<?php

namespace App\Exports;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, MapEmployeeApprover, UserPersonal, PublicHoliday};
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Auth;
class ReportExport implements FromCollection
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $user = User::where('id' , Auth::id())->first();
        $allLeaves = LeaveList::Where('approver_id', $user->username);

        $edata=array();
        foreach(explode(',', request()->get('exportdata')) as $data) { 
            array_push($edata,$data);
          //  $edata = $data;
         }
									
									
        			
        if(request()->get('exportdata') && request()->get('exportdata') != '')
        {
            $allLeaves->whereRaw('leave_list.id IN ("'.implode('","',$edata).'")');
        }
        if(request()->get('name') && request()->get('name') != '')
        {
            $emp = UserPersonal::where('name', 'like', '%'.request()->get('name').'%')
            ->pluck('username')->toArray();
            $allLeaves->whereIn('leave_list.username', $emp);
        }
        if(request()->get('ename') && request()->get('ename') != '')
        {
            $emp = UserPersonal::where('name', 'like', '%'.request()->get('ename').'%')
            ->pluck('username')->toArray();
            $allLeaves->whereIn('leave_list.username', $emp);
        }

        if(request()->get('status') && request()->get('status') != '')
        {
            $allLeaves->where('leave_list.status', request()->get('status'));
        }

        if(request()->get('type') && request()->get('type') != '')
        {
            $allLeaves->where('leave_list.type', request()->get('type'));
        }
        if(request()->get('phone') && request()->get('phone') != '')
        {
            $personals11 = DB::table('user_personal')->where('employee_no', request()->get('phone'))
                        ->pluck('username')->toArray();
            $allLeaves->whereIn('leave_list.username', $personals11);
        }
        $from = request()->get('from');
        $to = request()->get('to');
        if($from != '' && $to != ''){
            $allLeaves->whereBetween('leave_list.start_date', [$from, $to]);
        }
       elseif($from != '')
		{
			$allLeaves->where('leave_list.start_date', '=', $from);
		}

		elseif($to != '')
		{
			$allLeaves->where('leave_list.start_date', '=', $to);
		}
        
        $leaves = $allLeaves->get();
        $leaves->transform(function($request) {
            $userPersonal = UserPersonal::where('username', $request->username)->first();
            $emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';

            if($request->status == 0)
            {
                $status = 'Pending';
                $class= 'grey';
            }
            elseif($request->status == 1)
            {
                $status = 'Approved';
                $class= 'green';
            }
            elseif($request->status == 2)
            {
                $status = 'Rejected';
                $class= 'red';
            }
            elseif($request->status == 3)
            {
                $status = 'Recommended';
                $class= 'blue';
            }
            elseif($request->status == 4)
            {
                $status = 'Cancelled';
                $class= 'yellow';
            }
            elseif($request->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= 'orange';
            }
            $r_name = '';
            if($request->relieve != '')
            {
                $employee = UserPersonal::where('username', $request->relieve)->first();
                $r_name = $employee->name;
            }   
            if($request->type=='Line_Shut'){
                $iname='Out Of Office';
            }
            elseif($request->type=='Other_pay'){
                $iname='Replacement';
            }
            else{
                $iname=$request->type;
            } 
            $htype= '';
            if($request->half_day_type=='first'){
                $htype='AM';
            }
            if($request->half_day_type=='second'){
                $htype='PM';
            }
            return [
                'empNo' => $emp_no,
                'name'  => $emp_name,
                'relieve' => $r_name,
                'leaveType' => $iname,
                'leaveDate' => date('d-m-Y', strtotime($request->start_date)),
                'days' => $request->no_days.' '.$htype,
                'status' => $status,
                'reason' => $request->reason
            ];
        });

        return $leaves;
    }
}
