<?php

// Code within app\Helpers\Helper.php

namespace App\Helpers;

use App\Models\{
    UserPay,
    AllowanceDeduction,
    UserEpay,
    UserPersonal,
    Setting,
    User,
    Clockin

};
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class Helper {

     public static function settingInfo($field,$company_id = 1) {
        $res = '';
        $result =Setting::select("value")->where("field",$field)->where("company_id",$company_id)->first();       
        if (!empty($result->value)) {
            $res = $result->value;
        }
        return $res;
    }

    public static function sessionCheck() {
        $idletimeout = Setting::where('field', 'idletimeout_in_seconds')->first();
        $value = $idletimeout->value;
        if (time() - session()->get('sessiontime') > $value) {
            Auth::logout();
            return redirect(\URL::previous());
        } else {
            return session()->put('sessiontime', time());
        }
    }

    public static function getSoftwareStartDate() {
        $res = '';
        $result = Setting::select('value')->where("field", "software_start_year")->first();
        if (!empty($result)) {
            $res = $result->value;
        }
        return $res;
    }

    public static function getName($username) {
        $res = '';
        $result = UserPersonal::select("name")->where("username", $username)->first();
        if (!empty($result)) {
            $res = $result->name;
        }
        return $res;
    }

    public static function getUserEPFDetails($username) {
        $res = '';
        $result = DB::table('user_epf')->selectRaw("epf_no, epf_ic, tables, category, epf_yee_formula, epf_yer_formula")->where("username", $username)->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function getUserInsuranceDetails($username) {
        $res = '';
        $result = DB::table('user_insurance')->selectRaw("socso_no, tables, socso_ic, category, socso_initial")->where("username", $username)->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function getUserGovernmentDetails($username) {
        $res = '';
        $result = DB::table('user_government')->selectRaw("bank_code, branch_code, bank_ac_no, category, payment_mode")->where("username", $username)->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function getUserPersonalDetails($username) {
        $res = '';
        $result = UserPersonal::from('user_personal as up')
                ->leftJoin("rest_day_category_employee as rdce", "rdce.employee_id", "=", "up.username")
                ->leftJoin("rest_day_category as rdc", "rdc.id", "=", "rdce.category_id")
                ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no,up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra,up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted");
        if (!empty($username)) {
            $result = $result->where('username', $username);
        }
        $result = $result->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function getUserPayDetails($username) {
        $res = '';
        $result = UserPay::from('user_pay as a')
                ->leftJoin("branch as b", "a.branch_id", "=", "b.id")
                ->leftJoin("department as c", "a.department_id", "=", "c.id")
                ->leftJoin("category as  d", "a.category_id", "=", "d.id")
                ->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category,DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted,'%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned,DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method,a.pay_status, a.contract");
        if (!empty($username)) {
            $result = $result->where('a.username', $username);
        }
        $result = $result->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function getCompanyInfoByValue($column) {
        $res = '';
        $result = DB::table('details')->select("value as $column")->whereRaw("field='$column'")->first();
       
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function userEPayDetail($id) {
        $res = '';
        $result = UserEpay::selectRaw("user_epay.*,c.name,c.ic_no_new,c.designation,c.passport_no,cat.name as category,br.name as branch")
                        ->leftJoin("user_personal as c", "user_epay.employee_no", "=", "c.employee_no")
                        ->leftJoin("user_pay as up", "c.username", "=", "up.username")
                        ->leftJoin("category as  cat", "up.category_id", "=", "cat.id")
                        ->leftJoin("branch as br", "up.branch_id", "=", "br.id")
                        ->where('user_epay.id', $id)->first();
        if (!empty($result)) {
            $res = $result;
        }
        return $res;
    }

    public static function overtimeDetail() {
        $res = array();
        $result = AllowanceDeduction::whereRaw("field_name like '%overtime%'")->get();
        if (!empty($result)) {
            foreach ($result as $row) {
                $res[$row['field_name']] = $row['field_value'];
            }
        }
        return $res;
    }   
    
    public static function saveWebHookData($rr) {
        $data =  json_decode($rr->data);
        
           
        if (isset($data->event_log) && isset($data->event_log)!='') {
            $event_log = json_decode($data->event_log, true);
            if($event_log == null || !isset($event_log['dateTime']) ){
                return;                
            }
            
            date_default_timezone_set("Asia/Bangkok");
            $dateee=   date_create($event_log['dateTime']);
            $datetime =   date_format($dateee,'Y-m-d H:i:s');
            $date     = date_format($dateee,'Y-m-d');
            $time     = date_format($dateee,'H:i:s');
            $deviceName =  $event_log['AccessControllerEvent']['deviceName'];
            $serialNo =  $event_log['AccessControllerEvent']['serialNo'];
            if (array_key_exists('employeeNoString', $event_log['AccessControllerEvent'])) {
                $employeeNoString = $event_log['AccessControllerEvent']['employeeNoString'];
               
               
            } else {
                return false;
                $employeeNoString = "0";
            }

            if (array_key_exists('name', $event_log['AccessControllerEvent'])) {
                $name = $event_log['AccessControllerEvent']['name'];
            } else {
                $name = "";
            }

            if (array_key_exists('cardReaderNo', $event_log['AccessControllerEvent'])) {
                $cardReaderNo = $event_log['AccessControllerEvent']['cardReaderNo'];
            } else {
                $cardReaderNo = "0";
            }

           
                $device_serialNo = "0";
           

            Clockin::insert(array(

                'employee_no'     => $employeeNoString,
                'datetime'        => $datetime,
                'date'            => $date,
                'time'            => $time,
                'direction'       => "IN",
                'devicename'      =>  $deviceName,
                'serialNumber'    => $device_serialNo,
                'serialNo'        =>  $serialNo,
                'personname'      =>  $name,
                'cardno'          =>  $cardReaderNo,
                'working_day'     =>  $date,

            ));
        }
        return true;
    }   



}
