<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, MessagesSent, Message,
    Branch, Department, Category, PublicHoliday};
use Auth , DateTime;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Carbon\CarbonInterval;
use Carbon\CarbonPeriod;

class ApprovalDashboardController extends Controller
{


    public function index(Request $request)
    {
        
		$year = $request->get('year') ?? '2021';
        $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $user = User::where('id' , Auth::id())->first();
        $leaves = Leavelist::selectRaw("leave_list.*, leave_name.name as typename")->where('approver_id', $user->username)->leftjoin('leave_name', 'leave_name.type','=','leave_list.type')->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('start_date', '<=', $endOfYear->format('Y-m-d'))->get();
        $leaveTypes  = Leavetype::where('is_show',1)->get();
        
        $approvedLeaves11 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                        ->leftjoin('category as cat','d.category_id','=','cat.id')
                        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                        ->leftjoin('department as e','d.department_id','=','e.id')
                        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
                        ->where('app_lv.approver_id',$user->username)->where('leave_days.status',1)
                        ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name");
        $approvedLeaves12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->where('b.approver_id',$user->username)->where('leave_days.status',1)
                ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name")
                ->union($approvedLeaves11)->orderByRaw('(CASE WHEN status = 0 THEN 0 ELSE 1 END), date  DESC');
        $approvedLeaves = $approvedLeaves12->count();
        
        $pendingLeaves11 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                        ->leftjoin('category as cat','d.category_id','=','cat.id')
                        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                        ->leftjoin('department as e','d.department_id','=','e.id')
                        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
                        ->where('app_lv.approver_id',$user->username)->where('leave_days.status',0)
                        ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name");
        $pendingLeaves12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->where('b.approver_id',$user->username)->where('leave_days.status',0)
                ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name")
                ->union($pendingLeaves11)->orderByRaw('(CASE WHEN status = 0 THEN 0 ELSE 1 END), date  DESC');
        $pendingLeaves = $pendingLeaves12->count();
        
        $rejectLeaves11 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                        ->leftjoin('category as cat','d.category_id','=','cat.id')
                        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                        ->leftjoin('department as e','d.department_id','=','e.id')
                        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
                        ->where('app_lv.approver_id',$user->username)->where('leave_days.status',2)
                        ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name");
        $rejectLeaves12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->where('b.approver_id',$user->username)->where('leave_days.status',2)
                ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name")
                ->union($rejectLeaves11)->orderByRaw('(CASE WHEN status = 0 THEN 0 ELSE 1 END), date  DESC');
        $rejectLeaves = $rejectLeaves12->count();
        $user = User::where('id' , Auth::id())->first();
        
        $cpending11 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                        ->leftjoin('category as cat','d.category_id','=','cat.id')
                        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                        ->leftjoin('department as e','d.department_id','=','e.id')
                        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
                        ->where('app_lv.approver_id',$user->username)->where('leave_days.status',5)
                        ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name");
        $cpending12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->where('b.approver_id',$user->username)->where('leave_days.status',5)
                ->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name")
                ->union($cpending11)->orderByRaw('(CASE WHEN status = 0 THEN 0 ELSE 1 END), date  DESC');
        $cancellationpendingLeaves = $cpending12->count();
                
        $percentage = [];
        $lables = ['Medical', 'Annual', 'Marriage', 'Others'];
        $medical =  $leaves->where('type', 'Medical')->count();
        $annual =  $leaves->where('type', 'Annual')->count();
        $marriage =  $leaves->where('type', 'Marriage')->count();
        $other =  $leaves->whereNotIn('type',['Marriage', 'Annual', 'Medical'])->count();
        $total = $medical + $annual + $marriage + $other;

        $medicalPercentage = $total > 0 ? ($medical/$total) * 100 : 0;
        $annualPercentage = $total > 0 ? ($annual/$total) * 100 : 0;
        $marriagePercentage = $total > 0 ? ($marriage/$total) * 100 : 0;
        $otherPercentage = $total > 0 ? ($other/$total) * 100 : 0;

        array_push($percentage, round($medicalPercentage,2));
        array_push($percentage, round($annualPercentage,2));
        array_push($percentage, round($marriagePercentage,2));
        array_push($percentage, round($otherPercentage,2));

        $months = [];
		$noOfLeave = [];

		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();
            $no = Leavelist::where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->where('status', '1')->count();
            array_push($noOfLeave, $no);
        }

        $allHolodays = PublicHoliday::where('company_id', $user->company_id)->whereBetween('date', [$startOfYear->format('Y-m-d'),$endOfYear->format('Y-m-d')])->get();
        $allHolodays = $allHolodays->transform(function($item) {
			$item->month = date("F", strtotime($item->date));
			$item->day = date("j", strtotime($item->date));

			return [
                'status' => '#0096FF',
				'date' => $item->date,
				'month' => $item->month,
				'day' => $item->day,
			];
		});
        $arrayOne = [];
		$arrayTwo = [];
		$arrayThree = [];
		$arrayFour = [];
		$arrayFive = [];
		$arraySix = [];
		$arraySeven = [];
		$arrayEight = [];
		$arrayNine = [];
		$arrayTen = [];
		$arrayEleven = [];
		$arrayTweal = [];

		foreach($allHolodays as $leaveVal)
		{
			if($leaveVal['month'] == "January")
			{
				$arrayOne[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "February")
			{
				$arrayTwo[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "March")
			{
				$arrayThree[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "April")
			{
				$arrayFour[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "May")
			{
				$arrayFive[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "June")
			{
				$arraySix[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "July")
			{
				$arraySeven[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "August")
			{
				$arrayEight[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "September")
			{
				$arrayNine[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "October")
			{
				$arrayTweal[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "November")
			{
				$arrayTen[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "December")
			{
				$arrayTweal[$leaveVal['day']] = $leaveVal['status'];
			}


		}
		for($i=1; $i <=31 ; $i++)
		{
			if(!isset($arrayOne[$i]))
			{
				$arrayOne[$i] = '#F8F9F9';
			}
			if(!isset($arrayTwo[$i]))
			{
				$arrayTwo[$i] = '#F8F9F9';
			}
			if(!isset($arrayThree[$i]))
			{
				$arrayThree[$i] = '#F8F9F9';
			}
			if(!isset($arrayFour[$i]))
			{
				$arrayFour[$i] = '#F8F9F9';
			}
			if(!isset($arrayFive[$i]))
			{
				$arrayFive[$i] = '#F8F9F9';
			}
			if(!isset($arraySix[$i]))
			{
				$arraySix[$i] = '#F8F9F9';
			}
			if(!isset($arraySeven[$i]))
			{
				$arraySeven[$i] = '#F8F9F9';
			}
			if(!isset($arrayEight[$i]))
			{
				$arrayEight[$i] = '#F8F9F9';
			}
			if(!isset($arrayNine[$i]))
			{
				$arrayNine[$i] = '#F8F9F9';
			}
			if(!isset($arrayTen[$i]))
			{
				$arrayTen[$i] = '#F8F9F9';
			}
			if(!isset($arrayEleven[$i]))
			{
				$arrayEleven[$i] = '#F8F9F9';
			}
			if(!isset($arrayTweal[$i]))
			{
				$arrayTweal[$i] = '#F8F9F9';
			}
		}
		ksort($arrayOne);
		ksort($arrayTwo);
		ksort($arrayThree);
		ksort($arrayFour);
		ksort($arrayFive);
		ksort($arraySix);
		ksort($arraySeven);
		ksort($arrayEight);
		ksort($arrayNine);
		ksort($arrayTen);
		ksort($arrayEleven);
		ksort($arrayTweal);

        $messages = Message::where('recipient', $user->username)->where('expiry_date', '>' , date('Y-m-d'))->get()->take(7);

        if(isset($_GET['type']) || isset($_GET['status'])  ){
            if(isset($_GET['type']))
            {
                $recentLeaves = Leavelist::where('approver_id', $user->username)->where([['start_date', '>' , date('Y-m-d')],['type', $_GET['type']]])->get()->take(10);

                $dataa['data'] = html_entity_decode(view('E-Leave.partials.leavetype', compact('recentLeaves')));
                return response()->json($dataa, 200);

            }

            else
            {
                $recentLeaves = Leavelist::where('approver_id', $user->username)->where([['start_date', '>' , date('Y-m-d')],['status', $_GET['status']]])->get()->take(10);

                $dataa['data'] = html_entity_decode(view('E-Leave.partials.leavetype', compact('recentLeaves')));
                return response()->json($dataa, 200);
            }
        }

        else{
            $recentLeaves = Leavelist::where('approver_id', $user->username)->where('start_date', '>' , date('Y-m-d'))->take(10)->get();
        }

       $branches = Branch::where('company_id', $user->company_id)->orderBy('name','ASC')->get();
	   $departments = Department::where('company_id', $user->company_id)->orderBy('name','ASC')->get();
	   $categories = Category::where('company_id', $user->company_id)->orderBy('name','ASC')->get();
	   $approval_viewStatus = $this->getPermissionValue("approval_view_all",$user->username);
	   $ActiveUserShownStatus11 = DB::table('settings')->where('field',"active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
	
	   $leavesArray = Leavelist::selectRaw("leave_list.*, leave_name.name as typename, leave_list.start_time, leave_list.end_time")->leftjoin('user_pay','user_pay.username','=','leave_list.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('leave_name', 'leave_name.type','=','leave_list.type')->orderBy('date_applied' , 'DESC')->where('status', '1');
	   if($approval_viewStatus==1){
	       $leavesArray->where('leave_list.username',$user->username);
			
		}elseif($approval_viewStatus==2){
			$logged_userGroups = getUserGroups($user->username);
			$leavesArray->where('user_pay.branch_id',$logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id',$logged_userGroups->department_id);
		
		}elseif($approval_viewStatus==3){
			$logged_userGroups = getUserGroups($user->username);
		//	dd($logged_userGroups->branch_id);
			$leavesArray->where('user_pay.branch_id',$logged_userGroups->branch_id);
		}elseif($approval_viewStatus==4){
			$userbranchId = getUserBranchId($user->username);
	        	$state_nm = getstatebybranch($userbranchId);
			$leavesArray->where('branch.state',$state_nm);
		
		}elseif($approval_viewStatus==6){
			$user = User::where('id', Auth::id())->first();
			$leavesArray->where('leave_list.approver_id',$user->username);
		}
		// list for own subordinate 6
		
		 if($ActiveUserShownStatus==1){
            $leavesArray->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
        }
        else{
            $leavesArray->where('user_pay.pay_status','1');
        }
        $premonth=date('m')-1;
	    $nextmonth=date('m')+1;
	   if($premonth<=1){
	        $year=date('Y')-1;
	       $startDate112=$year.'-12-01';
	   }
	   else{
	      $startDate112=date('Y').'-'.$premonth.'-01';
	   }
	    if($nextmonth>=12){
	        $year=date('Y')+1;
	        $endDate112=$year.'-01-31';
	    }else{
	        $endDate112=date('Y').'-'.$nextmonth.'-31';
	    }
	   
	   $leavesArray= $leavesArray->whereBetween('leave_list.start_date', [$startDate112, $endDate112])->get();
	   
	   $leavesArray->transform(function ($item) {
			if($item->getType != null){
			   $item->background_color = $item->getType->leave_color;   
		   }else{ 
			   $item->background_color = "#4298a1";
		   }
		  if($item->half_day_type=='first'){
			   $htype='AM';
		   }
		   elseif($item->half_day_type=='second'){
			   $htype='PM';
		   }
		   else{
			   $htype='';
		   }
		   if($item->type=='Line_Shut'){
			   $iname='Out Of Office';
			   $colornm='';
			}
		   elseif($item->type=='Other_pay'){
			   $iname='Replacement';
			   $colornm='#000000';
		   }
		   else{
			   $iname=$item->type;
			   $colornm=$item->background_color;
		   }
		   
		   
		   $employee = DB::table('user_personal')
			   ->where('username', $item->username)->first();
			   if($employee!=''){
                 $r_name = $employee->name;   
                }
                
                else{
                    $r_name = '';
                }
            if($item->is_hourly!=0){ 
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->start_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
		   
		   return [
		       'id' => date('m', strtotime($item->start_date)),
			    'title' => $r_name.' ('.$item->typename.')'.$htype.' '.$time,
		        'text_color' => '#fff',
			   'start' => date('Y-m-d', strtotime($item->start_date)),
			   'type' => $item->type,
			   'color' =>  $colornm,
			   
		   ];

	   })->toArray();
	   
	   $leavesPastArray = DB::table('leave_past')->selectRaw("leave_past.*, leave_name.name as typename, leave_name.leave_color")->leftjoin('user_pay','user_pay.username','=','leave_past.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('leave_name', 'leave_name.type','=','leave_past.type')->where('status', '1');
	   if($approval_viewStatus==1){
	       $leavesPastArray->where('leave_past.username',$user->username);
			
		}elseif($approval_viewStatus==2){
			$logged_userGroups = getUserGroups($user->username);
			$leavesPastArray->where('user_pay.branch_id',$logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id',$logged_userGroups->department_id);
		
		}elseif($approval_viewStatus==3){
			$logged_userGroups = getUserGroups($user->username);
			$leavesPastArray->where('user_pay.branch_id',$logged_userGroups->branch_id);
		}elseif($approval_viewStatus==4){
			$userbranchId = getUserBranchId($user->username);
	        	$state_nm = getstatebybranch($userbranchId);
			$leavesPastArray->where('branch.state',$state_nm);
		
		}
		if($ActiveUserShownStatus==1){
            $leavesPastArray->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
        }
        else{
            $leavesPastArray->where('user_pay.pay_status','1');
        }
            $premonth=date('m')-1;
		    $nextmonth=date('m')+1;
		    if($premonth<=1){
		        $year=date('Y')-1;
		       $startDate112=$year.'-12-01';
		   }
		   else{
		      $startDate112=date('Y').'-'.$premonth.'-01';
		   }
		    if($nextmonth>=12){
		        $year=date('Y')+1;
		        $endDate112=$year.'-01-31';
		    }else{
		        $endDate112=date('Y').'-'.$nextmonth.'-31';
		    }
	   $leavesPastArray= $leavesPastArray->whereBetween('leave_past.start_date', [$startDate112, $endDate112])->get();
	   
	   $leavesPastArray->transform(function ($item) {
			if($item->leave_color != null){
			   $item->background_color = $item->leave_color;   
		   }else{ 
			   $item->background_color = "#4298a1";
		   }
		  if($item->half_day_type=='first'){
			   $htype='AM';
		   }
		   elseif($item->half_day_type=='second'){
			   $htype='PM';
		   }
		   else{
			   $htype='';
		   }
		   if($item->type=='Line_Shut'){
			   $iname='Out Of Office';
			   $colornm='';
			}
		   elseif($item->type=='Other_pay'){
			   $iname='Replacement';
			   $colornm='#000000';
		   }
		   else{
			   $iname=$item->type;
			   $colornm=$item->background_color;
		   }
		   
		   
		   $employee = DB::table('user_personal')
			   ->where('username', $item->username)->first();
			   if($employee!=''){
                 $r_name = $employee->name;   
                }
                
                else{
                    $r_name = '';
                }
		   
		   return [
		        'id' => date('m', strtotime($item->start_date)),
			    'title' => $r_name.' ('.$item->typename.')'.$htype,
		        'text_color' => '#fff',
			   'start' => date('Y-m-d', strtotime($item->start_date)),
			   'type' => $item->type,
			   'color' =>  $colornm,
			   
		   ];

	   })->toArray();
	   
	   $rest_day_type = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->get();
	   $rest_day_id=0;
	   if(!$rest_day_type->isEmpty()){
	       $rest_day_id=$rest_day_type['0']->category_id;
	        $rest_day_cat = DB::table('rest_day_category')->where('id', $rest_day_id)->get();
	   }
	   
	   $rest_cat_name = array();
	   if($rest_day_id!=0){
	        foreach(explode('-', $rest_day_cat['0']->category) as $cat) { 
		        $rest_cat_name11 = substr($cat,0 ,3); 
		        array_push($rest_cat_name,$rest_cat_name11);
	        }
	   }
	   $restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->whereRaw('DATE_FORMAT(STR_TO_DATE(date, "%Y-%m-%d"),"%a") IN ("'.implode('","',$rest_cat_name).'")')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
					   
	   $restDay->transform( function($item) {

		   return [
                'id' => date('m', strtotime($item->date)),
			   'title' => 'Rest Day',
			   'type' => '',
			   'start' => date('Y-m-d', strtotime($item->date)),
			   'text_color' => '#000',
			   'color' =>  '#e0e0e0',
		   ];
	   })->toArray();
	   $user = User::where('id' , Auth::id())->first();
	   $userPay = DB::table('user_pay')->where('username', $user->username)->first();
	   $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
	   if($branchData != null){
		   $userState = $branchData->state;
	   }else{
		   $userState = "zzzzzzz";
	   }
	   $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date','ASC')->where('company_id', $user->company_id)
	   ->whereYear('date', '=', date('Y'))->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "'.$userState.'")')->groupBy('date_holiday')->get();
			   
				   $recentHoliday->transform( function($item11) {

					   return [
		                    'id' => date('m', strtotime($item11->date)),
						   'title' => $item11->description,
						   'type' => '',
						   'start' => date('Y-m-d', strtotime($item11->date)),
						   'text_color' => '#fff',
						   'color' =>  '#28c76f',
					   ];
				   })->toArray();
	    $leaves1123 = $restDay->merge($leavesArray);		   
	   $leaves11 = $leaves1123->merge($leavesPastArray);
	   $leaves = $leaves11->merge($recentHoliday);
	  $relieveallow=DB::table('settings')->where('field','leave_relieve_allow')->where('company_id',$user->company_id)->first();
		$halfdayallow=DB::table('settings')->where('field','halfdayleave')->where('company_id',$user->company_id)->first();
		$replacement =getRLeaveList($user->username);
		
		$c_key = 'leave_staff_dashboard';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }
        
 
        
		//dd($replacement);
        return view('approvals.dashboard', [
            'approvedLeaves' => $approvedLeaves, 'pendingLeaves' => $pendingLeaves, 'rejectLeaves' => $rejectLeaves, 'cancellationpendingLeaves' => $cancellationpendingLeaves,
            'percentage' => json_encode($percentage,JSON_NUMERIC_CHECK),
		    'lables' => json_encode($lables,JSON_NUMERIC_CHECK),
            'month' => json_encode($months,JSON_NUMERIC_CHECK),
		    'noOfLeave' => json_encode($noOfLeave,JSON_NUMERIC_CHECK), 'messages' => $messages, 'recentLeaves' => $recentLeaves,
            'arrayOne' => $arrayOne, 'arrayTwo' => $arrayTwo, 'arrayThree' => $arrayThree, 'arrayFour' => $arrayFour,
            'arrayFive' => $arrayFive, 'arraySix' => $arraySix, 'arraySeven' => $arraySeven, 'arrayEight' => $arrayEight,
			'arrayNine' => $arrayNine, 'arrayTen' => $arrayTen, 'arrayEleven' => $arrayEleven, 'arrayTweal' => $arrayTweal, 'leaveTypes' => $leaveTypes,
			'leaves' =>$leaves, 'branches' =>$branches, 'departments' =>$departments, 'categories'=>$categories,'relieveallow'=>$relieveallow,'halfdayallow'=>$halfdayallow,'replacement'=>$replacement, 'columnHideShowData'=>$columnHideShowData, 'c_key'=>$c_key
        ]);

	}
	
	public function getPermissionValue($group, $username)
	{
		$query = "select b.$group as val from map_employee_permission a left join permission_group b ";
		$query .= "on a.permission_group_id=b.id where a.employee_id='$username'";
		$builder = DB::select($query);
		$result = intval($builder[0]->val);
		return $result;
    }
	
	public function getapproverstaffLeave(Request $request)
    {
        $user = User::where('id' , Auth::id())->first();
		$requestArray = Leavelist::leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')
		->leftJoin('user_personal', 'leave_list.relieve', '=', 'user_personal.username')
		->leftJoin('user_pay', 'leave_list.username', '=', 'user_pay.username')
		->leftJoin('branch', 'user_pay.branch_id', '=', 'branch.id')
		->leftJoin('department', 'user_pay.department_id', '=', 'department.id')
		->leftjoin('leave_name', 'leave_name.type','=','leave_list.type')
		->selectRaw("leave_list.*,leave_name.name as typename,leave_days.id as lid,leave_days.leave_id,leave_days.date,leave_days.cancellation_reason,leave_days.reject_reason,user_pay.category_id,user_pay.department_id,user_pay.branch_id,department.name as dname,CASE leave_list.is_hourly WHEN 1 THEN ((leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours")
		->where('leave_list.approver_id',$user->username)
		->whereRaw("(leave_days.status='0' or leave_days.status='5' or leave_days.status='3')");
		
		if($request->get('branch') != null){
				$requestArray->where('user_pay.branch_id', $request->get('branch'));
			}
			if($request->get('category') != null){
				$requestArray->where('user_pay.category_id', $request->get('category'));
			}
			if($request->get('dept') != null){
				$requestArray->where('user_pay.department_id', $request->get('dept'));
			}
			if($request->get('sdate') != null){
				$requestArray->where('leave_list.start_date', $request->get('sdate'));
			}
		
        //$requests = $requestArray->get();
        $requests = $requestArray->orderby('leave_list.id','asc')->get();
        $requests->map(function($item) {
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $r_name = '';
            if($item->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $item->relieve)->first();
                $r_name = $employee->name;
            }
            if($item->type=='Other_pay'){
                $type='Replacement';
            }
            elseif($item->type=='Line_Shut'){
                $type='Out Of Office';
            }
            else{
                $type=$item->type;
            }
            if($item->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($item->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($item->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($item->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($item->status == 4)
            {
                $status = 'Cancelled';
                $class= 'yellow';
            }
            elseif($item->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			elseif($item->half_day_type=='second'){
				$htype='PM';
			}
			else{
				$htype='';
			}
			if($item->approver_id != Auth::user()->username){
				$dradio ='disabled';
			  }
			else{
				  $dradio='';
			}
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->r_name = $r_name;
            $item->leave_type  = $item->typename;
            $item->half_day_type  = $htype;
            $item->dradio  = $dradio;
            return $item;
		});
       return DataTables::of($requests)->make(true);
    }

    public function getMessage()
    {
        $user = User::where('id' , Auth::id())->first();
        $branches = Branch::where('company_id', $user->company_id)->get();
        $departments = Department::where('company_id', $user->company_id)->get();
        $categories = Category::where('company_id', $user->company_id)->get();

        $users = User::where('users.company_id', $user->company_id)->leftjoin('user_personal','users.username','=','user_personal.username')->orderBy('user_personal.name','asc')->get();
        $users->transform(function($item){
           // $item->name =  $item->name ?? '';

            return [
                'username' => $item->username,
                'name' => $item->name ?? ''
            ];
        });
        return view('approvals.message', [
            'branches' => $branches, 'departments' => $departments, 'categories' => $categories,
            'users' => $users
        ]);
    }

    public function storeMessage(Request $request)
    {
		$receiver=$request->receiver;
		$rv = implode(",", $receiver);
		
        $this->validate($request,[
            "receiver"=>"required",
    		"expiry_date"=>"required|date",
    		"message"=>"required",
    	]
        );
		$user = User::where('id' , Auth::id())->first();
	
		foreach($receiver as  $value){
			Message::create([
				'sender' => $user->username,
				'recipient' => $value,
				'message' => $request->message,
				'expiry_date' => $request->expiry_date
			]);
		}
		
        
        MessagesSent::create([
            'sender' => $user->username,
            'recipients' => $rv,
            'message' => $request->message
        ]);

        return redirect()->back()->with('statusMsg', 'Successfully Created');
    }
}
