<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;
use App\Models\Device;
use App\Models\User;
use App\Models\UserPay;
use Yajra\DataTables\DataTables;
class DeviceController extends Controller
{
     

    public function devices()
    {
      
        return view('E-Attendance.device.add_devices');

    }

    public function addDevices(Request $request)
    {
    
      
     $validation =   $request->validate([
        'devicename'   => 'required',
        'serial_no'    => 'required',
        'location'     =>'required',
        'mac_address'  => 'required',
        'start_date'   =>'required',
        'activation'   => 'required',
        'remark'       => 'required',
       ], [
            'devicename.required' => 'Device Name is required',
            'serial_no.required' => 'Serial No. is required',
            'location.required' => 'Location Name is required',
            'mac_address.required' => 'Mac Address is required',
            'start_date.required' => 'Start date Name is required',
            'activation.required' => 'Activation No. is required',
            'remark.required'       => 'Remark is required',
        ]);
    
        $deviceName    = $request->devicename;
        $serialNo      = $request->serial_no;
        $location      =  $request->location;
        $macAddress    = $request->mac_address;
        $startDate     = $request->start_date;
        $activation    =  $request->activation;
        $remark        =  $request->remark;
        $data = ([

            'devicename'   =>  $deviceName,
            'serial_no'    =>  $serialNo,
            'location'     =>  $location,
            'mac_address'  =>  $macAddress,
            'start_date'   =>  $startDate,
            'activation'   =>  $activation,
            'remark'       => $remark,
        ]);

        $insert = Device::insert($data);
        return response()->json(['success' => 'Devices added successfully']);
      
    }

    public function viewDevice()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('E-Attendance.device.device-list', compact('userPay', 'user'));
    }

    public function getDevicedata(Request $request)
    {
        
       $devicedata =  Device::latest('id')->get();


        $devicedata->map(function ($item, $index) {

            $index++;
            $item->index = $index;
            $item->id;
            $item->devicename;
            $item->location;
            $item->start_date = date("d-m-Y", strtotime($item->start_date));
            $item->serial_no;

            return $item;
        });

        return DataTables::of($devicedata)->make(true);
    }

    public function editdevice()
    {
     
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        if (isset($_REQUEST['id'])) {

            $devicedata = Device::where('id', $_REQUEST['id'])->get();
             return view('E-Attendance.device.edit_devices', compact('userPay', 'user','devicedata'));
        }
 
    }

    public function updateDevice(Request $request)
    {
        
      $id = $request->device_id;
     
       $request->validate([
        'devicename'   => 'required',
        'serial_no'    => 'required',
        'location'     =>'required',
        'mac_address'  => 'required',
        'start_date'   =>'required',
        'activation'   => 'required',
        'remark'       => 'required',
       ], [
            'devicename.required'  => 'Device Name is required',
            'serial_no.required'   => 'Serial No. is required',
            'location.required'    => 'Location Name is required',
            'mac_address.required' => 'Mac Address No. is required',
            'start_date.required'  => 'Start date Name is required',
            'activation.required'  => 'Activation No. is required',
            'remark.required'      => 'Remark is required',
        ]);
      
        $deviceName    = $request->devicename;
        $serialNo      = $request->serial_no;
        $location      = $request->location;
        $macAddress    = $request->mac_address;
        $startDate     = $request->start_date;
        $activation    =  $request->activation;
        $remark        =  $request->remark;
        $data = ([

            'devicename'   =>  $deviceName,
            'serial_no'    =>  $serialNo,
            'location'     =>  $location,
            'mac_address'  =>  $macAddress,
            'start_date'   =>  $startDate,
            'activation'   =>  $activation,
            'remark'       =>  $remark ,
        ]);
       
        // $update = DB::table('devices')->where('id', $id)->update($data);
        $update = Device::where('id', $id)->update($data);
        return response()->json(['success' => 'Device updated successfully']);

    }

    public function deletedevice(Request $request)
    {
        $deviceId = $request->id;
        $delete = Device::where('id', $deviceId)->delete();
        return response()->json(['success' => 'Device deleted successfully']);
    }
}
