<?php

namespace App\Http\Controllers;

use App\Models\DutyRoster;
use Illuminate\Support\Facades\DB;
use App\Models\PublicHoliday;
use App\Models\User;
use App\Models\UserPay;
use App\Models\State;
use App\Models\Setting;
use App\Models\DutyRoaster;
use App\Models\DutyRosterDates;
use App\Models\UserPersonal;
use Auth;  
use Illuminate\Http\Request;

use Yajra\DataTables\DataTables;


class DutyroasterController extends Controller
{
    public function dutyRoaster()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        $schedule = DB::table('schedule')->select('id', 'name')->get();
        $leave_type = DB::table('leave_name')->select('id', 'type')->get();
        $public_holiday = DB::table('public_holiday')->select('id', 'description')->limit(10)->get();

        $restday = DB::table('rest_day_category')->select('id', 'category')->get();
        return view('E-Attendance.dutyRoaster.duty-roster', compact('userPay', 'schedule', 'leave_type', 'public_holiday', 'restday'));

    }

    public function createDutyroaster(Request $request)
    {
       $duty_roaster = new DutyRoster;
        $request->validate([
            'group_id' => 'required',
            'name' => 'required',
        ], [
            'group_id.required' => 'GROUP ID is required',
            'name.required' => 'Name is required',

        ]);

        $group_id = $request->group_id;
        $name = $request->name;

        $data = [
            'group_id' => $group_id,
            'name' => $name,
        ];
        $id =  $duty_roaster->insertGetId($data);   
        return redirect()->route('update-duty_roaster',['id'=>$id])->with(['success' => 'Duty Roaster created successfully']);  
    
    }

    public function viewdutyRoaster()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
       
        return view('E-Attendance.dutyRoaster.view_duty-roaster', compact('userPay','user'));

    }
    
    public function dutyRoasterdata(Request $request)
    { 
        
         $dutyRoasterdata = DB::table('duty_roaster')
            ->leftjoin('user_personal', 'duty_roaster.id', '=','user_personal.duty_roaster_id')
            ->select('duty_roaster.name','duty_roaster.group_id', 'duty_roaster.id','user_personal.duty_roaster_id')  
            ->latest('id')  
            ->groupBy('duty_roaster.id')
            ->get();    
            
            $dutyRoasterdata->map(function ($item, $index) {

                $index++;
                $item->index = $index;
    
                return $item;
            });
            
           return DataTables::of($dutyRoasterdata)->make(true);
    }
   
    public function removeDutyRoaster(Request $request)
    {
        $dutyRoaster_id = $request->id;
      
         $user_personal = DB::table('user_personal')->select('duty_roaster_id')->where('duty_roaster_id',$dutyRoaster_id)->first();

        if(empty($user_personal) || (isset($user_personal) && ($user_personal->duty_roaster_id != $dutyRoaster_id  )))
        {         
          $delete = DB::table('duty_roaster')->where('id',$dutyRoaster_id)->delete();
          return response()->json(['success' => 'Duty Roaster deleted successfully']);
        }       
       
    }
    public function updateDutyRoaster()
    {    
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        if (isset($_REQUEST['id'])) {
        
            $dutyRoasterdata = DutyRoster::where('id', $_REQUEST['id'])->get();
            // echo"<pre>";print_r( $dutyRoasterdata);die();
        }
        $schedule = DB::table('schedule')->select('id', 'name', 'color')->get();

        $state = State::select('state', 'id')->get();

        $restday = DB::table('rest_day_category')->select('id', 'category')->get();

        return view('E-Attendance.dutyRoaster.edit_duty-roaster', compact('dutyRoasterdata', 'user', 'userPay', 'schedule', 'state', 'restday'));
    }
    
    public function editdutyRoaster(Request $request)
    {
        $data = json_decode($request->input('data'));
        $year = $request->year;
        $duty_roaster_id = $request->duty_roaster_id;
        foreach ($data as $value) {
            $dates = date("Y-m-d", strtotime($value->date));
            $day_type = $value->day_type;
           
            $dutyRoasters = [
                'duty_roaster_id' => $duty_roaster_id,
                'date' => $dates,
                'day_type' => $value->day_type,
            ];
            if ($value->selected == "false") {
                $dutyRoaster = DB::table('duty_roaster_dates')->where('date', $dates)
                    ->whereYear('date', $year)
                    ->where('duty_roaster_id', $duty_roaster_id)->delete();
            } elseif ($day_type == "SCHEDULE" && $value->selected == "true") {
                $dutyRoasters['schedule_id'] = $value->type_id;
            } elseif ($day_type == "RESTDAY" && $value->selected == "true") {
                $dutyRoasters['schedule_id'] = null;
            } elseif ($day_type == "HOLIDAY" && $value->selected == "true") {
                $dutyRoasters['holiday_id'] = $value->type_id;
            }
            $data = DB::table('duty_roaster_dates')->where('duty_roaster_id', $duty_roaster_id)
                ->where('date', $dates)
                ->first();
            if (isset($data)) {
                DB::table('duty_roaster_dates')->where('duty_roaster_id', $duty_roaster_id)
                    ->where('date', $dates)
                    ->whereYear('date', $year)
                    ->update($dutyRoasters);
            } else {

               if($value->selected != "false"){
                    $insert = DB::table('duty_roaster_dates')->insert($dutyRoasters);
                }
            }

            $response = DB::table('duty_roaster_dates')
                ->whereYear('date', $year)
                ->where('duty_roaster_id', $duty_roaster_id)->get();
        }

        echo json_encode($response);

    }
    
        // duty roaster data update
    public function updateDutyRoasterData(Request $request){
        $dutyRoasterdata = DutyRoster::find($request->duty_roaster_id);
        $dutyRoasterdata->group_id = $request->group_id;
        $dutyRoasterdata->name = $request->name;
        $dutyRoasterdata->save();
        return redirect()->back();
    }
    
    
    public function deleteRoaster(Request $request)
    {
        $duty_roaster_id = $request->duty_roaster_id;
        $res = DB::table('duty_roaster_dates')->where('duty_roaster_id', $duty_roaster_id)->delete();
        if($res){
            return 1;
        }else{
            return 0;
        }
    }
    
    public function dutyroasterdataLoad(Request $request)
    {
        $id = $request->duty_roaster_id;
        $year = $request->year;
        $results = DB::table('duty_roaster_dates')->select(['duty_roaster_dates.*', 'schedule.color'])
        ->leftJoin('schedule', 'duty_roaster_dates.schedule_id', '=', 'schedule.id')
        ->where('duty_roaster_id', $id)
        ->whereYear('date',$year)
        ->get();
        return response()->json($results);
    }
    public function getYearlyDutyRoaster(Request $request)
    {
        $year = $request->year; 
        $id = $request->id;     
        $duty_roaster = DB::table('duty_roaster_dates')->select(['duty_roaster_dates.*', 'schedule.color'])
        ->leftJoin('schedule', 'duty_roaster_dates.schedule_id', '=', 'schedule.id')
        ->where('duty_roaster_id', $id)
        ->whereYear('date', $year)
        ->get();
         echo json_encode($duty_roaster);
    }
    public function getHoliday(Request $request)
    {
        $year = $request->year;
        $state = $request->states;
    
        $holiday = DB::table('public_holiday')->select('id', 'date')
            ->whereYear('date', $year);
            if($request->states != "All"){
                $holiday->WhereIn('state', ['National', 'national', 'NATIONAL', $state]);
            }
            $res = $holiday->get();
 
        echo json_encode($res);
    }


     public function empDutyroaster()
    {
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        $dutyraoster = DutyRoster::select('name', 'id')->get();

        $dutyroasterData = UserPersonal::select('user_personal.name as name', 'user_personal.username', 'duty_roaster.name as sname')
            ->leftJoin('duty_roaster', 'user_personal.duty_roaster_id', '=', 'duty_roaster.id')->whereNull('user_personal.duty_roaster_id')->get();
           
        return view('E-Attendance.dutyRoaster.dutyroaster_to_emp', compact('dutyroasterData','dutyraoster'));
    }
    
    function getDutyRoasterType(Request $request)
    {
         $duty_roaster = DutyRoster::get();
         return $duty_roaster
         ;     
    }
  
      public function employeedutyroasterData(Request $request)
    {
        

        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();

        $dutyroasterData = UserPersonal::select('user_personal.name as name','user_personal.username', 'duty_roaster.name as sname','user_personal.duty_roaster_id')->leftJoin('duty_roaster', 'duty_roaster.id', '=', 'user_personal.duty_roaster_id')->leftjoin('user_pay', 'user_personal.username', '=', 'user_pay.username');

        if ($request->dutyroaster_id != 'not_assign_duty_Roaster' && $request->dutyroaster_id && $request->dutyroaster_id != 'null' && $request->dutyroaster_id != null){
            $dutyroasterData = $dutyroasterData->where('user_personal.duty_roaster_id', $request->dutyroaster_id);
        }else if(($request->dutyroaster_id == 'not_assign_duty_Roaster' && $request->dutyroaster_id != 'null' && $request->dutyroaster_id != null)){
            $dutyroasterData = $dutyroasterData->whereNull('user_personal.duty_roaster_id');
        }
        if ($ActiveUserShownStatus == '0') {
            $dutyroasterData = $dutyroasterData->where('user_pay.pay_status', '=', '1');
        }

        $dutyroasterData =  $dutyroasterData->get();
        // dd($dutyroasterData);
        $dutyroasterData->map(function ($item, $index) {
            $index++;
            $item->name = $item->name;
            if ($item->sname) {
                $item->dutyRoaster_name = $item->sname;
                $item->duty_roaster_id = $item->duty_roaster_id;
            } else {
                $item->dutyRoaster_name = " ";
            }

            return $item;
        });
        // dd($request->dutyroaster_id);
        return DataTables::of($dutyroasterData)->make(true);

       

    }


    function mapAttendance(Request $request)
    {   
        $emp_arr = json_decode($request->employee_id);
        $userpersonal['eattendance_type'] = $request->eattendance_type;
        $userpersonal['duty_roaster_id'] = $request->dutyRoaster_id; 
        $userpersonal['schedule_id'] = NULL;
        
        $result = UserPersonal::whereIn('username', $emp_arr)->update($userpersonal);
        
        return true;
    }
     
    public function Empdutyroasterdata(Request $request)
    {

        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        
        $dutyroasterData = UserPersonal::select('user_personal.name as name','user_personal.username','duty_roaster.name as sname')
                            ->leftJoin('duty_roaster',  'user_personal.duty_roaster_id','=','duty_roaster.id')
                            ->leftJoin('user_pay',  'user_personal.username','=','user_pay.username');
        
        if ($ActiveUserShownStatus == '0') {
            $dutyroasterData = $dutyroasterData->where('user_pay.pay_status', '=', '1');
        }
            
        $dutyroasterData->whereNull('user_personal.duty_roaster_id')->get();

         return DataTables::of($dutyroasterData)->make(true);
    }
     public function updateAssigndutyroaster(Request $request)
    {
        $duty_roster_id = $request->duty_roster_id;
        $empUsername = $request->empUsername;
        UserPersonal::where('username', $empUsername)->update(['duty_roaster_id' => $duty_roster_id]);
        return true;
    }

    public function unassigndutyroaster(Request $request)
    {
        $empUsername = json_decode($request->empUsernames);
        // dd($empUsername);
        DB::table('user_personal')
        ->whereIn('username',$empUsername)
        ->update(['duty_roaster_id' =>NULL,'eattendance_type'=>NULL]);
        return true;     
    }
    
    
    
  
}