<?php

namespace App\Http\Controllers;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Dompdf\Options;
use Carbon\CarbonPeriod;
use Dompdf\Dompdf;
use App\Models\{
    Setting,
    UserEpay,
    User,
    UserPay,
    AllowanceDeduction,
    Category,
    EAttandanceHook,
    Clockin,
    Schedule,
    Department,
    Branch,
    Detail,
    UserPersonal,
    DutyRoster,
    OtRequest,
};
use Auth,
    DateTime,
    Yajra\DataTables\DataTables;

use Helper;
use PHPUnit\Util\Json;

class EattendanceController extends Controller
{
    protected $storageDriver;

    public function __construct()
    {
        $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }

    public function attendanceEmp()
    {
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        
        $c_key = 'emp_attendance';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('E-Attendance.eattendance_em', compact('categories', 'departments', 'branches', 'schedules', 'columnHideShowData', 'c_key'));
    }


    public function dashboardEmp()
    {
        return view('E-Attendance.dashboard_em');
    }

    public function dashboardHr()
    {
        
        $total_employee = UserPersonal::where('isDeleted', '0')->count();

        $total_emp = $total_employee * 31;
        $schedules =  Schedule::select('id', 'name')->get();

        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
           
        $c_key = 'late_listings';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

           
        return view('E-Attendance.dashboard_hr', compact('total_emp', 'schedules', 'categories', 'departments', 'branches', 'columnHideShowData', 'c_key'));

    }

    public function EAttendanceMain()
    {
        return view('E-Attendance.eattendance');
    }


    public function setupHr()
    {
        return view('E-Attendance.setup_hr');
    }

    function EAttendanceClockIn(Request $request)
    {

        $newRequest = EAttandanceHook::where('id', '!=', "0")->orderBy('id', 'DESC')->where('used', 'n')->limit(500)->get();

        foreach ($newRequest as $rr) {
            $saveData = Helper::saveWebHookData($rr);
            if ($saveData) {
                $rr->used = 'y';
                $rr->save();
            } else {
                continue;
            }
        }
        return response()->json(["message" => "Success"], 200);
    }


    function list()
    {
        $emps = DB::table('user_personal')->select('employee_no', 'name')->get();
        $devices = DB::table('devices')->select('devicename')->get();
        return view('E-Attendance.list', compact('emps', 'devices'));
    }


    public function allClockindata(Request $request)
    {
     
        $scheduleData = Clockin::select('clockin.*');
        if(isset($request->from_date) && isset($request->to_date)){
            $scheduleData->whereBetween('working_day', [$request->from_date, $request->to_date]);
        }
        if(isset($request->device) && $request->device != ""){
            $scheduleData->where('devicename', $request->device);
        }
        if(isset($request->emp) && $request->emp != ""){
            $scheduleData->where('employee_no', $request->emp);
        }
        
        $scheduleData->orderBy('clockin.id', 'DESC');
        $scheduleDatas = $scheduleData->get();
        
        $scheduleDatas->map(function ($item, $index) {
            $index++;
            $item->serialNo;
            $item->personname;
            $item->employee_no;
            $item->date;
            $item->time;

            if(isset($item->id)){
                $timeChange2 = DB::table('time_change')->where('clockin_id', $item->id)->first();
            }else{
                $timeChange2 = NULL;
            }

            if(isset($timeChange2)){
                $item->time = date("H:i", strtotime($timeChange2->time_from));
            }else{
                $item->time = date("H:i", strtotime($item->time));
            }

            if($item->devicename == "0000"){
                $item->devicename = "Manual";
            }else{
                $item->devicename;
            }
            
            $item->serialNumber;
            $item->cardno;

            return $item;
        });
        return DataTables::of($scheduleDatas)->make(true);
    }






    // public function scheduledataaaa(Request $request)
    // {


    //     $scheduleData = Schedule::get();
    //     $scheduleData->map(function ($item, $index) {
    //         $index++;
    //         $item->schedule_id = $item->schedule_id;
    //         $item->name = $item->name;
    //         $item->eattendance_type = $item->work_schedule;
    //         $item->description = $item->description;
    //         $item->map_schedule =  '1';

    //         return $item;
    //     });
    //     return DataTables::of($scheduleData)->make(true);
    // }





    function empattendancedata(Request $request)
    {
        $employees11 = Clockin::where('employee_no', '=', getUserName());

        if ($request->get('sdatefrom') && $request->get('sdatefrom') != '') {
            $employees11->where('date', '>=', $request->get('sdatefrom'));
        }
        if ($request->get('sdateto') && $request->get('sdateto') != '') {
            $employees11->where('date', '<=', $request->get('sdateto'));
        }

        $employees = $employees11->get();
        $employees->map(function ($item) {
            $item->serialNo;
            $item->personname;
            $item->date;
            $item->time;
            $item->devicename;
            $item->serialNumber;
            $item->cardno;
        });

        return DataTables::of($employees)->make(true);
    }


    function HrAttendance()
    {
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $c_key = 'hr_attendance';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('E-Attendance.eattendance_hr', compact('categories', 'departments', 'branches', 'schedules', 'columnHideShowData', 'c_key'));
    }

    
    /////////////////////////////allAttendance//////////////////////////////////
    
   // change By Ashutosh
   public function allAttendance(Request $req)
   {
       if ($req->user_type == 'emp') {
           $start_date = Carbon::now()->startOfMonth()->toDateString();
       }else{
           if($req->att_filter == "daily"){
               $start_date = Carbon::now()->toDateString();
           }elseif($req->att_filter == "weekly"){
               $start_date = Carbon::now()->sub('6 days')->toDateString();
           }elseif($req->att_filter == "monthly"){
               $start_date = Carbon::now()->startOfMonth()->toDateString();
           }
       }

 
       $end_of_month = Carbon::now()->endOfMonth()->toDateString();
       $current_date = Carbon::now()->toDateString();
       
       session(['employees_attendance_data' => $req->getUri()]);
       $user_type = $req->user_type;
       $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
       $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
       $schedule = $req->schedule;
       $day_type = $req->day_type;
       $category = $req->category;
       $branch = $req->branch;
       $department = $req->department;
       $emp_no = $req->emp_no;
       $in_out_filter = $req->in_out_filter;
       $att_filter = $req->att_filter;
       $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave', 'at_least_one'];

      //
       $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
       $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
       //

       $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
       $dates = $dateRange->toArray();

       $qry = '';
       for ($i = 0; $i < count($dateRange); $i++) {
           $alldate = $dates[$i]->format('Y-m-d');
               $qry .= 'select cast(\'' . $alldate . '\' as date) as dte ';

               if ($i < (count($dateRange) - 1)) {
                   $qry .= 'union ';
               }
       }
       
       if($sdatefrom == $sdateto){
           $qry = $qry .'union '. $qry;
       }
   
       $attendanceDatad = DB::table(DB::raw('(' . $qry . ') dates'))
           ->select('dates.dte', 'clk.devicename', 'duty_roaster_dates.holiday_id','duty_roaster_dates.day_type as r_day_type', 'public_holiday.description', 'sch.*', 'up.employee_no', 'up.eattendance_type', 'up.username','up.name','clk.id as clockin_id','clk.updated_at',
               DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'), 'user_pay.date_commence', 'user_pay.date_resigned', 'user_pay.date_attendance_start', 'leave_list.type as l_type')
           ->crossJoin(DB::raw('user_personal up'))
           ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
           
           $attendanceDatad->leftJoin(DB::raw('clockin clk'), function ($data) {
               $data->on('up.employee_no', '=', 'clk.employee_no')
                   ->whereRaw('clk.working_day = dte');
           });
          

           // roster
           $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) {
               $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                   ->whereRaw('duty_roaster_dates.date = dte');
           });

           $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
               $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                   ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
           });

           $attendanceDatad->leftJoin(DB::raw('public_holiday'), function ($joins) {
               $joins->on('public_holiday.id', '=', 'duty_roaster_dates.holiday_id');
           });

           $attendanceDatad->leftjoin('user_pay', 'user_pay.username', '=', 'up.username');


           $attendanceDatad->leftJoin(DB::raw('leave_list'), function ($joins) {
               $joins->on('leave_list.username', '=', 'user_pay.username')
               ->whereRaw('leave_list.start_date = dte')
               ->where('leave_list.status', 1);
           });


           if ($user_type == 'emp') {
               $attendanceDatad->where('up.employee_no', '=', $emp_no);
           }
           
           $attendanceDatad->where(function($q){
               $q->whereRaw('user_pay.date_resigned >= dte')->orWhere('user_pay.date_resigned', '0000-00-00');
           })->where('user_pay.pay_status', 1);

   
           $attendanceDatad->whereRaw('dte >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
       
       // filter
       if ($sdatefrom) {
           $attendanceDatad->where('dates.dte', '>=', $sdatefrom);
       }
       
       if ($sdateto) {
           $attendanceDatad->where('dates.dte', '<=', $sdateto);
       }
       if ($schedule && $schedule != "Flexi") {
           $attendanceDatad->where('up.schedule_id', '=', $schedule);
       }

       if ($day_type && $day_type != '' && $day_type == 'Work') {
           $attendanceDatad->where('duty_roaster_dates.day_type', '=', "SCHEDULE");
       }
 
       if ($day_type && $day_type != '' && $day_type == 'PH') {
           $attendanceDatad->where('duty_roaster_dates.day_type', '=', "HOLIDAY");
       }

       if ($day_type && $day_type != '' && $day_type == 'Rest') {
           $attendanceDatad->where('duty_roaster_dates.day_type', '=', "RESTDAY");
       }

       if ($category) {
           $attendanceDatad->where('user_pay.category_id', '=', $category);
       }
       if ($branch) {
           $attendanceDatad->where('user_pay.branch_id', '=', $branch);
       }
       if ($department) {
           $attendanceDatad->where('user_pay.department_id', '=', $department);
       }
       if ($ActiveUserShownStatus == '0') {
           $attendanceDatad->where('user_pay.pay_status', '=', 1);
       }
       // // filter


       $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'dates.dte'])->orderBy('dates.dte', 'DESC')->orderBy('up.employee_no', 'ASC')->get();
       // dd($attendanceData);

       for ($i = 0; $i < count($attendanceData); $i++) {
           $attendance_data =  $attendanceData[$i];

           $fulltime = explode('==', $attendance_data->fulltime);
           $entry_time = $attendance_data->entry;
           $break_time = $attendance_data->break;
           $resume_time = $attendance_data->user_resume;
           $leave_time = $attendance_data->user_leave;
           $schedule_range = $attendance_data->schedule_range;
           $flexi_lunch = $attendance_data->flexi_lunch;
           $min_ot = $attendance_data->min_ot;
           $min_flexi_hour = $attendance_data->min_flexi_hour;
           $user_schedule = $attendance_data->schedule_id;
           $l_type = $attendance_data->l_type;

           $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
           $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
           $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
           $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
           $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));



           $intime = '';
           $break = '';
           $resume = '';
           $out_time = '';
           $lateness = "";
           $overtime = "";
           sort($fulltime);



           $total_fultime = count($fulltime);

           for ($a = 0; $a < $total_fultime; $a++) {
               $emp_time = $fulltime[$a];
              
               // entry time
               if ($attendance_data->day_type == 'Work') {
                   if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                       $intime = $emp_time;
                   }

                   // break_times
                   if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                       $break = $emp_time;
                   }


                   //   resume_time
                   if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                       $resume = $emp_time;
                   } else {
                       if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                           $resume = $emp_time;
                       }
                   }

                   //   out
                   if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                       $out_time = $emp_time;
                   }
                   
               } elseif ($attendance_data->day_type == 'Flexi') {

                   if ($a == '0') {
                       $intime = $emp_time;
                   } elseif ($a == ($total_fultime - 1)) {
                       $out_time = $emp_time;
                   } elseif ($a == '1') {
                       $break = $emp_time;
                   } elseif ($a == '2') {
                       $resume = $emp_time;
                   }
               }else{
                   if($user_schedule && $break_range_min != "00:00" && $resume_range_min != "00:00" && $resume_range_max != "00:00" && $min_ot_range != "00:00"){
                       
                       if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                           $intime = $emp_time;
                       }
               
                       // break_times
                       if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                           $break = $emp_time;
                       }


                       //   resume_time
                       if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                           $resume = $emp_time;
                       } else {
                           if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                               $resume = $emp_time;
                           }
                       }

                       //   out
                       if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                           $out_time = $emp_time;
                       }
                   }else{
                       $attendance_data->day_type = "Rest";
                       if($attendance_data->r_day_type == "HOLIDAY"){
                           $attendance_data->day_type  = "Holiday";
                       }
                       if(count($fulltime) > 1){
                           $intime = $fulltime[0];
                           $out_time = end($fulltime);
                           $attendance_data->schedule_id = "Flexi";
                       }elseif(count($fulltime) == 1 && $fulltime[0] != ''){
                           $intime = $fulltime[0];
                           $attendance_data->schedule_id = "Flexi";
                       }

                       if(isset($intime) && isset($out_time) && $out_time != "00:00" && $out_time != "" && strtotime(date("H:i",strtotime($out_time) - strtotime($intime)))){
                           $overtime = date("H:i", strtotime($out_time) - strtotime($intime));
                       }
                   }   

               }

               // late data
               if(isset($intime) && $entry_range != "00:00" && strtotime($entry_range) > strtotime($intime)){
                   $lateness = '';
               }elseif(isset($intime) && $entry_range != "00:00" && strtotime($entry_range) < strtotime($intime)){
                   $lateness = date("H:i", strtotime($intime) - strtotime($entry_range));
               }elseif(isset($break) && $entry_range != "00:00" && strtotime($entry_range) < strtotime($break)){
                   $lateness = date("H:i", strtotime($break) - strtotime($entry_range));
               }elseif(isset($resume) && $entry_range != "00:00" && strtotime($entry_range) < strtotime($resume)){
                   $lateness = date("H:i", strtotime($resume) - strtotime($entry_range));
               }

               // early out
               // dd($out_time);
               if(isset($out_time) && $out_time != "00:00" && $out_time != ""  && $leave_time != "00:00" && strtotime($leave_time) > strtotime($out_time)){
                   $outTime = date('H:i', strtotime($out_time));
                   $earlyOut = date("H:i", strtotime($leave_time) - strtotime($outTime));
               }else{
                   $earlyOut = '';
               }

               // OT data
     
               if(isset($out_time) && $out_time != "" && $min_ot_range != "00:00" && strtotime($min_ot_range) <= strtotime($out_time)){
                   $overtime = date("H:i", strtotime($out_time) - strtotime($leave_time));
               }
           }

           $lunch_text_color = $in_text_color = $leave_text_color = 'black';
           $emp_lunch = (strtotime($resume) - strtotime($break));
           if (($emp_lunch >= ($flexi_lunch * 60) && $emp_lunch > 0)) {
               $lunch_text_color = "red";
           }
           if (strtotime($intime) > strtotime($entry_time)) {
               $in_text_color = "red";
           }
           if (strtotime($out_time) < strtotime($leave_time)) {
               $leave_text_color = "red";
           }


           $attendance_data->earlyOut = $earlyOut;
           $attendance_data->lateness = $lateness;
           $attendance_data->overtime = $overtime;
           $attendance_data->intime = $intime;
           $attendance_data->break_time = $break;
           $attendance_data->resume_time = $resume;
           $attendance_data->leave_time = $out_time;
           $attendance_data->lunch_text_color = $lunch_text_color;
           $attendance_data->in_text_color = $in_text_color;
           $attendance_data->leave_text_color = $leave_text_color;
           $attendance_data->in_textbold =  $this->fontBold($intime, $attendance_data->dte, $attendance_data->employee_no);
           $attendance_data->break_textbold =  $this->fontBold($break, $attendance_data->dte, $attendance_data->employee_no);
           $attendance_data->resume_textbold =  $this->fontBold($resume, $attendance_data->dte, $attendance_data->employee_no);
           $attendance_data->out_textbold =  $this->fontBold($out_time, $attendance_data->dte, $attendance_data->employee_no);
           
           $attendance_data->filter_val = 0;
           // in out filter
           if ((($in_out_filter == 'no_in_out')  && !$intime && $out_time) || (($in_out_filter == 'no_in_out')  && $intime && !$out_time) || (($in_out_filter == 'no_lunch')  && !$break && ($intime || $out_time)) || ($in_out_filter == 'over_lunch'  && ($emp_lunch >= ($flexi_lunch * 60) && $emp_lunch > 0)) || ($in_out_filter == 'late_in'  && ($intime > $entry_time)) || ($in_out_filter == 'early_out' && $out_time != ""  && ($out_time < $leave_time) )  || ($in_out_filter == 'overtime'  && ($out_time > $min_ot_range)) || ($in_out_filter == 'on_leave' && $l_type != NULL) || ($in_out_filter == 'at_least_one' && ($intime || $out_time || $break || $resume))) {
               $attendance_data->filter_val = $i + 1;
           }
       }

       if (in_array($in_out_filter, $filter_arr)) {
           $filtered = $attendanceData->reject(function ($value, $key) {
               $key++;
               return $value->filter_val != $key;
           });
       } else {
           $filtered = $attendanceData;
       }
       


       $filtered->map(function ($item, $index) {
           
           if(is_int($item->schedule_id)){
               if(isset($item->schedule_id) && ($item->schedule_id) != null){
                   $schedule_name = getScheduleName($item->schedule_id);
               }
           }else{
               $schedule_name = $item->schedule_id;
           }

           $index++;
           $item->date = date('d-m-Y', strtotime($item->dte));
           $item->working_day = $item->dte;
           $item->clockin_id = $item->clockin_id;
           $item->day_name = date("D", strtotime($item->dte));
           $item->employee_no = $item->employee_no;
           $item->personname  =  $item->name;
           $item->schedule_id = $schedule_name;
           $item->lateness;
           $item->earlyOut;
           $item->overtime;
           
           
           if($item->l_type && $item->l_type!=NULL){
               $item->day_type = getLeaveNameByType($item->l_type);;
           }else{
               $item->day_type = $item->day_type;
           }
           
           
           $item->devicename;
           $item->in_textbold;
           $item->break_textbold;
           $item->resume_textbold;
           $item->out_textbold;
           // for edit
           $item->intime_id  = $item->intime;
           $item->break_id  = $item->break_time;
           $item->resume_id = $item->resume_time;
           $item->leave_id  = $item->leave_time;
           
            if(isset($item->intime) && $item->intime!= '' && isset($item->leave_time) && $item->leave_time!= '' && $item->day_type == "Work"){
                $item->work_hour = date("H:i", (explode_time($item->leave_time)) - (explode_time($item->intime)));
            }else{
                $item->work_hour = "";
            }
            
           // for edit
           $item->intime  = ($item->intime != '') ? (date('H:i', strtotime($item->intime))) : ('-');
           $item->break_time  = ($item->break_time != '') ? (date('H:i', strtotime($item->break_time))) : ('-');
           $item->resume_time = ($item->resume_time != '') ? (date('H:i', strtotime($item->resume_time))) : ('-');
           $item->leave_time  = ($item->leave_time != '') ? (date('H:i', strtotime($item->leave_time))) : ('-');
           // dd($item);
           return $item;
       });
       // dd($filtered);
    
       $finalData = [];
       if(isset($schedule) && $schedule=="Flexi"){
           foreach($filtered as $filters){
               if($filters->schedule_id == "Flexi"){
                   if($filters->eattendance_type != NULL){
                       array_push($finalData, $filters);
                   }
               }
           }
       }else{
           foreach($filtered as $filters){
               if($filters->eattendance_type != NULL){
                   array_push($finalData, $filters);
               }
           }
       }

       // dd($filtered);

       return DataTables::of($finalData)->make(true);
   }
    
    // ==================== attandance report by Ashutosh soni =====================
    public function attendanceSummary()
    {
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();

        $c_key1 = 'summary_1';
        $columnHideShowData1 = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key1])->first();
        if($columnHideShowData1){
            $columnHideShowData1 = json_decode($columnHideShowData1->c_value);
        }else{
            $columnHideShowData1 = array();
        }

        $c_key2 = 'summary_2';
        $columnHideShowData2 = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key2])->first();
        if($columnHideShowData2){
            $columnHideShowData2 = json_decode($columnHideShowData2->c_value);
        }else{
            $columnHideShowData2 = array();
        }

        $c_key3 = 'summary_3';
        $columnHideShowData3 = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key3])->first();
        if($columnHideShowData3){
            $columnHideShowData3 = json_decode($columnHideShowData3->c_value);
        }else{
            $columnHideShowData3 = array();
        }

        
        return view('E-Attendance.attendance-summary', compact('categories', 'departments', 'branches', 'schedules', 'c_key1', 'columnHideShowData1', 'c_key2', 'columnHideShowData2', 'c_key3', 'columnHideShowData3'));
    }


    public function attendanceSummaryData(Request $req)
    {
        $start_date = Carbon::now()->startOfMonth()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();
        
        session(['employees_attendance_summary' => $req->getUri()]);
        $user_type = $req->user_type;
        $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
        $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
        $schedule = $req->schedule;
        $day_type = $req->day_type;
        $category = $req->category;
        $branch = $req->branch;
        $department = $req->department;
        $emp_no = $req->emp_no;
        $in_out_filter = $req->in_out_filter;
        $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave'];
        $diffDate = date_diff(date_create($sdatefrom),date_create($sdateto));
        $totalDays = $diffDate->days+1;

        $overtimes_emp = 0;
        $overtime = '';

       //
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        //

        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
        
        $qry = '';
        for ($i = 0; $i < count($dateRange); $i++) {
            $alldate = $dates[$i]->format('Y-m-d');
                $qry .= 'select cast(\'' . $alldate . '\' as date) as dte ';

                if ($i < (count($dateRange) - 1)) {
                    $qry .= 'union ';
                }
        }
        
        if($sdatefrom == $sdateto){
            $qry = $qry .'union '. $qry;
        }
      
        $attendanceDatad = DB::table(DB::raw('(' . $qry . ') dates'))
            ->select('dates.dte', 'leave_list.no_days','duty_roaster_dates.holiday_id','duty_roaster_dates.day_type as r_day_type', 'public_holiday.description', 'sch.*', 'up.employee_no', 'up.eattendance_type', 'up.duty_roaster_id', 'up.username','up.name','clk.updated_at',
             DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'), 'user_pay.date_attendance_start', 'user_pay.branch_id', 'user_pay.date_resigned')
            ->crossJoin(DB::raw('user_personal up'))
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
            
            $attendanceDatad->leftJoin(DB::raw('clockin clk'), function ($data) {
                $data->on('up.employee_no', '=', 'clk.employee_no')
                    ->whereRaw('clk.working_day = dte');
            });
            
            // roster
            $attendanceDatad->join(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->whereRaw('duty_roaster_dates.date = dte');
            });
            
            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            });

            // $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
            //     $joinss->on(DB::raw('(CASE WHEN up.eattendance_type = "duty_roaster" THEN duty_roaster_dates.schedule_id ELSE up.schedule_id END)') , '=', 'sch.schedule_id')
            //         ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            // });

            
            $attendanceDatad->leftJoin(DB::raw('public_holiday'), function ($joins) {
                $joins->on('public_holiday.id', '=', 'duty_roaster_dates.holiday_id');
            });
           
            
            $attendanceDatad->leftJoin(DB::raw('leave_list'), function ($joins) use($sdatefrom, $sdateto) {
                $joins->on('up.username', '=', 'leave_list.username')
                    ->where('leave_list.start_date', '>=', $sdatefrom)->where('leave_list.end_date', '<=', $sdateto)->where('leave_list.status', 1);
            });

            
            $attendanceDatad->leftjoin('user_pay', 'user_pay.username', '=', 'up.username');

    
            $attendanceDatad->where(function($q){
                $q->where('user_pay.date_resigned', NULL)->orWhere('user_pay.date_resigned', '0000-00-00');
            })->where('user_pay.pay_status', 1);

    
            $attendanceDatad->whereRaw('dte >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
            
        if ($user_type == 'emp') {
            $attendanceDatad->where('up.employee_no', '=', $emp_no);
        }
        

        // filter
        if ($sdatefrom) {
            $attendanceDatad->where('dates.dte', '>=', $sdatefrom);
        }
        
        if ($sdateto) {
            $attendanceDatad->where('dates.dte', '<=', $sdateto);
        }
        if ($schedule) {
            $attendanceDatad->where('up.schedule_id', '=', $schedule);
        }
        if ($day_type && $day_type != '') {
            $attendanceDatad->where('sch.day_type', '=', $day_type);
        }
        if ($category) {
            $attendanceDatad->where('user_pay.category_id', '=', $category);
        }
        if ($branch) {
            $attendanceDatad->where('user_pay.branch_id', '=', $branch);
        }
        if ($department) {
            $attendanceDatad->where('user_pay.department_id', '=', $department);
        }
        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', 1);
        }
        // // filter


        $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'dates.dte'])->orderBy('dates.dte', 'DESC')->orderBy('up.employee_no', 'ASC')->get();
        // dd($attendanceData);

        if (in_array($in_out_filter, $filter_arr)) {
            $filtered = $attendanceData->reject(function ($value, $key) {
                $key++;
                return $value->filter_val != $key;
            });
        } else {
            $filtered = $attendanceData;
        }


        $filtered->map(function ($item, $index) {
            
            if(isset($item->schedule_id) && ($item->schedule_id) != null){
                $schedule_name = getScheduleName($item->schedule_id);
            }else{
                $schedule_name = $item->description;
            }

            $index++;
            $item->index = $index;
            $item->date = date('d-m-Y', strtotime($item->dte));
            $item->working_day = $item->dte;
            $item->employee_no = $item->employee_no;
            $item->no_days = $item->no_days;
            $item->personname  =  $item->name;
  
            return $item;
        });
        // dd($filtered);

        $finalDatas = json_decode(json_encode($filtered), true);

        $check = [];
        $finalReport = [];

        foreach($finalDatas as $finalData){
            if(!isset($check[$finalData['employee_no']])){

                $entry_time = $finalData['entry'];
                $break_time = $finalData['break'];
                $resume_time = $finalData['user_resume'];
                $leave_time = $finalData['user_leave'];
                $schedule_range = $finalData['schedule_range'];
                $flexi_lunch = $finalData['flexi_lunch'];
                $min_ot = $finalData['min_ot'];
                $min_flexi_hour = $finalData['min_flexi_hour'];
                $user_schedule = $finalData['schedule_id'];
  
                $entry_range_before = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($entry_time)));
                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                
                
                $hdays = DB::table('public_holiday')->where(function($q) use($finalData){
                    $q->where('branch_id',$finalData['branch_id'])->orWhere('branch_id', 0);
                })->whereBetween('date', [$sdatefrom, $sdateto])->count();

                
            
                
                $pre = array_filter($finalDatas, function($value) use($finalData){
                    return $value['employee_no'] == $finalData['employee_no'] && $value['fulltime'] != NULL;
                });

                $sche = array_filter($finalDatas, function($value) use($finalData){
                    return $value['employee_no'] == $finalData['employee_no'] && $value['schedule_id'] != NULL;
                });


                // workday present
                $wp = array_filter($pre, function($value) use($finalData){
                    return $value['day_type'] == 'Work';
                });
                $fwp = array_filter($pre, function($value) use($finalData){
                    return $value['day_type'] == 'Flexi';
                });


                // rest day present
                $op = array_filter($pre, function($value) use($finalData){
                    return $value['r_day_type'] == 'RESTDAY';
                });
                
                
                // overtime present
                $overtimes_emp = 0;
                $late_emp = 0;
                $early_dep = 0;
                $mp = 0;
                $leave = 0;
                $perfect = 0;
                $leave += $finalData['no_days'];

                $workdayHours = 0;
                $restdayHours = 0;
                $eoHours = 0;
                $liHours = 0;
                
                $workdayOvertimeHours = 0;
                $restdayOvertimeHours = 0;
                $holydayHours = 0;
                $holydayOvertimeHours = 0;
                $out_time = 0;
                $hp = 0;

                foreach($pre as $value){
                    
                    $entry_time = $value['entry'];
                    $break_time = $value['break'];
                    $resume_time = $value['user_resume'];
                    $leave_time = $value['user_leave'];
                    $schedule_range = $value['schedule_range'];
                    $flexi_lunch = $value['flexi_lunch'];
                    $min_ot = $value['min_ot'];
                    $min_flexi_hour = $value['min_flexi_hour'];
                    $user_schedule = $value['schedule_id'];
      
                    $entry_range_before = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($entry_time)));
                    $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                    $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                    $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                    
                    
                    $odays = DB::table('duty_roaster_dates')->where(['duty_roaster_id'=> $value['duty_roaster_id'], 'day_type'=>'RESTDAY'])->whereBetween('date', [$sdatefrom, $sdateto])->count();
                
                    $fulltime = explode('==', $value['fulltime']);
                    // dd($odays);
                    
                    // holiday present count
                    $hpc = $value['holiday_id'];
                    if($value['holiday_id'] != null){
                        $hp += 1;
                    }
                   
                    $intime = '';
                    $break = '';
                    $resume = '';
                    $out_time = '';

                    sort($fulltime);


                    $total_fultime = count($fulltime);

                    // miss punch count
                    if($total_fultime %3 == 0){
                        $mp += 1; 
                    }

                    
                    for ($a = 0; $a < $total_fultime; $a++) {
                        
                        $emp_time = $fulltime[$a];
                        
                        // holiday present hour
                        if($hpc){
                            
                            if(isset($fulltime[$a+1])){
                                $otOut = $fulltime[$a+1];
                                $otIn =  $fulltime[$a];
                                if(strtotime(date('H:i', (strtotime($otOut) - strtotime($otIn)))) > strtotime(date("H:i", strtotime("08:00")))){
                                    $holydayOvertimeHours = second_to_hhmm(explode_time($holydayOvertimeHours) + (explode_time($otOut) - explode_time($otIn)) - explode_time("08:00"));
                                    $holydayHours = second_to_hhmm(explode_time($holydayHours) + explode_time("08:00"));
                                }else{
                                    $holydayHours = second_to_hhmm(explode_time($holydayHours) + explode_time($otOut) - explode_time($otIn));
                                }
                            }       
                        }
                        
                        // entry time
                        if ($value['day_type'] == 'Work') {

                                if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                    $intime = $emp_time;
                                  
                                    //continue;
                                }
    
    
                                // break_times
    
                                if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                    $break = $emp_time;
                                    //continue;
                                }
    
    
                                //   resume_time
                                if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                    $resume = $emp_time;
                                    //continue;
                                } else {
                                    if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                        $resume = $emp_time;
                                        //continue;
                                    }
                                }
                            
                                //   out
                                if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                    $out_time = $emp_time;
                                    //continue;
                                }
                                
                                $userLeaveTime = date("H:i", strtotime($value['user_leave']));
                                $userMinOtTime = date("H:i", strtotime($value['user_leave']) + strtotime($value['min_ot']));
                            
                                // workday hour
                                if(isset($fulltime[$a+1])){
                                    $next_clk = $fulltime[$a+1];
                                    $current_clk =  $fulltime[$a];
                                    if(strtotime(end($fulltime)) >= strtotime($userMinOtTime)){
                                        $todaysWorkingHrs = date("H:i", strtotime($value['user_leave']) - strtotime($value['entry']));
                                        $workdayOvertimeHours = second_to_hhmm(explode_time($workdayOvertimeHours) + explode_time(end($fulltime)) - explode_time($userLeaveTime));
                                    }else{
                                        $todaysWorkingHrs = second_to_hhmm(explode_time($next_clk) - explode_time($current_clk));
                                    }
                                    
                                    $workdayHours = second_to_hhmm(explode_time($workdayHours) + explode_time($todaysWorkingHrs));
                                    
                                }
                                
                               
                        } elseif ($value['day_type'] == 'Flexi') {
                            if($user_schedule){
                                // workday hour
                                if(isset($fulltime[$a+1])){
                                    $next_clk = $fulltime[$a+1];
                                    $current_clk =  $fulltime[$a];
                                    $workdayHours = second_to_hhmm(explode_time($workdayHours) + explode_time($next_clk) - explode_time($current_clk));
                                }
                     
                                if (strtotime($out_time) >= strtotime($min_ot_range)) {
                                    $workdayOvertimeHours = second_to_hhmm(explode_time($workdayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                                }
                                
                                if ($a == '0') {
                                    $intime = $emp_time;
                                    continue;
                                } elseif ($a == ($total_fultime - 1)) {
                                    $out_time = $emp_time;
                                    continue;
                                } elseif ($a == '1') {
                                    $break = $emp_time;
                                    continue;
                                } elseif ($a == '2') {
                                    $resume = $emp_time;
                                    continue;
                                }elseif($a == '3'){
                                    $out_time = $emp_time;
                                    continue;
                                }
                            }
                        }else{
                            if(isset($value['entry']) && $value['entry']!= " " && $value['entry']!= "00:00"){
                                //   out
                                if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                    $out_time = $emp_time;
                                }
                                 
                                // restday hour
                                if(isset($fulltime[$a+1])){
                                    $next_clk = $fulltime[$a+1];
                                    $current_clk =  $fulltime[$a];
                                    $restdayHours = second_to_hhmm(explode_time($restdayHours) + explode_time($next_clk) - explode_time($current_clk));
                                }
                        
                                if (strtotime($out_time) >= strtotime($min_ot_range)) {
                                    $restdayOvertimeHours = second_to_hhmm(explode_time($restdayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                                }
                            }else{
                                    
                                // restday hour
                                if(isset($fulltime) && $hpc == null){
                                    // dd(end($fulltime));
                                    // print_r($fulltime);
                                    $otIn = current($fulltime);
                                    $otOut = end($fulltime);
                     
                                    if(strtotime(date('H:i', (strtotime($otOut) - strtotime($otIn)))) > strtotime(date("H:i", strtotime("08:00")))){
                                        $restdayOvertimeHours = second_to_hhmm(explode_time($restdayOvertimeHours) + (explode_time($otOut) - explode_time($otIn)) - explode_time("08:00"));
                                        $restdayHours = second_to_hhmm(explode_time($restdayHours) + explode_time("08:00"));
                                    }else{
                                        $restdayHours = second_to_hhmm(explode_time($restdayHours) + explode_time($otOut) - explode_time($otIn));
                                    }
                                }
                                
                            }
                        }

                        // perfect
                        if(strtotime($intime) >= strtotime($entry_range_before) && strtotime($intime) <= strtotime($entry_range)){
                            $perfect += 1;
                        }
                        
                        
                    }
                    
                    if($value['day_type'] == 'Work'){
                        
                            
                        if (strtotime($intime) > strtotime($entry_range)) {
                            $late_emp += 1;
                            $liHours = second_to_hhmm(explode_time($liHours) + explode_time($intime) - explode_time($entry_time));
                            
                        } elseif (!$intime && $break) {
                            $late_emp += 1;
                        } elseif (!$intime && !$break && $resume) {
                            $late_emp += 1;
                        } elseif (!$intime && !$break && !$resume && $out_time) {
                            $late_emp += 1;
                        }
                        
                        if ((strtotime($out_time) < strtotime($leave_time)) && $out_time && $out_time!= "" && $out_time != null) {
                            $eoHours = second_to_hhmm(explode_time($eoHours) + explode_time($leave_time) - explode_time($out_time));
                            $early_dep += 1;
                        }
                    }
                    

                    $lunch_text_color = $in_text_color = $leave_text_color = 'black';
                    $emp_lunch = (strtotime($resume) - strtotime($break));
                    if (($emp_lunch >= ($flexi_lunch * 60) && $emp_lunch > 0)) {
                        $lunch_text_color = "red";
                    }
                    if (strtotime($intime) > strtotime($entry_time)) {
                        $in_text_color = "red";
                    }
                    if (strtotime($out_time) < strtotime($leave_time)) {
                        $leave_text_color = "red";
                    }

                    if($value['day_type'] == NULL){
                        $value['day_type'] = $value['r_day_type'];
                    }

                    // overtime
                    if (strtotime($out_time) >= strtotime($min_ot_range)) {
                        $overtimes_emp += 1;
                    }
                    

                }
                
                $finalData['start_date'] = $sdatefrom;
                $finalData['end_date'] = $sdateto;
                
                // count
                // if(strtotime($finalData['date_attendance_start']) > strtotime($sdatefrom)){
                //     $diffDate = date_diff(date_create($finalData['date_attendance_start']),date_create($sdateto));
                //     $totalDays = $diffDate->days+1;
                //     $finalData['start_date'] = $finalData['date_attendance_start'];
                // }

                $finalData['today'] = date("Y-m-d");

                $finalData['total_days'] = $totalDays;
                $finalData['present_days']=count($pre);
                
                if($totalDays){
                    $finalData['workrate'] = round(((count($pre))*100)/$totalDays, 2);
                }else{
                    $finalData['workrate'] = 0;
                }

                $oa = ( $odays ?? 0 ) - count($op);
                $ha = $hdays-$hp;


                $finalData['absent_days'] = $totalDays - count($pre) - $ha- $oa - $leave;
                $finalData['wp'] = count($wp) + count($fwp);
                $finalData['op'] = count($op);
                $finalData['oa'] = $oa;
                $finalData['ot'] = $overtimes_emp;
                $finalData['li'] = $late_emp;
                $finalData['eo'] = $early_dep;
                $finalData['leave'] = $leave;
                $finalData['mp'] = $mp;
                $finalData['perfect'] = $perfect;
                $finalData['workday'] = $workdayHours;
                $finalData['restday'] = $restdayHours;
                $finalData['hp'] = $hp;
                $finalData['ha'] = $ha;
                $finalData['sche'] = count($sche);
                $finalData['workdayOvertimeHours'] = $workdayOvertimeHours;
                $finalData['holydayOvertimeHours'] = $holydayOvertimeHours;
                $finalData['holydayHours'] = $holydayHours;
                $finalData['restdayOvertimeHours'] = $restdayOvertimeHours;
                if(date('H:i', strtotime($liHours) + strtotime($eoHours)) != "00:00"){
                    $short = date('H:i', strtotime($liHours) + strtotime($eoHours));
                }else{
                    $short = 0;
                }
                $finalData['short'] = $short;

                $finalReport[] =$finalData;
                $check[$finalData['employee_no']]='1';
            }
           
        }
        // dd($finalReport);
        
        return DataTables::of($finalReport)->make(true);
    }
    
    
    public function attendanceSummaryExcel(Request $request)
    {
        $url1 = str_replace("length=10","length=-1",session('employees_attendance_summary'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        
        ini_set('memory_limit', -1);
          $curl = curl_init();
  
              curl_setopt_array($curl, array(
              CURLOPT_URL => $url."&auth_id=".Auth::id(),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
          ));

        $response = curl_exec($curl);
        //    dd($response);
        curl_close($curl);
        
        
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'Attendance Summary');

        $sheet->setCellValue('A'. 3, '√ = Perfect');
        $sheet->setCellValue('B'. 3, 'WP = Workday Present');
        $sheet->setCellValue('C'. 3, 'RP = Offday Present');
        $sheet->setCellValue('D'. 3, 'HP = Restday/Holiday Present');
        $sheet->setCellValue('E'. 3, 'OT = Overtime');
        $sheet->setCellValue('F'. 3, 'WR = WD/DW %');

        $sheet->setCellValue('A'. 4, 'AB = Absent');
        $sheet->setCellValue('B'. 4, 'LV = Leave Taken');
        $sheet->setCellValue('C'. 4, 'LI = Late In');
        $sheet->setCellValue('D'. 4, 'EO = Early Out');
        $sheet->setCellValue('E'. 4, 'MP = Miss Punch');
        $sheet->setCellValue('F'. 4, 'WD = Working Days');
        $sheet->setCellValue('G'. 4, 'DW = Days Worked');

        $sheet->setCellValue('A'. 6, 'No');
        $sheet->setCellValue('B'. 6, 'User ID');
        $sheet->setCellValue('C'. 6, 'Name');
        $sheet->setCellValue('D'. 6, 'Total Days');
        $sheet->setCellValue('E'. 6, 'Normal Work');
        $sheet->setCellValue('F'. 6, 'Normal Leave');
        $sheet->setCellValue('G'. 6, 'Normal Absent');
        $sheet->setCellValue('H'. 6, 'Holiday Work');
        $sheet->setCellValue('I'. 6, 'Holiday Absent');
        $sheet->setCellValue('J'. 6, 'Restday Work');
        $sheet->setCellValue('K'. 6, 'Restday Absent');
        $sheet->setCellValue('L'. 6, 'LI');
        $sheet->setCellValue('M'. 6, 'MP');
        $sheet->setCellValue('N'. 6, 'Short');
        $sheet->setCellValue('O'. 6, 'EO');
        $sheet->setCellValue('P'. 6, 'Workday');
        $sheet->setCellValue('Q'. 6, 'OT');
        $sheet->setCellValue('R'. 6, 'Holiday');
        $sheet->setCellValue('S'. 6, 'OT');
        $sheet->setCellValue('T'. 6, 'Restday');
        $sheet->setCellValue('U'. 6, 'OT');

        
        $rows = 6;
        $nullData = 0;
        foreach($employees as $employee){
          
            $rows++;
            $sheet->setCellValue('A' . $rows, $employee->index);
            $sheet->setCellValue('B' . $rows, $employee->employee_no);
            $sheet->setCellValue('C' . $rows, $employee->personname);
            $sheet->setCellValue('D' . $rows, $employee->total_days);
            $sheet->setCellValue('E' . $rows, $employee->wp);
            $sheet->setCellValue('F' . $rows, $employee->leave);
            $sheet->setCellValue('G' . $rows, $employee->absent_days);
            $sheet->setCellValue('H' . $rows, $employee->hp);
            $sheet->setCellValue('I' . $rows, $employee->ha);
            $sheet->setCellValue('J' . $rows, $employee->op);
            $sheet->setCellValue('K' . $rows, $employee->oa);
            $sheet->setCellValue('L' . $rows, $employee->li);
            $sheet->setCellValue('M' . $rows, $employee->mp);
            $sheet->setCellValue('N' . $rows, $employee->short);
            $sheet->setCellValue('O' . $rows, $employee->eo);
            $sheet->setCellValue('P' . $rows, $employee->workday);
            $sheet->setCellValue('Q' . $rows, $employee->workdayOvertimeHours);
            $sheet->setCellValue('R' . $rows, $employee->holydayHours);
            $sheet->setCellValue('S' . $rows, $employee->holydayOvertimeHours);
            $sheet->setCellValue('T' . $rows, $employee->restday);
            $sheet->setCellValue('U' . $rows, $employee->restdayOvertimeHours); 
        }

        $fileName = "employees-attendance-summary.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }
   
    
    public function attendanceSummaryPdf(Request $request)
    {
        
        $type = $request->type;
      
        $url1 = str_replace("length=10","length=-1",session('employees_attendance_summary'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);

        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        $employees = json_decode($response)->data;
        
        $user = User::where('id' , Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $html = html_entity_decode(view('hr.reports.pdf.attendance-summary', compact('employees','companyname', 'type')));//->render();
        $options = new Options();        
        $options->set('isRemoteEnabled', true);          
        $pdf = new Dompdf($options);
        

        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('Employees Attendance summary Report');
        return 1;

    }
    
    
        // user movement
    public function userMovement()
    {
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $devices  = DB::table('devices')->orderBy('devicename', 'asc')->get();
        $emps  = DB::table('user_personal')->select('username', 'employee_no', 'name')->orderBy('name', 'ASC')->get();

        $c_key = 'attendance_movement';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('E-Attendance.user-movement', compact('categories', 'departments', 'branches', 'schedules', 'c_key', 'columnHideShowData', 'devices', 'emps'));
    }
    
    public function userMovementData(Request $req)
    {
        $start_date = Carbon::now()->startOfMonth()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();
        
        session(['employees_movement_data' => $req->getUri()]);
        $user_type = $req->user_type;
        $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
        $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
        $schedule = $req->schedule;
        $day_type = $req->day_type;
        $category = $req->category;
        $branch = $req->branch;
        $device = $req->device;
        $emp = $req->emp;
        $department = $req->department;
        $emp_no = $req->emp_no;
        $in_out_filter = $req->in_out_filter;
        $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave'];
        $diffDate = date_diff(date_create($sdatefrom),date_create($sdateto));
        $totalDays = $diffDate->days;

        $overtimes_emp = 0;
        $overtime = '';

       //
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        //

        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
            
        $attendanceDatad = DB::table(DB::raw('user_personal up'))
            ->select('clk.working_day','up.employee_no', 'up.eattendance_type', 'up.username','up.name','clk.updated_at',
                DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'),
                DB::raw('(GROUP_CONCAT(clk.devicename SEPARATOR \'==\')) AS usedDevice'),
                'user_pay.date_attendance_start')
        
            ->leftJoin(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
            ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
        
            
            $attendanceDatad->where(function($q){
                $q->where('user_pay.date_resigned', NULL)->orWhere('user_pay.date_resigned', '0000-00-00');
            })->where('user_pay.pay_status', 1);
            
           $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');

         
        // filter
        if ($sdatefrom) {
            $attendanceDatad->where('clk.working_day', '>=', $sdatefrom);
        }
        
        if ($sdateto) {
            $attendanceDatad->where('clk.working_day', '<=', $sdateto);
        }   
        if ($schedule) {
            $attendanceDatad->where('up.schedule_id', '=', $schedule);
        }
        if ($day_type && $day_type != '') {
            $attendanceDatad->where('sch.day_type', '=', $day_type);
        }
        if ($category) {
            $attendanceDatad->where('user_pay.category_id', '=', $category);
        }
        if ($branch) {
            $attendanceDatad->where('user_pay.branch_id', '=', $branch);
        }
        if ($device) {
            $attendanceDatad->where('clk.devicename', '=', $device);
        }
        if ($emp) {
            $attendanceDatad->where('up.username', '=', $emp);
        }
        if ($department) {
            $attendanceDatad->where('user_pay.department_id', '=', $department);
        }
        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', 1);
        }
        // // filter


        $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'clk.working_day'])->orderBy('clk.working_day', 'DESC')->orderBy('up.employee_no', 'ASC')->get();
        // dd($attendanceData);


        if (in_array($in_out_filter, $filter_arr)) {
            $filtered = $attendanceData->reject(function ($value, $key) {
                $key++;
                return $value->filter_val != $key;
            });
        } else {
            $filtered = $attendanceData;
        }


        $filtered->map(function ($item, $index) {

            $index++;

            $item->date = date('d-m-Y', strtotime($item->working_day));
            $item->employee_no = $item->employee_no;
            $item->personname  =  $item->name;
            $item->dayname  =  date('D', strtotime($item->working_day));
            
            $movement = explode('==', $item->fulltime);
            $movement = array_map(function ($movement) use($item){
            
                $timeChange1 = DB::table('time_change')->where('employee_no', $item->employee_no)->where('date', $item->working_day)->where('time_from', '!=', NULL)->where('time_to', $movement)->first();
                if(isset($timeChange1->clockin_id)){
                    $timeChange2 = DB::table('time_change')->where('clockin_id', $timeChange1->clockin_id)->first();
                }else{
                    $timeChange2 = NULL;
                }
        
                // dd($timeChange2);
            
                if($timeChange2){
                    return date("H:i", strtotime($timeChange2->time_from));
                }else{
                    return date("H:i", strtotime($movement));
                }
                
            }, $movement);

            $deviceName = explode('==', $item->usedDevice);
            
            $farr = [];
            $deviceName = explode('==', $item->usedDevice);
            for($i=0; $i<count($movement); $i++){
                $farr[($deviceName[$i]??'none').'_'.$i] = $movement[$i];
            }
            asort($farr);
    
            $item->movement = $farr;
            
            return $item;
        });
        
        return DataTables::of($filtered)->make(true);
    }

    public function userMovementExcel(Request $request)
    {
        $url1 = str_replace("length=10","length=-1",session('employees_movement_data'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        //   dd($url);
        ini_set('memory_limit', -1);
          $curl = curl_init();
  
              curl_setopt_array($curl, array(
              CURLOPT_URL => $url."&auth_id=".Auth::id(),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
          ));
  
        $response = curl_exec($curl);

        curl_close($curl);
        
        
        $employees = json_decode($response)->data;
        // dd($employees);
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'User Movement Analysis');
        

        $c_key = 'attendance_movement';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Date", "Day", "Emp No", "Name", "Movement"];

          $startFrom = 65;
          for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 3, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rowss = 4;
        
        foreach($employees as $key=>$employee){
            $data = [];
            foreach($employee->movement as $key=>$movement){
                if(explode('_',$key)[0] == "0000"){
                    $mvmntDevice = "Manual";
                }else{
                    $mvmntDevice = explode('_',$key)[0];
                }
                $mvmnt = $mvmntDevice."-".$movement;
               
                array_push($data, $mvmnt);
            }
            $arrRows = [$employee->date, $employee->dayname, $employee->employee_no, $employee->personname, implode(",", $data)];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rowss, $arrRows[$k]); 
                    $startFrom++;
                }
            }
    
            $rowss++;
        }

        $fileName = "user-movement-analysis.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }
    
    
     public function userMovementPdf(Request $request)
    {
        
        $url1 = str_replace("length=10","length=-1",session('employees_movement_data'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        $employees = json_decode($response)->data;
        $user = User::where('id' , Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'attendance_movement';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Date", "Day", "Emp No", "Name", "Movement"];


        $html = html_entity_decode(view('hr.reports.pdf.user-movement', compact('employees','companyname', 'columnHideShowData', 'c_key', 'arrColumns')));//->render();
        $options = new Options();        
        $options->set('isRemoteEnabled', true);         
        $pdf = new Dompdf($options);
        

        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('User Movements Analysis');
        return 1;

    }
    
    
    // audit Trial
    public function auditTrial()
    {
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();

        $c_key = 'attendance_audit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('E-Attendance.audit-trial', compact('categories', 'departments', 'branches', 'schedules', 'c_key', 'columnHideShowData'));
    }
    
    
    public function auditTrialData(Request $req)
    {
        $start_date = Carbon::now()->startOfMonth()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();
        
        session(['audit_trial' => $req->getUri()]);
        $user_type = $req->user_type;
        $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
        $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
        $schedule = $req->schedule;
        $day_type = $req->day_type;
        $category = $req->category;
        $branch = $req->branch;
        $department = $req->department;
        $emp_no = $req->emp_no;
        $in_out_filter = $req->in_out_filter;
        $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave'];
        $diffDate = date_diff(date_create($sdatefrom),date_create($sdateto));
        $totalDays = $diffDate->days;

        $overtimes_emp = 0;
        $overtime = '';

       //
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        //

        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
      
        $attendanceDatad = DB::table(DB::raw('time_change'))
            ->select('time_change.*', 'user_personal.employee_no', 'user_personal.name')
            ->join('user_personal', 'user_personal.employee_no', '=', 'time_change.employee_no')
            ->join('user_pay', 'user_personal.username', '=', 'user_pay.username');       
        

        // filter
        if ($sdatefrom) {
            $attendanceDatad->whereDate('time_change.created_at', '>=', $sdatefrom);
        }
        
        if ($sdateto) {
            $attendanceDatad->whereDate('time_change.created_at', '<=', $sdateto);
        }
        
        if ($category) {
            $attendanceDatad->where('user_pay.category_id', '=', $category);
        }
        if ($branch) {
            $attendanceDatad->where('user_pay.branch_id', '=', $branch);
        }
        if ($department) {
            $attendanceDatad->where('user_pay.department_id', '=', $department);
        }
        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', 1);
        }
        // // filter


        $attendanceData = $attendanceDatad->orderBy('time_change.id', 'DESC')->get();
        // dd($attendanceData);


        if (in_array($in_out_filter, $filter_arr)) {
            $filtered = $attendanceData->reject(function ($value, $key) {
                $key++;
                return $value->filter_val != $key;
            });
        } else {
            $filtered = $attendanceData;
        }


        $filtered->map(function ($item, $index) {

            $index++;
           if($item->time_from){
                $timeFrom = date("H:i", strtotime($item->time_from));
            }else{
                $timeFrom = "NA";
            }

      

            $item->admin = getUserNameById($item->admin);
            $item->employee_no = $item->employee_no;
            $item->employee  =  $item->name;
            $item->date  =  date("d-m-Y", strtotime($item->date));
            $item->time_from  = $timeFrom;
            $item->time_to  = date("H:i", strtotime($item->time_to));;
            $item->updated_date  =  date("d-m-Y", strtotime($item->created_at));
            $item->updated_time =  date("H:i", strtotime($item->created_at));
            
            
            return $item;
        });
        
        // dd($filtered);
        return DataTables::of($filtered)->make(true);
    }

    public function auditTrialExcel(Request $request)
    {
        $url1 = str_replace("length=10","length=-1",session('audit_trial'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        
        ini_set('memory_limit', -1);
          $curl = curl_init();
  
              curl_setopt_array($curl, array(
              CURLOPT_URL => $url."&auth_id=".Auth::id(),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
          ));

        $response = curl_exec($curl);
        //    dd($response);
        curl_close($curl);
        
        
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'Audit Trial');
          
        
        $sheet->mergeCells('D3:E3')->setCellValue('D'. 3, 'Editted');
        $sheet->mergeCells('F3:G3:H3')->setCellValue('G'. 3, 'Records');
        
        $c_key = 'attendance_audit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Admin", "Emp No", "Employee", "Date", "Time", "Date", "From", "To"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 3, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rowss = 4;
        foreach($employees as $key=>$employee){
            $arrRows = [$employee->admin, $employee->employee_no, $employee->name, $employee->updated_date, $employee->updated_time, $employee->date,$employee->time_from,$employee->time_to];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rowss, $arrRows[$k]); 
                    $startFrom++;
                }
            }
            $rowss++;
        }

        $fileName = "user-movement-analysis.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }
    
    public function auditTrialPdf(Request $request)
    {
        
        $url1 = str_replace("length=10","length=-1",session('audit_trial'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        $employees = json_decode($response)->data;
        $user = User::where('id' , Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'attendance_audit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Admin", "Emp No", "Employee", "Date", "Time", "Date", "From", "To"];

        $html = html_entity_decode(view('hr.reports.pdf.audit-trial', compact('employees','companyname', 'columnHideShowData', 'c_key', 'arrColumns')));//->render();
        $options = new Options();        
        $options->set('isRemoteEnabled', true);          
        $pdf = new Dompdf($options);
        

        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('Audit Trial');
        return 1;

    }
    

    // Attendance sheet
    public function attendanceSheet()
    {   
        $total_days = Carbon::now()->month(date('m'))->daysInMonth;
      
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();

        $leaveNames  = DB::table('leave_name')->get();
        
        $c_key = 'attendance_sheet';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        
        return view('E-Attendance.attendance-sheet', compact('categories', 'departments', 'branches', 'schedules', 'total_days', 'leaveNames', 'c_key', 'columnHideShowData'));
    }
    
    public function attendanceSheetData(Request $req)
    {
        
        $start_date = Carbon::now()->startOfMonth()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();    

        
        session(['employees_attendance_sheet' => $req->getUri()]);
        $user_type = $req->user_type;
        $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
        $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
        $schedule = $req->schedule;
        $day_type = $req->day_type;
        $category = $req->category;
        $branch = $req->branch;
        $department = $req->department;
        $emp_no = $req->emp_no;
        $in_out_filter = $req->in_out_filter;
        $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave'];
        $diffDate = date_diff(date_create($sdatefrom),date_create($sdateto));
        $totalDays = $diffDate->days;
        
        // dd(date('m', strtotime($sdatefrom)));
        $total_days = Carbon::now()->month(date('m', strtotime($sdatefrom)))->daysInMonth;
        
        $overtimes_emp = 0;
        $overtime = '';

       //
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        //

        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
        
        $qry = '';
        for ($i = 0; $i < count($dateRange); $i++) {
            $alldate = $dates[$i]->format('Y-m-d');
                $qry .= 'select cast(\'' . $alldate . '\' as date) as dte ';

                if ($i < (count($dateRange) - 1)) {
                    $qry .= 'union ';
                }
        }
        
        if($sdatefrom == $sdateto){
            $qry = $qry .'union '. $qry;
        }
      
        $attendanceDatad = DB::table(DB::raw('(' . $qry . ') dates'))
            ->select('dates.dte', 'leave_list.no_days', 'leave_list.type as leave_type','duty_roaster_dates.holiday_id','duty_roaster_dates.day_type as r_day_type', 'public_holiday.description', 'sch.*', 'up.employee_no', 'up.eattendance_type', 'up.username','up.name','clk.updated_at', DB::raw('(SELECT GROUP_CONCAT(TIME SEPARATOR \'==\') FROM clockin WHERE employee_no = up.employee_no AND working_day = dte GROUP BY working_day) AS fulltime'), 'user_pay.date_attendance_start', 'user_pay.branch_id', 'user_pay.date_resigned')
            ->crossJoin(DB::raw('user_personal up'))
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
            
            $attendanceDatad->leftJoin(DB::raw('clockin clk'), function ($data) {
                $data->on('up.employee_no', '=', 'clk.employee_no')
                    ->whereRaw('clk.working_day = dte');
            });
            
            // roster
            $attendanceDatad->join(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->whereRaw('duty_roaster_dates.date = dte');
            });
            
            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            });

            // $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
            //     $joinss->on(DB::raw('(CASE WHEN up.eattendance_type = "duty_roaster" THEN duty_roaster_dates.schedule_id ELSE up.schedule_id END)') , '=', 'sch.schedule_id')
            //         ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            // });

            
            $attendanceDatad->leftJoin(DB::raw('public_holiday'), function ($joins) {
                $joins->on('public_holiday.id', '=', 'duty_roaster_dates.holiday_id');
            });
           
            
            $attendanceDatad->leftJoin(DB::raw('leave_list'), function ($joins) {
                $joins->on('up.username', '=', 'leave_list.username')
                    ->whereRaw('leave_list.start_date = dte')
                    ->where('leave_list.status', 1);
            });
            
            $attendanceDatad->leftjoin('user_pay', 'user_pay.username', '=', 'up.username');
            
            $attendanceDatad->where(function($q){
                $q->where('user_pay.date_resigned', NULL)->orWhere('user_pay.date_resigned', '0000-00-00');
            })->where('user_pay.pay_status', 1);
            
    
            $attendanceDatad->whereRaw('dte >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');

        // filter
        if ($sdatefrom) {
            $attendanceDatad->where('dates.dte', '>=', $sdatefrom);
        }
        
        if ($sdateto) {
            $attendanceDatad->where('dates.dte', '<=', $sdateto);
        }
        if ($schedule) {
            $attendanceDatad->where('up.schedule_id', '=', $schedule);
        }
   
        if ($day_type && $day_type != '' && $day_type == 'Work') {
            $attendanceDatad->where('duty_roaster_dates.day_type', '=', "SCHEDULE");
        }
  
        if ($day_type && $day_type != '' && $day_type == 'PH') {
            $attendanceDatad->where('duty_roaster_dates.day_type', '=', "HOLIDAY");
        }

        if ($day_type && $day_type != '' && $day_type == 'Rest') {
            $attendanceDatad->where('duty_roaster_dates.day_type', '=', "RESTDAY");
        }
        if ($category) {
            $attendanceDatad->where('user_pay.category_id', '=', $category);
        }
        if ($branch) {
            $attendanceDatad->where('user_pay.branch_id', '=', $branch);
        }
        if ($department) {
            $attendanceDatad->where('user_pay.department_id', '=', $department);
        }
        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', 1);
        }
        // // filter


        $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'dates.dte'])->orderBy('dates.dte', 'DESC')->orderBy('up.employee_no', 'ASC')->get();
        //dd($attendanceData[0]);
        

        if (in_array($in_out_filter, $filter_arr)) {
            $filtered = $attendanceData->reject(function ($value, $key) {
                $key++;
                return $value->filter_val != $key;
            });
        } else {
            $filtered = $attendanceData;
        }
        // dd($filtered);

        $filtered->map(function ($item, $index) {
            
            if(isset($item->schedule_id) && ($item->schedule_id) != null){
                $schedule_name = getScheduleName($item->schedule_id);
            }else{
                $schedule_name = $item->description;
            }

            $index++;
            $item->index = $index;
            $item->date = date('d-m-Y', strtotime($item->dte));
            $item->working_day = $item->dte;
            $item->employee_no = $item->employee_no;
            $item->no_days = $item->no_days;
            $item->personname  =  $item->name;
     
            return $item;
        });
        // dd($filtered);

        $finalDatas = json_decode(json_encode($filtered), true);

        $check = [];
        $finalReport = [];
        
        // dd($finalDatas);
        foreach($finalDatas as $finalData){
            if(!isset($check[$finalData['employee_no']])){
                
                $pre = array_filter($finalDatas, function($value) use($finalData){
                    return $value['employee_no'] == $finalData['employee_no'] && $value['fulltime'] != NULL;
                });

                $entry_time = $finalData['entry'];
                $break_time = $finalData['break'];
                $resume_time = $finalData['user_resume'];
                $leave_time = $finalData['user_leave'];
                $schedule_range = $finalData['schedule_range'];
                $flexi_lunch = $finalData['flexi_lunch'];
                $min_ot = $finalData['min_ot'];
                $min_flexi_hour = $finalData['min_flexi_hour'];


                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));

                    $resAt = [];
                    $leave = 0;
                    foreach($finalDatas as $atData){
                        $intime = '';
                        $break = '';
                        $resume = '';
                        $out_time = '';

                        if($atData['employee_no'] == $finalData['employee_no']){
                        
                            $temp = date("j-F", strtotime($atData['dte']));
                            $start_from = date("j", strtotime($atData['dte']));
                            
                            if($atData['fulltime']){
                                $timeArray = explode('==', $atData['fulltime']);
                                
                                $timeArrayData = array_map(function ($timeArrayVal){
                                    return date("H:i", strtotime($timeArrayVal));
                                }, $timeArray);

                                
                                $total_fultime = count($timeArrayData);

                                for ($a = 0; $a < $total_fultime; $a++) {
                                    $emp_time = $timeArrayData[$a];

                                    // entry time
                                    if ($atData['day_type'] == 'Work') {
                                     
                                        if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                            $intime = $emp_time;
                                        }
                                  
                                        // break_times
                                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                            $break = $emp_time;
                                            
                                        }
                                        
                                        //   resume_time
                                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                            $resume = $emp_time;
                                            
                                        } else {
                                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                                $resume = $emp_time;
                                                
                                            }
                                        }

                                        //   out
                                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                            $out_time = $emp_time;
                                            
                                        }
                                        
                                    }elseif ($atData['day_type'] == 'Flexi') {
                                        
                                        if ($a == '0') {
                                            $intime = $emp_time;
                                            
                                        } elseif ($a == ($total_fultime - 1)) {
                                            $out_time = $emp_time;
                                            
                                        } elseif ($a == '1') {
                                            $break = $emp_time;
                                            
                                        } elseif ($a == '2') {
                                            $resume = $emp_time;
                                            
                                        }
                                    }
                                }
                                $clkData = [
                                    0 => $intime, 
                                    1 => $break, 
                                    2 => $resume, 
                                    3 => $out_time, 
                                ];

                
                                $resAt[$temp] = implode(" ", $clkData);
                            


                            }elseif($atData['r_day_type'] == "RESTDAY"){
                                $resAt[$temp] = "R";
                            }elseif($atData['holiday_id'] != null){
                                $resAt[$temp] = "H";
                            }
                            elseif($atData['leave_type'] != null){
                               
                                $leave += $atData['no_days'];
                                $lName = $atData['leave_type'];
                                
                                switch ($lName) {
                                    
                                    case "Annual":
                                        $resAt[$temp] = "AL";
                                        break;
                                    case "Medical":
                                        $resAt[$temp] = "MC";
                                        break;
                                    case "Maternity":
                                        $resAt[$temp] = "MT";
                                        break;
                                    case "Marriage":
                                        $resAt[$temp] = "MR";
                                        break;
                                    case "Compassionate":
                                        $resAt[$temp] = "CL";
                                        break;
                                    case "Hospital":
                                        $resAt[$temp] = "HL";
                                        break;
                                    case "Examination":
                                        $resAt[$temp] = "EX";
                                        break;
                                    case "Paternity":
                                        $resAt[$temp] = "PT";
                                        break;
                                    case "Advance":
                                        $resAt[$temp] = "AD";
                                        break;
                                    case "Other_pay":
                                        $resAt[$temp] = "RL";
                                        break;
                                    case "Line_Shut":
                                        $resAt[$temp] = "LS";
                                        break;
                                    case "Absent":
                                        $resAt[$temp] = "AB";
                                        break;
                                    case "Emergency":
                                        $resAt[$temp] = "EL";
                                        break;
                                    case "NPL":
                                        $resAt[$temp] = "NPL";
                                        break;
                                    default:
                                        $resAt[$temp] = " ";
                                }
                            }
                            else{
                                $resAt[$temp] = "AB";
                            }
                        }
                    }

                
                $sche = array_filter($finalDatas, function($value) use($finalData){
                    return $value['employee_no'] == $finalData['employee_no'] && $value['schedule_id'] != NULL;
                });


                // workday present
                $wp = array_filter($pre, function($value) use($finalData){
                    return $value['day_type'] == 'Work';
                });
                $fwp = array_filter($pre, function($value) use($finalData){
                    return $value['day_type'] == 'Flexi';
                });


                // rest day present
                $op = array_filter($pre, function($value) use($finalData){
                    return $value['day_type'] == 'Rest';
                });
                
                // overtime present
                $overtimes_emp = 0;
                $late_emp = 0;
                $early_dep = 0;
                $mp = 0;
                $perfect = 0;

                $workdayHours = 0;
                $restdayHours = 0;
                $eoHours = 0;
                $liHours = 0;
                
                $workdayOvertimeHours = 0;
                $restdayOvertimeHours = 0;
                $holydayHours = 0;
                $holydayOvertimeHours = 0;
                $out_time = 0;
                $hp = 0;

                
                foreach($pre as $value){
                    $fulltime = explode('==', $value['fulltime']);
                    $entry_time = $value['entry'];
                    $break_time = $value['break'];
                    $resume_time = $value['user_resume'];
                    $leave_time = $value['user_leave'];
                    $schedule_range = $value['schedule_range'];
                    $flexi_lunch = $value['flexi_lunch'];
                    $min_ot = $value['min_ot'];
                    $min_flexi_hour = $value['min_flexi_hour'];
                    
                    $entry_range_before = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($entry_time)));
                    $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                    $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                    $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                    
                    // holiday present count
                    $hpc = DB::table('public_holiday')->where('branch_id',$value['branch_id'])->where('date', date("Y-m-d", strtotime($value['date'])))->first();
                    if($hpc){
                        $hp += 1;
                    }
                   
                    $intime = '';
                    $break = '';
                    $resume = '';

                    sort($fulltime);


                    $total_fultime = count($fulltime);

                    // miss punch count
                    if($total_fultime %3 == 0){
                        $mp += 1; 
                    }

                    
                    for ($a = 0; $a < $total_fultime; $a++) {
                        
                        $emp_time = $fulltime[$a];

                        


                         //   out
                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                            $out_time = $emp_time;
                        }

                        // holiday present hour
                        if($hpc){
                            if(isset($fulltime[$a+1])){
                                $next_clk = $fulltime[$a+1];
                                $current_clk =  $fulltime[$a];
                                //$holydayHours = date('H:i', strtotime($holydayHours) + (strtotime($next_clk) - strtotime($current_clk)));
                                $holydayHours = second_to_hhmm(explode_time($holydayHours) + explode_time($next_clk) - explode_time($current_clk));
                            }
                            if (strtotime($out_time) >= strtotime($min_ot_range) && strtotime($min_ot_range) != strtotime("00:00")) {
                                $holydayOvertimeHours = second_to_hhmm(explode_time($holydayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                            }
                        }
                        // entry time
                        if ($value['day_type'] == 'Work') {
                            // workday hour
                            if(isset($fulltime[$a+1])){
                                $next_clk = $fulltime[$a+1];
                                $current_clk =  $fulltime[$a];
                                //$workdayHours = date('H:i', strtotime($workdayHours) + (strtotime($next_clk) - strtotime($current_clk)));
                                $workdayHours = second_to_hhmm(explode_time($workdayHours) + explode_time($next_clk) - explode_time($current_clk));
                            }
                            if (strtotime($out_time) >= strtotime($min_ot_range)) {
                                $workdayOvertimeHours = second_to_hhmm(explode_time($workdayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                            }

                            

                            if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                $intime = $emp_time;
                                continue;
                            }


                            // break_times

                            if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                $break = $emp_time;
                                continue;
                            }


                            //   resume_time
                            if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                $resume = $emp_time;
                                continue;
                            } else {
                                if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                    $resume = $emp_time;
                                    continue;
                                }
                            }
                           
                        } elseif ($value['day_type'] == 'Flexi') {

                            // workday hour
                            if(isset($fulltime[$a+1])){
                                $next_clk = $fulltime[$a+1];
                                $current_clk =  $fulltime[$a];
                                $workdayHours = second_to_hhmm(explode_time($workdayHours) + explode_time($next_clk) - explode_time($current_clk));
                            }
                 
                            if (strtotime($out_time) >= strtotime($min_ot_range)) {
                                 $workdayOvertimeHours = second_to_hhmm(explode_time($workdayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                            }
                            
                            if ($a == '0') {
                                $intime = $emp_time;
                                continue;
                            } elseif ($a == ($total_fultime - 1)) {
                                $out_time = $emp_time;
                                continue;
                            } elseif ($a == '1') {
                                $break = $emp_time;
                                continue;
                            } elseif ($a == '2') {
                                $resume = $emp_time;
                                continue;
                            }
                        }else{
                            // restday hour
                            if(isset($fulltime[$a+1])){
                                $next_clk = $fulltime[$a+1];
                                $current_clk =  $fulltime[$a];
                                $restdayHours = second_to_hhmm(explode_time($restdayHours) + explode_time($next_clk) - explode_time($current_clk));
                            }

                            if (strtotime($out_time) >= strtotime($min_ot_range)) {
                                $restdayOvertimeHours = second_to_hhmm(explode_time($restdayOvertimeHours) + explode_time($out_time) - explode_time($leave_time));
                            }
                        }

                        // perfect
                        if(strtotime($intime) >= strtotime($entry_range_before) && strtotime($intime) <= strtotime($entry_range)){
                            $perfect += 1;
                        }
                    }


                    $lunch_text_color = $in_text_color = $leave_text_color = 'black';
                    $emp_lunch = (strtotime($resume) - strtotime($break));
                    if (($emp_lunch >= ($flexi_lunch * 60) && $emp_lunch > 0)) {
                        $lunch_text_color = "red";
                    }
                    if (strtotime($intime) > strtotime($entry_time)) {
                        $in_text_color = "red";
                    }
                    if (strtotime($out_time) < strtotime($leave_time)) {
                        $leave_text_color = "red";
                    }

                    if($value['day_type'] == NULL){
                        $value['day_type'] = $value['r_day_type'];
                    }

                    // overtime
                    // dd(strtotime($min_ot_range));
                    if (strtotime($out_time) >= strtotime($min_ot_range)) {
                        $overtimes_emp += 1;
                    }

                    if (strtotime($intime) > strtotime($entry_range)) {
                        $late_emp += 1;
                        $liHours = second_to_hhmm(explode_time($liHours) + explode_time($intime) - explode_time($entry_time));
                        
                    } elseif (!$intime && $break) {
                        $late_emp += 1;
                    } elseif (!$intime && !$break && $resume) {
                        $late_emp += 1;
                    } elseif (!$intime && !$break && !$resume && $out_time) {
                        $late_emp += 1;
                    }
                    
                    
                    if ((strtotime($out_time) < strtotime($leave_time)) && $out_time) {
                        $eoHours = second_to_hhmm(explode_time($eoHours) + explode_time($leave_time) - explode_time($out_time));
                        $early_dep += 1;
                    }

                }
        
                    // count
                    $finalData['start_from'] = $start_from;
                    $finalData['start_date'] = $sdatefrom;
                    $finalData['end_date'] = $sdateto;
                    $finalData['today'] = date("Y-m-d");

                    $finalData['total_days'] = $totalDays;
                    $finalData['present_days']=count($pre);
                    $finalData['absent_days'] = $totalDays-count($pre);
                    if($totalDays){
                        $finalData['workrate'] = round(((count($pre))*100)/$totalDays, 2);
                   }else{
                       $finalData['workrate'] = 0;
                   }

                $finalData['att'] = $resAt;
    
                $finalData['workday'] = second_to_hhmm(explode_time($workdayHours) + explode_time($restdayHours));
                $finalData['overtime'] = second_to_hhmm(explode_time($workdayOvertimeHours));
                $finalData['leave'] = $leave;
                $finalData['short'] = second_to_hhmm(explode_time($liHours) + explode_time($eoHours));
                $finalData['date_from'] = $sdatefrom;
                $finalData['date_to'] = $sdateto;

                $finalReport[] =$finalData;
                $check[$finalData['employee_no']]='1';
            }
        }
        //    die();
        // dd($finalReport);
        
        return DataTables::of($finalReport)->make(true);
    }

    public function attendanceSheetExcel(Request $request)
    {
        $leaveNames  = DB::table('leave_name')->get();
        
        $url1 = str_replace("length=10","length=-1",session('employees_attendance_sheet'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        
        ini_set('memory_limit', -1);
          $curl = curl_init();
              curl_setopt_array($curl, array(
              CURLOPT_URL => $url."&auth_id=".Auth::id(),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
          ));

        $response = curl_exec($curl);
           
        curl_close($curl);
        
        
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'Attendance Sheet');

        $sheet->setCellValue('A'. 3, '√ = Present');
        $sheet->setCellValue('B'. 3, 'L1 = WFH');
        $sheet->setCellValue('C'. 3, 'R = Restday');
        $sheet->setCellValue('D'. 3, 'H = Holiday');


        $sheet->setCellValue("A". 4, 'AL=Annual');
        $sheet->setCellValue("B". 4, 'MC=Medical');
        $sheet->setCellValue("C". 4, 'MT = Maternity');
        $sheet->setCellValue("D". 4, 'MR = Marriage ');
        $sheet->setCellValue("E". 4, 'CL = Compassionate');
        $sheet->setCellValue("F". 4, 'HL = Hospital');
        $sheet->setCellValue("G". 4, 'EX = Examination ');

        $sheet->setCellValue("A". 5, 'PT = Paternity');
        $sheet->setCellValue("B". 5, 'AD = Advance');
        $sheet->setCellValue("C". 5, 'RL = Replacement');
        $sheet->setCellValue("D". 5, 'LS = Out Of Office');
        $sheet->setCellValue("E". 5, 'AB = Absent');
        $sheet->setCellValue("F". 5, 'NPL = NPL');
        $sheet->setCellValue("G". 5, 'EL = Emergency');

        

        $rows = 7;
        $sheet->setCellValue('A'. $rows, 'User ID');
        $sheet->setCellValue('B'. $rows, 'Work');
        $sheet->setCellValue('C'. $rows, 'Leave');
        $sheet->setCellValue('D'. $rows, 'Name');
        $sheet->setCellValue('E'. $rows, 'Overtime');
        $sheet->setCellValue('F'. $rows, 'Short');
        
        $char = 71;
        $secondChar = 65;
        
        for($i=1;$i<=31;$i++){
            if($char <= 90){
                $sheet->setCellValue(chr($char). $rows, $i);
                $char++;
            }else{
                $sheet->setCellValue('A'.chr($secondChar). $rows, $i);
                $secondChar++;
            }
        }

        foreach($employees as $employee){
            $rows++;
            $sheet->setCellValue('A' . $rows, $employee->employee_no);
            $sheet->setCellValue('B' . $rows, $employee->workday);
            $sheet->setCellValue('C' . $rows, $employee->leave);
            $sheet->setCellValue('D' . $rows, $employee->personname);
            $sheet->setCellValue('E' . $rows, $employee->overtime);
            $sheet->setCellValue('F' . $rows, $employee->short);
            
            $char = 71;
            $secondChar = 65;
            
            foreach($employee->att as $att){
                
                if($char <= 90){
                    $sheet->setCellValue(chr($char). $rows, $att);
                    $char++;
                }else{
                    $sheet->setCellValue('A'.chr($secondChar). $rows, $att);
                    $secondChar++;
                }   
            }

        }

        $fileName = "attendance-sheet.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }

    public function attendanceSheetPdf(Request $request)
    {
        
        $url1 = str_replace("length=10","length=-1",session('employees_attendance_sheet'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        $employees = json_decode($response)->data;
        $user = User::where('id' , Auth::id())->first();

        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $total_days = Carbon::now()->month(date('m'))->daysInMonth;
        $leaveNames  = DB::table('leave_name')->get();

        $html = html_entity_decode(view('hr.reports.pdf.attendance-sheet', compact('employees','companyname', 'total_days', 'leaveNames')));//->render();
        $options = new Options();        
        $options->set('isRemoteEnabled', true);          
        $pdf = new Dompdf($options);
        

        $pdf->loadHtml($html);
        $pdf->setPaper('A2', 'landscape');
        $pdf->render();
        $pdf->stream('Attendance Sheet');
        return 1;

    }
    
        // time card
    public function timeCard()
    {   
        $total_days = Carbon::now()->month(date('m'))->daysInMonth;
        
      
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        
        return view('E-Attendance.electronic-time-card', compact('categories', 'departments', 'branches', 'schedules', 'total_days'));
    }

    public function viewTimeCard(Request $request){
       
        // $userList = $request->user_list;
        $pageData = $this->timeCardData($request);
        $pageData = $pageData->original['data'];
        session(['electronic_time_card' => $request->getUri()]);
        $leaveNames  = DB::table('leave_name')->get();


        $total_days = Carbon::now()->month(date('m'))->daysInMonth;
        $user = User::where('id', Auth::id())->first();
        $schedules =  Schedule::select('id', 'name')->get();
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        
        return view('E-Attendance.time-card', compact('pageData', 'categories', 'departments', 'branches', 'schedules', 'total_days', 'leaveNames'));
    }
    
    
    public function timeCardData(Request $req)
    {
        
        $start_date = Carbon::now()->startOfMonth()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();    
        $user_list = $req->user_list;
        // dd($user_list);
        session(['electronic_time_card' => $req->getUri()]);
        $user_type = $req->user_type;
        $sdatefrom = ($req->sdatefrom) ? $req->sdatefrom : $start_date;
        $sdateto = ($req->sdateto) ? $req->sdateto : $current_date;
        $schedule = $req->schedule;
        $day_type = $req->day_type;
        $category = $req->category;
        $branch = $req->branch;
        $department = $req->department;
        $emp_no = $req->emp_no;
        $in_out_filter = $req->in_out_filter;
        $filter_arr = ['no_in_out', 'no_lunch', 'over_lunch', 'late_in', 'early_out', 'overtime', 'on_leave'];
        $diffDate = date_diff(date_create($sdatefrom),date_create($sdateto));
        $totalDays = $diffDate->days;
        
        // dd(date('m', strtotime($sdatefrom)));
        $total_days = Carbon::now()->month(date('m', strtotime($sdatefrom)))->daysInMonth;
        
        $overtimes_emp = 0;
        $overtime = '';

        //
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        //

        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
        
        $qry = '';
        for ($i = 0; $i < count($dateRange); $i++) {
            $alldate = $dates[$i]->format('Y-m-d');
                $qry .= 'select cast(\'' . $alldate . '\' as date) as dte ';

                if ($i < (count($dateRange) - 1)) {
                    $qry .= 'union ';
                }
        }
        
        if($sdatefrom == $sdateto){
            $qry = $qry .'union '. $qry;
        }
        
        $attendanceDatad = DB::table(DB::raw('(' . $qry . ') dates'))
            ->select('dates.dte', 'leave_list.no_days', 'leave_list.type as leave_type', 'leave_list.reason','duty_roaster_dates.holiday_id','duty_roaster_dates.day_type as r_day_type', 'public_holiday.description', 'sch.*', 'up.employee_no', 'up.eattendance_type', 'up.username','up.name','clk.updated_at', DB::raw('(SELECT GROUP_CONCAT(TIME SEPARATOR \'==\') FROM clockin WHERE employee_no = up.employee_no AND working_day = dte GROUP BY working_day) AS fulltime'), 'user_pay.date_attendance_start', 'user_pay.branch_id', 'user_pay.date_resigned')
            ->crossJoin(DB::raw('user_personal up'))
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
            
            $attendanceDatad->leftJoin(DB::raw('clockin clk'), function ($data) {
                $data->on('up.employee_no', '=', 'clk.employee_no')
                    ->whereRaw('clk.working_day = dte');
            });
            
            // roster
            $attendanceDatad->join(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->whereRaw('duty_roaster_dates.date = dte');
            });
            
            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            });

            // $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
            //     $joinss->on(DB::raw('(CASE WHEN up.eattendance_type = "duty_roaster" THEN duty_roaster_dates.schedule_id ELSE up.schedule_id END)') , '=', 'sch.schedule_id')
            //         ->whereRaw('sch.week_day = date_format(dte,\'%a\')');
            // });

            
            $attendanceDatad->leftJoin(DB::raw('public_holiday'), function ($joins) {
                $joins->on('public_holiday.id', '=', 'duty_roaster_dates.holiday_id');
            });
            
            
            $attendanceDatad->leftJoin(DB::raw('leave_list'), function ($joins) use($sdatefrom, $sdateto) {
                $joins->on('up.username', '=', 'leave_list.username')
                    ->where('leave_list.start_date', '>=', $sdatefrom)->where('leave_list.end_date', '<=', $sdateto)->where('leave_list.status', 1)->where('leave_list.username', 'up.username');
            });
            
            $attendanceDatad->leftjoin('user_pay', 'user_pay.username', '=', 'up.username');

            
            $attendanceDatad->where(function($q){
                $q->where('user_pay.date_resigned', NULL)->orWhere('user_pay.date_resigned', '0000-00-00');
            })->where('user_pay.pay_status', 1);
            
    
            $attendanceDatad->whereRaw('dte >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
            
            if($user_list){
                $attendanceDatad->whereIn('up.employee_no', $user_list);
            }

        // filter
        if ($sdatefrom) {
            $attendanceDatad->where('dates.dte', '>=', $sdatefrom);
        }
        
        if ($sdateto) {
            $attendanceDatad->where('dates.dte', '<=', $sdateto);
        }
        if ($schedule) {
            $attendanceDatad->where('up.schedule_id', '=', $schedule);
        }
        if ($day_type && $day_type != '') {
            $attendanceDatad->where('sch.day_type', '=', $day_type);
        }
        if ($category) {
            $attendanceDatad->where('user_pay.category_id', '=', $category);
        }
        if ($branch) {
            $attendanceDatad->where('user_pay.branch_id', '=', $branch);
        }
        if ($department) {
            $attendanceDatad->where('user_pay.department_id', '=', $department);
        }
        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', 1);
        }
        // // filter


        $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'dates.dte'])->orderBy('dates.dte', 'ASC')->orderBy('up.employee_no', 'ASC')->get();
        // dd($attendanceData);


        if (in_array($in_out_filter, $filter_arr)) {
            $filtered = $attendanceData->reject(function ($value, $key) {
                $key++;
                return $value->filter_val != $key;
            });
        } else {
            $filtered = $attendanceData;
        }


        $filtered->map(function ($item, $index) {
        
            $index++;
            $item->index = $index;
            $item->date = date('d-m-Y', strtotime($item->dte));
            $item->working_day = $item->dte;
            $item->employee_no = $item->employee_no;
            $item->no_days = $item->no_days;
            $item->personname  =  $item->name;
         
            return $item;
        });
        // dd($filtered);

        $finalDatas = json_decode(json_encode($filtered), true);

        $check = [];
        $finalReport = [];

        foreach($finalDatas as $finalData){
            if(!isset($check[$finalData['employee_no']])){
                
                // overtime present
                $overtimes_emp = 0;
                $late_emp = 0;
                $early_dep = 0;
                $mp = 0;
                $leave = 0;
                $perfect = 0;
                $leave += $finalData['no_days'];

                $workdayHours = 0;
                $restdayHours = 0;
                $eoHours = 0;
                $liHours = 0;
                
                $workdayOvertimeHours = 0;
                $restdayOvertimeHours = 0;
                $holydayHours = 0;
                $holydayOvertimeHours = 0;
                $out_time = 0;
                $hp = 0;

                    $resAt = [];
                    foreach($finalDatas as $atData){
                        
                        if($atData['employee_no'] == $finalData['employee_no']){
                            
                            $user_schedule = $atData['schedule_id'];
                            $entry_time = $atData['entry'];
                            $break_time = $atData['break'];
                            $resume_time = $atData['user_resume'];
                            $leave_time = $atData['user_leave'];
                            $schedule_range = $atData['schedule_range'];
                            $flexi_lunch = $atData['flexi_lunch'];
                            $min_ot = $atData['min_ot'];
                            $min_flexi_hour = $atData['min_flexi_hour'];
        
                            $entry_range_before = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($entry_time)));
                            $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                            $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                            $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                            $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                            $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                            
                            $intime = '';
                            $break = '';
                            $resume = '';
                            $out_time = '';
                                                
                            $temp = date("j", strtotime($atData['dte']));
                            $resAt[$temp] = [];
                            $clkTime = explode('==', $atData['fulltime']);

                            $clkTime = array_map(function ($clkTime){
                                return date("H:i", strtotime($clkTime));
                            }, $clkTime);

                            sort($clkTime);

                            
                            $earlyOutData = 0;
                            $lateData = 0;
                            $overtimeData = '';
                            $workData = 0;
     
                                
                                for ($a = 0; $a < count($clkTime); $a++) {
                                    
                                    $emp_time = $clkTime[$a];
                    
                                        // entry time
                                    if ($atData['day_type'] == 'Work') {
                                        if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                            $intime = $emp_time;
                                        }
                    
                    
                                        // break_times
                                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                            $break = $emp_time;
                                        }
                    
                    
                                        //   resume_time
                                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                            $resume = $emp_time;
                                        } else {
                                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                                $resume = $emp_time;
                                            }
                                        }
                    
                    
                                        //   out
                                        if ($a == (count($clkTime) - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                            $out_time = $emp_time;
                                        }
                                        
                                        $atData['day_type'] = "Work";
                                        
                                        
                                    } elseif ($atData['day_type'] == 'Flexi') {
                                        if ($a == '0') {
                                            $intime = $emp_time;
                                        } elseif ($a == (count($clkTime) - 1)) {
                                            $out_time = $emp_time;
                                        } elseif ($a == '1') {
                                            $break = $emp_time;
                                        } elseif ($a == '2') {
                                            $resume = $emp_time;
                                        }
                                    }else{
                                        if($user_schedule && $break_range_min != "00:00" && $resume_range_min != "00:00" && $resume_range_max != "00:00" && $min_ot_range != "00:00"){
                                            if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                                $intime = $emp_time;
                                                
                                            }
                                    
                                            // break_times
                                            if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                                $break = $emp_time;
                                                
                                            }
                    
                                            //   resume_time
                                            if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                                $resume = $emp_time;
                                                
                                            } else {
                                                if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                                    $resume = $emp_time;
                                                    
                                                }
                                            }
                    
                                            //   out
                                            if (strtotime($emp_time) > strtotime($resume_range_max)) {
                                                $out_time = $emp_time;
                                            }
                                            $atData['day_type'] = "Rest";

                                            // restday hour
                                            if(isset($clkTime[$a+1])){
                                                $next_clk = $clkTime[$a+1];
                                                $current_clk =  $clkTime[$a];
                                                $restdayHours = date('H:i', strtotime($restdayHours) + (strtotime($next_clk) - strtotime($current_clk)));
                                                $atData['day_type'] = "Flexi";
                                            }
                                    
                                            if (strtotime($out_time) > strtotime($min_ot_range)) {
                                                $restdayOvertimeHours =  date('H:i', strtotime($restdayOvertimeHours) + strtotime($out_time) - strtotime($leave_time));
                                            }
                                            
                                        }elseif($atData['holiday_id'] !== "null"){

                                            if(isset($clkTime)){

                                                if(count($clkTime) > 1){
                                                    $intime = $clkTime[0];
                                                    $out_time = end($clkTime);
                                                }else{
                                                    $intime = $clkTime[0];
                                                }

                                                $otIn = $clkTime[0];
                                                $otOut = end($clkTime);
                                           
                                                $restdayHours = date('H:i', strtotime($restdayHours) + (strtotime($otOut) - strtotime($otIn)));
                                 
                                                if(strtotime(date('H:i', (strtotime($otOut) - strtotime($otIn)))) > strtotime(date("H:i", strtotime("08:00")))){
                                                    $restdayOvertimeHours =  date('H:i', strtotime($restdayOvertimeHours) + (strtotime($otOut) - strtotime($otIn)) - strtotime("08:00"));
                                                    $atData['day_type'] = "Flexi";
                                                }
                                            }
                                            
                                            $atData['day_type'] = "Rest";
                                        }
                                    }
                                    
                                    
                                }
                                
                                if(strtotime($intime) && strtotime($out_time)){
                                    $workData = date('H:i', (strtotime($out_time) - strtotime($intime)));   
                                }else{
                                    $workData = date('H:i', (strtotime(end($clkTime)) - strtotime($clkTime[0]))); 
                                }
                            
                                if(strtotime($intime) > strtotime($entry_range)){
                                    $lateData = date('H:i', strtotime($intime) - strtotime($entry_range));
                                }

                                if(date('H:i', strtotime($intime)) != "00:00" && date('H:i', strtotime($out_time)) != "00:00" && strtotime($leave_time) > strtotime($out_time)){
                                    $earlyOutData = date('H:i', strtotime($leave_time) - strtotime($out_time));
                                }
                                
                                if(strtotime($out_time)>strtotime($min_ot_range)){
                                    $overtimeData = date('H:i', strtotime($out_time) - strtotime($leave_time));
                                }
                               
                                $shortData = date('H:i', (strtotime($lateData) + strtotime($earlyOutData)));
                                
                                if($intime == "00:00"){
                                    $resAt[$temp]['in_time'] = NULL;
                                }else{
                                    $resAt[$temp]['in_time'] = $intime;
                                }
                                
                                $resAt[$temp]['break_time'] = $break;
                                $resAt[$temp]['resume_time'] = $resume;
                                $resAt[$temp]['out_time'] = $out_time;

                                $resAt[$temp]['date'] = $atData['dte'];
                                $resAt[$temp]['day_type'] = $atData['day_type'];

                                if(isset($atData['schedule_id']) && ($atData['schedule_id']) != null){
                                    $schedule_name = getScheduleName($atData['schedule_id']);
                                }else{
                                    $schedule_name = $atData['description'];
                                }

                                $resAt[$temp]['sche'] = $schedule_name;
                                
                                $resAt[$temp]['short'] = $shortData;
                                
                               
                                if($intime == "00:00"){
                                    $resAt[$temp]['work'] = NULL;
                                }else{
                                    $resAt[$temp]['work'] = $workData;
                                }
                                
                                $resAt[$temp]['overtime'] = $overtimeData;

                            $leaveList = DB::table('leave_list')->where('start_date', '>=', $atData['dte'])->where('end_date', '<=', $atData['dte'])->where('status', 1)->where('username', $atData['username'])->first();
                            if($leaveList){
                                $resAt[$temp]['leave_taken'] = $leaveList->type;
                                $resAt[$temp]['remark'] = $leaveList->reason;
                            }

                        }
                    }
        

                $finalData['start_date'] = $sdatefrom;
                $finalData['end_date'] = $sdateto;
    
                $finalData['att'] = $resAt;
                $finalReport[] =$finalData;
                $check[$finalData['employee_no']]='1';
            }
        }

        //  dd($finalReport);
        
        return DataTables::of($finalReport)->make(true);
    }

    public function timeCardExcel(Request $request)
    {
                
        $url1 = str_replace("length=10","length=-1",session('electronic_time_card'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        
        ini_set('memory_limit', -1);
            $curl = curl_init();
                curl_setopt_array($curl, array(
                CURLOPT_URL => $url."&auth_id=".Auth::id(),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ));

        $response = curl_exec($curl);
            
        curl_close($curl);
        
        if(!isset($request->user_list)){
            $parsedUrl = parse_url(url()->previous());
            parse_str($parsedUrl['query'], $output);
            $request->user_list = $output['user_list'];
        }
        
        // $employees = json_decode($response)->data;
        $pageData = $this->timeCardData($request);
        $employees = $pageData->original['data'];
        $leaveNames  = DB::table('leave_name')->get();

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        
        $sheet->setCellValue('A'. 1, 'Electronic Time Card')->getStyle('A1')->getFont()->setBold(true);

        $empRows = 4;
        foreach($employees as $employee){
            $empRowsHead = $empRows-1;
            
            $sheet->setCellValue('A'. $empRowsHead, 'Name = '.$employee['personname'])->getStyle('A'.$empRowsHead)->getFont()->setBold(true);
            $sheet->setCellValue('B'. $empRowsHead, 'Emp No = '.$employee['employee_no'])->getStyle('B'.$empRowsHead)->getFont()->setBold(true);
            $sheet->setCellValue('C'. $empRowsHead, '√ = Excused')->getStyle('C'.$empRowsHead)->getFont()->setBold(true);
            $sheet->setCellValue('D'. $empRowsHead, 'Date : '. date('d-m-Y', strtotime($employee['start_date'])) .'-'. date('d-m-Y', strtotime($employee['end_date'])))->getStyle('D'.$empRowsHead)->getFont()->setBold(true);
            
            
            $sheet->setCellValue('A'. $empRows, 'DATE')->getStyle('A'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('B'. $empRows, 'DAY TYPE')->getStyle('B'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('C'. $empRows, 'SCHE')->getStyle('C'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('D'. $empRows, 'IN')->getStyle('D'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('E'. $empRows, 'BREAK')->getStyle('E'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('F'. $empRows, 'RESUME')->getStyle('F'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('G'. $empRows, 'OUT')->getStyle('G'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('H'. $empRows, 'WORK')->getStyle('H'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('I'. $empRows, 'OVERTIME')->getStyle('I'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('J'. $empRows, 'SHORT')->getStyle('J'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('K'. $empRows, 'LEAVE TAKEN')->getStyle('K'.$empRows)->getFont()->setBold(true);
            $sheet->setCellValue('L'. $empRows, 'REMARK')->getStyle('L'.$empRows)->getFont()->setBold(true);
            
            $rows = $empRows+1;
            foreach ($employee['att'] as $attData){
                if($attData){
            
                    $sheet->setCellValue('A'. $rows, date('d-m-Y', strtotime($attData['date'])) ?? null);
                    $sheet->setCellValue('B'. $rows, $attData['day_type'] ?? null);
                    $sheet->setCellValue('C'. $rows, $attData['sche'] ?? null);
                    $sheet->setCellValue('D'. $rows, $attData['in_time'] ?? null);
                    $sheet->setCellValue('E'. $rows, $attData['break_time'] ?? null);
                    $sheet->setCellValue('F'. $rows, $attData['resume_time'] ?? null);
                    $sheet->setCellValue('G'. $rows, $attData['out_time'] ?? null);
                    $sheet->setCellValue('H'. $rows, $attData['work'] ?? null);
                    $sheet->setCellValue('I'. $rows, $attData['overtime'] ?? null);
                    $sheet->setCellValue('J'. $rows, $attData['short'] ?? null);
                    $sheet->setCellValue('K'. $rows, $attData['leave_taken'] ?? null);
                    $sheet->setCellValue('L'. $rows, $attData['remark'] ?? null);
                
                    $rows++;
                }
            }


            $workDays = 0;
            $flexiDays = 0;
            $holidays = 0;
            $workDayPresent = 0;
            $flexiDayPresent = 0;
            $holidayPresent = 0;
            $workDayHours = 0;
            $flexiDayHours = 0;
            $holidayHours = 0;
            $workDayOvertimeHours = 0;
            $flexiOvertimeHours = 0;
            $holiOvertimeHours = 0;
            $workDayShortHours = 0;
            $flexiShortHours = 0;
            $holiShortHours = 0;
        
            foreach ($employee['att'] as $attData){
            
                if (isset($attData['day_type']) && $attData['day_type'] == 'Work') {
                    $workDays += 1;
                    if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                        $workDayPresent += 1;
                    }
                
                    if (isset($attData['work'])) {
                        $workDayHours = second_to_hhmm(explode_time($workDayHours) + explode_time($attData['work']));
                    }
                
                    if (isset($attData['overtime'])) {
                        $workDayOvertimeHours = second_to_hhmm(explode_time($workDayOvertimeHours) + explode_time($attData['overtime']));
                    }
                
                    if (isset($attData['short'])) {
                        $workDayShortHours = second_to_hhmm(explode_time($workDayShortHours) + explode_time($attData['short']));
                    }
                }
                
                if (isset($attData['day_type']) && $attData['day_type'] == 'Flexi') {
                    $flexiDays += 1;
                    if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                        $flexiDayPresent += 1;
                    }
                
                    if (isset($attData['work'])) {
                        $flexiDayHours = second_to_hhmm(explode_time($flexiDayHours) + explode_time($attData['work']));
                    }
                
                    if (isset($attData['overtime'])) {
                        $flexiOvertimeHours = second_to_hhmm(explode_time($flexiOvertimeHours) + explode_time($attData['overtime']));
                    }
                
                    if (isset($attData['short'])) {
                        $flexiShortHours = second_to_hhmm(explode_time($flexiShortHours) + explode_time($attData['short']));
                    }
                }
                
                if ((isset($attData['day_type']) && $attData['day_type'] == 'HOLIDAY') || (isset($attData['day_type']) && $attData['day_type'] == 'Rest')) {
                    $holidays += 1;
                    if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                        $holidayPresent += 1;
                    }
                
                    if (isset($attData['work'])) {
                        $holidayHours = second_to_hhmm(explode_time($holidayHours) + explode_time($attData['work']));
                    }
                
                    if (isset($attData['overtime'])) {
                        $holiOvertimeHours = second_to_hhmm(explode_time($holiOvertimeHours) + explode_time($attData['overtime']));
                    }
                
                    if (isset($attData['short'])) {
                        $holiShortHours = second_to_hhmm(explode_time($holiShortHours) + explode_time($attData['short']));
                    }
                }
            }



            $summaryHeading = $rows+1;
            $sheet->setCellValue('A'. $summaryHeading, 'Summary')->getStyle('A'.$summaryHeading)->getFont()->setBold(true);;

            $summaryHeadOne = $summaryHeading+1;
            $sheet->setCellValue('A'. $summaryHeadOne, 'DAY TYPE')->getStyle('A'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('B'. $summaryHeadOne, 'Total Days')->getStyle('B'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('C'. $summaryHeadOne, 'Present')->getStyle('C'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('D'. $summaryHeadOne, 'Work')->getStyle('D'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('E'. $summaryHeadOne, 'Overtime')->getStyle('E'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('F'. $summaryHeadOne, 'Short')->getStyle('F'.$summaryHeadOne)->getFont()->setBold(true);
            
            $sheet->setCellValue('I'. $summaryHeadOne, 'Leave Type')->getStyle('I'.$summaryHeadOne)->getFont()->setBold(true);
            $sheet->setCellValue('J'. $summaryHeadOne, 'Total')->getStyle('J'.$summaryHeadOne)->getFont()->setBold(true);

            $summaryDataOne = $summaryHeadOne+1;
            $sheet->setCellValue('A'. $summaryDataOne, 'Workday');
            $sheet->setCellValue('B'. $summaryDataOne, $workDays);
            $sheet->setCellValue('C'. $summaryDataOne, $workDayPresent);
            $sheet->setCellValue('D'. $summaryDataOne, $workDayHours);
            $sheet->setCellValue('E'. $summaryDataOne, $workDayOvertimeHours);
            $sheet->setCellValue('F'. $summaryDataOne, $workDayShortHours);

            $leaveCount = 0;
            $summaryDataTwo = $summaryDataOne;
            foreach ($leaveNames as $lv){
        
                $leaveType = $lv->type;
            
                $sheet->setCellValue('I'. $summaryDataTwo, $leaveType);
                
                $leaveList = array_filter($employee['att'], function ($value) use ($leaveType) {
                    if (isset($value['leave_taken'])) {
                        return $leaveType == $value['leave_taken'];
                    }
                });
                
                $leaveCount += count($leaveList);
                
                $sheet->setCellValue('J'. $summaryDataTwo, count($leaveList));

                
                $summaryDataTwo++;
            }
            $sheet->setCellValue('I'. $summaryDataTwo, 'Total')->getStyle('I'.$summaryDataTwo)->getFont()->setBold(true);
            $sheet->setCellValue('J'. $summaryDataTwo, $leaveCount);


            $summaryDataOne = $summaryHeadOne+2;
            $sheet->setCellValue('A'. $summaryDataOne, 'FlexiDay');
            $sheet->setCellValue('B'. $summaryDataOne, $flexiDays);
            $sheet->setCellValue('C'. $summaryDataOne, $flexiDayPresent);
            $sheet->setCellValue('D'. $summaryDataOne, $flexiDayHours);
            $sheet->setCellValue('E'. $summaryDataOne, $flexiOvertimeHours);
            $sheet->setCellValue('F'. $summaryDataOne, $flexiShortHours);

            $summaryDataOne = $summaryHeadOne+3;
            $sheet->setCellValue('A'. $summaryDataOne, 'RestDay');
            $sheet->setCellValue('B'. $summaryDataOne, $holidays);
            $sheet->setCellValue('C'. $summaryDataOne, $holidayPresent);
            $sheet->setCellValue('D'. $summaryDataOne, $holidayHours);
            $sheet->setCellValue('E'. $summaryDataOne, $holiOvertimeHours);
            $sheet->setCellValue('F'. $summaryDataOne, $holiShortHours);

            $summaryDataOne = $summaryHeadOne+4;
            $sheet->setCellValue('A'. $summaryDataOne, 'Total')->getStyle('A'.$summaryDataOne)->getFont()->setBold(true);;
            $sheet->setCellValue('B'. $summaryDataOne, $workDays + $flexiDays + $holidays);
            $sheet->setCellValue('C'. $summaryDataOne, $workDayPresent + $flexiDayPresent + $holidayPresent);
            $sheet->setCellValue('D'. $summaryDataOne, second_to_hhmm(explode_time($workDayHours) + explode_time($flexiDayHours) + explode_time($holidayHours)) );
            $sheet->setCellValue('E'. $summaryDataOne,  second_to_hhmm(explode_time($workDayOvertimeHours) + explode_time($flexiOvertimeHours) + explode_time($holiOvertimeHours)));
            $sheet->setCellValue('F'. $summaryDataOne, second_to_hhmm(explode_time($workDayShortHours) + explode_time($flexiShortHours) + explode_time($holiShortHours)));

            $empRows=$summaryDataTwo+6;
        }
        
        $fileName = "time-card.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }

    public function timeCardPdf(Request $request)
    {
        
        $url1 = str_replace("length=10","length=-1",session('electronic_time_card'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
       
        $response = curl_exec($curl);
        curl_close($curl);
        //   dd($url."&auth_id=".Auth::id());
        // $employees = json_decode($response)->data;
        $user = User::where('id' , Auth::id())->first();
        $leaveNames  = DB::table('leave_name')->get();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $total_days = Carbon::now()->month(date('m'))->daysInMonth;
        
        if(!isset($request->user_list)){
            $parsedUrl = parse_url(url()->previous());
            parse_str($parsedUrl['query'], $output);
            $request->user_list = $output['user_list'];
        }
        
        $pageData = $this->timeCardData($request);
        $employees = $pageData->original['data'];
        // dd($employees);
        
        // return view('hr.reports.pdf.time-card', compact('employees','companyname', 'total_days', 'leaveNames'));
        $html = html_entity_decode(view('hr.reports.pdf.time-card', compact('employees','companyname', 'total_days', 'leaveNames')));
        $options = new Options();        
        $options->set('isRemoteEnabled', true);          
        $pdf = new Dompdf($options);
        

        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('Time Card');
        return 1;
        
    }




    
    //  ================================= attandance summary by Ashutosh soni ================================
    
    

    /////////////////////////allAttendance//////////////////////////////////////
        public function fontBold($time, $date, $empno)
    {
        $clockindata =  Clockin::select('updated_at')->where('time', $time)->where('working_day', $date)->where('employee_no', $empno)->whereNotNull('updated_at')->count();
        if ($clockindata) {
            return 'font-weight: 900;';
        } else {
            return '';
        }
    }


    /////////////////////////text bold//////////////////////////////////////


      ///////////////////////// for testing allAttendance//////////////////////////////////////
    public function allAttendanceeee()
    {
    
        $user_type = 'emp';
    
        $attendanceDatad = Clockin::select('clockin.*', 'sch_week.*', 'up.schedule_id', DB::raw("group_concat(time separator '==') as fulltime"))
            ->join('user_personal as up', 'clockin.employee_no', '=', 'up.employee_no')
            ->join("schedule_week as sch_week", function ($join) {
                $join->whereRaw("up.schedule_id=sch_week.schedule_id")
                    ->whereRaw(" week_day = date_format(working_day,'%a')");
            });
            
                if ($user_type == 'emp') {
                    $attendanceDatad->where('up.employee_no', '=', getEmpNo());
                }
            $attendanceData = $attendanceDatad->groupBy('working_day', 'personname')->orderBy('working_day', 'desc')->get();
    
            // dd($attendanceData)
    
    
        for ($i = 0; $i < count($attendanceData); $i++) {
            $attendance_data =  $attendanceData[$i];
            $fulltime = explode('==', $attendance_data['fulltime']);
            $entry_time = $attendance_data['entry'];
            $break_time = $attendance_data['break'];
            $resume_time = $attendance_data['resume'];
            $leave_time = $attendance_data['leave'];
            $schedule_range = $attendance_data['schedule_range'];
            $flexi_lunch = $attendance_data['flexi_lunch'];
            $min_ot = $attendance_data['min_ot'];
            $min_flexi_hour = $attendance_data['min_flexi_hour'];
    
            $intime = '-';
            $break = '-';
            $resume = '-';
            $out_time = '-';
            sort($fulltime);
    
    
            echo "Employee_id---" . $attendance_data->employee_no . "<br>";
                echo "Date---" . $attendance_data->working_day . "<br><br>";
                echo "schedule_entry---" . $entry_time . "<br>";
                echo "break_time---" . $break_time . "<br>";
                echo "resume_time---" . $resume_time . "<br>";
                echo "leave_time---" . $leave_time . "<br>";
                echo "range---" . $schedule_range . "<br>";
                echo "flexi lunch---" . $flexi_lunch . "<br>";
                echo "schedule_id---" . $attendance_data->schedule_id . "<br><br>";
    
    
            $total_fultime = count($fulltime);
    
            for ($a = 0; $a < $total_fultime; $a++) {
                $emp_time = $fulltime[$a];
                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
    
                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
    
                echo $emp_time . "<br>";
    
    
                // entry time
                if ($attendance_data->day_type == 'Work') {
                    if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                        $intime = $emp_time;
                        continue;
                    }
    
    
                    // break_times
    
                    if (($break == '-') &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                        $break = $emp_time;
                        continue;
                    }
    
    
                    //   resume_time
    
    
                    if (($break != '-') && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                        $resume = $emp_time;
                        continue;
                    } else {
                        if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                            $resume = $emp_time;
                            continue;
                        }
                    }
    

    
                    //   out
    
                    if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                        $out_time = $emp_time;
                        continue;
                    }
                } elseif ($attendance_data->day_type == 'Flexi') {
    
                    if ($a == '0') {
                        $intime = $emp_time;
                        continue;
                    } elseif ($a == '1') {
                        $break = $emp_time;
                        continue;
                    } elseif ($a == '2') {
                        $resume = $emp_time;
                        continue;
                    } elseif ($a == ($total_fultime - 1)) {
                        $out_time = $emp_time;
                        continue;
                    }
                }
            }
            // text color 
            $emp_lunch = (strtotime($resume)-strtotime($break));
            $text_color = 'black';
            echo "<br>".($flexi_lunch*60)."<br>";
            echo  $emp_lunch."<br>";
            
            if(($emp_lunch >= ($flexi_lunch*60) && $emp_lunch > 0)){
                $text_color = "red";
            }
             echo  $text_color."<br>";
            // text color 
            $attendance_data->intime = $intime;
            $attendance_data->break_time = $break;
            $attendance_data->resume_time = $resume;
            $attendance_data->leave_time = $out_time;
            $attendance_data->text_color = $text_color;
    
        echo "<br>(entry------" . $attendance_data->intime . ")---(break---" . $attendance_data->break_time . ")----(resume--" . $attendance_data->resume_time . ")----(out--" . $attendance_data->leave_time . ")";
                echo "<hr>";
            }
}


      ///////////////////////// for testing allAttendance//////////////////////////////////////


    public function empAttendanceexport(Request $request)
    {
          $url1 = str_replace("length=10","length=-1",session('employees_attendance_data'));
          $url11 = str_replace("length=20","length=-1", $url1);
          $url12 = str_replace("length=50","length=-1", $url11);
          $url = str_replace("length=100","length=-1", $url12);
          ini_set('memory_limit', -1);
          $curl = curl_init();
  
              curl_setopt_array($curl, array(
              CURLOPT_URL => $url."&auth_id=".Auth::id(),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
          ));
  
          $response = curl_exec($curl);
          curl_close($curl);
          $employees = json_decode($response)->data;
          
          $spreadsheet = new Spreadsheet();
          $sheet = $spreadsheet->getActiveSheet();
          $sheet->setCellValue('A'. 1, 'Employees Attendance Report');

        if(isset($request->at) && $request->at == "emp"){
            $c_key = 'emp_attendance';
        }else{
            $c_key = 'hr_attendance';
        }
        
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Date", "Day", "Emp No", "Name", "Schedule", "Day Type", "In", "Break", "Resume", "Out", "Late In", "Early Out", "Overtime"];

          $startFrom = 65;
          for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 3, $arrColumns[$i]);
                $startFrom++;
            }
          }

          $rowss = 4;
          foreach($employees as $key=>$employee){
            $arrRows = [$employee->date, $employee->day_name, $employee->employee_no, $employee->personname, $employee->schedule_id, $employee->day_type, $employee->intime, $employee->break_time, $employee->resume_time, $employee->leave_time, $employee->lateness, $employee->earlyOut, $employee->overtime];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rowss, $arrRows[$k]); 
                    $startFrom++;
                }
            }
    
            $rowss++;
        }
  
  
          $fileName = "employees-attendance-report.xlsx";
      
          $writer = new Xlsx($spreadsheet);
          header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
          header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
          $writer->save('php://output');
    }
      
      
      // pdf
      
    public function empAttendancePdf(Request $request)
    {
      
        $timezone = Carbon::now(get_local_time());
        
        $timedate = $timezone->format('d-m-Y H:i A');
        
        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10","length=-1",session('employees_attendance_data'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        $employees = json_decode($response)->data;
        $user = User::where('id' , Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();


        if(isset($request->at) && $request->at == "emp"){
            $c_key = 'emp_attendance';
        }else{
            $c_key = 'hr_attendance';
        }

        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Date", "Day", "Emp No", "Name", "Schedule", "Day Type", "In", "Break", "Resume", "Out", "Late In", "Early Out", "Overtime"];

        
        $html = html_entity_decode(view('hr.reports.pdf.empattendancepdf', compact('employees','timedate','companyname', 'columnHideShowData', 'c_key', 'arrColumns')));//->render();
        $options = new Options();        
        $options->set('isRemoteEnabled', true);         
        $pdf = new Dompdf($options);
      
      

        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Employees Attendance Report');
        return 1;

    }


    public function hrrDashboardData(Request $request)
    {

        $user_type = $request->user_type;
        $emp_no = $request->emp_no;
        $month =   $request->month;
        $year =  $request->year;
        $chartype = $request->chartype;
        $day_type = '';
        $late_emp = '0';
        $lateness = '0';
        $early_dep = '0';
        $present_emp = '0';
        $overtimes_emp = '0';
        $intime = '';
        $break = '';
        $resume = '';
        $out_time = '';
        $overtime = '';
        $total_days =   cal_days_in_month(CAL_GREGORIAN, $month, $year);
        $startDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-01')->startOfDay()->toDateString();
        $endDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-' . $total_days)->endOfDay()->toDateString();
        $end_of_month = Carbon::now()->endOfMonth()->toDateString();
        $current_date = Carbon::now()->toDateString();
        $sdatefrom = ($chartype == 'today') ? $current_date : $startDate;
        $sdateto =  ($chartype == 'today') ? $current_date : $endDate;
        $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
        $dates = $dateRange->toArray();
        $qry = '';
        for ($i = 0; $i < count($dateRange); $i++) {
            $alldate = $dates[$i]->format('Y-m-d');
            $qry .= 'select cast(\'' . $alldate . '\' as date) as dte ';

            if ($i < (count($dateRange) - 1)) {
                $qry .= 'union ';
            }
        }




        $attendanceDatad = DB::table(DB::raw('(' . $qry . ') dates'))
            ->select('dates.dte', 'sch.*', 'sch.day_type', 'up.employee_no', 'up.username', DB::raw('(SELECT GROUP_CONCAT(TIME SEPARATOR \'==\') FROM clockin WHERE employee_no = up.employee_no AND working_day = dte GROUP BY working_day) AS fulltime'))
            ->crossJoin(DB::raw('user_personal up'))
            ->leftJoin(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
            ->leftjoin('user_pay', 'up.username', '=', 'user_pay.username')
            ->leftJoin(DB::raw('schedule_week sch'), function ($join) {
                $join->on('up.schedule_id', '=', 'sch.schedule_id')
                    ->whereRaw('week_day = date_format(dte,\'%a\')');
            });

        if ($user_type == 'emp') {
            $attendanceDatad->where('up.employee_no', '=', $emp_no);
        }


        //active status
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

        if ($ActiveUserShownStatus == '0') {
            $attendanceDatad->where('user_pay.pay_status', '=', '1');
        }

        // active status


        $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'dates.dte'])->orderBy('dates.dte', 'DESC')->orderBy('up.employee_no', 'ASC')->get();

        // dd($attendanceData);

        for ($i = 0; $i < count($attendanceData); $i++) {
            $attendance_data =  $attendanceData[$i];
            $fulltime = explode('==', $attendance_data->fulltime);
            $entry_time = $attendance_data->entry;
            $break_time = $attendance_data->break;
            $resume_time = $attendance_data->user_resume;
            $leave_time = $attendance_data->user_leave;
            $schedule_range = $attendance_data->schedule_range;
            $flexi_lunch = $attendance_data->flexi_lunch;
            $min_ot = $attendance_data->min_ot;
            $min_flexi_hour = $attendance_data->min_flexi_hour;
            $min_flexi_hour = $attendance_data->min_flexi_hour;


            sort($fulltime);

            $total_fultime = count($fulltime);

            for ($a = 0; $a < $total_fultime; $a++) {
                $emp_time = $fulltime[$a];
                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));

                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));


                // entry time
                if ($attendance_data->day_type == 'Work') {
                    if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                        $intime = $emp_time;
                        continue;
                    }

                    // break_times

                    if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                        $break = $emp_time;
                        continue;
                    }

                    //   resume_time

                    if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                        $resume = $emp_time;
                        continue;
                    } else {
                        if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                            $resume = $emp_time;
                            continue;
                        }
                    }

                    //   out

                    if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                        $out_time = $emp_time;
                        continue;
                    }
                } elseif ($attendance_data->day_type == 'Flexi') {

                    if ($a == '0') {
                        $intime = $emp_time;
                        continue;
                    } elseif ($a == ($total_fultime - 1)) {
                        $out_time = $emp_time;
                        continue;
                    } elseif ($a == '1') {
                        $break = $emp_time;
                        continue;
                    } elseif ($a == '2') {
                        $resume = $emp_time;
                        continue;
                    }
                }
            }

            if (strtotime($intime) > strtotime($entry_time)) {
                $late_emp += 1;
                $lateness = date('H:i', strtotime($intime) - strtotime($entry_time));
            } elseif (!$intime && $break) {
                $late_emp += 1;
            } elseif (!$intime && !$break && $resume) {
                $late_emp += 1;
            } elseif (!$intime && !$break && !$resume && $out_time) {
                $late_emp += 1;
            }



            if (!$intime && $break) {
            }

            if ((strtotime($intime) < strtotime($entry_time)) && $intime) {
                $early_dep = date('H:i', strtotime($entry_time) - strtotime($intime));
            }

            if (($intime || $out_time || $break || $resume) && ($attendance_data->day_type == 'Work' || $attendance_data->day_type == 'Flexi')) {
                if (!$early_dep) {

                    if (!$lateness && $break) {
                        $lateness = date('H:i', strtotime($break) - strtotime($entry_time));
                    } elseif (!$lateness && $resume) {
                        $lateness = date('H:i', strtotime($resume) - strtotime($entry_time));
                    } elseif (!$lateness && $out_time) {
                        $lateness = date('H:i', strtotime($out_time) - strtotime($entry_time));
                    }
                }
                $present_emp += 1;
            }
            if (strtotime($out_time) >= strtotime($min_ot_range)) {
                $overtimes_emp += 1;
                $overtime =  date('H:i', strtotime($out_time) - strtotime($leave_time));
            }
            $day_type = $attendance_data->day_type;

            $intime = '';
            $break = '';
            $resume = '';
            $out_time = '';
        }


        $absent_emp                           = count($attendanceData) - $present_emp;
        $return_arr['late_emp']               = $late_emp;
        $return_arr['present_emp']            = $present_emp;
        $return_arr['total_emp']              = count($attendanceData);
        $return_arr['absent_emp']             = $absent_emp;
        $return_arr['month']                  = $month;
        $return_arr['year']                   = $year;
        $return_arr['day_type']               = $day_type;
        $return_arr['overtime']               = ($overtime) ? $overtime : 0;
        $return_arr['overtimes_emp']          = $overtimes_emp;
        $return_arr['lateness']               = $lateness;
        $return_arr['early_dep']              = $early_dep;
        $return_arr['total_days']             = $total_days;
        $return_arr['total_absent']           = $absent_emp;



        return response()->json($return_arr);
    }
    
    public function hrDashboardData(Request $request)
    {
        $user_type = $request->user_type;
        $emp_no = $request->emp_no;
        if(isset($request->month)){
            $month =   $request->month;
        }else{
            $month = date("m");
        }

        if(isset($request->year)){
            $year =   $request->year;
        }else{
            $year = date("Y");
        }

        $chartype = $request->chartype;
        $branch =  $request->branch_id;

        $day_type = '';
        $late_emp = '0';
        $lateness = '0';
        $early_dep = '0';
        $present_emp = '0';
        $overtimes_emp = '0';
        $intime = '';
        $break = '';
        $resume = '';
        $out_time = '';
        $overtime = '';

            $total_days =   cal_days_in_month(CAL_GREGORIAN, $month, $year);
            $startDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-01')->startOfDay()->toDateString();
            $endDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-' . $total_days)->endOfDay()->toDateString();
            $end_of_month = Carbon::now()->endOfMonth()->toDateString();
            $current_date = Carbon::now()->toDateString();
            $sdatefrom = ($chartype == 'today') ? $current_date : $startDate;
            $sdateto =  ($chartype == 'today') ? $current_date : $endDate;
            $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
            $dates = $dateRange->toArray();
    
            $dateFrom = date_format(date_create(date($year.'-'.$month)."-01"),"Y-m-d");
            $getDays = Carbon::now()->month($month)->daysInMonth;
            $dateTo = date($year.'-'.$month.'-'.$getDays);


        if($request->data_type == "line_chart"){

            $category = $request->category;
            $branchs = $request->branch;
            $department = $request->department;
            $year = $request->year;
          
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
                ->select('clk.working_day', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.date_attendance_start',
                    DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))
                    
                ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');

                $attendanceDatad->leftJoin(DB::raw('clockin clk'), function ($data){
                    $data->on('up.employee_no', '=', 'clk.employee_no');
                        // ->whereYear('clk.working_day', $year);
                });
                $attendanceDatad->whereYear('clk.working_day', $year);
                //active status
                $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
                $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

                if ($ActiveUserShownStatus == '0') {
                    $attendanceDatad->where('user_pay.pay_status', '=', '1');
                }

                
                $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');

                // active status

                // filter
                if ($category) {
                    $attendanceDatad->where('user_pay.category_id', '=', $category);
                }
                if ($branchs) {
                    $attendanceDatad->where('user_pay.branch_id', '=', $branchs);
                }
                if ($department) {
                    $attendanceDatad->where('user_pay.department_id', '=', $department);
                }

                $attendanceDatas = $attendanceDatad->groupBy(['up.employee_no','clk.working_day'])->orderBy('clk.working_day', 'DESC')->get();
                // dd($attendanceData);

                // total emp count
                $empTotal = DB::table(DB::raw('user_personal up'))->select('up.*')->leftJoin('user_pay', 'up.username', '=', 'user_pay.username');
                if ($ActiveUserShownStatus == '0') {
                    $empTotal->where('user_pay.pay_status', '=', '1');
                }
                $empTotal = $empTotal->count();
                
                $monthData = [];
                foreach($attendanceDatas as $attendanceData){
                    $m = date('n', strtotime($attendanceData->working_day));
                    if(isset($monthData[$m])){
                        array_push($monthData[$m], $attendanceData);
                    }
                    else{
                     $monthData[$m]= [];
                     $monthData[$m][0]= $attendanceData;
                    }
                }  
                if($year == date("Y")){
                    $mm = date("m");
                }else{
                    $mm = 12;
                }
                $finalMonth = [];
                for ($i = 1; $i <=$mm; $i++) {
                    $finalMonth[$i] = $monthData[$i]??[];
                }

                $finalRes = [];
                foreach($finalMonth as $key=>$attendanceData){
                    
                    $getDays = Carbon::now()->month($key)->daysInMonth;
                    $total_presents_days = $empTotal * $getDays;
                    $present_p = (count($attendanceData)*100)/$total_presents_days;
            
                    $return_arr['present_emp']            = round($present_p, 2);
                    $return_arr['total_emp']              = $empTotal;
                    $return_arr['month']                  = $month;
                    $return_arr['year']                   = $year;

                    $finalRes[$key] = $return_arr;
                }
                
                // dd($finalRes);
                return response()->json($finalRes);
        }

        if($request->data_type == "pie_chart"){
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
                ->select('clk.working_day', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.branch_id', 'user_pay.date_attendance_start',
                    DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))

                ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
                

                $attendanceDatad->join(DB::raw('clockin clk'), function ($data) use($dateFrom, $dateTo) {
                    $data->on('up.employee_no', '=', 'clk.employee_no')
                        ->whereBetween('clk.working_day', [$dateFrom, $dateTo]);
                });
                
                //active status
                $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
                $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

                if ($ActiveUserShownStatus == '0') {
                    $attendanceDatad->where('user_pay.pay_status', '=', '1');
                }

                
                $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
                // active status

                $attendanceData = $attendanceDatad->groupBy(['up.employee_no','clk.working_day'])->orderBy('clk.working_day', 'DESC')->get();

                
                $presentInBranch = [];
                foreach($attendanceData as $atData){
                    $temp = getBranchNameById($atData->branch_id);
                    if(!isset($$temp)){
                        $$temp=$temp;
                        $presentInBranch[$$temp]=1;
                    }
                    else{
                        $$temp=$temp;
                        $presentInBranch[$$temp]+=1;
                    }
                }
        
                $return_arr['data']                   = json_encode($presentInBranch);
                $return_arr['month']                  = $month;
                $return_arr['year']                   = $year;
                
                // dd($return_arr);
                return response()->json($return_arr);
        }

        if($request->data_type == "pie_chart_branch"){
            if(isset($request->date_from)){
                $date_from11 = date("Y-m-d", strtotime($request->date_from));
            }else{
                $date_from11 = date("Y-m-d");
            }

            if(isset($request->date_to)){
                $date_to11 = date("Y-m-d", strtotime($request->date_to));
            }else{
                $date_to11 = date("Y-m-d");
            }
           
                
            $diff_Date = date_diff(date_create($date_from11),date_create($date_to11));
            $get_days_diff = $diff_Date->days+1;
           
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
            ->select('clk.working_day', 'sch.*', 'user_pay.branch_id', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.date_attendance_start',
                DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))

            ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
            ->leftJoin(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');


            // print_r($dateFrom);
            $attendanceDatad->where('clk.working_day','>=',$date_from11);
            $attendanceDatad->where('clk.working_day', '<=' ,$date_to11);

            
            $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->where('duty_roaster_dates.date', 'clk.working_day');
            });

            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(clk.working_day,\'%a\')');
            });

            if(isset($branch) && $branch != "All"){
                $attendanceDatad->where('user_pay.branch_id', $branch);
            }
            
            //active status
            $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

            if ($ActiveUserShownStatus == '0') {
                $attendanceDatad->where('user_pay.pay_status', '=', '1');
            }

            $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
            // active status

            $attendanceData = $attendanceDatad->groupBy(['up.employee_no','clk.working_day'])->orderBy('clk.working_day', 'DESC')->get();
            // dd($attendanceData);
            // total emp count
            $empTotal = DB::table(DB::raw('user_personal up'))->select('up.*')->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                ->where(function($q){
                    $q->where('user_pay.date_resigned', NULL)
                    ->orWhere('user_pay.date_resigned', '0000-00-00');
                });
                if(isset($branch) && $branch != "All"){
                    $empTotal->where('user_pay.branch_id', $branch);
                }
            $empTotal = $empTotal->where('user_pay.pay_status', '=', '1')->count();

            for ($i = 0; $i < count($attendanceData); $i++) {
                $attendance_data =  $attendanceData[$i];
                $fulltime = explode('==', $attendance_data->fulltime);
                $entry_time = $attendance_data->entry;
                $break_time = $attendance_data->break;
                $resume_time = $attendance_data->user_resume;
                $leave_time = $attendance_data->user_leave;
                $schedule_range = $attendance_data->schedule_range;
                $flexi_lunch = $attendance_data->flexi_lunch;
                $min_ot = $attendance_data->min_ot;
                $min_flexi_hour = $attendance_data->min_flexi_hour;
                $min_flexi_hour = $attendance_data->min_flexi_hour;
    
           
                sort($fulltime);
                $total_fultime = count($fulltime);
          
                for ($a = 0; $a < $total_fultime; $a++) {
                    $emp_time = $fulltime[$a];
                   
                    $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                    $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                    $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                   
    
                    // entry time
                    if ($attendance_data->day_type == 'Work') {
                       
                        // intime
                        if ($a == 0 && strtotime($emp_time) < strtotime($break_range_min)) {
                            $intime = $emp_time;
                            continue;
                        }
        
                        // break_times
                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                            $break = $emp_time;
                            continue;
                        }
                        
                        //   resume_time
                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                            $resume = $emp_time;
                            continue;
                        } else {
                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                $resume = $emp_time;
                                continue;
                            }
                        }
                        
                        //   out
                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                            $out_time = $emp_time;
                            continue;
                        }
                        
                    }elseif ($attendance_data->day_type == 'Flexi') {
                        if ($a == '0') {
                            $intime = $emp_time;
                            continue;
                        } elseif ($a == ($total_fultime - 1)) {
                            $out_time = $emp_time;
                            continue;
                        } elseif ($a == '1') {
                            $break = $emp_time;
                            continue;
                        } elseif ($a == '2') {
                            $resume = $emp_time;
                            continue;
                        }
                       
                    }
                    
                }
       
                // lateness and late count
                if (strtotime($intime) > strtotime($entry_range)) {
                    $late_emp += 1;
                } elseif (!$intime && $break) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && $resume) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && !$resume && $out_time) {
                    $late_emp += 1;
                }

                
                if (($intime || $out_time || $break || $resume) && ($attendance_data->day_type == 'Work' || $attendance_data->day_type == 'Flexi')) {
                    $present_emp += 1;
                }

                $intime = '';
                $break = '';
                $resume = '';
                $out_time = '';
           
            }

            $absent_emp = $empTotal * $get_days_diff - count($attendanceData);


            $return_arr['present'] = count($attendanceData);
            $return_arr['absent'] = $absent_emp;
            $return_arr['late'] = $late_emp;
            // dd($return_arr);
            return response()->json($return_arr);
        }
        
        if($request->data_type == "counter_data"){
            $late_emp = 0;
            $date = date("Y-m-d");
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
            ->select('clk.working_day', 'sch.*', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.date_attendance_start',
                DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))
                
            ->leftJoin(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
            ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');


            $attendanceDatad->where('clk.working_day', $date);
            
            $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->whereRaw('duty_roaster_dates.date = clk.working_day');
            });
 
            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(clk.working_day,\'%a\')');
            });
            
            
            $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
            
            //active status
            $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

            if ($ActiveUserShownStatus == '0') {
                $attendanceDatad->where('user_pay.pay_status', '=', '1');
            }
            
            
                    
            // active status

            $attendanceData = $attendanceDatad->groupBy(['up.employee_no','clk.working_day'])->orderBy('clk.working_day', 'DESC')->get();
            //dd($attendanceData);

            // total emp count
            $empTotal = DB::table(DB::raw('user_personal up'))->select('up.*')->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                        ->where(function($q){
                            $q->where('user_pay.date_resigned', NULL)->orWhere('user_pay.date_resigned', '0000-00-00');
                        })->whereNotNull('user_pay.date_attendance_start')
                        ->where('user_pay.pay_status', '=', '1')->count();

            $unAssignedEmp = DB::table(DB::raw('user_pay'))
                ->whereNull('user_pay.date_attendance_start')
                ->where('user_pay.pay_status', '=', '1')->count();

            for ($i = 0; $i < count($attendanceData); $i++) {
                $attendance_data =  $attendanceData[$i];
                $fulltime = explode('==', $attendance_data->fulltime);
                $entry_time = $attendance_data->entry;
                $break_time = $attendance_data->break;
                $resume_time = $attendance_data->user_resume;
                $leave_time = $attendance_data->user_leave;
                $schedule_range = $attendance_data->schedule_range;
                $flexi_lunch = $attendance_data->flexi_lunch;
                $min_ot = $attendance_data->min_ot;
                $min_flexi_hour = $attendance_data->min_flexi_hour;
                $min_flexi_hour = $attendance_data->min_flexi_hour;

                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
               
    
           
                sort($fulltime);
                $total_fultime = count($fulltime);
          
                for ($a = 0; $a < $total_fultime; $a++) {
                    $emp_time = $fulltime[$a];
                   
    
                    // entry time
                    if ($attendance_data->day_type == 'Work') {
                       
                        // intime
                        if ($a == 0 && strtotime($emp_time) < strtotime($break_range_min)) {
                            $intime = $emp_time;
                            continue;
                        }
        
                        // break_times
                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                            $break = $emp_time;
                            continue;
                        }
                        
                        //   resume_time
                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                            $resume = $emp_time;
                            continue;
                        } else {
                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                $resume = $emp_time;
                                continue;
                            }
                        }
                        
                        //   out
                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                            $out_time = $emp_time;
                            continue;
                        }
                        
                    }elseif ($attendance_data->day_type == 'Flexi') {
                        if ($a == '0') {
                            $intime = $emp_time;
                            continue;
                        } elseif ($a == ($total_fultime - 1)) {
                            $out_time = $emp_time;
                            continue;
                        } elseif ($a == '1') {
                            $break = $emp_time;
                            continue;
                        } elseif ($a == '2') {
                            $resume = $emp_time;
                            continue;
                        }
                       
                    }else{
                        if($fulltime){
                             $intime = $fulltime[0];
                        }
                       
                    }
                    
                }

                // lateness and late count
                if (strtotime($intime) > strtotime($entry_range)) {
                    $late_emp += 1;
                } elseif (!$intime && $break) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && $resume) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && !$resume && $out_time) {
                    $late_emp += 1;
                }

                $intime = '';
                $break = '';
                $resume = '';
                $out_time = '';
           
            }
       
            $absent_emp                           = $empTotal - count($attendanceData);
            $return_arr['unAssignedEmp']          = $unAssignedEmp;
            $return_arr['late_emp']               = $late_emp;
            $return_arr['present_emp']            = count($attendanceData);
            $return_arr['total_emp']              = $empTotal;
            $return_arr['absent_emp']             = $absent_emp;
            $return_arr['month']                  = $month;
            $return_arr['year']                   = $year;

            //dd($return_arr);
            return response()->json($return_arr);
        }

        if($request->data_type == "late_data"){

            if($request->sdatefrom){
                $sdatefrom = $request->sdatefrom;
            }else{
                $sdatefrom = date("Y-m-d");
            }

            if($request->sdateto){
                $sdateto = $request->sdateto;
            }else{
                $sdateto = date("Y-m-d");
            }

            
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
            ->select('clk.working_day', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'up.name', 'sch.*', 'user_pay.branch_id', 'user_pay.department_id', 'user_pay.date_attendance_start',
                DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))

            ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
            ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username')

            ->leftJoin(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no');
            
            
            // roster
            $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) {
                $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->whereRaw('duty_roaster_dates.date = clk.working_day');
            });

            $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                $joinss->on('duty_roaster_dates.schedule_id' , '=', 'sch.schedule_id')
                    ->whereRaw('sch.week_day = date_format(clk.working_day,\'%a\')');
            });
                
            
            $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
                // filter
                
            $attendanceDatad->where('clk.working_day', '>=', "$sdatefrom")->where('clk.working_day', '<=', "$sdateto");

            $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
            
            if ($ActiveUserShownStatus == '0') {
                $attendanceDatad->where('user_pay.pay_status', '=', 1);
            }
            // // filter


            $attendanceData = $attendanceDatad->groupBy(['up.employee_no', 'clk.working_day'])->orderBy('clk.working_day', 'DESC')->orderBy('up.employee_no', 'ASC')->get();
            // dd($attendanceData);

            for ($i = 0; $i < count($attendanceData); $i++) {
                $attendance_data =  $attendanceData[$i];
                $fulltime = explode('==', $attendance_data->fulltime);
                $entry_time = $attendance_data->entry;
                $break_time = $attendance_data->break;
                $resume_time = $attendance_data->user_resume;
                $leave_time = $attendance_data->user_leave;
                $schedule_range = $attendance_data->schedule_range;
                $flexi_lunch = $attendance_data->flexi_lunch;
                $min_ot = $attendance_data->min_ot;
                $min_flexi_hour = $attendance_data->min_flexi_hour;
                $user_schedule = $attendance_data->schedule_id;

                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));
                $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                

                $intime = '';
                $break = '';
                $resume = '';
                $out_time = '';
                sort($fulltime);



                $total_fultime = count($fulltime);

                for ($a = 0; $a < $total_fultime; $a++) {
                    $emp_time = $fulltime[$a];
                    

                    // entry time
                    if ($attendance_data->day_type == 'Work') {
                        if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                            $intime = $emp_time;
                            continue;
                        }

                        // break_times
                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                            $break = $emp_time;
                            continue;
                        }


                        //   resume_time
                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                            $resume = $emp_time;
                            continue;
                        } else {
                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                $resume = $emp_time;
                                continue;
                            }
                        }

                        //   out
                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                            $out_time = $emp_time;
                            continue;
                        }
                    } elseif ($attendance_data->day_type == 'Flexi') {

                        if ($a == '0') {
                            $intime = $emp_time;
                            continue;
                        } elseif ($a == ($total_fultime - 1)) {
                            $out_time = $emp_time;
                            continue;
                        } elseif ($a == '1') {
                            $break = $emp_time;
                            continue;
                        } elseif ($a == '2') {
                            $resume = $emp_time;
                            continue;
                        }
                    }else{
                        if($user_schedule && $break_range_min != "00:00" && $resume_range_min != "00:00" && $resume_range_max != "00:00" && $min_ot_range != "00:00"){
                            
                            if ($a == '0' && strtotime($emp_time) < strtotime($break_range_min)) {
                                $intime = $emp_time;
                                continue;
                            }
                    
                            // break_times
                            if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                $break = $emp_time;
                                continue;
                            }


                            //   resume_time
                            if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                $resume = $emp_time;
                                continue;
                            } else {
                                if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                    $resume = $emp_time;
                                    continue;
                                }
                            }

                            //   out
                            if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                $out_time = $emp_time;
                                continue;
                            }
                        }else{
                            if(count($fulltime) > 1){
                                $intime = $fulltime[0];
                                $out_time = end($fulltime);
                            }else{
                                $intime = $fulltime[0];
                            }
                        }   

                    }
                }

                $lunch_text_color = $in_text_color = $leave_text_color = 'black';
                $emp_lunch = (strtotime($resume) - strtotime($break));

                if (strtotime($intime) > strtotime($entry_time)) {
                    $in_text_color = "red";
                }
            
                $attendance_data->intime = $intime;
                $attendance_data->branch_id = getBranchNameById($attendance_data->branch_id);
                $attendance_data->department_id = getDepartmentNameById($attendance_data->department_id);
                
                $attendance_data->filter_val = 0;
      
            }
            $filter = $attendanceData;
            
            // dd($filter);
            
            
            $filtered = [];
            foreach($filter as $data){
                $schedule_range = $data->schedule_range;
                $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($data->entry)));

                if(strtotime($data->intime) > strtotime($entry_range) && $entry_range != "00:00"){
 
                    $intime = date("H:i", strtotime($data->intime));
             
                    if(strtotime($intime) > strtotime($entry_range)){
                        $lateness = date("H:i", strtotime($intime) - strtotime($entry_range));
                    }else{
                        $lateness = 0;
                    }
                    if(strtotime($lateness)){
                        $data->lateness = $lateness;
                        array_push($filtered, $data);
                    }
                    
                }
            }
            // dd($filtered);
            return DataTables::of($filtered)->make(true);
            
        }
    }
    
    // my changes
    public function empDashboardData(Request $request)
    {
        

        if($request->dataType == "counter"){
            $user_type = $request->user_type;
            $emp_no = $request->emp_no;
            $month =   $request->month;
            $year =  $request->year;
            $chartype = $request->chartype;
            $day_type = '';
            $late_emp = '0';
            $lateness = '0';
            $early_dep = '0';
            $present_emp = '0';
            $overtimes_emp = '0';
            $intime = '';
            $break = '';
            $resume = '';
            $out_time = '';
            $overtime = '';
            $total_days =   cal_days_in_month(CAL_GREGORIAN, $month, $year);
            $startDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-01')->startOfDay()->toDateString();
            $endDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-' . $total_days)->endOfDay()->toDateString();
            $end_of_month = Carbon::now()->endOfMonth()->toDateString();
            $current_date = Carbon::now()->toDateString();
            $sdatefrom = ($chartype == 'today') ? $current_date : $startDate;
            $sdateto =  ($chartype == 'today') ? $current_date : $endDate;
            $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
            $dates = $dateRange->toArray();
    
            $to_month = $request->to_month;
            
            if(isset($to_month)){
                if($month == date("m") && $year == date("Y")){
                    $dateFrom = date_format(date_create(date('Y-m')."-01"),"Y-m-d");
                    $dateTo = date("Y-m-d");
                    $getDays = date('d'); 
                }else{
                    $dateFrom = date_format(date_create(date($year.'-'.$month)."-01"),"Y-m-d");
                    $getDays = Carbon::now()->month($month)->daysInMonth;;
                    $dateTo = date($year.'-'.$to_month.'-'.$getDays);
                }
            }else{
            
                if($month == date("m") && $year == date("Y")){
                    $dateFrom = date_format(date_create(date('Y-m')."-01"),"Y-m-d");
                    $dateTo = date("Y-m-d");
                    $getDays = date('d'); 
                }else{
                    $dateFrom = date_format(date_create(date($year.'-'.$month)."-01"),"Y-m-d");
                    $getDays = Carbon::now()->month($month)->daysInMonth;;
                    $dateTo = date($year.'-'.$month.'-'.$getDays);
                }
            }

            $checkAtt = UserPay::where('username', '=', getUserName($emp_no))->first();
            if(isset($checkAtt) && $checkAtt->date_attendance_start == null){
                $getDays = 0;
            }
        
            $attendanceDatad = DB::table(DB::raw('user_personal up'))
                ->select('clk.working_day', 'sch.*', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.date_attendance_start',
                    DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))
                    
                ->join(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
        
                ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
                

                // roster
                $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) use($dateFrom, $dateTo) {
                    $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                    ->where('duty_roaster_dates.date', 'clk.working_day');
                });
                
            
                
                
                $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                    $joinss->on('duty_roaster_dates.schedule_id', '=', 'sch.schedule_id')  
                    ->whereRaw('sch.week_day = date_format(clk.working_day,\'%a\')')
                    ;
                });
        

                $attendanceDatad->whereBetween('clk.working_day', [$dateFrom, $dateTo]);
                $attendanceDatad->where('up.employee_no', '=', $emp_no);
                
                
                $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
                
                //active status
            $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

            if ($ActiveUserShownStatus == '0') {
                $attendanceDatad->where('user_pay.pay_status', '=', '1');
            }

            // active status
            

            $attendanceData = $attendanceDatad->groupBy('clk.working_day')->orderBy('clk.date', 'DESC')->get();
            // dd($attendanceData);

            for ($i = 0; $i < count($attendanceData); $i++) {
                $attendance_data =  $attendanceData[$i];
                $fulltime = explode('==', $attendance_data->fulltime);
                $entry_time = $attendance_data->entry;
                $break_time = $attendance_data->break;
                $resume_time = $attendance_data->user_resume;
                $leave_time = $attendance_data->user_leave;
                $schedule_range = $attendance_data->schedule_range;
                $flexi_lunch = $attendance_data->flexi_lunch;
                $min_ot = $attendance_data->min_ot;
                $min_flexi_hour = $attendance_data->min_flexi_hour;
                $min_flexi_hour = $attendance_data->min_flexi_hour;

        
                sort($fulltime);
                $total_fultime = count($fulltime);
        
            
                for ($a = 0; $a < $total_fultime; $a++) {
                    $emp_time = $fulltime[$a];
                    
                    $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));

                    $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                    $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                    $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                

                    // entry time
                    if ($attendance_data->day_type == 'Work') {
                    
                        // intime
                        if ($a == 0 && strtotime($emp_time) < strtotime($break_range_min)) {
                            $intime = $emp_time;
                            continue;
                        }
        
                        // break_times
                        if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                            $break = $emp_time;
                            continue;
                        }
                        
                        //   resume_time
                        if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                            $resume = $emp_time;
                            continue;
                        } else {
                            if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                $resume = $emp_time;
                                continue;
                            }
                        }
                        
                        //   out
                        if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                            $out_time = $emp_time;
                            continue;
                        }
                        
                    }elseif ($attendance_data->day_type == 'Flexi') {
                        if ($a == '0') {
                            $intime = $emp_time;
                            continue;
                        } elseif ($a == ($total_fultime - 1)) {
                            $out_time = $emp_time;
                            continue;
                        } elseif ($a == '1') {
                            $break = $emp_time;
                            continue;
                        } elseif ($a == '2') {
                            $resume = $emp_time;
                            continue;
                        }
                    
                    }
                    
                }
                // dd($break);
                // lateness and late count
                if (strtotime($intime) > strtotime($entry_range)) {
                    $late_emp += 1;
                    $lateness = date('H:i', strtotime($lateness) + strtotime($intime) - strtotime($entry_time));
                } elseif (!$intime && $break) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && $resume) {
                    $late_emp += 1;
                } elseif (!$intime && !$break && !$resume && $out_time) {
                    $late_emp += 1;
                }
                
                // early dep
                if ((strtotime($out_time) < strtotime($leave_time)) && $out_time) {
                    $early_dep = date('H:i', strtotime($early_dep) + strtotime($leave_time) - strtotime($out_time));
                }

                if (($intime || $out_time || $break || $resume) && ($attendance_data->day_type == 'Work' || $attendance_data->day_type == 'Flexi')) {
                    if (!$early_dep) {

                        if (!$lateness && $break) {
                            $lateness = date('H:i', strtotime($lateness) + strtotime($break) - strtotime($entry_time));
                        } elseif (!$lateness && $resume) {
                            $lateness = date('H:i', strtotime($lateness) + strtotime($resume) - strtotime($entry_time));
                        } elseif (!$lateness && $out_time) {
                            $lateness = date('H:i', strtotime($lateness) + strtotime($out_time) - strtotime($entry_time));
                        }
                    }
                    $present_emp += 1;
                }
            
                // overtime
                if (strtotime($out_time) >= strtotime($min_ot_range)) {
                    $overtimes_emp += 1;
                    $overtime =  date('H:i', strtotime($overtime) + strtotime($out_time) - strtotime($leave_time));
                }

                $day_type = $attendance_data->day_type;
            
                $intime = '';
                $break = '';
                $resume = '';
                $out_time = '';
        
            }
    
            
            $absent_emp                           = $getDays - count($attendanceData);
            $return_arr['late_emp']               = $late_emp;
            $return_arr['present_emp']            = count($attendanceData);
            $return_arr['total_emp']              = count($attendanceData);
            $return_arr['absent_emp']             = $absent_emp;
            $return_arr['month']                  = $month;
            $return_arr['year']                   = $year;
            $return_arr['day_type']               = $day_type;
            $return_arr['overtime']               = ($overtime) ? $overtime : 0;
            $return_arr['overtimes_emp']          = $overtimes_emp;
            $return_arr['lateness']               = $lateness;
            $return_arr['early_dep']              = $early_dep;
            $return_arr['total_days']             = $total_days;
            $return_arr['total_absent']           = $absent_emp;

            // dd($return_arr);
            return response()->json($return_arr);
        }

        if($request->dataType == "bar"){

                $user_type = $request->user_type;
                $emp_no = $request->emp_no;
                $month =   1;
                $year =  $request->year;
                $chartype = $request->chartype;
                $day_type = '';
                $late_emp = '0';
                $lateness = '0';
                $early_dep = '0';
                $present_emp = '0';
                $overtimes_emp = '0';
                $intime = '';
                $break = '';
                $resume = '';
                $out_time = '';
                $overtime = '';
                $total_days =   cal_days_in_month(CAL_GREGORIAN, $month, $year);
                $startDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-01')->startOfDay()->toDateString();
                $endDate = Carbon::createFromFormat('Y-m-d', $year . '-' . $month . '-' . $total_days)->endOfDay()->toDateString();
                $end_of_month = Carbon::now()->endOfMonth()->toDateString();
                $current_date = Carbon::now()->toDateString();
                $sdatefrom = ($chartype == 'today') ? $current_date : $startDate;
                $sdateto =  ($chartype == 'today') ? $current_date : $endDate;
                $dateRange = CarbonPeriod::create($sdatefrom, $sdateto);
                $dates = $dateRange->toArray();
        
                $to_month = $request->to_month;
                
                if(isset($to_month)){
                    if($month == date("m") && $year == date("Y")){
                        $dateFrom = date_format(date_create(date('Y-m')."-01"),"Y-m-d");
                        $dateTo = date("Y-m-d");
                        $getDays = date('d'); 
                    }else{
                        $dateFrom = date_format(date_create(date($year.'-'.$month)."-01"),"Y-m-d");
                        $getDays = Carbon::now()->month($month)->daysInMonth;;
                        $dateTo = date($year.'-'.$to_month.'-'.$getDays);
                    }
                }else{
                    if($month == date("m") && $year == date("Y")){
                        $dateFrom = date_format(date_create(date('Y-m')."-01"),"Y-m-d");
                        $dateTo = date("Y-m-d");
                        $getDays = date('d'); 
                    }else{
                        $dateFrom = date_format(date_create(date($year.'-'.$month)."-01"),"Y-m-d");
                        $getDays = Carbon::now()->month($month)->daysInMonth;
                        $dateTo = date($year.'-'.$month.'-'.$getDays);
                    }
                }

               
                
                $attendanceDatad = DB::table(DB::raw('user_personal up'))
                    ->select('clk.working_day', 'sch.*', 'up.employee_no', 'up.schedule_id','up.duty_roaster_id', 'up.username', 'user_pay.date_attendance_start',
                        DB::raw('(GROUP_CONCAT(TIME SEPARATOR \'==\')) AS fulltime'))
                        
                    ->join(DB::raw('clockin clk'), 'up.employee_no', '=', 'clk.employee_no')
            
                    ->leftJoin('user_pay', 'up.username', '=', 'user_pay.username')
                    ->leftJoin(DB::raw('users'), 'up.username', '=', 'users.username');
                    

                    // roster
                    $attendanceDatad->leftJoin(DB::raw('duty_roaster_dates'), function ($joins) use($dateFrom, $dateTo) {
                        $joins->on('up.duty_roaster_id', '=', 'duty_roaster_dates.duty_roaster_id')
                        ->where('duty_roaster_dates.date', 'clk.working_day');
                    });

                    $attendanceDatad->leftJoin(DB::raw('schedule_week sch'), function ($joinss) {
                        $joinss->on('duty_roaster_dates.schedule_id', '=', 'sch.schedule_id')  
                        ->whereRaw('sch.week_day = date_format(clk.working_day,\'%a\')')
                        ;
                    });
            

                    $attendanceDatad->whereYear('clk.working_day', $year);
                    $attendanceDatad->where('up.employee_no', '=', $emp_no);
                    
                    
                    $attendanceDatad->whereRaw('clk.working_day >= date_format(user_pay.date_attendance_start, "%Y-%m-%d")');
                    
                    //active status
                    $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
                    $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

                    if ($ActiveUserShownStatus == '0') {
                        $attendanceDatad->where('user_pay.pay_status', '=', '1');
                    }

                    // active status
                    

                $attendanceDatas = $attendanceDatad->groupBy('clk.working_day')->orderBy('clk.date', 'DESC')->get();
                $monthData = [];
                foreach($attendanceDatas as $attendanceData){
                    $m = date('n', strtotime($attendanceData->working_day));
                    if(isset($monthData[$m])){
                        array_push($monthData[$m], json_decode(json_encode($attendanceData),true));
                    }
                    else{
                     $monthData[$m]= [];
                     $monthData[$m][0]= json_decode(json_encode($attendanceData),true);
                    }
                }  
                if($year == date("Y")){
                    $mm = date("m");
                }else{
                    $mm = 12;
                }
                $finalMonth = [];
                for ($i = 1; $i <=$mm; $i++) {
                    $finalMonth[$i] = $monthData[$i]??[];
                }

                $finalRes = [];
                foreach($finalMonth as $key=>$attendanceData){
                   
                    for ($i = 0; $i < count($attendanceData); $i++) {
                        $attendance_data =  (object)$attendanceData[$i];
                        $fulltime = explode('==', $attendance_data->fulltime);
                        $entry_time = $attendance_data->entry;
                        $break_time = $attendance_data->break;
                        $resume_time = $attendance_data->user_resume;
                        $leave_time = $attendance_data->user_leave;
                        $schedule_range = $attendance_data->schedule_range;
                        $flexi_lunch = $attendance_data->flexi_lunch;
                        $min_ot = $attendance_data->min_ot;
                        $min_flexi_hour = $attendance_data->min_flexi_hour;
                        $min_flexi_hour = $attendance_data->min_flexi_hour;

                
                        sort($fulltime);
                        $total_fultime = count($fulltime);
                
                    
                        for ($a = 0; $a < $total_fultime; $a++) {
                            $emp_time = $fulltime[$a];
                            
                            $entry_range = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($entry_time)));

                            $break_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($break_time)));
                            $resume_range_min = date('H:i', strtotime('-' . $schedule_range . ' minutes', strtotime($resume_time)));
                            $resume_range_max = date('H:i', strtotime('+' . $schedule_range . ' minutes', strtotime($resume_time)));
                            $min_ot_range =  date('H:i', strtotime('+' . $min_ot . ' minutes', strtotime($leave_time)));
                        

                            // entry time
                            if ($attendance_data->day_type == 'Work') {
                            
                                // intime
                                if ($a == 0 && strtotime($emp_time) < strtotime($break_range_min)) {
                                    $intime = $emp_time;
                                    continue;
                                }
                
                                // break_times
                                if ((!$break) &&  (strtotime($emp_time) >= strtotime($break_range_min)) && (strtotime($emp_time) < strtotime($resume_range_min))) {
                                    $break = $emp_time;
                                    continue;
                                }
                                
                                //   resume_time
                                if (($break) && (strtotime($emp_time) >  strtotime($break)) && (strtotime($resume_range_max) >= strtotime($emp_time))) {
                                    $resume = $emp_time;
                                    continue;
                                } else {
                                    if ((strtotime($emp_time) >= strtotime($resume_range_min)) && (strtotime($emp_time) <= strtotime($resume_range_max))) {
                                        $resume = $emp_time;
                                        continue;
                                    }
                                }
                                
                                //   out
                                if ($a == ($total_fultime - 1) &&  strtotime($emp_time) > strtotime($resume_range_max)) {
                                    $out_time = $emp_time;
                                    continue;
                                }
                                
                            }elseif ($attendance_data->day_type == 'Flexi') {
                                if ($a == '0') {
                                    $intime = $emp_time;
                                    continue;
                                } elseif ($a == ($total_fultime - 1)) {
                                    $out_time = $emp_time;
                                    continue;
                                } elseif ($a == '1') {
                                    $break = $emp_time;
                                    continue;
                                } elseif ($a == '2') {
                                    $resume = $emp_time;
                                    continue;
                                }
                            
                            }
                            
                        }
                        // dd($break);
                        // lateness and late count
                        if (strtotime($intime) > strtotime($entry_range)) {
                            $late_emp += 1;
                            $lateness = date('H:i', strtotime($lateness) + strtotime($intime) - strtotime($entry_time));
                        } elseif (!$intime && $break) {
                            $late_emp += 1;
                        } elseif (!$intime && !$break && $resume) {
                            $late_emp += 1;
                        } elseif (!$intime && !$break && !$resume && $out_time) {
                            $late_emp += 1;
                        }
                        
                        // early dep
                        if ((strtotime($out_time) < strtotime($leave_time)) && $out_time) {
                            $early_dep = date('H:i', strtotime($early_dep) + strtotime($leave_time) - strtotime($out_time));
                        }

                        if (($intime || $out_time || $break || $resume) && ($attendance_data->day_type == 'Work' || $attendance_data->day_type == 'Flexi')) {
                            if (!$early_dep) {

                                if (!$lateness && $break) {
                                    $lateness = date('H:i', strtotime($lateness) + strtotime($break) - strtotime($entry_time));
                                } elseif (!$lateness && $resume) {
                                    $lateness = date('H:i', strtotime($lateness) + strtotime($resume) - strtotime($entry_time));
                                } elseif (!$lateness && $out_time) {
                                    $lateness = date('H:i', strtotime($lateness) + strtotime($out_time) - strtotime($entry_time));
                                }
                            }
                            $present_emp += 1;
                        }
                    
                        // overtime
                        if (strtotime($out_time) >= strtotime($min_ot_range)) {
                            $overtimes_emp += 1;
                            $overtime =  date('H:i', strtotime($overtime) + strtotime($out_time) - strtotime($leave_time));
                        }

                        $day_type = $attendance_data->day_type;
                    
                        $intime = '';
                        $break = '';
                        $resume = '';
                        $out_time = '';
                
                    }

                    $getDays = Carbon::now()->month($key)->daysInMonth;
                    $checkAtt = UserPay::where('username', '=', getUserName($emp_no))->first();
                    if(isset($checkAtt) && $checkAtt->date_attendance_start == null || date('m', strtotime($checkAtt->date_attendance_start)) >= $key+1 && date('Y', strtotime($checkAtt->date_attendance_start)) >= $year){
                        $getDays = 0;
                        $attendanceData = [];
                    }
                    
                    $absent_emp                           = $getDays - count($attendanceData);
                    $return_arr['present_emp']            = count($attendanceData);
                    $return_arr['total_absent']           = $absent_emp;
                    $return_arr['late_emp']               = $late_emp;
                    $return_arr['overtimes_emp']          = $overtimes_emp;

                    $finalRes[$key] = $return_arr;
                }

            return response()->json($finalRes);
        }
    }

  
     public function getShcedule(Request $request)
   

{
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;


        $inner_qry = '(SELECT count(*) as total_rec,(SELECT name FROM schedule WHERE id = user_personal.schedule_id) as schedule_id  FROM `user_personal`';
        if ($ActiveUserShownStatus == '0') {
            $inner_qry .= ' left join `user_pay` on `user_personal`.`username` = `user_pay`.`username` where `user_pay`.`pay_status` = 1';
        }
        $inner_qry .= ' GROUP by schedule_id ORDER by total_rec DESC) as user_table';

        $scheduledata =  DB::table(DB::raw($inner_qry))
            ->select(DB::raw('GROUP_CONCAT(total_rec) as total_recc'), DB::raw('GROUP_CONCAT(schedule_id) as schedule_id'))
            ->get();


        $total_recc =  explode(',', $scheduledata[0]->total_recc);
        $schedule_name =  explode(',', $scheduledata[0]->schedule_id);
        $schedule_id =  $request->schedule_id;
        $schedule_data =  Schedule::where('id', $schedule_id)->get();
        $total_employee = UserPersonal::where('isDeleted', '0')->count();
        $sch_to_empp = UserPersonal::where('schedule_id', $schedule_id)->where('isDeleted', '0');

        $sch_to_emp = $sch_to_empp->count();

        $result['schedule_rec'] =  $total_recc;
        $result['schedule_name'] =  $schedule_name;

        $result['sch_to_emp'] =  $sch_to_emp;
        return response()->json($result);
    }
    
    
    // hide show columns setting
    public function hideShowSetting(Request $request){
        $c_key = $request->c_key;
        $c_value = $request->value;
        
        if($request->actionType == "add"){
            $check = DB::table('hide_show_columns')->where(['c_key'=> $c_key, 'username'=>getUserNameByRowId(Auth::id())])->first();

            if($check){
                // update
                $oldValues = json_decode($check->c_value);
                array_push($oldValues, $c_value);
                $newValues = json_encode($oldValues);
                DB::table('hide_show_columns')->where(['c_key'=> $c_key, 'username'=>getUserNameByRowId(Auth::id())])->update(['c_value'=>$newValues]);
                return 1;
            }else{
                // insert
                $c_value = json_encode(array($c_value));
                DB::table('hide_show_columns')->where('c_key', $c_key)->insert(['c_key'=>$c_key, 'c_value'=>$c_value, 'username'=>getUserNameByRowId(Auth::id())]);
                return 1;
            }
        }elseif($request->actionType == "remove"){
            $check = DB::table('hide_show_columns')->where(['c_key'=> $c_key, 'username'=>getUserNameByRowId(Auth::id())])->first();

            if($check){
                $oldValues = json_decode($check->c_value);
                $c_value_enc = array($c_value);
                if(in_array($c_value, $oldValues)){
                    $newValues = array_diff($oldValues, $c_value_enc);
                  
                    $newValues = json_encode(array_values($newValues));
                    DB::table('hide_show_columns')->where(['c_key'=> $c_key, 'username'=>getUserNameByRowId(Auth::id())])->update(['c_value'=>$newValues]);
                    
                    return 1;
                }
            }
        }
    }
    
    public function hideShowData(Request $request){
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$request->c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
            $columnHideShowData = json_decode($columnHideShowData);
        }else{
            $columnHideShowData = array("");
        }

        return $columnHideShowData;
    }


    //=============================== assign att to emp =============================
    //=============================== assign att to emp =============================
    
    public function assignAttToEmp(){
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        $dutyraoster = DutyRoster::select('name', 'id')->get();
        $dutyroasterData = UserPersonal::select('user_personal.name as name', 'user_personal.username', 'duty_roaster.name as sname')
            ->leftJoin('duty_roaster', 'user_personal.duty_roaster_id', '=', 'duty_roaster.id')->whereNull('user_personal.duty_roaster_id')->get();
           
        return view('E-Attendance.attendance_to_emp', compact('dutyroasterData','dutyraoster'));
    }

    public function empAttdata(Request $request)
    {

        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        $empAttData = UserPersonal::select('user_personal.name as name', 'user_personal.username')
            ->leftJoin('user_pay', 'user_personal.username', '=', 'user_pay.username')->whereNull('user_pay.date_attendance_start');
            if ($ActiveUserShownStatus == '0') {
                $empAttData->where('user_pay.pay_status', '=', '1');
            }
        $empAttData= $empAttData->get();
        return DataTables::of($empAttData)->make(true);
    }

    public function mapAttendanceStartDate(Request $request){
        $emp_arr = json_decode($request->employee_id);
        
        $userpersonal['date_attendance_start'] = $request->att_start;
        $result = UserPay::whereIn('username', $emp_arr)->update($userpersonal);

        return true;
    }

    public function employeeAttListDate(Request $request){
    
        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;

        $empAttData = UserPersonal::select('user_personal.name as name','user_personal.username', 'user_pay.date_attendance_start')->leftjoin('user_pay', 'user_personal.username', '=', 'user_pay.username');

        if ($request->type == 'assign'){
            $empAttData = $empAttData->whereNotNull('user_pay.date_attendance_start');
        }else if(($request->type == 'not_assign')){
            $empAttData = $empAttData->whereNull('user_pay.date_attendance_start');
        }
        if ($ActiveUserShownStatus == '0') {
            $empAttData = $empAttData->where('user_pay.pay_status', '=', '1');
        }

        $empAttData =  $empAttData->get();
        // dd($empAttData);
        $empAttData->map(function ($item, $index) {
            $index++;
            $item->name = $item->name;
            if(isset($item->date_attendance_start)){
                $item->date_attendance_start = date('d-m-Y', strtotime($item->date_attendance_start));
                $item->date = date('Y-m-d', strtotime($item->date_attendance_start));
            }else{
                $item->date_attendance_start = " ";
                $item->date = "";
            }
            

            return $item;
        });
        // dd($empAttData);
        return DataTables::of($empAttData)->make(true);

    }


    public function updatedAttList(Request $request){
        $att_start = $request->att_start;
        $empUsername = $request->empUsername;
        UserPay::where('username', $empUsername)->update(['date_attendance_start' => $att_start]);
        return true;
    }

    public function unassignAttendanceStart(Request $request)
    {
        $empUsername = json_decode($request->empUsernames);
        UserPay::whereIn('username',$empUsername)
        ->update(['date_attendance_start' =>NULL]);
        return true;     
    }

  
    //=============================== assign att to emp end =============================
    //=============================== assign att to emp  end =============================



    // ========================== request ot  ================================
    // ========================== request ot  ================================

    public function otRequest(){
        
        $user = User::where('id', Auth::id())->first();
        $upaydetails = UserPersonal::where('username', $user->username)->first();
        if ($upaydetails->sex == 1) {
            $leaveTypes = DB::table('leave_name')->where('type', '!=', 'Maternity')->where('company_id', $user->company_id)->where('is_show', 1)->get();
        } else {
            $leaveTypes = DB::table('leave_name')->where('is_show', 1)->get();
        }
        $relieves = DB::table('user_personal')->leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $employees = DB::table('map_employee_approver')->where('approver_id', $user->username)->leftjoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->selectRaw("map_employee_approver.employee_id, user_personal.name ")->groupBy('map_employee_approver.employee_id')->orderby('user_personal.name', 'asc')->get();

        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        $holidays = DB::table('public_holiday')->where('company_id', $user->company_id)->where('date', '>=', $startOfYear->format('Y-m-d'))->where('date', '<=', $endOfYear->format('Y-m-d'))->get();
        $requestOT = DB::table('ot_requests')->where('ot_requests.status', '1')->where('ot_requests.username', $user->username)->get();
        // dd($requestOT);

        $requestOT->transform(function ($item) {
            
            $item->background_color = "#4298a1";
            
            $employee = DB::table('user_personal')->where('username', $item->username)->first();
            $r_name = $employee->name;

            $time = '(' . date('h:i A', strtotime($item->from_time)) . ' to ' . date('h:i A', strtotime($item->to_time)) . ')';
     
            return [
                'title' => $r_name . ' ' . $time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->working_day)),
            ];
        })->toArray();


        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();

        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function ($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
            ->whereYear('date', '=', date('Y'))->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function ($item11) {

            return [
                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();
        $ot = $restDay->merge($requestOT);
        $reqOt = $ot->merge($recentHoliday);
        
        // $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        return view('E-Attendance.approvals.ot-request', compact('leaveTypes', 'relieves', 'employees', 'holidays', 'reqOt'));
    }

    public function addOtRequest(Request $request){
        $user = User::where('id', Auth::id())->first();
        $check = OtRequest::where(['working_day'=> $request->working_day, 'username'=>$user->username])->count();
        
        if($check == 0){
            $data = new OtRequest();
            $data->working_day = $request->working_day;
            $data->from_time = $request->time_from;
            $data->to_time = $request->time_to;
            $data->reason = $request->reason;
            $data->username = $user->username;
            $res = $data->save();
            if($res){
                return true;
            }
        }else{
            return false;
        }
    }

    public function empOtData(){
        $user = User::where('id', Auth::id())->first();
        $data = OtRequest::where('username', $user->username)->orderBy('id', 'DESC')->get();
        
        $data->map(function ($item) {
            $item->working_date = date('d-m-Y', strtotime($item->working_day));
            $item->applied_date = date('d-m-Y', strtotime($item->created_at));
            $item->time = date('H:i A', strtotime($item->from_time)) ."-". date('H:i A', strtotime($item->to_time));
            $item->hrs = date('H:i', strtotime($item->to_time) - strtotime($item->from_time));
            if($item->status == 0){
                $item->status = "Pending";
            }elseif($item->status == 1){
                $item->status = "Approved";
            }elseif($item->status == 2){
                $item->status = "Rejected";
            }
            
            return $item;
        });
        // dd($data);
        return DataTables::of($data)->make(true);
    }

    public function updatedOTList(Request $request){
        $user = User::where('id', Auth::id())->first();
        
        $data = OtRequest::where(['id'=>$request->id, 'username'=>$user->username])->where('status', '!=', 1)->first();
        if($data){
            $data->working_day = $request->date;
            $data->from_time = $request->from_time;
            $data->to_time = $request->to_time;
            $data->reason = $request->reason;
            $res = $data->save();
            if($res){
                return 2;
            }
        }else{
            return 1;
        }
    }

    public function deleteRequestOT(Request $request){
        $user = User::where('id', Auth::id())->first();
        $check = OtRequest::whereIn('id', json_decode($request->ot_id))->where('username', $user->username)->where('status', '!=', 1)->first();
        $res = OtRequest::whereIn('id', json_decode($request->ot_id))->where('username', $user->username)->where('status', '!=', 1)->delete();
        if($check){
            return 1;
        }else{
            return 2;
        }
    }

    public function approvalList(){
        return view('E-Attendance.approvals.approval-list');
    }

    public function allEmpOtData(Request $request){
        $sDate = $request->sdatefrom;
        if(isset($request->sdateto) && $request->sdateto!= " "){
            $eDate = $request->sdateto;
        }else{
            $eDate = date("Y-m-d");
        }
    
        $data = OtRequest::select('ot_requests.*', 'map_employee_approver.approver_id')
                ->join('map_employee_approver', 'map_employee_approver.employee_id', '=', 'ot_requests.username')
                ->where('map_employee_approver.approver_id', Auth::user()->username);

            if($sDate){
                $data->whereDate('ot_requests.created_at', '>=', $sDate)->whereDate('ot_requests.created_at', '<=', $eDate); 
            }
                
        $data = $data->orderBy('id', 'DESC')->get();

        $data->map(function ($item) {
            $user = UserPersonal::where('username', $item->username)->first();

            $item->emp_name = $user->name??null;
            $item->emp_id = $user->employee_no??null;

            $item->working_date = date('d-m-Y', strtotime($item->working_day));
            $item->applied_date = date('d-m-Y', strtotime($item->created_at));
            $item->time = date('H:i A', strtotime($item->from_time)) ."-". date('H:i A', strtotime($item->to_time));
            $item->hrs = date('H:i', strtotime($item->to_time) - strtotime($item->from_time));
            
            return $item;
        });
        // dd($data);
        return DataTables::of($data)->make(true);
    }

    public function approveOTUsers(Request $request){
        // dd($request);
        $data = [
            'status' => $request->status,
            'cancel_reason'=> $request->reason??null
        ];
        $res = OtRequest::whereIn('id', $request->ids)->update($data);
        if($res){
            return true;
        }else{
            return false;
        }
    }
    
}