<?php

namespace App\Http\Controllers;
use App\Models\{Department,Category,Branch,User ,EclaimType, EclaimtypeField,Detail,EclaimEmployee,UserPersonal,UserPay, EclaimAudit};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Dompdf\Dompdf;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Yajra\DataTables\Facades\DataTables;

use Illuminate\Support\Facades\Storage;

class EclaimController extends Controller
{
    protected $storageDriver;

    public function __construct() {
        $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }
    
     public function dashboard(){
                $c_key = 'claim_dashbaord';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
        return view('E-Claim.dashboard',compact('eclaimFinanceSkipSetting', 'c_key', 'columnHideShowData'));
     }
     
     public function getEClaimListForApproval(Request $request){
        $user = User::where('id' , Auth::id())->first();
        $approver_id = (isset($request->approver_id)? $request->approver_id: $user->username);
		
		$main_array= DB::table('eclaim_employee as ee')->leftjoin('user_personal as up','up.username','=','ee.employee_id')
		            ->leftjoin('user_personal as approver_up','approver_up.username','=','ee.approver_id')
		            ->leftjoin('eclaimtype as et','et.id','=','ee.eclaimtype_id')
		            ->selectRaw("ee.id,from_unixtime(ee.created,'%Y-%m-%d') as created,up.name,approver_up.name as approver_name,et.type_name,ee.total_amount,from_unixtime(ee.billing_date,'%Y-%m-%d') as billing_date, case  when ee.status='1' then 'Not Approved' when ee.status='2' then 'Approved'  when ee.status='4' then 'Paid' else 'Rejected' end as status_text,status, filename, ee.employee_id,ee.eclaimtype_id")
		            ->where('status','<','3')->where('approver_id',$approver_id)->get();
		 $main_array->map(function($item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
		    $item->status_text=$status;
            $fields = DB::table('eclaim_employee_field_value as eefv')
                    ->leftjoin('eclaimtype_fields as ef','ef.id','=','eefv.eclaimtype_fields_id')
                    ->where('eefv.eclaim_employee_id',$item->id)
                    ->where('ef.id','!=',null)->selectRaw('eefv.id,ef.field_name,eefv.value')->groupBy('ef.id')->orderBy('ef.id','asc')->limit(2)->get();
            $item->fields = $fields;
        });
		
		return DataTables::of($main_array)->make(true);
     }
     
     public function getEClaimListForFinancer(Request $request){
          $user = User::where('id' , Auth::id())->first();
        $approver_id = (isset($request->approver_id)? $request->approver_id: $user->username);
		
		$data= DB::table('eclaim_employee as ee')->leftjoin('user_personal as up','up.username','=','ee.employee_id')
		            ->leftjoin('user_personal as approver_up','approver_up.username','=','ee.approver_id')
		            ->leftjoin('eclaimtype as et','et.id','=','ee.eclaimtype_id')
		            ->selectRaw("ee.id,from_unixtime(ee.created,'%Y-%m-%d') as created,up.name,approver_up.name as approver_name,et.type_name,ee.total_amount,from_unixtime(ee.billing_date,'%Y-%m-%d') as billing_date, case  when ee.status='1' then 'Not Approved' when ee.status='2' then 'Approved'  when ee.status='4' then 'Paid' else 'Rejected' end as status_text,status, filename, ee.employee_id,ee.eclaimtype_id")
		            ->where('status','3')->where('approver_id',$approver_id);
		  if($request->name && $request->name != '')
            {
                $data->where(function($query){
                    $query->where('up.name', 'like', '%'.request()->get('name').'%')
                        ->orwhere('up.employee_no', 'like', '%'.request()->get('name').'%')
                        ->orwhere('up.username', 'like', '%'.request()->get('name').'%');
                });
            }
        if($request->year && $request->year != '')
		{
		    $data->whereRaw("DATE_FORMAT(from_unixtime(ee.billing_date),'%Y') = '".$request->year."'");
		}
		 $main_array = $data->get();
		 $main_array->map(function($item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
		    $item->status_text=$status;
        });
		
		return DataTables::of($main_array)->make(true);
     }
     
     public function getEClaimListForApprovalByFinancer(Request $request){
         
          $user = User::where('id' , Auth::id())->first();
        $approver_id = (isset($request->approver_id)? $request->approver_id: $user->username);
		
		$main_array= DB::table('eclaim_employee as ee')->leftjoin('user_personal as up','up.username','=','ee.employee_id')
		            ->leftjoin('eclaimtype as et','et.id','=','ee.eclaimtype_id')
		            ->selectRaw("ee.id,from_unixtime(ee.created,'%Y-%m-%d') as created,up.name,et.type_name,ee.total_amount,from_unixtime(ee.billing_date,'%Y-%m-%d') as billing_date, case  when ee.status='1' then 'Not Approved' when ee.status='2' then 'Approved'  when ee.status='4' then 'Paid' else 'Rejected' end as status_text,status, filename, ee.employee_id,ee.eclaimtype_id")
		            ->where('status','2')->get();
		 $main_array->map(function($item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
		    $item->status_text=$status;
        });
		
		return DataTables::of($main_array)->make(true);
         
     }
     
     public function updateEClaimAmount(Request $request){
            $id = $request->id;
            $username = $request->username;
            $amount = $request->total_amount;
            $eclaimtype_id = $request->eclaimtype_id;
            $billing_date = $request->billing_date;
            
            if($this->checkClaimAmountAllow($amount,$username,$eclaimtype_id,$billing_date,$id)){
                $result = DB::table('eclaim_employee')->where('id',$id)->update(array('total_amount'=>$amount));
                return true;
            }
            
            return 'Exceed your amount limit';
    }
    
    public function EClaimStatus(Request $request){
            $ids = $request->ids;
            $status = $request->status;
            $email_array = $this->EClaimUpdateStatus($ids,$status,true);
            for($i=0;$i<count($email_array);$i++){
                $tmp = $email_array[$i];
                if(count($tmp)>2){
                    $semail = UserPersonal::where('username',$tmp[0])->first();
                      sendemail($semail->email_id,$tmp[1],$tmp[2]);
                }
            }
        return true;
	}
	
	 public function EClaimUpdateStatus($ids,$status,$email_sending = false,$amount='',$eclaim_type_id=''){
		$time = time();
        $email_array = array();
                
		for($i=0;$i<count($ids);$i++){
                    
                    $result = DB::table('eclaim_employee')->where('id',$ids[$i])->selectRaw('total_amount,employee_id')->first();
                    
                    $info_total_amount = money_format('%.2n', $result->total_amount);
                    $employee_id = $result->employee_id;
                    $approver_id = DB::table('map_employee_manager')->where('employee_id',$employee_id)->pluck('manager_id')->first();
                    $approver_id = urldecode($approver_id);
                    
                    $query_amount = "";
                    if($amount!=""){
                        $query_amount = " total_amount='".$amount."', ";
                    }
                    
                    $query_type = "";
                    if($eclaim_type_id!=""){
                    	$query_type= " eclaimtype_id='".$eclaim_type_id."', ";
                    }
                    
                    $actual_status = 1;
                    if($status<3){
                        if($approver_id!=""){
                            $actual_status = 2;
                            $query = "update `eclaim_employee` set ".$query_amount.$query_type." `approver_id`='".$approver_id."',`status`='2',`modified`='".$time."' where `id`=$ids[$i]";
                        }else{
                            $actual_status = 3;
                            $query = "update `eclaim_employee` set ".$query_amount.$query_type." `status`='3',`modified`='".$time."' where `id`=$ids[$i]";
                        }
                    }else{
                        $actual_status = $status;
                        $_p_query = "";
                        if($status=="4"){
                            $_p_query = " paid_on='".$time."', " ;
                        }
                        $query = "update `eclaim_employee` set ".$query_amount.$query_type." ".$_p_query." `approver_id`='".$approver_id."',`status`='".$status."',`modified`='".$time."' where `id`=$ids[$i]";
                    }
                    
                    $builder = DB::statement($query);
                    
                    $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance'); 
                
                    
                    $approver_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$approver_id)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
                
                    $user_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$employee_id)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
                    
                    if($actual_status==2){
                        $subject = "Claim status updated";
                        $body = "Dear ".$user_info->name.", <br><br>";
                        $body .= "Your claim amount RM ".$info_total_amount." approved by Manager.";
                        $tmp_arr = array($employee_id, $subject, $body);
                        array_push($email_array,$tmp_arr);
                        
                        $email_array = $this->EclaimFinancerEmailSending($user_info->name, $info_total_amount, $email_array);
                        
                    }else if($actual_status==3){
                        $subject = "Claim status updated";
                        $body = "Dear ".$user_info->name.", <br><br>";
                        if($eclaimFinanceSkipSetting!=1){
                            $body .= "Your claim amount RM ".$info_total_amount." approved by Financier.";
                        }else{
                            $body .= "Your claim amount RM ".$info_total_amount." approved.";
                        }
                        $tmp_arr = array($employee_id, $subject, $body);
                        array_push($email_array,$tmp_arr);
                    }else if($actual_status==4){
                        $subject = "Claim status updated";
                        $body = "Dear ".$user_info->name.", <br><br>";
                        $body .= "Your claim amount RM ".$info_total_amount." Paid.";
                        $tmp_arr = array($employee_id, $subject, $body);
                        array_push($email_array,$tmp_arr);
                    }else if($actual_status==5){
                        $subject = "Claim status updated";
                        $body = "Dear ".$user_info->name.", <br><br>";
                        $body .= "Your claim amount RM ".$info_total_amount." Rejected.";
                        $tmp_arr = array($employee_id, $subject, $body);
                        array_push($email_array,$tmp_arr);
                    }
                    
		}
        if($email_sending){
            return $email_array;
        }
                
		return true;
	}
	
	public function EclaimFinancerEmailSending($employee_name,$amount,$email_array){
        
        $result = DB::table('user_personal as up')->leftjoin('map_employee_permission as mep','mep.employee_id','=','up.username')
                ->leftjoin('permission_group as pg','pg.id','=','mep.permission_group_id')->where('pg.eclaim','3')->selectRaw('up.name,up.username')->get();
        
        for($i=0;$i<count($result);$i++){
            $subject1 = "Claim Approval Needed";
            $body1 = "Dear ".$result[$i]->name.", <br><br>";
            $body1 .= " E-Claim from ".$employee_name." with amount RM ".$amount." waiting for your approver.";
            $tmp_arr1 = array($result[$i]->username, $subject1, $body1);
            array_push($email_array,$tmp_arr1);
        }
        return $email_array;
    }
     
     public function financer(){
        $user = User::where('id' , Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();

        $c_key = 'claim_financer';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }


        return view('E-Claim.financer',compact('userPay', 'c_key', 'columnHideShowData'));
     }

    public function report(){
         $categories  = Category::orderBy('name','asc')->get();
        $departments  = Department::orderBy('name','asc')->get();
        $branches  = Branch::orderBy('name','asc')->get();
        $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');

        $c_key = 'claim_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        
        return view('E-Claim.report',compact('categories','departments','branches','eclaimFinanceSkipSetting', 'c_key', 'columnHideShowData'));
    }
    
    public function geteclaimreportdata(Request $request){
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
	    $report = DB::table('eclaim_employee as ece')->leftjoin('user_personal as b','ece.employee_id','=','b.username')
                        ->leftjoin('user_personal as approver_up','approver_up.username','=','ece.approver_id')
                        ->leftjoin('user_pay as c','ece.employee_id','=','c.username')
                        ->leftjoin('branch as d','c.branch_id','=','d.id')
                        ->leftjoin('department as e','c.department_id','=','e.id')
                        ->leftjoin('category as f','c.category_id','=','f.id')
                        ->leftjoin('eclaimtype as et','ece.eclaimtype_id','=','et.id');
                        if($request->month && $request->month != '')
                        {
                            $report->whereRaw("from_unixtime(ece.paid_on, '%m')='".$request->month."'");
                        }
                        if($request->approver_id && $request->approver_id != '')
                        {
                            
                            $report->where("ece.approver_id",$request->approver_id);
                        }
                         if($request->name && $request->name != '')
                        {
                            $report->where(function($query){
                                $query->where('b.name', 'like', '%'.request()->get('name').'%')
                                    ->orwhere('b.employee_no', 'like', '%'.request()->get('name').'%');
                            });
                        }
                        
                    	if($ActiveUserShownStatus==1){
            $report->whereRaw("( c.pay_status='1' or c.pay_status='0')");
        }
        else{
            $report->where('c.pay_status','1');
        }
                        if($request->branch && $request->branch != '')
                        {
                            
                            $report->where('c.branch_id',$request->branch);
                        }
                        if($request->department && $request->department != '')
                        {
                           
                            $report->where('c.department_id',$request->department);
                        }

                        if($request->category && $request->category != '')
                        {
                           
                            $report->where('c.category_id',$request->category);
                        }
                           if($request->astart_date && $request->astart_date != '')
                        {
                            
                            $report->where('ece.created','>=',strtotime($request->astart_date));
                        }
                        if($request->aend_date && $request->aend_date != '')
                        {
                           $acheck_end_date = strtotime($request->aend_date) + (60*60*24);
                            $report->where('ece.created','<=',$acheck_end_date);
                        }
      if($request->start_date && $request->start_date != '')
                        {
                            
                            $report->where('ece.billing_date','>=',strtotime($request->start_date));
                        }
                        if($request->end_date && $request->end_date != '')
                        {
                          // $check_end_date = strtotime($request->end_date) + (60*60*24);
                            $report->where('ece.billing_date','<=',strtotime($request->end_date));
                        }
                          if($request->paidSdate && $request->paidSdate != '')
                        {
                            $report->where('ece.paid_on','>=',strtotime($request->paidSdate));
                        }
                        if($request->paidEdate && $request->paidEdate != '')
                        {
                            $paidEdate = strtotime($request->paidEdate) + (60*60*24);
                          $report->where('ece.paid_on','<=',$paidEdate);
                        }
                        if($request->paid_status && $request->paid_status != '')
                        {
                          $report->where('ece.status',$request->paid_status);
                        }
                        
        $report->selectRaw("ece.id,b.employee_no,approver_up.name as approver_name, b.name, d.name as branch, e.name as department, f.name as category, from_unixtime(ece.created, '%Y-%m-%d') as date_applied, et.type_name as eclaimtype, et.id as eclaim_type_id, ece.total_amount, from_unixtime(ece.billing_date, '%Y-%m-%d') as billing_date, from_unixtime(ece.paid_on, '%Y-%m-%d') as paid_on,ece.status, case  when ece.status='1' then 'Not Approved' when ece.status='2' then 'Approved' when ece.status='4' then 'Paid' else 'Rejected' end as status_text,ece.filename, ece.status as status_val ");
        $reports = $report->groupBy('ece.id')->get();
        $i=0;
        foreach($reports as $item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
            $item->status_text=$status;
            $item->i=$i;
            $i++;
        }
        if($request->get('val')=='normal'){
            return $reports;
        }
        return DataTables::of($reports)->make(true);
    }
    
    public function getreportdata($id){
        $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
        $eclaimtype = EclaimType::get();
        $result = EclaimEmployee::find($id);
        $result['astatus'] = $result->status;
        $result['eclaimtype'] = $eclaimtype;
        $result['eclaimFinanceSkipSetting'] = $eclaimFinanceSkipSetting;
         return $result;
 
     }
     
      public function editreport(Request $request){
         $update = EclaimEmployee::where('id' , $request->report_id)->first();
         
            $audit = new EclaimAudit;
            $audit->claim_id = $request->report_id ?? NULL;
            $audit->admin_id = getUserNameByRowId(Auth::id()) ?? NULL;
            $audit->amount_from = $update->total_amount ?? NULL;
            $audit->amount_to = $request->total_amount ?? NULL;
            $audit->type_from = $update->eclaimtype_id ?? NULL;
            $audit->type_to = $request->eclaim_type ?? NULL;
            $audit->status_from = $update->status ?? NULL;
            $audit->status_to = $request->status ?? NULL;
            $audit->emp_id = $update->employee_id  ?? NULL;
            $audit->save(); 
            
         $update->total_amount = $request->total_amount;
         $update->eclaimtype_id = $request->eclaim_type;
         $update->status = $request->status;
         $update->save();
         return $update;
 
     }
     
     public function deleteEclaimEmployee(Request $request)
	{
		$id = $request->id;
		$result = $this->deleteEclaimEmployee11($id);
		return array("result" => $result);
	}

	public function deleteEclaimEmployee11($id){
	    $data = EclaimEmployee::where('id' , $id)->first();
         
        $audit = new EclaimAudit;
        $audit->claim_id = $id ?? NULL;
        $audit->admin_id = $data->approver_id ?? NULL;
        $audit->amount_from = $data->total_amount ?? NULL;
        $audit->type_from = $data->eclaimtype_id ?? NULL;
        $audit->status_from = $data->status ?? NULL;
        $audit->emp_id = $data->employee_id  ?? NULL;
        $audit->claim_list_raw = json_encode($data);
        $audit->deleted_at = date("Y-m-d H:i:s")  ?? NULL;
        $audit->save(); 
        
	    DB::table('eclaim_employee_field_value')->where('eclaim_employee_id', $id)->delete();
		DB::table('eclaim_employee')->where('id', $id)->delete();
		return true;
	}
    
    public function eclaimreportpdf(Request $request){
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
	    $report = DB::table('eclaim_employee as ece')->leftjoin('user_personal as b','ece.employee_id','=','b.username')
                        ->leftjoin('user_personal as approver_up','approver_up.username','=','ece.approver_id')
                        ->leftjoin('user_pay as c','ece.employee_id','=','c.username')
                        ->leftjoin('branch as d','c.branch_id','=','d.id')
                        ->leftjoin('department as e','c.department_id','=','e.id')
                        ->leftjoin('category as f','c.category_id','=','f.id')
                        ->leftjoin('eclaimtype as et','ece.eclaimtype_id','=','et.id');
                        if($request->month && $request->month != '')
                        {
                            
                            $report->whereMonth("ece.paid_on",$request->month);
                        }
                        if($request->approver_id && $request->approver_id != '')
                        {
                            
                            $report->where("ece.approver_id",$request->approver_id);
                        }
                         if($request->name && $request->name != '')
                        {
                            $report->where(function($query){
                                $query->where('b.name', 'like', '%'.request()->get('name').'%')
                                    ->orwhere('b.employee_no', 'like', '%'.request()->get('name').'%');
                            });
                        }
                        
                    	if($ActiveUserShownStatus==1){
                            $report->whereRaw("( c.pay_status='1' or c.pay_status='0')");
                        }
                        else{
                            $report->where('c.pay_status','1');
                        }
                        if($request->branch && $request->branch != '')
                        {
                            
                            $report->where('c.branch_id',$request->branch);
                        }
                        if($request->department && $request->department != '')
                        {
                           
                            $report->where('c.department_id',$request->department);
                        }

                        if($request->category && $request->category != '')
                        {
                           
                            $report->where('c.category_id',$request->category);
                        }
                           if($request->astart_date && $request->astart_date != '')
                        {
                            
                            $report->where('ece.created','>=',strtotime($request->astart_date));
                        }
                        if($request->aend_date && $request->aend_date != '')
                        {
                           $acheck_end_date = strtotime($request->aend_date) + (60*60*24);
                            $report->where('ece.created','<=',$acheck_end_date);
                        }
                        if($request->start_date && $request->start_date != '')
                        {
                            
                            $report->where('ece.billing_date','>=',strtotime($request->start_date));
                        }
                        if($request->end_date && $request->end_date != '')
                        {
                           $acheck_end_date = strtotime($request->end_date) + (60*60*24);
                            $report->where('ece.created','<=',$acheck_end_date);
                        }
                          if($request->paidSdate && $request->paidSdate != '')
                        {
                            $report->where('ece.paid_on','>=',strtotime($request->paidSdate));
                        }
                        if($request->paidEdate && $request->paidEdate != '')
                        {
                          $report->where('ece.paid_on','<=',strtotime($request->paidEdate));
                        }
                        if($request->paid_status && $request->paid_status != '')
                        {
                          $report->where('ece.status',$request->paid_status);
                        }
                        
        $report->selectRaw("ece.id,b.employee_no,approver_up.name as approver_name, b.name, d.name as branch, e.name as department, f.name as category, from_unixtime(ece.created, '%Y-%m-%d') as date_applied, et.type_name as eclaimtype, et.id as eclaim_type_id, ece.total_amount, from_unixtime(ece.billing_date, '%Y-%m-%d') as billing_date, from_unixtime(ece.paid_on, '%Y-%m-%d') as paid_on,ece.status, case  when ece.status='1' then 'Not Approved' when ece.status='2' then 'Approved' when ece.status='4' then 'Paid' else 'Rejected' end as status_text,ece.filename, ece.status as status_val ");
        $reports = $report->groupBy('ece.id')->get();
        $reports->map(function($item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
            $item->status_text=$status;
             $fields = DB::table('eclaim_employee_field_value as eefv')->leftjoin('eclaimtype_fields as ef','ef.id','=','eefv.eclaimtype_fields_id')->where('eefv.eclaim_employee_id',$item->id)->where('ef.id','!=',null)->selectRaw('eefv.id,ef.field_name,eefv.value')->groupBy('ef.id')->orderBy('ef.id','asc')->limit(2)->get();
            $item->fields = $fields;
        });
        $timezone = Carbon::now(get_local_time());
        
        $timedate = $timezone->format('d-m-Y H:i A');
        
        $user = User::where('id' , Auth::id())->first();
        
        $c_key = 'claim_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Category", "Dept", "Applied On", "Eclaim Type", "Amount", "Bill Date", "Desp1", "Desp2", "Status"];;


        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $html = html_entity_decode(view('E-Claim.pdf.reportpdf', compact('reports','timedate','companyname', 'arrColumns', 'columnHideShowData', 'c_key')));//->render();
        $pdf = new Dompdf();
      

        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('E-claim Report');
        return 1;
        
       
    }
    
    public function eclaimreportexport(Request $request){
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
	    $report = DB::table('eclaim_employee as ece')->leftjoin('user_personal as b','ece.employee_id','=','b.username')
                        ->leftjoin('user_personal as approver_up','approver_up.username','=','ece.approver_id')
                        ->leftjoin('user_pay as c','ece.employee_id','=','c.username')
                        ->leftjoin('branch as d','c.branch_id','=','d.id')
                        ->leftjoin('department as e','c.department_id','=','e.id')
                        ->leftjoin('category as f','c.category_id','=','f.id')
                        ->leftjoin('eclaimtype as et','ece.eclaimtype_id','=','et.id');
                        if($request->month && $request->month != '')
                        {
                            
                            $report->whereMonth("ece.paid_on",$request->month);
                        }
                        if($request->approver_id && $request->approver_id != '')
                        {
                            
                            $report->where("ece.approver_id",$request->approver_id);
                        }
                         if($request->name && $request->name != '')
                        {
                            $report->where(function($query){
                                $query->where('b.name', 'like', '%'.request()->get('name').'%')
                                    ->orwhere('b.employee_no', 'like', '%'.request()->get('name').'%');
                            });
                        }
                        
                    	if($ActiveUserShownStatus==1){
                            $report->whereRaw("( c.pay_status='1' or c.pay_status='0')");
                        }
                        else{
                            $report->where('c.pay_status','1');
                        }
                        if($request->branch && $request->branch != '')
                        {
                            
                            $report->where('c.branch_id',$request->branch);
                        }
                        if($request->department && $request->department != '')
                        {
                           
                            $report->where('c.department_id',$request->department);
                        }

                        if($request->category && $request->category != '')
                        {
                           
                            $report->where('c.category_id',$request->category);
                        }
                           if($request->astart_date && $request->astart_date != '')
                        {
                            
                            $report->where('ece.created','>=',strtotime($request->astart_date));
                        }
                        if($request->aend_date && $request->aend_date != '')
                        {
                           $acheck_end_date = strtotime($request->aend_date) + (60*60*24);
                            $report->where('ece.created','<=',$acheck_end_date);
                        }
                        if($request->start_date && $request->start_date != '')
                        {
                            
                            $report->where('ece.billing_date','>=',strtotime($request->start_date));
                        }
                        if($request->end_date && $request->end_date != '')
                        {
                           $acheck_end_date = strtotime($request->end_date) + (60*60*24);
                            $report->where('ece.created','<=',$acheck_end_date);
                        }
                          if($request->paidSdate && $request->paidSdate != '')
                        {
                            $report->where('ece.paid_on','>=',strtotime($request->paidSdate));
                        }
                        if($request->paidEdate && $request->paidEdate != '')
                        {
                          $report->where('ece.paid_on','<=',strtotime($request->paidEdate));
                        }
                        if($request->paid_status && $request->paid_status != '')
                        {
                          $report->where('ece.status',$request->paid_status);
                        }
                        
        $report->selectRaw("ece.id,b.employee_no,approver_up.name as approver_name, b.name, d.name as branch, e.name as department, f.name as category, from_unixtime(ece.created, '%Y-%m-%d') as date_applied, et.type_name as eclaimtype, et.id as eclaim_type_id, ece.total_amount, from_unixtime(ece.billing_date, '%Y-%m-%d') as billing_date, from_unixtime(ece.paid_on, '%Y-%m-%d') as paid_on,ece.status, case  when ece.status='1' then 'Not Approved' when ece.status='2' then 'Approved' when ece.status='4' then 'Paid' else 'Rejected' end as status_text,ece.filename, ece.status as status_val ");
        $reports = $report->groupBy('ece.id')->get();
        $reports->map(function($item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
            $item->status_text=$status;
            $fields = DB::table('eclaim_employee_field_value as eefv')->leftjoin('eclaimtype_fields as ef','ef.id','=','eefv.eclaimtype_fields_id')->where('eefv.eclaim_employee_id',$item->id)->where('ef.id','!=',null)->selectRaw('eefv.id,ef.field_name,eefv.value')->groupBy('ef.id')->orderBy('ef.id','asc')->limit(2)->get();
            $item->fields = $fields;
        });
        
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'Eclaim Report');

        $c_key = 'claim_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Emp No", "Name", "Category", "Dept", "Applied On", "Eclaim Type", "Amount", "Bill Date", "Desp1", "Desp2", "Status"];

          $startFrom = 65;
          for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
          }
        
        $rows = 2;
        $totalamount = 0;
        foreach($reports as $report){
            $totalamount = $totalamount+$report->total_amount;
            
            $rows++;

            if(count($report->fields)>=2){
                $reps = $report->fields;
                $k=0;
                foreach($reps as $rep){
                    if($k==0){
                         $sheet->setCellValue('I' . $rows, $rep->value);
                    }
                    if($k==1){
                         $sheet->setCellValue('J' . $rows, $rep->value);
                         break;
                    }
                  $k++;  
                }
            }elseif(count($report->fields)>=1){
                $reps = $report->fields;
                $k=0;
                foreach($reps as $rep){
                    if($k==0){
                         $sheet->setCellValue('I' . $rows, $rep->value);
                         break;
                    }
                  
                  $k++;  
                }
                $sheet->setCellValue('J' . $rows, '');
            }else{
                $sheet->setCellValue('I' . $rows, '');
                $sheet->setCellValue('J' . $rows, '');
            
            }

            $bdate = !is_null($report->billing_date) ? date('d-m-Y', strtotime($report->billing_date)) : "";

            $arrRows = [$report->employee_no, mb_convert_encoding($report->name, "UTF-8", "HTML-ENTITIES"), $report->category, $report->department, date('d-m-Y', strtotime($report->date_applied)), $report->eclaimtype, $report->total_amount, $bdate, $report->status_text];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
            
        }
        $rows2 = $rows+1;
        $sheet->setCellValue('F'. $rows2, 'Total Amount');
        $sheet->setCellValue('G'. $rows2, $totalamount);

        $fileName = "eclaim-report.xlsx";
    
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
        
       
    }

    public function type(){

        return view('E-Claim.type');
    }
    public function gettype(Request $request){
        $dtable = $request->dtable ?? "";
        $result = EclaimType::selectRaw("DATE_FORMAT(from_unixtime(created),'%b %d %Y %h:%i %p') as created,DATE_FORMAT(from_unixtime(modified),'%b %d %Y %h:%i %p') as modified, type_name,id")->get();
           for($i=0;$i<count($result);$i++){
                $result[$i]->t_id = $i+1; 
            }
        if($dtable!=''){
            return $result;
        }
        else{
            return DataTables::of($result)->make(true);
        }
        
    }
    public function addtype(Request $request){
 
        $type = new EclaimType;
        $type->type_name = $request->type_name;
        $type->created = time();
        $type->modified = time();
        $type->save();
        
        $categorynames = DB::table('category_name')->where('is_deleted',0)->get();
        foreach($categorynames as $category){
        $result = DB::table('eclaimrate')->insert(array('rate'=>0,'category_id'=>$category->id,'eclaimtype_id'=>$type->id,'rate_type'=>0));
        $result = DB::table('eclaimrate')->insert(array('rate'=>0,'category_id'=>$category->id,'eclaimtype_id'=>$type->id,'rate_type'=>1));  
    }
        return 1;

    }

    public function geteclaimtypedata($id){
        $result = EclaimType::find($id);
         return $result;
 
     }
 
     public function edittype(Request $request){
         $type = EclaimType::where('id' , $request->type_id)->first();
         $type->type_name = $request->type_names;
         $type->modified = time();
         $type->save();
         return $type;
 
     }
 
     public function deletetype(Request $request){
         $type = DB::table('eclaimtype')->delete($request->type_id);
         return $type;
 
     }
     
     public function geteclaimtypefielddata($id){
        $result = EclaimtypeField::find($id);
         return $result;
 
     }
     
      public function deletetypefield(Request $request){
         $typefield = DB::table('eclaimtype_fields')->delete($request->type_field_id);
         return $typefield;
 
     }
     
      public function edittypefield(Request $request){
         $typefield = EclaimtypeField::where('id' , $request->type_field_id)->first();
         $typefield->field_name = $request->field_names;
         $typefield->required_field = $request->eclaim_requiredfield ?? 0;
         $typefield->field_type = $request->eclaim_field_types;
         $typefield->save();
         return $typefield;
    
     }
     
    public function typefield(){

        return view('E-Claim.type-field');
    }
    public function gettypefield(Request $request){
        $result = EclaimtypeField::where('type_id',$request->type_id)->get();
           for($i=0;$i<count($result);$i++){
                $result[$i]->tf_id = $i+1; 
            }
       
            return DataTables::of($result)->make(true);

        
    }
    public function addtypefield(Request $request){
 
        $typefield = new EclaimtypeField;
        $typefield->type_id = $request->type_id;
        $typefield->field_name = $request->field_name;
        $typefield->required_field =  $request->required_field ?? 0;
         $typefield->field_type = $request->field_type;
        $typefield->save();
        return 1;

    }
    
    public function eclaim(){
        $eclaimtypes  = EclaimType::get();
        $user = User::where('id' , Auth::id())->first();
        $approver_id = DB::table('map_employee_manager')->where('employee_id',$user->username)->pluck('manager_id')->first();
        $username = urldecode($approver_id);
        $approver_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$username)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
     
        return view('E-Claim.eclaim',compact('eclaimtypes','approver_info'));
    }
    
    public function editeclaim(Request $request){
        $eclaimtypes  = EclaimType::get();
        $user = User::where('id' , Auth::id())->first();
        $approver_id = DB::table('map_employee_manager')->where('employee_id',$user->username)->pluck('manager_id')->first();
        $username = urldecode($approver_id);
        $approver_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$username)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
        $billdate = $this->getEClaimByIdForEdit($request->id);
        return view('E-Claim.edit-eclaim',compact('eclaimtypes','approver_info','billdate'));
    }
    
    
    public function getEClaim(Request $request){
        $user = User::where('id' , Auth::id())->first();
        $employee_id = (isset($request->employee_id)? $request->employee_id: $user->username);
		
		$eclaim = DB::table('eclaim_employee as ee')
		        ->leftjoin('user_personal as up','up.username','=','ee.employee_id')
		        ->leftjoin('eclaimtype as et','et.id','=','ee.eclaimtype_id')
		        ->where('ee.employee_id',$employee_id);
		if($request->start_date!=''){
		    $eclaim->where("from_unixtime(ee.billing_date, '%d-%m-%Y')",">=",$request->start_date);
		}
		if($request->end_date!=''){
		    $eclaim->where("from_unixtime(ee.billing_date, '%d-%m-%Y')","<=",$request->end_date);
		}
		
		if($request->modified_month!=""){
		    $eclaim->whereRaw("from_unixtime(ee.billing_date, '%m') = '".$request->modified_month."'");
		}
		
		if($request->modified_year!=""){
		    $eclaim->whereRaw("from_unixtime(ee.billing_date, '%Y') = '".$request->modified_year."'");
		}
		if($request->status!=''){
		    $eclaim->where("ee.status",$request->status);
		}
		$result = $eclaim->selectRaw("ee.id,up.name,et.type_name,ee.total_amount,from_unixtime(ee.billing_date,'%Y-%m-%d') as billing_date,  case  when ee.status='1' then 'Not Approved' when ee.status='2' then 'Approved'  when ee.status='4' then 'Paid' else 'Rejected' end as status_text,status,filename")
		->groupBy('ee.id')->get();
		 $i=1;
        foreach($result as $item) {
            $status = $item->status_text;
            $eclaimFinanceSkipSetting = getSettingsValue('skip_eclaim_finance');
    
            if($eclaimFinanceSkipSetting==1){
                if($item->status=='3'){
                     $status='Approved'; 
                }
            }
            else{
                 if($item->status=='3'){
                     $status='Approved Finance'; 
                }
            }
            $item->status_text=$status;
            $item->sno=$i;
            $i++;
        }
		if($request->get('val')=='normal'){
            return $result;
        }
        return DataTables::of($result)->make(true);
	}
	
	public function getEClaimFieldType(Request $request){
		$result = DB::table('eclaimtype_fields as ef')->leftjoin('eclaimtype as et','et.id','=','ef.type_id')->where('ef.type_id',$request->type_id)->selectRaw("ef.*,et.type_name")->get();
		return $result;
	}
	
	public function addClaim(Request $request,$return_val = true){
            $user = User::where('id' , Auth::id())->first();
            $username = (isset($request->username)? $request->username: $user->username);
            $filename =null;
            
            if (!empty($request->slip_file)) {

                $file = $request->file('slip_file');
                $extension = $file->getClientOriginalExtension();
                $filename = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
                //	dd($endFileName);
                $filePath = 'public/upload/';

                try {
                    Storage::disk($this->storageDriver)->put($filePath . $filename, file_get_contents($file));
                } catch (\Exception $e) {
                    
                }
            }
            $data = $request->all();
            if($this->checkClaimAmountAllow($request->total_amount,$username,$request->eclaimtype_id,$request->billing_date)){
                $approver_id = DB::table('map_employee_manager')->where('employee_id',$user->username)->pluck('manager_id')->first();
                $approver_id = urldecode($approver_id);
                $approver_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$approver_id)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
                
                $user_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$username)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
     
                $this->saveClaim($data,$filename,$request);
                if($return_val){
                    
                    $subject = "New claim added for approval";
                    $body = "Dear ".$approver_info->name.", <br><br>";
                    $body .= "".$user_info->name." add new Claim with amount : RM ".money_format('%.2n', $request->total_amount);
                    sendemail($approver_info->email_id,$subject,$body);
                    return true;
                }
            }
            return 'Exceed your amount limit';
	}
	
	
	public function updateClaim(Request $request){
            $user = User::where('id' , Auth::id())->first();
            $username = (isset($request->username)? $request->username: $user->username);
            $filename =null;
            
            if (!empty($request->slip_file)) {

                $file = $request->file('slip_file');
                $extension = $file->getClientOriginalExtension();
                $filename = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
                //	dd($endFileName);
                $filePath = 'public/upload/';

                try {
                    Storage::disk($this->storageDriver)->put($filePath . $filename, file_get_contents($file));
                } catch (\Exception $e) {
                    
                }
            }
                $employee_id = (isset($request->employee_id)? $request->employee_id: $user->username);
		$eclaimtype_id = $request->eclaimtype_id;
		$fields	= isset($request->fields) ? json_decode($request->fields) : [];
		$billing_date	= strtotime($request->billing_date);
		$total_amount	= $request->total_amount;
		$created = time();
            if($this->checkClaimAmountAllow($request->total_amount,$username,$request->eclaimtype_id,$request->billing_date,$request->id)){
                $approver_id = DB::table('map_employee_manager')->where('employee_id',$user->username)->pluck('manager_id')->first();
                $approver_id = urldecode($approver_id);
                $approver_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$approver_id)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
                
                $user_info = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')->where('username',$username)
                        ->selectRaw("up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted ")->first();
                 if($filename!=''){
                             $eclaimemp = DB::table('eclaim_employee')->where('id',$request->id)->update(array('eclaimtype_id'=>$eclaimtype_id, 'billing_date'=>$billing_date, 'total_amount'=>$total_amount, 'filename'=>$filename,'modified'=>$created));
            		
                 }else{
                            $eclaimemp = DB::table('eclaim_employee')->where('id',$request->id)->update(array('eclaimtype_id'=>$eclaimtype_id, 'billing_date'=>$billing_date, 'total_amount'=>$total_amount,'modified'=>$created)); 
                 }
                 	$eclaim_employee_field_value = DB::table('eclaim_employee_field_value')->where('eclaim_employee_id',$request->id)->delete();
                 
                 if($fields!='[]'){
        		for($i=0;$i<count($fields);$i++){
        		    $eclaimempfield = DB::table('eclaim_employee_field_value')->insert(array('eclaim_employee_id'=>$request->id, 'eclaimtype_fields_id' => $fields[$i]->name, 'value'=>$fields[$i]->value));
        		
        		}
                 	}
                return true;
            }
            return 'Exceed your amount limit';
	}
	
	
	public function saveClaim($data,$filename,$request){
	    $user = User::where('id' , Auth::id())->first();
        $employee_id = (isset($data["employee_id"])? $data["employee_id"]: $user->username);
		$eclaimtype_id = $data['eclaimtype_id'];
		$fields	= isset($request->fields) ? json_decode($request->fields) : [];
		$billing_date	= strtotime($data['billing_date']);
		$total_amount	= $data['total_amount'];
		$status = '1';
		$created = time();
		$approver_id = DB::table('map_employee_manager')->where('employee_id',$employee_id)->pluck('manager_id')->first();
        $approver_id = urldecode($approver_id);
		
		$eclaimemp = DB::table('eclaim_employee')->insert(array('employee_id'=>$employee_id, 'approver_id' => $approver_id, 'eclaimtype_id'=>$eclaimtype_id, 'billing_date'=>$billing_date, 'total_amount'=>$total_amount, 'filename'=>$filename,'modified'=>$created,'created'=>$created,'status'=>$status));
		$eclaim_employee_id = DB::table('eclaim_employee')->selectRaw('max(id) as id')->pluck('id')->first();
	    
	    $audit = new EclaimAudit;
        $audit->claim_id = $eclaimemp->id ?? NULL;
        $audit->admin_id = $approver_id ?? NULL;
        $audit->amount_from = NULL;
        $audit->amount_to = $total_amount ?? NULL;
        $audit->type_from = NULL;
        $audit->type_to = $eclaimtype_id ?? NULL;
        $audit->status_from = NULL;
        $audit->status_to = $status ?? NULL;
        $audit->emp_id = $employee_id  ?? NULL;
        $audit->save(); 
	    
	    if($fields!='[]'){
		for($i=0;$i<count($fields);$i++){
			$eclaimempfield = DB::table('eclaim_employee_field_value')->insert(array('eclaim_employee_id'=>$eclaim_employee_id, 'eclaimtype_fields_id' => $fields[$i]->name, 'value'=>$fields[$i]->value));
		
		}
		 }
		
	}
	
	
	public function checkClaimAmountAllow($amount,$username,$eclaimtype_id,$date,$eclaim_employee_id=''){
            
        $max_month_claim_amount = $this->getMaxUserClaimAmount($username,$eclaimtype_id,'0');
        $max_year_claim_amount = $this->getMaxUserClaimAmount($username,$eclaimtype_id,'1');
        $claimDate = date('d-m-Y', strtotime($date));
        
        
        
        $already_claimed_month_amount = $this->getTotalClaimedAmount('month', $claimDate, $username, $eclaimtype_id,$eclaim_employee_id);
        $already_claimed_year_amount = $this->getTotalClaimedAmount('year', $claimDate, $username, $eclaimtype_id,$eclaim_employee_id);
       // dd($already_claimed_year_amount,$already_claimed_month_amount,$amount,$max_year_claim_amount,$max_month_claim_amount);
        if($already_claimed_year_amount+$amount>$max_year_claim_amount){
            return FALSE;
        }
        if($already_claimed_month_amount+$amount>$max_month_claim_amount){
            return FALSE;
        }
        return TRUE;
    }
    
    public function getMaxUserClaimAmount($username,$eclaimtype_id,$rate_type=0){
            
		$val = DB::table('eclaimrate as cr')->leftjoin('user_category as uc','uc.category','=','cr.category_id')->where('uc.username',$username)->where('cr.eclaimtype_id',$eclaimtype_id)->where('cr.rate_type',$rate_type)->pluck('cr.rate')->first();
        if($val==""){
            $val = 0;
        }
		return $val;
	}
	
	public function getTotalClaimedAmount($monthOrYear,$my_value,$employee_id,$eclaimtype_id,$eclaim_employee_id=''){
        $claimMonth = date('m', strtotime($my_value));
        $ClaimYear = date('Y', strtotime($my_value));
        
        $query = DB::table('eclaim_employee')->where('employee_id',$employee_id)->where('eclaimtype_id',$eclaimtype_id);
        if($monthOrYear=='month'){
            $query->whereRaw("DATE_FORMAT(from_unixtime(billing_date),'%c') = '".intval($claimMonth)."'");
        }
        $query->whereRaw("DATE_FORMAT(from_unixtime(billing_date),'%Y') = '".intval($ClaimYear)."'");
        if($eclaim_employee_id!=''){
            $query->where('id','!=',$eclaim_employee_id);
        }
       $val = $query->where('status','!=','5')->sum('total_amount');
        if($val==''){
            $val = 0;
        }
        return $val;
    }
    
    public function viewDocs($id) {
        $leave = DB::table('eclaim_employee')->find($id);

        $file_path = 'public/upload/' . $leave->filename;
        $fileContent = Storage::disk($this->storageDriver)->get($file_path);
        $fileName = basename($file_path);
        return response($fileContent)->header('Content-Type', '');
    }
    
    public function deleteEclaim(Request $request){
        
		$eclaim_employee_field_value = DB::table('eclaim_employee_field_value')->where('eclaim_employee_id',$request->eclaim_employee_id)->delete();
		$eclaim_employee = DB::table('eclaim_employee')->delete($request->eclaim_employee_id);
	    return $eclaim_employee;
	}
	
	public function geteclaimdata($id){
        $result = DB::table('eclaim_employee')->selectRaw("*,from_unixtime(billing_date,'%Y-%m-%d') as billing_date")->find($id);
        
         return $result;
 
     }
     
    public function deleteEclaimFile(Request $request){
         $result = DB::table('eclaim_employee')->where('id',$request->eclaim_employee_id)->update(array('filename'=>null));
     }
     
     
    public function getEClaimByIdForEdit(){
	    $id = request()->id;
		$result = DB::table('eclaim_employee')->where('id',$id)->selectRaw("*,from_unixtime(billing_date,'%Y-%m-%d') as billingDate")->get();
		$fields = DB::table('eclaim_employee_field_value as eefv')->leftjoin('eclaimtype_fields as ef','ef.id','=','eefv.eclaimtype_fields_id')->where('eefv.eclaim_employee_id',$id)->selectRaw("eefv.id,ef.field_name,ef.required_field,eefv.value,eefv.eclaimtype_fields_id")->get();
	    $result[0]->fields = $fields;
		
		return $result;
	}
	
	public function claimrate(){
         $claimtypes = EclaimType::get();
         $categorynames = DB::table('category_name')->where('is_deleted',0)->get();
        
         return view('E-Claim.rates',compact('claimtypes','categorynames'));
     }
     
    public function getClaimRateList(Request $request){
        $rate_type = $request->rate_type ?? 0;
        $claimrate = DB::table('eclaimrate as cr')
		            ->leftjoin('eclaimtype as et','cr.eclaimtype_id','=','et.id')
		            ->leftjoin('category_name as cn','cr.category_id','=','cn.id')->where('cr.rate_type',$rate_type)->selectRaw("cn.id,et.id as typeid, cr.eclaimtype_id, cr.rate, et.type_name")->get();
		return $claimrate;
    }
    
    public function setclaimrate(Request $request){
        $user = User::where('id' , Auth::id())->first();
        $rate_type = $request->rate_type ?? 0;
        $claimrate_json = json_decode(stripslashes($request->claimrate_json));
            for($i = 0; $i < count($claimrate_json); $i++)
            {
                $category = $claimrate_json[$i]->category;
                $claimType = $claimrate_json[$i]->claimType;
                $noRate = $claimrate_json[$i]->noRate;

                $data = DB::table('eclaimrate')->where('category_id' , $category)->where('eclaimtype_id',$claimType)->where('rate_type',$rate_type)->pluck('id')->first();
                if(empty($data)){
                     $result = DB::table('eclaimrate')->insert(array('rate'=>$noRate,'category_id'=>$category,'eclaimtype_id'=>$claimType,'rate_type'=>$rate_type));
                }
                else{
                    $result = DB::table('eclaimrate')->where('category_id',$category)->where('eclaimtype_id',$claimType)->where('rate_type',$rate_type)->update(array('rate'=>$noRate));

                }
        
          
            }
            return true;
    } 
    
    
    // audit
    public function audit(){

        $c_key = 'claim_audit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        $employees = UserPersonal::select('name', 'username')->get();
        $claimStatus = [
            '1'=>'Not Approved',
            '2'=>'Approved',
            '3'=>'Finance Approved',
            '4'=>'Paid',
            '5'=>'Reject',
        ];
            
        return view('E-Claim.audit', compact('c_key', 'columnHideShowData', 'employees', 'claimStatus'));
    }
   
    public function geteclaimauditdata(Request $request){

        session(['claim_audit_data' => $request->getUri()]);
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        
        $employees = DB::table('eclaim_audit');
        
        // filter
        if(isset($request->date_from)){
            $employees->whereDate('created_at', '>=', $request->date_from);
        }

        if(isset($request->date_to)){
            $employees->whereDate('created_at', '<=', $request->date_to);
        }

        if(isset($request->updated_at) && $request->updated_at !=""){
            $employees->whereDate('updated_at', $request->updated_at);
        }

        if(isset($request->emp) && $request->emp !=""){
            $employees->where('emp_id', $request->emp);
        }

        if(isset($request->amount_from) && $request->amount_from !=""){
            $employees->where('amount_from', '>=' ,$request->amount_from);
        }

        if(isset($request->amount_to) && $request->amount_to !=""){
            $employees->where('amount_to', '<=' ,$request->amount_to);
        }

        if(isset($request->status_from) && $request->status_from !=""){
            $employees->where('status_from', $request->status_from);
        }

        if(isset($request->status_to) && $request->status_to !=""){
            $employees->where('status_to', $request->status_to);
        }

        // filter

        $employees = $employees->get()->sortDesc();
       
        $employees->map(function ($item) {
            
            $typeName = DB::table('eclaimtype')->where('id', $item->type_from)->first();

            if(isset($typeName) && $typeName != null){
                $item->type_from = $typeName->type_name;
            }else{
                $item->type_from = '';
            }

            $typeName2 = DB::table('eclaimtype')->where('id', $item->type_to)->first();
            if($typeName2){
                $item->type_to = $typeName2->type_name;
            }else{
                $item->type_to = '';
            }

            $item->admin = getNameByUserName($item->admin_id);
            $item->emp_name = getNameByUserName($item->emp_id);
       
            if($item->status_from == 1){
                $item->status_from = 'Pending';
            }elseif($item->status_from == 2 || $item->status_from == 3){
                $item->status_from = 'Approved';
            }elseif($item->status_from == 4){
                $item->status_from = 'Paid';
            }elseif($item->status_from == 5){
                $item->status_from = 'Rejected';
            }

            if($item->status_to == 1){
                $item->status_to = 'Pending';
            }elseif($item->status_to == 2 || $item->status_to == 3){
                $item->status_to = 'Approved';
            }elseif($item->status_to == 4){
                $item->status_to = 'Paid';
            }elseif($item->status_to == 5){
                $item->status_to = 'Rejected';
            }

            if($item->deleted_at){
                $item->deleted_at = date("d-m-Y H:i", strtotime($item->created_at));
            }else{
                $item->deleted_at = "NA";
            } 

            $item->created_at = date("d-m-Y H:i", strtotime($item->created_at));
            if($item->deleted_at){
                $item->deleted_at;
            }else{
                $item->deleted_at = "NA";
            }
        }); 
        return DataTables::of($employees)->make(true);
    }

    // eclaimauditpdf
    
    public function eclaimauditpdf(Request $request)
    {

        
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        
        $url1 = str_replace("length=10","length=-1",session('claim_audit_data'));
        $url11 = str_replace("length=20","length=-1", $url1);
        $url12 = str_replace("length=50","length=-1", $url11);
        $url = str_replace("length=100","length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        

        $employees = json_decode($response)->data;
        
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $html = html_entity_decode(view('E-Claim.pdf.audit-pdf', compact('employees', 'timedate', 'companyname', 'employees'))); //->render();
        $pdf = new Dompdf();


        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('claim Audit Report');
        return 1;
    }

    public function eclaimauditexport(Request $request)
    {
        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('claim_audit_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Claim Audit Report');
        $sheet->setCellValue('B' . 2, 'Admin');
        $sheet->setCellValue('C' . 2, 'Emp No');
        $sheet->setCellValue('D' . 2, 'Emp Name');
        $sheet->setCellValue('E' . 2, 'Updated Date');
        $sheet->setCellValue('F' . 2, 'Deleted Date/Time');
        $sheet->setCellValue('G' . 2, 'Amount From');
        $sheet->setCellValue('H' . 2, 'Amount To');
        $sheet->setCellValue('I' . 2, 'Type From');
        $sheet->setCellValue('J' . 2, 'Type To');
        $sheet->setCellValue('K' . 2, 'Status From');
        $sheet->setCellValue('L' . 2, 'Status to');

        $rows = 2;
        foreach ($employees as $employee) {
            $rows++;
            $sheet->setCellValue('B' . $rows, $employee->admin);
            $sheet->setCellValue('C' . $rows, $employee->emp_id);
            $sheet->setCellValue('D' . $rows, $employee->emp_name);
            $sheet->setCellValue('E' . $rows, $employee->created_at);
            $sheet->setCellValue('F' . $rows, $employee->deleted_at);
            $sheet->setCellValue('G' . $rows, $employee->amount_from);
            $sheet->setCellValue('H' . $rows, $employee->amount_to);
            $sheet->setCellValue('I' . $rows, $employee->type_from);
            $sheet->setCellValue('J' . $rows, $employee->type_to);
            $sheet->setCellValue('K' . $rows, $employee->status_from);
            $sheet->setCellValue('L' . $rows, $employee->status_to);
        }


        $fileName = "eclaim-audit.xlsx";

        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }
}
