<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, LeavePast, UserPay, Branch, Department, Category};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Carbon\CarbonInterval;
use Carbon\CarbonPeriod;

class Eleavecontroller extends Controller
{
    public function dashboard($year = null){

    	$hours = gethours();
        $user = User::where('id' , Auth::id())->first();
        $year = request()->get('year') ?? carbon()->year;
	//dd(getSettingsValue('leave_adjustment_type'));
		if(getSettingsValue('leave_adjustment_type') == 8){
			$year = $year;
			$joiningDate = getJoinDateStr($user->username);
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			// if ((isset($_POST["pdf"]))) {
			// } else {
				if (date('Y-m-d') < $curr_date) {
				//	$year = $year - 1;
					$year = $year;
				}
			// }
		}
	
		$startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        
        $months = [];
		$pendingLeaves = [];
		$approvedLeaves = [];
		$type = request()->get('type') ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$m = $month->copy()->format('n');
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			// $pending = LeaveList::where('username', $user->username)->whereIn('status', ['0', '5'])->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();

			// $approved = LeaveList::where('username', $user->username)->where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
            //$approved = sum(CASE b.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) from leave_days
			//$pending = sum(total_leave_days) as leaves from leave_past

            $approved = LeaveDay::selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as ss")
            			->join('leave_list',"leave_days.leave_id","leave_list.id")
            			->where('leave_days.username', $user->username)
            			->where("leave_days.status",1)
            			->where("leave_list.type",$type)
            			->whereRaw("month(leave_days.date) ='".$m."'")
            			->whereRaw("year(leave_days.date) ='".$year."'")->first()->ss ?? 0;


            // $pending = LeavePast::selectRaw("sum(leave_past.total_leave_days) as ss")
            // 			->where('leave_past.username', $user->username)
            // 			->where("leave_past.type",$type)
            // 			->whereRaw("month(leave_past.start_date) ='".$m."'")
            // 			->whereRaw("year(leave_past.start_date) ='".$year."'")->first()->ss ?? 0;
            			
            $pending = LeaveDay::selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as ss")
            			->join('leave_list',"leave_days.leave_id","leave_list.id")
            			->where('leave_days.username', $user->username)
            			->where("leave_days.status",0)
            			->where("leave_list.type",$type)
            			->whereRaw("month(leave_days.date) ='".$m."'")
            			->whereRaw("year(leave_days.date) ='".$year."'")->first()->ss ?? 0;


			array_push($pendingLeaves, $pending);
			array_push($approvedLeaves, $approved);
		}
		$pendingLeave = Leavelist::where('status', '0')->where('type', 'Annual')->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('end_date', '<=', $endOfYear->format('Y-m-d'))->where('username', $user->username)->count();
		$approvedLeave = Leavelist::where('status', '1')->where('type', 'Annual')->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('end_date', '<=', $endOfYear->format('Y-m-d'))->where('username', $user->username)->count();

		$start = Carbon::now()->startOfMonth();
        $end = $start->copy()->endOfMonth();
        $now = Carbon::now();
        $interval = CarbonPeriod::create($start, $end);

    	$user = User::where('id' , Auth::id())->first();
    	$leavetypes = Leavetype::orderBy('name')->where('is_show',1)->get();
    	$relieves = Relieve::orderBy('name')->get();
		$today = \Carbon\Carbon::now();
		$ActiveUserShownStatus1=DB::table('settings')->where('field','active_user_shown')->where('company_id',$user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly1=DB::table('settings')->where('field','only_current_year_leave_display')->where('company_id',$user->company_id)->first();
        $currentOnly = $currentOnly1->value ?? 0;
		$viewStatus = getPermissionValue("view_leave",$user->username);
		
    	$leaves = Leavelist::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename")->where('start_date', date('Y-m-d'))->where('status', '1')->join('user_personal','user_personal.username','=','leave_list.username')->leftjoin('user_pay','user_pay.username','=','leave_list.username')->leftjoin('leave_name', 'leave_name.type','=','leave_list.type');
    	if($currentOnly=='1'){
    	   $leaves->whereYear('leave_list.start_date','>=', date('Y')); 
    	}
    	if($viewStatus==4){
    	    $leaves->where('user_personal.employee_no',$user->username);
    	}
    	elseif($viewStatus==5){
    	    $userGroups=DB::table('user_pay')->where('username',$user->username)->first();
    	    
    	    $leaves->where('user_pay.branch_id',$userGroups->branch_id)->where('user_pay.category_id',$userGroups->category_id)->where('user_pay.department_id',$userGroups->department_id);
    	    
    	    
    	}elseif($viewStatus==8){
    	    
    	    $logged_userGroups=DB::table('user_pay')->where('username',$user->username)->first();
			$all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
			if(is_array($all_other_branch_ids) && count($all_other_branch_ids)>0){
				$array_i = array();
				for($b_id_i = 0; $b_id_i<count($all_other_branch_ids); $b_id_i++){
					$array_i[] = $all_other_branch_ids[$b_id_i]->id;
				}
				$str_branch_ids = implode(", ",$array_i);
				$leaves->whereIn('user_pay.branch_id',$str_branch_ids);
			}
    	    
    	}
    	if($ActiveUserShownStatus=='1'){
           $leaves->whereRaw("(user_pay.pay_status = '1' or user_pay.pay_status = '0')");
        }
        else{
            $leaves->where('user_pay.pay_status',1);
        }
    	$leaves = $leaves->get();
		$leaves->transform(function($item) {
            $pay = UserPay::where('username', $item->username)->first();
			$branch = Branch::find($pay->branch_id);
			$department = Department::find($pay->department_id);
			$category = Category::find($pay->category_id);
			$item->branch = $branch->name ?? "";
			$item->department = $department->name ?? "";
			$item->category = $category->name ?? "";
			if($item->is_half_day == 0)
			{
				$item->leave_type = "Full Day";
			}
			else
			{
				if($item->half_day_type=='first'){
					$item->leave_type = "Half Day (AM)";
				}
				if($item->half_day_type=='second'){
					$item->leave_type = "Half Day (PM)";
				}
			}
			return $item;
		});
		$history = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Annual')->first();
		// dd($history);
		$medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Medical')->first();
		$repHistory = DB::table('leave_list')->where('username', $user->username)
					->where('type', 'Other_pay')->where('status', 1)->count();
		$totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');
		// dd($user);
		$userPay = DB::table('user_pay')->where('username', $user->username)->first();
		$branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
		if($branchData != null){
			$userState = $branchData->state;
			// $branchId = $branchData->id;
		}else{
			$userState = "zzzzzzz";
			// $userState = 0;
		}
	//	dd($year);
		if($year!=null){
			$yr=$year;
		}
		else{
			$yr=date('Y');
		}
		
		$recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*")->orderBy('date','ASC')->where('company_id', $user->company_id)
					->where('date', '>' , date('Y-m-d'))->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "'.$userState.'")')->groupBy('description')->get();
	

		// $myLeaveSumm = json_decode(myLeaveSummary($user->username,$year),true);
		// $myLeaveSummSm = json_decode(myLeaveSummary($user->username,$year,"getYearlyrlEntitleList"),true);
		// $myLeaveSummSm = $myLeaveSummSm['users'][0];
		
// 		$myLeaveSumm = getYearlyEntitle($user->username, $year);
// 	    //dd($myLeaveSumm);
// 		$myLeaveSummSm = getYearlyrlEntitleList($user->username, $year);
// 		if(!$myLeaveSummSm->isEmpty()){
// 			$myLeaveSummSm= $myLeaveSummSm[0];
// 		}
// 		else{
// 			$myLeaveSummSm= '';
// 		}
		//dd($myLeaveSummSm);
		
		$uname = DB::table('user_personal')->whereRaw('name="' . $user->username . '" or username="' . $user->username . '" or employee_no="' . $user->username . '"')->first();
        $name = urlencode($uname->employee_no);
        $ln = 1;
        $aid = Auth::id();
        
        $url11 = str_replace("e-leave/dashboard","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
      
       // dd($url11);
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $myLeaveSumm = json_decode($response);
           
         if (!empty($myLeaveSumm)) {
            $myLeaveSumm = $myLeaveSumm[0];
        } else {
            $myLeaveSumm = '';
        }
      
        $url12 = str_replace("e-leave/dashboard","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }

        
        $url = str_replace("e-leave/dashboard", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());

        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $myLeaveSummSm = json_decode($response);

        //dd($myLeaveSummSm);
        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }
       // dd($myLeaveSummSm,$medicalSumm,$myLeaveSumm);
		// dd($months, $pendingLeaves, $approvedLeaves,$type);
		// dd($arrayOne,$arrayTwo,$arrayThree);
    	return view('E-Leave/dashboard' , ['leavetypes'=>$leavetypes , 'relieves'=>$relieves ,
		'leaves'=>$leaves, 'history' => $history, 'recentHoliday' => $recentHoliday,
		'months' => json_encode($months,JSON_NUMERIC_CHECK),
		'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
		'approvedLeaves' => json_encode($approvedLeaves,JSON_NUMERIC_CHECK),
		'approvedLeave' => $approvedLeave, 
		'start' => $start, 'interval' =>  $interval, 'monthArray' => $months,
		
		'pendingLeave' => $pendingLeave, 'medHistory' => $medHistory, 'repHistory' => $repHistory, 'totalReplacement' =>$totalReplacement ,'year'=>$year,'myLeaveSumm' =>$myLeaveSumm, 'myLeaveSummSm'=>$myLeaveSummSm, 'medicalSumm'=>$medicalSumm]);
	}
	
	function edashmysummary(Request $request){
	    
	    $user = User::where('id' , Auth::id())->first();
    	
	    $year = request()->get('year') ?? date('Y');
	     
	    $userPay = DB::table('user_pay')->where('username', $user->username)->first();
		$branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
		if($branchData != null){
			$userState = $branchData->state;
		}else{
			$userState = "zzzzzzz";
		}
	    
    	$recentHoliday11 = DB::table('public_holiday')->selectRaw("public_holiday.*")->orderBy('date','ASC')->where('company_id', $user->company_id)
				->whereYear('date', '=' , $year)->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "'.$userState.'")')->groupBy('date')->get();
                   
		$leavesArray =DB::table('leave_list')
		->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->select('leave_list.*', 'leave_days.leave_id', 'leave_days.date','leave_days.cancellation_reason','leave_days.reject_reason')->whereRaw('(leave_list.status != "2" And leave_list.status != "4")')->where('leave_list.username' , $user->username)->whereYear('leave_days.date', '=' , $year)->orderBy('date_applied' , 'DESC')->get();
	
		$rday = DB::table('rest_days')->where('employee_id',$user->username)->select('employee_id')->first();
		
		$recat = DB::table('rest_day_category_employee')->where('employee_id',$user->username)->select('category_id')->first();
		
		if($rday!=''){
		    
			$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('user_personal','rest_days.employee_id','=','user_personal.username');
			if($recat!=''){
			    
			    $restDay->leftjoin('rest_day_category_employee','rest_days.category_id','=','rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
			    
			}
			$restDay = $restDay->where('rest_days.employee_id', $user->username)->whereYear('rest_dates.date', '=' , $year)->groupBy('rest_dates.date')->get();
			
		}else{
		    
			
			$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal','rest_days.employee_id','=','user_personal.username')->leftjoin('rest_day_category_employee','rest_days.category_id','=','rest_day_category_employee.category_id');
			if($recat!=''){
			    
			    $restDay->where('rest_days.category_id', $recat->category_id);
			    
			}
			$restDay=$restDay->where('rest_day_category_employee.employee_id', $user->username)->whereYear('rest_dates.date', '=' , $year)->groupBy('rest_dates.date')->get();
		}
		
		$restDay->transform( function($item) {
		$item->month = date("F", strtotime($item->date));
		$item->day = date("j", strtotime($item->date));
			return [
				'status' => '#e0e0e0',
				'date' => $item->date,
				'month' => $item->month,
				'day' => $item->day,
				];
			})->toArray();
		
		$recentHoliday11->transform( function($item) {
			$item->month = date("F", strtotime($item->date));
			$item->day = date("j", strtotime($item->date));
			return [
				'status' => '#6a7e80',
				'date' => $item->date,
				'month' => $item->month,
				'day' => $item->day,
			];
		})->toArray();
        $leavesArray = $leavesArray->transform(function($item) {
			$item->month = date("F", strtotime($item->date));
			$item->day = date("j", strtotime($item->date));
			$color='';
			if($item->status == '1' && ($item->type == 'Annual' || $item->type == 'Emergency'))
			{
				$color = "#28c76f";
			}
			
			if($item->status == '0')
			{
				$color = "#ff9f43";
			}
			if($item->status != '0' && $item->status != '2'  && $item->status != '4'  && $item->type != 'Annual' && $item->type != 'Medical' && $item->type != 'Emergency' && $item->type != 'NPL' && $item->type != 'Other_pay')
			{
				$color = "#7367f0";
			}
			if($item->type == 'Medical' && $item->status != '0')
			{
				$color = "#ea5455";
			}
			if($item->type == 'NPL' && $item->status != '0')
			{
				$color = "#4298a1";
			}
			if($item->type == 'Other_pay' && $item->status != '0' && $item->status != '2'  && $item->status != '4')
			{
				$color = "#00cfe8";
			}
			return [
				'status' => $color,
				'date' => $item->start_date,
				'month' => $item->month,
				'day' => $item->day,
			];
		});
		$ucat = DB::table('user_category')->where('username', $user->username)->first();
		$holidaycatpriority = DB::table('holiday_restday_inleave_setting')->where('category', $ucat->category)->whereRaw('(restday_added = "1" or holiday_added="1")')->get();
		$leavesArray11 =DB::table('leave_list')
					->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->select('leave_list.*', 'leave_days.leave_id', 'leave_days.date','leave_days.cancellation_reason','leave_days.reject_reason')->whereRaw('(leave_list.status != "2" And leave_list.status != "4")')->where('leave_list.username' , $user->username)->whereYear('leave_days.date', '=' , $year)->orderBy('date_applied' , 'DESC')->get();
		$leavesArray11 = $leavesArray11->transform(function($item)use($holidaycatpriority){
			
			foreach($holidaycatpriority as $holidaycatprioritys){
			if($holidaycatprioritys->leave_type==$item->type){
			$item->month = date("F", strtotime($item->date));
			$item->day = date("j", strtotime($item->date));
			$color='';
			if($item->status == '1' && ($item->type == 'Annual' || $item->type == 'Emergency'))
			{
				$color = "#28c76f";
			}
			
			if($item->status == '0')
			{
				$color = "#ff9f43";
			}
			if($item->status != '0' && $item->status != '2'  && $item->status != '4'  && $item->type != 'Annual' && $item->type != 'Medical' && $item->type != 'Emergency' && $item->type != 'NPL' && $item->type != 'Other_pay')
			{
				$color = "#7367f0";
			}
			if($item->type == 'Medical' && $item->status != '0')
			{
				$color = "#ea5455";
			}
			if($item->type == 'NPL' && $item->status != '0')
			{
				$color = "#4298a1";
			}
			if($item->type == 'Other_pay' && $item->status != '0' && $item->status != '2'  && $item->status != '4')
			{
				$color = "#00cfe8";
			}
			return [
				'status' => $color,
				'date' => $item->start_date,
				'month' => $item->month,
				'day' => $item->day,
			];
		}
		}
		});
		
		
		$leavesArray112 =DB::table('leave_past')
					->where('username' , $user->username)->whereYear('start_date', '=' , $year)->orderBy('start_date' , 'DESC')->get();
				
		$leavesArray112 = $leavesArray112->transform(function($item)use($holidaycatpriority){
			
			foreach($holidaycatpriority as $holidaycatprioritys){
			  
			if($holidaycatprioritys->leave_type==$item->type || $holidaycatprioritys->leave_type!=$item->type){
			$item->month = date("F", strtotime($item->start_date));
			$item->day = date("j", strtotime($item->start_date));
			$color='';
			if($item->status == '1' && ($item->type == 'Annual' || $item->type == 'Emergency'))
			{
				$color = "#28c76f";
			}
			
			if($item->status == '0')
			{
				$color = "#ff9f43";
			}
			if($item->status != '0' && $item->status != '2'  && $item->status != '4'  && $item->type != 'Annual' && $item->type != 'Medical' && $item->type != 'Emergency' && $item->type != 'NPL' && $item->type != 'Other_pay')
			{
				$color = "#7367f0";
			}
			if($item->type == 'Medical' && $item->status != '0')
			{
				$color = "#ea5455";
			}
			if($item->type == 'NPL' && $item->status != '0')
			{
				$color = "#4298a1";
			}
			if($item->type == 'Other_pay' && $item->status != '0' && $item->status != '2'  && $item->status != '4')
			{
				$color = "#00cfe8";
			}
			return [
				'status' => $color,
				'date' => $item->start_date,
				'month' => $item->month,
				'day' => $item->day,
			];
			
		}
		
		}
		});
		
		$arrayOne = [];
		$arrayTwo = [];
		$arrayThree = [];
		$arrayFour = [];
		$arrayFive = [];
		$arraySix = [];
		$arraySeven = [];
		$arrayEight = [];
		$arrayNine = [];
		$arrayTen = [];
		$arrayEleven = [];
		$arrayTweal = [];
		$leavesArray11=array_filter($leavesArray11->toArray());
		$leavesArray112=array_filter($leavesArray112->toArray());
		//dd($leavesArray112);
		$allLeaves11 = $leavesArray->merge($restDay);
		$allLeaves12 =$allLeaves11->merge($recentHoliday11);
		$allLeaves113=$allLeaves12->merge($leavesArray112);
		$allLeaves =$allLeaves113->merge($leavesArray11);
		
		
		foreach($allLeaves as $leaveVal)
		{
		
		
			if($leaveVal['month'] == "January")
			{
				$arrayOne[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "February")
			{
				$arrayTwo[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "March")
			{
				$arrayThree[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "April")
			{
				$arrayFour[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "May")
			{
				$arrayFive[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "June")
			{
				$arraySix[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "July")
			{
				$arraySeven[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "August")
			{
				$arrayEight[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "September")
			{
				$arrayNine[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "October")
			{
				$arrayTen[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "November")
			{
				$arrayEleven[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "December")
			{
				$arrayTweal[$leaveVal['day']] = $leaveVal['status'];
			}


		}
		for($i=1; $i <=31 ; $i++)
		{
			if(!isset($arrayOne[$i]))
			{
				$arrayOne[$i] = 'transparent';
			}
			if(!isset($arrayTwo[$i]))
			{
				$arrayTwo[$i] = 'transparent';
			}
			if(!isset($arrayThree[$i]))
			{
				$arrayThree[$i] = 'transparent';
			}
			if(!isset($arrayFour[$i]))
			{
				$arrayFour[$i] = 'transparent';
			}
			if(!isset($arrayFive[$i]))
			{
				$arrayFive[$i] = 'transparent';
			}
			if(!isset($arraySix[$i]))
			{
				$arraySix[$i] = 'transparent';
			}
			if(!isset($arraySeven[$i]))
			{
				$arraySeven[$i] = 'transparent';
			}
			if(!isset($arrayEight[$i]))
			{
				$arrayEight[$i] = 'transparent';
			}
			if(!isset($arrayNine[$i]))
			{
				$arrayNine[$i] = 'transparent';
			}
			if(!isset($arrayTen[$i]))
			{
				$arrayTen[$i] = 'transparent';
			}
			if(!isset($arrayEleven[$i]))
			{
				$arrayEleven[$i] = 'transparent';
			}
			if(!isset($arrayTweal[$i]))
			{
				$arrayTweal[$i] = 'transparent';
			}
		}
		
		$hours = gethours();
		$a= LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->whereRaw('(type = "Annual" or type="Emergency")')->where('status', 1)->first()->no_days ?? 0;
		$od=LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->whereRaw('(status != 0 and status != 2 and status!=4)')->where('type', "Other_pay")->first()->no_days ?? 0;
		$m=LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->where('type', "Medical")->where('status','!=', "0")->first()->no_days ?? 0;
		$p=LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->where('status','=', "0")->first()->no_days ?? 0;
		$o=LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->where('status','!=', "0")->where('status','!=', "2")->where('status','!=', "4")->where('type','!=', "Annual")->where('type','!=', "Medical")->where('type','!=', "Emergency")->where('type','!=', "NPL")->where('type','!=', "Other_pay")->first()->no_days ?? 0;
		$n=LeaveList::selectRaw('sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'.$hours.') WHEN 0 THEN CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as no_days')->where('username' , $user->username)->whereYear('start_date', '=' , $year)->where('type', "NPL")->where('status','!=', "0")->first()->no_days ?? 0;
		
		$result['Febdays']=cal_days_in_month(CAL_GREGORIAN,2,$year);
		$result['Jan']=$arrayOne ;
		$result['Feb']=$arrayTwo;
		$result['Mar']=$arrayThree;
		$result['Apr']=$arrayFour;
		$result['May']=$arrayFive;
		$result['Jun']=$arraySix;
		$result['Jul']=$arraySeven;
		$result['Aug']=$arrayEight;
		$result['Sep']=$arrayNine;
		$result['Oct']=$arrayTen;
		$result['Nov']=$arrayEleven;
		$result['Dec']=$arrayTweal;

		$result['a']= (float)$a;
		$result['od']= (float)$od;
		$result['m']= (float)$m;
		$result['p']= (float)$p;
		$result['o']= (float)$o;
		$result['n']= (float)$n;
		//dd(count($result));
		return $result;
	    
	}
	
	function filteruser(Request $request){
		$branch=$request->get('branch');
		$department=$request->get('department');
		$category=$request->get('category');
		$user = UserPay::leftJoin('user_personal', 'user_pay.username', '=', 'user_personal.username')->orderBy('user_personal.name' , 'asc');
        
		if($branch && $branch != '')
		{
			$user->where('user_pay.branch_id', $branch);
		}

		if($department && $department != '')
		{
			$user->where('user_pay.department_id', $department);
		}

		if($category && $category != '')
		{
			$user->where('user_pay.category_id', $category);
		}
		$users = $user->get();
		
		return $users;
	}

	function filtercountry(Request $request){
		$user = User::where('id' , Auth::id())->first();
		$country=$request->get('country');
		$states=DB::table('states')->where('company_id',$user->company_id)->where('is_deleted',0);
        if($country && $country != '')
		{
			$states->where('country', $country);
		}
		$states = $states->orderBy('state','asc')->get();
		return $states;
	}
	

    function ApplyForLeave(Request $request){
    	$request->validate([
    		"leave_type"=>"required",
    		"hof"=>"required",
    		"leave_start_date"=>"required|date",
    		"leave_end_date"=>"nullable|date",
    		"reason"=>"nullable",
    		"relieve"=>"required"
    	]);
    	$ishalfday = 0;
    	if($request->hof=='h'){
    		$ishalfday = 1;
    	}
    	$user = User::where('id' , $request->user_id)->first();
    	$leave_start_date = new DateTime($request->leave_start_date);
    	$leave_end_date = new DateTime($request->leave_end_date);


    	if(!empty($request->leave_end_date)){
    		$no_days = $leave_start_date->diff($leave_end_date);
    		$no_days = $no_days->format('%a');
    	}


    	$leave = Leavelist::create([
    		"username"=>$user->username,
    		"type"=>$request->leave_type,
    		"is_half_day"=>$ishalfday,
    		"start_date"=>$request->leave_start_date,
    		"end_date"=>$request->leave_end_date ?? $request->leave_start_date,
    		"no_days"=> $no_days ?? 0.5,
    		"half_day_type"=>'',
    		"reason"=>$request->reason,
    		"date_applied"=>now(),
    		"relieve"=>$request->relieve,

    	]);
    	if($leave){
    		return redirect()->route('employee-dashboard')->with('message','Applied successfully.');
    	}else{
    		return redirect()->route('employee-dashboard')->with('danger','Something went wrong');
    	}

    }


	public function  carbon()
	{
		return new \Carbon\Carbon();
	}


	public function getChartData(Request $request)
	{
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $months = [];
		$pendingLeaves = [];
		$approvedLeave = [];
		$type = $request->type ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			$pending = LeaveList::where('status', '0')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('end_date', '<=', $endDate->format('Y-m-d'))->count();
			$approved = LeaveList::where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('end_date', '<=', $endDate->format('Y-m-d'))->count();
			array_push($pendingLeaves, $pending);
			array_push($approvedLeave, $approved);
		}

		return [
            'months' => json_encode($months,JSON_NUMERIC_CHECK),
			'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
			'approvedLeave' => json_encode($approvedLeave,JSON_NUMERIC_CHECK),
		];
	}

	public function getTimeline($id)
	{
	 // dd($id);
		$leaveDay = LeaveDay::where('id', $id)->first();
	
		$timelinedata = DB::table('timeline_leaves_detail')->where('leave_days_id', $id)->get();
	$leave = LeaveList::join('user_personal','user_personal.username','=','leave_list.username')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->selectRaw("leave_list.*, leave_days.leave_id, leave_days.date, leave_days.date as ldate,leave_days.cancellation_reason,leave_days.reject_reason, user_personal.name,leave_list.start_time, leave_list.end_time")->find($leaveDay->leave_id);
    //	dd(count($timelinedata));
		if(count($timelinedata)>0){
			if($leave->type=='Other_pay'){
				$type='Replacement';
			}
			elseif($leave->type=='Line_Shut'){
				$type='Out Of Office';
			}
			else{
				$type=$leave->type;
			}
			$hourtime = '';
			if($leave->is_hourly==1){
			    
			    $hourtime = '<br>('.date('h:i A',$leave->start_time).' to '.date('h:i A',$leave->end_time).')';
			}
			//$data11[$type.' Leave'] = 'Employee Name: '.$leave->name.', '.'Date: '.date('d-m-Y', strtotime($leave->ldate));
			$data11[date('d-m-Y', strtotime($leave->ldate)).' '.$type.' Leave '.$hourtime.'<br> Reason: '.$leave->reason] = $leave->name;
			$data11[date('d-m-Y h:i A', strtotime($leave->date_applied)).' | Applied'] = '';
// 			$data11['Pending'] = '';
			$i=0;
			$reason = 'Reason: '.$leave->reason;
			if($leave->status == 0)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;';
				$status = 'Pending ';
				
				$approver_id ='';
			}
            $a_id1=[];
            $j=0;
            $k=0;
            $l=0;
            $m=0;
            $n=0;
			foreach($timelinedata as $timelinedata1){
				
				array_push($a_id1,$timelinedata1->approver_id);
				 $tdapprovername=getapprovername($timelinedata1->approver_id);
				if($timelinedata1->status == 1)
				{
				    $i=$i+1;
				    $level='&nbsp;&nbsp;';
					$status = 'Approved';
					$reason = $leave->reason;
					$approver_id = ' Approved ('.$i.'): '.$tdapprovername;
					
				}
				if($timelinedata1->status == 2)
				{
				    $j=$j+1;
				    $level='&nbsp;&nbsp;&nbsp;';
					$status = 'Rejected';
				    $reason = isset($leaveDay) && isset($timelinedata1->reject_reason) ? $leave->reason.' | '.'Reject Reason: '.$timelinedata1->reject_reason.' | '. 'Rejected By: '.$tdapprovername : '';
				$approver_id =' Rejected ('.$j.'): '.$tdapprovername.'<br> Reason: '.$timelinedata1->reject_reason;
				}
				if($timelinedata1->status == 3)
				{
				    $k=$k+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Recommended';
					$reason =  $leave->reason;
					$approver_id=' Recommended ('.$k.'): '.$tdapprovername;
				}
				if($timelinedata1->status == 4)
				{
				    $l=$l+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Cancelled';
					$reason = isset($leaveDay) && isset($timelinedata1->cancellation_reason) ? $leave->reason.' | '.'Cancelled Reason: '.$timelinedata1->cancellation_reason. '' : '';
					$approver_id=' Cancelled ('.$l.'): '.$tdapprovername;
				}
				if($timelinedata1->status == 5)
				{
				    $m=$m+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Cancellation Pending';
					$reason = isset($leaveDay) && isset($timelinedata1->cancellation_reason) ? $leave->reason.' | '.'Cancellation Reason: '.$timelinedata1->cancellation_reason. '' : '';
					$approver_id =' Cancellation Pending ('.$m.'): '.$tdapprovername.'<br> Reason: '.$timelinedata1->cancellation_reason;
				}
				$approver_ids=strtolower($timelinedata1->approver_id);
				$data11[$status != '' ? (isset($timelinedata1->created_at) ? date('d-m-Y h:i A', strtotime($timelinedata1->created_at)). ' | '. $approver_id : $approver_id ) : $reason] ='';
			}
			if($leave->status==0 || $leave->status==5 || $leave->status==3){
			    $approvers=DB::table('map_employee_approver')->where('employee_id',$leave->username)->whereNotIn('approver_id',$a_id1)->get();
			    $aj=$i;
			    foreach($approvers as $approver){
			        $aj=$aj+1;
			        $apname=getapprovername($approver->approver_id);
			        $data11['Pending ('.$aj.'): '.$apname] ='';
			        
			    }

			    
			}
		}
		else{
			
			$leaveApproval = DB::table('approver_approved_leaves')->where('leave_days_id', $id)->get();
			
			$status = '';
			if($leave->approver_id!=''){
			    $lapprovername=getapprovername($leave->approver_id);
			}else{
			    $lapprovername='';
			}
			
		  if($leave->status == 0)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Pending';
				$reason = 'Reason: '.$leave->reason;
				$approver_id ='Pending By (1):'.$lapprovername;
			}
			if($leave->status == 1)
			{
			    //dd("hello");
			    $level='&nbsp;&nbsp;';
				$status = 'Approved';
				$reason = $leave->reason;
				$approver_id = ' Approved By (1):'.$lapprovername;
				
			}
			if($leave->status == 2)
			{
			    //dd("hello1");
			    $level='&nbsp;&nbsp;&nbsp;';
				$status = 'Rejected';
			  $reason = isset($leaveDay) && isset($leaveDay->reject_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->reject_reason.' | '. 'Rejected By: '.$lapprovername : '';
			$approver_id =' Rejected By (1):'.$lapprovername.'<br> Reason: '.$leave->reject_reason;
			}
			if($leave->status == 3)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Recommended';
				$reason =  $leave->reason;
				$approver_id=' Recommended By (1):'.$lapprovername;
			}
			if($leave->status == 4)
			{
				$level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Cancelled';
				$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->cancellation_reason. '' : '';
				$approver_id=' Cancelled By (1):'.$lapprovername;
			}
			if($leave->status == 5)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Cancellation Pending';
				$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->cancellation_reason. '' : '';
				$approver_id =' Cancellation Pending By (1):'.$lapprovername.'<br> Reason: '.$leave->cancellation_reason;
			}
			if($leave->type=='Other_pay'){
				$type='Replacement';
			}
			elseif($leave->type=='Line_Shut'){
				$type='Out Of Office';
			}
			else{
				$type=$leave->type;
			}
			$hourtime = '';
			if($leave->is_hourly==1){
			    
			    $hourtime = '<br>('.date('h:i A',$leave->start_time).' to '.date('h:i A',$leave->end_time).')';
			}
			//$data11[$type.' Leave'] = 'Employee Name: '.$leave->name.', '.'Date: '.date('d-m-Y', strtotime($leave->date));
			$data11[date('d-m-Y', strtotime($leave->date)).' '.$type.' Leave '.$hourtime.'<br> Reason: '.$leave->reason] = $leave->name;
			$data11[date('d-m-Y h:i A', strtotime($leave->date_applied)).' | Applied'] = '';
// 			$data11['Pending'] = '';
			$i=0;
		//	dd($data11);
		//dd($leaveApproval);
			if($leaveApproval->isEmpty()){
			   // dd($leave->date_approved);
			//	dd($leave->status);
				if($leave->date_approved!='0000-00-00'){
				    $approved=$leave->date_approved;
				}else{
				    $approved=$leave->ldate;
				}
				    if($lapprovername!=''){
    				   $data11[$status != '' ? (isset($approved) ? date('d-m-Y', strtotime($approved)). ' | '. $approver_id : $approver_id ) : $reason] = '';
			        }
				   if($leave->status==0 || $leave->status==5 || $leave->status==3){
    				    $approvers11=DB::table('map_employee_approver')->where('employee_id',$leave->username);
    				    if($leave->approver_id!=''){
    				      $approvers11->where('approver_id','!=',$leave->approver_id);  
    				    }
    				    
    				    $approvers11=$approvers11->get();
    				    if($lapprovername!=''){
        			        $aj=1;
    				    }else{
    				        $aj=0;
    				    }
        			    foreach($approvers11 as $approver1){
        			        $aj=$aj+1;
        			        $apname=getapprovername($approver1->approver_id);
        			        $data11['Pending ('.$aj.'): '.$apname] ='';
        			       
        			    }
    				    
    				    
    				    
    				    
    				}
			   
			}
			else{
				$a_id=[];
				foreach($leaveApproval as $leaveApprovals){
				$i=$i+1;
				array_push($a_id,$leaveApprovals->approver_id);
				$approver_ids=strtolower($leaveApprovals->approver_id);
					if($approver_ids!='admin'){
					    $laapprovername=getapprovername($leaveApprovals->approver_id);
						//$data11['Approve Lavel '.$i] = date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)).' | '.'Approved ('.$i.'):'.$laapprovername;
						$data11[date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)).' | '.'Approved ('.$i.'):'.$laapprovername] = '';
					}
					else{
						$data11[$status != '' ? (isset($leaveApprovals->created_at) ? date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)). ' | '.'Leave Reason: ' .$reason. ' | '. $approver_id : $approver_id ) : $reason] ='';
						}
				
				}
				if($leave->status==0 || $leave->status==5 || $leave->status==3){
				    $approvers=DB::table('map_employee_approver')->where('employee_id',$leave->username)->whereNotIn('approver_id',$a_id)->get();
    			    $aj=$i;
    			    foreach($approvers as $approver){
    			        
    			        $apname=getapprovername($approver->approver_id);
    			        $data11['Pending ('.$aj.'): '.$apname] ='';
    			       
    			    }
				    
				    
				    
				    
				}
			}
		}
		
		//dd($data11);	
		return $data11;
	
	}
	
	public function getTimelines($id)
	{
	 // dd($id);
		$leaveDay = LeaveDay::where('id', $id)->first();
	
		$timelinedata = DB::table('timeline_leaves_detail')->where('leave_days_id', $id)->get();
		$leave = LeaveList::join('user_personal','user_personal.username','=','leave_list.username')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->selectRaw("leave_list.*, leave_days.leave_id, leave_days.date, leave_days.date as ldate,leave_days.cancellation_reason,leave_days.reject_reason, user_personal.name,leave_list.start_time, leave_list.end_time")->find($leaveDay->leave_id);
   //	dd(count($timelinedata));
 //  dd(date('h:i A', $leave->start_time));
  // dd($leave);
		if(count($timelinedata)>0){
			if($leave->type=='Other_pay'){
				$type='Replacement';
			}
			elseif($leave->type=='Line_Shut'){
				$type='Out Of Office';
			}
			else{
				$type=$leave->type;
			}
			$hourtime = '';
			if($leave->is_hourly==1){
			    
			    $hourtime = '<br>('.date('h:i A',$leave->start_time).' to '.date('h:i A',$leave->end_time).')';
			}
			//$data11[$type.' Leave'] = 'Employee Name: '.$leave->name.', '.'Date: '.date('d-m-Y', strtotime($leave->ldate));
			$data11[date('d-m-Y', strtotime($leave->ldate)).' '.$type.' Leave '.$hourtime.'<br> Reason: '.$leave->reason] = $leave->name;
			$data11[date('d-m-Y h:i A', strtotime($leave->date_applied)).' | Applied'] = '';
// 			$data11['Pending'] = '';
			$i=0;
			$reason = 'Reason: '.$leave->reason;
			if($leave->status == 0)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;';
				$status = 'Pending ';
				
				$approver_id ='';
			}
            $a_id1=[];
            $j=0;
            $k=0;
            $l=0;
            $m=0;
            $n=0;
			foreach($timelinedata as $timelinedata1){
				
				array_push($a_id1,$timelinedata1->approver_id);
				 $tdapprovername=getapprovername($timelinedata1->approver_id);
				if($timelinedata1->status == 1)
				{
				    $i=$i+1;
				    $level='&nbsp;&nbsp;';
					$status = 'Approved';
					$reason = $leave->reason;
					$approver_id = ' Approved ('.$i.'): '.$tdapprovername;
					
				}
				if($timelinedata1->status == 2)
				{
				    $j=$j+1;
				    $level='&nbsp;&nbsp;&nbsp;';
					$status = 'Rejected';
				    $reason = isset($leaveDay) && isset($timelinedata1->reject_reason) ? $leave->reason.' | '.'Reject Reason: '.$timelinedata1->reject_reason.' | '. 'Rejected By: '.$tdapprovername : '';
				$approver_id =' Rejected ('.$j.'): '.$tdapprovername.'<br> Reason: '.$timelinedata1->reject_reason;
				}
				if($timelinedata1->status == 3)
				{
				    $k=$k+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Recommended';
					$reason =  $leave->reason;
					$approver_id=' Recommended ('.$k.'): '.$tdapprovername;
				}
				if($timelinedata1->status == 4)
				{
				    $l=$l+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Cancelled';
					$reason = isset($leaveDay) && isset($timelinedata1->cancellation_reason) ? $leave->reason.' | '.'Cancelled Reason: '.$timelinedata1->cancellation_reason. '' : '';
					$approver_id=' Cancelled ('.$l.'): '.$tdapprovername;
				}
				if($timelinedata1->status == 5)
				{
				    $m=$m+1;
				    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
					$status = 'Cancellation Pending';
					$reason = isset($leaveDay) && isset($timelinedata1->cancellation_reason) ? $leave->reason.' | '.'Cancellation Reason: '.$timelinedata1->cancellation_reason. '' : '';
					$approver_id =' Cancellation Pending ('.$m.'): '.$tdapprovername.'<br> Reason: '.$timelinedata1->cancellation_reason;
				}
				$approver_ids=strtolower($timelinedata1->approver_id);
				$data11[$status != '' ? (isset($timelinedata1->created_at) ? date('d-m-Y h:i A', strtotime($timelinedata1->created_at)). ' | '. $approver_id : $approver_id ) : $reason] ='';
			}
			if($leave->status==0 || $leave->status==5 || $leave->status==3){
			    $approvers=DB::table('map_employee_approver')->where('employee_id',$leave->username)->whereNotIn('approver_id',$a_id1)->get();
			    $aj=$i;
			    foreach($approvers as $approver){
			        $aj=$aj+1;
			        $apname=getapprovername($approver->approver_id);
			        $data11['Pending ('.$aj.'): '.$apname] ='';
			        
			    }

			    
			}
		}
		else{
			
			$leaveApproval = DB::table('approver_approved_leaves')->where('leave_days_id', $id)->get();
			
			$status = '';
			if($leave->approver_id!=''){
			    $lapprovername=getapprovername($leave->approver_id);
			}else{
			    $lapprovername='';
			}
			
		  if($leave->status == 0)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Pending';
				$reason = 'Reason: '.$leave->reason;
				$approver_id ='Pending By (1):'.$lapprovername;
			}
			if($leave->status == 1)
			{
			    //dd("hello");
			    $level='&nbsp;&nbsp;';
				$status = 'Approved';
				$reason = $leave->reason;
				$approver_id = ' Approved By (1):'.$lapprovername;
				
			}
			if($leave->status == 2)
			{
			    //dd("hello1");
			    $level='&nbsp;&nbsp;&nbsp;';
				$status = 'Rejected';
			  $reason = isset($leaveDay) && isset($leaveDay->reject_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->reject_reason.' | '. 'Rejected By: '.$lapprovername : '';
			$approver_id =' Rejected By (1):'.$lapprovername.'<br> Reason: '.$leave->reject_reason;
			}
			if($leave->status == 3)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Recommended';
				$reason =  $leave->reason;
				$approver_id=' Recommended By (1):'.$lapprovername;
			}
			if($leave->status == 4)
			{
				$level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Cancelled';
				$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->cancellation_reason. '' : '';
				$approver_id=' Cancelled By (1):'.$lapprovername;
			}
			if($leave->status == 5)
			{
			    $level='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				$status = 'Cancellation Pending';
				$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? $leave->reason.' | '.'Reason: '.$leaveDay->cancellation_reason. '' : '';
				$approver_id =' Cancellation Pending By (1):'.$lapprovername.'<br> Reason: '.$leave->cancellation_reason;
			}
			if($leave->type=='Other_pay'){
				$type='Replacement';
			}
			elseif($leave->type=='Line_Shut'){
				$type='Out Of Office';
			}
			else{
				$type=$leave->type;
			}
			$hourtime = '';
			if($leave->is_hourly==1){
			  //  dd($leave);
			    $hourtime = '<br>('.date('h:i A',$leave->start_time).' to '.date('h:i A',$leave->end_time).')';
			}
			//$data11[$type.' Leave'] = 'Employee Name: '.$leave->name.', '.'Date: '.date('d-m-Y', strtotime($leave->date));
			$data11[date('d-m-Y', strtotime($leave->date)).' '.$type.' Leave '.$hourtime.'<br> Reason: '.$leave->reason] = $leave->name;
			$data11[date('d-m-Y h:i A', strtotime($leave->date_applied)).' | Applied'] = '';
// 			$data11['Pending'] = '';
			$i=0;
		//	dd($data11);
		//dd($leaveApproval);
			if($leaveApproval->isEmpty()){
			   // dd($leave->date_approved);
			//	dd($leave->status);
				if($leave->date_approved!='0000-00-00'){
				    $approved=$leave->date_approved;
				}else{
				    $approved=$leave->ldate;
				}
				    if($lapprovername!=''){
    				   $data11[$status != '' ? (isset($approved) ? date('d-m-Y', strtotime($approved)). ' | '. $approver_id : $approver_id ) : $reason] = '';
			        }
				   if($leave->status==0 || $leave->status==5 || $leave->status==3){
    				    $approvers11=DB::table('map_employee_approver')->where('employee_id',$leave->username);
    				    if($leave->approver_id!=''){
    				      $approvers11->where('approver_id','!=',$leave->approver_id);  
    				    }
    				    
    				    $approvers11=$approvers11->get();
    				    if($lapprovername!=''){
        			        $aj=1;
    				    }else{
    				        $aj=0;
    				    }
        			    foreach($approvers11 as $approver1){
        			        $aj=$aj+1;
        			        $apname=getapprovername($approver1->approver_id);
        			        $data11['Pending ('.$aj.'): '.$apname] ='';
        			       
        			    }
    				    
    				    
    				    
    				    
    				}
			   
			}
			else{
				$a_id=[];
				foreach($leaveApproval as $leaveApprovals){
				$i=$i+1;
				array_push($a_id,$leaveApprovals->approver_id);
				$approver_ids=strtolower($leaveApprovals->approver_id);
					if($approver_ids!='admin'){
					    $laapprovername=getapprovername($leaveApprovals->approver_id);
						//$data11['Approve Lavel '.$i] = date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)).' | '.'Approved ('.$i.'):'.$laapprovername;
						$data11[date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)).' | '.'Approved ('.$i.'):'.$laapprovername] = '';
					}
					else{
						$data11[$status != '' ? (isset($leaveApprovals->created_at) ? date('d-m-Y h:i A', strtotime($leaveApprovals->created_at)). ' | '.'Leave Reason: ' .$reason. ' | '. $approver_id : $approver_id ) : $reason] ='';
						}
				
				}
				if($leave->status==0 || $leave->status==5 || $leave->status==3){
				    $approvers=DB::table('map_employee_approver')->where('employee_id',$leave->username)->whereNotIn('approver_id',$a_id)->get();
    			    $aj=$i;
    			    foreach($approvers as $approver){
    			        
    			        $apname=getapprovername($approver->approver_id);
    			        $data11['Pending ('.$aj.'): '.$apname] ='';
    			       
    			    }
				    
				    
				    
				    
				}
			}
		}
		
		//dd($data11);	
		return $data11;
	
	}


	public function filterGraph(Request $request)
	{
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $months = [];
		$pendingLeaves = [];
		$approvedLeave = [];
		$type = $request->leave_type ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			$pending = LeaveList::where('status', '0')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			$approved = LeaveList::where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			array_push($pendingLeaves, $pending);
			array_push($approvedLeave, $approved);
		}
		return ['months' => $months,
		'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
		'approvedLeave' => json_encode($approvedLeave,JSON_NUMERIC_CHECK),
	];
	}
	// function getYearlyEntitle($year = null){
	// 	if($year == null){
	// 		$year = carbon()->year;
    //     }
    //     $user = User::where('id' , Auth::id())->first();
	// 	$year = request()->post('year') ?? carbon()->year;
	// 	$type ="Annual";
	// 	$username = $user->username;
	// 	$cutOffMonth = DB::table('settings')->where('field', "cut_of_month")->first();
	// 	$cutOffDate = DB::table('settings')->where('field', "cut_of_date")->first();
	// 	$cutOffStartDate = DB::table('settings')->where('field', "cut_of_startdate")->first();
	// 	$cutOffStartMonth = DB::table('settings')->where('field', "cut_of_startmonth")->first();
	// 	$SettingLeaveAdjustmentType = DB::table('settings')->where('field', "leave_adjustment_type")->first();
	// 	if ($SettingLeaveAdjustmentType->value == 8) {
	// 		$joiningDate = UserPay::where('username',$username)->first();
	// 		$joiningDateArr = explode('-', $joiningDate->date_commence);
	// 		$joining_month = $joiningDateArr[1];
	// 		$joining_date = $joiningDateArr[2];
	// 		$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
	// 		if ((isset($_POST["pdf"]))) {
	// 		} else {
	// 			if (date('Y-m-d') < $curr_date) {
	// 				$year = $year - 1;
	// 			}
	// 		}
		
	// 	}
		
	// 	$SoftwareStartDate = DB::table('settings')->where('field', "software_start_year")->first();
	// 	$companyName = DB::table('settings')->where('field', "company")->first();
	// 	$isShowClaimable ='';
	// 	$date_commence= UserPay::where('username',$username)->first();
	// 	$joiningDate = strtotime($date_commence->date_commence);
	// 	$cutOffStartYear = $year;
	// 	$cutOffYear = $year;
	// 	if($cutOffStartMonth->value!=1){
	// 		if($cutOffStartMonth->value > date('m')){
	// 			$cutOffStartYear = $year;
	// 			$cutOffYear = $year;
	// 		}else{
	// 			$cutOffStartYear = $year-1;
	// 			$cutOffYear = $year;
	// 		}
	// 	}else{
	// 		$cutOffStartYear = $year;
	// 		$cutOffYear = $year;
	// 	}
	// 	$duration_query = DB::table('settings')->where('field', "replacement_duration")->first();
	// 	$duration = $duration_query->value;
	// 	if($duration<365){
	// 		$result = DB::table('leave_adjustment')->where('employee_id',$username)->whereYear('start_date',$year)->where('taken_stat',0)->having('isforfeit',1)->selectRaw("case when DATEDIFF(DATE_ADD(start_date, INTERVAL (90) DAY),CURDATE()) >0 then 0 ELSE 1 END isforfeit ,no_granted")->get();
	// 		$rl_count = 0;
	// 		for($i=0;$i<count($result);$i++){
	// 			$rl_count += $result[$i]->no_granted;
	// 		}
	// 		$RL_forfeit = $rl_count;
	// 	}
	// 	else{
	// 		$RL_forfeit= 0;
	// 	}
	// 	//dd($RL_forfeit);
	// 	$commence_year=$date_commence->date_commence;
	// 	$resign_year = date('Y',strtotime($date_commence->date_resigned));
	// 	$experience_check = 0;
	// 	$SettingLeaveAdjustmentType= DB::table('settings')->where('field', "leave_adjustment_type")->first();
	// 	$medicalLeaveProRated = DB::table('settings')->where('field', "medical_leave_prorated")->first();
    //     $actual_experience = 0;
	// 	$_check_year = $year;
	// 	$cutOffStartYear = $_check_year;
	// 	$cutOffYear = $_check_year;
	// 		if($cutOffStartMonth!=1){
	// 			if($cutOffStartMonth > date('m')){
	// 				$cutOffStartYear = $_check_year;
	// 				$cutOffYear = $_check_year;
	// 			}else{
	// 				$cutOffStartYear = $_check_year-1;
	// 				$cutOffYear = $_check_year;
	// 			}
	// 		}else{
	// 			$cutOffStartYear = $_check_year;
	// 			$cutOffYear = $_check_year;
	// 		}
	// 		if($SettingLeaveAdjustmentType->value == 6){
	// 			$date_for_query = "CURDATE()";
                
    //             $year_for_check = date('Y');
    //             $year_for_check = date("Y",  strtotime($year));
    //             //$_d = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
    //             $_d = date("Y",  strtotime($year))."-".$cutOffMonth."-".$cutOffDate;
	// 			$date_for_query = "'".$_d."'";
				
	// 			$resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".date("Y")."-".$cutOffMonth."-".$cutOffDate."') as 'days' ")->first();
	// 			$actual_experience = intval($resultArrayVal->experience);
	// 			$date_commence = $resultArrayVal->date_commence;
	// 			$ExperienceInYear = $actual_experience + 1;
	// 			if(date("Y",  strtotime($date_commence))==  $year_for_check){
				
	// 				$resultArrayVal1 = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".$year_for_check."-".$cutOffMonth."-".$cutOffDate."') as 'days'")->first();
	// 				$actual_experience = intval($resultArrayVal1->experience);
    //                 $date_commence = $resultArrayVal1->date_commence;

	// 				$ExperienceInYear = $actual_experience + 1;
					
	// 				$entitle_year_base = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
	// 				if($entitle_year_base==""){
	// 					$entitle_year_base = 0;

	// 				}
					
	// 			}

	// 			$entitle_year_base = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
	// 				if($entitle_year_base==""){
	// 					$entitle_year_base = 0;

	// 				}
                
                
	// 		}
	// 		else if($SettingLeaveAdjustmentType->value == 5){
	// 			if($type=="Medical"){
	// 			}
	// 		}
	// 	$annualEntitle =
		

		
	
	// }
}
