<?php

namespace App\Http\Controllers;

use App\Models\Epayslip;
use Illuminate\Http\Request;
use App\Models\{
    Setting,
    UserEpay,
    User,
    UserPay,
    AllowanceDeduction,
    Category
};
use Auth;
use Dompdf\Dompdf;
use Dompdf\Options;
use PDFSnappy;
use Illuminate\Support\Facades\DB;
use Helper;
use DPDF;
use View;
use File;

class EpayslipController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    protected $storageDriver;

    public function __construct() {
        $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }

    public function index() {
        $user = User::where('id', Auth::id())->first();        
        $c_key = 'payslip_e';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }
        return view('E-Payslip.epayslip', compact('c_key', 'columnHideShowData'));
    }

    public function getAllowanceDeduction() {
        echo json_encode(AllowanceDeduction::get());
    }
    
    public function base64Img(Request $request) {
        $action = '';
        if(!empty($request->action)){
            $action = $request->action;
        }
        echo json_encode(Helper::base64Img(Auth::user()->username,$action));
    }

    public function getUserEPayDetail(Request $request) {
        try {
            $result1 = Helper::userEPayDetail($request->id);
            $result2 = Helper::overtimeDetail();
            echo json_encode($result1) . '##' . json_encode($result2);
        } catch (\Exception $ex) {
            $exception = 'Error - ' . $ex->getMessage() . ' (Line - ' . $ex->getLine() . ')';
            return response()->json(['status' => false, 'message' => $exception], 200);
        }
    }

    public function epayslipView(Request $request) {
        $epayslip_id = '';
        if (!empty($request->id)) {
            $epayslip_id = $request->id;
        }
        return view('E-Payslip.epayslip-view', ['epayslip_id' => $epayslip_id]);
    }

    public function getEpayslipGridData(Request $request) {
        try {
            $username = (isset($request->username)? $request->username: auth()->user()->username);
            $year = $request->year;
            $userinfo = $this->getUserPersonalDetails($username);
            $result = UserEpay::select("user_epay.*", "user_personal.name")
                    ->leftJoin("user_personal", "user_epay.employee_no", "=", "user_personal.employee_no")
                    ->where("user_epay.employee_no", $userinfo->employee_no);
            if($year!=''){
                $result = $result->where("user_epay.epay_year", $year);
            }
            $result = $result->orderBy('user_epay.month');
            return \DataTables::of($result)
                            ->addColumn('select', function ($result) {
                                return '<input onclick="epayslip(' . $result->id . ')" name="epayslip" value="' . $result->id . '" type="radio" class="grid-row-checkbox" data-id="' . $result->id . '">';
                            })
                            ->editColumn('basic_rate', function ($result) {
                                return number_format((float) $result->basic_rate, 2, '.', '');
                            })
                            ->editColumn('basic_pay', function ($result) {
                                return number_format((float) $result->basic_pay, 2, '.', '');
                            })
                            ->editColumn('total_monthly_over_time_pay', function ($result) {
                                return number_format((float) $result->total_monthly_over_time_pay, 2, '.', '');
                            })
                            ->editColumn('total_allowance', function ($result) {
                                return number_format((float) $result->total_allowance, 2, '.', '');
                            })
                            ->editColumn('director_fee', function ($result) {
                                return number_format((float) $result->director_fee, 2, '.', '');
                            })
                            ->editColumn('bonus', function ($result) {
                                return number_format((float) $result->bonus, 2, '.', '');
                            })
                            ->editColumn('commision', function ($result) {
                                return number_format((float) $result->commision, 2, '.', '');
                            })
                            ->editColumn('extra', function ($result) {
                                return number_format((float) $result->extra, 2, '.', '');
                            })
                            ->editColumn('CompensateGratuity', function ($result) {
                                return number_format((float) $result->compensate + $result->gratuity, 2, '.', '');
                            })
                            ->editColumn('GrossPay', function ($result) {
                                return number_format((float) $result->gross_pay + $result->bonus + $result->extra + $result->commision, 2, '.', '');
                            })
                            ->editColumn('total_EPF_employee', function ($result) {
                                return number_format((float) $result->total_EPF_employee, 2, '.', '');
                            })
                            ->editColumn('total_socso_employee', function ($result) {
                                return number_format((float) $result->total_socso_employee, 2, '.', '');
                            })
                            ->editColumn('Eisww', function ($result) {
                                return number_format((float) $result->Eisww, 2, '.', '');
                            })
                            ->editColumn('itaxpcb', function ($result) {
                                return number_format((float) $result->itaxpcb, 2, '.', '');
                            })
                            ->editColumn('other_deduction', function ($result) {
                                return number_format((float) $result->other_deduction, 2, '.', '');
                            })
                            ->editColumn('NetPay', function ($result) {
                                $NetPay = $result->gross_pay + $result->bonus + $result->extra + $result->commision - $result->total_EPF_employee - $result->total_socso_employee - $result->itaxpcb - $result->other_deduction - $result->Eisww;
                                return number_format((float) $NetPay, 2, '.', '');
                            })
                            ->rawColumns(['select', 'month', 'basic_rate', 'basic_pay', 'total_monthly_over_time_pay', 'total_allowance', 'director_fee', 'bonus', 'commision', 'extra', 'CompensateGratuity', 'GrossPay', 'total_EPF_employee', 'total_socso_employee', 'Eisww', 'itaxpcb', 'other_deduction', 'NetPay'])
                            ->make(true);
        } catch (\Exception $ex) {
            $exception = 'Error - ' . $ex->getMessage() . ' (Line - ' . $ex->getLine() . ')';
            return response()->json(['status' => false, 'message' => $exception], 200);
        }
    }
  
    public function getUserPersonalDetails($username)
	{
		$username = urldecode($username);
		$result = DB::table('user_personal as up')->leftjoin('rest_day_category_employee as rdce','rdce.employee_id','=','up.username')->leftjoin('rest_day_category as rdc','rdc.id','=','rdce.category_id')
		->where('up.username',$username)->selectRaw('up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted')->first();
		return $result;
	}	

    //Report Download
    public function epayslipReportDownload(Request $request) {
        
        ini_set('max_execution_time', 180);
        $field_result = AllowanceDeduction::get();
        $username = Auth::user()->username;
        $group_id = '';
        $companyTitle =[];
        $companyTitle11 = Helper::getCompanyInfoByValue('company_details');
        $companyTitle['name'] = $companyTitle11->company_details;
        $user_paydetail = Helper::getUserPayDetails($username);
        $companyTitle['joiningdate'] = $user_paydetail['date_commence'];
        $companyTitle['yearlyentitle'] = getYearlyEntitle($username, date('Y'));
        $res = DB::table('map_employee_permission')->select("permission_group_id")->where("employee_id", $username)->first();
      
        if (!empty($res->permission_group_id)) {
            $group_id = $res->permission_group_id;
        }
        $download_permission = '';
        $ft = DB::table('permission_group')->select("epay_download")->where("id", $group_id)->first();
    
        if ($ft->epay_download) {
            $download_permission = $ft->epay_download;
        }
       
        $field_values = array();
        for ($i = 0; $i < count($field_result); $i++) {
            $field_values[$field_result[$i]['field_name']] = $field_result[$i]['field_value'];
        }
        if ($download_permission == 1) {
            $filename_format = 'payslip-t.pdf';
            $PDF_Templete = 1;
        } else if ($download_permission == 2) {
            $filename_format = 'payslip-w.pdf';
            $PDF_Templete = 2;
        } else if ($download_permission == 3) {
            $filename_format = 'payslip-x.pdf';
            $PDF_Templete = 3;
        }else if ($download_permission == 4) {
            $filename_format = 'payslip-u.pdf';
            $PDF_Templete = 4;
        }else if ($download_permission == 5) {
            $filename_format = 'payslip-v.pdf';
            $PDF_Templete = 5;
        } else {
            $filename_format = 'payslip-t.pdf';
            $PDF_Templete = 1;
        }
        if($request->type){
            $PDF_Templete = 2;
        }

        $result   = Helper::userEPayDetail($request->epay_slip_id);
        $overtime = Helper::overtimeDetail();
        $data = $this->EPaySlipToPdf($filename_format, $result, $field_values, $PDF_Templete, $overtime,$request->type);

        // $months=$data['months'];
        // $slip_month = $data['slip_month'];
        // $name = $data['name'];
        // $slip_year = $data['slip_year'];
        // $details = $data['details'];
        // $time = $data['time'];
        // $field_result = $data['field_result'];
        // $net_pay = $data['net_pay'];
        // $gross_pay = $data['gross_pay'];
      
        // return view('pdf.T_FORMATE',compact('details','time','months','slip_year','name','field_result','net_pay','gross_pay')); 

            //   $months = $data['months'];
            //   $slip_month = $data['slip_month'];
            //   $details = $data['details'];
            //   $name = $data['name'] ;
            //   $slip_year = $data['slip_year'];
            //   $net_pay = $data['net_pay'];

        //return  view('pdf.T_FORMATE',compact('months','slip_year','name','slip_month','details','net_pay'));
        if($request->type){
            $logoimg           = $data['logoimg'];
            $months            = $data['months'];
            $slip_year         = $data['slip_year'];
            $slip_month        = $data['slip_month'];
            $details           = $data['details'];
            $name              = $data['name'];
            $net_pay           = $data['net_pay'];
            $field_result      = $field_values;
            $earning_total     = $data['earning_total'];
           
            return  view('pdf.W_FORMATE',compact('logoimg','months','slip_year','details','name','net_pay','companyTitle','slip_month','field_result','earning_total','overtime'));
        }
    }
  public  function number_to_word( $num = '' )
{
    $num    = ( string ) ( ( int ) $num );
   
    if( ( int ) ( $num ) && ctype_digit( $num ) )
    {
        $words  = array( );
       
        $num    = str_replace( array( ',' , ' ' ) , '' , trim( $num ) );
       
        $list1  = array('','one','two','three','four','five','six','seven',
            'eight','nine','ten','eleven','twelve','thirteen','fourteen',
            'fifteen','sixteen','seventeen','eighteen','nineteen');
       
        $list2  = array('','ten','twenty','thirty','forty','fifty','sixty',
            'seventy','eighty','ninety','hundred');
       
        $list3  = array('','thousand','million','billion','trillion',
            'quadrillion','quintillion','sextillion','septillion',
            'octillion','nonillion','decillion','undecillion',
            'duodecillion','tredecillion','quattuordecillion',
            'quindecillion','sexdecillion','septendecillion',
            'octodecillion','novemdecillion','vigintillion');
       
        $num_length = strlen( $num );
        $levels = ( int ) ( ( $num_length + 2 ) / 3 );
        $max_length = $levels * 3;
        $num    = substr( '00'.$num , -$max_length );
        $num_levels = str_split( $num , 3 );
       
        foreach( $num_levels as $num_part )
        {
            $levels--;
            $hundreds   = ( int ) ( $num_part / 100 );
            $hundreds   = ( $hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ( $hundreds == 1 ? '' : 's' ) . ' ' : '' );
            $tens       = ( int ) ( $num_part % 100 );
            $singles    = '';
           
            if( $tens < 20 ) { $tens = ( $tens ? ' ' . $list1[$tens] . ' ' : '' ); } else { $tens = ( int ) ( $tens / 10 ); $tens = ' ' . $list2[$tens] . ' '; $singles = ( int ) ( $num_part % 10 ); $singles = ' ' . $list1[$singles] . ' '; } $words[] = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_part ) ) ? ' ' . $list3[$levels] . ' ' : '' ); } $commas = count( $words ); if( $commas > 1 )
        {
            $commas = $commas - 1;
        }
       
        $words  = implode( ', ' , $words );
       
        $words  = trim( str_replace( ' ,' , ',' , ucwords( $words ) )  , ', ' );
        if( $commas )
        {
            $words  = str_replace( ',' , ' and' , $words );
        }
       
        return $words;
    }
    else if( ! ( ( int ) $num ) )
    {
        return 'Zero';
    }
    return '';
}


    public function EPaySlipToPdf($filename, $details, $field_result, $PDF_Templete, $overtime,$type=NULL) {
        $res = DB::table('user_personal')->select("username")->where("employee_no", $details['employee_no'])->first();
        $username = '';
        if (!empty($res->username)) {
            $username = $res->username;
        }
        $res = DB::table('settings')->select("value")->where("field", "epayslip_branch_or_company_logo")->first();
        $EplayslipSetting = '';
        if (!empty($res->value)) {
            $EplayslipSetting = $res->value;
        }
        $uploadFolderURL = url('/storage');
        if ($EplayslipSetting == "branch") {
            $branch_detail = DB::table('branch as b')->select("b.*")->leftJoin("user_pay as up", "up.branch_id", "=", "b.id")
                            ->where("up.username", $username)->first();
            $company['company_details'] = $branch_detail->description;
            $getCompanyLogo['company_logo'] = $uploadFolderURL . "/branch/" . $branch_detail->logo;
        } else if ($EplayslipSetting == "category") {
            $category_detail = DB::table('category as b')->select("b.*")->leftJoin("user_pay as up", "up.category_id", "=", "b.id")
                            ->where("up.username", $username)->first();
            $company['company_details'] = $category_detail->description;
            $getCompanyLogo['company_logo'] = $uploadFolderURL . "/companylogo/" . $category_detail->logo;
        } else {
            $company = Helper::getCompanyInfoByValue('company_details');
            $companyLogo = Helper::getCompanyInfoByValue('company_logo');
            $companyLogo = (array) $companyLogo;
            $getCompanyLogo['company_logo'] = $uploadFolderURL . '/settings/companylogo/' . $companyLogo['company_logo'];
        }
        $companyTitle = [];
          $companyTitle11 = Helper::getCompanyInfoByValue('company_details');
            $companyTitle['name'] = $companyTitle11->company_details;
            
            
        $user_paydetail = Helper::getUserPayDetails($username);
        $companyTitle['joiningdate'] = $user_paydetail['date_commence'];
        $companyTitle['yearlyentitle'] = getYearlyEntitle($username, date('Y'));
        
        $user_detail = Helper::getUserPersonalDetails($username);
        $user_govt = Helper::getUserGovernmentDetails($username);
        $user_insurance = Helper::getUserInsuranceDetails($username);
        $user_EPFDetail = Helper::getUserEPFDetails($username);
        $name = Helper::getName($username);

        $company = (array) $company;
        $getCompanyLogo = (array) $getCompanyLogo;
        $user_EPFDetail = (array) $user_EPFDetail;
        $user_insurance = (array) $user_insurance;
        $user_govt = (array) $user_govt;
    // dd($$getCompanyLogo)
        // $data = file_get_contents($getCompanyLogo['company_logo']);
        // $data = file_get_contents('https://www.w3schools.com/howto/img_avatar2.png');
        // $companyLogo =  'data:image/png' .  ';base64,' . base64_encode($data);
        // $imgpath = '<img src="'.$companyLogo.'" />';
        
        $companyLogo = Helper::getCompanyInfoByValue('company_logo');
         $companyLogo = (array) $companyLogo;
         $getCompanyLogo['company_logo'] = $uploadFolderURL . '/settings/companylogo/' . $companyLogo['company_logo'];
        if (File::exists(public_path('storage/settings/companylogo/' . $companyLogo['company_logo']))) {
           // dd(File::exists(public_path('storage/settings/companylogo/' . $companyLogo['company_logo'])));
            $data = file_get_contents($getCompanyLogo['company_logo']);
            $imgpath =  'data:image/png' .  ';base64,' . base64_encode($data);

          }else{
            $imgpath = null;
          }
          
// dd($imgpath);
        $time = date("d-m-Y");
        $slip_month = $details['month'];
        $slip_year = $details['epay_year'];
        $months = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');


        $net_pay = $details['gross_pay'] + $details['bonus'] + $details['extra'] + $details['commision'] - $details['total_EPF_employee'] - $details['total_socso_employee'] - $details['itaxpcb'] - $details['Eisww'] - $details['other_deduction'];
        $companyTitle['net_pay_word'] = $this->number_to_word($net_pay);
        $gross_pay = $details['gross_pay'] + $details['bonus'] + $details['extra'] + $details['commision']+ $details['commision_amount'];

        //$earning_total = $details['basic_pay']+$details['director_fee']+$details['total_monthly_over_time_pay']+$details['total_allowance']+ $details['bonus']+ $details['commision']+ $details['extra']+ $details['compensate']+$details['gratuity']+$details['allowance_1']+$details['allowance_2']+$details['allowance_3']+$details['allowance_4']+$details['allowance_5']+$details['allowance_6']+$details['allowance_7']+$details['allowance_8']+$details['allowance_9']+$details['allowance_10'];
        $earning_total = $details['basic_pay'] + $details['director_fee'] + $details['total_monthly_over_time_pay'] + $details['total_allowance'] + $details['bonus'] + $details['commision'] + $details['extra'] + $details['compensate'] + $details['gratuity'];
        $deduction_total = $details['deduction_1'] + $details['deduction_2'] + $details['deduction_3'] + $details['deduction_4'] + $details['deduction_5'] + $details['deduction_6'] + $details['deduction_7'] + $details['deduction_8'] + $details['deduction_9'] + $details['deduction_10'] + $details['total_EPF_employee'] + $details['total_socso_employee'] + $details['itaxpcb'];

        $categoryid = UserPay::where('username',Auth::user()->username)->first(); 
        $category = Category::find($categoryid->category_id);
        $category_name = $category->name ?? '';
        
        //echo "<pre>";
        //print_r($details)."<br />";exit;
        if ($PDF_Templete == '3') {
            $data12['months']     =  $months;
            $data12['slip_month'] =  $slip_month;
            $data12['name']       = $name ;
            $data12['slip_year']  =  $slip_year;
            $data12['details']    =  $details;
            $data12['net_pay']    = $net_pay;
            $data12['field_result']  = $field_result;
            $data12['gross_pay']  = $gross_pay;
            $logoimg    = $imgpath;
            $time       = $time;
            $category_name = $category_name;
            
            $html = (string)View::make('pdf.X_FORMATE',compact('months','slip_year','slip_month','name','companyTitle','net_pay','details','logoimg','time','field_result','gross_pay','category_name')); 
          
            
        }else if ($PDF_Templete == '5') {
            $data112['months']     =  $months[$slip_month - 1];
            $data112['slip_month'] =  $slip_month;
            $data112['name']       = $name ;
            $data112['slip_year']  =  $slip_year;
            $data112['time']  =  $time;
            $data112['details']    =  $details;
            $data112['time']    = $time;
            $data112['field_result']  = $field_result;
            $data112['net_pay']    = $net_pay;
            $data112['gross_pay']  = $gross_pay;
            $logoimg    = $imgpath;
            $html = (string)View::make('pdf.V_FORMATE',compact('months','slip_year','slip_month','name','companyTitle','net_pay','details','logoimg','time','field_result','gross_pay')); 
        }else if ($PDF_Templete == '1') {
            $data112['months']     =  $months[$slip_month - 1];
            $data112['slip_month'] =  $slip_month;
            $data112['name']       = $name ;
            $data112['slip_year']  =  $slip_year;
            $data112['details']    =  $details;
            $data112['time']    = $time;
            $data112['field_result']    = $field_result;
            $data112['net_pay']    = $net_pay;
            $data112['gross_pay']    = $gross_pay;
            $logoimg    = $imgpath;
            $category_name = $category_name;
            
            $html   = (string)View::make('pdf.T_FORMATE',compact('details','time','months','slip_year','name','companyTitle','field_result','net_pay','gross_pay','logoimg','category_name')); 
 
        }else if($PDF_Templete == '4'){
            $annualutl = DB::table('leave_list')->where('username',$username)->where('status','1')->whereYear('start_date', '=', $slip_year)->where('type','Annual')->whereMonth('start_date', '=', $slip_month)->sum('no_days');
            $medicalutl = DB::table('leave_list')->where('username',$username)->where('status','1')->whereYear('start_date', '=', $slip_year)->where('type','Medical')->whereMonth('start_date', '=', $slip_month)->sum('no_days');
            $data12['months'] =  $months;
            $data12['slip_month'] =  $slip_month;
            $data12['name']      = $name ;
            $data12['slip_year'] =  $slip_year;
            $data12['details'] =  $details;
            $data12['net_pay'] = $net_pay;
            $logoimg =  $imgpath;
            $companyTitle['annualutl'] = $annualutl;
             $companyTitle['medicalutl'] = $medicalutl;
            //dd($logoimg);y
            $html = (string)View::make('pdf.U_FORMATE',compact('months','slip_year','slip_month','name','companyTitle','net_pay','details','logoimg')); 
        } else if ($PDF_Templete == "2") {
            //Ssprintzdesigns One
            //echo $getCompanyLogo['company_logo'];exit;
            $companylogo = ($getCompanyLogo['company_logo'] != '') ? $getCompanyLogo['company_logo'] : '';
            if ($companylogo != '') {
                $logoimg = $imgpath;
            } else {
                $logoimg = '';
            }
                if($type){
                    $data1['logoimg']    = $logoimg;
                    $data1['months']     = $months;
                    $data1['slip_year']  = $slip_year;
                    $data1['slip_month'] = $slip_month;
                    $data1['details']    = $details;
                    $data1['name']       = $name;
                    $data1['net_pay']    = $net_pay;
                    $data1['earning_total'] = $earning_total;
                    return $data1;
                }
               
           
        $html = (string)View::make('pdf.W_FORMATE',compact('logoimg','months','slip_year','details','name','companyTitle','net_pay','slip_month','field_result','earning_total','overtime')); 
        

     //echo $html;exit;
        } else {

            $html = '<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" style="border-top:1px solid #000;border-bottom:1px solid #000;">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="70%">
        	<table width="100%" border="0" cellspacing="0" cellpadding="0">
            	<tr>
                    <td colspan="3" style="font-weight:bold;" align="center">' . $company['company_details'] . '</td>
                </tr>
                <tr>
                    <td width="30%">NAME</td>
                    <td width="5%">:</td>
                    <td width="65%">&nbsp;' . $name . '</td>
                </tr>
                <tr>
                    <td>STAFF NO.</td>
                    <td>:</td>
                    <td>&nbsp;' . $user_detail['employee_no'] . '</td>
                </tr>
                <tr>
                    <td>DEPT</td>
                    <td>:</td>
                    <td>&nbsp;' . $user_paydetail['department'] . '</td>
                </tr>
                <tr>
                    <td>I / C NO. / PASSPORT NO</td>
                    <td>:</td>
                    <td>&nbsp;' . $user_detail['ic_no_new'] . ' / &nbsp;' . $user_paydetail['passport_no'] . '</td>
                </tr>
                <tr>
                    <td width="30%">PAY PERIOD </td>
                    <td width="5%">:</td>
                    <td width="65%">&nbsp;' . $months[$slip_month - 1] . ' - ' . $slip_year . '</td>
                </tr>
            </table>
        	
        </td>
        <td width="30%" align="right">' . $imgpath . '</td>
        
      </tr>
    </table></td>
  </tr>
  <tr>
    <td width="25%" align="center" style="border-right:1px solid #000;">--- EARNING ---</td>
    <td width="22%" align="center" style="border-right:1px solid #000;">--- RM ---</td>
    <td width="28%" align="center" style="border-right:1px solid #000;">--- DEDUCTIONS ---</td>
    <td width="25%" align="center">--- RM ---</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;BASIC PAY</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['basic_pay'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_1'] . '</td>
    <td align="right">' . number_format($details['deduction_1'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;DIRECTOR FEE</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['director_fee'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_2'] . '</td>
    <td align="right">' . number_format($details['deduction_2'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;OVERTIME</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['total_monthly_over_time_pay'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_3'] . '</td>
    <td align="right">' . number_format($details['deduction_3'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;ALLOWANCE</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['total_allowance'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_4'] . '</td>
    <td align="right">' . number_format($details['deduction_4'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;BONUS</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['bonus'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_5'] . '</td>
    <td align="right">' . number_format($details['deduction_5'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;COMMISSION</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['commision'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_6'] . '</td>
    <td align="right">' . number_format($details['deduction_6'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;EXTRA</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format($details['extra'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_7'] . '</td>
    <td align="right">' . number_format($details['deduction_7'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;COMPENSATE</td>
    <td align="right" style="border-right:1px solid #000;">' . number_format(($details['compensate'] + $details['gratuity']), 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_8'] . '</td>
    <td align="right">' . number_format($details['deduction_8'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_1'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_1'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_9'] . '</td>
    <td align="right">' . number_format($details['deduction_9'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_2'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_2'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_10'] . '</td>
    <td align="right">' . number_format($details['deduction_10'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_3'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_3'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_11'] . '</td>
    <td align="right">' . number_format($details['deduction_11'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_4'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_4'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_12'] . '</td>
    <td align="right">' . number_format($details['deduction_12'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_5'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_5'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_13'] . '</td>
    <td align="right">' . number_format($details['deduction_13'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_6'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_6'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_14'] . '</td>
    <td align="right">' . number_format($details['deduction_14'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_7'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_7'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;' . $field_result['deduction_15'] . '</td>
    <td align="right">' . number_format($details['deduction_15'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_8'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_8'], 2) . '&nbsp;&nbsp;</td>
    <td  style="border-right:1px solid #000;">&nbsp;EPF</td>
    <td align="right">' . number_format($details['total_EPF_employee'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_9'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_9'], 2) . '&nbsp;&nbsp;</td>
    <td  style="border-right:1px solid #000;">&nbsp;SOCSO</td>
    <td align="right">' . number_format($details['total_socso_employee'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_10'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_10'], 2) . '&nbsp;&nbsp;</td>
    <td  style="border-right:1px solid #000;">&nbsp;TAX</td>
    <td align="right">' . number_format($details['itaxpcb'], 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_11'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_11'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_12'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_12'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_12'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_12'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_13'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_13'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_14'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_14'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_15'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_15'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_16'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_16'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;' . $field_result['allowance_17'] . '</td>
    <td align="right" style="border-right:1px solid #000;border-left:1px solid #000;">' . number_format($details['allowance_17'], 2) . '&nbsp;&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td align="right" style="border-right:1px solid #000;border-bottom:1px solid #000;">Total &nbsp;</td>
    <td align="right" style="border-right:1px solid #000;border-bottom:1px solid #000;">' . number_format($earning_total, 2) . '&nbsp;&nbsp;</td>
    <td align="right" style="border-right:1px solid #000;border-bottom:1px solid #000;">Total &nbsp;</td>
    <td align="right" style="border-bottom:1px solid #000;">' . number_format($deduction_total, 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td align="right">NET PAY  &nbsp;</td>
    <td style="border-bottom:1px double #000;border-left:1px solid #000;" align="right">&nbsp;' . number_format($net_pay, 2) . '&nbsp;&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td colspan="2" rowspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="15%">&nbsp;EPF :</td>
        <td width="35%">' . $user_EPFDetail['epf_no'] . '</td>
        <td width="15%">TAX :</td>
        <td width="35%">&nbsp;</td>
      </tr>
      <tr>
        <td>&nbsp;SOSCO :</td>
        <td>' . $user_insurance['socso_no'] . '</td>
        <td>BANK :</td>
        <td>' . $user_govt['bank_ac_no'] . '</td>
      </tr>
    </table></td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="border-right:1px solid #000;">&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td colspan="2" style="border-right:1px solid #000;border-top:1px solid #000;border-bottom:1px solid #000;" align="center">CURRENT MONTH</td>
    <td colspan="2" style="border-top:1px solid #000;border-bottom:1px solid #000;" align="center">YEAR-TO-DATE</td>
  </tr>
  <tr>
    <td colspan="2" style="border-right:1px solid #000;border-bottom:1px solid #000;"><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td>&nbsp;</td>
        <td>E.P.F</td>
        <td>SOCSO</td>
        <td>TAX</td>
      </tr>
      <tr>
        <td>Employee :</td>
        <td>' . number_format($details['total_EPF_employee'], 2) . '</td>
        <td>' . number_format($details['total_socso_employee'], 2) . '</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Employer :</td>
        <td>' . number_format($details['total_EPF_employer'], 2) . '</td>
        <td>' . number_format($details['total_socso_employer'], 2) . '</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Total :</td>
        <td>' . number_format(($details['total_EPF_employee'] + $details['total_EPF_employer']), 2) . '</td>
        <td>' . number_format(($details['total_socso_employee'] + $details['total_socso_employer']), 2) . '</td>
        <td>&nbsp;</td>
      </tr>
    </table></td>
    <td colspan="2" style="border-bottom:1px solid #000;"><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td>&nbsp;</td>
        <td>E.P.F</td>
        <td>SOCSO</td>
        <td>TAX</td>
      </tr>
      <tr>
        <td>&nbsp;Employee :</td>
        <td>' . number_format($details['total_EPF_employee'], 2) . '</td>
        <td>' . number_format($details['total_socso_employee'], 2) . '</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>&nbsp;Employer :</td>
        <td>' . number_format($details['total_EPF_employer'], 2) . '</td>
        <td>' . number_format($details['total_socso_employer'], 2) . '</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>&nbsp;Total :</td>
        <td>' . number_format(($details['total_EPF_employee'] + $details['total_EPF_employer']), 2) . '</td>
        <td>' . number_format(($details['total_socso_employee'] + $details['total_socso_employer']), 2) . '</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
      </tr>
    </table></td>
  </tr>
</table>';
        }
    //  return view('pdf.V_FORMATE',compact('months','slip_year','slip_month','name','companyTitle','net_pay','details','logoimg','time','field_result','gross_pay'));
             
        $options = new Options();
        $options->set('defaultFont', 'Helvetica');
        $options->set('dpi', '120');
        $options->set('enable_html5_parser', true);
        $dompdf = new Dompdf($options);
        $dompdf->loadHTML($html);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();
        $dompdf->stream($filename);        
    }

}
