<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Department, Category, Branch, LeaveDay, Leavelist, LeavePast, UserPersonal, UserPay, User, Country, State, Leavetype, LeaveEntitleHistory, EmployeeType, Designation, ClaimRate, LeaveAdjustment, LeaveEntitle, CategoryMaxLeave, HolidayRestDayInleaveSetting, Race, CategoryName, PublicHoliday, Relieve, MapEmployeeApprover, Detail, LeaveAudit};
use Auth, DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Dompdf\Dompdf;
use Carbon\Carbon;
use App\Exports\ReportExport;
use App\Exports\UserInfoReportExport;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Yajra\DataTables\Facades\DataTables;
use App\Mail\MyDemoMail;
use XBase\TableEditor;
use Mail;
use PDFSnappy;

class HrController extends Controller
{
    protected $storageDriver;

    public function __construct()
    {
        $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }

    public function dashboard()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();

        $userPay = UserPay::where('username', $user->username)->first();
        $viewStatus = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->where('a.employee_id', $user->username)->selectRaw('b.view_leave, b.hr_leave_edit')->first();
        $leaveTypes  = Leavetype::where('is_show', 1)->get();
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0)->where('b.pay_status', 1);
        $new = clone $employees11;
        $birthdate = clone $employees11;
        $anniversarydate = clone $employees11;
        $totalemployees = $employees11->count();
        $newemployees = $new->whereYear('b.date_commence', date('Y'))->count();

        $todayleave = Leavelist::where('start_date', date('Y-m-d'))->whereYear('start_date', date('Y'))->where('status', '1')->count();
        $todayleavepercent = ($totalemployees - $todayleave) * 100 / $totalemployees;
        $birthdates = $birthdate->where('user_personal.dob', '!=', '0000-00-00')->get();
        $anniversary = $anniversarydate->where('b.date_commence', '!=', '0000-00-00')->get();
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        // $replacement =getRLeaveList($user->username);
        $yr = '';
        $username = "";
        $replacement  = $this->getSelfRepleacementLeave($username, $yr);

        return view('hr.dashboard', compact('categories', 'departments', 'branches', 'viewStatus', 'userPay', 'leaveTypes', 'totalemployees', 'newemployees', 'todayleavepercent', 'todayleave', 'birthdates', 'anniversary', 'relieveallow', 'halfdayallow', 'replacement'));
    }

    public function getSelfRepleacementLeave($username, $year)
    {
        $user = User::where('id', Auth::id())->first();

        $ActiveUserShownStatus11 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = '';
        if (!empty($ActiveUserShownStatus11)) {
            $ActiveUserShownStatus = $ActiveUserShownStatus11->value ?? 0;
        }
        $currentOnly11 = DB::table('settings')->where('company_id', $user->company_id)->where('field', 'only_current_year_leave_display')->first();
        $currentOnly = '';
        if (!empty($currentOnly11)) {
            $currentOnly = $currentOnly11->value ?? 0;
        }
        $currentUser = $user->username;
        //echo $currentUser;

        $query1 = DB::table('rl_leaves as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->leftjoin('user_pay as c', 'a.employee_id', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('category as f', 'c.category_id', '=', 'f.id')->leftjoin('map_employee_approver as map', 'a.employee_id', '=', 'map.employee_id')->selectRaw("a.id, a.approver_id, a.employee_id, b.employee_no, b.name, d.name as branch, e.name as department, f.name as category, DATE_FORMAT(a.start_date, '%d/%m/%Y') as start_date, a.end_date, a.no_days, sum(a.no_granted) as no_granted,  DATE_FORMAT(a.date_applied, '%d/%m/%Y') as date_applied, a.reason,a.leave_status as `status`");
        if ($currentOnly == '1') {
            $query1->whereRaw("DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE())");
        }
        if ($year != '' && $year != 0) {
            $query1->whereRaw("DATE_FORMAT(a.start_date, '%Y') = '" . $year . "' ");
        }
        if ($ActiveUserShownStatus == '1') {
            $query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        } else {
            $query1->where('c.pay_status', 1);
        }
        // if($username!=""){
        //     $query1->where('a.employee_id',$username);
        // }
        // if($username==''){
        //     $query1->where('map.approver_id',$currentUser);
        // }
        $_q1 = $query1->groupBy('a.id')->get();

        $_q1->map(function ($item) {
            $approvername = DB::table('user_personal')->where('username', $item->approver_id)->first();
            $item->approver_name = $approvername->name ?? '';
        });

        return $_q1;
    }


    public function getemployeegendercomposition(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
            ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
            ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
            ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $categoryId);
        }
        $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);
        if ($ActiveUserShownStatus == 1) {
            $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $employees11->where('b.pay_status', '1');
        }
        $female = clone ($employees11);
        $result['Male'] = $employees11->where('user_personal.sex', 1)->count();
        $result['Female'] = $female->where('user_personal.sex', 0)->count();
        $total = $result['Male'] + $result['Female'];

        if ($total == 0) {
            $result['mpercent'] = 0;
            $result['fpercent'] = 0;
        } else {
            $result['mpercent'] = sprintf("%0.1f", ($result['Male'] * 100) / $total);
            $result['fpercent'] = sprintf("%0.1f", ($result['Female'] * 100) / $total);
        }

        return $result;
    }

    public function getemployeetypecomposition(Request $request)
    {

        $rtype = DB::table('employee_type')->where('is_deleted', 0)->get();
        $rtype->map(function ($item) {
            $user = User::where('id', Auth::id())->first();
            $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
            $employees12 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $categoryId);
            }
            $employees12->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
                ->where('user_personal.username', '!=', null)
                ->where('user_personal.isDeleted', 0);
            if ($ActiveUserShownStatus == 1) {
                $employees12->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees12->where('b.pay_status', '1');
            }
            $totalemployees = $employees12->orderByRaw('user_personal.name+0,user_personal.name')->count();
            $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $categoryId);
            }
            $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
                ->where('user_personal.username', '!=', null);

            $employees11->where('user_personal.employee_type', $item->employee_type);

            $result = $employees11->where('user_personal.isDeleted', 0)->where('b.pay_status', 1)->count();
            if ($result == 0) {
                $item->epercent = 0;
            } else {
                $item->epercent = sprintf("%0.1f", ($result * 100) / $totalemployees);
            }
            $item->emp = $result;
            $item->total = $totalemployees;
            return $item;
        });

        return $rtype;
    }

    public function getemployeeracecomposition(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $race = DB::table('race')->orderBy('race', 'asc')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        $racttl = 0;
        $race->map(function ($item) {
            $user = User::where('id', Auth::id())->first();
            $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
            $employees12 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id')
                ->leftjoin('race as rc', 'rc.race', '=', 'user_personal.race');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $categoryId);
            }
            $employees12->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
                ->where('user_personal.username', '!=', null)
                ->where('user_personal.isDeleted', 0)->where('rc.is_deleted', 0);
            if ($ActiveUserShownStatus == 1) {
                $employees12->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees12->where('b.pay_status', '1');
            }
            $totalemployees = $employees12->where('user_personal.race', '!=', '')->count();
            $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $categoryId);
            }
            $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
                ->where('user_personal.username', '!=', null);
            $employees11->where('user_personal.race', $item->race);
            if ($ActiveUserShownStatus == 1) {
                $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees11->where('b.pay_status', '1');
            }
            $result = $employees11->where('user_personal.isDeleted', 0)->count();
            if ($result == 0) {
                $item->epercent = 0;
            } else {
                $item->epercent = sprintf("%0.1f", ($result * 100) / $totalemployees);
            }
            $item->emp = $result;
            $item->total = $totalemployees;
            return $item;
        });
        //   $race = $race->sortByDesc('epercent');
        //$race['total']=$racttl;
        return $race;
    }

    public function getRestDaygroup(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $rgroup = DB::table('rest_day_category')->get();

        $rgroup->map(function ($item) {
            $user = User::where('id', Auth::id())->first();
            $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
            $employees12 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $categoryId);
            }
            $employees12->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")->where('rdce.category_id', '!=', 0)
                ->where('user_personal.username', '!=', null)
                ->where('user_personal.isDeleted', 0);
            if ($ActiveUserShownStatus == 1) {
                $employees12->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees12->where('b.pay_status', '1');
            }
            $totalemployees = $employees12->orderByRaw('user_personal.name+0,user_personal.name')->count();
            $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $categoryId);
            }
            $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")->where('rdce.category_id', $item->id)
                ->where('user_personal.username', '!=', null);
            if ($ActiveUserShownStatus == 1) {
                $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees11->where('b.pay_status', '1');
            }
            $result = $employees11->where('user_personal.isDeleted', 0)->count();
            if ($result == 0) {
                $item->epercent = 0;
            } else {
                $item->epercent = sprintf("%0.1f", ($result * 100) / $totalemployees);
            }
            $item->emp = $result;
            $item->total = $totalemployees;
            return $item;
        });

        return $rgroup;
    }

    public function getleavecategory(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $leavecatdata = DB::table('category_name')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();

        $leavecatdata->map(function ($item) {
            $user = User::where('id', Auth::id())->first();
            $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
            $employees12 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees12->whereIn('user_personal.username', $categoryId);
            }
            $employees12->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")
                ->where('user_personal.username', '!=', null)
                ->where('user_personal.isDeleted', 0);
            if ($ActiveUserShownStatus == 1) {
                $employees12->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees12->where('b.pay_status', '1');
            }
            $totalemployees = $employees12->orderByRaw('user_personal.name+0,user_personal.name')->count();
            $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
                ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
                ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
                ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
                ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
                ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
                ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
                ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
                ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
            if (request()->get('branch') && request()->get('branch') != '') {
                $branchId = UserPay::where('branch_id', request()->get('branch'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $branchId);
            }
            if (request()->get('department') && request()->get('department') != '') {
                $departmentId = UserPay::where('department_id', request()->get('department'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $departmentId);
            }

            if (request()->get('category') && request()->get('category') != '') {
                $categoryId = UserPay::where('category_id', request()->get('category'))->pluck('username')->toArray();
                $employees11->whereIn('user_personal.username', $categoryId);
            }
            if ($ActiveUserShownStatus == 1) {
                $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            } else {
                $employees11->where('b.pay_status', '1');
            }
            $result = $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")->where('uc.category', $item->id)
                ->where('user_personal.username', '!=', null)
                ->where('user_personal.isDeleted', 0)->count();
            $item->category = $item->name;
            $item->epercent = sprintf("%0.1f", ($result * 100) / $totalemployees);
            $item->emp = $result;
            $item->total = $totalemployees;
            return $item;
        });

        return $leavecatdata;
    }

    public function getmaritalstatus(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
            ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
            ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
            ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $categoryId);
        }
        if ($ActiveUserShownStatus == 1) {
            $employees11->whereRaw("(b.pay_status='1' or b.pay_status='0')");
        } else {
            $employees11->where('b.pay_status', '1');
        }
        $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed ")->whereRaw("(user_personal.marital_status!='' or user_personal.marital_status!=0)")
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);
        $married = clone ($employees11);
        $other = clone ($employees11);
        $result['single'] = $employees11->where('user_personal.marital_status', 'Single')->count();
        $result['married'] = $married->where('user_personal.marital_status', 'Married')->count();
        $result['other'] = $other->where('user_personal.marital_status', 'Other')->count();
        $result['total'] = $result['single'] + $result['married'] + $result['other'];

        $result['spercent'] = sprintf("%0.1f", ($result['single'] * 100) / $result['total']);
        $result['mpercent'] = sprintf("%0.1f", ($result['married'] * 100) / $result['total']);
        $result['opercent'] = sprintf("%0.1f", ($result['other'] * 100) / $result['total']);

        return $result;
    }

    public function getagedistribution(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
            ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
            ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
            ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $categoryId);
        }
        if ($ActiveUserShownStatus == 1) {
            $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $employees11->where('b.pay_status', '1');
        }
        $emp = $employees11->selectRaw("user_personal.dob, user_personal.username")->where('user_personal.dob', '!=', '0000-00-00')
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);
        $less25 = clone $emp;
        $gr25less35 = clone $emp;
        $gr35less45 = clone $emp;
        $gr45less55 = clone $emp;
        $gr55 = clone $emp;
        $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -25 Year "));
        $result['less25'] =  $less25->where('user_personal.dob', '<=', date('Y-m-d'))->where('user_personal.dob', '>', $yearMinusOneDay)->count();

        $yearMinusOneDay11 =  date("Y-m-d", strtotime("now" . " -25 Year "));
        $yearMinusOneDay12 =  date("Y-m-d", strtotime("now" . " -35 Year "));
        $result['gr25less35'] = $gr25less35->where('user_personal.dob', '<=', $yearMinusOneDay11)->where('user_personal.dob', '>', $yearMinusOneDay12)->count();

        $yearMinusOneDay13 =  date("Y-m-d", strtotime("now" . " -35 Year "));
        $yearMinusOneDay14 =  date("Y-m-d", strtotime("now" . " -45 Year "));
        $result['gr35less45'] =  $gr35less45->where('user_personal.dob', '<=', $yearMinusOneDay13)->where('user_personal.dob', '>', $yearMinusOneDay14)->count();

        $yearMinusOneDay15 =  date("Y-m-d", strtotime("now" . " -45 Year "));
        $yearMinusOneDay16 =  date("Y-m-d", strtotime("now" . " -55 Year "));
        $result['gr45less55'] = $gr45less55->where('user_personal.dob', '<=', $yearMinusOneDay15)->where('user_personal.dob', '>', $yearMinusOneDay16)->count();

        $yearMinusOneDay17 =  date("Y-m-d", strtotime("now" . " -55 Year "));
        $result['more55'] = $gr55->where('user_personal.dob', '<=', $yearMinusOneDay17)->where('user_personal.dob', '!=', '0000-00-00')->count();



        $result['total'] = $result['less25'] + $result['gr25less35'] + $result['gr35less45'] + $result['gr45less55'] + $result['more55'];

        $result['l25'] = sprintf("%0.1f", ($result['less25'] * 100) / $result['total']);
        $result['g25l35'] = sprintf("%0.1f", ($result['gr25less35'] * 100) / $result['total']);
        $result['g35l45'] = sprintf("%0.1f", ($result['gr35less45'] * 100) / $result['total']);
        $result['g45l55'] = sprintf("%0.1f", ($result['gr45less55'] * 100) / $result['total']);
        $result['m55'] = sprintf("%0.1f", ($result['more55'] * 100) / $result['total']);

        return $result;
    }


    public function getlengthofservice(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
            ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
            ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
            ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id');
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $employees11->whereIn('user_personal.username', $categoryId);
        }

        if ($ActiveUserShownStatus == 1) {
            $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $employees11->where('b.pay_status', '1');
        }
        $emp = $employees11->selectRaw("b.date_commence")->where('b.date_commence', '!=', '')->where('user_personal.username', '!=', null)->where('user_personal.isDeleted', 0)->get();
        $total = 0;
        $total1 = 0;
        $total2 = 0;
        $total3 = 0;
        $total4 = 0;
        $total5 = 0;

        foreach ($emp as $employees) {
            $today = date_create(date('Y-m-d'));
            $edob = date_create($employees->date_commence);
            $diff = date_diff($edob, $today);

            $years = $diff->format("%y");
            if ($years < 1) {
                $total = $total + 1;
            } elseif ($years >= 1 && $years < 5) {
                $total1 = $total1 + 1;
            } elseif ($years >= 5 && $years < 10) {
                $total2 = $total2 + 1;
            } elseif ($years >= 10 && $years < 15) {
                $total3 = $total3 + 1;
            } elseif ($years >= 15 && $years < 20) {
                $total4 = $total4 + 1;
            } else {
                $total5 = $total5 + 1;
            }
        }
        $result['less1'] = $total;
        $result['gr1less5'] = $total1;
        $result['gr5less10'] = $total2;
        $result['gr10less15'] = $total3;
        $result['gr15less20'] = $total4;
        $result['more20'] = $total5;
        $result['total'] = $result['less1'] + $result['gr1less5'] + $result['gr5less10'] + $result['gr10less15'] + $result['gr15less20'] + $result['more20'];

        $result['l1'] = sprintf("%0.1f", ($result['less1'] * 100) / $result['total']);
        $result['g1l5'] = sprintf("%0.1f", ($result['gr1less5'] * 100) / $result['total']);
        $result['g5l10'] = sprintf("%0.1f", ($result['gr5less10'] * 100) / $result['total']);
        $result['g10l15'] = sprintf("%0.1f", ($result['gr10less15'] * 100) / $result['total']);
        $result['g15l20'] = sprintf("%0.1f", ($result['gr15less20'] * 100) / $result['total']);
        $result['m20'] = sprintf("%0.1f", ($result['more20'] * 100) / $result['total']);

        return $result;
    }

    public function getrbranchforecastdata(Request $request)
    {
        $branches  = Branch::groupBy('name')->orderBy('name', 'asc')->get();
        $branches->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.branch_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.branch_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);
            return $item;
        });
        return $branches;
    }

    public function getrcategoryforecastdata(Request $request)
    {
        session(['rcategory_pdf_data' => $request->getUri()]);
        $category  = Category::groupBy('name')->orderBy('name', 'asc')->get();
        $category->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.category_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.category_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);
            return $item;
        });
        return $category;
    }

    public function getrdeptforecastdata(Request $request)
    {
        session(['rdept_pdf_data' => $request->getUri()]);
        $departments  = Department::groupBy('name')->orderBy('name', 'asc')->get();
        $departments->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.department_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.department_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);

            return $item;
        });

        return $departments;
    }

    // public function getweeklyattendance(Request $request){
    //     $user = User::where('id' , Auth::id())->first();
    //     $employees11 = UserPersonal::leftjoin('user_pay as b','user_personal.username','=','b.username')
    //                     ->leftjoin('branch as c','b.branch_id','=','c.id')
    //                     ->leftjoin('category as d','b.category_id','=','d.id')
    //                     ->leftjoin('department as e','b.department_id','=','e.id')
    //                     ->leftjoin('map_employee_permission as f','user_personal.username','=','f.employee_id')
    //                     ->leftjoin('permission_group as g','f.permission_group_id','=','g.id')
    //                     ->leftjoin('user_category as uc','user_personal.username','=','uc.username')
    //                     ->leftjoin('rest_day_category_employee as rdce','user_personal.username','=','rdce.employee_id')
    //                     ->leftjoin('rest_day_category as rdc','rdce.category_id','=','rdc.id')->leftjoin('users as u','user_personal.username','=','u.username');
    //                     if($request->get('branch') && $request->get('branch') != '')
    //                     {
    //                         $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                         $employees11->whereIn('user_personal.username',$branchId);
    //                     }
    //                     if($request->get('department') && $request->get('department') != '')
    //                     {
    //                         $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                         $employees11->whereIn('user_personal.username',$departmentId);
    //                     }

    //                     if($request->get('category')&& $request->get('category') != '')
    //                     {
    //                         $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                         $employees11->whereIn('user_personal.username',$categoryId);
    //                     }
    //     $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed,b.date_commence,b.date_resigned ,rdce.id as rempcatid ,rdc.id as restdayid , c.state as estate")
    //     ->where('user_personal.username','!=',null)
    //     ->where('user_personal.isDeleted',0)->where('u.company_id',$user->company_id)->where('b.pay_status',1);
    //     $empcln = clone $employees11;
    //     $total = $employees11->count();
    //     $empttl = $empcln->get();
    //     $jan=0; $feb=0; $mar=0; $apr=0; $may=0; $jun=0; $jul=0; $aug=0; $sep=0; $oct=0; $nov=0; $dec=0;
    //     $totaljan=0; $totalfeb=0; $totalmar=0; $totalapr=0; $totalmay=0; $totaljun=0; $totaljul=0; $totalaug=0; $totalsep=0; $totaloct=0; $totalnov=0; $totaldec=0;
    //     foreach($empttl as $empt){
    //         $jan11=Leavelist::whereMonth('start_date','01')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $jan11->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $jan11->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $jan11->whereIn('user_personal.username',$categoryId);
    //             }
    //         $jan=$jan11->count();

    //         $feb1=Leavelist::whereMonth('start_date','02')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $feb1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $feb1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $feb1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $feb=$feb1->count();
    //         //dd($feb);
    //         \Log::info($feb. " ".  $feb1->count());
    //         $mar1=Leavelist::whereMonth('start_date','03')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $mar1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $mar1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $mar1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $mar=$mar1->count();
    //         $apr1=Leavelist::whereMonth('start_date','04')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $apr1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $apr1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $apr1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $apr=$apr1->count();
    //         $may1=Leavelist::whereMonth('start_date','05')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $may1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $may1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $may1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $may=$may1->count();
    //         $jun1=Leavelist::whereMonth('start_date','06')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $jun1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $jun1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $jun1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $jun=$jun1->count();
    //         $jul1=Leavelist::whereMonth('start_date','07')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $jul1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $jul1->whereIn('user_personal.username',$departmentId);
    //             }
    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $jul1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $jul=$jul1->count();

    //         $aug1=Leavelist::whereMonth('start_date','08')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $aug1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $aug1->whereIn('user_personal.username',$departmentId);
    //             }
    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $aug1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $aug=$aug1->count();

    //         $sep1=Leavelist::whereMonth('start_date','09')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $sep1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $sep1->whereIn('user_personal.username',$departmentId);
    //             }
    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $sep1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $sep=$sep1->count();

    //         $oct1=Leavelist::whereMonth('start_date','10')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $oct1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $oct1->whereIn('user_personal.username',$departmentId);
    //             }
    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $oct1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $oct=$oct1->count();

    //         $nov1=Leavelist::whereMonth('start_date','11')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $nov1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $nov1->whereIn('user_personal.username',$departmentId);
    //             }
    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $nov1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $nov=$nov1->count();

    //         $dec1=Leavelist::whereMonth('start_date','12')->whereYear('start_date',date('Y'))->leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username);
    //             if($request->get('branch') && $request->get('branch') != '')
    //             {
    //                 $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                 $dec1->whereIn('user_personal.username',$branchId);
    //             }
    //             if($request->get('department') && $request->get('department') != '')
    //             {
    //                 $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                 $dec1->whereIn('user_personal.username',$departmentId);
    //             }

    //             if($request->get('category')&& $request->get('category') != '')
    //             {
    //                 $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                 $dec1->whereIn('user_personal.username',$categoryId);
    //             }
    //         $dec=$dec1->count();

    //             $janstart=Carbon::parse(date('Y').'-01-01');
    //             $febstart=Carbon::parse(date('Y').'-02-01');
    //             $marstart=Carbon::parse(date('Y').'-03-01');
    //             $aprstart=Carbon::parse(date('Y').'-04-01');
    //             $maystart=Carbon::parse(date('Y').'-05-01');
    //             $junstart=Carbon::parse(date('Y').'-06-01');
    //             $julstart=Carbon::parse(date('Y').'-07-01');
    //             $augstart=Carbon::parse(date('Y').'-08-01');
    //             $sepstart=Carbon::parse(date('Y').'-09-01');
    //             $octstart=Carbon::parse(date('Y').'-10-01');
    //             $novstart=Carbon::parse(date('Y').'-11-01');
    //             $decstart=Carbon::parse(date('Y').'-12-01');
    //             if($empt->date_commence > $janstart){
    //                 $janstart=Carbon::parse($empt->date_commence);
    //                 //dd($janstart);
    //             }
    //             if($empt->date_commence > $febstart){
    //                 $febstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $marstart){
    //                 $marstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $aprstart){
    //                 $aprstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $maystart){
    //                 $maystart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $junstart){
    //                 $junstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $julstart){
    //                 $julstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $augstart){
    //                 $augstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $sepstart){
    //                 $sepstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $octstart){
    //                 $octstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $novstart){
    //                 $novstart=Carbon::parse($empt->date_commence);
    //             }
    //             if($empt->date_commence > $decstart){
    //                 $decstart=Carbon::parse($empt->date_commence);
    //             }

    //             $janend=Carbon::parse(date('Y').'-01-31');
    //             $d=cal_days_in_month(CAL_GREGORIAN,2,date('Y'));
    //             $febend=Carbon::parse(date('Y').'-02-'.$d);
    //             $marend=Carbon::parse(date('Y').'-03-31');
    //             $aprend=Carbon::parse(date('Y').'-04-30');
    //             $mayend=Carbon::parse(date('Y').'-05-31');
    //             $junend=Carbon::parse(date('Y').'-06-30');
    //             $julend=Carbon::parse(date('Y').'-07-31');
    //             $augend=Carbon::parse(date('Y').'-08-31');
    //             $sepend=Carbon::parse(date('Y').'-09-30');
    //             $octend=Carbon::parse(date('Y').'-10-31');
    //             $novend=Carbon::parse(date('Y').'-11-30');
    //             $decend=Carbon::parse(date('Y').'-12-31');
    //             $resigned = false;

    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $janend &&$empt->date_resigned > $janstart){
    //                 $janend=Carbon::parse($empt->date_resigned);
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $febend && $empt->date_resigned > $febstart){
    //                 $febend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $marend && $empt->date_resigned > $marstart){
    //                 $marend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $aprend && $empt->date_resigned > $aprstart){
    //                 $aprend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $mayend && $empt->date_resigned > $maystart){
    //                 $mayend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $junend && $empt->date_resigned > $junstart){
    //                 $junend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $julend && $empt->date_resigned > $julstart){
    //                 $julend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $augend && $empt->date_resigned > $augstart){
    //                 $augend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $sepend && $empt->date_resigned > $sepstart){
    //                 $sepend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $octend && $empt->date_resigned > $octstart){
    //                 $octend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $novend && $empt->date_resigned > $novstart){
    //                 $novend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }
    //             if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $decend && $empt->date_resigned > $decstart){
    //                 $decend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                 $resigned = true;
    //             }

    //             $rjandays=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereBetween('rest_dates.date',[$janstart,$janend])->count();

    //             $janpublicholiday=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereBetween('date',[$janstart,$janend])->count();


    //             $jandays = date_diff(date_create($janstart), date_create($janend));
    //             //$jandays = $diff->format($jandays);
    //             // dd();

    //             $totaljanday=($jandays->d+1)-$rjandays-$janpublicholiday-$jan;
    //             $totaljan1=($totaljanday*100)/($jandays->d+1);
    //             $totaljan=$totaljan+$totaljan1;
    //             //dd($totaljan, $jan, $rjandays, $jandays);


    //             $rfebdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','02');

    //             $febpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','02');

    //             if($febend!='0000-00-00'){
    //                 $rfebdays1->whereBetween('rest_dates.date',[$febstart,$febend]);
    //                 $febpublicholiday1->whereBetween('date',[$febstart,$febend]);
    //             }
    //             $febpublicholiday=$febpublicholiday1->count();
    //             $rfebdays=$rfebdays1->count();

    //             if($febend=='0000-00-00'){

    //                 $totalfeb =0;
    //             }
    //             else{
    //                 $febdays = date_diff(date_create($febstart), date_create($febend));
    //                 $totalfebday=($febdays->d+1)-$rfebdays-$febpublicholiday-$feb;
    //                 $totalfeb1=($totalfebday*100)/($febdays->d+1);
    //                 $totalfeb=$totalfeb+$totalfeb1;
    //             }

    //             $rmardays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','03');

    //             $marpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','03');

    //             if($marend!='0000-00-00'){
    //                 $rmardays1->whereBetween('rest_dates.date',[$marstart,$marend]);
    //                 $marpublicholiday1->whereBetween('date',[$marstart,$marend]);
    //             }
    //             $marpublicholiday=$marpublicholiday1->count();

    //             $rmardays=$rmardays1->count();
    //             if($marend=='0000-00-00'){
    //                 $totalmar =0;
    //             }
    //             else{
    //                 $mardays = date_diff(date_create($marstart), date_create($marend));
    //                 $totalmarday=($mardays->d+1)-$rmardays-$marpublicholiday-$mar;
    //                 $totalmar1=($totalmarday*100)/($mardays->d+1);
    //                 $totalmar=$totalmar+$totalmar1;
    //             }

    //             $raprdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','04');

    //             $aprpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','04');

    //             if($aprend!='0000-00-00'){
    //                 $raprdays1->whereBetween('rest_dates.date',[$aprstart,$aprend]);
    //                 $aprpublicholiday1->whereBetween('date',[$aprstart,$aprend]);
    //             }
    //             $aprpublicholiday=$aprpublicholiday1->count();
    //             $raprdays=$raprdays1->count();
    //             if($aprend=='0000-00-00'){
    //                 $totalapr =0;
    //             }
    //             else{
    //                 $aprdays = date_diff(date_create($aprstart), date_create($aprend));
    //                 $totalaprday=($aprdays->d+1)-$raprdays-$aprpublicholiday-$apr;
    //                 $totalapr1=($totalaprday*100)/($aprdays->d+1);
    //                 $totalapr=$totalapr+$totalapr1;
    //             }

    //             $rmaydays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','05');

    //             $maypublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','05');

    //             if($mayend!='0000-00-00'){
    //                 $rmaydays1->whereBetween('rest_dates.date',[$maystart,$mayend]);
    //                 $maypublicholiday1->whereBetween('date',[$maystart,$mayend]);
    //             }
    //             $maypublicholiday=$maypublicholiday1->count();
    //             $rmaydays=$rmaydays1->count();
    //             if($mayend=='0000-00-00'){
    //                 $totalmay =0;
    //             }
    //             else{
    //                 $maydays = date_diff(date_create($maystart), date_create($mayend));
    //                 $totalmayday=($maydays->d+1)-$rmaydays-$maypublicholiday-$may;
    //                 $totalmay1=($totalmayday*100)/($maydays->d+1);
    //                 $totalmay=$totalmay+$totalmay1;
    //             }

    //             $rjundays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','06');

    //             $junpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','06');

    //             if($junend!='0000-00-00'){
    //                 $rjundays1->whereBetween('rest_dates.date',[$junstart,$junend]);
    //                 $junpublicholiday1->whereBetween('date',[$junstart,$junend]);
    //             }
    //             $junpublicholiday=$junpublicholiday1->count();
    //             $rjundays=$rjundays1->count();
    //             if($junend=='0000-00-00'){
    //                 $totaljun =0;
    //             }
    //             else{
    //                 $jundays = date_diff(date_create($junstart), date_create($junend));
    //                 $totaljunday=($jundays->d+1)-$rjundays-$junpublicholiday-$jun;
    //                 $totaljun1=($totaljunday*100)/($jundays->d+1);
    //                 $totaljun=$totaljun+$totaljun1;
    //             }

    //             $rjuldays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','07');

    //             $julpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','07');

    //             if($julend!='0000-00-00'){
    //                 $rjuldays1->whereBetween('rest_dates.date',[$julstart,$julend]);
    //                 $julpublicholiday1->whereBetween('date',[$julstart,$julend]);
    //             }
    //             $julpublicholiday=$julpublicholiday1->count();
    //             $rjuldays=$rjuldays1->count();
    //             if($julend=='0000-00-00'){
    //                 $totaljul =0;
    //             }
    //             else{
    //                 $juldays = date_diff(date_create($julstart), date_create($julend));
    //                 $totaljulday=($juldays->d+1)-$rjuldays-$julpublicholiday-$jul;
    //                 $totaljul1=($totaljulday*100)/($juldays->d+1);
    //                 $totaljul=$totaljul+$totaljul1;
    //             }
    //           // dd($julstart);
    //             $raugdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','08');

    //             $augpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','08');

    //             if($augend!='0000-00-00'){
    //                 $raugdays1->whereBetween('rest_dates.date',[$augstart,$augend]);
    //                 $augpublicholiday1->whereBetween('date',[$augstart,$augend]);
    //             }
    //             $augpublicholiday=$augpublicholiday1->count();
    //             $raugdays=$raugdays1->count();
    //             if($augend=='0000-00-00'){
    //                 $totalaug =0;
    //             }
    //             else{
    //                 $augdays = date_diff(date_create($augstart), date_create($augend));
    //                 $totalaugday=($augdays->d+1)-$raugdays-$augpublicholiday-$aug;
    //                 $totalaug1=($totalaugday*100)/($augdays->d+1);
    //                 $totalaug=$totalaug+$totalaug1;
    //             }

    //             $rsepdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','09');

    //             $seppublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','09');

    //             if($sepend!='0000-00-00'){
    //                 $rsepdays1->whereBetween('rest_dates.date',[$sepstart,$sepend]);
    //                 $seppublicholiday1->whereBetween('date',[$sepstart,$sepend]);
    //             }
    //             $seppublicholiday=$seppublicholiday1->count();
    //             $rsepdays=$rsepdays1->count();
    //             if($sepend=='0000-00-00'){
    //                 $totalsep =0;
    //             }
    //             else{
    //                 $sepdays = date_diff(date_create($sepstart), date_create($sepend));
    //                 $totalsepday=($sepdays->d+1)-$rsepdays-$seppublicholiday-$sep;
    //                 $totalsep1=($totalsepday*100)/($sepdays->d+1);
    //                 $totalsep=$totalsep+$totalsep1;
    //             }

    //             $roctdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','10');

    //             $octpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','10');

    //             if($octend!='0000-00-00'){
    //                 $roctdays1->whereBetween('rest_dates.date',[$octstart,$octend]);
    //                 $octpublicholiday1->whereBetween('date',[$octstart,$octend]);
    //             }
    //             $octpublicholiday=$octpublicholiday1->count();
    //             $roctdays=$roctdays1->count();
    //             if($octend=='0000-00-00'){
    //                 $totaloct =0;
    //             }
    //             else{
    //                 $octdays = date_diff(date_create($octstart), date_create($octend));
    //                 $totaloctday=($octdays->d+1)-$roctdays-$octpublicholiday-$oct;
    //                 $totaloct1=($totaloctday*100)/($octdays->d+1);
    //                 $totaloct=$totaloct+$totaloct1;
    //             }

    //             $rnovdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','11');

    //             $novpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','11');

    //             if($novend!='0000-00-00'){
    //                 $rnovdays1->whereBetween('rest_dates.date',[$novstart,$novend]);
    //                 $novpublicholiday1->whereBetween('date',[$novstart,$novend]);
    //             }
    //             $novpublicholiday=$novpublicholiday1->count();
    //             $rnovdays=$rnovdays1->count();
    //             if($novend=='0000-00-00'){
    //                 $totalnov =0;
    //             }
    //             else{
    //                 $novdays = date_diff(date_create($novstart), date_create($novend));
    //                 $totalnovday=($novdays->d+1)-$rnovdays-$novpublicholiday-$nov;
    //                 $totalnov1=($totalnovday*100)/($novdays->d+1);
    //                 $totalnov=$totalnov+$totalnov1;
    //             }

    //             $rdecdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','12');

    //             $decpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','11');
    //             if($decend!='0000-00-00'){
    //                 $rdecdays1->whereBetween('rest_dates.date',[$decstart,$decend]);
    //                 $decpublicholiday1->whereBetween('date',[$decstart,$decend]);
    //             }
    //             $decpublicholiday=$decpublicholiday1->count();
    //             $rdecdays=$rdecdays1->count();
    //             if($decend=='0000-00-00'){
    //                 $totaldec =0;
    //             }
    //             else{
    //                 $decdays = date_diff(date_create($decstart), date_create($decend));
    //                 $totaldecday=($decdays->d+1)-$rdecdays-$decpublicholiday-$dec;
    //                 $totaldec1=($totaldecday*100)/($decdays->d+1);
    //                 $totaldec=$totaldec+$totaldec1;
    //             }



    //     }

    //     $result['jan'] = sprintf("%0.1f", ($totaljan)/$total);
    //     $result['feb'] = sprintf("%0.1f",($totalfeb) / $total);
    //     $result['mar'] = sprintf("%0.1f",($totalmar) / $total);
    //     $result['apr'] = sprintf("%0.1f",($totalapr) / $total);
    //     $result['may'] = sprintf("%0.1f",($totalmay) / $total);
    //     $result['jun'] = sprintf("%0.1f",($totaljun) / $total);
    //     $result['jul'] = sprintf("%0.1f",($totaljul) / $total);
    //     $result['aug'] = sprintf("%0.1f",($totalaug) / $total);
    //     $result['sep'] = sprintf("%0.1f",($totalsep) / $total);
    //     $result['oct'] = sprintf("%0.1f",($totaloct) / $total);
    //     $result['nov'] = sprintf("%0.1f",($totalnov) / $total);
    //     $result['dec'] = sprintf("%0.1f",($totaldec) / $total);


    //     return $result;
    // }

    //      public function getweeklyattendance(Request $request){
    //         $user = User::where('id' , Auth::id())->first();
    //         $employees11 = UserPersonal::leftjoin('user_pay as b','user_personal.username','=','b.username')
    //                         ->leftjoin('branch as c','b.branch_id','=','c.id')
    //                         ->leftjoin('category as d','b.category_id','=','d.id')
    //                         ->leftjoin('department as e','b.department_id','=','e.id')
    //                         ->leftjoin('map_employee_permission as f','user_personal.username','=','f.employee_id')
    //                         ->leftjoin('permission_group as g','f.permission_group_id','=','g.id')
    //                         ->leftjoin('user_category as uc','user_personal.username','=','uc.username')
    //                         ->leftjoin('rest_day_category_employee as rdce','user_personal.username','=','rdce.employee_id')
    //                         ->leftjoin('rest_day_category as rdc','rdce.category_id','=','rdc.id')->leftjoin('users as u','user_personal.username','=','u.username');
    //                         if($request->get('branch') && $request->get('branch') != '')
    //                         {
    //                             $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
    //                             $employees11->whereIn('user_personal.username',$branchId);
    //                         }
    //                         if($request->get('department') && $request->get('department') != '')
    //                         {
    //                             $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
    //                             $employees11->whereIn('user_personal.username',$departmentId);
    //                         }

    //                         if($request->get('category')&& $request->get('category') != '')
    //                         {
    //                             $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
    //                             $employees11->whereIn('user_personal.username',$categoryId);
    //                         }
    //         $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, b.date_confirmed as date_confirmed,b.date_commence,b.date_resigned ,rdce.id as rempcatid ,rdc.id as restdayid , c.state as estate")
    //         ->where('user_personal.username','!=',null)
    //         ->where('user_personal.isDeleted',0)->where('u.company_id',$user->company_id);
    //         $empcln = clone $employees11;
    //         $total = $employees11->count();
    //         $empttl = $empcln->get();
    //         $jan=0; $feb=0; $mar=0; $apr=0; $may=0; $jun=0; $jul=0; $aug=0; $sep=0; $oct=0; $nov=0; $dec=0;
    //         $totaljan=0; $totalfeb=0; $totalmar=0; $totalapr=0; $totalmay=0; $totaljun=0; $totaljul=0; $totalaug=0; $totalsep=0; $totaloct=0; $totalnov=0; $totaldec=0; $rjandays11=0; $rfebdays11=0; $rmardays11=0; $raprdays11=0; $rmaydays11=0; $rjundays11=0; $rjuldays11=0; $raugdays11=0; $rsepdays11=0; $roctdays11=0; $rnovdays11=0;  $rdecdays11=0;
    //         foreach($empttl as $empt){

    //             $janstart=Carbon::parse(date('Y').'-01-01');
    //                 $febstart=Carbon::parse(date('Y').'-02-01');
    //                 $marstart=Carbon::parse(date('Y').'-03-01');
    //                 $aprstart=Carbon::parse(date('Y').'-04-01');
    //                 $maystart=Carbon::parse(date('Y').'-05-01');
    //                 $junstart=Carbon::parse(date('Y').'-06-01');
    //                 $julstart=Carbon::parse(date('Y').'-07-01');
    //                 $augstart=Carbon::parse(date('Y').'-08-01');
    //                 $sepstart=Carbon::parse(date('Y').'-09-01');
    //                 $octstart=Carbon::parse(date('Y').'-10-01');
    //                 $novstart=Carbon::parse(date('Y').'-11-01');
    //                 $decstart=Carbon::parse(date('Y').'-12-01');

    //                 $janend=Carbon::parse(date('Y').'-01-31');
    //                 $d=cal_days_in_month(CAL_GREGORIAN,2,date('Y'));
    //                 $febend=Carbon::parse(date('Y').'-02-'.$d);
    //                 $marend=Carbon::parse(date('Y').'-03-31');
    //                 $aprend=Carbon::parse(date('Y').'-04-30');
    //                 $mayend=Carbon::parse(date('Y').'-05-31');
    //                 $junend=Carbon::parse(date('Y').'-06-30');
    //                 $julend=Carbon::parse(date('Y').'-07-31');
    //                 $augend=Carbon::parse(date('Y').'-08-31');
    //                 $sepend=Carbon::parse(date('Y').'-09-30');
    //                 $octend=Carbon::parse(date('Y').'-10-31');
    //                 $novend=Carbon::parse(date('Y').'-11-30');
    //                 $decend=Carbon::parse(date('Y').'-12-31');

    //                 if($empt->date_commence > $janstart && $empt->date_commence < $janend){
    //                     $janstart=Carbon::parse($empt->date_commence);
    //                     //dd($janstart);
    //                 }
    //                 if($empt->date_commence > $febstart && $empt->date_commence < $febend){
    //                     $febstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $marstart && $empt->date_commence < $marend){
    //                     $marstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $aprstart && $empt->date_commence < $aprend){
    //                     $aprstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $maystart && $empt->date_commence < $mayend){
    //                     $maystart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $junstart && $empt->date_commence < $junend){
    //                     $junstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $julstart && $empt->date_commence < $julend){
    //                     $julstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $augstart && $empt->date_commence < $augend){
    //                     $augstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $sepstart && $empt->date_commence < $sepend){
    //                     $sepstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $octstart && $empt->date_commence < $octend){
    //                     $octstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $novstart && $empt->date_commence < $novend){
    //                     $novstart=Carbon::parse($empt->date_commence);
    //                 }
    //                 if($empt->date_commence > $decstart && $empt->date_commence < $decend){
    //                     $decstart=Carbon::parse($empt->date_commence);
    //                 }


    //                 $resigned = false;

    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $janend && $empt->date_resigned > $janstart){
    //                     $janend=Carbon::parse($empt->date_resigned);
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $febend && $empt->date_resigned > $febstart){
    //                     $febend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $marend && $empt->date_resigned > $marstart){
    //                     $marend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $aprend && $empt->date_resigned > $aprstart){
    //                     $aprend= !$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $mayend && $empt->date_resigned > $maystart){
    //                     $mayend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $junend && $empt->date_resigned > $junstart){
    //                     $junend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $julend && $empt->date_resigned > $julstart){
    //                     $julend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $augend && $empt->date_resigned > $augstart){
    //                     $augend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $sepend && $empt->date_resigned > $sepstart){
    //                     $sepend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $octend && $empt->date_resigned > $octstart){
    //                     $octend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $novend && $empt->date_resigned > $novstart){
    //                     $novend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }
    //                 if($empt->date_resigned!='0000-00-00' && $empt->date_resigned < $decend && $empt->date_resigned > $decstart){
    //                     $decend=!$resigned ? Carbon::parse($empt->date_resigned) : '0000-00-00';
    //                     $resigned = true;
    //                 }

    //             $jan11=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$janstart,$janend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $jan11->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $jan11->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $jan11->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $jan12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$janstart,$janend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $jan12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $jan12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $jan12->where('user_pay.category_id',$request->get('category'));
    //                 }
    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $jandata=0;
    //                     }
    //                     else{
    //                         $jandata=$jan11->sum('leave_list.no_days')+$jan12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $jandata=$jan11->sum('leave_list.no_days')+$jan12->sum('leave_past.total_leave_days');
    //                 }

    //             $jan=$jan+$jandata;


    //             $feb1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$febstart,$febend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $feb1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $feb1->where('user_pay.department_id',$request->get('departmment'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $feb1->where('user_pay.category_id',$request->get('category'));
    //                 }
    //             $feb12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$febstart,$febend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $feb12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $feb12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $feb12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $febdata=0;
    //                     }
    //                     else{
    //                         $febdata=$feb1->sum('leave_list.no_days')+$feb12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $febdata=$feb1->sum('leave_list.no_days')+$feb12->sum('leave_past.total_leave_days');
    //                 }
    //             $feb= $feb+$febdata;

    //             $mar1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$marstart,$marend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $mar1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $mar1->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $mar1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $mar12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$marstart,$marend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $mar12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $mar12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $mar12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $mardata=0;
    //                     }
    //                     else{
    //                         $mardata=$mar1->sum('leave_list.no_days')+$mar12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $mardata=$mar1->sum('leave_list.no_days')+$mar12->sum('leave_past.total_leave_days');
    //                 }
    //             $mar=$mar+$mardata;
    //             $apr1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$aprstart,$aprend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $apr1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $apr1->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $apr1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $apr12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$aprstart,$aprend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $apr12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $apr12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $apr12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $aprdata=0;
    //                     }
    //                     else{
    //                         $aprdata=$apr1->sum('leave_list.no_days')+$apr12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $aprdata=$apr1->sum('leave_list.no_days')+$apr12->sum('leave_past.total_leave_days');
    //                 }
    //             $apr=$apr+$aprdata;
    //             $may1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$maystart,$mayend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $may1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $may1->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $may1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $may12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$maystart,$mayend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $may12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $may12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $may12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $maydata=0;
    //                     }
    //                     else{
    //                         $maydata=$may1->sum('leave_list.no_days')+$may12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $maydata=$may1->sum('leave_list.no_days')+$may12->sum('leave_past.total_leave_days');
    //                 }
    //             $may=$may+$maydata;
    //             $jun1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$junstart,$junend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $jun1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $jun1->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $jun1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $jun12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$junstart,$junend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $jun12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $jun12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $jun12->where('user_pay.category_id',$request->get('category'));
    //                 }
    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $jundata=0;
    //                     }
    //                     else{
    //                         $jundata=$jun1->sum('leave_list.no_days')+$jun12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $jundata=$jun1->sum('leave_list.no_days')+$jun12->sum('leave_past.total_leave_days');
    //                 }
    //             $jun=$jun+$jundata;

    //             $jul1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$julstart,$julend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $jul1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $jul1->where('user_pay.department_id',$request->get('deparment'));
    //                 }
    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $jul1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $jul12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$julstart,$julend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $jul12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $jul12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $jul12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $juldata=0;
    //                     }
    //                     else{
    //                         $juldata=$jul1->sum('leave_list.no_days')+$jul12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $juldata=$jul1->sum('leave_list.no_days')+$jul12->sum('leave_past.total_leave_days');
    //                 }
    //             $jul=$jul+$juldata;

    //             $aug1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$augstart,$augend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $aug1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $aug1->where('user_pay.department_id',$request->get('department'));
    //                 }
    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $aug1->where('user_pay.category_id',$request->get('category'));
    //                 }
    //             $aug12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$augstart,$augend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $aug12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $aug12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $aug12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $augdata=0;
    //                     }
    //                     else{
    //                         $augdata=$aug1->sum('leave_list.no_days')+$aug12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $augdata=$aug1->sum('leave_list.no_days')+$aug12->sum('leave_past.total_leave_days');
    //                 }
    //             $aug=$aug+$augdata;

    //             $sep1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$sepstart,$sepend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $sep1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $sep1->where('user_pay.department_id',$request->get('department'));
    //                 }
    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $sep1->where('user_pay.category_id',$request->get('category'));
    //                 }
    //             $sep12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$sepstart,$sepend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $sep12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $sep12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $sep12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $sepdata=0;
    //                     }
    //                     else{
    //                         $sepdata=$sep1->sum('leave_list.no_days')+$sep12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $sepdata=$sep1->sum('leave_list.no_days')+$sep12->sum('leave_past.total_leave_days');
    //                 }
    //             $sep=$sep+$sepdata;

    //             $oct1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$octstart,$octend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $oct1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $oct1->where('user_pay.department_id',$request->get('department'));
    //                 }
    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $oct1->where('user_pay.category_id',$request->get('category'));
    //                 }
    //             $oct12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$octstart,$octend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $oct12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $oct12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $oct12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){

    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         //dd($empt->username);
    //                         $octdata=0;
    //                     }
    //                     else{
    //                         // if($empt->username=='P002'){
    //                         //     dd(date('Y',strtotime($empt->date_resigned)),date('Y'));
    //                         // }
    //                         $octdata=$oct1->sum('leave_list.no_days')+$oct12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $octdata=$oct1->sum('leave_list.no_days')+$oct12->sum('leave_past.total_leave_days');
    //                 }
    //             $oct=$oct+$octdata;

    //             $nov1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$novstart,$novend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $nov1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $nov1->where('user_pay.department_id',$request->get('department'));
    //                 }
    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                   $nov1->where('user_pay.category_id',$request->get('category'));
    //                 }

    //             $nov12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$novstart,$novend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $nov12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $nov12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $nov12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $novdata=0;
    //                     }
    //                     else{
    //                         $novdata=$nov1->sum('leave_list.no_days')+$nov12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $novdata=$nov1->sum('leave_list.no_days')+$nov12->sum('leave_past.total_leave_days');
    //                 }
    //             $nov=$nov+$novdata;

    //             $dec1=Leavelist::leftjoin('user_personal','leave_list.username','=','user_personal.username')->leftjoin('user_pay','leave_list.username','=','user_pay.username')->where('leave_list.status','1')->where('leave_list.username',$empt->username)->whereBetween('leave_list.start_date',[$decstart,$decend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {
    //                     $dec1->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {
    //                     $dec1->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {
    //                     $dec1->where('user_pay.category_id',$request->get('category'));
    //                 }
    //             $dec12=DB::table('leave_past')->leftjoin('user_personal','leave_past.username','=','user_personal.username')->leftjoin('user_pay','leave_past.username','=','user_pay.username')->where('leave_past.status','1')->where('leave_past.username',$empt->username)->whereBetween('leave_past.start_date',[$decstart,$decend]);
    //                 if($request->get('branch') && $request->get('branch') != '')
    //                 {

    //                     $dec12->where('user_pay.branch_id',$request->get('branch'));
    //                 }
    //                 if($request->get('department') && $request->get('department') != '')
    //                 {

    //                     $dec12->where('user_pay.department_id',$request->get('department'));
    //                 }

    //                 if($request->get('category')&& $request->get('category') != '')
    //                 {

    //                     $dec12->where('user_pay.category_id',$request->get('category'));
    //                 }

    //                 if($empt->date_resigned!='0000-00-00'){
    //                     if(date('Y',strtotime($empt->date_resigned)) < date('Y'))
    //                     {
    //                         $decdata=0;
    //                     }
    //                     else{
    //                         $decdata=$dec1->sum('leave_list.no_days')+$dec12->sum('leave_past.total_leave_days');
    //                     }

    //                 }
    //                 else{
    //                     $decdata=$dec1->sum('leave_list.no_days')+$dec12->sum('leave_past.total_leave_days');
    //                 }

    //             $dec=$dec+$decdata;



    //                 $rjandays=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereBetween('rest_dates.date',[$janstart,$janend])->count();

    //                 $janpublicholiday=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereBetween('date',[$janstart,$janend])->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $janpublicholiday=count($janpublicholiday);


    //                 $jandays = date_diff(date_create($janstart), date_create($janend));
    //                 //$jandays = $diff->format($jandays);
    //                 // dd();

    //                 $totaljanday=($jandays->d+1)-$rjandays-$janpublicholiday-$jan;
    //                 $totaljan1=($totaljanday*100)/($jandays->d+1);
    //                 $totaljan=$totaljan+$totaljan1;
    //                 //dd($totaljan, $jan, $rjandays, $jandays);
    //                 // if($empt->active==0){
    //                 //         $totaljanday12=0;
    //                 // }
    //                 if($empt->date_resigned < $janstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $janend){
    //                     $totaljanday12=0;
    //                   // dd($totalmarday12);
    //                 }
    //                 else{
    //                     $totaljanday12=($jandays->d+1)-$rjandays-$janpublicholiday;
    //                 }
    //                 //$totaljanday12=($jandays->d+1)-$rjandays-$janpublicholiday;
    //                 $rjandays11=$rjandays11+$totaljanday12;


    //                 $rfebdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','02');

    //                 $febpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','02');

    //                 if($febend!='0000-00-00'){
    //                     $rfebdays1->whereBetween('rest_dates.date',[$febstart,$febend]);
    //                     $febpublicholiday1->whereBetween('date',[$febstart,$febend]);
    //                 }
    //                 $febpublicholiday=$febpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $febpublicholiday=count($febpublicholiday);
    //                 $rfebdays=$rfebdays1->count();

    //                 if($febend=='0000-00-00'){

    //                     $totalfeb =0;
    //                     $totalfebday12=0;
    //                 }
    //                 else{
    //                     $febdays = date_diff(date_create($febstart), date_create($febend));
    //                     $totalfebday=($febdays->d+1)-$rfebdays-$febpublicholiday-$feb;
    //                     $totalfeb1=($totalfebday*100)/($febdays->d+1);
    //                     $totalfeb=$totalfeb+$totalfeb1;
    //                     // if($empt->active==0){
    //                     //     $totalfebday12=0;
    //                     // }
    //                     if($empt->date_resigned < $febstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $febend){
    //                         $totalfebday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalfebday12=($febdays->d+1)-$rfebdays-$febpublicholiday;
    //                     }
    //                     //$totalfebday12=($febdays->d+1)-$rfebdays-$febpublicholiday;
    //                 }

    //                 $rfebdays11=$rfebdays11+$totalfebday12;

    //                 $rmardays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','03');

    //                 $marpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','03');

    //                 if($marend!='0000-00-00'){
    //                     $rmardays1->whereBetween('rest_dates.date',[$marstart,$marend]);
    //                     $marpublicholiday1->whereBetween('date',[$marstart,$marend]);
    //                 }
    //                 $marpublicholiday=$marpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $marpublicholiday=count($marpublicholiday);

    //                 $rmardays=$rmardays1->count();

    //                 if($marend=='0000-00-00'){
    //                     $totalmar =0;
    //                     $totalmarday12=0;
    //                 }
    //                 else{

    //                     $mardays = date_diff(date_create($marstart), date_create($marend));
    //                     $totalmarday=($mardays->d+1)-$rmardays-$marpublicholiday-$mar;
    //                     $totalmar1=($totalmarday*100)/($mardays->d+1);
    //                     // if($empt->active==0){
    //                     //     $totalmarday12=0;
    //                     // }
    //                     if($empt->date_resigned < $marstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $marend ){
    //                         $totalmarday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalmarday12=($mardays->d+1)-$rmardays-$marpublicholiday;
    //                     }


    //                     $totalmar=$totalmar+$totalmar1;
    //                 }

    //                 $rmardays11=$rmardays11+$totalmarday12;

    //                 $raprdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','04');

    //                 $aprpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','04');

    //                 if($aprend!='0000-00-00'){
    //                     $raprdays1->whereBetween('rest_dates.date',[$aprstart,$aprend]);
    //                     $aprpublicholiday1->whereBetween('date',[$aprstart,$aprend]);
    //                 }
    //                 $aprpublicholiday=$aprpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $aprpublicholiday=count($aprpublicholiday);
    //                 $raprdays=$raprdays1->count();
    //                 if($aprend=='0000-00-00'){
    //                     $totalapr =0;
    //                     $totalaprday12=0;
    //                 }
    //                 else{
    //                     $aprdays = date_diff(date_create($aprstart), date_create($aprend));
    //                     $totalaprday=($aprdays->d+1)-$raprdays-$aprpublicholiday-$apr;
    //                     $totalapr1=($totalaprday*100)/($aprdays->d+1);
    //                     $totalapr=$totalapr+$totalapr1;
    //                     // if($empt->active==0){
    //                     //     $totalaprday12=0;
    //                     // }
    //                     if($empt->date_resigned < $aprstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $aprend){
    //                         $totalaprday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalaprday12=($aprdays->d+1)-$raprdays-$aprpublicholiday;
    //                     }
    //                     //$totalaprday12=($aprdays->d+1)-$raprdays-$aprpublicholiday;
    //                 }
    //                 $raprdays11=$raprdays11+$totalaprday12;

    //                 $rmaydays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','05');

    //                 $maypublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','05');

    //                 if($mayend!='0000-00-00'){
    //                     $rmaydays1->whereBetween('rest_dates.date',[$maystart,$mayend]);
    //                     $maypublicholiday1->whereBetween('date',[$maystart,$mayend]);
    //                 }
    //                 $maypublicholiday=$maypublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $maypublicholiday=count($maypublicholiday);
    //                 $rmaydays=$rmaydays1->count();
    //                 if($mayend=='0000-00-00'){
    //                     $totalmay =0;
    //                     $totalmayday12=0;
    //                 }
    //                 else{
    //                     $maydays = date_diff(date_create($maystart), date_create($mayend));
    //                     $totalmayday=($maydays->d+1)-$rmaydays-$maypublicholiday-$may;
    //                     $totalmay1=($totalmayday*100)/($maydays->d+1);
    //                     $totalmay=$totalmay+$totalmay1;
    //                     // if($empt->active==0){
    //                     //     $totalmayday12=0;
    //                     // }
    //                     if($empt->date_resigned < $maystart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $mayend){
    //                         $totalmayday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalmayday12=($maydays->d+1)-$rmaydays-$maypublicholiday;
    //                     }
    //                     //$totalmayday12=($maydays->d+1)-$rmaydays-$maypublicholiday;
    //                 }
    //                 $rmaydays11=$rmaydays11+$totalmayday12;

    //                 $rjundays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','06');

    //                 $junpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','06');

    //                 if($junend!='0000-00-00'){
    //                     $rjundays1->whereBetween('rest_dates.date',[$junstart,$junend]);
    //                     $junpublicholiday1->whereBetween('date',[$junstart,$junend]);
    //                 }
    //                 $junpublicholiday=$junpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $junpublicholiday=count($junpublicholiday);
    //                 $rjundays=$rjundays1->count();
    //                 if($junend=='0000-00-00'){
    //                     $totaljun =0;
    //                     $totaljunday12=0;
    //                 }
    //                 else{
    //                     $jundays = date_diff(date_create($junstart), date_create($junend));
    //                     $totaljunday=($jundays->d+1)-$rjundays-$junpublicholiday-$jun;
    //                     $totaljun1=($totaljunday*100)/($jundays->d+1);
    //                     $totaljun=$totaljun+$totaljun1;
    //                     //$totaljunday12=($jundays->d+1)-$rjundays-$junpublicholiday;

    //                     // if($empt->active==0){
    //                     //     $totaljunday12=0;
    //                     // }
    //                     if($empt->date_resigned < $junstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $junend){
    //                         $totaljunday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totaljunday12=($jundays->d+1)-$rjundays-$junpublicholiday;
    //                     }
    //                 }
    //                 $rjundays11=$rjundays11+$totaljunday12;
    // //                          if($empt->restdayid=='99'){
    // //     echo $empt->username.'('.$empt->date_commence.')('.$empt->date_resigned.')('.$totalmarday12.')('.$rmardays.')('.$marpublicholiday.')<br>';
    // // } 
    //               $rjuldays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','07');

    //                 $julpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','07');

    //                 if($julend!='0000-00-00'){
    //                     $rjuldays1->whereBetween('rest_dates.date',[$julstart,$julend]);
    //                     $julpublicholiday1->whereBetween('date',[$julstart,$julend]);
    //                 }
    //                 $julpublicholiday=$julpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $julpublicholiday=count($julpublicholiday);
    //                 $rjuldays=$rjuldays1->count();
    //                 if($julend=='0000-00-00'){
    //                     $totaljul =0;
    //                     $totaljulday12=0;
    //                 }
    //                 else{
    //                     $juldays = date_diff(date_create($julstart), date_create($julend));
    //                     $totaljulday=($juldays->d+1)-$rjuldays-$julpublicholiday-$jul;
    //                     $totaljul1=($totaljulday*100)/($juldays->d+1);
    //                     $totaljul=$totaljul+$totaljul1;

    //                     // if($empt->active==0){
    //                     //   // dd('hello');
    //                     //     $totaljulday12=0;
    //                     // }
    //                     if($empt->date_resigned < $julstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $julend ){
    //                         $totaljulday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totaljulday12=($juldays->d+1)-$rjuldays-$julpublicholiday;
    //                     }
    //                   // $totaljulday12=($juldays->d+1)-$rjuldays-$julpublicholiday;
    //                 }
    //                 $rjuldays11=$rjuldays11+$totaljulday12;
    // // if($empt->restdayid=='133'){
    // //     echo $empt->username.'('.$totaljulday12.')<br>';
    // // }
    //               // dd($julstart);
    //                 $raugdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','08');

    //                 $augpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','08');

    //                 if($augend!='0000-00-00'){
    //                     $raugdays1->whereBetween('rest_dates.date',[$augstart,$augend]);
    //                     $augpublicholiday1->whereBetween('date',[$augstart,$augend]);
    //                 }
    //                 $augpublicholiday=$augpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $augpublicholiday=count($augpublicholiday);
    //                 $raugdays=$raugdays1->count();
    //                 if($augend=='0000-00-00'){
    //                     $totalaug =0;
    //                     $totalaugday12=0;
    //                 }
    //                 else{
    //                     $augdays = date_diff(date_create($augstart), date_create($augend));
    //                     $totalaugday=($augdays->d+1)-$raugdays-$augpublicholiday-$aug;
    //                     $totalaug1=($totalaugday*100)/($augdays->d+1);
    //                     $totalaug=$totalaug+$totalaug1;

    //                     // if($empt->active==0){
    //                     //     $totalaugday12=0;
    //                     // }
    //                     if($empt->date_resigned < $augstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $augend){
    //                         $totalaugday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalaugday12=($augdays->d+1)-$raugdays-$augpublicholiday;
    //                     }
    //                     //$totalaugday12=($augdays->d+1)-$raugdays-$augpublicholiday;
    //                 }
    //                 $raugdays11=$raugdays11+$totalaugday12;

    //                 $rsepdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','09');

    //                 $seppublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','09');

    //                 if($sepend!='0000-00-00'){
    //                     $rsepdays1->whereBetween('rest_dates.date',[$sepstart,$sepend]);
    //                     $seppublicholiday1->whereBetween('date',[$sepstart,$sepend]);
    //                 }
    //                 $seppublicholiday=$seppublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $seppublicholiday=count($seppublicholiday);
    //                 $rsepdays=$rsepdays1->count();
    //                 if($sepend=='0000-00-00'){
    //                     $totalsep =0;
    //                     $totalsepday12=0;
    //                 }
    //                 else{
    //                     $sepdays = date_diff(date_create($sepstart), date_create($sepend));
    //                     $totalsepday=($sepdays->d+1)-$rsepdays-$seppublicholiday-$sep;
    //                     $totalsep1=($totalsepday*100)/($sepdays->d+1);
    //                     $totalsep=$totalsep+$totalsep1;

    //                     // if($empt->active==0){
    //                     //     $totalsepday12=0;
    //                     // }
    //                     if($empt->date_resigned < $sepstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $sepend){
    //                         $totalsepday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalsepday12=($sepdays->d+1)-$rsepdays-$seppublicholiday;
    //                     }
    //                   // $totalsepday12=($sepdays->d+1)-$rsepdays-$seppublicholiday;
    //                 }
    //                 $rsepdays11=$rsepdays11+$totalsepday12;

    //                 $roctdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','10');

    //                 $octpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','10');

    //                 if($octend!='0000-00-00'){
    //                     $roctdays1->whereBetween('rest_dates.date',[$octstart,$octend]);
    //                     $octpublicholiday1->whereBetween('date',[$octstart,$octend]);
    //                 }

    //                 $octpublicholiday=$octpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $octpublicholiday=count($octpublicholiday);

    //                 $roctdays=$roctdays1->count();
    //                 if($octend=='0000-00-00'){
    //                     $totaloct =0;
    //                     $totaloctday12=0;
    //                 }
    //                 else{
    //                     $octdays = date_diff(date_create($octstart), date_create($octend));
    //                     $totaloctday=($octdays->d+1)-$roctdays-$octpublicholiday-$oct;
    //                     $totaloct1=($totaloctday*100)/($octdays->d+1);
    //                     $totaloct=$totaloct+$totaloct1;
    //                     // if($empt->active==0){
    //                     //     $totaloctday12=0;
    //                     // }
    //                     if($empt->date_resigned < $octstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $octend){
    //                         $totaloctday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totaloctday12=($octdays->d+1)-$roctdays-$octpublicholiday;
    //                     }
    //                     //$totaloctday12=($octdays->d+1)-$roctdays-$octpublicholiday;
    //                 }
    //                 $roctdays11=$roctdays11+$totaloctday12;



    //  //echo $totaloctday12.'<br>';
    //                 $rnovdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','11');

    //                 $novpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','11');

    //                 if($novend!='0000-00-00'){
    //                     $rnovdays1->whereBetween('rest_dates.date',[$novstart,$novend]);
    //                     $novpublicholiday1->whereBetween('date',[$novstart,$novend]);
    //                 }
    //                 $novpublicholiday=$novpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $novpublicholiday=count($novpublicholiday);
    //                 $rnovdays=$rnovdays1->count();
    //                 if($novend=='0000-00-00'){
    //                     $totalnov =0;
    //                     $totalnovday12=0;
    //                 }
    //                 else{
    //                     $novdays = date_diff(date_create($novstart), date_create($novend));
    //                     $totalnovday=($novdays->d+1)-$rnovdays-$novpublicholiday-$nov;
    //                     $totalnov1=($totalnovday*100)/($novdays->d+1);
    //                     $totalnov=$totalnov+$totalnov1;

    //                     // if($empt->active==0){
    //                     //     $totalnovday12=0;
    //                     // }
    //                     if($empt->date_resigned < $novstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $novend){
    //                         $totalnovday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totalnovday12=($novdays->d+1)-$rnovdays-$novpublicholiday;
    //                     }
    //                   // $totalnovday12=($novdays->d+1)-$rnovdays-$novpublicholiday;
    //                 }
    //                 $rnovdays11=$rnovdays11+$totalnovday12;

    //                 $rdecdays1=DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_days.category_id',$empt->restdayid)->whereYear('rest_dates.date',date('Y'))->whereMonth('rest_dates.date','12');

    //                 $decpublicholiday1=DB::table('public_holiday')->whereRaw("(state='".$empt->estate."' or state='National')")->where('company_id',$user->company_id)->whereYear('date',date('Y'))->whereMonth('date','11');
    //                 if($decend!='0000-00-00'){
    //                     $rdecdays1->whereBetween('rest_dates.date',[$decstart,$decend]);
    //                     $decpublicholiday1->whereBetween('date',[$decstart,$decend]);
    //                 }
    //                 $decpublicholiday=$decpublicholiday1->groupByRaw("CONCAT(state, country, date, description)")->get();
    //                 $decpublicholiday=count($decpublicholiday);
    //                 $rdecdays=$rdecdays1->count();
    //                 if($decend=='0000-00-00'){
    //                     $totaldec =0;
    //                     $totaldecday12=0;
    //                 }
    //                 else{
    //                     $decdays = date_diff(date_create($decstart), date_create($decend));
    //                     $totaldecday=($decdays->d+1)-$rdecdays-$decpublicholiday-$dec;
    //                     $totaldec1=($totaldecday*100)/($decdays->d+1);
    //                     $totaldec=$totaldec+$totaldec1;

    //                     // if($empt->active==0){
    //                     //     $totaldecday12=0;
    //                     // }
    //                     if($empt->date_resigned < $decstart && $empt->date_resigned!='0000-00-00' || $empt->date_commence > $decend){
    //                         $totaldecday12=0;
    //                       // dd($totalmarday12);
    //                     }
    //                     else{
    //                         $totaldecday12=($decdays->d+1)-$rdecdays-$decpublicholiday;
    //                     }
    //                     //$totaldecday12=($decdays->d+1)-$rdecdays-$decpublicholiday;
    //                 }
    //                 $rdecdays11=$rdecdays11+$totaldecday12;



    //         }
    //         //dd($rmardays11,$mar);
    //     // dd($rjandays11,$jan);
    //         $result['jan'] = sprintf("%0.1f", ($rjandays11-$jan)*100 /$rjandays11);
    //         $result['feb'] = sprintf("%0.1f",($rfebdays11-$feb)*100 / $rfebdays11);
    //         $result['mar'] = sprintf("%0.1f",($rmardays11-$mar)*100 / $rmardays11);
    //         $result['apr'] = sprintf("%0.1f",($raprdays11-$apr)*100 / $raprdays11);
    //         $result['may'] = sprintf("%0.1f",($rmaydays11-$may)*100 / $rmaydays11);
    //         $result['jun'] = sprintf("%0.1f",($rjundays11-$jun)*100 / $rjundays11);
    //         $result['jul'] = sprintf("%0.1f",($rjuldays11-$jul)*100 / $rjuldays11);
    //         $result['aug'] = sprintf("%0.1f",($raugdays11-$aug)*100 / $raugdays11);
    //         $result['sep'] = sprintf("%0.1f",($rsepdays11-$sep)*100 / $rsepdays11);
    //         $result['oct'] = sprintf("%0.1f",($roctdays11-$oct)*100 / $roctdays11);
    //         $result['nov'] = sprintf("%0.1f",($rnovdays11-$nov)*100 / $rnovdays11);
    //         $result['dec'] = sprintf("%0.1f",($rdecdays11-$dec)*100 / $rdecdays11);

    //         return $result;
    //     }


    public function getweeklyattendance(Request $request)
    {
        $aid = Auth::id();
        $url = str_replace("e-leave/getweeklyattendance", "public/attendance.php?action=attendance&auth_id=$aid&", $request->getUri());
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response);
        return $result;
    }


    public function getmonthlyattrition(Request $request)
    {
        $user = User::where('id', Auth::id())->first();


        $janstart = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '<', date('Y') . '-01-01')->where('user_pay.date_resigned', '0000-00-00')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $jannewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-01-01')->where('user_pay.date_commence', '<=', date('Y') . '-01-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $janresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-01-01')->where('user_pay.date_resigned', '<=', date('Y') . '-01-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $janend = $janstart + $jannewjoin - $janresign;

        $febnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-02-01')->where('user_pay.date_commence', '<=', date('Y') . '-02-29')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $febresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-02-01')->where('user_pay.date_resigned', '<=', date('Y') . '-02-29')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $febend = $janend + $febnewjoin - $febresign;

        $marnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-03-01')->where('user_pay.date_commence', '<=', date('Y') . '-03-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $marresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-03-01')->where('user_pay.date_resigned', '<=', date('Y') . '-03-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $marend = $febend + $marnewjoin - $marresign;

        $aprnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-04-01')->where('user_pay.date_commence', '<=', date('Y') . '-04-30')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $aprresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-04-01')->where('user_pay.date_resigned', '<=', date('Y') . '-04-30')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $aprend = $marend + $aprnewjoin - $aprresign;

        $maynewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-05-01')->where('user_pay.date_commence', '<=', date('Y') . '-05-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $mayresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-05-01')->where('user_pay.date_resigned', '<=', date('Y') . '-05-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $mayend = $aprend + $maynewjoin - $mayresign;


        $junnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-06-01')->where('user_pay.date_commence', '<=', date('Y') . '-06-30')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $junresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-06-01')->where('user_pay.date_resigned', '<=', date('Y') . '-06-30')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $junend = $mayend + $junnewjoin - $junresign;

        $julnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-07-01')->where('user_pay.date_commence', '<=', date('Y') . '-07-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $julresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-07-01')->where('user_pay.date_resigned', '<=', date('Y') . '-07-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $julend = $junend + $julnewjoin - $julresign;

        $augnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-08-01')->where('user_pay.date_commence', '<=', date('Y') . '-08-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $augresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-08-01')->where('user_pay.date_resigned', '<=', date('Y') . '-08-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $augend = $julend + $augnewjoin - $augresign;


        $sepnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-09-01')->where('user_pay.date_commence', '<=', date('Y') . '-09-30')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $sepresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-09-01')->where('user_pay.date_resigned', '<=', date('Y') . '-09-30')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $sepend = $augend + $sepnewjoin - $sepresign;


        $octnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '10-01')->where('user_pay.date_commence', '<=', date('Y') . '-10-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $octresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-10-01')->where('user_pay.date_resigned', '<=', date('Y') . '-10-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $octend = $sepend + $octnewjoin - $octresign;

        $novnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-11-01')->where('user_pay.date_commence', '<=', date('Y') . '-11-30')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $novresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-11-01')->where('user_pay.date_resigned', '<=', date('Y') . '-11-30')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $novend = $octend + $novnewjoin - $novresign;

        $decnewjoin = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_commence', '>=', date('Y') . '-12-01')->where('user_pay.date_commence', '<=', date('Y') . '-12-31')->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->where('users.company_id', $user->company_id)->count();

        $decresign = DB::table('users')->leftjoin('user_pay', 'user_pay.username', '=', 'users.username')->leftjoin('user_personal', 'user_personal.username', '=', 'users.username')->where('user_pay.date_resigned', '>=', date('Y') . '-12-01')->where('user_pay.date_resigned', '<=', date('Y') . '-12-31')->where('user_personal.isDeleted', 0)->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->count();

        $decend = $novend + $decnewjoin - $decresign;

        $janavg = ($janstart + $janend) / 2;
        $febavg = ($janend + $febend) / 2;
        $maravg = ($febend + $marend) / 2;
        $apravg = ($marend + $aprend) / 2;
        $mayavg = ($aprend + $mayend) / 2;
        $junavg = ($mayend + $junend) / 2;
        $julavg = ($junend + $julend) / 2;
        $augavg = ($julend + $augend) / 2;
        $sepavg = ($augend + $sepend) / 2;
        $octavg = ($sepend + $octend) / 2;
        $novavg = ($octend + $novend) / 2;
        $decavg = ($novend + $decend) / 2;





        $result['jan'] = sprintf("%0.1f", (1 / $janavg) * 100);
        $result['feb'] = sprintf("%0.1f", (1 / $febavg) * 100);
        $result['mar'] = sprintf("%0.1f", (1 / $maravg) * 100);
        $result['apr'] = sprintf("%0.1f", (1 / $apravg) * 100);
        $result['may'] = sprintf("%0.1f", (1 / $mayavg) * 100);
        $result['jun'] = sprintf("%0.1f", (1 / $junavg) * 100);
        $result['jul'] = sprintf("%0.1f", (1 / $julavg) * 100);
        $result['aug'] = sprintf("%0.1f", (1 / $augavg) * 100);
        $result['sep'] = sprintf("%0.1f", (1 / $sepavg) * 100);
        $result['oct'] = sprintf("%0.1f", (1 / $octavg) * 100);
        $result['nov'] = sprintf("%0.1f", (1 / $novavg) * 100);
        $result['dec'] = sprintf("%0.1f", (1 / $decavg) * 100);

        return $result;
    }

    public function getjoinresign(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('users as u', 'user_personal.username', '=', 'u.username')->where('user_personal.username', '!=', null)->where('user_personal.isDeleted', 0)->where('u.company_id', $user->company_id)->where('b.pay_status', 1);
        $jan = clone $employees11;
        $jan1 = clone $employees11;
        $feb = clone $employees11;
        $feb1 = clone $employees11;
        $mar = clone $employees11;
        $mar1 = clone $employees11;
        $apr = clone $employees11;
        $apr1 = clone $employees11;
        $may = clone $employees11;
        $may1 = clone $employees11;
        $jun = clone $employees11;
        $jun1 = clone $employees11;
        $jul = clone $employees11;
        $jul1 = clone $employees11;
        $aug = clone $employees11;
        $aug1 = clone $employees11;
        $sep = clone $employees11;
        $sep1 = clone $employees11;
        $oct = clone $employees11;
        $oct1 = clone $employees11;
        $nov = clone $employees11;
        $nov1 = clone $employees11;
        $dec = clone $employees11;
        $dec1 = clone $employees11;

        $janstart = Carbon::parse(date('Y') . '-01-01');
        $febstart = Carbon::parse(date('Y') . '-02-01');
        $marstart = Carbon::parse(date('Y') . '-03-01');
        $aprstart = Carbon::parse(date('Y') . '-04-01');
        $maystart = Carbon::parse(date('Y') . '-05-01');
        $junstart = Carbon::parse(date('Y') . '-06-01');
        $julstart = Carbon::parse(date('Y') . '-07-01');
        $augstart = Carbon::parse(date('Y') . '-08-01');
        $sepstart = Carbon::parse(date('Y') . '-09-01');
        $octstart = Carbon::parse(date('Y') . '-10-01');
        $novstart = Carbon::parse(date('Y') . '-11-01');
        $decstart = Carbon::parse(date('Y') . '-12-01');

        $janend = Carbon::parse(date('Y') . '-01-31');
        $d = cal_days_in_month(CAL_GREGORIAN, 2, date('Y'));
        $febend = Carbon::parse(date('Y') . '-02-' . $d);
        $marend = Carbon::parse(date('Y') . '-03-31');
        $aprend = Carbon::parse(date('Y') . '-04-30');
        $mayend = Carbon::parse(date('Y') . '-05-31');
        $junend = Carbon::parse(date('Y') . '-06-30');
        $julend = Carbon::parse(date('Y') . '-07-31');
        $augend = Carbon::parse(date('Y') . '-08-31');
        $sepend = Carbon::parse(date('Y') . '-09-30');
        $octend = Carbon::parse(date('Y') . '-10-31');
        $novend = Carbon::parse(date('Y') . '-11-30');
        $decend = Carbon::parse(date('Y') . '-12-31');

        $janjoin = $jan->whereBetween('b.date_commence', [$janstart, $janend])->count();
        $janresign = $jan1->whereBetween('b.date_resigned', [$janstart, $janend])->count();

        $febjoin = $feb->whereBetween('b.date_commence', [$febstart, $febend])->count();
        $febresign = $feb1->whereBetween('b.date_resigned', [$febstart, $febend])->count();

        $marjoin = $mar->whereBetween('b.date_commence', [$marstart, $marend])->count();
        $marresign = $mar1->whereBetween('b.date_resigned', [$marstart, $marend])->count();

        $aprjoin = $apr->whereBetween('b.date_commence', [$aprstart, $aprend])->count();
        $aprresign = $apr1->whereBetween('b.date_resigned', [$aprstart, $aprend])->count();

        $mayjoin = $may->whereBetween('b.date_commence', [$maystart, $mayend])->count();
        $mayresign = $may1->whereBetween('b.date_resigned', [$maystart, $mayend])->count();

        $junjoin = $jun->whereBetween('b.date_commence', [$junstart, $junend])->count();
        $junresign = $jun1->whereBetween('b.date_resigned', [$junstart, $junend])->count();

        $juljoin = $jul->whereBetween('b.date_commence', [$julstart, $julend])->count();
        $julresign = $jul1->whereBetween('b.date_resigned', [$julstart, $julend])->count();

        $augjoin = $aug->whereBetween('b.date_commence', [$augstart, $augend])->count();
        $augresign = $aug1->whereBetween('b.date_resigned', [$augstart, $augend])->count();

        $sepjoin = $sep->whereBetween('b.date_commence', [$sepstart, $sepend])->count();
        $sepresign = $sep1->whereBetween('b.date_resigned', [$sepstart, $sepend])->count();

        $octjoin = $oct->whereBetween('b.date_commence', [$octstart, $octend])->count();
        $octresign = $oct1->whereBetween('b.date_resigned', [$octstart, $octend])->count();

        $novjoin = $nov->whereBetween('b.date_commence', [$novstart, $novend])->count();
        $novresign = $nov1->whereBetween('b.date_resigned', [$novstart, $novend])->count();

        $decjoin = $dec->whereBetween('b.date_commence', [$decstart, $decend])->count();
        $decresign = $dec1->whereBetween('b.date_resigned', [$decstart, $decend])->count();


        $result['janjoin'] = $janjoin;
        $result['janresign'] = $janresign;
        $result['febjoin'] = $febjoin;
        $result['febresign'] = $febresign;
        $result['marjoin'] = $marjoin;
        $result['marresign'] = $marresign;
        $result['aprjoin'] = $aprjoin;
        $result['aprresign'] = $aprresign;
        $result['mayjoin'] = $mayjoin;
        $result['mayresign'] = $mayresign;
        $result['junjoin'] = $junjoin;
        $result['junresign'] = $junresign;
        $result['juljoin'] = $juljoin;
        $result['julresign'] = $julresign;
        $result['augjoin'] = $augjoin;
        $result['augresign'] = $augresign;
        $result['sepjoin'] = $sepjoin;
        $result['sepresign'] = $sepresign;
        $result['octjoin'] = $octjoin;
        $result['octresign'] = $octresign;
        $result['novjoin'] = $novjoin;
        $result['novresign'] = $novresign;
        $result['decjoin'] = $decjoin;
        $result['decresign'] = $decresign;

        return $result;
    }

    public function getbirthdayanniversary(Request $request)
    {

        $year = $request->year;
        $month = $request->month;
        $type = $request->type;
        
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0)->where('b.pay_status', 1);
        $an = clone $employees11;

        if($type == "All"){
            $result['birthday'] = $employees11->whereMonth('user_personal.dob', $month)->whereYear('user_personal.dob', '<', $year)->get();
            $result['anniversary'] = $an->whereMonth('b.date_commence', $month)->whereYear('b.date_commence', '<', $year)->get();
        }elseif($type == "Birthday"){
            $result['birthday'] = $employees11->whereMonth('user_personal.dob', $month)->whereYear('user_personal.dob', '<', $year)->get();
            $result['anniversary'] = [];
        }elseif($type == "Anniversary"){
            $result['anniversary'] = $an->whereMonth('b.date_commence', $month)->whereYear('b.date_commence', '<', $year)->get();
            $result['birthday'] = [];
        }

        // dd($result);
        return $result;
    }



    public function setup()
    {
        $user = User::where('id', Auth::id())->first();
        //$permission_group = DB::table('map_employee_permission as a')->leftjoin('permission_group as b','a.permission_group_id','=','b.id')->where('a.employee_id',$user->username)->selectRaw('b.hr_leave_control, b.hr_leave_entitle, b.hr_add_employee, b.hr_edit_employee, b.hr_setup_leave_edit, b.hr_menu')->first();
        $permission_hr_leave_control = getPermissionValueString("hr_leave_control", $user->username);
        $permission_hr_leave_entitle = getPermissionValueString("hr_leave_entitle", $user->username);

        $permission_hr_add_employee = getPermissionValueString("hr_add_employee", $user->username);
        $permission_hr_edit_employee = getPermissionValueString("hr_edit_employee", $user->username);
        $permission_hr_setup_leave_edit = getPermissionValueString("hr_setup_leave_edit", $user->username);

        $permission_group = getPermissionValueString("hr_menu", $user->username);


        return view('hr.setup', compact('permission_hr_leave_control', 'permission_hr_leave_entitle', 'permission_hr_add_employee', 'permission_hr_edit_employee', 'permission_hr_setup_leave_edit', 'permission_group'));

        //return view('hr.setup', compact('permission_group'));
    }

    public function employee_type()
    {

        return view('hr.setup.employee_type');
    }
    public function getemployeetype(Request $request)
    {
        $dtable = $request->dtable ?? "";

        $user = User::where('id', Auth::id())->first();
        $result = DB::table('employee_type')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_personal')->selectRaw("username")->where('employee_type', $result[$i]->employee_type)->first();
            $result[$i]->type_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function addemployeetype(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $emptype = new EmployeeType;
        $emptype->employee_type = $request->employee_type;
        $emptype->is_deleted = 0;
        $emptype->company_id = $user->company_id;
        $emptype->save();
        return 1;
    }

    public function getemptypedata($id)
    {
        $result = DB::table('employee_type')->where('is_deleted', 0)->find($id);
        return $result;
    }

    public function editemptype(Request $request)
    {
        $emptype = EmployeeType::where('id', $request->type_id)->first();
        $emptype->employee_type = $request->employee_type;
        $emptype->save();

        return $emptype;
    }

    public function deleteemptype(Request $request)
    {
        $emptype = EmployeeType::where('id', $request->type_id)->first();
        $emptype->is_deleted = 1;
        $emptype->save();

        return $emptype;
    }


    public function employee_designation()
    {

        return view('hr.setup.employee_designation');
    }
    public function getemployeedesignation(Request $request)
    {
        $dtable = $request->dtable ?? "";
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('designation')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_personal')->selectRaw("username")->where('designation', $result[$i]->designation)->first();
            $result[$i]->designation_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function addemployeedesignation(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $empdesignation = new Designation;
        $empdesignation->designation = $request->employee_designation;
        $empdesignation->is_deleted = 0;
        $empdesignation->company_id = $user->company_id;
        $empdesignation->save();
        return 1;
    }

    public function getempdesignationdata($id)
    {
        $result = DB::table('designation')->where('is_deleted', 0)->find($id);
        return $result;
    }

    public function editempdesignation(Request $request)
    {
        $empdesignation = Designation::where('id', $request->designation_id)->first();
        $empdesignation->designation = $request->employee_designation;
        $empdesignation->save();

        return $empdesignation;
    }

    public function deleteempdesignation(Request $request)
    {
        $empdesignation = Designation::where('id', $request->designation_id)->first();
        $empdesignation->is_deleted = 1;
        $empdesignation->save();

        return $empdesignation;
    }

    public function createemployee()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $duty_roasters  = DB::table('duty_roaster')->get();
        
        $race  = Race::orderBy('race', 'asc')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        $countries = $this->getCountries();
        return view('hr.setup.add_employee', compact('categories', 'departments', 'branches', 'countries', 'race', 'duty_roasters'));
    }

    public function getCountries()
    {
        $query = "select * from countries where is_deleted='0'";
        $result = DB::select($query);
        for ($i = 0; $i < count($result); $i++) {
            $query = "select username from user_personal where nationality='" . $result[$i]->country_code . "'";
            $builder = DB::select($query);
            if ($builder != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return $result;
    }
    public function getGroupPermissions()
    {
        $query = "select id, group_name as permission from permission_group where type='group'";
        $result = DB::select($query);
        return $result;
    }

    public function getStateByCountry(Request $request)
    {
        $query = "select * from states where is_deleted='0' and country='$request->country'";
        $result = DB::select(($query));
        return $result;
    }


    public function registerUser_1(Request $request)
    {
        $query = "select v4_value from details where field='default password'";
        $dpass = DB::select($query);
        $password = $dpass[0]->v4_value;
        $username = $request->username;
        $emp_no = $request->employee_no;
        $employeeCode = $request->employee_code;
        $name = $request->name;
        $address = $request->address;
        $postalCode = $request->postal_code;
        $town = $request->town;
        $nationality = $request->nationality;
        $state = $request->state;
        $phoneNo = $request->phone_no;
        $dob = (($request->dob != "") ? date('Y-m-d', strtotime($request->dob)) : "");
        $highestEducation = $request->highest_education;
        $workingExperience = $request->working_experience;
        $icNoOld = $request->ic_no_old;
        $icNoNew = $request->ic_no_new;
        $icColor = $request->ic_color;
        $passportNo = $request->passport_no;
        $sex = $request->sex;
        $employee_type = $request->employee_type;
        $designation = $request->designation;
        $race = $request->race;
        $bumiputra = $request->bumiputra;
        $maritalStatus =  $request->marital_status;
        $emailId = $request->email_id;
        $blood_group = $request->blood_group;
        $spouseName = $request->spouse_name;
        $spouseIcNo = $request->spouse_ic_no;
        $noChildren = $request->no_children;
        $spouseWorking = $request->spouse_working;
        $address_name = $request->address_name;
        $address_address = $request->address_address;
        $address_phone_no = $request->address_phone_no;
        $status = $request->users_status;
        $eattendance_type = "duty_roaster";
        $schedule_id = $request->schedule_id;




        $query = "select username from users where username='$username'";
        $value11 = DB::select($query);
        $value = "";
        if (!empty($value11)) {
            $value = $value11[0]->username;
        }
        if ($value != '') {
            return 'dup_ic_no';
        }

        $query1 = "select employee_no from user_personal where username='$emp_no'";
        $value12 = DB::select($query1);
        $value1 = "";
        if (!empty($value12)) {
            $value1 = $value12[0]->employee_no;
        }
        if ($value1 != '') {
            return 'dup_emp_no';
        }

        if ($value == '' && $value1 == '') {


            $this->addUserPersonal(
                $username,
                $password,
                $emp_no,
                $employeeCode,
                $name,
                $address,
                $postalCode,
                $town,
                $nationality,
                $state,
                $phoneNo,
                $dob,
                $highestEducation,
                $workingExperience,
                $icNoOld,
                $icNoNew,
                $icColor,
                $passportNo,
                $sex,
                $employee_type,
                $designation,
                $race,
                $bumiputra,
                $maritalStatus,
                $emailId,
                1,
                $status,
                $blood_group,
                $eattendance_type,
                $schedule_id
            );
            if ($this->isUsernameAvailableuserspouse($username) == '') {
                $query = "insert into user_spouse (username, spouse_name, spouse_ic_no, no_children, spouse_working) ";
                $query .= 'values ("' . $username . '", "' . $spouseName . '", "' . $spouseIcNo . '", "' . $noChildren . '", "' . $spouseWorking . '")';
                DB::select($query);
            }

            if ($this->isUsernameAvailableuseraddress($username) == '') {
                $query3 = 'insert into user_address (username, name, address, phone_no) values ("' . $username . '", "' . $address_name . '", "' . $address_address . '", "' . $address_phone_no . '")';
                DB::select($query3);
            }
            $query4 = "insert into email_preferences (employee_id) values ('$username')";
            DB::select($query4);
            return true;
        } else {
            return 'duplicate';
        }
    }

    public function addUserPersonal(
        $username,
        $password,
        $employeeNo,
        $employeeCode,
        $name,
        $address,
        $postalCode,
        $town,
        $nationality,
        $state,
        $phoneNo,
        $dob,
        $highestEducation,
        $workingExperience,
        $icNoOld,
        $icNoNew,
        $icColor,
        $passportNo,
        $sex,
        $employee_type,
        $designation,
        $race,
        $bumiputra,
        $maritalStatus,
        $emailId,
        $type = 1,
        $status,
        $blood_group = "",
        $eattendance_type = "",
        $schedule_id = ""
    ) {

        switch ($type) {

            case 1:
                $this->createStaff($username, $password, $status);
        }

        if ($this->isUsernameAvailableuserpersonal($username) == '') {
            $query = 'insert into user_personal (username, employee_no, employee_code, name, address, postal_code, town, nationality, ';
            $query .= 'state, phone_no, dob, highest_education, working_experience, ic_no_old, ic_no_new, ic_color, passport_no, sex, employee_type, designation, ';
            $query .= 'race, bumiputra, marital_status, email_id,blood_group,eattendance_type,duty_roaster_id) values ("' . $username . '", "' . $employeeNo . '", "' . $employeeCode . '", "' . $name . '", "' . $address . '", "' . $postalCode . '", "' . $town . '", "' . $nationality . '", "' . $state . '", "' . $phoneNo . '", "' . $dob . '", "' . $highestEducation . '", "' . $workingExperience . '", "' . $icNoOld . '", "' . $icNoNew . '", "' . $icColor . '", "' . $passportNo . '", "' . $sex . '", "' . $employee_type . '", "' . $designation . '", "' . $race . '", "' . $bumiputra . '", "' . $maritalStatus . '", "' . $emailId . '", "' . $blood_group . '", "' . $eattendance_type . '", "' . $schedule_id . '")';

            $builder = DB::select($query);
            $result = $builder;
            return $result;
        }
    }

    public function createStaff($username, $password, $status)
    {

        if (!$this->isUsernameAvailable($username)) {
        } else {
            $query = 'insert into users (username, v4_password, account_type, status) values ("' . $username . '", "' . $password . '", "2", "' . $status . '")';
            $builder = DB::select($query);
            return $builder;
        }
    }

    public function isUsernameAvailableuserpersonal($username)
    {
        $query = "select username from user_personal where username='$username'";
        $value1 = DB::select($query);
        $value = "";
        if (!empty($value1)) {
            $value = $value1[0]->username;
        }
        return $value;
    }

    public function isUsernameAvailableuserspouse($username)
    {
        $query = "select username from user_spouse where username='$username'";
        $value1 = DB::select($query);
        $value = "";
        if (!empty($value1)) {
            $value = $value1[0]->username;
        }
        return $value;
    }

    public function isUsernameAvailableuseraddress($username)
    {
        $query = "select username from user_address where username='$username'";
        $value1 = DB::select($query);
        $value = "";
        if (!empty($value1)) {
            $value = $value1[0]->username;
        }
        return $value;
    }


    public function isUsernameAvailable($username, $gusername = '')
    {
        if ($gusername != '') {
            $query = 'select username from users where username="' . $username . '" and username !="' . $gusername . '"';
        } else {
            $query = "select username from users where username='$username'";
        }

        $value1 = DB::select($query);
        $value = "";
        if (!empty($value1)) {
            $value = $value1[0]->username;
        }
        if ($value != "")
            return FALSE;
        return TRUE;
    }


    public function mapEmployeePermission(Request $request)
    {
        $employeeIds = explode(",", $request->employee_ids);
        $groupId = $request->permission_group_id;

        for ($i = 0; $i < count($employeeIds); $i++) {
            $this->mapEmplyoyeePermission($employeeIds[$i], $groupId);
        }

        return true;
    }

    public function mapEmplyoyeePermission($employeeId, $permissionGroupid)
    {
        $query = "delete from map_employee_permission where employee_id='$employeeId'";
        DB::select($query);

        $query = 'insert into map_employee_permission (employee_id, permission_group_id) values ("' . $employeeId . '", "' . $permissionGroupid . '")';
        $result = DB::select($query);
        return $result;
    }

    public function getcategoryNames()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('category_name')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        return $result;
    }

    public function isEmployeeNoAvailable(Request $request)
    {

        $employeeNo = $request->employee_no;
        $username = $request->username ?? '';
        if ($username != '') {
            if ($this->isEmployeeNoAvailable12($employeeNo, $username))
                return true;
            else
                return false;
        } else {
            if ($this->isEmployeeNoAvailable11($employeeNo))
                return true;
            else
                return false;
        }
    }

    public function isEmployeeNoAvailable11($employeeNo)
    {
        $query = "select employee_no from user_personal where employee_no='$employeeNo'";
        $value1 = DB::select($query);
        $val = "";
        if (!empty($value1)) {
            $val = $value1[0]->employee_no;
        }
        if ($val != "")
            return FALSE;
        return TRUE;
    }

    public function isEmployeeNoAvailable12($employeeNo, $username)
    {
        $query = 'select employee_no from user_personal where employee_no="' . $employeeNo . '" and username!="' . $username . '"';
        $value1 = DB::select($query);
        $val = "";
        if (!empty($value1)) {
            $val = $value1[0]->employee_no;
        }

        if ($val != "")
            return FALSE;
        return TRUE;
    }

    public function usernameAvailable(Request $request)
    {
        $username = $request->username;
        $gusername = $request->gusername;
        if ($this->isUsernameAvailable($username, $gusername))
            return true;
        else
            return false;
    }


    public function registerUser_2(Request $request)
    {
        $username = $request->username;
        $jobTitle = $request->job_title;
        $branchId = $request->branch_id;
        $departmentId = $request->department_id;
        $categoryId = $request->category_id;
        $dateCommence = (($request->date_commence != "") ? date('Y-m-d', strtotime($request->date_commence)) : "");
        $datePrompted = (($request->date_prompted != "") ? date('Y-m-d', strtotime($request->date_prompted)) : "");
        $dateResigned = (($request->date_resigned != "") ? date('Y-m-d', strtotime($request->date_resigned)) : "");
        $dateConfirmed = (($request->date_confirmed != "") ? date('Y-m-d', strtotime($request->date_confirmed)) : "");
        $payRateType = $request->pay_rate_type;
        $payMethod = $request->pay_method;
        $payStatus = $request->pay_status;
        $contract = $request->contract;
        $contract = $request->contract;
        $att_start = $request->att_start;

        $this->addUserPay(
            $username,
            $jobTitle,
            $branchId,
            $departmentId,
            $categoryId,
            $dateCommence,
            $datePrompted,
            $dateResigned,
            $dateConfirmed,
            $payRateType,
            $payMethod,
            $payStatus,
            $contract,
            $att_start
        );
        return true;
    }


    public function addUserPay(
        $username,
        $jobTitle,
        $branchId,
        $departmentId,
        $categoryId,
        $dateCommence,
        $datePrompted,
        $dateResigned,
        $dateConfirmed,
        $payRateType,
        $payMethod,
        $payStatus,
        $contract,
        $att_start
    ) {

        if ($this->isUsernameduplicate('user_pay', $username) == '') {

            $query = "insert into user_pay (username, job_title, branch_id, department_id, category_id, date_commence, date_prompted, ";
            $query .= 'date_resigned, date_confirmed, pay_rate_type, pay_method, pay_status, contract, date_attendance_start) value ("' . $username . '", "' . $jobTitle . '", "' . $branchId . '", "' . $departmentId . '", "' . $categoryId . '", "' . $dateCommence . '", "' . $datePrompted . '", "' . $dateResigned . '", "' . $dateConfirmed . '", "' . $payRateType . '", "' . $payMethod . '", "' . $payStatus . '", "' . $contract . '", "' . $att_start . '")';
            $builder = DB::select($query);
            //return $query;
            return $builder;
        }
    }

    public function isUsernameduplicate($tablename, $username)
    {
        $query = "select username from " . $tablename . " where username='$username'";
        $value1 = DB::select($query);
        $value = "";
        if (!empty($value1)) {
            $value = $value1[0]->username;
        }
        return $value;
    }

    public function registerUser_3(Request $request)
    {
        $username = $request->username;
        $bankCode = $request->bank_code;
        $branchCode = $request->branch_code;
        $bankAcNo = $request->bank_ac_no;
        $category = $request->gov_category;
        $paymentMode = $request->payment_mode;

        $this->addUserGovernment($username, $bankCode, $branchCode, $bankAcNo, $category, $paymentMode);

        $soscoNo = $request->socso_no;
        $table = $request->ins_table;
        $soscoIc = $request->socso_ic;
        $category = $request->ins_category;
        $soscoInitial = $request->socso_initial;

        $this->addUserInsurance($username, $soscoNo, $table, $soscoIc, $category, $soscoInitial);

        $epfNo = $request->epf_no;
        $epfIc = $request->epf_ic;
        $table = $request->epf_table;
        $category = $request->epf_category;
        $epfYeeFormula = $request->epf_yee_formula;
        $epfYerFormula = $request->epf_yer_formula;

        $this->addUserEPF($username, $epfNo, $epfIc, $table, $category, $epfYeeFormula, $epfYerFormula);

        $username = $request->username;
        $branch = $request->branch;
        $taxNo = $request->tax_no;
        $category = $request->tax_category;

        $this->addUserTax($username, $branch, $taxNo, $category);

        return true;
    }

    public function addUserGovernment($username, $bankCode, $branchCode, $bankAcNo, $category, $paymentMode)
    {
        if ($this->isUsernameduplicate('user_government', $username) == '') {
            $query = "insert into user_government (username, bank_code, branch_code, bank_ac_no, category, payment_mode)";
            $query .= " value ('$username', '$bankCode', '$branchCode', '$bankAcNo', '$category', '$paymentMode')";
            $builder = DB::select($query);
            return $builder;
        }
    }


    public function addUserInsurance($username, $soscoNo, $table, $soscoIc, $category, $soscoInitial)
    {
        if ($this->isUsernameduplicate('user_insurance', $username) == '') {
            $query = "insert into user_insurance (username, socso_no, tables, socso_ic, category, socso_initial) ";
            $query .= "values ('$username', '$soscoNo', '$table', '$soscoIc', '$category', '$soscoInitial')";
            $builder = DB::select($query);
            return $builder;
        }
    }

    public function addUserEPF($username, $epfNo, $epfIc, $table, $category, $epfYeeFormula, $epfYerFormula)
    {
        if ($this->isUsernameduplicate('user_epf', $username) == '') {
            $query = "insert into user_epf (username, epf_no, epf_ic, tables, category, epf_yee_formula, epf_yer_formula) ";
            $query .= "values ('$username', '$epfNo', '$epfIc', '$table', '$category', '$epfYeeFormula', '$epfYerFormula')";
            $builder = DB::select($query);
            return $builder;
        }
    }

    public function addUserTax($username, $branch, $taxNo, $category)
    {
        if ($this->isUsernameduplicate('user_tax', $username) == '') {
            $query = "insert into user_tax (username, branch, tax_no, category) values ('$username', '$branch', '$taxNo', '$category')";
            $builder = DB::select($query);
            return $builder;
        }
    }


    public function registerUser_4(Request $request)
    {
        if ($this->isUsernameduplicate('user_category', $request->username) == '') {
            $query = "insert into user_category (username, category) values ('$request->username', '$request->category')";
            $builder = DB::select($query);
            return true;
        }
        return false;
    }



    public function editemployee()
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $user = User::where('id', Auth::id())->first();
        $viewStatus = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->where('a.employee_id', $user->username)->selectRaw('b.view_leave, b.hr_leave_edit')->first();
        $deleteBtnShowSetting1 = DB::table('settings')->where('field', 'admindeletebutton')->first();
        $deleteBtnShowSetting = $deleteBtnShowSetting1->value ?? 0;

        $query = "select b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, ";
        $query .= "b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe from map_employee_permission a left join permission_group b on ";
        $query .= "a.permission_group_id=b.id where a.employee_id='$user->username'";
        $permission = DB::select($query);
        
        $c_key = 'leave_emp_edit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.setup.edit_employee', compact('categories', 'departments', 'branches', 'deleteBtnShowSetting', 'permission', 'c_key', 'columnHideShowData'));
    }

    public function deleteUser(Request $request)
    {
        $username = $request->username;
        $query = "update users set isDeleted='1' where username='$username'";
        $result = DB::select($query);
        $query1 = "update user_personal set isDeleted='1' where username='$username'";
        DB::select($query1);

        return $result;
    }

    public function resetpassword(Request $request)
    {
        $username = $request->username;
        User::where(['username' => $username])->update(['v4_password' => bcrypt('123456')]);

        $user_personal = UserPersonal::where('username', $username)->first();
        $subject = "Eleave- New Password Generated";
        $email = $user_personal->email_id;

        $body = "New password: 123456";
        if ($email) {
            //Mail::to($email)->send(new MyDemoMail($body));
            sendemail($email, $subject, $body);
        }
        return true;
    }

    public function updateemployee($username)
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $userpersonal  = UserPersonal::where('username', '=', $user->username)->get();
        $race  = Race::orderBy('race', 'asc')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        $countries = $this->getCountries();
        $duty_roasters  = DB::table('duty_roaster')->get();
        return view('hr.setup.update_employee', compact('username', 'countries', 'branches', 'departments', 'categories', 'race', 'userpersonal', 'duty_roasters'));
    }

    public function getAllDetails(Request $request)
    {

        $personal = $this->getUserPersonalDetails($request->username);
        $spouse = $this->getUserSpouseDetails($request->username);
        $address = $this->getUserAddressDetails($request->username);
        $pay = $this->getUserPayDetails($request->username);
        $government = $this->getUserGovernmentDetails($request->username);
        $insurance = $this->getUserInsuranceDetails($request->username);
        $epf = $this->getUserEPFDetails($request->username);
        $tax = $this->getUserTax($request->username);
        $category = $this->getUserCategory($request->username);
        $user_status = $this->getUserStatus($request->username);
        $user_role = $this->getUserrole($request->username);
        $listArray = array(
            "personal" => $personal[0] ?? '',
            "spouse" => $spouse[0] ?? '',
            "address" => $address[0] ?? '',
            "pay" => $pay[0] ?? '',
            "government" => $government[0] ?? '',
            "insurance" => $insurance[0] ?? '',
            "epf" => $epf[0] ?? '',
            "tax" => $tax[0] ?? '',
            "category" => $category[0] ?? '',
            "user_status" => $user_status[0] ?? '',
            "permission_group_id" => $user_role[0] ?? '',
        );
        return $listArray;
    }

    public function getUserPersonalDetails($username)
    {
        $query = "select up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no,up.eattendance_type,up.schedule_id, up.duty_roaster_id,";
        $query .= "up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, ";
        $query .= "up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted from user_personal up ";
        $query .= "left join rest_day_category_employee rdce on rdce.employee_id=up.username left join rest_day_category rdc on rdc.id=rdce.category_id  ";
        $query .= "where username='$username' ";
        $result = DB::select($query);
        return $result;
    }

    public function getUserSpouseDetails($username)
    {
        $query = "select spouse_name, spouse_ic_no, no_children, spouse_working from user_spouse where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserAddressDetails($username)
    {
        $query = "select name, address, phone_no from user_address where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserPayDetails($username)
    {

        $query = "select a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, ";
        $query .= "DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, ";
        $query .= "'%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_attendance_start, '%d-%m-%Y') as date_attendance_start, ";
        $query .= "DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, ";
        $query .= "a.pay_status, a.contract from user_pay a left join branch b ";
        $query .= "on a.branch_id=b.id left join department c on a.department_id=c.id left join category d on a.category_id=d.id where ";
        $query .= "a.username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserGovernmentDetails($username)
    {
        $query = "select bank_code, branch_code, bank_ac_no, category, payment_mode from user_government where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserInsuranceDetails($username)
    {
        $query = "select socso_no, tables, socso_ic, category, socso_initial from user_insurance where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserEPFDetails($username)
    {
        $query = "select epf_no, epf_ic, tables, category, epf_yee_formula, epf_yer_formula from user_epf where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserTax($username)
    {
        $query = "select branch, tax_no, category from user_tax where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserCategory($username)
    {
        $query = "select category from user_category where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getUserStatus($username)
    {
        $query = "select status from users where username='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getLeaveMultipleApprover()
    {
        $query = "select value from settings where field='leave_multiple_approver'";
        $builder = DB::select($query);
        $result = $builder[0]->value;
        return $result;
    }
    public function getUserrole($username)
    {
        $query = "select permission_group_id from map_employee_permission
 where employee_id='$username'";
        $result = DB::select($query);
        return $result;
    }

    public function getApproversOfEmployee(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $employeeId = ($request->employee_id ? $request->employee_id : $user->username);

        $list = $this->getApproversOfEmployee11($employeeId);
        return $list;
    }

    public function getApproversOfEmployee11($employeeId)
    {
        $query = "select distinct a.approver_id as username, b.name from map_employee_approver a left join user_personal b ";
        $query .= "on a.approver_id=b.username where a.employee_id='$employeeId' order by a.approver_index ASC";

        $builder = DB::select($query);
        return $builder;
    }

    public function getPermissionGroupOfEmployee(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $employeeId = ($request->employee_id ? $request->employee_id : $user->username);

        $result = $this->getPermissionGroupOfEmployee11($employeeId);
        return $result;
    }

    public function getPermissionGroupOfEmployee11($employeeId)
    {
        $query = "select b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, ";
        $query .= "b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe from map_employee_permission a left join permission_group b on ";
        $query .= "a.permission_group_id=b.id where a.employee_id='$employeeId'";
        $builder = DB::select($query);
        return $builder;
    }

    public function getRestDayCategoriesOfEmployee(Request $request)
    {
        $employeeId = $request->employee_id;

        $result = $this->getRestDayCategoriesOfEmployee11($employeeId);
        return $result;
    }

    public function getRestDayCategoriesOfEmployee11($employeeId)
    {

        $query = "select a.category_id, b.category from rest_day_category_employee a left join ";
        $query .= "rest_day_category b on a.category_id=b.id where a.employee_id='$employeeId'";
        $builder = DB::select($query);

        return $builder;
    }

    public function updateUserAll(Request $request)
    {

        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);

        $userd_data = "select * from users where username='" . $username . "'";
        $user_data = DB::select($userd_data);
        $icNoNew = $request->ic_no_new;

        $query = "select username from users where username='$icNoNew' AND id!=" . $user_data[0]->id;
        $value11 = DB::select($query);

        $value = $value11;

        if (!empty($value)) {
            return 'dup_ic_no';
        }



        $this->updateUserPersonal(request());
        $this->updateUserSpouse(request());
        $this->updateUserAddress(request());
        $this->updateUserPay(request());
        $this->updateUserGovernment(request());
        $this->updateUserInsurance(request());
        $this->updateUserEPF(request());
        $this->updateUserTax(request());
        $this->updateUserCategory(request());
        $this->updateUsername($username, $icNoNew);
        $this->updateUserStatus(request());
        return true;
    }

    public function updateUserPersonal(Request $request)
    {
          $user_personal = new  UserPersonal;

        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $employeeNo = $request->employee_no;
        $employeeCode = $request->employee_code;
        $name = $request->name;
        $address = $request->address;
        $postalCode = $request->postal_code;
        $town = $request->town;
        $nationality = $request->nationality;
        $state = $request->state;
        $phoneNo = $request->phone_no;
        $dob = (($request->dob != "") ? date('Y-m-d', strtotime($request->dob)) : "");
        $highestEducation = $request->highest_education;
        $workingExperience = $request->working_experience;
        $icNoOld = $request->ic_no_old;
        $icNoNew = $request->ic_no_new;
        $icColor = $request->ic_color;
        $passportNo = $request->passport_no;
        $sex = $request->sex;
        $employee_type = $request->employee_type;
        $designation = $request->designation;
        $race = $request->race;
        $bumiputra = $request->bumiputra;
        $maritalStatus =  $request->marital_status;
        $emailId = $request->email_id;
        $blood_group = $request->blood_group;
        $profile_photo_file = $request->profile_photo_file;
        $eattendance_type = "duty_roaster";
        $schedule_id = $request->schedule_id;
        $result = $this->updateUserPersonal11(
            $username,
            $employeeNo,
            $employeeCode,
            $name,
            $address,
            $postalCode,
            $town,
            $nationality,
            $state,
            $phoneNo,
            $dob,
            $highestEducation,
            $workingExperience,
            $icNoOld,
            $icNoNew,
            $icColor,
            $passportNo,
            $sex,
            $employee_type,
            $designation,
            $race,
            $bumiputra,
            $maritalStatus,
            $emailId,
            $blood_group,
            $profile_photo_file,
            $eattendance_type,
            $schedule_id
        );
    }

    public function updateUserPersonal11(
        $username,
        $employeeNo,
        $employeeCode,
        $name,
        $address,
        $postalCode,

        $town,
        $nationality,
        $state,
        $phoneNo,
        $dob,
        $highestEducation,
        $workingExperience,
        $icNoOld,
        $icNoNew,
        $icColor,
        $passportNo,
        $sex,
        $employee_type,
        $designation,
        $race,
        $bumiputra,
        $maritalStatus,
        $emailId,
        $blood_group = "",
        $profile_photo_file = "",
        $eattendance_type = "",
        $schedule_id = ""
    )
  
     {
           
        if($eattendance_type == 'schedule')
        {
            $result =  DB::table('user_personal')->where('username', $username)->update(array('employee_no' => $employeeNo, 'employee_code' => $employeeCode, 'name' => $name, 'address' => $address, 'postal_code' => $postalCode, 'town' => $town, 'nationality' => $nationality, 'state' => $state, 'phone_no' => $phoneNo, 'dob' => $dob, 'highest_education' => $highestEducation, 'working_experience' => $workingExperience, 'ic_no_old' => $icNoOld, 'ic_no_new' => $icNoNew, 'ic_color' => $icColor, 'passport_no' => $passportNo, 'sex' => $sex, 'employee_type' => $employee_type, 'designation' => $designation, 'race' => $race, 'bumiputra' => $bumiputra, 'marital_status' => $maritalStatus, 'email_id' => $emailId, 'blood_group' => $blood_group, 'profile_photo_file' => $profile_photo_file, 'eattendance_type' => $eattendance_type, 'schedule_id' => $schedule_id, 'duty_roaster_id' => NULL));
            return $result;
        }
        elseif($eattendance_type == 'duty_roaster'){
            
            $result =  DB::table('user_personal')->where('username', $username)->update(array('employee_no' => $employeeNo, 'employee_code' => $employeeCode, 'name' => $name, 'address' => $address, 'postal_code' => $postalCode, 'town' => $town, 'nationality' => $nationality, 'state' => $state, 'phone_no' => $phoneNo, 'dob' => $dob, 'highest_education' => $highestEducation, 'working_experience' => $workingExperience, 'ic_no_old' => $icNoOld, 'ic_no_new' => $icNoNew, 'ic_color' => $icColor, 'passport_no' => $passportNo, 'sex' => $sex, 'employee_type' => $employee_type, 'designation' => $designation, 'race' => $race, 'bumiputra' => $bumiputra, 'marital_status' => $maritalStatus, 'email_id' => $emailId, 'blood_group' => $blood_group, 'profile_photo_file' => $profile_photo_file, 'eattendance_type' => $eattendance_type, 'schedule_id'=>NULL, 'duty_roaster_id' => $schedule_id ));
            return $result;
        }       

       
    }

    public function updateUserSpouse(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $spouseName = $request->spouse_name;
        $spouseIcNo = $request->spouse_ic_no;
        $noChildren = $request->no_children;
        $spouseWorking = $request->spouse_working;

        $result = $this->updateUserSpouse11($username, $spouseName, $spouseIcNo, $noChildren, $spouseWorking);
    }

    public function updateUserSpouse11($username, $spouseName, $spouseIcNo, $noChildren, $spouseWorking)
    {
        $query = "update user_spouse set spouse_name='$spouseName', spouse_ic_no='$spouseIcNo', no_children='$noChildren', ";
        $query .= "spouse_working='$spouseWorking' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserAddress(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $name = $request->address_name;
        $address = $request->address_address;
        $phoneNo = $request->address_phone_no;

        $result = $this->updateUserAddress11($username, $name, $address, $phoneNo);
    }

    public function updateUserAddress11($username, $name, $address, $phoneNo)
    {
        $query = "update user_address set name='$name', address='$address', phone_no='$phoneNo' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserPay(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $jobTitle = $request->job_title;
        $branchId = $request->branch_id;
        $departmentId = $request->department_id;
        $categoryId = $request->category_id;
        $dateCommence = (($request->date_commence != "") ? date('Y-m-d', strtotime($request->date_commence)) : "");
        $datePrompted = (($request->date_prompted != "") ? date('Y-m-d', strtotime($request->date_prompted)) : "");
        $dateResigned = (($request->date_resigned != "") ? date('Y-m-d', strtotime($request->date_resigned)) : "");
        $dateConfirmed = (($request->date_confirmed != "") ? date('Y-m-d', strtotime($request->date_confirmed)) : "");
        $payRateType = $request->pay_rate_type;
        $payMethod = $request->pay_method;
        $payStatus = $request->pay_status;
        $contract = $request->contract;
        $att_start = $request->att_start;

        $result = $this->updateUserPay11(
            $username,
            $jobTitle,
            $branchId,
            $departmentId,
            $categoryId,
            $dateCommence,
            $datePrompted,
            $dateResigned,
            $dateConfirmed,
            $payRateType,
            $payMethod,
            $payStatus,
            $contract,
            $att_start
        );
    }

    public function  updateUserPay11(
        $username,
        $jobTitle,
        $branchId,
        $departmentId,
        $categoryId,
        $dateCommence,
        $datePrompted,
        $dateResigned,
        $dateConfirmed,
        $payRateType,
        $payMethod,
        $payStatus,
        $contract,
        $att_start
    ) {
        $query = "update user_pay set job_title='$jobTitle', branch_id='$branchId', department_id='$departmentId', category_id='$categoryId', ";
        $query .= "date_commence='$dateCommence', date_prompted='$datePrompted', date_resigned='$dateResigned', date_confirmed='$dateConfirmed', pay_rate_type='$payRateType', date_attendance_start='$att_start', ";
        $query .= "pay_method='$payMethod', pay_status='$payStatus', contract='$contract' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserGovernment(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $bankCode = $request->bank_code;
        $branchCode = $request->branch_code;
        $bankAcNo = $request->bank_ac_no;
        $category = $request->gov_category;
        $paymentMode = $request->payment_mode;

        $result = $this->updateUserGovernment11($username, $bankCode, $branchCode, $bankAcNo, $category, $paymentMode);
    }

    public function updateUserGovernment11($username, $bankCode, $branchCode, $bankAcNo, $category, $paymentMode)
    {
        $query = "update user_government set bank_code='$bankCode', branch_code='$branchCode', bank_ac_no='$bankAcNo', ";
        $query .= "category='$category', payment_mode='$paymentMode' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserInsurance(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $soscoNo = $request->socso_no;
        $table = $request->ins_table;
        $soscoIc = $request->socso_ic;
        $category = $request->ins_category;
        $soscoInitial = $request->socso_initial;

        $this->updateUserInsurance11($username, $soscoNo, $table, $soscoIc, $category, $soscoInitial);
    }

    public function updateUserInsurance11($username, $soscoNo, $table, $soscoIc, $category, $soscoInitial)
    {
        $query = "update user_insurance set socso_no='$soscoNo', tables='$table', socso_ic='$soscoIc', category='$category', ";
        $query .= "socso_initial='$soscoInitial' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }


    public function updateUserEPF(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $epfNo = $request->epf_no;
        $epfIc = $request->epf_ic;
        $table = $request->epf_table;
        $category = $request->epf_category;
        $epfYeeFormula = $request->epf_yee_formula;
        $epfYerFormula = $request->epf_yer_formula;

        $this->updateUserEPF11($username, $epfNo, $epfIc, $table, $category, $epfYeeFormula, $epfYerFormula);
    }

    public function updateUserEPF11($username, $epfNo, $epfIc, $table, $category, $epfYeeFormula, $epfYerFormula)
    {
        $query = "update user_epf set epf_no='$epfNo', epf_ic='$epfIc', tables='$table', category='$category', ";
        $query .= "epf_yee_formula='$epfYeeFormula', epf_yer_formula='$epfYerFormula' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }


    public function updateUserTax(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $branch = $request->branch;
        $taxNo = $request->tax_no;
        $category = $request->tax_category;

        $this->updateUserTax11($username, $branch, $taxNo, $category);
    }

    public function updateUserTax11($username, $branch, $taxNo, $category)
    {
        $query = "update user_tax set branch='$branch', tax_no='$taxNo', category='$category' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserCategory(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $category = $request->category;

        $this->updateUserCategory11($username, $category);
    }

    public function updateUserCategory11($username, $category)
    {
        $query = "update user_category set category='$category' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUserStatus(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = ($request->username ? $request->username : $user->username);
        $users_status = $request->users_status;

        $result = $this->updateUserStatus11($username, $users_status);
    }

    public function updateUserStatus11($username, $status)
    {
        $query = "update users set status='$status' where username='" . $username . "'";
        $result = DB::select($query);
        return $result;
    }

    public function updateUsername($oldUsername, $newusername)
    {
        if ($oldUsername == $newusername || !$this->isUsernameAvailable($newusername))
            return FALSE;

        $usernameList = array(
            array("email_preferences", "employee_id"),
            array("leave_adjustment", "employee_id"),
            array("leave_days", "username"),
            array("leave_entitle_history", "username"),
            array("leave_list", "username"),
            array("leave_list", "approver_id"),
            array("leave_past", "username"),
            array("rl_leaves", "employee_id"),
            array("rl_leaves", "approver_id"),
            array("eclaim_employee", "employee_id"),
            array("eclaim_employee", "approver_id"),
            array("leave_bf_adj", "username"),
            array("pending_emails", "email_to"),
            array("map_employee_approver", "employee_id"),
            array("map_employee_approver", "approver_id"),
            array("map_employee_manager", "employee_id"),
            array("map_employee_manager", "manager_id"),
            array("map_employee_permission", "employee_id"),
            array("messages", "sender"),
            array("messages", "recipient"),
            array("messages_sent", "sender"),
            array("organization_structure", "employee_id"),
            array("organization_structure", "superior_id"),
            array("rest_day_category_employee", "category_id"),
            array("rest_day_category_employee", "employee_id"),
            array("rest_days", "employee_id"),
            array("sms_preference", "employee_id"),
            array("user_address", "username"),
            array("user_category", "username"),
            array("user_epf", "username"),
            array("user_government", "username"),
            array("user_insurance", "username"),
            array("user_pay", "username"),
            array("user_personal", "username"),
            array("user_spouse", "username"),
            array("user_tax", "username"),
            array("users", "username")
        );

        for ($i = 0; $i < count($usernameList); $i++) {
            $table = $usernameList[$i][0];
            $field = $usernameList[$i][1];
            $query = "update $table set $field='" . $newusername . "' where $field='" . $oldUsername . "'";
            DB::select($query);
        }
        return TRUE;
    }





    public function approvercreate()
    {

        return view('hr.setup.approver_create');
    }

    public function getApprovers()
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $query = "select c.username, c.name, c.employee_no from map_employee_permission a left join ";
        $query .= "permission_group b on a.permission_group_id=b.id left join user_personal c on ";
        $query .= "a.employee_id=c.username  left join user_pay up on c.username=up.username where approval>0 ";
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
        } else {
            $query .= "and up.pay_status = '1'";
        }
        $query .= " and c.isDeleted =0 order by c.name";

        $result = DB::select($query);
        //echo $builder->getQuery();
        return $result;
    }

    public function getManagers()
    {
        $result = $this->filterByStatus("2");
        return $result;
    }

    public function getGroupedUsers(Request $request)
    {

        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $searchQuery = "a.username != ''";
        if ($request->department_id != "") {
            $searchQuery .= " and a.department_id='$request->department_id'";
        }
        if ($request->branch_id != "") {
            $searchQuery .= " and a.branch_id='$request->branch_id'";
        }
        if ($request->categoryId != "") {
            $searchQuery .= " and a.category_id='$request->categoryId'";
        }
        if ($request->category_id != "") {
            $searchQuery .= " and a.category_id='$request->category_id'";
        }
        if ($request->username != "") {
            $searchQuery .= ' and (b.name like "' . $request->username . '%" OR b.employee_no like "' . $request->username . '%") ';
        }

        $query = "select b.username, b.employee_no, b.name from user_pay a left join user_personal b on a.username=b.username ";

        if ($ActiveUserShownStatus == '1') {
            $searchQuery .= "and (a.pay_status = '1' or a.pay_status = '0')";
        } else {
            $searchQuery .= "and a.pay_status = '1'";
        }
        $searchQuery .= "and b.isDeleted ='0' order by b.name";
        $query .= " where $searchQuery";

        $result = DB::select($query);
        return $result;
    }

    public function getUnMappedEmployees(Request $request)
    {
        $query = 'select username, name from user_personal where (username like "' . $request->keyword . '%" or name like "' . $request->keyword . '%") and username not in (select employee_id from map_employee_approver)and isDeleted = "0"';

        $result = DB::select($query);
        return $result;
    }

    public function getEmployeesList(Request $request)
    {
        $query = 'select username, name from user_personal where  isDeleted = "0"';

        $result = DB::select($query);
        //   dd($result);
        return $result;
    }

    public function getAllUsers($sorting = '')
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $user = User::where('id', Auth::id())->first();

        $query = "select distinct b.name, b.employee_no, a.username from users a ";
        $query .= "left join user_personal b on a.username=b.username left join user_pay up on a.username=up.username";


        $query .= " where a.isDeleted ='0' and  a.company_id='" . $user->company_id . "'";
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
        } else {
            $query .= "and up.pay_status = '1'";
        }
        if ($sorting == "name") {
            $query .= " order by b.name + 0,b.name";
        } else {
            $query .= " order by b.employee_no + 0,b.employee_no";
        }

        $result = DB::select($query);
        $this->natsort2d($result);
        return $result;
    }
    public function mapEmplyoyee(Request $request)
    {
        $employeeId = $request->employee_id;
        $approverId = $request->approver_id;
        $approver_index = $request->approver_index;

        $result = $this->mapEmployee11($employeeId, $approverId, $approver_index);
        return $result;
    }
    public function mapEmployee11($employeeId, $approvedId, $approver_index = '')
    {
        //$getLeaveMultipleApprover1=DB::table('settings')->where('field','leave_multiple_approver')->first();

        $query = "insert into map_employee_approver(employee_id, approver_id, approver_index) values ('$employeeId', '$approvedId', '$approver_index')";

        $builder = DB::select($query);
        return true;
    }

    public function removeEmployeeMapping($employeeId)
    {
        $query = "delete from map_employee_approver where employee_id='$employeeId'";
        $builder = DB::select($query);

        return $builder;
    }

    public function getMapBackupUserListForEmp(Request $request)
    {
        $query = "select distinct a.user_id as username, b.name, b.email_id from map_employee_backupuser a left join user_personal b ";
        $query .= "on a.user_id=b.username where a.employee_id='$request->employeeId'";

        $result = DB::select($query);
        return $result;
    }

    public function removeBackupUserMappingByEmployee(Request $request)
    {
        $query = "delete from map_employee_backupuser where employee_id='$request->employeeId'";
        $builder = DB::select($query);
        return true;
    }

    public function map_backup_users(Request $request)
    {
        $query = "insert into map_employee_backupuser(employee_id, user_id) values ('$request->employeeId', '$request->user_id')";
        $builder = DB::select($query);
        return true;
    }

    public function mapMultipleEmployeemanager(Request $request)
    {
        $employeeId = $request->employee_id ?? "";
        $managerId = $request->manager_id ?? "";
        $this->removeManagerMapping($managerId);
        if (is_array($employeeId)) {
            for ($i = 0; $i < count($employeeId); $i++) {
                $this->deleteemployeeifexist($employeeId[$i]);
                $result = $this->mapEmployeemanager($employeeId[$i], $managerId);
            }
        }
        return true;
    }

    public function removeManagerMapping($approverId)
    {
        $query = "delete from map_employee_manager where manager_id='$approverId'";
        $builder = DB::select($query);
        return $builder;
    }

    public function deleteemployeeifexist($emp_id)
    {
        $query = "delete from map_employee_manager where employee_id='$emp_id'";
        $builder = DB::select($query);
        return $builder;
    }

    public function mapEmployeemanager($employeeId, $approvedId)
    {
        $query = "insert into map_employee_manager(employee_id, manager_id) values ('$employeeId', '$approvedId')";
        $builder = DB::select($query);
        return $builder;
    }

    public function mapEmplyoyeemanager(Request $request)
    {
        $employeeId = $request->employee_id;
        $managerId = $request->manager_id;

        $result = $this->mapEmployeemanager($employeeId, $managerId);
        return $result;
    }

    public function getEmployeesUnderManager(Request $request)
    {
        $approverId = $request->approver_id;
        $query = "select distinct a.employee_id as username, b.name from map_employee_manager a left join user_personal b ";
        $query .= "on a.employee_id=b.username where a.manager_id='$approverId'";

        $result = DB::select($query);
        return $result;
    }

    public function getUserList(Request $request)
    {
        $dtable = $request->dtable ?? "";
        $name = ($request->name ? $request->name : "");
        $empNo = ($request->employee_no ? $request->employee_no : "");
        $branchId = ($request->branch_id ? $request->branch_id : "");
        $categoryId = ($request->category_id ? $request->category_id : "");
        $departmentId = ($request->department_id ? $request->department_id : "");
        $leave_entitle_category = ($request->leave_entitle_category ? $request->leave_entitle_category : "");
        $pay_status = ($request->pay_status ? $request->pay_status : "");
        $rest_day_group = ($request->rest_day_group ? $request->rest_day_group : "");
        $role = ($request->role ? $request->role : "");

        $keyword = $request->keyword;

        $list = $this->getUserList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category, $request->pay_status ?? '', $rest_day_group, $role);
        if ($dtable != '') {
            return DataTables::of($list)->make(true);
        } else {
            return $list;
        }
    }

    public function downloaduserPDF(Request $request)
    {
        $name = ($request->name ? $request->name : "");
        $empNo = ($request->employee_no ? $request->employee_no : "");
        $branchId = ($request->branch_id ? $request->branch_id : "");
        $categoryId = ($request->category_id ? $request->category_id : "");
        $departmentId = ($request->department_id ? $request->department_id : "");
        $leave_entitle_category = ($request->leave_entitle_category ? $request->leave_entitle_category : "");
        $pay_status = ($request->pay_status ? $request->pay_status : "");
        $rest_day_group = ($request->rest_day_group ? $request->rest_day_group : "");
        $role = ($request->role ? $request->role : "");

        $keyword = $request->keyword;

        $userlist = $this->getUserList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category,  $request->pay_status ?? '', $rest_day_group, $role);


        $html = view('approvals.export.userpdf', compact('userlist'))->render();
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('User List');
        return 1;
    }

    public function userexport(Request $request)
    {
        $name = ($request->name ? $request->name : "");
        $empNo = ($request->employee_no ? $request->employee_no : "");
        $branchId = ($request->branch_id ? $request->branch_id : "");
        $categoryId = ($request->category_id ? $request->category_id : "");
        $departmentId = ($request->department_id ? $request->department_id : "");
        $leave_entitle_category = ($request->leave_entitle_category ? $request->leave_entitle_category : "");
        $pay_status = ($request->pay_status ? $request->pay_status : "");
        $rest_day_group = ($request->rest_day_group ? $request->rest_day_group : "");
        $role = ($request->role ? $request->role : "");

        $keyword = $request->keyword;

        $userlist = $this->getUserList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category,  $request->pay_status ?? '', $rest_day_group, $role);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'User List');
        $sheet->setCellValue('A' . 2, 'Username');
        $sheet->setCellValue('B' . 2, 'Name');
        $sheet->setCellValue('C' . 2, 'Email');
        $sheet->setCellValue('D' . 2, 'Commence');
        $sheet->setCellValue('E' . 2, 'Confirmed');
        $sheet->setCellValue('F' . 2, 'Role');
        $sheet->setCellValue('G' . 2, 'Department');
        $sheet->setCellValue('H' . 2, 'Branch');
        $sheet->setCellValue('I' . 2, 'Category');
        $sheet->setCellValue('J' . 2, 'Leave Category');
        $sheet->setCellValue('K' . 2, 'Rest Day');
        $sheet->setCellValue('L' . 2, 'Pay Status');

        $rows = 3;

        foreach ($userlist as $user) {
            if ($user->date_commence != '00/00/0000') {
                $commence = $user->date_commence;
            } else {
                $commence = '';
            }
            if ($user->date_confirmed != '00/00/0000') {
                $confirmed = $user->date_confirmed;
            } else {
                $confirmed = '';
            }
            if ($user->active == 1) {
                $status = 'Active';
            } else {
                $status = 'Inactive';
            }
            $sheet->setCellValue('A' . $rows, $user->username);
            $sheet->setCellValue('B' . $rows, $user->name);
            $sheet->setCellValue('C' . $rows, $user->email_id);
            $sheet->setCellValue('D' . $rows, $commence);
            $sheet->setCellValue('E' . $rows, $confirmed);
            $sheet->setCellValue('F' . $rows, $user->role);
            $sheet->setCellValue('G' . $rows, $user->department);
            $sheet->setCellValue('H' . $rows, $user->branch);
            $sheet->setCellValue('I' . $rows, $user->category);
            $sheet->setCellValue('J' . $rows, $user->category_mapping);
            $sheet->setCellValue('K' . $rows, $user->rest_day_group);
            $sheet->setCellValue('L' . $rows, $status);
            $rows++;
        }


        $fileName = "user_list.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function getUserList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category, $pay_status, $rest_day_group, $role)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $user = User::where('id', Auth::id())->first();
        $permission_val1 = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->where('a.employee_id', $user->username)->selectRaw('b.hr, b.hr_leave_edit')->first();
        $permission_val = $permission_val1->hr;

        $approverId = $user->username;

        $approver_query = "select distinct b.username from map_employee_approver a left join user_personal b on ";
        $approver_query .= "a.employee_id=b.username where a.approver_id='" . $approverId . "'";

        $approver_array = DB::select($approver_query);

        $approver_str = "";
        for ($i = 0; $i < count($approver_array); $i++) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ", ";
            }
        }

        $query = "select a.username, a.employee_no, a.name, a.email_id, a.employee_code, DATE_FORMAT(b.date_commence, '%d/%m/%Y') as date_commence,b.date_commence as join_date, b.pay_status as active, c.name as branch, d.name as category, e.name as department, ";
        $query .= "a.state, a.phone_no, g.group_name as role, ";
        $query .= "cname.name as category_mapping, rdc.category as rest_day_group, DATE_FORMAT(b.date_confirmed, '%d/%m/%Y') as date_confirmed ";
        $query .= "from user_personal a left join user_pay b on a.username=b.username left join branch c ";
        $query .= "on b.branch_id=c.id left join category d on b.category_id=d.id left join department e on b.department_id=e.id ";
        $query .= "left join map_employee_permission f on a.username=f.employee_id left join permission_group g on g.id=f.permission_group_id ";
        $query .= "left join user_category uc on uc.username=a.username left join rest_day_category_employee rdce on rdce.employee_id=a.username ";
        $query .= "left join rest_day_category rdc on rdc.id=rdce.category_id left join category_name cname on cname.id = uc.category ";
        $query .= "where a.username != '' and a.isDeleted='0' ";
        if ($keyword != "") {
            $query .= 'and (a.employee_no like "' . $keyword . '%" or a.name like "' . $keyword . '%") ';
        }

        if ($permission_val == 4) {
            $query .= " and b.username in (" . $approver_str . ")";
        }

        if ($ActiveUserShownStatus == '1') {

            $query .= "and (b.pay_status = '1' or b.pay_status = '0')";
        } else {
            $query .= "and b.pay_status = '1'";
        }
        if ($name != '') {
            $query .= 'and (a.employee_no like "' . $name . '%" or a.name like "' . $name . '%") ';
        }
        if ($empNo != '') {
            $query .= "and a.employee_no = '$empNo'";
        }
        if ($branchId != '') {
            $query .= "and b.branch_id = '$branchId'";
        }
        if ($categoryId != '') {
            $query .= "and b.category_id = '$categoryId'";
        }
        if ($departmentId != '') {
            $query .= "and b.department_id = '$departmentId'";
        }
        if ($pay_status != '') {
            $query .= "and b.pay_status = '$pay_status'";
        }
        if ($leave_entitle_category != '') {
            $query .= "and uc.category = '$leave_entitle_category'";
        }
        if ($rest_day_group != '') {
            $query .= "and rdc.id = '$rest_day_group'";
        }
        if ($role != '') {
            $query .= "and g.id = '$role'";
        }
        $query .= "order by a.name+0,a.name";
        $builder = DB::select($query);
        return $builder;
    }

    public function natsort2d(&$aryInput)
    {
        $aryTemp = $aryOut = array();
        foreach ($aryInput as $key => $value) {
            reset($value);
            $aryTemp[] = current($value);
        }
        natsort($aryTemp);
        foreach ($aryTemp as $key => $value) {
            $aryOut[] = $aryInput[$key];
            // --------^^^^ add this if you want your keys preserved!
        }
        $aryInput = $aryOut;
    }



    public function filterByStatus($status)
    {
        $query = "select distinct b.name, b.employee_no, a.username from users a ";
        $query .= "left join user_personal b on a.username=b.username where a.status='$status' and a.isDeleted='0' order by b.name";

        $result = DB::select($query);

        return $result;
    }

    public function approveredit()
    {
        $deleteBtnShowSetting1 = DB::table('settings')->where('field', 'admindeletebutton')->first();
        $deleteBtnShowSetting = $deleteBtnShowSetting1->value ?? 0;
        return view('hr.setup.approver_edit', compact('deleteBtnShowSetting'));
    }

    public function getApproverEmployeeList(Request $request)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $query = "select distinct a.approver_id, b.name, d.name as department, e.name as category, f.name as branch, '' as employees from map_employee_approver a left join user_personal b ";
        $query .= "on a.approver_id=b.username left join user_pay c on a.approver_id=c.username left join department d on c.department_id=d.id left join category e on c.category_id=e.id left join branch f on c.branch_id=f.id  where b.isDeleted = '0' ";

        $username = $request->username ?? "";

        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }

        $approvers = DB::select($query);

        for ($i = 0; $i < count($approvers); $i++) {
            $query = "select distinct a.employee_id, b.name from map_employee_approver a left join user_personal b ";
            $query .= "on a.employee_id=b.username  left join user_pay up on b.username=up.username";

            $query .= " where a.approver_id='" . $approvers[$i]->approver_id . "' ";

            if ($ActiveUserShownStatus == '1') {
                $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
            } else {
                $query .= "and up.pay_status = '1'";
            }
            $query .= "and b.isDeleted ='0'";
            $employees = DB::select($query);

            $approvers[$i]->employees = $employees;
        }
        $updated_approvers = array();
        if ($username != '') {
            $new_i = 0;
            for ($a = 0; $a < count($approvers); $a++) {
                $allow = false;
                if (stripos($approvers[$a]->name, $username) !== false) {
                    $allow = true;
                }
                $employees = $approvers[$a]->employees;
                for ($j = 0; $j < count($employees); $j++) {
                    $employees_n[$j] = $employees[$j];
                    if (stripos($employees[$j]->name, $username) !== false) {
                        $allow = true;
                    }
                }

                if ($allow) {
                    $updated_approvers[$new_i] = $approvers[$a];
                    $new_i++;
                }
            }
        } else {
            $updated_approvers = $approvers;
        }
        // return $updated_approvers;
        return DataTables::of($updated_approvers)->make(true);
    }

    public function getAllManagerNConnectedUsers(Request $request)
    {
        $username = $request->username ?? "";
        $query = "select distinct b.name, b.employee_no, a.username, d.name as branch, f.name as department, e.name as category, ";
        $query .= "(select distinct GROUP_CONCAT(CONCAT(UCASE(LEFT(up.name,1)),LCASE(SUBSTRING(up.name,2))) SEPARATOR ', ') from map_employee_manager mem left join user_personal up on mem.employee_id=up.username where mem.manager_id=b.username) as employees,  ";
        $query .= "(select distinct GROUP_CONCAT(up1.username SEPARATOR ',') from map_employee_manager mem1 left join user_personal up1 on mem1.employee_id=up1.username where mem1.manager_id=b.username) as employe_ids ";
        $query .= "from users a ";
        $query .= "left join user_personal b on a.username=b.username ";
        $query .= "left join user_pay c on a.username=c.username left join branch d on c.branch_id=d.id ";
        $query .= "left join category e on c.category_id=e.id left join department f on c.department_id=f.id ";
        $query .= "where a.status='2' and a.isDeleted='0' HAVING employees!='' ";
        if ($username != "") {
            $query .= 'and (employees LIKE "%' . $username . '%" or b.name like "%' . $username . '%")';
        }
        $builder = DB::select($query);
        return DataTables::of($builder)->make(true);
    }

    public function geteclaimmappingdata($username)
    {
        $query = "select distinct b.name, b.employee_no, a.username, d.name as branch, f.name as department, e.name as category, ";
        $query .= "(select distinct GROUP_CONCAT(CONCAT(UCASE(LEFT(up.name,1)),LCASE(SUBSTRING(up.name,2))) SEPARATOR ', ') from map_employee_manager mem left join user_personal up on mem.employee_id=up.username where mem.manager_id=b.username) as employees,  ";
        $query .= "(select distinct GROUP_CONCAT(up1.username SEPARATOR ',') from map_employee_manager mem1 left join user_personal up1 on mem1.employee_id=up1.username where mem1.manager_id=b.username) as employe_ids ";
        $query .= "from users a ";
        $query .= "left join user_personal b on a.username=b.username ";
        $query .= "left join user_pay c on a.username=c.username left join branch d on c.branch_id=d.id ";
        $query .= "left join category e on c.category_id=e.id left join department f on c.department_id=f.id ";
        $query .= "where a.status='2' and a.isDeleted='0' HAVING employees!='' ";
        if ($username != "") {
            $query .= " and a.username ='$username'";
        }
        $builder = DB::select($query);
        $builder['employees'] = $this->getGroupedUsers(request());
        $builder['manager'] = $this->getManagers(request());
        return $builder;
    }

    public function employeeapprovermapping($username)
    {

        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $query = "select distinct a.approver_id, b.name, d.name as department, e.name as category, f.name as branch, '' as employees from map_employee_approver a left join user_personal b ";
        $query .= "on a.approver_id=b.username left join user_pay c on a.approver_id=c.username left join department d on c.department_id=d.id left join category e on c.category_id=e.id left join branch f on c.branch_id=f.id  where b.isDeleted = '0' ";
        $query .= " and a.approver_id ='$username'";

        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }

        $approvers = DB::select($query);

        for ($i = 0; $i < count($approvers); $i++) {
            $query = "select distinct a.employee_id, b.name from map_employee_approver a left join user_personal b ";
            $query .= "on a.employee_id=b.username left join user_pay up on b.username=up.username";

            $query .= " where a.approver_id='" . $approvers[$i]->approver_id . "' ";

            if ($ActiveUserShownStatus == '1') {
                $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
            } else {
                $query .= "and up.pay_status = '1'";
            }
            $query .= "and b.isDeleted ='0'";
            $employees = DB::select($query);

            $approvers[$i]->employees = $employees;
        }
        $updated_approvers = array();

        $updated_approvers = $approvers;

        $approvers['emp11'] = array();
        foreach ($approvers[0]->employees as $emp) {
            array_push($approvers['emp11'], $emp->name);
        }

        $updated_approvers['emp'] = implode(",", $approvers['emp11']);
        $updated_approvers['employees'] = $this->getGroupedUsers(request());
        $updated_approvers['approver'] = $this->getApprovers(request());

        return $updated_approvers;
    }

    public function eremoveManagerMapping(Request $request)
    {
        $managerId = $request->manager_id;
        $result = $this->removeManagerMapping($managerId);
        return $result;
    }

    public function updateManagerMapping(Request $request)
    {

        $old_manager_id = $request->old_manager_id;
        $managerId = $request->manager_id;
        $employeeId = $request->employee_id;

        if ($old_manager_id != $managerId) {
            $this->removeManagerMapping($old_manager_id);
        }

        $this->removeManagerMapping($managerId);
        if (is_array($employeeId)) {
            for ($i = 0; $i < count($employeeId); $i++) {
                $this->deleteemployeeifexist($employeeId[$i]);
                $result = $this->mapEmployeemanager($employeeId[$i], $managerId);
            }
        }
        return true;
    }

    public function editApproverMapping(Request $request)
    {
        $oldApproverId = $request->old_approver_id;
        $approverId = $request->approver_id;
        $employeeIds = explode(",", $request->employee_ids);

        $this->removeApproverMapping($oldApproverId);
        $this->removeApproverMapping($approverId);;
        for ($i = 0; $i < count($employeeIds); $i++) {

            $this->mapEmployee11($employeeIds[$i], $approverId);
        }
    }

    public function eremoveApproverMapping(Request $request)
    {
        $employeeId = $request->employee_id;
        $result = $this->removeApproverMapping($employeeId);
        return $result;
    }

    public function removeApproverMapping($approverId)
    {
        $query = "delete from map_employee_approver where approver_id='$approverId'";
        $builder = DB::select($query);
        return $builder;
    }


    public function getemployeelist()
    {

        $result = DB::table('user_personals as a')
            ->leftjoin('user_pay as b', 'a.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'a.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'g.id', '=', 'f.permission_group_id')
            ->leftjoin('user_category as uc', 'uc.username', '=', 'a.username')
            ->leftjoin('rest_day_category_employee as rdce', 'rdce.employee_id', '=', 'a.username')
            ->leftjoin('rest_day_category as rdc', 'rdc.id', '=', 'rdce.category_id')
            ->where('a.isDeleted', '!=', '0')
            ->orderByRaw("a.name+0,a.name")
            ->get();
        return DataTables::of($result)->make(true);
    }

    public function claimrate()
    {
        $eclaimtypes = DB::table('eclaimtype')->selectRaw("id,type_name,DATE_FORMAT(from_unixtime(created),'%b %d %Y %h:%i %p') as created,DATE_FORMAT(from_unixtime(modified),'%b %d %Y %h:%i %p') as modified")->get();

        $user = User::where('id', Auth::id())->first();
        $categorynames = DB::table('category_name')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();


        return view('hr.setup.claim_rate', compact('eclaimtypes', 'categorynames'));
    }

    public function getclaimrate(Request $request)
    {

        if ($request->get('rate_type') != '') {
            $eclaimrates = DB::table('eclaimrate as cr')->leftjoin('eclaimtype as et', 'cr.eclaimtype_id', '=', 'et.id')->leftjoin('category_name as cn', 'cr.category_id', '=', 'cn.id')->where('cr.rate_type', $request->get('rate_type'))->selectRaw("cn.id, cr.eclaimtype_id, cr.rate, et.type_name,cn.name")->get();
        } else {
            $eclaimrates = DB::table('eclaimrate as cr')->leftjoin('eclaimtype as et', 'cr.eclaimtype_id', '=', 'et.id')->leftjoin('category_name as cn', 'cr.category_id', '=', 'cn.id')->where('cr.rate_type', 0)->selectRaw("cn.id, cr.id as rate_id, cr.eclaimtype_id, cr.rate, et.type_name,cn.name")->get();
        }

        return $eclaimrates;
    }

    public function setclaimrate(Request $request)
    {
        $rate_type = $request->get('rate_type');
        $claimrate_json = json_decode(stripslashes($request->get('claimrate_json')));
        for ($i = 0; $i < count($claimrate_json); $i++) {
            $category = $claimrate_json[$i]->category;
            $claimType = $claimrate_json[$i]->claimType;
            $noRate = $claimrate_json[$i]->noRate;

            $erate = ClaimRate::where('category_id', $category)->where('eclaimtype_id', $claimType)->where('rate_type', $rate_type)->first();
            if (empty($erate)) {
                $nerate = new ClaimRate;
                $nerate->category_id = $category;
                $nerate->eclaimtype_id = $claimType;
                $nerate->rate_type = $rate_type;
                $nerate->rate = $noRate;
                $nerate->save();
            } else {
                $erate->rate = $noRate;
                $erate->save();
            }
        }
        return true;
    }

    public function blockdates()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('hr.setup.block_dates', compact('userPay'));
    }

    public function getRestDayCategories()
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, category from rest_day_category where company_id='" . $user->company_id . "'";
        $result = DB::select($query);

        for ($i = 0; $i < count($result); $i++) {
            $query = "select id from rest_day_category_employee where category_id='" . $result[$i]->id . "'";
            $builder = DB::select($query);
            if ($builder != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return $result;
    }

    public function getRestDayCategoriesdatatable()
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, category from rest_day_category where company_id='" . $user->company_id . "'";

        $result = DB::select($query);

        for ($i = 0; $i < count($result); $i++) {
            $builder = DB::table('rest_day_category_employee')->where('category_id', $result[$i]->id)->selectRaw("id")->first();

            if (!empty($builder)) {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return $result;
    }

    public function getCategoryMappingForApprover()
    {
        $user = User::where('id', Auth::id())->first();
        $categories = $this->getRestDayCategories();


        for ($i = 0; $i < count($categories); $i++) {
            $categoryId = $categories[$i]->id;

            $employees = $this->getCategoryEmployees($categoryId, $user->username);

            $categories[$i]->employees = $employees;
            if (count($employees) > 0) {
                $categories[$i]->display_allow = true;
            } else {
                $categories[$i]->display_allow = false;
            }
        }

        return $categories;
    }

    public function getCategoryEmployees($categoryId, $employeeId)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $query = " select distinct mep.employee_id as mep_ei, a.id, a.employee_id, b.name, b.employee_no from rest_day_category_employee a left join ";
        $query .= "user_personal b on a.employee_id=b.username ";
        $query .= "left join map_employee_approver mep on a.employee_id = mep.employee_id left join user_pay up on b.username=up.username";


        $query .= "  where a.category_id='" . $categoryId . "' and mep.approver_id='" . $employeeId . "' ";
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
        } else {
            $query .= "and up.pay_status = '1'";
        }
        $builder = DB::select($query);

        return $builder;
    }

    public function deleteMappingByCategoryUser(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $categoryId = $request->category_id;
        $result = $this->getCategoryEmployees($categoryId, $user->username);
        $this->deleteRestDayByCategoryOrEmp($categoryId, 'cat');
        for ($i = 0; $i < count($result); $i++) {
            $id = $result[$i]['id'];
            $this->removeMappingById($id);
        }
    }

    public function deleteRestDayByCategoryOrEmp($id, $type = 'emp')
    {
        if ($type == 'emp') {
            $s_query = "select id from rest_days where employee_id='" . $id . "' and is_employee='1'";
        } else {
            $s_query = "select id from rest_days where category_id='" . $id . "' and is_employee='0'";
        }

        $s_result = DB::select($s_query);

        for ($i = 0; $i < count($s_result); $i++) {
            $rest_day_id = $s_result[$i]->id;

            $query = "delete from rest_dates where rest_day_id='" . $rest_day_id . "'";
            $builder = DB::select($query);

            $query = "delete from rest_days where id='" . $rest_day_id . "'";
            $result = DB::select($query);
        }

        return true;
    }

    public function removeMappingById($id)
    {
        $query = "delete from rest_day_category_employee where id='" . $id . "'";
        $result = DB::select($query);
        return $result;
    }

    public function deleteRestDayCategory(Request $request)
    {
        $query = "delete from rest_day_category where id='" . $request->id . "'";
        $builder = DB::select($query);


        $query = "delete from rest_day_category_employee where category_id='" . $request->id . "'";
        $builder = DB::select($query);

        $query = "select id from rest_days where category_id='" . $request->id . "'";
        $result_ARR = DB::select($query);
        foreach ($result_ARR as $row) {
            $query = "delete from rest_dates where rest_day_id='" . $row->id . "'";
            $builder = DB::select($query);
        }

        $query = "delete from rest_days where category_id='" . $request->id . "'";
        $builder = DB::select($query);

        return TRUE;
    }

    public function getEmployeesUnderApprover(Request $request)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $user = User::where('id', Auth::id())->first();
        if ($request->approver_id) {
            $approverid = $request->approver_id;
        } else {
            $approverid = $user->username;
        }
        
        //dd($approverid);

        $query = "select distinct a.employee_id as username, b.name from map_employee_approver a left join user_personal b ";
        $query .= "on a.employee_id=b.username left join user_pay up on b.username=up.username";


        $query .= " where a.approver_id='$approverid' ";
        if ($request->keyword != '') {
            $query .= ' and (b.name like "' . $request->keyword . '%" or b.employee_no like "' . $request->keyword . '%")';
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
        } else {
            $query .= "and up.pay_status = '1'";
        }
        $query .= " and b.isDeleted = '0' order by b.name";

        $result = DB::select($query);
        return $result;
    }

    public function getcategoryList()
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, name, description, email from category where company_id='" . $user->company_id . "' GROUP BY category.name";
        $builder = DB::select($query);
        return $builder;
    }

    public function getbranchList()
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, name, state, description, logo, email from branch where company_id='" . $user->company_id . "' GROUP BY branch.name,branch.id";

        $builder = DB::select($query);
        return $builder;
    }

    public function getdepartmentList()
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, name, description, email from department where company_id='" . $user->company_id . "' GROUP BY department.name";

        $builder = DB::select($query);
        return $builder;
    }

    public function EmployeAddedList()
    {
        $query = "select DISTINCT u.username as `username`,b.name as `name`  from block_dates bd ";
        $query .= " left join users u on u.username=bd.block_id ";
        $query .= " left join user_personal b on u.username=b.username ";
        $query .= " where is_user=1";
        $builder = DB::select($query);
        return $builder;
    }

    public function CategoryAddedList()
    {
        $query = "select DISTINCT c.name, c.id from block_dates bd ";
        $query .= " left join category c on bd.block_id = c.id ";
        $query .= " where is_category=1";
        $builder = DB::select($query);
        return $builder;
    }

    public function DepartmentAddedList()
    {
        $query = "select DISTINCT d.name,d.id from block_dates bd ";
        $query .= " left join department d on bd.block_id = d.id ";
        $query .= " where is_department=1";
        $builder = DB::select($query);
        return $builder;
    }

    public function BranchAddedList()
    {
        $query = "select DISTINCT b.name,b.id from block_dates bd ";
        $query .= " left join branch b on bd.block_id = b.id ";
        $query .= " where is_branch=1";
        $builder = DB::select($query);
        return $builder;
    }

    public function getBlockdaysList(Request $request)
    {
        $block_id = $request->block_id;
        $for = $request->for;
        $query = "select block_date as date  from block_dates ";
        $query .= " where block_id='$block_id' ";

        switch ($for) {
            case 'emp':
                $query .= " and is_user=1 ";
                break;
            case 'cat':
                $query .= " and is_category=1 ";
                break;
            case 'dep':
                $query .= " and is_department=1 ";
                break;
            case 'branch':
                $query .= " and is_branch=1 ";
                break;
        }

        $builder = DB::select($query);
        return $builder;
    }

    public function getCategoryRestDays(Request $request)
    {
        $categoryId = $request->category_id;
        $query = "select a.rest_day_id, a.date from rest_dates a left join rest_days b on b.id=a.rest_day_id ";
        $query .= "where b.category_id='$categoryId'";

        $result = DB::select($query);
        return $result;
    }

    public function getEmployeeRestDays(Request $request)
    {
        $employeeId = $request->employee_id;
        $query = "select employee_id from rest_days where employee_id='$employeeId'";
        $result = DB::select($query);
        return $result;
    }

    public function addBlockdays(Request $request)
    {

        $blockdays_for = $request->blockdays_for;
        switch ($blockdays_for) {
            case 'emp':
                $is_user = 1;
                $is_category = 0;
                $is_department = 0;
                $is_branch = 0;
                break;
            case 'cat':
                $is_user = 0;
                $is_category = 1;
                $is_department = 0;
                $is_branch = 0;
                break;
            case 'dep':
                $is_user = 0;
                $is_category = 0;
                $is_department = 1;
                $is_branch = 0;
                break;
            case 'branch':
                $is_user = 0;
                $is_category = 0;
                $is_department = 0;
                $is_branch = 1;
                break;
        }

        $block_id = $request->block_id;
        $created = time();
        $dates = explode(",", $request->dates);

        for ($i = 0; $i < count($dates); $i++) {
            $this->addBlockDays11(date('Y-m-d', strtotime($dates[$i])), $block_id, $is_user, $is_category, $is_department, $is_branch, $created);
        }
        return true;
    }

    public function updateBlockdays(Request $request)
    {
        $blockdays_for = $request->blockdays_for;
        switch ($blockdays_for) {
            case 'emp':
                $is_user = 1;
                $is_category = 0;
                $is_department = 0;
                $is_branch = 0;
                break;
            case 'cat':
                $is_user = 0;
                $is_category = 1;
                $is_department = 0;
                $is_branch = 0;
                break;
            case 'dep':
                $is_user = 0;
                $is_category = 0;
                $is_department = 1;
                $is_branch = 0;
                break;
            case 'branch':
                $is_user = 0;
                $is_category = 0;
                $is_department = 0;
                $is_branch = 1;
                break;
        }

        $block_id = $request->block_id;
        $created = time();
        $dates = explode(",", $request->dates);
        $this->deleteBlockDaysForBlockId($block_id, $is_user, $is_category, $is_department, $is_branch);
        for ($i = 0; $i < count($dates); $i++) {
            $this->addBlockDays11(date('Y-m-d', strtotime($dates[$i])), $block_id, $is_user, $is_category, $is_department, $is_branch, $created);
        }
        return true;
    }

    public function updateRestDays(Request $request)
    {
        $restDayId = $request->rest_day_id;
        $isEmployee = $request->is_employee;
        $employeeId = $request->employee_id;
        $categoryId = $request->category_id;
        $description = $request->description;
        $dates = explode(",", $request->dates);
        if ($isEmployee) {
            $this->deleteRestDayByCategoryOrEmp($employeeId, 'emp');
        } else {
            $this->deleteRestDayByCategoryOrEmp($categoryId, 'cat');
        }

        $user = User::where('id', Auth::id())->first();
        $employeeId = ($request->employee_id && $request->employee_id != 0) ? $request->employee_id : $user->username;

        $restDayId = $this->addRestDay11($isEmployee, $employeeId, $categoryId, $description);

        for ($i = 0; $i < count($dates); $i++) {
            $this->addRestDate($restDayId, date('Y-m-d', strtotime($dates[$i])));
        }
        return true;
    }

    public function addRestDay11($isEmployee, $employeeId, $categoryId, $description)
    {
        //$employeeId=1;
        $check_query = "SELECT id FROM rest_days WHERE is_employee='$isEmployee' AND employee_id='$employeeId' AND category_id='$categoryId'";
        $check_id = DB::select($check_query);
        if (!empty($check_id)) {
            return $check_id[0]->id;
        } else {
            $query = "insert into rest_days (is_employee, employee_id, category_id, description) ";
            $query .= "values ('$isEmployee', '$employeeId', '$categoryId', '$description')";
            $builder = DB::select($query);


            $query = "select max(id) as id from rest_days";
            $builder = DB::select($query);

            return $builder[0]->id;
        }
    }


    public function addRestDate($restDayId, $date)
    {
        $check_id = DB::table('rest_dates')->where('rest_day_id', $restDayId)->where('date', $date)->selectRaw("id")->first();

        if (!empty($check_id)) {
            return "";
        } else {

            $result = DB::table('rest_dates')->insert(array('rest_day_id' => $restDayId, 'date' => $date));
            return $result;
        }
    }



    public function addBlockDays11($date, $block_id, $is_user, $is_category, $is_department, $is_branch, $created)
    {
        $query = "insert into block_dates (block_date, block_id, is_user, is_category, is_department, is_branch, created) ";
        $query .= "values ('$date', '$block_id', '$is_user', '$is_category', '$is_department', '$is_branch', '$created')";
        $builder = DB::select($query);
    }

    public function deleteBlockDaysForBlockId($block_id, $is_user, $is_category, $is_department, $is_branch)
    {
        $query = "delete from block_dates ";
        $query .= " where is_user='$is_user' and is_category='$is_category' and is_department='$is_department' and is_branch='$is_branch' and block_id='$block_id'";
        $builder = DB::select($query);
    }

    public function addRestDayCategory(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $category = $request->category;
      
        if ($this->isRestDayExist11($category)) {

            $query = "insert into rest_day_category (category,company_id) values ('$category','$user->company_id')";
            $build = DB::select($query);
            $result = true;
        } else {
            $result = false;
        }

        return $result;
    }

    public function isRestDayExist(Request $request)
    {
        $groupName = $request->category;
        $result = $this->isRestDayExist11($groupName);
        return $result;
    }

    public function isRestDayExist11($groupName)
    {
        $query = "SELECT id FROM rest_day_category WHERE category='$groupName'";

        $id = DB::select($query);
        if ($id != "") {
            $result = "false";
        } else {
            $result = "true";
        }
        return $result;
    }

    public function mapCategoryEmployee(Request $request)
    {
        $categoryId = $request->category_id;
        $employeeIds = explode(",", $request->employee_ids);

        for ($i = 0; $i < count($employeeIds); $i++) {
            $dquery = "delete from rest_day_category_employee where employee_id='$employeeIds[$i]'";
            $dlt = DB::select($dquery);
            $query = "insert into rest_day_category_employee (category_id, employee_id) values ('$categoryId', '$employeeIds[$i]')";
            $result = DB::select($query);
            // return true;
        }
        return true;
    }

    public function mapEmployeeToCategory(Request $request)
    {
        $categoryId = $request->category_id;
        $employeeId = $request->employee_id;
        $query = "delete from rest_day_category_employee where employee_id='$employeeId'";
        DB::select($query);
        $result = $this->mapCategoryEmployee11($categoryId, $employeeId);
        return $result;
    }

    public function mapCategoryEmployee11($categoryId, $employeeId)
    {
        $query = "delete from rest_day_category_employee where employee_id='$employeeId'";
        DB::select($query);
        $query = "insert into rest_day_category_employee (category_id, employee_id) values ('$categoryId', '$employeeId')";
        $result = DB::select($query);
        return true;
    }

    public function removeEmployeeMapping11(Request $request)
    {
        $query = "delete from map_employee_approver where employee_id='$request->approver_id'";
        DB::select($query);
        return true;
    }

    public function mapEmplyoyeeS(Request $request)
    {
        $employeeId = $request->employee_id;
        $approverId = $request->approver_id;
        $approver_index = $request->approver_index;
        $getLeaveMultipleApprover1 = DB::table('settings')->where('field', 'approver_setting_any_all')->first();
        if (!empty($getLeaveMultipleApprover1)) {
            $val = $getLeaveMultipleApprover1->value ?? 0;
        } else {
            $val = null;
        }
        $getLeaveMultipleApprover = intval($val);

        if ($getLeaveMultipleApprover == 0) {
            $this->removeEmployeeMapping($employeeId);
        }
        for ($i = 0; $i < count($approverId); $i++) {
            $result = $this->mapEmployee11($employeeId, $approverId[$i], $approver_index[$i]);
        }
        return $result;
    }

    public function editleave(Request $request)
    {
        $this->saveAudit($request);
        
        $user = User::where('id', Auth::id())->first();
        $leaveId = $request->get('leave_id');
        $id = $request->get('id');
        $username = $request->get('employee_id');
        $approverId = (isset($request->approver_id) ? $request->approver_id : $user->username);
        $type = $request->get('type');
        $isHalfDay = $request->get('is_half_day');
        $startTime = $request->get('start_time') ?? "";
        $endTime = $request->get('end_time') ?? "";
        //$year = date('Y', strtotime($_POST["start_date"]));
        //$startDate = date('Y-m-d', strtotime($_POST["start_date"]));
        //$endDate = date('Y-m-d', strtotime($_POST["end_date"]));
        $startDate = $request->get('start_date');
        $endDate = $request->get('end_date');
        $year = '';

        $noDays = $request->get('no_days');
        $reason = $request->get('reason');
        $status = $request->get('status');
        $isPast = $request->get('isPast');

        if ($isHalfDay == "") {
            if ($noDays == "0.5") {
                $isHalfDay = "1";
            } else {
                $isHalfDay = "0";
            }
        }

        $startDate_arr = explode("-", $startDate);
        if (count($startDate_arr) > 2) {
            $startDate = $startDate_arr[0] . "-" . $startDate_arr[1] . "-" . $startDate_arr[2];
            $year = $startDate_arr[0];
        }
        $endDate_arr = explode("-", $endDate);
        if (count($endDate_arr) > 2) {
            $endDate = $endDate_arr[0] . "-" . $endDate_arr[1] . "-" . $endDate_arr[2];
        }
        $currentLeaveDetail = $this->getLeaveDetails($id);

        if ($currentLeaveDetail[0]->type == "Other_pay" && $type != "Other_pay") {

            if ($noDays == "0.5") {
                $this->unMarkReplacementLeaveAsTaken($username, $year);
            } else {
                $this->unMarkReplacementLeaveAsTaken($username, $year);
                $this->unMarkReplacementLeaveAsTaken($username, $year);
            }
        }

        /* if leave RL Type than changing Stats as 0 as well in leave_adjustment table END */

        if ($currentLeaveDetail[0]->type != "Other_pay" && $type == "Other_pay") {
            if ($noDays == "0.5") {
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
            } else {
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
            }
        }

        $result = $this->updateLeave(
            $leaveId,
            $username,
            $approverId,
            $type,
            $isHalfDay,
            $startTime,
            $endTime,
            $startDate,
            $endDate,
            $noDays,
            $reason,
            $isPast,
            $id
        );

        $leave_detail = $this->getLeaveDetails($id);

        $id = $request->id ?? "";
        $this->setStatus($id, $status);


        if ($leave_detail[0]->leave_category != "Compulsory") {
            if ($type != 'Emergency') {
                $this->changeCategory($leave_detail[0]->leave_id, "Normal");
            } else if ($type == 'Emergency') {
                $this->changeCategory($leave_detail[0]->leave_id, "Emergency");
            }
        }

        if ($leave_detail[0]->type != "Emergency" && $leave_detail[0]->leave_category == "Emergency") {
            $this->changeCategory($leave_detail[0]->leave_id, "Normal");
        }

        if ($type == 'Annual' || $type == 'Medical' || $type == 'Other_pay') {
            $this->addLeaveEntitleHistory($username, $year, $type);
        }


        return $result;
    }
    
    // audit store
    public function saveAudit(Request $request)
    {

        $user = User::where('id', Auth::id())->first();
        $leaveId = $request->get('leave_id');
        $username = $request->get('employee_id');
        $approverId = $user->username;
        $leave_to = $request->get('type');
        $reason_to = $request->get('reason');
        $status_to = $request->get('status');
        
        $leaveData = Leavelist::where('id', $leaveId)->first();
        $leaveFrom = $leaveData->type;
        $reasonFrom = $leaveData->reason;
        $statusFrom = $leaveData->status;
        $leaveDate = $leaveData->start_date;

        $audit = new LeaveAudit;
        $audit->leave_id = $leaveId  ?? NULL;
        $audit->leave_date = $leaveDate  ?? NULL;
        $audit->admin_id = $approverId  ?? NULL;
        $audit->emp_id = $username  ?? NULL;
        $audit->leave_from = $leaveFrom  ?? NULL;
        $audit->leave_to = $leave_to  ?? NULL;
        $audit->reason_from = $reasonFrom  ?? NULL;
        $audit->reason_to = $reason_to  ?? NULL;
        $audit->status_from = $statusFrom ?? NULL;
        $audit->status_to = $status_to  ?? NULL;
        $audit->deleted_at = NULL;        
        $audit->save();        
    }

    public function editRlleave(Request $request)
    {
        $no_granted = $request->no_granted ?? '';
        $approver = $request->approver_id ?? '';
        $start_date = $request->start_date ?? '';
        $end_date = $request->end_date ?? '';
        $reason = $request->reason ?? '';
        $result =  DB::table('rl_leaves')->where('id', $request->id)->update(array('no_granted' => $no_granted, 'start_date' => $start_date, 'end_date' => $end_date, 'approver_id' => $approver, 'reason' => $reason));
        return true;
    }
    public function getYearlyLeaveGraphByLeaveType(request $request)
    {

        $user = User::where('id', Auth::id())->first();
        $leaveType = $request->get('leave_type') ?? "";
        $date = $request->get('date') ? date('Y-m-d', strtotime($request->get('date'))) : "";
        $username = $request->get('username') ? $request->get('username') : "";

        $branch_id = $request->get('branch_id') ?? "";
        $department_id = $request->get('department_id') ?? "";
        $category_id = $request->get('category_id') ?? "";
        $keyword = $request->get('keyword') ?? "";
        $year = $request->get('year') ?? "";

        $leave_color = getleavecolorarry();
        //         if ($leaveType == '') {
        // 			$leaveType = 'Annual';
        //         }

        $currentYearLeaveDisplay1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $currentYearLeaveDisplay = $currentYearLeaveDisplay1->value ?? 0;

        $result = $this->getYearlyLeaveGraphByLeaveTypedata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);

        $result1 = $this->getYearlyLeaveGraphByLeaveTypePendingdata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);

        $result2 = $this->getYearlyLeaveGraphByLeaveTypeRejecteddata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);

        $result3 = $this->getYearlyLeaveGraphByLeaveTypeRecommendeddata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);

        $result4 = $this->getYearlyLeaveGraphByLeaveTypeCancelleddata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);


        $result5 = $this->getYearlyLeaveGraphByLeaveTypeCancellationPendingdata($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, $currentYearLeaveDisplay, $year);

        $graph["leaves"] = $result;
        $graph["leaves1"] = $result1;
        $graph["leaves2"] = $result2;
        $graph["leaves3"] = $result3;
        $graph["leaves4"] = $result4;
        $graph["leaves5"] = $result5;
        $month = array('1' => 'Jan', '2' => 'Feb', '3' => 'Mar', '4' => 'Apr', '5' => 'May', '6' => 'Jun', '7' => 'Jul', '8' => 'Aug', '9' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
        $i = 0;
        $main_ARR = array();
        $main_ARR11 = array();
        $main_ARR21 = array();
        $main_ARR31 = array();
        $main_ARR41 = array();
        $main_ARR51 = array();

        $used_month = array();
        $used_month1 = array();
        $used_month2 = array();
        $used_month3 = array();
        $used_month4 = array();
        $used_month5 = array();
        foreach ($month as $mk => $mv) {
            foreach ($result as $res) {

                if ($res->month == $mk) {
                    $used_month[$mk] = $mv;

                    $main_ARR[$mk]['leaves'] = $res->leaves;
                    $main_ARR[$mk]['month'] = $month[$mk];
                }
            }

            foreach ($result1 as $res1) {

                if ($res1->month == $mk) {
                    $used_month1[$mk] = $mv;

                    $main_ARR11[$mk]['leaves'] = $res1->leaves;
                    $main_ARR11[$mk]['month'] = $month[$mk];
                }
            }

            foreach ($result2 as $res2) {

                if ($res2->month == $mk) {
                    $used_month2[$mk] = $mv;

                    $main_ARR21[$mk]['leaves'] = $res2->leaves;
                    $main_ARR21[$mk]['month'] = $month[$mk];
                }
            }

            foreach ($result3 as $res3) {

                if ($res3->month == $mk) {
                    $used_month3[$mk] = $mv;

                    $main_ARR31[$mk]['leaves'] = $res3->leaves;
                    $main_ARR31[$mk]['month'] = $month[$mk];
                }
            }

            foreach ($result4 as $res4) {

                if ($res4->month == $mk) {
                    $used_month4[$mk] = $mv;

                    $main_ARR41[$mk]['leaves'] = $res4->leaves;
                    $main_ARR41[$mk]['month'] = $month[$mk];
                }
            }

            foreach ($result5 as $res5) {

                if ($res5->month == $mk) {
                    $used_month5[$mk] = $mv;

                    $main_ARR51[$mk]['leaves'] = $res5->leaves;
                    $main_ARR51[$mk]['month'] = $month[$mk];
                }
            }
            $i++;
        }
        $j = count($main_ARR);
        $j = $j - 1;
        if ($j < 0) {
            $j = 0;
        }

        foreach ($month as $mk => $mv) {
            if (!array_key_exists($mk, $used_month)) {
                $main_ARR[$mk]['leavetype'] = '';
                $main_ARR[$mk]['leaves'] = '0';
                $main_ARR[$mk]['month'] = $month[$mk];
                $main_ARR[$mk]['color'] = '#c3c3c3';
            }
            if (!array_key_exists($mk, $used_month1)) {
                $main_ARR11[$mk]['leavetype'] = '';
                $main_ARR11[$mk]['leaves'] = '0';
                $main_ARR11[$mk]['month'] = $month[$mk];
                $main_ARR11[$mk]['color'] = '#c3c3c3';
            }
            if (!array_key_exists($mk, $used_month2)) {
                $main_ARR21[$mk]['leavetype'] = '';
                $main_ARR21[$mk]['leaves'] = '0';
                $main_ARR21[$mk]['month'] = $month[$mk];
                $main_ARR21[$mk]['color'] = '#c3c3c3';
            }
            if (!array_key_exists($mk, $used_month3)) {
                $main_ARR31[$mk]['leavetype'] = '';
                $main_ARR31[$mk]['leaves'] = '0';
                $main_ARR31[$mk]['month'] = $month[$mk];
                $main_ARR31[$mk]['color'] = '#c3c3c3';
            }

            if (!array_key_exists($mk, $used_month4)) {
                $main_ARR41[$mk]['leavetype'] = '';
                $main_ARR41[$mk]['leaves'] = '0';
                $main_ARR41[$mk]['month'] = $month[$mk];
                $main_ARR41[$mk]['color'] = '#c3c3c3';
            }
            if (!array_key_exists($mk, $used_month5)) {
                $main_ARR51[$mk]['leavetype'] = '';
                $main_ARR51[$mk]['leaves'] = '0';
                $main_ARR51[$mk]['month'] = $month[$mk];
                $main_ARR51[$mk]['color'] = '#c3c3c3';
            }
            $j++;
        }
        ksort($main_ARR);
        ksort($main_ARR11);
        ksort($main_ARR21);
        ksort($main_ARR31);
        ksort($main_ARR41);
        ksort($main_ARR51);
        $cn = 0;
        $main_ARR2 = array();
        foreach ($main_ARR as $arr) {

            $main_ARR2[$cn]['leaves'] = $arr['leaves'];
            $main_ARR2[$cn]['month'] = $arr['month'];

            $cn++;
        }

        $cn1 = 0;
        $main_ARR211 = array();
        foreach ($main_ARR11 as $arr) {

            $main_ARR211[$cn1]['leaves'] = $arr['leaves'];
            $main_ARR211[$cn1]['month'] = $arr['month'];

            $cn1++;
        }

        $cn2 = 0;
        $main_ARR212 = array();
        foreach ($main_ARR21 as $arr) {

            $main_ARR212[$cn2]['leaves'] = $arr['leaves'];
            $main_ARR212[$cn2]['month'] = $arr['month'];

            $cn2++;
        }

        $cn3 = 0;
        $main_ARR213 = array();
        foreach ($main_ARR31 as $arr) {

            $main_ARR213[$cn3]['leaves'] = $arr['leaves'];
            $main_ARR213[$cn3]['month'] = $arr['month'];

            $cn3++;
        }

        $cn4 = 0;
        $main_ARR214 = array();
        foreach ($main_ARR41 as $arr) {

            $main_ARR214[$cn4]['leaves'] = $arr['leaves'];
            $main_ARR214[$cn4]['month'] = $arr['month'];

            $cn4++;
        }

        $cn5 = 0;
        $main_ARR215 = array();
        foreach ($main_ARR51 as $arr) {

            $main_ARR215[$cn5]['leaves'] = $arr['leaves'];
            $main_ARR215[$cn5]['month'] = $arr['month'];

            $cn5++;
        }

        $graph["leaves"] = $main_ARR2;
        $graph["leaves1"] = $main_ARR211;
        $graph["leaves2"] = $main_ARR212;
        $graph["leaves3"] = $main_ARR213;
        $graph["leaves4"] = $main_ARR214;
        $graph["leaves5"] = $main_ARR215;
        return $graph;
    }

    public function getHRApproverPendingLeaveListAll(Request $request)
    {

        $user = User::where('id', Auth::id())->first();
        $categoryId = $request->get('category_id') ?? "";
        $branchId = $request->get('branch_id') ?? "";
        $departmentId = $request->get('department_id') ?? "";
        $leaveType = $request->get('leave_type') ?? "";
        $Status = $request->get('status') ?? "";
        $approvername = $request->get('approvername') ?? "";
        $date = $request->get('date') ? date('Y-m-d', strtotime($request->get('date'))) : "";
        $employeeNo = $request->get('employee_no') ?? "";
        $employeeName = $request->get('employee_name') ?? "";

        $approverId = $request->get('approver_id') ?? $user->username;

        $result = getHRApproverPendingLeaveListAll($categoryId, $branchId, $departmentId, $leaveType, $date, $employeeNo, $employeeName, $approverId, $Status, $approvername);

        foreach ($result as $item) {
            $leavetypename = DB::table('leave_name')->where('type', $item->type)->first();
            if ($item->r_name == '') {
                $rname = '';
            } else {
                $rname = $item->r_name;
            }
            if ($item->type == "npl" || $item->type == "NPL" || $item->type == "No_Pay") {
                $filename = '';
                $leavetype = "No Pay Leave";
            } else {
                $filename = $item->filename;
                $leavetype = $item->type;
            }
            if ($item->status == 0) {
                $status = 'Pending';
                $class = '#82868b';
            } elseif ($item->status == 1) {
                $status = 'Approved';
                $class = '#28c76f';
            } elseif ($item->status == 2) {
                $status = 'Rejected';
                $class = '#ea5455';
            } elseif ($item->status == 3) {
                $status = 'Recommended';
                $class = '#7367f0';
            } elseif ($item->status == 4) {
                $status = 'Cancelled';
                $class = '#00cfe8';
            } elseif ($item->status == 5) {
                $status = 'Cancellation Pending';
                $class = '#ff9f43';
            }
            $item->r_name = $rname;
            $item->ndays = $item->no_days . $item->half_day_type;
            $item->filename = $filename;
            $item->leave_type = $leavetypename->name;
            $item->leave_status = $status;
            $item->back_color = $class;
        }

        return DataTables::of($result)->make(true);
    }

    public function getBranchEmployeeCount()
    {
        $result = UserPay::leftjoin('branch as b', 'user_pay.branch_id', '=', 'b.id')->selectRaw("user_pay.branch_id, b.name as branch, count(user_pay.username) as count")->groupBy('b.name')->get();
        return $result;
    }

    public function getCategoryEmployeeCount()
    {
        $result = UserPay::leftjoin('category as b', 'user_pay.category_id', '=', 'b.id')->selectRaw("user_pay.category_id, b.name as category, count(user_pay.username) as count")->groupBy('user_pay.category_id')->get();
        return $result;
    }

    public function getDepartmentEmployeeCount()
    {
        $result = UserPay::leftjoin('department as b', 'user_pay.department_id', '=', 'b.id')->selectRaw("user_pay.department_id, b.name as department, count(user_pay.username) as count")->groupBy('user_pay.department_id')->get();
        return $result;
    }

    public function branchgetTypewiseYearlyLeaveCount(Request $request)
    {
        $hours = gethours();
        $result1 = UserPay::leftjoin('branch as b', 'user_pay.branch_id', '=', 'b.id')->leftjoin('leave_days as c', 'user_pay.username', '=', 'c.username')->leftjoin('leave_list as d', 'c.leave_id', '=', 'd.id')->selectRaw("b.id as branch_id, b.name as branch, sum(CASE d.is_hourly WHEN 1 THEN (((d.end_time-d.start_time)/3600 )/'$hours') WHEN 0 THEN d.no_days END) as count")->whereYear('c.date', $request->post('year'))->where('d.type', $request->post('type'))->where('d.status', '1')->groupBy('b.id');

        $result2 = UserPay::leftjoin('branch as b', 'user_pay.branch_id', '=', 'b.id')->leftjoin('leave_past as lp', 'user_pay.username', '=', 'lp.username')->selectRaw("b.id as branch_id, b.name as branch, sum(CASE lp.is_hourly WHEN 1 THEN (((lp.end_time-lp.start_time)/3600 )/'$hours') WHEN 0 THEN lp.total_leave_days END) as count")->whereYear('lp.start_date', $request->post('year'))->where('lp.type', $request->post('type'))->groupBy('b.id');

        $build_query1 = str_replace(['?'], ['\'%s\''], $result1->toSql());
        $bindings1 = $result1->getBindings();
        $query1 = vsprintf($build_query1, $bindings1);

        $build_query2 = str_replace(['?'], ['\'%s\''], $result2->toSql());
        $bindings2 = $result2->getBindings();
        $query2 = vsprintf($build_query2, $bindings2);

        $result = DB::select("select branch_id, sum(`count`) as `count`, `branch` from (" . $query1 . " union " . $query2 . ") as mainTable group by branch_id");

        return $result;
    }

    public function categorygetTypewiseYearlyLeaveCount(Request $request)
    {
        $hours = gethours();
        $result1 = UserPay::leftjoin('category as b', 'user_pay.category_id', '=', 'b.id')->leftjoin('leave_days as c', 'user_pay.username', '=', 'c.username')->leftjoin('leave_list as d', 'c.leave_id', '=', 'd.id')->selectRaw("b.id as category_id, b.name as category, sum(CASE d.is_hourly WHEN 1 THEN (((d.end_time-d.start_time)/3600 )/'$hours') WHEN 0 THEN d.no_days END) as count")->whereYear('c.date', $request->post('year'))->where('d.type', $request->post('type'))->where('d.status', '1')->groupBy('b.id');

        $result2 = UserPay::leftjoin('category as b', 'user_pay.category_id', '=', 'b.id')->leftjoin('leave_past as lp', 'user_pay.username', '=', 'lp.username')->selectRaw("b.id as category_id, b.name as category, sum(CASE lp.is_hourly WHEN 1 THEN (((lp.end_time-lp.start_time)/3600 )/'$hours') WHEN 0 THEN lp.total_leave_days END) as count")->whereYear('lp.start_date', $request->post('year'))->where('lp.type', $request->post('type'))->groupBy('b.id');

        $build_query1 = str_replace(['?'], ['\'%s\''], $result1->toSql());
        $bindings1 = $result1->getBindings();
        $query1 = vsprintf($build_query1, $bindings1);

        $build_query2 = str_replace(['?'], ['\'%s\''], $result2->toSql());
        $bindings2 = $result2->getBindings();
        $query2 = vsprintf($build_query2, $bindings2);

        $result = DB::select("select category_id, sum(`count`) as `count`, `category` from (" . $query1 . " union " . $query2 . ") as mainTable group by category_id");

        return $result;
    }

    public function deptgetTypewiseYearlyLeaveCount(Request $request)
    {
        $hours = gethours();
        $result1 = UserPay::leftjoin('department as b', 'user_pay.department_id', '=', 'b.id')->leftjoin('leave_days as c', 'user_pay.username', '=', 'c.username')->leftjoin('leave_list as d', 'c.leave_id', '=', 'd.id')->selectRaw("b.id as department_id, b.name as department, sum(CASE d.is_hourly WHEN 1 THEN (((d.end_time-d.start_time)/3600 )/'$hours') WHEN 0 THEN d.no_days END) as count")->whereYear('c.date', $request->post('year'))->where('d.type', $request->post('type'))->where('d.status', '1')->groupBy('b.id');

        $result2 = UserPay::leftjoin('department as b', 'user_pay.department_id', '=', 'b.id')->leftjoin('leave_past as lp', 'user_pay.username', '=', 'lp.username')->selectRaw("b.id as department_id, b.name as department, sum(CASE lp.is_hourly WHEN 1 THEN (((lp.end_time-lp.start_time)/3600 )/'$hours') WHEN 0 THEN lp.total_leave_days END) as count")->whereYear('lp.start_date', $request->post('year'))->where('lp.type', $request->post('type'))->groupBy('b.id');

        $build_query1 = str_replace(['?'], ['\'%s\''], $result1->toSql());
        $bindings1 = $result1->getBindings();
        $query1 = vsprintf($build_query1, $bindings1);

        $build_query2 = str_replace(['?'], ['\'%s\''], $result2->toSql());
        $bindings2 = $result2->getBindings();
        $query2 = vsprintf($build_query2, $bindings2);

        $result = DB::select("select department_id, sum(`count`) as `count`, `department` from (" . $query1 . " union " . $query2 . ") as mainTable group by department_id");

        return $result;
    }

    public function remployee()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $restdaygroups  = DB::table('rest_day_category')->where('company_id', $user->company_id)->orderBy('category', 'asc')->get();
        $leavecategories  = DB::table('category_name')->where('company_id', $user->company_id)->where('is_deleted', 0)->orderBy('name', 'asc')->get();
        $types = DB::table('employee_type')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        $race = Race::where('is_deleted', 0)->where('company_id', $user->company_id)->get();

        $c_key = 'leave_emp_list';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        
        return view('hr.reports.employee', compact('categories', 'departments', 'branches', 'restdaygroups', 'leavecategories', 'types', 'race', 'c_key', 'columnHideShowData'));
    }

    public function getremployeedata(Request $request)
    {
        session(['remployee_pdf_data' => $request->getUri()]);
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')
            ->leftjoin('department as e', 'b.department_id', '=', 'e.id')
            ->leftjoin('map_employee_permission as f', 'user_personal.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'f.permission_group_id', '=', 'g.id')
            ->leftjoin('user_category as uc', 'user_personal.username', '=', 'uc.username')
            ->leftjoin('rest_day_category_employee as rdce', 'user_personal.username', '=', 'rdce.employee_id')
            ->leftjoin('rest_day_category as rdc', 'rdce.category_id', '=', 'rdc.id')
            ->leftjoin('category_name as cname', 'uc.category', '=', 'cname.id');
        if ($request->get('branch') && $request->get('branch') != '') {

            $employees11->where('b.branch_id', $request->get('branch'));
        }
        if ($request->get('department') && $request->get('department') != '') {

            $employees11->where('b.department_id', $request->get('department'));
        }

        if ($request->get('category') && $request->get('category') != '') {

            $employees11->where('b.category_id', $request->get('category'));
        }
        if ($request->get('lengthofservice') && $request->get('lengthofservice') != '') {


            if ($request->get('lengthofservice') == 'less1') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -1 Year "));
                $employees11->where('b.date_commence', '<=', date('Y-m-d'))->where('b.date_commence', '>', $yearMinusOneDay);
            } elseif ($request->get('lengthofservice') == '1-5') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -1 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -5 Year "));
                $employees11->where('b.date_commence', '<=', $yearMinusOneDay)->where('b.date_commence', '>', $yearMinusOneDay1);
            } elseif ($request->get('lengthofservice') == '5-10') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -5 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -10 Year "));
                $employees11->where('b.date_commence', '<=', $yearMinusOneDay)->where('b.date_commence', '>', $yearMinusOneDay1);
            } elseif ($request->get('lengthofservice') == '10-15') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -10 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -15 Year "));
                $employees11->where('b.date_commence', '<=', $yearMinusOneDay)->where('b.date_commence', '>', $yearMinusOneDay1);
            } elseif ($request->get('lengthofservice') == '15-20') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -15 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -20 Year "));
                $employees11->where('b.date_commence', '<=', $yearMinusOneDay)->where('b.date_commence', '>', $yearMinusOneDay1);
            } else {
                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -20 Year "));
                $employees11->where('b.date_commence', '<=', $yearMinusOneDay);
            }
        }

        if ($request->get('agedistribution') && $request->get('agedistribution') != '') {


            if ($request->get('agedistribution') == 'less25') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -25 Year "));
                $employees11->where('user_personal.dob', '<=', date('Y-m-d'))->where('user_personal.dob', '>', $yearMinusOneDay);
            } elseif ($request->get('agedistribution') == '25-35') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -25 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -35 Year "));
                $employees11->where('user_personal.dob', '<=', $yearMinusOneDay)->where('user_personal.dob', '>', $yearMinusOneDay1);
            } elseif ($request->get('agedistribution') == '35-45') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -35 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -45 Year "));
                $employees11->where('user_personal.dob', '<=', $yearMinusOneDay)->where('user_personal.dob', '>', $yearMinusOneDay1);
            } elseif ($request->get('agedistribution') == '45-55') {

                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -45 Year "));
                $yearMinusOneDay1 =  date("Y-m-d", strtotime("now" . " -55 Year "));
                $employees11->where('user_personal.dob', '<=', $yearMinusOneDay)->where('user_personal.dob', '>', $yearMinusOneDay1);
            } elseif ($request->get('agedistribution') == '55more') {
                $yearMinusOneDay =  date("Y-m-d", strtotime("now" . " -55 Year "));
                $employees11->where('user_personal.dob', '<=', $yearMinusOneDay)->where('user_personal.dob', '!=', '0000-00-00');
            } elseif ($request->get('agedistribution') == 'empty') {
                $employees11->whereRaw("user_personal.dob='0000-00-00'");
            }
        }

        if ($request->get('datecommence_from') && $request->get('datecommence_to')) {
            $employees11->whereBetween('b.date_commence', [$request->get('datecommence_from'), $request->get('datecommence_to')]);
        } elseif ($request->get('datecommence_from')) {
            $employees11->where('b.date_commence', $request->get('datecommence_from'));
        } elseif ($request->get('datecommence_to')) {
            $employees11->where('b.date_commence', $request->get('datecommence_to'));
        }


        if ($request->get('dateconfirmed_from') && $request->get('dateconfirmed_to')) {
            $employees11->whereBetween('b.date_confirmed', [$request->get('dateconfirmed_from'), $request->get('dateconfirmed_to')]);
        } elseif ($request->get('dateconfirmed_from')) {
            $employees11->where('b.date_confirmed', $request->get('dateconfirmed_from'));
        } elseif ($request->get('dateconfirmed_to')) {
            $employees11->where('b.date_confirmed', $request->get('dateconfirmed_to'));
        }


        if ($request->get('dateresigned_from') && $request->get('dateresigned_to')) {
            $employees11->whereBetween('b.date_resigned', [$request->get('dateresigned_from'), $request->get('dateresigned_to')]);
        } elseif ($request->get('dateresigned_from')) {
            $employees11->where('b.date_resigned', $request->get('dateresigned_from'));
        } elseif ($request->get('dateresigned_to')) {
            $employees11->where('b.date_resigned', $request->get('dateresigned_to'));
        }

        if ($request->get('maritalstatus') && $request->get('maritalstatus') != '') {
            if ($request->get('maritalstatus') != 'empty') {
                $employees11->where('user_personal.marital_status', $request->get('maritalstatus'));
            } else {
                $employees11->whereRaw("(user_personal.marital_status='' or user_personal.marital_status IS NULL)");
            }
        }
        if ($request->get('restdaygroup') && $request->get('restdaygroup') != '') {
            if ($request->get('restdaygroup') != 'empty') {
                $employees11->where('rdce.category_id', $request->get('restdaygroup'));
            } else {
                $employees11->whereRaw("(rdce.category_id='' or rdce.category_id IS NULL)");
            }
        }
        if ($request->get('leavecategory') && $request->get('leavecategory') != '') {
            $employees11->where('uc.category', $request->get('leavecategory'));
        }
        if ($request->get('employeetype') && $request->get('employeetype') != '') {
            if ($request->get('employeetype') != '0') {
                $employees11->where('user_personal.employee_type', $request->get('employeetype'));
            } else {
                $employees11->whereRaw("(user_personal.employee_type='' or user_personal.employee_type IS NULL");
            }
        }
        if ($request->get('dob') && $request->get('dob') != '') {
            if ($request->get('dob') != 'empty') {
                $employees11->whereMonth('user_personal.dob', $request->get('dob'));
            } else {
                $employees11->whereRaw("user_personal.dob='0000-00-00'");;
            }
        }
        if ($request->get('race') && $request->get('race') != '') {
            if ($request->get('race') != 'empty') {
                $employees11->where('user_personal.race', $request->get('race'));
            } else {
                $employees11->whereRaw("(user_personal.race='' or user_personal.race IS NULL)");
            }
        }
        if ($request->get('pay_status')) {
            if ($request->get('pay_status') == 'active') {
                $status = 1;
            } else {
                $status = 0;
            }
            $employees11->where('b.pay_status', $status);
        }
        if ($request->get('gender') && $request->get('gender') != '') {
            if ($request->get('gender') == 'Male') {
                $sex = 1;
            } else {
                $sex = 0;
            }
            $employees11->where('user_personal.sex', $sex);
        }
        if ($ActiveUserShownStatus == 1) {
            $employees11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $employees11->where('b.pay_status', '1');
        }

        $employees11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.name, user_personal.email_id, user_personal.employee_code, b.date_commence,b.date_resigned,user_personal.sex,user_personal.marital_status,user_personal.race,user_personal.dob,user_personal.employee_type, b.pay_status as active, c.name as branch, d.name as category, e.name as department, user_personal.state, user_personal.phone_no, g.group_name as role, uc.category as category_mapping, rdc.category as rest_day_group, cname.name as leave_category, b.date_confirmed as date_confirmed, user_personal.marital_status,  user_personal.race, c.name as branchname, d.name as categoryname, e.name as departmentname")
            ->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);
        $employees = $employees11->orderByRaw('user_personal.name+0,user_personal.name')->get();
        $employees->map(function ($item) {
            if ($item->sex == 1) {
                $gender = 'Male';
            } else {
                $gender = 'Female';
            }
            if ($item->active == 1) {
                $status = "Active";
            } else {
                $status = "Non-Active";
            }
            if ($item->date_resigned == '0000-00-00') {
                $item->date_resigned = '';
            } else {
                $item->date_resigned = date('d-m-Y', strtotime($item->date_resigned));
            }
            $item->estatus = $status;
            $item->gender = $gender;
        });

        return DataTables::of($employees)->make(true);
    }


    public function employeePDF(Request $request)
    {

        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('remployee_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $employees = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_emp_list';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Date of Join", "Confirmed Date", "Gender", "Phone No", "Status"];


        $html = html_entity_decode(view('hr.reports.pdf.employeepdf', compact('employees', 'timedate', 'companyname', 'arrColumns', 'columnHideShowData', 'c_key'))); //->render();
        $pdf = new Dompdf();


        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Employees Report');
        return 1;
    }

    public function employeeexport(Request $request)
    {
        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('remployee_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Employees Report');


        $c_key = 'leave_emp_list';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Emp No", "Name", "Date of Join", "Confirmed Date", "Gender", "Phone No", "Status", "Resigned Date","Marital Status","Rest Day", "Leave Category", "Employee Type", "Department", "Category", "Branch","Race"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 3;

 

        foreach ($employees as $employee) {

            if ($employee->date_confirmed == '0000-00-00' || $employee->date_confirmed == '') {
                $dconfirmed = '';
            } else {
                $dconfirmed = date('d-m-Y', strtotime($employee->date_confirmed));
            }

            $commence_date = !is_null($employee->date_commence) ? date('d-m-Y', strtotime($employee->date_commence)) : "";
            
            $arrRows = [$employee->employee_no, mb_convert_encoding($employee->name, "UTF-8", "HTML-ENTITIES"), $commence_date, $dconfirmed, $employee->gender, $employee->phone_no,$employee->estatus,$employee->date_resigned,$employee->marital_status,$employee->rest_day_group,$employee->leave_category,$employee->employee_type,$employee->departmentname,$employee->categoryname,$employee->branchname,$employee->race];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
            $rows++;       
        }


        $fileName = "employees-report.xlsx";

        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }


    public function rdepartments()
    {
        $departments  = Department::groupBy('name')->orderBy('name', 'asc')->get();
        $departments->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.department_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.department_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            return $item;
        });
        $total = 0;
        foreach ($departments as $dtotal) {
            $total = $total + $dtotal->employee;
        }

        $c_key = 'leave_department';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.department', compact('departments', 'total', 'c_key', 'columnHideShowData'));
    }

    public function getrdeptdata(Request $request)
    {
        session(['rdept_pdf_data' => $request->getUri()]);
        $departments  = Department::groupBy('name')->orderBy('name', 'asc')->get();

        $departments->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.department_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.department_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);
            return $item;
        });

        return DataTables::of($departments)->make(true);
    }

    public function departmentPDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('rdept_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rdept_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('rdept_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        //return view('hr.reports.pdf.deptpdf', compact('departments'));
        $departments = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_department';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Department", "Description", "Email", "Forecast", "Actual", "Percent"];


        $html = html_entity_decode(view('hr.reports.pdf.deptpdf', compact('departments', 'timedate', 'companyname', 'c_key', 'columnHideShowData', 'arrColumns')));
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Department');
        return 1;
    }

    public function deparmentexport()
    {
        //$url = str_replace("length=20","length=-1",session('rdept_pdf_data'));
        //$url = session('rdept_pdf_data');
        $url1 = str_replace("length=10", "length=-1", session('rdept_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $departments = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Department Report');

        $c_key = 'leave_department';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Department", "Description", "Email", "Forecast", "Actual", "Percent"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 3;
        $total = 0;
        foreach ($departments as $department) {

            $total = $total + $department->employee;

            $rows++;
            $percent = $department->percent . '%';
            $arrRows = [$department->name, $department->description, $department->email, $department->forecast, $department->employee, $percent];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }
        $rows1 = $rows + 1;
        $sheet->setCellValue('D' . $rows1, 'Total');
        $sheet->setCellValue('E' . $rows1, $total);


        $fileName = "department-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function rcategory()
    {
        $category  = Category::groupBy('name')->orderBy('name', 'asc')->get();
        $category->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.category_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.category_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            return $item;
        });
        $total = 0;
        foreach ($category as $ctotal) {
            $total = $total + $ctotal->employee;
        }

        $c_key = 'leave_category';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.category', compact('total', 'c_key', 'columnHideShowData'));
    }

    public function getrcategorydata(Request $request)
    {
        session(['rcategory_pdf_data' => $request->getUri()]);
        $category  = Category::groupBy('name')->orderBy('name', 'asc')->get();
        $category->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.category_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.category_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);
            return $item;
        });
        return DataTables::of($category)->make(true);
    }

    public function categoryPDF(Request $request)
    {

                $c_key = 'leave_category';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Category", "Description", "Email", "Forecast", "Actual", "Percent"];




        $timezone = Carbon::now(get_local_time());
        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('rcategory_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rcategory_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('rcategory_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $category = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_category';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Category", "Description", "Email", "Forecast", "Actual", "Percent"];


        $html = html_entity_decode(view('hr.reports.pdf.catpdf', compact('category', 'timedate', 'companyname', 'c_key', 'columnHideShowData', 'arrColumns')));
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Category');
        return 1;
    }

    public function categoryexport()
    {
        //$url = str_replace("length=20","length=-1",session('rcategory_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rcategory_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('rcategory_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $category = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Category Report');

        $c_key = 'leave_category';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Category", "Description", "Email", "Forecast", "Actual", "Percent"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        $total = 0;
        foreach ($category as $cat) {
            $total = $total + $cat->employee;
            $rows++;

            $arrRows = [$cat->name, $cat->description, $cat->email, $cat->forecast, $cat->employee, $cat->percent];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }
        $rows1 = $rows + 1;
        $sheet->setCellValue('D' . $rows1, 'Total');
        $sheet->setCellValue('E' . $rows1, $total);

        $fileName = "category-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function rbranch()
    {
        $branches  = Branch::groupBy('name')->orderBy('name', 'asc')->get();
        $branches->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.branch_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.branch_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            return $item;
        });
        $total = 0;
        foreach ($branches as $btotal) {
            $total = $total + $btotal->employee;
        }

        $c_key = 'leave_branch';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.branch', compact('total', 'c_key', 'columnHideShowData'));
    }
    public function getrbranchdata(Request $request)
    {
        session(['rbranch_pdf_data' => $request->getUri()]);
        $branches  = Branch::groupBy('name')->orderBy('name', 'asc')->get();
        $branches->map(function ($item) {
            $emp = DB::table('user_pay')->selectRaw("count(user_pay.branch_id) as employee")->leftjoin('user_personal', 'user_personal.username', '=', 'user_pay.username')->where('user_pay.branch_id', $item->id)->whereRaw("(user_pay.`date_resigned` = 0000-00-00 or user_pay.`date_resigned` > " . date('Y-m-d') . ")")->where('user_personal.isDeleted', 0)->where('user_pay.pay_status', 1)->first();
            $item->employee = $emp->employee;
            $forecast = $item->forecast;
            if ($item->forecast == 0) {
                $forecast = 1;
            }
            $item->percent = sprintf("%0.1f", ($item->employee * 100) / $forecast);
            return $item;
        });
        return DataTables::of($branches)->make(true);
    }
    public function branchPDF(Request $request)
    {

        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        //$url = str_replace("length=20","length=-1",session('rbranch_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rbranch_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('rbranch_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $branches = json_decode($response)->data;
        //return view('hr.reports.pdf.deptpdf', compact('departments'));
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_branch';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Branch", "Description", "Email", "Forecast", "Actual", "Percent"];



        $html = html_entity_decode(view('hr.reports.pdf.branchpdf', compact('branches', 'timedate', 'companyname', 'c_key', 'columnHideShowData', 'arrColumns')));
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Branch');
        return 1;
    }

    public function branchexport()
    {
        //$url = str_replace("length=20","length=-1",session('rbranch_pdf_data'));
        //$url = session('rbranch_pdf_data');
        $url1 = str_replace("length=10", "length=-1", session('rbranch_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $branches = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Branch Report');

        $c_key = 'leave_branch';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Branch", "Description", "Email", "Forecast", "Actual", "Percent"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        $total = 0;
        foreach ($branches as $branch) {
            $total = $total + $branch->employee;
            $rows++;

            $arrRows = [$branch->name, $branch->description, $branch->email, $branch->forecast, $branch->employee, $branch->percent];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }
        $rows1 = $rows + 1;
        $sheet->setCellValue('D' . $rows1, 'Total');
        $sheet->setCellValue('E' . $rows1, $total);

        $fileName = "branch-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }


    public function rleave()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::orderBy('name', 'asc')->where('is_show', 1)->where('company_id', $user->company_id)->get();
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        $c_key = 'leave_rleave';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.leave', compact('categories', 'departments', 'branches', 'leaveTypes', 'relieveallow', 'halfdayallow', 'c_key', 'columnHideShowData'));
    }

    public function getrleavedata(Request $request)
    {
        $hours = gethours();
        session(['rleaves_pdf_data' => $request->getUri()]);
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", !empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
        $only_current_year_leave_display = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        $leavepastcount = LeavePast::leftjoin('user_personal as b', 'leave_past.username', '=', 'b.username')->leftjoin('user_pay as d', 'leave_past.username', '=', 'd.username');
        $leaves11 = LeavePast::leftjoin('user_personal as b', 'leave_past.username', '=', 'b.username')
            ->leftjoin('user_pay as d', 'leave_past.username', '=', 'd.username')
            ->leftjoin('branch as e', 'd.branch_id', '=', 'e.id')
            ->leftjoin('department as f', 'd.department_id', '=', 'f.id')
            ->leftjoin('category as g', 'd.category_id', '=', 'g.id');
        if ($request->get('name') && $request->get('name') != '') {
            $leaves11->whereRaw('(b.name like ("' . request()->name . '%") OR b.employee_no like ("' . request()->name . '%")) ');

            $leavepastcount->whereRaw('(b.name like ("' . request()->name . '%") OR b.employee_no like ("' . request()->name . '%")) ');
        }
        if ($request->get('status') != '') {

            $leaves11->where('leave_past.status', $request->get('status'));
            $leavepastcount->where('leave_past.status', $request->get('status'));
        }
        if ($request->get('ename') && $request->get('ename') != '') {

            $leaves11->whereRaw('(b.name like ("' . request()->ename . '%")) ');

            $leavepastcount->whereRaw('(b.name like ("' . request()->ename . '%")) ');
        }
        if ($request->get('type') && $request->get('type') != '') {
            $leaves11->where('leave_past.type', $request->get('type'));
            $leavepastcount->where('leave_past.type', $request->get('type'));
        }
        if ($request->get('phone') && $request->get('phone') != '') {
            $personals11 = UserPersonal::where('employee_no', $request->get('phone'))
                ->pluck('username')->toArray();
            $leaves11->whereIn('b.username', $personals11);
            $leavepastcount->whereIn('b.username', $personals11);
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $leaves11->where('d.branch_id', $request->get('branch'));
            $leavepastcount->where('d.branch_id', $request->get('branch'));
        }
        if ($request->get('department') && $request->get('department') != '') {
            $leaves11->where('d.department_id', $request->get('department'));
            $leavepastcount->where('d.department_id', $request->get('department'));
        }

        if ($request->get('category') && $request->get('category') != '') {
            $leaves11->where('d.category_id', $request->get('category'));
            $leavepastcount->where('d.category_id', $request->get('category'));
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            //$leaves11->whereBetween('a.start_date', [$from, $to]);
            $leaves11->where('leave_past.start_date', ">=", $from)->where('leave_past.end_date', "<=", $to);
            $leavepastcount->where('leave_past.start_date', ">=", $from)->where('leave_past.end_date', "<=", $to);
        } elseif ($from != '') {
            $leaves11->where('leave_past.start_date', ">=", $from)->where('leave_past.end_date', "<=", $from);
            $leavepastcount->where('leave_past.start_date', ">=", $from)->where('leave_past.end_date', "<=", $from);
        } elseif ($to != '') {
            $leaves11->where('leave_past.start_date', ">=", $to)->where('leave_past.end_date', "<=", $to);
            $leavepastcount->where('leave_past.start_date', ">=", $to)->where('leave_past.end_date', "<=", $to);
        }

        $logged_username = $user->username;
        if ($hr_viewStatus == 1) {
            $leaves11->where('b.username', $logged_username);
            $leavepastcount->where('b.username', $logged_username);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($logged_username);
            $leaves11->where('d.branch_id', $logged_userGroups->branch_id)->where('d.category_id', $logged_userGroups->category_id)->where('d.department_id', $logged_userGroups->department_id);
            $leavepastcount->where('d.branch_id', $logged_userGroups->branch_id)->where('d.category_id', $logged_userGroups->category_id)->where('d.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($logged_username);
            $leaves11->where('d.branch_id', $logged_userGroups->branch_id);
            $leavepastcount->where('d.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $logged_userGroups = getUserGroups($logged_username);

            $all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);

            if (count($all_other_branch_ids) > 0) {
                $array_i = array();
                for ($b_id_i = 0; $b_id_i < count($all_other_branch_ids); $b_id_i++) {
                    $array_i[] = $all_other_branch_ids[$b_id_i]->id;
                }
                $str_branch_ids = $array_i;
                $leaves11->whereIn('d.branch_id', $str_branch_ids);
                $leavepastcount->whereIn('d.branch_id', $str_branch_ids);
            }
        }
        $leaves11->selectRaw("CASE leave_past.is_hourly WHEN 1 THEN ( (leave_past.end_time-leave_past.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_past.is_hourly,leave_past.id, 1 as leave_type, leave_past.username, 0, b.name, b.employee_no, e.name as branch, f.name as department,  g.name as category, type, '-' as date_applied, '-' as date_approved, leave_past.start_date as date, leave_past.end_date as end_date, leave_past.total_leave_days as no_days, 0, 0, 0, 1 as status, 'Past Leave' as reason, '' as cancellation_reason, leave_past.half_day_type as half_day_type, '' as filename,'past' as leave_from,'' as r_name")
            ->where('b.isDeleted', 0);
        if ($ActiveUserShownStatus == 1) {
            $leaves11->whereRaw("( d.pay_status='1' or d.pay_status='0')");
            $leavepastcount->whereRaw("( d.pay_status='1' or d.pay_status='0')");
        } else {
            $leaves11->where('d.pay_status', '1');
            $leavepastcount->where('d.pay_status', '1');
        }
        $leavepastcount->selectRaw("leave_past.id")->where('b.isDeleted', 0);
        if (($only_current_year_leave_display->value ?? 0) == 1) {
            $leaves11->whereYear('leave_past.start_date', '=', date('Y'));
            $leavepastcount->whereYear('leave_past.start_date', '=', date('Y'));
        }
        $leavecount = LeaveDay::leftjoin('leave_list as b', 'leave_days.leave_id', '=', 'b.id')->leftjoin('user_personal as c', 'leave_days.username', '=', 'c.username')->leftjoin('user_pay as d', 'leave_days.username', '=', 'd.username');
        $allLeaves = LeaveDay::leftjoin('leave_list as b', 'leave_days.leave_id', '=', 'b.id')
            ->leftjoin('user_personal as c', 'leave_days.username', '=', 'c.username')
            ->leftjoin('user_pay as d', 'leave_days.username', '=', 'd.username')
            ->leftjoin('branch as e', 'd.branch_id', '=', 'e.id')
            ->leftjoin('department as f', 'd.department_id', '=', 'f.id')
            ->leftjoin('category as g', 'd.category_id', '=', 'g.id')
            ->leftjoin('user_personal as c_r', 'b.relieve', '=', 'c_r.username');
        if ($request->get('name') && $request->get('name') != '') {
            $allLeaves->whereRaw('(c.name like ("' . request()->name . '%") OR c.employee_no like ("' . request()->name . '%")) ');

            $leavecount->whereRaw('(c.name like ("' . request()->name . '%") OR c.employee_no like ("' . request()->name . '%")) ');
        }
        if ($request->get('ename') && $request->get('ename') != '') {

            $allLeaves->whereRaw('(c.name like ("' . request()->ename . '%") OR c.employee_no like ("' . request()->ename . '%")) ');

            $leavecount->whereRaw('(c.name like ("' . request()->ename . '%") OR c.employee_no like ("' . request()->ename . '%")) ');
        }
        if ($request->get('status') != '') {
            $allLeaves->where('b.status', $request->get('status'));
            $leavecount->where('b.status', $request->get('status'));
        }
        if ($request->get('type') && $request->get('type') != '') {
            $allLeaves->where('b.type', $request->get('type'));
            $leavecount->where('b.type', $request->get('type'));
        }
        if ($request->get('phone') && $request->get('phone') != '') {
            // $personals11 = UserPersonal::where('employee_no', $request->get('phone'))
            //             ->pluck('username')->toArray();
            // $allLeaves->whereIn('b.username', $personals11);
            //  $allLeaves->where(function($query){
            //     $query->where('c.name', 'like', '%'.request()->get('phone').'%')->orwhere('c.employee_no', 'like', '%'.request()->get('phone').'%');
            // });
            $allLeaves->whereRaw('(c.name like ("' . request()->phone . '%") OR c.employee_no like ("' . request()->phone . '%")) ');

            $leavecount->whereRaw('(c.name like ("' . request()->phone . '%") OR c.employee_no like ("' . request()->phone . '%")) ');
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $allLeaves->where('d.branch_id', $request->get('branch'));
            $leavecount->where('d.branch_id', $request->get('branch'));
        }
        if ($request->get('department') && $request->get('department') != '') {
            $allLeaves->where('d.department_id', $request->get('department'));
            $leavecount->where('d.department_id', $request->get('department'));
        }

        if ($request->get('category') && $request->get('category') != '') {
            $allLeaves->where('d.category_id', $request->get('category'));
            $leavecount->where('d.category_id', $request->get('category'));
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            $allLeaves->where('leave_days.date', '>=', $from)->where('leave_days.date', '<=', $to);
            $leavecount->where('leave_days.date', '>=', $from)->where('leave_days.date', '<=', $to);
        } elseif ($from != '') {
            $allLeaves->where('leave_days.date', '=', $from);
            $leavecount->where('leave_days.date', '=', $from);
        } elseif ($to != '') {
            $allLeaves->where('leave_days.date', '=', $to);
            $leavecount->where('leave_days.date', '=', $to);
        }

        $logged_username = $user->username;
        if ($hr_viewStatus == 1) {
            $allLeaves->where('c.username', $logged_username);
            $leavecount->where('c.username', $logged_username);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($logged_username);
            $allLeaves->where('d.branch_id', $logged_userGroups->branch_id)->where('d.category_id', $logged_userGroups->category_id)->where('d.department_id', $logged_userGroups->department_id);
            $leavecount->where('d.branch_id', $logged_userGroups->branch_id)->where('d.category_id', $logged_userGroups->category_id)->where('d.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($logged_username);
            $allLeaves->where('d.branch_id', $logged_userGroups->branch_id);
            $leavecount->where('d.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $logged_userGroups = getUserGroups($logged_username);
            $all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
            // 			if(is_array($all_other_branch_ids) && count($all_other_branch_ids)>0){
            if (count($all_other_branch_ids) > 0) {
                $array_i = array();
                for ($b_id_i = 0; $b_id_i < count($all_other_branch_ids); $b_id_i++) {
                    $array_i[] = $all_other_branch_ids[$b_id_i]->id;
                }
                $str_branch_ids = $array_i;
                $allLeaves->whereIn('d.branch_id', $str_branch_ids);
                $leavecount->whereIn('d.branch_id', $str_branch_ids);
            }
        }

        $allLeaves->selectRaw("CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,b.is_hourly,leave_days.id, 0 as leave_type, leave_days.username, b.id as leave_id, c.name, c.employee_no, e.name as branch, f.name as department, g.name as category, b.type, DATE_FORMAT(b.date_applied, '%Y-%m-%d') as date_applied, b.date_approved as date_approved, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', b.is_half_day, b.start_time,b.end_time, leave_days.status, b.reason, leave_days.cancellation_reason, b.half_day_type  as half_day_type, b.filename, 'leave' as leave_from, c_r.name as r_name ")
            ->where('c.isDeleted', 0);
        if ($ActiveUserShownStatus == 1) {
            $allLeaves->whereRaw("( d.pay_status='1' or d.pay_status='0')");
            $leavecount->whereRaw("( d.pay_status='1' or d.pay_status='0')");
        } else {
            $allLeaves->where('d.pay_status', '1');
            $leavecount->where('d.pay_status', '1');
        }
        $leavecount->selectRaw("leave_days.id")->where('c.isDeleted', 0);
        if (($only_current_year_leave_display->value ?? 0) == 1) {
            if ($from == '' && $to == '') {
                $allLeaves->whereYear('leave_days.date', '=', date('Y'));
                $leavecount->whereYear('leave_days.date', '=', date('Y'));
            }
        }
        $allLeaves->union($leaves11)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 5 THEN 1 ELSE 2 END), date  DESC');
        $leavecount->union($leavepastcount);

        // $totalleave =  $leavecount->count();
        $totalleave =  $allLeaves->count();
        
        $offset = 0;
        if (isset($_GET['start'])) {
            $offset = $_GET['start'];
        }

        $length = $totalleave;
        if (isset($_GET['length'])  && $_GET['length'] > 0) {
            $length = $_GET['length'];
        }
        //$leaves = $allLeaves->get();
        $leaves = $allLeaves->skip($offset)->take($length)->get();
        $leaves->map(function ($item) {
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $leavetypename = DB::table('leave_name')->where('type', $item->type)->first();

            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class = '';
            if ($item->is_hourly != 0) {
                $item->start_time = date('h:i A', $item->start_time);
                $item->end_time = date('h:i A', $item->end_time);
            }
            if ($item->type == 'Other_pay') {
                $type = 'Replacement';
            } elseif ($item->type == 'Line_Shut') {
                $type = 'Out Of Office';
            } else {
                $type = $item->type;
            }
            if ($item->status == 0) {
                $status = 'Pending';
                $class = 'grey';
            } elseif ($item->status == 1) {
                $status = 'Approved';
                $class = 'green';
            } elseif ($item->status == 2) {
                $status = 'Rejected';
                $class = 'red';
            } elseif ($item->status == 3) {
                $status = 'Recommended';
                $class = 'blue';
            } elseif ($item->status == 4) {
                $status = 'Cancelled';
                $class = '#00cfe8';
            } elseif ($item->status == 5) {
                $status = 'Cancellation Pending';
                $class = 'orange';
            }
            if ($item->no_days == '0.5') {
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
            } else {
                $htype = '';
            }

            $item->back_color = $class;
            $item->leave_status = $status;
            $item->leave_type  = $leavetypename->name ?? "";
            $item->half_day  = $htype;
            return $item;
        });

        if (isset($_GET['order'][0]['column'])) {
            $collection = collect($leaves);
            if ($_GET['order'][0]['column'] == 0) {
                $ocolumn = "emp_no";
            } elseif ($_GET['order'][0]['column'] == 1) {
                $ocolumn = "emp_name";
            } elseif ($_GET['order'][0]['column'] == 2) {
                $ocolumn = "r_name";
            } elseif ($_GET['order'][0]['column'] == 3) {
                $ocolumn = "leave_type";
            } elseif ($_GET['order'][0]['column'] == 4) {
                $ocolumn = "date";
            } elseif ($_GET['order'][0]['column'] == 5) {
                $ocolumn = "date_approved";
            } elseif ($_GET['order'][0]['column'] == 6) {
                $ocolumn = "date_applied";
            } elseif ($_GET['order'][0]['column'] == 7) {
                $ocolumn = "no_days";
            } elseif ($_GET['order'][0]['column'] == 8) {
                $ocolumn = "reason";
            } elseif ($_GET['order'][0]['column'] == 9) {
                $ocolumn = "leave_status";
            }
            if ($_GET['order'][0]['dir'] == 'asc') {
                $leaves =  $collection->sortBy($ocolumn)->values();
            } else {
                $leaves =  $collection->sortByDesc($ocolumn)->values();
            }
        } else {
            $leaves   = $leaves;
        }

        $response = array(
            "draw" => intval($_GET['draw']),
            "iTotalRecords" => $totalleave,
            "iTotalDisplayRecords" => $totalleave,
            "data" => $leaves
        );

        return json_encode($response);

        // return DataTables::of($leaves)->make(true);
    }


    public function leavePDF(Request $request)
    {
        //  phpinfo();
        //  exit;
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('rleaves_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rleaves_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        //$url = session('rleaves_pdf_data');
        $curl = curl_init();

        curl_setopt_array($curl, array(

            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $leaves = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();

        $c_key = 'leave_rleave';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Relief", "Leave Type", "Leave Date", "Date Approved", "Date Applied", "Days", "Reason", "Status"];



        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $data = [
            'leaves' => $leaves,
            'timedate' => $timedate,
            'companyname' => $companyname,
            'c_key'=>$c_key,
            'columnHideShowData'=>$columnHideShowData,
            'arrColumns'=>$arrColumns,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.leavepdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Leave Report.pdf');
    }

    public function leaveexport(Request $request)
    {

        $url1 = str_replace("length=10", "length=-1", session('rleaves_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $leaves = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Leave Report');

        $c_key = 'leave_rleave';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Emp No", "Name", "Relief", "Leave Type", "Leave Date", "Date Approved", "Date Applied", "Days", "Reason", "Status"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        foreach ($leaves as $leave) {
            // if($leave->date_approved == '-'){
            //     $leave->date_approved = '';
            // }
            // if($leave->date_applied == '-'){
            //     $leave->date_applied = '';
            // }
            if ($leave->date_applied != '' && $leave->date_applied != '0000-00-00' && $leave->date_approved != '-') {
                $dapplied = date('d-m-Y', strtotime($leave->date_applied));
            } else {
                $dapplied = '';
            }
            if ($leave->date_approved != '' && $leave->date_approved != '0000-00-00' && $leave->date_approved != '-') {
                $date_approved = date('d-m-Y', strtotime($leave->date_approved));
            } else {
                $date_approved = '';
            }

            $ldate = !is_null($leave->date) ? date('d-m-Y', strtotime($leave->date)) : "";
            $lcalc = $leave->no_days . $leave->half_day;
            $rows++;

            $arrRows = [$leave->emp_no, mb_convert_encoding($leave->emp_name, "UTF-8", "HTML-ENTITIES"), $leave->r_name, $leave->leave_type, $ldate, $date_approved, $dapplied, $lcalc,$leave->reason,$leave->leave_status];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }


        $fileName = "leave-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }


    public function rholiday(Request $request, $year = null)
    {

        $countries  = Country::where('is_deleted', 0)->get();
        $states  = State::get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();

        $c_key = 'leave_rholiday';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }


        return view('hr.reports.holiday', compact('countries', 'states', 'userPay','c_key', 'columnHideShowData'));
    }

    public function getrholidaydata(Request $request)
    {
        session(['rholiday_pdf_data' => $request->getUri()]);
        $holidays11 = DB::table('public_holiday')->selectRaw("public_holiday.*, GROUP_CONCAT(DISTINCT state) as state, CONCAT(date, description) as date_holiday");
        if ($request->get('year') != '') {
            $year = $request->get('year');
        } else {
            $year = date('Y');
        }
        $holidays = $holidays11->orderBy('date', 'ASC')->whereYear('date', '=', $year)->groupBy('date_holiday')->get();

        $holidays->map(function ($item, $index) {
            //$item->no = $index;
            $index++;
            $item->no = $index;
            $item->hdate  = date('d-m-Y', strtotime($item->date));
            $item->day  = date('D', strtotime($item->date));
            return $item;
        });
        return DataTables::of($holidays)->make(true);
    }

    public function getsearchholidaydata(Request $request)
    {
        session(['rholiday_pdf_data' => $request->getUri()]);
        $holidays11 = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday");

        if ($request->get('country') && $request->get('country') != '') {
            $holidays11->where('country', $request->get('country'));
        }
        if ($request->get('state') && $request->get('state') != '') {
            $holidays11->where('state', $request->get('state'));
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            $holidays11->whereBetween('date', [$from, $to]);
        } elseif ($from != '') {
            $holidays11->where('date', '=', $from);
        } elseif ($to != '') {
            $holidays11->where('date', '=', $to);
        }
        $holidays = $holidays11->orderBy('date', 'ASC')->groupBy('date_holiday')->get();

        $holidays->map(function ($item, $index) {

            $index++;
            $item->no  = $index;
            $item->hdate  = date('d-m-Y', strtotime($item->date));
            $item->day  = date('D', strtotime($item->date));
            return $item;
        });
        return DataTables::of($holidays)->make(true);
    }

    public function holidayPDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('rholiday_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('rholiday_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('rholiday_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $holidays = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_rholiday';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Date", "Day", "Description", "State"];

        
        $html = html_entity_decode(view('hr.reports.pdf.holidaypdf', compact('holidays', 'timedate', 'companyname', 'c_key', 'columnHideShowData', 'arrColumns')));
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Holiday Report');
        return 1;
    }

    public function holidayexport(Request $request)
    {
        //$url = str_replace("length=20","length=-1",session('rholiday_pdf_data'));
        //$url = session('rholiday_pdf_data');
        $url1 = str_replace("length=10", "length=-1", session('rholiday_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $holidays = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Public Holidays');

        $c_key = 'leave_rholiday';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Date", "Day", "Description", "State"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        foreach ($holidays as $holiday) {

            $rows++;
            $arrRows = [date('d-m-Y', strtotime($holiday->date)), $holiday->day, $holiday->description, $holiday->state];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }


        $fileName = "holiday-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function rannualentitle()
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        $hourlyLeave = getSettingsValue('hourlyLeave');

        $c_key = 'leave_annualentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.annualentitle', compact('categories', 'departments', 'branches', 'userPay', 'hourlyLeave', 'c_key', 'columnHideShowData'));
    }

    public function getrannualentitledata(Request $request)
    {
        session(['rannual_pdf_data' => $request->getUri()]);
        if ($request->get('year') && $request->get('year') != '') {
            $year11 = request()->get('year');
        } else {
            $year11 = date('Y');
        }
        $leavedataCount = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username');
        $annualentitle11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');
        if ($request->get('name') && $request->get('name') != '') {
            $annualentitle11->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
            $leavedataCount->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $annualentitle11->whereIn('user_personal.username', $branchId);
            $leavedataCount->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $annualentitle11->whereIn('user_personal.username', $departmentId);
            $leavedataCount->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $annualentitle11->whereIn('user_personal.username', $categoryId);
            $leavedataCount->whereIn('user_personal.username', $categoryId);
        }
        $annualentitle11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.employee_no as No, user_personal.employee_code, user_personal.name, user_personal.name as Name, b.date_commence, b.date_commence as join_year")
            ->where('user_personal.username', '!=', null)
            ->whereYear('b.date_commence', '<=', $year11)->whereRaw("(year(`b`.`date_resigned`) = $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.isDeleted', 0);

        $leavedataCount = $leavedataCount->whereYear('b.date_commence', '<=', $year11)
            ->whereRaw("(year(`b`.`date_resigned`) = $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);

        $offset = 0;
        if (isset($_GET['start'])) {
            $offset = $_GET['start'];
        }
        $length = 0;
        if (isset($_GET['length'])  && $_GET['length'] > 0) {
            $length = $_GET['length'];
        }

        $annualentitle16 = $annualentitle11->skip($offset)->take($length)->get();
        $annualentitle16->map(function ($item) {
            if (request()->get('year') && request()->get('year') != '') {
                $year = request()->get('year');
            } else {
                $year = carbon()->year;
            }


            $myLeaveSumm = getYearlyEntitle($item->username, $year);
            
            if ($myLeaveSumm['bfadj_forfeit'] == 1) {
                $forfeitbf = $myLeaveSumm['brought_forward']['annual'] - $myLeaveSumm['brought_forward']['annual_taken'];
                $forfeitbfadj = $myLeaveSumm['brought_forward']['annual_adj'] - $myLeaveSumm['brought_forward']['bfAdjLeaveTaken'];
            } else {
                $forfeitbf = 0;
                $forfeitbfadj = 0;
            }
            $item->commerce = date('d-m-Y', strtotime($item->join_year));
            $item->bf = $this->checkvaluefloat($myLeaveSumm['brought_forward']['annual']);
            $item->bfadj = $this->checkvaluefloat($myLeaveSumm['brought_forward']['annual_adj']);
            $item->entitle = $this->checkvaluefloat($myLeaveSumm['annual']['entitle']);
            $item->earn  = $this->checkvaluefloat($myLeaveSumm['earn']);
            $item->claimable  = $this->checkvaluefloat($myLeaveSumm['claimable']);
            $item->npl = $this->checkvaluefloat($myLeaveSumm['npl']) ?? 0;
            $item->takenel = $this->checkvaluefloat($myLeaveSumm['EmergencyLeaveValue']);
            $item->takenal = $this->checkvaluefloat($myLeaveSumm['annual']['taken'] + $myLeaveSumm['past_leaves']['annual']);
            $item->forfeitbf = $this->checkvaluefloat($forfeitbf);
            $item->forfeitbfadj = $this->checkvaluefloat($forfeitbfadj);
            $item->balance = $this->checkvaluefloat($myLeaveSumm['balance']) ?? 0;
            return $item;
        });

        $response = array(
            "draw" => intval($_GET['draw']),
            "iTotalRecords" => $leavesdataCount,
            "iTotalDisplayRecords" => $leavesdataCount,
            "aaData" => $annualentitle16
        );

        return json_encode($response);
        //return DataTables::of($annualentitle16)->make(true);
    }


    public function annualentitlePDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        $hourlyLeave = getSettingsValue('hourlyLeave');

        $url = str_replace(env('BASE_URL')."e-leave/reports/getYearlyEntitleListHR?", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=report&", session('rannual_pdf_data'));

        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $annualentitle16 = json_decode($response);

        $data = [
            'annualentitle16' => $annualentitle16,
            'timedate' => $timedate,
            'companyname' => $companyname,
            'hourlyLeave' => $hourlyLeave,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.annualentitlepdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Annual Entitle Report.pdf');
    }

    public function annualentitleexport(Request $request)
    {
        // $url1 = str_replace("length=10","length=-1",session('rannual_pdf_data'));
        //  $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        //$url = session('rannual_pdf_data');
        $url = str_replace(env('BASE_URL')."e-leave/reports/getYearlyEntitleListHR?", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=report&", session('rannual_pdf_data'));
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $annualentitle16 = json_decode($response);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Annual Entitle Report');
        $sheet->setCellValue('A' . 2, 'No');
        $sheet->setCellValue('B' . 2, 'Name');
        $sheet->setCellValue('C' . 2, 'Commerce');
        $sheet->setCellValue('D' . 2, 'BF');
        $sheet->setCellValue('E' . 2, 'BF Adj');
        $sheet->setCellValue('F' . 2, 'Entitle');
        $sheet->setCellValue('G' . 2, 'Earn');
        $sheet->setCellValue('H' . 2, 'Claimable');
        $sheet->setCellValue('I' . 2, 'NPL');
        $sheet->setCellValue('J' . 2, 'Taken EL');
        $sheet->setCellValue('K' . 2, 'Taken AL');
        $sheet->setCellValue('L' . 2, 'Forfeit BF');
        $sheet->setCellValue('M' . 2, 'Forfeit Adj');
        $sheet->setCellValue('N' . 2, 'Balance');

        $rows = 3;
        foreach ($annualentitle16 as $annualentitle) {
            $bf_forfeit = 0;
            if ($annualentitle->bf_forfeit == 1) {
                $actual_bf = ceil(round($annualentitle->entitle->brought_forward->annual, 2) * 2) / 2;
                $taken_bf = ceil(round($annualentitle->entitle->brought_forward->annual_taken, 2) * 2) / 2;
                $bf_forfeit = $actual_bf - $taken_bf;
            }
            $rl_forfeit = ceil(round($annualentitle->entitle->annual->rlForfeit, 2) * 2) / 2;
            $bf_adj_forfeit = 0;
            if ($annualentitle->bfadj_forfeit == 1) {
                $actual_bf_adj = ceil(round($annualentitle->entitle->brought_forward->annual_adj, 2) * 2) / 2;
                $taken_bf_adj = ceil(round($annualentitle->entitle->brought_forward->bfAdjLeaveTaken, 2) * 2) / 2;
                $bf_adj_forfeit = $actual_bf_adj - $taken_bf_adj;
            }

            $rows++;
            $sheet->setCellValue('A' . $rows, $annualentitle->No);
            $sheet->setCellValue('B' . $rows, mb_convert_encoding($annualentitle->name, "UTF-8", "HTML-ENTITIES"));
            $sheet->setCellValue('C' . $rows, $annualentitle->date_commence);
            $sheet->setCellValue('D' . $rows, ceil(round($annualentitle->entitle->brought_forward->annual, 2) * 2) / 2);
            $sheet->setCellValue('E' . $rows, $annualentitle->entitle->brought_forward->annual_adj);
            $sheet->setCellValue('F' . $rows, round($annualentitle->entitle->annual->entitle * 2) / 2);
            $sheet->setCellValue('G' . $rows, $annualentitle->entitle->earn);
            $sheet->setCellValue('H' . $rows, $annualentitle->claimable);
            $sheet->setCellValue('I' . $rows, $annualentitle->entitle->npl);
            $sheet->setCellValue('J' . $rows, floatval($annualentitle->entitle->EmergencyLeaveValue));
            $sheet->setCellValue('K' . $rows, floatval($annualentitle->entitle->annual->taken) + floatval($annualentitle->entitle->past_leaves->annual));
            $sheet->setCellValue('L' . $rows, $bf_forfeit);
            $sheet->setCellValue('M' . $rows, $bf_adj_forfeit);
            $sheet->setCellValue('N' . $rows, $annualentitle->balance);
        }


        $fileName = "annual-entitle-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function rmedicalentitle()
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();

        $c_key = 'leave_medicalentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }


        return view('hr.reports.medicalentitle', compact('categories', 'departments', 'branches', 'userPay','c_key', 'columnHideShowData'));
    }

    public function getrmedicalentitledata(Request $request)
    {
        session(['rmedical_pdf_data' => $request->getUri()]);
        if ($request->get('year') && $request->get('year') != '') {
            $year11 = request()->get('year');
        } else {
            $year11 = date('Y');
        }
        $medicalentitle11 = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')
            ->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');

        if ($request->get('name') && $request->get('name') != '') {
            $medicalentitle11->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = UserPay::where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $medicalentitle11->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = UserPay::where('department_id', $request->get('department'))->pluck('username')->toArray();
            $medicalentitle11->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = UserPay::where('category_id', $request->get('category'))->pluck('username')->toArray();
            $medicalentitle11->whereIn('user_personal.username', $categoryId);
        }
        $medicalentitle11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.employee_no as No, user_personal.employee_code, user_personal.name, user_personal.name as Name, b.date_commence, b.date_commence as join_year, b.date_commence as joining_year")
            ->where('user_personal.username', '!=', null)
            ->whereYear('b.date_commence', '<=', $year11)->whereRaw("(year(`b`.`date_resigned`) = $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.isDeleted', 0);
        $medicalentitle16 = $medicalentitle11->get();
        $medicalentitle16->map(function ($item) {
            if (request()->get('year') && request()->get('year') != '') {
                $year = request()->get('year');
            } else {
                $year = carbon()->year;
            }

            $myLeaveSumm = getYearlyEntitle($item->username, $year);
            $medleavetaken = $myLeaveSumm['medical']['taken'] + $myLeaveSumm['past_leaves']['medical'];
            $meentitle = $myLeaveSumm['medical']['entitle'];
            $mebalance = ($meentitle + $myLeaveSumm['brought_forward']['medical_adj']) - ($myLeaveSumm['medical']['taken'] + $myLeaveSumm['past_leaves']['medical']);
            if ($medleavetaken > $meentitle) {
                $balance = 0;
            } else {
                $balance = $mebalance;
            }
            $item->commerce = date('d-m-Y', strtotime($item->join_year));
            $item->bf = $this->checkvaluefloat($myLeaveSumm['brought_forward']['medical']);
            $item->bfadj = $this->checkvaluefloat($myLeaveSumm['brought_forward']['medical_adj']);
            $item->adj = 0;
            $item->entitle = $this->checkvaluefloat($meentitle);
            $item->claimable  = $this->checkvaluefloat($meentitle + $myLeaveSumm['brought_forward']['medical_adj']);
            $item->npl = $this->checkvaluefloat($myLeaveSumm['npl']) ?? 0;
            $item->taken = $this->checkvaluefloat($medleavetaken);
            $item->balance = $this->checkvaluefloat($balance) ?? 0;
            return $item;
        });
        // echo'<pre>';
        // print_r($medicalentitle16);
        // exit;
        return DataTables::of($medicalentitle16)->make(true);
    }

    public function medicalentitlePDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        $url = str_replace(env('BASE_URL')."e-leave/reports/getYearlyEntitleListHR?", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=report&", session('rmedical_pdf_data'));
        // $url1 = str_replace("length=10","length=-1",session('rmedical_pdf_data'));
        //  $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);

        //$url = session('rmedical_pdf_data');
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $medicalentitle16 = json_decode($response);
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        // $html = html_entity_decode(view('hr.reports.pdf.medicalentitlepdf', compact('medicalentitle16','timedate','companyname')));
        // $pdf = new Dompdf();
        // $pdf->loadHtml($html);
        // $pdf->setPaper('A4', 'portrait');
        // $pdf->render();
        // $pdf->stream('Medical Entitle Report');
        // return 1;

        $c_key = 'leave_medicalentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Date Commerce", "BF", "BF Adj", "Adj", "Entile", "Claimable", "NPL","Taken", "Balance"];


        $data = [
            'medicalentitle16' => $medicalentitle16,
            'timedate' => $timedate,
            'companyname' => $companyname,
            'c_key'=>$c_key,
            'columnHideShowData'=>$columnHideShowData,
            'arrColumns'=>$arrColumns,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.medicalentitlepdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Medical Entitle Report.pdf');
    }

    public function medicalentitleexport(Request $request)
    {
        // $url1 = str_replace("length=10","length=-1",session('rmedical_pdf_data'));
        //  $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        $url = str_replace(env('BASE_URL')."e-leave/reports/getYearlyEntitleListHR?", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=report&", session('rmedical_pdf_data'));
        //$url = session('rmedical_pdf_data');
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $medicalentitle16 = json_decode($response);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Medical Entitle Report');

        $c_key = 'leave_medicalentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Emp No", "Name", "Date Commerce", "BF", "BF Adj", "Adj", "Entile", "Claimable", "NPL","Taken", "Balance"];;

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        foreach ($medicalentitle16 as $medicalentitle) {
            $mebalance = ((floatval($medicalentitle->entitle->brought_forward->medical) + ((round($medicalentitle->entitle->medical->entitle * 2)) / 2) + floatval($medicalentitle->entitle->brought_forward->medical_adj)) - (floatval($medicalentitle->entitle->medical->taken) + floatval($medicalentitle->entitle->past_leaves->medical)));
            $medleavetaken = (floatval($medicalentitle->entitle->medical->taken) + floatval($medicalentitle->entitle->past_leaves->medical));

            $mneg = abs($mebalance);
            $adj = 0;
            $meentitle = $medicalentitle->entitle->medical->entitle;
            if ($medleavetaken > $meentitle) {
                $npl = 0;
                $balance = 0;
            } else {
                $npl = $medicalentitle->entitle->npl;
                $converted = floatval(round($mebalance, 2));
                $decimal = ($converted - intval($converted, 10));
                $decimal = round($decimal * 10);
                if ($decimal == 5) {
                    $balance = (intval($converted, 10) + 0.5);
                }
                if (($decimal < 4) || ($decimal > 6)) {
                    $balance = round($converted);
                } else {
                    $balance = (intval($converted, 10) + 0.5);
                }
            }

            $entile = (round($medicalentitle->entitle->medical->entitle * 2)) / 2;
            $claimable = (round($medicalentitle->entitle->medical->claimable * 2)) / 2;
            $medicaltaken = floatval($medicalentitle->entitle->medical->taken) + floatval($medicalentitle->entitle->past_leaves->medical);

            $rows++;

            $arrRows = [$medicalentitle->No, mb_convert_encoding($medicalentitle->name, "UTF-8", "HTML-ENTITIES"), $medicalentitle->date_commence, $medicalentitle->entitle->brought_forward->medical, $medicalentitle->entitle->brought_forward->medical_adj,$adj,$entile, $claimable,$npl,$medicaltaken, $medicalentitle->mbalance];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }


        $fileName = "medical-entitle-report.xlsx";
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }
    public function checkvaluefloat($val)
    {
        $val1 = (sprintf("%0.2f", $val) * 100) / 100;
        $str1 = explode(".", $val1);
        if (count($str1) == 2) {
            $val11 = $str1[0];
            $val12 = '0.' . $str1[1];
            if ($val12 < 0.25) {
                $val13 = $val11;
            } elseif ($val12 > 0.24 && $val12 < 0.51) {
                $val13 = $val11 + 0.5;
            } elseif ($val12 > 0.50 && $val12 < 0.75) {
                $val13 = $val11 + 0.5;
            } elseif ($val12 > 0.74 && $val12 < 1.00) {
                $val13 = $val11 + 1;
            } else {
                $val13 = $val11;
            }
        } else {
            $val13 = $str1[0];
        }

        return $val13;
    }
    public function rrlentitle()
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();

        $c_key = 'leave_rlentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        return view('hr.reports.rlentitle', compact('categories', 'departments', 'branches', 'userPay', 'c_key', 'columnHideShowData'));
    }

    public function getrrlentitledata(Request $request)
    {
        session(['rreplacement_pdf_data' => $request->getUri()]);
        //       return DB::transaction(function($connection) use( $request) {
        if ($request->get('year') && $request->get('year') != '') {
            $year11 = request()->get('year');
        } else {
            $year11 = date('Y');
        }
        if ($request->auth_id != '') {
            $user = DB::table('users')->where('id', $request->auth_id)->first();
        } else {
            $user = DB::table('users')->where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", $user->username);
        $permission_val = $this->getPermissionValue("hr", $user->username);
        $approverId = $user->username;
        $approver_array = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
        $approver_str = "";
        for ($i = 0; $i < count($approver_array); $i++) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ", ";
            }
        }
        $leavedataCount = DB::table('user_personal')->leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');
        //         // $rlentitle11 = UserPersonal::leftjoin('user_pay as b','user_personal.username','=','b.username')
        //         //                 ->leftjoin('branch as c','b.branch_id','=','c.id')->leftjoin('users as d','d.username','=','user_personal.username')->leftjoin('user_category as e','e.username','=','user_personal.username')->leftjoin('replacement_duration as f','f.');

        //         $rlentitle11 = $connection->table('user_personal')->leftjoin('user_pay as b','user_personal.username','=','b.username')->leftjoin('branch as c','b.branch_id','=','c.id');


        if ($request->get('name') && $request->get('name') != '') {
            // $rlentitle11->where(function($query){
            //     $query->where('user_personal.name', 'like', '%'.request()->get('name').'%')->orwhere('user_personal.employee_no', 'like', '%'.request()->get('name').'%');
            // });

            $leavedataCount->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = DB::table('user_pay')->where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            //$rlentitle11->whereIn('user_personal.username',$branchId);
            $leavedataCount->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = DB::table('user_pay')->where('department_id', $request->get('department'))->pluck('username')->toArray();
            //$rlentitle11->whereIn('user_personal.username',$departmentId);
            $leavedataCount->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = DB::table('user_pay')->where('category_id', $request->get('category'))->pluck('username')->toArray();
            //$rlentitle11->whereIn('user_personal.username',$categoryId);
            $leavedataCount->whereIn('user_personal.username', $categoryId);
        }
        if ($request->get('year') && $request->get('year') != '') {
            //$rlentitle11->whereYear('b.date_commence','<=',$request->get('year'));
            $leavedataCount->whereYear('b.date_commence', '<=', $request->get('year'));
        }
        //         $rlentitle11->selectRaw("user_personal.username, user_personal.employee_no, user_personal.employee_no as No, user_personal.employee_code, user_personal.name, user_personal.name as Name, b.date_commence, b.date_commence as join_year, b.date_commence as joining_year")
        //         ->where('user_personal.username','!=',null)
        //         ->whereYear('b.date_commence','<=',$year11)->whereRaw("(year(`b`.`date_resigned`) = $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.isDeleted',0);

        if ($ActiveUserShownStatus == 1) {
            //$rlentitle11->whereRaw("( b.pay_status='1' or b.pay_status='0')");
            $leavedataCount->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            //$rlentitle11->where('b.pay_status','1');
            $leavedataCount->where('b.pay_status', '1');
        }

        if ($hr_viewStatus == 1) {
            $leavedataCount->where('user_personal.username', $approverId);
            //	$rlentitle11->where('user_personal.username',$approverId);
            //	$query .= " and a.username= '".$approverId."' ";
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
            //	$rlentitle11->where('b.branch_id',$logged_userGroups->branch_id)->where('b.category_id',$logged_userGroups->category_id)->where('b.department_id',$logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $leavedataCount->where('c.state', $state_nm);
        }
        $leavedataCount = $leavedataCount->whereYear('b.date_commence', '<=', $year11)->whereRaw("(year(`b`.`date_resigned`) >= $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);


        $leavesdataCount = $leavedataCount->count();
        //         $length = $leavesdataCount;
        //         if(isset($_GET['length'])  && $_GET['length'] > 0){
        //             $length = $_GET['length'];
        //         }
        //         // dd($rlentitle18);
        //         //session(['rreplacement_pdf_data' => $request->getUri()]);
        //         $rlentitle16 = $rlentitle11->skip($offset)->take($length)->get();
        //       // dd($rlentitle16);
        //         $rlentitle16->map(function($item,$index) use( $connection) {

        //             if(request()->get('year')&& request()->get('year') != ''){
        //                 $year=request()->get('year');
        //             } else {
        //                 $year = carbon()->year;
        //             }
        //             $username = $item->username;
        //             $date_commence = $item->date_commence;
        // 			$joiningDate = strtotime($date_commence);

        //             $myLeaveSummSm = getYearlyrlEntitleList($item->username, $year);
        //             // $myLeaveSummSm='';
        //             // dd($myLeaveSummSm);
        //              try {
        //                 $myLeaveSummSm= $myLeaveSummSm[0];
        //              } catch (\Exception $th) {
        //                  $myLeaveSummSm='';

        //              }
        //              if($myLeaveSummSm!=''){
        //                  //dd($myLeaveSummSm);
        //             if($myLeaveSummSm->bf_forfeit == 1){
        //                 $actual_bf = $myLeaveSummSm->entitle['brought_forward']['Other_pay'];
        //                 $taken_bf = $myLeaveSummSm->entitle['EmergencyLeaveValue'];
        //                 $past_leave = $myLeaveSummSm->entitle['past_leave_forfeit'];
        //                 if($actual_bf>0){
        //                     $bf_forfeit = $actual_bf - $taken_bf - $past_leave;
        //                 }else{
        //                     $bf_forfeit = $actual_bf - $taken_bf - $past_leave;
        //                 }
        //             }else{
        //                 $bf_forfeit =  $myLeaveSummSm->bf_forfeit;
        //             }
        //             $item->commerce = date('d-m-Y',strtotime($item->join_year));
        //             $item->bf = $this->checkvaluefloat($myLeaveSummSm->entitle['brought_forward']['Other_pay']);
        //             $item->bfadj = $this->checkvaluefloat($myLeaveSummSm->entitle['adjust_leaves']);
        //             $item->granted = $this->checkvaluefloat($myLeaveSummSm->entitle['Other_pay']['granted']);
        //             $item->taken = $this->checkvaluefloat($myLeaveSummSm->entitle['Other_pay']['taken']+ $myLeaveSummSm->entitle['past_leaves']['replacement']);
        //             $item->forfeit = $this->checkvaluefloat($bf_forfeit);
        //             $item->balance = $this->checkvaluefloat($myLeaveSummSm->balance) ?? 0;
        //             return $item;
        //              }
        //              else{
        //             $item->commerce = date('d-m-Y',strtotime($item->join_year));
        //             $item->bf = 0;
        //             $item->bfadj = 0;
        //             $item->granted = 0;
        //             $item->taken = 0;
        //             $item->forfeit = 0;
        //             $item->balance = 0;
        //             return $item;
        //              }

        //         });
        //       if(isset($_GET['order'][0]['column'])){
        //             $collection = collect($rlentitle16);
        //             if($_GET['order'][0]['column']==0){
        //                 $ocolumn="No";
        //             }
        //             elseif($_GET['order'][0]['column']==1){
        //                 $ocolumn="name";
        //             }
        //             elseif($_GET['order'][0]['column']==2){
        //                 $ocolumn="join_year";
        //             }
        //             elseif($_GET['order'][0]['column']==3){
        //                 $ocolumn="bf";
        //             }
        //             elseif($_GET['order'][0]['column']==4){
        //                 $ocolumn="bfadj";
        //             }
        //             elseif($_GET['order'][0]['column']==5){
        //                 $ocolumn="granted";
        //             }
        //             elseif($_GET['order'][0]['column']==6){
        //                 $ocolumn="taken";
        //             }
        //             elseif($_GET['order'][0]['column']==7){
        //                 $ocolumn="forfeit";
        //             }
        //             elseif($_GET['order'][0]['column']==8){
        //                 $ocolumn="balance";
        //             }
        //             if($_GET['order'][0]['dir']=='asc'){
        //                 $rlentitle16 =  $collection->sortBy($ocolumn)->values();
        //             }
        //             else{
        //                 $rlentitle16 =  $collection->sortByDesc($ocolumn)->values();
        //             }

        //         }
        //         else{
        //             $rlentitle16   = $rlentitle16;
        //         }
        //       $response = array(
        //             "draw" => intval($_GET['draw']),
        //             "iTotalRecords" => $leavesdataCount,
        //             "iTotalDisplayRecords" => $leavesdataCount,
        //             "aaData" => $rlentitle16
        //         ); 

        //         return json_encode($response);
        //         });
        $ln = $_GET['length'];
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/reports/getrrlentitledata?", env('CURL_URL')."public/rlentitle.php?action=pdf&pagetype=report&add_limit=yes&auth_id=$aid&totalemp=$leavesdataCount&rlimit=$ln&test=1", $request->getUri());
        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $rlentitle16 = json_decode($response);
        // dd($rlentitle16->totalemp);
        // return DataTables::of($rlentitle16)->make(true);
        $responses = array(
            "draw" => intval($_GET['draw']),
            "iTotalRecords" => $leavesdataCount,
            "iTotalDisplayRecords" => $leavesdataCount,
            "aaData" => $rlentitle16
        );

        return json_encode($responses);
        //return DataTables::of($rlentitle16)->make(true);
    }

    public function rlentitlePDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/reports/getrrlentitledata?", env('CURL_URL')."public/rlentitle.php?action=pdf&pagetype=report&auth_id=$aid&", session('rreplacement_pdf_data'));
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $rlentitle16 = json_decode($response);

        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();

        $c_key = 'leave_rlentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Date Commerce", "BF", "BF Adj", "Granted", "Taken", "Forfeit", "Balance"];


        $data = [
            'rlentitle16' => $rlentitle16,
            'timedate' => $timedate,
            'companyname' => $companyname,
            'c_key'=>$c_key,
            'columnHideShowData'=>$columnHideShowData,
            'arrColumns'=>$arrColumns,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.rlentitlepdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Replacement Entitle Report.pdf');
    }

    public function rlentitleexport(Request $request)
    {
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/reports/getrrlentitledata?", env('CURL_URL')."public/rlentitle.php?action=pdf&pagetype=report&auth_id=$aid&", session('rreplacement_pdf_data'));
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $rlentitle16 = json_decode($response);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'RL Entitle Report');

        $c_key = 'leave_rlentitle';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["Emp No", "Name", "Date Commerce", "BF", "BF Adj", "Granted", "Taken","Forfeit", "Balance"];;

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rows = 2;
        foreach ($rlentitle16 as $rlentitle) {

            $rows++;

            $arrRows = [$rlentitle->No, mb_convert_encoding($rlentitle->name, "UTF-8", "HTML-ENTITIES"), $rlentitle->commerce, $rlentitle->bf, $rlentitle->bfadj, $rlentitle->granted,$rlentitle->taken, $rlentitle->forfeit,$rlentitle->balance];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }
        }


        $fileName = "rl-entitle-report.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }


    public function leavesummary(Request $request)
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $leaveTypes  = Leavetype::orderBy('name', 'asc')->where('is_show', 1)->get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();

        $c_key = 'leave_summary_report';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }


        return view('hr.leavesummary', compact('categories', 'departments', 'branches', 'leaveTypes', 'userPay', 'c_key', 'columnHideShowData'));
    }

    
    public function getleavesummarydata(Request $request)
    {
        $offset = 0;

        if (isset($_GET['order'][0]['column'])) {
            if (session('lstart')) {
                $url1 = str_replace("start=0", "start=" . session('lstart'), $request->getUri());

                session(['leavesummary_pdf_data' => $url1]);
                $offset = session('lstart');
            } else {
                session(['leavesummary_pdf_data' => $request->getUri()]);
            }
        } else {
            session(['leavesummary_pdf_data' => $request->getUri()]);
            if (isset($_GET['start'])) {
                session(['lstart' => $_GET['start']]);
                $offset = $_GET['start'];
            }
        }

        $need_to_check = false;
        if ($request->get('leave_no') != '') {
            $need_to_check = true;
        }
        if ($request->get('year') && $request->get('year') != '') {
            $year11 = request()->get('year');
        } else {
            $year11 = date('Y');
        }
        $days = 0;
        for ($month = 1; $month <= 12; $month++) {
            $days = $days + cal_days_in_month(CAL_GREGORIAN, $month, $year11);
        }
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", $user->username);
        $permission_val = $this->getPermissionValue("hr", $user->username);
        $approverId = $user->username;
        $approver_array = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
        $approver_str = "";
        for ($i = 0; $i < count($approver_array); $i++) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ", ";
            }
        }
        $leavedataCount = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');
        if ($request->get('name') && $request->get('name') != '') {
            $leavedataCount->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
        }
        $usernames = [];
        if ($request->get('branch') && $request->get('branch') != '') {
            $leavedataCount->where('b.branch_id', $request->get('branch'));
        }

        if ($request->get('department') && $request->get('department') != '') {
            $leavedataCount->where('b.department_id', $request->get('department'));
        }

        if ($request->get('category') && $request->get('category') != '') {
            $leavedataCount->where('b.category_id', $request->get('category'));
        }

        if ($ActiveUserShownStatus == 1) {
            $leavedataCount->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $leavedataCount->where('b.pay_status', '1');
        }

        if ($hr_viewStatus == 1) {
            $leavedataCount->where('user_personal.username', $approverId);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $leavedataCount->where('c.state', $state_nm);
        }



        $leavedataCount = $leavedataCount->whereYear('b.date_commence', '<=', $year11)
            ->whereRaw("(year(`b`.`date_resigned`) >= $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);

        $leavesdataCount = $leavedataCount->count();


        // dd($offset);
        $ln = $_GET['length'];
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getleavesummarydata?", env('CURL_URL')."public/leavesummary.php?action=pdf&pagetype=report&add_limit=yes&auth_id=$aid&offset=$offset&totalemp=$leavesdataCount&rlimit=$ln&test=1", session('leavesummary_pdf_data'));
        //dd($url);
        //dd($url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $count = $leavesdataCount;
        $usersResult = json_decode($response);
        if (isset($_GET['function_type'])) {
            if (isset($_GET['leave_no'])) {
                $count = count($usersResult);
            }
        }
        // dd(count($usersResult));
        // dd($rlentitle16->totalemp);
        // return DataTables::of($rlentitle16)->make(true);

        $responses = array(
            "draw" => intval($_GET['draw']),
            // "page" => 1,
            // "pages" => 6,
            //"start" => 10,
            // "end" => 20,
            // "length" => 10,
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $usersResult
        );

        return json_encode($responses);
        // $response = array(
        //     "draw" => intval($_GET['draw']),
        //     "iTotalRecords" => $leavesdataCount,
        //     "iTotalDisplayRecords" => $leavesdataCount,
        //     "aaData" => $usersResult
        // ); 

        // return json_encode($response);
        //exit;
        // $datatable = DataTables::of($leavesdata)->with([
        //     "recordsTotal" => $leavesdataCount,
        //     "recordsFiltered" => $leavesdataCount,
        //   ])->make(true);
        // dd($usersResult,$datatable);
        //return $datatable;
    }

    public function leavesummaryPDF(Request $request)
    {

        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        // $url1 = str_replace("length=10","length=-1",session('leavesummary_pdf_data'));
        // $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        //$url = session('leavesummary_pdf_data');
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getleavesummarydata?", env('CURL_URL')."public/leavesummary.php?action=pdf&pagetype=report&auth_id=$aid&", session('leavesummary_pdf_data'));
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        //dd(json_decode($response));
        $leavessummary = json_decode($response);
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        // $html = html_entity_decode(view('hr.reports.pdf.leavesummarypdf', compact('leavessummary','timedate','companyname')));
        // $pdf = new Dompdf();
        // $pdf->loadHtml($html);
        // $pdf->setPaper('A4', 'portrait');
        // $pdf->render();
        // $pdf->stream('Leave Summary');
        // return 1;

        $c_key = 'leave_summary_report';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["No", "Name", "Join Date", "Attendance", "AL", "MC", "MT", "MR", "CL","HL","EX","PT","AD","RL","LS","AB","NPL","EL"];



        $data = [
            'leavessummary' => $leavessummary,
            'timedate' => $timedate,
            'companyname' => $companyname,
            'c_key'=>$c_key,
            'columnHideShowData'=>$columnHideShowData,
            'arrColumns'=>$arrColumns,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.leavesummarypdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Leave Summary.pdf');
    }

    public function leavesummaryexport(Request $request)
    {
        // $url1 = str_replace("length=10","length=-1",session('leavesummary_pdf_data'));
        // $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        //$url = session('leavesummary_pdf_data');
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getleavesummarydata?", env('CURL_URL')."public/leavesummary.php?action=pdf&pagetype=report&auth_id=$aid&", session('leavesummary_pdf_data'));
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $leavessummary = json_decode($response);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Leave Summary');

        $c_key = 'leave_summary_report';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
            if($columnHideShowData){
                $columnHideShowData = $columnHideShowData->c_value;
            }else{
                $columnHideShowData = "[]";
            }
          $arrColumns = ["No", "Name", "Join Date", "Attendance", "AL", "MC", "MT", "MR", "CL","HL","EX","PT","AD","RL","LS","AB","NPL","EL"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 2, $arrColumns[$i]);
                $startFrom++;
            }
        }
        
        $rows = 2;
        foreach ($leavessummary as $leavesummary) {
            if ($leavesummary->sex == 1) {
                $mt = '-';
                $pt = $leavesummary->PaternityLeave;
            } else {
                $mt = $leavesummary->MaternityLeave;
                $pt = '-';
            }
            $rows++;
            $jYear = !is_null($leavesummary->join_year) ? date('d-m-Y', strtotime($leavesummary->join_year)) : "";
            $arrRows = [$leavesummary->No, mb_convert_encoding($leavesummary->name, "UTF-8", "HTML-ENTITIES"), $jYear, $leavesummary->AnnualLeave, $leavesummary->MedicalLeave, $mt,$leavesummary->MarriageLeave, $leavesummary->CompassionateLeave,$leavesummary->HospitalLeave,$leavesummary->ExaminationLeave,$pt,$leavesummary->Advance,$leavesummary->ReplacementLeave,$leavesummary->Line_ShutLeave,$leavesummary->AbsentLeave,$leavesummary->NPLeave,$leavesummary->ELeave];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rows, $arrRows[$k]); 
                    $startFrom++;
                }
            }

        }


        $fileName = "leave-summary.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function other_leave_reports()
    {
        $categories  = Category::orderBy('name', 'asc')->get();
        $departments  = Department::orderBy('name', 'asc')->get();
        $branches  = Branch::orderBy('name', 'asc')->get();
        $leaveTypes  = Leavetype::orderBy('name', 'asc')->where('is_show', 1)->get();
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('hr.other_leave_report', compact('categories', 'departments', 'branches', 'leaveTypes', 'userPay'));
    }

    //     public function getotherleavereportdata(Request $request)
    //     {
    //         session(['otherleave_pdf_data' => $request->getUri()]);
    //         $need_to_check = false;
    // 		if ($request->get('leave_no') != '') {
    // 			$need_to_check = true;
    // 		}
    // 		if($request->get('year')&& $request->get('year') != '')
    //         {
    //             $year=request()->get('year');
    //             $year11=request()->get('year');
    //         } else {
    //             $year = carbon()->year;
    //             $year11 = date('Y');
    //         }
    //         if($request->auth_id!=''){
    //             $user = User::where('id' , $request->auth_id)->first();
    //         }
    //         else{
    //             $user = User::where('id' , Auth::id())->first();
    //         }

    //         if($request->get('datefrom')&& $request->get('datefrom') != '')
    //                         {
    //         $startDate = $request->get('datefrom');
    //                         }
    //         else{
    //             $startDate ='';
    //         }
    //         if($request->get('dateto')&& $request->get('dateto') != '')
    //                         {
    //         $endDate = $request->get('dateto');
    //                         }
    //         else{
    //             $endDate ='';
    //         }

    //         $cutOffDate = getCutOffDate();
    //         $cutOffMonth = getCutOffMonth();

    //         $cutOffStartDate = getCutOffStartDate();
    //         $cutOffStartMonth = getCutOffStartMonth();

    //         if($cutOffStartMonth!=1){
    //         $startYear = $year-1;
    //         }else{
    //             $startYear = $year;
    //         }

    //         if($startDate == null){
    //             $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    //         }

    //         if($endDate == null){
    //             $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
    //         }

    //         $ActiveUserShownStatus1=DB::table('settings')->where('field','active_user_shown')->where('company_id',$user->company_id)->first();
    // 		$ActiveUserShownStatus = $ActiveUserShownStatus1->value;
    // 		$hr_viewStatus = $this->getPermissionValue("hr_view_all",$user->username);
    // 		$permission_val = $this->getPermissionValue("hr", $user->username);
    // 		$approverId = $user->username;
    // 		$approver_array = DB::table('map_employee_approver as a')->leftjoin('user_personal as b','a.employee_id','=','b.username')->where('a.approver_id',$approverId)->selectRaw("distinct b.username")->get();
    // 		$approver_str = "";
    // 		for($i=0;$i<count($approver_array);$i++){
    // 			$approver_str .= "'".$approver_array[$i]->username."'";
    // 			if($i<(count($approver_array)-1)){
    // 				$approver_str .= ", ";
    // 			}
    // 		}
    //         $leavedataCount = UserPersonal::leftjoin('user_pay as b','user_personal.username','=','b.username' )->leftjoin('branch as c','b.branch_id','=','c.id');
    //         $leavedata = UserPersonal::leftjoin('user_pay as b','user_personal.username','=','b.username')->leftjoin('branch as c','b.branch_id','=','c.id');
    //                         if($request->get('name') && $request->get('name') != '')
    //                         {
    //                             $leavedataCount->where(function($query){
    //                                 $query->where('user_personal.name', 'like', '%'.request()->get('name').'%')
    //                                     ->orwhere('user_personal.employee_no', 'like', '%'.request()->get('name').'%');
    //                             });
    //                             $leavedata->where(function($query){
    //                                 $query->where('user_personal.name', 'like', '%'.request()->get('name').'%')->orwhere('user_personal.employee_no', 'like', '%'.request()->get('name').'%');
    //                             });
    //                         }
    //                          if($request->get('branch') && $request->get('branch') != '')
    //                         {
    //                             $leavedata->where('b.branch_id',$request->get('branch'));
    //                             $leavedataCount->where('b.branch_id',$request->get('branch'));
    //                         }
    //                         if($request->get('department') && $request->get('department') != '')
    //                         {
    //                             $leavedata->where('b.department_id',$request->get('department'));
    //                             $leavedataCount->where('b.department_id',$request->get('department'));
    //                         }

    //                         if($request->get('category')&& $request->get('category') != '')
    //                         {
    //                             $leavedata->where('b.category_id',$request->get('category'));
    //                             $leavedataCount->where('b.category_id',$request->get('category'));
    //                         }
    //                         if($ActiveUserShownStatus==1){
    //                             $leavedata->whereRaw("( b.pay_status='1' or b.pay_status='0')");
    //                             $leavedataCount->whereRaw("( b.pay_status='1' or b.pay_status='0')");
    //                         }
    //                         else{
    //                             $leavedata->where('b.pay_status','1');
    //                             $leavedataCount->where('b.pay_status','1');
    //                         }

    //         if($hr_viewStatus==1){
    // 		    $leavedataCount->where('user_personal.username',$approverId);
    // 			$leavedata->where('user_personal.username',$approverId);
    // 		//	$query .= " and a.username= '".$approverId."' ";
    // 		}else if($hr_viewStatus==2){
    // 			$logged_userGroups = getUserGroups($approverId);
    //         	$leavedataCount->where('b.branch_id',$logged_userGroups->branch_id)->where('b.category_id',$logged_userGroups->category_id)->where('b.department_id',$logged_userGroups->department_id);
    // 			$leavedata->where('b.branch_id',$logged_userGroups->branch_id)->where('b.category_id',$logged_userGroups->category_id)->where('b.department_id',$logged_userGroups->department_id);
    // 		}else if($hr_viewStatus==3){
    // 			$logged_userGroups = getUserGroups($approverId);
    // 			$leavedataCount->where('b.branch_id',$logged_userGroups->branch_id);
    // 			$leavedata->where('b.branch_id',$logged_userGroups->branch_id);

    // 		}else if($hr_viewStatus==4){
    // 			$userbranchId = $this->getUserBranchId($approverId);
    // 			$state_nm = $this->getstatebybranch($userbranchId);
    // 			 $leavedataCount->where('c.state',$state_nm);
    // 			 $leavedata->where('c.state',$state_nm);
    // 		}

    //         $leavedata->selectRaw("user_personal.username, user_personal.employee_no as No, user_personal.name, user_personal.sex, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Maternity' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as MaternityLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Maternity' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as MaternityPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Marriage' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as MarriageLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Marriage' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as MarriagePastLeave,  (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Compassionate' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as CompassionateLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Compassionate' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as CompassionatePastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Hospital' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as HospitalLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Hospital' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as HospitalPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Examination' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as ExaminationLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Examination' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as ExaminationPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Paternity' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as PaternityLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Paternity' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as PaternityPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Advance' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as AdvanceLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Advance' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as AdvancePastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Other_pay' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as ReplacementLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Other_pay' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as ReplacementPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Line_Shut' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as Line_ShutLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Line_Shut' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as Line_ShutPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Absent' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as AbsentLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Absent' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as AbsentPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='NPL' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as NPLLeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='NPL' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as NPLPastLeave, (SELECT sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken FROM leave_days left join leave_list on leave_list.id = leave_days.leave_id where leave_days.status=1 and leave_list.type='Emergency' and leave_days.username=user_personal.username and leave_days.date >= '".$startDate."' and leave_days.date <= '".$endDate."' ) as ELeave, (SELECT sum(total_leave_days) as leave_taken FROM leave_past where username=user_personal.username and type='Emergency' and start_date >= '".$startDate."' and end_date <= '".$endDate."' ) as ELPastLeave")
    //         ->whereYear('b.date_commence','<=',$year11)->where('user_personal.username','!=',null)
    //         ->where('user_personal.isDeleted',0)->whereRaw(" (DATE_FORMAT(b.date_resigned,'%Y') >= '$year' OR DATE_FORMAT(b.date_resigned,'%Y') = '0000' ) and DATE_FORMAT(b.date_commence,'%Y') <='$year'  ");

    //          $leavedataCount = $leavedataCount->whereYear('b.date_commence','<=',$year11)
    //         ->whereRaw("(year(`b`.`date_resigned`) = $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username','!=',null)->where('user_personal.isDeleted',0);


    //         $offset = 0;
    //         if(isset($_GET['start'])){
    //             $offset = $_GET['start'];
    //         }
    //         $leavesdataCount = $leavedataCount->count();  
    //         $length = $leavesdataCount;
    //         if(isset($_GET['length'])  && $_GET['length'] > 0){
    //             $length = $_GET['length'];
    //         }

    //         $leavesdata = $leavedata->skip($offset)->take($length)->get();
    //       // dd($leavesdata); 
    //         //$leavesdata = $leavedata->get();


    //         //$leavesdata = $leavedata->get();


    //         $userLeaveNoArray = array();
    // 		$no = 0;
    // 		$usernameArray = array();


    //         for($i=0; $i < count($leavesdata); $i++){
    //             $username = $leavesdata[$i]["username"];
    //             $max_rl = getAdjustmentLeaveCount($username, $year, 1);
    //           // dd($max_rl);
    //             $max_leave = getMaxLeaveValueForUser($username);

    // 			$leavesdata[$i]["MaternityLeave"] = (float)($leavesdata[$i]->MaternityLeave ?? 0) + $leavesdata[$i]->MaternityPastLeave ?? 0;
    // 			$leavesdata[$i]["MarriageLeave"] = (float)($leavesdata[$i]->MarriageLeave ?? 0) + $leavesdata[$i]->MarriagePastLeave ?? 0;
    // 			$leavesdata[$i]["CompassionateLeave"] = (float)($leavesdata[$i]->CompassionateLeave ?? 0) + $leavesdata[$i]->CompassionatePastLeave ?? 0;
    // 			$leavesdata[$i]["HospitalLeave"] = (float)($leavesdata[$i]->HospitalLeave ?? 0) + $leavesdata[$i]->HospitalPastLeave ?? 0;
    // 			$leavesdata[$i]["ExaminationLeave"] = (float)($leavesdata[$i]->ExaminationLeave ?? 0) + $leavesdata[$i]->ExaminationPastLeave ?? 0;
    // 			$leavesdata[$i]["PaternityLeave"] = (float)($leavesdata[$i]->PaternityLeave ?? 0) + $leavesdata[$i]->PaternityPastLeave ?? 0;
    // 			$leavesdata[$i]["Advance"] = (float)($leavesdata[$i]->AdvanceLeave ?? 0 )+ $leavesdata[$i]->AdvancePastLeave ?? 0;
    // 			$leavesdata[$i]["ReplacementLeave"] = (float)($leavesdata[$i]->ReplacementLeave ?? 0) + $leavesdata[$i]->ReplacementPastLeave ?? 0;
    // 			$leavesdata[$i]["Line_ShutLeave"] = (float)($leavesdata[$i]->Line_ShutLeave ?? 0) + $leavesdata[$i]->Line_ShutPastLeave ?? 0;
    // 			$leavesdata[$i]["AbsentLeave"] = (float)($leavesdata[$i]->AbsentLeave ?? 0) + $leavesdata[$i]->AbsentPastLeave ?? 0;
    // 			$leavesdata[$i]["NPLeave"] = (float)($leavesdata[$i]->NPLeave ?? 0) + $leavesdata[$i]->NPLPastLeave ?? 0;
    //             $leavesdata[$i]["ELeave"] = (float)($leavesdata[$i]->ELeave ?? 0) + $leavesdata[$i]->ELPastLeave ?? 0;



    //             $leavesdata[$i]["MaternityMAX"] = array_key_exists("Maternity", $max_leave) ? $max_leave['Maternity']+0 : 0;
    //             $leavesdata[$i]["MarriageMAX"] = array_key_exists("Marriage", $max_leave) ? $max_leave['Marriage']+0 : 0;
    //             $leavesdata[$i]["CompassionateMAX"] = array_key_exists("Compassionate", $max_leave) ? $max_leave['Compassionate']+0 : 0;
    //             $leavesdata[$i]["HospitalMAX"] = array_key_exists("Hospital", $max_leave) ? $max_leave['Hospital']+0 : 0;
    //             $leavesdata[$i]["ExaminationMAX"] = array_key_exists("Examination", $max_leave) ? $max_leave['Examination']+0 : 0;
    //             $leavesdata[$i]["PaternityMAX"] = array_key_exists("Paternity", $max_leave) ? $max_leave['Paternity']+0 : 0;
    //             $leavesdata[$i]["AdvanceMAX"] = array_key_exists("Advance", $max_leave) ? $max_leave['Advance']+0 : 0;
    //             $leavesdata[$i]["Other_payMAX"] = $max_rl+0;
    //             $leavesdata[$i]["Line_ShutMAX"] = array_key_exists("Line_Shut", $max_leave) ? $max_leave['Line_Shut']+0 : 0;
    //             $leavesdata[$i]["EmergencyMAX"] = array_key_exists("Emergency", $max_leave) ? $max_leave['Emergency']+0 : 0;


    //             if (!$need_to_check) {
    // 				$usersResult[$i] = $leavesdata[$i];
    // 				$usernameArray[$no] = $leavesdata[$i]['username'];
    // 				$userLeaveNoArray[$no] = $leavesdata[$i];
    // 				$no++;
    // 			} else {

    // 				switch ($request->get('leave_type')) {
    // 					case 'Annual':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'), $leavesdata[$i]["AnnualLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Medical':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'), $leavesdata[$i]["MedicalLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Maternity':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["MaternityLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Marriage':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["MarriageLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Compassionate':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["CompassionateLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Hospital':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["HospitalLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 						}
    // 						break;
    // 					case 'Examination':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["ExaminationLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Paternity':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["PaternityLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Advance':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["Advance"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Other_pay':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["ReplacementLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Line_Shut':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["Line_ShutLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Absent':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["AbsentLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'NPL':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'), $leavesdata[$i]["NPLeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 					case 'Emergency':
    // 						if ($this->checkCount($request->get('function_type'), $request->get('leave_no'),  $leavesdata[$i]["ELeave"])) {
    // 							$usernameArray[$no] = $leavesdata[$i]['username'];
    // 							$userLeaveNoArray[$no] = $leavesdata[$i];
    // 							$no++;
    // 						}
    // 						break;
    // 				}
    // 			}
    // 		//	dd($usernameArray);
    // 		// dd($leavesdata);
    //         }
    //         //dd($usernameArray);

    //         $finalData = array();
    // 		if(count($usernameArray)>0){
    // 			$finalData = $usernameArray;
    // 			for($i = 0; $i < count($finalData); $i++)
    // 			{
    // 				for($j=0;$j<count($userLeaveNoArray);$j++){
    // 					if($userLeaveNoArray[$j]['username']===$finalData[$i]){
    // 						$finalData[$i] 		= $userLeaveNoArray[$j];
    // 					}
    // 				}
    // 			}
    // 		}else{
    // 			$finalData = array();
    // 		}

    // 		$usersResult = $finalData;
    //       if(isset($_GET['order'][0]['column'])){
    //             $collection = collect($usersResult);
    //             if($_GET['order'][0]['column']==0 || $_GET['order'][0]['column']==1){
    //                 if($_GET['order'][0]['column']==0){
    //                     $ocolumn="No";
    //                 }
    //                 else{
    //                     $ocolumn="name";
    //                 }

    //                 if($_GET['order'][0]['dir']=='asc'){
    //                     $usersResult =  $collection->sortBy($ocolumn)->values();
    //                 }
    //                 else{
    //                     $usersResult =  $collection->sortByDesc($ocolumn)->values();
    //                 }
    //             }
    //             else{
    //                 $usersResult   = $usersResult;
    //             }

    //         }
    //         else{
    //             $usersResult   = $usersResult;
    //         }
    //          $response = array(
    //             "draw" => intval($_GET['draw']),
    //             "iTotalRecords" => $leavesdataCount,
    //             "iTotalDisplayRecords" => $leavesdataCount,
    //             "aaData" => $usersResult
    //         ); 
    //         return json_encode($response);
    //         //return DataTables::of($usersResult)->make(true);
    //     }

    public function getotherleavereportdata(Request $request)
    {

        session(['otherleave_pdf_data' => $request->getUri()]);
        $need_to_check = false;
        if ($request->get('leave_no') != '') {
            $need_to_check = true;
        }
        if ($request->get('year') && $request->get('year') != '') {
            $year11 = request()->get('year');
        } else {
            $year11 = date('Y');
        }
        $days = 0;
        for ($month = 1; $month <= 12; $month++) {
            $days = $days + cal_days_in_month(CAL_GREGORIAN, $month, $year11);
        }
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", $user->username);
        $permission_val = $this->getPermissionValue("hr", $user->username);
        $approverId = $user->username;

        $leavedataCount = UserPersonal::leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');
        if ($request->get('name') && $request->get('name') != '') {
            $leavedataCount->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
        }
        $usernames = [];
        if ($request->get('branch') && $request->get('branch') != '') {
            $leavedataCount->where('b.branch_id', $request->get('branch'));
        }

        if ($request->get('department') && $request->get('department') != '') {
            $leavedataCount->where('b.department_id', $request->get('department'));
        }

        if ($request->get('category') && $request->get('category') != '') {
            $leavedataCount->where('b.category_id', $request->get('category'));
        }

        if ($ActiveUserShownStatus == 1) {
            $leavedataCount->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $leavedataCount->where('b.pay_status', '1');
        }

        if ($hr_viewStatus == 1) {
            $leavedataCount->where('user_personal.username', $approverId);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $leavedataCount->where('b.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $leavedataCount->where('c.state', $state_nm);
        }



        $leavedataCount = $leavedataCount->whereYear('b.date_commence', '<=', $year11)
            ->whereRaw("(year(`b`.`date_resigned`) >= $year11 or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);

        $leavesdataCount = $leavedataCount->count();

        $ln = $_GET['length'];
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getotherleavereportdata?", env('CURL_URL')."public/otherleave.php?action=pdf&pagetype=report&add_limit=yes&auth_id=$aid&totalemp=$leavesdataCount&rlimit=$ln&test=1", $request->getUri());
        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $count = $leavesdataCount;
        $usersResult = json_decode($response);
        if (isset($_GET['function_type'])) {
            if (isset($_GET['leave_no'])) {
                $count = count($usersResult);
            }
        }
        // dd($rlentitle16->totalemp);
        // return DataTables::of($rlentitle16)->make(true);
        $responses = array(
            "draw" => intval($_GET['draw']),
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $usersResult
        );

        return json_encode($responses);
        // $response = array(
        //     "draw" => intval($_GET['draw']),
        //     "iTotalRecords" => $leavesdataCount,
        //     "iTotalDisplayRecords" => $leavesdataCount,
        //     "aaData" => $usersResult
        // ); 

        // return json_encode($response);
        //exit;
        // $datatable = DataTables::of($leavesdata)->with([
        //     "recordsTotal" => $leavesdataCount,
        //     "recordsFiltered" => $leavesdataCount,
        //   ])->make(true);
        // dd($usersResult,$datatable);
        //return $datatable;
    }

    public function otherleavereportPDF(Request $request)
    {
        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');
        // $url1 = str_replace("length=10","length=-1",session('otherleave_pdf_data'));
        // $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        //$url = session('otherleave_pdf_data');
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getotherleavereportdata?", env('CURL_URL')."public/otherleave.php?action=pdf&pagetype=report&auth_id=$aid&", session('otherleave_pdf_data'));

        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $otherleavereports = json_decode($response);

        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        //return view('hr.reports.pdf.otherleavereportpdf', compact('otherleavereports','timedate','companyname'));
        // $html = html_entity_decode(view('hr.reports.pdf.otherleavereportpdf', compact('otherleavereports','timedate','companyname')));
        // $pdf = new Dompdf();
        // $pdf->loadHtml($html);
        // $pdf->setPaper('A4', 'portrait');
        // $pdf->render();
        // $pdf->stream('Other Leave Reports');
        // return 1;

        $data = [
            'otherleavereports' => $otherleavereports,
            'timedate' => $timedate,
            'companyname' => $companyname,
        ];
        $pdf = PDFSnappy::loadView('hr.reports.pdf.otherleavereportpdf', $data);
        $pdf->setPaper('A4', 'portrait');
        return $pdf->download('Other Leave Reports.pdf');
    }

    public function otherleavereportexport(Request $request)
    {
        // $url1 = str_replace("length=10","length=-1",session('otherleave_pdf_data'));
        // $url11 = str_replace("length=20","length=-1", $url1);
        // $url12 = str_replace("length=50","length=-1", $url11);
        // $url = str_replace("length=100","length=-1", $url12);
        //$url = session('otherleave_pdf_data');
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/getotherleavereportdata?", env('CURL_URL')."public/otherleave.php?action=pdf&pagetype=report&auth_id=$aid&", session('otherleave_pdf_data'));
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $otherleavereports = json_decode($response);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Other Leave Report');
        $sheet->setCellValue('A' . 2, 'No');
        $sheet->setCellValue('B' . 2, 'Name');
        $sheet->setCellValue('C' . 2, 'MT(Max)');
        $sheet->setCellValue('D' . 2, 'MT(Total)');
        $sheet->setCellValue('E' . 2, 'MT(Balance)');
        $sheet->setCellValue('F' . 2, 'MR(Max)');
        $sheet->setCellValue('G' . 2, 'MR(Total)');
        $sheet->setCellValue('H' . 2, 'MR(Balance)');
        $sheet->setCellValue('I' . 2, 'CL(Max)');
        $sheet->setCellValue('J' . 2, 'CL(Total)');
        $sheet->setCellValue('K' . 2, 'CL(Balance)');
        $sheet->setCellValue('L' . 2, 'HL(Max)');
        $sheet->setCellValue('M' . 2, 'HL(Total)');
        $sheet->setCellValue('N' . 2, 'HL(Balance)');
        $sheet->setCellValue('O' . 2, 'EX(Max)');
        $sheet->setCellValue('P' . 2, 'EX(Total)');
        $sheet->setCellValue('Q' . 2, 'EX(Balance)');
        $sheet->setCellValue('R' . 2, 'PT(Max)');
        $sheet->setCellValue('S' . 2, 'PT(Total)');
        $sheet->setCellValue('T' . 2, 'PT(Balance)');
        $sheet->setCellValue('U' . 2, 'AD(Max)');
        $sheet->setCellValue('V' . 2, 'AD(Total)');
        $sheet->setCellValue('W' . 2, 'AD(Balance)');
        $sheet->setCellValue('X' . 2, 'LS(Max)');
        $sheet->setCellValue('Y' . 2, 'LS(Total)');
        $sheet->setCellValue('Z' . 2, 'LS(Balance)');
        $sheet->setCellValue('AA' . 2, 'EL(Max)');
        $sheet->setCellValue('AB' . 2, 'EL(Total)');
        $sheet->setCellValue('AC' . 2, 'EL(Balance)');
        $rows = 2;
        foreach ($otherleavereports as $otherleavereport) {

            if ($otherleavereport->sex == 1) {
                $mmax = "-";
                $mleave = "-";
                $mbalance = "-";
                $pmax = $otherleavereport->PaternityMAX;
                $pleave = $otherleavereport->PaternityLeave;
                $pbalance = $otherleavereport->PaternityMAX - $otherleavereport->PaternityLeave;
            } else {
                $mmax = $otherleavereport->MaternityMAX;
                $mleave = $otherleavereport->MaternityLeave;
                $mbalance = $otherleavereport->MaternityMAX - $otherleavereport->MaternityLeave;
                $pmax = "-";
                $pleave = "-";
                $pbalance = "-";
            }
            $rows++;
            $sheet->setCellValue('A' . $rows, $otherleavereport->No);
            $sheet->setCellValue('B' . $rows, mb_convert_encoding($otherleavereport->name, "UTF-8", "HTML-ENTITIES"));
            $sheet->setCellValue('C' . $rows, $mmax);
            $sheet->setCellValue('D' . $rows, $mleave);
            $sheet->setCellValue('E' . $rows, $mbalance);
            $sheet->setCellValue('F' . $rows, $otherleavereport->MarriageMAX);
            $sheet->setCellValue('G' . $rows, $otherleavereport->MarriageLeave);
            $sheet->setCellValue('H' . $rows, $otherleavereport->MarriageMAX - $otherleavereport->MarriageLeave);
            $sheet->setCellValue('I' . $rows, $otherleavereport->CompassionateMAX);
            $sheet->setCellValue('J' . $rows, $otherleavereport->CompassionateLeave);
            $sheet->setCellValue('K' . $rows, $otherleavereport->CompassionateMAX - $otherleavereport->CompassionateLeave);
            $sheet->setCellValue('L' . $rows, $otherleavereport->HospitalMAX);
            $sheet->setCellValue('M' . $rows, $otherleavereport->HospitalLeave);
            $sheet->setCellValue('N' . $rows, $otherleavereport->HospitalMAX - $otherleavereport->HospitalLeave);
            $sheet->setCellValue('O' . $rows, $otherleavereport->ExaminationMAX);
            $sheet->setCellValue('P' . $rows, $otherleavereport->ExaminationLeave);
            $sheet->setCellValue('Q' . $rows, $otherleavereport->ExaminationMAX - $otherleavereport->ExaminationLeave);
            $sheet->setCellValue('R' . $rows, $pmax);
            $sheet->setCellValue('S' . $rows, $pleave);
            $sheet->setCellValue('T' . $rows, $pbalance);
            $sheet->setCellValue('U' . $rows, $otherleavereport->AdvanceMAX);
            $sheet->setCellValue('V' . $rows, $otherleavereport->Advance);
            $sheet->setCellValue('W' . $rows, $otherleavereport->AdvanceMAX - $otherleavereport->Advance);
            $sheet->setCellValue('X' . $rows, $otherleavereport->Line_ShutMAX);
            $sheet->setCellValue('Y' . $rows, $otherleavereport->Line_ShutLeave);
            $sheet->setCellValue('Z' . $rows, $otherleavereport->Line_ShutMAX - $otherleavereport->Line_ShutLeave);
            $sheet->setCellValue('AA' . $rows, $otherleavereport->EmergencyMAX);
            $sheet->setCellValue('AB' . $rows, $otherleavereport->ELeave);
            $sheet->setCellValue('AC' . $rows, $otherleavereport->EmergencyMAX - $otherleavereport->ELeave);
        }


        $fileName = "other-leave-reports.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }



    public function checkCount($functionType, $leaveno, $currentCount)
    {
        $return = false;
        switch ($functionType) {
            case '>':
                if ($currentCount > $leaveno) {
                    $return = true;
                }
                break;
            case '=':
                if ($currentCount == $leaveno) {
                    $return = true;
                }
                break;
            case '<':
                if ($currentCount < $leaveno) {
                    $return = true;
                }
                break;
            case '<=':
                if ($currentCount <= $leaveno) {
                    $return = true;
                }
                break;
            case '>=':
                if ($currentCount >= $leaveno) {
                    $return = true;
                }
                break;
        }
        return $return;
    }

    public function getYearlyLeaveGraphByLeaveTypedata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        // dd($leaveType);
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;
        $hours = gethours();

        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }
        if ($leaveType != '') {
            //dd($leaveType);
            $query .= "and b.type = '" . $leaveType . "' ";
        }
        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        $query .= " and a.status = '1'  ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
        } else {
            $query .= " group by month(a.date)";
        }



        $query2 = "select a.type as leavetype, sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.total_leave_days END) as no_days, month(a.start_date) as `month` ";
        $query2 .= "from leave_past a left join user_personal b on a.username=b.username left join user_pay ";
        $query2 .= "c on a.username=c.username";
        $query2 .= " left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id where 1  and year(a.start_date)='" . $year . "' ";
        if ($keyword != '') {
            $query2 .= ' and (b.name like ("' . $keyword . '%") OR b.employee_no like ("' . $keyword . '%") OR b.username like ("' . $keyword . '%")) ';
        }
        if ($currentOnly == '1') {
            $query2 .= " and DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query2 .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query2 .= "and c.pay_status = '1'";
        }
        if ($leaveType != '') {
            $query2 .= "and a.type = '" . $leaveType . "'";
        }
        if ($date != '') {
            $query2 .= "and a.start_date = '" . $date . "'";
        }
        if ($username != '') {
            $query2 .= "and a.username ='" . $username . "' ";
        }
        if ($branch_id != '') {
            $query2 .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query2 .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query2 .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query2 .= "group by `month`,leavetype";
        } else {
            $query2 .= "group by `month`";
        }

        //   dd("select leavetype, sum(no_days) as leaves, `month` from ( ".$query ." union all ". $query2.") as mainTable group by `month`,leavetype");
        if ($leaveType != '') {
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . " union all " . $query2 . ") as mainTable group by `month`,leavetype");
        } else {
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . " union all " . $query2 . ") as mainTable group by `month`");
        }

        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getYearlyLeaveGraphByLeaveTypePendingdata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;
        $hours = gethours();
        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }

        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        $query .= " and a.status = '0'  ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($leaveType != '') {
            $query .= "and b.type = '" . $leaveType . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
        } else {
            $query .= " group by month(a.date)";
        }
        if ($leaveType != '') {
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`,leavetype");
        } else {
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`");
        }

        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getYearlyLeaveGraphByLeaveTypeRejecteddata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;
        $hours = gethours();

        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }

        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        if ($leaveType != '') {
            $query .= "and b.type = '" . $leaveType . "'";
        }
        $query .= " and a.status = '2'  ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`,leavetype");
        } else {
            $query .= " group by month(a.date)";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`");
        }


        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getYearlyLeaveGraphByLeaveTypeRecommendeddata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;
        $hours = gethours();

        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }

        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($leaveType != '') {
            $query .= "and b.type = '" . $leaveType . "'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        $query .= " and a.status = '3'  ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`,leavetype");
        } else {
            $query .= " group by month(a.date)";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`");
        }

        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getYearlyLeaveGraphByLeaveTypeCancelleddata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;
        $hours = gethours();

        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }
        if ($leaveType != '') {
            $query .= "and b.type = '" . $leaveType . "'";
        }
        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        $query .= " and a.status = '4'  ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`,leavetype");
        } else {
            $query .= " group by month(a.date)";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`");
        }
        //dd($query11);
        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getYearlyLeaveGraphByLeaveTypeCancellationPendingdata($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '', $year)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly = $currentOnly1->value ?? 0;

        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        if ($year != '') {
            $year = $year;
        } else {
            $year = date('Y');
        }

        $query = "select b.type as leavetype, sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as 'no_days', month(a.date) as `month` ";
        $query .= " from leave_days a left join leave_list b on a.leave_id=b.id ";

        $query .= "left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";

        $query .= "left join user_personal f on a.username=f.username where 1 and year(a.date)='" . $year . "' ";

        if ($keyword != '') {
            $query .= ' and (f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%") OR f.username like ("' . $keyword . '%") ) ';
        }
        if ($leaveType != '') {
            $query .= "and b.type = '" . $leaveType . "'";
        }

        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= "and (c.pay_status = '1' or c.pay_status = '0')";
        } else {
            $query .= "and c.pay_status = '1'";
        }
        if ($date != '') {
            $query .= "and a.date = '" . $date . "'";
        }
        if ($username != '') {
            $query .= "and a.username ='" . $username . "' ";
        }
        $query .= " and a.status = '5' ";
        // $query .=" and a.status = '5' and b.type = '".$leaveType."' ";
        if ($branch_id != '') {
            $query .= "and c.branch_id ='" . $branch_id . "'";
        }
        if ($dept_id != '') {
            $query .= "and c.department_id ='" . $dept_id . "'";
        }
        if ($category_id != '') {

            $query .= "and c.category_id ='" . $category_id . "'";
        }
        if ($leaveType != '') {
            $query .= " group by month(a.date),b.type";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`,leavetype");
        } else {
            $query .= " group by month(a.date)";
            $masterArr = DB::select("select leavetype, sum(no_days) as leaves, `month` from ( " . $query . ") as mainTable group by `month`");
        }

        $leave_color = getleavecolorarry();

        return $masterArr;
    }

    public function getLeaveDetails($id)
    {
        $query = "select a.id, a.leave_id, a.username, c.name, c.employee_no, b.type, DATE_FORMAT(b.date_applied, '%m/%d/%Y') as date_applied_cal, DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, DATE_FORMAT(a.date, '%m/%d/%Y') as start_date_cal, ";
        $query .= "DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, CASE b.is_half_day ";
        $query .= "WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', a.status, b.reason, b.leave_category as leave_category, b.approver_id, ";
        $query .= "a.cancellation_reason, b.half_day_type,b.is_half_day, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,b.is_hourly from leave_days a left join leave_list b on a.leave_id=b.id ";
        $query .= " left join user_personal c on a.username=c.username where a.id = '$id' ";
        $result = DB::select($query);
        //echo $builder->getQuery(); 
        return $result;
    }

    public function unMarkReplacementLeaveAsTaken($username, $year = "")
    {
        if ($year != "") {
            $query = "select min(id) from leave_adjustment where employee_id='" . $username . "' and taken_stat=1 and year(start_date)='" . $year . "'";
        } else {
            $query = "select min(id) from leave_adjustment where employee_id='" . $username . "' and taken_stat=1";
        }
        $minId = DB::select($query);
        $leaves = LeaveAdjustment::where('id', $minId)->first();
        $leaves->taken_stat = "0";
        $leaves->save();
    }

    public function markReplacementLeaveAsTaken($username, $year = '', $startDate = 'CURDATE()')
    {
        $users11 = DB::table('users')->where('username', $username)->first();
        $usercat = DB::table('user_category')->where('username', $username)->first();
        if ($year == '') {
            $year = date('Y');
        }


        if ($startDate == "CURDATE()") {
            $f_query = "select case when DATEDIFF(DATE_ADD(start_date, INTERVAL (SELECT `value` FROM `replacement_duration` where `category_name`='" . $usercat->category . "' and `company_id`='" . $users11->company_id . "') DAY), CURDATE()) >0 then 0 ELSE 1 END isforfeit ,";
        } else {
            $f_query = "select case when DATEDIFF(DATE_ADD(start_date, INTERVAL (SELECT `value` FROM `replacement_duration` where `category_name`='" . $usercat->category . "' and `company_id`='" . $users11->company_id . "') DAY),'" . $startDate . "') >0 then 0 ELSE 1 END isforfeit ,";
        }
        $f_query .= "no_granted,id from leave_adjustment where employee_id='" . $username . "' and year(start_date)='" . $year . "' and taken_stat=0 having isforfeit=1";

        $result = DB::select($f_query);

        $ids = array();
        for ($i = 0; $i < count($result); $i++) {
            //dd($result[$i]->id);
            array_push($ids, $result[$i]->id);
        }

        $id_str = implode(",", $ids);

        $query = "select min(id) as mid from leave_adjustment where employee_id='" . $username . "' and taken_stat=0  and year(start_date)='" . $year . "' ";
        if ($id_str != '') {
            $query .= " and id NOT IN (" . $id_str . ")";
        }

        $minId = DB::select($query);
        //dd($minId);
        // dd($query);
        if ($minId[0]->mid != '') {
            $leaves = LeaveAdjustment::where('id', $minId[0]->mid)->first();
            $leaves->taken_stat = "1";
            $leaves->save();
            return $minId[0]->mid;
        } else {
            return '';
        }
    }

    function updateLeave($leaveId, $username, $approverId, $type, $isHalfDay, $startTime, $endTime, $startDate, $endDate, $noDays, $reason, $isPast = 0, $id = 0)
    {
        if (!$isPast || $isPast == "undefined") {

            $leaves = Leavelist::where('id', $leaveId)->first();
            $leaves->username = $username;
            $leaves->approver_id = $approverId;
            $leaves->type = $type;
            $leaves->is_half_day = $isHalfDay;
            // $leaves->start_time = $startTime;
            // $leaves->end_time = $endTime;
            // $leaves->start_date = $startDate;
            // $leaves->end_date = $endDate; 
            // $leaves->no_days = $noDays;
            $leaves->reason = $reason;
            $leaves->save();
        } else {

            $leaves = LeavePast::where('id', $id)->first();
            // $leaves->username = $username;
            $leaves->type = $type;
            // $leaves->start_date = $startDate;
            // $leaves->end_date = $endDate; 
            $leaves->save();
        }
        return $leaves;
    }

    function updateLeave112($leaveId, $username, $type, $isHalfDay, $startTime, $endTime, $startDate, $endDate, $noDays, $reason, $isPast = 0, $id = 0, $hourly = 0, $hours = '')
    {
        if (!$isPast || $isPast == "undefined") {

            $leaves = Leavelist::where('id', $leaveId)->first();
            // $leaves->username = $username;
            $leaves->type = $type;
            $leaves->is_half_day = $isHalfDay;
            // $leaves->start_time = $startTime;
            // $leaves->end_time = $endTime;
            // $leaves->start_date = $startDate;
            // $leaves->end_date = $endDate; 
            // $leaves->no_days = $noDays;
            if ($hourly == 1) {
                $leavedate = date('Y-m-d H:i A', $startTime);
                $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $hours . ' hours')));
                $leaves->end_time = $endTime;
            }
            $leaves->reason = $reason;
            $leaves->save();
        } else {

            $leaves = LeavePast::where('id', $id)->first();
            // $leaves->username = $username;
            $leaves->type = $type;
            if ($hourly == 1) {
                $leavedate = date('Y-m-d H:i A', $startTime);
                $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $hours . ' hours')));
                $leaves->end_time = $endTime;
            }
            // $leaves->start_date = $startDate;
            // $leaves->end_date = $endDate; 
            $leaves->save();
        }
        return $leaves;
    }

    public function changeCategory($id, $category)
    {
        $leaves = Leavelist::where('id', $id)->first();
        $leaves->leave_category = $category;
        $leaves->save();
        return $leaves;
    }
    public function addLeaveEntitleHistory($username, $year, $type)
    {
        $this->deleteLeaveEntitleHistory($username, $year, $type);
        $entitle = getLeaveEntitle($username, $type);

        $taken = getTakenLeaveCount($username, $year, $type);
        $pastLeaves = getTakenPastLeaves($username, $year);
        //dd($pastLeaves);
        $taken = floatval($taken) + floatval($pastLeaves[strtolower($type)]);

        $adjustmentLeaves = ((strtolower($type) == "annual") ? getAdjustmentLeaveCount($username, $year, '') : "0");
        $bfLeaves = getBroughtForwardLeaveCount($username, $year, $type);
        //dd($username);
        $leaveentitle = LeaveEntitleHistory::create([
            "username" => $username,
            "year" => $year,
            "leave_type" => $type,
            "entitle" => $entitle,
            "adjustment" => $adjustmentLeaves,
            "leave_taken" => $taken,
            "bf_leaves" => $bfLeaves,

        ]);
    }
    public function deleteLeaveEntitleHistory($username, $year, $type)
    {
        $query = "delete from leave_entitle_history where username='" . $username . "' and year='" . $year . "' and leave_type='" . $type . "'";
        $result = DB::select($query);
    }

    public function setStatus($id, $status)
    {

        $resultVal = LeaveDay::where('id', $id)->first();
        $leaveId = $resultVal->leave_id;
        $query = Leavelist::where('id', $leaveId)->first();
        $resultVal->status = $status;
        $resultVal->save();
        $query->status = $status;
        if ($status == '1') {
            $query->date_approved = date('Y-m-d');
        }
        $query->save();

        return $resultVal;
    }

    public function add_edit_holiday()
    {
        $user = User::where('id', Auth::id())->first();
        $countries = DB::table('countries')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        $states = DB::table('states')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        return view('hr.setup.holiday', compact('states', 'countries'));
    }

    public function holidays()
    {
        $user = User::where('id', Auth::id())->first();
        $countries = DB::table('countries')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        $states = DB::table('states')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        return view('hr.holidays', compact('states', 'countries'));
    }

    public function getholidaydata($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('public_holiday')->where('company_id', $user->company_id)->find($id);
        $date = $result->date;

        $result = DB::table('public_holiday')->where('date', $date)->selectRaw("distinct id,date,GROUP_CONCAT( state ) as state, day(date) as day, month(date) as month, year(date) as year, country,description")->groupBy('date', 'description')->orderBy('date')->first();
        return $result;
    }

    public function deleteholiday(Request $request)
    {
        $holidaydt = PublicHoliday::where('id', $request->holiday_id)->first();
        $holidays = PublicHoliday::where('date', $holidaydt->date)->where('description', $holidaydt->description)->where('company_id', $holidaydt->company_id)->get();
        foreach ($holidays as $holiday) {
            $holiday11 = DB::table('public_holiday_subscriber')->where('public_holiday_id', $holiday->id)->delete();
            $holiday = PublicHoliday::where('id', $holiday->id)->delete();
        }
        return true;
    }

    public function createholiday()
    {
        $user = User::where('id', Auth::id())->first();
        $countries = DB::table('countries')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        $states = DB::table('states')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        return view('hr.add_holiday', compact('states', 'countries'));
    }

    public function addHoliday(Request $request)
    {
        // dd($request);
        $country = $request->country;
        $state = $request->state;
        //dd($request->all());
        if (is_array($request->state)) {
            $state = $state[0];
        } else {
            $state = $state;
        }
        if (strtolower($state) != 'national') {
            $branchIds = $this->getBranchIdOfState($state);
        }

        $dates = explode(",", $request->date);
        $description = addslashes($request->description);

        $description = preg_replace("/\r|\n/", " ", $description);

        for ($i = 0; $i < count($dates); $i++) {

            $date = date('Y-m-d', strtotime($dates[$i]));
            if ((strtolower($state) != 'national')) {

                if (count($branchIds) > 0) {

                    for ($j = 0; $j < count($branchIds); $j++) {
                        //dd($branchIds);
                        $branch = $branchIds[$j]->id;
                        if ($this->isAlreadyAdded($country, $state, $branch, $date, $description)) {
                            return array("result" => 0);
                        }
                        $result = $this->addPublicHoliday($country, $state, $branch, $date, $description);
                    }
                }
            } elseif (strtolower($state) == 'national') {
                $branch = 0;
                //dd(count($dates));
                if (is_array($request->state)) {
                    $states = $request->state;
                    $states = $states[0];
                } else {
                    $states = $state;
                }

                if ($this->isAlreadyAdded($country, $states, $branch, $date, $description)) {
                    return array("result" => 0);
                }
                $result = $this->addPublicHoliday($country, $states, $branch, $date, $description);
            } else {
                $result = false;
            }
        }
        if ($result)
            $result = 1;
        else
            $result = 2;

        return array("result" => $result);
    }

    public function addNextYearPHoliday(Request $request)
    {
        $id = $request->ids;
        if (count($id) > 0) {
            foreach ($id as $dt) {
                $detail = DB::table('public_holiday')->find($dt);
                $date = explode("-", $detail->date);
                $date = ($request->year) . '-' . $date[1] . '-' . $date[2];
                //dd($date);
                $details = DB::table('public_holiday')->where('date', $detail->date)->get();
                foreach ($details as $dts) {
                    if (!$this->isAlreadyAdded($dts->country, $dts->state, $dts->branch_id, $date, $dts->description)) {
                        $result = $this->addPublicHoliday($dts->country, $dts->state, $dts->branch_id, $date, $dts->description);
                    }
                }
            }
            return 1;
        } else {
            return 0;
        }
    }

    public function updateWithDateAndDescription(Request $request)
    {
        $oldDate = $request->old_date;
        $oldDescription = $request->old_description;
        $this->deleteWithDateAndDescription($oldDate, $oldDescription);

        $country = $request->country;
        $states = explode(",", $request->states);
        if (count($states) == 0)
            $states = array("");
        $date = date('Y-m-d', strtotime($request->date));
        $description = addslashes($request->description);
        $description = preg_replace("/\r|\n/", " ", $description);
        //$description = str_replace('<br />',' ',$description);
        //echo $description;exit;

        for ($i = 0; $i < count($states); $i++) {
            if (isset($states[0])) {
                if (strtolower($states[0]) != 'national') {
                    $branchIds = $this->getBranchIdOfState($states[$i]);
                }
            }
            if (strtolower($states[0]) != 'national' && strtolower($states[$i]) != 'national') {
                if (!empty($branchIds)) {
                    for ($j = 0; $j < count($branchIds); $j++) {
                        //dd($branchIds,$states[$i]);
                        $branch = $branchIds[$j]->id;
                        $result = $this->addPublicHoliday($country, $states[$i], $branch, $date, $description);
                    }
                }
            } else if (strtolower($states[0]) == 'national' || strtolower($states[$i]) == 'national') {
                $branch = 0;
                //dd(count($dates));
                if (is_array($request->state)) {
                    $state = $states[0];
                } else {
                    $state = $states[$i];
                }

                $result = $this->addPublicHoliday($country, $state, $branch, $date, $description);
            }
        }
        return array("result" => true);
    }

    public function deleteWithDateAndDescription($date, $description)
    {

        DB::table('public_holiday')->where('date', $date)->where('description', $description)->delete();
        return true;
    }


    public function addPublicHoliday($country, $state, $branch, $date, $description)
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('public_holiday')->insert(array('country' => $country, 'state' => $state, 'branch_id' => $branch, 'date' => $date, 'description' => $description, 'company_id' => $user->company_id));
        return true;
    }

    public function isAlreadyAdded($country, $state, $branch, $date, $description)
    {
        $user = User::where('id', Auth::id())->first();

        $id = DB::table('public_holiday')->where('country', $country)->where('state', $state)->where('branch_id', $branch)->where('date', $date)->where('description', $description)->where('company_id', $user->company_id)->first();
        if (!empty($id))
            return TRUE;
        return FALSE;
    }

    public function getBranchIdOfState($state)
    {

        $user = User::where('id', Auth::id())->first();
        if (strtolower($state) == "national" || $state == "")
            return array(array("id" => "0"));
        // $query = "select id from branch where state='%s'";
        // $builder = new QueryBuilder($query);
        // $builder->bind(array($state));
        // $builder->execute();
        $ids = DB::table('branch')->where('company_id', $user->company_id)->where('state', $state)->get('id');
        return $ids;
    }

    public function getPublicHolidaysWithStates(Request $request)
    {
        $country = $request->nationality;
        $state = $request->state;
        $year = (($request->year && $request->year != "") ? $request->year : date('Y'));
        $startDate = (($request->start_date && $request->start_date != "") ? date('Y-m-d', strtotime($request->start_date)) : "");
        $endDate = (($request->end_date && $request->start_date != "") ? date('Y-m-d', strtotime($request->end_date)) : "");
        $branch = "";
        if ($state != "")
            $branch = $this->getStateBranchId($state);

        $result = $this->getPublicHolidaysWithStates11($branch, $state, $year, $startDate, $endDate, $country);
        return $result;
    }

    public function getStateBranchId($state)
    {
        if (strtolower($state) == "national")
            return "0";
        $builder = DB::table('branch')->where('state', $state)->selectRaw("id")->first();
        $ids = '';
        if (!empty($builder))
            $ids = $builder->id;
        return $ids;
    }


    public function getPublicHolidaysWithStates11($branchId, $state, $year, $startDate = "", $endDate = "", $country = "")
    {
        $user = User::where('id', Auth::id())->first();
        $viewStatus11 = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->where('a.employee_id', $user->username)->selectRaw('b.view_leave')->first();
        $viewStatus = $viewStatus11->view_leave;

        $searchQuery = "id > 0";
        if (($branchId != "" && $branchId != "0") || $viewStatus == 5) {

            if ($viewStatus == 5) {
                $userbranchId = $this->getUserBranchId($user->username);
                $searchQuery .= " and( branch_id='$userbranchId' or state = 'National' )";
            } else {
                $searchQuery .= " and( branch_id='$branchId' or state = 'National' )";
            }
        }

        if ($country != "")
            $searchQuery .= " and (country = '$country')";
        if ($state != "" && $state != "National")
            $searchQuery .= ' and (LOWER(state) LIKE "%' . strtolower($state) . '%" || state = "National"  || state = "")';
        if ($year != "0" && $year != "")
            $searchQuery .= " and year(date) = '$year'";
        if ($startDate != "")
            $searchQuery .= " and date >= '$startDate'";
        if ($endDate != "")
            $searchQuery .= " and date <= '$endDate'";


        $builder = DB::table('public_holiday')->whereRaw($searchQuery)->selectRaw("distinct id,date,GROUP_CONCAT( state ) as state, day(date) as day, month(date) as month, year(date) as year, country,description")->groupBy('date', 'description')->orderBy('date')->get();
        $result = $builder;

        for ($i = 0; $i < count($result); $i++) {
            $states = $this->getStatesLeave($result[$i]->date, $result[$i]->description);
            $result[$i]->states = $states;
            $str_arr = preg_split("/\,/", $result[$i]->state);
            $result[$i]->state = implode(", ", array_unique($str_arr));;
            $result[$i]->id = $result[$i]->id;
            $branches = $this->getBranchLeave($result[$i]->date, $result[$i]->description);
            $result[$i]->branches = $branches;
            $user = User::where('id', Auth::id())->first();
            $subscriber = DB::table('public_holiday_subscriber')->where('public_holiday_id', $result[$i]->id)->where('username', $user->username)->first();
            if (!empty($subscriber)) {
                //dd($subscriber->status);
                if ($subscriber->status == 0) {
                    $result[$i]->subscriber_allow = true;
                } else {
                    $result[$i]->subscriber_allow = false;
                }
            } else {
                $result[$i]->subscriber_allow = true;
            }
        }
        $result->map(function ($item) {

            $item->day = date("D", strtotime($item->date));

            return $item;
        });

        return DataTables::of($result)->make(true);
        //return $result;
    }

    public function holidaySubscribe(Request $request)
    {
        $holidayid = $request->ids;
        $user = User::where('id', Auth::id())->first();
        $subscriber = DB::table('public_holiday_subscriber')->where('public_holiday_id', $holidayid)->where('username', $user->username)->first();
        if (!empty($subscriber)) {
            DB::table('public_holiday_subscriber')->where('username', $user->username)->where('public_holiday_id', $holidayid)->where('company_id', $user->company_id)->update(array('status' => 1));
        } else {
            DB::table('public_holiday_subscriber')->insert(array('username' => $user->username, 'public_holiday_id' => $holidayid, 'company_id' => $user->company_id, 'status' => 1));
        }
        return true;
    }

    public function holidayUnsubscribe(Request $request)
    {

        $holidayid = $request->ids;
        $user = User::where('id', Auth::id())->first();
        $subscriber = DB::table('public_holiday_subscriber')->where('public_holiday_id', $holidayid)->where('username', $user->username)->first();

        DB::table('public_holiday_subscriber')->where('username', $user->username)->where('public_holiday_id', $holidayid)->where('company_id', $user->company_id)->update(array('status' => 0));
    }

    public function getUserBranchId($username)
    {
        $builder = DB::table('user_pay')->where('username', $username)->selectRaw("branch_id")->first();
        $result = $builder->branch_id;
        return $result;
    }

    public function getStatesLeave($date, $description = "")
    {
        $builder11 = DB::table('public_holiday')->selectRaw("distinct state ")->where('date', $date);
        if ($description != '') {
            $builder11->where('description', $description);
        }
        $builder = $builder11->get();
        $result = $builder;
        return $result;
    }

    public function getBranchLeave($date, $description = "")
    {

        $builder11 = DB::table('public_holiday as a')->leftjoin('branch as b', 'a.branch_id', '=', 'b.id')->selectRaw("distinct b.id, b.name as branch, b.description")->where('a.branch_id', '>', '0')->where('a.date', $date);
        if ($description != '') {
            $builder11->where('a.description', $description);
        }
        $builder = $builder11->get();
        $result = $builder;
        return $result;
    }

    public function racecategory()
    {

        return view('hr.setup.race_category');
    }

    public function getrace(Request $request)
    {
        $dtable = $request->dtable ?? "";

        $user = User::where('id', Auth::id())->first();
        $result = DB::table('race')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_personal')->selectRaw("username")->where('race', $result[$i]->race)->first();
            $result[$i]->c_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function addrace(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $race = new Race;
        $race->race = $request->race;
        $race->is_deleted = 0;
        $race->company_id = $user->company_id;
        $race->save();
        return 1;
    }

    public function getracedata($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('race')->where('is_deleted', 0)->where('company_id', $user->company_id)->find($id);

        return $result;
    }

    public function editrace(Request $request)
    {
        $race = Race::where('id', $request->race_id)->first();
        $emp = UserPersonal::where('race', $race->race)->update(array('race' => $request->race_name));
        $race->race = $request->race_name;
        $race->save();

        return $race;
    }

    public function deleterace(Request $request)
    {
        $race = Race::where('id', $request->race_id)->first();
        $race->is_deleted = 1;
        $race->save();

        return $race;
    }

    public function getcategory(Request $request)
    {
        $dtable = $request->dtable ?? "";

        $user = User::where('id', Auth::id())->first();
        $result = CategoryName::where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_category')->selectRaw("username")->where('category', $result[$i]->id)->first();
            $result[$i]->c_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function add_category(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $category = new CategoryName;
        $category->name = $request->category;
        $category->is_deleted = 0;
        $category->company_id = $user->company_id;
        $category->save();
        return 1;
    }

    public function get_categorydata($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = CategoryName::where('is_deleted', 0)->where('company_id', $user->company_id)->find($id);
        return $result;
    }

    public function edit_category(Request $request)
    {
        $category = CategoryName::where('id', $request->category_id)->first();
        $category->name = $request->category;
        $category->save();

        return $category;
    }

    public function delete_category(Request $request)
    {
        $category = CategoryName::where('id', $request->category_id)->first();
        $category->is_deleted = 1;
        $category->save();

        return $category;
    }

    public function countries()
    {

        $user = User::where('id', Auth::id())->first();
        $country = DB::table('countries')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        return view('hr.setup.countries', compact('country'));
    }
    public function getcountry(Request $request)
    {
        $dtable = $request->dtable ?? "";

        $user = User::where('id', Auth::id())->first();
        $result = DB::table('countries')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_personal')->selectRaw("username")->where('nationality', $result[$i]->country_code)->first();
            $result[$i]->c_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function addcountry(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $country = new Country;
        $country->country_code = $request->country_code;
        $country->country = $request->country;
        $country->is_deleted = 0;
        $country->company_id = $user->company_id;
        $country->created = time();
        $country->modified = time();
        $country->save();
        return 1;
    }

    public function getcountrydata($id)
    {
        $result = DB::table('countries')->where('is_deleted', 0)->find($id);
        return $result;
    }

    public function editcountry(Request $request)
    {
        $country = Country::where('id', $request->country_id)->first();
        $country->country_code = $request->country_code;
        $country->country = $request->country;
        $country->modified = time();
        $country->save();

        return $country;
    }

    public function deletecountry(Request $request)
    {
        $country = Country::where('id', $request->country_id)->first();
        $country->is_deleted = 1;
        $country->modified = time();
        $country->save();

        return $country;
    }

    public function states()
    {
        $user = User::where('id', Auth::id())->first();
        $country = DB::table('countries')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        return view('hr.setup.state', compact('country'));
    }
    public function getstate(Request $request)
    {
        $dtable = $request->dtable ?? "";

        $user = User::where('id', Auth::id())->first();
        $result = DB::table('states')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_personal')->selectRaw("username")->where('state', $result[$i]->state)->first();
            $result[$i]->c_id = $i + 1;
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        if ($dtable != '') {
            return $result;
        } else {
            return DataTables::of($result)->make(true);
        }
    }
    public function addstate(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $state = new State;
        $state->country = $request->country;
        $state->state = $request->state;
        $state->is_deleted = 0;
        $state->company_id = $user->company_id;
        $state->created = time();
        $state->modified = time();
        $state->save();
        return 1;
    }

    public function getstatedata($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('states')->where('is_deleted', 0)->find($id);
        $result->countries = DB::table('countries')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        return $result;
    }

    public function editstate(Request $request)
    {
        $state = State::where('id', $request->state_id)->first();
        $state->country = $request->country;
        $state->state = $request->state;
        $state->modified = time();
        $state->save();

        return $state;
    }

    public function deletestate(Request $request)
    {
        $state = State::where('id', $request->state_id)->first();
        $state->is_deleted = 1;
        $state->modified = time();
        $state->save();

        return $state;
    }

    public function createdepartment()
    {
        $countries = DB::table('countries')->where('is_deleted', 0)->orderBy('country', 'asc')->get();
        return view('hr.setup.create-department', compact('countries'));
    }

    public function createcategory()
    {
        $countries = DB::table('countries')->where('is_deleted', 0)->orderBy('country', 'asc')->get();
        return view('hr.setup.create-category', compact('countries'));
    }

    public function createbranch()
    {
        $countries = DB::table('countries')->where('is_deleted', 0)->orderBy('country', 'asc')->get();
        return view('hr.setup.create-branch', compact('countries'));
    }

    public function addDepartment(Request $request)
    {

        $user = User::where('id', Auth::id())->first();

        $department = new Department;
        $department->name = $request->department_name;
        $department->description = $request->department_description;
        $department->email = $request->department_email;
        $department->company_id = $user->company_id;
        $department->forecast = $request->department_forecast;
        $department->save();
        return 1;
    }

    public function isDepartmentAvailable(Request $request, $dept = '', $id = '')
    {
        $user = User::where('id', Auth::id())->first();
        if ($id == '') {
            $department = DB::table('department')->where('name', $request->department)->where('company_id', $user->company_id)->first();
        } else {
            $department = DB::table('department')->where('name', $dept)->where('company_id', $user->company_id)->where('id', '!=', $id)->first();
        }

        if (!empty($department)) {
            return false;
        } else {
            return true;
        }
    }

    public function isCategoryAvailable(Request $request, $cat = '', $id = '')
    {
        $user = User::where('id', Auth::id())->first();
        if ($id == '') {
            $category = DB::table('category')->where('name', $request->category)->where('company_id', $user->company_id)->first();
        } else {
            $category = DB::table('category')->where('name', $cat)->where('company_id', $user->company_id)->where('id', '!=', $id)->first();
        }
        if (!empty($category)) {
            return false;
        } else {
            return true;
        }
    }

    public function isBranchAvailable(Request $request, $branchn = '', $id = '')
    {
        $user = User::where('id', Auth::id())->first();
        if ($id == '') {
            $branch = DB::table('branch')->where('name', $request->branch)->where('company_id', $user->company_id)->first();
        } else {
            $branch = DB::table('branch')->where('name', $branchn)->where('company_id', $user->company_id)->where('id', '!=', $id)->first();
        }
        if (!empty($branch)) {
            return false;
        } else {
            return true;
        }
    }

    public function addCategory(Request $request)
    {
        //return $request->all();
        $file = $request->file('category_logo');
        $user = User::where('id', Auth::id())->first();
        if ($request->has('category_logo') && !empty($file)) {

            $file = $request->file('category_logo');
            $extension = $file->getClientOriginalExtension();
            $endFileName = $request->category_name . rand(111, 999) . '.' . $extension;
            $filePath = 'public/category/';

            try {

                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
            }
        } else {
            $endFileName = '';
        }

        $category = new Category;
        $category->name = $request->category_name;
        $category->logo = $endFileName;
        $category->description = $request->category_description;
        $category->email = $request->category_email;
        $category->company_id = $user->company_id;
        $category->forecast = $request->category_forecast;
        if ($request->email_manager) {
            $category->in_mgt_email = 1;
        }
        $category->save();
        return 1;
    }

    public function addBranch(Request $request)
    {
        //return $request->all();
        $file = $request->file('branch_logo');
        $user = User::where('id', Auth::id())->first();
        if ($request->has('branch_logo') && !empty($file)) {

            $file = $request->file('branch_logo');
            $extension = $file->getClientOriginalExtension();
            $endFileName = $request->branch_name . rand(111, 999) . '.' . $extension;
            $filePath = 'public/branch/';

            try {

                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
            }
        } else {
            $endFileName = '';
        }

        $branch = new Branch;
        $branch->name = $request->branch_name;
        $branch->logo = $endFileName;
        $branch->description = $request->branch_description;
        $branch->email = $request->branch_email;
        $branch->state = $request->branch_state;
        $branch->company_id = $user->company_id;
        $branch->forecast = $request->branch_forecast;
        $branch->save();
        return 1;
    }

    public function editdepartment()
    {
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->first();
        return view('hr.setup.edit-department', compact('deleteBtnShowSetting'));
    }

    public function getdeptdata()
    {

        $result = DB::table('department')->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_pay')->selectRaw("username")->where('department_id', $result[$i]->id)->first();
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return DataTables::of($result)->make(true);
    }

    public function getdept_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('department')->where('company_id', $user->company_id)->find($id);
        return $result;
    }

    public function editdept(Request $request)
    {
        $department = Department::where('id', $request->dept_id)->first();
        $isDep = $this->isDepartmentAvailable(request(), $request->name, $request->dept_id);
        if ($isDep) {
            $department->name = $request->name;
        }
        $department->description = $request->description;
        $department->email = $request->email;
        $department->forecast = $request->forecast;
        $department->save();


        return $department;
    }

    public function deletedepartment(Request $request)
    {
        $department = Department::where('id', $request->dept_id)->delete();

        return true;
    }

    public function getcategorydata()
    {
        $result = DB::table('category')->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_pay')->selectRaw("username")->where('category_id', $result[$i]->id)->first();
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return DataTables::of($result)->make(true);
    }

    public function getcat_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('category')->where('company_id', $user->company_id)->find($id);
        return $result;
    }

    public function editcat(Request $request)
    {
        //dd($request->all());
        $category = Category::where('id', $request->cat_id)->first();
        $isCat = $this->isCategoryAvailable(request(), $request->category_name, $request->cat_id);
        if ($isCat) {
            $category->name = $request->category_name;
        }
        $file = $request->file('category_logo');
        if ($request->has('category_logo') && !empty($file)) {
            if (isset($category->logo)) {
                Storage::delete('public/category/' . $category->logo);
            }
            $file = $request->file('category_logo');
            $extension = $file->getClientOriginalExtension();
            $endFileName = $request->category_name . rand(111, 999) . '.' . $extension;
            $filePath = 'public/category/';

            try {

                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
            }
            $category->logo = $endFileName;
        }

        $category->description = $request->category_description;
        $category->email = $request->category_email;
        $category->forecast = $request->category_forecast;
        if ($request->category_memail) {
            $category->in_mgt_email = $request->category_memail;
        }
        $category->save();


        return $category;
    }

    public function deletecategory(Request $request)
    {
        $category = Category::where('id', $request->cat_id)->delete();;

        return true;
    }

    public function getbranchdata()
    {
        $result = DB::table('branch')->get();
        for ($i = 0; $i < count($result); $i++) {
            $query = DB::table('user_pay')->selectRaw("username")->where('branch_id', $result[$i]->id)->first();
            if ($query != '') {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return DataTables::of($result)->make(true);
    }

    public function getbranch_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('branch')->where('company_id', $user->company_id)->find($id);
        $state = DB::table('states')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        $result->statelist = $state;
        return $result;
    }

    public function editbranch(Request $request)
    {
        $branch = Branch::where('id', $request->branch_id)->first();
        $isBranch = $this->isBranchAvailable(request(), $request->branch_name, $request->branch_id);
        if ($isBranch) {
            $branch->name = $request->branch_name;
        }
        $file = $request->file('branch_logo');
        if ($request->has('branch_logo') && !empty($file)) {
            if (isset($branch->logo)) {
                Storage::delete('public/branch/' . $branch->logo);
            }
            $file = $request->file('branch_logo');
            $extension = $file->getClientOriginalExtension();
            $endFileName = $request->branch_name . rand(111, 999) . '.' . $extension;
            $filePath = 'public/branch/';

            try {

                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
            }
            $branch->logo = $endFileName;
        }

        $branch->description = $request->branch_description;
        $branch->email = $request->branch_email;
        $branch->forecast = $request->branch_forecast;
        $branch->state = $request->branch_state;

        $branch->save();


        return $branch;
    }

    public function deletebranch(Request $request)
    {
        $branch = Branch::where('id', $request->branch_id)->delete();;

        return true;
    }

    public function getYearlyEntitleListHR(Request $request)
    {
        if ($request->get('pagetype') == 'annual') {
            session(['rannual_pdf_data' => $request->getUri()]);
        }
        if ($request->get('pagetype') == 'medical') {
            session(['rmedical_pdf_data' => $request->getUri()]);
        }
        //         $cutOffMonth1 = DB::table('settings')->where('field', "cut_of_month")->first();
        //         $cutOffDate1 = DB::table('settings')->where('field', "cut_of_date")->first();
        //         $cutOffStartDate1 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        //         $cutOffStartMonth1 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        //         $SettingLeaveAdjustmentType1 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        //         $companyName1 = DB::table('settings')->where('field', "company")->first();
        // 		$cutOffDate = $cutOffDate1->value;
        // 		$cutOffMonth = $cutOffMonth1->value;

        // 		$cutOffStartDate = $cutOffStartDate1->value;
        // 		$cutOffStartMonth = $cutOffStartMonth1->value;
        //         $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType1->value;
        //       // dd($SettingLeaveAdjustmentType);
        //         if($companyName1!=''){
        //             $companyName = $companyName1->value;
        //         }
        //         else{
        //             $companyName ='';
        //         }

        if ($request->get('year')) {
            $year = $request->year;
        } else {
            $year = date('Y');
        }
        // 		if($request->get('name')){
        //             $username = $request->name;
        //         }
        //         else{
        //             $username='';
        //         }
        if ($request->auth_id != '') {
            $user = DB::table('users')->where('id', $request->auth_id)->first();
        } else {
            $user = DB::table('users')->where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", $user->username);
        $permission_val = $this->getPermissionValue("hr", $user->username);
        $approverId = $user->username;

        $usercount = DB::table('user_personal')->leftjoin('user_pay as b', 'user_personal.username', '=', 'b.username')->leftjoin('branch as c', 'b.branch_id', '=', 'c.id');

        if ($request->get('name') && $request->get('name') != '') {
            $usercount->where(function ($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%"))');
            });
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            $branchId = DB::table('user_pay')->where('branch_id', $request->get('branch'))->pluck('username')->toArray();
            $usercount->whereIn('user_personal.username', $branchId);
        }
        if ($request->get('department') && $request->get('department') != '') {
            $departmentId = DB::table('user_pay')->where('department_id', $request->get('department'))->pluck('username')->toArray();
            $usercount->whereIn('user_personal.username', $departmentId);
        }

        if ($request->get('category') && $request->get('category') != '') {
            $categoryId = DB::table('user_pay')->where('category_id', $request->get('category'))->pluck('username')->toArray();
            $usercount->whereIn('user_personal.username', $categoryId);
        }
        if ($request->get('year') && $request->get('year') != '') {
            $usercount->whereYear('b.date_commence', '<=', $request->get('year'));
        }

        if ($ActiveUserShownStatus == 1) {
            $usercount->whereRaw("( b.pay_status='1' or b.pay_status='0')");
        } else {
            $usercount->where('b.pay_status', '1');
        }

        if ($hr_viewStatus == 1) {
            $usercount->where('user_personal.username', $approverId);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            $usercount->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $usercount->where('b.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $usercount->where('c.state', $state_nm);
        }
        $usercount = $usercount->whereYear('b.date_commence', '<=', $year)->whereRaw("(year(`b`.`date_resigned`) >= $year or year(`b`.`date_resigned`) = 0000)")->where('user_personal.username', '!=', null)
            ->where('user_personal.isDeleted', 0);

        $usercount = $usercount->count();

        // 		$cutOffStartYear = $year;
        // 		$cutOffYear = $year;
        // 		if($cutOffStartMonth!=1){
        // 			if($cutOffStartMonth > date('m')){
        // 				$cutOffStartYear = $year;
        // 				$cutOffYear = $year;
        // 			}else{
        // 				$cutOffStartYear = $year-1;
        // 				$cutOffYear = $year;
        // 			}
        // 		}else{
        // 			$cutOffStartYear = $year;
        // 			$cutOffYear = $year;
        // 		}


        // 		if ($username != '') {

        // 			$userdata = $this->getUserRequiredListByUsernameHR($username, $year);
        // 			//$users = $userdata['result'];
        // 			$usercount= $userdata['count'];

        // 		} else {
        // 			$userdata = $this->getUserRequiredListHR("", $year,request());
        // 		//	$users = $userdata['result'];
        // 			$usercount= $userdata['count'];

        //         }
        //         //dd(count(array($users)));
        //         $date_commence= UserPay::where('username',$username)->first();
        //         $SoftwareStartDate1 = DB::table('settings')->where('field', "software_start_year")->first();
        // 		$SoftwareStartDate = $SoftwareStartDate1->value;

        // 		for ($i = 0; $i < count($users); $i++) {
        // 		    $date_for_query = "CURDATE()";
        //             $username = $users[$i]->username;
        //             $date_commence11= UserPay::where('username',$username)->first();
        // 			$curr_join_date = $this->get_curr_joining_date($username, $year);
        // 			$date_commence = $date_commence11->date_commence;
        // 			$joiningDate = strtotime($date_commence);
        // 			$RL_forfeit = getForfeitAdjLeaveCount($username, $year);

        // 			$isShowClaimable = getConfirmDisplay($username);

        // 			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
        // 			//dd($annualEntitle);
        // 		   //dd($annualEntitle);
        // 			//echo " - ".$annualEntitle;exit;
        // 			$medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);
        // 			//if pr`o rated
        // 			$resiged_date_str = $date_commence11->date_resigned;
        // 			$medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
        //             $medical_pro_rated = $medical_pro_rated11->value;
        // 			if ($medical_pro_rated == 1) {
        // 				$joiningDate = $date_commence11->date_commence;
        // 				$joiningDateArr = explode('-', $joiningDate);

        // 				$joining_year = $joiningDateArr[0];
        // 				$joining_month = $joiningDateArr[1];
        // 				$joining_date = $joiningDateArr[2];

        // 				$resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();

        // 				$ExperienceInYear = intval($resultArrayVal->experience) + 1;
        // 				//
        // 				$joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

        // 				//section one	
        // 				$prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
        // 				$start = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
        // 				$datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
        // 				$days1 = round($datediff / (60 * 60 * 24));

        // 				$date1 = new DateTime($joiningDate);
        // 				$date2 = new DateTime($prev_date_of_joining_date);
        // 				$diff = $date1->diff($date2);
        // 				$experiance1 = $diff->y;
        // 				if ($experiance1 == 0) {
        // 					$experiance1 = 1;
        // 				}

        // 				$medicalEntitlenew11= DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Medical")->where('a.experience','<=',$experiance1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 				$medicalEntitlenew1 = $medicalEntitlenew11->no_leaves;

        // 				$d1 = ($days1 / 365) * $medicalEntitlenew1;

        // 				$a1 = array(
        // 					'username' => $username,
        // 					'joining date' => $joiningDate,
        // 					'entitle' => $medicalEntitlenew1,
        // 					'start date' => $start,
        // 					'end date' => $prev_date_of_joining_date,
        // 					'days' => $days1,
        // 					'experiance' => $experiance1,
        // 				);

        // 				//section one

        // 				//section two
        // 				$end_date = $year . "-".$cutOffMonth."-".$cutOffDate;
        // 				$datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
        // 				$days2 = round($datediff2 / (60 * 60 * 24));

        // 				$date1 = new DateTime($joiningDate);
        // 				$date2 = new DateTime($end_date);
        // 				$diff = $date1->diff($date2);
        // 				$experiance2 = $diff->y;
        // 				if ($joiningdatecurrent <= date('Y-m-d')) {
        // 					$experiance2 = $experiance2 + 1;
        // 				}

        //                 $medicalEntitlenew21= DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Medical")->where('a.experience','<=',$experiance2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 				$medicalEntitlenew = $medicalEntitlenew21->no_leaves;
        // 				$d2 = ($days2 / 365) * $medicalEntitlenew;

        // 				$a2 = array(
        // 					'username' => $username,
        // 					'joining date' => $joiningDate,
        // 					'entitle' => $medicalEntitlenew,
        // 					'start date' => $end_date,
        // 					'end date' => $joiningdatecurrent,
        // 					'days2' => $days2,
        // 					'experiance' => $experiance2,
        // 				);
        // 				//section two
        // 				if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
        // 					if ($medicalEntitlenew1 != $medicalEntitlenew) {
        // 						$medicalEntitle = round($d1 + $d2);
        // 					} else {
        // 						if ($medicalEntitlenew1 != '') {
        // 							$medicalEntitle = $medicalEntitlenew1;
        // 						} else if ($medicalEntitlenew != '') {
        // 							$medicalEntitle = $medicalEntitlenew;
        // 						}
        // 					}
        // 				}

        // 			}

        // 			$resiged_date_str = $date_commence11->date_resigned;
        // 			$joiningDate = $date_commence11->date_commence;
        // 			$joiningDateArr = explode('-', $joiningDate);
        // 			$resignDateArr = explode('-', $resiged_date_str);
        // 			$resign_year = $resignDateArr[0];
        // 			$joining_year = $joiningDateArr[0];

        // 			if ($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
        // 				$joining_year = $joiningDateArr[0];
        // 				$joining_month = $joiningDateArr[1];
        // 				$joining_date = $joiningDateArr[2];
        // 				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
        // 				$date1 = new DateTime($joiningDate);
        // 				$date2 = new DateTime($joiningdatecurrent);
        // 				$diff = $date1->diff($date2);
        // 				$experiance1 = $diff->y;
        // 				$experiance1 = $experiance1 + 1;


        // 				if ($joining_year < $year && $resign_year == $year) {
        // 					$joining_year = $joiningDateArr[0];
        // 					$joining_month = $joiningDateArr[1];
        // 					$joining_date = $joiningDateArr[2];
        // 					$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
        // 					$date1 = new DateTime($joiningDate);
        // 					$date2 = new DateTime($joiningdatecurrent);
        // 					$diff = $date1->diff($date2);
        // 					$experiance_1 = $diff->y;
        // 					if ($experiance_1 == 0) {
        // 						$experiance_1 = 1;
        // 					}

        //                     $annualEntitle_11=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 					$annualEntitle_1 = $annualEntitle_11->no_leaves;

        //                     $experiance_2 = $experiance_1 + 1;
        //                     $pro = 0;
        // 					$annualEntitle_21=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 					$annualEntitle_2 = $annualEntitle_21->no_leaves;

        //                     if (($annualEntitle_1 != $annualEntitle_2) && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
        // 						$pro = 1;
        // 						$datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
        // 						$days1 = round($datediff11 / (60 * 60 * 24));
        // 						$datediff22 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
        // 						$days2 = round($datediff22 / (60 * 60 * 24));
        // 						$first_dif = ($days1 / 365) * $annualEntitle_1;
        // 						//$second_dif = ($days2 / 365) * $annualEntitle_2;
        // 						$second_dif = ($days2 / 365) * $annualEntitle_1;
        //                       // $annualEntitle = ($first_dif + $second_dif);	

        //                         $datediff2= $datediff22;
        //                       // dd($days1,$days2,$annualEntitle_1,$annualEntitle_2);	

        // 					} else {
        // 						$datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
        // 					}
        // 				//dd($annualEntitle,$resiged_date_str);	
        // 				} else if ($joining_year < $year && $resign_year > $year) {
        // 					$joining_year = $joiningDateArr[0];
        // 					$joining_month = $joiningDateArr[1];
        // 					$joining_date = $joiningDateArr[2];
        // 					$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
        // 					$date1 = new DateTime($joiningDate);
        // 					$date2 = new DateTime($joiningdatecurrent);
        // 					$diff = $date1->diff($date2);
        // 					$experiance_1 = $diff->y;
        // 					if ($experiance_1 == 0) {
        // 						$experiance_1 = 1;
        // 					}
        // 					$annualEntitle_11=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 					$annualEntitle_1 = $annualEntitle_11->no_leaves;

        // 					$experiance_2 = $experiance_1 + 1;
        // 					$annualEntitle_21=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 					$pro = 0;
        // 					$annualEntitle_2 = $annualEntitle_21->no_leaves;
        // 					if ($annualEntitle_1 != $annualEntitle_2) {
        // 						$pro = 1;
        //                         $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-".$cutOffMonth."-".$cutOffDate);

        //                     }
        //                     $datediff2=0;

        // 				} else if ($joining_year == $year && $resign_year == $year) {
        //                     $pro = 0;
        //                     $datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);

        // 				} else if ($joining_year == $year && $resign_year > $year) {
        //                     $pro = 0;
        //                     $datediff2 = strtotime($cutOffYear . "-".$cutOffMonth."-".$cutOffDate) - strtotime($joiningDate);

        // 				}

        // 				//dd($datediff2);
        // 				$days = round($datediff2 / (60 * 60 * 24));
        // 				$annualEntitle1 = $days / 365;

        // 				if ($joining_year < $year && $resign_year > $year) {
        // 					if ($pro == 0) {
        // 						$annualEntitle = $annualEntitle;
        // 					}
        // 				} else {
        // 					if ($pro == 0) {

        // 						$annualEntitle = $annualEntitle;
        // 					}

        // 				}

        // 			}

        // 			//dd($annualEntitle);	
        // 			//dd($SettingLeaveAdjustmentType);
        // 			if ($SettingLeaveAdjustmentType == 8 || $SettingLeaveAdjustmentType == 1) {
        // 				$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
        // 				$joiningDate = $date_commence11->date_commence;
        // 				$joiningDateArr = explode('-', $joiningDate);
        // 				$joining_month = $joiningDateArr[1];
        // 				$joining_date = $joiningDateArr[2];


        // 				$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
        // 				$curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));

        // 				$date1 = new DateTime($joiningDate);
        // 				$date2 = new DateTime($curr_date);
        // 				$diff = $date1->diff($date2);
        // 				$ExperienceInYear = $diff->y;

        // 				if ($diff->d > 0 || $joiningDate == $curr_date) {
        // 					$ExperienceInYear = $ExperienceInYear + 1;
        // 				}

        // 				$annualEntitle1=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        // 				$annualEntitle = $annualEntitle1->no_leaves;

        // 			} else if ($SettingLeaveAdjustmentType == 6 && $joining_year != Date('Y')) {
        // 				$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
        // 				$joiningDate = $date_commence11->date_commence;
        // 				$joiningDateArr = explode('-', $joiningDate);
        // 				$joining_month = $joiningDateArr[1];
        // 				$joining_date = $joiningDateArr[2];

        // 				if($year!=""){
        // 					//$curr_date = date($year.'-m-d');

        // 					if($year == date('Y')){
        // 						$curr_date = date($year.'-m-d');
        // 					}else {
        // 						$curr_date = ($year) . "-".$cutOffMonth."-".$cutOffDate;
        // 					}

        // 				}else{
        // 					$curr_date = date('Y-m-d');
        // 				}


        // 				$date1 = new DateTime($joiningDate);
        // 				$date2 = new DateTime($curr_date);
        // 				$diff = $date1->diff($date2);
        // 				$ExperienceInYear = $diff->y;
        // 				$actual_ExperienceInYear = $ExperienceInYear;
        // 				if ($diff->d > 0 || $joiningDate == $curr_date) {
        // 					$ExperienceInYear = $ExperienceInYear + 1;
        // 				}

        // 				if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
        // 					$ExperienceInYear = 1;
        // 				}


        // 				$annualEntitle13=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();

        // 				if($actual_ExperienceInYear>0){
        // 					$annualEntitle = $annualEntitle13->no_leaves;
        // 				}

        // 			}

        // 			$annaualTaken = getTakenLeaveCount($username, $year, "Annual");
        // 			$rlLeave = getReplacementLeaveCount($username, $year);
        // 			$medicalTaken = getTakenLeaveCount($username, $year, "Medical");
        // 			$pastLeaves = getTakenPastLeaves($username, $year);
        // 			$adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
        // 			if ($SoftwareStartDate <= ($year - 1)) {
        // 				$bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
        // 				//dd($bfAnnual);
        // 			} else {
        // 				$bfAnnual = 0;
        // 			}


        // 			//echo $bfAnnual;exit;
        // 			$EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);

        // 			$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
        // 			$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
        // 			$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
        // 			$nplCount = getNPLCount($username, $year);
        // 			if($cutOffStartMonth!='1'){
        // 				$BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
        // 			}else{
        // 				$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
        // 			}

        // 			if ($BFLeaveTaken > $bfAnnual) {
        // 				$BFLeaveTaken = $bfAnnual;
        // 			}

        // 			$bfAdjLeaveTaken =getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

        // 			$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);

        // 			$tilldateDaysVal = tilldateDays($date_commence);
        // 			$tillYearEndDaysVal = tillYearEndDays($date_commence);
        // 			$YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);

        // 			$resiged_date_str = $date_commence11->date_resigned;
        // 			$resiged_date = strtotime($resiged_date_str);
        // 			$resiged_year = date('Y', $resiged_date);

        // 			$joiningDate = $date_commence11->date_commence;

        // 			if ($SettingLeaveAdjustmentType == 8) {
        // 				$annual_ent = get_anniv_cutt_off_entitle($username, $year);
        // 				$cut_off_days = day_count_anniv_cutt_off($username, $year);
        // 				$earn = ($cut_off_days / 365) * $annual_ent;
        // 				$earn = roundaway($earn);
        // 			} else {
        // 				if ($year < date('Y')) {
        // 					$earn = roundaway($annualEntitle);
        // 				} else {
        // 					if($cutOffStartMonth!=1 && $cutOffMonth <= date('m') && $year<=date('Y')){
        // 						$earn = roundaway($annualEntitle);
        // 					}else if ($year == $resiged_year) {

        // 						if (date("n") < date('n', $resiged_date)) {
        // 							$earn = roundaway((date("n") /  date('n', $resiged_date)) * roundaway($annualEntitle));
        // 						} else {
        // 							$earn = roundaway(roundaway($annualEntitle));
        // 						}
        // 					} else {
        // 						if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
        // 							$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
        // 						} else {
        // 							if ((date("n", strtotime($joiningDate)) == date("n")) && date("Y", strtotime($joiningDate)) == $year) {

        // 								$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
        // 							} else {
        // 								if($cutOffStartMonth>date('n')){
        // 									if(date("Y", strtotime($joiningDate)) == $year){
        // 										$month_cal = date('n') - $joiningDateArr[1];
        // 									}else{
        // 										if($joining_year==($year-1) && $cutOffStartMonth>$joiningDateArr[1]){
        // 											$month_cal_1 = 12 - $cutOffStartMonth;
        // 										}else if($joining_year==($year-1)){
        // 											$month_cal_1 = 12 - $joiningDateArr[1];
        // 										}else{
        // 											$month_cal_1 = 12 - $cutOffStartMonth;
        // 										}
        // 										$month_cal = $month_cal_1 + date('n');
        // 									}
        // 									$month_cal = $month_cal +1;

        // 								}else{
        // 									$month_cal = date('n') - $cutOffStartMonth;
        // 									$month_cal = $month_cal +1;
        // 								}

        // 								if (date("Y", strtotime($joiningDate)) == $year) {
        // 									if ($companyName == "earn_prorated") {
        // 										$earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
        // 									} else {

        // 										$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
        // 									}

        // 									if ($month_cal == 12) {
        // 										$earn = roundaway($annualEntitle);
        // 									}
        // 								} else {
        // 									$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
        // 								}
        // 							}
        // 						}
        // 					}
        // 				}
        // 		}



        //             $medical_claimable_pro_rated1=DB::table('settings')->where('field','medical_claimable_prorated')->first();
        //             if($medical_claimable_pro_rated1!=''){
        //                 $medical_claimable_pro_rated = $medical_claimable_pro_rated1->value;
        //             }
        //             else{
        //                 $medical_claimable_pro_rated = '';
        //             }

        // 			$medical_claimable = $medicalEntitle;
        // 			if ($medical_claimable_pro_rated == 1) {
        // 				$med_claim_sdate = date('Y') . "-".$cutOffStartMonth."-".$cutOffStartDate;
        // 				$med_claim_date1 = new DateTime($med_claim_sdate);
        // 				$med_claim_date2 = new DateTime(date('Y-m-d'));
        // 				$diff = $med_claim_date1->diff($med_claim_date2);
        // 				$med_claim_days = $diff->days + 1;
        // 				$med_claim_days = $med_claim_days / 365;
        // 				$med_claim_days = $med_claim_days * $medicalEntitle;
        // 				$medical_claimable = $med_claim_days;
        // 			}
        // 			$medical_claimable = roundaway($medical_claimable) + $bfMedicalAdj;
        // 		//	dd($annualEntitle,getValue($annualEntitle));
        // 	//dd(getValue($annualEntitle));
        // 			$yearlyEntitle = array(
        // 				"annual" => array(
        // 					"entitle" => getValue($annualEntitle),
        // 					"taken" => floatval($annaualTaken),
        // 					"rlLeave" => floatval($rlLeave),
        // 					"rlLeaveTaken" => $rlLeaveTaken,
        // 					"rlForfeit" => $RL_forfeit,
        // 					"isShowClaimable" => $isShowClaimable
        // 				),
        // 				"medical" => array(
        // 					"entitle" => roundaway($medicalEntitle),
        // 					"taken" => floatval($medicalTaken),
        // 					"claimable" => $medical_claimable
        // 				),
        // 				"past_leaves" => $pastLeaves,
        // 				"adjust_leaves" => $adjustmentLeaves,
        // 				"npl" => $nplCount,
        // 				"earn" => $earn,
        // 				"EmergencyLeaveValue" => $EmergencyLeaveValue,
        // 				"brought_forward" => array(
        // 					"annual" => ($bfAnnual),
        // 					"annual_taken" => floatval($BFLeaveTaken),
        // 					"annual_adj" => ($bfAnnualAdj),
        // 					"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
        // 					"medical" => $bfMedical,
        // 					"medical_adj" => $bfMedicalAdj
        // 				)
        // 			);






        // 			/*BF, BF Adj, ADJ Start*/
        // 			$totalDaysTillToday =  tillTodayTotalDays($year);
        //             // $BFClearDuration1=DB::table('settings')->where('field','bf_duration')->first();
        //             // $BFClearDuration = $BFClearDuration1->value;
        //             // $BFAdjClearDuration1=DB::table('settings')->where('field','bf_adj_duration')->first();
        //             // $BFAdjClearDuration = $BFAdjClearDuration1->value;

        //             $BFClearDuration=0;
        //             $BFAdjClearDuration=0;
        //             if($username!=''){
        //                 $users11=DB::table('users')->where('username',$username)->first();
        //                 $usercat =DB::table('user_category')->where('username',$username)->first();
        //                 $BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        //                 $BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        //                 $BFClearDuration = $BFClearDuration1->value ?? 0;
        //                 $BFAdjClearDuration = $BFAdjClearDuration1->value ?? 0;
        //             }

        // 			$users[$i]->bf_forfeit = 0;
        // 			$users[$i]->bfadj_forfeit = 0;
        // 			$users[$i]->adj_forfeit = 0;

        // 			$bf_forfeit_value = 0;
        // 			$bfadj_forfeit_value = 0;

        // 			if (($BFClearDuration < $totalDaysTillToday || $year != $cutOffYear) && $BFClearDuration < 365) {
        // 				$users[$i]->bf_forfeit = 1;
        // 				$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
        // 			}


        // 			if (($BFAdjClearDuration < $totalDaysTillToday || $year != $cutOffYear) && $BFAdjClearDuration < 365) {
        // 				$users[$i]->bfadj_forfeit = 1;
        // 				$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
        // 			}

        // //dd($bfadj_forfeit_value);

        // 			$total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value);
        // 			/*BF, BF Adj, ADJ End*/

        // 			$users[$i]->entitle = $yearlyEntitle;
        //             //$preset1=DB::table('settings')->where('field','claimable_pre_set')->first();
        //             $usercat =DB::table('user_category')->where('username',$username)->first();
        //             $preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->first();
        // 			$preset = $preset1->value ?? 0;
        // 			$earn1 = ($earn - $preset);
        // 			$ear1 = ($preset / 12) * $annualEntitle;
        // 			$earn1 = $earn - $ear1;
        // 			if ($SettingLeaveAdjustmentType == 8) {
        // 				$_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
        // 			} else {
        // 				if ($year < date('Y')) {
        // 					if ($earn1 > $annualEntitle) {
        // 						$earn2 = $annualEntitle;
        // 					} else {
        // 						$earn2 = $earn1;
        // 					}
        // 					$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;

        // 				} else {
        // 					if ($earn1 > $annualEntitle) {
        // 						$earn2 = $annualEntitle;
        // 					} else {
        // 						$earn2 = $earn1;
        // 					}
        // 					$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;

        // 				}
        // 				$_claim = roundaway($_claim);
        // 				if ($_claim < 0) {
        // 					$_claim = 0;
        // 				}
        // 			}
        //             $confirm_disp1 = DB::table('settings')->where('field','confirm_display')->first();
        // 			$confirm_disp = $confirm_disp1->value;
        // 			$user_pay = $this->getUserPayDetails($users[$i]->username);
        // 			if ($confirm_disp == '1') {
        // 			    //dd($user_pay);
        // 				if ($user_pay[0]->date_confirmed == '' || $user_pay[0]->date_confirmed == '00-00-0000') {
        // 					$_claim = 0;
        // 				}
        // 			}

        // 			$users[$i]->claimable = $_claim;

        //             $users[$i]->balance = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual'])) - $total_forfeit;


        // 		}

        // 		foreach($users as $user112){
        //             $abf_forfeit=0;
        //             if($user112->bf_forfeit==1){
        //                 $actual_bf = ceil(round($user112->entitle['brought_forward']['annual'],2)* 2)/2;
        //                 $taken_bf = ceil(round($user112->entitle['brought_forward']['annual_taken'],2)* 2)/2;
        //                 $abf_forfeit = $actual_bf - $taken_bf;
        //             }
        //           $rl_forfeit = ceil(round($user112->entitle['annual']['rlForfeit'],2)* 2)/2;
        //           $abf_adj_forfeit = 0;
        //             if($user112->bfadj_forfeit==1){
        //                 $actual_bf_adj = ceil(round($user112->entitle['brought_forward']['annual_adj'],2)* 2)/2;
        //                 $taken_bf_adj = ceil(round($user112->entitle['brought_forward']['bfAdjLeaveTaken'],2)* 2)/2;
        //                 $abf_adj_forfeit = $actual_bf_adj - $taken_bf_adj; 
        //             }

        //             $mebalance = ((floatval($user112->entitle['brought_forward']['medical']) + ((round($user112->entitle['medical']['entitle']*2))/2) + floatval($user112->entitle['brought_forward']['medical_adj'])) - (floatval($user112->entitle['medical']['taken']) + floatval($user112->entitle['past_leaves']['medical'])));

        //                 $medleavetaken = (floatval($user112->entitle['medical']['taken']) + floatval($user112->entitle['past_leaves']['medical']));

        //                 $mneg = abs($mebalance);
        //                 $adj=0;
        //                 $meentitle = $user112->entitle['medical']['entitle'];
        //                 if($medleavetaken > $meentitle){
        //                     $npl=0;
        //                     $balance=0;
        //                 }
        //                 else{
        //                     $npl=$user112->entitle['npl'];
        //                     $converted = floatval(round($mebalance,2)); 
        //                     $decimal = ($converted - intval($converted, 10)); 
        //                     $decimal = round($decimal * 10); 
        //                     if ($decimal == 5) { $balance= (intval($converted, 10)+0.5); } 
        //                     if ( ($decimal < 4) || ($decimal > 6) ) { 
        //                         $balance=round($converted); 
        //                     } else {
        //                         $balance= (intval($converted, 10)+0.5); 
        //                     } 
        //                 }
        //             $user112->abf=$user112->entitle['brought_forward']['annual'];
        //             $user112->abfadj=$user112->entitle['brought_forward']['annual_adj'];
        //             $user112->aentitle=$user112->entitle['annual']['entitle'];
        //             $user112->aearn=$user112->entitle['earn'];
        //             $user112->anpl=$user112->entitle['npl'];
        //             $user112->atakenel=$user112->entitle['EmergencyLeaveValue'];
        //             $user112->atakenal=$user112->entitle['annual']['taken']+$user112->entitle['past_leaves']['annual'];
        //             $user112->aforfeitbf=$abf_forfeit;
        //             $user112->aforfeitadj=$abf_adj_forfeit;

        //             $user112->mbf=$user112->entitle['brought_forward']['medical'];
        //             $user112->mbfadj=$user112->entitle['brought_forward']['medical_adj'];
        //             $user112->mentitle=(round($user112->entitle['medical']['entitle']*2))/2;
        //             $user112->madj=0;
        //             $user112->mclaimable=(round($user112->entitle['medical']['claimable']*2))/2;
        //             $user112->mnpl=$npl;
        //             $user112->mtaken=floatval($user112->entitle['medical']['taken']) + floatval($user112->entitle['past_leaves']['medical']);
        //             $user112->mbalance=$balance;

        //         }
        //         if($request->get('pagetype')=='annual'){
        //             if(isset($_GET['order'][0]['column'])){
        //                 $collection = collect($users);
        //                 if($_GET['order'][0]['column']==0){
        //                     $ocolumn="No";
        //                 }
        //                 elseif($_GET['order'][0]['column']==1){
        //                     $ocolumn="name";
        //                 }
        //                 elseif($_GET['order'][0]['column']==2){
        //                     $ocolumn="join_year";
        //                 }
        //                 elseif($_GET['order'][0]['column']==3){
        //                     $ocolumn="abf";
        //                 }
        //                 elseif($_GET['order'][0]['column']==4){
        //                     $ocolumn="abfadj";
        //                 }
        //                 elseif($_GET['order'][0]['column']==5){
        //                     $ocolumn="aentitle";
        //                 }
        //                 elseif($_GET['order'][0]['column']==6){
        //                     $ocolumn="aearn";
        //                 }
        //                 elseif($_GET['order'][0]['column']==7){
        //                     $ocolumn="claimable";
        //                 }
        //                 elseif($_GET['order'][0]['column']==8){
        //                     $ocolumn="anpl";
        //                 }
        //                 elseif($_GET['order'][0]['column']==9){
        //                     $ocolumn="atakenel";
        //                 }
        //                 elseif($_GET['order'][0]['column']==10){
        //                     $ocolumn="aforfeitbf";
        //                 }
        //                 elseif($_GET['order'][0]['column']==11){
        //                     $ocolumn="balance";
        //                 }
        //                 if($_GET['order'][0]['dir']=='asc'){
        //                     $users =  $collection->sortBy($ocolumn)->values();
        //                 }
        //                 else{
        //                     $users =  $collection->sortByDesc($ocolumn)->values();
        //                 }

        //             }
        //             else{
        //                 $users   = $users;
        //             }
        //         }
        //         if($request->get('pagetype')=='medical'){
        //             if(isset($_GET['order'][0]['column'])){
        //                 $collection = collect($users);
        //                 if($_GET['order'][0]['column']==0){
        //                     $ocolumn="No";
        //                 }
        //                 elseif($_GET['order'][0]['column']==1){
        //                     $ocolumn="name";
        //                 }
        //                 elseif($_GET['order'][0]['column']==2){
        //                     $ocolumn="join_year";
        //                 }
        //                 elseif($_GET['order'][0]['column']==3){
        //                     $ocolumn="mbf";
        //                 }
        //                 elseif($_GET['order'][0]['column']==4){
        //                     $ocolumn="mbfadj";
        //                 }
        //                 elseif($_GET['order'][0]['column']==5){
        //                     $ocolumn="madj";
        //                 }
        //                 elseif($_GET['order'][0]['column']==6){
        //                     $ocolumn="mentitle";
        //                 }
        //                 elseif($_GET['order'][0]['column']==7){
        //                     $ocolumn="mclaimable";
        //                 }
        //                 elseif($_GET['order'][0]['column']==8){
        //                     $ocolumn="mnpl";
        //                 }
        //                 elseif($_GET['order'][0]['column']==9){
        //                     $ocolumn="mtaken";
        //                 }
        //                 elseif($_GET['order'][0]['column']==10){
        //                     $ocolumn="mbalance";
        //                 }
        //                 if($_GET['order'][0]['dir']=='asc'){
        //                     $users =  $collection->sortBy($ocolumn)->values();
        //                 }
        //                 else{
        //                     $users =  $collection->sortByDesc($ocolumn)->values();
        //                 }

        //             }
        //             else{
        //                 $users   = $users;
        //             }
        //         }

        // 		$response = array(
        //             "draw" => intval($_GET['draw']),
        //             "iTotalRecords" => $usercount,
        //             "iTotalDisplayRecords" => $usercount,
        //             "aaData" => $users
        //         ); 

        //         return json_encode($response);
        //return $users;
        //	return DataTables::of($users)->make(true);

        $ln = $_GET['length'];
        //	$ln=100;
        $aid = Auth::id();
        $url = str_replace(env('BASE_URL')."e-leave/reports/getYearlyEntitleListHR?", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=report&add_limit=yes&auth_id=$aid&totalemp=$usercount&rlimit=$ln&test=1", $request->getUri());
        // dd($url);
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        // dd(json_decode($response));
        $entitle16 = json_decode($response);
        //dd(count($entitle16));
        // dd($rlentitle16->totalemp);
        // return DataTables::of($rlentitle16)->make(true);
        $responses = array(
            "draw" => intval($_GET['draw']),
            "iTotalRecords" => $usercount,
            "iTotalDisplayRecords" => $usercount,
            "aaData" => $entitle16
        );

        return json_encode($responses);
    }

    public function getUserRequiredListByUsernameHR($nameORNo = "", $year = "")
    {
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", !empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $ActiveUserShownStatus11 = DB::table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value ?? 0;
        $permission_val = $this->getPermissionValue("hr", !empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $approverId = !empty(Auth::check()) ? Auth::user()->username : request()->auth_id;

        $approver_array = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
        $approver_str = "";
        for ($i = 0; $i < count($approver_array); $i++) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ", ";
            }
        }
        $resultCount = DB::table('user_personal as a')->leftjoin('user_pay as b', 'a.username', '=', 'b.username')->leftjoin('branch as d', 'b.branch_id', '=', 'd.id')->whereRaw("1 and (DATE_FORMAT(b.date_resigned,'%Y') >=  '" . $year . "' OR DATE_FORMAT(b.date_resigned,'%Y') = '0000')")->selectRaw("DATE_FORMAT(b.date_commence,'%Y') as join_year1");

        $query = DB::table('user_personal as a')->leftjoin('user_pay as b', 'a.username', '=', 'b.username')->leftjoin('branch as d', 'b.branch_id', '=', 'd.id')->whereRaw("1 and (DATE_FORMAT(b.date_resigned,'%Y') >=  '" . $year . "' OR DATE_FORMAT(b.date_resigned,'%Y') = '0000')")->selectRaw("a.username, a.employee_no, a.employee_no as No, a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(b.date_commence, '%d/%m/%Y') as date_commence, b.date_commence as join_year, DATE_FORMAT(b.date_commence,'%Y') as join_year1");

        if ($nameORNo != "") {
            $resultCount->whereRaw('(a.name like ("' . $nameORNo . '%") OR a.employee_no like ("' . $nameORNo . '%"))');
            $query->whereRaw('(a.name like ("' . $nameORNo . '%") OR a.employee_no like ("' . $nameORNo . '%"))');
        }

        if ($ActiveUserShownStatus == '0') {
            $resultCount->whereRaw("b.pay_status like '%1%'");
            $query->whereRaw("b.pay_status like '%1%'");
        }
        $resultCount->where('a.isDeleted', 0);

        $query->where('a.isDeleted', 0);




        if ($hr_viewStatus == 1) {
            $resultCount->where('a.username', $approverId);
            $query->where('a.username', $approverId);
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            $resultCount->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
            $query->where('b.branch_id', $logged_userGroups->branch_id)->where('b.category_id', $logged_userGroups->category_id)->where('b.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $resultCount->where('b.branch_id', $logged_userGroups->branch_id);
            $query->where('b.branch_id', $logged_userGroups->branch_id);
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $resultCount->where('d.state', $state_nm);
            $query->where('d.state', $state_nm);
        }
        if ($year != "") {
            $resultCount->having('join_year1', '<=', $year);
            $query->having('join_year1', '<=', $year);
        }

        $offset = 0;
        if (isset($_GET['start'])) {
            $offset = $_GET['start'];
        }
        $resultCount = $resultCount->count();
        $length = $resultCount;
        if (isset($_GET['length'])  && $_GET['length'] > 0) {
            $length = $_GET['length'];
        }

        $builder = $query->skip($offset)->take($length)->get();


        $result = $builder;
        $resultData = ['result' => $result, 'count' => $resultCount];
        return $resultData;
    }

    public function getPermissionValue($group, $username)
    {
        $query = "select b.$group as val from map_employee_permission a left join permission_group b ";
        $query .= "on a.permission_group_id=b.id where a.employee_id='$username'";
        $builder = DB::select($query);
        // 		dd("select b.$group as val from map_employee_permission a left join permission_group b on a.permission_group_id=b.id where a.employee_id='$username'");
        $result = intval($builder[0]->val ?? 0);
        return $result;
    }

    public function getPermissionValue11($group, $username, $connection)
    {
        $query = "select b.$group as val from map_employee_permission a left join permission_group b ";
        $query .= "on a.permission_group_id=b.id where a.employee_id='$username'";
        $builder = $connection->select($query);
        $result = intval($builder[0]->val);
        return $result;
    }

    public function getstatebybranch($id)
    {
        $ids = DB::table('branch')->where('id', $id)->get();
        if (count($ids) > 0) {
            return $ids[0]->state;
        } else {
            return '';
        }
    }

    public function getUserRequiredListHR($usernames = "", $year = "", Request $request)
    {
        $ActiveUserShownStatus11 = DB::table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value ?? 0;
        $hr_viewStatus = $this->getPermissionValue("hr_view_all", !empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $permission_val = $this->getPermissionValue("hr", !empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $approverId = !empty(Auth::check()) ? Auth::user()->username : request()->auth_id;
        $approver_array = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
        $approver_str = "";
        for ($i = 0; $i < count($approver_array); $i++) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ", ";
            }
        }

        $yearwisedt = date('Y-m-d');
        $yearwisedt = str_replace(date('Y'), $year, $yearwisedt);

        $resultCount = DB::table('user_personal as a')->leftjoin('user_pay as bb', 'a.username', '=', 'bb.username')->leftjoin('branch as d', 'bb.branch_id', '=', 'd.id')->whereRaw("1 and (DATE_FORMAT(bb.date_resigned,'%Y') >=  '" . $year . "'  OR DATE_FORMAT(bb.date_resigned,'%Y') = '0000' ) ");

        $query = DB::table('user_personal as a')->leftjoin('user_pay as bb', 'a.username', '=', 'bb.username')->leftjoin('branch as d', 'bb.branch_id', '=', 'd.id')->whereRaw("1 and (DATE_FORMAT(bb.date_resigned,'%Y') >=  '" . $year . "'  OR DATE_FORMAT(bb.date_resigned,'%Y') = '0000' ) ")->selectRaw("a.username, a.employee_no, a.employee_no as No, a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(bb.date_commence,'%d/%m/%Y') as date_commence,bb.date_commence as join_year");
        // 		$query = "select a.username, a.employee_no, a.employee_no as No, a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(bb.date_commence, ";
        // 		$query .= "'%d/%m/%Y') as date_commence,bb.date_commence as join_year from user_personal a left join user_pay bb on a.username=bb.username  ";
        // 		$query .= "left join branch d on bb.branch_id=d.id  where 1 ";
        // 		$query .= "and (DATE_FORMAT(bb.date_resigned,'%Y') >=  '".$year."'  OR DATE_FORMAT(bb.date_resigned,'%Y') = '0000' ) ";
        if ($usernames != "") {
            $resultCount->whereIn('a.username', $usernames);
            $query->whereIn('a.username', $usernames);
            // $query .= " and a.username in ($usernames) ";

        }
        if ($ActiveUserShownStatus == '0') {
            $resultCount->whereRaw(" bb.pay_status like '%1%'");
            $query->whereRaw(" bb.pay_status like '%1%'");
            // $query .= " and bb.pay_status like '%1%' ";
        }
        $resultCount->where('a.isDeleted', 0);
        $query->where('a.isDeleted', 0);
        //$query .= " and a.isDeleted=0 ";

        if ($year != "") {
            //$query .= "and DATE_FORMAT(bb.date_commence,'%Y') <='".$year."' ";
            $resultCount->whereRaw(" DATE_FORMAT(bb.date_commence,'%Y') <='" . $year . "'");
            $query->whereRaw(" DATE_FORMAT(bb.date_commence,'%Y') <='" . $year . "'");
        }
        if ($request->get('branch') && $request->get('branch') != '') {
            //$query.=' and bb.branch_id='.$request->get('branch');
            $resultCount->where('bb.branch_id', $request->get('branch'));
            $query->where('bb.branch_id', $request->get('branch'));
        }
        if ($request->get('department') && $request->get('department') != '') {
            //$query.=' and bb.department_id='.$request->get('department');
            $resultCount->where('bb.department_id', $request->get('department'));
            $query->where('bb.department_id', $request->get('department'));
        }
        if ($request->get('category') && $request->get('category') != '') {
            $resultCount->where('bb.category_id', $request->get('category'));
            $query->where('bb.category_id', $request->get('category'));
            // 			$query.=' and bb.category_id='.$request->get('category');
        }
        if ($hr_viewStatus == 1) {
            $resultCount->where('a.username', $approverId);
            $query->where('a.username', $approverId);
            //	$query .= " and a.username= '".$approverId."' ";
        } else if ($hr_viewStatus == 2) {
            $logged_userGroups = getUserGroups($approverId);
            // 			$query .= " and bb.branch_id= '".$logged_userGroups['branch_id']."' ";
            // 			$query .= " and bb.category_id= '".$logged_userGroups['category_id']."' ";
            // 			$query .= " and  bb.department_id= '".$logged_userGroups['department_id']."' ";
            $resultCount->where('bb.branch_id', $logged_userGroups->branch_id)->where('bb.category_id', $logged_userGroups->category_id)->where('bb.department_id', $logged_userGroups->department_id);
            $query->where('bb.branch_id', $logged_userGroups->branch_id)->where('bb.category_id', $logged_userGroups->category_id)->where('bb.department_id', $logged_userGroups->department_id);
        } else if ($hr_viewStatus == 3) {
            $logged_userGroups = getUserGroups($approverId);
            $resultCount->where('bb.branch_id', $logged_userGroups->branch_id);
            $query->where('bb.branch_id', $logged_userGroups->branch_id);
            //$query .= " and bb.branch_id= '".$logged_userGroups['branch_id']."' ";
        } else if ($hr_viewStatus == 4) {
            $userbranchId = $this->getUserBranchId($approverId);
            $state_nm = $this->getstatebybranch($userbranchId);
            $resultCount->where('d.state', $state_nm);
            $query->where('d.state', $state_nm);
            //$query .= " and  d.state= '".$state_nm."' ";
        }
        $offset = 0;
        if (isset($_GET['start'])) {
            $offset = $_GET['start'];
        }
        $resultCount = $resultCount->count();
        $length = $resultCount;
        if (isset($_GET['length'])  && $_GET['length'] > 0) {
            $length = $_GET['length'];
        }

        $builder = $query->skip($offset)->take($length)->get();


        //$builder = DB::select($query);
        $result = $builder;
        $resultData = ['result' => $result, 'count' => $resultCount];
        return $resultData;
    }

    public function get_curr_joining_date($username, $year)
    {
        $joiningDate1 = UserPay::where('username', $username)->first();
        $joiningDate = $joiningDate1->date_commence;
        $joiningDateArr = explode('-', $joiningDate);
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];

        $joining_curr_Date = $year . '-' . $joining_month . '-' . $joining_date;
        return $joining_curr_Date;
    }

    public function leaveentitle()
    {
        $user = User::where('id', Auth::id())->first();
        $leave_name = DB::table('leave_name')->selectRaw("type")->where('company_id', $user->company_id)->whereRaw("(type ='Maternity' or type = 'Marriage' or type = 'Compassionate' or type = 'Hospital' or type='Examination' or type='Paternity' or type='Advance' or type='Other_pay' or type='Line_Shut' or type='Emergency')")->get();

        $categorynames = DB::table('category_name')->where('company_id', $user->company_id)->where('is_deleted', 0)->get();
        return view('hr.setup.leave-entitle', compact('leave_name', 'categorynames'));
    }

    public function getLeaveEntitleList()
    {
        $user = User::where('id', Auth::id())->first();
        $annual = DB::table('leave_entitle')->where('company_id', $user->company_id)->selectRaw("type, category_name, experience, no_leaves")->where('type', 'annual')->get();
        $result['annual'] = $annual;

        $medical = DB::table('leave_entitle')->where('company_id', $user->company_id)->selectRaw("type, category_name, experience, no_leaves")->where('type', 'medical')->get();
        $result['medical'] = $medical;

        $max_allow_leave = DB::table('category_max_leave')->where('company_id', $user->company_id)->selectRaw("leave_type, category, max_value")->get();
        $result['max_allow_leave'] = $max_allow_leave;

        $HolidayRestDayInclusive = DB::table('holiday_restday_inleave_setting')->leftjoin('category_name', 'holiday_restday_inleave_setting.category', '=', 'category_name.id')->where('category_name.is_deleted', 0)->where('holiday_restday_inleave_setting.company_id', $user->company_id)->selectRaw("holiday_restday_inleave_setting.leave_type, holiday_restday_inleave_setting.category, holiday_restday_inleave_setting.restday_added, holiday_restday_inleave_setting.holiday_added")->get();
        $result['HolidayRestDayInclusive'] = $HolidayRestDayInclusive;

        return $result;
    }

    public function setannualentitle(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $annualentitle_json = json_decode(stripslashes($request->annualentitle_json));
        for ($i = 0; $i < count($annualentitle_json); $i++) {
            $category = $annualentitle_json[$i]->category;
            $experience = $annualentitle_json[$i]->experience;
            $noRate = $annualentitle_json[$i]->noRate;
            $type = 'Annual';

            $entitle = LeaveEntitle::where('category_name', $category)->where('experience', $experience)->where('company_id', $user->company_id)->where('type', $type)->first();
            if (empty($entitle)) {
                $entitle = new LeaveEntitle;
                $entitle->category_name = $category;
                $entitle->experience = $experience;
                $entitle->no_leaves = $noRate;
                $entitle->type = $type;
                $entitle->company_id = $user->company_id;
                $entitle->save();
            } else {
                $entitle->no_leaves = $noRate;
                $entitle->save();
            }
        }
        return true;
    }

    public function setmdbf(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $mdbf_json = json_decode(stripslashes($request->get('mdbf_json')));
        $rl_json = json_decode(stripslashes($request->get('rl_json')));
        $bf_json = json_decode(stripslashes($request->get('bf_json')));
        $bf_adj_json = json_decode(stripslashes($request->get('bf_adj_json')));
        $claimable_pre_set_json = json_decode(stripslashes($request->get('claimable_pre_set_json')));
        $emergency_leave_json = json_decode(stripslashes($request->get('emergency_leave_json')));
        $max_past_leave_json = json_decode(stripslashes($request->get('max_past_leave_json')));

        for ($i = 0; $i < count($mdbf_json); $i++) {
            // echo $mdbf_json[$i]->category;
            $category = $mdbf_json[$i]->category;
            $experience = $mdbf_json[$i]->experience;
            $percentage = $mdbf_json[$i]->percent;
            $type = $mdbf_json[$i]->cattype;

            if ($type == '') {
                $type = 'days';
            }

            $bfcat = DB::table('leave_brought_forward_category')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($bfcat)) {
                if ($category != '' && $percentage != '' && $type != '') {
                    DB::table('leave_brought_forward_category')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('percentage' => $percentage, 'type' => $type));
                    // return true;
                }
            } else {
                if ($category != '' && $percentage != '' && $type != '') {
                    DB::table('leave_brought_forward_category')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'percentage' => $percentage, 'type' => $type));
                    // return true;
                }
            }
        }

        for ($j = 0; $j < count($rl_json); $j++) {
            $category = $rl_json[$j]->category;
            $value = $rl_json[$j]->value;


            $rl = DB::table('replacement_duration')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($rl)) {
                if ($category != '' && $value != '') {
                    DB::table('replacement_duration')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('replacement_duration')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }
        for ($k = 0; $k < count($bf_json); $k++) {

            $category = $bf_json[$k]->category;
            $value = $bf_json[$k]->value;

            $bf = DB::table('bf_duration')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($bf)) {
                if ($category != '' && $value != '') {
                    DB::table('bf_duration')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('bf_duration')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }

        for ($l = 0; $l < count($bf_adj_json); $l++) {

            $category = $bf_adj_json[$l]->category;
            $value = $bf_adj_json[$l]->value;


            $bfadj = DB::table('bf_adj_duration')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($bfadj)) {
                if ($category != '' && $value != '') {
                    DB::table('bf_adj_duration')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('bf_adj_duration')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }

        for ($m = 0; $m < count($claimable_pre_set_json); $m++) {
            $category = $claimable_pre_set_json[$m]->category;
            $value = $claimable_pre_set_json[$m]->value;


            $claimable = DB::table('claimable_pre_set')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($claimable)) {
                if ($category != '' && $value != '') {
                    DB::table('claimable_pre_set')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('claimable_pre_set')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }
        for ($n = 0; $n < count($emergency_leave_json); $n++) {

            $category = $emergency_leave_json[$n]->category;
            $value = $emergency_leave_json[$n]->value;

            $emergency = DB::table('emergency_leave')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($emergency)) {
                if ($category != '' && $value != '') {
                    DB::table('emergency_leave')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('emergency_leave')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }

        for ($o = 0; $o < count($max_past_leave_json); $o++) {

            $category = $max_past_leave_json[$o]->category;
            $value = $max_past_leave_json[$o]->value;


            $maxpast = DB::table('max_past_leave')->where('category_name', $category)->where('company_id', $user->company_id)->first();

            if (!empty($maxpast)) {
                if ($category != '' && $value != '') {
                    DB::table('max_past_leave')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('value' => $value));
                }
            } else {
                if ($category != '' && $value != '') {
                    DB::table('max_past_leave')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'value' => $value));
                }
            }
        }

        return true;
    }


    public function setmedicalentitle(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $medicalentitle_json = json_decode(stripslashes($request->medicalentitle_json));
        for ($i = 0; $i < count($medicalentitle_json); $i++) {
            $category = $medicalentitle_json[$i]->category;
            $experience = $medicalentitle_json[$i]->experience;
            $noRate = $medicalentitle_json[$i]->noRate;
            $type = 'Medical';

            $entitle = LeaveEntitle::where('category_name', $category)->where('experience', $experience)->where('company_id', $user->company_id)->where('type', $type)->first();
            if (empty($entitle)) {
                $entitle = new LeaveEntitle;
                $entitle->category_name = $category;
                $entitle->experience = $experience;
                $entitle->no_leaves = $noRate;
                $entitle->type = $type;
                $entitle->company_id = $user->company_id;
                $entitle->save();
            } else {
                $entitle->no_leaves = $noRate;
                $entitle->save();
            }
        }
        return true;
    }

    public function setmaxleaveallowentitle(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $maxleaveallowentitle_json = json_decode(stripslashes($request->get('maxleaveallowentitle_json')));
        for ($i = 0; $i < count($maxleaveallowentitle_json); $i++) {
            $category = $maxleaveallowentitle_json[$i]->category;
            $lname = $maxleaveallowentitle_json[$i]->lname;
            $value = $maxleaveallowentitle_json[$i]->value;

            $entitle = CategoryMaxLeave::where('category', $category)->where('company_id', $user->company_id)->where('leave_type', $lname)->first();
            if (empty($entitle)) {
                $entitle = new CategoryMaxLeave;
                $entitle->category = $category;
                $entitle->leave_type = $lname;
                $entitle->max_value = $value;
                $entitle->company_id = $user->company_id;
                $entitle->save();
            } else {
                $entitle->max_value = $value;
                $entitle->save();
            }
        }
        return true;
    }

    public function setholidayrestdaysetting(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $holidayrestdaysetting_json = json_decode(stripslashes($request->post('holidayrestdaysetting_json')));
        for ($i = 0; $i < count($holidayrestdaysetting_json); $i++) {
            $category = $holidayrestdaysetting_json[$i]->category;
            $lname = $holidayrestdaysetting_json[$i]->lname;
            $restday = $holidayrestdaysetting_json[$i]->restday;
            $holiday = $holidayrestdaysetting_json[$i]->holiday;

            $entitle = HolidayRestDayInleaveSetting::where('category', $category)->where('company_id', $user->company_id)->where('leave_type', $lname)->first();

            if (empty($entitle)) {

                $entitle = new HolidayRestDayInleaveSetting;
                $entitle->category = $category;
                $entitle->leave_type = $lname;
                $entitle->restday_added = $restday;
                $entitle->holiday_added = $holiday;
                $entitle->company_id = $user->company_id;
                $entitle->save();
            } else {
                // dd($entitle);
                $entitle->restday_added = $restday;
                $entitle->holiday_added = $holiday;
                $entitle->save();
                //dd($entitle);
            }
        }
        return true;
    }

    public function edit_Leave()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        return view('hr.setup.edit_leave', compact('departments', 'branches', 'categories', 'leaveTypes', 'deleteBtnShowSetting'));
    }

    public function getLeaveListForAdminFromTo(Request $request)
    {
        $hours = gethours();
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        $currentOnly = $currentOnly1->value ?? 0;


        $query = "select a.id,b.approver_id as approver_id ,a.username as username, 0 as leave_type, b.id as leave_id, c.name, c.employee_no, e.name as branch, f.name as ";
        $query .= "department, g.name as category, b.type, DATE_FORMAT(b.date_applied, '%d/%m/%Y') ";
        $query .= "as date_applied, 0 as isPast, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, a.date as sdate, ";
        $query .= "DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, ";
        $query .= "(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as 'no_days', b.is_half_day, b.start_time,b.end_time, a.status, b.reason, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, b.is_hourly, ";
        $query .= " CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type',  ";
        $query .= "a.cancellation_reason, b.filename from leave_days a left join leave_list b on a.leave_id=b.id left join user_personal c ";
        $query .= "on a.username=c.username left join user_pay d ";
        $query .= "on a.username=d.username left join branch e on d.branch_id=e.id left join department f ";
        $query .= "on d.department_id=f.id left join category g on d.category_id=g.id where a.status!=0 ";
        if ($request->get('branch_id') && $request->get('branch_id') != '') {
            $query .= " and e.id='" . $request->get('branch_id') . "' ";
        }
        if ($request->get('department_id') && $request->get('department_id') != '') {
            $query .= " and f.id='" . $request->get('department_id') . "' ";
        }
        if ($request->get('category_id') && $request->get('category_id') != '') {
            $query .= " and g.id='" . $request->get('category_id') . "' ";
        }
        if ($request->get('type') && $request->get('type') != '') {
            $query .= " and b.type='" . $request->get('type') . "' ";
        }
        if ($request->get('empno') && $request->get('empno') != '') {
            $query .= " and c.employee_no='" . $request->get('empno') . "' ";
        }
        if ($request->get('sname') &&  $request->get('sname') != "") {
            $query .= ' and (c.name like "' . $request->get('sname') . '%" OR c.employee_no like "' . $request->get('sname') . '%") ';
        }
        if ($request->get('name') &&  $request->get('name') != "") {
            $query .= ' and (c.name like "' . $request->get('name') . '%" OR c.employee_no like "' . $request->get('name') . '%") ';
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            $query .= " and a.date between '" . $from . "' and '" . $to . "'";
        } elseif ($from != '') {
            $query .= "and a.date ='" . $from . "'";
        } elseif ($to != '') {
            $query .= "and a.date ='" . $to . "'";
        }
        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }

        if ($ActiveUserShownStatus == '1') {
            $query .= "and (d.pay_status = '1' or d.pay_status = '0') ";
        } else {
            $query .= "and d.pay_status = '1' ";
        }


        $query1 = "select a.id, '' as approver_id,a.username as username, 1 as leave_type, 0, b.name, b.employee_no, e.name as branch, f.name as ";
        $query1 .= "department, g.name as category, type, '-' as date_applied, 1 as isPast, DATE_FORMAT(a.start_date, ";
        $query1 .= "'%d/%m/%Y') as start_date, a.start_date as sdate, DATE_FORMAT(a.end_date, '%d/%m/%Y') as end_date, (CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.total_leave_days END) ";
        $query1 .= "as no_days, 0, 0, 0, 1 as status, 'Past Leave' as reason, CASE a.is_hourly WHEN 1 THEN ( (a.end_time-a.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, a.is_hourly, CASE total_leave_days WHEN 0.5 THEN ( CASE half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_type', '' as cancellation_reason, '' as filename from ";
        $query1 .= "leave_past a left join user_personal b on a.username=b.username left join user_pay d ";
        $query1 .= "on a.username=d.username left join branch e on d.branch_id=e.id left join department f ";
        $query1 .= "on d.department_id=f.id left join category g on d.category_id=g.id where a.id > 0 ";
        if ($request->get('branch_id') && $request->get('branch_id') != '') {
            $query1 .= " and e.id='" . $request->get('branch_id') . "' ";
        }
        if ($request->get('department_id') && $request->get('department_id') != '') {
            $query1 .= " and f.id='" . $request->get('department_id') . "' ";
        }
        if ($request->get('category_id') && $request->get('category_id') != '') {
            $query1 .= " and g.id='" . $request->get('category_id') . "' ";
        }
        if ($request->get('type') && $request->get('type') != '') {
            $query1 .= " and a.type='" . $request->get('type') . "' ";
        }
        if ($request->get('empno') && $request->get('empno') != '') {
            $query1 .= " and b.employee_no='" . $request->get('empno') . "' ";
        }
        if ($request->get('sname') && $request->get('sname') != "") {
            $query1 .= ' and (b.name like "' . $request->sname . '%" OR b.employee_no like "' .
                $request->sname . '%") ';
        }
        if ($request->get('name') &&  $request->get('name') != "") {
            $query1 .= ' and (b.name like "' . $request->name . '%" OR b.employee_no like "' . $request->name . '%") ';
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            $query1 .= " and a.start_date between '" . $from . "' and '" . $to . "'";
        } elseif ($from != '') {
            $query1 .= "and a.start_date ='" . $from . "'";
        } elseif ($to != '') {
            $query1 .= "and a.start_date ='" . $to . "'";
        }
        if ($currentOnly == '1') {
            $query1 .= " and DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query1 .= "and (d.pay_status = '1' or d.pay_status = '0') ";
        } else {
            $query1 .= "and d.pay_status = '1' ";
        }


        $query2 = $query;
        $query2 .= " union ";
        $query2 .= $query1;
        $query2 .= "order by STR_TO_DATE(start_date, '%d/%m/%Y') DESC";

        $builder = DB::select($query2);
        $i = 0;
        foreach ($builder as $item) {

            $type = DB::table('leave_name')->where('type', $item->type)->where('company_id', $user->company_id)->first();
            if ($item->is_hourly != 0) {
                $item->start_time = date('h:i A', $item->start_time);
                $item->end_time = date('h:i A', $item->end_time);
            }
            if ($item->status == 0) {
                $status = 'Pending';
                $class = '#82868b';
            } elseif ($item->status == 1) {
                $status = 'Approved';
                $class = '#28c76f';
            } elseif ($item->status == 2) {
                $status = 'Rejected';
                $class = '#ea5455';
            } elseif ($item->status == 3) {
                $status = 'Recommended';
                $class = '#7367f0';
            } elseif ($item->status == 4) {
                $status = 'Cancelled';
                $class = '#00cfe8';
            } elseif ($item->status == 5) {
                $status = 'Cancellation Pending';
                $class = '#ff9f43';
            }

            $item->back_color = $class;
            $item->leave_status = $status;
            $item->i = $i;
            $i++;
            if (!empty($type)) {
                $item->leave_type  = $type->name;
            } else {
                $item->leave_type  = $item->type;
            }
        }

        if ($request->get('val') == 'normal') {
            return $builder;
        }


        return DataTables::of($builder)->make(true);
    }

    public function leaveReplacement()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        return view('hr.setup.leave_replacement', compact('departments', 'branches', 'categories', 'deleteBtnShowSetting', 'leaveTypes'));
    }

    public function getLeaveAdjustmentList(Request $request)
    {
        session(['replacement_pdf_data' => $request->getUri()]);
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }

        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        $currentOnly = $currentOnly1->value ?? 0;

        $query = "select a.id, a.employee_id, a.granted, a.reason, b.employee_no, b.name, d.name as branch, e.name as department, f.name as category, a.start_date, a.end_date, a.no_days, sum(a.no_granted) as no_granted,sum(a.no_hours) as no_hours, a.is_hourly from ";
        $query .= "leave_adjustment a left join user_personal b on a.employee_id=b.username left join user_pay ";
        $query .= "c on a.employee_id=c.username left join branch d on c.branch_id=d.id left join department e on ";
        $query .= "c.department_id=e.id left join category f on c.category_id=f.id where 1 ";
        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= " and (c.pay_status = '1' or c.pay_status = '0') ";
        } else {
            $query .= " and c.pay_status = '1' ";
        }
        if ($request->get('branch_id') && $request->get('branch_id') != '') {
            $query .= " and c.branch_id='" . $request->get('branch_id') . "' ";
        }
        if ($request->get('department_id') && $request->get('department_id') != '') {
            $query .= " and c.department_id='" . $request->get('department_id') . "' ";
        }
        if ($request->get('category_id') && $request->get('category_id') != '') {
            $query .= " and c.category_id='" . $request->get('category_id') . "' ";
        }
        if ($request->get('sname') &&  $request->get('sname') != "") {
            $query .= ' and (b.name like "' . $request->get('sname') . '%" OR b.employee_no like "' . $request->get('sname') . '%") ';
        }
        if ($request->get('from') != '' && $request->get('to') != '') {
            $query .= " and a.start_date between '" . $request->get('from') . "' and '" . $request->get('to') . "'  ";
        } elseif ($request->get('from') != '') {
            $query .= " and a.start_date='" . $request->get('from') . "' ";
        } elseif ($request->get('to') != '') {
            $query .= " and a.start_date='" . $request->get('to') . "' ";
        }

        $query .= " and  a.company_id='" . $user->company_id . "' group by a.employee_id,a.start_date";

        $result = DB::select($query);
        return DataTables::of($result)->make(true);
    }

    public function leavereplacementpdf(Request $request)
    {


        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('replacement_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('replacement_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('replacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $replacement = json_decode($response)->data;
        //return view('hr.reports.pdf.deptpdf', compact('departments'));
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $html = html_entity_decode(view('hr.reports.pdf.replacementpdf', compact('replacement', 'timedate', 'companyname')));
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Replacement Leave Report');
        return 1;
    }


    public function leavereplacementexport(Request $request)
    {
        //$url = str_replace("length=20","length=-1",session('replacement_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('replacement_pdf_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('replacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $leaves = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Replacement Leave Report');
        $sheet->setCellValue('A' . 2, 'Emp No');
        $sheet->setCellValue('B' . 2, 'Name');
        $sheet->setCellValue('C' . 2, 'Department');
        $sheet->setCellValue('D' . 2, 'Branch');
        $sheet->setCellValue('E' . 2, 'Category');
        $sheet->setCellValue('F' . 2, 'Date');
        $sheet->setCellValue('G' . 2, 'Days Granted');
        $sheet->setCellValue('H' . 2, 'Reason');

        $rows = 2;
        foreach ($leaves as $leave) {

            $rows++;
            $sheet->setCellValue('A' . $rows, $leave->employee_no);
            $sheet->setCellValue('B' . $rows, mb_convert_encoding($leave->name, "UTF-8", "HTML-ENTITIES"));
            $sheet->setCellValue('C' . $rows, $leave->department);
            $sheet->setCellValue('D' . $rows, $leave->branch);
            $sheet->setCellValue('E' . $rows, $leave->category);
            $sheet->setCellValue('F' . $rows, !is_null($leave->start_date) ? date('d-m-Y', strtotime($leave->start_date)) : "");
            $sheet->setCellValue('G' . $rows, $leave->no_granted);
            $sheet->setCellValue('H' . $rows, $leave->reason);
        }


        $fileName = "replacementleave-report.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    public function deleteLeaveAdjustment(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('leave_adjustment')->where('id', $request->id)->where('company_id', $user->company_id)->delete();
    }

    public function getreplacement_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('leave_adjustment')->where('company_id', $user->company_id)->find($id);
        return $result;
    }

    public function editreplacementleave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        if ($request->hourly ?? 0 == 1) {
            DB::table('leave_adjustment')->where('id', $request->replacement_id)->where('company_id', $user->company_id)->update(array('start_date' => $request->start_date, 'no_hours' => $request->no_hours));
        } else {
            DB::table('leave_adjustment')->where('id', $request->replacement_id)->where('company_id', $user->company_id)->update(array('start_date' => $request->start_date, 'no_granted' => $request->no_granted));
        }
    }

    public function addLeaveAdjustment(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $hours = 0;
        if (isset($request->no_hours) && $request->no_hours != '') {
            $hours = $request->no_hours;
        }
        if (isset($request->granted) && $request->granted != '') {
            $Granted = $request->granted;
        } else {
            $Granted = 0;
        }
        $flag = DB::table('leave_adjustment')->where('employee_id', $request->employee_id)->where('start_date', $request->work_date)->where('end_date', '2013-01-01')->where('company_id', $user->company_id)->first();
        $values = array('employee_id' => $request->employee_id, 'start_date' => $request->work_date, 'end_date' => '2013-01-01', 'no_days' => $Granted, 'no_hours' => $hours, 'no_granted' => $request->no_granted, 'is_hourly' => $request->is_hourly ?? 0, 'reason' => $request->reason, 'company_id' => $user->company_id);
        if (!empty($flag)) {
            DB::table('leave_adjustment')->where('employee_id', $request->employee_id)->where('start_date', $request->work_date)->where('end_date', '2013-01-01')->where('company_id', $user->company_id)->update($values);
        } else {

            DB::table('leave_adjustment')->insert($values);
        }
    }


    public function pastLeave()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('hr.setup.past_leave', compact('departments', 'branches', 'categories', 'deleteBtnShowSetting', 'leaveTypes', 'userPay'));
    }

    public function getAllPastLeavesFromTo(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        $currentOnly = $currentOnly1->value ?? 0;

        $query = "select a.id, a.username, b.employee_no, b.name, d.name as branch, e.name as department, f.name as category, ";
        $query .= " CASE a.total_leave_days WHEN 0.5 THEN ( CASE a.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_typeAMPM',  ";
        $query .= "a.type, a.start_date, a.end_date, a.total_leave_days, a.half_day_type, lname.name as leave_type, CASE a.is_hourly WHEN 1 THEN ( (a.end_time-a.start_time)/3600 ) WHEN 0 THEN 0 END as hours,a.is_hourly from leave_past a left join ";
        $query .= "user_personal b on a.username=b.username left join user_pay c on a.username=c.username ";
        $query .= "left join branch d on c.branch_id=d.id left join department e on c.department_id=e.id ";
        $query .= "left join category f on c.category_id=f.id left join user_pay up on a.username=up.username left join leave_name lname on a.type=lname.type ";

        $query .= " where 1 and a.company_id='" . $user->company_id . "'";

        if ($currentOnly == '1' && $request->from == '') {
            $query .= " and DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= " and (up.pay_status = '1' or up.pay_status = '0') ";
        } else {
            $query .= " and up.pay_status = '1' ";
        }
        if ($request->get('branch_id') && $request->get('branch_id') != '') {
            $query .= " and c.branch_id='" . $request->get('branch_id') . "' ";
        }
        if ($request->get('department_id') && $request->get('department_id') != '') {
            $query .= " and c.department_id='" . $request->get('department_id') . "' ";
        }
        if ($request->get('category_id') && $request->get('category_id') != '') {
            $query .= " and c.category_id='" . $request->get('category_id') . "' ";
        }
        if ($request->get('name') &&  $request->get('name') != "") {
            $query .= ' and (b.name like "' . $request->name . '%" OR b.employee_no like "' . $request->name . '%") ';
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if ($from != '' && $to != '') {
            $query .= " and a.start_date between '" . $from . "' and '" . $to . "'";
        } elseif ($from != '') {
            $query .= "and a.start_date ='" . $from . "'";
        } elseif ($to != '') {
            $query .= "and a.start_date ='" . $to . "'";
        }

        $result = DB::select($query);
        return DataTables::of($result)->make(true);
    }

    public function getpastleave_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('leave_past')->selectRaw("leave_past.*, CASE leave_past.is_hourly WHEN 1 THEN ( (leave_past.end_time-leave_past.start_time)/3600 ) WHEN 0 THEN 0 END as hours")->where('company_id', $user->company_id)->find($id);
        $result->leavename = DB::table('leave_name')->where('company_id', $user->company_id)->orderBy('name')->get();
        return $result;
    }

    public function addPastLeave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        //$result = DB::table('settings')->where('field', 'max_past_leave')->where('company_id',$user->company_id)->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('max_past_leave')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        // if(!empty($result)){
        //     if($result->value==0){
        //         return array("result" => "notapplied");
        //     }

        // }
        $username = (isset($request->username) ? $request->username : $user->username);
        $type = $request->type;
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $year = date('Y', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $leaveDays = $request->leave_days;
        $half_day_type = ($request->half_day_type != "") ? $request->half_day_type : "";
        $startTime = '';
        $endTime = '';
        if ($request->hourly == 1) {
            $half_day_type1 = '';
            $is_hourly = 1;
            $hours = gethours();
            $hourly = $request->hourly ?? 0;
            $time_from = $request->time_from;
            $time_for = $request->time_for;
            $no_of_hours = $request->leave_hours;
            $leaveDays = $no_of_hours / $hours;
            $noDays = 0;
            $leavedate = $request->start_date . ' ' . $time_from;
            $startTime = strtotime($leavedate);
            $time_for = explode(":", $time_for);
            $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $time_for[0] . ' hours')));
        }


        $D_year = date('Y', strtotime($request->start_date));

        $add_allow = true;
        $msg = "";

        if ($type == "Other_pay") {

            $msg = "Not have sufficient Replacement leave.";
            $leaveCount = $this->getAdjustmentLeaveCount2($username, $year);
            $RL_forfeit = getForfeitAdjLeaveCount($username, $year);


            $value = (isset($request->rlleavevalue)) ? $request->rlleavevalue : $leaveCount;
            if ($value >= $leaveDays) {
                $add_allow = true;
                if ($leaveDays < 1) {
                    $this->markReplacementLeaveAsTaken($username, $D_year, $startDate);
                } else {
                    $noDays = 1;
                    for ($_rl_i = 0; $_rl_i < ($noDays * 2); $_rl_i++) {
                        $this->markReplacementLeaveAsTaken($username, $D_year, $startDate);
                    }
                }
            } else {
                $add_allow = false;
            }
        }
        if ($request->hourly ?? 0 == '1') {
            if (isLeaveHourlyAllow($username, $startDate, $startTime, $endTime)) {
                $add_allow = true;
            } else {
                $add_allow = false;
            }
        }
        //exit;
        if ($add_allow) {
            $result = $this->addPastLeave11($username, $type, $startDate, $endDate, $leaveDays, $startTime, $endTime, $request->hourly ?? 0, $half_day_type);
            return array("result" => $result);
            if ($type == 'Annual' || $type == 'Medical' || $type == 'Other_pay') {
                $this->addLeaveEntitleHistory($username, $year, $type);
            }
        } else {
            return array("result" => false, "msg" => $msg);
        }
    }

    public function getAdjustmentLeaveCount2($username, $year, $stat = 0)
    {
        if ($stat == 0) {

            $query = DB::table('leave_adjustment')->where('employee_id', $username)->whereYear('start_date', $year)->whereRaw("(taken_stat=0 OR taken_stat=0.5)")->selectRaw("sum(CASE taken_stat WHEN 0 then no_granted WHEN 0.5 THEN (no_granted - 0.5) END) as ttl")->first();
        } else {

            $query = DB::table('leave_adjustment')->where('employee_id', $username)->whereYear('start_date', $year)->selectRaw("sum(no_granted) as ttl")->first();
        }

        return floatval($query->ttl);
    }


    public function addPastLeave11($username, $type, $startDate, $endDate, $leaveDays, $startTime = '', $endTime = '', $hourly = '', $half_day_type = '')
    {
        $user = User::where('id', Auth::id())->first();
        $exist = DB::table('leave_past')->where('username', $username)->where('type', $type)->where('start_date', $startDate)->where('end_date', $startDate)->where('total_leave_days', $leaveDays)->where('half_day_type', $half_day_type)->get();

        if (count($exist) <= 0) {
            //   $values = array('username' => $username,'type' => $type,'start_date'=>$startDate,'end_date'=>$endDate,'total_leave_days'=>$leaveDays,start_time=>$startTime,'endTime'=>$endTime,'is_hourly'=>$hourly,'half_day_type'=>$half_day_type, 'company_id'=>$user->company_id);

            $data = new LeavePast;
            $data->username = $username;
            $data->type = $type;
            $data->is_hourly = $hourly;
            $data->start_time = $startTime;
            $data->end_time = $endTime;
            $data->start_date = $startDate;
            $data->end_date = $endDate;
            $data->total_leave_days = $leaveDays;
            $data->half_day_type = $half_day_type;
            //$data->time_from = $time_from;
            //$data->time_for = $time_for;
            $data->company_id = $user->company_id;
            $data->save();
            return true;
        }
    }

    public function editpastleave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $id = $request->id;
        $username = ($request->username ? $request->username : $user->username);
        $type = $request->type;
        $old_type = $request->old_type;
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $leaveDays = $request->leave_days;
        $hourly = $request->hourly ?? '';
        $hours = $request->leave_hours ?? '';
        $startTime = $request->start_time ?? '';

        $currentLeaveDetail = $this->getPastLeaveListbyid($id);

        $old_days = $currentLeaveDetail->total_leave_days;
        $startDate_arr = explode("-", $startDate);
        if (count($startDate_arr) > 2) {
            $year = $startDate_arr[0];
        }

        if ($type == "Other_pay") {
            if ($leaveDays > $old_days) {
                $tot = $leaveDays - $old_days;
                $lp = $tot / 0.5;
                for ($i = 1; $i <= $lp; $i++) {
                    $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                }
            } else if ($leaveDays < $old_days) {
                $tot = $old_days - $leaveDays;
                $lp = $tot / 0.5;
                for ($i = 1; $i <= $lp; $i++) {
                    $this->unMarkReplacementLeaveAsTaken($username, $year);
                }
            }
        }

        if ($old_type == "Other_pay" && $type != "Other_pay") {

            if ($leaveDays == "0.5") {
                $this->unMarkReplacementLeaveAsTaken($username, $year);
            } else {
                $this->unMarkReplacementLeaveAsTaken($username, $year);
                $this->unMarkReplacementLeaveAsTaken($username, $year);
            }
        }


        if ($old_type != "Other_pay" && $type == "Other_pay") {
            if ($leaveDays == "0.5") {
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
            } else {
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                $this->markReplacementLeaveAsTaken($username, $year, $startDate);
            }
        }

        $result = $this->updatePastLeave($id, $username, $type, $startDate, $endDate, $leaveDays, $hourly, $hours, $startTime);
        return $result;
    }

    public function deletePastLeave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('leave_past')->where('id', $request->id)->where('company_id', $user->company_id)->delete();
    }

    public function getPastLeaveListbyid($id)
    {
        $hours = gethours();
        $result = DB::table('leave_past')->where('id', $id)->selectRaw("id, username, type, start_date as date, (CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as total_leave_days")->first();
        return $result;
    }

    public function updatePastLeave($id, $username, $type, $startDate, $endDate, $leaveDays, $hourly = '', $hours = '', $startTime = '')
    {
        $user = User::where('id', Auth::id())->first();
        if ($hourly != '' && $hourly == 1) {
            $leavedate = date('Y-m-d H:i A', $startTime);
            //$endTime11 = date("h:i A", strtotime('+'.$time_for[0].' hours +'.$time_for[1].'minutes', strtotime($time_from)));
            //$endTime = strtotime($request->leave_start_date . ' ' . $endTime11);
            $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $hours . ' hours')));
            $result = DB::table('leave_past')->where('id', $id)->where('company_id', $user->company_id)->update(array('username' => $username, 'type' => $type, 'start_date' => $startDate, 'end_date' => $endDate, 'end_time' => $endTime));
        } else {
            $result = DB::table('leave_past')->where('id', $id)->where('company_id', $user->company_id)->update(array('username' => $username, 'type' => $type, 'start_date' => $startDate, 'end_date' => $endDate, 'total_leave_days' => $leaveDays));
        }
        return $result;
    }

    public function getLeaveDaysCount(Request $request)
    {
        $user = User::where('id', Auth::id())->first();

        $type = isset($request->type) ? $request->type : '';
        $half_day_type = isset($request->half_day_type) ? $request->half_day_type : '';
        $is_half_day = isset($request->is_half_day) ? $request->is_half_day : '0';
        $is_pastleave = isset($request->is_pastleave) ? $request->is_pastleave : '0';
        $username = (isset($request->username) ? $request->username : $user->username);
        $hourly = isset($request->hourly) ? $request->hourly : '0';
        $startHour = isset($request->startHour) ? $request->startHour : '0';
        $endHour = isset($request->endHour) ? $request->endHour : '0';

        if ($username == "") {
            return json_encode(array("result" => false, "msg" => "Please refresh your page, before add new leaves."));
            exit;
        }

        $year = date('Y', strtotime($request->start_date));
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $groups = DB::table('user_personal')->where('username', $username)->selectRaw("nationality, state")->first();
        $branch_cat_dept = DB::table('user_pay')->where('username', $username)->selectRaw("branch_id, department_id, category_id")->first();
        $holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0", $startDate, $endDate);
        $restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->start_date, $request->end_date, request());
        $blockdates = $this->getBlockAllDayslistByUserId($username, request());

        $appliedDays = $this->getLeaveDaysBetweenDates($username, $startDate, $endDate);
        $appliedPastDays = $this->getPastLeaveDaysBetweenDates($username, $startDate, $endDate);
        $pastLeaves = getTakenPastLeaves($username, $year);
        $date1 = add_date($startDate);
        $date2 = add_date($endDate);
        $dayCount = 0;
        for ($index = $date1; dateDifference($date2, $index) >= 0; $index = add_date($index, 1)) {
            $restday_allow_now = true;

            if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                if ($this->isRestDay($restdays, $index)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                if ($this->isHoliday($holidays, $index)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow && !$this->isLeaveAppliedDate($index, $appliedDays) && !$this->isLeaveAppliedDate($index, $appliedPastDays)) {
                $dayCount++;
            }
        }

        if ($is_half_day == '1') {
            $restday_allow_now = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                if ($this->isRestDay($restdays, $startDate)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                if ($this->isHoliday($holidays, $startDate)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow) {
                // dd($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave),$this->isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave));
                if ($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave) < 1) {
                    $dayCount += 0.5;
                }
            }
        }

        if ($hourly == 1) {
            $time_from = isset($request->time_from) ? $request->time_from : '';
            $time_for = isset($request->time_for) ? $request->time_for : '';
            $leavedate = $request->start_date . ' ' . $time_from;
            $startTime = strtotime($leavedate);
            $time_for = explode(":", $time_for);
            //$endTime11 = date("h:i A", strtotime('+'.$time_for[0].' hours +'.$time_for[1].'minutes', strtotime($time_from)));
            //$endTime = strtotime($request->leave_start_date . ' ' . $endTime11);
            $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $time_for[0] . ' hours')));

            $restday_allow_now = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                if ($this->isRestDay($restdays, $startDate)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            //echo " Holiday =  ".$this->checkHolidayRestDayInclusive($username,$type,'holiday');
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                if ($this->isHoliday($holidays, $startDate)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow) {
                if (isLeaveHourlyAllow($username, $startDate, $startTime, $endTime) == 1) {
                    $dayCount = ($endTime - $startTime) / (60 * 60);
                }
            }
        }

        return array(
            "no_leave_days" => $dayCount,
            "holidays" => count($holidays),
            "restdays" => count($restdays),
            "blockdates" => count($blockdates),
            "applieddays" => count($appliedDays),
            "past_leaves" => $pastLeaves
        );
    }

    public function getPublicHolidays($country, $state, $branchId, $year, $startDate = "", $endDate = "")
    {
        $searchQuery = "id > 0";
        if ($country != "")
            $searchQuery .= " and country = '$country'";
        if ($state != "")
            $searchQuery .= " and state = '$state'";
        if ($branchId != "0")
            $searchQuery .= " and (branch_id = '$branchId' or branch_id='0')";
        if ($year != "0" && $year != "")
            $searchQuery .= " and year(date) = '$year'";
        if ($startDate != "")
            $searchQuery .= " and date >= '$startDate'";
        if ($endDate != "")
            $searchQuery .= " and date <= '$endDate'";
        $query = "select distinct id, date, day(date) as day, month(date) as month, year(date) as year, state, country,";
        $query .= " description from public_holiday where $searchQuery GROUP BY date, description order by date";
        $result = DB::select($query);
        return $result;
    }

    public function getRestDaysOfEmployeeBetweenDates($employeeId, $startDate, $endDate, Request $request)
    {
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $query = "select employee_id from rest_days where employee_id='" . $employeeId . "'";
        $user = DB::select($query);

        $recat = DB::table('rest_day_category_employee')->where('employee_id', $employeeId)->select('category_id')->first();

        if (!empty($user)) {
            $query1 = "select a.rest_day_id, a.date from rest_dates a left join rest_days b ";
            $query1 .= "on b.id=a.rest_day_id";
            if ($recat != '') {
                $query1 .= " left join rest_day_category_employee c on b.category_id=c.category_id ";
            }
            $query1 .= " where b.employee_id='" . $employeeId . "' and a.date between '" . $startDate . "' and '" . $endDate . "'";
            if ($recat != '') {
                $query1 .= " and b.category_id = '" . $recat->category_id . "'";
            }
            $result = DB::select($query1);
            return $result;
        } else {
            $query1 = "select a.rest_day_id, a.date from rest_dates a left join rest_days b on b.id=a.rest_day_id ";
            $query1 .= "left join rest_day_category_employee c on b.category_id=c.category_id where c.employee_id='" . $employeeId . "'";
            if ($recat != '') {
                $query1 .= " and b.category_id = '" . $recat->category_id . "'";
            }
            $query1 .= " and a.date between '" . $startDate . "' and '" . $endDate . "'";
            $result = DB::select($query1);
            return $result;
        }
    }

    public function getBlockAllDayslistByUserId($username, Request $request)
    {
        if (isset($request->start_date)) {
            $startDate = date('Y-m-d', strtotime($request->start_date));
        } else {
            $startDate = '';
        }
        if (isset($request->end_date)) {
            $endDate = date('Y-m-d', strtotime($request->end_date));
        } else {
            $endDate = '';
        }

        $wh_query = "";
        if ($startDate != '' && $endDate != '') {
            $wh_query = " and bd.block_date between '" . $startDate . "' and '" . $endDate . "' ";
        }

        //branch based for user
        $query = "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.branch_id where up.username='" . $username . "' and bd.is_branch='1'";
        $query .= " and bd.block_date!='1970-01-01' " . $wh_query;

        $query .= " union ";

        //user based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.username where up.username='" . $username . "' and bd.is_user='1'";
        $query .= " and bd.block_date!='1970-01-01' " . $wh_query;

        $query .= " union ";

        //category based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.category_id where up.username='" . $username . "' and bd.is_category='1'";
        $query .= " and bd.block_date!='1970-01-01' " . $wh_query;

        $query .= " union ";

        //department based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.department_id where up.username='" . $username . "' and bd.is_department='1'";
        $query .= " and bd.block_date!='1970-01-01' " . $wh_query;

        $result = DB::select($query);
        return $result;
    }

    public function getLeaveDaysBetweenDates($username, $startDate, $endDate)
    {
        $query = "select date from leave_days where username='" . $username . "' and date>='" . $startDate . "' and date<='" . $endDate . "' and (status='1' OR status='0') ";
        $result = DB::select($query);
        return $result;
    }

    public function getPastLeaveDaysBetweenDates($username, $startDate, $endDate)
    {
        $query = "select start_date as date from leave_past where username='" . $username . "' and start_date='" . $startDate . "' and end_date='" . $endDate . "' ";
        $result = DB::select($query);
        return $result;
    }

    public function checkHolidayRestDayInclusive($username, $type, $restday_or_holiday_check = 'restday')
    {

        $result = false;
        if ($type != 'Annual' && $type != 'Absent' && $type != 'NPL') {
            $categoryId = $this->getUserCategory($username);
            $categoryId = $categoryId[0]->category;
            $HolidayRestDayInclusiveArray = $this->getHolidayRestDayInclusive($type, $categoryId);

            //dd($type, $categoryId);
            if ($restday_or_holiday_check == 'restday') {
                // dd($HolidayRestDayInclusiveArray);
                if ($HolidayRestDayInclusiveArray->restday_added == '1') {
                    $result = true;
                } else {
                    $result = false;
                }
            } else {
                if ($HolidayRestDayInclusiveArray->holiday_added == '1') {
                    $result = true;
                } else {
                    $result = false;
                }
            }
        } else {
            $result = false;
        }
        return $result;
    }

    public function getHolidayRestDayInclusive($leave_type, $category)
    {

        $result = DB::table('holiday_restday_inleave_setting')->selectRaw("`restday_added`,`holiday_added`")->where('leave_type', $leave_type)->where('category', $category)->first();

        return $result;
    }

    public function isRestDay($restdays, $day)
    {
        for ($i = 0; $i < count($restdays); $i++) {
            if ($restdays[$i]->date == $day) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function isHoliday($holidays, $day)
    {
        for ($i = 0; $i < count($holidays); $i++) {
            if ($holidays[$i]->date == $day) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function isLeaveAppliedDate($date, $appliedDays)
    {
        for ($i = 0; $i < count($appliedDays); $i++) {
            if ($appliedDays[$i]->date == $date) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave = 0)
    {
        $val = 0;
        if ($is_pastleave == '1') {
            $val1 = DB::table('leave_past')->where('username', $username)->where('start_date', $startDate)->where('end_date', $endDate)->selectRaw("start_date as date,is_hourly, total_leave_days,half_day_type")->get();
            $not_allow = 1;
            for ($i = 0; $i < count($val1); $i++) {
                // if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
                // dd($val1[$i]->total_leave_days,$val1[$i]->half_day_type,$half_day_type);
                if ($val1[$i]->total_leave_days == '0.5' && $val1[$i]->half_day_type != $half_day_type) {
                    $not_allow = 0;
                } else {
                    $not_allow = 1;
                }
                break;
                // }
            }
            //	dd($not_allow,$val1[$i]->half_day_type,$half_day_type,$val1[$i]->total_leave_days=='0.5',$val1[$i]->half_day_type!=$half_day_type);
            $val = $not_allow;
        } else {

            $result = DB::table('leave_list')->where('username', $username)->where('start_date', $startDate)->where('end_date', $endDate)->where('half_day_type', $half_day_type)->whereRaw("(status='1' OR status='0')")->get();
            //dd($result);

            $not_allow = 0;
            for ($i = 0; $i < count($result); $i++) {
                //dd($result[$i]->is_half_day,$result[$i]->half_day_type,$half_day_type); 
                // if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type!=$half_day_type && $result[$i]->no_days=='0.5'){
                // 	$not_allow = 0;
                // }else{
                $not_allow = 1;
                //}
                break;
            }

            $val = $not_allow;
        }

        // 		$leave=DB::table('leave_list')->where('username',$username)->where('start_date',$startDate)->where('end_date',$endDate)->whereRaw("(status='1' OR status='0')")->sum('no_days');
        // 		$past=DB::table('leave_past')->where('username',$username)->where('start_date',$startDate)->where('end_date',$endDate)->selectRaw("start_date as date,total_leave_days,half_day_type")->sum('total_leave_days');
        // 		$ttl=$leave+$past;
        // 		dd()
        // 		if($ttl>0.5){
        // 		     $val = 1;
        // 		}
        // dd($val);
        return $val;
    }

    public function getYearlyrlEntitleList(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = $request->username ?? $user->username;
        $result = getYearlyrlEntitleList($username, $request->year, $request->start);
        return $result;
    }

    public function compulsoryLeave()
    {
        $user = User::where('id', Auth::id())->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        return view('hr.setup.compulsory_leave', compact('departments', 'branches', 'categories', 'deleteBtnShowSetting', 'leaveTypes'));
    }

    public function getCompulsoryLeaveList(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $currentOnly1 = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        $currentOnly = $currentOnly1->value ?? 0;

        $query = "select a.id, a.username as employee_id, f.employee_no, f.name, c.name as branch, d.name as department, e.name as category, ";
        $query .= "a.type, a.is_half_day, a.start_time, a.end_time, a.start_date, a.end_date, a.no_days,a.is_hourly, CASE a.is_hourly WHEN 1 THEN ( (a.end_time-a.start_time)/3600 ) WHEN 0 THEN 0 END as hours, a.half_day_type, ";
        $query .= "a.reason, a.status, a.date_applied, lname.name as leavename, ldays.id as lid from leave_list a left join leave_days ldays  on a.id=ldays.leave_id left join user_pay b on a.username=b.username ";
        $query .= "left join branch c on b.branch_id=c.id left join department d on b.department_id=d.id ";
        $query .= "left join category e on b.category_id=e.id left join user_personal f on a.username=f.username left join leave_name lname on a.type=lname.type ";
        $query .= " where leave_category='Compulsory' ";
        if ($currentOnly == '1') {
            $query .= " and DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ";
        }
        if ($ActiveUserShownStatus == '1') {
            $query .= " and (b.pay_status = '1' or b.pay_status = '0') ";
        } else {
            $query .= " and b.pay_status = '1' ";
        }
        if ($request->get('branch_id') && $request->get('branch_id') != '') {
            $query .= " and b.branch_id='" . $request->get('branch_id') . "' ";
        }
        if ($request->get('department_id') && $request->get('department_id') != '') {
            $query .= " and b.department_id='" . $request->get('department_id') . "' ";
        }
        if ($request->get('category_id') && $request->get('category_id') != '') {
            $query .= " and b.category_id='" . $request->get('category_id') . "' ";
        }
        if ($request->get('name') &&  $request->get('name') != "") {
            $query .= ' and (f.name like "' . $request->name . '%" OR f.employee_no like "' . $request->name . '%") ';
        }

        if ($request->get('from') != '' && $request->get('to') != '') {
            $query .= " and a.start_date between '" . $request->get('from') . "' and '" . $request->get('to') . "'  ";
        } elseif ($request->get('from') != '') {
            $query .= " and a.start_date='" . $request->get('from') . "' ";
        } elseif ($request->get('to') != '') {
            $query .= " and a.start_date='" . $request->get('to') . "' ";
        }

        $results = DB::select($query);
        $fdata=[];
        foreach ($results as $result) {
            if ($result->is_hourly != 0) {
                $result->start_time = date('h:i A', $result->start_time);
                $result->end_time = date('h:i A', $result->end_time);
            }
            array_push($fdata,$result);
        }
        return DataTables::of($fdata)->make(true);
    }

    public function addCompulsoryLeave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = $request->employee_id;
        $approverId = $user->username;
        $type = $request->type;
        $isHalfDay = $request->is_half_day;
        $half_day_type = ($request->half_day_type != "") ? $request->half_day_type : "";
        $hourly = ($request->is_hourly != "") ? $request->is_hourly : "";
        $startTime = ($request->start_time != "") ? $request->start_time : "";
        $endTime = ($request->end_time != "") ? $request->end_time : "";
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $year = date('Y', strtotime($request->start_date));
        if (isset($request->end_date) && $request->end_date != '') {
            $endDate = date('Y-m-d', strtotime($request->end_date));
        } else {
            $endDate = date('Y-m-d', strtotime($request->start_date));
        }
        $noDays = $request->no_days ?? '';
        $reason = $request->reason;
        $status = "1";


        if ($request->is_half_day == 2) {
            $time_from = $request->time_from;
            $time_for = $request->time_for;
            $no_of_hours = $request->time_for;
            $noDays = 1;
            if (!empty($request->start_date)) {
                $leavedate = $request->start_date . ' ' . $time_from;
                $startTime = strtotime($leavedate);
                $time_for = explode(":", $time_for);
                $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate . ' + ' . $time_for[0] . ' hours')));
            }
            if (!empty($request->start_date)) {
                $endDate = $request->start_date;
            } else {

                $endDate = $request->start_date;
            }
        }

        $checkcount = $this->checkLeave(
            $username,
            $approverId,
            $type,
            $isHalfDay,
            $half_day_type,
            $startTime,
            $endTime,
            $startDate,
            $endDate,
            $noDays,
            $reason,
            "Compulsory"
        );

        if (!$checkcount) {
            return array("result" => FALSE);
        }


        $groups = DB::table('user_personal')->where('username', $username)->selectRaw("nationality, state")->first();
        $branch_cat_dept = DB::table('user_pay')->where('username', $username)->selectRaw("branch_id, department_id, category_id")->first();
        $holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0");
        $restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->start_date, $request->end_date, request());

        $date1 = add_date($startDate);

        $date2 = add_date($endDate);


        $one_leave_added = false;
        for ($index = $date1; dateDifference($date2, $index) >= 0; $index = add_date($index, 1)) {
            $add_allow = false;
            if ($isHalfDay == '1') {
                if ($this->isLeaveHalfDayAllow($username, $index, $index, $isHalfDay, $half_day_type) < 1) {
                    $add_allow = true;
                }
            }
            if ($isHalfDay == '2') {
                if (isLeaveHourlyAllow($username, $startDate, $startTime, $endTime)) {
                    $add_allow = true;
                } else {
                    $add_allow = false;
                }
            }
            $appliedDays = $this->getLeaveDaysBetweenDates($username, $index, $index);
            $appliedPastDays = $this->getPastLeaveDaysBetweenDates($username, $index, $index);

            if (!$this->isLeaveAppliedDate($index, $appliedDays) && !$this->isLeaveAppliedDate($index, $appliedPastDays)) {
                $add_allow = true;
            }

            if (!$this->isHoliday($holidays, $index) == false) {
                return array("result" => 2);
            }
            if (!$this->isRestDay($restdays, $index) == false) {
                return array("result" => 3);
            }
            //dd($appliedDays,$appliedPastDays,$isHalfDay,!$this->isHoliday($holidays, $index),!$this->isRestDay($restdays, $index)
            //,$add_allow);
            if (!$this->isHoliday($holidays, $index) && !$this->isRestDay($restdays, $index) && $add_allow) {
                $one_leave_added = true;
                $leaveId = $this->addLeave(
                    $username,
                    $approverId,
                    $type,
                    $isHalfDay,
                    $startTime,
                    $endTime,
                    $index,
                    $index,
                    $noDays,
                    $reason,
                    $half_day_type,
                    "Compulsory",
                    $hourly
                );
                $this->addLeaveDays($leaveId, $username, $index, $status);
            }
        }

        if ($one_leave_added) {

            $email_send_allow = true;

            $getEmailSendByPrefernces1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->where('company_id', $user->company_id)->first();
            $getEmailSendByPrefernces = $getEmailSendByPrefernces1->value ?? 0;
            if ($getEmailSendByPrefernces) {
                if (!hasContentPreference($username)) {
                    $email_send_allow = true;
                } else {
                    $email_send_allow = false;
                }
            }

            if ($email_send_allow) {
                // // Send email
                $uname = UserPersonal::where('username', $username)->first();
                $name = $uname->name;
                $subject = "Leave approved: Compulsory Leave";

                $body = "Dear $name,<br><br>";
                $body .= "Compulsory leave has been approved<br><br>";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: " . date('d-m-Y', strtotime($startDate)) . "<br>";
                $body .= "To: " . date('d-m-Y', strtotime($endDate)) . "<br><br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Kind regards,";
                $body .= "Note, this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username', $username)->first();
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                sendemail($semail->email_id, $subject, $body);

                $message = "Dear $name,  ";
                $message .= "Your leave has been approved, ";
                $message .= "Details of the leave are as follows: ";
                $message .= "From: $startDate  ";
                $message .= "To: $endDate  ";
                $message .= "Reason: $reason";

                sendSMSToUserFromServer($username, $message);
            }

            if ($type == 'Annual' || $type == 'Medical' || $type == 'Other_pay') {
                $this->addLeaveEntitleHistory($username, $year, $type);
            }
            return array("result" => TRUE);
        } else {
            return array("result" => FALSE);
        }
    }


    public function getcompulsoryleave_data($id)
    {
        $result = DB::table('leave_days')->leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_list.id', $id)->selectRaw("leave_list.*,leave_days.id as lid, CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as hours")->first();
        return $result;
    }

    public function editCompulsoryLeave(Request $request)
    { {
            $leaveId = $request->leave_id;
            $id = $request->id;
            $username = $request->employee_id;
            $type = $request->type;
            $isHalfDay = $request->is_half_day ?? '';
            $startTime = ($request->start_time != "") ? $request->start_time : "";
            $endTime = ($request->end_time != "") ? $request->end_time : "";
            $startDate = $request->start_date;
            $endDate = $request->end_date;
            $year = '';
            $hourly = $request->hourly ?? '';
            $hours = $request->leave_hours ?? '';

            $noDays = $request->no_days ?? '';
            $reason = $request->reason;
            $status = $request->status;
            $isPast = $request->isPast;

            if ($isHalfDay == "") {
                if ($noDays == "0.5") {
                    $isHalfDay = "1";
                } else {
                    $isHalfDay = "0";
                }
            }

            $startDate_arr = explode("-", $startDate);

            if (count($startDate_arr) > 2) {
                $startDate = $startDate_arr[0] . "-" . $startDate_arr[1] . "-" . $startDate_arr[2];
                $year = $startDate_arr[0];
            }
            $endDate_arr = explode("-", $endDate);
            if (count($endDate_arr) > 2) {
                $endDate = $endDate_arr[0] . "-" . $endDate_arr[1] . "-" . $endDate_arr[2];
            }

            $currentLeaveDetail = $this->getLeaveDetails($id);

            if ($currentLeaveDetail[0]->type == "Other_pay" && $type != "Other_pay") {

                if ($noDays == "0.5") {
                    $this->unMarkReplacementLeaveAsTaken($username, $year);
                } else {
                    $this->unMarkReplacementLeaveAsTaken($username, $year);
                    $this->unMarkReplacementLeaveAsTaken($username, $year);
                }
            }

            /* if leave RL Type than changing Stats as 0 as well in leave_adjustment table END */

            if ($currentLeaveDetail[0]->type != "Other_pay" && $type == "Other_pay") {
                if ($noDays == "0.5") {
                    $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                } else {
                    $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                    $this->markReplacementLeaveAsTaken($username, $year, $startDate);
                }
            }

            $result = $this->updateLeave112(
                $leaveId,
                $username,
                $type,
                $isHalfDay,
                $startTime,
                $endTime,
                $startDate,
                $endDate,
                $noDays,
                $reason,
                $isPast,
                $id,
                $hourly,
                $hours
            );

            $leave_detail = $this->getLeaveDetails($id);

            $id = (isset($request->id) ? $request->id : "");
            $this->setStatus($id, $status);


            if ($leave_detail[0]->leave_category != "Compulsory") {
                if ($type != 'Emergency') {
                    $this->changeCategory($leave_detail[0]->leave_id, "Normal");
                } else if ($type == 'Emergency') {
                    $this->changeCategory($leave_detail[0]->leave_id, "Emergency");
                }
            }

            if ($leave_detail[0]->type != "Emergency" && $leave_detail[0]->leave_category == "Emergency") {
                $this->changeCategory($leave_detail[0]->leave_id, "Normal");
            }
            if ($type == 'Annual' || $type == 'Medical' || $type == 'Other_pay') {
                $this->addLeaveEntitleHistory($username, $year, $type);
            }
            return array("result" => $result);
        }
    }

    public function deleteCompulsoryLeave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('leave_list')->where('id', $request->id)->delete();
        DB::table('leave_days')->where('leave_id', $request->id)->delete();
    }

    public function addLeaveDays($leaveId, $username, $date, $status = "0")
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('leave_days')->insert(array('leave_id' => $leaveId, 'username' => $username, 'date' => $date, 'status' => $status, 'company_id' => $user->company_id));
        return true;
    }

    public function addLeave($username, $approverId, $type, $isHalfDay, $startTime, $endTime, $startDate, $endDate, $noDays, $reason, $half_day_type, $leaveCategory = "Normal", $filename = '', $Relieve = '', $hourly = '')
    {
        if ($isHalfDay == 2) {
            $hourly = 1;
        }
        DB::table('leave_list')->insert(array('username' => $username, 'approver_id' => $approverId, 'is_hourly' => $hourly, 'type' => $type, 'is_half_day' => $isHalfDay, 'start_time' => $startTime, 'end_time' => $endTime, 'start_date' => $startDate, 'end_date' => $endDate, 'no_days' => $noDays, 'reason' => $reason, 'half_day_type' => $half_day_type, 'leave_category' => $leaveCategory, 'filename' => $filename, 'relieve' => $Relieve));
        $query = DB::table('leave_list')->selectRaw("max(id) as id")->first();
        //dd($query);
        return $query->id;
    }

    public function checkLeave(
        $username,
        $approverId,
        $type,
        $isHalfDay,
        $half_day_type = null,
        $startTime,
        $endTime,
        $startDate,
        $endDate,
        $noDays,
        $reason,
        $leaveCategory = "Normal"
    ) {
        $query = "select count(*) as ttl from leave_list a where a.username='" . $username . "' and (('" . $startDate . "' between a.start_date and a.end_date)";

        $query .= "and  ('" . $endDate . "' between a.start_date and a.end_date) or (a.start_date= '" . $startDate . "' or a.start_date='" . $endDate . "') or (a.end_date= '" . $startDate . "' or a.end_date='" . $endDate . "'))";

        if ($isHalfDay == 1 && $half_day_type != null) {
            $query .= "and a.half_day_type='" . $half_day_type . "'";
        }

        $result = DB::select($query);
        if ($result[0]->ttl > 0) {
            return false;
        }

        return true;
    }

    public function leaveControl()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('hr.setup.leave_control', compact('userPay'));
    }

    public function setEscalateDuration(Request $request)
    {
        $escalteDuration = $request->escalate_duration;
        $user = User::where('id', Auth::id())->first();
        DB::table('settings')->where('field', 'escalate_duration')->where('company_id', $user->company_id)->update(array('value' => $escalteDuration));
        return true;
    }

    public function getEscalateDuration()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'escalate_duration')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("emergency_leave" => intval($val));
    }

    public function setmaxpastleave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $max_past_leave = $request->max_past_leave;
        //$result = DB::table('settings')->where('field', 'max_past_leave')->where('company_id',$user->company_id)->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('max_past_leave')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            // DB::table('settings')->where('field', 'max_past_leave')->where('company_id',$user->company_id)->update(array('value' => $max_past_leave)); 
            DB::table('max_past_leave')->where('id', $result->id)->update(array('value' => $max_past_leave));
        } else {
            DB::table('max_past_leave')->insert(array('value' => $max_past_leave, 'category_name' => $usercat->category, 'company_id' => $user->company_id));
            //DB::table('settings')->insert(array('field'=>'max_past_leave', 'value' => $max_past_leave, 'company_id'=>$user->company_id));
        }
        return true;
    }

    public function getmaxpastleave()
    {
        $user = User::where('id', Auth::id())->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('max_past_leave')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        //$result = DB::table('settings')->where('field', 'max_past_leave')->where('company_id',$user->company_id)->first() ;
        if (!empty($result)) {
            $val = $result->value;
        } else {
            $val = 0;
        }
        return array("max_past_leave" => intval($val));
    }

    public function setLeaveAdjustmentType(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $adjustmentType = $request->leave_adjustment_type;
        DB::table('settings')->where('field', 'leave_adjustment_type')->where('company_id', $user->company_id)->update(array('value' => $adjustmentType));
        return true;
    }

    public function getLeaveAdjustmentType()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'leave_adjustment_type')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value;
        } else {
            $val = 0;
        }
        return array("adjustment_type" => intval($val));
    }

    public function setLeaveMultipleApprover(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $leaveMultipleApprover = $request->leave_multiple_approver;
        DB::table('settings')->where('field', 'leave_multiple_approver')->where('company_id', $user->company_id)->update(array('value' => $leaveMultipleApprover));
        return true;
    }

    public function getLeaveMultiple_Approver()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'leave_multiple_approver')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("leave_multiple_approver" => intval($val));
    }

    public function setActiveUserShown(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $active_user_shown = $request->active_user_shown;
        DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->update(array('value' => $active_user_shown));
        return true;
    }

    public function getActiveUserShown()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("active_user_shown" => intval($val));
    }

    public function setConfirmDisplay(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $confirm_display = $request->confirm_display;
        DB::table('settings')->where('field', 'confirm_display')->where('company_id', $user->company_id)->update(array('value' => $confirm_display));
        return true;
    }

    public function getConfirmDisplay()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'confirm_display')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("confirm_display" => intval($val));
    }

    public function setClaimable_al_el(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $claimable_al_el = $request->claimable_al_el;
        $result = DB::table('settings')->where('field', 'claimable_al_el')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'claimable_al_el')->where('company_id', $user->company_id)->update(array('value' => $claimable_al_el));
        } else {
            DB::table('settings')->insert(array('field' => 'claimable_al_el', 'value' => $claimable_al_el));
        }

        return true;
    }

    public function getClaimable_al_el()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'claimable_al_el')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("claimable_al_el" => intval($val));
    }

    public function setCurrentYearLeaveDisplay(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getCurrentYearLeaveDisplay()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setSingleEmailSetting(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'email_by_cronjob')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getSingleEmailSetting()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'email_by_cronjob')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setNPL_TO_HR(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'npl_to_hr')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getNPL_TO_HR()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'npl_to_hr')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setApply_rl_to_hr(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'apply_rl_to_hr')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getApply_rl_to_hr()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'apply_rl_to_hr')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setCancel_leave_to_hr(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'cancel_leave_to_hr')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getCancel_leave_to_hr()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'cancel_leave_to_hr')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setIsMedicalLeavProrated(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'medical_leave_prorated')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getIsMedicalLeavProrated()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'medical_leave_prorated')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setIsMedicalClaimableProrated(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        $result = DB::table('settings')->where('field', 'medical_claimable_prorated')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'medical_claimable_prorated')->where('company_id', $user->company_id)->update(array('value' => $value));
        } else {
            DB::table('settings')->insert(array('field' => 'medical_claimable_prorated', 'value' => $value, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function getIsMedicalClaimableProrated()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'medical_claimable_prorated')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setIsMedicalLeaveBFAllow(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'medical_leave_bf_allow')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getIsMedicalLeaveBFAllow()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'medical_leave_bf_allow')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setIsRelieveAllow(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getIsRelieveAllow()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setWorkForEarn(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        $result = DB::table('settings')->where('field', 'WorkForEarn')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'WorkForEarn')->where('company_id', $user->company_id)->update(array('value' => $value));
        } else {
            DB::table('settings')->insert(array('field' => 'WorkForEarn', 'value' => $value, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function getWorkForEarn()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'WorkForEarn')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setpastLeaveCancel(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'pastLeaveCancel')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function getpastLeaveCancel()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'pastLeaveCancel')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function getApproveLeavePage()
    {
        $user = User::where('id', Auth::id())->first();
        $ApproverName1 = DB::table('settings')->where('field', 'approveleave_display_approver_name')->where('company_id', $user->company_id)->first();
        $val = 0;
        if (!empty($ApproverName1)) {
            $val = $ApproverName1->value ?? 0;
        }
        $ApproverName = intval($val);
        $Branch1 = DB::table('settings')->where('field', 'approveleave_display_branch')->where('company_id', $user->company_id)->first();
        $val1 = 0;
        if (!empty($Branch1)) {
            $val1 = $Branch1->value ?? 0;
        }
        $Branch = intval($val1);
        $Category1 = DB::table('settings')->where('field', 'approveleave_display_category')->where('company_id', $user->company_id)->first();
        $val2 = 0;
        if (!empty($Category1)) {
            $val2 = $Category1->value ?? 0;
        }
        $Category = intval($val2);
        $Department1 = DB::table('settings')->where('field', 'approveleave_display_department')->where('company_id', $user->company_id)->first();
        $val3 = 0;
        if (!empty($Department1)) {
            $val3 = $Department1->value ?? 0;
        }
        $Department = intval($val3);

        return array("approveleave_display_approver_name" => $ApproverName, "approveleave_display_branch" => $Branch, "approveleave_display_category" => $Category, "approveleave_display_department" => $Department);
    }

    public function setHourlyLeave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        $check = DB::table('settings')->where('field', 'hourlyLeave')->where('company_id', $user->company_id)->count();
        if (!empty($check)) {
            DB::table('settings')->where('field', 'hourlyLeave')->where('company_id', $user->company_id)->update(array('value' => $value));
        } else {
            DB::table('settings')->insert(array('field' => 'hourlyLeave', 'value' => $value));
        }
        return true;
    }
    public function getHourlyLeave()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'hourlyLeave')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function sethalfdayleave(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $value = $request->value;
        DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->update(array('value' => $value));
        return true;
    }

    public function gethalfdayleave()
    {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function setBFAdj(Request $request)
    {

        $username = $request->username;
        $year = $request->year;
        $type = $request->type;
        $bfAdj = $request->bf_adj;
        $granted = $request->granted;
        $reason = $request->reason;
        $user = User::where('id', Auth::id())->first();

        if ($username != '' && $year != '' && $type != '' && $bfAdj != '') {

            if ($type == "adj") {
                $count = $bfAdj / 0.5;
                //$count = $bfAdj;
                if ($count < 0) {
                    $leave_one = '-0.5';
                } else {
                    $leave_one = '0.5';
                }
                $date = ($year) . "-01-01";

                if (isset($request->granted) && $request->granted != '') {
                    $granted = $request->granted;
                } else {
                    $granted = 0;
                }
                // dd($date);
                $flag = DB::table('leave_adjustment')->where('employee_id', $username)->where('start_date', $date)->where('end_date', $date)->where('company_id', $user->company_id)->first();
                //dd($flag);
                $values = array('employee_id' => $username, 'start_date' => $date, 'end_date' => $date, 'no_days' => 0, 'no_granted' => $bfAdj, 'granted' => $granted, 'company_id' => $user->company_id, 'reason' => $reason);
                //dd($flag);
                if (!empty($flag)) {
                    DB::table('leave_adjustment')->where('employee_id', $username)->where('start_date', $date)->where('end_date', $date)->where('company_id', $user->company_id)->update($values);
                } else {
                    DB::table('leave_adjustment')->insert($values);
                }
                $result = true;
            } else {
                $result = $this->addingBFAdj($username, $year, $type, $bfAdj);
            }
        } else {
            $result = false;
        }
        return array("result" => $result);
    }

    public function addingBFAdj($username, $year, $type, $bfAdj)
    {
        $user = User::where('id', Auth::id())->first();
        $flag = DB::table('leave_bf_adj')->where('username', $username)->where('year', $year)->where('leave_type', $type)->where('company_id', $user->company_id)->first();
        if (!empty($flag)) {
            DB::table('leave_bf_adj')->where('username', $username)->where('year', $year)->where('leave_type', $type)->where('company_id', $user->company_id)->update(array('bf_adj' => $bfAdj));
        } else {
            DB::table('leave_bf_adj')->insert(array('username' => $username, 'bf_adj' => $bfAdj, 'year' => $year, 'leave_type' => $type, 'company_id' => $user->company_id));
        }
        return true;
    }


    public function getClaimablePreSet()
    {
        $user = User::where('id', Auth::id())->first();

        // $result = DB::table('settings')->where('field', 'claimable_pre_set')->where('company_id',$user->company_id)->first();

        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();

        return array("pre_set" => intval($result->value));
    }


    public function setClaimablePreSet(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $preSet = $request->pre_set;
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        //$result = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
        DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->update(array('value' => $preSet));
        return true;
    }

    public function getEmergencyLeaveSettings()
    {
        $user = User::where('id', Auth::id())->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        // $result = DB::table('settings')->where('field', 'emergency_leave')->where('company_id',$user->company_id)->first() ;
        return array("emergency_leave" => intval($result->value));
    }

    public function setEmergencyLeaveSettings(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $emergencyLeave = $request->emergency_leave;
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        //$preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
        DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->update(array('value' => $emergencyLeave));
        return true;
    }

    public function getReplacementDuration()
    {
        $user = User::where('id', Auth::id())->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('replacement_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        //$result = DB::table('settings')->where('field', 'replacement_duration')->where('company_id',$user->company_id)->first() ;
        return array("replacement_duration" => intval($result->value));
    }

    public function setReplacementDuration(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $replacementDuration = $request->replacement_duration;
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        DB::table('replacement_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->update(array('value' => $replacementDuration));
        //DB::table('settings')->where('field', 'replacement_duration')->where('company_id',$user->company_id)->update(array('value' => $replacementDuration)); 
        return true;
    }

    public function getBFDuration()
    {
        $user = User::where('id', Auth::id())->first();
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        //$result = DB::table('settings')->where('field', 'bf_duration')->where('company_id',$user->company_id)->first() ;
        return array("bf_duration" => intval($result->value));
    }

    public function setBFDuration(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $bfAdjDuration = $request->bf_duration;
        $days = date("z", mktime(0, 0, 0, 12, 31, date('Y'))) + 1;
        if ($bfAdjDuration > $days) {
            return false;
        }
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->update(array('value' => $bfAdjDuration));
        //DB::table('settings')->where('field', 'bf_duration')->where('company_id',$user->company_id)->update(array('value' => $bfAdjDuration)); 
        return true;
    }

    public function getBFAdjDuration()
    {
        $user = User::where('id', Auth::id())->first();

        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        $result = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();

        // $result = DB::table('settings')->where('field', 'bf_adj_duration')->where('company_id',$user->company_id)->first() ;
        return array("bf_adj_duration" => intval($result->value));
    }

    public function setBFAdjDuration(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $bfAdjDuration = $request->bf_adj_duration;
        $days = date("z", mktime(0, 0, 0, 12, 31, date('Y'))) + 1;
        if ($bfAdjDuration > $days) {
            return false;
        }
        $usercat = DB::table('user_category')->where('username', $user->username)->first();
        DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->update(array('value' => $bfAdjDuration));
        //DB::table('settings')->where('field', 'bf_adj_duration')->where('company_id',$user->company_id)->update(array('value' => $bfAdjDuration)); 
        return true;
    }

    public function updateBroughtForwardCategory(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $category = $request->category;
        $percentage = $request->percentage;
        $type = $request->type;
        if ($type == '') {
            $type = 'days';
        }
        $bfcat = DB::table('leave_brought_forward_category')->where('category_name', $category)->where('company_id', $user->company_id)->first();
        if (!empty($bfcat)) {
            if ($category != '' && $percentage != '' && $type != '') {
                DB::table('leave_brought_forward_category')->where('category_name', $category)->where('company_id', $user->company_id)->update(array('percentage' => $percentage, 'type' => $type));
                return true;
            }
        } else {
            if ($category != '' && $percentage != '' && $type != '') {
                DB::table('leave_brought_forward_category')->insert(array('category_name' => $category, 'company_id' => $user->company_id, 'percentage' => $percentage, 'type' => $type));
                return true;
            }
        }

        return false;
    }

    public function approveleaveDisplayUpdate(Request $request)
    {
        $approveleave_display_approver_name = $request->approveleave_display_approver_name;
        if ($approveleave_display_approver_name == "") {
            $approveleave_display_approver_name = 0;
        } else if ($approveleave_display_approver_name == "on") {
            $approveleave_display_approver_name = 1;
        }
        $this->setApproveleaveApproverName($approveleave_display_approver_name);


        $approveleave_display_branch = $request->approveleave_display_branch;
        if ($approveleave_display_branch == "") {
            $approveleave_display_branch = 0;
        } else if ($approveleave_display_branch == "on") {
            $approveleave_display_branch = 1;
        }
        $this->setApproveleaveBranch($approveleave_display_branch);

        $approveleave_display_category = $request->approveleave_display_category;
        if ($approveleave_display_category == "") {
            $approveleave_display_category = 0;
        } else if ($approveleave_display_category == "on") {
            $approveleave_display_category = 1;
        }
        $this->setApproveleaveCategory($approveleave_display_category);

        $approveleave_display_department = $request->approveleave_display_department;
        if ($approveleave_display_department == "") {
            $approveleave_display_department = 0;
        } else if ($approveleave_display_department == "on") {
            $approveleave_display_department = 1;
        }
        $this->setApproveleaveDepartment($approveleave_display_department);

        return true;
    }

    public function setApproveleaveApproverName($status)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('settings')->where('field', 'approveleave_display_approver_name')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'approveleave_display_approver_name')->where('company_id', $user->company_id)->update(array('value' => $status));
        } else {
            DB::table('settings')->insert(array('field' => 'approveleave_display_approver_name', 'value' => $status, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function setApproveleaveBranch($status)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('settings')->where('field', 'approveleave_display_branch')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'approveleave_display_branch')->where('company_id', $user->company_id)->update(array('value' => $status));
        } else {
            DB::table('settings')->insert(array('field' => 'approveleave_display_branch', 'value' => $status, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function setApproveleaveCategory($status)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('settings')->where('field', 'approveleave_display_category')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'approveleave_display_category')->where('company_id', $user->company_id)->update(array('value' => $status));
        } else {
            DB::table('settings')->insert(array('field' => 'approveleave_display_category', 'value' => $status, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function setApproveleaveDepartment($status)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('settings')->where('field', 'approveleave_display_department')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            DB::table('settings')->where('field', 'approveleave_display_department')->where('company_id', $user->company_id)->update(array('value' => $status));
        } else {
            DB::table('settings')->insert(array('field' => 'approveleave_display_department', 'value' => $status, 'company_id' => $user->company_id));
        }
        return true;
    }

    public function leaveNameUpdate(Request $request)
    {
        $array = $request->all();
        $user = User::where('id', Auth::id())->first();

        $today_color = DB::table('calendar_color')->where('name', 'today')->where('company_id', $user->company_id)->get();
        if (count($today_color) > 0) {
            DB::table('calendar_color')->where('name', 'today')->where('company_id', $user->company_id)->update(array('color' => $request->today_color));
        } else {
            if ($request->today_color != '') {
                DB::table('calendar_color')->where('name', 'today')->where('company_id', $user->company_id)->insert(array('name' => 'today', 'color' => $request->today_color, 'company_id' => $user->company_id));
            }
        }
        //update calendar color
        unset($array['_token']);
        foreach ($array as $key => $value) {
            if ($key != "action" && $key != "today_color") {
                $color        =    $request->{"leave_" . $key . "_color"};
                $upload        =    0;
                if (isset($request->{"leave_" . $key . "_upload"})) {
                    $upload        =    1;
                }
                $compulsory    =    0;
                if (isset($request->{"leave_" . $key . "_compulsory"})) {
                    $compulsory        =    1;
                }
                $show        =    0;
                if (isset($request->{"leave_" . $key . "_show"})) {
                    $show        =    1;
                }
                $hourly = 0;
                if (isset($request->{"leave_" . $key . "_hourly"})) {
                    $hourly        =    1;
                }
                // dd("leave_'$key'_color");
                $result = DB::table('leave_name')->where('type', $key)->where('company_id', $user->company_id)->update(array('name' => $value, 'leave_color' => $color, 'upload' => $upload, 'compulsory' => $compulsory, 'is_show' => $show, 'hourly_allow' => $hourly));
            }
        }
        return TRUE;
    }

    public function getNames()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('category_name')->where('is_deleted', 0)->where('company_id', $user->company_id)->get();
        return $result;
    }

    public function getBroughtForwardList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('leave_brought_forward_category')->leftjoin('category_name', 'category_name.id', '=', 'leave_brought_forward_category.category_name')->where('category_name.is_deleted', 0)->where('leave_brought_forward_category.company_id', $user->company_id)->selectRaw("leave_brought_forward_category.category_name, leave_brought_forward_category.percentage,leave_brought_forward_category.type")->get();
        return $result;
    }

    public function getLeaveName()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('leave_name')->where('company_id', $user->company_id)->get();
        return $result;
    }

    public function getcalendarcolor()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('calendar_color')->where('company_id', $user->company_id)->get();
        return $result;
    }

    public function restday()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        return view('hr.setup.rest-day', compact('departments', 'branches', 'categories', 'deleteBtnShowSetting', 'leaveTypes', 'userPay'));
    }

    public function aprrestday()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        $categories  = Category::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $departments  = Department::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $branches  = Branch::orderBy('name', 'asc')->where('company_id', $user->company_id)->get();
        $leaveTypes  = Leavetype::where('company_id', $user->company_id)->where('is_show', 1)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->where('company_id', $user->company_id)->first();
        return view('approvals.apr-restday', compact('departments', 'branches', 'categories', 'deleteBtnShowSetting', 'leaveTypes', 'userPay'));
    }

    public function addRestDay(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $isEmployee = $request->is_employee;
        $employeeId = (isset($request->employee_id) && $request->employee_id != 0) ? $request->employee_id : $user->username;
        $categoryId = $request->category_id;
        $description = $request->description;
        $dates = explode(",", $request->dates);
        //dd($dates);
        $restDayId = $this->addRestDay11($isEmployee, $employeeId, $categoryId, $description);
        //dd($restDayId);
        for ($i = 0; $i < count($dates); $i++) {
            $this->addRestDate($restDayId, date('Y-m-d', strtotime($dates[$i])));
        }
        return array("result" => TRUE);
    }

    public function editMapCategoryEmployee(Request $request)
    {

        $categoryId = $request->category_id;
        $employeeIds = explode(",", $request->employee_ids);
        $this->removeMapping11($categoryId);

        for ($i = 0; $i < count($employeeIds); $i++) {
            $this->mapCategoryEmployee11($categoryId, $employeeIds[$i]);
        }
        return array("result" => TRUE);
    }

    public function removeMapping11($categoryId)
    {
        DB::table('rest_day_category_employee')->where('category_id', $categoryId)->delete();
        return true;
    }

    public function removeMapping(Request $request)
    {
        $categoryId = $request->category_id;
        $result = $this->removeMapping11($categoryId);
        return array("result" => $result);
    }

    public function getRestDayUserList()
    {
        $result = DB::table('rest_days as rd')->leftjoin('users as u', 'u.username', '=', 'rd.employee_id')->leftjoin('user_personal as b', 'u.username', '=', 'b.username')->where('rd.is_employee', 1)->where('b.isDeleted', 0)->selectRaw("distinct u.username as `username`, b.name as `name`")->get();
        return $result;
    }

    public function getCategoryMapping()
    {

        $categories = $this->getRestDayCategoriesdatatable();
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        for ($i = 0; $i < count($categories); $i++) {
            $categoryId = $categories[$i]->id;
            $query = DB::table('rest_day_category_employee as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->leftjoin('user_pay as up', 'b.username', '=', 'up.username')->where('a.category_id', $categoryId)->where('b.isDeleted', 0);
            if ($ActiveUserShownStatus == '1') {
                $query->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
            } else {
                $query->where('up.pay_status', 1);
            }
            $employees = $query->selectRaw("a.employee_id, UPPER(b.name) as name, b.employee_no")->get();
            $categories[$i]->employees = $employees;
            if (count($employees) > 0) {
                $categories[$i]->display_allow = true;
            } else {
                $categories[$i]->display_allow = false;
            }
        }


        if (isset($_GET['s_catname']) && $_GET['s_catname'] && $_GET['s_catname'] != '') {
            $empty_arr = [];
            $val = strtoupper($_GET['s_catname']);
            // $categories = collect($categories)->filter(function ($item) use ($val){
            //     dd($item->employees,$val);
            //     return false !== stripos($item->employees, $val);
            // });
            //dd($val);
            foreach ($categories as $category) {
                $employees = $category->employees;
                //dd()
                $filter = $employees->filter(function ($emp) use ($val) {
                    return false !== stripos($emp->name, $val);
                });
                if (count($filter) > 0) {
                    array_push($empty_arr, $category);
                }
                //         //dd($category->employees->where('name', $val));
                //  if(count($category->employees->where('name', $val))){
                //      //dd($empty_arr);
                //  array_push($empty_arr,$category);
                //  }
            }
            //dd($empty_arr);
            return $empty_arr;
        }


        return $categories;
    }

    function getcategorymapping_data($id)
    {
        $categories = $this->getRestDayCategories_data($id);
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        for ($i = 0; $i < count($categories); $i++) {
            $categoryId = $categories[$i]->id;
            $query = DB::table('rest_day_category_employee as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->leftjoin('user_pay as up', 'b.username', '=', 'up.username')->where('a.category_id', $categoryId)->where('b.isDeleted', 0);
            if ($ActiveUserShownStatus == '1') {
                $query->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
            } else {
                $query->where('up.pay_status', 1);
            }
            $employees = $query->selectRaw("a.employee_id, b.name, b.employee_no")->get();
            $categories[$i]->employees = $employees;
            if (count($employees) > 0) {
                $categories[$i]->display_allow = true;
            } else {
                $categories[$i]->display_allow = false;
            }
        }
        $categories['employee'] = $this->getGroupedUsers(request());
        return $categories;
    }

    public function getRestDayCategories_data($id)
    {
        $user = User::where('id', Auth::id())->first();
        $query = "select id, category from rest_day_category where id='" . $id . "' and company_id='" . $user->company_id . "'";
        $result = DB::select($query);

        for ($i = 0; $i < count($result); $i++) {
            $builder = DB::table('rest_day_category_employee')->where('category_id', $result[$i]->id)->selectRaw("id")->first();

            if (!empty($builder)) {
                $result[$i]->delete_allow = false;
            } else {
                $result[$i]->delete_allow = true;
            }
        }
        return $result;
    }

    public function sendEditMessage()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('hr.setup.send_edit_message', compact('userPay'));
    }

    public function sendMessage(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $sender = (isset($request->sender) ? $request->sender : $user->username);
        $is_email = ((isset($request->is_email) && $request->is_email == "on") ? true : false);
        $recipients = $request->recipients;
        $message = $request->message;
        $expiryDate = date('Y-m-d', strtotime($request->expiry_date));
        $recipientsArray = explode(",", $recipients);

        $result = $this->addSenderMessage($sender, $recipients, $message, $expiryDate);


        for ($i = 0; $i < count($recipientsArray); $i++) {

            $entitle = $this->getYearlyEntitleMain($recipientsArray[$i], date('Y'), false, '', '');

            $bf_value = $entitle['brought_forward']['annual'];
            $bf_taken_value = $entitle['brought_forward']['annual_taken'];

            $bfadj_value = $entitle['brought_forward']['annual_adj'];
            $bfadj_taken_value = $entitle['brought_forward']['bfAdjLeaveTaken'];

            $adj_value = $entitle['adjust_leaves'];
            $adj_taken_value = $entitle['annual']['rlLeaveTaken'];

            $forfeit_bf = 0;
            $forfeit_bfadj = 0;
            $forfeit_adj = 0;

            if ($entitle['bf_forfeit'] == 1) {
                $forfeit_bf = $bf_value - $bf_taken_value;
            }
            if ($entitle['bfadj_forfeit'] == 1) {
                $forfeit_bfadj = $bfadj_value - $bfadj_taken_value;
            }
            if ($entitle['adj_forfeit'] == 1) {
                $forfeit_adj = $adj_value - $adj_taken_value;
            }


            $info = $this->getUserPersonalDetails($recipientsArray[$i]);
            // dd($info);
            $send_msg = "";
            $send_msg =  str_replace("%u%", $info[0]->username, $message);
            $send_msg =  str_replace("%n%", $info[0]->name, $send_msg);
            $send_msg =  str_replace("%bf%", $bf_value, $send_msg);
            $send_msg =  str_replace("%bfadj%", $bfadj_value, $send_msg);
            $send_msg =  str_replace("%adj%", $adj_value, $send_msg);

            $send_msg =  str_replace("%bf_f%", $forfeit_bf, $send_msg);
            $send_msg =  str_replace("%bfadj_f%", $forfeit_bfadj, $send_msg);
            $send_msg =  str_replace("%adj_f%", $forfeit_adj, $send_msg);

            $send_msg =  str_replace("%bf_b%", ($bf_value - $forfeit_bf), $send_msg);
            $send_msg =  str_replace("%bfadj_b%", ($bfadj_value - $forfeit_bfadj), $send_msg);
            $send_msg =  str_replace("%adj_b%", ($adj_value - $forfeit_adj), $send_msg);

            $send_msg =  str_replace("%bal%", $entitle['balance'], $send_msg);

            if ($is_email) {
                $subject = "Message For You!";
                //Email::sendEmailToUserFromServer($info['username'], $subject, $message);
                $msg_4_send = nl2br($send_msg);
                //Email::sendEmail($info[0]->email_id, $subject, $msg_4_send);
                //Mail::to($info['email_id'])->send(new MyDemoMail($msg_4_send,$subject));
                //dd($info);
                sendemail($info[0]->email_id, $subject, $msg_4_send);
            }

            $this->sendMessage11($sender, $recipientsArray[$i], $send_msg, $expiryDate);
        }
        return array("result" => $result);
    }


    //     public function getYearlyEntitleMain($username = '', $year = '' , $in_json = true, $date = '', $updt = '')
    // 	{
    // 	    $date_for_query = "CURDATE()";
    // 		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
    //         $cutOffMonth = $cutOffMonth11->value;
    //         $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
    //         $cutOffDate=$cutOffDate11->value;
    //         $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
    //         $cutOffStartDate=$cutOffStartDate11->value;
    //         $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    // 		$cutOffStartMonth=$cutOffStartMonth11->value;
    // 		$userPay = DB::table('user_pay')->where('username' , $username)->first();

    // 		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
    //         $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
    // 		if ($SettingLeaveAdjustmentType == 8) {
    // 			$joiningDate = $userPay->date_commence;
    // 			$joiningDateArr = explode('-', $joiningDate);
    // 			$joining_month = $joiningDateArr[1];
    // 			$joining_date = $joiningDateArr[2];
    // 			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
    // 			if (($request->pdf)) {
    // 			} else {
    // 				if (date('Y-m-d') < $curr_date) {
    // 					$year = $year - 1;
    // 				}
    // 			}
    // 		}

    // 		$SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
    // 		$SoftwareStartDate = $SoftwareStartDate11->value;

    // 		$companyName11 = DB::table('settings')->where('field', "company")->first();
    // 		$companyName='';
    // 		if($companyName11!='')
    // 		$companyName = $companyName11->value;

    // 		$isShowClaimable = getConfirmDisplay($username);

    // 		$date_commence = $userPay->date_commence;
    // 		$joiningDate = strtotime($date_commence);

    // 		$cutOffStartYear = $year;
    // 		$cutOffYear = $year;
    // 		if($cutOffStartMonth!=1){
    // 			if($cutOffStartMonth > date('m')){
    // 				$cutOffStartYear = $year;
    // 				$cutOffYear = $year;
    // 			}else{
    // 				$cutOffStartYear = $year-1;
    // 				$cutOffYear = $year;
    // 			}
    // 		}else{
    // 			$cutOffStartYear = $year;
    // 			$cutOffYear = $year;
    // 		}

    // 		$RL_forfeit = getForfeitAdjLeaveCount($username, $year);

    // 		$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
    // 		$medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);

    // 		$medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
    // 		$medical_pro_rated = $medical_pro_rated11->value;
    // 		$joiningDate = $userPay->date_commence;
    // 		$joiningDateArr = explode('-', $joiningDate);
    // 		if ($medical_pro_rated == 1) {


    // 			$joining_year = $joiningDateArr[0];
    // 			$joining_month = $joiningDateArr[1];
    // 			$joining_date = $joiningDateArr[2];

    // 			$resultArrayVal = DB::table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as experience, date_commence")->first();

    // 			$ExperienceInYear = intval($resultArrayVal->experience) + 1;
    // 			$joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

    // 			//section one	
    // 			$prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
    // 			$start = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
    // 			$datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
    // 			$days1 = round($datediff / (60 * 60 * 24));

    // 			$date1 = new DateTime($joiningDate);
    // 			$date2 = new DateTime($prev_date_of_joining_date);
    // 			$diff = $date1->diff($date2);
    // 			$experiance1 = $diff->y;
    // 			if ($experiance1 == 0) {
    // 				$experiance1 = 1;
    // 			}


    // 			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 			$medicalEntitlenew1 = $builder1[0]->no_leaves;
    // 			$d1 = ($days1 / 365) * $medicalEntitlenew1;

    // 			$a1 = array(
    // 				'username' => $username,
    // 				'joining date' => $joiningDate,
    // 				'entitle' => $medicalEntitlenew1,
    // 				'start date' => $start,
    // 				'end date' => $prev_date_of_joining_date,
    // 				'days' => $days1,
    // 				'experiance' => $experiance1,
    // 			);
    // 			//section one

    // 			//section two
    // 			$end_date = $year . "-".$cutOffMonth."-".$cutOffDate;
    // 			$datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
    // 			$days2 = round($datediff2 / (60 * 60 * 24));

    // 			$date1 = new DateTime($joiningDate);
    // 			$date2 = new DateTime($end_date);
    // 			$diff = $date1->diff($date2);
    // 			$experiance2 = $diff->y;
    // 			if ($joiningdatecurrent <= date('Y-m-d')) {
    // 				$experiance2 = $experiance2 + 1;
    // 			}
    // 			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 			$medicalEntitlenew = $builder1[0]->no_leaves;
    // 			$d2 = ($days2 / 365) * $medicalEntitlenew;

    // 			$a2 = array(
    // 				'username' => $username,
    // 				'joining date' => $joiningDate,
    // 				'entitle' => $medicalEntitlenew,
    // 				'start date' => $end_date,
    // 				'end date' => $joiningdatecurrent,
    // 				'days2' => $days2,
    // 				'experiance' => $experiance2,
    // 			);

    // 			if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
    // 				if ($medicalEntitlenew1 != $medicalEntitlenew) {
    // 					$medicalEntitle = round($d1 + $d2);
    // 				} else {
    // 					if ($medicalEntitlenew1 != '') {
    // 						$medicalEntitle = $medicalEntitlenew1;
    // 					} else if ($medicalEntitlenew != '') {
    // 						$medicalEntitle = $medicalEntitlenew;
    // 					}
    // 				}
    // 			}
    // 		}

    // 		$resiged_date_str = $userPay->date_resigned;
    // 		$joiningDate = $userPay->date_commence;
    // 		$joiningDateArr = explode('-', $joiningDate);
    // 		$resignDateArr = explode('-', $resiged_date_str);
    // 		$resign_year = $resignDateArr[0];
    // 		$joining_year = $joiningDateArr[0];
    // 		if ($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
    // 			$joining_year = $joiningDateArr[0];
    // 			$joining_month = $joiningDateArr[1];
    // 			$joining_date = $joiningDateArr[2];
    // 			$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
    // 			$date1 = new DateTime($joiningDate);
    // 			$date2 = new DateTime($joiningdatecurrent);
    // 			$diff = $date1->diff($date2);
    // 			$experiance1 = $diff->y;
    // 			$experiance1 = $experiance1 + 1;



    // 			if ($joining_year < $year && $resign_year == $year) {
    // 				$joining_year = $joiningDateArr[0];
    // 				$joining_month = $joiningDateArr[1];
    // 				$joining_date = $joiningDateArr[2];
    // 				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
    // 				$date1 = new DateTime($joiningDate);
    // 				$date2 = new DateTime($joiningdatecurrent);
    // 				$diff = $date1->diff($date2);
    // 				$experiance_1 = $diff->y;
    // 				if ($experiance_1 == 0) {
    // 					$experiance_1 = 1;
    // 				}

    // 				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 				$annualEntitle_1 = $builder_1[0]->no_leaves;

    // 				$experiance_2 = $experiance_1 + 1;
    // 				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 				$pro = 0;
    // 				$annualEntitle_2 = $builder_2[0]->no_leaves;

    // 				if (($annualEntitle_1 != $annualEntitle_2)  && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
    // 					$pro = 1;
    // 					$datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
    // 					$days1 = round($datediff11 / (60 * 60 * 24));
    // 					$datediff22 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
    // 					$days2 = round($datediff22 / (60 * 60 * 24));
    // 					$first_dif = ($days1 / 365) * $annualEntitle_1;
    // 					$second_dif = ($days2 / 365) * $annualEntitle_2;
    // 					$annualEntitle = ($first_dif + $second_dif);

    // 				} else {
    // 					$datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
    // 				}
    // 				//echo $annualEntitle;exit;
    // 			} else if ($joining_year < $year && $resign_year > $year) {
    // 				$joining_year = $joiningDateArr[0];
    // 				$joining_month = $joiningDateArr[1];
    // 				$joining_date = $joiningDateArr[2];
    // 				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
    // 				$date1 = new DateTime($joiningDate);
    // 				$date2 = new DateTime($joiningdatecurrent);
    // 				$diff = $date1->diff($date2);
    // 				$experiance_1 = $diff->y;
    // 				if ($experiance_1 == 0) {
    // 					$experiance_1 = 1;
    // 				}

    // 				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 				$annualEntitle_1 = $builder_1[0]->no_leaves;

    // 				$experiance_2 = $experiance_1 + 1;
    // 				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 				$pro = 0;
    // 				$annualEntitle_2 = $builder_2[0]->no_leaves;
    // 				if ($annualEntitle_1 != $annualEntitle_2) {
    // 					$pro = 1;
    // 					$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-".$cutOffMonth."-".$cutOffDate);
    // 				}
    // 			} else if ($joining_year == $year && $resign_year == $year) {
    // 				$datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);
    // 			} else if ($joining_year == $year && $resign_year > $year) {
    // 				$datediff2 = strtotime($cutOffYear . "-".$cutOffMonth."-".$cutOffDate) - strtotime($joiningDate);
    // 			}


    // 			$days = round($datediff2 / (60 * 60 * 24));
    // 			$annualEntitle1 = $days / 365;
    // 			if ($joining_year < $year && $resign_year > $year) {
    // 				if ($pro == 0) {
    // 					$annualEntitle = $annualEntitle;
    // 				}
    // 			} else {
    // 				if ($pro == 0) {
    // 					$annualEntitle = $annualEntitle;
    // 				}
    // 			}
    // 		}


    // 		if ($SettingLeaveAdjustmentType == 8 || $SettingLeaveAdjustmentType == 1) {
    // 			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
    // 			$joiningDate = $userPay->date_commence;

    // 			$joiningDateArr = explode('-', $joiningDate);
    // 			$joining_month = $joiningDateArr[1];
    // 			$joining_date = $joiningDateArr[2];

    // 			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
    // 			$curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
    // 			$date1 = new DateTime($joiningDate);
    // 			$date2 = new DateTime($curr_date);
    // 			$diff = $date1->diff($date2);
    // 			$ExperienceInYear = $diff->y;
    // 			if ($diff->d > 0) {
    // 				$ExperienceInYear = $ExperienceInYear + 1;
    // 			}

    // 			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 			$annualEntitle = $builder2[0]->no_leaves;

    // 		} else if ($SettingLeaveAdjustmentType == 6  && $joining_year != Date('Y')) {
    // 			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
    // 			$joiningDate = $userPay->date_commence;
    // 			$joiningDateArr = explode('-', $joiningDate);
    // 			$joining_month = $joiningDateArr[1];
    // 			$joining_date = $joiningDateArr[2];

    // 			if($year!=""){

    // 				if($year == date('Y')){
    // 					$curr_date = date($year.'-m-d');
    // 				}else {
    // 					$curr_date = ($year) . "-".$cutOffMonth."-".$cutOffDate;
    // 				}

    // 			}else{
    // 				$curr_date = date('Y-m-d');
    // 			}


    // 			$date1 = new DateTime($joiningDate);
    // 			$date2 = new DateTime($curr_date);
    // 			$diff = $date1->diff($date2);
    // 			$ExperienceInYear = $diff->y;
    // 			$actual_ExperienceInYear = $ExperienceInYear;

    // 			if ($diff->d > 0 || $joiningDate == $curr_date) {
    // 				$ExperienceInYear = $ExperienceInYear + 1;
    // 			}
    // 			if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
    // 				$ExperienceInYear = 1;
    // 			}

    // 			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
    // 			if($actual_ExperienceInYear>0){
    // 				$annualEntitle = $builder2[0]->no_leaves;
    // 			}
    // 		}
    // 		$rlLeave = getReplacementLeaveCount($username, $year);
    // 		$annaualTaken = getTakenLeaveCount($username, $year, "Annual");
    // 		$medicalTaken = getTakenLeaveCount($username, $year, "Medical");
    // 		$pastLeaves = getTakenPastLeaves($username, $year);
    // 		$adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
    // 		if ($SoftwareStartDate <= ($year - 1)) {
    // 			$bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
    // 		} else {
    // 			$bfAnnual = 0;
    // 		}

    // 		$EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);
    // 		$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
    // 		$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
    // 		$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
    // 		$nplCount = getNPLCount($username, $year);

    // 		if($cutOffStartMonth!='1'){
    // 			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
    // 		}else{
    // 			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
    // 		}




    // 		if ($BFLeaveTaken > $bfAnnual) {
    // 			$BFLeaveTaken = $bfAnnual;
    // 		}


    // 		$tilldateDaysVal = tilldateDays($date_commence);
    // 		$tillYearEndDaysVal = tillYearEndDays($date_commence);
    // 		$YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);

    // 		$resiged_date_str = $userPay->date_resigned;
    // 		$resiged_date = strtotime($resiged_date_str);
    // 		$resiged_year = date('Y', $resiged_date);

    // 		if ($date != '') {
    // 			$leave_month = date("n", strtotime(str_replace('/', '-', $date)));
    // 			$leave_year = date("Y", strtotime(str_replace('/', '-', $date)));
    // 		} else {
    // 			$leave_month = date("n");
    // 			$leave_year = date("Y");
    // 		}

    // 		if ($SettingLeaveAdjustmentType == 8) {
    // 			$annual_ent = get_anniv_cutt_off_entitle($username, $year);
    // 			$cut_off_days = day_count_anniv_cutt_off($username, $year);
    // 			$earn = ($cut_off_days / 365) * $annual_ent;
    // 			$earn = roundaway($earn);
    // 		} else {
    // 			if ($year < $leave_year) {
    // 				$earn = roundaway($annualEntitle);
    // 			} else {
    // 				if($cutOffStartMonth!=1 && $cutOffMonth <= $leave_month && $year<=$leave_year){
    // 					$earn = roundaway($annualEntitle);
    // 				}else if ($year == $resiged_year) {
    // 					if ($leave_month < date('n', $resiged_date)) {
    // 						$earn = roundaway(($leave_month /  date('n', $resiged_date)) * roundaway($annualEntitle));
    // 					} else {
    // 						$earn = roundaway(roundaway($annualEntitle));
    // 					}
    // 				} else {
    // 					if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
    // 						$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
    // 					} else {
    // 						if ((date("n", strtotime($joiningDate)) == $leave_month) && date("Y", strtotime($joiningDate)) == $leave_year) {
    // 							$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
    // 						} else {
    // 							if($cutOffStartMonth>$leave_month){
    // 								if(date("Y", strtotime($joiningDate)) == $leave_year){
    // 									$month_cal = $leave_month - $joiningDateArr[1];
    // 								}else{
    // 									if($joining_year==($leave_year-1) && $cutOffStartMonth>$joiningDateArr[1]){
    // 										$month_cal_1 = 12 - $cutOffStartMonth;
    // 									}else if($joining_year==($leave_year-1)){
    // 										$month_cal_1 = 12 - $joiningDateArr[1];
    // 									}else{
    // 										$month_cal_1 = 12 - $cutOffStartMonth;
    // 									}
    // 									$month_cal = $month_cal_1 + $leave_month;
    // 								}
    // 								$month_cal = $month_cal +1;

    // 							}else{
    // 								$month_cal = $leave_month - $cutOffStartMonth;
    // 								$month_cal = $month_cal +1;
    // 							}
    // 							if (date("Y", strtotime($joiningDate)) == $leave_year) {
    // 								if ($companyName == "earn_prorated") {
    // 									$earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
    // 								} else {
    // 									$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
    // 								}


    // 								if ($month_cal == 12) {
    // 									$earn = roundaway($annualEntitle);
    // 								}
    // 							} else {

    // 								$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
    // 							}
    // 						}
    // 					}
    // 				}
    // 			}
    // 		}
    // 		$annualEntitle_arr = explode('.', number_format($annualEntitle, 2));
    // 		if (isset($annualEntitle_arr[1])) {

    // 			if ($annualEntitle_arr[1] > 1 && $annualEntitle_arr[1] <= 25) {
    // 				$annualEntitle = floor($annualEntitle);
    // 			} else if ($annualEntitle_arr[1] >= 26 && $annualEntitle_arr[1] <= 75) {
    // 				$annualEntitle = $annualEntitle;
    // 			} else if ($annualEntitle_arr[1] > 75) {
    // 				$annualEntitle = ceil($annualEntitle);
    // 			} else {
    // 				$annualEntitle = $annualEntitle;
    // 			}

    // 		} else {
    // 			$annualEntitle = $annualEntitle;
    // 		}


    // 		$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);
    // 		$bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

    // 		$yearlyEntitle = array(
    // 			"annual" => array(
    // 				"entitle" => getValue($annualEntitle),
    // 				"taken" => floatval($annaualTaken),
    // 				"rlLeave" => floatval($rlLeave),
    // 				"rlLeaveTaken" => $rlLeaveTaken,
    // 				"rlForfeit" => $RL_forfeit,
    // 				"isShowClaimable" => $isShowClaimable
    // 			),
    // 			"medical" => array(
    // 				"entitle" => floatval($medicalEntitle),
    // 				"taken" => floatval($medicalTaken)
    // 			),
    // 			"past_leaves" => $pastLeaves,
    // 			"adjust_leaves" => $adjustmentLeaves,
    // 			"npl" => $nplCount,
    // 			"earn" => $earn,
    // 			"EmergencyLeaveValue" => $EmergencyLeaveValue,
    // 			"brought_forward" => array(
    // 				"annual" => ($bfAnnual),
    // 				"annual_taken" => floatval($BFLeaveTaken),
    // 				"annual_adj" => ($bfAnnualAdj),
    // 				"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
    // 				"medical" => $bfMedical,
    // 				"medical_adj" => $bfMedicalAdj
    // 			),
    // 			"date_commence" => $date_commence
    // 		);

    // 		$totalDaysTillToday =  tillTodayTotalDays($year, $date);

    // 		// $BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
    //         // $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
    //         // $BFClearDuration = $BFClearDuration11->value;
    //         // $BFAdjClearDuration = $BFAdjClearDuration11->value;

    //         $BFClearDuration=0;
    //         $BFAdjClearDuration=0;
    //         if($username!=''){
    //             $users11=DB::table('users')->where('username',$username)->first();
    //             $usercat =DB::table('user_category')->where('username',$username)->first();
    //             $BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
    //             $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
    //             $BFClearDuration = $BFClearDuration11->value;
    //             $BFAdjClearDuration = $BFAdjClearDuration11->value;
    //         }

    // 		$yearlyEntitle['bf_forfeit'] = 0;
    // 		$yearlyEntitle['bfadj_forfeit'] = 0;
    // 		$yearlyEntitle['adj_forfeit'] = 0;

    // 		$bf_forfeit_value = 0;
    // 		$bfadj_forfeit_value = 0;

    // 		$checking_leave_year = $leave_year;
    // 		if($cutOffStartMonth!=1){
    // 			if($cutOffStartMonth>=$leave_month){
    // 				$checking_leave_year = $leave_year+1;
    // 			}
    // 		}

    // 		if (($BFClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFClearDuration < 365) {
    // 			$yearlyEntitle['bf_forfeit'] = 1;
    // 			$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
    // 		}

    // 		if (($BFAdjClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFAdjClearDuration < 365) {
    // 			$yearlyEntitle['bfadj_forfeit'] = 1;
    // 			$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
    // 		}

    // 		$total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value);
    //         $user=DB::table('users')->where('username',$username)->first();
    //         $usercat =DB::table('user_category')->where('username',$username)->first();
    //         $preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
    // 		//$preset1 = DB::table('settings')->where('field', "claimable_pre_set")->first();
    // 		$preset = $preset1->value;
    // 		$earn1 = ($earn - $preset);
    // 		$ear1 = ($preset / 12) * $annualEntitle;
    // 		$earn1 = $earn - $ear1;
    // 		if ($SettingLeaveAdjustmentType == 8) {
    // 			$_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
    // 		} else {
    // 			if ($year < date('Y')) {
    // 				if ($earn1 > $annualEntitle) {
    // 					$earn2 = $annualEntitle;
    // 				} else {
    // 					$earn2 = $earn1;
    // 				}
    // 				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;

    // 			} else {
    // 				if ($earn1 > $annualEntitle) {
    // 					$earn2 = $annualEntitle;
    // 				} else {
    // 					$earn2 = $earn1;
    // 				}
    // 				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;

    // 			}
    // 			$_claim = roundaway($_claim);
    // 			if ($_claim < 0) {
    // 				$_claim = 0;
    // 			}
    // 		}

    // 		$confirm_disp1 = DB::table('settings')->where('field', "confirm_display")->first();
    //     	$confirm_disp = $confirm_disp1->value;
    // 		$user_pay = DB::table('user_pay as a')->where('a.username', $username)->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, a.pay_status, a.contract")->leftjoin('branch as b','a.branch_id','=','b.id')->leftjoin('department as c','a.department_id','=','c.id')->leftjoin('category as d','a.category_id','=','d.id')->first();
    // 		if ($confirm_disp == '1') {
    // 			$user_pay->date_confirmed." -- ";
    // 			if ($user_pay->date_confirmed == '' || $user_pay->date_confirmed == '00-00-0000') {
    // 				$_claim = 0;
    // 			}
    // 		}

    // 		if (date("Y", strtotime($joiningDate)) == $leave_year) {


    // 			if ($yearlyEntitle['annual']['isShowClaimable'] == 0) {
    // 				$yearlyEntitle["claimable"] = 0;
    // 			} else {

    // 				$yearlyEntitle["claimable"] = $yearlyEntitle['earn'];
    // 			}
    // 		} else {
    // 			$yearlyEntitle["claimable"] = $_claim;
    // 		}

    // 		$yearlyEntitle["balance"] = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit);
    // 		if ($in_json) {
    // 			return json_encode($yearlyEntitle);
    // 		} else {
    // 			return $yearlyEntitle;
    // 		}
    //     }

    public function getYearlyEntitleMain($username = '', $year = '', $in_json = true, $date = '', $updt = '')
    {
        $date_for_query = "CURDATE()";
        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value ?? 0;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate = $cutOffDate11->value ?? 0;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate = $cutOffStartDate11->value ?? 0;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth = $cutOffStartMonth11->value ?? 0;
        $userPay = DB::table('user_pay')->where('username', $username)->first();

        $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value ?? 0;
        if ($SettingLeaveAdjustmentType == 8) {
            $joiningDate = $userPay->date_commence;
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            if (($request->pdf)) {
            } else {
                if (date('Y-m-d') < $curr_date) {
                    $year = $year - 1;
                }
            }
        }

        $SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
        $SoftwareStartDate = $SoftwareStartDate11->value ?? 0;

        $companyName11 = DB::table('settings')->where('field', "company")->first();
        $companyName = '';
        if ($companyName11 != '')
            $companyName = $companyName11->value ?? '';

        $isShowClaimable = getConfirmDisplay($username);

        $date_commence = $userPay->date_commence;
        $joiningDate = strtotime($date_commence);

        $cutOffStartYear = $year;
        $cutOffYear = $year;
        if ($cutOffStartMonth != 1) {
            if ($cutOffStartMonth > date('m')) {
                $cutOffStartYear = $year;
                $cutOffYear = $year;
            } else {
                $cutOffStartYear = $year - 1;
                $cutOffYear = $year;
            }
        } else {
            $cutOffStartYear = $year;
            $cutOffYear = $year;
        }

        $RL_forfeit = getForfeitAdjLeaveCount($username, $year);

        $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-" . $cutOffMonth . "-" . $cutOffDate);
        $medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-" . $cutOffMonth . "-" . $cutOffDate);

        $medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
        $medical_pro_rated = $medical_pro_rated11->value ?? 0;
        $joiningDate = $userPay->date_commence;
        $joiningDateArr = explode('-', $joiningDate);

        if ($medical_pro_rated == 1) {


            $joining_year = $joiningDateArr[0];
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];

            $resultArrayVal = DB::table('user_pay')->where('username', $username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as experience, date_commence")->first();

            $ExperienceInYear = intval($resultArrayVal->experience) + 1;
            $joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

            //section one	
            $prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
            $start = $year . "-" . $cutOffStartMonth . "-" . $cutOffStartDate;
            $datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
            $days1 = round($datediff / (60 * 60 * 24));

            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($prev_date_of_joining_date);
            $diff = $date1->diff($date2);
            $experiance1 = $diff->y;
            if ($experiance1 == 0) {
                $experiance1 = 1;
            }


            $builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Medical')->where('a.experience', '<=', $experiance1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
            $medicalEntitlenew1 = $builder1[0]->no_leaves;
            $d1 = ($days1 / 365) * $medicalEntitlenew1;

            $a1 = array(
                'username' => $username,
                'joining date' => $joiningDate,
                'entitle' => $medicalEntitlenew1,
                'start date' => $start,
                'end date' => $prev_date_of_joining_date,
                'days' => $days1,
                'experiance' => $experiance1,
            );
            //section one

            //section two
            $end_date = $year . "-" . $cutOffMonth . "-" . $cutOffDate;
            $datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
            $days2 = round($datediff2 / (60 * 60 * 24));

            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($end_date);
            $diff = $date1->diff($date2);
            $experiance2 = $diff->y;
            if ($joiningdatecurrent <= date('Y-m-d')) {
                $experiance2 = $experiance2 + 1;
            }
            $builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Medical')->where('a.experience', '<=', $experiance2)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
            $medicalEntitlenew = $builder1[0]->no_leaves;
            $d2 = ($days2 / 365) * $medicalEntitlenew;

            $a2 = array(
                'username' => $username,
                'joining date' => $joiningDate,
                'entitle' => $medicalEntitlenew,
                'start date' => $end_date,
                'end date' => $joiningdatecurrent,
                'days2' => $days2,
                'experiance' => $experiance2,
            );

            if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
                if ($medicalEntitlenew1 != $medicalEntitlenew) {
                    $medicalEntitle = round($d1 + $d2);
                } else {
                    if ($medicalEntitlenew1 != '') {
                        $medicalEntitle = $medicalEntitlenew1;
                    } else if ($medicalEntitlenew != '') {
                        $medicalEntitle = $medicalEntitlenew;
                    }
                }
            }
        }

        $resiged_date_str = $userPay->date_resigned;
        $joiningDate = $userPay->date_commence;
        $joiningDateArr = explode('-', $joiningDate);
        $resignDateArr = explode('-', $resiged_date_str);
        $resign_year = $resignDateArr[0];
        $joining_year = $joiningDateArr[0];
        if ($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
            $joining_year = $joiningDateArr[0];
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($joiningdatecurrent);
            $diff = $date1->diff($date2);
            $experiance1 = $diff->y;
            $experiance1 = $experiance1 + 1;



            if ($joining_year < $year && $resign_year == $year) {
                $joining_year = $joiningDateArr[0];
                $joining_month = $joiningDateArr[1];
                $joining_date = $joiningDateArr[2];
                $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
                $date1 = new DateTime($joiningDate);
                $date2 = new DateTime($joiningdatecurrent);
                $diff = $date1->diff($date2);
                $experiance_1 = $diff->y;
                if ($experiance_1 == 0) {
                    $experiance_1 = 1;
                }

                $builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $experiance_1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
                $annualEntitle_1 = $builder_1[0]->no_leaves;

                $experiance_2 = $experiance_1 + 1;
                $builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $experiance_2)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
                $pro = 0;
                $annualEntitle_2 = $builder_2[0]->no_leaves;

                if (($annualEntitle_1 != $annualEntitle_2)  && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
                    $pro = 1;
                    $datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-" . $cutOffStartMonth . "-" . $cutOffStartDate);
                    $days1 = round($datediff11 / (60 * 60 * 24));
                    $datediff2 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
                    $days2 = round($datediff2 / (60 * 60 * 24));
                    $first_dif = ($days1 / 365) * $annualEntitle_1;
                    $second_dif = ($days2 / 365) * $annualEntitle_2;
                    $annualEntitle = ($first_dif + $second_dif);
                } else {
                    $datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-" . $cutOffStartMonth . "-" . $cutOffStartDate);
                }
                //echo $annualEntitle;exit;
            } else if ($joining_year < $year && $resign_year > $year) {
                $joining_year = $joiningDateArr[0];
                $joining_month = $joiningDateArr[1];
                $joining_date = $joiningDateArr[2];
                $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
                $date1 = new DateTime($joiningDate);
                $date2 = new DateTime($joiningdatecurrent);
                $diff = $date1->diff($date2);
                $experiance_1 = $diff->y;
                if ($experiance_1 == 0) {
                    $experiance_1 = 1;
                }

                $builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $experiance_1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
                $annualEntitle_1 = $builder_1[0]->no_leaves;

                $experiance_2 = $experiance_1 + 1;
                $builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $experiance_2)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
                $pro = 0;
                $annualEntitle_2 = $builder_2[0]->no_leaves;
                if ($annualEntitle_1 != $annualEntitle_2) {
                    $pro = 1;
                    $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-" . $cutOffMonth . "-" . $cutOffDate);
                }
            } else if ($joining_year == $year && $resign_year == $year) {
                $pro = 0;
                $datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);
            } else if ($joining_year == $year && $resign_year > $year) {
                $pro = 0;
                $datediff2 = strtotime($cutOffYear . "-" . $cutOffMonth . "-" . $cutOffDate) - strtotime($joiningDate);
            } else {
                $pro = 0;
                $datediff2 = null;
            }

            // try {
            //    
            // } catch (\Throwable $th) {
            //     dd($joining_year,$year,$resign_year,$username);
            // }
            if ($datediff2 != null) {
                $days = round($datediff2 / (60 * 60 * 24));
            } else {
                $days = 0;
            }

            $annualEntitle1 = $days / 365;
            if ($joining_year < $year && $resign_year > $year) {
                if ($pro == 0) {
                    $annualEntitle = $annualEntitle;
                }
            } else {
                if ($pro == 0) {
                    $annualEntitle = $annualEntitle;
                }
            }
        }


        if ($SettingLeaveAdjustmentType == 8 || $SettingLeaveAdjustmentType == 1) {
            $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-" . $cutOffMonth . "-" . $cutOffDate);
            $joiningDate = $userPay->date_commence;

            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];

            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            $curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($curr_date);
            $diff = $date1->diff($date2);
            $ExperienceInYear = $diff->y;
            if ($diff->d > 0) {
                $ExperienceInYear = $ExperienceInYear + 1;
            }

            $builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $ExperienceInYear)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
            $annualEntitle = $builder2[0]->no_leaves;
        } else if ($SettingLeaveAdjustmentType == 6  && $joining_year != Date('Y')) {
            $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-" . $cutOffMonth . "-" . $cutOffDate);
            $joiningDate = $userPay->date_commence;
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];

            if ($year != "") {

                if ($year == date('Y')) {
                    $curr_date = date($year . '-m-d');
                } else {
                    $curr_date = ($year) . "-" . $cutOffMonth . "-" . $cutOffDate;
                }
            } else {
                $curr_date = date('Y-m-d');
            }


            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($curr_date);
            $diff = $date1->diff($date2);
            $ExperienceInYear = $diff->y;
            $actual_ExperienceInYear = $ExperienceInYear;

            if ($diff->d > 0 || $joiningDate == $curr_date) {
                $ExperienceInYear = $ExperienceInYear + 1;
            }
            if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
                $ExperienceInYear = 1;
            }

            $builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b', 'a.category_name', '=', 'b.category')->leftjoin('user_pay as c', 'b.username', '=', 'c.username')->where('a.type', 'Annual')->where('a.experience', '<=', $ExperienceInYear)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
            if ($actual_ExperienceInYear > 0) {
                $annualEntitle = $builder2[0]->no_leaves;
            }
        }
        $rlLeave = getReplacementLeaveCount($username, $year);
        $annaualTaken = getTakenLeaveCount($username, $year, "Annual");
        $medicalTaken = getTakenLeaveCount($username, $year, "Medical");
        $pastLeaves = getTakenPastLeaves($username, $year);
        $adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
        if ($SoftwareStartDate <= ($year - 1)) {
            $bfAnnual = getBFValue($year - 1, $username, ($year) . "-" . $cutOffMonth . "-" . $cutOffDate);
        } else {
            $bfAnnual = 0;
        }

        $EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);
        $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
        $bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
        $bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
        $nplCount = getNPLCount($username, $year);

        if ($cutOffStartMonth != '1') {
            $BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
        } else {
            $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
        }




        if ($BFLeaveTaken > $bfAnnual) {
            $BFLeaveTaken = $bfAnnual;
        }


        $tilldateDaysVal = tilldateDays($date_commence);
        $tillYearEndDaysVal = tillYearEndDays($date_commence);
        $YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);

        $resiged_date_str = $userPay->date_resigned;
        $resiged_date = strtotime($resiged_date_str);
        $resiged_year = date('Y', $resiged_date);

        if ($date != '') {
            $leave_month = date("n", strtotime(str_replace('/', '-', $date)));
            $leave_year = date("Y", strtotime(str_replace('/', '-', $date)));
        } else {
            $leave_month = date("n");
            $leave_year = date("Y");
        }

        if ($SettingLeaveAdjustmentType == 8) {
            $annual_ent = get_anniv_cutt_off_entitle($username, $year);
            $cut_off_days = day_count_anniv_cutt_off($username, $year);
            $earn = ($cut_off_days / 365) * $annual_ent;
            $earn = roundaway($earn);
        } else {
            if ($year < $leave_year) {
                $earn = roundaway($annualEntitle);
            } else {
                if ($cutOffStartMonth != 1 && $cutOffMonth <= $leave_month && $year <= $leave_year) {
                    $earn = roundaway($annualEntitle);
                } else if ($year == $resiged_year) {
                    if ($leave_month < date('n', $resiged_date)) {
                        $earn = roundaway(($leave_month /  date('n', $resiged_date)) * roundaway($annualEntitle));
                    } else {
                        $earn = roundaway(roundaway($annualEntitle));
                    }
                } else {
                    if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
                        $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                    } else {
                        if ((date("n", strtotime($joiningDate)) == $leave_month) && date("Y", strtotime($joiningDate)) == $leave_year) {
                            $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                        } else {
                            if ($cutOffStartMonth > $leave_month) {
                                if (date("Y", strtotime($joiningDate)) == $leave_year) {
                                    $month_cal = $leave_month - $joiningDateArr[1];
                                } else {
                                    if ($joining_year == ($leave_year - 1) && $cutOffStartMonth > $joiningDateArr[1]) {
                                        $month_cal_1 = 12 - $cutOffStartMonth;
                                    } else if ($joining_year == ($leave_year - 1)) {
                                        $month_cal_1 = 12 - $joiningDateArr[1];
                                    } else {
                                        $month_cal_1 = 12 - $cutOffStartMonth;
                                    }
                                    $month_cal = $month_cal_1 + $leave_month;
                                }
                                $month_cal = $month_cal + 1;
                            } else {
                                $month_cal = $leave_month - $cutOffStartMonth;
                                $month_cal = $month_cal + 1;
                            }
                            if (date("Y", strtotime($joiningDate)) == $leave_year) {
                                if ($companyName == "earn_prorated") {
                                    $earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
                                } else {
                                    $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
                                }


                                if ($month_cal == 12) {
                                    $earn = roundaway($annualEntitle);
                                }
                            } else {

                                $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
                            }
                        }
                    }
                }
            }
        }
        $annualEntitle_arr = explode('.', number_format($annualEntitle, 2));
        if (isset($annualEntitle_arr[1])) {

            if ($annualEntitle_arr[1] > 1 && $annualEntitle_arr[1] <= 25) {
                $annualEntitle = floor($annualEntitle);
            } else if ($annualEntitle_arr[1] >= 26 && $annualEntitle_arr[1] <= 75) {
                $annualEntitle = $annualEntitle;
            } else if ($annualEntitle_arr[1] > 75) {
                $annualEntitle = ceil($annualEntitle);
            } else {
                $annualEntitle = $annualEntitle;
            }
        } else {
            $annualEntitle = $annualEntitle;
        }


        $rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);
        $bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

        $yearlyEntitle = array(
            "annual" => array(
                "entitle" => getValue($annualEntitle),
                "taken" => floatval($annaualTaken),
                "rlLeave" => floatval($rlLeave),
                "rlLeaveTaken" => $rlLeaveTaken,
                "rlForfeit" => $RL_forfeit,
                "isShowClaimable" => $isShowClaimable
            ),
            "medical" => array(
                "entitle" => floatval($medicalEntitle),
                "taken" => floatval($medicalTaken)
            ),
            "past_leaves" => $pastLeaves,
            "adjust_leaves" => $adjustmentLeaves,
            "npl" => $nplCount,
            "earn" => $earn,
            "EmergencyLeaveValue" => $EmergencyLeaveValue,
            "brought_forward" => array(
                "annual" => ($bfAnnual),
                "annual_taken" => floatval($BFLeaveTaken),
                "annual_adj" => ($bfAnnualAdj),
                "bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
                "medical" => $bfMedical,
                "medical_adj" => $bfMedicalAdj
            ),
            "date_commence" => $date_commence
        );

        $totalDaysTillToday =  tillTodayTotalDays($year, $date);

        // $BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
        // $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
        // $BFClearDuration = $BFClearDuration11->value;
        // $BFAdjClearDuration = $BFAdjClearDuration11->value;

        $BFClearDuration = 0;
        $BFAdjClearDuration = 0;
        if ($username != '') {
            $users11 = DB::table('users')->where('username', $username)->first();
            $usercat = DB::table('user_category')->where('username', $username)->first();
            $BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id', $users11->company_id)->first();
            $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id', $users11->company_id)->first();
            $BFClearDuration = $BFClearDuration11->value;
            $BFAdjClearDuration = $BFAdjClearDuration11->value;
        }

        $yearlyEntitle['bf_forfeit'] = 0;
        $yearlyEntitle['bfadj_forfeit'] = 0;
        $yearlyEntitle['adj_forfeit'] = 0;

        $bf_forfeit_value = 0;
        $bfadj_forfeit_value = 0;

        $checking_leave_year = $leave_year;
        if ($cutOffStartMonth != 1) {
            if ($cutOffStartMonth >= $leave_month) {
                $checking_leave_year = $leave_year + 1;
            }
        }

        if (($BFClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFClearDuration < 365) {
            $yearlyEntitle['bf_forfeit'] = 1;
            $bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
        }

        if (($BFAdjClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFAdjClearDuration < 365) {
            $yearlyEntitle['bfadj_forfeit'] = 1;
            $bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
        }

        $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value);
        $user = DB::table('users')->where('username', $username)->first();
        $usercat = DB::table('user_category')->where('username', $username)->first();
        $preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id', $user->company_id)->first();
        //$preset1 = DB::table('settings')->where('field', "claimable_pre_set")->first();
        $preset = $preset1->value;
        $earn1 = ($earn - $preset);
        $ear1 = ($preset / 12) * $annualEntitle;
        $earn1 = $earn - $ear1;
        if ($SettingLeaveAdjustmentType == 8) {
            $_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
        } else {
            if ($year < date('Y')) {
                if ($earn1 > $annualEntitle) {
                    $earn2 = $annualEntitle;
                } else {
                    $earn2 = $earn1;
                }
                $_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
            } else {
                if ($earn1 > $annualEntitle) {
                    $earn2 = $annualEntitle;
                } else {
                    $earn2 = $earn1;
                }
                $_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
            }
            $_claim = roundaway($_claim);
            if ($_claim < 0) {
                $_claim = 0;
            }
        }

        $confirm_disp1 = DB::table('settings')->where('field', "confirm_display")->first();
        $confirm_disp = $confirm_disp1->value ?? 0;
        $user_pay = DB::table('user_pay as a')->where('a.username', $username)->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, a.pay_status, a.contract")->leftjoin('branch as b', 'a.branch_id', '=', 'b.id')->leftjoin('department as c', 'a.department_id', '=', 'c.id')->leftjoin('category as d', 'a.category_id', '=', 'd.id')->first();
        if ($confirm_disp == '1') {
            $user_pay->date_confirmed . " -- ";
            if ($user_pay->date_confirmed == '' || $user_pay->date_confirmed == '00-00-0000') {
                $_claim = 0;
            }
        }

        if (date("Y", strtotime($joiningDate)) == $leave_year) {


            if ($yearlyEntitle['annual']['isShowClaimable'] == 0) {
                $yearlyEntitle["claimable"] = 0;
            } else {

                $yearlyEntitle["claimable"] = $yearlyEntitle['earn'];
            }
        } else {
            $yearlyEntitle["claimable"] = $_claim;
        }

        $yearlyEntitle["balance"] = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit);
        if ($in_json) {
            return json_encode($yearlyEntitle);
        } else {
            return $yearlyEntitle;
        }
    }

    public function sendMessage11($sender, $recipient, $message, $expiryDate)
    {
        $result = DB::table('messages')->insert(array('sender' => $sender, 'recipient' => $recipient, 'message' => $message, 'expiry_date' => $expiryDate));
        return true;
    }

    public function addSenderMessage($sender, $recipients, $message)
    {
        $result = DB::table('messages_sent')->insert(array('sender' => $sender, 'recipients' => $recipients, 'message' => $message));
        return true;
    }

    public function getSentMessages(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $sender = (isset($request->sender) ? $request->sender : $user->username);
        $result = DB::table('messages_sent')->where('sender', $sender)->orderBy('time', 'desc')->get();
        return DataTables::of($result)->make(true);
    }

    public function deleteSentMessage(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $id = $request->msg_id;

        $result = $this->deleteSentMessage11($id);
        return array("result" => $result);
    }

    public function deleteSentMessage11($id)
    {

        $_res = $this->getSentMessageDetails($id);
        $recipients = $_res[0]->recipients;
        $recipients_array = explode(",", $recipients);
        for ($i = 0; $i < count($recipients_array); $i++) {
            $msg_id = $this->getMessageId($_res[0]->sender, $recipients_array[$i], $_res[0]->message, $_res[0]->time);
            if (!empty($msg_id))
                $this->deleteMessage($msg_id->id);
        }
        $query = "delete from messages_sent where id='" . $id . "'";
        $builder = DB::select($query);
        return true;
    }

    public function getSentMessageDetails($id)
    {
        $builder = DB::table('messages_sent')->where('id', $id)->orderBy('time', 'desc')->selectRaw("sender, recipients, message, time")->get();
        return $builder;
    }

    public function getMessageId($senderVal, $recipientVal, $messageVal, $timeVal)
    {
        $builder = DB::table('messages')->where('sender', $senderVal)->where('recipient', $recipientVal)->where('message', $messageVal)->where('time', $timeVal)->selectRaw("id")->first();
        return $builder;
    }

    public function deleteMessage($id)
    {
        $messages = DB::table('messages')->where('id', $id)->delete();
        return $messages;
    }


    public function getSingleSentMessage($id)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('messages_sent')->where('id', $id)->selectRaw("*,date(time) as dateval")->find($id);
        return $result;
    }

    public function hrapplyonbehalf()
    {
        $user = User::where('id', Auth::id())->first();
        $upaydetails = UserPersonal::where('username', $user->username)->first();
        if ($upaydetails->sex == 1) {
            $leaveTypes  = Leavetype::where('type', '!=', 'Maternity')->where('company_id', $user->company_id)->where('is_show', 1)->get();
        } else {
            $leaveTypes  = Leavetype::where('is_show', 1)->get();
        }
        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $employees = MapEmployeeApprover::where('approver_id', $user->username)->leftjoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->selectRaw("map_employee_approver.employee_id, user_personal.name ")->groupBy('map_employee_approver.employee_id')->orderby('user_personal.name', 'asc')->get();

        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        $holidays = PublicHoliday::where('company_id', $user->company_id)->where('date', '>=', $startOfYear->format('Y-m-d'))->where('date', '<=', $endOfYear->format('Y-m-d'))->get();
        $leavesArray = Leavelist::selectRaw("leave_list.*,user_personal.username as name,user_personal.name as uname, map_employee_approver.*, leave_name.name as typename, CONCAT(leave_list.username, leave_list.start_date) as usergroup")->leftjoin('user_personal', 'leave_list.username', '=', 'user_personal.username')->leftjoin('map_employee_approver', 'map_employee_approver.employee_id', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('map_employee_approver.approver_id', $user->username)->groupBy('usergroup')->orderBy('leave_list.date_applied', 'DESC')->with('getType')->where('leave_list.status', '1')->get();

        // dd($leavesArray);

        $leavesArray->transform(function ($item) {
            if ($item->getType != null) {
                $item->background_color = $item->getType->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = '#000000';
            } else {
                $iname = $item->type;
                $colornm = $item->background_color;
            }
            $r_name = $item->name;

            return [
                'title' => $r_name . ' (  ' . $item->typename . ')' . $htype,
                'text_color'  => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' =>  $colornm,

            ];
        })->toArray();

        // 		$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();
        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function ($item) {

            return [

                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color'  => '#000',
                'color' =>  '#e0e0e0',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
            ->whereYear('date', '=', date('Y'))->whereRaw('(state = "National" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function ($item11) {

            return [

                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'text_color'  => '#fff',
                'color' =>  '#28c76f',
            ];
        })->toArray();
        $leaves11 = $restDay->merge($leavesArray);
        $leaves = $leaves11->merge($recentHoliday);
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        $company_id = '';
        if (!empty($user->company_id)) {
            $company_id = $user->company_id;
        }
        return view('hr.apply-on-behalf', compact('company_id', 'leaveTypes', 'upaydetails', 'relieves', 'employees', 'holidays', 'leaves', 'relieveallow', 'halfdayallow'));
    }

    public function  setStatuss($_id = '', $_approver_id = '', $_status = '', Request $request)
    {
        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate = $cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate = $cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth = $cutOffStartMonth11->value;
        $user = User::where('id', Auth::id())->first();

        if ($_id == '') {
            $id = $request->id;
        } else {
            $id = $_id;
        }
        $cancel_reason = $request->cancel_reason;
        $reject_reason = $request->reject_reason;

        $login_username = ($request->username ? $request->username : $user->username);

        if ($_approver_id == '') {
            $approverId = ($request->approver_id ? $request->approver_id : $user->username);
        } else {
            $approverId = $_approver_id;
        }

        if ($_status == '') {
            $status = $request->status;
        } else {
            $status = $_status;
        }
        $apply_subord = $request->apply_subord ? $request->apply_subord : '0';
        if ($status != "2" && $apply_subord != '1') {
            $getLeaveMultipleApprover = DB::table('settings')->where('field', 'leave_multiple_approver')->first();
            $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
            if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
                $this->update_leave_approver($id, $approverId, $status, $cancel_reason, $reject_reason);
                if (!$this->UpdateApproverOfLeave($id, $approverId, $status, request())) {
                    return;
                }
            } else if ($LeaveMultipleApprover == '3') {
                $this->update_leave_approver($id, $approverId, $status, $cancel_reason, $reject_reason);
                $cnt = $this->get_approver_by_leaveid($id);
                if ($cnt > 0) {
                    return;
                }
            } else if ($LeaveMultipleApprover == '4') {
                $this->update_leave_approver($id, '', $status, $cancel_reason, $reject_reason);
            }
        }

        if ($status == "2" && $apply_subord != '1') {
            $getLeaveMultipleApprover = DB::table('settings')->where('field', 'leave_multiple_approver')->first();
            $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
            if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
                $this->update_leave_approver11($id, $approverId, $status, $cancel_reason, $reject_reason);
            } else if ($LeaveMultipleApprover == '3') {
                $this->update_leave_approver11($id, $approverId, $status, $cancel_reason, $reject_reason);
            } else if ($LeaveMultipleApprover == '4') {
                $this->update_leave_approver11($id, '', $status, $cancel_reason, $reject_reason);
            }
        }


        $result = $this->setStatus11($id, $status);

        $sStatus = "";
        if ($status == "1")
            $sStatus = "approved";
        else if ($status == "2")
            $sStatus = "rejected";
        else if ($status == "3")
            $sStatus = "recommended";
        else if ($status == "4")
            $sStatus = "cancelled";
        else if ($status == "5")
            $sStatus = "Cancellation Pending";

        $npl_to_hr1 = DB::table('settings')->where('field', 'npl_to_hr')->first();
        $npl_to_hr = '';
        if ($npl_to_hr1 != '')
            $npl_to_hr = $npl_to_hr1->value;
        $nplHRUsers = $this->getNPL_HR_User();

        $hr_id_array = array();
        for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
            $hr_id_array[$npl_hr_i] = strtolower($nplHRUsers[$npl_hr_i]->employee_id);
        }

        $leaveDetails = $this->getLeaveDetails($id);

        $isShowClaimable = $this->getConfirmDisplay($leaveDetails->username);

        if ($status == '4' || $status == '2') {
            if ($leaveDetails->type == 'Other_pay') {
                for ($_rl_i = 0; $_rl_i < ($leaveDetails->no_days * 2); $_rl_i++) {
                    unMarkReplacementLeaveAsTaken($leaveDetails->username);
                }
            }
        }

        if ($cancel_reason != '') {
            $this->updateLeaveDays($cancel_reason, $id);
        }
        if ($reject_reason != '') {
            $this->updateLeaveDays($reject_reason, $id, 'reject');
        }


        $email_send_allow = true;
        $sendbypreference1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->first();
        $sendbypreference = $sendbypreference1->value ?? 0;
        if ($sendbypreference == "1") {
            if (!hasContentPreference($leaveDetails->username)) {
                $email_send_allow = true;
            } else {
                $email_send_allow = false;
            }
        }
        if ($status == "3") {
            $getLeaveMultipleApprover = DB::table('settings')->where('field', 'leave_multiple_approver')->first();
            $LeaveMultipleApprover = $getLeaveMultipleApprover->value;

            if ($LeaveMultipleApprover == '1') {
                $masterApprover = getApproversOfEmployee($leaveDetails->username);
                if (count($masterApprover) > 1) {
                    $masterApprover = $masterApprover[1]->username;
                } else {
                    $masterApprover = getApproversOfEmployee($approverId);
                    $masterApprover = $masterApprover[0]->username;
                }
            } else {
                $masterApprover = getApproversOfEmployee($approverId);
                $masterApprover = $masterApprover[0]->username;
            }

            $this->setAssignee($id, $masterApprover);
            $emailSendingStatus1 = DB::table('settings')->where('field', 'email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;

            $uname = UserPersonal::where('username', $user->username)->first();
            $name = $uname->name;

            if ($email_send_allow) {
                if ($emailSendingStatus == '0') {
                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;
                    $referer = str_replace('self-leaves', 'dashboard', url()->current());

                    $body = "Leave has been recommended by $name. ";
                    $body .= "Details of the leave are as follows:<br><br>";
                    $body .= "Employee Name: $emp_name<br>";
                    $body .= "From: " . date('d-m-Y', strtotime($from_date)) . "<br>";
                    $body .= "To: " . date('d-m-Y', strtotime($to_date)) . "<br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  date('h:i A', $leaveDetails->start_time);
                        $endTime = date('h:i A', $leaveDetails->end_time);
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")<br><br>";
                    }
                    $body .= "Type: $type_display<br>";
                    $body .= "Reason: $reason<br>";
                    $body .= "Link: <a href='$referer'>$referer</a><br><br>";
                    $body .= "Kind regards,";
                    $body .= "Note, this is an automatic email. Please do not reply. ";
                    $body .= "If you did not request this information, please ignore this message. ";
                    $body .= "If you have any questions, please contact us";

                    $semail = UserPersonal::where('username', $masterApprover)->first();
                    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                    sendemail($semail->email_id, $subject, $body);

                    // $details['email_id'] = $semail->email_id;
                    // $details['subject'] = $subject;
                    // $details['body'] = $body;

                    // SendEmailJob::dispatch($details);

                    //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
                } else {

                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;

                    $referer = str_replace('self-leaves', 'dashboard', url()->current());
                    $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                    $body = "<tr>";
                    $body .= "<td>$emp_name</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($from_date)) . "</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($to_date)) . "</td>";

                    $body .= "<td>$type_display Leave<br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")</td>";
                    } else {
                        $body .= "<br></td>";
                    }
                    $body .= "<td>$reason</td>";
                    $body .= "<td>" . ucwords($sStatus) . "</td>";
                    $body .= '<td>Link: <a href="' . $referer . '">' . $referer . '</a></td>';
                    $body .= "</tr>";

                    $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
                }
            }
        } else if ($status == "5") {

            $Cancel_leave_to_hr1 = DB::table('settings')->where('field', 'cancel_leave_to_hr')->first();
            $Cancel_leave_to_hr = $Cancel_leave_to_hr1->value;
            $approver_done = false;
            if ($Cancel_leave_to_hr == 1) {

                $masterApprover = $this->getCancelLeave_Approver();

                if (count($masterApprover) > 0) {
                    $approver_done = true;
                    $masterApprover = $masterApprover[0]->username;
                    $this->setAssignee($id, $masterApprover);
                } else {
                    $approver_done = false;
                }
            }

            if (!$approver_done) {
                $masterApprover = getApproversOfEmployee($approverId);
                $masterApprover = $masterApprover[0]->username;
                $this->setAssignee($id, $masterApprover);
            }

            $emailSendingStatus1 = DB::table('settings')->where('field', 'email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;
            $uname = UserPersonal::where('username', $user->username)->first();
            $name = $uname->name;

            if ($email_send_allow) {
                if ($emailSendingStatus == '0') {
                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;

                    $body = "Self Leave has been Cancelled by $name. ";
                    $body .= "Details of the leave are as follows:<br><br>";
                    $body .= "From: " . date('d-m-Y', strtotime($from_date)) . "<br>";
                    $body .= "To: " . date('d-m-Y', strtotime($to_date)) . "<br><br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")<br><br>";
                    }
                    $body .= "Type: $type_display<br>";
                    $body .= "Reason: $reason<br><br>";
                    $body .= "Name : $emp_name<br><br>";
                    $referer = str_replace('self-leaves', 'dashboard', url()->current());
                    $body .= "Link: <a href='$referer'>$referer</a><br><br>";

                    $body .= "Kind regards,";
                    $body .= "Note, this is an automatic email. Please do not reply. ";
                    $body .= "If you did not request this information, please ignore this message. ";
                    $body .= "If you have any questions, please contact us";

                    $semail = UserPersonal::where('username', $masterApprover)->first();
                    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                    sendemail($semail->email_id, $subject, $body);

                    // 	$details['email_id'] = $semail->email_id;
                    //     $details['subject'] = $subject;
                    //     $details['body'] = $body;
                    //                 SendEmailJob::dispatch($details);
                    //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
                } else {

                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;

                    $referer = str_replace('self-leaves', 'dashboard', url()->current());
                    $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                    $body = "<tr>";
                    $body .= "<td>$emp_name</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($from_date)) . "</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($to_date)) . "</td>";

                    $body .= "<td>$type_display Leave<br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")</td>";
                    } else {
                        $body .= "<br></td>";
                    }
                    $body .= "<td>$reason</td>";
                    $body .= "<td>" . ucwords($sStatus) . "</td>";
                    $body .= '<td>Link: <a href="' . $referer . '">' . $referer . '</a></td>';
                    $body .= "</tr>";


                    $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
                }
            }
        } else if ($status == "4") {
            if ($email_send_allow) {
                $emailSendingStatus1 = DB::table('settings')->where('field', 'email_by_cronjob')->first();
                $emailSendingStatus = $emailSendingStatus1->value;
                if ($emailSendingStatus == '0') {
                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;
                    $referer = url()->current();
                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());


                    $body = "Dear $emp_name<br><br>";
                    $body .= "Your leave has been $sStatus<br><br>";
                    $body .= "Details of the leave are as follows:<br><br>";
                    $body .= "From: " . date('d-m-Y', strtotime($from_date)) . "<br>";
                    $body .= "To: " . date('d-m-Y', strtotime($to_date)) . "<br><br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")<br><br>";
                    }
                    $body .= "Type: $type_display<br>";
                    $body .= "Reason: $reason<br><br>";
                    $body .= "Kind regards,<br><br>";
                    $body .= "Note: this is an automatic email. Please do not reply. ";
                    $body .= "If you did not request this information, please ignore this message. ";
                    $body .= "If you have any questions, please contact us";

                    $semail = UserPersonal::where('username', $username)->first();
                    sendemail($semail->email_id, $subject, $body);

                    // 	$details['email_id'] = $semail->email_id;
                    //     $details['subject'] = $subject;
                    //     $details['body'] = $body;

                    //                 SendEmailJob::dispatch($details);

                    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));

                    $message = "Dear $emp_name  ";
                    $message .= "Your leave has been $sStatus, ";
                    $message .= "Details of the leave are as follows: ";
                    $message .= "From: $from_date  ";
                    $message .= "To: $to_date  ";
                    $message .= "Reason: $reason";

                    sendSMSToUserFromServer($username, $message);
                } else {
                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($leaveDetails->type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;
                    $referer = url()->current();
                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());

                    $body = "<tr>";
                    $body .= "<td>" . date('d-m-Y', strtotime($from_date)) . "</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($to_date)) . "</td>";
                    $body .= "<td>$type_display Leave<br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")</td>";
                    } else {
                        $body .= "<br></td>";
                    }
                    $body .= "<td>$reason</td>";
                    $body .= "<td>" . ucwords($sStatus) . "</td>";
                    $body .= "<td>  </td>";
                    $body .= "</tr>";

                    $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
                }
            }
        } else if ($sStatus != "") {
            $username = $leaveDetails->username;
            $type = $leaveDetails->type;
            $year = date("Y", strtotime(str_replace('/', '-', $leaveDetails->start_date)));
            $leave_month = date("m", strtotime(str_replace('/', '-', $leaveDetails->start_date)));

            if ($cutOffStartMonth != 1) {
                if ($cutOffStartMonth > $leave_month) {
                    $cutOffStartYear = $year;
                    $year = $year;
                } else {
                    $cutOffStartYear = $year;
                    $year = $year + 1;
                }
            } else {
                $cutOffStartYear = $year;
                $year = $year;
            }

            $new_type = $type;

            $categoryId = getUserCategory($username);
            $leaveAllowMaxvalue = $this->getMaxValue($new_type, $categoryId);
            $totalLeaveValue = $this->getLeaveAccordingToTypeCount($year, $username, $new_type);
            $this_taken = 0;

            $TakenPastLeaves = getTakenPastLeaves($username, $cutOffStartYear);


            if ($type == "Medical" && $status == "1") {
                $medicalEntitle = getLeaveEntitle($username, "Medical");
                $medicalTaken = getTakenLeaveCount($username, $year, "Medical");


                $bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
                $bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");


                if (($medicalTaken + $TakenPastLeaves['medical']) > ($medicalEntitle + $bfMedical + $bfMedicalAdj)) {
                    $new_type = "NPL";
                    $this->changeType($id, "NPL");
                }
            }

            if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
                if ($leaveAllowMaxvalue < $totalLeaveValue) {
                    $type = "Annual";
                    $new_type = "Annual";
                    $this->changeType($id, $new_type);
                }
            }

            if ($type == "Annual" && $status == "1") {

                $checking_year = date('Y');
                if ($cutOffStartMonth != 1) {
                    if ($cutOffStartMonth <= $leave_month) {
                        $checking_year = date('Y') + 1;
                    }
                }

                $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
                $SoftwareStartDate1 = DB::table('settings')->where('field', 'software_start_year')->first();
                $SoftwareStartDate = $SoftwareStartDate1->value;

                $_start_leave_date_array = explode("/", $leaveDetails->start_date);
                $_start_leave_date = $_start_leave_date_array[2] . "-" . $_start_leave_date_array[1] . "-" . $_start_leave_date_array[0];

                if ($SoftwareStartDate <= ($year - 1)) {

                    $bfAnnual = getBFValue($year - 1, $username, $_start_leave_date);
                } else {

                    $bfAnnual = 0;
                }
                $users = DB::table('users')->where('username', $username)->first();
                $usercat = DB::table('user_category')->where('username', $username)->first();
                $BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id', $users->company_id)->first();

                $BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id', $users->company_id)->first();

                //$BFClearDuration1=DB::table('settings')->where('field','bf_duration')->first();
                $BFClearDuration = $BFClearDuration1->value;
                //$BFAdjClearDuration1=DB::table('settings')->where('field','bf_adj_duration')->first();
                $BFAdjClearDuration = $BFAdjClearDuration1->value;
                $totalDaysTillToday =  tillTodayTotalDays($year, $leaveDetails->start_date);

                if (($BFClearDuration < $totalDaysTillToday || $year != date('Y'))  && $cutOffStartMonth == 1) {

                    $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);

                    if ($BFLeaveTaken > $bfAnnual) {
                        $BFLeaveTaken = $bfAnnual;
                    }

                    $bfAnnual = $BFLeaveTaken;
                } else if ($cutOffStartMonth != 1) {

                    $BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);

                    if ($BFLeaveTaken > $bfAnnual) {
                        $BFLeaveTaken = $bfAnnual;
                    }

                    $bfAnnual = $BFLeaveTaken;
                }

                if (($BFAdjClearDuration < $totalDaysTillToday || $year != date('Y')) && $cutOffStartMonth == 1) {

                    $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

                    if ($BFADJLeaveTaken > $bfAnnualAdj) {
                        $BFADJLeaveTaken = $bfAnnualAdj;
                    }

                    $bfAnnualAdj = $BFADJLeaveTaken;
                } else if ($cutOffStartMonth != 1) {
                    $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $checking_year, $bfAnnual, $bfAnnualAdj);

                    if ($BFADJLeaveTaken > $bfAnnualAdj) {
                        $BFADJLeaveTaken = $bfAnnualAdj;
                    }

                    $bfAnnualAdj = $BFADJLeaveTaken;
                }

                $taken = getTakenLeaveCount($username, $year, $type);
                if ($type == "Annual") {

                    $el_taken = getTakenLeaveCount($username, $year, "Emergency");
                }

                $leave_end_month = date('m', strtotime(str_replace("/", "-", $leaveDetails->end_date)));

                $workForEarnSetting1 = DB::table('settings')->where('field', 'WorkForEarn')->first();
                $workForEarnSetting = $workForEarnSetting1->value;
                //if ($year > date('Y')) {
                $url = \Request::url();

                $uname = UserPersonal::whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
                $name = urlencode($uname->employee_no);

                $ln = 1;
                $aid = Auth::id();

                if ($year != null) {
                    $url11 = str_replace(env('BASE_URL')."e-leave/approve-leaves", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
                } else {
                    $url11 = str_replace(env('BASE_URL')."e-leave/approve-leaves", env('CURL_URL')."public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
                }
                // dd($url11,$year);
                ini_set('memory_limit', -1);
                ini_set('max_execution_time', -1);
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url11 . "&auth_id=" . Auth::id(),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                ));

                $response = curl_exec($curl);
                curl_close($curl);

                $myLeaveSumm = json_decode($response);
                if (!empty($myLeaveSumm)) {
                    $yearlyEntitle = $myLeaveSumm[0];
                } else {
                    $yearlyEntitle = '';
                }
                // $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
                // } else {
                //     $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
                // }
                if ($yearlyEntitle != '') {
                    // $claimable = $yearlyEntitle['claimable'];
                    // $entitle1 = $yearlyEntitle['annual']['entitle'];
                    $claimable = $yearlyEntitle->claimable;
                    $entitle1 = $yearlyEntitle->aentitle;
                }


                //$elSetting1=DB::table('settings')->where('field','emergency_leave')->first();
                $users = DB::table('users')->where('username', $username)->first();
                $usercat = DB::table('user_category')->where('username', $username)->first();
                $elSetting1 = DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id', $users->company_id)->first();
                $elSetting = $elSetting1->value;
                $em_leave = getEmergencyLeaveCountByUser($username, $year);


                $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b', 'a.category', '=', 'b.category_name')->where('a.username', $username)->selectRaw("b.percentage,b.type")->first();
                $max_day = $resultArrayVal->percentage;
                $balance1 = $yearlyEntitle->balance;

                if ($year > $checking_year) {
                    if ($balance1 <= $max_day) {
                        $claimable = $balance1 + 1;
                    } else {
                        $claimable = $max_day + 1;
                    }
                } else {
                    if ($balance1 < 0) {
                        $new_type = "NPL";
                        $this->changeType($id, "NPL");
                    }
                }

                if ($isShowClaimable == 0) {
                    $claimable = 0;
                }

                $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
                $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
                if ($SettingLeaveAdjustmentType != 8) {
                    if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable) || (($claimable) == 0)) {

                        $new_type = "NPL";
                        $this->changeType($id, "NPL");

                        if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                            //$result = $this->setStatus11($id, '0');
                            $result = $this->setStatus11($id, $status);
                        }
                    }
                } else {

                    $TakenPastLeaves2 = $this->getTakenPastLeaves2($username, $leaveDetails->start_date, $year);
                    $cut_off_taken = $this->getTakenLeaveCount2($username, $type, $leaveDetails->start_date, $year);
                    $cut_off_em_leave = $this->getEmergencyLeaveCountByUser2($username, $leaveDetails->start_date, $year);

                    if (($cut_off_taken + $cut_off_em_leave + $TakenPastLeaves2['annual']) > $yearlyEntitle->aentitle) {

                        $new_type = "NPL";
                        $this->changeType($id, "NPL");

                        if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                            //$result = $this->setStatus11($id, '0');
                            $result = $this->setStatus11($id, $status);
                        }
                    }
                    $leavedate = str_replace('/', '-', $leaveDetails->start_date);
                    $leavedate = date('Y-m-d', strtotime($leavedate));

                    $joindate1 = DB::table('user_pay')->where('username', $username)->first();
                    $joiningDate = $joindate1->date_commence;
                    $joiningDateArr = explode('-', $joiningDate);
                    $joining_month = $joiningDateArr[1];
                    $joining_date = $joiningDateArr[2];

                    $curr_j_date = $year . '-' . $joining_month . '-' . $joining_date;

                    if ($leavedate > $curr_j_date) {
                        $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b', 'a.category', '=', 'b.category_name')->where('a.username', $username)->selectRaw("b.percentage,b.type")->first();
                        $max_day = $resultArrayVal->percentage;
                        \Log::info($yearlyEntitle);
                        \Log::info($curr_j_date);
                        \Log::info($max_day);
                        if (isset($max_day)) {
                            if ($max_day > 0) {
                                $max_day = ($max_day - 1);
                            } else {
                                $new_type = "NPL";
                                $this->changeType($id, "NPL");

                                if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                                    //	$result = $this->setStatus11($id, '0');
                                    $result = $this->setStatus11($id, $status);
                                }
                            }
                        } else {
                            $max_day = $max_day;
                            if ($max_day > 0) {
                                $max_day = ($max_day - 1);
                            } else {
                                $new_type = "NPL";
                                $this->changeType($id, "NPL");

                                if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                                    // $result = $this->setStatus11($id, '0');
                                    $result = $this->setStatus11($id, $status);
                                }
                            }
                        }
                    }
                }

                $is_emergency_check = true;

                if ($npl_to_hr == '1') {
                    if ($new_type != "NPL") {
                        $is_emergency_check = true;
                    } else {
                        $is_emergency_check = false;
                    }
                }

                $dateDiff = diff(strtotime($leaveDetails->start_date_cal), strtotime($leaveDetails->date_applied_cal));
                if ($is_emergency_check && $elSetting != 0 && $new_type != "NPL") {
                    if ($dateDiff['invert'] == 0 || (($dateDiff['month'] == 0 && $dateDiff['year'] == 0 && $dateDiff['day'] < $elSetting) && ($this->total_Emergency < $elSetting))) {
                        if ($this->total_Emergency < $elSetting) {
                            $this->total_Emergency++;
                            $this->changeCategory($leaveDetails->leave_id, "Emergency");
                            $this->changeTypeOfLeaveList($leaveDetails->leave_id, "Emergency");
                            $new_type = "Emergency";
                        } else {
                            if ($leaveDetails->leave_category == 'Emergency') {
                                $this->changeCategory($leaveDetails->leave_id, "Normal");
                            }
                        }
                    }
                } else {
                    if ($leaveDetails->leave_category == 'Emergency') {
                        $this->changeCategory($leaveDetails->leave_id, "Normal");
                    }
                }

                if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
                    if ($leaveAllowMaxvalue < $totalLeaveValue) {
                        $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                        $this->changeCategory($leaveDetails->leave_id, "Normal");
                        $new_type = "NPL";
                    }
                } else if ($new_type == 'Emergency') {
                    if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable)) {
                        $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                        $this->changeCategory($leaveDetails->leave_id, "Normal");
                        $new_type = "NPL";
                    }
                }
            }

            $uname = UserPersonal::where('username', $approverId)->first();
            $name = $uname->name;

            if ($email_send_allow) {
                $emailSendingStatus1 = DB::table('settings')->where('field', 'email_by_cronjob')->first();
                $emailSendingStatus = $emailSendingStatus1->value;
                if ($emailSendingStatus == '0') {
                    $subject = "Leave $sStatus";

                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($new_type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;
                    $referer = url()->current();
                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                    $half_day_type = '';
                    if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                        $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                    }

                    $body = "Dear $emp_name<br><br>";
                    $body .= "Your leave has been $sStatus<br><br>";
                    $body .= "Details of the leave are as follows:<br><br>";
                    $body .= "From: " . date('d-m-Y', strtotime($from_date)) . "<br>";
                    $body .= "To: " . date('d-m-Y', strtotime($to_date)) . "<br><br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")<br><br>";
                    }
                    $body .= "Type: $type_display $half_day_type<br>";
                    $body .= "Reason: $reason<br><br>";
                    $body .= "Kind regards,<br><br>";
                    $body .= "Note: this is an automatic email. Please do not reply. ";
                    $body .= "If you did not request this information, please ignore this message. ";
                    $body .= "If you have any questions, please contact us";

                    $semail = UserPersonal::where('username', $username)->first();

                    sendemail($semail->email_id, $subject, $body);

                    // $details['email_id'] = $semail->email_id;
                    // $details['subject'] = $subject;
                    // $details['body'] = $body;

                    //             SendEmailJob::dispatch($details);

                    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));

                    $message = "Dear $emp_name  ";
                    $message .= "Your leave has been $sStatus, ";
                    $message .= "Details of the leave are as follows: ";
                    $message .= "From: $from_date  ";
                    $message .= "To: $to_date  $half_day_type";
                    $message .= "Reason: $reason";

                    sendSMSToUserFromServer($username, $message);
                } else {
                    if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        $subject = "Leave $new_type";
                    } else {
                        $subject = "Leave $sStatus";
                    }
                    $emp_name = $leaveDetails->name;
                    $from_date = $leaveDetails->sdate;
                    $to_date = $leaveDetails->edate;
                    $type_display = getLeaveNameByType($new_type);
                    $reason = $leaveDetails->reason;
                    $username = $leaveDetails->username;
                    $referer = url()->current();
                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());

                    $half_day_type = '';
                    if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                        $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                    }


                    $body = "<tr>";
                    $body .= "<td>" . date('d-m-Y', strtotime($from_date)) . "</td>";
                    $body .= "<td>" . date('d-m-Y', strtotime($to_date)) . "</td>";
                    $body .= "<td>$type_display Leave $half_day_type<br>";
                    if ($leaveDetails->is_hourly == 1) {
                        $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (" . $startTime . " to " . $endTime . ")</td>";
                    } else {
                        $body .= "<br></td>";
                    }
                    $body .= "<td>$reason</td>";
                    if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        $body .= "<td>" . ucwords($new_type) . "</td>";
                    } else {
                        $body .= "<td>" . ucwords($sStatus) . "</td>";
                    }
                    $body .= "</tr>";

                    if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {

                        for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
                            $this->pendingEmailInsert($nplHRUsers[$npl_hr_i]->name, $nplHRUsers[$npl_hr_i]->employee_id, $body, $subject, $sStatus, $leaveDetails->username);
                        }
                    } else {
                        $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
                    }
                }
            }
        }
        if ($_id == '') {
            return array(
                'result' => $result,
            );
        }
    }

    public function addLeaveByApprover(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $username = $request->username;


        $approverId = $user->username;
        if ($request->hof == 1) {
            $half_day_type1 = $request->half_day_type;
            $edate = $request->leave_start_date;
        } else {
            $half_day_type1 = '';
            $edate = $request->leave_end_date;
        }
        foreach (explode(':', $request->leave_type) as $types) {
            $leavetype = $types;
            break 1;
        }
        $file = $request->file('slip_file');
        $endFileName = '';

        if (!empty($file)) {

            $file = $request->file('slip_file');
            $extension = $file->getClientOriginalExtension();
            $endFileName = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
            $filePath = 'public/upload/';

            try {
                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
            }
        }
        $type = $leavetype;
        $isHalfDay = $request->hof;
        $half_day_type = ($half_day_type1 != "") ? $half_day_type1 : "";
        $startTime = ($request->start_time != "") ? $request->start_time : "";
        $endTime = ($request->end_time != "") ? $request->end_time : "";
        $startDate = date('Y-m-d', strtotime($request->leave_start_date));
        $year = date('Y', strtotime($request->leave_start_date));
        $endDate = date('Y-m-d', strtotime($edate));
        $noDays = $request->no_of_days;
        $reason = $request->reason;
        $status = $request->status;
        $Relieve = $request->relieve;
        $filename = $endFileName;

        //echo " FIRST TYPE 1 = ".$type." <-- TYPE -- ";

        if ($approverId == "") {
            return (array("result" => false, "msg" => "Please refresh your page, before add new leaves."));
        }

        $D_year = date('Y', strtotime($request->leave_start_date));

        if ($type == "Other_pay") {
            if ($isHalfDay == '1') {
                $this->markReplacementLeaveAsTaken($username, $D_year);
            } else {
                for ($_rl_i = 0; $_rl_i < ($noDays * 2); $_rl_i++) {
                    $this->markReplacementLeaveAsTaken($username, $D_year);
                }
            }
        }
        $_added_one_at_least = false;
        $isShowClaimable = getConfirmDisplay($username);

        $groups = $this->getCountryState($username);
        $branch_cat_dept = getUserGroups($username);
        $holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0");
        $restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->leave_start_date, $request->leave_end_date, request());

        $blockdates = $this->getBlockAllDayslistByUserId($username, request());

        $appliedDays = $this->getLeaveDaysBetweenDates($username, $startDate, $endDate);
        $date1 = add_date($startDate);
        $date2 = add_date($endDate);
        $total_Emergency = 0;
        $conditional_msg = "";

        for ($index = $date1; dateDifference($date2, $index) >= 0; $index = add_date($index, 1)) {
            $new_type = $type;
            $noDays = "1";
            if ($isHalfDay == "1")
                $noDays = "0.5";

            $add_allow = false;
            if ($isHalfDay == '1') {
                if ($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $isHalfDay, $half_day_type) < 1) {
                    $add_allow = true;
                } else {
                    $add_allow = false;
                }
            } else {

                if ((!$this->isLeaveAppliedDate($index, $appliedDays))) {
                    $add_allow = true;
                } else {
                    $add_allow = false;
                }
            }

            $restday_allow_now = true;
            if (!$this->checkHolidayRestDayInclusive($username, $new_type, 'restday')) {
                if ($this->isRestDay($restdays, $index)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            if (!$this->checkHolidayRestDayInclusive($username, $new_type, 'holiday')) {
                if ($this->isHoliday($holidays, $index)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $add_allow && $blockdays_check_allow) {
                $leaveId = $this->addLeave($username, $approverId, $new_type, $isHalfDay, $startTime, $endTime, $index, $index, $noDays, $reason, $half_day_type, "Normal", $filename, $Relieve);

                $this->addLeaveDays($leaveId, $username, $index, $status);
                $_added_one_at_least = true;

                $leave_day_arr = DB::table('leave_days')->where('leave_id', $leaveId)->get();
                //$this->setStatus($leave_day_arr[0]->id, '1');
                $this->setStatuss($leave_day_arr[0]->id, '', '1', request());

                $yeararr = explode('-', $startDate);
                $year = $yeararr[0];

                $leaveDetails = $this->getLeaveDetails($leave_day_arr[0]->id);

                $SoftwareStartDate1 = DB::table('settings')->where('field', 'software_start_year')->where('company_id', $user->company_id)->first();
                $SoftwareStartDate = $SoftwareStartDate1->value ?? '';

                //echo $SoftwareStartDate."<=".($year-1)." <br />";
                if ($SoftwareStartDate <= ($year - 1)) {
                    $bfAnnual = getBFValue($year - 1, $username, $index);
                } else {
                    $bfAnnual = 0;
                }

                $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);

                if ($BFLeaveTaken > $bfAnnual) {
                    $BFLeaveTaken = $bfAnnual;
                }

                $bfAnnual = $BFLeaveTaken;
            } elseif (!$restday_allow_now) {
                $conditional_msg = "Selected Date is a Rest Day.";
            } elseif (!$holiday_check_allow) {
                $conditional_msg = "Selected Date is a Holiday.";
            }
        }
        //dd($_added_one_at_least);
        if ($_added_one_at_least) {
            $userdt = DB::table('user_personal')->where('username', $username)->first();
            $name = $userdt->name;
            $emp_id = $username;
            $sStatus = '';
            if ($status == "1")
                $sStatus = "approved";
            else if ($status == "2")
                $sStatus = "rejected";
            else if ($status == "3")
                $sStatus = "recommended";
            else if ($status == "4")
                $sStatus = "cancelled";

            $startDate = date('d F Y', strtotime($request->leave_start_date));
            $endDate = date('d F Y', strtotime($request->leave_end_date));
            $subject = "Employee " . $name . " applied for leave";
            //$body = "$name applied leave from $startDate to $endDate<br/><br/><br/>";


            $body = "Dear $name,<br><br>";
            $body .= "Your leave has been $sStatus<br><br>";
            $body .= "Details of the leave are as follows:<br><br>";
            $body .= "From: $startDate<br>";
            $body .= "To: $endDate<br><br>";
            $body .= "Reason: $reason<br><br>";
            //$body .= "Link: <a href='$referer'>$referer</a>";
            $body .= "Kind regards,<br><br>";
            $body .= "Note: this is an automatic email. Please do not reply. ";
            $body .= "If you did not request this information, please ignore this message. ";
            $body .= "If you have any questions, please contact us";

            $email_send_allow = true;
            $getEmailSendByPrefernces1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->where('company_id', $user->company_id)->first();
            $getEmailSendByPrefernces = $getEmailSendByPrefernces1->value ?? 0;
            if ($getEmailSendByPrefernces) {

                if (!hasContentPreference($leaveDetails[0]->username)) {
                    $email_send_allow = true;
                } else {
                    $email_send_allow = false;
                }
            }


            if ($email_send_allow) {
                $semail = UserPersonal::where('username', $username)->first();
                if ($semail->email_id != '')
                    // Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                    sendemail($semail->email_id, $subject, $body);
            }

            return array("result" => TRUE);
        } else {
            return array("result" => false, "msg" => $conditional_msg);
        }
    }

    public function getLeaveNameAll()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('leave_name')->where('company_id', $user->company_id)->orderBy('id', 'desc')->get();
        return $result;
    }



    public function getAllUsersForHR(Request $request)
    {
        $result = $this->getAllUsersForHR11('', request());
        $this->natsort2d($result);
        return $result;
    }

    public function getAllUsersForHR11($sorting = '', Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $approval_viewStatus = getPermissionValue("hr_view_all", $user->username);
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $result11 = DB::table('users as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as up', 'a.username', '=', 'up.username')->selectRaw("distinct b.name, b.employee_no, a.username");
        if ($request->filtername && $request->filtername != '') {
            $result11->where(function ($query) {
                $query->whereRaw('(b.name like ("' . request()->filtername . '%") OR b.username like ("' . request()->filtername . '%") OR b.employee_no like ("' . request()->filtername . '%"))');
            });
        }
        if ($sorting == "name") {
            $result11->orderByRaw("b.name + 0,b.name");
        } else {
            $result11->orderByRaw("b.employee_no + 0,b.employee_no");
        }
        if ($ActiveUserShownStatus == '1') {
            $result11->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
        } else {
            $result11->where('up.pay_status', 1);
        }
        $result11->where('a.isDeleted', 0);
        $logged_username = $user->username;
        if ($approval_viewStatus == 1) {
            $result11->where('b.username', $logged_username);
        } else if ($approval_viewStatus == 2) {
            $logged_userGroups = getUserGroups($logged_username);
            $result11->where('up.branch_id', $logged_userGroups->branch_id)->where('up.category_id', $logged_userGroups->category_id)->where('up.department_id', $logged_userGroups->department_id);
        } else if ($approval_viewStatus == 3) {
            $logged_userGroups = getUserGroups($logged_username);
            $result11->where('up.branch_id', $logged_userGroups->branch_id);
        } else if ($approval_viewStatus == 4) {
            $CurrentUserCountryState = $this->getCountryState($logged_username);
            $result11->where('b.state', $CurrentUserCountryState->state);
        }
        $result = $result11->get();
        return $result;
    }

    public function getCountryState($username)
    {

        $result1 = UserPersonal::where('username', $username)->selectRaw("nationality, state")->first();
        $result = $result1;
        return $result;
    }

    public function importDBFFile(Request $request)
    {
        $file = $request->file('fileupload');

        for ($i = 0; $i < count($file); $i++) {

            if ($file[$i] != '' && !empty($file[$i])) {

                //$file = $request[$i]->file('fileupload');
                $extension = $file[$i]->getClientOriginalExtension();
                $endFileName = $file[$i]->getClientOriginalName();
                $filePath = 'public/payrollpath/';


                try {

                    Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file[$i]));
                    // dd($endFileName);
                    $this->import($endFileName);
                } catch (\Exception $e) {
                }
            }
        }
        return redirect()->back()->with('statusMsg', 'File Upload Successfully');
    }

    public function import($filename)
    {

        $user = User::where('id', Auth::id())->first();

        $file = Storage::path('payrollpath/' . $filename);

        $table = new TableEditor($file);

        $dbfTable = array();

        while ($record = $table->nextRecord()) {
            $row = array();
            foreach ($table->getColumns() as $i => $c) {

                if ($c->getType() != 'G') {
                    $val = $record->get($c);
                    if ($val == '') {
                        $row[$c->getName()] = '0.00';
                    } else {

                        $row[$c->getName()] = $val;
                    }
                }
            }

            array_push($dbfTable, $row);
        }
        if ($filename == "pmast.dbf")
            $this->updateUserDetails($dbfTable, $user->company_id);
        else if ($filename == "branch.dbf")
            $this->updateBranchDetails($dbfTable, $user->company_id);
        else if ($filename == "category.dbf")
            $this->updateCategoryDetails($dbfTable, $user->company_id);
        else if ($filename == "dept.dbf")
            $this->updateDepartmentDetails($dbfTable, $user->company_id);
        else if ($filename == "holtable.dbf")
            $this->updateHolidayDetails($dbfTable);
        else if ($filename == "pleave.dbf")
            $this->updatePastLeaveDetails($dbfTable);
        else if ($filename == "pay_tm.dbf")
            $this->SalaryImport($dbfTable, 'N', request());
        else if ($filename == "pay_12m.dbf")
            $this->SalaryImport($dbfTable, 'Y', request());
        else if ($filename == "awtable.dbf")
            $this->importTextOfAllowance($dbfTable);
        else if ($filename == "dedtable.dbf")
            $this->importTextOfDeduction($dbfTable);
        else if ($filename == "ottable.dbf")
            $this->importTextOfOvertime($dbfTable);
        else if ($filename == "paytran.dbf")
            $this->importUserEpay($dbfTable, 'N', request());
    }

    public function importUserEpay($dbfTable, $is_past = 'N', Request $request)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            $employee_no = $dbfTable[$i]['empno'];

            if ($is_past == 'Y') {
                $month = $dbfTable[$i]['tmonth'];
            } else {
                $month = $request->epay_month;
            }

            $epay_year = $request->epay_year;

            if ($epay_year == '') {
                $epay_year = date('Y');
            }


            $basic_rate = $dbfTable[$i]['brate'];
            $basic_pay = $dbfTable[$i]['basicpay'];
            $back_pay = $dbfTable[$i]['backpay'] ?? 0;
            $compensate = $dbfTable[$i]['pampasan'];
            $compensate_tax = $dbfTable[$i]['pamtax'];
            $gratuity = $dbfTable[$i]['grant'];
            $gratuity_tax  = $dbfTable[$i]['granttax'];
            $OOB = $dbfTable[$i]['oob'];
            $work_day = $dbfTable[$i]['wday'];
            $day_work = $dbfTable[$i]['dw'];
            $PH = $dbfTable[$i]['ph'];
            $AL = $dbfTable[$i]['al'];
            $MC = $dbfTable[$i]['mc'];
            $MT = $dbfTable[$i]['mt'];
            $MR = $dbfTable[$i]['mr'];
            $PT = $dbfTable[$i]['pt'];
            $CL = $dbfTable[$i]['cl'];
            $HL = $dbfTable[$i]['hl'];
            $AD = $dbfTable[$i]['ad'];
            $EX = $dbfTable[$i]['ex'];
            $OPL = $dbfTable[$i]['opl'];
            $NPL = $dbfTable[$i]['npl'];
            $AB = $dbfTable[$i]['ab'];
            $total_monthly_over_time_pay = $dbfTable[$i]['otpay'];
            $director_fee = $dbfTable[$i]['dirfee'];
            $total_allowance = $dbfTable[$i]['taw'];
            $gross_pay = $dbfTable[$i]['grosspay'];
            $other_deduction = $dbfTable[$i]['tdedu'];
            $total_decduction = $dbfTable[$i]['tded'];
            $net_pay = $dbfTable[$i]['netpay'];
            $net_pay_adjustment = $dbfTable[$i]['netpayadj'] ?? 0;
            $total_non_pay_leave_amount = $dbfTable[$i]['nplpay'];
            $bonus = $dbfTable[$i]['bonus'] ?? 0;
            $commision = $dbfTable[$i]['comm'] ?? 0;
            $fixcommision = $dbfTable[$i]['fcomm'] ?? 0;
            $extra = $dbfTable[$i]['extra'] ?? 0;
            $tax_overtime = $dbfTable[$i]['txot'] ?? 0;
            $tax_allowance = $dbfTable[$i]['txaw'];
            $tax_deduct = $dbfTable[$i]['txded'];
            $tax_relief = $dbfTable[$i]['txrelief'];
            $amount_over_time_1 = $dbfTable[$i]['ot1'] ?? 0;
            $amount_over_time_2 = $dbfTable[$i]['ot2'] ?? 0;
            $amount_over_time_3 = $dbfTable[$i]['ot3'] ?? 0;
            $amount_over_time_4 = $dbfTable[$i]['ot4'] ?? 0;
            $amount_over_time_5 = $dbfTable[$i]['ot5'] ?? 0;
            $amount_over_time_6 = $dbfTable[$i]['ot6'] ?? 0;
            $allowance_1 = $dbfTable[$i]['aw101'];
            $allowance_2 = $dbfTable[$i]['aw102'];
            $allowance_3 = $dbfTable[$i]['aw103'];
            $allowance_4 = $dbfTable[$i]['aw104'];
            $allowance_5 = $dbfTable[$i]['aw105'];
            $allowance_6 = $dbfTable[$i]['aw106'];
            $allowance_7 = $dbfTable[$i]['aw107'];
            $allowance_8 = $dbfTable[$i]['aw108'];
            $allowance_9 = $dbfTable[$i]['aw109'];
            $allowance_10 = $dbfTable[$i]['aw110'];
            $allowance_11 = $dbfTable[$i]['aw111'];
            $allowance_12 = $dbfTable[$i]['aw112'];
            $allowance_13 = $dbfTable[$i]['aw113'];
            $allowance_14 = $dbfTable[$i]['aw114'];
            $allowance_15 = $dbfTable[$i]['aw115'];
            $allowance_16 = $dbfTable[$i]['aw116'];
            $allowance_17 = $dbfTable[$i]['aw117'];
            $deduction_1 = $dbfTable[$i]['ded101'];
            $deduction_2 = $dbfTable[$i]['ded102'];
            $deduction_3 = $dbfTable[$i]['ded103'];
            $deduction_4 = $dbfTable[$i]['ded104'];
            $deduction_5 = $dbfTable[$i]['ded105'];
            $deduction_6 = $dbfTable[$i]['ded106'];
            $deduction_7 = $dbfTable[$i]['ded107'];
            $deduction_8 = $dbfTable[$i]['ded108'];
            $deduction_9 = $dbfTable[$i]['ded109'];
            $deduction_10 = $dbfTable[$i]['ded110'];
            $deduction_11 = $dbfTable[$i]['ded111'];
            $deduction_12 = $dbfTable[$i]['ded112'];
            $deduction_13 = $dbfTable[$i]['ded113'];
            $deduction_14 = $dbfTable[$i]['ded114'];
            $deduction_15 = $dbfTable[$i]['ded115'];
            $itaxpcbb = $dbfTable[$i]['itaxpcbb'];
            $itaxpcb = $dbfTable[$i]['itaxpcb'];
            $itaxpcbadj = $dbfTable[$i]['itaxpcbadj'];
            $tp1zakat = $dbfTable[$i]['tp1zakat'];
            $tp1levy = $dbfTable[$i]['tp1levy'];
            $total_EPF_employee = $dbfTable[$i]['epfww'];
            $total_EPF_employer = $dbfTable[$i]['epfcc'];
            $epfwwext = $dbfTable[$i]['epfwwext'];
            $epfccext = $dbfTable[$i]['epfccext'];
            $epgww = $dbfTable[$i]['epgww'];
            $epgcc = $dbfTable[$i]['epgcc'];
            $soasoww = $dbfTable[$i]['soasoww'];
            $soasocc = $dbfTable[$i]['soasocc'];
            $sobsoww = $dbfTable[$i]['sobsoww'];
            $sobsocc = $dbfTable[$i]['sobsocc'];
            $total_socso_employee = $dbfTable[$i]['socsoww'];
            $total_socso_employer = $dbfTable[$i]['socsocc'];
            $sodsoww = $dbfTable[$i]['sodsoww'];
            $sodsocc = $dbfTable[$i]['sodsocc'];
            $soesoww = $dbfTable[$i]['soesoww'];
            $soesocc = $dbfTable[$i]['soesocc'];
            $unionww = $dbfTable[$i]['unionww'];
            $unioncc = $dbfTable[$i]['unioncc'];
            $ccstat1 = $dbfTable[$i]['ccstat1'];
            $pencen = $dbfTable[$i]['pencen'];
            $advance = $dbfTable[$i]['advance'];
            $bink = empty($dbfTable[$i]['bink']) ? '0.00' : $dbfTable[$i]['bink'] ?? 0;
            $mfund = empty($dbfTable[$i]['mfund']) ? '0.00' : $dbfTable[$i]['mfund'];
            $dfund = empty($dbfTable[$i]['dfund']) ? '0.00' : $dbfTable[$i]['dfund'];
            $epf_pay = $dbfTable[$i]['epf_pay'];
            $epf_pay_a = $dbfTable[$i]['epf_pay_a'];
            $bonus_amount = $dbfTable[$i]['epf_pay_b'] ?? 0;
            $commision_amount = $dbfTable[$i]['epf_pay_c'] ?? 0;
            $tawcpf = $dbfTable[$i]['tawcpf'] ?? 0;
            $tawcpfww = $dbfTable[$i]['tawcpfww'] ?? 0;
            $tawcpfcc = $dbfTable[$i]['tawcpfcc'] ?? 0;
            $hrd_pay = $dbfTable[$i]['hrd_pay'] ?? 0;
            $payyes = $dbfTable[$i]['payyes'];
            $hr1 = $dbfTable[$i]['hr1'];
            $hr2 = $dbfTable[$i]['hr2'];
            $hr3 = $dbfTable[$i]['hr3'];
            $hr4 = $dbfTable[$i]['hr4'];
            $hr5 = $dbfTable[$i]['hr5'];
            $hr6 = $dbfTable[$i]['hr6'];
            $DW = $dbfTable[$i]['dw'];
            $workhr = $dbfTable[$i]['workhr'];
            $latehr = $dbfTable[$i]['latehr'];
            $earlyhr = $dbfTable[$i]['earlyhr'];
            $nopayhr = $dbfTable[$i]['nopayhr'];
            $EISWW = $dbfTable[$i]['eisww'] ?? 0.00;
            $EISCC = $dbfTable[$i]['eiscc'] ?? 0.00;
            $rate_overtime_1 = $dbfTable[$i]['rate1'] ?? 0;
            $rate_overtime_2 = $dbfTable[$i]['rate2'] ?? 0;
            $rate_overtime_3 = $dbfTable[$i]['rate3'] ?? 0;
            $rate_overtime_4 = $dbfTable[$i]['rate4'] ?? 0;
            $rate_overtime_5 = $dbfTable[$i]['rate5'] ?? 0;
            $rate_overtime_6 = $dbfTable[$i]['rate6'] ?? 0;

            if ($payyes == '') {
                $payyes = 'N';
            }

            $data = "";
            $data = $this->getUserEPayDetailByEmp($employee_no, $month, $epay_year);


            if (count($data) <= 0) {

                $this->addUserEPay($employee_no, $month, $epay_year, $basic_rate, $work_day, $day_work, $basic_pay, $compensate, $gratuity, $compensate_tax, $gratuity_tax, $total_monthly_over_time_pay, $director_fee, $total_allowance, $gross_pay, $other_deduction, $total_decduction, $net_pay, $net_pay_adjustment, $total_non_pay_leave_amount, $bonus, $commision, $extra, $tax_overtime, $tax_allowance, $tax_deduct, $tax_relief, $amount_over_time_1, $amount_over_time_2, $amount_over_time_3, $amount_over_time_4, $amount_over_time_5, $amount_over_time_6, $allowance_1, $allowance_2, $allowance_3, $allowance_4, $allowance_5, $allowance_6, $allowance_7, $allowance_8, $allowance_9, $allowance_10, $allowance_11, $allowance_12, $allowance_13, $allowance_14, $allowance_15, $allowance_16, $allowance_17, $deduction_1, $deduction_2, $deduction_3, $deduction_4, $deduction_5, $deduction_6, $deduction_7, $deduction_8, $deduction_9, $deduction_10, $deduction_11, $deduction_12, $deduction_13, $deduction_14, $deduction_15, $itaxpcbb, $itaxpcb, $itaxpcbadj, $tp1zakat, $tp1levy, $total_EPF_employee, $total_EPF_employer, $epfwwext, $epfccext, $epgww, $epgcc, $soasoww, $soasocc, $sobsoww, $sobsocc, $total_socso_employee, $total_socso_employer, $sodsoww, $sodsocc, $soesoww, $soesocc, $unionww, $unioncc, $ccstat1, $pencen, $advance, $bink, $mfund, $dfund, $epf_pay, $epf_pay_a, $bonus_amount, $commision_amount, $tawcpf, $tawcpfww, $tawcpfcc, $hrd_pay, $payyes, $hr1, $hr2, $hr3, $hr4, $hr5, $hr6, $DW, $PH, $AL, $MC, $MT, $PT, $MR, $CL, $HL, $EX, $AD, $OPL, $NPL, $AB, $OOB, $workhr, $latehr, $earlyhr, $nopayhr, $EISWW, $EISCC, $rate_overtime_1, $rate_overtime_2, $rate_overtime_3, $rate_overtime_4, $rate_overtime_5, $rate_overtime_6, $fixcommision, $back_pay);
            } else {
                $this->updateUserEPay($employee_no, $month, $epay_year, $basic_rate, $work_day, $day_work, $basic_pay, $compensate, $gratuity, $compensate_tax, $gratuity_tax, $total_monthly_over_time_pay, $director_fee, $total_allowance, $gross_pay, $other_deduction, $total_decduction, $net_pay, $net_pay_adjustment, $total_non_pay_leave_amount, $bonus, $commision, $extra, $tax_overtime, $tax_allowance, $tax_deduct, $tax_relief, $amount_over_time_1, $amount_over_time_2, $amount_over_time_3, $amount_over_time_4, $amount_over_time_5, $amount_over_time_6, $allowance_1, $allowance_2, $allowance_3, $allowance_4, $allowance_5, $allowance_6, $allowance_7, $allowance_8, $allowance_9, $allowance_10, $allowance_11, $allowance_12, $allowance_13, $allowance_14, $allowance_15, $allowance_16, $allowance_17, $deduction_1, $deduction_2, $deduction_3, $deduction_4, $deduction_5, $deduction_6, $deduction_7, $deduction_8, $deduction_9, $deduction_10, $deduction_11, $deduction_12, $deduction_13, $deduction_14, $deduction_15, $itaxpcbb, $itaxpcb, $itaxpcbadj, $tp1zakat, $tp1levy, $total_EPF_employee, $total_EPF_employer, $epfwwext, $epfccext, $epgww, $epgcc, $soasoww, $soasocc, $sobsoww, $sobsocc, $total_socso_employee, $total_socso_employer, $sodsoww, $sodsocc, $soesoww, $soesocc, $unionww, $unioncc, $ccstat1, $pencen, $advance, $bink, $mfund, $dfund, $epf_pay, $epf_pay_a, $bonus_amount, $commision_amount, $tawcpf, $tawcpfww, $tawcpfcc, $hrd_pay, $payyes, $hr1, $hr2, $hr3, $hr4, $hr5, $hr6, $DW, $PH, $AL, $MC, $MT, $PT, $MR, $CL, $HL, $EX, $AD, $OPL, $NPL, $AB, $OOB, $workhr, $latehr, $earlyhr, $nopayhr, $EISWW, $EISCC, $rate_overtime_1, $rate_overtime_2, $rate_overtime_3, $rate_overtime_4, $rate_overtime_5, $rate_overtime_6, $fixcommision, $back_pay);
            }
        }
    }

    public function SalaryImport($dbfTable, $is_past = 'N', Request $request)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            $employee_no = $dbfTable[$i]['empno'];

            if ($is_past == 'Y') {
                $month = $dbfTable[$i]['tmonth'];
            } else {
                $month = $request->epay_month;
            }

            $epay_year = $request->epay_year;

            if ($epay_year == '') {
                $epay_year = date('Y');
            }



            $basic_rate = $dbfTable[$i]['brate'];
            $work_day = $dbfTable[$i]['wday'];
            $day_work = $dbfTable[$i]['dw'];
            $basic_pay = $dbfTable[$i]['basicpay'];
            $back_pay = $dbfTable[$i]['backpay'] ?? 0;
            $compensate = $dbfTable[$i]['pampasan'];
            $gratuity = $dbfTable[$i]['grant'];
            $compensate_tax = $dbfTable[$i]['pamtax'];
            $gratuity_tax  = $dbfTable[$i]['granttax'];
            $total_monthly_over_time_pay = $dbfTable[$i]['otpay'];
            $director_fee = $dbfTable[$i]['dirfee'];
            $total_allowance = $dbfTable[$i]['taw'];
            $gross_pay = $dbfTable[$i]['grosspay'];
            $other_deduction = $dbfTable[$i]['tdedu'];
            $total_decduction = $dbfTable[$i]['tded'];
            $net_pay = $dbfTable[$i]['netpay'];
            $net_pay_adjustment = $dbfTable[$i]['netpayadj'];
            $total_non_pay_leave_amount = $dbfTable[$i]['nplpay'];
            $bonus = $dbfTable[$i]['bonus'];
            $commision = $dbfTable[$i]['comm'];
            $fixcommision = $dbfTable[$i]['fcomm'] ?? 0;
            $extra = $dbfTable[$i]['extra'];
            $tax_overtime = $dbfTable[$i]['txot'];
            $tax_allowance = $dbfTable[$i]['txaw'];
            $tax_deduct = $dbfTable[$i]['txded'];
            $tax_relief = $dbfTable[$i]['txrelief'];
            $amount_over_time_1 = $dbfTable[$i]['ot1'];
            $amount_over_time_2 = $dbfTable[$i]['ot2'];
            $amount_over_time_3 = $dbfTable[$i]['ot3'];
            $amount_over_time_4 = $dbfTable[$i]['ot4'];
            $amount_over_time_5 = $dbfTable[$i]['ot5'];
            $amount_over_time_6 = $dbfTable[$i]['ot6'];
            $allowance_1 = $dbfTable[$i]['aw101'];
            $allowance_2 = $dbfTable[$i]['aw102'];
            $allowance_3 = $dbfTable[$i]['aw103'];
            $allowance_4 = $dbfTable[$i]['aw104'];
            $allowance_5 = $dbfTable[$i]['aw105'];
            $allowance_6 = $dbfTable[$i]['aw106'];
            $allowance_7 = $dbfTable[$i]['aw107'];
            $allowance_8 = $dbfTable[$i]['aw108'];
            $allowance_9 = $dbfTable[$i]['aw109'];
            $allowance_10 = $dbfTable[$i]['aw110'];
            $allowance_11 = $dbfTable[$i]['aw111'];
            $allowance_12 = $dbfTable[$i]['aw112'];
            $allowance_13 = $dbfTable[$i]['aw113'];
            $allowance_14 = $dbfTable[$i]['aw114'];
            $allowance_15 = $dbfTable[$i]['aw115'];
            $allowance_16 = $dbfTable[$i]['aw116'];
            $allowance_17 = $dbfTable[$i]['aw117'];
            $deduction_1 = $dbfTable[$i]['ded101'];
            $deduction_2 = $dbfTable[$i]['ded102'];
            $deduction_3 = $dbfTable[$i]['ded103'];
            $deduction_4 = $dbfTable[$i]['ded104'];
            $deduction_5 = $dbfTable[$i]['ded105'];
            $deduction_6 = $dbfTable[$i]['ded106'];
            $deduction_7 = $dbfTable[$i]['ded107'];
            $deduction_8 = $dbfTable[$i]['ded108'];
            $deduction_9 = $dbfTable[$i]['ded109'];
            $deduction_10 = $dbfTable[$i]['ded110'];
            $deduction_11 = $dbfTable[$i]['ded111'];
            $deduction_12 = $dbfTable[$i]['ded112'];
            $deduction_13 = $dbfTable[$i]['ded113'];
            $deduction_14 = $dbfTable[$i]['ded114'];
            $deduction_15 = $dbfTable[$i]['ded115'];
            $itaxpcbb = $dbfTable[$i]['itaxpcbb'];
            $itaxpcb = $dbfTable[$i]['itaxpcb'];
            $itaxpcbadj = $dbfTable[$i]['itaxpcbadj'];
            $tp1zakat = $dbfTable[$i]['tp1zakat'];
            $tp1levy = $dbfTable[$i]['tp1levy'];
            $total_EPF_employee = $dbfTable[$i]['epfww'];
            $total_EPF_employer = $dbfTable[$i]['epfcc'];
            $epfwwext = $dbfTable[$i]['epfwwext'];
            $epfccext = $dbfTable[$i]['epfccext'];
            $epgww = $dbfTable[$i]['epgww'];
            $epgcc = $dbfTable[$i]['epgcc'];
            $soasoww = $dbfTable[$i]['soasoww'];
            $soasocc = $dbfTable[$i]['soasocc'];
            $sobsoww = $dbfTable[$i]['sobsoww'];
            $sobsocc = $dbfTable[$i]['sobsocc'];
            $total_socso_employee = $dbfTable[$i]['socsoww'];
            $total_socso_employer = $dbfTable[$i]['socsocc'];
            $sodsoww = $dbfTable[$i]['sodsoww'];
            $sodsocc = $dbfTable[$i]['sodsocc'];
            $soesoww = $dbfTable[$i]['soesoww'];
            $soesocc = $dbfTable[$i]['soesocc'];
            $unionww = $dbfTable[$i]['unionww'];
            $unioncc = $dbfTable[$i]['unioncc'];
            $ccstat1 = $dbfTable[$i]['ccstat1'];
            $pencen = $dbfTable[$i]['pencen'];
            $advance = $dbfTable[$i]['advance'];
            $bink = empty($dbfTable[$i]['bink']) ? '0.00' : $dbfTable[$i]['bink'];
            $mfund = empty($dbfTable[$i]['mfund']) ? '0.00' : $dbfTable[$i]['mfund'];
            $dfund = empty($dbfTable[$i]['dfund']) ? '0.00' : $dbfTable[$i]['dfund'];
            $epf_pay = $dbfTable[$i]['epf_pay'];
            $epf_pay_a = $dbfTable[$i]['epf_pay_a'];
            $bonus_amount = $dbfTable[$i]['epf_pay_b'];
            $commision_amount = $dbfTable[$i]['epf_pay_c'];
            $tawcpf = $dbfTable[$i]['tawcpf'];
            $tawcpfww = $dbfTable[$i]['tawcpfww'];
            $tawcpfcc = $dbfTable[$i]['tawcpfcc'];
            $hrd_pay = $dbfTable[$i]['hrd_pay'];
            $payyes = $dbfTable[$i]['payyes'];
            $hr1 = $dbfTable[$i]['hr1'];
            $hr2 = $dbfTable[$i]['hr2'];
            $hr3 = $dbfTable[$i]['hr3'];
            $hr4 = $dbfTable[$i]['hr4'];
            $hr5 = $dbfTable[$i]['hr5'];
            $hr6 = $dbfTable[$i]['hr6'];
            $DW = $dbfTable[$i]['dw'];
            $PH = $dbfTable[$i]['ph'];
            $AL = $dbfTable[$i]['al'];
            $MC = $dbfTable[$i]['mc'];
            $MT = $dbfTable[$i]['mt'];
            $PT = $dbfTable[$i]['pt'];
            $MR = $dbfTable[$i]['mr'];
            $CL = $dbfTable[$i]['cl'];
            $HL = $dbfTable[$i]['hl'];
            $EX = $dbfTable[$i]['ex'];
            $AD = $dbfTable[$i]['ad'];
            $OPL = $dbfTable[$i]['opl'];
            $NPL = $dbfTable[$i]['npl'];
            $AB = $dbfTable[$i]['ab'];
            $OOB = $dbfTable[$i]['oob'];
            $workhr = $dbfTable[$i]['workhr'];
            $latehr = $dbfTable[$i]['latehr'];
            $earlyhr = $dbfTable[$i]['earlyhr'];
            $nopayhr = $dbfTable[$i]['nopayhr'];
            $EISWW = $dbfTable[$i]['eisww'] ?? 0.00;
            $EISCC = $dbfTable[$i]['eiscc'] ?? 0.00;
            $rate_overtime_1 = $dbfTable[$i]['rate1'] ?? 0;
            $rate_overtime_2 = $dbfTable[$i]['rate2'] ?? 0;
            $rate_overtime_3 = $dbfTable[$i]['rate3'] ?? 0;
            $rate_overtime_4 = $dbfTable[$i]['rate4'] ?? 0;
            $rate_overtime_5 = $dbfTable[$i]['rate5'] ?? 0;
            $rate_overtime_6 = $dbfTable[$i]['rate6'] ?? 0;

            if ($payyes == '') {
                $payyes = 'N';
            }

            $data = "";
            $data = $this->getUserEPayDetailByEmp($employee_no, $month, $epay_year);


            if (count($data) <= 0) {

                $this->addUserEPay($employee_no, $month, $epay_year, $basic_rate, $work_day, $day_work, $basic_pay, $compensate, $gratuity, $compensate_tax, $gratuity_tax, $total_monthly_over_time_pay, $director_fee, $total_allowance, $gross_pay, $other_deduction, $total_decduction, $net_pay, $net_pay_adjustment, $total_non_pay_leave_amount, $bonus, $commision, $extra, $tax_overtime, $tax_allowance, $tax_deduct, $tax_relief, $amount_over_time_1, $amount_over_time_2, $amount_over_time_3, $amount_over_time_4, $amount_over_time_5, $amount_over_time_6, $allowance_1, $allowance_2, $allowance_3, $allowance_4, $allowance_5, $allowance_6, $allowance_7, $allowance_8, $allowance_9, $allowance_10, $allowance_11, $allowance_12, $allowance_13, $allowance_14, $allowance_15, $allowance_16, $allowance_17, $deduction_1, $deduction_2, $deduction_3, $deduction_4, $deduction_5, $deduction_6, $deduction_7, $deduction_8, $deduction_9, $deduction_10, $deduction_11, $deduction_12, $deduction_13, $deduction_14, $deduction_15, $itaxpcbb, $itaxpcb, $itaxpcbadj, $tp1zakat, $tp1levy, $total_EPF_employee, $total_EPF_employer, $epfwwext, $epfccext, $epgww, $epgcc, $soasoww, $soasocc, $sobsoww, $sobsocc, $total_socso_employee, $total_socso_employer, $sodsoww, $sodsocc, $soesoww, $soesocc, $unionww, $unioncc, $ccstat1, $pencen, $advance, $bink, $mfund, $dfund, $epf_pay, $epf_pay_a, $bonus_amount, $commision_amount, $tawcpf, $tawcpfww, $tawcpfcc, $hrd_pay, $payyes, $hr1, $hr2, $hr3, $hr4, $hr5, $hr6, $DW, $PH, $AL, $MC, $MT, $PT, $MR, $CL, $HL, $EX, $AD, $OPL, $NPL, $AB, $OOB, $workhr, $latehr, $earlyhr, $nopayhr, $EISWW, $EISCC, $rate_overtime_1, $rate_overtime_2, $rate_overtime_3, $rate_overtime_4, $rate_overtime_5, $rate_overtime_6, $fixcommision, $back_pay);
            } else {
                $this->updateUserEPay($employee_no, $month, $epay_year, $basic_rate, $work_day, $day_work, $basic_pay, $compensate, $gratuity, $compensate_tax, $gratuity_tax, $total_monthly_over_time_pay, $director_fee, $total_allowance, $gross_pay, $other_deduction, $total_decduction, $net_pay, $net_pay_adjustment, $total_non_pay_leave_amount, $bonus, $commision, $extra, $tax_overtime, $tax_allowance, $tax_deduct, $tax_relief, $amount_over_time_1, $amount_over_time_2, $amount_over_time_3, $amount_over_time_4, $amount_over_time_5, $amount_over_time_6, $allowance_1, $allowance_2, $allowance_3, $allowance_4, $allowance_5, $allowance_6, $allowance_7, $allowance_8, $allowance_9, $allowance_10, $allowance_11, $allowance_12, $allowance_13, $allowance_14, $allowance_15, $allowance_16, $allowance_17, $deduction_1, $deduction_2, $deduction_3, $deduction_4, $deduction_5, $deduction_6, $deduction_7, $deduction_8, $deduction_9, $deduction_10, $deduction_11, $deduction_12, $deduction_13, $deduction_14, $deduction_15, $itaxpcbb, $itaxpcb, $itaxpcbadj, $tp1zakat, $tp1levy, $total_EPF_employee, $total_EPF_employer, $epfwwext, $epfccext, $epgww, $epgcc, $soasoww, $soasocc, $sobsoww, $sobsocc, $total_socso_employee, $total_socso_employer, $sodsoww, $sodsocc, $soesoww, $soesocc, $unionww, $unioncc, $ccstat1, $pencen, $advance, $bink, $mfund, $dfund, $epf_pay, $epf_pay_a, $bonus_amount, $commision_amount, $tawcpf, $tawcpfww, $tawcpfcc, $hrd_pay, $payyes, $hr1, $hr2, $hr3, $hr4, $hr5, $hr6, $DW, $PH, $AL, $MC, $MT, $PT, $MR, $CL, $HL, $EX, $AD, $OPL, $NPL, $AB, $OOB, $workhr, $latehr, $earlyhr, $nopayhr, $EISWW, $EISCC, $rate_overtime_1, $rate_overtime_2, $rate_overtime_3, $rate_overtime_4, $rate_overtime_5, $rate_overtime_6, $fixcommision, $back_pay);
            }
        }
    }

    public function importTextOfAllowance($dbfTable)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            $this->updateFieldValue("allowance_" . ($i + 1), $dbfTable[$i]['aw_desp']);
        }
    }

    public function importTextOfDeduction($dbfTable)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            $this->updateFieldValue("deduction_" . ($i + 1), $dbfTable[$i]['ded_desp']);
        }
    }
    public function importTextOfOvertime($dbfTable)
    {
        //$ad = new DB_Allowance_Deduction();
        for ($i = 0; $i < count($dbfTable); $i++) {
            if ($this->exist_field("overtime_" . ($i + 1))) {
                $this->updateFieldValue("overtime_" . ($i + 1), $dbfTable[$i]['ot_desp']);
            } else {
                $this->addFieldValue("overtime_" . ($i + 1), $dbfTable[$i]['ot_desp']);
            }
        }
    }



    public function updateFieldValue($field, $values)
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('allowance_deduction')->where('field_name', $field)->where('company_id', $user->company_id)->update(array('field_value' => $values));
        return true;
    }
    public function addFieldValue($field, $values)
    {
        $user = User::where('id', Auth::id())->first();
        DB::table('allowance_deduction')->insert(array('field_name' => $field, 'field_value' => $values, 'company_id' => $user->company_id));
        return true;
    }

    public function exist_field($field)
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('allowance_deduction')->where('field_name', $field)->where('company_id', $user->company_id)->get();
        if (count($result) > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function getUserEPayDetailByEmp($empNo, $month, $epay_year)
    {

        $result = DB::table('user_epay')->where('employee_no', $empNo)->where('month', $month)->where('epay_year', $epay_year)->get();
        return $result;
    }

    public function addUserEPay(
        $employee_no,
        $month,
        $epay_year,
        $basic_rate,
        $work_day,
        $day_work,
        $basic_pay,
        $compensate,
        $gratuity,
        $compensate_tax,
        $gratuity_tax,
        $total_monthly_over_time_pay,
        $director_fee,
        $total_allowance,
        $gross_pay,
        $other_deduction,
        $total_decduction,
        $net_pay,
        $net_pay_adjustment,
        $total_non_pay_leave_amount,
        $bonus,
        $commision,
        $extra,
        $tax_overtime,
        $tax_allowance,
        $tax_deduct,
        $tax_relief,
        $amount_over_time_1,
        $amount_over_time_2,
        $amount_over_time_3,
        $amount_over_time_4,
        $amount_over_time_5,
        $amount_over_time_6,
        $allowance_1,
        $allowance_2,
        $allowance_3,
        $allowance_4,
        $allowance_5,
        $allowance_6,
        $allowance_7,
        $allowance_8,
        $allowance_9,
        $allowance_10,
        $allowance_11,
        $allowance_12,
        $allowance_13,
        $allowance_14,
        $allowance_15,
        $allowance_16,
        $allowance_17,
        $deduction_1,
        $deduction_2,
        $deduction_3,
        $deduction_4,
        $deduction_5,
        $deduction_6,
        $deduction_7,
        $deduction_8,
        $deduction_9,
        $deduction_10,
        $deduction_11,
        $deduction_12,
        $deduction_13,
        $deduction_14,
        $deduction_15,
        $itaxpcbb,
        $itaxpcb,
        $itaxpcbadj,
        $tp1zakat,
        $tp1levy,
        $total_EPF_employee,
        $total_EPF_employer,
        $epfwwext,
        $epfccext,
        $epgww,
        $epgcc,
        $soasoww,
        $soasocc,
        $sobsoww,
        $sobsocc,
        $total_socso_employee,
        $total_socso_employer,
        $sodsoww,
        $sodsocc,
        $soesoww,
        $soesocc,
        $unionww,
        $unioncc,
        $ccstat1,
        $pencen,
        $advance,
        $bink,
        $mfund,
        $dfund,
        $epf_pay,
        $epf_pay_a,
        $bonus_amount,
        $commision_amount,
        $tawcpf,
        $tawcpfww,
        $tawcpfcc,
        $hrd_pay,
        $payyes,
        $hr1,
        $hr2,
        $hr3,
        $hr4,
        $hr5,
        $hr6,
        $DW,
        $PH,
        $AL,
        $MC,
        $MT,
        $PT,
        $MR,
        $CL,
        $HL,
        $EX,
        $AD,
        $OPL,
        $NPL,
        $AB,
        $OOB,
        $workhr,
        $latehr,
        $earlyhr,
        $nopayhr,
        $EISWW,
        $EISCC,
        $rate_overtime_1,
        $rate_overtime_2,
        $rate_overtime_3,
        $rate_overtime_4,
        $rate_overtime_5,
        $rate_overtime_6,
        $fixcommision,
        $back_pay
    ) {

        $query = 'insert into `user_epay`(`employee_no`,`month`,`epay_year`,`basic_rate`,`work_day`,`day_work`,`basic_pay`,`compensate`,`gratuity`,`compensate_tax`,`gratuity_tax`,`total_monthly_over_time_pay`,`director_fee`,`total_allowance`,`gross_pay`,`other_deduction`,`total_decduction`,`net_pay`,`net_paynet_pay_adjustment`,`total_non_pay_leave_amount`,`bonus`,`commision`,`fix_commision`,`extra`,`tax_overtime`,`tax_allowance`,`tax_deduct`,`tax_relief`,`amount_over_time_1`,`amount_over_time_2`,`amount_over_time_3`,`amount_over_time_4`,`amount_over_time_5`,`amount_over_time_6`,`rate_over_time_1`,`rate_over_time_2`,`rate_over_time_3`,`rate_over_time_4`,`rate_over_time_5`,`rate_over_time_6`,`allowance_1`,`allowance_2`,`allowance_3`,`allowance_4`,`allowance_5`,`allowance_6`,`allowance_7`,`allowance_8`,`allowance_9`,`allowance_10`,`allowance_11`,`allowance_12`,`allowance_13`,`allowance_14`,`allowance_15`,`allowance_16`,`allowance_17`,`deduction_1`,`deduction_2`,`deduction_3`,`deduction_4`,`deduction_5`,`deduction_6`,`deduction_7`,`deduction_8`,`deduction_9`,`deduction_10`,`deduction_11`,`deduction_12`,`deduction_13`,`deduction_14`,`deduction_15`,`itaxpcbb`,`itaxpcb`,`itaxpcbadj`,`tp1zakat`,`tp1levy`,`total_EPF_employee`,`total_EPF_employer`,`epfwwext`,`epfccext`,`epgww`,`epgcc`,`soasoww`,`soasocc`,`sobsoww`,`sobsocc`,`total_socso_employee`,`total_socso_employer`,`sodsoww`,`sodsocc`,`soesoww`,`soesocc`,`unionww`,`unioncc`,`ccstat1`,`pencen`,`advance`,`bink`,`mfund`,`dfund`,`epf_pay`,`epf_pay_a`,`bonus_amount`,`commision_amount`,`tawcpf`,`tawcpfww`,`tawcpfcc`,`hrd_pay`,`payyes`,`hr1`,`hr2`,`hr3`,`hr4`,`hr5`,`hr6`, `DW`,`PH`,`AL`,`MC`,`MT`,`PT`,`MR`,`CL`,`HL`,`EX`,`AD`,`OPL`,`NPL`,`AB`,`OOB`,`workhr`,`latehr`,`earlyhr`,`nopayhr`,`Eisww`,`Eiscc`,`back_pay`) values ( "' . $employee_no . '", "' . $month . '", "' . $epay_year . '", "' . $basic_rate . '", "' . $work_day . '", "' . $day_work . '", "' . $basic_pay . '", "' . $compensate . '", "' . $gratuity . '", "' . $compensate_tax . '","' . $gratuity_tax . '", "' . $total_monthly_over_time_pay . '", "' . $director_fee . '", "' . $total_allowance . '", "' . $gross_pay . '", "' . $other_deduction . '", "' . $total_decduction . '", "' . $net_pay . '","' . $net_pay_adjustment . '", "' . $total_non_pay_leave_amount . '", "' . $bonus . '", "' . $commision . '","' . $fixcommision . '", "' . $extra . '", "' . $tax_overtime . '", "' . $tax_allowance . '", "' . $tax_deduct . '","' . $tax_relief . '", "' . $amount_over_time_1 . '", "' . $amount_over_time_2 . '", "' . $amount_over_time_3 . '", "' . $amount_over_time_4 . '", "' . $amount_over_time_5 . '", "' . $amount_over_time_6 . '","' . $rate_overtime_1 . '","' . $rate_overtime_2 . '","' . $rate_overtime_3 . '","' . $rate_overtime_4 . '","' . $rate_overtime_5 . '","' . $rate_overtime_6 . '","' . $allowance_1 . '", "' . $allowance_2 . '", "' . $allowance_3 . '", "' . $allowance_4 . '", "' . $allowance_5 . '", "' . $allowance_6 . '", "' . $allowance_7 . '", "' . $allowance_8 . '", "' . $allowance_9 . '", "' . $allowance_10 . '", "' . $allowance_11 . '","' . $allowance_12 . '", "' . $allowance_13 . '", "' . $allowance_14 . '", "' . $allowance_15 . '", "' . $allowance_16 . '", "' . $allowance_17 . '", "' . $deduction_1 . '", "' . $deduction_2 . '", "' . $deduction_3 . '", "' . $deduction_4 . '","' . $deduction_5 . '", "' . $deduction_6 . '", "' . $deduction_7 . '", "' . $deduction_8 . '", "' . $deduction_9 . '", "' . $deduction_10 . '", "' . $deduction_11 . '", "' . $deduction_12 . '", "' . $deduction_13 . '", "' . $deduction_14 . '", "' . $deduction_15 . '", "' . $itaxpcbb . '", "' . $itaxpcb . '", "' . $itaxpcbadj . '", "' . $tp1zakat . '", "' . $tp1levy . '", "' . $total_EPF_employee . '", "' . $total_EPF_employer . '", "' . $epfwwext . '", "' . $epfccext . '", "' . $epgww . '", "' . $epgcc . '","' . $soasoww . '", "' . $soasocc . '", "' . $sobsoww . '", "' . $sobsocc . '", "' . $total_socso_employee . '", "' . $total_socso_employer . '", "' . $sodsoww . '", "' . $sodsocc . '", "' . $soesoww . '", "' . $soesocc . '", "' . $unionww . '", "' . $unioncc . '","' . $ccstat1 . '", "' . $pencen . '", "' . $advance . '", "' . $bink . '", "' . $mfund . '", "' . $dfund . '", "' . $epf_pay . '", "' . $epf_pay_a . '", "' . $bonus_amount . '", "' . $commision_amount . '", "' . $tawcpf . '", "' . $tawcpfww . '", "' . $tawcpfcc . '", "' . $hrd_pay . '", "' . $payyes . '","' . $hr1 . '","' . $hr2 . '","' . $hr3 . '","' . $hr4 . '","' . $hr5 . '","' . $hr6 . '", "' . $DW . '","' . $PH . '","' . $AL . '","' . $MC . '","' . $MT . '","' . $PT . '","' . $MR . '","' . $CL . '","' . $HL . '","' . $EX . '","' . $AD . '","' . $OPL . '","' . $NPL . '","' . $AB . '","' . $OOB . '","' . $workhr . '","' . $latehr . '","' . $earlyhr . '","' . $nopayhr . '","' . $EISWW . '","' . $EISCC . '","' . $back_pay . '")';
        //dd($query);
        $result = DB::select($query);

        // $result = DB::table('user_epay')->insert(array('employee_no' => $employee_no,'month' => $month,'epay_year' => $epay_year,'basic_rate' => $basic_rate,'work_day'=>$work_day,'day_work'=>$day_work,'basic_pay' => $basic_pay,'compensate' => $compensate,'gratuity' => $gratuity,'compensate_tax'=>$compensate_tax,'gratuity_tax'=>$gratuity_tax,'total_monthly_over_time_pay' => $total_monthly_over_time_pay,'director_fee' => $director_fee,'total_allowance' => $total_allowance,'gross_pay'=>$gross_pay,'other_deduction'=>$other_deduction,'total_decduction' => $total_decduction,'net_pay' => $net_pay,'net_pay_adjustment' => $net_pay_adjustment,'total_non_pay_leave_amount'=>$total_non_pay_leave_amount,'bonus'=>$bonus,'commision' => $commision,'extra' => $extra,'tax_overtime' => $tax_overtime,'tax_allowance'=>$tax_allowance,'tax_deduct'=>$tax_deduct,'tax_relief' => $tax_relief,'amount_over_time_1' => $amount_over_time_1,'amount_over_time_2' => $amount_over_time_2,'amount_over_time_3'=>$amount_over_time_3,'amount_over_time_4'=>$amount_over_time_4,'amount_over_time_5' => $amount_over_time_5,'amount_over_time_6' => $amount_over_time_6,'allowance_1' => $allowance_1,'allowance_2'=>$allowance_2,'allowance_3'=>$allowance_3,'allowance_4' => $allowance_4,'allowance_5' => $allowance_5,'allowance_6' => $allowance_6,'allowance_7'=>$allowance_7,'allowance_8'=>$allowance_8,'allowance_9' => $allowance_9,'allowance_10' => $allowance_10,'allowance_11' => $allowance_11,'allowance_12'=>$allowance_12,'allowance_13'=>$allowance_13,'allowance_14' => $allowance_14,'allowance_15' => $allowance_15,'allowance_16' => $allowance_16,'allowance_17'=>$allowance_17,'deduction_1'=>$deduction_1,'deduction_2' => $deduction_2,'deduction_3' => $deduction_3,'deduction_4' => $deduction_4,'deduction_5'=>$deduction_5,'deduction_6'=>$deduction_6,'deduction_7' => $deduction_7,'deduction_8' => $deduction_8,'deduction_9' => $deduction_9,'deduction_10'=>$deduction_10,'deduction_11'=>$deduction_11,'deduction_12' => $deduction_12,'deduction_13' => $deduction_13,'deduction_14' => $deduction_14,'deduction_15'=>$deduction_15,'itaxpcbb'=>$itaxpcbb,'itaxpcb' => $itaxpcb,'itaxpcbadj' => $itaxpcbadj,'tp1zakat' => $tp1zakat,'tp1levy'=>$tp1levy,'total_EPF_employee'=>$total_EPF_employee,'epfwwext' => $epfwwext,'epfccext'=>$epfccext,'epgww'=>$epgww,'epgcc' => $epgcc,'soasoww' => $soasoww,'soasocc' => $soasocc,'sobsoww'=>$sobsoww,'sobsocc'=>$sobsocc,'total_socso_employee' => $total_socso_employee,'total_socso_employer' => $total_socso_employer,'sodsoww' => $sodsoww,'sodsocc'=>$sodsocc,'soesoww'=>$soesoww,'soesocc' => $soesocc,'unionww' => $unionww,'unioncc' => $unioncc,'ccstat1'=>$ccstat1,'pencen'=>$pencen,'advance'=>$advance,'bink'=>$bink,'mfund'=>$mfund,'dfund'=>$dfund,'epf_pay'=>$epf_pay,'epf_pay_a'=>$epf_pay_a,'bonus_amount'=>$bonus_amount,'commision_amount'=>$commision_amount,'tawcpf'=>$tawcpf,'tawcpfww'=>$tawcpfww,'tawcpfcc'=>$tawcpfcc,'hrd_pay'=>$hrd_pay,'payyes'=>$payyes,'hr1'=>$hr1,'hr2'=>$hr2,'hr3'=>$hr3,'hr4'=>$hr4,'hr5'=>$hr5,'hr6'=>$hr6,'DW'=>$DW,'PH'=>$PH,'AL'=>$AL,'MC'=>$MC,'MT'=>$MT,'PT'=>$PT,'MR'=>$MR,'CL'=>$CL,'HL'=>$HL,'EX'=>$EX,'AD'=>$AD,'OPL'=>$OPL,'NPL'=>$NPL,'AB'=>$AB,'OOB'=>$OOB,'workhr'=>$workhr,'latehr'=>$latehr,'earlyhr'=>$earlyhr,'nopayhr'=>$nopayhr,'EISWW'=>$EISWW,'EISCC'=>$EISCC));

        return true;
    }

    public function updateUserEPay(
        $employee_no,
        $month,
        $epay_year,
        $basic_rate,
        $work_day,
        $day_work,
        $basic_pay,
        $compensate,
        $gratuity,
        $compensate_tax,
        $gratuity_tax,
        $total_monthly_over_time_pay,
        $director_fee,
        $total_allowance,
        $gross_pay,
        $other_deduction,
        $total_decduction,
        $net_pay,
        $net_pay_adjustment,
        $total_non_pay_leave_amount,
        $bonus,
        $commision,
        $extra,
        $tax_overtime,
        $tax_allowance,
        $tax_deduct,
        $tax_relief,
        $amount_over_time_1,
        $amount_over_time_2,
        $amount_over_time_3,
        $amount_over_time_4,
        $amount_over_time_5,
        $amount_over_time_6,
        $allowance_1,
        $allowance_2,
        $allowance_3,
        $allowance_4,
        $allowance_5,
        $allowance_6,
        $allowance_7,
        $allowance_8,
        $allowance_9,
        $allowance_10,
        $allowance_11,
        $allowance_12,
        $allowance_13,
        $allowance_14,
        $allowance_15,
        $allowance_16,
        $allowance_17,
        $deduction_1,
        $deduction_2,
        $deduction_3,
        $deduction_4,
        $deduction_5,
        $deduction_6,
        $deduction_7,
        $deduction_8,
        $deduction_9,
        $deduction_10,
        $deduction_11,
        $deduction_12,
        $deduction_13,
        $deduction_14,
        $deduction_15,
        $itaxpcbb,
        $itaxpcb,
        $itaxpcbadj,
        $tp1zakat,
        $tp1levy,
        $total_EPF_employee,
        $total_EPF_employer,
        $epfwwext,
        $epfccext,
        $epgww,
        $epgcc,
        $soasoww,
        $soasocc,
        $sobsoww,
        $sobsocc,
        $total_socso_employee,
        $total_socso_employer,
        $sodsoww,
        $sodsocc,
        $soesoww,
        $soesocc,
        $unionww,
        $unioncc,
        $ccstat1,
        $pencen,
        $advance,
        $bink,
        $mfund,
        $dfund,
        $epf_pay,
        $epf_pay_a,
        $bonus_amount,
        $commision_amount,
        $tawcpf,
        $tawcpfww,
        $tawcpfcc,
        $hrd_pay,
        $payyes,
        $hr1,
        $hr2,
        $hr3,
        $hr4,
        $hr5,
        $hr6,
        $DW,
        $PH,
        $AL,
        $MC,
        $MT,
        $PT,
        $MR,
        $CL,
        $HL,
        $EX,
        $AD,
        $OPL,
        $NPL,
        $AB,
        $OOB,
        $workhr,
        $latehr,
        $earlyhr,
        $nopayhr,
        $EISWW,
        $EISCC,
        $rate_overtime_1,
        $rate_overtime_2,
        $rate_overtime_3,
        $rate_overtime_4,
        $rate_overtime_5,
        $rate_overtime_6,
        $fixcommision,
        $back_pay
    ) {

        $query = 'update `user_epay` set `employee_no`="' . $employee_no . '",`month`="' . $month . '",`epay_year`="' . $epay_year . '",`basic_rate`="' . $basic_rate . '",`work_day`="' . $work_day . '",`day_work`="' . $day_work . '",`basic_pay`="' . $basic_pay . '",`compensate`="' . $compensate . '",`gratuity`="' . $gratuity . '",`compensate_tax`="' . $compensate_tax . '" ,`gratuity_tax`="' . $gratuity_tax . '",`total_monthly_over_time_pay`="' . $total_monthly_over_time_pay . '",`director_fee`="' . $director_fee . '",`total_allowance`="' . $total_allowance . '",`gross_pay`="' . $gross_pay . '",`other_deduction`="' . $other_deduction . '",`total_decduction`="' . $total_decduction . '",`net_pay`="' . $net_pay . '",`net_paynet_pay_adjustment`="' . $net_pay_adjustment . '",`total_non_pay_leave_amount`="' . $total_non_pay_leave_amount . '",`bonus`="' . $bonus . '",`commision`="' . $commision . '",`fix_commision`="' . $fixcommision . '",`extra`="' . $extra . '",`tax_overtime`="' . $tax_overtime . '",`tax_allowance`="' . $tax_allowance . '", `tax_deduct`="' . $tax_deduct . '",`tax_relief`="' . $tax_relief . '",`amount_over_time_1`="' . $amount_over_time_1 . '",`amount_over_time_2`="' . $amount_over_time_2 . '",`amount_over_time_3`="' . $amount_over_time_3 . '",`amount_over_time_4`="' . $amount_over_time_4 . '",`amount_over_time_5`="' . $amount_over_time_5 . '", `amount_over_time_6`="' . $amount_over_time_6 . '",`rate_over_time_1`="' . $rate_overtime_1 . '",`rate_over_time_2`="' . $rate_overtime_2 . '",`rate_over_time_3`="' . $rate_overtime_3 . '",`rate_over_time_4`="' . $rate_overtime_4 . '",`rate_over_time_5`="' . $rate_overtime_5 . '",`rate_over_time_6`="' . $rate_overtime_6 . '",`allowance_1`="' . $allowance_1 . '",`allowance_2`="' . $allowance_2 . '",`allowance_3`="' . $allowance_3 . '",`allowance_4`="' . $allowance_4 . '",`allowance_5`="' . $allowance_5 . '",`allowance_6`="' . $allowance_6 . '",`allowance_7`="' . $allowance_7 . '", `allowance_8`="' . $allowance_8 . '",`allowance_9`="' . $allowance_9 . '",`allowance_10`="' . $allowance_10 . '",`allowance_11`="' . $allowance_11 . '",`allowance_12`="' . $allowance_12 . '",`allowance_13`="' . $allowance_13 . '",`allowance_14`="' . $allowance_14 . '",`allowance_15`="' . $allowance_15 . '", `allowance_16`="' . $allowance_16 . '",`allowance_17`="' . $allowance_17 . '",`deduction_1`="' . $deduction_1 . '",`deduction_2`="' . $deduction_2 . '",`deduction_3`="' . $deduction_3 . '",`deduction_4`="' . $deduction_4 . '",`deduction_5`="' . $deduction_5 . '",`deduction_6`="' . $deduction_6 . '", `deduction_7`="' . $deduction_7 . '",`deduction_8`="' . $deduction_8 . '",`deduction_9`="' . $deduction_9 . '",`deduction_10`="' . $deduction_10 . '",`deduction_11`="' . $deduction_11 . '",`deduction_12`="' . $deduction_12 . '",`deduction_13`="' . $deduction_13 . '",`deduction_14`="' . $deduction_14 . '", `deduction_15`="' . $deduction_15 . '",`itaxpcbb`="' . $itaxpcbb . '",`itaxpcb`="' . $itaxpcb . '",`itaxpcbadj`="' . $itaxpcbadj . '",`tp1zakat`="' . $tp1zakat . '",`tp1levy`="' . $tp1levy . '",`total_EPF_employee`="' . $total_EPF_employee . '",`total_EPF_employer`="' . $total_EPF_employer . '", `epfwwext`="' . $epfwwext . '",`epfccext`="' . $epfccext . '",`epgww`="' . $epgww . '",`epgcc`="' . $epgcc . '",`soasoww`="' . $soasoww . '",`soasocc`="' . $soasocc . '",`sobsoww`="' . $sobsoww . '",`sobsocc`="' . $sobsocc . '",`total_socso_employee`="' . $total_socso_employee . '", `total_socso_employer`="' . $total_socso_employer . '",`sodsoww`="' . $sodsoww . '",`sodsocc`="' . $sodsocc . '",`soesoww`="' . $soesoww . '",`soesocc`="' . $soesocc . '",`unionww`="' . $unionww . '",`unioncc`="' . $unioncc . '",`ccstat1`="' . $ccstat1 . '",`pencen`="' . $pencen . '",`advance`="' . $advance . '", `bink`="' . $bink . '",`mfund`="' . $mfund . '",`dfund`="' . $dfund . '",`epf_pay`="' . $epf_pay . '",`epf_pay_a`="' . $epf_pay_a . '",`bonus_amount`="' . $bonus_amount . '",`commision_amount`="' . $commision_amount . '",`tawcpf`="' . $tawcpf . '",`tawcpfww`="' . $tawcpfww . '", `tawcpfcc`="' . $tawcpfcc . '",`hrd_pay`="' . $hrd_pay . '",`payyes`="' . $payyes . '",`hr1`="' . $hr1 . '",`hr2`="' . $hr2 . '",`hr3`="' . $hr3 . '",`hr4`="' . $hr4 . '",`hr5`="' . $hr5 . '",`hr6`="' . $hr6 . '",`DW`="' . $DW . '",`PH`="' . $PH . '",`AL`="' . $AL . '",`MC`="' . $MC . '", `MT`="' . $MT . '",`PT`="' . $PT . '",`MR`="' . $MR . '",`CL`="' . $CL . '",`HL`="' . $HL . '",`EX`="' . $EX . '",`AD`="' . $AD . '",`OPL`="' . $OPL . '",`NPL`="' . $NPL . '",`AB`="' . $AB . '",`OOB`="' . $OOB . '",`workhr`="' . $workhr . '",`latehr`="' . $latehr . '",`earlyhr`="' . $earlyhr . '", `nopayhr`="' . $nopayhr . '", `Eisww`="' . $EISWW . '", `Eiscc`="' . $EISCC . '", `back_pay`="' . $back_pay . '" where `employee_no`="' . $employee_no . '" and `month`="' . $month . '" and `epay_year`="' . $epay_year . '"';

        $result = DB::select($query);

        //   $result =  DB::table('user_epay')->where('employee_no',$employee_no)->where('month',$month)->where('epay_year',$epay_year)->update(array('employee_no' => $employee_no,'month' => $month,'epay_year' => $epay_year,'basic_rate' => $basic_rate,'work_day'=>$work_day,'day_work'=>$day_work,'basic_pay' => $basic_pay,'compensate' => $compensate,'gratuity' => $gratuity,'compensate_tax'=>$compensate_tax,'gratuity_tax'=>$gratuity_tax,'total_monthly_over_time_pay' => $total_monthly_over_time_pay,'director_fee' => $director_fee,'total_allowance' => $total_allowance,'gross_pay'=>$gross_pay,'other_deduction'=>$other_deduction,'total_decduction' => $total_decduction,'net_pay' => $net_pay,'net_pay_adjustment' => $net_pay_adjustment,'total_non_pay_leave_amount'=>$total_non_pay_leave_amount,'bonus'=>$bonus,'commision' => $commision,'extra' => $extra,'tax_overtime' => $tax_overtime,'tax_allowance'=>$tax_allowance,'tax_deduct'=>$tax_deduct,'tax_relief' => $tax_relief,'amount_over_time_1' => $amount_over_time_1,'amount_over_time_2' => $amount_over_time_2,'amount_over_time_3'=>$amount_over_time_3,'amount_over_time_4'=>$amount_over_time_4,'amount_over_time_5' => $amount_over_time_5,'amount_over_time_6' => $amount_over_time_6,'allowance_1' => $allowance_1,'allowance_2'=>$allowance_2,'allowance_3'=>$allowance_3,'allowance_4' => $allowance_4,'allowance_5' => $allowance_5,'allowance_6' => $allowance_6,'allowance_7'=>$allowance_7,'allowance_8'=>$allowance_8,'allowance_9' => $allowance_9,'allowance_10' => $allowance_10,'allowance_11' => $allowance_11,'allowance_12'=>$allowance_12,'allowance_13'=>$allowance_13,'allowance_14' => $allowance_14,'allowance_15' => $allowance_15,'allowance_16' => $allowance_16,'allowance_17'=>$allowance_17,'deduction_1'=>$deduction_1,'deduction_2' => $deduction_2,'deduction_3' => $deduction_3,'deduction_4' => $deduction_4,'deduction_5'=>$deduction_5,'deduction_6'=>$deduction_6,'deduction_7' => $deduction_7,'deduction_8' => $deduction_8,'deduction_9' => $deduction_9,'deduction_10'=>$deduction_10,'deduction_11'=>$deduction_11,'deduction_12' => $deduction_12,'deduction_13' => $deduction_13,'deduction_14' => $deduction_14,'deduction_15'=>$deduction_15,'itaxpcbb'=>$itaxpcbb,'itaxpcb' => $itaxpcb,'itaxpcbadj' => $itaxpcbadj,'tp1zakat' => $tp1zakat,'tp1levy'=>$tp1levy,'total_EPF_employee'=>$total_EPF_employee,'epfwwext' => $epfwwext,'epfccext'=>$epfccext,'epgww'=>$epgww,'epgcc' => $epgcc,'soasoww' => $soasoww,'soasocc' => $soasocc,'sobsoww'=>$sobsoww,'sobsocc'=>$sobsocc,'total_socso_employee' => $total_socso_employee,'total_socso_employer' => $total_socso_employer,'sodsoww' => $sodsoww,'sodsocc'=>$sodsocc,'soesoww'=>$soesoww,'soesocc' => $soesocc,'unionww' => $unionww,'unioncc' => $unioncc,'ccstat1'=>$ccstat1,'pencen'=>$pencen,'advance'=>$advance,'bink'=>$bink,'mfund'=>$mfund,'dfund'=>$dfund,'epf_pay'=>$epf_pay,'epf_pay_a'=>$epf_pay_a,'bonus_amount'=>$bonus_amount,'commision_amount'=>$commision_amount,'tawcpf'=>$tawcpf,'tawcpfww'=>$tawcpfww,'tawcpfcc'=>$tawcpfcc,'hrd_pay'=>$hrd_pay,'payyes'=>$payyes,'hr1'=>$hr1,'hr2'=>$hr2,'hr3'=>$hr3,'hr4'=>$hr4,'hr5'=>$hr5,'hr6'=>$hr6,'DW'=>$DW,'PH'=>$PH,'AL'=>$AL,'MC'=>$MC,'MT'=>$MT,'PT'=>$PT,'MR'=>$MR,'CL'=>$CL,'HL'=>$HL,'EX'=>$EX,'AD'=>$AD,'OPL'=>$OPL,'NPL'=>$NPL,'AB'=>$AB,'OOB'=>$OOB,'workhr'=>$workhr,'latehr'=>$latehr,'earlyhr'=>$earlyhr,'nopayhr'=>$nopayhr,'EISWW'=>$EISWW,'EISCC'=>$EISCC));
        return true;
    }

    public function updateUserDetails($dbfTable, $company_id)
    {
        $dpass = DB::table('details')->where('field', 'default password')->first();
        $password = $dpass->v4_value;

        for ($i = 0; $i < count($dbfTable); $i++) {

            if ($dbfTable[$i]["nricn"] != '') {
                $date = new DateTime($dbfTable[$i]["dbirth"]);
                $dob = date_format($date, 'Y-m-d');
                $sex = $dbfTable[$i]["sex"];
                $sex = (($sex == "M") ? "1" : "0");
                $race = $dbfTable[$i]["race"];
                switch ($dbfTable[$i]["race"]) {
                    case "C":
                        $race = "Chinese";
                        break;
                    case "I":
                        $race = "India";
                        break;
                    case "M":
                        $race = "Malay";
                        break;
                    case "":
                        $race = "Other";
                        break;
                    default:
                        $race = $dbfTable[$i]["race"];
                        break;
                }
                $bumiputra = (($dbfTable[$i]["b_putra"] == "Y") ? "1" : "0");
                $mstatus = "";
                switch ($dbfTable[$i]["mstatus"]) {
                    case "S":
                        $mstatus = "0";
                        break;
                    case "M":
                        $mstatus = "1";
                        break;
                    default:
                        $mstatus = "2";
                }

                $nationality = "";
                switch ($dbfTable[$i]["national"]) {
                    case "MY":
                        $nationality = "Malaysia";
                        break;
                    default:
                        $nationality = $dbfTable[$i]["national"];
                }
                $address = $dbfTable[$i]["add1"] . " " . $dbfTable[$i]["add2"];

                $this->addUserPersonal(
                    $dbfTable[$i]["nricn"],
                    $password,
                    $dbfTable[$i]["empno"],
                    $dbfTable[$i]["emp_code"],
                    $dbfTable[$i]["name"],
                    $address,
                    $dbfTable[$i]["postcode"],
                    $dbfTable[$i]["town"],
                    $nationality,
                    $dbfTable[$i]["state"],
                    $dbfTable[$i]["phone"],
                    $dob,
                    $dbfTable[$i]["edu"],
                    $dbfTable[$i]["exp"],
                    $dbfTable[$i]["nric"],
                    $dbfTable[$i]["nricn"],
                    $dbfTable[$i]["iccolor"],
                    $dbfTable[$i]["passport"],
                    $sex,
                    '',
                    '',
                    $race,
                    $bumiputra,
                    $mstatus,
                    $dbfTable[$i]["email"]
                );

                $spouseWorkig = (($dbfTable[$i]["tx_ded_sp"] == "Y") ? "1" : "0");
                $this->addUserSpouse($dbfTable[$i]["nricn"], $dbfTable[$i]["sname"], $dbfTable[$i]["snric"], $dbfTable[$i]["num_child"], $spouseWorkig);

                $this->addUserAddress($dbfTable[$i]["nricn"], $dbfTable[$i]["econtact"], $dbfTable[$i]["eadd1"], $dbfTable[$i]["etelno"]);
                $dcomm = preg_replace('/\s+/', '', $dbfTable[$i]["dcomm"]);
                if ($dcomm != "") {
                    $date = new DateTime($dbfTable[$i]["dcomm"]);
                    $dateOfJoin = date_format($date, 'Y-m-d');
                } else {
                    $dateOfJoin = "";
                }

                $dpromote = preg_replace('/\s+/', '', $dbfTable[$i]["dpromote"]);
                if ($dpromote != "") {
                    $date = new DateTime($dbfTable[$i]["dpromote"]);
                    $datePromote = date_format($date, 'Y-m-d');
                } else {
                    $datePromote = "";
                }

                $dresign = preg_replace('/\s+/', '', $dbfTable[$i]["dresign"]);
                if ($dresign != "") {
                    $date = new DateTime($dbfTable[$i]["dresign"]);
                    $dateResigned = date_format($date, 'Y-m-d');
                } else {
                    $dateResigned = "";
                }
                $branchId = $this->getBranchId($dbfTable[$i]["brcode"], $company_id);
                $departmentId = $this->getDepartmentId($dbfTable[$i]["deptcode"], $company_id);
                $categoryId = $this->getCategoryId($dbfTable[$i]["category"], $company_id);

                $dateConfirm = "";

                $dconfirm = preg_replace('/\s+/', '', $dbfTable[$i]["dconfirm"]);
                if ($dconfirm != "") {
                    $date = new DateTime($dbfTable[$i]["dconfirm"]);
                    $dateConfirm = date_format($date, 'Y-m-d');
                } else {
                    $dateConfirm = "";
                }


                $PAYRTYPE = "";
                switch ($dbfTable[$i]["payrtype"]) {
                    case "D":
                        $PAYRTYPE = "Daily";
                        break;
                    case "M":
                        $PAYRTYPE = "Monthly";
                        break;
                    case "H":
                        $PAYRTYPE = "Hourly";
                        break;
                    default:
                        $PAYRTYPE = "D";
                }

                $PAYMETH = "";
                switch ($dbfTable[$i]["paymeth"]) {
                    case "B":
                        $PAYMETH = "Bank";
                        break;
                    case "C":
                        $PAYMETH = "Cash";
                        break;
                    case "Q":
                        $PAYMETH = "Cheque";
                        break;
                    default:
                        $PAYMETH = "B";
                }

                $PAYSTATUS = "";
                switch ($dbfTable[$i]["paystatus"]) {
                    case "A":
                        $PAYSTATUS = "1";
                        break;
                    default:
                        $PAYSTATUS = "0";
                }

                $CONTRACT = "";
                switch ($dbfTable[$i]["contract"]) {
                    case "Y":
                        $CONTRACT = "1";
                        break;
                    default:
                        $CONTRACT = "0";
                }


                $this->addUserPay(
                    $dbfTable[$i]["nricn"],
                    $dbfTable[$i]["jtitle"],
                    $branchId,
                    $departmentId,
                    $categoryId,
                    $dateOfJoin,
                    $datePromote,
                    $dateResigned,
                    $dateConfirm,
                    $PAYRTYPE,
                    $PAYMETH,
                    $PAYSTATUS,
                    $CONTRACT
                );
                $this->addUserGovernment(
                    $dbfTable[$i]["nricn"],
                    $dbfTable[$i]["bankcode"],
                    $dbfTable[$i]["brancode"],
                    $dbfTable[$i]["bankaccno"],
                    $dbfTable[$i]["bankcat"],
                    $dbfTable[$i]["bankpmode"]
                );
                $this->addUserInsurance(
                    $dbfTable[$i]["nricn"],
                    $dbfTable[$i]["socsono"],
                    $dbfTable[$i]["socsotbl"],
                    $dbfTable[$i]["socsoic"],
                    $dbfTable[$i]["socsocat"],
                    $dbfTable[$i]["socsoinit"]
                );
                $this->addUserEPF(
                    $dbfTable[$i]["nricn"],
                    $dbfTable[$i]["epfno"],
                    $dbfTable[$i]["epfic"],
                    $dbfTable[$i]["epftbl"],
                    $dbfTable[$i]["epfcat"],
                    $dbfTable[$i]["epf_fyee"],
                    $dbfTable[$i]["epf_fyer"]
                );
                $this->addUserTax($dbfTable[$i]["nricn"], $dbfTable[$i]["itaxbran"], $dbfTable[$i]["itaxno"], $dbfTable[$i]["itaxcat"]);
                $this->addUserCategory($dbfTable[$i]["nricn"], "");
            }
        }
    }

    public function addUserCategory($username, $category)
    {
        if ($this->isUsernameduplicate('user_category', $username) == '') {
            $result = DB::table('user_category')->insert(array('username' => $username, 'category' => $category));
            return $result;
        }
    }

    public function getBranchId($branch, $company_id)
    {
        $query = DB::table('branch')->where('name', $branch)->where('company_id', $company_id)->first();
        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }

        return $id;
    }

    public function getDepartmentId($department, $company_id)
    {

        $query = DB::table('department')->where('name', $department)->where('company_id', $company_id)->first();
        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }
        return $id;
    }

    public function getCategoryId($category, $company_id)
    {
        $query = DB::table('category')->where('name', $category)->where('company_id', $company_id)->first();
        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }
        return $id;
    }

    public function addUserAddress($username, $name, $address, $phoneNo)
    {
        if ($this->isUsernameAvailableuseraddress($username) == '') {

            $result = DB::table('user_address')->insert(array('username' => $username, 'name' => $name, 'address' => $address, 'phone_no' => $phoneNo));
            return $result;
        }
    }

    public function addUserSpouse($username, $spouseName, $spouseIcNo, $noChildren, $spouseWorking)
    {
        if ($this->isUsernameAvailableuserspouse($username) == '') {

            $result = DB::table('user_spouse')->insert(array('username' => $username, 'spouse_name' => $spouseName, 'spouse_ic_no' => $spouseIcNo, 'no_children' => $noChildren, 'spouse_working' => $spouseWorking));
            return $result;
        }
    }

    public function updateDepartmentDetails($dbfTable, $company_id)
    {

        for ($i = 0; $i < count($dbfTable); $i++) {

            if ($this->isDepartmentNameAvailable($dbfTable[$i]["deptcode"], '', $company_id)) {
                $this->addDepartment11($dbfTable[$i]["deptcode"], $dbfTable[$i]["deptdesp"], '', $company_id);
            }
        }
    }

    public function isDepartmentNameAvailable($department, $id, $company_id)
    {

        if ($id == '') {
            $query = DB::table('department')->where('name', $department)->where('company_id', $company_id)->first();
        } else {
            $query = DB::table('department')->where('name', $department)->where('id', '!=', $id)->where('company_id', $company_id)->first();
        }


        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }

        if ($id != "")
            return FALSE;
        return TRUE;
    }

    public function addDepartment11($name, $description, $email, $company_id)
    {
        $result = DB::table('department')->insert(array('name' => $name, 'description' => $description, 'email' => $email, 'company_id' => $company_id));
        return $result;
    }

    public function updateBranchDetails($dbfTable, $company_id)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            if ($this->isBranchNameAvailable($dbfTable[$i]["brcode"], '', $company_id)) {
                $this->addBranch11($company_id, $dbfTable[$i]["brcode"], $dbfTable[$i]["brdesp"], $dbfTable[$i]["brdesp"]);
            }
        }
    }

    public function isBranchNameAvailable($branch, $id, $company_id)
    {
        if ($id == '') {
            $query = DB::table('branch')->where('name', $branch)->where('company_id', $company_id)->first();
        } else {
            $query = DB::table('branch')->where('name', $branch)->where('id', '!=', $id)->where('company_id', $company_id)->first();
        }

        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }
        if ($id != "")
            return FALSE;
        return TRUE;
    }

    public function addBranch11($company_id, $name, $state, $description, $logo = '', $email = '')
    {
        $result = DB::table('branch')->insert(array('name' => $name, 'state' => $state, 'description' => $description, 'logo' => $logo, 'email' => $email, 'company_id' => $company_id));
        return $result;
    }

    public function updateCategoryDetails($dbfTable, $company_id)
    {

        for ($i = 0; $i < count($dbfTable); $i++) {
            if ($this->isCategoryNameAvailable($dbfTable[$i]["category"], '', $company_id)) {
                $this->addCategory11($company_id, $dbfTable[$i]["category"], $dbfTable[$i]["desp"]);
            }
        }
    }

    public function isCategoryNameAvailable($category, $id, $company_id)
    {
        if ($id == '') {
            $query = DB::table('category')->where('name', $category)->where('company_id', $company_id)->first();
        } else {
            $query = DB::table('category')->where('name', $category)->where('id', '!=', $id)->where('company_id', $company_id)->first();
        }

        $id = '';
        if (!empty($query)) {
            $id = $query->id;
        }
        if ($id != "")
            return FALSE;
        return TRUE;
    }
    public function addCategory11($company_id, $name, $description, $email = '', $in_mgt_email = "0", $file_name = "")
    {

        $result = DB::table('category')->insert(array('name' => $name, 'description' => $description, 'email' => $email, 'in_mgt_email' => $in_mgt_email, 'logo' => $file_name, 'company_id' => $company_id));
        return $result;
    }

    public function updateHolidayDetails($dbfTable)
    {
        for ($i = 0; $i < count($dbfTable); $i++) {
            $date = new DateTime($dbfTable[$i]["hol_date"]);
            $holDate = date_format($date, 'Y-m-d');
            $this->addPublicHoliday("", "", "", $holDate, $dbfTable[$i]["hol_desp"]);
        }
    }

    public function updatePastLeaveDetails($dbfTable)
    {

        for ($i = 0; $i < count($dbfTable); $i++) {
            $date = new DateTime($dbfTable[$i]["lve_date"]);
            $leaveDate = date_format($date, 'Y-m-d');
            $leaveType = "";
            switch ($dbfTable[$i]["lve_type"]) {
                case "AL":
                    $leaveType = "Annual";
                    break;
                case "MC":
                    $leaveType = "Medical";
                    break;
                case "MT":
                    $leaveType = "Maternity";
                    break;
                case "MR":
                    $leaveType = "Marriage";
                    break;
                case "CL":
                    $leaveType = "Compassionate";
                    break;
                case "HL":
                    $leaveType = "Hospital";
                    break;
                case "EX":
                    $leaveType = "Examination";
                    break;
                case "PT":
                    $leaveType = "Paternity";
                    break;
                case "AD":
                    $leaveType = "Advance";
                    break;
                case "RL":
                    $leaveType = "Replacement";
                    break;
                case "LS":
                    $leaveType = "Line_Shut";
                    break;
                case "AB":
                    $leaveType = "Absent";
                    break;
                case "NPL":
                    $leaveType = "NPL";
                    break;
                case "EL":
                    $leaveType = "Emergency";
                    break;
                case "OPL":
                    $leaveType = "Other_pay";
                    break;
                default:
                    $leaveType = $dbfTable[$i]["lve_type"];
            }
            $noDays = (($dbfTable[$i]["lve_day"] != "0") ? $dbfTable[$i]["lve_day"] : "0.5");
            $username = $this->getUsernameFromEmployeeNo($dbfTable[$i]["empno"]);
            $this->addPastLeave11($username, $leaveType, $leaveDate, $leaveDate, $noDays);
        }
    }

    public function getUsernameFromEmployeeNo($employeeNo)
    {
        $value = DB::table('user_personal')->where('employee_no', $employeeNo)->first();
        return $value->username;
    }

    // public function getEmployeesUnderApprover(Request $request){

    //     $ActiveUserShownStatus1=DB::table('settings')->where('field','active_user_shown')->first();
    //     $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
    //     $user = User::where('id' , Auth::id())->first();

    //     $query = "select distinct a.employee_id as username, b.name from map_employee_approver a left join user_personal b ";
    //     $query .= "on a.employee_id=b.username ";

    //     if($ActiveUserShownStatus=='0'){
    //         $query .= " left join user_pay up on b.username=up.username ";
    //     }

    //     $query .= " where a.approver_id='".$user->username."' ";

    //     if($request->username != ""){
    //         $searchQuery .= " and (b.name like '".$request->username."%' OR b.employee_no like '".$request->username."%') ";
    //     }
    //     if($ActiveUserShownStatus=='1'){
    //         $query .= "and (up.pay_status = '1' or up.pay_status = '0')";
    //     }
    //     else{
    //         $query .= "and up.pay_status = '1'";
    //     }
    //     $query .= "and b.isDeleted ='0' order by b.name";


    //     $result = DB::select($query);
    //     return $result;

    // }

    public function getGroupedUsersqq(Request $request)
    {

        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $user = User::where('id', Auth::id())->first();

        $searchQuery = "a.username != '' and c.company_id='" . $user->company_id . "'";
        if ($request->department_id != "") {
            $searchQuery .= " and a.department_id='$request->department_id'";
        }
        if ($request->branch_id != "") {
            $searchQuery .= " and a.branch_id='$request->branch_id'";
        }
        if ($request->categoryId != "") {
            $searchQuery .= " and a.category_id='$request->categoryId'";
        }
        if ($request->category_id != "") {
            $searchQuery .= " and a.category_id='$request->category_id'";
        }
        if ($request->username != "") {
            $searchQuery .= ' and (b.name like "' . $request->username . '%" OR b.employee_no like "' . $request->username . '%") ';
        }

        $query = "select b.username, b.employee_no, b.name from user_pay a left join user_personal b on a.username=b.username left join user_pay up on a.username=up.username left join users c on a.username=c.username";

        if ($ActiveUserShownStatus == '1') {
            $searchQuery .= "and (up.pay_status = '1' or up.pay_status = '0')";
        } else {
            $searchQuery .= "and up.pay_status = '1'";
        }
        $searchQuery .= "and b.isDeleted ='0'";
        $query .= " where $searchQuery";

        $result = DB::select($query);
        return $result;
    }

    public function getcategorymapping_data11($id)
    {
        $categories = $this->getRestDayCategories_data($id);
        $user = User::where('id', Auth::id())->first();
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        for ($i = 0; $i < count($categories); $i++) {
            $categoryId = $categories[$i]->id;
            $query = DB::table('rest_day_category_employee as a')->leftjoin('user_personal as b', 'a.employee_id', '=', 'b.username')->leftjoin('user_pay as up', 'b.username', '=', 'up.username')->where('a.category_id', $categoryId)->where('b.isDeleted', 0);
            if ($ActiveUserShownStatus == '1') {
                $query->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
            } else {
                $query->where('up.pay_status', 1);
            }
            $employees = $query->selectRaw("a.employee_id, b.name, b.employee_no")->get();
            $categories[$i]->employees = $employees;
            if (count($employees) > 0) {
                $categories[$i]->display_allow = true;
            } else {
                $categories[$i]->display_allow = false;
            }
        }
        $categories['employee'] = $this->getEmployeesUnderApprover(request());
        return $categories;
    }

    public function getRLList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('replacement_duration')->leftjoin('category_name', 'category_name.id', '=', 'replacement_duration.category_name')->where('category_name.is_deleted', 0)->where('replacement_duration.company_id', $user->company_id)->selectRaw("replacement_duration.category_name, replacement_duration.value")->get();
        return $result;
    }

    public function getBFList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('bf_duration')->leftjoin('category_name', 'category_name.id', '=', 'bf_duration.category_name')->where('category_name.is_deleted', 0)->where('bf_duration.company_id', $user->company_id)->selectRaw("bf_duration.category_name, bf_duration.value")->get();
        return $result;
    }

    public function getBFAdjList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('bf_adj_duration')->leftjoin('category_name', 'category_name.id', '=', 'bf_adj_duration.category_name')->where('category_name.is_deleted', 0)->where('bf_adj_duration.company_id', $user->company_id)->selectRaw("bf_adj_duration.category_name, bf_adj_duration.value")->get();
        return $result;
    }

    public function getclaimablepresetList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('claimable_pre_set')->leftjoin('category_name', 'category_name.id', '=', 'claimable_pre_set.category_name')->where('category_name.is_deleted', 0)->where('claimable_pre_set.company_id', $user->company_id)->selectRaw("claimable_pre_set.category_name, claimable_pre_set.value")->get();
        return $result;
    }

    public function getemergencyleaveList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('emergency_leave')->leftjoin('category_name', 'category_name.id', '=', 'emergency_leave.category_name')->where('category_name.is_deleted', 0)->where('emergency_leave.company_id', $user->company_id)->selectRaw("emergency_leave.category_name, emergency_leave.value")->get();
        return $result;
    }

    public function getmaxpastleaveList()
    {
        $user = User::where('id', Auth::id())->first();
        $result = DB::table('max_past_leave')->leftjoin('category_name', 'category_name.id', '=', 'max_past_leave.category_name')->where('category_name.is_deleted', 0)->where('max_past_leave.company_id', $user->company_id)->selectRaw("max_past_leave.category_name, max_past_leave.value")->get();
        return $result;
    }

    public function getTopManagementForTodayEmail(Request $request)
    {
        $date = (isset($request->date) ? date('Y-m-d', strtotime($request->date)) : date('Y-m-d'));
        $leave_list = $this->getTopManagementForTodayEmail11($date);
        return $leave_list;
    }


    public function getTopManagementForTodayEmail11($date)
    {
        $catIds = DB::table('category')->where('in_mgt_email', 1)->select('id')->get();
        $categoryIdArray = [];

        for ($i = 0; $i < count($catIds); $i++) {
            array_push($categoryIdArray, $catIds[$i]['id']);
        }

        $categoryId = implode(",", $categoryIdArray);


        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
        $currentOnly = getSettingsValue('only_current_year_leave_display');

        $result = DB::table('leave_days as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')
            ->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('leave_list as ll', 'll.id', '=', 'a.leave_id')
            ->leftjoin('category as f', 'c.category_id', '=', 'f.id')->selectRaw("b.name, b.employee_no,b.username as username, d.name as branch, e.name as department, f.name as category, ll.type as `Type`, CASE ll.is_half_day WHEN 1 THEN ( CASE ll.half_day_type WHEN 'first' THEN 'AM Half Day' WHEN 'second' THEN 'PM Half Day' END ) 
            WHEN 0 THEN 'Full Day' END as 'day_leave_type', ll.reason, b.email_id")->whereRaw("1 and a.status='1'");
        if ($currentOnly == '1') {
            $result->whereRaw(" DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }

        if ($categoryId != "") {
            $result->whereIn('c.category_id', $categoryId);
        }

        if ($ActiveUserShownStatus == '0') {
            $result->where('c.pay_status', '!=', '1');
        }


        $query = $result->where('a.date', $date)->get();
        return $query;
    }

    public function getBranchBasedLeaveTodayEmail($date, $branchId)
    {
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
        $currentOnly = getSettingsValue('only_current_year_leave_display');

        $query = "select from leave_days a ";
        $query .= "left join user_personal b on a.username=b.username left join user_pay c ";
        $query .= "on a.username=c.username left join branch d on c.branch_id=d.id left join department e ";
        $query .= "on c.department_id=e.id left join leave_list ll on ll.id=a.leave_id left join category f on c.category_id=f.id where 1 and a.status='1'";
        $query = DB::table('leave_days as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')
            ->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('leave_list as ll', 'll.id', '=', 'a.leave_id')
            ->leftjoin('category as f', 'c.category_id', '=', 'f.id')->selectRaw(" b.name, b.employee_no,b.username as username, d.name as branch, e.name as department, f.name as category, ll.type as `Type`, CASE ll.is_half_day WHEN 1 THEN ( CASE ll.half_day_type WHEN 'first' THEN 'AM Half Day' WHEN 'second' THEN 'PM Half Day' END ) 
                    WHEN 0 THEN 'Full Day' END as 'day_leave_type', ll.reason, b.email_id")->whereRaw("1 and a.status='1'");
        if ($currentOnly == '1') {
            $query->whereRaw(" DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }

        $query->where('a.date', $date);
        if ($ActiveUserShownStatus == '0') {
            $query->where('c.pay_status', '!=', '1');
        }
        $results = $query->where('c.branch_id', $branchId)->get();
        return $results;
    }

    public function branchGetList()
    {
        $branchs = DB::table('branch')->select('id', 'name', 'state', 'description', 'logo', 'email')->groupBy('branch.name', 'branch.id')->get();
        return $branchs;
    }

    public function sendDailyEmailT(Request $request)
    {
        $AllowEmailSentToTopMgtByCronjob = getSettingsValue('email_status_sent_to_top_mgt_cronjob');
        $top_mgt_email = getSettingsValue('top_mgt_email');
        if ($AllowEmailSentToTopMgtByCronjob == "1" && $top_mgt_email != '') {

            $email_detail = $this->getTopManagementForTodayEmail(request());
            $subject = "Leave Status";
            $body = "";

            $body .= "Staff On Leave: " . date("d-m-Y") . "<br /><br />";
            $body .= "<table>";
            $body .= "<tr>";
            $body .= "<td width='50'><strong>No.</strong></td>";
            $body .= "<td width='200'><strong>Employee Name</strong></td>";
            $body .= "<td width='100'><strong>Half/Full</strong></td>";
            $body .= "</tr>";

            for ($i = 0; $i < count($email_detail); $i++) {

                $_email_send_allow = true;
                if (!$email_send_allow && $_email_send_allow) {
                    $email_send_allow = true;
                }
                if ($_email_send_allow) {
                    $body .= "<tr>";
                    $body .= "<td>" . ($i + 1) . "</td>";
                    $body .= "<td>" . $email_detail[$i]['name'] . "</td>";
                    $body .= "<td>" . $email_detail[$i]['day_leave_type'] . "</td>";
                    $body .= "</tr>";
                }
            }
            $body .= "</table><br /><br />";
            $body .= "Kind regards,<br />";
            $body .= "Note, this is an automatic email. Please do not reply. <br />";
            $body .= "If you did not request this information, please ignore this message. <br />";
            $body .= "If you have any questions, please contact us<br />";

            if ($email_send_allow && count($email_detail) > 0) {
                echo $body . "<br /><br />==========================" . $AllEmails[$j]['email'] . "<br /><br />";
                echo "<br /><br />Allow - " . $top_mgt_email . "<br /><br />";
                sendemail($top_mgt_email, $subject, $body);
            } else {
            }

            $branch_permission = getSettingsValue('daily_email_to_branch');
            $branchEmails = [];
            if ($branch_permission) {
                $branchEmails = $this->branchGetList();
            }

            for ($j = 0; $j < count($branchEmails); $j++) {

                $detailInfo = $this->getBranchBasedLeaveTodayEmail($branchEmails[$j]['id']);


                $subject = "Leave Status";
                $body = "";

                $body .= "Staff On Leave: " . date("d-m-Y") . "<br /><br />";
                $body .= "<table>";
                $body .= "<tr>";
                $body .= "<td width='50'><strong>No.</strong></td>";
                $body .= "<td width='200'><strong>Employee Name</strong></td>";
                $body .= "<td width='100'><strong>Half/Full</strong></td>";
                $body .= "</tr>";

                for ($i = 0; $i < count($detailInfo); $i++) {

                    $_email_send_allow = true;

                    if (!$email_send_allow && $_email_send_allow) {
                        $email_send_allow = true;
                    }
                    if ($_email_send_allow) {
                        $body .= "<tr>";
                        $body .= "<td>" . ($i + 1) . "</td>";
                        $body .= "<td>" . $detailInfo[$i]['name'] . "</td>";
                        $body .= "<td>" . $detailInfo[$i]['day_leave_type'] . "</td>";
                        $body .= "</tr>";
                    }
                }
                $body .= "</table><br /><br />";
                $body .= "Kind regards,<br />";
                $body .= "Note, this is an automatic email. Please do not reply. <br />";
                $body .= "If you did not request this information, please ignore this message. <br />";
                $body .= "If you have any questions, please contact us<br />";

                if ($email_send_allow && count($detailInfo) > 0) {
                    echo $body . "<br /><br />==========================" . $AllEmails[$j]['email'] . "<br /><br />";
                    echo "<br /><br />Allow - " . $branchEmails[$j]['email'] . "<br /><br />";
                    sendemail($branchEmails[$j]['email'], $subject, $body);
                } else {
                    echo "<br /><br />Not Allow " . $branchEmails[$j]['name'] . "<br /><br />";
                }
            }
        }
    }

    public function getEmployeesLeaveTodayForEmail(Request $request)
    {
        $date = (isset($request->date) ? date('Y-m-d', strtotime($request->date)) : date('Y-m-d'));
        $branchId = (isset($request->branch_id) ? $request->branch_id : "");
        $categoryId = (isset($request->category_id) ? $request->category_id : "");
        $departmentId = (isset($request->department_id) ? $request->department_id : "");
        $leave_list = $this->getEmployeesLeaveTodayForEmail11($date, $branchId, $categoryId, $departmentId);
        return $leave_list;
    }

    public function getEmployeesLeaveTodayForEmail11($date, $branchId, $categoryId, $departmentId)
    {
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
        $currentOnly = getSettingsValue('only_current_year_leave_display');

        $query = DB::table('leave_days as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')
            ->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('leave_list as ll', 'll.id', '=', 'a.leave_id')->leftjoin('category as f', 'c.category_id', '=', 'f.id')->leftjoin('leave_name as ln', 'll.type', '=', 'ln.type')
            ->selectRaw("b.name, b.employee_no,b.username as username, d.name as branch, e.name as department, f.name as category, ln.name as `Type`, CASE ll.is_half_day WHEN 1 THEN ( CASE ll.half_day_type WHEN 'first' THEN 'AM Half Day' WHEN 'second' THEN 'PM Half Day' END ) 
    WHEN 0 THEN 'Full Day' END as 'day_leave_type', ll.reason, b.email_id")->whereRaw("1 and a.status='1'");
        if ($currentOnly == '1') {
            $query->whereRaw(" DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }

        $query->where('a.date', $date);
        if ($ActiveUserShownStatus == '0') {
            $query->where('c.pay_status', '!=', '1');
        }
        $result = $query->where('c.branch_id', $branchId)->where('c.category_id', $categoryId)->where('c.department_id', $departmentId)->get();
        return $result;
    }

    public function getAllUserList()
    {
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');

        $query = DB::table('user_personal as a')->leftjoin('user_pay as b', 'a.username', '=', 'b.username')->leftjoin('branch as c', 'b.branch_id', '=', 'c.id')
            ->leftjoin('category as d', 'b.category_id', '=', 'd.id')->leftjoin('department as e', 'b.department_id', '=', 'e.id')->leftjoin('map_employee_permission as f', 'a.username', '=', 'f.employee_id')
            ->leftjoin('permission_group as g', 'g.id', '=', 'f.permission_group_id')->leftjoin('user_category as uc', 'uc.username', '=', 'a.username')->leftjoin('rest_day_category_employee as rdce', 'rdce.employee_id', '=', 'a.username')
            ->leftjoin('rest_day_category as rdc', 'rdc.id', '=', 'rdce.category_id')->selectRaw("a.username, a.employee_no, a.name, a.employee_code, DATE_FORMAT(b.date_commence, '%d/%m/%Y') as date_commence, b.pay_status as active, c.name as branch, d.name as category, e.name as department, a.state, a.phone_no, g.group_name as role, a.email_id, uc.category as category_mapping, rdc.category as rest_day_group, DATE_FORMAT(b.date_confirmed, '%d/%m/%Y') as date_confirmed")
            ->where('a.username', '!=', '')->where('a.isDeleted', 0);
        if ($ActiveUserShownStatus == '0') {
            $query->where('b.pay_status', '!=', '1');
        }

        $results = $query->orderBy('a.name+0', 'a.name')->get();
        return $results;
    }



    public function sendEmailTodayLeaveSuser(Request $request)
    {
        $AllowEmailSentToAllByCronjob = getSettingsValue('email_status_sent_to_all_cronjob');

        $template = getSettingsValue('CronJobEmailTemplateSetting');
        if ($template == "") {
            $template = 0;
        }
        $AllowEmailSentToAllByCronjob = 1;
        if ($AllowEmailSentToAllByCronjob == "1") {

            $detailInfo = $this->getEmployeesLeaveTodayForEmail(request());
            $all_userList = $this->getAllUserList();

            $email_send_allow = false;
            for ($j = 0; $j < count($all_userList); $j++) {
                $subject = "Leave Status";
                $body = "";

                if ($template == 1) {

                    //$body .= "Dear ".$all_userList[$j]['name'].", <br /><br />";
                    $body .= "Staff On Leave: " . date("d-m-Y") . "<br /><br />";
                    $body .= "<table>";
                    $body .= "<tr>";
                    $body .= "<td width='200'><strong>Employee Name</strong></td>";
                    $body .= "<td width='100'><strong>Leave Type</strong></td>";
                    $body .= "<td width='200'><strong>Reason</strong></td>";
                    $body .= "<td width='100'><strong>Half/Full</strong></td>";
                    $body .= "</tr>";

                    for ($i = 0; $i < count($detailInfo); $i++) {

                        $_email_send_allow = true;

                        if (getSettingsValue('email_send_by_preferneces')) {
                            //echo '<br />1 <br />';
                            if (!hasContentPreference($detailInfo[$i]['username'])) {
                                $_email_send_allow = true;
                            } else {
                                $_email_send_allow = false;
                            }
                        }

                        //echo ' 2 = '.$_email_send_allow.'<br/>';
                        if (!$email_send_allow && $_email_send_allow) {
                            $email_send_allow = true;
                        }
                        //echo ' 3 = '.$email_send_allow.'<br/>';   
                        if ($_email_send_allow) {
                            $body .= "<tr>";
                            $body .= "<td>" . $detailInfo[$i]['name'] . "</td>";
                            $body .= "<td>" . $detailInfo[$i]['Type'] . "</td>";
                            $body .= "<td>" . $detailInfo[$i]['reason'] . "</td>";
                            $body .= "<td>" . $detailInfo[$i]['day_leave_type'] . "</td>";
                            $body .= "</tr>";
                        }

                        if ($detailInfo[$i]['email_id'] == $all_userList[$j]['email_id']) {
                            //$email_send_allow = false;
                        }
                    }
                    $body .= "</table><br /><br />";
                    $body .= "Kind regards,<br />";
                    $body .= "Note, this is an automatic email. Please do not reply. <br />";
                    $body .= "If you did not request this information, please ignore this message. <br />";
                    $body .= "If you have any questions, please contact us<br />";
                } else {




                    $body .= "Dear " . $all_userList[$j]['name'] . ", <br /><br />";
                    $body .= "Staff On Leave: " . date("d-m-Y") . "<br /><br />";
                    $body .= "<table>";
                    $body .= "<tr>";
                    $body .= "<td width='50'><strong>No.</strong></td>";
                    $body .= "<td width='200'><strong>Employee Name</strong></td>";
                    $body .= "<td width='100'><strong>Half/Full</strong></td>";
                    $body .= "</tr>";

                    for ($i = 0; $i < count($detailInfo); $i++) {

                        $_email_send_allow = true;

                        if (getSettingsValue('email_send_by_preferneces')) {
                            //echo '<br />1 <br />';
                            if (!hasContentPreference($detailInfo[$i]['username'])) {
                                $_email_send_allow = true;
                            } else {
                                $_email_send_allow = false;
                            }
                        }

                        //echo ' 2 = '.$_email_send_allow.'<br/>';
                        if (!$email_send_allow && $_email_send_allow) {
                            $email_send_allow = true;
                        }
                        //echo ' 3 = '.$email_send_allow.'<br/>';   
                        if ($_email_send_allow) {
                            $body .= "<tr>";
                            $body .= "<td>" . ($i + 1) . "</td>";
                            $body .= "<td>" . $detailInfo[$i]['name'] . "</td>";
                            $body .= "<td>" . $detailInfo[$i]['day_leave_type'] . "</td>";
                            $body .= "</tr>";
                        }

                        if ($detailInfo[$i]['email_id'] == $all_userList[$j]['email_id']) {
                            //$email_send_allow = false;
                        }
                    }
                    $body .= "</table><br /><br />";
                    $body .= "Kind regards,<br />";
                    $body .= "Note, this is an automatic email. Please do not reply. <br />";
                    $body .= "If you did not request this information, please ignore this message. <br />";
                    $body .= "If you have any questions, please contact us<br />";
                }


                //echo $body;	

                echo $body . "<br /><br />==========================<br /><br />";
                //exit;
                if ($email_send_allow && count($detailInfo) > 0) {
                    $semail = UserPersonal::where('username', $all_userList[$j]['username'])->first();
                    echo "<br /><br />Allow - " . $all_userList[$j]['username'] . "<br /><br />";
                    //Email::sendEmailToUserFromServer($all_userList[$j]['username'], $subject, $body);
                    if ($semail->email_id != '') {
                        sendemail($semail->email_id, $subject, $body);
                    }
                } else {
                    //echo "<br /><br />Not Allow<br /><br />";
                }
            }
        }
    }

    public function get2DaysNextLeavesEmails(Request $request)
    {
        $date = date('Y-m-d', strtotime("+2 days"));
        $branchId = (isset($request->branch_id) ? $request->branch_id : "");
        $categoryId = (isset($request->category_id) ? $request->category_id : "");
        $departmentId = (isset($request->department_id) ? $request->department_id : "");
        $leave_list = $this->get2DaysNextLeavesEmails11($date, $branchId, $categoryId, $departmentId);
        return $leave_list;
    }

    public function get2DaysNextLeavesEmails11($date, $branchId, $categoryId, $departmentId)
    {
        $ActiveUserShownStatus = getSettingsValue('active_user_shown');
        $currentOnly = getSettingsValue('only_current_year_leave_display');

        $query = DB::table('leave_days as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')
            ->leftjoin('leave_list as ll', 'll.id', '=', 'a.leave_id')->leftjoin('user_personal as approver_up', 'll.approver_id', '=', 'approver_up.username')->leftjoin('category as f', 'c.category_id', '=', 'f.id')
            ->selectRaw("b.username,b.name, b.employee_no, d.name as branch, e.name as department, f.name as category, ll.type as `Type`,CASE ll.is_half_day WHEN 1 THEN ( CASE ll.half_day_type WHEN 'first' THEN 'AM Half Day' WHEN 'second' THEN 'PM Half Day' END ) 
    WHEN 0 THEN 'Full Day' END as 'day_leave_type', ll.reason, b.email_id,approver_up.email_id as approver_email,approver_up.name as approver_name,approver_up.username as approver_username ")->whereRaw("(a.status='0' or a.status='3')");
        if ($currentOnly == '1') {
            $query->whereRaw(" DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }

        $query->where('a.date', $date);
        if ($ActiveUserShownStatus == '0') {
            $query->where('c.pay_status', '!=', '1');
        }
        $result = $query->where('c.branch_id', $branchId)->where('c.category_id', $categoryId)->where('c.department_id', $departmentId)->get();
        return $result;
    }

    public function Send2DaysBeforeEmail(Request $request)
    {

        $emailValues = $this->get2DaysNextLeavesEmails(request());

        $emailUsers = array();
        $emailUsersName = array();
        for ($i = 0; $i < count($emailValues); $i++) {
            if (!in_array($emailValues[$i]['approver_email'], $emailUsers)) {
                array_push($emailUsers, $emailValues[$i]['approver_email']);
                array_push($emailUsersName, $emailValues[$i]['approver_name']);
            }
        }



        for ($j = 0; $j < count($emailUsersName); $j++) {
            $email_send_allow = false;

            $subject = "Leave Status";
            $body = "";

            $body .= "Dear " . $emailUsersName[$j] . ", <br /><br />";
            $body .= "Following leaves still pending for your approval on : " . date('d-m-Y', strtotime("+2 days")) . "<br /><br />";
            $body .= "<table>";
            $body .= "<tr>";
            $body .= "<td width='50'><strong>No.</strong></td>";
            $body .= "<td width='200'><strong>Employee Name</strong></td>";
            //$body .= "<td width='100'><strong>Reason</strong></td>";
            $body .= "</tr>";
            $n = 0;
            for ($i = 0; $i < count($emailValues); $i++) {

                if ($emailValues[$i]['approver_email'] == $emailUsers[$j] && $emailValues[$i]['approver_name'] == $emailUsersName[$j]) {
                    $email_send_allow = true;
                    $n++;
                    $body .= "<tr>";
                    $body .= "<td>" . ($n) . "</td>";
                    $body .= "<td>" . $emailValues[$i]['name'] . "</td>";
                    $body .= "<td>" . $emailValues[$i]['reason'] . "</td>";
                    $body .= "</tr>";
                }
            }
            $body .= "</table><br /><br />";
            $body .= "Kind regards,<br />";
            $body .= "Note, this is an automatic email. Please do not reply. <br />";
            $body .= "If you did not request this information, please ignore this message. <br />";
            $body .= "If you have any questions, please contact us<br />";

            //echo $body;	

            //echo $body."<br /><br />==========================<br /><br />";
            //exit;
            if ($email_send_allow) {
                //echo "<br /><br />Allow<br /><br />";
                //Email::sendEmail($emailUsers[$j], $subject, $body);
                //Email::sendEmailToUserFromServer($emailValues[$j]['approver_username'], $subject, $body);
                $semail = UserPersonal::where('username', $emailValues[$j]['approver_username'])->first();
                if ($semail->email_id != '') {
                    sendemail($semail->email_id, $subject, $body);
                }
                echo "Email Send on = " . $emailUsers[$j] . " --- username = " . $emailValues[$j]['approver_username'] . " --- approver_name = " . $emailValues[$j]['approver_name'] . " <br /> <br />";
            } else {
                //echo "<br /><br />Not Allow<br /><br />";
                echo "Email Not Send on = " . $emailUsers[$j] . " <br /> <br />";
            }
        }
    }
    
        // leave Audit

    public function leaveAudit()
    {
        $c_key = 'leave_eaudit';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        $employees = UserPersonal::select('name', 'username')->get();
        $leaves = DB::table('leave_name')->select('type', 'name')->get();

        $leaveStatus = [
            '0'=>'Pending',
            '1'=>'Approved',
            '2'=>'Rejected',
            '3'=>'Recommended',
            '4'=>'Cancelled',
        ];
        return view('hr.reports.leave-audit', compact('c_key', 'columnHideShowData', 'employees', 'leaves', 'leaveStatus'));
    }

    public function leaveAuditData(Request $request)
    {

        session(['leave_audit_data' => $request->getUri()]);
        if ($request->auth_id != '') {
            $user = User::where('id', $request->auth_id)->first();
        } else {
            $user = User::where('id', Auth::id())->first();
        }
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $employees = DB::table('leave_audits');
        
        // filter
        if(isset($request->date_from) && $request->date_from!=""){
            $employees->whereDate('created_at', '>=', $request->date_from);
        }

        if(isset($request->date_to) && $request->date_to!=""){
            $employees->whereDate('created_at', '<=', $request->date_to);
        }

        if(isset($request->leave_date) && $request->leave_date !=""){
            $employees->whereDate('leave_date', $request->leave_date);
        }

        if(isset($request->emp) && $request->emp !=""){
            $employees->where('emp_id', $request->emp);
        }

        if(isset($request->leave_from) && $request->leave_from !=""){
            $employees->where('leave_from', $request->leave_from);
        }

        if(isset($request->leave_to) && $request->leave_to !=""){
            $employees->where('leave_to', $request->leave_to);
        }

        if(isset($request->status_from) && $request->status_from !=""){
            $employees->where('status_from', $request->status_from);
        }

        if(isset($request->status_to) && $request->status_to !=""){
            $employees->where('status_to', $request->status_to);
        }


        // filter end


        $employees = $employees->get()->sortDesc();

        $employees->map(function ($item) {
            $item->admin = getNameByUserName($item->admin_id);
            $item->emp_name = getNameByUserName($item->emp_id);
            if($item->status_from == 0){
                $item->status_from = 'Pending';
            }elseif($item->status_from == 1){
                $item->status_from = 'Approved';
            }elseif($item->status_from == 2){
                $item->status_from = 'Rejected';
            }elseif($item->status_from == 3){
                $item->status_from = 'Recommended';
            }elseif($item->status_from == 4){
                $item->status_from = 'Cancelled';
            }else{
                $item->status_from = 'Cancellation Pending';
            }

            if($item->status_to == 0){
                $item->status_to = 'Pending';
            }elseif($item->status_to == 1){
                $item->status_to = 'Approved';
            }elseif($item->status_to == 2){
                $item->status_to = 'Rejected';
            }elseif($item->status_to == 3){
                $item->status_to = 'Recommended';
            }elseif($item->status_to == 4){
                $item->status_to = 'Cancelled';
            }else{
                $item->status_to = 'Cancellation Pending';
            }
        
            if($item->leave_to){
                $item->leave_to = getLeaveNameByType($item->leave_to);
            }else{
                $item->leave_to = "";
            }
            
            if($item->leave_from){
                $item->leave_from = getLeaveNameByType($item->leave_from);
            }else{
                $item->leave_from = "";
            }


            if($item->deleted_at){
                $item->deleted_at = date("d-m-Y", strtotime($item->created_at));
            }else{
                $item->deleted_at = "NA";
            }
            
            if($item->leave_from){
                $item->leave_from = $item->leave_from;
            }else{
                $item->leave_from = " ";
            }
            if($item->leave_to){
                $item->leave_to = $item->leave_to;
            }else{
                $item->leave_to = " ";
            }
            
            if($item->reason_from){
                $item->reason_from = $item->reason_from;
            }else{
                $item->reason_from = " ";
            }
            
            if($item->reason_to){
                $item->reason_to = $item->reason_to;
            }else{
                $item->reason_to = " ";
            }
            $item->created_at = date("d-m-Y", strtotime($item->created_at));
            if($item->leave_date){
                $item->leave_date = date("d-m-Y", strtotime($item->leave_date));
            }else{
                $item->leave_date = "";
            }
            

        }); 

        return DataTables::of($employees)->make(true);
    }


    public function leaveAuditPDF(Request $request)
    {

        $timezone = Carbon::now(get_local_time());

        $timedate = $timezone->format('d-m-Y H:i A');

        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('leave_audit_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $employees = json_decode($response)->data;
        $user = User::where('id', Auth::id())->first();
        $companyname = Detail::where('field', 'company_details')->where('company_id', $user->company_id)->first();
        $html = html_entity_decode(view('hr.reports.pdf.leave-audit', compact('employees', 'timedate', 'companyname'))); //->render();
        $pdf = new Dompdf();


        $pdf->loadHtml($html);
        $pdf->setPaper('A3', 'landscape');
        $pdf->render();
        $pdf->stream('Audit Report');
        return 1;
    }

    public function leaveAuditExport(Request $request)
    {
        //$url = str_replace("length=20","length=-1",session('remployee_pdf_data'));
        $url1 = str_replace("length=10", "length=-1", session('leave_audit_data'));
        $url11 = str_replace("length=20", "length=-1", $url1);
        $url12 = str_replace("length=50", "length=-1", $url11);
        $url = str_replace("length=100", "length=-1", $url12);
        //$url = session('remployee_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . "&auth_id=" . Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $employees = json_decode($response)->data;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A' . 1, 'Leave Audit Report');
        $sheet->setCellValue('B' . 2, 'Admin');
        $sheet->setCellValue('C' . 2, 'Emp No');
        $sheet->setCellValue('D' . 2, 'Emp Name');
        $sheet->setCellValue('E' . 2, 'Leave Date');
        $sheet->setCellValue('F' . 2, 'Updated/Deleted Date');
        $sheet->setCellValue('G' . 2, 'Leave Type From');
        $sheet->setCellValue('H' . 2, 'Leave Type To');
        $sheet->setCellValue('I' . 2, 'Reason From');
        $sheet->setCellValue('J' . 2, 'Reason To');
        $sheet->setCellValue('K' . 2, 'Status From');
        $sheet->setCellValue('L' . 2, 'Status to');

        $rows = 2;
        foreach ($employees as $employee) {
            $rows++;
            $sheet->setCellValue('B' . $rows, $employee->admin);
            $sheet->setCellValue('C' . $rows, $employee->emp_id);
            $sheet->setCellValue('D' . $rows, $employee->emp_name);
            $sheet->setCellValue('E' . $rows, $employee->leave_date);
            $sheet->setCellValue('F' . $rows, $employee->created_at);
            $sheet->setCellValue('G' . $rows, $employee->leave_from);
            $sheet->setCellValue('H' . $rows, $employee->leave_to);
            $sheet->setCellValue('I' . $rows, $employee->reason_from);
            $sheet->setCellValue('J' . $rows, $employee->reason_to);
            $sheet->setCellValue('K' . $rows, $employee->status_from);
            $sheet->setCellValue('L' . $rows, $employee->status_to);
        }


        $fileName = "leave-audit.xlsx";

        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer->save('php://output');
    }

    // user permission list
    public function empPermissionData(Request $request)
    {

        $employees = DB::table('user_personal')
                    ->select('permission_group.type', 'permission_group.group_name', 'map_employee_permission.*', 'user_personal.name', 'user_personal.username')
                    ->leftJoin('map_employee_permission', 'map_employee_permission.employee_id', '=', 'user_personal.username')
                    ->leftJoin('permission_group', 'permission_group.id', '=', 'map_employee_permission.permission_group_id');
                
                    if(isset($request->permission_id) && $request->permission_id!="Not Assigned" && $request->permission_id!=""){
                        $employees->where('permission_group_id', $request->permission_id);
                    }elseif(isset($request->permission_id) && $request->permission_id=="Not Assigned"){
                        $employees->where('permission_group_id', NULL);
                    }
        $employees = $employees->get();

        return DataTables::of($employees)->make(true);
    }

    public function unassigedPermission(Request $request){
        $emp = $request->empUsernames;
        $res = DB::table('map_employee_permission')->where('employee_id', $emp)->delete();
        if($res){
            return True;
        }else{
            return False;
        }
    }

    public function updateUserPermission(Request $request){
        $permission_id = $request->permission_id;
        $emp = $request->empUsername;
        $check = DB::table('map_employee_permission')->where('employee_id', $emp)->first();
        if($check){
            $res = DB::table('map_employee_permission')->where('employee_id', $emp)->update(['permission_group_id'=> $permission_id]);
        }else{
            $res = DB::table('map_employee_permission')->where('employee_id', $emp)->insert(['employee_id'=>$emp,'permission_group_id'=> $permission_id]);
        }
        if($res){
            return True;
        }else{
            return False;
        }
    }
}