<?php

namespace App\Http\Controllers;
use App\Http\Controllers\MyLeaveController;
use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, MapEmployeeApprover, UserPersonal, PublicHoliday, Category, Department, ApproverApprovedLeave,LeaveEntitleHistory,PendingEmail, LeaveAudit};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Mail\MyDemoMail;
use Mail;
use App\Jobs\SendEmailJob;
use App\Jobs\SetStatusJob;
class LeaveApprovalsController extends Controller
{
	protected $storageDriver;
	public function __construct()
    {
      $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }
    
    public function index(Request $request)
    {
        $user = User::where('id' , Auth::id())->first();
        $leaveTypes  = Leavetype::where('is_show',1)->get();
        $category  = Category::all();
        $department  = Department::all();
        $yr='';
        $username = "";
        $replacement =getSelfRepleasementLeave($username,$yr);
        $c_key = 'leave_all';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }
        
        return view('approvals.leave-requests', compact('leaveTypes', 'category', 'department', 'replacement', 'c_key', 'columnHideShowData'));
    }

    public function getLeave()
    {
        $user = User::where('id' , Auth::id())->first();
        $apr_viewStatus = getPermissionValue("approval_view_all",!empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $requestArray12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                        ->leftjoin('category as cat','d.category_id','=','cat.id')
                        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                        ->leftjoin('department as e','d.department_id','=','e.id')
                        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
                        ->leftjoin('leave_name', 'leave_name.type','=','b.type')
                        ->where('app_lv.approver_id',$user->username);
             $logged_username = $user->username;
          //  dd($hr_viewStatus);
    		if($apr_viewStatus==1){
                $requestArray12->where('b.username',$logged_username);
    		}else if($apr_viewStatus==2){
    			$logged_userGroups = getUserGroups($logged_username);
                $requestArray12->where('d.branch_id',$logged_userGroups->branch_id)->where('d.category_id',$logged_userGroups->category_id)->where('d.department_id',$logged_userGroups->department_id);
    		}else if($apr_viewStatus==3){
    			$logged_userGroups = getUserGroups($logged_username);
    			$requestArray12->where('d.branch_id',$logged_userGroups->branch_id);
    		}else if($apr_viewStatus==4){
    			$logged_userGroups = getUserGroups($logged_username);
    		
    			$all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
    			//	dd(is_array($all_other_branch_ids), count($all_other_branch_ids));
    // 			if(is_array($all_other_branch_ids) && count($all_other_branch_ids)>0){
                if(count($all_other_branch_ids)>0){
    				$array_i = array();
    				for($b_id_i = 0; $b_id_i<count($all_other_branch_ids); $b_id_i++){
    					$array_i[] = $all_other_branch_ids[$b_id_i]->id;
    				}
    				$str_branch_ids = $array_i;
    			//	dd($str_branch_ids);
    			    //$str_branch_ids = explode(",",$str_branch_ids);
                    $requestArray12->whereIn('d.branch_id',$str_branch_ids);
    			}
    		}
                $requestArray12->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name, leave_name.name as typename, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, b.is_hourly ");
                
                
        $requestArray =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->leftjoin('leave_name', 'leave_name.type','=','b.type')
                ->where('b.approver_id',$user->username);
                
        	if($apr_viewStatus==1){
                $requestArray->where('b.username',$logged_username);
    		}else if($apr_viewStatus==2){
    			$logged_userGroups = getUserGroups($logged_username);
                $requestArray->where('d.branch_id',$logged_userGroups->branch_id)->where('d.category_id',$logged_userGroups->category_id)->where('d.department_id',$logged_userGroups->department_id);
    		}else if($apr_viewStatus==3){
    			$logged_userGroups = getUserGroups($logged_username);
    			$requestArray->where('d.branch_id',$logged_userGroups->branch_id);
    		}else if($apr_viewStatus==4){
    			$logged_userGroups = getUserGroups($logged_username);
    		
    			$all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
    			//	dd(is_array($all_other_branch_ids), count($all_other_branch_ids));
    // 			if(is_array($all_other_branch_ids) && count($all_other_branch_ids)>0){
                if(count($all_other_branch_ids)>0){
    				$array_i = array();
    				for($b_id_i = 0; $b_id_i<count($all_other_branch_ids); $b_id_i++){
    					$array_i[] = $all_other_branch_ids[$b_id_i]->id;
    				}
    				$str_branch_ids = $array_i;
    			//	dd($str_branch_ids);
    			    //$str_branch_ids = explode(",",$str_branch_ids);
                    $requestArray->whereIn('d.branch_id',$str_branch_ids);
    			}
    		}
                $requestArray->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name,  leave_name.name as typename, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, b.is_hourly ")
                ->union($requestArray12)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 5 THEN 1 ELSE 2 END), date  DESC');

        $requests = $requestArray->get();




        $requests->map(function($item) {
            $user = User::where('id' , Auth::id())->first();
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $lastapprover = DB::table('map_employee_approver')->where('employee_id', $item->username)->orderby('approver_index','desc')->first();
            $lastapprover11 = DB::table('map_employee_approver')->where('approver_id', $user->username)->first();
           
            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $r_name = '';
            if($item->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $item->relieve)->first();
                $r_name = $employee->name;
            }
            if($item->type=='Other_pay'){
                $type='Replacement';
            }
            elseif($item->type=='Line_Shut'){
                $type='Out Of Office';
                
            }
            else{
                $type=$item->type;
            }
            if($item->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($item->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($item->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($item->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($item->status == 4)
            {
                $status = 'Cancelled';
                $class= '#00cfe8';
            }
            elseif($item->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			elseif($item->half_day_type=='second'){
				$htype='PM';
			}
			else{
				$htype='';
			}
			if($item->approver_id != Auth::user()->username && $item->date_approved!='' || $item->approver_id != Auth::user()->username && $item->date_approved=='' || $item->status == 4 || $item->status == 2){
               $dradio ='disabled ';
             }
             elseif($item->approver_id==''){
                $dradio ='disabled ';
             }
             else{
                 $dradio='';
             }
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->r_name = $r_name;
            $item->leave_type  = $item->typename;
            $item->dradio  = $dradio;
            if($lastapprover!=''){
                $item->lastindex = $lastapprover->approver_index;
            }
            else{
                $item->lastindex = '';
            }
            if($lastapprover11!=''){
                $item->userindex = $lastapprover11->approver_index;
            }
            else{
                $item->userindex = '';
            }
            return $item;
        });
        // echo'<pre>';
        // print_r($requests);
        // die();
       return DataTables::of($requests)->make(true);
    }
    
    function filteremployee(Request $request){
		$name=$request->get('name');
		$user = User::where('id' , Auth::id())->first();
        $employees11 =MapEmployeeApprover::leftJoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->select('map_employee_approver.*', 'user_personal.name', 'user_personal.username')->where('map_employee_approver.approver_id' , $user->username)->groupBy('map_employee_approver.employee_id');
		
		if($name && $name != '')
		{
            $employees11->where(function($query){
				$query->whereRaw('(user_personal.name like ("'.request()->name.'%") OR user_personal.employee_no like ("'.request()->name.'%") OR user_personal.username like ("'.request()->name.'%"))');
			});
        }
        		
        $employees = $employees11->orderby('name','asc')->get();
		return $employees;
	}
    public function applyBehalf()
    {
        $user = User::where('id' , Auth::id())->first();
        $company_id = '';
        if (!empty($user->company_id)) {
            $company_id = $user->company_id;
        }
        $upaydetails = UserPersonal::where('username' , $user->username)->first();
        if($upaydetails->sex==1){
            if($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1){
                 $leaveTypes  = Leavetype::where('type','!=','Maternity')->where('type','!=','Paternity')->where('is_show',1);
            }else{
                $leaveTypes  = Leavetype::where('type','!=','Maternity')->where('is_show',1);
            }
        }
        else{
            if($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1){
                 $leaveTypes  = Leavetype::where('type','!=','Maternity')->where('is_show',1);
            }else{
                $leaveTypes  = Leavetype::where('is_show',1);
            }
            
        }
        
        if($upaydetails->marital_status == 1){
            $leaveTypes->where('type','!=','Marriage');
        }
        if($upaydetails->marital_status == 'Married'){
            $leaveTypes->where('type','!=','Marriage');
        }
        
        $leaveTypes=$leaveTypes->get();
        $relieves = Relieve::leftjoin('user_pay','user_pay.username','=','user_personal.username')->leftjoin('users','users.username','=','user_personal.username')->where('users.company_id',$user->company_id)->where('user_pay.pay_status',1)->orderBy('user_personal.name')->get();
        $employees = MapEmployeeApprover::where('approver_id', $user->username)->leftjoin('user_personal','map_employee_approver.employee_id','=','user_personal.username')->where('user_personal.name','!=',null)->groupBy('map_employee_approver.employee_id')->orderby('user_personal.name','asc')->get();
   
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        $holidays = PublicHoliday::where('company_id', $user->company_id)->where('date', '>=', $startOfYear->format('Y-m-d'))->where('date', '<=', $endOfYear->format('Y-m-d'))->get();
        $leavesArray = Leavelist::selectRaw("leave_list.*,user_personal.name as name, map_employee_approver.*, leave_name.name as typename, CONCAT(leave_list.username, leave_list.start_date) as usergroup, leave_list.start_time, leave_list.end_time")->leftjoin('map_employee_approver','map_employee_approver.employee_id','=','leave_list.username')->leftjoin('user_personal','user_personal.username','=','leave_list.username')->leftjoin('leave_name', 'leave_name.type','=','leave_list.type')->where('map_employee_approver.approver_id', $user->username)->groupBy('usergroup')->orderBy('leave_list.date_applied' , 'DESC')->with('getType')->where('leave_list.status', '1')->get();
        // dd($leavesArray);
        
		$leavesArray->transform(function ($item) {
		    if($item->getType != null){
                $item->background_color = $item->getType->leave_color;   
		    }else{ 
                $item->background_color = "#4298a1";
		    }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			elseif($item->half_day_type=='second'){
				$htype='PM';
			}
			else{
				$htype='';
			}
			if($item->type=='Line_Shut'){
				$iname='Out Of Office';
				$colornm="#4298a1";
			 }
            if($item->type=='Other_pay'){
				$iname='Replacement';
				$colornm='#000000';
			}
			else{
				$iname=$item->type;
				$colornm=$item->background_color;
			}
               // dd($employee->name);
               $r_name = $item->name;
            if($item->is_hourly!=0){ 
                $time = '('.date('h:i A', $item->start_time) . ' to ' . date('h:i A', $item->end_time).')';
            } else 
            { 
                $time = ''; 
            }   
			
            return [
               'title' => $r_name.' ('.$item->typename.')'.$htype.' '.$time,
			
				'start' => date('Y-m-d', strtotime($item->start_date)),
				'type' => $item->type,
				'color' =>  $colornm,
				'text_color' => '#fff',
				//'extendedProps' => [
				//	'calendar' => $item->type,
				//]
            ];

        })->toArray();
		//$restDay = DB::table('rest_days')
		//			->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
// 		$rest_day_type = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->get();
// 		$rest_day_id=$rest_day_type['0']->category_id;
// 		$rest_day_cat = DB::table('rest_day_category')->where('id', $rest_day_id)->get();
// 		$rest_cat_name = array();
// 		if($rest_day_id!=0){
//     		foreach(explode('-', $rest_day_cat['0']->category) as $cat) { 
//     			$rest_cat_name11 = substr($cat,0 ,3); 
//     			array_push($rest_cat_name,$rest_cat_name11);
//     		}
// 		}
// 		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->whereRaw('DATE_FORMAT(STR_TO_DATE(date, "%Y-%m-%d"),"%a") IN ("'.implode('","',$rest_cat_name).'")')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
//  		$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id',$user->username)->select('employee_id')->first();
        
        $recat = DB::table('rest_day_category_employee')->where('employee_id',$user->username)->select('category_id')->first();
        
		if($rday!=''){
		    
			$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('user_personal','rest_days.employee_id','=','user_personal.username');
			if($recat!=''){
			    
			    $restDay->leftjoin('rest_day_category_employee','rest_days.category_id','=','rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
			    
			}
			$restDay = $restDay->where('rest_days.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
			
		}else{
		    
			
			$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal','rest_days.employee_id','=','user_personal.username')->leftjoin('rest_day_category_employee','rest_days.category_id','=','rest_day_category_employee.category_id');
			if($recat!=''){
			    
			    $restDay->where('rest_days.category_id', $recat->category_id);
			    
			}
			$restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
		}
 						
		$restDay->transform( function($item) {

			return [

				'title' => 'Rest Day',
				'type' => '',
				'start' => date('Y-m-d', strtotime($item->date)),
				//'color' =>  $item->background_color,
				//'extendedProps' => [
				//	'calendar' => 'Marriage',
				//]
				'text_color' => '#000',
                'color' =>  '#e0e0e0',
			];
		})->toArray();
		
		$userPay = DB::table('user_pay')->where('username', $user->username)->first();
		$branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
		if($branchData != null){
			$userState = $branchData->state;
			// $branchId = $branchData->id;
		}else{
			$userState = "zzzzzzz";
			// $userState = 0;
		}
		$recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date','ASC')->where('company_id', $user->company_id)
		->whereYear('date', '=', date('Y'))->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "'.$userState.'")')->groupBy('date_holiday')->get();
        $recentHoliday->transform( function($item11) {

            return [

                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'text_color' => '#fff',
                'color' =>  '#28c76f',
            ];
        })->toArray();		
        $leaves11 = $restDay->merge($leavesArray);
        $leaves = $leaves11->merge($recentHoliday);
        $relieveallow=DB::table('settings')->where('field','leave_relieve_allow')->where('company_id',$user->company_id)->first();
		$halfdayallow=DB::table('settings')->where('field','halfdayleave')->where('company_id',$user->company_id)->first();
        return view('approvals.apply-behalf', compact('company_id','leaveTypes','upaydetails', 'relieves', 'employees', 'holidays','leaves','relieveallow','halfdayallow'));
    }
    
    public function leaveType(Request $request){
        $uname = $request->username ?? Auth::user()->username;
        $upaydetails = UserPersonal::where('username' , $uname)->first();
        if($upaydetails->sex==1){
            if($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1){
                 $leaveTypes  = Leavetype::where('type','!=','Maternity')->where('type','!=','Paternity')->where('is_show',1);
            }else{
                $leaveTypes  = Leavetype::where('type','!=','Maternity')->where('is_show',1);
            }
        }elseif($upaydetails->sex==0){
            if($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1){
                 $leaveTypes  = Leavetype::where('type','!=','Paternity')->where('type','!=','Maternity')->where('is_show',1);
            }else{
                $leaveTypes  = Leavetype::where('type','!=','Paternity')->where('is_show',1);
            }
            
        }
        else{
            if($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1){
                 $leaveTypes  = Leavetype::where('type','!=','Paternity')->where('type','!=','Maternity')->where('is_show',1);
            }else{
                $leaveTypes  = Leavetype::where('is_show',1);
            }
        }
        
        if($upaydetails->marital_status == 1){
            $leaveTypes->where('type','!=','Marriage');
        }
        if($upaydetails->marital_status == 'Married'){
            $leaveTypes->where('type','!=','Marriage');
        }
        
        $leaveTypes=$leaveTypes->get();
        return $leaveTypes;
    }

    public function storeBehalf(Request $request)
    {
        $this->validate($request,[
            "username"=>"required",
    		"leave_type"=>"required",
    		"hof"=>"required",
    		"leave_start_date"=>"required|date",
    		"leave_end_date"=>"nullable|date",
    		"reason"=>"nullable",
    		//"relieve"=>"required"
    	],
        [
            'username.required' => 'Employee field is requird'
        ]
        );

    	$user = User::where('id' , $request->user_id)->first();
    	$leave_start_date = new DateTime($request->leave_start_date);
    	$leave_end_date = new DateTime($request->leave_end_date);
    	if(!empty($request->leave_end_date)){
    		$no_days = $leave_start_date->diff($leave_end_date);
    		$no_days = $no_days->format('%a');
    	}
    	else{
			$no_days =0.5;
		}
        if($no_days==0.5){
			$ndays=1;
		}
		else{
			$ndays=$no_days+1;
		}
		
		$startdate = $request->leave_start_date;
        $startdate = strtotime($startdate);
        $startdate = strtotime("-1 day", $startdate);
		for($ndayss=1; $ndayss<=$ndays; $ndayss++){

			$sdate = strtotime("+$ndayss day", $startdate);
			$sdate = date('Y-m-d', $sdate);
			$leaveexists = Leavelist::where('username' , $request->username)->where('start_date',$sdate)->first();
            if($request->hof==1){
				$half_day_type=$request->half_day_type;
				$nodays=0.5;
			}
			else{
				$half_day_type='';
				$nodays=1.0;
			}
		if(!$leaveexists)
		{
			

                $leave = Leavelist::create([
                    "username" => $request->username,
                    "approver_id" => $user->username,
                    "type" => $request->leave_type,
                    "is_half_day" => $request->hof,
                    "start_date" => $sdate,
                    "end_date" => $sdate,
                    "no_days" => $nodays,
                    "half_day_type" => $half_day_type,
                    "reason" => $request->reason,
                    "date_applied" => now(),
                    'status' => $request->status,
                    "relieve" => $request->relieve,

                ]);



                $leaveDay = LeaveDay::create([
                    'leave_id' => $leave->id,
                    'username' => $user->username,
                    'date' => $sdate,
                    'cancellation_reason' => '',
                    'status' => $request->status,
                    'reject_reason' => ''

                ]);
        }
        }
        if($request->status == '1')
        {
            $history = LeaveEntitleHistory::where('username', $request->username)
            ->where('year', carbon()->year)->where('leave_type', $request->leave_type)->first();

            if(isset($history))
            {
                $history->leave_taken = $history->leave_taken + $nodays;
                $history->save();

            }
        }

        return redirect()->back()->with('statusMsg', 'Successfully Created');
    }
    public function hasContentPreference($username)
    {
            $epreferences = DB::table('email_content_preferences')->selectRaw("employee_id")->where('employee_id', $username)->first();
        
            if($epreferences == ""){
                return FALSE;
            }      
            else{
                return TRUE;
            }
                    
    }

    public function approveLeave(Request $request)
	{
       
        $user = User::where('id' , Auth::id())->first();
		$leaves = Leavelist::where('id', $request->id)->first();
        $day = LeaveDay::where('leave_id',$request->id)->first();
        $user_personal = UserPersonal::where('username',$leaves->username)->first();
        $leaves->status = "1";
        $leaves->date_approved = date('Y-m-d');
        $leaves->save();
        $day->status = "1";
        $day->save();
        $approver = new ApproverApprovedLeave;
    			$approver->leave_days_id = $day->id;
				$approver->approver_id = $user->username;
                $approver->save();
                
        $getEmailSendByPrefernces = DB::table('settings')->where('field' , "email_send_by_preferneces")->first();
		if ($getEmailSendByPrefernces->value == "1") {
			if (!$this->hasContentPreference($leaves->username)) {
				$email_send_allow = true;
			} else {
				$email_send_allow = false;
			}
        }
        if ($email_send_allow) {
            $emailSendingStatus = DB::table('settings')->where('field' , "email_by_cronjob")->first();
            if ($emailSendingStatus->value == '0') {
                $subject = "Leave Approved";
                $email = $user_personal->email_id;
                $emp_name = $user_personal->name;
				$from_date = $leaves->start_date;
					$to_date = $leaves->end_date;
                    $type_display = $leaves->type;
                    if($leaves->type=='Other_pay'){
                        $type_display="Replacement";
                    }
                    if($leaves->type=='Line_Shut'){
                        $type_display='Out Of Office';
                    }
					$reason = $leaves->reason;
					$username = $leaves->username;
					$half_day_type = '';
					if ($leaves->half_day_type != '' && $leaves->is_half_day != '0') {
						$half_day_type = ($leaves->half_day_type != "first") ? "(PM)" : "(AM)";
					}

					$body = "Dear $emp_name<br><br>";
					$body .= "Your leave has been Approved<br><br>";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "From: ".date("d-m-Y",strtotime($from_date))."<br>";
					$body .= "To: ".date("d-m-Y",strtotime($to_date))."<br><br>";
					$body .= "Type: $type_display $half_day_type<br>";
					$body .= "Reason: $reason<br><br>";
					$body .= "Kind regards,<br><br>";
					$body .= "Note: this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";
                    //Mail::to($email)->send(new MyDemoMail($body));
                    sendemail($email,$subject,$body);
                    
                    // if (Mail::failures()) {
                    //     return 0;
                    // }
                    return 1;

            }
            else {
					$subject = "Leave Approved";

					$emp_name = $user_personal->name;
					$from_date = $leaves->start_date;
					$to_date = $leaves->end_date;
					$type_display = $leaves->type;
                    if($leaves->type=='Other_pay'){
                        $type_display="Replacement";
                    }
                    if($leaves->type=='Line_Shut'){
                        $type_display='Out Of Office';
                    }
                    $reason = $leaves->reason;
                    $username = $leaves->username;
				
					$body = "<tr>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
					$body .= "<td>$type_display Leave</td>";
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords("Approved") . "</td>";
					$body .= "<td>  </td>";
					$body .= "</tr>";
                    $query = PendingEmail::create([
                        "emp_name" => $emp_name,
                        "email_to" => $username,
                        "email_body" => $body,
                        "email_subject" => $subject,
                        "leave_status" => "approved",
                        "sent_status" => '0',
                        "leave_username" => $username,
            
                     ]);
					
            }
		

        }
		return 1;
	}

    public function rejectLeave(Request $request)
	{
        $leaves = Leavelist::where('id', $request->id)->first();
        $day = LeaveDay::where('leave_id',$request->id)->first();
        $user_personal = UserPersonal::where('username',$leaves->username)->first();
        $leaves->status = "2";
        $leaves->date_approved = date('Y-m-d');
        $leaves->save();
        $day->status = "2";
        $day->reject_reason = $request->reject_reason;
        $day->save();
        $getEmailSendByPrefernces = DB::table('settings')->where('field' , "email_send_by_preferneces")->first();
		if ($getEmailSendByPrefernces->value == "1") {
			if (!$this->hasContentPreference($leaves->username)) {
				$email_send_allow = true;
			} else {
				$email_send_allow = false;
			}
        }
        if ($email_send_allow) {
            $emailSendingStatus = DB::table('settings')->where('field' , "email_by_cronjob")->first();
            if ($emailSendingStatus->value == '0') {
                $subject = "Leave Rejected";
                $email = $user_personal->email_id;
                $emp_name = $user_personal->name;
				$from_date = $leaves->start_date;
					$to_date = $leaves->end_date;
                    $type_display = $leaves->type;
                    if($leaves->type=='Other_pay'){
                        $type_display="Replacement";
                    }
                    if($leaves->type=='Line_Shut'){
                        $type_display='Out Of Office';
                    }
					$reason = $leaves->reason;
					$username = $leaves->username;
					$half_day_type = '';
					if ($leaves->half_day_type != '' && $leaves->is_half_day != '0') {
						$half_day_type = ($leaves->half_day_type != "first") ? "(PM)" : "(AM)";
					}

					$body = "Dear $emp_name<br><br>";
					$body .= "Your leave has been Rejected<br><br>";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
					$body .= "Type: $type_display $half_day_type<br>";
					$body .= "Reason: $reason<br><br>";
					$body .= "Kind regards,<br><br>";
					$body .= "Note: this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";
                    //Mail::to($email)->send(new MyDemoMail($body));
                    sendemail($email,$subject,$body);
                    
                    // if (Mail::failures()) {
                    //     return 0;
                    // }
                    return 1;

            }
            else {
					$subject = "Leave Rejected";

					$emp_name = $user_personal->name;
					$from_date = $leaves->start_date;
					$to_date = $leaves->end_date;
					$type_display = $leaves->type;
                    if($leaves->type=='Other_pay'){
                        $type_display="Replacement";
                    }
                    if($leaves->type=='Line_Shut'){
                        $type_display='Out Of Office';
                    }
                    $reason = $leaves->reason;
                    $username = $leaves->username;
				
					$body = "<tr>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
					$body .= "<td>$type_display Leave</td>";
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords("Rejected") . "</td>";
					$body .= "<td>  </td>";
					$body .= "</tr>";
                    $query = PendingEmail::create([
                        "emp_name" => $emp_name,
                        "email_to" => $username,
                        "email_body" => $body,
                        "email_subject" => $subject,
                        "leave_status" => "rejected",
                        "sent_status" => '0',
                        "leave_username" => $username,
            
                     ]);
					
            }
		

        }
		return 1;
	}

    public function leaveCancellation(Request $request)
	{
		$leaves = Leavelist::whereIn('id', $request->id)->get();

        foreach($leaves as $leave)
        {
		// $leave = Leavelist::find($id);
            $day = LeaveDay::where('leave_id', $leave->id)->first();
            $user_personal = UserPersonal::where('username',$leave->username)->first();
            $leave->status = "4";
            $leave->date_approved = date('Y-m-d');
            $leave->save();

            $day->status = "4";
            $day->cancellation_reason = $request->reason;
            $day->save();

            $getEmailSendByPrefernces = DB::table('settings')->where('field' , "email_send_by_preferneces")->first();
            if ($getEmailSendByPrefernces->value == "1") {
                if (!$this->hasContentPreference($leave->username)) {
                    $email_send_allow = true;
                } else {
                    $email_send_allow = false;
                }
            }
            if ($email_send_allow) {
                $emailSendingStatus = DB::table('settings')->where('field' , "email_by_cronjob")->first();
                if ($emailSendingStatus->value == '0') {
                    $subject = "Leave Cancelled";
                    $email = $user_personal->email_id;
                    $emp_name = $user_personal->name;
                    $from_date = $leave->start_date;
                        $to_date = $leave->end_date;
                        $type_display = $leave->type;
                        if($leave->type=='Other_pay'){
                            $type_display="Replacement";
                        }
                        if($leave->type=='Line_Shut'){
                            $type_display='Out Of Office';
                        }
                        $reason = $leave->reason;
                        $username = $leave->username;
                        $half_day_type = '';
                        if ($leave->half_day_type != '' && $leave->is_half_day != '0') {
                            $half_day_type = ($leave->half_day_type != "first") ? "(PM)" : "(AM)";
                        }

                        $body = "Dear $emp_name<br><br>";
                        $body .= "Your leave has been Cancelled<br><br>";
                        $body .= "Details of the leave are as follows:<br><br>";
                        $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                        $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                        $body .= "Type: $type_display $half_day_type<br>";
                        $body .= "Reason: $reason<br><br>";
                        $body .= "Kind regards,<br><br>";
                        $body .= "Note: this is an automatic email. Please do not reply. ";
                        $body .= "If you did not request this information, please ignore this message. ";
                        $body .= "If you have any questions, please contact us";
                        sendemail($email,$subject,$body);
                        //Mail::to($email)->send(new MyDemoMail($body));
                        
                        // if (Mail::failures()) {
                        //     return 0;
                        // }
                        return 1;

                }
                else{
                    $subject = "Leave Cancelled";

                    $emp_name = $user_personal->name;
                    $from_date = $leave->start_date;
                    $to_date = $leave->end_date;
                    $type_display = $leave->type;
                    if($leave->type=='Other_pay'){
                        $type_display="Replacement";
                    }
                    if($leave->type=='Line_Shut'){
                        $type_display='Out Of Office';
                    }
                    $reason = $leave->reason;
                    $username = $leave->username;
                
                    $body = "<tr>";
                    $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                    $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                    $body .= "<td>$type_display Leave</td>";
                    $body .= "<td>$reason</td>";
                    $body .= "<td>" . ucwords("Cancelled") . "</td>";
                    $body .= "<td>  </td>";
                    $body .= "</tr>";
                    $query = PendingEmail::create([
                        "emp_name" => $emp_name,
                        "email_to" => $username,
                        "email_body" => $body,
                        "email_subject" => $subject,
                        "leave_status" => "Cancelled",
                        "sent_status" => '0',
                        "leave_username" => $username,
            
                    ]);
                }
            }
            
        }


		return 1;
    }
    
    public function approve_search(Request $request)
    {

        $user = User::where('id' , Auth::id())->first();

        
        $requestArray12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
        ->leftjoin('category as cat','d.category_id','=','cat.id')
        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
        ->leftjoin('department as e','d.department_id','=','e.id')
        ->leftjoin('leave_name', 'leave_name.type','=','b.type')
        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
        ->where('app_lv.approver_id',$user->username);

        if($request->get('name') && $request->get('name') != '')
        {
             $requestArray12->where(function($query){
                    $query->whereRaw('(c.name like ("'.request()->name.'%") OR c.employee_no like ("'.request()->name.'%"))');
                });
                }
                if($request->get('status') != '')
                {
                    $requestArray12->where('leave_days.status', $request->get('status'));
                }

                if($request->get('type') && $request->get('type') != '')
                {
                    $requestArray12->where('b.type', $request->get('type'));
                }
            

                $requestArray12->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name, leave_name.name as typename, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,b.is_hourly");
                
                
        $requestArray =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->leftjoin('leave_name', 'leave_name.type','=','b.type')
                ->where('b.approver_id',$user->username);
                if($request->get('name') && $request->get('name') != '')
                {
                    $requestArray->where(function($query){
                        $query->whereRaw('(c.name like ("'.request()->name.'%") OR c.employee_no like ("'.request()->name.'%"))');
                    });
                    
                }
                if($request->get('status') != '')
                {
                    $requestArray->where('leave_days.status', $request->get('status'));
                }

                if($request->get('type') && $request->get('type') != '')
                {
                    $requestArray->where('b.type', $request->get('type'));
                }
            
                
        $requestArray->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id,b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name, leave_name.name as typename,CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,b.is_hourly")
        ->union($requestArray12)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 1 THEN 1 ELSE 2 END), (CASE WHEN status = 0 THEN UNIX_TIMESTAMP(date) WHEN status = 1 THEN -UNIX_TIMESTAMP(date) ELSE -UNIX_TIMESTAMP(date) END) ASC');

        
            $leaveTypes  = Leavetype::where('is_show',1)->get();
       
            $requests = $requestArray->get();




        $requests->map(function($item) {
            $user = User::where('id' , Auth::id())->first();
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $lastapprover = DB::table('map_employee_approver')->where('employee_id', $item->username)->orderby('approver_index','desc')->first();
            $lastapprover11 = DB::table('map_employee_approver')->where('approver_id', $user->username)->first();
           
            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $r_name = '';
            if($item->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $item->relieve)->first();
                $r_name = $employee->name;
            }
            if($item->type=='Other_pay'){
                $type='Replacement';
            }
            elseif($item->type=='Line_Shut'){
                $type='Out Of Office';
                
            }
            else{
                $type=$item->type;
            }
            if($item->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($item->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($item->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($item->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($item->status == 4)
            {
                $status = 'Cancelled';
                $class= '#00cfe8';
            }
            elseif($item->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			elseif($item->half_day_type=='second'){
				$htype='PM';
			}
			else{
				$htype='';
			}
			if($item->approver_id != Auth::user()->username && $item->date_approved!='' || $item->approver_id != Auth::user()->username && $item->date_approved=='' || $item->status == 4 || $item->status == 2){
               $dradio ='disabled ';
             }
             elseif($item->approver_id==''){
                $dradio ='disabled ';
             }
             else{
                 $dradio='';
             }
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->r_name = $r_name;
            $item->leave_type  = $item->typename;
            $item->dradio  = $dradio;
            if($lastapprover!=''){
                $item->lastindex = $lastapprover->approver_index;
            }
            else{
                $item->lastindex = '';
            }
            if($lastapprover11!=''){
                $item->userindex = $lastapprover11->approver_index;
            }
            else{
                $item->userindex = '';
            }
            return $item;
        });

        //return $requests;
        return DataTables::of($requests)->make(true);

    }


    public function approve_search1(Request $request)
    {

        $user = User::where('id' , Auth::id())->first();

        $requestArray12 =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
        ->leftjoin('user_personal as c','leave_days.username','=','c.username')
        ->leftjoin('user_pay as d','leave_days.username','=','d.username')
        ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
        ->leftjoin('category as cat','d.category_id','=','cat.id')
        ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
        ->leftjoin('department as e','d.department_id','=','e.id')
        ->leftjoin('leave_name', 'leave_name.type','=','b.type')
        ->join('approver_approved_leaves as app_lv','leave_days.id','=','app_lv.leave_days_id')
        ->where('app_lv.approver_id',$user->username);

                if($request->get('name') && $request->get('name') != '')
                {
                    $requestArray12->where(function($query){
                            $query->whereRaw('(c.name like ("'.request()->name.'%") OR c.employee_no like ("'.request()->name.'%"))');
                        });
                }
        
                if($request->get('status') && $request->get('status') != '')
                {
                    $requestArray12->where('b.status', $request->get('status'));
                }

                if($request->get('type') && $request->get('type') != '')
                {
                    $requestArray12->where('b.type', $request->get('type'));
                }
            
                if($request->get('phone') && $request->get('phone') != '')
                {
                    $personals11 = DB::table('user_personal')->where('employee_no', $request->get('phone'))
                                ->pluck('username')->toArray();
                    $requestArray12->whereIn('b.username', $personals11);
                }
                if($request->get('category') && $request->get('category') != '')
                {
                    $personals12 = DB::table('user_pay')->where('category_id', $request->get('category'))
                                ->pluck('username')->toArray();
                    $requestArray12->whereIn('b.username', $personals12);
                }
                if($request->get('dept') && $request->get('dept') != '')
                {
                    $personals13 = DB::table('user_pay')->where('department_id', $request->get('dept'))
                                ->pluck('username')->toArray();
                    $requestArray12->whereIn('b.username', $personals13);
                }
                $from = $request->get('from');
                $to = $request->get('to');
                if($from != '' && $to != ''){
                    $requestArray12->whereBetween('leave_days.date', [$from, $to]);
                }
            elseif($from != '')
                {
                    $requestArray12->where('leave_days.date', '=', $from);
                }

                elseif($to != '')
                {
                    $requestArray12->where('leave_days.date', '=', $to);
                }
            

        $requestArray12->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason,e.name as Department,c_r.name as r_name, leave_name.name as typename, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, b.is_hourly");
                
                
        $requestArray =LeaveDay::leftjoin('leave_list as b','leave_days.leave_id','=','b.id')
                ->leftjoin('user_personal as c','leave_days.username','=','c.username')
                ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                ->leftjoin('branch as brnch','d.branch_id','=','brnch.id')
                ->leftjoin('category as cat','d.category_id','=','cat.id')
                ->leftjoin('user_personal as c_r','b.relieve','=','c_r.username')
                ->leftjoin('department as e','d.department_id','=','e.id')
                ->leftjoin('leave_name', 'leave_name.type','=','b.type')
                ->where('b.approver_id',$user->username);
                if($request->get('name') && $request->get('name') != '')
                {
                    $requestArray->where(function($query){
                        $query->whereRaw('(c.name like ("'.request()->name.'%") OR c.employee_no like ("'.request()->name.'%"))');
                    });
                    
                }
        
                if($request->get('status') && $request->get('status') != '')
                {
                    $requestArray->where('b.status', $request->get('status'));
                }

                if($request->get('type') && $request->get('type') != '')
                {
                    $requestArray->where('b.type', $request->get('type'));
                }
            
                if($request->get('phone') && $request->get('phone') != '')
                {
                    $personals11 = DB::table('user_personal')->where('employee_no', $request->get('phone'))
                                ->pluck('username')->toArray();
                    $requestArray->whereIn('b.username', $personals11);
                }
                if($request->get('category') && $request->get('category') != '')
                {
                    $personals12 = DB::table('user_pay')->where('category_id', $request->get('category'))
                                ->pluck('username')->toArray();
                    $requestArray->whereIn('b.username', $personals12);
                }
                if($request->get('dept') && $request->get('dept') != '')
                {
                    $personals13 = DB::table('user_pay')->where('department_id', $request->get('dept'))
                                ->pluck('username')->toArray();
                    $requestArray->whereIn('b.username', $personals13);
                }
                $from = $request->get('from');
                $to = $request->get('to');
                if($from != '' && $to != ''){
                    $requestArray->whereBetween('leave_days.date', [$from, $to]);
                }
            elseif($from != '')
                {
                    $requestArray->where('leave_days.date', '=', $from);
                }

                elseif($to != '')
                {
                    $requestArray->where('leave_days.date', '=', $to);
                }
            
                
        $requestArray->selectRaw("(select name from user_personal where user_personal.username = b.approver_id) as approvername, leave_days.id, b.id as lid, leave_days.username, c.name, c.employee_no, b.type, b.approver_id, b.filename, brnch.name as branch_name, cat.name as category_name, b.date_applied as date_applied, leave_days.date as date, leave_days.date as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status as status, b.reason, CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, e.name as Department, c_r.name as r_name, leave_name.name as typename, CASE b.is_hourly WHEN 1 THEN ( (b.end_time-b.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, b.is_hourly")
        ->union($requestArray12)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 5 THEN 1 ELSE 2 END), date  ASC');

        
        $leaveTypes  = Leavetype::where('is_show',1)->get();
        
        $requests = $requestArray->get();



        $requests->map(function($item) {
            $user = User::where('id' , Auth::id())->first();
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $lastapprover = DB::table('map_employee_approver')->where('employee_id', $item->username)->orderby('approver_index','desc')->first();
            $lastapprover11 = DB::table('map_employee_approver')->where('approver_id', $user->username)->first();
            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $r_name = '';
            if($item->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $item->relieve)->first();
                $r_name = $employee->name;
            }
            if($item->type=='Other_pay'){
                $type='Replacement';
            }
            elseif($item->type=='Line_Shut'){
                $type='Out Of Office';
            }
            else{
                $type=$item->type;
            }
            if($item->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($item->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($item->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($item->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($item->status == 4)
            {
                $status = 'Cancelled';
                $class= '#00cfe8';
            }
            elseif($item->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			elseif($item->half_day_type=='second'){
				$htype='PM';
			}
			else{
				$htype='';
			}
            
            if($item->approver_id != Auth::user()->username  && $item->date_approved!='' || $item->approver_id != Auth::user()->username && $item->date_approved=='' || $item->status == 4 || $item->status == 2){
               $dradio ='disabled ';
             }
             elseif($item->approver_id==''){
                $dradio ='disabled ';
             }
             else{
                 $dradio='';
             }
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->r_name = $r_name;
            $item->leave_type  = $item->typename;
            $item->dradio  = $dradio;
            if($lastapprover!=''){
                $item->lastindex = $lastapprover->approver_index;
            }
            else{
                $item->lastindex = '';
            }
            if($lastapprover11!=''){
                $item->userindex = $lastapprover11->approver_index;
            }
            else{
                $item->userindex = '';
            }
            return $item;
        });

        
        return DataTables::of($requests)->make(true);

    }
    
    
    public function approver11(Request $request){
		
		$data = approveleave(Auth::user()->username,$request->ids,$request->status,$request->cancel_reason,$request->reject_reason,$request->action);
        
        return Response::json(json_decode($data), 200);

	}
	
	
    public function selfapprover(Request $request){
		
		$data = selfleave($request->ids,$request->status,$request->cancel_reason,$request->reject_reason,$request->action);
        
        return Response::json(json_decode($data), 200);

	}
        public function approver(Request $request){

		//$data = approveleave(Auth::user()->username,$request->ids,$request->status,$request->cancel_reason,$request->reject_reason,$request->action);
		if($request->action =='cancelMultipleLeave'){
			
			$data = $this->cancelMultipleLeave(request());
		}
		else{
	
			$data = $this->multipleSetStatus(request());
		}
        
      //  return Response::json($data, 200);
    }
    
    public function approverr(Request $request){
		
		//$data = approveleave(Auth::user()->username,$request->ids,$request->status,$request->cancel_reason,$request->reject_reason,$request->action);
		if($request->action=='cancelMultipleLeave'){
			
			$data = $this->cancelMultipleLeave(request());
		}
		else{
			
			$data = $this->multipleSetStatuss(request());
		}
        
      //  return Response::json($data, 200);
    }

   public function multipleSetStatuss(Request $request){

		$ids = $request->ids;
		//dd($ids);
		sort($ids);
		$status = $request->status;
		$multipleSetStatus = $request->multipleSetStatus;
		$this->total_Emergency = 0;
		
// 		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
//         $cutOffMonth = $cutOffMonth11->value;
//         $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
//         $cutOffDate=$cutOffDate11->value;
//         $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
//         $cutOffStartDate=$cutOffStartDate11->value;
//         $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
//         $cutOffStartMonth=$cutOffStartMonth11->value;
//         $user = User::where('id' , Auth::id())->first();
//         $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
// 		$LeaveMultipleApprover = $getLeaveMultipleApprover->value;
// 		$npl_to_hr1=DB::table('settings')->where('field','npl_to_hr')->first(); 
// 		$emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
//         $emailSendingStatus = $emailSendingStatus1->value ?? 0;
//         $uname = UserPersonal::where('username',$user->username)->first();
//         $Cancel_leave_to_hr1=DB::table('settings')->where('field','cancel_leave_to_hr')->first();
//         $Cancel_leave_to_hr = $Cancel_leave_to_hr1->value;
//     	$SoftwareStartDate1=DB::table('settings')->where('field','software_start_year')->first();
//         $SoftwareStartDate = $SoftwareStartDate1->value;
//     	$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
//         $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
//         $workForEarnSetting1=DB::table('settings')->where('field','WorkForEarn')->first();
//         $workForEarnSetting = $workForEarnSetting1->value;
//         $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
//         $sendbypreference = $sendbypreference1->value;
//         $companyName11 = DB::table('settings')->where('field', "company")->first();
// 		$medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
// 		$medical_pro_rated = $medical_pro_rated11->value;	
            
		for ($i = 0; $i < count($ids); $i++) {
		    if($request->status_val && $request->status_val=='status_val'){
		       // dd('hello1');
		       $stats= $request->status;
		    }
		    else{
		       // dd('hello2');
		        $stats = $status[$i];
		    }
		    
		  //  $values['id'] = $request->ids[$i];
		  //  $values['approver_id'] ='';
    //         $values['status'] = $stats;
    //         $values['res'] = $request->all();
    //         $values['auth_id'] = Auth::id();
				    
           // SetStatusJob::dispatch($values);
        //   setStatus($request->ids[$i],'', $stats,request(),$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$user,$LeaveMultipleApprover,$npl_to_hr1,$emailSendingStatus,$uname,$Cancel_leave_to_hr,$SoftwareStartDate,$SettingLeaveAdjustmentType,$workForEarnSetting,$sendbypreference,$companyName11,$medical_pro_rated);
			$this->setStatuss($request->ids[$i], '', $stats,request());
		}
 		sendEmailNow();
		
//         return array(
//             'result' => true
//       );
		

	}

    public function multipleSetStatus(Request $request){
        //dd($request);
		$ids = $request->ids;
		//dd($ids);
		sort($ids);
		$status = $request->status;
		$multipleSetStatus = $request->multipleSetStatus;
		$this->total_Emergency = 0;
		
// 		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
//         $cutOffMonth = $cutOffMonth11->value;
//         $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
//         $cutOffDate=$cutOffDate11->value;
//         $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
//         $cutOffStartDate=$cutOffStartDate11->value;
//         $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
//         $cutOffStartMonth=$cutOffStartMonth11->value;
//         $user = User::where('id' , Auth::id())->first();
//         $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
// 		$LeaveMultipleApprover = $getLeaveMultipleApprover->value;
// 		$npl_to_hr1=DB::table('settings')->where('field','npl_to_hr')->first(); 
// 		$emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
//         $emailSendingStatus = $emailSendingStatus1->value ?? 0;
//         $uname = UserPersonal::where('username',$user->username)->first();
//         $Cancel_leave_to_hr1=DB::table('settings')->where('field','cancel_leave_to_hr')->first();
//         $Cancel_leave_to_hr = $Cancel_leave_to_hr1->value;
//     	$SoftwareStartDate1=DB::table('settings')->where('field','software_start_year')->first();
//         $SoftwareStartDate = $SoftwareStartDate1->value;
//     	$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
//         $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
//         $workForEarnSetting1=DB::table('settings')->where('field','WorkForEarn')->first();
//         $workForEarnSetting = $workForEarnSetting1->value;
//         $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
//         $sendbypreference = $sendbypreference1->value;
//         $companyName11 = DB::table('settings')->where('field', "company")->first();
// 		$medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
// 		$medical_pro_rated = $medical_pro_rated11->value;	
            
		for ($i = 0; $i < count($ids); $i++) {
		    
		    if($request->status_val && $request->status_val=='status_val'){
		       // dd('hello1');
		       $stats= $request->status;
		    }
		    else{
		       // dd('hello2');
		        $stats = $status[$i];
		    }
		    //dd($stats);
		    
		  //  $values['id'] = $request->ids[$i];
		  //  $values['approver_id'] ='';
    //         $values['status'] = $stats;
    //         $values['res'] = $request->all();
    //         $values['auth_id'] = Auth::id();
				    
           // SetStatusJob::dispatch($values);
        //   setStatus($request->ids[$i],'', $stats,request(),$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$user,$LeaveMultipleApprover,$npl_to_hr1,$emailSendingStatus,$uname,$Cancel_leave_to_hr,$SoftwareStartDate,$SettingLeaveAdjustmentType,$workForEarnSetting,$sendbypreference,$companyName11,$medical_pro_rated);
			$this->setStatus($request->ids[$i], '', $stats, request());
		}
 		sendEmailNow();
		
//         return array(
//             'result' => true
//       );
		

	}
	
	public function cancelMultipleLeave(Request $request)
	{
		$ids = $request->ids;
		for ($i = 0; $i < count($ids); $i++) {
			$this->cancelLeave($ids[$i],request());
		}
		sendEmailNow();
		return array(
            'result' => true
       );
	}
	
	public function deletePastLeave(Request $request)
	{
		$id = $request->id;
		for ($i = 0; $i < count($id); $i++) {
		$result = $this->deletePastLeave11($id);
		}
		return array("result" => $result);
	}

	public function deletePastLeave11($id){

		DB::table('leave_past')->where('id', $id)->delete();
		return true;
	}

	public function cancelLeave($idVal = '',Request $request)
	{
		if ($idVal == '') {
			$id = $request->id;
		} else {
			$id = $idVal;
		}
		
		$leaveDetails = $this->getLeaveDetails($id);
	//	dd($leaveDetails);
		if ($leaveDetails->type == 'Other_pay') {
			for ($_rl_i = 0; $_rl_i < ($leaveDetails->no_days * 2); $_rl_i++) {
				unMarkReplacementLeaveAsTaken($leaveDetails->username);
			}
		}

		$email_send_allow = true;
		$sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
        $sendbypreference = $sendbypreference1->value;
		if ($sendbypreference) {
			if (!hasContentPreference($leaveDetails->username)) {
				$email_send_allow = true;
			} else {
				$email_send_allow = false;
			}
		}

		if ($email_send_allow) {
			if ($idVal != '') {
				$subject = "Leave Cancelled";

				$emp_name = $leaveDetails->name;
				$from_date = $leaveDetails->start_date;
				$to_date = $leaveDetails->end_date;
				$type_display = $leaveDetails->type;
				$reason = $leaveDetails->reason;
				$username = $leaveDetails->username;

				$type_display = getLeaveNameByType($type_display);
				
				$body = "<tr>";
				$body .= "<td>" . date('d-m-Y', strtotime($from_date)) . "</td>";
                $body .= "<td>" . date('d-m-Y', strtotime($to_date)) . "</td>";
				$body .= "<td>$to_date</td>";
				$body .= "<td>$type_display Leave<br>";
				if($leaveDetails->is_hourly == 1){
					    $startTime =  date('h:i A',$leaveDetails->start_time);
                        $endTime = date('h:i A',$leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}  else {
					    $body .= "<br></td>";
					}
				$body .= "<td>$reason</td>";
				$body .= "<td>Cancelled</td>";
				$body .= "<td></td>";
				$body .= "</tr>";;
				$this->pendingEmailInsert($emp_name, $username, $body, $subject, "Cancelled", $leaveDetails->username);
			}
		}


		$result = $this->deleteLeave($id);
		return array(
            'result' => $result
       );
	}

    public function deleteLeave($id)
    {
        $detail = $this->getLeaveDetails($id);
        
        $leaveData = LeaveList::where('id', $detail->leave_id)->first();
        $user = User::where('id', Auth::id())->first();
        $approverId = $user->username;

        $audit = new LeaveAudit;
        $audit->leave_id = $detail->leave_id ?? NULL;
        $audit->leave_date = $leaveData->start_date ?? NULL;
        $audit->admin_id = $approverId ?? NULL;
        $audit->leave_from = $detail->type ?? NULL;
        $audit->reason_from = $detail->reason ?? NULL;
        $audit->status_from = $detail->status ?? NULL;
        $audit->emp_id = $detail->username  ?? NULL;
        $audit->leave_list_raw = json_encode($leaveData) ?? NULL;
        $audit->deleted_at = date("Y-m-d H:i:s");    
        $audit->save();   

        DB::table('leave_list')->delete($detail->leave_id);

        DB::table('leave_days')->delete($id);

        return true;
    }

	
public function  setStatuss($_id = '', $_approver_id = '', $_status = '',Request $request)
{
    $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $user = User::where('id' , Auth::id())->first();

    if ($_id == '') {
        $id = $request->id;
    } else {
        $id = $_id;
    }
    $cancel_reason = $request->cancel_reason;
    $reject_reason = $request->reject_reason;

    $login_username = ($request->username ? $request->username : $user->username);

    if ($_approver_id == '') {
        $approverId = ($request->approver_id ? $request->approver_id : $user->username);
    } else {
        $approverId = $_approver_id;
    }

    if ($_status == '') {
        $status = $request->status;
    } else {
        $status = $_status;
    }
    $apply_subord = $request->apply_subord ? $request->apply_subord : '0';
    if ($status != "2" && $apply_subord != '1') {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
            $this->update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
            if (!$this->UpdateApproverOfLeave($id, $approverId, $status,request())) {
                return;
            }
        } else if ($LeaveMultipleApprover == '3') {
            $this->update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
            $cnt = $this->get_approver_by_leaveid($id);
            if ($cnt > 0) {
                return;
            }
        } else if ($LeaveMultipleApprover == '4') {
            $this->update_leave_approver($id,'',$status,$cancel_reason,$reject_reason);
        }
    }

    if($status == "2" && $apply_subord != '1')
    {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
            $this->update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
            
        } else if ($LeaveMultipleApprover == '3') {
            $this->update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
            
        } else if ($LeaveMultipleApprover == '4') {
            $this->update_leave_approver11($id,'',$status,$cancel_reason,$reject_reason);
        }
    }


    $result = $this->setStatus11($id, $status);

    $sStatus = "";
    if ($status == "1")
        $sStatus = "approved";
    else if ($status == "2")
        $sStatus = "rejected";
    else if ($status == "3")
        $sStatus = "recommended";
    else if ($status == "4")
        $sStatus = "cancelled";
    else if ($status == "5")
        $sStatus = "Cancellation Pending";
    
    $npl_to_hr1=DB::table('settings')->where('field','npl_to_hr')->first();
    $npl_to_hr='';
    if($npl_to_hr1!='')
    $npl_to_hr = $npl_to_hr1->value;
    $nplHRUsers = $this->getNPL_HR_User();

    $hr_id_array = array();
    for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
        $hr_id_array[$npl_hr_i] = strtolower($nplHRUsers[$npl_hr_i]->employee_id);
    }
    
    $leaveDetails = $this->getLeaveDetails($id);

    $isShowClaimable = $this->getConfirmDisplay($leaveDetails->username);

    if ($status == '4' || $status == '2') {
        if ($leaveDetails->type == 'Other_pay') {
            for ($_rl_i = 0; $_rl_i < ($leaveDetails->no_days * 2); $_rl_i++) {
                unMarkReplacementLeaveAsTaken($leaveDetails->username);
            }
        }
    }

    if ($cancel_reason != '') {
        $this->updateLeaveDays($cancel_reason, $id);
    }
    if ($reject_reason != '') {
        $this->updateLeaveDays($reject_reason, $id, 'reject');
    }


    $email_send_allow = true;
    $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
    $sendbypreference = $sendbypreference1->value ?? 0;
    if ($sendbypreference == "1") {
        if (!hasContentPreference($leaveDetails->username)) {
            $email_send_allow = true;
        } else {
            $email_send_allow = false;
        }
    }
    if ($status == "3") {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        
        if ($LeaveMultipleApprover == '1') {
            $masterApprover = getApproversOfEmployee($leaveDetails->username);
            if (count($masterApprover) > 1) {
                $masterApprover = $masterApprover[1]->username;
            } else {
                $masterApprover = getApproversOfEmployee($approverId);
                $masterApprover = $masterApprover[0]->username;
            }
        } else {
            $masterApprover = getApproversOfEmployee($approverId);
            $masterApprover = $masterApprover[0]->username;
        }

        $this->setAssignee($id, $masterApprover);
        $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
        $emailSendingStatus = $emailSendingStatus1->value;

        $uname = UserPersonal::where('username',$user->username)->first();
        $name = $uname->name;

        if ($email_send_allow) {
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = str_replace('self-leaves', 'dashboard', url()->current());

                $body = "Leave has been recommended by $name. ";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "Employee Name: $emp_name<br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  date('h:i A',$leaveDetails->start_time);
                    $endTime = date('h:i A',$leaveDetails->end_time);
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br>";
                $body .= "Link: <a href='$referer'>$referer</a><br><br>";
                $body .= "Kind regards,";
                $body .= "Note, this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$masterApprover)->first();
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                sendemail($semail->email_id,$subject,$body);
                
                // $details['email_id'] = $semail->email_id;
                // $details['subject'] = $subject;
                // $details['body'] = $body;
                
                // SendEmailJob::dispatch($details);
                
                //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
            } else {

                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                $body = "<tr>";
                $body .= "<td>$emp_name</td>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
            
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                } else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
                $body .= "</tr>";

                $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($status == "5") {

        $Cancel_leave_to_hr1=DB::table('settings')->where('field','cancel_leave_to_hr')->first();
        $Cancel_leave_to_hr = $Cancel_leave_to_hr1->value;
        $approver_done = false;
        if ($Cancel_leave_to_hr == 1) {

            $masterApprover = $this->getCancelLeave_Approver();
            
            if (count($masterApprover) > 0) {
                $approver_done = true;
                $masterApprover = $masterApprover[0]->username;
                $this->setAssignee($id, $masterApprover);
            } else {
                $approver_done = false;
            }
        }

        if (!$approver_done) {
            $masterApprover = getApproversOfEmployee($approverId);
            $masterApprover = $masterApprover[0]->username;
            $this->setAssignee($id, $masterApprover);
        }

        $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
        $emailSendingStatus = $emailSendingStatus1->value;
        $uname = UserPersonal::where('username',$user->username)->first();
        $name = $uname->name;

        if ($email_send_allow) {
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $body = "Self Leave has been Cancelled by $name. ";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                } 
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Name : $emp_name<br><br>";
                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                $body .= "Link: <a href='$referer'>$referer</a><br><br>";

                $body .= "Kind regards,";
                $body .= "Note, this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";
                
                $semail = UserPersonal::where('username',$masterApprover)->first();
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                sendemail($semail->email_id,$subject,$body);
                
            // 	$details['email_id'] = $semail->email_id;
            //     $details['subject'] = $subject;
            //     $details['body'] = $body;
//                 SendEmailJob::dispatch($details);
                //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
            } else {

                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                 $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                $body = "<tr>";
                $body .= "<td>$emp_name</td>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
                $body .= "</tr>";


                $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($status == "4") {
        if ($email_send_allow) {
            $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                

                $body = "Dear $emp_name<br><br>";
                $body .= "Your leave has been $sStatus<br><br>";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Kind regards,<br><br>";
                $body .= "Note: this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$username)->first();
                sendemail($semail->email_id,$subject,$body);
                
            // 	$details['email_id'] = $semail->email_id;
            //     $details['subject'] = $subject;
            //     $details['body'] = $body;
                
//                 SendEmailJob::dispatch($details);
                
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                
                $message = "Dear $emp_name  ";
                $message .= "Your leave has been $sStatus, ";
                $message .= "Details of the leave are as follows: ";
                $message .= "From: $from_date  ";
                $message .= "To: $to_date  ";
                $message .= "Reason: $reason";

                sendSMSToUserFromServer($username, $message);
            } else {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                
                $body = "<tr>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= "<td>  </td>";
                $body .= "</tr>";

                $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($sStatus != "") {
        $username = $leaveDetails->username;
        $type = $leaveDetails->type;
        $year = date("Y", strtotime(str_replace('/', '-', $leaveDetails->start_date)));
        $leave_month = date("m", strtotime(str_replace('/', '-', $leaveDetails->start_date)));

        if($cutOffStartMonth!=1){
            if($cutOffStartMonth > $leave_month){
                $cutOffStartYear = $year;
                $year = $year;
            }else{
                $cutOffStartYear = $year;
                $year = $year+1;
            }
        }else{
            $cutOffStartYear = $year;
            $year = $year;
        }
        
        $new_type = $type;

        $categoryId = getUserCategory($username);
        $leaveAllowMaxvalue = $this->getMaxValue($new_type, $categoryId);
        $totalLeaveValue = $this->getLeaveAccordingToTypeCount($year, $username, $new_type);
        $this_taken = 0;

        $TakenPastLeaves = getTakenPastLeaves($username, $cutOffStartYear);


        if ($type == "Medical" && $status == "1") {
            $medicalEntitle = getLeaveEntitle($username, "Medical");
            $medicalTaken = getTakenLeaveCount($username, $year, "Medical");


            $bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
            $bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");


            if (($medicalTaken + $TakenPastLeaves['medical']) > ($medicalEntitle + $bfMedical + $bfMedicalAdj)) {
                $new_type = "NPL";
                $this->changeType($id, "NPL");
            }
        }
        
        if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
            if ($leaveAllowMaxvalue < $totalLeaveValue) {
                $type = "Annual";
                $new_type = "Annual";
                $this->changeType($id, $new_type);
            }
        }

        if ($type == "Annual" && $status == "1") {

            $checking_year = date('Y');
            if($cutOffStartMonth!=1){
                if($cutOffStartMonth <= $leave_month){
                    $checking_year = date('Y') + 1;
                }
            }

            $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
            $SoftwareStartDate1=DB::table('settings')->where('field','software_start_year')->first();
            $SoftwareStartDate = $SoftwareStartDate1->value;

            $_start_leave_date_array = explode("/", $leaveDetails->start_date);
            $_start_leave_date = $_start_leave_date_array[2] . "-" . $_start_leave_date_array[1] . "-" . $_start_leave_date_array[0];
            
            if ($SoftwareStartDate <= ($year - 1)) {
                
                $bfAnnual = getBFValue($year - 1, $username, $_start_leave_date);
            
            } else {
                
                $bfAnnual = 0;

            }
            $users=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            
            $BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            
            //$BFClearDuration1=DB::table('settings')->where('field','bf_duration')->first();
            $BFClearDuration = $BFClearDuration1->value;
            //$BFAdjClearDuration1=DB::table('settings')->where('field','bf_adj_duration')->first();
            $BFAdjClearDuration = $BFAdjClearDuration1->value;
            $totalDaysTillToday =  tillTodayTotalDays($year,$leaveDetails->start_date);

            if (($BFClearDuration < $totalDaysTillToday || $year != date('Y'))  && $cutOffStartMonth==1) {
                
                $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
                
                if ($BFLeaveTaken > $bfAnnual) {
                    $BFLeaveTaken = $bfAnnual;
                }

                $bfAnnual = $BFLeaveTaken;
            }else if($cutOffStartMonth!=1){
                
                $BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
                
                if ($BFLeaveTaken > $bfAnnual) {
                    $BFLeaveTaken = $bfAnnual;
                }

                $bfAnnual = $BFLeaveTaken;
            }
            
            if (($BFAdjClearDuration < $totalDaysTillToday || $year != date('Y')) && $cutOffStartMonth==1 ) {

                $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

                if ($BFADJLeaveTaken > $bfAnnualAdj) {
                    $BFADJLeaveTaken = $bfAnnualAdj;
                }

                $bfAnnualAdj = $BFADJLeaveTaken;
            }else if($cutOffStartMonth!=1){
                $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $checking_year, $bfAnnual, $bfAnnualAdj);

                if ($BFADJLeaveTaken > $bfAnnualAdj) {
                    $BFADJLeaveTaken = $bfAnnualAdj;
                }

                $bfAnnualAdj = $BFADJLeaveTaken;
            }
            
            $taken = getTakenLeaveCount($username, $year, $type);
            if ($type == "Annual") {

                $el_taken = getTakenLeaveCount($username, $year, "Emergency");
            
            }
            
            $leave_end_month = date('m', strtotime(str_replace("/", "-", $leaveDetails->end_date)));

            $workForEarnSetting1=DB::table('settings')->where('field','WorkForEarn')->first();
            $workForEarnSetting = $workForEarnSetting1->value;
            //if ($year > date('Y')) {
                $url = \Request::url();

                $uname = UserPersonal::whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
                $name = urlencode($uname->employee_no);
        
                $ln = 1;
                $aid = Auth::id();
        
                if ($year != null) {
                    $url11 = str_replace("e-leave/approve-leaves", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
                } else {
                    $url11 = str_replace("e-leave/approve-leaves", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
                }
                // dd($url11,$year);
                ini_set('memory_limit', -1);
                ini_set('max_execution_time', -1);
                $curl = curl_init();
        
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url11 . "&auth_id=" . Auth::id(),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                ));
        
                $response = curl_exec($curl);
                curl_close($curl);
        
                $myLeaveSumm = json_decode($response);
                if (!empty($myLeaveSumm)) {
                    $yearlyEntitle = $myLeaveSumm[0];
                }else{
                    $yearlyEntitle='';
                }
               // $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
            // } else {
            //     $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
            // }
            if($yearlyEntitle!='')
            {
                // $claimable = $yearlyEntitle['claimable'];
                // $entitle1 = $yearlyEntitle['annual']['entitle'];
                $claimable = $yearlyEntitle->claimable;
                $entitle1 = $yearlyEntitle->aentitle;
            }
            
        
            //$elSetting1=DB::table('settings')->where('field','emergency_leave')->first();
            $users=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $elSetting1 = DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            $elSetting = $elSetting1->value;
            $em_leave = getEmergencyLeaveCountByUser($username, $year);


            $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
            $max_day = $resultArrayVal->percentage;
            $balance1 = $yearlyEntitle->balance;

            if ($year > $checking_year) {
                if ($balance1 <= $max_day) {
                    $claimable = $balance1 + 1;
                } else {
                    $claimable = $max_day + 1;
                }
            } else {
                if ($balance1 < 0) {
                    $new_type = "NPL";
                    $this->changeType($id, "NPL");
                }
            }

            if ($isShowClaimable == 0) {
                $claimable = 0;
            }

            $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
            $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
            if ($SettingLeaveAdjustmentType != 8) {
                if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable) || (($claimable) == 0)) {

                    $new_type = "NPL";
                    $this->changeType($id, "NPL");

                    if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        //$result = $this->setStatus11($id, '0');
                        $result = $this->setStatus11($id, $status);
                    }
                }
                
            } else {
               
                $TakenPastLeaves2 = $this->getTakenPastLeaves2($username, $leaveDetails->start_date, $year);
                $cut_off_taken = $this->getTakenLeaveCount2($username, $type, $leaveDetails->start_date, $year);
                $cut_off_em_leave = $this->getEmergencyLeaveCountByUser2($username, $leaveDetails->start_date, $year);
                
                if (($cut_off_taken + $cut_off_em_leave + $TakenPastLeaves2['annual']) > $yearlyEntitle->aentitle) {

                    $new_type = "NPL";
                    $this->changeType($id, "NPL");

                    if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        //$result = $this->setStatus11($id, '0');
                        $result = $this->setStatus11($id, $status);
                    }
                }
                $leavedate = str_replace('/', '-', $leaveDetails->start_date);
                $leavedate = date('Y-m-d', strtotime($leavedate));

                $joindate1 = DB::table('user_pay')->where('username',$username)->first();
                $joiningDate = $joindate1->date_commence;
                $joiningDateArr = explode('-', $joiningDate);
                $joining_month = $joiningDateArr[1];
                $joining_date = $joiningDateArr[2];

                $curr_j_date = $year . '-' . $joining_month . '-' . $joining_date;
                
                if ($leavedate > $curr_j_date) {
                    $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
                    $max_day = $resultArrayVal->percentage;
                     \Log::info($yearlyEntitle);
                    \Log::info($curr_j_date);
                        \Log::info($max_day);
                    if (isset($max_day)) {
                        if ($max_day > 0) {
                            $max_day = ($max_day - 1);
                        } else {
                            $new_type = "NPL";
                            $this->changeType($id, "NPL");

                            if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                            //	$result = $this->setStatus11($id, '0');
                                $result = $this->setStatus11($id, $status);
                            }
                        }
                    } else {
                        $max_day = $max_day;
                        if ($max_day > 0) {
                            $max_day = ($max_day - 1);
                        } else {
                            $new_type = "NPL";
                            $this->changeType($id, "NPL");

                            if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                                // $result = $this->setStatus11($id, '0');
                                $result = $this->setStatus11($id, $status);
                            }
                        }
                    }
                }
            }

            $is_emergency_check = true;

            if ($npl_to_hr == '1') {
                if ($new_type != "NPL") {
                    $is_emergency_check = true;
                } else {
                    $is_emergency_check = false;
                }
            }

            $dateDiff = diff(strtotime($leaveDetails->start_date_cal), strtotime($leaveDetails->date_applied_cal));
            if ($is_emergency_check && $elSetting != 0 && $new_type != "NPL") {
                if ($dateDiff['invert'] == 0 || (($dateDiff['month'] == 0 && $dateDiff['year'] == 0 && $dateDiff['day'] < $elSetting) && ($this->total_Emergency < $elSetting))) {
                    if ($this->total_Emergency < $elSetting) {
                        $this->total_Emergency++;
                        $this->changeCategory($leaveDetails->leave_id, "Emergency");
                        $this->changeTypeOfLeaveList($leaveDetails->leave_id, "Emergency");
                        $new_type = "Emergency";
                    } else {
                        if ($leaveDetails->leave_category == 'Emergency') {
                            $this->changeCategory($leaveDetails->leave_id, "Normal");
                        }
                    }
                }
            } else {
                if ($leaveDetails->leave_category == 'Emergency') {
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                }
            }

            if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
                if ($leaveAllowMaxvalue < $totalLeaveValue) {
                    $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                    $new_type = "NPL";
                }
            } else if ($new_type == 'Emergency') {
                if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable)) {
                    $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                    $new_type = "NPL";
                }
            }
            
        }
        
        $uname = UserPersonal::where('username',$approverId)->first();
        $name = $uname->name;
        
        if ($email_send_allow) {
            $emailSendingStatus1 = DB::table('settings')->where('field','email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($new_type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                $half_day_type = '';
                if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                    $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                }

                $body = "Dear $emp_name<br><br>";
                $body .= "Your leave has been $sStatus<br><br>";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display $half_day_type<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Kind regards,<br><br>";
                $body .= "Note: this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$username)->first();
                
                sendemail($semail->email_id,$subject,$body);
            
                // $details['email_id'] = $semail->email_id;
                // $details['subject'] = $subject;
                // $details['body'] = $body;
                
    //             SendEmailJob::dispatch($details);
                
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));

                $message = "Dear $emp_name  ";
                $message .= "Your leave has been $sStatus, ";
                $message .= "Details of the leave are as follows: ";
                $message .= "From: $from_date  ";
                $message .= "To: $to_date  $half_day_type";
                $message .= "Reason: $reason";

                sendSMSToUserFromServer($username, $message);

            } else {
                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                    $subject = "Leave $new_type";
                } else {
                    $subject = "Leave $sStatus";
                }
                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($new_type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                
                $half_day_type = '';
                if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                    $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                }


                $body = "<tr>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                $body .= "<td>$type_display Leave $half_day_type<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                    $body .= "<td>" . ucwords($new_type) . "</td>";
                } else {
                    $body .= "<td>" . ucwords($sStatus) . "</td>";
                }
                $body .= "</tr>";

                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {

                    for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
                        $this->pendingEmailInsert($nplHRUsers[$npl_hr_i]->name, $nplHRUsers[$npl_hr_i]->employee_id, $body, $subject, $sStatus, $leaveDetails->username);
                    }
                } else {
                    $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
                }
            }
        }
    }
    if ($_id == '') {
        return array(
            'result' => $result,
        );
    }
}

    public function setStatus($_id = '', $_approver_id = '', $_status = '',Request $request)
	{

    $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $user = User::where('id' , Auth::id())->first();

    if ($_id == '') {
        $id = $request->id;
    } else {
        $id = $_id;
    }
    //dd($id);
    $cancel_reason = $request->cancel_reason;
    $reject_reason = $request->reject_reason;

    $login_username = ($request->username ? $request->username : $user->username);

    if ($_approver_id == '') {
        $approverId = ($request->approver_id ? $request->approver_id : $user->username);
    } else {
        $approverId = $_approver_id;
    }

    if ($_status == '') {
        $status = $request->status;
    } else {
        $status = $_status;
    }
    $apply_subord = $request->apply_subord ? $request->apply_subord : '0';
    if ($status != "2" && $apply_subord != '1') {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
            $this->update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
            if (!$this->UpdateApproverOfLeave($id, $approverId, $status,request())) {
                return;
            }
        } else if ($LeaveMultipleApprover == '3') {
            $this->update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
            $cnt = $this->get_approver_by_leaveid($id);
            if ($cnt > 0) {
                return;
            }
        } else if ($LeaveMultipleApprover == '4') {
            $this->update_leave_approver($id,'',$status,$cancel_reason,$reject_reason);
        }
    }

    if($status == "2" && $apply_subord != '1')
    {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
            $this->update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
            
        } else if ($LeaveMultipleApprover == '3') {
            $this->update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
            
        } else if ($LeaveMultipleApprover == '4') {
            $this->update_leave_approver11($id,'',$status,$cancel_reason,$reject_reason);
        }
    }


    $result = $this->setStatus11($id, $status);

    $sStatus = "";
    if ($status == "1")
        $sStatus = "approved";
    else if ($status == "2")
        $sStatus = "rejected";
    else if ($status == "3")
        $sStatus = "recommended";
    else if ($status == "4")
        $sStatus = "cancelled";
    else if ($status == "5")
        $sStatus = "Cancellation Pending";
   
    $npl_to_hr1=DB::table('settings')->where('field','npl_to_hr')->first();
    $npl_to_hr='';
    if($npl_to_hr1!='')
    $npl_to_hr = $npl_to_hr1->value;
    $nplHRUsers = $this->getNPL_HR_User();
    
    $hr_id_array = array();
    for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
        $hr_id_array[$npl_hr_i] = strtolower($nplHRUsers[$npl_hr_i]->employee_id);
    }
    
    $leaveDetails = $this->getLeaveDetails($id);

    $isShowClaimable = $this->getConfirmDisplay($leaveDetails->username);

    if ($status == '4' || $status == '2') {
        if ($leaveDetails->type == 'Other_pay') {
            for ($_rl_i = 0; $_rl_i < ($leaveDetails->no_days * 2); $_rl_i++) {
                unMarkReplacementLeaveAsTaken($leaveDetails->username);
            }
        }
    }

    if ($cancel_reason != '') {
        $this->updateLeaveDays($cancel_reason, $id);
    }
    if ($reject_reason != '') {
        $this->updateLeaveDays($reject_reason, $id, 'reject');
    }


    $email_send_allow = true;
    $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
    $sendbypreference = $sendbypreference1->value ?? 0;
    if ($sendbypreference == "1") {
        if (!hasContentPreference($leaveDetails->username)) {
            $email_send_allow = true;
        } else {
            $email_send_allow = false;
        }
    }
    if ($status == "3") {
        $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
        
        if ($LeaveMultipleApprover == '1') {
            $masterApprover = getApproversOfEmployee($leaveDetails->username);
            if (count($masterApprover) > 1) {
                $masterApprover = $masterApprover[1]->username;
            } else {
                $masterApprover = getApproversOfEmployee($approverId);
                $masterApprover = $masterApprover[0]->username;
            }
        } else {
            $masterApprover = getApproversOfEmployee($approverId);
            $masterApprover = $masterApprover[0]->username;
        }

        $this->setAssignee($id, $masterApprover);
        $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
        $emailSendingStatus = $emailSendingStatus1->value;

        $uname = UserPersonal::where('username',$user->username)->first();
        $name = $uname->name;

        if ($email_send_allow) {
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = str_replace('self-leaves', 'dashboard', url()->current());

                $body = "Leave has been recommended by $name. ";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "Employee Name: $emp_name<br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  date('h:i A',$leaveDetails->start_time);
                    $endTime = date('h:i A',$leaveDetails->end_time);
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br>";
                $body .= "Link: <a href='$referer'>$referer</a><br><br>";
                $body .= "Kind regards,";
                $body .= "Note, this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$masterApprover)->first();
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                sendemail($semail->email_id,$subject,$body);
                
                // $details['email_id'] = $semail->email_id;
                // $details['subject'] = $subject;
                // $details['body'] = $body;
                
                // SendEmailJob::dispatch($details);
                
                //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
            } else {

                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                $body = "<tr>";
                $body .= "<td>$emp_name</td>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
            
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                } else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
                $body .= "</tr>";

                $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($status == "5") {

        $Cancel_leave_to_hr1=DB::table('settings')->where('field','cancel_leave_to_hr')->first();
        $Cancel_leave_to_hr = $Cancel_leave_to_hr1->value;
        $approver_done = false;
        if ($Cancel_leave_to_hr == 1) {

            $masterApprover = $this->getCancelLeave_Approver();
            
            if (count($masterApprover) > 0) {
                $approver_done = true;
                $masterApprover = $masterApprover[0]->username;
                $this->setAssignee($id, $masterApprover);
            } else {
                $approver_done = false;
            }
        }

        if (!$approver_done) {
            $masterApprover = getApproversOfEmployee($approverId);
            $masterApprover = $masterApprover[0]->username;
            $this->setAssignee($id, $masterApprover);
        }

        $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
        $emailSendingStatus = $emailSendingStatus1->value;
        $uname = UserPersonal::where('username',$user->username)->first();
        $name = $uname->name;

        if ($email_send_allow) {
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $body = "Self Leave has been Cancelled by $name. ";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                } 
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Name : $emp_name<br><br>";
                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                $body .= "Link: <a href='$referer'>$referer</a><br><br>";

                $body .= "Kind regards,";
                $body .= "Note, this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";
                
                $semail = UserPersonal::where('username',$masterApprover)->first();
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                sendemail($semail->email_id,$subject,$body);
                
            // 	$details['email_id'] = $semail->email_id;
            //     $details['subject'] = $subject;
            //     $details['body'] = $body;
//                 SendEmailJob::dispatch($details);
                //Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
            } else {

                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;

                $referer = str_replace('self-leaves', 'dashboard', url()->current());
                 $referer = str_replace('approve-leaves', 'approve-leave', $referer);

                $body = "<tr>";
                $body .= "<td>$emp_name</td>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
                $body .= "</tr>";


                $this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($status == "4") {
        if ($email_send_allow) {
            $emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                

                $body = "Dear $emp_name<br><br>";
                $body .= "Your leave has been $sStatus<br><br>";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Kind regards,<br><br>";
                $body .= "Note: this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$username)->first();
                sendemail($semail->email_id,$subject,$body);
                
            // 	$details['email_id'] = $semail->email_id;
            //     $details['subject'] = $subject;
            //     $details['body'] = $body;
                
//                 SendEmailJob::dispatch($details);
                
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                
                $message = "Dear $emp_name  ";
                $message .= "Your leave has been $sStatus, ";
                $message .= "Details of the leave are as follows: ";
                $message .= "From: $from_date  ";
                $message .= "To: $to_date  ";
                $message .= "Reason: $reason";

                sendSMSToUserFromServer($username, $message);
            } else {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($leaveDetails->type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                
                $body = "<tr>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                $body .= "<td>$type_display Leave<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                $body .= "<td>" . ucwords($sStatus) . "</td>";
                $body .= "<td>  </td>";
                $body .= "</tr>";

                $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
            }
        }
    } else if ($sStatus != "") {
        
        $username = $leaveDetails->username;
        $type = $leaveDetails->type;
  
        $year = date("Y", strtotime(str_replace('/', '-', $leaveDetails->start_date)));
        $leave_month = date("m", strtotime(str_replace('/', '-', $leaveDetails->start_date)));

        if($cutOffStartMonth!=1){
            if($cutOffStartMonth > $leave_month){
                $cutOffStartYear = $year;
                $year = $year;
            }else{
                $cutOffStartYear = $year;
                $year = $year+1;
            }
        }else{
            $cutOffStartYear = $year;
            $year = $year;
        }
        
        $new_type = $type;

        $categoryId = getUserCategory($username);
        $leaveAllowMaxvalue = $this->getMaxValue($new_type, $categoryId);
        $totalLeaveValue = $this->getLeaveAccordingToTypeCount($year, $username, $new_type);
        $this_taken = 0;

        $TakenPastLeaves = getTakenPastLeaves($username, $cutOffStartYear);


        if ($type == "Medical" && $status == "1") {
            $medicalEntitle = getLeaveEntitle($username, "Medical");
            $medicalTaken = getTakenLeaveCount($username, $year, "Medical");


            $bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
            $bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");


            if (($medicalTaken + $TakenPastLeaves['medical']) > ($medicalEntitle + $bfMedical + $bfMedicalAdj)) {
                $new_type = "NPL";
                $this->changeType($id, "NPL");
            }
        }
        
        if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
            if ($leaveAllowMaxvalue < $totalLeaveValue) {
                $type = "Annual";
                $new_type = "Annual";
                $this->changeType($id, $new_type);
            }
        }

        if ($type == "Annual" && $status == "1") {

            $checking_year = date('Y');
            if($cutOffStartMonth!=1){
                if($cutOffStartMonth <= $leave_month){
                    $checking_year = date('Y') + 1;
                }
            }
            

            $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
            $SoftwareStartDate1=DB::table('settings')->where('field','software_start_year')->first();
            $SoftwareStartDate = $SoftwareStartDate1->value;

            $_start_leave_date_array = explode("/", $leaveDetails->start_date);
            $_start_leave_date = $_start_leave_date_array[2] . "-" . $_start_leave_date_array[1] . "-" . $_start_leave_date_array[0];
            
            if ($SoftwareStartDate <= ($year - 1)) {
                
                $bfAnnual = getBFValue($year - 1, $username, $_start_leave_date);
            
            } else {
                
                $bfAnnual = 0;

            }
            $users=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            
            $BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            
            //$BFClearDuration1=DB::table('settings')->where('field','bf_duration')->first();
            $BFClearDuration = $BFClearDuration1->value;
            //$BFAdjClearDuration1=DB::table('settings')->where('field','bf_adj_duration')->first();
            $BFAdjClearDuration = $BFAdjClearDuration1->value;
            $totalDaysTillToday =  tillTodayTotalDays($year,$leaveDetails->start_date);

            if (($BFClearDuration < $totalDaysTillToday || $year != date('Y'))  && $cutOffStartMonth==1) {
                
                $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
                
                if ($BFLeaveTaken > $bfAnnual) {
                    $BFLeaveTaken = $bfAnnual;
                }

                $bfAnnual = $BFLeaveTaken;
            }else if($cutOffStartMonth!=1){
                
                $BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
                
                if ($BFLeaveTaken > $bfAnnual) {
                    $BFLeaveTaken = $bfAnnual;
                }

                $bfAnnual = $BFLeaveTaken;
            }
            
            if (($BFAdjClearDuration < $totalDaysTillToday || $year != date('Y')) && $cutOffStartMonth==1 ) {

                $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

                if ($BFADJLeaveTaken > $bfAnnualAdj) {
                    $BFADJLeaveTaken = $bfAnnualAdj;
                }

                $bfAnnualAdj = $BFADJLeaveTaken;
            }else if($cutOffStartMonth!=1){
                $BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $checking_year, $bfAnnual, $bfAnnualAdj);

                if ($BFADJLeaveTaken > $bfAnnualAdj) {
                    $BFADJLeaveTaken = $bfAnnualAdj;
                }

                $bfAnnualAdj = $BFADJLeaveTaken;
            }
            
            $taken = getTakenLeaveCount($username, $year, $type);
            if ($type == "Annual") {

                $el_taken = getTakenLeaveCount($username, $year, "Emergency");
            
            }
            
            $leave_end_month = date('m', strtotime(str_replace("/", "-", $leaveDetails->end_date)));

            $workForEarnSetting1=DB::table('settings')->where('field','WorkForEarn')->first();
            $workForEarnSetting = $workForEarnSetting1->value;
            //if ($year > date('Y')) {
                $url = \Request::url();

                $uname = UserPersonal::whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
                $name = urlencode($uname->employee_no);
        
                $ln = 1;
                $aid = Auth::id();
        
                if ($year != null) {
                    $url11 = str_replace("e-leave/approve-leaves", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
                  
                   $url11 = str_replace("e-leave/addLeaveByApprover", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $url11);
               $url11 = str_replace("e-leave/apply-on-behalf", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $url11);
                
                } else {
                    $url11 = str_replace("e-leave/approve-leaves", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
                    $url11 = str_replace("e-leave/addLeaveByApprover", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $url11);
                    $url11 = str_replace("e-leave/apply-on-behalf", "public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $url11);
                 }
                 
                // dd($url11,$year);
                ini_set('memory_limit', -1);
                ini_set('max_execution_time', -1);
                $curl = curl_init();
        
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url11 . "&auth_id=" . Auth::id(),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                ));
        
                $response = curl_exec($curl);
                curl_close($curl);
        
                $myLeaveSumm = json_decode($response);
                if (!empty($myLeaveSumm)) {
                    $yearlyEntitle = $myLeaveSumm[0];
                }else{
                    $yearlyEntitle='';
                }
                
               // $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
            // } else {
            //     $yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt');
            // }
            if($yearlyEntitle!='')
            {
                // $claimable = $yearlyEntitle['claimable'];
                // $entitle1 = $yearlyEntitle['annual']['entitle'];
                $claimable = $yearlyEntitle->claimable;
                $entitle1 = $yearlyEntitle->aentitle;
            }
            
        
            //$elSetting1=DB::table('settings')->where('field','emergency_leave')->first();
            $users=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $elSetting1 = DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
            $elSetting = $elSetting1->value;
            $em_leave = getEmergencyLeaveCountByUser($username, $year);


            $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
            $max_day = $resultArrayVal->percentage;
            $balance1 = $yearlyEntitle->balance;

            if ($year > $checking_year) {
                if ($balance1 <= $max_day) {
                    $claimable = $balance1 + 1;
                } else {
                    $claimable = $max_day + 1;
                }
            } else {
                if ($balance1 < 0) {
                    $new_type = "NPL";
                    $this->changeType($id, "NPL");
                }
            }

            if ($isShowClaimable == 0) {
                $claimable = 0;
            }

            $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
            $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
            
            if ($SettingLeaveAdjustmentType != 8) {
                if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable) || (($claimable) == 0)) {

                    $new_type = "NPL";
                    $this->changeType($id, "NPL");

                    if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        //$result = $this->setStatus11($id, '0');
                        $result = $this->setStatus11($id, $status);
                    }
                }
                
            } else {
               
                $TakenPastLeaves2 = $this->getTakenPastLeaves2($username, $leaveDetails->start_date, $year);
                $cut_off_taken = $this->getTakenLeaveCount2($username, $type, $leaveDetails->start_date, $year);
                $cut_off_em_leave = $this->getEmergencyLeaveCountByUser2($username, $leaveDetails->start_date, $year);
             
                if (($cut_off_taken + $cut_off_em_leave + $TakenPastLeaves2['annual']) > $yearlyEntitle->aentitle) {

                    $new_type = "NPL";
                    $this->changeType($id, "NPL");

                    if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                        //$result = $this->setStatus11($id, '0');
                        $result = $this->setStatus11($id, $status);
                    }
                }
                $leavedate = str_replace('/', '-', $leaveDetails->start_date);
                $leavedate = date('Y-m-d', strtotime($leavedate));
                    
                $joindate1 = DB::table('user_pay')->where('username',$username)->first();
                $joiningDate = $joindate1->date_commence;
                $joiningDateArr = explode('-', $joiningDate);
                $joining_month = $joiningDateArr[1];
                $joining_date = $joiningDateArr[2];

                $curr_j_date = $year . '-' . $joining_month . '-' . $joining_date;
                
                if ($leavedate > $curr_j_date) {
                    $resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
                    
                    $max_day = $resultArrayVal->percentage;
            
                    if (isset($max_day)) {
                        if ($max_day > 0) {
                            $max_day = ($max_day - 1);
                        } else {
                            $new_type = "NPL";
                            $this->changeType($id, "NPL");

                            if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                            //	$result = $this->setStatus11($id, '0');
                                $result = $this->setStatus11($id, $status);
                            }
                        }
                    } else {
                        $max_day = $max_day;
                        if ($max_day > 0) {
                            $max_day = ($max_day - 1);
                        } else {
                            $new_type = "NPL";
                            $this->changeType($id, "NPL");

                            if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                                // $result = $this->setStatus11($id, '0');
                                $result = $this->setStatus11($id, $status);
                            }
                        }
                    }
                  
                }
            }

            $is_emergency_check = true;

            if ($npl_to_hr == '1') {
                if ($new_type != "NPL") {
                    $is_emergency_check = true;
                } else {
                    $is_emergency_check = false;
                }
            }

            $dateDiff = diff(strtotime($leaveDetails->start_date_cal), strtotime($leaveDetails->date_applied_cal));
            
            if ($is_emergency_check && $elSetting != 0 && $new_type != "NPL") {
                if ($dateDiff['invert'] == 0 || (($dateDiff['month'] == 0 && $dateDiff['year'] == 0 && $dateDiff['day'] < $elSetting) && ($this->total_Emergency < $elSetting))) {
                    if ($this->total_Emergency < $elSetting) {
                        $this->total_Emergency++;
                        $this->changeCategory($leaveDetails->leave_id, "Emergency");
                        $this->changeTypeOfLeaveList($leaveDetails->leave_id, "Emergency");
                        $new_type = "Emergency";
                    } else {
                        if ($leaveDetails->leave_category == 'Emergency') {
                            $this->changeCategory($leaveDetails->leave_id, "Normal");
                        }
                    }
                }
            } else {
                if ($leaveDetails->leave_category == 'Emergency') {
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                }
            }

            if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
                if ($leaveAllowMaxvalue < $totalLeaveValue) {
                    $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                    $new_type = "NPL";
                }
            } else if ($new_type == 'Emergency') {
                if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable)) {
                    $this->changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
                    $this->changeCategory($leaveDetails->leave_id, "Normal");
                    $new_type = "NPL";
                }
            }
            
        }
        
        $uname = UserPersonal::where('username',$approverId)->first();
        $name = $uname->name;
        
        if ($email_send_allow) {
            $emailSendingStatus1 = DB::table('settings')->where('field','email_by_cronjob')->first();
            $emailSendingStatus = $emailSendingStatus1->value;
            if ($emailSendingStatus == '0') {
                $subject = "Leave $sStatus";

                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($new_type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                $half_day_type = '';
                if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                    $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                }

                $body = "Dear $emp_name<br><br>";
                $body .= "Your leave has been $sStatus<br><br>";
                $body .= "Details of the leave are as follows:<br><br>";
                $body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
                $body .= "To: ".date('d-m-Y',strtotime($to_date))."<br><br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
                }
                $body .= "Type: $type_display $half_day_type<br>";
                $body .= "Reason: $reason<br><br>";
                $body .= "Kind regards,<br><br>";
                $body .= "Note: this is an automatic email. Please do not reply. ";
                $body .= "If you did not request this information, please ignore this message. ";
                $body .= "If you have any questions, please contact us";

                $semail = UserPersonal::where('username',$username)->first();
                
                sendemail($semail->email_id,$subject,$body);
            
                // $details['email_id'] = $semail->email_id;
                // $details['subject'] = $subject;
                // $details['body'] = $body;
                
    //             SendEmailJob::dispatch($details);
                
                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));

                $message = "Dear $emp_name  ";
                $message .= "Your leave has been $sStatus, ";
                $message .= "Details of the leave are as follows: ";
                $message .= "From: $from_date  ";
                $message .= "To: $to_date  $half_day_type";
                $message .= "Reason: $reason";

                sendSMSToUserFromServer($username, $message);

            } else {
                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                    $subject = "Leave $new_type";
                } else {
                    $subject = "Leave $sStatus";
                }
                $emp_name = $leaveDetails->name;
                $from_date = $leaveDetails->sdate;
                $to_date = $leaveDetails->edate;
                $type_display = getLeaveNameByType($new_type);
                $reason = $leaveDetails->reason;
                $username = $leaveDetails->username;
                $referer = url()->current();
                $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                
                $half_day_type = '';
                if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
                    $half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
                }


                $body = "<tr>";
                $body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
                $body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
                $body .= "<td>$type_display Leave $half_day_type<br>";
                if($leaveDetails->is_hourly == 1){
                    $startTime =  $leaveDetails->start_time;
                    $endTime = $leaveDetails->end_time;
                    $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
                }  else {
                    $body .= "<br></td>";
                }
                $body .= "<td>$reason</td>";
                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
                    $body .= "<td>" . ucwords($new_type) . "</td>";
                } else {
                    $body .= "<td>" . ucwords($sStatus) . "</td>";
                }
                $body .= "</tr>";

                if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {

                    for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
                        $this->pendingEmailInsert($nplHRUsers[$npl_hr_i]->name, $nplHRUsers[$npl_hr_i]->employee_id, $body, $subject, $sStatus, $leaveDetails->username);
                    }
                } else {
                    $this->pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
                }
            }
        }
    }
    
    if ($_id == '') {
        return array(
            'result' => $result,
        );
    }
}
    
    public function update_leave_approver($leave_id,$approver_id='',$status='',$cancel_reason='',$reject_reason=''){
        $query = "insert into approver_approved_leaves (leave_days_id, approver_id) values ('$leave_id', '$approver_id')";
		DB::select($query);
		
		$query = "insert into timeline_leaves_detail (leave_days_id, approver_id,status,reject_reason,cancellation_reason) values ('$leave_id', '$approver_id','$status','$reject_reason','$cancel_reason')";
        DB::select($query);
        
        //if($approver_id!=''){
            // $query1 = "update leave_approver set status = '1' where leave_id='$leave_id' AND approver_id='$approver_id'";
        //}else{
            // $query1 = "update leave_approver set status = '1' where leave_id='$leave_id'";
        //}
        // DB::select($query1);
	}
	
	public function update_leave_approver11($leave_id,$approver_id='',$status='',$cancel_reason,$reject_reason){
        
		$query = "insert into timeline_leaves_detail (leave_days_id, approver_id,status,reject_reason,cancellation_reason) values ('$leave_id', '$approver_id','$status','$reject_reason','$cancel_reason')";
        DB::select($query);
        
    }

    public function UpdateApproverOfLeave($_id = '', $_approver_id = '', $_status,Request $request)
	{
		
		$approverId = $_approver_id;
		$id = $_id;
		$leaveDetails = $this->getLeaveDetails($id);
		$masterApprover = $this->NextApproverOfLeave($approverId, $leaveDetails->username);
		
		if ($masterApprover != $approverId && $masterApprover != '') {

			$this->setAssignee($id, $masterApprover);

			$emailSendingStatus1 = DB::table('settings')->where('field','email_by_cronjob')->first();
			$emailSendingStatus = $emailSendingStatus1->value;
			
			$user = User::where('id' , Auth::id())->first();
			$uname = UserPersonal::where('username',$user->username)->first();
			$name = $uname->name;
			

			$email_send_allow = true;
            $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
            $sendbypreference = $sendbypreference1->value;
			if ($sendbypreference) {
				if (!hasContentPreference($leaveDetails->username)) {
					$email_send_allow = true;
				} else {
					$email_send_allow = false;
				}
			}
			$sStatus='';
			if ($email_send_allow) {
				if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->start_date;
					$to_date = $leaveDetails->end_date;
					$type_display = getLeaveNameByType($leaveDetails->type);

					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = str_replace('self-leaves', 'dashboard', url()->current());

					$body = "Leave has been Approved by $name and need your approval on this same. ";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "Employee Name: $emp_name<br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date('h:i A',$leaveDetails->start_time);
                        $endTime = date('h:i A',$leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display<br>";
					$body .= "Reason: $reason<br>";
					$body .= "Link: <a href='$referer'>$referer</a><br><br>";
					$body .= "Kind regards,";
					$body .= "Note, this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";
					
					$semail = UserPersonal::where('username',$masterApprover)->first();
					//Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
					sendemail($semail->email_id,$subject,$body);
				} else {

					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;


                    // $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                    $referer = route('approve-leave');
                    
					$body = "<tr>";
					$body .= "<td>$emp_name</td>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
					$body .= "<td>$type_display Leave<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  $leaveDetails->start_time;
                        $endTime = $leaveDetails->end_time;
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					 else {
					    $body .= "<br></td>";
					}
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords($sStatus) . "</td>";
					$body .= '<td><a href="'.$referer.'">'.$referer.'</a></td>';
					$body .= "</tr>";
                    //dd($body);
					$this->pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
				}
			}

			return false;
		}
		return true;
    }
    
    public function getLeaveDetails($id)
	{
		
		$builder = DB::table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->leftjoin('user_personal as c','a.username','=','c.username')->where('a.id',$id)->selectRaw("a.id, a.leave_id, a.username, c.name, c.employee_no, b.type, DATE_FORMAT(b.date_applied, '%m/%d/%Y') as date_applied_cal, DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date,a.date as sdate, a.date as edate, DATE_FORMAT(a.date, '%m/%d/%Y') as start_date_cal, DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', a.status, b.reason, b.leave_category as leave_category, b.approver_id, a.cancellation_reason, b.half_day_type,b.is_half_day, b.start_time, b.end_time, b.is_hourly ")->get();
		//dd($builder);
		$result = $builder[0];
		
		return $result;
	}

    public function NextApproverOfLeave($currentApprover, $user_id)
	{

		$approverArray = getApproversOfEmployee($user_id);
		

		for ($i = 0; $i < count($approverArray); $i++) {
			if ($currentApprover == $approverArray[$i]->username) {
				if (count($approverArray) == ($i + 1)) {
					return $currentApprover;
				} else {
					return $approverArray[$i + 1]->username;
				}
			}
		}
    }
  

    public function get_approver_by_leaveid($id){
        // $builder = DB::table('leave_approver')->where('status','0')->where('leave_id',$id)->selectRaw("count(id) as value")->first();
		// $result = $builder->value;
		$result=0;
         return $result;
    }

    public function setStatus11($id, $status)
	{
		$query = "update leave_days set status='$status' where id='$id'";
		$builder = DB::select($query);
		$resultVal = $builder;
		
		$builder = DB::table('leave_days')->where('id',$id)->selectRaw("leave_id")->first();;
		$leaveId = $builder->leave_id;
		$approved = '';
		if($status=='1'){
			$approved = ", date_approved='".date('Y-m-d')."'";
		}
		$query = "update leave_list set status='$status'".$approved." where id='$leaveId'";
		$builder = DB::select($query);
        return $resultVal;
        
    }
    
    public function getNPL_HR_User(){
		
		$builder = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg','mep.permission_group_id','=','pg.id')->leftjoin('user_personal as up','mep.employee_id','=','up.username')->where('pg.hr',3)->selectRaw("mep.employee_id,up.name")->get();
		$result = $builder;
        return $result;
        
    }
    
    public function updateLeaveDays($reason,$leaveId,$which='cancel'){
		if($which=='cancel'){
			$query = "update leave_days set cancellation_reason='$reason' where id='$leaveId'";
			$result2 = DB::select($query);
		}
		if($which=='reject'){
			$query = "update leave_days set reject_reason='$reason' where id='$leaveId'";
			$result2 = DB::select($query);
		}
		
    }
    
    public function setAssignee($id, $assignee)
	{
		$query = DB::table('leave_days')->where('id',$id)->selectRaw("leave_id")->first();
		$leaveId = $query->leave_id;
		
		$query = "update leave_list set approver_id='$assignee' where id='$leaveId'";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    public function pendingEmailInsert($emp_name, $to,$body,$subject,$leave_type,$username){
       
		$query = "insert into pending_emails (`emp_name`, `email_to`, `email_body`, `email_subject`, `leave_status`, `sent_status`, `leave_username`) values ('$emp_name', '$to', '$body', '$subject', '$leave_type','0','$username')";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    public function getCancelLeave_Approver(){
        
        $query = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg','mep.permission_group_id','=','pg.id')->leftjoin('user_personal as up','mep.employee_id','=','up.username')->where('pg.cancel_leave','1')->selectRaw("mep.employee_id, up.username")->get();
		$result = $query;
		return $result;
    }
    
    public function getMaxValue($leave_type,$category){
		$builder = DB::table('category_max_leave')->where('leave_type',$leave_type)->where('category',$category)->first();
		if($builder!='')
		$result = $builder->max_value;
		else
		$result=0;
		
		return $result;
    }
    
    public function getLeaveAccordingToTypeCount($year,$username,$type,$status='1')
	{
		$builder = DB::table('leave_list')->where('type',$type)->where('username',$username)->where('status',$status)->whereYear('start_date',$year)->count();
		$result = $builder;
		return $result;
    }
    
    public function changeType($id, $type)
	{
		$listId = $this->getLeaveListId($id);
		$query = "update leave_list set type='$type' where id='$listId'";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    public function getLeaveListId($leaveDaysId)
	{
		$builder = DB::table('leave_days')->where('id',$leaveDaysId)->first();
		$result = $builder->leave_id;
		return $result;
	}

	public function getYearlyEntitleMain($username = '', $year = '' , $in_json = true, $date = '', $updt = '')
	{
	    $date_for_query = "CURDATE()";
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
		$cutOffStartMonth=$cutOffStartMonth11->value;
		$userPay = DB::table('user_pay')->where('username' , $username)->first();
		
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		if ($SettingLeaveAdjustmentType == 8) {
			$joiningDate = $userPay->date_commence;
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
				if (date('Y-m-d') < $curr_date) {
					$year = $year - 1;
				}
			
		}
		
		$SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
		$SoftwareStartDate = $SoftwareStartDate11->value;

		$companyName11 = DB::table('settings')->where('field', "company")->first();
		$companyName='';
		if($companyName11!='')
		$companyName = $companyName11->value;

		$isShowClaimable = $this->getConfirmDisplay($username);

		$date_commence = $userPay->date_commence;
		$joiningDate = strtotime($date_commence);

		$cutOffStartYear = $year;
		$cutOffYear = $year;
		if($cutOffStartMonth!=1){
			if($cutOffStartMonth > date('m')){
				$cutOffStartYear = $year;
				$cutOffYear = $year;
			}else{
				$cutOffStartYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$cutOffStartYear = $year;
			$cutOffYear = $year;
		}
		
		$RL_forfeit = getForfeitAdjLeaveCount($username, $year);

		$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
		$medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);
		
		$medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
		$medical_pro_rated = $medical_pro_rated11->value;
		$joiningDate = $userPay->date_commence;
		$joiningDateArr = explode('-', $joiningDate);
		if ($medical_pro_rated == 1) {


			$joining_year = $joiningDateArr[0];
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			$resultArrayVal = DB::table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as experience, date_commence")->first();

			$ExperienceInYear = intval($resultArrayVal->experience) + 1;
			$joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

			//section one	
			$prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
			$start = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
			$datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
			$days1 = round($datediff / (60 * 60 * 24));

			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($prev_date_of_joining_date);
			$diff = $date1->diff($date2);
			$experiance1 = $diff->y;
			if ($experiance1 == 0) {
				$experiance1 = 1;
			}
			

			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$medicalEntitlenew1 = $builder1[0]->no_leaves;
			$d1 = ($days1 / 365) * $medicalEntitlenew1;

			$a1 = array(
				'username' => $username,
				'joining date' => $joiningDate,
				'entitle' => $medicalEntitlenew1,
				'start date' => $start,
				'end date' => $prev_date_of_joining_date,
				'days' => $days1,
				'experiance' => $experiance1,
			);
			//section one

			//section two
			$end_date = $year . "-".$cutOffMonth."-".$cutOffDate;
			$datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
			$days2 = round($datediff2 / (60 * 60 * 24));

			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($end_date);
			$diff = $date1->diff($date2);
			$experiance2 = $diff->y;
			if ($joiningdatecurrent <= date('Y-m-d')) {
				$experiance2 = $experiance2 + 1;
			}
			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$medicalEntitlenew = $builder1[0]->no_leaves;
			$d2 = ($days2 / 365) * $medicalEntitlenew;

			$a2 = array(
				'username' => $username,
				'joining date' => $joiningDate,
				'entitle' => $medicalEntitlenew,
				'start date' => $end_date,
				'end date' => $joiningdatecurrent,
				'days2' => $days2,
				'experiance' => $experiance2,
			);
			
			if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
				if ($medicalEntitlenew1 != $medicalEntitlenew) {
					$medicalEntitle = round($d1 + $d2);
				} else {
					if ($medicalEntitlenew1 != '') {
						$medicalEntitle = $medicalEntitlenew1;
					} else if ($medicalEntitlenew != '') {
						$medicalEntitle = $medicalEntitlenew;
					}
				}
			}
		}
		
		$resiged_date_str = $userPay->date_resigned;
		$joiningDate = $userPay->date_commence;
		$joiningDateArr = explode('-', $joiningDate);
		$resignDateArr = explode('-', $resiged_date_str);
		$resign_year = $resignDateArr[0];
		$joining_year = $joiningDateArr[0];
		if ($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
			$joining_year = $joiningDateArr[0];
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($joiningdatecurrent);
			$diff = $date1->diff($date2);
			$experiance1 = $diff->y;
			$experiance1 = $experiance1 + 1;
			

			
			if ($joining_year < $year && $resign_year == $year) {
				$joining_year = $joiningDateArr[0];
				$joining_month = $joiningDateArr[1];
				$joining_date = $joiningDateArr[2];
				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
				$date1 = new DateTime($joiningDate);
				$date2 = new DateTime($joiningdatecurrent);
				$diff = $date1->diff($date2);
				$experiance_1 = $diff->y;
				if ($experiance_1 == 0) {
					$experiance_1 = 1;
				}
				
				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$annualEntitle_1 = $builder_1[0]->no_leaves;

				$experiance_2 = $experiance_1 + 1;
				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$pro = 0;
				$annualEntitle_2 = $builder_2[0]->no_leaves;
				
				if (($annualEntitle_1 != $annualEntitle_2)  && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
					$pro = 1;
					$datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
					$days1 = round($datediff11 / (60 * 60 * 24));
					$datediff22 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
					$days2 = round($datediff22 / (60 * 60 * 24));
					$first_dif = ($days1 / 365) * $annualEntitle_1;
					$second_dif = ($days2 / 365) * $annualEntitle_2;
					$annualEntitle = ($first_dif + $second_dif);
					
				} else {
					$datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
				}
				//echo $annualEntitle;exit;
			} else if ($joining_year < $year && $resign_year > $year) {
				$joining_year = $joiningDateArr[0];
				$joining_month = $joiningDateArr[1];
				$joining_date = $joiningDateArr[2];
				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
				$date1 = new DateTime($joiningDate);
				$date2 = new DateTime($joiningdatecurrent);
				$diff = $date1->diff($date2);
				$experiance_1 = $diff->y;
				if ($experiance_1 == 0) {
					$experiance_1 = 1;
				}
				
				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$annualEntitle_1 = $builder_1[0]->no_leaves;

				$experiance_2 = $experiance_1 + 1;
				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$pro = 0;
				$annualEntitle_2 = $builder_2[0]->no_leaves;
				if ($annualEntitle_1 != $annualEntitle_2) {
					$pro = 1;
					$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-".$cutOffMonth."-".$cutOffDate);
				}
			} else if ($joining_year == $year && $resign_year == $year) {
			    	$pro = 0;
				$datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);
			} else if ($joining_year == $year && $resign_year > $year) {
			    	$pro = 0;
				$datediff2 = strtotime($cutOffYear . "-".$cutOffMonth."-".$cutOffDate) - strtotime($joiningDate);
			}

			
			$days = round($datediff2 / (60 * 60 * 24));
			$annualEntitle1 = $days / 365;
			if ($joining_year < $year && $resign_year > $year) {
				if ($pro == 0) {
					$annualEntitle = $annualEntitle;
				}
			} else {
				if ($pro == 0) {
					$annualEntitle = $annualEntitle;
				}
			}
		}
		

		if ($SettingLeaveAdjustmentType == 8 || $SettingLeaveAdjustmentType == 1) {
			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$joiningDate = $userPay->date_commence;

			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			$curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($curr_date);
			$diff = $date1->diff($date2);
			$ExperienceInYear = $diff->y;
			if ($diff->d > 0) {
				$ExperienceInYear = $ExperienceInYear + 1;
			}

			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$annualEntitle = $builder2[0]->no_leaves;
			
		} else if ($SettingLeaveAdjustmentType == 6  && $joining_year != Date('Y')) {
			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$joiningDate = $userPay->date_commence;
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			if($year!=""){
				
				if($year == date('Y')){
					$curr_date = date($year.'-m-d');
				}else {
					$curr_date = ($year) . "-".$cutOffMonth."-".$cutOffDate;
				}
				
			}else{
				$curr_date = date('Y-m-d');
			}


			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($curr_date);
			$diff = $date1->diff($date2);
			$ExperienceInYear = $diff->y;
			$actual_ExperienceInYear = $ExperienceInYear;

			if ($diff->d > 0 || $joiningDate == $curr_date) {
				$ExperienceInYear = $ExperienceInYear + 1;
			}
			if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
				$ExperienceInYear = 1;
			}
			
			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			if($actual_ExperienceInYear>0){
				$annualEntitle = $builder2[0]->no_leaves;
			}
		}
		$rlLeave = getReplacementLeaveCount($username, $year);
		$annaualTaken = getTakenLeaveCount($username, $year, "Annual");
		$medicalTaken = getTakenLeaveCount($username, $year, "Medical");
		$pastLeaves = getTakenPastLeaves($username, $year);
		$adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
		if ($SoftwareStartDate <= ($year - 1)) {
			$bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
		} else {
			$bfAnnual = 0;
		}
		
		$EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);
		$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
		$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
		$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
		$nplCount = getNPLCount($username, $year);

		if($cutOffStartMonth!='1'){
			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
		}else{
			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
		}
		

		

		if ($BFLeaveTaken > $bfAnnual) {
			$BFLeaveTaken = $bfAnnual;
		}


		$tilldateDaysVal = tilldateDays($date_commence);
		$tillYearEndDaysVal = tillYearEndDays($date_commence);
		$YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);

		$resiged_date_str = $userPay->date_resigned;
		$resiged_date = strtotime($resiged_date_str);
		$resiged_year = date('Y', $resiged_date);

		if ($date != '') {
			$leave_month = date("n", strtotime(str_replace('/', '-', $date)));
			$leave_year = date("Y", strtotime(str_replace('/', '-', $date)));
		} else {
			$leave_month = date("n");
			$leave_year = date("Y");
		}

		if ($SettingLeaveAdjustmentType == 8) {
			$annual_ent = get_anniv_cutt_off_entitle($username, $year);
			$cut_off_days = day_count_anniv_cutt_off($username, $year);
			$earn = ($cut_off_days / 365) * $annual_ent;
			$earn = roundaway($earn);
		} else {
			if ($year < $leave_year) {
				$earn = roundaway($annualEntitle);
			} else {
				if($cutOffStartMonth!=1 && $cutOffMonth <= $leave_month && $year<=$leave_year){
					$earn = roundaway($annualEntitle);
				}else if ($year == $resiged_year) {
					if ($leave_month < date('n', $resiged_date)) {
						$earn = roundaway(($leave_month /  date('n', $resiged_date)) * roundaway($annualEntitle));
					} else {
						$earn = roundaway(roundaway($annualEntitle));
					}
				} else {
					if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
						$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
					} else {
						if ((date("n", strtotime($joiningDate)) == $leave_month) && date("Y", strtotime($joiningDate)) == $leave_year) {
							$earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
						} else {
							if($cutOffStartMonth>$leave_month){
								if(date("Y", strtotime($joiningDate)) == $leave_year){
									$month_cal = $leave_month - $joiningDateArr[1];
								}else{
									if($joining_year==($leave_year-1) && $cutOffStartMonth>$joiningDateArr[1]){
										$month_cal_1 = 12 - $cutOffStartMonth;
									}else if($joining_year==($leave_year-1)){
										$month_cal_1 = 12 - $joiningDateArr[1];
									}else{
										$month_cal_1 = 12 - $cutOffStartMonth;
									}
									$month_cal = $month_cal_1 + $leave_month;
								}
								$month_cal = $month_cal +1;
								
							}else{
								$month_cal = $leave_month - $cutOffStartMonth;
								$month_cal = $month_cal +1;
							}
							if (date("Y", strtotime($joiningDate)) == $leave_year) {
								if ($companyName == "earn_prorated") {
									$earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
								} else {
									$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
								}

								
								if ($month_cal == 12) {
									$earn = roundaway($annualEntitle);
								}
							} else {
								
								$earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
							}
						}
					}
				}
			}
		}
		$annualEntitle_arr = explode('.', number_format($annualEntitle, 2));
		if (isset($annualEntitle_arr[1])) {
			
			if ($annualEntitle_arr[1] > 1 && $annualEntitle_arr[1] <= 25) {
				$annualEntitle = floor($annualEntitle);
			} else if ($annualEntitle_arr[1] >= 26 && $annualEntitle_arr[1] <= 75) {
				$annualEntitle = $annualEntitle;
			} else if ($annualEntitle_arr[1] > 75) {
				$annualEntitle = ceil($annualEntitle);
			} else {
				$annualEntitle = $annualEntitle;
			}

		} else {
			$annualEntitle = $annualEntitle;
		}


		$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);
		$bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

		$yearlyEntitle = array(
			"annual" => array(
				"entitle" => getValue($annualEntitle),
				"taken" => floatval($annaualTaken),
				"rlLeave" => floatval($rlLeave),
				"rlLeaveTaken" => $rlLeaveTaken,
				"rlForfeit" => $RL_forfeit,
				"isShowClaimable" => $isShowClaimable
			),
			"medical" => array(
				"entitle" => floatval($medicalEntitle),
				"taken" => floatval($medicalTaken)
			),
			"past_leaves" => $pastLeaves,
			"adjust_leaves" => $adjustmentLeaves,
			"npl" => $nplCount,
			"earn" => $earn,
			"EmergencyLeaveValue" => $EmergencyLeaveValue,
			"brought_forward" => array(
				"annual" => ($bfAnnual),
				"annual_taken" => floatval($BFLeaveTaken),
				"annual_adj" => ($bfAnnualAdj),
				"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
				"medical" => $bfMedical,
				"medical_adj" => $bfMedicalAdj
			),
			"date_commence" => $date_commence
		);

		$totalDaysTillToday =  tillTodayTotalDays($year, $date);

		// $BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
		// $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
		
		$users=DB::table('users')->where('username',$username)->first();
		$usercat =DB::table('user_category')->where('username',$username)->first();
		$BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
				
		$BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();

        $BFClearDuration = $BFClearDuration11->value;
		$BFAdjClearDuration = $BFAdjClearDuration11->value;
		
		$yearlyEntitle['bf_forfeit'] = 0;
		$yearlyEntitle['bfadj_forfeit'] = 0;
		$yearlyEntitle['adj_forfeit'] = 0;

		$bf_forfeit_value = 0;
		$bfadj_forfeit_value = 0;

		$checking_leave_year = $leave_year;
		if($cutOffStartMonth!=1){
			if($cutOffStartMonth>=$leave_month){
				$checking_leave_year = $leave_year+1;
			}
		}

		if (($BFClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFClearDuration < 365) {
			$yearlyEntitle['bf_forfeit'] = 1;
			$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
		}

		if (($BFAdjClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFAdjClearDuration < 365) {
			$yearlyEntitle['bfadj_forfeit'] = 1;
			$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
		}

		$total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value);
		
		//$preset1 = DB::table('settings')->where('field', "claimable_pre_set")->first();
		$user=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
		$preset = $preset1->value;
		$earn1 = ($earn - $preset);
		$ear1 = ($preset / 12) * $annualEntitle;
		$earn1 = $earn - $ear1;
		if ($SettingLeaveAdjustmentType == 8) {
			$_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
		} else {
			if ($year < date('Y')) {
				if ($earn1 > $annualEntitle) {
					$earn2 = $annualEntitle;
				} else {
					$earn2 = $earn1;
				}
				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
				
			} else {
				if ($earn1 > $annualEntitle) {
					$earn2 = $annualEntitle;
				} else {
					$earn2 = $earn1;
				}
				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
				
			}
			$_claim = roundaway($_claim);
			if ($_claim < 0) {
				$_claim = 0;
			}
		}
		
		$confirm_disp1 = DB::table('settings')->where('field', "confirm_display")->first();
    	$confirm_disp = $confirm_disp1->value;
		$user_pay = DB::table('user_pay as a')->where('a.username', $username)->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, a.pay_status, a.contract")->leftjoin('branch as b','a.branch_id','=','b.id')->leftjoin('department as c','a.department_id','=','c.id')->leftjoin('category as d','a.category_id','=','d.id')->first();
		if ($confirm_disp == '1') {
			$user_pay->date_confirmed." -- ";
			if ($user_pay->date_confirmed == '' || $user_pay->date_confirmed == '00-00-0000') {
				$_claim = 0;
			}
		}
		
		if (date("Y", strtotime($joiningDate)) == $leave_year) {


			if ($yearlyEntitle['annual']['isShowClaimable'] == 0) {
				$yearlyEntitle["claimable"] = 0;
			} else {
				
				$yearlyEntitle["claimable"] = $yearlyEntitle['earn'];
			}
		} else {
			$yearlyEntitle["claimable"] = $_claim;
		}
		
		$yearlyEntitle["balance"] = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit);
		if ($in_json) {
			return json_encode($yearlyEntitle);
		} else {
			return $yearlyEntitle;
		}
	}

	public function getConfirmDisplay($username)
	{
		$ConfirmDisplayUser11 = DB::table('settings')->where('field', "confirm_display")->first();
		$ConfirmDisplayUser = $ConfirmDisplayUser11->value;
		$userpay = DB::table('user_pay')->where('username', $username)->first();
		$userConfirmDate = $userpay->date_confirmed;
		$userJoinDate = $userpay->date_commence;
		$isShowClaimable = 1;
		if ($ConfirmDisplayUser == 1) {
			if ($userConfirmDate != 0) {
				$month = date('n', strtotime($userConfirmDate));
				if ($month != 0) {
					$isShowClaimable = 1;
				} else {
					$isShowClaimable = 0;
				}
			} else {
				$isShowClaimable = 0;
			}
		}
		return $isShowClaimable;
	}

	public function getTakenPastLeaves2($username, $leavedate, $year)
	{
	    $hours = gethours();
		$leavedate = str_replace('/','-',$leavedate);
		$leavedate = date('Y-m-d',strtotime($leavedate));
		
		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
		$builder = DB::table('leave_past')->where('type','Annual')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as no_leave")->first();
		$noleave ="";
		if(!empty($builder)){
			$noleave=$builder->no_leave ?? 0;
		}
		
		$annualLeaves = floatval($noleave);
			
		$builder1 = DB::table('leave_past')->where('type','Medical')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as no_leave")->first();
		$mnoleave ="";
		if(!empty($builder1)){
			$mnoleave=$builder1->no_leave ?? 0;
		}
		$medicalLeaves = floatval($mnoleave);
		
		$builder2 = DB::table('leave_past')->where('type','Other_pay')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as no_leave")->first();
		$onoleave ="";
		if(!empty($builder2)){
			$onoleave=$builder2->no_leave ?? 0;
		}
		$replacementLeaves = floatval($onoleave);
		
		$builder3 = DB::table('leave_past')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as no_leave")->first();
		$tnoleave ="";
		if(!empty($builder3)){
			$tnoleave=$builder3->no_leave ?? 0;
		}
		$totalLeaves = floatval($tnoleave);
		
		$takenLeaves = array("annual" => $annualLeaves, "medical" =>$medicalLeaves, "replacement"=>$replacementLeaves, "total" => $totalLeaves);
		return $takenLeaves;
	}

	public function getTakenLeaveCount2($username, $type, $leavedate, $year)
	{
		$leavedate = str_replace('/','-',$leavedate);
		$leavedate = date('Y-m-d',strtotime($leavedate));
		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		$hours = gethours();
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
	
		$builder = DB::table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->where('a.status','1')->where('b.type',$type)->whereRaw("(date between '$start_date' and '$end_date')")->where("a.username",$username);
		if($type!="Emergency"){
			$builder->where('b.leave_category','!=','Emergency');
		}
		$val = $builder->selectRaw("sum(CASE b.is_hourly WHEN 1 THEN (( (b.end_time-b.start_time)/3600 )/".$hours.") WHEN 0 THEN (CASE b.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) END) as leave_taken")->first();

		$value = $val->leave_taken;
		if($value==''){
			$value = 0;
		}
		
		return $value;
	}

	public function getEmergencyLeaveCountByUser2($username,$leavedate,$year)
	{
		$leavedate = str_replace('/','-',$leavedate);
		$leavedate = date('Y-m-d',strtotime($leavedate));
        $hours = gethours();
		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
		
		$builder1 = DB::table('leave_past')->where('type','Emergency')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 0 THEN total_leave_days WHEN 1 THEN (((end_time-start_time)/3600)/$hours) WHEN 0 THEN total_leave_days END) as no_leave")->first();
		
		$result1 = $builder1;
		$past_val = $result1->no_leave;
		
		
		$builder = DB::table('leave_list')->where('type','Emergency')->where('type','!=','NPL')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (( (end_time-start_time)/3600 )/$hours) WHEN 0 THEN (CASE is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) END) as no_leave")->first();
		
		$result = $builder;
		$all_val = $past_val + $result->no_leave;
		return floatval($all_val);
	}

	public function changeCategory($id, $category)
	{
		
		$leave = Leavelist::find($id);
       	$leave->leave_category = $category;
		$leave->save();
		return $leave;
	}

	public function changeTypeOfLeaveList($listid, $type)
	{
		$leave = Leavelist::find($listid);
       	$leave->type = $type;
		$leave->save();
		return $leave;
	}

	public function deleteRLeave(Request $request)
	{
		//dd($request->ids);
		$ids = $request->ids;
		$result = $this->DeleteRLeave11($ids);
		return array("result" => true);
	}

	public function DeleteRLeave11($ids){
		
		//$ids = implode(', ',$ids);
		//dd($ids);
		$builder = DB::table('rl_leaves')->whereIn('id',$ids)->delete();
		return true;
	}

	public function RLeaveStatus(Request $request)
	{
		$ids = $request->ids;
		//dd($ids);
		$status = $request->status;
		$this->RLeaveStatus11($ids, $status);
	}

	public function RLeaveStatus11($ids,$status){
		//$ids = implode(', ',$ids);
		$result = DB::table('rl_leaves')->whereIn('id',$ids)->get();
                
		for($i=0;$i<count($result);$i++){
			
			if($result[$i]->no_granted==1){
				$count_to_run_query = 2;
			}else{
				$count_to_run_query = 1;
			}

			for($i_c=0;$i_c<$count_to_run_query;$i_c++){
				
				DB::table('leave_adjustment')->insert(array('employee_id' => $result[$i]->employee_id,'start_date' => $result[$i]->start_date,'end_date'=>$result[$i]->end_date,'no_days'=>$result[$i]->no_days,'no_granted'=>'0.5','taken_stat'=>$result[$i]->taken_stat,'reason'=>$result[$i]->reason,'date_applied'=>$result[$i]->date_applied));
	
			}
			
		}
		
        DB::table('rl_leaves')->whereIn('id',$ids)->delete();
        
	}

	public function rejectRLeave(Request $request)
	{
		$ids = $request->ids;
		$status = $request->status;
		$result = $this->rejectRLeave11($ids);
		return array("result" => true);
	}

	public function rejectRLeave11($ids){
		//$ids = implode(', ',$ids);
		DB::table('rl_leaves')->whereIn('id',$ids)->update(array('leave_status' => 'rejected'));
		return true;
	}



	public function applyonbehalf(Request $request){
		
		$data = $this->addLeaveByApprover(request());
		
		//\Log::info(json_encode($data));
		//return Response::json(json_decode($data), 200);
		return Response::json($data, 200);
		
	}

	public function addLeaveByApprover(Request $request)
	{
		$username = $request->username;
		$approverId = Auth::user()->username;
		$file = $request->file('slip_file');
		$endFileName='';
		if(!empty($file))
			{
			
				$file = $request->file('slip_file');
				$extension = $file->getClientOriginalExtension();
				$endFileName = env('FILE_UPLOAD_PREFIX'). rand(111111111,99999999999). '.' . $extension;
				$filePath = 'public/upload/';
				
				try {
				    
					Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
						
				} 
				catch (\Exception $e) {
                  
				}
		}
		foreach(explode(':', $request->leave_type) as $type) {
			$leavetype = $type;
			break 1;
		}
		$startTime = ($request->start_time != "") ? $request->start_time : "";
		$endTime = ($request->end_time != "") ? $request->end_time : "";
		$is_hourly = 0;
		if($request->hof==1){
			$half_day_type = $request->half_day_type;
			$edate = $request->leave_start_date;
		}
		elseif ($request->hof == 2) {
                $half_day_type = '';
                $is_hourly = 1;
                $time_from = $request->time_from;
                $time_for = $request->time_for;
                $no_of_hours = $request->time_for;
                $noDays = 0;
                if (!empty($request->leave_start_date)) {
                   $leavedate = $request->start_date . ' ' . $time_from;
                    $startTime = strtotime($leavedate);
                    $time_for = explode(":",$time_for);
                    $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate. ' + '.$time_for[0].' hours')));
        
                }
                if (!empty($request->leave_end_date)) {
                    $edate = $request->leave_end_date;
                } else {
                    
                    $edate = $request->leave_start_date;
                }
            }
		else{
			$half_day_type='';
			$edate=$request->leave_end_date;
		}
		$type = $leavetype;
		$isHalfDay = $request->hof;
		$half_day_type = $half_day_type;
		$startDate = $request->leave_start_date;
		$endDate = $edate;
		$noDays = $request->no_of_day;
		$reason = $request->reason;
		$status = $request->status;
		$Relieve = $request->relieve;
		$filename = $endFileName;

		//echo " FIRST TYPE 1 = ".$type." <-- TYPE -- ";

		if ($approverId == "") {
			echo json_encode(array("result" => false, "msg" => "Please refresh your page, before add new leaves."));
			exit;
		}

		$D_year = date('Y', strtotime($request->leave_start_date));

		if ($type == "Other_pay") {
			if ($isHalfDay == '1') {
				markReplacementLeaveAsTaken($username, $D_year);
			} else {
				for ($_rl_i = 0; $_rl_i < ($noDays * 2); $_rl_i++) {
					markReplacementLeaveAsTaken($username, $D_year);
				}
			}
		}
		$_added_one_at_least = false;
		/*$leaveId = $this->table->addLeave($username, $approverId, $type, $isHalfDay, $startTime, $endTime, $startDate,
			$endDate, $noDays, $reason);*/
		$isShowClaimable = getConfirmDisplay($username);

		$groups = getCountryState($username);
		$branch_cat_dept = getUserGroups($username);
		$holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0");
		$restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->leave_start_date, $edate);
        //dd($restdays);
		$blockdates = $this->getBlockAllDayslistByUserId($username);

		$appliedDays = $this->getLeaveDaysBetweenDates($username, $startDate, $endDate);
		$date1 = $this->add_date($startDate);
		$date2 = $this->add_date($endDate);
		$this->total_Emergency = 0;
		$conditional_msg = "";
		//unset($_SESSION['maxday']);
		
		for ($index = $date1; $this->dateDifference($date2, $index) >= 0; $index = $this->add_date($index, 1)) {
			$new_type = $type;
			$noDays = "1";
			if ($isHalfDay == "1")
				$noDays = "0.5";

			$add_allow = false;
			if ($isHalfDay == '1') {
				if ($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $isHalfDay, $half_day_type) < 1) {
					$add_allow = true;
				} else {
					$add_allow = false;
				}
			} else {

				if ((!$this->isLeaveAppliedDate($index, $appliedDays))) {
					$add_allow = true;
				} else {
					$add_allow = false;
				}
			}

			$restday_allow_now = true;
			if (!$this->checkHolidayRestDayInclusive($username, $new_type, 'restday')) {
				if ($this->isRestDay($restdays, $index)) {
					$restday_allow_now = false;
				}
			}
			$holiday_check_allow = true;
			if (!$this->checkHolidayRestDayInclusive($username, $new_type, 'holiday')) {
				if ($this->isHoliday($holidays, $index)) {
					$holiday_check_allow = false;
				}
			}

			$blockdays_check_allow = true;
			if ($this->isHoliday($blockdates, $index)) {
				$blockdays_check_allow = false;
			}


			if ($restday_allow_now && $holiday_check_allow && $add_allow && $blockdays_check_allow) {
				//echo " FIRST TYPE = ".$new_type." <-- TYPE -- ";
				$leaveId = $this->addLeave($username, $approverId, $new_type, $is_hourly,$isHalfDay, $startTime, $endTime, $index, $index, $noDays, $reason, $half_day_type, "Normal", $filename, $Relieve);
				$this->addLeaveDays($leaveId, $username, $index, $status);
				$_added_one_at_least = true;

				$leave_day_arr = DB::table('leave_days')->select('id')->where('leave_id',$leaveId)->get();
				/* echo "<pre>";
				print_r($leave_day_arr[0]['id']);
				echo "</pre>"; */
				$this->setStatus($leave_day_arr[0]->id, '', '1',request());

				//$this->setStatus($leaveId,'','1');

				//adjust leave type
				$yeararr = explode('-', $startDate);
				$year = $yeararr[0];
				//dd($leaveDetails);
				$leaveDetails = $this->getLeaveDetails($leave_day_arr[0]->id);
				$leaveAllowMaxvalue = $this->getMaxLeaveValue($new_type);
				$totalLeaveValue = $this->getLeaveAccordingToTypeCount($year, $username, $new_type);
				//echo $leaveAllowMaxvalue.' - '.$totalLeaveValue.' - '.$username.' - '.$new_type.' - '.$year.'<br>';
				$all_leavename = $this->getLeaveNameAll();

				$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
				$SoftwareStartDate = getSettingsValue("software_start_year");

				//echo $SoftwareStartDate."<=".($year-1)." <br />";
				if ($SoftwareStartDate <= ($year - 1)) {
					$bfAnnual = getBFValue($year - 1, $username, $index);
					//$bfAnnual = $this->getBFValue($year,$username);
				} else {
					$bfAnnual = 0;
				}

				$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);

				if ($BFLeaveTaken > $bfAnnual) {
					$BFLeaveTaken = $bfAnnual;
				}

				$bfAnnual = $BFLeaveTaken;

				$TakenPastLeaves = getTakenPastLeaves($username, $year);

				$taken = getTakenLeaveCount($username, $year, $new_type);
				$leave_end_month = date('m', strtotime(str_replace("/", "-", $index)));
				$yearlyEntitle = $this->getYearlyEntitleMain($username, $year, FALSE, $index);
				$claimable = $yearlyEntitle['claimable'];

				if ($isShowClaimable == 0) {
					$claimable = 0;
				}
				if ($new_type == 'Medical') {
					$em_leave = 0;
				} else {
					$em_leave = getEmergencyLeaveCountByUser($username, $year);
				}

			
				$dateDiff = diff(strtotime($index), strtotime(date('Y-m-d', time())));
				//echo "<br /> -- END TYPE = ".$new_type." <br /><br />";

				//checking all category for max allowed leave in that category
				$categoryId = getUserCategory($username);
				$leaveAllowMaxvalue = $this->getMaxValue($new_type, $categoryId);
				$totalLeaveValue = $this->getLeaveAccordingToTypeCount($year, $username, $new_type);

				//echo " --> ".$new_type." <-- <br />";

			} elseif (!$restday_allow_now) {
				$conditional_msg = "Selected Date is a Rest Day.";
			} elseif (!$holiday_check_allow) {
				$conditional_msg = "Selected Date is a Holiday.";
			}
		}

		if ($_added_one_at_least = true) {
			$uname = UserPersonal::where('username',$username)->first();
			$name = $uname->name ?? '';
			$emp_id = $username;
			$sStatus = '';
			if ($status == "1")
				$sStatus = "approved";
			else if ($status == "2")
				$sStatus = "rejected";
			else if ($status == "3")
				$sStatus = "recommended";
			else if ($status == "4")
				$sStatus = "cancelled";

			$startDate = date('d F Y', strtotime($startDate));
			$endDate = date('d F Y', strtotime($endDate));
			$subject = "Employee " . $name . " applied for leave";
			//$body = "$name applied leave from $startDate to $endDate<br/><br/><br/>";


			$body = "Dear $name,<br><br>";
			$body .= "Your leave has been $sStatus<br><br>";
			$body .= "Details of the leave are as follows:<br><br>";
			$body .= "From: ".date('d-m-Y',strtotime($startDate))."<br>";
			$body .= "To: ".date('d-m-Y',strtotime($endDate))."<br>";
			if($is_hourly == 1){
			    $startTime =  date("h:i A", $startTime);
                $endTime = date("h:i A", $endTime);
                $body .= "Time: (".$startTime." to ".$endTime.")<br><br>";   
			}
			$body .= "Reason: $reason<br><br>";
			//$body .= "Link: <a href='$referer'>$referer</a>";
			$body .= "Kind regards,<br><br>";
			$body .= "Note: this is an automatic email. Please do not reply. ";
			$body .= "If you did not request this information, please ignore this message. ";
			$body .= "If you have any questions, please contact us";

			$email_send_allow = true;
			$getEmailSendByPrefernces = DB::table('settings')->where('field' , "email_send_by_preferneces")->first();
			
			if ($getEmailSendByPrefernces->value == "1") {
				if (!$this->hasContentPreference($username)) {
					$email_send_allow = true;
				} else {
					$email_send_allow = false;
				}
			}

			if ($email_send_allow) {
				$semail = UserPersonal::where('username',$username)->first();
				    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
				    sendemail($semail->email_id,$subject,$body);
				//Email::sendEmailToUserFromServer($username, $subject, $body);
			}

			return array("result" => TRUE);
		} else {
			return array("result" => false, "msg" => $conditional_msg);
		}
	}


	public function getPublicHolidays($country, $state, $branchId, $year, $startDate="", $endDate="")
	{
		$result = PublicHoliday::where('id','>','0');
		if($country != "")
			$result->where('country',$country);
		if($state != "")
			$result->where('state',$state);
		if($branchId != "0")
			$result->whereRaw("(branch_id = '$branchId' or branch_id='0')");
		if($year != "0" && $year!="")	
			$result->whereYear('date',$year);
		if($startDate != "")
			$result->where('date','>=',$startDate);
		if($endDate != "")
			$result->where('date','<=',$endDate);
		$result = $result->selectRaw("distinct id, date, day(date) as day, month(date) as month, year(date) as year, state, country, description")->groupByRaw('date, description')->orderBy('date')->get();
		return $result;
	}

	public function getRestDaysOfEmployeeBetweenDates($employeeId, $startDate, $endDate)
	{
		
		$user = DB::table('rest_days')->where('employee_id',$employeeId)->selectRaw("employee_id")->get();
		
		$recat = DB::table('rest_day_category_employee')->where('employee_id',$employeeId)->select('category_id')->first();
		if(count($user)>0)
		{
			//dd("hello");
			$result1 = DB::table('rest_dates as a')->leftjoin('rest_days as b','b.id','=','a.rest_day_id');
			
			if($recat!=''){
			    
			    $result1->leftjoin('rest_day_category_employee','b.category_id','=','rest_day_category_employee.category_id')->where('b.category_id', $recat->category_id);
			    
			}
			$result1= $result1->where('b.employee_id',$employeeId)->whereBetween('a.date', [$startDate, $endDate])->selectRaw("a.rest_day_id, a.date")->get();
			$result = $result1;
			return $result;
		}
		else
		{
			//dd("hello1");
			$result1 = DB::table('rest_dates as a')->leftjoin('rest_days as b','b.id','=','a.rest_day_id')->leftjoin('rest_day_category_employee as c','b.category_id','=','c.category_id');
			if($recat!=''){
			    
			    $result1->where('b.category_id', $recat->category_id);
			    
			}
			$result1 = $result1->where('c.employee_id',$employeeId)->whereBetween('a.date', [$startDate, $endDate])->selectRaw("a.rest_day_id, a.date")->get();
			$result = $result1;
			return $result;
		}
	}

	public function getBlockAllDayslistByUserId($username){
		
                
			//branch based for user
			$query = "select bd.block_date as date from block_dates bd ";
			$query .= "left join user_pay up on bd.block_id=up.branch_id where up.username='$username' and bd.is_branch='1'";
			$query .= " and bd.block_date!='1970-01-01' ";
			
			$query .= " union ";
			
			//user based for user
			$query .= "select bd.block_date as date from block_dates bd ";
			$query .= "left join user_pay up on bd.block_id=up.username where up.username='$username' and bd.is_user='1'";
			$query .= " and bd.block_date!='1970-01-01' ";
			
			$query .= " union ";
			
			//category based for user
			$query .= "select bd.block_date as date from block_dates bd ";
			$query .= "left join user_pay up on bd.block_id=up.category_id where up.username='$username' and bd.is_category='1'";
			$query .= " and bd.block_date!='1970-01-01' ";
			
			$query .= " union ";
			
			//department based for user
			$query .= "select bd.block_date as date from block_dates bd ";
			$query .= "left join user_pay up on bd.block_id=up.department_id where up.username='$username' and bd.is_department='1'";
			$query .= " and bd.block_date!='1970-01-01' ";
			
		$builder = DB::select($query);
		$result = $builder;
		return $result;
	}

	public function getLeaveDaysBetweenDates($username, $startDate, $endDate)
	{
		$result1 = DB::table('leave_days')->where('username',$username)->where('date','>=',$startDate)->where('date','<=',$endDate)->whereRaw("(status='1' OR status='0')")->selectRaw("date")->get();
		$result = $result1;
		return $result;

	}

	public function add_date($givendate,$day=0,$mth=0,$yr=0)
	{
		$cd = strtotime($givendate);
		$newdate = date('Y-m-d', mktime(date('h',$cd), 
			date('i',$cd), date('s',$cd), date('m',$cd)+$mth, 
			date('d',$cd)+$day, date('Y',$cd)+$yr));
		return $newdate;
	}

	public function dateDifference($startDate, $endDate)
    {
        $startDate = strtotime($startDate);
        $endDate = strtotime($endDate);
        return $startDate - $endDate;
	}
	
	public function isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave=0)
	{
		
		if($is_pastleave=='1'){
			$query = "select start_date as date from leave_past where username='$username' and start_date='$startDate' and end_date='$endDate' and half_day_type='$half_day_type' ";
			$val1 = DB::select($query);
			$result = $val1;
			$not_allow = 1;
			for($i=0;$i<count($result);$i++){
				// if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
					$not_allow = 0;
					break;
				// }
			}
			
			$val = $not_allow;
		}else{
			$query = "select * from leave_list where username='$username' and start_date='$startDate' and end_date<='$endDate' and half_day_type='$half_day_type'  and (status='1' OR status='0')  ";
			//dd($query);
			$result1 = DB::select($query);
			$result = $result1;
			//dd(count($result));
			$not_allow = 0;
			for($i=0;$i<count($result);$i++){
				// if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
					$not_allow = 1;
					break;
				// }
			}
			
			$val = $not_allow;
		}
		
		return (int)$val;
	}

	public function isLeaveAppliedDate($date, $appliedDays)
	{
		for ($i = 0; $i < count($appliedDays); $i++) {
			if($appliedDays[$i]->date == $date) {
				return TRUE;
			}
		}
		return FALSE;
	}

	public function isHoliday($holidays, $day)
	{
		for ($i = 0; $i < count($holidays); $i++) {
			if($holidays[$i]->date == $day) {
				return TRUE;
			}
		}
		return FALSE;
	}

	public function isRestDay($restdays, $day)
	{
		for ($i = 0; $i < count($restdays); $i++) {
			if($restdays[$i]->date == $day) {
				return TRUE;
			}
		}
		return FALSE;
	}

	public function checkHolidayRestDayInclusive($username, $type, $restday_or_holiday_check = 'restday')
	{
		$result = false;
		
		if($type != 'Annual' && $type != 'Absent' && $type != 'NPL') {
			$categoryId = getUserCategory($username);
			$HolidayRestDayInclusiveArray = $this->getHolidayRestDayInclusive($type, $categoryId);

            if(!empty($HolidayRestDayInclusiveArray)){
			if($restday_or_holiday_check == 'restday') {
				if($HolidayRestDayInclusiveArray->restday_added == '1') {
					$result = true;
				} else {
					$result = false;
				}
			} else {
				if($HolidayRestDayInclusiveArray->holiday_added == '1') {
					$result = true;
				} else {
					$result = false;
				}
			}
            }
            else{
                $result = false;
            }
		} else {
			$result = false;
		}
		return $result;
	}

	public function getHolidayRestDayInclusive($leave_type,$category){
		
		$result1 = DB::table('holiday_restday_inleave_setting')->selectRaw('`restday_added`,`holiday_added`')->where('leave_type',$leave_type)->where('category', $category)->first();
		$result = $result1;
		return $result;
	}

	public function addLeave($username, $approverId, $type, $is_hourly,$isHalfDay, $startTime, $endTime, $startDate, $endDate, $noDays, $reason, $half_day_type, $leaveCategory="Normal",$filename='',$Relieve='')
	{
		//\Log::info($username);
		$data = new Leavelist;
		$data->username = $username;
		$data->approver_id = $approverId;
		$data->type = $type;
		$data->is_hourly = $is_hourly;
		$data->is_half_day = $isHalfDay;
		$data->start_time = $startTime;
		$data->end_time = $endTime;
		$data->start_date = $startDate;
		$data->end_date = $endDate;
		$data->no_days = $noDays;
		$data->reason = $reason;
		$data->half_day_type = $half_day_type;
		$data->leave_category = $leaveCategory;
		$data->filename = $filename;
		$data->relieve = $Relieve;
		$data->save();
		
		return $data->id;
	}

	public function addLeaveDays($leaveId, $username, $date, $status="0")
	{
		
		$data = new LeaveDay;
		$data->leave_id = $leaveId;
		$data->username = $username;
		$data->date = $date;
		$data->status = $status;
		$data->save();
		
		return $data->id;
	}

	public function getMaxLeaveValue($leave_type){
		
		$result=DB::table('category_max_leave')->select('max_value')->where('leave_type',$leave_type)->first();
		return $result->max_value ?? 0;
	}

	public function getLeaveNameAll(){
		$user = User::where('id' , Auth::id())->first();
		$builder = DB::table('leave_name')->where('company_id',$user->company_id)->orderBy('id','desc')->get();
		return $builder;
	}
	
}
