<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\Auth\Authenticatable as UserContract;
use App\Models\UserPersonal;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class Logincontroller extends Controller
{

	protected $storageDriver;

    public function __construct()
    {
      $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }

    function postLogin(Request $request){
    	$request->validate([
    		"username"=>"required",
    		"password"=>"required"
    	]);
    	$user = User::leftjoin('user_pay','user_pay.username','=','users.username')->where('users.username' , $request->username)->leftjoin('user_personal','user_personal.username','=','users.username')->first();
    	
    	if($user){
    	    if($user->pay_status==0){
    	    	return redirect()->back()->with('message','User Inactive!');
    	}else{
    	    $request->session()->put('sessiontime', time());
    	    $request->session()->put('redirectTo', $request->redirectTo);
			if($user->v4_password=='' || $user->v4_password==null){
				$updatepassword = User::where('username' , $user->username)->first();
        		$updatepassword->v4_password = "$2y$10$61Y70Z3svTVnf0vQ3VeW7eKk9glNQMQBkpn8vvUxdm5XHtj.XvM.m";
				$updatepassword->save();
				$otp = DB::table('settings')->where('field', 'otp')->where('company_id', $user->company_id)->first();
				if($user->email_id!='' && ($otp->value ?? 0==1)){
					if(ValidateEmail($user->email_id)){
						$username=$user->username;
						$value = $request->session()->put('otpusername', $username);
						$otp = mt_rand(1000,9999);
						DB::table('user_personal')->where('username',$user->username)->update(array('otp'=>$otp));
						$subject ="Verify OTP";
						$body = "";
						$body .= "Please Provide This OTP to Login : $otp<br/><br />";
						
						$body .= "Note, this is an automatic email. Please do not reply. <br />";
						$body .= "If you did not request this information, please ignore this message. <br />";
						$body .= "If you have any questions, please contact us<br />";
						sendemail($user->email_id,$subject,$body,$user->username);
						return redirect()->route('otp');
					}
					else{
						Auth::login($user, true);
					    $redirect=session()->get('redirectTo');
					    if($redirect!='' || $redirect!=null){
					        if($redirect=='dashboard'){
					            $redirect='employee-dashboard';
					        }
					        return redirect()->route($redirect);
					    }
					    else{
						    return redirect()->route('employee-dashboard');
					    }
					}
				}
				else{
					Auth::login($user, true);
					$redirect=session()->get('redirectTo');
				    if($redirect!='' || $redirect!=null){
				        if($redirect=='dashboard'){
				            $redirect='employee-dashboard';
				        }
				        return redirect()->route($redirect);
				    }
				    else{
					    return redirect()->route('employee-dashboard');
				    }
				}
			}
			else{
				if (Hash::check($request->password, $user->v4_password)) {
					$otp = DB::table('settings')->where('field', 'otp')->where('company_id', $user->company_id)->first();
					// dd(Auth::id());
					if($user->email_id!='' && ($otp->value ?? 0==1)){
						if(ValidateEmail($user->email_id)){
							$otp = mt_rand(1000,9999);
							$username=$user->username;
							$value = $request->session()->put('otpusername', $username);
							DB::table('user_personal')->where('username',$user->username)->update(array('otp'=>$otp));
							$subject ="Verify OTP";
							$body = "";
							$body .= "Please Provide This OTP to Login : $otp<br/><br />";
							
							$body .= "Note, this is an automatic email. Please do not reply. <br />";
							$body .= "If you did not request this information, please ignore this message. <br />";
							$body .= "If you have any questions, please contact us<br />";
							sendemail($user->email_id,$subject,$body,$user->username);
							return redirect()->route('otp');
						}
						else{
							Auth::login($user, true);
							$redirect=session()->get('redirectTo');
    					    if($redirect!='' || $redirect!=null){
    					        if($redirect=='dashboard'){
					                $redirect='employee-dashboard';
					            }
    					        return redirect()->route($redirect);
    					    }
    					    else{
    						    return redirect()->route('employee-dashboard');
    					    }
						}
					}
					else{
						Auth::login($user, true);
						$redirect=session()->get('redirectTo');
					    if($redirect!='' || $redirect!=null){
					        if($redirect=='dashboard'){
					            $redirect='employee-dashboard';
					        }
					        return redirect()->route($redirect);
					    }
					    else{
						    return redirect()->route('employee-dashboard');
					    }
					}
					
					// if (Auth::attempt(['username' => $request->username])) {
					//    return redirect()->route('employee-dashboard');
					// }else{
					// 	return redirect()->back()->with('message','Invalid Credential!!');
					// }
				}
				else
				{
					return redirect()->back()->with('message','Invalid Credential!!');
				}
			}
        	}
    	}else{
    		return redirect()->back()->with('message','User not found');
    	}

	}
	
	public function otpverify(Request $request){

		$request->validate([
    		"otp"=>"required"
    	]);
    	$user = User::leftjoin('user_pay','user_pay.username','=','users.username')->where('users.username' , session()->get('otpusername'))->leftjoin('user_personal','user_personal.username','=','users.username')->where('user_pay.pay_status',1)->first();
    	
    	if($user){
			$request->session()->put('sessiontime', time());	
			if($user->otp == $request->otp){

				Auth::login($user, true);
				$otp = mt_rand(1000,9999);
				DB::table('user_personal')->where('username',$user->username)->update(array('otp'=>$otp));
				session()->forget('otpusername');
				$redirect=session()->get('redirectTo');
			    if($redirect!='' || $redirect!=null){
			        if($redirect=='dashboard'){
			            $redirect='employee-dashboard';
			        }
			        return redirect()->route($redirect);
			    }
			    else{
				    return redirect()->route('employee-dashboard');
			    }
			}
			else{
				return redirect()->back()->with('message','Invalid OTP!!');
			}

		}

	}



    function logout(){
	   Auth::logout();
	   return redirect(\URL::previous());
       //return redirect()->route('login');
    }

	public function changePassword(Request $request)
	{
		$this->validate($request,[
    		"current_password"=>"required",
    		"new_password"=>"required",
    		"confirm_password"=>"required",
		]);
		
				
		$user_id = Auth::id();
        $user = User::findOrFail($user_id);
		$data = $request->all();

		if(Hash::check($data['current_password'], $user['v4_password']))
		{
		if($data['new_password']==$data['confirm_password'])
		{
				 User::where(['id'=>$user['id']])->update(['v4_password'=>bcrypt($data['new_password'])]);
			
		
		return redirect()->back()->with('flash_message_success','Password Changed Successfully!');
		}
		else{
		return redirect()->back()->with('flash_message_error','Password not Match!');
		
		}
		}else{
		//return response()->json(['status' => 'false', 'message' => 'Old Password Wrong!', 'response' => 400]);
		return redirect()->back()->with('flash_message_error','Old Password Wrong!');
		
		}
		
	}

	public function uploadProfile(Request $request)
	{
		$file = $request->file('profile_photo');

		$user_id = Auth::id();
        $user = User::findOrFail($user_id);

		$employee = UserPersonal::where('username', $user->username)->first();

		if($request->has('profile_photo') && !empty($file))
		{
		
			if(isset($employee->profile_photo_file))
			{
			  Storage::delete('public/profile/'.$employee->profile_photo_file);
			}
			$file = $request->file('profile_photo');
			$extension = $file->getClientOriginalExtension();
			$endFileName = $employee->username . rand(111,999). '.' . $extension;
			$filePath = 'public/profile/';
		
			$user->personal()->update([
				'profile_photo_file' => $endFileName

				]);
			try {

				Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
				
			} catch (\Exception $e) {

			}
		}

		return redirect('e-leave/update-personal-information?update=profile')->with('flash_message_success','Profile Updated Successfully!');
		
	}

	public function savePersonalInfo(Request $request)
	{
		$user_id = Auth::id();
		$user = User::findOrFail($user_id);
		if (isset($_POST['personal_info']))
    {
		$user->personal()->update([
			'employee_no' => $request->employee_number,
			'employee_code' => $request->employee_code,
			'employee_type' => $request->employee_type,
			'designation' => $request->designation,
			'name' => $request->emaployee_name,
    		'address' => $request->address,
			'postal_code' => $request->post_code,
			'town' => $request->town,
			'nationality' => $request->nationality,
			'state' => $request->state,
			'phone_no' => $request->phone_no,
			'dob' => $request->dob,
			'highest_education' => $request->education,
			'working_experience' => $request->experience,
			'ic_no_old' => $request->icno_old,
			'ic_no_new' => $request->icno_new,
			'ic_color' => $request->ic_color,
    		'passport_no' => $request->passport_no,
			'marital_status' => $request->marital_status,
			'email_id' => $request->email_id,
			'blood_group' => $request->blood_group ?? '',
			'sex' => $request->sex,
			'race' => $request->race,
			'bumiputra' => $request->bumiputra,
		]);

		$user->userPay()->update([
			'branch_id' => $request->branch,
			'department_id' => $request->department,
		]);
		}
		if (isset($_POST['spouse']))
    {
		$user->spouse()->update([
			'spouse_name'  => $request->spouse_name,
			'spouse_ic_no' => $request->spic_no,
			'no_children' => $request->childern,
			'spouse_working' => $request->spouse_working
		]);
		}
		if (isset($_POST['address_contact']))
    {
		$user->address()->update([
			'name'  => $request->ad_name,
			'address'  => $request->p_address,
			'phone_no'  => $request->pphno
		]);
	}
		//return 1;
		return \Redirect::route('personal-information');
	}

	public function sendforgotpasswordmail(Request $request){
		$user = User::leftjoin('user_personal','users.username','=','user_personal.username')->where('users.username',$request->username)->first();
		
					// dd(Auth::id());
		if(!empty($user)){
			if($user->email_id!=''){
				if(ValidateEmail($user->email_id)){
					$token_id =   Str::random(32);
					
					$username=$user->username;
					if($this->checktoken($token_id)){
						DB::table('users')->where('id',$user->id)->update(array('token'=>$token_id));
						$subject ="Change Password";
						$body = "";
						$body .= "Click on a Below Link to Reset Your Password :<br> ".URL::to('/e-leave/changepassword?updatepassword='.$token_id)."<br/><br />";
						
						$body .= "Note, this is an automatic email. Please do not reply. <br />";
						$body .= "If you did not request this information, please ignore this message. <br />";
						$body .= "If you have any questions, please contact us<br />";
						//dd($body);
						sendemail($user->email_id,$subject,$body,$user->username);
						return redirect()->back()->with('successmessage','Please Check your Email !');
					}
					else{
						$this->sendforgotpasswordmail(request());
					}
				}
			}
		}
		else{
			return redirect()->back()->with('message','User not found!');
		}

	}
	public function checktoken($token){
		$user = User::where('token',$token)->first();
		if(!empty($user))
			return false;
		return true;
	}
	
	public function change_password(Request $request)
	{
		
					
		$user = User::where('token',$_GET['updatepassword'])->first();
		//dd($user);
		if(!empty($user)){
			$username=$user->username;
			$id=$user->id;
			
			
			return view('E-Leave.change-password', compact('id','username'));
		}else{
			return redirect('e-leave/forgot-password')->with('message','Invalid Link! Please try again ');
		}
	}
	public function updatePassword(Request $request)
	{
		$this->validate($request,[
    		"new_password"=>"required",
    		"confirm_password"=>"required",
		]);
		
				
		$data = $request->all();
		$user = User::where('username',$request->username)->where('id',$request->id)->first();
		
		if(!empty($user)){
			if($data['new_password']==$data['confirm_password'])
			{
				$token_id =   Str::random(32);
			
					DB::table('users')->where('id',$user->id)->update(array('token'=>$token_id));
					$otp = mt_rand(1000,9999);
					DB::table('user_personal')->where('username',$user->username)->update(array('otp'=>$otp));
					User::where(['id'=>$user->id])->update(['v4_password'=>bcrypt($data['new_password'])]);
				
					return redirect('/login')->with('successmessage','Password Changed Successfully!');
			
			}
			else{
			
				return redirect()->back()->with('message','Password not Match!');
			}
		}else{
			return redirect('e-leave/forgot-password')->with('message','Invalid Link! Please try again ');
		}
		
		
	}
}
