<?php

namespace App\Http\Controllers;

use App\Http\Controllers\HrController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Response;
use App\Models\{
    User,
    Leavetype,
    Relieve,
    Leavelist,
    LeaveDay,
    Branch,
    Department,
    Category,
    LeaveEntitleHistory,
    UserPay,
    UserPersonal,
    PublicHoliday,
    MapEmployeeApprover,
    LeaveAudit
};
use Auth,
    DateTime,
    Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use App\Mail\MyDemoMail;
use Mail;
use Illuminate\Support\Facades\Log;

//use Yajra\DataTables\Services\DataTables;



class MyLeaveController extends Controller {

    protected $storageDriver;

    public function __construct() {
        $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }

    public function index(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $leaveTypes = Leavetype::where('is_show', 1)->get();
        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $leaveArray = Leavelist::orderBy('date_applied', 'DESC')->where('username', $user->username);
        $type = $request->get('type');
        $from = $request->get('from');
        $to = $request->get('to');
        if ($type && $type != '') {
            $leaveArray->where('type', $type);
        }

        if ($from && $from != '') {
            $leaveArray->where('start_date', '>=', $from);
        }

        if ($to && $to != '') {
            $leaveArray->where('end_date', '<=', $to);
        }

        $leaves = $leaveArray->paginate(10);


        $history = LeaveEntitleHistory::where('username', $user->username)->where('year', carbon()->year)->get();
        $history->transform(function($item) {
            if ($item->leave_type == 'Annual') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Medical') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Marriage') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Compassionate') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Hospital') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Maternity') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'Examination') {
                $item->class = 'progress-bar-dark';
            }

            if ($item->leave_type == 'Paternity') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Advance') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Other_pay') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Line_Shut') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Absent') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Emergency') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'NPL') {
                $item->class = 'progress-bar-dark';
            }
            return $item;
        });
        // dd($history);
        return view('E-Leave/my-leaves', compact('leaveTypes', 'relieves', 'leaves', 'history'));
    }

    public function erequestforrl() {
        $user = User::where('id', Auth::id())->first();
        $upaydetails = UserPersonal::where('username', $user->username)->first();
        if ($upaydetails->sex == 1) {
            $leaveTypes = Leavetype::where('type', '!=', 'Maternity')->where('company_id', $user->company_id)->where('is_show', 1)->get();
        } else {
            $leaveTypes = Leavetype::where('is_show', 1)->get();
        }
        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $employees = MapEmployeeApprover::where('approver_id', $user->username)->leftjoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->selectRaw("map_employee_approver.employee_id, user_personal.name ")->groupBy('map_employee_approver.employee_id')->orderby('user_personal.name', 'asc')->get();

        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        $holidays = PublicHoliday::where('company_id', $user->company_id)->where('date', '>=', $startOfYear->format('Y-m-d'))->where('date', '<=', $endOfYear->format('Y-m-d'))->get();
        $leavesArray = LeaveDay::selectRaw("leave_list.*, map_employee_approver.*, leave_name.name as typename,leave_name.leave_color, CONCAT(leave_list.username, leave_list.start_date) as usergroup, leave_list.start_time, leave_list.end_time")->leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->leftjoin('map_employee_approver', 'map_employee_approver.employee_id', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('leave_days.username', $user->username)->groupBy('usergroup')->orderBy('leave_list.date_applied', 'DESC')->where('leave_days.status', '1')->get();

        // dd($leavesArray);

        $leavesArray->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = '#000000';
            } else {
                $iname = $item->type;
                $colornm = $item->background_color;
            }
            $employee = DB::table('user_personal')
                            ->where('username', $item->username)->first();
            $r_name = $employee->name;
            if($item->is_hourly!=0){ 
                
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
            return [
                'title' => $r_name . '(  ' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'text_color' => '#fff',
                'color' => $colornm,
            ];
        })->toArray();

// 		$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();

        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereYear('date', '=', date('Y'))->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function($item11) {

            return [
                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();
        $leaves11 = $restDay->merge($leavesArray);
        $leaves = $leaves11->merge($recentHoliday);
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        return view('E-Leave.request-for-rl', compact('leaveTypes', 'relieves', 'employees', 'holidays', 'leaves', 'relieveallow', 'halfdayallow'));
    }

    public function getRL_Approvers() {
        $user = User::where('id', Auth::id())->first();
        $Apply_rl_to_hr11 = DB::table('settings')->where('field', 'apply_rl_to_hr')->where('company_id', $user->company_id)->first();
        $Apply_rl_to_hr = $Apply_rl_to_hr11->value ?? 0;

        if ($Apply_rl_to_hr == 1) {
            $result = $this->getRL_Leave_Approver();
            return $result;
        } else {
            $result = $this->getMyApprovers();
            return $result;
        }
    }

    public function getMyApprovers() {
        $user = User::where('id', Auth::id())->first();
        $username = $user->username;
        $result = $this->getApproversByUser($username);
        return $result;
    }

    public function getApproversByUser($username) {

        $result = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.approver_id', '=', 'b.username')->where('a.employee_id', $username)->selectRaw("distinct b.name, b.employee_no, b.username")->get();
        return $result;
    }

    public function getRL_Leave_Approver() {

        // 		$result = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg','mep.permission_group_id','=','pg.id')->leftjoin('user_personal as up','mep.employee_id','=','up.username')->where('pg.apply_rl',1)->where('up.isDeleted',0)->selectRaw("mep.employee_id,up.name,up.username")->get();
        $apply_rl = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg', 'mep.permission_group_id', '=', 'pg.id')->where('mep.employee_id', Auth::user()->username)->first();
        $apply_rl = $apply_rl->apply_rl ?? 0;

        $result = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg', 'mep.permission_group_id', '=', 'pg.id')->leftjoin('user_personal as up', 'mep.employee_id', '=', 'up.username')->where('pg.apply_rl', $apply_rl)->where('up.isDeleted', 0)->selectRaw("mep.employee_id,up.name,up.username")->get();
        return $result;
    }

    public function addRLeave(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $employeeId = (isset($request->employee_id) ? $request->employee_id : $user->username);
        $approver = $request->approver;
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $noDays = $request->no_days;
        $noGranted = $request->no_granted;
        $reason = $request->reason;

        /* if($noGranted==1){
          $count_to_run_query = 2;
          }else{
          $count_to_run_query = 1;
          } */

        if ($this->RLeaveAddAllow($employeeId, $startDate, $noGranted)) {

            $result = $this->addRLeave11($employeeId, $approver, $startDate, $endDate, $noDays, $noGranted, $reason);

            // Email Start
            $udetail = DB::table('user_personal')->where('username', $user->username)->first();
            $name = $udetail->name;
            $emp_id = $udetail->username;
            $referer = str_replace('request-for-rl', 'approval-dashboard', url()->current());
            $referer = str_replace('addRLeave', 'approval-dashboard', url()->current());

            $startDate = date('d F Y', strtotime($request->start_date));
            $endDate = date('d F Y', strtotime($request->end_date));

            $subject = "Employee " . $name . " applied for Replacement leave";

            $uadt = DB::table('user_personal')->where('username', $approver)->first();
            $approver_name = $uadt->name;
            $body = "Dear $approver_name<br><br>";
            $body .= "$name applied Replacement Leave from $startDate to $endDate<br/><br/><br/>";
            $body .= "Link: <a href='$referer'>$referer</a>";

            $email_send_allow = true;
            $getEmailSendByPrefernces1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->where('company_id', $user->company_id)->first();
            $getEmailSendByPrefernces = $getEmailSendByPrefernces1->value ?? 0;
            if ($getEmailSendByPrefernces) {
                if (!hasContentPreference($employeeId)) {
                    $email_send_allow = true;
                } else {
                    $email_send_allow = false;
                }
            }

            if ($email_send_allow) {
                $semail = UserPersonal::where('username', $approver)->first();
                if ($semail->email_id != '')
                // Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                    sendemail($semail->email_id, $subject, $body);
            }
            // Email End

            return array("result" => $result);
        } else {
            return array("result" => false, "msg" => "Already applied for selected days");
        }
    }

    public function RLeaveAddAllow($employeeId, $startDate, $noGranted) {
        $currentCount = $this->getRLeaveGetCount($employeeId, $startDate);
        //echo $currentCount;exit;
        if (($currentCount + $noGranted) > 1) {
            return false;
        } else {
            return true;
        }
    }

    public function addRLeave11($employeeId, $approver, $startDate, $endDate, $noDays, $noGranted, $reason) {
        DB::table('rl_leaves')->insert(array('employee_id' => $employeeId, 'approver_id' => $approver, 'start_date' => $startDate, 'end_date' => $endDate, 'no_days' => $noDays, 'no_granted' => $noGranted, 'reason' => $reason));
        return true;
    }

    public function getRLeaveGetCount($employeeId, $startDate) {

        $rl_result = DB::table('rl_leaves')->where('employee_id', $employeeId)->where('start_date', $startDate)->sum('no_granted');


        $la_result = DB::table('leave_adjustment')->where('employee_id', $employeeId)->where('start_date', $startDate)->sum('no_granted');

        $result = $rl_result + $la_result;
        return $result;
    }

    public function getuser(Request $request) {

        $user = User::where('id', Auth::id())->first();
        $permission_val = DB::table('map_employee_permission')->leftjoin('permission_group', 'map_employee_permission.permission_group_id', '=', 'permission_group.id')->selectRaw("permission_group.global_search")->where('map_employee_permission.employee_id', $user->username)->first();
        if ($permission_val == '1' || $permission_val == '2') {
            $users = DB::table('map_employee_approver')->leftjoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->selectRaw("distinct user_personal.username, user_personal.name")->where('map_employee_approver.approver_id', $user->username)->whereRaw('(user_personal.username like ("' . $request->username . '%") OR user_personal.name like ("' . $request->username . '%"))')->get();
        } else {
            $users = UserPersonal::leftjoin('user_pay', 'user_pay.username', '=',
                            'user_personal.username')->selectRaw('user_personal.username, name')->whereRaw('(user_personal.employee_no like ("' . $request->username . '%") OR user_personal.name like ("' . $request->username . '%"))')->where('isDeleted', '0')->get();
        }
        return $users;
    }

    public function getglobaluser(Request $request) {

        $user = User::where('id', Auth::id())->first();
        $permission_val = DB::table('map_employee_permission')->leftjoin('permission_group', 'map_employee_permission.permission_group_id', '=', 'permission_group.id')->selectRaw("permission_group.global_search")->where('map_employee_permission.employee_id', $user->username)->first();
        if ($permission_val == '1' || $permission_val == '2') {
            $users = DB::table('map_employee_approver')->leftjoin('user_personal', 'map_employee_approver.employee_id', '=', 'user_personal.username')->leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->selectRaw("distinct user_personal.username, user_personal.name")->where('map_employee_approver.approver_id', $user->username)->whereRaw('(user_personal.username like ("' . $request->username . '%") or user_personal.name like ("' . $request->username . '%"))');

            if (hasGlobalSearchAccess11() == 1) {
                $users->where('user_personal.username', $user->username);
            } elseif (hasGlobalSearchAccess11() == 2) {
                $logged_userGroups = getUserGroups($user->username);
                $users->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
            }
            $users = $users->get();
        } else {
            $users = UserPersonal::leftjoin('user_pay', 'user_pay.username', '=',
                            'user_personal.username')->whereRaw('(`user_personal`.`name` like ("' . $request->username . '%") or `user_personal`.`employee_no` like ("' . $request->username . '%"))');
            //dd(hasGlobalSearchAccess11());
            if (hasGlobalSearchAccess11() == 1) {
                $users->where('user_personal.username', $user->username);
            } elseif (hasGlobalSearchAccess11() == 2) {
                $logged_userGroups = getUserGroups($user->username);
                $users->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
            }

            $users = $users->selectRaw('user_personal.username, name')->where('isDeleted', '0')->get();
        }
        return $users;
    }

    public function globalSearch(Request $request) {
        $hours = gethours();
        $user = UserPersonal::whereRaw('name="' . $request->get('username') . '" or username="' . $request->get('username') . '" or employee_no="' . $request->get('username') . '"')->first();
        if (empty($user)) {
            return view('E-Leave.not-found');
        }
        $personal = UserPersonal::leftJoin('rest_day_category_employee', 'user_personal.username', '=', 'rest_day_category_employee.employee_id')->leftJoin('rest_day_category', 'rest_day_category_employee.category_id', '=', 'rest_day_category.id')->select('user_personal.*', 'rest_day_category_employee.*', 'rest_day_category.category as rcategory')->where('user_personal.username', $user->username)->first();
        $pay = UserPay::leftJoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftJoin('department', 'user_pay.department_id', '=', 'department.id')->leftJoin('category', 'user_pay.category_id', '=', 'category.id')->leftJoin('user_category', 'user_pay.username', '=', 'user_category.username')->leftjoin("category_name", "category_name.id", "=", "user_category.category")->select('user_pay.*', 'branch.name as bname', 'department.name as dname', 'category.name as cname', 'category_name.name as ecategory')->where('user_pay.username', $user->username)->first();
        $permission = DB::table('map_employee_permission')->leftjoin('permission_group', 'map_employee_permission.permission_group_id', '=', 'permission_group.id')->where('map_employee_permission.employee_id', $user->username)->first();
        $cl1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Compassionate')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();

        $cl = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Compassionate')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();

        $cl = $cl1->total ?? 0 + $cl->total ?? 0;

        $hl1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Hospital')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $hl = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Hospital')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $hl = $hl->total ?? 0 + $hl1->total ?? 0;

        $ml1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Maternity')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();

        $ml = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Maternity')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ml = $ml->total ?? 0 + $ml1->total ?? 0;

        $mr1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Marriage')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $mr = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Marriage')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $mr = $mr->total ?? 0 + $mr1->total ?? 0;

        $ex1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Examination')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $ex = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Examination')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ex = $ex->total ?? 0 + $ex1->total ?? 0;

        $pt1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Paternity')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $pt = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Paternity')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $pt = $pt->total ?? 0 + $pt1->total ?? 0;

        $ad1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Advance')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $ad = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Advance')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ad = $ad->total ?? 0 + $ad1->total ?? 0;

        $ls1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Line_Shut')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $ls = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Line_Shut')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ls = $ls->total ?? 0 + $ls1->total ?? 0;

        $ab1 = DB::table('leave_past')->where('leave_past.status', '1')->where('leave_past.type', 'Absent')->where('leave_past.username', $user->username)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600)/'$hours') WHEN 0 THEN total_leave_days END) as total")->first();
        $ab = LeaveDay::leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->where('leave_days.status', '1')->where('leave_list.type', 'Absent')->where('leave_days.username', $user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600)/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ab = $ab->total ?? 0 + $ab1->total ?? 0;

        $getSupervisors11 = DB::table('map_employee_approver')->leftjoin('user_personal', 'map_employee_approver.approver_id', '=', 'user_personal.username')->leftjoin('user_pay', 'map_employee_approver.approver_id', '=', 'user_pay.username')->leftjoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftjoin('map_employee_permission', 'map_employee_approver.approver_id', '=', 'map_employee_permission.employee_id')->leftjoin('permission_group', 'map_employee_permission.permission_group_id', '=', 'permission_group.id')->leftjoin('category', 'user_pay.category_id', '=', 'category.id')->leftjoin('department', 'user_pay.department_id', '=', 'department.id')
                ->selectRaw("map_employee_approver.approver_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, permission_group.group_name as Role, user_personal.state")
                ->where('map_employee_approver.employee_id', $user->username);
        $getSupervisors12 = DB::table('map_employee_manager')->leftjoin('user_personal', 'map_employee_manager.manager_id', '=', 'user_personal.username')->leftjoin('user_pay', 'map_employee_manager.manager_id', '=', 'user_pay.username')->leftjoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftjoin('category', 'user_pay.category_id', '=', 'category.id')->leftjoin('department', 'user_pay.department_id', '=', 'department.id')
                ->selectRaw("map_employee_manager.manager_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, '' as Role, user_personal.state")
                ->where('map_employee_manager.employee_id', $user->username)
                ->union($getSupervisors11);
        $build_query = str_replace(['?'], ['\'%s\''], $getSupervisors12->toSql());
        $bindings = $getSupervisors12->getBindings();
        $query = vsprintf($build_query, $bindings);
        $getSupervisors = DB::select("SELECT * FROM (" . $query . ") x GROUP BY approver_id");

        $only_current_year_leave_display = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', Auth::user()->company_id)->first();

        $leaveinformation11 = DB::table('leave_past')
                ->selectRaw("CASE is_hourly WHEN 1 THEN ((end_time-start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,is_hourly, 0,'' as lid, type, '-' as date_applied, start_date as start_date, end_date as end_date, total_leave_days as no_days,  1 as status, 'Past Leave' as reason,'' as filename, CASE total_leave_days WHEN 0.5 THEN ( CASE half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_type', '' as cancellation_reason,'' as r_name ")
                ->where('username', $user->username);
        if (($only_current_year_leave_display->value ?? 0) == 1) {

            $leaveinformation11->whereYear('leave_past.start_date', '=', date('Y'));
        }
        //dd($only_current_year_leave_display);
        $leaveinformation = DB::table('leave_days')->leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->leftjoin('user_personal', 'leave_list.relieve', '=', 'user_personal.username')
                ->selectRaw("CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly, leave_days.id,  leave_list.id as lid,leave_list.type, leave_list.date_applied as date_applied, leave_days.date as start_date, leave_days.date as end_date, CASE leave_list.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status, leave_list.reason,leave_list.filename, CASE leave_list.is_half_day WHEN 1 THEN ( CASE leave_list.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, user_personal.name as r_name  ");
        if (($only_current_year_leave_display->value ?? 0) == 1) {

            $leaveinformation->whereYear('leave_days.date', '=', date('Y'));
        }
        $leaveinformation = $leaveinformation->where('leave_days.username', $user->username)->union($leaveinformation11)->get();
        //dd($leaveinformation);

        $year = carbon()->year;
        // }
        if (getSettingsValue('leave_adjustment_type') == 8) {

            $joiningDate = getJoinDateStr($user->username);
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            // if ((isset($_POST["pdf"]))) {
            // } else {
            if (date('Y-m-d') < $curr_date) {
                $year = $year - 1;
            }
            // }
        }


        $approver = DB::table('map_employee_approver')->where('employee_id', $user->username)->orderBy('approver_index', 'asc')->get();
        if (!$approver->isEmpty()) {
            $approvername = UserPersonal::where('username', $approver[0]->approver_id)->get();
        } else {
            $approvername = '';
        }
        //echo'<pre>';
        //print_r($user->username);
        //die();
        $userPay = UserPay::where('username', $user->username)->first();
        $leaveTypes = Leavetype::where('is_show', 1)->get();
        $leaveArray = Leavelist::orderBy('date_applied', 'DESC')->where('username', $user->username);
        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $type = $request->get('type');
        $year11 = $request->get('year');
        $from = $request->get('from');
        $to = $request->get('to');
        $status = $request->get('status');
        if ($year != null) {

            $yr = $year;
        } else {
            $yr = date('Y');
        }
        if ($year11 != '') {
            $leaveArray->whereYear('start_date', '=', $year11);
        } else {
            $leaveArray->whereYear('start_date', '=', $yr);
        }

        if ($type && $type != '') {

            $leaveArray->where('type', $type);
        }

        if ($from != '' && $to != '') {
            $leaveArray->whereBetween('start_date', [$from, $to]);
        } elseif ($from != '') {

            $leaveArray->where('start_date', '=', $from);
        } elseif ($to != '') {
            $leaveArray->where('start_date', '=', $to);
        }

        if (isset($status) && $status != '') {

            $leaveArray->where('status', $status);
        }

        $leaves = $leaveArray->get();
        if ($request->get('get') && $request->get('get') == 'all') {
            $leaves = $leaves;
            //return DataTables::of($leaves)->make(true);
        } else {
            $leaves = $leaves;
        }

        // dd($leaves);


        $replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->get();
        $history = LeaveEntitleHistory::where('username', $user->username)->where('year', carbon()->year)->get();
        $history->transform(function($item) {
            if ($item->leave_type == 'Annual') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Medical') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Marriage') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Compassionate') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Hospital') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Maternity') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'Examination') {
                $item->class = 'progress-bar-dark';
            }

            if ($item->leave_type == 'Paternity') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Advance') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Other_pay') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Line_Shut') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Absent') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Emergency') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'NPL') {
                $item->class = 'progress-bar-dark';
            }
            return $item;
        });
        $today = \Carbon\Carbon::now();

        $alHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Annual')->first();
        $medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Medical')->first();
        $repHistory = DB::table('leave_list')->where('username', $user->username)
                        ->where('type', 'Other_pay')->where('status', 1)->count();
        $totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');

        $cut_off_days = day_count_anniv_cutt_off($user->username, carbon()->year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Other_pay'); //rithik
        $mBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Medical');
        $rBFAdj = getAdjustmentLeaveCount($user->username, carbon()->year, 1);
        $mbf = getBroughtForwardLeaveNotAdjusted($user->username, carbon()->year, 'Medical');
        $rbf = 0;
        $albf = 0;
        $aEntitle = getEntitleLeave($user->username, carbon()->year, 'Annual');
        $mEntitle = getEntitleLeave($user->username, carbon()->year, 'Medical');
        $rEntitle = '-';
        $aEarn = (date('n') / 12) * $aEntitle;
        $mEarn = '-';
        $rEarn = getTotalReplaceLeave($user->username, carbon()->year);
        $aClaim = getAnnualClaimable($user->username, carbon()->year, 'Annual');
        $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
        $rlClaim = "-";
        $anunpl = getNPLSummary($user->username, carbon()->year);
        $mcnpl = 0;
        $rpnpl = '-';
        $elTaken = getTakenLeves($user->username, carbon()->year, 'Emergency');
        $alTaken = getTakenLeves($user->username, carbon()->year, 'Annual');
        $mcTaken = getTakenLeves($user->username, carbon()->year, 'Medical');
        $rlTaken = getTakenLeves($user->username, carbon()->year, 'Other_pay');
        $forAlBf = $albf;
        $forAlBfAdj = $aBFAdj;
        $forMC = $mbf;
        $forRL = $rbf;
        $alBalance = $aEntitle - $alTaken;
        $mcBalance = $mEntitle - $mcTaken;
        $rlBalance = $rEarn - $rlTaken;


        //* myleave curl for summary
        $username = $user->username;
        // $year = "";
        // $myLeaveSumm = json_decode(myLeaveSummary($username,$year),true);
        // $myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
        // $myLeaveSummSm = $myLeaveSummSm['users'][0];
        //dd($year);
        //$myLeaveSumm = getYearlyEntitle($username, $year);
        
        
// 		$myLeaveSummSm = getYearlyrlEntitleList($username, $year);
        $url = \Request::url();
        $name = urlencode($user->employee_no);
        $ln = 1;
        $aid = Auth::id();
        
        $url11 = str_replace("e-leave/search","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $myLeaveSumm = json_decode($response);
         if (!empty($myLeaveSumm)) {
            $myLeaveSumm = $myLeaveSumm[0];
        } else {
            $myLeaveSumm = '';
        }
        
        $url12 = str_replace("e-leave/search","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }


        
        $url = str_replace("e-leave/search", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());

        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $myLeaveSummSm = json_decode($response);

        //dd($myLeaveSummSm);
        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }


        $dataArray = [
            'albf' => $albf, 'forAlBf' => $forAlBf,
            'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
            'rbf' => $rbf, 'forMC' => $forMC,
            'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
            'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
            'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
            'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
            'mEntitle' => $mEntitle,
            'rEntitle' => $rEntitle,
            'aEarn' => $aEarn,
            'mEarn' => $mEarn,
            'rEarn' => $rEarn,
            'aClaim' => $aClaim,
            'mClaim' => $mClaim,
            'rlClaim' => $rlClaim,
            'anunpl' => $anunpl,
            'mcnpl' => $mcnpl,
            'rpnpl' => $rpnpl,
            'elTaken' => $elTaken,
            'alTaken' => $alTaken,
            'mcTaken' => $mcTaken,
            'rlTaken' => $rlTaken,
        ];

        if (isset($_GET['isJson'])) {
            // $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username)->selectRaw('*');
            $leaves = DB::table('leave_list')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->select('leave_list.*', 'leave_days.leave_id', 'leave_days.date', 'leave_days.cancellation_reason', 'leave_days.reject_reason')->whereRaw('(leave_list.username = "' . $user->username . '")')->orderBy('leave_list.date_applied', 'desc');

            if ($_GET['year']) {
                $leaves = $leaves->whereYear('leave_days.date', '=', $_GET['year']);
            }
            if ($_GET['type']) {
                $leaves = $leaves->where('leave_list.type', $_GET['type']);
            }
            if ($_GET['startdate'] && $_GET['enddate']) {
                $leaves = $leaves->whereBetween('leave_days.date', [$_GET['startdate'], $_GET['enddate']]);
            } elseif ($_GET['startdate'] != '') {

                $leaves = $leaves->where('leave_days.date', $_GET['startdate']);
            } elseif ($_GET['enddate'] != '') {
                $leaves = $leaves->where('leave_days.date', $_GET['enddate']);
            }


            $leavelist = $leaves->get();
            $leavelist->map(function($item) {
                if ($item->type == 'Other_pay') {
                    $type = 'Replacement';
                } elseif ($item->type == 'Line_Shut') {
                    $type = 'Out Of Office';
                } else {
                    $type = $item->type;
                }
                if ($item->status == 0) {
                    $status = 'Pending';
                    $class = '#82868b';
                } elseif ($item->status == 1) {
                    $status = 'Approved';
                    $class = '#28c76f';
                } elseif ($item->status == 2) {
                    $status = 'Rejected';
                    $class = '#ea5455';
                } elseif ($item->status == 3) {
                    $status = 'Recommended';
                    $class = '#7367f0';
                } elseif ($item->status == 4) {
                    $status = 'Cancelled';
                    $class = '#00cfe8';
                } else {
                    $status = 'Cancellation Pending';
                    $class = '#ff9f43';
                }
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
                $item->back_color = $class;
                $item->leave_status = $status;
                $item->leave_type = $type;
                $item->half_day_type = $htype;
                return $item;
            });
            return DataTables::of($leavelist)->editColumn('leave_days.date', function ($leavelist) {
                        if (!empty($leavelist->date)) {

                            $str = $leavelist->date;
                            $date = DateTime::createFromFormat('Y-m-d', $str)->format('d-m-Y');
                            return $date;
                        } else {
                            return '--';
                        }
                    })->make(true);
        }
        return view('E-Leave.global-search', compact('leaves', 'userPay', 'leaveTypes', 'replacement', 'relieves', 'history',
                        'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray', 'myLeaveSumm', 'myLeaveSummSm', 'approver', 'approvername'
                        , 'personal', 'pay', 'permission', 'cl', 'hl', 'ml', 'mr', 'ex', 'pt', 'ad', 'ls', 'ab', 'getSupervisors', 'leaveinformation','medicalSumm'));
    }

    public function apply(Request $request) {
        $this->validate($request, [
            "leave_type" => "required",
            "hof" => "required",
            "leave_start_date" => "required|date",
            "leave_end_date" => "nullable|date",
            "reason" => "nullable"
        ]);

        $user = User::where('id', $request->user_id)->first();
        $leave_start_date = new DateTime($request->leave_start_date);
        $leave_end_date = new DateTime($request->leave_end_date);
        $file = $request->file('slip_file');
        $endFileName = '';
        if (!empty($request->leave_end_date)) {

            $no_days = $leave_start_date->diff($leave_end_date);
            $no_days = $no_days->format('%a');
        } else {
            $no_days = 0.5;
        }

        $history = LeaveEntitleHistory::where('username', $user->username)
                        ->where('year', carbon()->year)->where('leave_type', $request->leave_type)->first();

        if (isset($history)) {
            if ($history->entitle > $no_days + 1) {
                $history->leave_taken = (string) $history->leave_taken + (string) $no_days + 1;
                $history->save();
            }
        }
        if ($no_days == 0.5) {
            $ndays = 1;
        } else {
            $ndays = $no_days + 1;
        }
        $startdate = $request->leave_start_date;
        $startdate = strtotime($startdate);
        $startdate = strtotime("-1 day", $startdate);

        for ($ndayss = 1; $ndayss <= $ndays; $ndayss++) {

            $sdate = strtotime("+$ndayss day", $startdate);
            $sdate = date('Y-m-d', $sdate);
            $leaveexists = Leavelist::where('username', $user->username)->where('start_date', $sdate)->first();

            if (!$leaveexists) {
                if ($request->hof == 1) {
                    $half_day_type = $request->half_day_type;
                    $nodays = 0.5;
                } else {
                    $half_day_type = '';
                    $nodays = 1.0;
                }
                if (!empty($file)) {

                    $file = $request->file('slip_file');
                    $extension = $file->getClientOriginalExtension();
                    $endFileName = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
                    $filePath = 'public/upload/';

                    try {

                        Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
                    } catch (\Exception $e) {
                        
                    }
                }
                $leave = Leavelist::create([
                            "approver_id" => $request->approver_id,
                            "username" => $user->username,
                            "type" => $request->leave_type,
                            "is_half_day" => $request->hof,
                            "start_date" => $sdate,
                            "end_date" => $sdate,
                            "no_days" => $nodays,
                            "half_day_type" => $half_day_type,
                            "reason" => $request->reason,
                            "filename" => $endFileName,
                            "date_applied" => now(),
                            "relieve" => $request->relieve,
                ]);
                $leaveDay = LeaveDay::create([
                            'leave_id' => $leave->id,
                            'username' => $user->username,
                            'date' => $sdate,
                            'cancellation_reason' => '',
                            'reject_reason' => '',
                ]);
            }
        }
        return 1;
    }

    public function getSelfLeave() {
        $user = User::where('id', Auth::id())->first();
        // $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username)->whereYear('start_date', '=' , date('Y'))->get();
        $leaveinformation11 = DB::table('leave_past')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_past.type')
                ->selectRaw("CASE leave_past.is_hourly WHEN 1 THEN ( (leave_past.end_time-leave_past.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours ,leave_past.is_hourly,0, '' as leave_id, '' as lid, leave_past.start_date as date, DATE_FORMAT(leave_past.start_date, '%d-%m-%Y') as start_date1, '' as cancellation_reason, '' as reject_reason,leave_past.id, leave_past.username,'' as approver_id,leave_past.type,'' as is_half_day,leave_past.half_day_type,leave_past.start_time,leave_past.end_time,leave_past.start_date,leave_past.end_date,leave_past.total_leave_days as no_days,'Past Leave' as reason,leave_past.status,'' as date_applied,'' as date_approved,'' as leave_category,'' as filename,'' as relieve")
                ->where('leave_past.username', $user->username);
        $leavess = DB::table('leave_list')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->selectRaw("CASE leave_list.is_hourly WHEN 1 THEN ( abs(leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly,leave_days.id, leave_days.leave_id as leave_id,leave_days.id as lid, leave_days.date as date, DATE_FORMAT(leave_days.date, '%d-%m-%Y') as start_date1,leave_days.cancellation_reason,leave_days.reject_reason,leave_list.id, leave_list.username,leave_list.approver_id,leave_list.type,leave_list.is_half_day,leave_list.half_day_type,leave_list.start_time,leave_list.end_time,leave_list.start_date,leave_list.end_date,leave_list.no_days,leave_list.reason,leave_list.status,leave_list.date_applied,leave_list.date_approved,leave_list.leave_category,leave_list.filename,leave_list.relieve")->whereRaw('(leave_list.username = "' . $user->username . '")')->orderBy('leave_list.id', 'asc')->orderBy('leave_list.date_applied', 'desc');

        $leaves = $leavess->union($leaveinformation11)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 5 THEN 1 ELSE 2 END), start_date  DESC')->get();
        $leaves->map(function($item) {
            $user = User::where('id', Auth::id())->first();
            $pastLeaveCancel = DB::table('settings')->where('field', 'pastLeaveCancel')->where('company_id', $user->company_id)->first();
            $leavename = DB::table('leave_name')->where('type', $item->type)->first();

            $r_name = '';
            if ($item->relieve != '') {
                $employee = DB::table('user_personal')
                                ->where('username', $item->relieve)->first();
                $r_name = $employee->name;
            }
            if ($item->type == 'Other_pay') {
                $type = 'Replacement';
            } elseif ($item->type == 'Line_Shut') {
                $type = 'Out Of Office';
            } else {
                $type = $item->type;
            }
            if ($item->status == 0) {
                $status = 'Pending';
                $class = '#82868b';
            } elseif ($item->status == 1) {
                $status = 'Approved';
                $class = '#28c76f';
            } elseif ($item->status == 2) {
                $status = 'Rejected';
                $class = '#ea5455';
            } elseif ($item->status == 3) {
                $status = 'Recommended';
                $class = '#7367f0';
            } elseif ($item->status == 4) {
                $status = 'Cancelled';
                $class = '#00cfe8';
            } else {
                $status = 'Cancellation Pending';
                $class = '#ff9f43';
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            }elseif($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            $pval = '';
            if ($pastLeaveCancel->value ?? 0 == 1) {
                if ($item->start_date < date('Y-m-d')) {
                    $pval = 'disabled';
                } else {
                    $pval = '';
                }
            }
            if($item->is_hourly!=0){ 
            $item->start_time = date('h:i A',$item->start_time);
            $item->end_time = date('h:i A',$item->end_time);
            }
            $item->pval = $pval;
            $item->typename = $leavename->name ?? '';
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->leave_type = $type;
            $item->half_day_type = $htype;
            $item->r_name = $r_name;
            return $item;
        });
        return DataTables::of($leaves)->make(true);
    }

    public function getMyLeaves(Request $request, $year = null) {
        ini_set('max_execution_time', 300);
        // if($year == null){
        $year = carbon()->year;
        // }
        $user = User::where('id', Auth::id())->first();
        if (getSettingsValue('leave_adjustment_type') == 8) {
            $year = $year;
            $joiningDate = getJoinDateStr($user->username);
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            // if((isset($_POST["pdf"]))) {
            // } else {
            // if (date('Y-m-d') < $curr_date) {
            //     $year = $year - 1;
            // }
            // }
        }

        $user = User::where('id', Auth::id())->first();
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        $approver = DB::table('map_employee_approver')->where('employee_id', $user->username)->orderBy('approver_index', 'asc')->get();
        if (!$approver->isEmpty()) {
            $approvername = UserPersonal::where('username', $approver[0]->approver_id)->get();
        } else {
            $approvername = '';
        }
        //echo'<pre>';
        //print_r($user->username);
        //die();
        $userPay = UserPay::where('username', $user->username)->first();
        $upaydetails = UserPersonal::where('username', $user->username)->first();
        if ($upaydetails->sex == 1) {
            if ($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1) {
                $leaveTypes = Leavetype::where('type', '!=', 'Maternity')->where('type', '!=', 'Paternity')->where('is_show', 1);
            } else {
                $leaveTypes = Leavetype::where('type', '!=', 'Maternity')->where('is_show', 1);
            }
        } else {
            if ($upaydetails->marital_status != 'Married' && $upaydetails->marital_status != 1) {
                $leaveTypes = Leavetype::where('type', '!=', 'Maternity')->where('is_show', 1);
            } else {
                $leaveTypes = Leavetype::where('is_show', 1);
            }
        }
        if ($upaydetails->marital_status == 1) {
            $leaveTypes->where('type', '!=', 'Marriage');
        }
        if ($upaydetails->marital_status == 'Married') {
            $leaveTypes->where('type', '!=', 'Marriage');
        }
        $company_id = '';
        if (!empty($user->company_id)) {
            $company_id = $user->company_id;
        }

        $leaveTypes = $leaveTypes->get();
        $leaveArray = Leavelist::orderBy('date_applied', 'DESC')->where('username', $user->username);
        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $type = $request->get('type');
        $year11 = $request->get('year');
        $from = $request->get('from');
        $to = $request->get('to');
        $status = $request->get('status');
        if ($year != null) {

            $yr = $year;
        } else {
            $yr = date('Y');
        }
        if ($year11 != '') {

            $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
            $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value ?? 0;
            $CutOffMonth = getSettingsValue('cut_of_month');
            $CutOffDate = getSettingsValue('cut_of_date');
            $CutOffStartMonth = getSettingsValue('cut_of_startmonth');
            $CutOffStartDate = getSettingsValue('cut_of_startdate');
            if ($SettingLeaveAdjustmentType == 8) {

                if ($CutOffStartMonth == 1) {
                    $st_date = $year11 . "-" . $CutOffStartMonth . "-" . $CutOffStartDate;
                } else {
                    $st_date = ($year11 - 1) . "-" . $CutOffStartMonth . "-" . $CutOffStartDate;
                }
                $en_date = $year11 . "-" . $CutOffMonth . "-" . $CutOffDate;

                $leaveArray->whereBetween('start_date', [$st_date, $en_date]);
            } else {
                $leaveArray->whereYear('start_date', '=', $year11);
            }
        } else {

            $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
            $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value ?? 0;
            $CutOffMonth = getSettingsValue('cut_of_month');
            $CutOffDate = getSettingsValue('cut_of_date');
            $CutOffStartMonth = getSettingsValue('cut_of_startmonth');
            $CutOffStartDate = getSettingsValue('cut_of_startdate');
            if ($SettingLeaveAdjustmentType == 8) {
                if ($CutOffStartMonth == 1) {
                    $st_date = $yr . "-" . $CutOffStartMonth . "-" . $CutOffStartDate;
                } else {
                    $st_date = ($yr - 1) . "-" . $CutOffStartMonth . "-" . $CutOffStartDate;
                }
                $en_date = $yr . "-" . $CutOffMonth . "-" . $CutOffDate;
                $leaveArray->whereBetween('start_date', [$st_date, $en_date]);
            } else {
                $leaveArray->whereYear('start_date', '=', $yr);
            }
        }

        if ($type && $type != '') {

            $leaveArray->where('type', $type);
        }
        if ($from != '' && $to != '') {
            $leaveArray->whereBetween('start_date', [$from, $to]);
        } elseif ($from != '') {
            $leaveArray->where('start_date', '=', $from);
        } elseif ($to != '') {
            $leaveArray->where('start_date', '=', $to);
        }

        if (isset($status) && $status != '') {
            //  dd($status);
            $leaveArray->where('status', $status);
        }

        $leaves = $leaveArray->selectRaw("leave_list.*, CONCAT(username, status, start_date) as usergroup")->groupBy('usergroup')->get();
        if ($request->get('get') && $request->get('get') == 'all') {
            $leaves = $leaves;
        } else {
            $leaves = $leaves;
        }

        $replacement = getSelfRepleasementLeave($user->username, $yr);

        $history = LeaveEntitleHistory::where('username', $user->username)->where('year', carbon()->year)->get();
        $history->transform(function($item) {
            if ($item->leave_type == 'Annual') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Medical') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Marriage') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Compassionate') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Hospital') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Maternity') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'Examination') {
                $item->class = 'progress-bar-dark';
            }

            if ($item->leave_type == 'Paternity') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Advance') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Other_pay') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Line_Shut') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Absent') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Emergency') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'NPL') {
                $item->class = 'progress-bar-dark';
            }
            return $item;
        });
        $today = \Carbon\Carbon::now();

        $alHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Annual')->first();
        $medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Medical')->first();
        $repHistory = DB::table('leave_list')->where('username', $user->username)
                        ->where('type', 'Other_pay')->where('status', 1)->count();
        $totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');
        $cut_off_days = day_count_anniv_cutt_off($user->username, carbon()->year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Other_pay'); //rithik
        $mBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Medical');
        $rBFAdj = getAdjustmentLeaveCount($user->username, carbon()->year, 1);
        $mbf = getBroughtForwardLeaveNotAdjusted($user->username, carbon()->year, 'Medical');
        $rbf = 0;
        $albf = 0;
        $aEntitle = getEntitleLeave($user->username, carbon()->year, 'Annual');
        $mEntitle = getEntitleLeave($user->username, carbon()->year, 'Medical');
        $rEntitle = '-';
        $aEarn = (date('n') / 12) * $aEntitle;
        $mEarn = '-';
        $rEarn = getTotalReplaceLeave($user->username, carbon()->year);
        $aClaim = getAnnualClaimable($user->username, carbon()->year, 'Annual');
        $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
        $rlClaim = "-";
        $anunpl = getNPLSummary($user->username, carbon()->year);
        $mcnpl = 0;
        $rpnpl = '-';
        $elTaken = getTakenLeves($user->username, carbon()->year, 'Emergency');
        $alTaken = getTakenLeves($user->username, carbon()->year, 'Annual');
        $mcTaken = getTakenLeves($user->username, carbon()->year, 'Medical');
        $rlTaken = getTakenLeves($user->username, carbon()->year, 'Other_pay');
        $forAlBf = $albf;
        $forAlBfAdj = $aBFAdj;
        $forMC = $mbf;
        $forRL = $rbf;
        $alBalance = $aEntitle - $alTaken;
        $mcBalance = $mEntitle - $mcTaken;
        $rlBalance = $rEarn - $rlTaken;


        //* myleave curl for summary
        $username = $user->username;
        // $year = "";
//         $myLeaveSumm = json_decode(myLeaveSummary($username,$year),true);
// 		$myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
// 		$myLeaveSummSm = $myLeaveSummSm['users'][0];
        //$myLeaveSumm = getYearlyEntitle($username, $year);
       // $myLeaveSummSm = getYearlyrlEntitleList($username, $year);
        $url = \Request::url();

        $uname = UserPersonal::whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
        $name = urlencode($uname->employee_no);

        $ln = 1;
        $aid = Auth::id();
        
         $url11 = str_replace("e-leave/self-leaves","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
      //dd($url11);
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $myLeaveSumm = json_decode($response);
         if (!empty($myLeaveSumm)) {
            $myLeaveSumm = $myLeaveSumm[0];
        } else {
            $myLeaveSumm = '';
        }
        
        $url12 = str_replace("e-leave/self-leaves","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }
        
        
        $url = str_replace("e-leave/self-leaves", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $myLeaveSummSm = json_decode($response);

        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }


        $dataArray = [
            'albf' => $albf, 'forAlBf' => $forAlBf,
            'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
            'rbf' => $rbf, 'forMC' => $forMC,
            'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
            'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
            'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
            'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
            'mEntitle' => $mEntitle,
            'rEntitle' => $rEntitle,
            'aEarn' => $aEarn,
            'mEarn' => $mEarn,
            'rEarn' => $rEarn,
            'aClaim' => $aClaim,
            'mClaim' => $mClaim,
            'rlClaim' => $rlClaim,
            'anunpl' => $anunpl,
            'mcnpl' => $mcnpl,
            'rpnpl' => $rpnpl,
            'elTaken' => $elTaken,
            'alTaken' => $alTaken,
            'mcTaken' => $mcTaken,
            'rlTaken' => $rlTaken,
        ];

        if (isset($_GET['isJson'])) {
            // $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username)->selectRaw('*');
            $SettingLeaveAdjustmentType = getSettingsValue('leave_adjustment_type');
            $CutOffMonth = getSettingsValue('cut_of_month');
            $CutOffDate = getSettingsValue('cut_of_date');
            $CutOffStartMonth = getSettingsValue('cut_of_startmonth');
            $CutOffStartDate = getSettingsValue('cut_of_startdate');
            $leaveinformation11 = DB::table('leave_past')
                    ->selectRaw("CASE leave_past.is_hourly WHEN 1 THEN ( (leave_past.end_time-leave_past.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours ,leave_past.is_hourly, 0,  '' as leave_id, '' as lid, leave_past.start_date as date, DATE_FORMAT(leave_past.start_date, '%d-%m-%Y') as start_date1, '' as cancellation_reason, '' as reject_reason,leave_past.id, leave_past.username,'' as approver_id,leave_past.type,'' as is_half_day,leave_past.half_day_type,leave_past.start_time,leave_past.end_time,leave_past.start_date,leave_past.end_date,leave_past.total_leave_days as no_days,'Past Leave' as reason,leave_past.status,'' as date_applied,'' as date_approved,'' as leave_category,'' as filename,'' as relieve, CONCAT(leave_past.username, leave_past.status, leave_past.start_date) as usergroup ")
                    ->where('leave_past.username', $user->username);

            if ($_GET['status']) {
                $leaveinformation11->where('leave_past.status', '=', $_GET['status']);
            }
            if ($_GET['year']) {
                if ($SettingLeaveAdjustmentType == 8) {
                    if ($CutOffStartMonth == 1) {
                        $startdate = $_GET['year'] . '-' . $CutOffStartMonth . '-' . $CutOffStartDate;
                    } else {
                        $startdate = ($_GET['year'] - 1) . '-' . $CutOffStartMonth . '-' . $CutOffStartDate;
                    }

                    $enddate = $_GET['year'] . '-' . $CutOffMonth . '-' . $CutOffDate;
                    $leaveinformation11->whereBetween('leave_past.start_date', [$startdate, $enddate]);
                } else {
                    $leaveinformation11->whereYear('leave_past.start_date', '=', $_GET['year']);
                }
            }
            if ($_GET['type']) {
                $leaveinformation11->where('leave_past.type', $_GET['type']);
            }
            if ($_GET['startdate'] && $_GET['enddate']) {
                $leaveinformation11->whereBetween('leave_past.start_date', [$_GET['startdate'], $_GET['enddate']]);
            } elseif ($_GET['startdate'] != '') {

                $leaveinformation11->where('leave_past.start_date', $_GET['startdate']);
            } elseif ($_GET['enddate'] != '') {
                $leaveinformation11->where('leave_past.start_date', $_GET['enddate']);
            }
            $leaves = DB::table('leave_list')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')
            ->selectRaw(" CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly, leave_days.id, leave_days.leave_id as leave_id,leave_days.id as lid, leave_days.date as date, DATE_FORMAT(leave_days.date, '%d-%m-%Y') as start_date1,leave_days.cancellation_reason,leave_days.reject_reason,leave_list.id, leave_list.username,leave_list.approver_id,leave_list.type,leave_list.is_half_day,leave_list.half_day_type,leave_list.start_time,leave_list.end_time,leave_list.start_date,leave_list.end_date,leave_list.no_days,leave_list.reason,leave_list.status,leave_list.date_applied,leave_list.date_approved,leave_list.leave_category,leave_list.filename,leave_list.relieve, CONCAT(leave_list.username, leave_list.status, leave_list.start_date) as usergroup")->groupBy('usergroup')->whereRaw('(leave_list.username = "' . $user->username . '")')->orderBy('leave_list.date_applied', 'desc');

            if ($_GET['year']) {
                if ($SettingLeaveAdjustmentType == 8) {
                    if ($CutOffStartMonth == 1) {
                        $startdate = $_GET['year'] . '-' . $CutOffStartMonth . '-' . $CutOffStartDate;
                    } else {
                        $startdate = ($_GET['year'] - 1) . '-' . $CutOffStartMonth . '-' . $CutOffStartDate;
                    }
                    $enddate = $_GET['year'] . '-' . $CutOffMonth . '-' . $CutOffDate;
                    $leaves->whereBetween('leave_days.date', [$startdate, $enddate]);
                } else {
                    $leaves->whereYear('leave_days.date', '=', $_GET['year']);
                }
            }
            if ($_GET['status']) {
                $leaves->where('leave_days.status', '=', $_GET['status']);
            }
            if ($_GET['type']) {
                $leaves->where('leave_list.type', $_GET['type']);
            }
            if ($_GET['startdate'] && $_GET['enddate']) {
                $leaves->whereBetween('leave_days.date', [$_GET['startdate'], $_GET['enddate']]);
            } elseif ($_GET['startdate'] != '') {

                $leaves->where('leave_days.date', $_GET['startdate']);
            } elseif ($_GET['enddate'] != '') {
                $leaves->where('leave_days.date', $_GET['enddate']);
            }


            $leavelist = $leaves->union($leaveinformation11)->orderByRaw('(CASE WHEN status = 0 THEN 0 WHEN status = 5 THEN 1 ELSE 2 END), date  DESC')->get();
            $leavelist->map(function($item) {
                $leavename = DB::table('leave_name')->where('type', $item->type)->first();
                $r_name = '';
                if ($item->relieve != '') {
                    $employee = DB::table('user_personal')
                                    ->where('username', $item->relieve)->first();
                    $r_name = $employee->name;
                }
                if ($item->type == 'Other_pay') {
                    $type = 'Replacement';
                } elseif ($item->type == 'Line_Shut') {
                    $type = 'Out Of Office';
                } else {
                    $type = $item->type;
                }
                if ($item->status == 0) {
                    $status = 'Pending';
                    $class = '#82868b';
                } elseif ($item->status == 1) {
                    $status = 'Approved';
                    $class = '#28c76f';
                } elseif ($item->status == 2) {
                    $status = 'Rejected';
                    $class = '#ea5455';
                } elseif ($item->status == 3) {
                    $status = 'Recommended';
                    $class = '#7367f0';
                } elseif ($item->status == 4) {
                    $status = 'Cancelled';
                    $class = '#00cfe8';
                } else {
                    $status = 'Cancellation Pending';
                    $class = '#ff9f43';
                }
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
                if($item->is_hourly!=0){ 
                $item->start_time = date('h:i A',$item->start_time);
                $item->end_time = date('h:i A',$item->end_time);
                }
                $item->typename = $leavename->name;
                $item->back_color = $class;
                $item->leave_status = $status;
                $item->leave_type = $type;
                $item->half_day_type = $htype;
                $item->r_name = $r_name;
                return $item;
            });
            return DataTables::of($leavelist)->editColumn('leave_days.date', function ($leavelist) {
                        if (!empty($leavelist->date)) {

                            $str = $leavelist->date;
                            $date = DateTime::createFromFormat('Y-m-d', $str)->format('d-m-Y');
                            return $date;
                        } else {
                            return '--';
                        }
                    })->make(true);


            // ->editColumn('status', function ($leavelist)
            // {
            //     if($leavelist->status == 0) {
            //     return 'Pending';
            //     }
            // })->editColumn('cancel', function ($leavelist)
            // {
            // })
            //* not optimized
            //     if( ($_GET['type']) && ($_GET['startdate']) && ($_GET['enddate'])  )
            //     {
            //         $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where([['username' , $user->username],['type',$_GET['type']]])->whereBetween('start_date',[$_GET['startdate'],$_GET['enddate']])->get();
            //         return DataTables::of($leaves)->editColumn('start_date', function ($leaves)
            //         {
            //             if(!empty($leaves->start_date))
            //             {
            //                 $str = $leaves->start_date ;
            //                 $date = DateTime::createFromFormat('Y-m-d', $str)->format('d-m-Y');
            //                 return $date;
            //             }
            //             else{
            //                  return '--';
            //             }
            //         })->editColumn('status', function ($leaves)
            //         {
            //         })->editColumn('cancel', function ($leaves)
            //         {
            //         })->make(true);
            //     }
            //     if($_GET['type'])
            //     {
            //      // dd($_GET['startdate'],$_GET['enddate']);
            //         $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where([['username' , $user->username],['type',$_GET['type']]])->get();
            //         return DataTables::of($leaves)->editColumn('start_date', function ($leaves)
            //         {
            //             if(!empty($leaves->start_date))
            //             {
            //                 $str = $leaves->start_date ;
            //                 $date = DateTime::createFromFormat('Y-m-d', $str)->format('d-m-Y');
            //                 return $date;
            //             }
            //             else{
            //                  return '--';
            //             }
            //         })->editColumn('status', function ($leaves)
            //         {
            //         })->editColumn('cancel', function ($leaves)
            //         {
            //         })->make(true);
            //     }
            // //  //   $_GET['startdate'] !='' &&  $_GET['enddate'] !=''
            //     if( ($_GET['startdate']) && ($_GET['enddate']))
            //     {
            //         $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username)->whereBetween('start_date',[$_GET['startdate'],$_GET['enddate']])->get();
            //         //dd($leaves);
            //         return DataTables::of($leaves)->editColumn('start_date', function ($leaves)
            //         {
            //             if(!empty($leaves->start_date))
            //             {
            //                 $str = $leaves->start_date ;
            //                 $date = DateTime::createFromFormat('Y-m-d', $str)->format('d-m-Y');
            //                 return $date;
            //             }
            //             else{
            //                  return '--';
            //             }
            //         })->editColumn('status', function ($leaves)
            //         {
            //         })->editColumn('cancel', function ($leaves)
            //         {
            //         })->make(true);
            //     }
            //     if(empty($_GET['type']))
            //     {
            //      // dd($_GET['startdate'],$_GET['enddate']);
            //         $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username);
            //         return DataTables::of($leaves)->editColumn('status', function ($leaves)
            //         {
            //         })->editColumn('cancel', function ($leaves)
            //         {
            //         })->make(true);
            //     }
        }


        //* old one
        // if(isset($_GET['status']))
        // {
        //     $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where([['username' , $user->username],['status',$_GET['status']]])->get();
        //    // dd($leaves);
        //     $dataa['data'] = html_entity_decode(view('E-Leave.partials.myleave', compact('leaves','userPay','leaveTypes', 'replacement', 'relieves', 'history',
        //    'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray','myLeaveSumm','myLeaveSummSm')));
        //    return response()->json($dataa, 200);
        // }//Rithik
        // if(isset($_GET['startdate']) && isset($_GET['enddate']))
        // {
        //     $leaves = Leavelist::orderBy('date_applied' , 'DESC')->where([['username' , $user->username],['start_date',$_GET['startdate']],['end_date',$_GET['enddate']]])->get();
        //    //dd($leaves);
        //    $dataa['data'] = html_entity_decode(view('E-Leave.partials.myleave', compact('leaves','userPay','leaveTypes', 'replacement', 'relieves', 'history',
        //    'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray','myLeaveSumm','myLeaveSummSm')));
        //    return response()->json($dataa, 200);
        // }
        // else
        // {//rithik
        
        $c_key = 'leave_self';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }
        
        return view('E-Leave.self-leave', compact('company_id', 'leaves', 'userPay', 'leaveTypes', 'replacement', 'relieves', 'history', 'upaydetails',
                        'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray', 'myLeaveSumm', 'myLeaveSummSm','medicalSumm', 'approver', 'approvername', 'relieveallow', 'halfdayallow',
            'c_key', 'columnHideShowData'
        ));

        // }//rithik
    }

    public function getMyLeaves_search(Request $request) {

        $user = User::where('id', Auth::id())->first();
        $relieveallow = DB::table('settings')->where('field', 'leave_relieve_allow')->where('company_id', $user->company_id)->first();
        $halfdayallow = DB::table('settings')->where('field', 'halfdayleave')->where('company_id', $user->company_id)->first();
        $leaveTypes = Leavetype::where('is_show', 1)->get();
        $leaveArray = Leavelist::orderBy('date_applied', 'DESC')->where('username', $user->username);


        $relieves = Relieve::leftjoin('user_pay', 'user_pay.username', '=', 'user_personal.username')->leftjoin('users', 'users.username', '=', 'user_personal.username')->where('users.company_id', $user->company_id)->where('user_pay.pay_status', 1)->orderBy('user_personal.name')->get();
        $type = $request->get('type');
        $year11 = $request->get('year');

        $from = $request->get('from');
        $to = $request->get('to');
        $status = $request->get('status');
        if ($year != null) {
            $yr = $year;
        } else {
            $yr = date('Y');
        }
        $leaveArray->whereYear('start_date', '=', $yr);

        if ($type && $type != '') {
            $leaveArray->where('type', $type);
        }

        if ($from != '' && $to != '') {

            $leaveArray->whereBetween('start_date', [$from, $to]);
        } elseif ($from != '') {
            $leaveArray->where('start_date', '=', $from);
        } elseif ($to != '') {
            $leaveArray->where('start_date', '=', $to);
        }



        if (isset($status) && $status != '') {

            $leaveArray->where('status', $status);
        }
        if ($year11 && $year11 != '') {
            $leaveArray->whereYear('start_date', '=', $yr);
        }

        $leaves = $leaveArray->get();
        if ($request->get('get') && $request->get('get') == 'all') {
            $leaves = $leaves;
        } else {
            $leaves = $leaves;
        }

        $replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->get();
        $history = LeaveEntitleHistory::where('username', $user->username)->where('year', carbon()->year)->get();
        $history->transform(function($item) {
            if ($item->leave_type == 'Annual') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Medical') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Marriage') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Compassionate') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Hospital') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Maternity') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'Examination') {
                $item->class = 'progress-bar-dark';
            }

            if ($item->leave_type == 'Paternity') {
                $item->class = 'progress-bar-info';
            }
            if ($item->leave_type == 'Advance') {
                $item->class = 'progress-bar-danger';
            }
            if ($item->leave_type == 'Other_pay') {
                $item->class = 'progress-bar-warning';
            }
            if ($item->leave_type == 'Line_Shut') {
                $item->class = 'progress-bar-success';
            }
            if ($item->leave_type == 'Absent') {
                $item->class = 'progress-bar-primary';
            }
            if ($item->leave_type == 'Emergency') {
                $item->class = 'progress-bar-secondary';
            }
            if ($item->leave_type == 'NPL') {
                $item->class = 'progress-bar-dark';
            }
            return $item;
        });
        $today = \Carbon\Carbon::now();

        $alHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Annual')->first();
        $medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
                        ->where('year', $today->year)->where('leave_type', 'Medical')->first();
        $repHistory = DB::table('leave_list')->where('username', $user->username)
                        ->where('type', 'Other_pay')->where('status', 1)->count();
        $totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');

        $cut_off_days = day_count_anniv_cutt_off($user->username, carbon()->year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Other_pay'); //rithik
        $mBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Medical');
        $rBFAdj = getAdjustmentLeaveCount($user->username, carbon()->year, 1);
        $mbf = getBroughtForwardLeaveNotAdjusted($user->username, carbon()->year, 'Medical');
        $rbf = 0;
        $albf = 0;
        $aEntitle = getEntitleLeave($user->username, carbon()->year, 'Annual');
        $mEntitle = getEntitleLeave($user->username, carbon()->year, 'Medical');
        $rEntitle = '-';
        $aEarn = (date('n') / 12) * $aEntitle;
        $mEarn = '-';
        $rEarn = getTotalReplaceLeave($user->username, carbon()->year);
        $aClaim = getAnnualClaimable($user->username, carbon()->year, 'Annual');
        $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
        $rlClaim = "-";
        $anunpl = getNPLSummary($user->username, carbon()->year);
        $mcnpl = 0;
        $rpnpl = '-';
        $elTaken = getTakenLeves($user->username, carbon()->year, 'Emergency');
        $alTaken = getTakenLeves($user->username, carbon()->year, 'Annual');
        $mcTaken = getTakenLeves($user->username, carbon()->year, 'Medical');
        $rlTaken = getTakenLeves($user->username, carbon()->year, 'Other_pay');
        $forAlBf = $albf;
        $forAlBfAdj = $aBFAdj;
        $forMC = $mbf;
        $forRL = $rbf;
        $alBalance = $aEntitle - $alTaken;
        $mcBalance = $mEntitle - $mcTaken;
        $rlBalance = $rEarn - $rlTaken;

        $dataArray = [
            'albf' => $albf, 'forAlBf' => $forAlBf,
            'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
            'rbf' => $rbf, 'forMC' => $forMC,
            'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
            'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
            'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
            'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
            'mEntitle' => $mEntitle,
            'rEntitle' => $rEntitle,
            'aEarn' => $aEarn,
            'mEarn' => $mEarn,
            'rEarn' => $rEarn,
            'aClaim' => $aClaim,
            'mClaim' => $mClaim,
            'rlClaim' => $rlClaim,
            'anunpl' => $anunpl,
            'mcnpl' => $mcnpl,
            'rpnpl' => $rpnpl,
            'elTaken' => $elTaken,
            'alTaken' => $alTaken,
            'mcTaken' => $mcTaken,
            'rlTaken' => $rlTaken,
        ];

        $leaves = $leaveArray->get();

        //return $leaves;

        if (isset($_GET['startdate']) && isset($_GET['enddate'])) {
            $leaves = Leavelist::orderBy('date_applied', 'DESC')->where([['username', $user->username], ['start_date', $_GET['startdate']], ['end_date', $_GET['enddate']]])->get();

            // dd($leaves);


            return view('E-Leave.self-leave', compact('leaves', 'relieveallow', 'halfdayallow'));
        } else {

            return view('E-Leave.self-leave', compact('leaves', 'leaveTypes', 'replacement', 'relieves', 'history',
                            'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray', 'relieveallow', 'halfdayallow'
            ));
        }
    }

    public function getAllLeaves() {
        $user = User::where('id', Auth::id())->first();
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $user = User::where('id', Auth::id())->first();
        $branches = Branch::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $departments = Department::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $categories = Category::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $leaveTypes = Leavetype::where('is_show', 1)->get();
        $permission_val = getPermissionValue("view_leave", $user->username);
        $currentOnly = 0;
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $leavesArray = LeaveDay::selectRaw("leave_list.*, leave_name.name as typename,leave_name.leave_color, leave_list.start_time, leave_list.end_time")->leftjoin('leave_list', 'leave_list.id', '=', 'leave_days.leave_id')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->leftjoin('user_pay as c', 'leave_days.username', '=', 'c.username');
// 		if($permission_val==5){
// 		    $leavesArray->leftjoin('map_employee_approver as mea','mea.employee_id','=','leave_list.username');
// 		}
        //$username=$user->username;
        $username = '';
        $userbranchId = getUserBranchId($user->username);
        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);

        if ($permission_val == 4) {
            $leavesArray->whereRaw("leave_days.username='" . $user->username . "'");
        }
        if ($permission_val == 8) {

            //$leavesArray->whereRaw("c.branch_id In ('".$branchidarr."')");
            $leavesArray->whereIn('c.branch_id', $branchidarr);
        }
        if ($permission_val == 7) {
            $leavesArray->where('c.branch_id', $userbranchId);
        }
        if ($permission_val == 5) {
            $logged_userGroups = getUserGroups($user->username);
            $leavesArray->where('c.branch_id', $logged_userGroups->branch_id)->where('c.category_id', $logged_userGroups->category_id)->where('c.department_id', $logged_userGroups->department_id);
            // $leavesArray->whereRaw("(mea.approver_id is not null OR leave_list.username='".$user->username."')");
        } else if ($username != '') {
            $leavesArray->whereRaw("leave_days.username ='" . $username . "'");
        }
        if ($ActiveUserShownStatus == '1') {
            $leavesArray->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        } else {
            $leavesArray->where('c.pay_status', 1);
        }
        $premonth = date('m') - 1;
        $nextmonth = date('m') + 1;
        if ($premonth <= 1) {
            $year = date('Y') - 1;
            $startDate112 = $year . '-12-01';
        } else {
            $startDate112 = date('Y') . '-' . $premonth . '-01';
        }
        if ($nextmonth >= 12) {
            $year = date('Y') + 1;
            $endDate112 = $year . '-01-31';
        } else {
            $endDate112 = date('Y') . '-' . $nextmonth . '-31';
        }
        // dd($startDate112,$endDate112);
        $leavesArray = $leavesArray->whereBetween('leave_days.date', [$startDate112, $endDate112])->orderBy('leave_list.date_applied', 'DESC')->where('leave_days.status', '1')->get();

        $leavesArray->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            } elseif ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = '#000000';
            } else {
                $iname = $item->type;
                $colornm = $item->background_color;
            }


            $employee = DB::table('user_personal')
                            ->where('username', $item->username)->first();
            if ($employee != '') {
                $r_name = $employee->name;
            } else {
                $r_name = '';
            }
            if($item->is_hourly!=0){ 
                $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
            return [
                'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $colornm,
                    //'extendedProps' => [
                    //	'calendar' => $item->type,
                    //]
            ];
        })->toArray();

        $leavesPastArray = DB::table('leave_past')->selectRaw("leave_past.*, leave_name.name as typename, leave_name.leave_color as leave_color,  leave_past.start_time, leave_past.end_time")->leftjoin('leave_name', 'leave_name.type', '=', 'leave_past.type')->leftjoin('user_pay as c', 'leave_past.username', '=', 'c.username');
// 		if($permission_val==5){
// 		    $leavesPastArray->leftjoin('map_employee_approver as mea','mea.employee_id','=','leave_past.username');
// 		}
        if ($permission_val == 4) {
            $leavesPastArray->whereRaw("leave_past.username='" . $user->username . "'");
        }
        if ($permission_val == 8) {
            $leavesPastArray->whereIn('c.branch_id', $branchidarr);
            //$leavesPastArray->whereRaw("c.branch_id In ('".$branchidarr."')");
        }
        if ($permission_val == 7) {
            $leavesPastArray->where('c.branch_id', $userbranchId);
        }
        if ($permission_val == 5) {
            $logged_userGroups = getUserGroups($user->username);
            $leavesPastArray->where('c.branch_id', $logged_userGroups->branch_id)->where('c.category_id', $logged_userGroups->category_id)->where('c.department_id', $logged_userGroups->department_id);
            //$leavesPastArray->whereRaw("(mea.approver_id is not null OR leave_past.username='".$user->username."')");
        } else if ($username != '') {
            $leavesPastArray->whereRaw("leave_past.username='" . $username . "'");
        }
        if ($ActiveUserShownStatus == '1') {
            $leavesPastArray->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        } else {
            $leavesPastArray->where('c.pay_status', 1);
        }

        $leavesPastArray = $leavesPastArray->whereBetween('leave_past.start_date', [$startDate112, $endDate112])->where('leave_past.status', '1')->get();

        $leavesPastArray->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            } elseif ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = '#000000';
            } else {
                $iname = $item->type;
                $colornm = $item->background_color;
            }


            $employee = DB::table('user_personal')
                            ->where('username', $item->username)->first();
            if ($employee != '') {
                $r_name = $employee->name;
            } else {
                $r_name = '';
            }
            if($item->is_hourly!=0){ 
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }

            return [
                'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $colornm,
                    //'extendedProps' => [
                    //	'calendar' => $item->type,
                    //]
            ];
        })->toArray();
        //$restDay = DB::table('rest_days')
        //			->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
        // 		$rest_day_type = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->get();
        // 		$rest_day_id=$rest_day_type['0']->category_id;
        // 		$rest_day_cat = DB::table('rest_day_category')->where('id', $rest_day_id)->get();
        // 		$rest_cat_name = array();
        // 		if($rest_day_id!=0){
        // 		    foreach(explode('-', $rest_day_cat['0']->category) as $cat) { 
        // 			    $rest_cat_name11 = substr($cat,0 ,3); 
        // 			    array_push($rest_cat_name,$rest_cat_name11);
        // 		    }
        // 		}
        // 		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->whereRaw('DATE_FORMAT(STR_TO_DATE(date, "%Y-%m-%d"),"%a") IN ("'.implode('","',$rest_cat_name).'")')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
// 		$restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();

        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();

        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();


        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }

        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereBetween('date', [$startDate112, $endDate112])->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();

        $recentHoliday->transform(function($item11) {

            return [
                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();
        $leaves11 = $restDay->merge($leavesArray);
        $leaves12 = $leaves11->merge($leavesPastArray);
        $leaves = $leaves12->merge($recentHoliday);

        return view('E-Leave.all-holidays', compact('leaves', 'branches', 'departments', 'categories', 'leaveTypes'));
    }

    public function cancelLeave(Request $request, $id) {
        $leave = Leavelist::find($id);
        $day = LeaveDay::where('leave_id', $id)->first();
        $leave->status = "4";
        $leave->date_approved = date('Y-m-d');
        $leave->save();

        $day->status = "4";
        $day->cancellation_reason = $request->reason;
        $day->save();


        return 1;
    }

    public function getEntitle(Request $request, $year = null, $isjson = "no") {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        if ($year == null) {
            $year = carbon()->year;
        }

        if (getSettingsValue('leave_adjustment_type') == 8) {

            $joiningDate = getJoinDateStr($user->username);
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            // if((isset($_POST["pdf"]))) {
            // } else {
            // if (date('Y-m-d') < $curr_date) {
            //     $year = $year - 1;
            // }
            //  dd($year,$curr_date);
            // }
        }

        $replacement = DB::table('leave_adjustment')->selectRaw("id, employee_id, start_date, end_date, no_days, sum(no_granted) as no_granted")->where('employee_id', $user->username)->groupBy('start_date');
        $replacement = $replacement->whereRaw("DATE_FORMAT(`start_date`, '%Y') = '" . $year . "'");
        $replacement = $replacement->get();


        $cut_off_days = day_count_anniv_cutt_off($user->username, $year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
        $mBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Medical');
        $rBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
        $mbf = getBroughtForwardLeaveNotAdjusted($user->username, $year, 'Medical');
        $rbf = 0;
        $albf = 0;
        $aEntitle = getEntitleLeave($user->username, $year, 'Annual');
        $mEntitle = getEntitleLeave($user->username, $year, 'Medical');
        $rEntitle = '-';
        $aEarn = (date('n') / 12) * $aEntitle;
        $mEarn = '-';
        $rEarn = getTotalReplaceLeave($user->username, $year);
        $aClaim = getAnnualClaimable($user->username, $year, 'Annual');
        $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
        $rlClaim = "-";
        $anunpl = getNPLSummary($user->username, $year);
        $mcnpl = 0;
        $rpnpl = '-';
        $elTaken = getTakenLeves($user->username, $year, 'Emergency');
        $alTaken = getTakenLeves($user->username, $year, 'Annual');
        $mcTaken = getTakenLeves($user->username, $year, 'Medical');
        $rlTaken = getTakenLeves($user->username, $year, 'Other_pay');
        $forAlBf = $albf;
        $forAlBfAdj = $aBFAdj;
        $forMC = $mbf;
        $forRL = $rbf;
        $alBalance = $aEntitle - $alTaken;
        $mcBalance = $mEntitle - $mcTaken;
        $rlBalance = $rEarn - $rlTaken;

        $dataArray = [
            'albf' => $albf, 'forAlBf' => $forAlBf,
            'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
            'rbf' => $rbf, 'forMC' => $forMC,
            'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
            'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
            'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
            'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
            'mEntitle' => $mEntitle,
            'rEntitle' => $rEntitle,
            'aEarn' => $aEarn,
            'mEarn' => $mEarn,
            'rEarn' => $rEarn,
            'aClaim' => $aClaim,
            'mClaim' => $mClaim,
            'rlClaim' => $rlClaim,
            'anunpl' => $anunpl,
            'mcnpl' => $mcnpl,
            'rpnpl' => $rpnpl,
            'elTaken' => $elTaken,
            'alTaken' => $alTaken,
            'mcTaken' => $mcTaken,
            'rlTaken' => $rlTaken,
        ];

        $alsStartDate = ((isset($request->datefrom) && $request->datefrom != "") ? date('Y-m-d', strtotime($request->datefrom)) : "");
        $alsEndDate = ((isset($request->dateto) && $request->dateto != "") ? date('Y-m-d', strtotime($request->dateto)) : "");
        $username = $user->username;
//dd($year);
        // $dataArrayAls["alsAnnualLeave"] = getTakenLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate);
        // $dataArrayAls["alsMedicalLeave"] = getTakenLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsMaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsMarriageLeave"] = getTakenLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsCompassionateLeave"] = getTakenLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsHospitalLeave"] = getTakenLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsExaminationLeave"] = getTakenLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsPaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsAdvance"] = getTakenLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate);

        // $dataArrayAls["alsReplacementLeave"] = getTakenLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsLine_ShutLeave"] = getTakenLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate);
        $dataArrayAls["alsAbsentLeave"] = getTakenLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate);

        // $dataArrayAls["alsNPLeave"] = getTakenLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate);
// 		$myLeaveSumm = json_decode(myLeaveSummary($username,$year),true);
// 		$myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
// 		$myLeaveSummSm = $myLeaveSummSm['users'][0];
        //$myLeaveSumm = getYearlyEntitle($username, $year);
        //	$myLeaveSummSm = getYearlyrlEntitleList($username, $year);
        $url = \Request::url();

        $uname = UserPersonal::whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
        $name = urlencode($uname->employee_no);

        $ln = 1;
        $aid = Auth::id();
        
        if($year!=null){
              $url11 = str_replace("e-leave/entitle","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
      
        }else{
          $url11 = str_replace("e-leave/entitle","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
          
        }
     // dd($url11,$year);
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $myLeaveSumm = json_decode($response);
         if (!empty($myLeaveSumm)) {
            $myLeaveSumm = $myLeaveSumm[0];
        } else {
            $myLeaveSumm = '';
        }
        if($year!=null){
             $url12 = str_replace("e-leave/entitle","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());
        
        }else{
           $url12 = str_replace("e-leave/entitle","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
          
        }
        $url12 = str_replace("e-leave/entitle","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }
        if($year!=null){
            $url = str_replace("e-leave/entitle", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&year=$year&test=1", $request->getUri());

        }else{
            $url = str_replace("e-leave/entitle", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&year=$year&test=1", $request->getUri());

        }
        
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);

        $myLeaveSummSm = json_decode($response);

        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }
        // $data['myLeaveSummSm'] = $myLeaveSummSm['users'][0];
        //return Response::json($data, 200);

        if ($isjson == "no") {
            return view('E-Leave.entitle', compact('user', 'username', 'userPay', 'replacement', 'dataArray', 'dataArrayAls', 'myLeaveSumm','medicalSumm', 'myLeaveSummSm'));
        } else {
            $dataa['data'] = html_entity_decode(view('E-Leave.partials.entilted', compact('user', 'username', 'userPay', 'replacement', 'dataArray', 'dataArrayAls', 'myLeaveSumm','medicalSumm', 'myLeaveSummSm')));
           return Response::json($dataa, 200);
        }
    }

    // public function getEntitle11(Request $request, $year = null, $isjson = "no") {
    //     $user = LeaveDay::where('id', $request->get('id'))->first();
    //     $userPay = UserPay::where('username', $user->username)->first();
    //     if ($year == null) {
    //         $year = carbon()->year;
    //     }
    //     if (getSettingsValue('leave_adjustment_type') == 8) {

    //         $joiningDate = getJoinDateStr($user->username);
    //         $joiningDateArr = explode('-', $joiningDate);
    //         $joining_month = $joiningDateArr[1];
    //         $joining_date = $joiningDateArr[2];
    //         $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
    //         // if((isset($_POST["pdf"]))) {
    //         // } else {
    //         if (date('Y-m-d') < $curr_date) {
    //             $year = $year - 1;
    //         }
    //         // }
    //     }

    //     $replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->groupBy('start_date');
    //     $replacement = $replacement->whereRaw("DATE_FORMAT(`start_date`, '%Y') = '" . $year . "'");
    //     $replacement = $replacement->get();


    //     $cut_off_days = day_count_anniv_cutt_off($user->username, $year);
    //     $aBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
    //     $mBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Medical');
    //     $rBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
    //     $mbf = getBroughtForwardLeaveNotAdjusted($user->username, $year, 'Medical');
    //     $rbf = 0;
    //     $albf = 0;
    //     $aEntitle = getEntitleLeave($user->username, $year, 'Annual');
    //     $mEntitle = getEntitleLeave($user->username, $year, 'Medical');
    //     $rEntitle = '-';
    //     $aEarn = (date('n') / 12) * $aEntitle;
    //     $mEarn = '-';
    //     $rEarn = getTotalReplaceLeave($user->username, $year);
    //     $aClaim = getAnnualClaimable($user->username, $year, 'Annual');
    //     $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
    //     $rlClaim = "-";
    //     $anunpl = getNPLSummary($user->username, $year);
    //     $mcnpl = 0;
    //     $rpnpl = '-';
    //     $elTaken = getTakenLeves($user->username, $year, 'Emergency');
    //     $alTaken = getTakenLeves($user->username, $year, 'Annual');
    //     $mcTaken = getTakenLeves($user->username, $year, 'Medical');
    //     $rlTaken = getTakenLeves($user->username, $year, 'Other_pay');
    //     $forAlBf = $albf;
    //     $forAlBfAdj = $aBFAdj;
    //     $forMC = $mbf;
    //     $forRL = $rbf;
    //     $alBalance = $aEntitle - $alTaken;
    //     $mcBalance = $mEntitle - $mcTaken;
    //     $rlBalance = $rEarn - $rlTaken;

    //     $dataArray = [
    //         'albf' => $albf, 'forAlBf' => $forAlBf,
    //         'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
    //         'rbf' => $rbf, 'forMC' => $forMC,
    //         'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
    //         'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
    //         'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
    //         'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
    //         'mEntitle' => $mEntitle,
    //         'rEntitle' => $rEntitle,
    //         'aEarn' => $aEarn,
    //         'mEarn' => $mEarn,
    //         'rEarn' => $rEarn,
    //         'aClaim' => $aClaim,
    //         'mClaim' => $mClaim,
    //         'rlClaim' => $rlClaim,
    //         'anunpl' => $anunpl,
    //         'mcnpl' => $mcnpl,
    //         'rpnpl' => $rpnpl,
    //         'elTaken' => $elTaken,
    //         'alTaken' => $alTaken,
    //         'mcTaken' => $mcTaken,
    //         'rlTaken' => $rlTaken,
    //     ];

    //     $alsStartDate = ((isset($request->datefrom) && $request->datefrom != "") ? date('Y-m-d', strtotime($request->datefrom)) : "");
    //     $alsEndDate = ((isset($request->dateto) && $request->dateto != "") ? date('Y-m-d', strtotime($request->dateto)) : "");
    //     $username = $user->username;

    //     // $dataArrayAls["alsAnnualLeave"] = getTakenLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate);
    //     // $dataArrayAls["alsMedicalLeave"] = getTakenLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsMaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsMarriageLeave"] = getTakenLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsCompassionateLeave"] = getTakenLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsHospitalLeave"] = getTakenLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsExaminationLeave"] = getTakenLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsPaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsAdvance"] = getTakenLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate);

    //     // $dataArrayAls["alsReplacementLeave"] = getTakenLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate);

    //     $dataArrayAls["alsLine_ShutLeave"] = getTakenLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate);
    //     $dataArrayAls["alsAbsentLeave"] = getTakenLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate);

    //     // $dataArrayAls["alsNPLeave"] = getTakenLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate);
    //     // 		$data['myLeaveSumm'] = json_decode(myLeaveSummary($username,$year),true);
    //     // 		$myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
    //     // 		$data['myLeaveSummSm'] = $myLeaveSummSm['users'][0];
    //     $uname = DB::table('user_personal')->whereRaw('name="' . $username . '" or username="' . $username . '" or employee_no="' . $username . '"')->first();
    //     $name = urlencode($uname->employee_no);
    //     $ln = 1;
    //     $aid = Auth::id();
        
    //     $url11 = str_replace("e-leave/en?_=".$request->_."&id=".$request->id,"public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
      
    //     ini_set('memory_limit', -1);
    //     ini_set('max_execution_time', -1);
    //     $curl = curl_init();

    //         curl_setopt_array($curl, array(
    //         CURLOPT_URL => $url11."&auth_id=".Auth::id(),
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_ENCODING => '',
    //         CURLOPT_MAXREDIRS => 10,
    //         CURLOPT_TIMEOUT => 0,
    //         CURLOPT_FOLLOWLOCATION => true,
    //         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //         CURLOPT_CUSTOMREQUEST => 'GET',
    //     ));

    //     $response = curl_exec($curl);
    //     curl_close($curl);
       
    //     $myLeaveSumm = json_decode($response);
           
    //      if (!empty($myLeaveSumm)) {
    //         $myLeaveSumm = $myLeaveSumm[0];
    //     } else {
    //         $myLeaveSumm = '';
    //     }
      
    //     $url12 = str_replace("e-leave/en?_=".$request->_."&id=".$request->id,"public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
        
    //     ini_set('memory_limit', -1);
    //     ini_set('max_execution_time', -1);
    //     $curl = curl_init();

    //         curl_setopt_array($curl, array(
    //         CURLOPT_URL => $url12."&auth_id=".Auth::id(),
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_ENCODING => '',
    //         CURLOPT_MAXREDIRS => 10,
    //         CURLOPT_TIMEOUT => 0,
    //         CURLOPT_FOLLOWLOCATION => true,
    //         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //         CURLOPT_CUSTOMREQUEST => 'GET',
    //     ));

    //     $response = curl_exec($curl);
    //     curl_close($curl);
       
    //     $medicalSumm = json_decode($response);
    //      if (!empty($medicalSumm)) {
    //         $medicalSumm = $medicalSumm[0];
    //     } else {
    //         $medicalSumm = '';
    //     }

    //     $url = str_replace("e-leave/en?_=".$request->_."&id=".$request->id, "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());

    //     //dd(session('rreplacement_pdf_data'),$url);
    //     //$url = session('rreplacement_pdf_data');
    //     ini_set('memory_limit', -1);
    //     $curl = curl_init();

    //     curl_setopt_array($curl, array(
    //         CURLOPT_URL => $url,
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_ENCODING => '',
    //         CURLOPT_MAXREDIRS => 10,
    //         CURLOPT_TIMEOUT => 0,
    //         CURLOPT_FOLLOWLOCATION => true,
    //         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //         CURLOPT_CUSTOMREQUEST => 'GET',
    //     ));
    //     //dd($url);
    //     $response = curl_exec($curl);
    //     curl_close($curl);
    //     // dd($response);
    //     $myLeaveSummSm = json_decode($response);

    //     //dd($myLeaveSummSm);
    //     if (!empty($myLeaveSummSm)) {
    //         $myLeaveSummSm = $myLeaveSummSm[0];
    //     } else {
    //         $myLeaveSummSm = '';
    //     }
    //     $data['myLeaveSumm'] = $myLeaveSumm;
    //     $data['medicalSumm'] = $medicalSumm;
    //     $data['myLeaveSummSm'] = $myLeaveSummSm;
    //     $data['hourly']=getSettingsValue('hourlyLeave');
    //     return Response::json($data, 200);
    // }
    
     public function getEntitle11(Request $request, $year = null, $isjson = "no") {
        $user = LeaveDay::where('id', $request->get('id'))->first();

        $userPay = UserPay::where('username', $user->username)->first();
        if ($year == null) {
            $year = carbon()->year;
        }
        if (getSettingsValue('leave_adjustment_type') == 8) {

            $joiningDate = getJoinDateStr($user->username);
            $joiningDateArr = explode('-', $joiningDate);
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
            // if((isset($_POST["pdf"]))) {
            // } else {
            if (date('Y-m-d') < $curr_date) {
                $year = $year - 1;
            }
            // }
        }

        $replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->groupBy('start_date');
        $replacement = $replacement->whereRaw("DATE_FORMAT(`start_date`, '%Y') = '" . $year . "'");
        $replacement = $replacement->get();


        $cut_off_days = day_count_anniv_cutt_off($user->username, $year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
        $mBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Medical');
        $rBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
        $mbf = getBroughtForwardLeaveNotAdjusted($user->username, $year, 'Medical');
        $rbf = 0;
        $albf = 0;
        $aEntitle = getEntitleLeave($user->username, $year, 'Annual');
        $mEntitle = getEntitleLeave($user->username, $year, 'Medical');
        $rEntitle = '-';
        $aEarn = (date('n') / 12) * $aEntitle;
        $mEarn = '-';
        $rEarn = getTotalReplaceLeave($user->username, $year);
        $aClaim = getAnnualClaimable($user->username, $year, 'Annual');
        $mClaim = (($mEntitle + $mBFAdj) * 2) / 2;
        $rlClaim = "-";
        $anunpl = getNPLSummary($user->username, $year);
        $mcnpl = 0;
        $rpnpl = '-';
        $elTaken = getTakenLeves($user->username, $year, 'Emergency');
        $alTaken = getTakenLeves($user->username, $year, 'Annual');
        $mcTaken = getTakenLeves($user->username, $year, 'Medical');
        $rlTaken = getTakenLeves($user->username, $year, 'Other_pay');
        $forAlBf = $albf;
        $forAlBfAdj = $aBFAdj;
        $forMC = $mbf;
        $forRL = $rbf;
        $alBalance = $aEntitle - $alTaken;
        $mcBalance = $mEntitle - $mcTaken;
        $rlBalance = $rEarn - $rlTaken;

        $dataArray = [
            'albf' => $albf, 'forAlBf' => $forAlBf,
            'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
            'rbf' => $rbf, 'forMC' => $forMC,
            'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
            'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
            'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
            'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
            'mEntitle' => $mEntitle,
            'rEntitle' => $rEntitle,
            'aEarn' => $aEarn,
            'mEarn' => $mEarn,
            'rEarn' => $rEarn,
            'aClaim' => $aClaim,
            'mClaim' => $mClaim,
            'rlClaim' => $rlClaim,
            'anunpl' => $anunpl,
            'mcnpl' => $mcnpl,
            'rpnpl' => $rpnpl,
            'elTaken' => $elTaken,
            'alTaken' => $alTaken,
            'mcTaken' => $mcTaken,
            'rlTaken' => $rlTaken,
        ];

        $alsStartDate = ((isset($request->datefrom) && $request->datefrom != "") ? date('Y-m-d', strtotime($request->datefrom)) : "");
        $alsEndDate = ((isset($request->dateto) && $request->dateto != "") ? date('Y-m-d', strtotime($request->dateto)) : "");
        $username = $user->username;

        // $dataArrayAls["alsAnnualLeave"] = getTakenLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate);
        // $dataArrayAls["alsMedicalLeave"] = getTakenLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsMaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsMarriageLeave"] = getTakenLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsCompassionateLeave"] = getTakenLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsHospitalLeave"] = getTakenLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsExaminationLeave"] = getTakenLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsPaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsAdvance"] = getTakenLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate);

        // $dataArrayAls["alsReplacementLeave"] = getTakenLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate);

        $dataArrayAls["alsLine_ShutLeave"] = getTakenLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate);
        $dataArrayAls["alsAbsentLeave"] = getTakenLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate);

        // $dataArrayAls["alsNPLeave"] = getTakenLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate);
// 		$data['myLeaveSumm'] = json_decode(myLeaveSummary($username,$year),true);
// 		$myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
// 		$data['myLeaveSummSm'] = $myLeaveSummSm['users'][0];
        $data['myLeaveSumm'] = getYearlyEntitle($username, $year);
        $myLeaveSummSm = getYearlyrlEntitleList($username, $year);
        $data['myLeaveSummSm'] = $myLeaveSummSm[0];
        return Response::json($data, 200);
    }


    public function leaveFilter(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $leaveArray = Leavelist::orderBy('date_applied', 'DESC')->where('username', $user->username);
        $type = $request->get('type');
        $from = $request->get('from');
        $to = $request->get('to');
        if ($type && $type != '') {
            $leaveArray->where('type', $type);
        }

        if ($from && $from != '') {
            $leaveArray->where('start_date', '>=', $from);
        }

        if ($to && $to != '') {
            $leaveArray->where('end_date', '<=', $to);
        }

        $leaves = $leaveArray->paginate(10);
        return view('E-Leave.inc.self-filter', compact('leaves'))->render();
    }

    public function holidayFilter(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $permission_val = $this->getPermissionValue("view_leave", $user->username);
        $ActiveUserShownStatus11 = DB::table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value ?? 0;
        $leavepast = DB::table('leave_past')->selectRaw("leave_past.*, user_personal.*, leave_name.name as typename, leave_name.leave_color, leave_past.start_time, leave_past.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_past.username')->leftjoin('user_pay', 'user_pay.username', '=', 'leave_past.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_past.type');
        if ($permission_val == 5) {
            $leavepast->leftjoin('map_employee_approver as mea', 'mea.employee_id', '=', 'leave_past.username');
        }
        $leavepast->where('leave_past.status', '1')->orderBy('leave_past.start_date', 'DESC');

        $leaveArray = LeaveDay::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename, leave_name.leave_color, leave_list.start_time,leave_list.end_time")->leftjoin('leave_list', 'leave_list.id', '=', 'leave_days.leave_id')->join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftjoin('user_pay', 'user_pay.username', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type');
// 		if($permission_val==5){
// 	        $leaveArray->leftjoin('map_employee_approver as mea','mea.employee_id','=','leave_list.username');
// 		}
        $leaveArray->where('leave_days.status', '1')->orderBy('leave_list.date_applied', 'DESC');
        $username = $request->name;
        $userbranchId = getUserBranchId($user->username);
        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);

        if ($permission_val == 8) {
            $leaveArray->whereIn('user_pay.branch_id', $branchidarr);
            $leavepast->whereIn('user_pay.branch_id', $branchidarr);
        }
        if ($permission_val == 4) {
            if ($username != '') {
                $leaveArray->whereRaw("leave_list.username='" . $username . "'");
                $leavepast->whereRaw("leave_past.username='" . $username . "'");
            } else {
                $leaveArray->whereRaw("leave_list.username='" . $user->username . "'");
                $leavepast->whereRaw("leave_past.username='" . $user->username . "'");
            }
        }

        if ($permission_val == 7) {
            $leaveArray->where('user_pay.branch_id', $userbranchId);
            $leavepast->where('user_pay.branch_id', $userbranchId);
        }
        if ($permission_val == 5) {
            $logged_userGroups = getUserGroups($user->username);
            $leaveArray->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
            $leavepast->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
        }

        if ($ActiveUserShownStatus == 1) {
            $leavepast->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
            $leaveArray->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
        } else {
            $leavepast->where('user_pay.pay_status', '1');
            $leaveArray->where('user_pay.pay_status', '1');
        }
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $type = $request->type;
        if ($type && $type != '') {
            $leavepast->where('leave_past.type', $type);
            $leaveArray->where('leave_list.type', $type);
        }

        if ($request->name && $request->name != '') {

            $leavepast->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');

            $leaveArray->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
        }
        if ($request->username && $request->username != '') {
            $leavepast->whereRaw('(user_personal.name like ("' . request()->username . '%") OR user_personal.employee_no like ("' . request()->username . '%")) ');

            $leaveArray->whereRaw('(user_personal.name like ("' . request()->username . '%") OR user_personal.employee_no like ("' . request()->username . '%")) ');
// 			});
        }

        if ($request->branch && $request->branch != '') {
            $leavepast->where('user_pay.branch_id', $request->branch);

            $leaveArray->where('user_pay.branch_id', $request->branch);
        }

        if ($request->department && $request->department != '') {
            $leavepast->where('user_pay.department_id', $request->department);

            $leaveArray->where('user_pay.department_id', $request->department);
        }

        if ($request->category && $request->category != '') {
            $leavepast->where('user_pay.category_id', $request->category);

            $leaveArray->where('user_pay.category_id', $request->category);
        }
        if ($request->month && $request->month != '') {
            //  if()
            $premonth = $request->month - 1;
            $nextmonth = $request->month + 1;

            if ($request->month <= 1) {
                $year = $request->year - 1;
                $startDate112 = $year . '-12-01';
            } else {
                $startDate112 = $request->year . '-' . $premonth . '-01';
            }
            if ($request->month >= 12) {
                $year = $request->year + 1;
                $endDate112 = $year . '-01-31';
            } else {
                $endDate112 = $request->year . '-' . $nextmonth . '-31';
            }
            if ($request->calenderview == 'previous') {
                $year123 = date('Y', strtotime($startDate112));
                $month123 = date('m', strtotime($startDate112));
                $endDate112 = $year123 . '-' . $month123 . '-31';
            } elseif ($request->calenderview == 'next') {
                $year123 = date('Y', strtotime($endDate112));
                $dt = date('Y-m-d', strtotime($endDate112 . ' -1 day'));
                $month123 = date('m', strtotime($dt));
                $startDate112 = $year123 . '-' . $month123 . '-01';
            } else {
                $endDate112 = $endDate112;
            }
            //  dd($startDate112,$endDate112);
            //session(['getmonthdata' => $request->month]);
            //dd($startDate,$endDate);
            $leavepast->whereBetween('leave_past.start_date', [$startDate112, $endDate112]);
            $leaveArray->whereBetween('leave_list.start_date', [$startDate112, $endDate112]);
            // $leavepast->whereMonth('leave_past.start_date',$request->month);
            //	$leaveArray->whereMonth('leave_list.start_date',$request->month);
        }

        $Array = $leaveArray->get();

        $Array->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = "#000000";
            } else {
                $iname = $item->type;
            }
            //	$employee = DB::table('user_personal')
            //  ->where('username', $item->username)->first();
            $r_name = $item->name;
            if($item->is_hourly!=0){ 
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
            return [
                'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $item->background_color,
            ];
        })->toArray();


        $pastArray = $leavepast->whereYear('leave_past.start_date', $request->year)->get();
        $pastArray->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = "#000000";
            } else {
                $iname = $item->type;
            }
            if($item->is_hourly!=0){ 
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
            //	$employee = DB::table('user_personal')
            //   ->where('username', $item->username)->first();
            $r_name = $item->name;
            
            return [
                'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $item->background_color,
            ];
        })->toArray();


        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();

        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();
        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();
        //	$user = User::where('id' , Auth::id())->first();
        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereBetween('date', [$startDate112, $endDate112])->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();

        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();

        $leaves11 = $restDay->merge($Array);
        $leaves12 = $leaves11->merge($pastArray);
        $leaves = $leaves12->merge($recentHoliday);
        //$leaves = $restDay->merge($Array);
// dd($leaves);

// $result = array();
// foreach ($leaves as $value)
// {
//     // $key = $value["store_id"];
//     // if (in_array($key, $storeID))
//     // {
//         $ItemIdFound = isset($result[$key]) && ItemIdExists($result[$key], $value["item_type_id"]);

//         if (!$ItemIdFound)
//             $result[$key][] = $value;
//     // }
// }
        return $leaves;
    }
    
    public function ItemIdExists($arr, $itemId)
    {
        foreach ($arr as $subValue)
        {
            if ($subValue["item_type_id"] == $itemId)
            {
                return true;
            }
        }
        return false;
    }

    public function getPermissionValue($group, $username) {
        $query = "select b.$group as val from map_employee_permission a left join permission_group b ";
        $query .= "on a.permission_group_id=b.id where a.employee_id='$username'";
        $builder = DB::select($query);
        $result = intval($builder[0]->val);
        return $result;
    }

    public function aholidayFilter(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $approval_viewStatus = $this->getPermissionValue("approval_view_all", $user->username);
        $ActiveUserShownStatus11 = DB::table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value ?? 0;
        $leavepast = DB::table('leave_past')->selectRaw("leave_past.*, user_personal.*, leave_name.name as typename, leave_name.leave_color, leave_past.start_time,leave_past.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_past.username')->leftjoin('user_pay', 'user_pay.username', '=', 'leave_past.username')->leftjoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_past.type')->where('leave_past.status', '1')->orderBy('leave_past.start_date', 'DESC');
        $leaveArray = Leavelist::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename, leave_name.leave_color, leave_list.start_time,leave_list.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftjoin('user_pay', 'user_pay.username', '=', 'leave_list.username')->leftjoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('leave_list.status', '1')->orderBy('leave_list.date_applied', 'DESC');
        if ($approval_viewStatus == 1) {
            $leavepast->where('leave_past.username', $user->username);
            $leaveArray->where('leave_list.username', $user->username);
        } elseif ($approval_viewStatus == 2) {
            $logged_userGroups = getUserGroups($user->username);
            $leavepast->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
            $leaveArray->where('user_pay.branch_id', $logged_userGroups->branch_id)->where('user_pay.category_id', $logged_userGroups->category_id)->where('user_pay.department_id', $logged_userGroups->department_id);
        } elseif ($approval_viewStatus == 3) {
            $logged_userGroups = getUserGroups($user->username);
            $leavepast->where('user_pay.branch_id', $logged_userGroups->branch_id);
            $leaveArray->where('user_pay.branch_id', $logged_userGroups->branch_id);
        } elseif ($approval_viewStatus == 4) {
            $userbranchId = getUserBranchId($user->username);
            $state_nm = getstatebybranch($userbranchId);
            $leavepast->where('branch.state', $state_nm);
            $leaveArray->where('branch.state', $state_nm);
        }
        if ($ActiveUserShownStatus == 1) {
            $leavepast->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
            $leaveArray->whereRaw("( user_pay.pay_status='1' or user_pay.pay_status='0')");
        } else {
            $leavepast->where('user_pay.pay_status', '1');
            $leaveArray->where('user_pay.pay_status', '1');
        }
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $type = $request->type;
        if ($type && $type != '') {
            $leavepast->where('leave_past.type', $type);
            $leaveArray->where('leave_list.type', $type);
        }

        if ($request->name && $request->name != '') {
// 			$leavepast->where(function($query){
            $leavepast->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
// 			});
// 			$leaveArray->where(function($query){
            $leaveArray->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
// 			});
        }
        if ($request->username && $request->username != '') {
            //  $leavepast->where(function($query){
            $leavepast->whereRaw('(user_personal.name like ("' . request()->username . '%") OR user_personal.employee_no like ("' . request()->username . '%")) ');
// 			});
// 			$leaveArray->where(function($query){
            $leaveArray->whereRaw('(user_personal.name like ("' . request()->username . '%") OR user_personal.employee_no like ("' . request()->username . '%")) ');
// 			});
        }


        if ($request->branch && $request->branch != '') {
            $branchId = UserPay::where('branch_id', $request->branch)->pluck('username')->toArray();

            $leavepast->whereIn('user_personal.username', $branchId);

            $leaveArray->whereIn('user_personal.username', $branchId);
        }

        if ($request->department && $request->department != '') {
            $branchId = UserPay::where('department_id', $request->department)->pluck('username')->toArray();

            $leavepast->whereIn('user_personal.username', $branchId);
            $leaveArray->whereIn('user_personal.username', $branchId);
        }

        if ($request->category && $request->category != '') {
            $branchId = UserPay::where('category_id', $request->category)->pluck('username')->toArray();
            $leavepast->whereIn('user_personal.username', $branchId);
            $leaveArray->whereIn('leave_list.username', $branchId);
        }
// 		if($request->year && $request->year !=''){
// 		    $leavepast->whereYear('leave_past.start_date',$request->year);
// 			$leaveArray->whereYear('leave_list.start_date',$request->year);
// 		}
        if ($request->month && $request->month != '') {
            //  if()
            $premonth = $request->month - 1;
            $nextmonth = $request->month + 1;

            if ($request->month == 1) {
                $year = $request->year - 1;
                $startDate112 = $year . '-12-01';
            } else {
                $startDate112 = $request->year . '-' . $premonth . '-01';
            }
            if ($request->month == 12) {
                $year = $request->year + 1;
                $endDate112 = $year . '-01-31';
            } else {
                $endDate112 = $request->year . '-' . $nextmonth . '-31';
            }
            if ($request->calenderview == 'previous') {
                $year123 = date('Y', strtotime($startDate112));
                $month123 = date('m', strtotime($startDate112));
                $endDate112 = $year123 . '-' . $month123 . '-31';
            } elseif ($request->calenderview == 'next') {
                $year123 = date('Y', strtotime($endDate112));
                $month123 = date('m', strtotime($endDate112));
                $startDate112 = $year123 . '-' . $month123 . '-01';
            } else {
                $endDate112 = $endDate112;
            }
            //  dd($startDate112,$endDate112);
            //session(['getmonthdata' => $request->month]);
            //dd($startDate,$endDate);
            $leavepast->whereBetween('leave_past.start_date', [$startDate112, $endDate112]);
            $leaveArray->whereBetween('leave_list.start_date', [$startDate112, $endDate112]);
            // $leavepast->whereMonth('leave_past.start_date',$request->month);
            //	$leaveArray->whereMonth('leave_list.start_date',$request->month);
        }

        $Array = $leaveArray->get();

        $Array->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = "#000000";
            } else {
                $iname = $item->type;
            }
            $employee = DB::table('user_personal')
                            ->where('username', $item->username)->first();
            $r_name = $employee->name;
            if($item->is_hourly!=0){ 
                $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }

            return [
                'id' => date('m', strtotime($item->start_date)),
                'title' => $r_name . ' (' . $item->typename . ')' . $htype. ' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $item->background_color,
            ];
        })->toArray();


        $pastArray = $leavepast->get();
        $pastArray->transform(function ($item) {
            if ($item->leave_color != null) {
                $item->background_color = $item->leave_color;
            } else {
                $item->background_color = "#4298a1";
            }
            if ($item->half_day_type == 'first') {
                $htype = 'AM';
            } elseif ($item->half_day_type == 'second') {
                $htype = 'PM';
            } else {
                $htype = '';
            }
            if ($item->type == 'Line_Shut') {
                $iname = 'Out Of Office';
                $colornm = "#4298a1";
            }
            if ($item->type == 'Other_pay') {
                $iname = 'Replacement';
                $colornm = "#000000";
            } else {
                $iname = $item->type;
            }
            if($item->is_hourly!=0){ 
                $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
            } else 
            { 
                $time = ''; 
            }
            $employee = DB::table('user_personal')
                            ->where('username', $item->username)->first();
            $r_name = $employee->name;



            return [
                'id' => date('m', strtotime($item->start_date)),
                'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                'text_color' => '#fff',
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'type' => $item->type,
                'color' => $item->background_color,
            ];
        })->toArray();


        // 		$rest_day_type = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->get();
        // 		$rest_day_id=$rest_day_type['0']->category_id;
        // 		$rest_day_cat = DB::table('rest_day_category')->where('id', $rest_day_id)->get();
        // 		$rest_cat_name = array();
        // 		foreach(explode('-', $rest_day_cat['0']->category) as $cat) { 
        // 			$rest_cat_name11 = substr($cat,0 ,3); 
        // 			array_push($rest_cat_name,$rest_cat_name11);
        // 		}
        // 		//$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
        // 		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->whereRaw('DATE_FORMAT(STR_TO_DATE(date, "%Y-%m-%d"),"%a") IN ("'.implode('","',$rest_cat_name).'")')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        // $restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $user->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $user->username)->select('category_id')->first();

        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $user->username)->whereBetween('rest_dates.date', [$startDate112, $endDate112])->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'id' => date('m', strtotime($item->date)),
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();
        $user = User::where('id', Auth::id())->first();
        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
         $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereBetween('date', [$startDate112, $endDate112])->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();

        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();

          
        $leaves11 = $restDay->merge($Array);
        $leaves12 = $leaves11->merge($pastArray);
        $leaves = $leaves12->merge($recentHoliday);
        //$leaves = $restDay->merge($Array);

        return $leaves;
    }

    public function holidayFilter11(Request $request) {
        $user = User::where('id', Auth::id())->first();

        $leaveArray = Leavelist::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename,leave_name.leave_color, CONCAT(leave_list.username, leave_list.start_date) as usergroup, leave_list.start_time,leave_list.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftjoin('map_employee_approver', 'map_employee_approver.employee_id', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('map_employee_approver.approver_id', $user->username)->where('leave_list.status', '1')->groupBy('usergroup')->orderBy('leave_list.date_applied', 'DESC');
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $type = $request->type;
        if ($type && $type != '') {
            $leaveArray->where('leave_list.type', $type);
        }

// 		if($request->name && $request->name != '' && $request->username == '')
// 		{
// 			$leaveArray->where(function($query){
// 				$query->where('user_personal.employee_no', request()->name)->orwhere('user_personal.username', request()->name)
// 			->orWhere('user_personal.name',  'like', '%'. request()->name .'%');
// 			});
// 		}
// 		if($request->username && $request->username != '')
// 		{
// 			$leaveArray->where(function($query){
// 				$query->orwhere('user_personal.username', request()->username);
// 			});
// 		}

        if ($request->name && $request->name != '' && $request->username == '') {

// 			$leaveArray->where(function($query){
            $leaveArray->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.username like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
// 			});
        }
        if ($request->username && $request->username != '') {

            $leaveArray->where(function($query) {
                $query->orwhere('user_personal.username', request()->username);
            });
        }


        if ($request->branch && $request->branch != '') {
            $branchId = UserPay::where('branch_id', $request->branch)->pluck('username')->toArray();
            $leaveArray->whereIn('user_personal.username', $branchId);
        }

        if ($request->department && $request->department != '') {
            $branchId = UserPay::where('department_id', $request->department)->pluck('username')->toArray();
            $leaveArray->whereIn('user_personal.username', $branchId);
        }

        if ($request->category && $request->category != '') {
            $branchId = UserPay::where('category_id', $request->category)->pluck('username')->toArray();
            $leaveArray->whereIn('leave_list.username', $branchId);
        }

        $Array = $leaveArray->get();

        if (count($Array) > 0) {

            $Array->transform(function ($item) {
                if ($item->leave_color != null) {
                    $item->background_color = $item->leave_color;
                } else {
                    $item->background_color = "#4298a1";
                }
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
                if ($item->type == 'Line_Shut') {
                    $iname = 'Out Of Office';
                    $colornm = "#4298a1";
                }
                if ($item->type == 'Other_pay') {
                    $iname = 'Replacement';
                    $colornm = "#000000";
                } else {
                    $iname = $item->type;
                }
                $employee = DB::table('user_personal')
                                ->where('username', $item->username)->first();
                $r_name = $employee->name;
                if($item->is_hourly!=0){ 
                   $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
                } else 
                { 
                    $time = ''; 
                }
                return [
                    'title' => $r_name . ' (' . $item->typename . ')' . $htype.' '.$time,
                    'text_color' => '#fff',
                    'start' => date('Y-m-d', strtotime($item->start_date)),
                    'type' => $item->type,
                    'color' => $item->background_color,
                ];
            })->toArray();
        }
        if ($request->name && $request->name != '' && $request->username == '') {
            $emplist = DB::table('user_personal')->whereRaw('(name like ("' . request()->name . '%") OR username like ("' . request()->name . '%") OR employee_no like ("' . request()->name . '%")) ')->first();
        } elseif ($request->username && $request->username != '') {
            $emplist = DB::table('user_personal')->where('username', $request->username)->first();
        } else {
            $emplist = DB::table('user_personal')->where('username', $user->username)->first();
        }

        // $restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $emplist->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $emplist->username)->select('category_id')->first();
        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();


        $blockDaybydept = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.department_id')->where('up.username', $emplist->username)->where('bd.is_department', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybycat = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.category_id')->where('up.username', $emplist->username)->where('bd.is_category', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybyuser = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.username')->where('up.username', $emplist->username)->where('bd.is_user', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybybranch = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.branch_id')->where('up.username', $emplist->username)->where('bd.is_branch', 1)->where('bd.block_date', '!=', '1970-01-01')->union($blockDaybydept)->union($blockDaybycat)->union($blockDaybyuser)->get();

        $blockDaybybranch->transform(function($item) {

            return [
                'title' => 'Block Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->block_date)),
                'text_color' => '#fff',
                'color' => '#FF8CD8',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $emplist->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereYear('date', '=', $request->year)->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();

        $leaves11 = $restDay->merge($Array);
        $leaves12 = $leaves11->merge($recentHoliday);
        $leaves = $leaves12->merge($blockDaybybranch);
        //$leaves = $restDay->merge($Array);
        //	\Log::info(json_encode($recentHoliday));
        return $leaves;
    }

    public function holidayFilter12(Request $request) {
        $user = User::where('id', Auth::id())->first();

        $leaveArray = Leavelist::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename,leave_name.leave_color, CONCAT(leave_list.username, leave_list.start_date) as usergroup, leave_list.start_time,leave_list.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftjoin('map_employee_approver', 'map_employee_approver.employee_id', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('leave_list.status', '1')->groupBy('usergroup')->orderBy('leave_list.date_applied', 'DESC');
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        if ($request->name && $request->name != '' && $request->username == '') {
            $leaveArray->where(function($query) {
                $query->whereRaw('(user_personal.name like ("' . request()->name . '%") OR user_personal.username like ("' . request()->name . '%") OR user_personal.employee_no like ("' . request()->name . '%")) ');
            });
        }
        if ($request->username && $request->username != '') {
            $leaveArray->where(function($query) {
                $query->where('user_personal.username', request()->username);
            });
        }

        $Array = $leaveArray->get();

        if (count($Array) > 0) {

            $Array->transform(function ($item) {
                if ($item->leave_color != null) {
                    $item->background_color = $item->leave_color;
                } else {
                    $item->background_color = "#4298a1";
                }
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
                if ($item->type == 'Line_Shut') {
                    $iname = 'Out Of Office';
                    $colornm = "#4298a1";
                }
                if ($item->type == 'Other_pay') {
                    $iname = 'Replacement';
                    $colornm = "#000000";
                } else {
                    $iname = $item->type;
                }
                $employee = DB::table('user_personal')
                                ->where('username', $item->username)->first();
                $r_name = $employee->name;
                if($item->is_hourly!=0){ 
                 $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
                } else 
                { 
                    $time = ''; 
                }
                return [
                    'title' => $r_name . ' (' . $item->typename . ')' . $htype. ' '. $time,
                    'text_color' => '#fff',
                    'start' => date('Y-m-d', strtotime($item->start_date)),
                    'type' => $item->type,
                    'color' => $item->background_color,
                ];
            })->toArray();
        }
        if ($request->name && $request->name != '' && $request->username == '') {
            $emplist = DB::table('user_personal')->whereRaw('(name like ("' . request()->name . '%") OR username like ("' . request()->name . '%") OR employee_no like ("' . request()->name . '%")) ')->first();
        } elseif ($request->username && $request->username != '') {
            $emplist = DB::table('user_personal')->where('username', $request->username)->first();
        } else {
            $emplist = DB::table('user_personal')->where('username', $user->username)->first();
        }

        // $restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $emplist->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $emplist->username)->select('category_id')->first();
        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }
        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();


        $blockDaybydept = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.department_id')->where('up.username', $emplist->username)->where('bd.is_department', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybycat = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.category_id')->where('up.username', $emplist->username)->where('bd.is_category', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybyuser = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.username')->where('up.username', $emplist->username)->where('bd.is_user', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybybranch = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.branch_id')->where('up.username', $emplist->username)->where('bd.is_branch', 1)->where('bd.block_date', '!=', '1970-01-01')->union($blockDaybydept)->union($blockDaybycat)->union($blockDaybyuser)->get();

        $blockDaybybranch->transform(function($item) {

            return [
                'title' => 'Block Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->block_date)),
                'text_color' => '#fff',
                'color' => '#FF8CD8',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $emplist->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereYear('date', '=', $request->year)->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();

        $leaves11 = $restDay->merge($Array);
        $leaves12 = $leaves11->merge($recentHoliday);
        $leaves = $leaves12->merge($blockDaybybranch);
        //$leaves = $restDay->merge($Array);
        //	\Log::info(json_encode($recentHoliday));
        return $leaves;
    }

    public function holidayFilter13(Request $request) {
        $user = User::where('id', Auth::id())->first();

        $leaveArray = Leavelist::selectRaw("leave_list.*, user_personal.*, leave_name.name as typename,leave_name.leave_color, CONCAT(leave_list.username, leave_list.start_date) as usergroup, leave_list.start_time, leave_list.end_time")->join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftjoin('map_employee_approver', 'map_employee_approver.employee_id', '=', 'leave_list.username')->leftjoin('leave_name', 'leave_name.type', '=', 'leave_list.type')->where('leave_list.status', '1')->groupBy('usergroup')->orderBy('leave_list.date_applied', 'DESC');
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();

        $leaveArray->where('user_personal.username', $user->username);

        $Array = $leaveArray->get();
        if (count($Array) > 0) {

            $Array->transform(function ($item) {
                if ($item->leave_color != null) {
                    $item->background_color = $item->leave_color;
                } else {
                    $item->background_color = "#4298a1";
                }
                if ($item->half_day_type == 'first') {
                    $htype = 'AM';
                } elseif ($item->half_day_type == 'second') {
                    $htype = 'PM';
                } else {
                    $htype = '';
                }
                if ($item->type == 'Line_Shut') {
                    $iname = 'Out Of Office';
                    $colornm = "#4298a1";
                }
                if ($item->type == 'Other_pay') {
                    $iname = 'Replacement';
                    $colornm = "#000000";
                } else {
                    $iname = $item->type;
                }
                $employee = DB::table('user_personal')
                                ->where('username', $item->username)->first();
                $r_name = $employee->name;
                if($item->is_hourly!=0){ 
                    $time = '('.date('h:i A',$item->start_time).' to '.date('h:i A',$item->end_time).')';
                    
                } else 
                { 
                    $time = ''; 
                }
                return [
                    'title' => $r_name . ' (' . $item->typename . ')' . $htype .' '.$time,
                    'text_color' => '#fff',
                    'start' => date('Y-m-d', strtotime($item->start_date)),
                    'type' => $item->type,
                    'color' => $item->background_color,
                ];
            })->toArray();
        }

        $emplist = DB::table('user_personal')->where('username', $user->username)->first();


        // $restDay = DB::table('rest_dates')->leftjoin('rest_days','rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category','rest_days.category_id','=','rest_day_category.id')->leftjoin('rest_day_category_employee','rest_day_category_employee.category_id','=','rest_day_category.id')->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();

        $rday = DB::table('rest_days')->where('employee_id', $emplist->username)->select('employee_id')->first();
        $recat = DB::table('rest_day_category_employee')->where('employee_id', $emplist->username)->select('category_id')->first();
        if ($rday != '') {

            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('rest_day_category', 'rest_days.category_id', '=', 'rest_day_category.id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username');
            if ($recat != '') {

                $restDay->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id')->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_days.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        } else {


            $restDay = DB::table('rest_dates')->leftjoin('rest_days', 'rest_days.id', '=', 'rest_dates.rest_day_id')->leftjoin('user_personal', 'rest_days.employee_id', '=', 'user_personal.username')->leftjoin('rest_day_category_employee', 'rest_days.category_id', '=', 'rest_day_category_employee.category_id');
            if ($recat != '') {

                $restDay->where('rest_days.category_id', $recat->category_id);
            }
            $restDay = $restDay->where('rest_day_category_employee.employee_id', $emplist->username)->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->groupBy('rest_dates.date')->get();
        }

        $restDay->transform(function($item) {

            return [
                'title' => 'Rest Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'text_color' => '#000',
                'color' => '#e0e0e0',
            ];
        })->toArray();


        $blockDaybydept = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.department_id')->where('up.username', $emplist->username)->where('bd.is_department', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybycat = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.category_id')->where('up.username', $emplist->username)->where('bd.is_category', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybyuser = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.username')->where('up.username', $emplist->username)->where('bd.is_user', 1)->where('bd.block_date', '!=', '1970-01-01');
        $blockDaybybranch = DB::table('block_dates as bd')->leftjoin('user_pay as up', 'bd.block_id', '=', 'up.branch_id')->where('up.username', $emplist->username)->where('bd.is_branch', 1)->where('bd.block_date', '!=', '1970-01-01')->union($blockDaybydept)->union($blockDaybycat)->union($blockDaybyuser)->get();

        $blockDaybybranch->transform(function($item) {

            return [
                'title' => 'Block Day',
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->block_date)),
                'text_color' => '#fff',
                'color' => '#FF8CD8',
            ];
        })->toArray();

        $userPay = DB::table('user_pay')->where('username', $emplist->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereYear('date', '=', $request->year)->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'text_color' => '#fff',
                'color' => '#28c76f',
            ];
        })->toArray();

        $leaves11 = $restDay->merge($Array);
        $leaves12 = $leaves11->merge($recentHoliday);
        $leaves = $leaves12->merge($blockDaybybranch);
        //$leaves = $restDay->merge($Array);
        //	\Log::info(json_encode($recentHoliday));
        return $leaves;
    }

    public function arrayPaginator($array, $request) {
        $page = $request->get('page') ?? 1;
        $perPage = 9;
        $offset = ($page * $perPage) - $perPage;
        $department = array_slice($array->toArray(), $offset, $perPage);
        $departments = new LengthAwarePaginator($department, count($array), $perPage, $page, [
            'path' => $request->url(),
            'query' => $request->query()
        ]);
        return $departments;
    }

    public function viewDocs($id) {
        $leave = Leavelist::find($id);

        $file_path = 'public/upload/' . $leave->filename;
        $fileContent = Storage::disk($this->storageDriver)->get($file_path);
        $fileName = basename($file_path);
        return response($fileContent)->header('Content-Type', '');
    }

    public function remainingDays(Request $request) {
        //$data = getLeavsCounts(Auth::user()->username,$request->type,$request->start_date,$request->end_date,$request->is_half_day,$request->action);
        $data = $this->getLeaveDaysCount(request());
        //dd($data);
        return Response::json($data, 200);
    }

    public function getLeaveDaysCount(Request $request) {
        $user = User::where('id', Auth::id())->first();
        // if(isset($request->username) && $request->username!=''){
        // 	$user = User::where('username' , $request->username)->first();	
        // }
        $type = isset($request->type) ? $request->type : '';
        if ($type != '') {
            $type1 = explode(":", $type);
            $type = $type1[0];
        }
        $half_day_type = isset($request->half_day_type) ? $request->half_day_type : '';
        $is_half_day = isset($request->is_half_day) ? $request->is_half_day : '0';
        $is_pastleave = isset($request->is_pastleave) ? $request->is_pastleave : '0';
        $username = (isset($request->username) ? $request->username : $user->username);
        $hourly = isset($request->hourly) ? $request->hourly : '0';
        $startHour = isset($request->startHour) ? $request->startHour : '0';
        $endHour = isset($request->endHour) ? $request->endHour : '0';
       
        if ($username == "") {
            return json_encode(array("result" => false, "msg" => "Please refresh your page, before add new leaves."));
            exit;
        }

        $year = date('Y', strtotime($request->start_date));
        $startDate = date('Y-m-d', strtotime($request->start_date));
        $endDate = date('Y-m-d', strtotime($request->end_date));
        $groups = DB::table('user_personal')->where('username', $username)->selectRaw("nationality, state")->first();
        $branch_cat_dept = DB::table('user_pay')->where('username', $username)->selectRaw("branch_id, department_id, category_id")->first();
        $holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0", $startDate, $endDate);

        $restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->start_date, $request->end_date, request());
        $blockdates = $this->getBlockAllDayslistByUserId($username, request());

        $appliedDays = $this->getLeaveDaysBetweenDates($username, $startDate, $endDate);
        $appliedPastDays = $this->getPastLeaveDaysBetweenDates($username, $startDate, $endDate);
        $pastLeaves = getTakenPastLeaves($username, $year);
        $date1 = add_date($startDate);
        $date2 = add_date($endDate);
        $dayCount = 0;
        for ($index = $date1; dateDifference($date2, $index) >= 0; $index = add_date($index, 1)) {
            $restday_allow_now = true;

            if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                if ($this->isRestDay($restdays, $index)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                if ($this->isHoliday($holidays, $index)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow && !$this->isLeaveAppliedDate($index, $appliedDays) && !$this->isLeaveAppliedDate($index, $appliedPastDays)) {
                $dayCount++;
            }
        }

        if ($is_half_day == '1') {
            $restday_allow_now = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                if ($this->isRestDay($restdays, $startDate)) {
                    $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                if ($this->isHoliday($holidays, $startDate)) {
                    $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if ($this->isHoliday($blockdates, $index)) {
                $blockdays_check_allow = false;
            }

            if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow) {

                // dd($this->isLeaveHalfDayAllow($username, $startDate, $startDate, $is_half_day, $half_day_type, 0),$this->isLeaveHalfDayAllow($username, $startDate, $startDate, $is_half_day, $half_day_type, 1));
                if ($this->isLeaveHalfDayAllow($username, $startDate, $startDate, $is_half_day, $half_day_type, 0) < 1 && $this->isLeaveHalfDayAllow($username, $startDate, $startDate, $is_half_day, $half_day_type, 1) != 0) {

                    $dayCount += 0.5;
                }
            }
        }
               
        if($hourly==1){
            $time_from = isset($request->time_from) ? $request->time_from : '';
            $time_for = isset($request->time_for) ? $request->time_for : '';
            $leavedate = $request->start_date . ' ' . $time_from;
            $startTime = strtotime($leavedate);
            $time_for = explode(":",$time_for);
            //$endTime11 = date("h:i A", strtotime('+'.$time_for[0].' hours +'.$time_for[1].'minutes', strtotime($time_from)));
            //$endTime = strtotime($request->leave_start_date . ' ' . $endTime11);
            $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate. ' + '.$time_for[0].' hours')));
            $restday_allow_now = true;
            if(!$this->checkHolidayRestDayInclusive($username,$type,'restday')){
                if($this->isRestDay($restdays, $startDate)){
                        $restday_allow_now = false;
                }
            }
            $holiday_check_allow = true;
            //echo " Holiday =  ".$this->checkHolidayRestDayInclusive($username,$type,'holiday');
            if(!$this->checkHolidayRestDayInclusive($username,$type,'holiday')){
                if($this->isHoliday($holidays, $startDate)){
                        $holiday_check_allow = false;
                }
            }

            $blockdays_check_allow = true;
            if($this->isHoliday($blockdates, $index)){
                $blockdays_check_allow = false;
            }

            if($restday_allow_now && $holiday_check_allow && $blockdays_check_allow)
            {
               if($this->isLeaveHourlyAllow($username, $startDate, $startTime, $endTime)==1){
                    $dayCount =  abs($endTime - $startTime)/(60*60);
                }
            }
        }
        
    	
		

        // if ($hourly != 0) {
        //     $restday_allow_now = true;
        //     if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
        //         if ($this->isRestDay($restdays, $startDate)) {
        //             $restday_allow_now = false;
        //         }
        //     }
        //     $holiday_check_allow = true;
        //     if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
        //         if ($this->isHoliday($holidays, $startDate)) {
        //             $holiday_check_allow = false;
        //         }
        //     }

        //     $blockdays_check_allow = true;
        //     if ($this->isHoliday($blockdates, $index)) {
        //         $blockdays_check_allow = false;
        //     }

        //     if ($restday_allow_now && $holiday_check_allow && $blockdays_check_allow) {
        //         if ($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave) < 1) {
        //             $dayCount = $endHour - $startHour;
        //         }
        //     }
        // }
        // if (!empty($request->no_of_hours)) {
        //   $chk = $this->isLeaveHoursAllow($username, $startDate, $endDate, 1, $half_day_type=0, $is_pastleave = 0);  
        //   if(empty($chk)){
        //       $dayCount = $request->no_of_hours;
        //   }
        // }
        
        
        //DB::table('leave_list')->where('username', $username)->selectRaw("nationality, state")->first();

        /*if (!empty($startDate) && !empty($endDate)) {
            $diff = strtotime($endDate) - strtotime($startDate);
            $dayCount = abs(round($diff / 86400));
            $dayCount = $dayCount + 1;
        }
        $chk = strlen((string) $dayCount);
        if ($chk < 3) {            
        } else {
            $dayCount = '';
        }
        if (!empty($request->no_of_hours)) {
            $dayCount = 1;
        }*/
        
        return array(
            "no_leave_days" => $dayCount,
            "holidays" => count($holidays),
            "restdays" => count($restdays),
            "blockdates" => count($blockdates),
            "applieddays" => count($appliedDays),
            "past_leaves" => $pastLeaves
        );
    }

    public function getPastLeaveDaysBetweenDates($username, $startDate, $endDate) {
        $query = "select start_date as date from leave_past where username='" . $username . "' and start_date='" . $startDate . "' and end_date='" . $endDate . "' ";
        $result = DB::select($query);
        return $result;
    }

    public function remainingDays11(Request $request) {
        //$data = getLeavsCounts($request->username,$request->type,$request->start_date,$request->end_date,$request->is_half_day,$request->action);
        $data = $this->getLeaveDaysCount(request());
        // dd($data);
        return Response::json($data, 200);
    }

    public function applySelfLeave11(Request $request) {
        $file = $request->file('slip_file');
        $endFileName = '';
        $replacement = '';
        if (!empty($file)) {

            $file = $request->file('slip_file');
            $extension = $file->getClientOriginalExtension();
            $endFileName = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
            $filePath = 'public/upload/';

            try {
                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
                
            }
        }
        if ($request->type == "Other_pay") {
            if ($request->no_of_day > $request->rlpending) {
                $replacement = 0;
            } else {
                $replacement = 1;
            }
        } else {
            $replacement = 0;
        }
        if ($request->hof == 1) {
            $half_day_type = $request->half_day_type;
            $edate = $request->leave_start_date;
        } else {
            $half_day_type = '';
            $edate = $request->leave_end_date;
        }
        foreach (explode(':', $request->leave_type) as $type) {
            $leavetype = $type;
            break 1;
        }
        $data = applysleave(Auth::user()->username, $leavetype, $request->approver_id, $request->leave_start_date, $edate, $request->hof, $half_day_type, $request->no_of_day, $request->reason, $replacement, $endFileName, $request->relieve);

        $data11 = json_decode($data);
        if ($data11->result == true) {
            Session::put('flash_message_success', 'Leave Applied Sucessfully !');
        }
        return Response::json(json_decode($data), 200);
    }

    public function applyonbehalf(Request $request) {
        $file = $request->file('slip_file');
        $endFileName = '';
        if (!empty($file)) {

            $file = $request->file('slip_file');
            $extension = $file->getClientOriginalExtension();
            $endFileName = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
            $filePath = 'public/upload/';

            try {
                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
            } catch (\Exception $e) {
                
            }
        }
        if ($request->hof == 1) {
            $half_day_type = $request->half_day_type;
            $edate = $request->leave_start_date;
        } else {
            $half_day_type = '';
            $edate = $request->leave_end_date;
        }
        foreach (explode(':', $request->leave_type) as $type) {
            $leavetype = $type;
            break 1;
        }
        $data = applyonbehalf($request->username, Auth::user()->username, $leavetype, $request->leave_start_date, $edate, $request->hof, $half_day_type, $request->no_of_day, $request->reason, $request->status, $endFileName, $request->relieve, "addLeaveByApprover11");

        //\Log::info(json_encode($data));
        return Response::json(json_decode($data), 200);
    }

    public function viewallholidays() {

        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('E-Leave/all-publicholidays', compact('userPay'));
    }

    public function getholidaysdata(Request $request) {
        $user = User::where('id', Auth::id())->first();
        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        if ($request->get('year') != '') {
            $year = $request->get('year');
        } else {
            $year = date('Y');
        }
        $recentHoliday = DB::table('public_holiday')->selectRaw("public_holiday.date as sdate, public_holiday.date as date, public_holiday.description as description, GROUP_CONCAT(DISTINCT state) as state, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                        ->whereYear('date', $year)->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")')->groupBy('date_holiday')->get();
        $recentHoliday->map(function($item, $index) {

            $index++;
            $item->no = $index;
            $item->hdate = date('d-m-Y', strtotime($item->date));
            $item->day = date('D', strtotime($item->date));
            return $item;
        });
        return DataTables::of($recentHoliday)->make(true);
    }

    public function getLeave($id) {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;
        $user = User::where('id', Auth::id())->first();

        $leave = LeaveList::join('user_personal', 'user_personal.username', '=', 'leave_list.username')->leftJoin('leave_days', 'leave_list.id', '=', 'leave_days.leave_id')->select('leave_list.*', 'leave_days.leave_id', 'leave_days.date', 'leave_days.cancellation_reason', 'leave_days.reject_reason', 'user_personal.name', 'leave_days.id as lid')->find($id);
        $approvers = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->leftjoin('user_personal as c', 'a.employee_id', '=', 'c.username')->leftjoin('user_pay as up', 'c.username', '=', 'up.username')->where('approval', '>', '0');
        if ($ActiveUserShownStatus == '1') {
            $approvers->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
        } else {
            $approvers->where('up.pay_status', 1);
        }

        $leave['approvers'] = $approvers->where('c.isDeleted', '0')->orderBy('c.name')->get();

        $leave['leaveTypes'] = Leavetype::where('company_id', $user->company_id)->orderBy('name')->where('is_show', 1)->get();

        return $leave;
    }

    public function getRlLeave($id) {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value ?? 0;

        $leave = DB::table('rl_leaves')->where('id', $id)->first();
        $approvers = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->leftjoin('user_personal as c', 'a.employee_id', '=', 'c.username')->leftjoin('user_pay as up', 'c.username', '=', 'up.username')->where('approval', '>', '0');
        if ($ActiveUserShownStatus == '1') {
            $approvers->whereRaw("(up.pay_status = '1' or up.pay_status = '0')");
        } else {
            $approvers->where('up.pay_status', 1);
        }

        $leave->approvers = $approvers->where('c.isDeleted', '0')->orderBy('c.name')->get();


        return $leave;
    }

    public function applySelfLeave(Request $request) {
        //dd(env('FILE_UPLOAD_PREFIX'));
       // $date = date('Y-m-d h:i A');;
//         $gmdate = gmdate('Y-m-d h:i A');
//          $ddate =date_default_timezone_get();
//   $date = new DateTime();
// $timeZone = $date->getTimezone();
//   $leavedate = $request->leave_start_date . ' ' . date('h:i:s',strtotime($request->time_from)). ' UTC (+00:00)';
// $leavedatestr = strtotime($leavedate);
//         dd($leavedate,$date,$gmdate,$timeZone->getName(),$ddate);
        $data = $this->applysleave(request());

        $data11 = $data;

        if ($data11['result'] == true) {

            foreach (explode(':', $request->leave_type) as $types) {
                $leavetype = $types;
                break 1;
            }

            // $audit = new LeaveAudit;
            // $audit->leave_id = $data11->id ?? NULL;
            // $audit->admin_id = $request->approver_id ?? NULL;
            // $audit->leave_from = $leavetype ?? NULL;
            // $audit->reason_from = $request->reason ?? NULL;
            // $audit->status_from = 0 ?? NULL;
            // $audit->emp_id = getUserNameByRowId($request->user_id) ?? NULL;
            // $audit->leave_list_raw = NULL;
            // $audit->save(); 

            Session::put('flash_message_success', 'Leave Applied Sucessfully !');
        }
        return Response::json($data11, 200);
    }

    public function applysleave(Request $request) {
        try {

            // DB::table('leave_list')->where('leave_category', 'Emergency')->count();

            $getLeaveMultipleApprover = DB::table('settings')->where('field', 'leave_multiple_approver')->first();
            $LeaveMultipleApprover = $getLeaveMultipleApprover->value ?? 0;
            $user = User::where('id', Auth::id())->first();
            $username = ($request->username ? $request->username : $user->username);

            if ($username == "") {
                echo json_encode(array("result" => false, "msg" => "Please refresh your page, before add new leaves."));
                exit;
            }

            $file = $request->file('slip_file');
            $endFileName = '';
            $replacement = '';
            if (!empty($file)) {

                $file = $request->file('slip_file');
                $extension = $file->getClientOriginalExtension();
                $endFileName = env('FILE_UPLOAD_PREFIX') . rand(111111111, 99999999999) . '.' . $extension;
                //	dd($endFileName);
                $filePath = 'public/upload/';

                try {
                    Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
                } catch (\Exception $e) {
                    
                }
            }
            if ($request->type == "Other_pay") {
                if ($request->no_of_day > $request->rlpending) {
                    $replacement = 0;
                } else {
                    $replacement = 1;
                }
            } else {
                $replacement = 0;
            }
            $time_from = '';
            $time_for = '';
            $no_of_hours = '';
            $is_hourly = '';
            
            $startTime = '';
            $endTime = '';
            if ($request->hof == 1) {
                $half_day_type1 = $request->half_day_type;
                $edate = $request->leave_start_date;
            } elseif ($request->hof == 2) {
                $half_day_type1 = '';
                $is_hourly = 1;
                $time_from = $request->time_from;
                $time_for = $request->time_for;
                $no_of_hours = $request->time_for;
                $noDays = 0;
                if (!empty($request->leave_start_date)) {
                   $leavedate = $request->leave_start_date . ' ' . $time_from;
                    $startTime = strtotime($leavedate);
                    $time_for = explode(":",$time_for);
                    $endTime = strtotime(date('Y-m-d H:i:s', strtotime($leavedate. ' + '.$time_for[0].' hours')));
        
                }
                if (!empty($request->leave_end_date)) {
                    $edate = $request->leave_end_date;
                } else {
                    
                    $edate = $request->leave_start_date;
                }
            } else {
                $half_day_type1 = '';
                if (!empty($request->leave_end_date)) {
                    $edate = $request->leave_end_date;
                } else {
                    $edate = $request->leave_start_date;
                }
            }
            foreach (explode(':', $request->leave_type) as $types) {
                $leavetype = $types;
                break 1;
            }

            $approverId = $request->approver_id;
            $type = $leavetype;

            $half_day_type = ($half_day_type1 != "") ? $half_day_type1 : "";
            $isHalfDay = $request->hof;
            
            $startTime = ($startTime != "") ? $startTime : "";
            $endTime = ($endTime != "") ? $endTime : "";
            $noDays = $request->no_days;

            $startDate = date('Y-m-d', strtotime($request->leave_start_date));
            $year = date('Y', strtotime($request->leave_start_date));
            $endDate = date('Y-m-d', strtotime($edate));
            
            $reason = $request->reason;
            $isReplacement = $replacement;
            $filename = $endFileName;
            $Relieve = $request->relieve ?? '';


            $D_year = date('Y', strtotime($request->leave_start_date));

            $RL_id = array();
            if ($isReplacement == "1") {
                if ($isHalfDay == '1') {
                    $RL_id[0] = markReplacementLeaveAsTaken($username, $D_year);
                } else {
                    for ($_rl_i = 0; $_rl_i < ($noDays * 2); $_rl_i++) {
                        $RL_id[$_rl_i] = markReplacementLeaveAsTaken($username, $D_year);
                    }
                }
            }

            $groups = $this->getCountryState($username);
            $branch_cat_dept = $this->getUserGroups($username);

            $holidays = $this->getPublicHolidays("", "", $branch_cat_dept->branch_id, "0");
            $restdays = $this->getRestDaysOfEmployeeBetweenDates($username, $request->leave_start_date, $request->leave_end_date);
            $appliedDays = $this->getLeaveDaysBetweenDates($username, $startDate, $endDate);
            $date1 = $this->add_date($startDate);
            $date2 = $this->add_date($endDate);
            $category = "Normal";
            $_added_one_at_least = false;
            $conditional_msg = "";

            $allow_adding_leave = true;
            $medical_leave_compulsory1 = DB::table('settings')->where('field', 'medial_leave_compulsory')->first();
            $medical_leave_compulsory = $medical_leave_compulsory1->value ?? 0;
            if ($type == "Medical" && $filename == "" && $medical_leave_compulsory) {
                $allow_adding_leave = false;
                $conditional_msg = "Please upload slip also.";
            }

           
            $blockdates = $this->getBlockAllDayslistByUserId($username);
            if ($allow_adding_leave) {

                for ($index = $date1; $this->dateDifference($date2, $index) >= 0; $index = $this->add_date($index, 1)) {
                    
                    $emergencyDuration1 = DB::table('settings')->where('field', 'emergency_day')->first();
                    $emergencyDuration = $emergencyDuration1->value ?? 0;
                    $emergencyLeaves1 = DB::table('settings')->where('field', 'emergency_day_acess')->first();
                    $emergencyLeaves = $emergencyLeaves1->value ?? 0;
                    $emergencyTaken = $this->getEmergencyLeaveCount($username);
                    //print_r($_POST);die;
                    $today = $this->add_date(date('Y-m-d', strtotime('today')));
                    if ($type == 'Annual') {
                        $category = "Normal";
                    }

                    $noDays = "1";
                    if ($isHalfDay == "1")
                        $noDays = "0.5";

                    $add_allow = false;
                    
                    if ($isHalfDay == '1') {
                        if ($this->isLeaveHalfDayAllow($username, $startDate, $endDate, $isHalfDay, $half_day_type) < 1) {
                            $add_allow = true;
                        } else {
                            $add_allow = false;
                        }
                    } elseif($is_hourly == '1'){
                        if($this->isLeaveHourlyAllow($username, $startDate, $startTime, $endTime)){
                            $add_allow = true;
                        }else{
                            $add_allow = false;
                        }
                    } else {
                        if (!$this->isLeaveAppliedDate($index, $appliedDays)) {
                            $add_allow = true;
                        } else {
                            $add_allow = false;
                        }
                        // if (!empty($request->no_of_hours)) {
                        //     $chk = $this->isLeaveHoursAllow($username, $startDate, $endDate, 1, $half_day_type=0, $is_pastleave = 0);  
                        //     if(empty($chk)){
                        //         $add_allow = true;
                        //     }else {
                        //     $add_allow = false;
                        //     }
                        // }
                    }

                    $restday_allow_now = true;
                    if (!$this->checkHolidayRestDayInclusive($username, $type, 'restday')) {
                        if ($this->isRestDay($restdays, $index)) {
                            $restday_allow_now = false;
                        }
                    }
                    $holiday_check_allow = true;
                    if (!$this->checkHolidayRestDayInclusive($username, $type, 'holiday')) {
                        if ($this->isHoliday($holidays, $index)) {
                            $holiday_check_allow = false;
                        }
                    }

                    $blockdays_check_allow = true;
                    if ($this->isHoliday($blockdates, $index)) {
                        $blockdays_check_allow = false;
                    }

                    //print_r($add_allow);die;
                    if ($restday_allow_now && $holiday_check_allow && $add_allow && $blockdays_check_allow) {

                        $leaveId = $this->addLeave(
                                $username,
                                $approverId,
                                $type,
                                $is_hourly,
                                $isHalfDay,
                                $startTime,
                                $endTime,
                                $index,
                                $index,
                                $noDays,
                                $reason,
                                $half_day_type,
                                $category,
                                $filename,
                                $Relieve,
                                $no_of_hours
                        );
                        \Log::info('After--' . $leaveId);
                        \Log::info($leaveId);
                        $this->addLeaveDays($leaveId, $username, $index);
                        $_added_one_at_least = true;

                        if ($LeaveMultipleApprover == '3' || $LeaveMultipleApprover == '4') {
                            $masterApprover = $this->getApproversOfEmployee($username);
                            if (count($masterApprover) > 0) {
                                foreach ($masterApprover as $appr_row) {
                                    $this->add_leave_approver($leaveId, $appr_row->username);
                                }
                            }
                        }
                    } elseif (!$restday_allow_now) {
                        $conditional_msg = "Selected Date is a Rest Day.";
                    } elseif (!$holiday_check_allow) {
                        $conditional_msg = "Selected Date is a Holiday.";
                    } elseif (!$blockdays_check_allow) {
                        $conditional_msg = "Selected Date is a block day.";
                    }
                }
            }

            if ($Relieve != '') {
                $uname = UserPersonal::where('username', $Relieve)->first();
                $approver_name = $uname->name;
                $names = UserPersonal::where('username', $username)->first();
                $name = $names->name;
                $referer1 = str_replace('self-leaves', 'dashboard', url()->current());
                $referer = str_replace('apply-self-leave', '', $referer1);
                $subject = "Employee " . $name . " applied for leave";
                $body = "Dear $approver_name, <br><br>";

                $type_display = $this->getLeaveNameByType($type);

                if ($isHalfDay == '1') {
                    $half_day_type_display = ($request->half_day_type != "first") ? "PM" : "AM";
                    $body .= "$name applied " . $type . " Leave half day " . $half_day_type_display . " from " . date('d-m-Y', strtotime($startDate)) . " to " . date('d-m-Y', strtotime($startDate)) . "<br/><br/><br/>";
                }elseif($is_hourly==1){
                    $startTime =  date("h:i A", $startTime);
                    $endTime = date("h:i A", $endTime);
                    $body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                    $hr_body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                }  else {
                    $body .= "$name applied " . $type . " Leave from " . date('d-m-Y', strtotime($startDate)) . " to " . date('d-m-Y', strtotime($endDate)) . "<br/><br/><br/>";
                }

                $body .= "Link: <a href='$referer'>$referer</a>";

                $email_send_allow = true;
                $sendbypreference1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->first();
                $sendbypreference = $sendbypreference1->value ?? 0;
                if ($sendbypreference) {
                    if (!$this->hasContentPreference($username)) {
                        $email_send_allow = true;
                    } else {
                        $email_send_allow = false;
                    }
                }

                if ($email_send_allow) {
                    $semail = UserPersonal::where('username', $Relieve)->first();

                    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                    sendemail($semail->email_id, $subject, $body);

                    //Email::sendEmailToUserFromServer($approverId, $subject, $body);
                }
            }
        
            if ($_added_one_at_least) {

                $uname = UserPersonal::where('username', $username)->first();
                $name = $uname->name;
                $emp_id = $user->username;
                $referer1 = str_replace('self-leaves', 'dashboard', url()->current());
                $referer = str_replace('apply-self-leave', '', $referer1);

                $startDate = date('d F Y', strtotime($request->leave_start_date));
                $endDate = date('d F Y', strtotime($request->leave_end_date));
                $subject = "Employee " . $name . " applied for leave";


                if ($LeaveMultipleApprover == '2' || $LeaveMultipleApprover == '3' || $LeaveMultipleApprover == '4') {
                    $masterApprover = $this->getApproversOfEmployee($username);
                    if (count($masterApprover) > 0) {
                        foreach ($masterApprover as $appr_row) {
                            $approver_name = $appr_row->name;
                            $body = "Dear $approver_name, <br><br>";
                            $hr_body = "Dear $approver_name, <br><br>";
                            ;

                            $type_display = $this->getLeaveNameByType($type);

                            if ($isHalfDay == '1') {
                                $half_day_type_display = ($request->half_day_type != "first") ? "PM" : "AM";
                                $body .= "$name applied " . $type . " Leave half day " . $half_day_type_display . " from $startDate to $startDate<br/><br/><br/>";
                                $hr_body .= "$name applied " . $type . " Leave half day " . $half_day_type_display . " from $startDate to $startDate<br/><br/><br/>";
                            } elseif($is_hourly==1){
                                $startTime =  date("h:i A", $startTime);
                                $endTime = date("h:i A", $endTime);
                                $body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                                $hr_body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                            } else {
                                $body .= "$name applied " . $type . " Leave from $startDate to $endDate<br/><br/><br/>";
                                $hr_body .= "$name applied " . $type . " Leave from $startDate to $endDate<br/><br/><br/>";
                            }

                            $body .= "Link: <a href='$referer'>$referer</a>";

                            $email_send_allow = true;
                            $sendbypreference1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->first();
                            $sendbypreference = $sendbypreference1->value ?? 0;
                            if ($sendbypreference) {
                                if (!$this->hasContentPreference($username)) {
                                    $email_send_allow = true;
                                } else {
                                    $email_send_allow = false;
                                }
                            }

                            if ($email_send_allow) {
                                $semail = UserPersonal::where('username', $appr_row->username)->first();

                                //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                                sendemail($semail->email_id, $subject, $body);
                            }

                            $HR_APPLY_EMAIL1 = DB::table('settings')->where('field', 'hr_apply_leave_email')->first();
                            $HR_APPLY_EMAIL = $HR_APPLY_EMAIL1->value ?? 0;
                            if ($HR_APPLY_EMAIL != "") {
                                //Mail::to($HR_APPLY_EMAIL)->send(new MyDemoMail($hr_body,$subject));
                                sendemail($HR_APPLY_EMAIL, $subject, $hr_body);

                                //Email::sendEmailToUserFromServer($HR_APPLY_EMAIL, $subject, $hr_body);
                            }
                        }
                    }
                } else {
                    $uname = UserPersonal::where('username', $approverId)->first();
                    $approver_name = $uname->name;
                    $names = UserPersonal::where('username', $username)->first();
                    $name = $names->name;
                    $body = "Dear $approver_name, <br><br>";
                    $hr_body = "Dear $approver_name, <br><br>";
                    ;
                    $referer2 = str_replace('self-leaves', 'dashboard', url()->current());
                    $referer3 = str_replace('apply-self-leave', 'e-leave/approval-dashboard', $referer2);
                    $type_display = $this->getLeaveNameByType($type);

                    if ($isHalfDay == '1') {
                        $half_day_type_display = ($request->half_day_type != "first") ? "PM" : "AM";
                        $body .= "$name applied " . $type . " Leave half day " . $half_day_type_display . " from $startDate to $startDate<br/><br/><br/>";
                        $hr_body .= "$name applied " . $type . " Leave half day " . $half_day_type_display . " from $startDate to $startDate<br/><br/><br/>";
                    } elseif($is_hourly==1){
                        $startTime =  date("h:i A", $startTime);
                        $endTime = date("h:i A", $endTime);
                        $body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                        $hr_body .= "$name applied " . $type ." from $startDate Time ($startTime to $endTime) <br/><br/><br/>";
                    } else {
                        $body .= "$name applied " . $type . " Leave from $startDate to $endDate<br/><br/><br/>";
                        $hr_body .= "$name applied " . $type . " Leave from $startDate to $endDate<br/><br/><br/>";
                    }

                    $body .= "Link: <a href='$referer3'>$referer3</a>";

                    $email_send_allow = true;
                    $sendbypreference1 = DB::table('settings')->where('field', 'email_send_by_preferneces')->first();
                    $sendbypreference = $sendbypreference1->value ?? 0;
                    if ($sendbypreference) {
                        if (!$this->hasContentPreference($username)) {
                            $email_send_allow = true;
                        } else {
                            $email_send_allow = false;
                        }
                    }

                    if ($email_send_allow) {
                        $semail = UserPersonal::where('username', $approverId)->first();

                        //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
                        sendemail($semail->email_id, $subject, $body);

                        //Email::sendEmailToUserFromServer($approverId, $subject, $body);
                    }

                    $HR_APPLY_EMAIL1 = DB::table('settings')->where('field', 'hr_apply_leave_email')->first();
                    $HR_APPLY_EMAIL = '';
                    if (!empty($HR_APPLY_EMAIL1))
                        $HR_APPLY_EMAIL = $HR_APPLY_EMAIL1->value ?? 0;

                    if ($HR_APPLY_EMAIL != "") {

                        //Mail::to($HR_APPLY_EMAIL)->send(new MyDemoMail($hr_body,$subject));

                        sendemail($HR_APPLY_EMAIL, $hr_body, $body);

                        //Email::sendEmailToUserFromServer($HR_APPLY_EMAIL, $subject, $hr_body);
                    }
                }

                $this->sendEmailNow();

                $leave_array = array();
                $leave_array['name'] = $name;
                $leave_array['startDate'] = $startDate;
                $leave_array['endDate'] = $endDate;
                $leave_array['type_display'] = $type_display;
                $leave_array['half_day_type'] = $request->half_day_type;
                $leave_array['isHalfDay'] = $isHalfDay;


                if ($email_send_allow) {
                    $this->sendEmailToBackupUsers($username, $leave_array);
                }
                $this->addLeaveEntitleHistory($username, $year, $type);
                return array(
                    'result' => true
                );
                //echo json_encode(array("result" => TRUE));
            } else {
                return array(
                    'result' => false,
                    'msg' => $conditional_msg
                );
                //echo json_encode(array("result" => false, "msg" => $conditional_msg));
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function getCountryState($username) {

        $result1 = UserPersonal::where('username', $username)->selectRaw("nationality, state")->first();
        $result = $result1;
        return $result;
    }

    public function getUserGroups($username) {

        $result1 = UserPay::where('username', $username)->selectRaw("branch_id, department_id, category_id")->first();
        $result = $result1;
        return $result;
    }

    public function getPublicHolidays($country, $state, $branchId, $year, $startDate = "", $endDate = "") {
        $result = PublicHoliday::where('id', '>', '0');
        if ($country != "")
            $result->where('country', $country);
        if ($state != "")
            $result->where('state', $state);
        if ($branchId != "0")
            $result->whereRaw("(branch_id = '$branchId' or branch_id='0')");
        if ($year != "0" && $year != "")
            $result->whereYear('date', $year);
        if ($startDate != "")
            $result->where('date', '>=', $startDate);
        if ($endDate != "")
            $result->where('date', '<=', $endDate);
        $result = $result->selectRaw("distinct id, date, day(date) as day, month(date) as month, year(date) as year, state, country, description")->groupByRaw('date, description')->orderBy('date')->get();
        return $result;
    }

    public function getRestDaysOfEmployeeBetweenDates($employeeId, $startDate, $endDate) {

        $user = DB::table('rest_days')->where('employee_id', $employeeId)->selectRaw("employee_id")->get();


        $recat = DB::table('rest_day_category_employee')->where('employee_id', $employeeId)->select('category_id')->first();

        if (count($user) > 0) {
            //dd("hello");
            $result1 = DB::table('rest_dates as a')->leftjoin('rest_days as b', 'b.id', '=', 'a.rest_day_id');
            if ($recat != '') {

                $result1->leftjoin('rest_day_category_employee', 'b.category_id', '=', 'rest_day_category_employee.category_id')->where('b.category_id', $recat->category_id);
            }
            $result1 = $result1->where('b.employee_id', $employeeId)->whereBetween('a.date', [$startDate, $endDate])->selectRaw("a.rest_day_id, a.date")->get();

            $result = $result1;
            return $result;
        } else {
            //dd("hello1");
            $result1 = DB::table('rest_dates as a')->leftjoin('rest_days as b', 'b.id', '=', 'a.rest_day_id')->leftjoin('rest_day_category_employee as c', 'b.category_id', '=', 'c.category_id');
            if ($recat != '') {

                $result1->where('b.category_id', $recat->category_id);
            }
            $result1 = $result1->where('c.employee_id', $employeeId)->whereBetween('a.date', [$startDate, $endDate])->selectRaw("a.rest_day_id, a.date")->get();
            $result = $result1;
            return $result;
        }
    }

    public function getLeaveDaysBetweenDates($username, $startDate, $endDate) {
        $result1 = DB::table('leave_days')->where('username', $username)->where('date', '>=', $startDate)->where('date', '<=', $endDate)->whereRaw("(status='1' OR status='0')")->selectRaw("date")->get();
        $result = $result1;
        if(empty($result)){
            return 0;
        }
        return $result;
    }

    public function add_date($givendate, $day = 0, $mth = 0, $yr = 0) {
        $cd = strtotime($givendate);
        $newdate = date('Y-m-d', mktime(date('h', $cd),
                        date('i', $cd), date('s', $cd), date('m', $cd) + $mth,
                        date('d', $cd) + $day, date('Y', $cd) + $yr));
        return $newdate;
    }

    public function dateDifference($startDate, $endDate) {
        $startDate = strtotime($startDate);
        $endDate = strtotime($endDate);
        return $startDate - $endDate;
    }

    public function getBlockAllDayslistByUserId($username) {


        //branch based for user
        $query = "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.branch_id where up.username='$username' and bd.is_branch='1'";
        $query .= " and bd.block_date!='1970-01-01' ";

        $query .= " union ";

        //user based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.username where up.username='$username' and bd.is_user='1'";
        $query .= " and bd.block_date!='1970-01-01' ";

        $query .= " union ";

        //category based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.category_id where up.username='$username' and bd.is_category='1'";
        $query .= " and bd.block_date!='1970-01-01' ";

        $query .= " union ";

        //department based for user
        $query .= "select bd.block_date as date from block_dates bd ";
        $query .= "left join user_pay up on bd.block_id=up.department_id where up.username='$username' and bd.is_department='1'";
        $query .= " and bd.block_date!='1970-01-01' ";

        $builder = DB::select($query);
        $result = $builder;
        return $result;
    }

    public static function getEmergencyLeaveCount($username) {
        $result1 = DB::table('leave_list')->where('leave_category', 'Emergency')->count();
        $result = $result1;
        return $result;
    }
    
     public function isLeaveHourlyAllow($username, $startDate, $startHour, $endHour)
	{
            $result = Leavelist::where('username',$username)->where('start_date',$startDate)->where('end_date',$startDate)->whereRaw("(status='1' OR status='0')")->where('is_hourly',0)->count('id');
            $allow = '1';
            if($result>0){
                $allow = '0';
            }
            if($allow=='1'){
                
                $result = Leavelist::where('username',$username)->where('start_date',$startDate)->where('end_date','<=',$startDate)->whereRaw("(status='1' OR status='0')")->whereRaw("(( start_time BETWEEN '".$startHour."' and '".$endHour."')  OR (end_time BETWEEN '".$startHour."' and '".$endHour."'))")->get();
                for($i=0;$i<count($result);$i++){
                    $allow = '0';
                }
            }
            
            return $allow;
	}
    
//     public function isLeaveHoursAllow($username, $startDate, $endDate, $is_hourly, $half_day_type = 0, $is_pastleave = 0) {
//         if ($is_pastleave == '1') {
// // 			$query = "select start_date as date from leave_past where username='$username' and start_date='$startDate' and end_date='$endDate' and half_day_type='$half_day_type' ";
// // 			$val1 = DB::select($query);
//             $result = DB::table('leave_past')->where('username', $username)->where('start_date', $startDate)->where('end_date', $endDate);
//             $result = $result->selectRaw("start_date as date, total_leave_days,half_day_type")->get();
//             //dd($is_half_day);
//             $not_allow = 1;
//             for ($i = 0; $i < count($result); $i++) {
//                 // if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
//                 if ($result[$i]->is_hourly = 1) {
//                     $not_allow = 1;
//                 } else {
//                     $not_allow = 0;
//                 }
//                 break;
//                 // }
//             }
//             $val = $not_allow;
//             //	dd($result);
//         } else {
//             $result = DB::table('leave_list')->where('username', $username)->where('start_date', $startDate)->whereRaw("(status='1' OR status='0')")->get();
//             $not_allow = 0;
//             for ($i = 0; $i < count($result); $i++) {
                
//                 if($result[$i]->is_hourly==1){
//                     $not_allow = $not_allow + $result[$i]->no_of_hours;
                
//                     if($not_allow < 1.0){
//                         $not_allow11 = 0;
//                         if($not_allow > $result[$i]->no_of_hours){
//                             $not_allow = 0;
//                         }else{
//                              $not_allow = 1;
//                              break;
//                         }
                        
//                     }else{
//                         $not_allow = 1;
//                         break; 
//                     }
//                 }
                    
            
//             }
//             $val = $not_allow;
//         }
//         return (int) $val;
//     }

    public function isLeaveHalfDayAllow($username, $startDate, $endDate, $is_half_day, $half_day_type, $is_pastleave = 0) {

        if ($is_pastleave == '1') {
// 			$query = "select start_date as date from leave_past where username='$username' and start_date='$startDate' and end_date='$endDate' and half_day_type='$half_day_type' ";
// 			$val1 = DB::select($query);
            $result = DB::table('leave_past')->where('username', $username)->where('start_date', $startDate)->where('end_date', $endDate);

            $result = $result->selectRaw("start_date as date, total_leave_days,half_day_type")->get();

            //dd($is_half_day);
            $not_allow = 1;
            for ($i = 0; $i < count($result); $i++) {
                // if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
                if ($result[$i]->total_leave_days == '0.5' && $result[$i]->half_day_type != $half_day_type) {
                    $not_allow = 1;
                } else {
                    $not_allow = 0;
                }
                break;
                // }
            }

            $val = $not_allow;
            //	dd($result);
        } else {
// 			$query = "select * from leave_list where username='$username' and start_date='$startDate' and end_date<='$endDate' and half_day_type='$half_day_type'  and (status='1' OR status='0')  ";
// 			//dd($query);
// 			$result1 = DB::select($query);
            $result = DB::table('leave_list')->where('username', $username)->where('start_date', $startDate)->where('end_date', '<=', $endDate)->where('half_day_type', $half_day_type)->whereRaw("(status='1' OR status='0')")->get();
            //dd(count($result));
            $not_allow = 0;
            for ($i = 0; $i < count($result); $i++) {
                // if($result[$i]->is_half_day=='1' && $result[$i]->half_day_type == $half_day_type){
                $not_allow = 1;
                break;
                // }
            }

            $val = $not_allow;
        }

        return (int) $val;
    }

    public function isLeaveAppliedDate($date, $appliedDays) {
        for ($i = 0; $i < count($appliedDays); $i++) {
            if ($appliedDays[$i]->date == $date) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function isHoliday($holidays, $day) {
        for ($i = 0; $i < count($holidays); $i++) {
            if ($holidays[$i]->date == $day) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function isRestDay($restdays, $day) {
        for ($i = 0; $i < count($restdays); $i++) {
            if ($restdays[$i]->date == $day) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function checkHolidayRestDayInclusive($username, $type, $restday_or_holiday_check = 'restday') {
        $result = false;

        if ($type != 'Annual' && $type != 'Absent' && $type != 'NPL') {
            $categoryId = $this->getUserCategory($username);
            $HolidayRestDayInclusiveArray = $this->getHolidayRestDayInclusive($type, $categoryId);

            if (!empty($HolidayRestDayInclusiveArray)) {
                if ($restday_or_holiday_check == 'restday') {
                    if ($HolidayRestDayInclusiveArray->restday_added == '1') {
                        $result = true;
                    } else {
                        $result = false;
                    }
                } else {
                    if ($HolidayRestDayInclusiveArray->holiday_added == '1') {
                        $result = true;
                    } else {
                        $result = false;
                    }
                }
            } else {
                $result = false;
            }
        } else {
            $result = false;
        }
        return $result;
    }

    public function getUserCategory($username) {
        $builder = DB::table('user_category')->where('username', $username)->first();
        $result = $builder->category;
        return $result;
    }

    public function getHolidayRestDayInclusive($leave_type, $category) {

        $result1 = DB::table('holiday_restday_inleave_setting')->selectRaw('`restday_added`,`holiday_added`')->where('leave_type', $leave_type)->where('category', $category)->first();
        $result = $result1;
        return $result;
    }

    public function addLeave($username, $approverId, $type, $is_hourly = '', $isHalfDay = '', $startTime, $endTime, $startDate, $endDate, $noDays, $reason, $half_day_type, $leaveCategory = "Normal", $filename = '', $Relieve = '', $no_of_hours = '') {
        //\Log::info($username);
        $data = new Leavelist;
        $data->username = $username;
        $data->approver_id = $approverId;
        $data->type = $type;
        $data->is_hourly = $is_hourly;
        $data->is_half_day = $isHalfDay;
        $data->start_time = $startTime;
        $data->end_time = $endTime;
        $data->start_date = $startDate;
        $data->end_date = $endDate;
        $data->no_days = $noDays;
        $data->reason = $reason;
        $data->half_day_type = $half_day_type;
        $data->leave_category = $leaveCategory;
        $data->filename = $filename;
        $data->relieve = $Relieve;
        //$data->time_from = $time_from;
        //$data->time_for = $time_for;
        $data->no_of_hours = $no_of_hours;
        $data->save();
        \Log::info('Leave added=========>');
        return $data->id;
    }

    public function addLeaveDays($leaveId, $username, $date, $status = "0") {

        $data = new LeaveDay;
        $data->leave_id = $leaveId;
        $data->username = $username;
        $data->date = $date;
        $data->status = $status;
        $data->save();

        return $data->id;
    }

    public function getApproversOfEmployee($employeeId) {
        $result1 = DB::table('map_employee_approver as a')->leftjoin('user_personal as b', 'a.approver_id', '=', 'b.username')->where('a.employee_id', $employeeId)->selectRaw("distinct a.approver_id as username, b.name")->orderBy('a.approver_index', 'asc')->get();
        $result = $result1;
        return $result;
    }

    public function add_leave_approver($leave_id, $approver_id) {
        // 	$query = "insert into leave_approver (leave_id, approver_id) values ('$leave_id', '$approver_id')";

        $query = "insert into approver_approved_leaves (leave_days_id, approver_id) values ('$leave_id', '$approver_id')";

        DB::select($query);
    }

    public function getLeaveNameByType($type = "Annual") {
        $result = DB::table('leave_name')->where('type', $type)->first();
        return $result->name;
    }

    public function hasContentPreference($username) {
        $query = "select employee_id from email_content_preferences where employee_id='$username'";
        $user1 = DB::select($query);
        $user = $user1;
        if (empty($user))
            return FALSE;
        else
            return TRUE;
    }

    public function sendEmailNow() {

        $all_pending_email_users = DB::table('pending_emails')->where('sent_status', 0)->selectRaw("distinct(email_to),`emp_name`,leave_status,leave_username")->get();
        $branchEmailInfo = [];
        $topMgtEmailInfo = [];
        if (count($all_pending_email_users) > 0) {
            for ($i = 0; $i < count($all_pending_email_users); $i++) {

                $all_pending_email = DB::table("pending_emails")->where('sent_status', 0)->where('email_to', $all_pending_email_users[$i]->email_to)->get();

                $subject = "Leave Status";



                if (($all_pending_email_users[$i]->leave_status == 'recommended' || $all_pending_email_users[$i]->leave_status == 'Cancellation Pending') || ($all_pending_email_users[$i]->email_to != $all_pending_email_users[$i]->leave_username && $all_pending_email_users[$i]->leave_status == "")) {
                    $uname = UserPersonal::where('username', $all_pending_email_users[$i]->email_to)->first();
                    $_name_val = $uname->name;
                    $body = "Dear " . $_name_val . ", <br /><br />";
                    $body .= "Following leave pending for your action : <br/><br />";
                } else {
                    $body = "Dear " . $all_pending_email_users[$i]->emp_name . ", <br /><br />";
                    $body .= "Your Leave Status : <br/><br />";
                }
                $body .= "<table>";
                $body .= "<tr>";
                if ($all_pending_email_users[$i]->leave_status == 'recommended' || $all_pending_email_users[$i]->leave_status == 'Cancellation Pending') {
                    $body .= "<td width='100'><strong>Employee</strong></td>";
                }
                $body .= "<td width='100'><strong>From Date</strong></td>";
                $body .= "<td width='100'><strong>To Date</strong></td>";
                $body .= "<td width='200'><strong>Leave Type</strong></td>";
                $body .= "<td width='100'><strong>Reason</strong></td>";
                $body .= "<td width='100'><strong>Status</strong></td>";
                if ($all_pending_email_users[$i]->leave_status != 'approved') {
                    $body .= "<td><strong>Link</strong></td>";
                }
                $body .= "</tr>";
                $inner_body = "";
                for ($j = 0; $j < count($all_pending_email); $j++) {
                    $this->pendingEmailStatusUpdate($all_pending_email[$j]->id, '1');
                    $body .= $all_pending_email[$j]->email_body;

                    $re = "/>.*?(?=<td>)<td>\\K.*?(?=<\\/td>)/s";
                    preg_match_all($re, $all_pending_email[$j]->email_body, $matches);
                    /* echo "<pre>";
                      print_r($matches);
                      echo " ======== <br /><br /><br />"; */
                    $new_inner_body = "<tr>";
                    for ($_m_i = 0; $_m_i < count($matches[0]); $_m_i++) {
                        if ($_m_i != 3) {
                            $new_inner_body .= "<td>" . $matches[0][$_m_i] . "</td>";
                        }
                    }
                    $new_inner_body .= "</tr>";

                    $inner_body .= $new_inner_body;
                }
                $body .= "</table><br /><br />";

                $body .= "Kind regards,<br />";
                $body .= "Note, this is an automatic email. Please do not reply. <br />";
                $body .= "If you did not request this information, please ignore this message. <br />";
                $body .= "If you have any questions, please contact us<br />";

                if (count($all_pending_email) > 0) {
                    $uname = UserPersonal::where('username', $all_pending_email_users[$i]->email_to)->first();
                    //	Mail::to($uname->email_id)->send(new MyDemoMail($body,$subject));

                    sendemail($uname->email_id, $subject, $body);


                    $AllowEmailSentToAll1 = DB::table('settings')->where('field', "email_status_sent_to_all")->first();
                    $AllowEmailSentToAll = $AllowEmailSentToAll1->value ?? 0;

                    if ($all_pending_email_users[$i]->leave_status == 'approved' && $AllowEmailSentToAll) {

                        $branch_info = $this->getBranchByUsername($all_pending_email_users[$i]->email_to);
                        $branch_id = $branch_info[0]->email;




                        $re = "/>.*?(?=<td>)<td>\\K.*?(?=<\\/td>)/s";
                        preg_match_all($re, $inner_body, $b_matches);

                        $branch_new_inner_body = "<tr>";
                        $_t_j = 0;
                        for ($_m_i = 0; $_m_i < count($b_matches[0]); $_m_i++) {

                            $_t_j++;
                            if ($_t_j == 1) {
                                $branch_new_inner_body .= "<td>" . $all_pending_email_users[$i]->emp_name . "</td>";
                            }
                            $branch_new_inner_body .= "<td>" . $b_matches[0][$_m_i] . "</td>";
                            if ($_t_j == 4) {
                                $_t_j = 0;
                                $branch_new_inner_body .= "</tr><tr>";
                            }
                        }
                        $branch_new_inner_body .= "</tr>";
                        //$branch_new_inner_body = substr($branch_new_inner_body, 0, -4);

                        if (array_key_exists($branch_id, $branchEmailInfo)) {
                            $exist_ar = $branchEmailInfo[$branch_id];

                            $_updated_inner_body = $exist_ar['inner_body'] . $branch_new_inner_body;
                            $exist_ar['inner_body'] = $_updated_inner_body;

                            $branchEmailInfo[$branch_id] = $exist_ar;
                        } else {
                            //$all_pending_email_users[$i]['emp_name']

                            $ar = array("subject" => $subject, "inner_body" => $branch_new_inner_body);
                            //echo $all_pending_email_users[$i]['email_to']." Branch id = ".$branch_id." <br />";
                            $branchEmailInfo[$branch_id] = $ar;
                        }

                        //$topMgtEmailInfo
                        $leave_username = $all_pending_email_users[$i]->leave_username;

                        $in_mgt_email1 = DB::table('user_pay as up')->leftjoin('category as c', 'c.id', '=', 'up.category_id')->where('up.username', $leave_username)->select('c.in_mgt_email as memail')->first();
                        $in_mgt_email = $in_mgt_email1->memail;

                        if ($in_mgt_email == "1") {
                            $topMgtEmailInfo[] = $branch_new_inner_body;
                        }
                    } else {
                        
                    }
                }
            }
            $this->SendEmailToTopMgt($topMgtEmailInfo);
            $this->SendEmailToBranchHeads($branchEmailInfo);
        }
    }

    public function pendingEmailStatusUpdate($id, $status) {

        $query = "update pending_emails set sent_status='$status' where id='$id'";
        $result1 = DB::select($query);
        $result = $result1;
        return $result;
    }

    public function getBranchByUsername($username) {

        $result1 = DB::table('branch as b')->leftjoin('user_pay as up', 'up.branch_id', '=', 'b.id')->selectRaw("b.*")->where('up.username', $username)->get();
        $result = $result1;
        return $result;
    }

    public function SendEmailToTopMgt($topMgtEmailInfo) {
        $top_mgt_email1 = DB::table('settings')->where('field', "top_mgt_email")->first();
        $top_mgt_email = $top_mgt_email1->value ?? 0;
        $subject = "Leave Status";

        if (count($topMgtEmailInfo) > 0 && $top_mgt_email != '' && $top_mgt_email != null) {
            $body = "";
            $body .= "Leave Status : <br/><br />";
            $body .= "<table>";
            $body .= "<tr>";
            $body .= "<td width='100'><strong>User</strong></td>";
            $body .= "<td width='100'><strong>From Date</strong></td>";
            $body .= "<td width='100'><strong>To Date</strong></td>";
            $body .= "<td width='200'><strong>Leave Type</strong></td>";
            $body .= "<td width='100'><strong>Status</strong></td>";
            $body .= "</tr>";
            for ($i = 0; $i < count($topMgtEmailInfo); $i++) {
                $body .= $topMgtEmailInfo[$i];
            }

            $body .= "</table><br /><br />";

            $body .= "Kind regards,<br />";
            $body .= "Note, this is an automatic email. Please do not reply. <br />";
            $body .= "If you did not request this information, please ignore this message. <br />";
            $body .= "If you have any questions, please contact us<br />";
            //Mail::to($top_mgt_email)->send(new MyDemoMail($body,$subject));
            sendemail($top_mgt_email, $subject, $body);
            //Email::sendEmail($top_mgt_email, $subject, $body);
        }
    }

    public function SendEmailToBranchHeads($branchEmailInfo) {

        $branch_permission1 = DB::table('settings')->where('field', "approve_email_to_branch")->first();
        $branch_permission = $branch_permission1->value ?? 0;
        if ($branch_permission == 1) {
            if (!empty($branchEmailInfo)) {
                if (count($branchEmailInfo) > 0) {
                    $subject = "Leave Status";
                    foreach ($branchEmailInfo as $key => $value) {
                        $body = "";
                        $body .= "Leave Status : <br/><br />";
                        $body .= "<table>";
                        $body .= "<tr>";
                        $body .= "<td width='100'><strong>User</strong></td>";
                        $body .= "<td width='100'><strong>From Date</strong></td>";
                        $body .= "<td width='100'><strong>To Date</strong></td>";
                        $body .= "<td width='200'><strong>Leave Type</strong></td>";
                        $body .= "<td width='100'><strong>Status</strong></td>";
                        $body .= "</tr>";
                        if(isset($branchEmailInfo[$key]->inner_body)){
                           $body .= $branchEmailInfo[$key]->inner_body; 
                        }
                        
                        $body .= "</table><br /><br />";

                        $body .= "Kind regards,<br />";
                        $body .= "Note, this is an automatic email. Please do not reply. <br />";
                        $body .= "If you did not request this information, please ignore this message. <br />";
                        $body .= "If you have any questions, please contact us<br />";
                        sendemail($key, $subject, $body);
                        //Mail::to($key)->send(new MyDemoMail($body,$subject));
                        //Email::sendEmail($key, $subject, $body);
                    }
                }
            }
        }
    }

    public function addLeaveEntitleHistory($username, $year, $type) {
        $this->deleteLeaveEntitleHistory($username, $year, $type);
        $entitle = getLeaveEntitle($username, $type);

        $taken = getTakenLeaveCount($username, $year, $type);
        $pastLeaves = getTakenPastLeaves($username, $year);
        $pleave = 0;
        if ($type == 'annual' || $type == 'medical' || $type == 'Other_pay') {
            $pleave = floatval($pastLeaves[strtolower($type)]);
        }
        $taken = floatval($taken) + $pleave;

        $adjustmentLeaves = ((strtolower($type) == "annual") ? getAdjustmentLeaveCount($username, $year) : "0");
        $bfLeaves = getBroughtForwardLeaveCount($username, $year, $type);
        $query = "insert into leave_entitle_history (username, year, leave_type, entitle, adjustment, leave_taken, ";
        $query .= "bf_leaves) values ('$username', '$year', '$type', '$entitle', '$adjustmentLeaves', '$taken', '$bfLeaves');";
        DB::select($query);
    }

    public function deleteLeaveEntitleHistory($username, $year, $type) {

        $query = "delete from leave_entitle_history where username='$username' and year='$year' and leave_type='$type'";
        DB::select($query);
    }

    public function sendEmailToBackupUsers($username, $leave_array) {
        $BackupUserList = $this->getMapBackupUserListForEmp($username);

        for ($i = 0; $i < count($BackupUserList); $i++) {
            $name = $leave_array['name'];

            $startDate = $leave_array['startDate'];
            $endDate = $leave_array['endDate'];
            $subject = "Employee " . $name . " applied for leave";

            $backupusername = $BackupUserList[$i]['name'];

            $body = "Dear $backupusername, <br><br>";
            $type_display = $leave_array['type_display'];
            $isHalfDay = $leave_array['isHalfDay'];

            /* $body .= "$name applied ".$type_display." Leave from $startDate to $endDate<br/><br/><br/>"; */
            if ($isHalfDay == '1') {
                $half_day_type_display = ($leave_array["half_day_type"] != "first") ? "PM" : "AM";
                $body .= "$name applied " . $type_display . " Leave half day " . $half_day_type_display . " from " . date('d-m-Y', strtotime($startDate)) . " to " . date('d-m-Y', strtotime($startDate)) . "<br/><br/><br/>";
            } else {
                $body .= "$name applied " . $type_display . " Leave from " . date('d-m-Y', strtotime($startDate)) . " to " . date('d-m-Y', strtotime($endDate)) . "<br/><br/><br/>";
            }

            $semail = UserPersonal::where('username', $BackupUserList[$i]->username)->first();

            sendemail($semail->email_id, $subject, $body);
            //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
            //Email::sendEmailToUserFromServer($BackupUserList[$i]['username'], $subject, $body);
        }
    }

    public function getMapBackupUserListForEmp($employee_id) {

        $result1 = DB::table('map_employee_backupuser as a')->leftjoin('user_personal as b', 'a.user_id', '=', 'b.username')->where('a.employee_id', $employee_id)->get();
        $result = $result1;
        return $result;
    }

    public function getUserRestDays(Request $request, $username = '', $duty_rost_permission = '') {
        $user = User::where('id', Auth::id())->first();
        if ($username != '') {
            $employeeId = $username;
        } else {
            $employeeId = (isset($request->name) ? $request->name : $user->username);
        }
        $duty_rost_permission = $duty_rost_permission;


        $branch_id = (isset($request->branch) ? $request->branch : "");
        $department_id = (isset($request->department) ? $request->department : "");
        $category_id = (isset($request->category) ? $request->category : "");
        $keyword = (isset($request->name) ? $request->name : "");

        $list = $this->getEmployeeWithFilterRestDays($employeeId, $branch_id, $department_id, $category_id, $keyword, $duty_rost_permission, request());

        return $list;
    }

    public function getEmployeeWithFilterRestDays($approver_id = '', $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $duty_rost_permission = '', Request $request) {
        $dr_permission = (isset($request->dr_permission)) ? $request->dr_permission : '0';
        if ($duty_rost_permission != '') {
            $dr_permission = $duty_rost_permission;
        }
        $query1 = DB::table('rest_dates as a')->leftjoin('rest_days as b', 'b.id', '=', 'a.rest_day_id')->leftjoin('rest_day_category_employee as c', 'b.category_id', '=', 'c.category_id')->leftjoin('user_personal as up', 'c.employee_id', '=', 'up.username')->leftjoin('user_pay as upy', 'c.employee_id', '=', 'upy.username')->leftjoin('user_personal as f', 'c.employee_id', '=', 'f.username')->leftjoin('map_employee_approver as map', 'c.employee_id', '=', 'map.employee_id')->selectRaw("a.rest_day_id, a.date,up.name")->where('c.employee_id', '!=', null)->where('b.is_employee', 0);
        if ($approver_id != '') {
            $query1->where('map.approver_id', $approver_id);
        }
        $branch_cat_dept = $this->getUserGroups($approver_id);
        $groups = $this->getCountryState($approver_id);
        if ($dr_permission == 4) {
            $query1->where('up.username', '3000');
        }
        if ($dr_permission == 5) {
            $query1->where('upy.branch_id', $branch_cat_dept->branch_id)->where('upy.category_id', $branch_cat_dept->category_id)->where('upy.department_id', $branch_cat_dept->department_id);
        }
        if ($dr_permission == 7) {
            $query1->where('upy.branch_id', $branch_cat_dept->branch_id);
        }
        if ($dr_permission == 8) {

            $state_nm = getstatebybranch($branch_cat_dept->branch_id);
            //dd($state_nm);
            $branchidarr = getbranchbystate($state_nm);
            $branchidarr = explode(",", $branchidarr);

            $query1->whereIn('upy.branch_id', $branchidarr);
        }
        if ($keyword != '') {
            $query1->whereRaw('(f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%"))');
        }
        if ($branch_id != '') {
            $query1->where('upy.branch_id', $branch_id);
        }
        if ($category_id != '') {
            $query1->where('upy.category_id', $category_id);
        }
        if ($dept_id != '') {
            $query1->where('upy.department_id', $dept_id);
        }

        $query2 = DB::table('rest_dates as a')->leftjoin('rest_days as b', 'b.id', '=', 'a.rest_day_id')->leftjoin('user_personal as up', 'b.employee_id', '=', 'up.username')->leftjoin('user_pay as upy', 'b.employee_id', '=', 'upy.username')->leftjoin('user_personal as f', 'b.employee_id', '=', 'f.username')->leftjoin('map_employee_approver as map', 'b.employee_id', '=', 'map.employee_id')->where('b.is_employee', '1')->selectRaw("a.rest_day_id, a.date,up.name");
        if ($approver_id != '') {
            $query2->where('map.approver_id', $approver_id);
        }

        $branch_cat_dept = $this->getUserGroups($approver_id);
        $groups = $this->getCountryState($approver_id);
        if ($dr_permission == 4) {
            $query2->where('up.username', '3000');
        }
        if ($dr_permission == 5) {
            $query2->where('upy.branch_id', $branch_cat_dept->branch_id)->where('upy.category_id', $branch_cat_dept->category_id)->where('upy.department_id', $branch_cat_dept->department_id);
        }
        if ($dr_permission == 7) {
            $query2->where('upy.branch_id', $branch_cat_dept->branch_id);
        }
        if ($dr_permission == 8) {
            $state_nm = getstatebybranch($branch_cat_dept->branch_id);
            $branchidarr = getbranchbystate($state_nm);
            $branchidarr = explode(",", $branchidarr);
            $query2->whereIn('upy.branch_id', $branchidarr);
        }
        if ($keyword != '') {
            $query2->whereRaw('(f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%"))');
        }
        //dd($branch_id);
        if ($branch_id != '') {
            $query2->where('upy.branch_id', $branch_id);
        }

        if ($dept_id != '') {
            $query2->where('upy.department_id', $dept_id);
        }
        if ($category_id != '') {
            $query2->where('upy.category_id', $category_id);
        }
        $result = $query2->union($query1)->get();

        return $result;
    }

    public function getDutyRoster() {
        $startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear = carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $user = User::where('id', Auth::id())->first();
        $branches = Branch::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $departments = Department::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $categories = Category::where('company_id', $user->company_id)->orderBy('name', 'ASC')->get();
        $leaveTypes = Leavetype::where('is_show', 1)->get();
        $permission = $this->getPermissionGroupOfEmployee($user->username);

        $duty_rost_permission = 0;
        if (!empty($permission)) {
            $duty_rost_permission = $permission->duty_rostere_viewe;
        }
        //dd($duty_rost_permission);
        if ($duty_rost_permission == 5) {
            $leavesArray = $this->showsectionLeavedayList($user->username);
        } elseif ($duty_rost_permission == 6 || $duty_rost_permission == 7 || $duty_rost_permission == 8) {
            $leavesArray = $this->showLeavedayList(request(), $user->username);
        } else {
            $leavesArray = $this->showselfLeavedayList(request(), $user->username);
        }
        //dd($leavesArray);
        $leavesArray->transform(function($item) {


            return [
                'title' => $item->name . ' (' . $item->type . ')' . $item->day_leave_type,
                'start' => date('Y-m-d', strtotime($item->date)),
                'type' => $item->type,
                'color' => $item->color,
                    //'extendedProps' => [
                    //	'calendar' => $item->type,
                    //]
            ];
        })->toArray();

        //dd($leavesArray);
        $restDay = $this->getUserRestDays(request(), $user->username, $duty_rost_permission);
        //dd($restDay);				
        $restDay->transform(function($item) {

            return [
                'title' => $item->name,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                //'color' =>  $item->background_color,
                //'extendedProps' => [
                //	'calendar' => 'Marriage',
                //]
                'color' => '#FFC0CB',
            ];
        })->toArray();

        $user = User::where('id', Auth::id())->first();
        $userPay = DB::table('user_pay')->where('username', $user->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();

        $recentHoliday11 = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                ->whereYear('date', '=', date('Y'));

        $recentHoliday = $recentHoliday11->groupBy('date_holiday')->get();

        $recentHoliday->transform(function($item11) {

            return [
                'title' => $item11->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item11->date)),
                'color' => '#28c76f',
            ];
        })->toArray();
        //dd($recentHoliday);		
        $leaves11 = $restDay->merge($leavesArray);
        $leaves = $leaves11->merge($recentHoliday);

        return view('E-Leave.duty-roster', compact('leaves', 'branches', 'departments', 'categories', 'leaveTypes'));
    }

    public function getPermissionGroupOfEmployee($employeeId) {

        $builder = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->selectRaw("b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe")->where('a.employee_id', $employeeId)->first();
        return $builder;
    }

    public function holidayFilter14(Request $request) {
        $user = User::where('id', Auth::id())->first();


        if ($request->name && $request->name != '' && $request->username == '') {
            $emplist = DB::table('user_personal')->whereRaw('(name like ("' . request()->name . '%") OR username like ("' . request()->name . '%") OR employee_no like ("' . request()->name . '%")) ')->first();
        } elseif ($request->name && $request->name != '') {
            $emplist = DB::table('user_personal')->where('username', $request->name)->first();
        } else {
            $emplist = DB::table('user_personal')->where('username', $user->username)->first();
        }
        $permission = $this->getPermissionGroupOfEmployee($emplist->username);
        $duty_rost_permission = 0;
        if (!empty($permission)) {
            $duty_rost_permission = $permission->duty_rostere_viewe;
        }
        //dd($duty_rost_permission);
        if ($duty_rost_permission == 5) {
            $leavesArray = $this->showsectionLeavedayList($emplist->username);
        } elseif ($duty_rost_permission == 6 || $duty_rost_permission == 7 || $duty_rost_permission == 8) {
            $leavesArray = $this->showLeavedayList(request(), $emplist->username);
        } else {
            $leavesArray = $this->showselfLeavedayList(request(), $emplist->username);
        }

        if (count($leavesArray) > 0) {
            $leavesArray->transform(function($item) {


                return [
                    'title' => $item->name . '(  ' . $item->type . ')' . $item->day_leave_type. ' ',
                    'start' => date('Y-m-d', strtotime($item->date)),
                    'type' => $item->type,
                    'color' => $item->color,
                        //'extendedProps' => [
                        //	'calendar' => $item->type,
                        //]
                ];
            })->toArray();
        }



        $restDay = $this->getUserRestDays(request(), $emplist->username, $duty_rost_permission);

        $restDay->transform(function($item) {

            return [
                'title' => $item->name,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'color' => '#FFC0CB',
            ];
        })->toArray();



        $userPay = DB::table('user_pay')->where('username', $emplist->username)->first();
        $branchData = DB::table('branch')->where('id', $userPay->branch_id)->first();
        if ($branchData != null) {
            $userState = $branchData->state;
            // $branchId = $branchData->id;
        } else {
            $userState = "zzzzzzz";
            // $userState = 0;
        }
        $recentHoliday11 = DB::table('public_holiday')->selectRaw("public_holiday.*, CONCAT(date, description) as date_holiday")->orderBy('date', 'ASC')->where('company_id', $user->company_id)
                ->whereYear('date', '=', $request->year);
        if ($request->name && $request->name != '' || $request->username != '') {
            $recentHoliday11->whereRaw('(state = "National" OR state = "NATIONAL" OR state = "' . $userState . '")');
        }
        $recentHoliday = $recentHoliday11->groupBy('date_holiday')->get();
        $recentHoliday->transform(function($item) {

            return [
                'title' => $item->description,
                'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'color' => '#28c76f',
            ];
        })->toArray();

        $leaves11 = $restDay->merge($leavesArray);
        //$leaves12 = $leaves11->merge($recentHoliday);
        $leaves = $leaves11->merge($recentHoliday);
        //$leaves = $restDay->merge($Array);
        //\Log::info(json_encode($recentHoliday));
        return $leaves;
    }

    public function showsectionLeavedayList($username = '') {
        $employeeId = $username;

        $userGroups = $this->getUserGroups($employeeId);
        $result = $this->getSelectedLeaveList($userGroups->branch_id, $userGroups->category_id, $userGroups->department_id);
        return $result;
    }

    public function getSelectedLeaveList($branchId, $categoryId, $departmentId) {
        $user = User::where('id', Auth::id())->first();
        $approver_id = $user->username;

        $query1 = DB::table('leave_days as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('category as f', 'c.category_id', '=', 'f.id')->leftjoin('leave_list as g', 'a.leave_id', '=', 'g.id')->leftjoin('map_employee_approver as map', 'a.username', '=', 'map.employee_id')->where('a.status', 1)->where('c.branch_id', $branchId)->where('c.category_id', $categoryId)->where('c.department_id', $departmentId)->selectRaw("a.id, a.date, b.name, g.type, g.reason, d.id as branch_id, d.name as branch, e.id as department_id, e.name as department, CASE g.is_half_day WHEN 1 THEN ( CASE g.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) END as 'day_leave_type', f.id as category_id, f.name as category");

        $query2 = DB::table('leave_past as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('category as f', 'c.category_id', '=', 'f.id')->leftjoin('map_employee_approver as map', 'a.username', '=', 'map.employee_id')->where('c.branch_id', $branchId)->where('c.category_id', $categoryId)->where('c.department_id', $departmentId)->selectRaw("a.id, a.start_date as date, b.name, a.type, '' as reason, d.id as branch_id, d.name as branch, e.id as department_id, e.name as department, CASE a.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END as 'day_leave_type', f.id as category_id, f.name as category")->union($query1)->get();
        $leave_color = $this->getleavecolorarry();

        $masterArr = $query2;
        foreach ($masterArr as $key => $val) {
            if ($masterArr[$key]->half_day_type == 'first') {
                $day_leave_type = 'AM';
            } elseif ($masterArr[$key]->half_day_type == 'second') {
                $day_leave_type = 'PM';
            } else {
                $day_leave_type = '';
            }

            $masterArr[$key]->textColor = '#ffffff';
            $masterArr[$key]->color = $leave_color[$val->type];
            $masterArr[$key]->day_leave_type = $day_leave_type;
        }

        return $masterArr;
        //return $builder->getArrayResult();
    }

    public function getleavecolorarry() {
        $masterArr = array();
        $user = User::where('id', Auth::id())->first();

        $leaveclolor = DB::table('leave_name')->where('company_id', $user->company_id)->get();
        foreach ($leaveclolor as $row) {
            $masterArr[$row->type] = $row->leave_color;
        }
        return $masterArr;
    }

    public function showLeavedayList(Request $request, $username) {
        $leaveType = (isset($request->type) ? $request->type : "");
        $date = ((isset($request->date) && $request->date != "") ? date('Y-m-d', strtotime($request->date)) : "");
        $username = $username;
        $user = User::where('id', Auth::id())->first();
        $approver_id = $user->username;


        $branch_id = (isset($request->branch) ? $request->branch : "");
        $department_id = (isset($request->department) ? $request->department : "");
        $category_id = (isset($request->category) ? $request->category : "");
        $keyword = (isset($request->name) ? $request->name : "");

        $result = $this->getUsersApprovedLeavesAccordingToApprover($username, $approver_id, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, 0);
        //dd($username,$approver_id,$leaveType,$date,$branch_id,$department_id,$category_id,$keyword);

        return $result;
    }

    public function getUsersApprovedLeavesAccordingToApprover($username, $approver_id, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '') {
        $user = User::where('id', Auth::id())->first();
        $logged_username = $user->username;
        $ActiveUserShownStatus = $this->getActiveUserShown();
        $currentOnly = $this->getCurrentYearLeaveDisplay();
        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }
        $permission_val = getPermissionValue("duty_rostere_viewe", $user->username);
        //dd($permission_val);
        $userbranchId = $this->getUserBranchId($user->username);
        $user_personal_info = $this->getUserPersonalDetails($logged_username);


        $query1 = DB::table('leave_days as a')->leftjoin('leave_list as b', 'a.leave_id', '=', 'b.id')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('map_employee_approver as map', 'a.username', '=', 'map.employee_id')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->leftjoin('user_personal as f', 'a.username', '=', 'f.username')->whereRaw("1")->where('map.approver_id', $approver_id)->selectRaw(" a.id, a.username, f.name, b.type, DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', b.is_half_day, b.half_day_type, a.status, b.reason, a.cancellation_reason,e.id as department_id, e.name as department , a.date as date ");
        if ($keyword != '') {
            $query1->whereRaw('(f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%"))');
        }
        if ($currentOnly == '1') {
            $query1->whereRaw("DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }
        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);
        //	dd($branch_id);
        if ($branch_id != '') {
            if ($permission_val == 8) {
                $query1->whereIn('c.branch_id', $branchidarr);
            } else {
                $query1->where('c.branch_id', $branch_id);
            }
        } else {
            if ($permission_val == 8) {

                $query1->whereIn('c.branch_id', $branchidarr);
            }
        }
// 		if($ActiveUserShownStatus=='0'){
// 			$query1->where('c.pay_status','!=',1);
//             //$query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
//         }
        if ($ActiveUserShownStatus == '1') {
            $query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        } else {
            $query1->where('c.pay_status', 1);
        }
        //     if($username!=''){
        //  $query1->where('a.username',$username);
        //     }
        $query1->where('a.status', '1');
        if ($leaveType != '') {
            $query1->where('b.type', $leaveType);
        }
        if ($date != '') {
            $query1->where('a.date', $date);
        }
        if ($branch_id != '') {
            if ($permission_val == 7) {
                $query1->where('c.branch_id', $userbranchId);
            } else {
                $query1->where('c.branch_id', $branch_id);
            }
        } else {
            if ($permission_val == 7) {
                $query1->where('c.branch_id', $userbranchId);
            }
        }
        if ($dept_id != '') {
            $query1->where('c.department_id', $dept_id);
        }
        if ($category_id != '') {
            $query1->where('c.category_id', $category_id);
        }

        $query2 = DB::table('leave_past as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('map_employee_approver as map', 'a.username', '=', 'map.employee_id')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->whereRaw("1")->where('map.approver_id', $approver_id)->selectRaw("'0' as id, a.username, b.name, a.type, '' as date_applied, DATE_FORMAT(a.start_date, '%d/%m/%Y') as start_date, DATE_FORMAT(a.end_date, '%d/%m/%Y') as end_date, a.total_leave_days as no_days, CASE a.total_leave_days WHEN 1 THEN 0 WHEN 0.5 THEN 1 END as is_half_day, a.half_day_type, 1 as status, '' as reason, '' as cancellation_reason,e.id as department_id, e.name as department, a.start_date as date");
        if ($keyword != '') {
            $query2->whereRaw('(b.name like ("' . $keyword . '%") OR b.employee_no like ("' . $keyword . '%"))');
        }
        if ($currentOnly == '1') {
            $query2->whereRaw("DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE()) ");
        }

        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);
        if ($branch_id != '') {
            if ($permission_val == 8) {
                $query2->whereIn('c.branch_id', $branchidarr);
            } else {
                $query2->where('c.branch_id', $branch_id);
            }
        } else {
            if ($permission_val == 8) {
                $query2->whereIn('c.branch_id', $branchidarr);
            }
        }
        // if($ActiveUserShownStatus=='1'){
        //     $query2->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        // }
        // else{
        //     $query2->where('c.pay_status',1);
        // }
// 		if($ActiveUserShownStatus=='0'){
// 			$query2->where('c.pay_status','!=',1);
//             //$query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
//         }
        if ($ActiveUserShownStatus == '1') {
            $query2->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        } else {
            $query2->where('c.pay_status', 1);
        }

        if ($dept_id != '') {
            $query2->where('c.department_id', $dept_id);
        }
        if ($leaveType != '') {
            $query2->where('a.type', $leaveType);
        }
        if ($category_id != '') {
            $query2->where('c.category_id', $category_id);
        }
// 		$query2->where('a.username',$username);
        if ($date != '') {
            $query2->where('a.start_date', $date);
        }

        $builder = $query2->union($query1)->get();

        $leave_color = $this->getleavecolorarry();
        $masterArr = $builder;
        //dd($masterArr);
        foreach ($masterArr as $key => $val) {
            $day_leave_type = '';
            if ($masterArr[$key]->is_half_day == 1) {
                if ($masterArr[$key]->half_day_type == 'first') {
                    $day_leave_type = 'AM';
                } else {
                    $day_leave_type = 'PM';
                }
            }
            $masterArr[$key]->textColor = '#ffffff';
            $masterArr[$key]->color = $leave_color[$val->type];
            $masterArr[$key]->day_leave_type = $day_leave_type;
        }

        return $masterArr;
    }

    public function getUserBranchId($username) {
        $builder = DB::table('user_pay')->where('username', $username)->selectRaw("branch_id")->first();
        $result = $builder->branch_id;
        return $result;
    }

    public function getActiveUserShown() {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'active_user_shown')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("active_user_shown" => intval($val));
    }

    public function getCurrentYearLeaveDisplay() {
        $user = User::where('id', Auth::id())->first();

        $result = DB::table('settings')->where('field', 'only_current_year_leave_display')->where('company_id', $user->company_id)->first();
        if (!empty($result)) {
            $val = $result->value ?? 0;
        } else {
            $val = 0;
        }
        return array("value" => intval($val));
    }

    public function getUserPersonalDetails($username) {
        $query = "select up.username, employee_no, up.employee_code, up.employee_type, up.designation, up.name, up.address, up.postal_code, up.town, up.nationality, up.state, up.phone_no, ";
        $query .= "up.dob, up.highest_education, up.working_experience, up.ic_no_old, up.ic_no_new, up.ic_color, up.passport_no, up.sex, up.race, up.bumiputra, ";
        $query .= "up.marital_status, up.email_id, up.blood_group, up.profile_photo_file, rdc.category as rest_day_group,up.isDeleted from user_personal up ";
        $query .= "left join rest_day_category_employee rdce on rdce.employee_id=up.username left join rest_day_category rdc on rdc.id=rdce.category_id  ";
        $query .= "where username='$username' ";
        $result = DB::select($query);
        return $result;
    }

    public function showselfLeavedayList(Request $request, $username) {
        $leaveType = (isset($request->type) ? $request->type : "");
        $date = ((isset($request->date) && $request->date != "") ? date('Y-m-d', strtotime($request->date)) : "");
        $username = $username;
        $user = User::where('id', Auth::id())->first();
        $approver_id = $user->username;


        $branch_id = (isset($request->branch) ? $request->branch : "");
        $department_id = (isset($request->department) ? $request->department : "");
        $category_id = (isset($request->category) ? $request->category : "");
        $keyword = (isset($request->name) ? $request->name : "");

        $result = $this->getUsersApprovedLeaves($username, $leaveType, $date, $branch_id, $department_id, $category_id, $keyword, 0);

        return $result;
    }

    public function getUsersApprovedLeaves($username, $leaveType, $date, $branch_id = '', $dept_id = '', $category_id = '', $keyword = '', $currentYearSettingAllow = '') {
        $user = User::where('id', Auth::id())->first();
        $logged_username = $user->username;

        $permission_val = getPermissionValue("view_leave", $user->username);

        $ActiveUserShownStatus = $this->getActiveUserShown();
        $currentOnly = $this->getCurrentYearLeaveDisplay();
        if ($currentYearSettingAllow == 0) {
            $currentOnly = 0;
        }

        $user_personal_info = $this->getUserPersonalDetails($logged_username);

        $query1 = DB::table('leave_days as a')->leftjoin('leave_list as b', 'a.leave_id', '=', 'b.id')->leftjoin('user_pay as c', 'a.username', '=', 'c.username')->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id');
        if ($permission_val == 5) {
            $query1->leftjoin('map_employee_approver as mea', 'mea.employee_id', '=', 'a.username');
        }
        $query1->leftjoin('user_personal as f', 'a.username', '=', 'f.username')->selectRaw("a.id, a.username, f.name, b.type, DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, CASE b.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', b.is_half_day, b.half_day_type, a.status, b.reason, a.cancellation_reason,e.id as department_id, e.name as department");

        $userbranchId = $this->getUserBranchId($user->username);
        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);
        if ($permission_val == 8) {
            $query1->whereIn('c.branch_id', $branchidarr);
        }

        if ($keyword != '') {
            $query1->whereRaw('(f.name like ("' . $keyword . '%") OR f.employee_no like ("' . $keyword . '%"))');
        }
        if ($currentOnly == '1') {
            $query1->whereRaw("DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE())");
        }

        if ($permission_val == 5) {
            $query1->whereRaw("( mea.approver_id='" . $logged_username . "' OR a.username='" . $username . "' )");
        } else if ($username != '') {
            $query1->where('a.username', $username);
        }

// 		if($ActiveUserShownStatus=='0'){
// 			$query1->where('c.pay_status','!=',1);
//             //$query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
//         }
        if ($ActiveUserShownStatus == 1) {
            $query1->whereRaw("( c.pay_status='1' or c.pay_status='0')");
        } else {
            $query1->where('c.pay_status', '1');
        }
        $query1->where('a.status', 1);
        if ($leaveType != '') {
            $query1->where('b.type', $leaveType);
        }
        if ($date != '') {
            $query1->where('a.date', $date);
        }

        if ($branch_id != '') {
            $query1->where('c.branch_id', $branch_id);
        }
        if ($dept_id != '') {
            $query1->where('c.department_id', $dept_id);
        }
        if ($category_id != '') {
            $query1->where('c.category_id', $category_id);
        }

        $query2 = DB::table('leave_past as a')->leftjoin('user_personal as b', 'a.username', '=', 'b.username')->leftjoin('user_pay as c', 'a.username', '=', 'c.username');
        if ($permission_val == 5) {
            $query2->leftjoin('map_employee_approver as mea', 'mea.employee_id', '=', 'a.username');
        }
        $query2->leftjoin('branch as d', 'c.branch_id', '=', 'd.id')->leftjoin('department as e', 'c.department_id', '=', 'e.id')->whereRaw("1")->selectRaw("CONCAT('P',a.id) as id, a.username, b.name, a.type, '' as date_applied, DATE_FORMAT(a.start_date, '%d/%m/%Y') as start_date, DATE_FORMAT(a.end_date, '%d/%m/%Y') as end_date, a.total_leave_days as no_days, CASE a.total_leave_days WHEN 1 THEN 0 WHEN 0.5 THEN 1 END as is_half_day, a.half_day_type, 1 as status, '' as reason, '' as cancellation_reason,e.id as department_id, e.name as department");

        if ($keyword != '') {
            $query2->whereRaw('(b.name like ("' . $keyword . '%") OR b.employee_no like ("' . $keyword . '%"))');
        }
        if ($currentOnly == '1') {
            $query2->whereRaw("DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE())");
        }
        if ($permission_val == 5) {
            $query2->whereRaw("( mea.approver_id='" . $logged_username . "' OR a.username='" . $username . "' )");
        } elseif ($username != '') {
            $query2->where('a.username', $username);
        }

        $userbranchId = $this->getUserBranchId($user->username);
        $state_nm = getstatebybranch($userbranchId);
        $branchidarr = getbranchbystate($state_nm);
        $branchidarr = explode(",", $branchidarr);
        if ($permission_val == 8) {
            $query2->whereIn('c.branch_id', $branchidarr);
        }

// 		if($ActiveUserShownStatus=='0'){
// 			$query2->where('c.pay_status','!=',1);
//             //$query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
//         }

        if ($ActiveUserShownStatus == 1) {
            $query2->whereRaw("( c.pay_status='1' or c.pay_status='0')");
        } else {
            $query2->where('c.pay_status', '1');
        }

        if ($branch_id != '') {
            $query2->where('c.branch_id', $branch_id);
        }
        if ($dept_id != '') {
            $query2->where('c.department_id', $dept_id);
        }
        if ($leaveType != '') {
            $query2->where('a.type', $leaveType);
        }
        if ($category_id != '') {
            $query2->where('c.category_id', $category_id);
        }
        if ($date != '') {
            $query2->where('a.start_date', $date);
        }

        $builder = $query2->union($query1)->get();
        $leave_color = $this->getleavecolorarry();

        $masterArr = $builder;
        foreach ($masterArr as $key => $val) {
            if ($masterArr[$key]->half_day_type == 'first') {
                $day_leave_type = 'AM';
            } elseif ($masterArr[$key]->half_day_type == 'second') {
                $day_leave_type = 'PM';
            } else {
                $day_leave_type = '';
            }

            $masterArr[$key]->textColor = '#ffffff';
            $masterArr[$key]->date = $masterArr[$key]->start_date;
            $masterArr[$key]->color = $leave_color[$val->type];
            $masterArr[$key]->day_leave_type = $day_leave_type;
        }

        return $masterArr;
    }

}
