<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, 
    UserPersonal, Designation, Branch, Department, EmployeeType,Race};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
class PersonalInfoController extends Controller
{
    public function index()
    {
        $user_id = Auth::id();
        $user = User::findOrFail($user_id);
        $personal = $user->personal;
        $spouse = $user->spouse;
        $address = $user->address;
        $userPay = $user->userPay;
        $designations = Designation::where('company_id', $user->company_id)->get();
        $branches = Branch::where('company_id', $user->company_id)->get();
        $departments = Department::where('company_id', $user->company_id)->get();
        $employeeTypes = EmployeeType::where('company_id', $user->company_id)->get();
       // dd($personal);
        return view('E-Leave/personal-information', compact('personal', 'designations', 'branches', 'departments', 'employeeTypes', 'userPay', 'spouse', 'address'));
    }

    public function updatepersonalinfo( Request $request, $update = null)
    {
       $update = $request->input('update');
     
        $user_id = Auth::id();
        $user = User::findOrFail($user_id);
        $personal = $user->personal;
        $spouse = $user->spouse;
        $address = $user->address;
        $userPay = $user->userPay;
        $designations = Designation::where('company_id', $user->company_id)->get();
        $branches = Branch::where('company_id', $user->company_id)->get();
        $race = Race::where('is_deleted',0)->where('company_id', $user->company_id)->get();
        
        $departments = Department::where('company_id', $user->company_id)->get();
        $employeeTypes = EmployeeType::where('company_id', $user->company_id)->get();
        if($personal->marital_status=='Single'){
            $personal->marital_status = '0';
        }
        if($personal->marital_status=='Married'){
            $personal->marital_status = '1';
        }
        if($personal->marital_status=='Other'){
            $personal->marital_status = '2';
        }
        return view('E-Leave/personal-info-update', compact('personal', 'designations', 'branches', 'departments', 'employeeTypes', 'userPay', 'spouse', 'address','update','race'));
    }
}