<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Hash;
use Illuminate\Support\Facades\DB;
class RegisterController extends Controller
{
    public function create(Request $request)
    {
        $this->validate($request,[
            'username' => 'required|min:2|max:20|regex:/^[\pL\s\-]+$/u|unique:users',
            'company' => 'required|min:2|max:20',
            'password' => 'required|min:6|confirmed|regex:/^(?=.*?[a-z])(?=.*?[0-9]).{6,}$/',
        ]);

        if (!empty($request->input('company'))) {
            $ck = strtolower($request->input('company'));

            $getId = DB::select('select id from companies where name = ?', array($ck));

            if (empty($getId)) {
                $data = array('name' => $request->input('company'));
                $id = DB::table('companies')->insertGetId($data);
            } else {
                $id = $getId[0]->id;
            }
        }

        $user = User::create([
            'username' => $request->username,
            'password' => \Hash::make($request->password),
            'company_id' => $id,
            'account_type'=> '2',
            'status'=> '2',
        ]);

        $user->personal()->create([
            'username' => $request->username,
            'blood_group' => ''
        ]);
        $user->userPay()->create([
			'username' => $request->username,
		]);

        $user->spouse()->create([
			'username' => $request->username,
		]);
        $user->address()->create([
			'username' => $request->username,
		]);
        $user->save();

        return redirect()->back()->with('message', 'Register Successfully');
    }
}