<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, MapEmployeeApprover, UserPersonal, PublicHoliday,UserPay,LeaveEntitleHistory};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Dompdf\Dompdf;
use App\Exports\ReportExport;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Yajra\DataTables\Facades\DataTables;
class ReportController extends Controller
{

    public function index(Request $request)
    {
        $leaveTypes  = Leavetype::orderBy('name')->get();
        $user = User::where('id' , Auth::id())->first();
        
        $yr='';
        $username = "";
        $replacement =getSelfRepleasementLeave($username,$yr);
        $relieveallow=DB::table('settings')->where('field','leave_relieve_allow')->where('company_id',$user->company_id)->first();
		$halfdayallow=DB::table('settings')->where('field','halfdayleave')->where('company_id',$user->company_id)->first();
        
        $c_key = 'leave_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = json_decode($columnHideShowData->c_value);
        }else{
            $columnHideShowData = array();
        }

        
        return view('approvals.report', compact('leaveTypes', 'relieveallow', 'halfdayallow', 'replacement', 'c_key', 'columnHideShowData'));
    }
    public function getreportdata(Request $request) {
        //dd($request->getUri());
        session(['pdf_data' => $request->getUri()]);
        //dd($request);
        $hr_viewStatus = getPermissionValue("approval_view_all",!empty(Auth::check()) ? Auth::user()->username : request()->auth_id);
        $currentOnly = getSettingsValue('only_current_year_leave_display');
        
        $user = User::where('id' , !empty(Auth::check()) ? Auth::id() : request()->auth_id)->first();
        $allLeaves = LeaveDay::selectRaw("leave_list.*, leave_days.*, leave_name.name as typename, CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly")->leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->leftjoin('leave_name', 'leave_name.type','=','leave_list.type')->leftjoin('user_personal as c','leave_days.username','=','c.username')
                            ->leftjoin('user_pay as d','leave_days.username','=','d.username')
                            ->leftjoin('user_personal as c_r','leave_list.relieve','=','c_r.username');
        
        $edata=array();
        foreach(explode(',', $request->get('exportdata')) as $data) { 
            array_push($edata,$data);
          //  $edata = $data;
         }
									
									
        			
        if($request->get('exportdata') && $request->get('exportdata') != '')
        {
            $allLeaves->whereRaw('leave_list.id IN ("'.implode('","',$edata).'")');
        }
        if($request->get('name') && $request->get('name') != '')
        {
            $allLeaves->whereRaw('(c.name like ("'.request()->name.'%") OR c.employee_no like ("'.request()->name.'%")) ');
        }
        if($request->get('ename') && $request->get('ename') != '')
        {
            $allLeaves->whereRaw('(c.name like ("'.request()->ename.'%") OR c.employee_no like ("'.request()->ename.'%")) ');
        }

        if($request->get('status') != null && $request->get('status') != '')
        {
            $allLeaves->where('leave_list.status', $request->get('status'));
        }

        if($request->get('type') && $request->get('type') != '')
        {
            $allLeaves->where('leave_list.type', $request->get('type'));
        }
        if($request->get('phone') && $request->get('phone') != '')
        {
            $personals11 = DB::table('user_personal')->where('employee_no', $request->get('phone'))
                        ->pluck('username')->toArray();
            $allLeaves->whereIn('leave_list.username', $personals11);
        }
        $from = $request->get('from');
        $to = $request->get('to');
        if($from != '' && $to != ''){
            $allLeaves->whereBetween('leave_list.start_date', [$from, $to]);
        }
       elseif($from != '')
		{
			$allLeaves->where('leave_list.start_date', '=', $from);
		}

		elseif($to != '')
		{
			$allLeaves->where('leave_list.start_date', '=', $to);
		}
        if($request->from==''){
			if($currentOnly=='1'){
			    $allLeaves->whereRaw("(DATE_FORMAT(leave_days.date, '%Y') >= YEAR(CURDATE()))");
			}
		}
		  $logged_username = $user->username;
    		if($hr_viewStatus==1){
                $allLeaves->where('c.username',$logged_username);
               // $leavecount->where('c.username',$logged_username);
    		}else if($hr_viewStatus==2){
    			$logged_userGroups = getUserGroups($logged_username);
                $allLeaves->where('d.branch_id',$logged_userGroups->branch_id)->where('d.category_id',$logged_userGroups->category_id)->where('d.department_id',$logged_userGroups->department_id);
                //$leavecount->where('d.branch_id',$logged_userGroups->branch_id)->where('d.category_id',$logged_userGroups->category_id)->where('d.department_id',$logged_userGroups->department_id);
    		}else if($hr_viewStatus==3){
    			$logged_userGroups = getUserGroups($logged_username);
    			$allLeaves->where('d.branch_id',$logged_userGroups->branch_id);
               // $leavecount->where('d.branch_id',$logged_userGroups->branch_id);
    		}else if($hr_viewStatus==4){
    			$logged_userGroups = getUserGroups($logged_username);
    			$all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
                if(count($all_other_branch_ids)>0){
        				$array_i = array();
        				for($b_id_i = 0; $b_id_i<count($all_other_branch_ids); $b_id_i++){
        					$array_i[] = $all_other_branch_ids[$b_id_i]->id;
        				}
        				$str_branch_ids = $array_i;
                        $allLeaves->whereIn('d.branch_id',$str_branch_ids);
        			}
    		}
        $leaves = $allLeaves->orderby('leave_days.id','desc')->get();
        $leaves->map(function($item) {
            $userPersonal = DB::table('user_personal')->where('username', $item->username)->first();
            $item->emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $item->emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $r_name = '';
            $htype ='';
            if($item->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $item->relieve)->first();
                $r_name = '';
                if(!empty($employee))
                    $r_name = $employee->name;
            }
            if($item->half_day_type=='first'){
				$htype='AM';
			}
			if($item->half_day_type=='second'){
				$htype='PM';
			}
            if($item->type=='Other_pay'){
                $type='Replacement';
            }
            elseif($item->type=='Line_Shut'){
                $type='Out Of Office';
            }
            else{
                $type=$item->type;
            }
            if($item->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($item->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($item->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($item->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($item->status == 4)
            {
                $status = 'Cancelled';
                $class= '#00cfe8';
            }
            elseif($item->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            $no_hours = 0;
            if($item->is_hourly == 1){
               $no_hours =($item->end_time-$item->start_time)/3600 ;
            }
            $item->back_color = $class;
            $item->leave_status = $status;
            $item->r_name = $r_name;
            $item->leave_type  = $item->typename;
            $item->half_day  = $htype;
            $item->no_of_hours  = $no_hours;
            return $item;
        });
       return DataTables::of($leaves)->make(true);

    }

    public function downloadPDF(Request $request)
    {
        $url = str_replace("length=20","length=-1",session('pdf_data'));
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id()."&exportdata=".$request->get('exportdata'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd(json_decode($response));

        $user = User::where('id' , Auth::id())->first();
        //$allLeaves = LeaveList::Where('approver_id', $user->username);
        $leaves = json_decode($response)->data;

        
        $c_key = 'leave_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();
        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "[]";
        }
        $arrColumns = ["Emp No", "Name", "Relief", "Type", "Date", "Days", "Reason", "Status"];

      
        $html = view('approvals.export.pdf', compact('leaves', 'columnHideShowData', 'c_key', 'arrColumns'))->render();
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('Leave list');
        return 1;

    }
    
    public function export(Request $request)
    {
        //return Excel::download(new ReportExport, 'leave.xlsx');
        $url = str_replace("length=20","length=-1",session('pdf_data'));
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url."&auth_id=".Auth::id()."&exportdata=".$request->get('exportdata'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // dd(json_decode($response));

        $user = User::where('id' , Auth::id())->first();
        //$allLeaves = LeaveList::Where('approver_id', $user->username);
        $leaves = json_decode($response)->data;

        $c_key = 'leave_reports';
        $columnHideShowData = DB::table('hide_show_columns')->select('c_value')->where(['username'=>getUserNameByRowId(Auth::id()), 'c_key'=>$c_key])->first();

        if($columnHideShowData){
            $columnHideShowData = $columnHideShowData->c_value;
        }else{
            $columnHideShowData = "['']";
        }

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $arrColumns = ["Emp No", "Name", "Relief", "Type", "Date", "Days", "Reason", "Status"];

          $startFrom = 65;
        for($i = 0; $i < count($arrColumns); $i++){
            if(!in_array($i, json_decode($columnHideShowData))){
                $sheet->setCellValue(chr($startFrom). 1, $arrColumns[$i]);
                $startFrom++;
            }
        }

        $rowss = 2;
            
        foreach($leaves as $request){
            $userPersonal = DB::table('user_personal')->where('username', $request->username)->first();
            $emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
            $emp_name = isset($userPersonal) ? $userPersonal->name : '';
            $status = '';
            $class= '';
            $htype= '';
            if($request->half_day_type=='first'){
                $htype='AM';
            }
            if($request->half_day_type=='second'){
                $htype='PM';
            }
            if($request->status == 0)
            {
                $status = 'Pending';
                $class= '#82868b';
            }
            elseif($request->status == 1)
            {
                $status = 'Approved';
                $class= '#28c76f';
            }
            elseif($request->status == 2)
            {
                $status = 'Rejected';
                $class= '#ea5455';
            }
            elseif($request->status == 3)
            {
                $status = 'Recommended';
                $class= '#7367f0';
            }
            elseif($request->status == 4)
            {
                $status = 'Cancelled';
                $class= '#00cfe8';
            }
            elseif($request->status == 5)
            {
                $status = 'Cancellation Pending';
                $class= '#ff9f43';
            }
            $r_name = '';
            if($request->relieve != '')
            {
                $employee = DB::table('user_personal')
                ->where('username', $request->relieve)->first();
                $r_name ='';
                if(!empty($employee))
                    $r_name = $employee->name;
            }
            if($request->type=='Line_Shut'){
                $iname='Out Of Office';
            }
            elseif($request->type=='Other_pay'){
                $iname='Replacement';
            }
            else{
                $iname=$request->type;
            }
             if($request->is_hourly == 1) {
             $ndays = $request->no_of_hours.' Hour(s)';
            } else {
            $ndays = $request->no_days.' '.$htype.' Day(s)';
            }
                                
            $arrRows = [$emp_no, $emp_name, $r_name, $request->typename, date('d-m-Y', strtotime($request->start_date)), $ndays,$request->reason,$status];
            $startFrom = 65;
            for($k = 0; $k < count($arrRows); $k++){
                if(!in_array($k, json_decode($columnHideShowData))){
                    $sheet->setCellValue(chr($startFrom) . $rowss, $arrRows[$k]); 
                    $startFrom++;
                }
            }
            $rowss++;
        
        }


        $fileName = "leave.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    }

    public function downloaduserinfoPDF(Request $request)
    {
        
        $hours = gethours();
        $user = UserPersonal::where('username',$request->get('username'))->first();
		$personal=UserPersonal::leftJoin('rest_day_category_employee', 'user_personal.username', '=', 'rest_day_category_employee.employee_id')->leftJoin('rest_day_category', 'rest_day_category_employee.category_id', '=', 'rest_day_category.id')->select('user_personal.*', 'rest_day_category_employee.*','rest_day_category.category as rcategory')->where('user_personal.username',$user->username)->first();
		$pay=UserPay::leftJoin('branch', 'user_pay.branch_id', '=', 'branch.id')->leftJoin('department', 'user_pay.department_id', '=', 'department.id')->leftJoin('category', 'user_pay.category_id', '=', 'category.id')->leftJoin('user_category', 'user_pay.username', '=', 'user_category.username')->leftjoin("category_name","category_name.id","=","user_category.category")->select('user_pay.*', 'branch.name as bname','department.name as dname','category.name as cname','category_name.name as ecategory')->where('user_pay.username',$user->username)->first();
		$permission=DB::table('map_employee_permission')->leftjoin('permission_group','map_employee_permission.permission_group_id','=','permission_group.id')->where('map_employee_permission.employee_id',$user->username)->first();
		$cl1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Compassionate')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		 
		$cl=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Compassionate')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		
		$cl=$cl1->total ?? 0 +$cl->total ?? 0;
		
		$hl1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Hospital')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
        $hl=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Hospital')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $hl=$hl->total ?? 0 +$hl1->total ?? 0;
        
        $ml1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Maternity')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
       
        $ml=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Maternity')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ml=$ml->total ?? 0 +$ml1->total ?? 0;
        
        $mr1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Marriage')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$mr=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Marriage')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$mr=$mr->total ?? 0 + $mr1->total ?? 0;
		
		$ex1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Examination')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ex=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Examination')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ex=$ex->total ?? 0 + $ex1->total ?? 0;
		
		$pt1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Paternity')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$pt=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Paternity')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$pt=$pt->total ?? 0 + $pt1->total ?? 0;
		
		$ad1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Advance')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ad=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Advance')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ad=$ad->total ?? 0 + $ad1->total ?? 0;
		
		$ls1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Line_Shut')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ls=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Line_Shut')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ls=$ls->total ?? 0 + $ls1->total ?? 0;
		
		$ab1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Absent')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ab=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Absent')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ab=$ab->total ?? 0 + $ab1->total ?? 0;
		
		$getSupervisors11=DB::table('map_employee_approver')->leftjoin('user_personal','map_employee_approver.approver_id','=','user_personal.username')->leftjoin('user_pay','map_employee_approver.approver_id','=','user_pay.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('map_employee_permission','map_employee_approver.approver_id','=','map_employee_permission.employee_id')->leftjoin('permission_group','map_employee_permission.permission_group_id','=','permission_group.id')->leftjoin('category','user_pay.category_id','=','category.id')->leftjoin('department','user_pay.department_id','=','department.id')
		->selectRaw("map_employee_approver.approver_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, permission_group.group_name as Role, user_personal.state")
		->where('map_employee_approver.employee_id',$user->username);
		$getSupervisors12=DB::table('map_employee_manager')->leftjoin('user_personal','map_employee_manager.manager_id','=','user_personal.username')->leftjoin('user_pay','map_employee_manager.manager_id','=','user_pay.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('category','user_pay.category_id','=','category.id')->leftjoin('department','user_pay.department_id','=','department.id')
		->selectRaw("map_employee_manager.manager_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, '' as Role, user_personal.state")
		->where('map_employee_manager.employee_id',$user->username)
		->union($getSupervisors11);
		$build_query = str_replace(['?'], ['\'%s\''], $getSupervisors12->toSql());
		$bindings = $getSupervisors12->getBindings();
		$query = vsprintf($build_query, $bindings);
		$getSupervisors = DB::select("SELECT * FROM (".$query.") x GROUP BY approver_id");

		
		$leaveinformation11=DB::table('leave_past')
		->selectRaw("CASE is_hourly WHEN 1 THEN ( (end_time-start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, is_hourly, 0, type, '-' as date_applied, '-' as dateapplied, DATE_FORMAT(start_date, '%d/%m/%Y') as start_date, DATE_FORMAT(end_date, '%d/%m/%Y') as end_date, total_leave_days as no_days, 1 as status, 'Past Leave' as reason,'' as filename, CASE total_leave_days WHEN 0.5 THEN ( CASE half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_type', '' as cancellation_reason,'' as r_name ")
		->where('username',$user->username);
		$leaveinformation=DB::table('leave_days')->leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->leftjoin('user_personal','leave_list.relieve','=','user_personal.username')
		->selectRaw("CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly, leave_days.id,  leave_list.type, DATE_FORMAT(leave_list.date_applied, '%d/%m/%Y') as date_applied, leave_list.date_applied as dateapplied, DATE_FORMAT(leave_days.date, '%d/%m/%Y') as start_date, DATE_FORMAT(leave_days.date, '%d/%m/%Y') as end_date, CASE leave_list.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status, leave_list.reason,leave_list.filename, CASE leave_list.is_half_day WHEN 1 THEN ( CASE leave_list.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, user_personal.name as r_name  ")
		->where('leave_days.username',$user->username)->union($leaveinformation11)->orderby('dateapplied','asc')->get();

		//dd($leaveinformation);

		$year = carbon()->year;
        // }
		if(getSettingsValue('leave_adjustment_type') == 8){
			$year =
			$joiningDate = getJoinDateStr($user->username);
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			// if ((isset($_POST["pdf"]))) {
			// } else {
				if (date('Y-m-d') < $curr_date) {
					$year = $year - 1;
				}
			// }
		}
		
		
		$approver = DB::table('map_employee_approver')->where('employee_id' , $user->username)->orderBy('approver_index' , 'asc')->get();
		$approvername = UserPersonal::where('username' , $approver[0]->approver_id)->get();
		//echo'<pre>';
		//print_r($user->username);
		//die();
        $userPay = UserPay::where('username' , $user->username)->first();
		$leaveTypes  = Leavetype::all();
    	 $leaveinformation112 = DB::table('leave_past')
                ->selectRaw("CASE is_hourly WHEN 1 THEN ( (end_time-start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, is_hourly, 0,'' as lid, type, '-' as date_applied, start_date as start_date, end_date as end_date, total_leave_days as no_days,  1 as status, 'Past Leave' as reason,'' as filename, CASE total_leave_days WHEN 0.5 THEN ( CASE half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_type', '' as cancellation_reason,'' as r_name ")
                ->where('username', $user->username);
        if (($only_current_year_leave_display->value ?? 0) == 1) {

            $leaveinformation112->whereYear('leave_past.start_date', '=', date('Y'));
        }
        //dd($only_current_year_leave_display);
        $leaveinformation2 = DB::table('leave_days')->leftjoin('leave_list', 'leave_days.leave_id', '=', 'leave_list.id')->leftjoin('user_personal', 'leave_list.relieve', '=', 'user_personal.username')
                ->selectRaw("CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly, leave_days.id,  leave_list.id as lid,leave_list.type, leave_list.date_applied as date_applied, leave_days.date as start_date, leave_days.date as end_date, CASE leave_list.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status, leave_list.reason,leave_list.filename, CASE leave_list.is_half_day WHEN 1 THEN ( CASE leave_list.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, user_personal.name as r_name  ");
        if (($only_current_year_leave_display->value ?? 0) == 1) {

            $leaveinformation2->whereYear('leave_days.date', '=', date('Y'));
        }
        $leaves = $leaveinformation2->where('leave_days.username', $user->username)->union($leaveinformation112)->get();
        
		$relieves = Relieve::orderBy('name')->get();
		$type = $request->get('type');
		$year11 = $request->get('year');
		$from = $request->get('from');
		$to = $request->get('to');
		$status = $request->get('status');
		$yr=date('Y');
		
    	$leaves =  $this->arrayPaginator($leaves, $request);
		
		
		// dd($leaves);


		$replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->get();
		$history = LeaveEntitleHistory::where('username' , $user->username)->where('year', carbon()->year)->get();
		
		$today = \Carbon\Carbon::now();

		$alHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Annual')->first();
		$medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Medical')->first();
		$repHistory = DB::table('leave_list')->where('username', $user->username)
					->where('type', 'Other_pay')->where('status', 1)->count();
		$totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');

		$cut_off_days = day_count_anniv_cutt_off($user->username, carbon()->year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Other_pay');//rithik
		$mBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Medical');
		$rBFAdj = getAdjustmentLeaveCount($user->username, carbon()->year, 1);
		$mbf = getBroughtForwardLeaveNotAdjusted($user->username, carbon()->year, 'Medical');
		$rbf = 0;
		$albf = 0;
		$aEntitle = getEntitleLeave($user->username, carbon()->year, 'Annual');
		$mEntitle = getEntitleLeave($user->username, carbon()->year, 'Medical');
		$rEntitle = '-';
		$aEarn = (date('n') / 12) * $aEntitle;
		$mEarn = '-';
		$rEarn = getTotalReplaceLeave( $user->username , carbon()->year);
		$aClaim = getAnnualClaimable($user->username, carbon()->year, 'Annual');
		$mClaim = (($mEntitle + $mBFAdj) * 2)/2;
		$rlClaim ="-";
		$anunpl = getNPLSummary($user->username, carbon()->year);
		$mcnpl = 0;
		$rpnpl = '-';
		$elTaken = getTakenLeves($user->username, carbon()->year, 'Emergency');
		$alTaken = getTakenLeves($user->username, carbon()->year, 'Annual');
		$mcTaken = getTakenLeves($user->username, carbon()->year, 'Medical');
		$rlTaken = getTakenLeves($user->username, carbon()->year, 'Other_pay');
		$forAlBf = $albf;
		$forAlBfAdj =  $aBFAdj;
		$forMC = $mbf;
		$forRL = $rbf;
		$alBalance = $aEntitle - $alTaken;
		$mcBalance = $mEntitle - $mcTaken;
		$rlBalance = $rEarn - $rlTaken;


        //* myleave curl for summary
        $username = $user->username;
        // $year = "";
       // $myLeaveSumm =  getYearlyEntitle($username, $year);
		$url = \Request::url();
        $name = $user->employee_no;
        $ln = 1;
        $aid = Auth::id();
        
        $url11 = str_replace("e-leave/user-info-pdf","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
      
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $myLeaveSumm = json_decode($response);
         if (!empty($myLeaveSumm)) {
            $myLeaveSumm = $myLeaveSumm[0];
        } else {
            $myLeaveSumm = '';
        }
        
        $url12 = str_replace("e-leave/user-info-pdf","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", $request->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }
        
        $url = str_replace("e-leave/user-info-pdf", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());

        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $myLeaveSummSm = json_decode($response);

        //dd($myLeaveSummSm);
        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }
		$dataArray = [
			'albf' => $albf, 'forAlBf' => $forAlBf,
			'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
			'rbf' => $rbf, 'forMC' => $forMC,
			'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
			'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
			'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
			'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
			'mEntitle' => $mEntitle,
			'rEntitle' => $rEntitle,
			'aEarn' => $aEarn,
			'mEarn' => $mEarn,
			'rEarn' => $rEarn,
			'aClaim' => $aClaim,
			'mClaim' => $mClaim,
			'rlClaim' => $rlClaim,
			'anunpl' => $anunpl,
			'mcnpl' => $mcnpl,
			'rpnpl' => $rpnpl,
			'elTaken' => $elTaken,
			'alTaken' => $alTaken,
			'mcTaken' => $mcTaken,
			'rlTaken' => $rlTaken,
		];
       
        $html = view('approvals.export.userinfopdf', compact('leaves','userPay','leaveTypes', 'replacement', 'relieves', 'history',
        'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray','myLeaveSumm','myLeaveSummSm','approver','approvername'
        ,'personal','pay','permission','cl','hl','ml','mr','ex','pt','ad','ls','ab','getSupervisors','leaveinformation','medicalSumm'))->render();
        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream('User Information');
        return 1;

    }
    public function arrayPaginator($array, $request)
	 {
	    $page = $request->get('page') ??  1;
	    $perPage = 9;
	    $offset = ($page * $perPage) - $perPage;
        $department = array_slice($array->toArray(), $offset, $perPage);
        $departments = new LengthAwarePaginator($department, count($array), $perPage, $page, [
            'path' => $request->url(),
            'query' => $request->query()
        ]);
	    return $departments;
	}
	
        public function userinfoexport()
    {
        //return Excel::download(new UserInfoReportExport(), 'user_leave_info.xlsx');
        $hours = gethours();
        $cutOffStartMonth=DB::table('settings')->where('field','cut_of_startmonth')->first();
        if($cutOffStartMonth->value!=1){
			if($cutOffStartMonth->value > date('m')){
				$currentYear = date('Y');
			}else{
				$currentYear = date('Y')+1;
			}
		}else{
			$currentYear = date('Y');
        }
        $year = carbon()->year;
        $user = UserPersonal::where('username',request()->get('username'))->first();
        $personaldetail =UserPersonal::selectRaw("user_personal.username, user_personal.employee_no, user_personal.employee_code, user_personal.employee_type, user_personal.designation, user_personal.name, user_personal.address, user_personal.postal_code, user_personal.town, user_personal.nationality, user_personal.state, user_personal.phone_no, user_personal.dob, user_personal.highest_education, user_personal.working_experience, user_personal.ic_no_old, user_personal.ic_no_new, user_personal.ic_color, user_personal.passport_no, user_personal.sex, user_personal.race, user_personal.bumiputra, user_personal.marital_status, user_personal.email_id, user_personal.blood_group, user_personal.profile_photo_file, rest_day_category.category as rest_day_group, user_personal.isDeleted ")->leftjoin('rest_day_category_employee','user_personal.username','=','rest_day_category_employee.employee_id')->leftjoin('rest_day_category','rest_day_category_employee.category_id','=','rest_day_category.id')->where('user_personal.username',$user->username)->first();
        $paydetail=UserPay::selectRaw("user_pay.job_title, user_pay.branch_id, branch.name as branch, user_pay.department_id, department.name as department, user_pay.category_id, category.name as category, DATE_FORMAT(user_pay.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(user_pay.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(user_pay.date_resigned, '%d-%m-%Y') as date_resigned,DATE_FORMAT(user_pay.date_confirmed, '%d-%m-%Y') as date_confirmed, user_pay.pay_rate_type, user_pay.pay_method, user_pay.pay_status, user_pay.contract")->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('department','user_pay.department_id','=','department.id')->leftjoin('category','user_pay.category_id','=','category.id')->where('user_pay.username',$user->username)->first();
        $categorydetail=DB::table('user_category')->leftjoin("category_name","category_name.id","=","user_category.category")->where('user_category.username',$user->username)->first();
        $permission=DB::table('map_employee_permission')->selectRaw("permission_group.id as permission_id, permission_group.type, permission_group.group_name, permission_group.eleave, permission_group.eclaim, permission_group.epay, permission_group.approval, permission_group.hr, permission_group.hr_applysubordinate, permission_group.settings, permission_group.view_leave, permission_group.approver_menu, permission_group.eleave_menu, permission_group.duty_rostere_viewe")->leftjoin('permission_group','map_employee_permission.permission_group_id','=','permission_group.id')->where('map_employee_permission.employee_id',$user->username)->first();
		$getSupervisors11=DB::table('map_employee_approver')->leftjoin('user_personal','map_employee_approver.approver_id','=','user_personal.username')->leftjoin('user_pay','map_employee_approver.approver_id','=','user_pay.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('map_employee_permission','map_employee_approver.approver_id','=','map_employee_permission.employee_id')->leftjoin('permission_group','map_employee_permission.permission_group_id','=','permission_group.id')->leftjoin('category','user_pay.category_id','=','category.id')->leftjoin('department','user_pay.department_id','=','department.id')->selectRaw("map_employee_approver.approver_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, permission_group.group_name as Role, user_personal.state")->where('map_employee_approver.employee_id',$user->username);
		$getSupervisors12=DB::table('map_employee_manager')->leftjoin('user_personal','map_employee_manager.manager_id','=','user_personal.username')->leftjoin('user_pay','map_employee_manager.manager_id','=','user_pay.username')->leftjoin('branch','user_pay.branch_id','=','branch.id')->leftjoin('category','user_pay.category_id','=','category.id')->leftjoin('department','user_pay.department_id','=','department.id')->selectRaw("map_employee_manager.manager_id as approver_id, user_personal.name, user_pay.date_commence as date_joined, user_personal.phone_no, branch.name as branch, category.name as category, department.name as department, '' as Role, user_personal.state")->where('map_employee_manager.employee_id',$user->username)->union($getSupervisors11);
		$build_query = str_replace(['?'], ['\'%s\''], $getSupervisors12->toSql());
		$bindings = $getSupervisors12->getBindings();
		$query = vsprintf($build_query, $bindings);
        $supervisor_information = DB::select("SELECT * FROM (".$query.") x GROUP BY approver_id");
        
		if(isset($supervisor_information[0])){
			$supervisor_info=$supervisor_information;
		}else{
			$supervisor_info=array();
		}
//         $annual_leave= getYearlyEntitle($user->username, $year);
//         $bf_forfeit_val = 0;
//         //bf_forfeit
//     	if($annual_leave['bf_forfeit']==1){
// 			$bf_forfeit_val = ($annual_leave['brought_forward']['annual']-$annual_leave['brought_forward']['annual_taken']);
// 		}

// 		$Forfeit_bf_val = 0;
// 		if($annual_leave['bfadj_forfeit']==1){
// 			$Forfeit_bf_val = ($annual_leave['brought_forward']['annual_adj']-$annual_leave['brought_forward']['bfAdjLeaveTaken']);
//         }
        $url = \Request::url();
        $name = $user->employee_no;
        $ln = 1;
        $aid = Auth::id();
        $url11 = str_replace("e-leave/user-info-export","public/listhrentitle.php?action=pdf&pagetype=annual&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
      
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url11."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $annual_leave = json_decode($response);
         if (!empty($annual_leave)) {
            $annual_leave = $annual_leave[0];
        } else {
            $annual_leave = '';
        }
        
        $url12 = str_replace("e-leave/user-info-export","public/listhrentitle.php?action=pdf&pagetype=medical&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());
        
        ini_set('memory_limit', -1);
        ini_set('max_execution_time', -1);
        $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $url12."&auth_id=".Auth::id(),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
       
        $medicalSumm = json_decode($response);
         if (!empty($medicalSumm)) {
            $medicalSumm = $medicalSumm[0];
        } else {
            $medicalSumm = '';
        }
        
        //bfadj_forfeit

		//Annual
        
        //Annual
		//Medical
		
//         $M_Entitle=round($annual_leave['medical']['entitle']*2)/2;
// 		$M_CL=($annual_leave['medical']['entitle']+$annual_leave['brought_forward']['medical_adj']);
// 		$M_Claimable=round($M_CL*2)/2;
		
// 		$M_BAL=($annual_leave['medical']['entitle'] + $annual_leave['brought_forward']['medical_adj'])-($annual_leave['medical']['taken']+$annual_leave['past_leaves']['medical']);
// 		$M_balance=round($M_BAL*2)/2;
		
        //Medical
		//Replacement
		
        
        $url = str_replace("e-leave/user-info-export", "public/rlentitle.php?action=pdf&add_limit=yes&auth_id=$aid&totalemp=&rlimit=$ln&name=$name&test=1", request()->getUri());

        //dd(session('rreplacement_pdf_data'),$url);
        //$url = session('rreplacement_pdf_data');
        ini_set('memory_limit', -1);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        //dd($url);
        $response = curl_exec($curl);
        curl_close($curl);
        // dd($response);
        $myLeaveSummSm = json_decode($response);

        //dd($myLeaveSummSm);
        if (!empty($myLeaveSummSm)) {
            $myLeaveSummSm = $myLeaveSummSm[0];
        } else {
            $myLeaveSummSm = '';
        }

        $rl_leave=$myLeaveSummSm;
       // dd($rl_leave);
        //replacement 
        //leave summary
        $cl1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Compassionate')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
	 
		$cl=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Compassionate')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		
		$cl=$cl1->total ?? 0 + $cl->total ?? 0;
		
		$hl1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Hospital')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		;
        $hl=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Hospital')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $hl=$hl->total ?? 0 + $hl1->total ?? 0;
        
        $ml1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Maternity')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
       
        $ml=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Maternity')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
        $ml=$ml->total ?? 0 + $ml1->total ?? 0;
        
        $mr1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Marriage')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$mr=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Marriage')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$mr=$mr->total ?? 0 + $mr1->total ?? 0;
		
		$ex1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Examination')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ex=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Examination')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ex=$ex->total ?? 0 + $ex1->total ?? 0;
		
		$pt1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Paternity')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$pt=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Paternity')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$pt=$pt->total ?? 0 + $pt1->total ?? 0;
		
		$ad1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Advance')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ad=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Advance')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ad=$ad->total ?? 0 + $ad1->total ?? 0;
		
		$ls1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Line_Shut')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ls=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Line_Shut')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ls=$ls->total ?? 0 + $ls1->total ?? 0;
		
		$ab1=DB::table('leave_past')->where('leave_past.status','1')->where('leave_past.type','Absent')->where('leave_past.username',$user->username)->selectRaw("sum(CASE leave_past.is_hourly WHEN 1 THEN (((leave_past.end_time-leave_past.start_time)/3600 )/'$hours') WHEN 0 THEN leave_past.total_leave_days END) as total")->first();
		$ab=LeaveDay::leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->where('leave_days.status','1')->where('leave_list.type','Absent')->where('leave_days.username',$user->username)->selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as total")->first();
		$ab=$ab->total ?? 0 + $ab1->total ?? 0;
        
	
        $leaveinformation11=DB::table('leave_past')
        ->selectRaw("CASE is_hourly WHEN 1 THEN ( (end_time-start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours, is_hourly, 0, type, '-' as date_applied, '-' as dateapplied, DATE_FORMAT(start_date, '%d/%m/%Y') as start_date, DATE_FORMAT(end_date, '%d/%m/%Y') as end_date, total_leave_days as no_days, 1 as status, 'Past Leave' as reason,'' as filename, CASE total_leave_days WHEN 0.5 THEN ( CASE half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 1 THEN '' END as 'half_day_type', '' as cancellation_reason,'' as r_name ")
        ->where('username',$user->username);
        $leaveinformation=DB::table('leave_days')->leftjoin('leave_list','leave_days.leave_id','=','leave_list.id')->leftjoin('user_personal','leave_list.relieve','=','user_personal.username')
        ->selectRaw("CASE leave_list.is_hourly WHEN 1 THEN ( (leave_list.end_time-leave_list.start_time)/3600 ) WHEN 0 THEN 0 END as no_of_hours,leave_list.is_hourly, leave_days.id,  leave_list.type, DATE_FORMAT(leave_list.date_applied, '%d/%m/%Y') as date_applied, leave_list.date_applied as dateapplied, DATE_FORMAT(leave_days.date, '%d/%m/%Y') as start_date, DATE_FORMAT(leave_days.date, '%d/%m/%Y') as end_date, CASE leave_list.is_half_day WHEN 1 THEN 0.5 WHEN 0 THEN 1 END as 'no_days', leave_days.status, leave_list.reason,leave_list.filename, CASE leave_list.is_half_day WHEN 1 THEN ( CASE leave_list.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type', leave_days.cancellation_reason, user_personal.name as r_name  ")
        ->where('leave_days.username',$user->username)->union($leaveinformation11)->orderby('dateapplied','asc')->get();

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A'. 1, 'Staff Information');
        $sheet->setCellValue('A'. 2, 'Emp No');
        $sheet->setCellValue('B'. 2, 'Name');
        $sheet->setCellValue('C'. 2, 'Date of Join');
        $sheet->setCellValue('D'. 2, 'Date confirm');
        $sheet->setCellValue('E'. 2, 'Entitle category');
        $sheet->setCellValue('F'. 2, 'Rest day group');
        $sheet->setCellValue('G'. 2, 'Phone No');
        $sheet->setCellValue('H'. 2, 'Branch');
        $sheet->setCellValue('I'. 2, 'Department');
        $sheet->setCellValue('J'. 2, 'Category');
        $sheet->setCellValue('K'. 2, 'Employee Role');
        $sheet->setCellValue('L'. 2, 'State');

        $sheet->setCellValue('A' . 3, $personaldetail->employee_no);
        $sheet->setCellValue('B' . 3, $personaldetail->name);
        $sheet->setCellValue('C' . 3, $paydetail->date_commence);
        $sheet->setCellValue('D' . 3, $paydetail->date_confirmed);
        $sheet->setCellValue('E' . 3, $categorydetail->name);
        $sheet->setCellValue('F' . 3, $personaldetail->rest_day_group);
        $sheet->setCellValue('G' . 3, $personaldetail->phone_no);
        $sheet->setCellValue('H' . 3, $paydetail->branch);
        $sheet->setCellValue('I' . 3, $paydetail->department);
        $sheet->setCellValue('J' . 3, $paydetail->category);
        $sheet->setCellValue('K' . 3, $permission->group_name);
        $sheet->setCellValue('L' . 3, $personaldetail->state);


        $sheet->setCellValue('A'. 5, 'Supervisor Information');
        $sheet->setCellValue('A'. 6, 'Emp No');
        $sheet->setCellValue('B'. 6, 'Name');
        $sheet->setCellValue('C'. 6, 'Date of Join');
        $sheet->setCellValue('D'. 6, 'Phone No');
        $sheet->setCellValue('E'. 6, 'Branch');
        $sheet->setCellValue('F'. 6, 'Department');
        $sheet->setCellValue('G'. 6, 'Category');
        $sheet->setCellValue('H'. 6, 'Employee Role');
        $sheet->setCellValue('I'. 6, 'State');
        $rows = 6;
        foreach($supervisor_info as $supervisor_infos){
            $rows++;
            $sheet->setCellValue('A' . $rows, $supervisor_infos->approver_id);
            $sheet->setCellValue('B' . $rows, $supervisor_infos->name);
            $sheet->setCellValue('C' . $rows, !is_null($supervisor_infos->date_joined) ? date('d-m-Y', strtotime($supervisor_infos->date_joined)) : "");
            $sheet->setCellValue('D' . $rows, $supervisor_infos->phone_no);
            $sheet->setCellValue('E' . $rows, $supervisor_infos->branch);
            $sheet->setCellValue('F' . $rows, $supervisor_infos->category);
            $sheet->setCellValue('G' . $rows, $supervisor_infos->department);
            $sheet->setCellValue('H' . $rows, $supervisor_infos->Role);
            $sheet->setCellValue('I' . $rows, $supervisor_infos->state);
            
            }

        $rows = $rows+2;
        $rows1 = $rows+1;
        $sheet->setCellValue('A'. $rows, 'Leave Summary');
        $sheet->setCellValue('A'. $rows1, 'Leave Type');
        $sheet->setCellValue('B'. $rows1, 'BF');
        $sheet->setCellValue('C'. $rows1, 'BF Adj');
        $sheet->setCellValue('D'. $rows1, 'Entitle');
        $sheet->setCellValue('E'. $rows1, 'Earn');
        $sheet->setCellValue('F'. $rows1, 'Claimable');
        $sheet->setCellValue('G'. $rows1, 'NPL');
        $sheet->setCellValue('H'. $rows1, 'Taken EL');
        $sheet->setCellValue('I'. $rows1, 'Taken Al');
        $sheet->setCellValue('J'. $rows1, 'Forfeit BF');
        $sheet->setCellValue('K'. $rows1, 'Forfeit Adj');
        $sheet->setCellValue('L'. $rows1, 'Balance');
        
        $rows2=$rows+2;
        $sheet->setCellValue('A'. $rows2, 'Annual Leave');
        $sheet->setCellValue('B'. $rows2, $annual_leave->abf);
        $sheet->setCellValue('C'. $rows2, $annual_leave->abfadj);
        $sheet->setCellValue('D'. $rows2, $annual_leave->aentitle);
        $sheet->setCellValue('E'. $rows2, $annual_leave->aearn);
        $sheet->setCellValue('F'. $rows2, $annual_leave->claimable);
        $sheet->setCellValue('G'. $rows2, $annual_leave->anpl);
        $sheet->setCellValue('H'. $rows2, $annual_leave->atakenel);
        $sheet->setCellValue('I'. $rows2, $annual_leave->atakenal);
        $sheet->setCellValue('J'. $rows2, $annual_leave->aforfeitbf );
        $sheet->setCellValue('K'. $rows2, $annual_leave->aforfeitadj );
        $sheet->setCellValue('L'. $rows2, $annual_leave->balance);

        $rows3=$rows+3;
        $sheet->setCellValue('A'. $rows3, 'Medical Leave');
        $sheet->setCellValue('B'. $rows3, $medicalSumm->mbf);
        $sheet->setCellValue('C'. $rows3, $medicalSumm->mbfadj);
        $sheet->setCellValue('D'. $rows3, $medicalSumm->mentitle);
        $sheet->setCellValue('E'. $rows3, '-');
        $sheet->setCellValue('F'. $rows3, $medicalSumm->mclaimable);
        $sheet->setCellValue('G'. $rows3, $medicalSumm->mnpl);
        $sheet->setCellValue('H'. $rows3, $medicalSumm->mtaken);
        $sheet->setCellValue('I'. $rows3, '');
        $sheet->setCellValue('J'. $rows3, '0');
        $sheet->setCellValue('K'. $rows3, '');
        $sheet->setCellValue('L'. $rows3, $medicalSumm->mbalance);
        
        $rows4=$rows+4;
        $sheet->setCellValue('A'. $rows4, 'Replacement Leave');
        $sheet->setCellValue('B'. $rows4, $rl_leave->bf);
        $sheet->setCellValue('C'. $rows4, $rl_leave->bfadj);
        $sheet->setCellValue('D'. $rows4, '-');
        $sheet->setCellValue('E'. $rows4, $rl_leave->granted);
        $sheet->setCellValue('F'. $rows4, '-');
        $sheet->setCellValue('G'. $rows4, '-');
        $sheet->setCellValue('H'. $rows4, $rl_leave->taken);
        $sheet->setCellValue('I'. $rows4, '');
        $sheet->setCellValue('J'. $rows4, $rl_leave->forfeit);
        $sheet->setCellValue('K'. $rows4, '');
        $sheet->setCellValue('L'. $rows4, $rl_leave->balance);

        $rows7 =$rows+7;
        $rows8 =$rows+8;
        $sheet->setCellValue('A'. $rows7, 'All Leave Summary ');
        $sheet->setCellValue('A'. $rows8, 'User');
        $sheet->setCellValue('B'. $rows8, 'MT');
        $sheet->setCellValue('C'. $rows8, 'MR');
        $sheet->setCellValue('D'. $rows8, 'CL');
        $sheet->setCellValue('E'. $rows8, 'HL');
        $sheet->setCellValue('F'. $rows8, 'EX');
        $sheet->setCellValue('G'. $rows8, 'PT');
        $sheet->setCellValue('H'. $rows8, 'AD');
        $sheet->setCellValue('I'. $rows8, 'LS');
        $sheet->setCellValue('J'. $rows8, 'AB');

        $rows9 =$rows+9;
        $sheet->setCellValue('A'. $rows9, $user->username);
        $sheet->setCellValue('B'. $rows9, $ml);
        $sheet->setCellValue('C'. $rows9, $mr);
        $sheet->setCellValue('D'. $rows9, $cl);
        $sheet->setCellValue('E'. $rows9, $hl);
        $sheet->setCellValue('F'. $rows9, $ex);
        $sheet->setCellValue('G'. $rows9, $pt);
        $sheet->setCellValue('H'. $rows9, $ad);
        $sheet->setCellValue('I'. $rows9, $ls);
        $sheet->setCellValue('J'. $rows9, $ab);

        $rows12=$rows+12;
        $rows13=$rows+13;
        $sheet->setCellValue('A'. $rows12, 'Leave Information ');
        $sheet->setCellValue('A'. $rows13, 'Date Applied');
        $sheet->setCellValue('B'. $rows13, 'Relieve');
        $sheet->setCellValue('C'. $rows13, 'Leave Type');
        $sheet->setCellValue('D'. $rows13, 'Leave Date');
        $sheet->setCellValue('E'. $rows13, 'Days');
        $sheet->setCellValue('F'. $rows13, 'Status');
        $sheet->setCellValue('G'. $rows13, 'Reason');
        $i=($rows+14);
        foreach($leaveinformation as $leaveinformations){
            $leavetypename = DB::table('leave_name')->where('type', $leaveinformations->type)->first();
                                                 
            if($leaveinformations->status==0){
                $status ="Pending";
            }
            if($leaveinformations->status==1) {
                $status="Approved"; 
            }
            if($leaveinformations->status==2) {
                $status="Rejected";
            }
            if($leaveinformations->status==3){
                $status="Recommended";
            } 
            if($leaveinformations->status==4) {
                $status="Cancelled";
            }
            if($leaveinformations->status==5) {
                $status="Cancellation Pending";
            }
            
            if($leaveinformations->half_day_type=='first'){
                $htype='AM';
            }
            elseif($leaveinformations->half_day_type=='second'){
                $htype='PM';
            }
            else{
                $htype='';
            }
            $type =  $leavetypename->name ?? "";
            if($leaveinformations->reason=="Past Leave"){
                $dt="-";
            }
            else{
                $dt=$leaveinformations->date_applied;
            }
            if($leaveinformations->is_hourly!=0){ 
                $nodays = number_format((float)$leaveinformations->no_of_hours, 2, '.', '').'Hour(s)'; 
                
            } else 
            { 
                $nodays = $leaveinformations->no_days.' '.$htype.'Day(s)'; 
            }
            $sheet->setCellValue('A' . $i, $dt);
            $sheet->setCellValue('B' . $i, $leaveinformations->r_name);
            $sheet->setCellValue('C' . $i, $type);
            $sheet->setCellValue('D' . $i, $leaveinformations->start_date);
            $sheet->setCellValue('E' . $i, $nodays);
            $sheet->setCellValue('F' . $i, $status);
            $sheet->setCellValue('G' . $i, $leaveinformations->reason);
            $i++;
            }

        $fileName = "user_leave_info.xlsx";
        //dd($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$writer->save('user_leave_info.xlsx');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
        $writer->save('php://output');
    

        }

}