<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\{
    User,
    UserPay,
    UserPersonal,
    Schedule,
    DutyRoster,
    ScheduleWeek,
    Setting,
    Clockin,
    TimeChange
};
use Auth,
    DateTime,
    Yajra\DataTables\DataTables;
use Validator;

class ScheduleController extends Controller
{



    public function schedule()
    {

        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        return view('E-Attendance.schedule.clockin_schedule', compact('userPay'));
    }

    public function scheduledata(Request $request)
    {
         $scheduleData = DB::table('schedule')
            ->leftjoin('user_personal', 'schedule.id', '=', 'user_personal.schedule_id')  
            ->leftjoin('duty_roaster_dates','schedule.id', '=','duty_roaster_dates.schedule_id')
            ->select('schedule.*','duty_roaster_dates.schedule_id as Schedule_id' , 'user_personal.schedule_id as scheduleId')
            ->latest('id')
            ->groupBy('schedule.id')
            ->get();
            
            $scheduleData->map(function ($item, $index) {

                $index++;
                $item->index = $index;
    
                return $item;
            });
            //dd($scheduleData);
        return DataTables::of($scheduleData)->make(true);
    }


    function createSchedule()
    {
        $categorynames =   [
            ['week_day' => 'Sun', 'day_type' => 'Rest', 'entry' => '0', 'break' => '0', 'user_resume' => '0', 'user_leave' => '0', 'schedule_range' => '0', 'flexi_lunch' => '0', 'min_ot' => '0', 'min_flexi_hour' => '0'],
            ['week_day' => 'Mon', 'day_type' => 'Work', 'entry' => '08:00', 'break' => '12:00', 'user_resume' => '13:00', 'user_leave' => '17:00', 'schedule_range' => '30', 'flexi_lunch' => '30', 'min_ot' => '30', 'min_flexi_hour' => '30'],
            ['week_day' => 'Tue', 'day_type' => 'Work', 'entry' => '08:00', 'break' => '12:00', 'user_resume' => '13:00', 'user_leave' => '17:00', 'schedule_range' => '30', 'flexi_lunch' => '30', 'min_ot' => '30', 'min_flexi_hour' => '30'],
            ['week_day' => 'Wed', 'day_type' => 'Work', 'entry' => '08:00', 'break' => '12:00', 'user_resume' => '13:00', 'user_leave' => '17:00', 'schedule_range' => '30', 'flexi_lunch' => '30', 'min_ot' => '30', 'min_flexi_hour' => '30'],
            ['week_day' => 'Thu', 'day_type' => 'Work', 'entry' => '08:00', 'break' => '12:00', 'user_resume' => '13:00', 'user_leave' => '17:00', 'schedule_range' => '30', 'flexi_lunch' => '30', 'min_ot' => '30', 'min_flexi_hour' => '30'],
            ['week_day' => 'Fri', 'day_type' => 'Work', 'entry' => '08:00', 'break' => '12:00', 'user_resume' => '13:00', 'user_leave' => '17:00', 'schedule_range' => '30', 'flexi_lunch' => '30', 'min_ot' => '30', 'min_flexi_hour' => '30'],
            ['week_day' => 'Sat', 'day_type' => 'Rest', 'entry' => '0', 'break' => '0', 'user_resume' => '0', 'user_leave' => '0', 'schedule_range' => '0', 'flexi_lunch' => '0', 'min_ot' => '0', 'min_flexi_hour' => '0']
        ];
        return view('E-Attendance.schedule.create_schedule', compact('categorynames'));
    }


    function getScheduleType(Request $request)
    {
        $eattendance_type = $request->eattendance_type;
        if ($eattendance_type == 'schedule') {
            $schedule =  Schedule::select('*')->get();
            return $schedule;
        } elseif ($eattendance_type == 'duty_roaster') {

            $schedule =  DutyRoster::select('*')->get();
            return $schedule;
        }
    }

function empSchedule()
    {
        $schedules = Schedule::select('name','id')->get();
        return view('E-Attendance.schedule.schedule_to_emp',compact('schedules'));
    }


    function insterscheduleData(Request $request)
    {

        $schedule =  new Schedule();
        $request->validate([
            'schedule_id' => 'required',
            'work_schedule' => 'required',
            'name' => 'required',
            'description' => 'required',
             'color' => 'required',
            // 'weekday.*' => 'required',
            // 'daytype.*' => 'required',
            // 'intime.*' => 'required',
            // 'breaktime.*' => 'required',
            // 'resumetime.*' => 'required',
            // 'outtime.*' => 'required',
            // 'range.*' => 'required',
            // 'flexi_lunch.*' => 'required',
            // 'min_ot.*' => 'required',


        ]);


        $schedule->schedule_id = $request->schedule_id;
        $schedule->work_schedule = $request->work_schedule;
        $schedule->name = $request->name;
        $schedule->description = $request->description;
        $schedule->color = $request->color;
        $schedule->save();
        $schedule_id = DB::getPdo()->lastInsertId();
        $array = [];
        foreach ($request->weekday as $key => $weekday) {
            $newArray['schedule_id'] = $schedule_id;
            $newArray['week_day'] = $weekday;
            $newArray['day_type'] = $request->daytype[$key];
            $newArray['entry'] = $request->intime[$key];
            $newArray['break'] = $request->breaktime[$key];
            $newArray['user_resume'] = $request->resumetime[$key];
            $newArray['user_leave'] = $request->outtime[$key];
            $newArray['schedule_range'] = $request->range[$key];
            $newArray['flexi_lunch'] = $request->flexi_lunch[$key];
            $newArray['min_ot'] = $request->min_ot[$key];
            $newArray['min_flexi_hour'] = $request->min_flex_hour[$key];
            array_push($array, $newArray);
        }
        ScheduleWeek::insert($array);


        return redirect('e-attendance/schedule');
    }




    public function removeSchedule(Request $request)
    {
        $scheduleId = $request->id;
        Schedule::where('id', $scheduleId)->delete();
        return redirect('e-attendance/schedule');
    }



    public function updateschedule($schedule_id)
    {

        $scheduledata  = Schedule::where('id', $schedule_id)->get();
        $weekdatas     = ScheduleWeek::where('schedule_id', $schedule_id)->get();

        return view('E-Attendance.schedule.edit_schedule', compact('scheduledata', 'weekdatas'));
    }


    public function editschedule(Request $request)
    {
      
        $request->validate([
            'schedule_id' => 'required',
            'work_schedule' => 'required',
            'name' => 'required',
            'description' => 'required',
            'color' => 'required',


        ]);


        $schedule['schedule_id'] = $request->schedule_id;
        $schedule['work_schedule'] = $request->work_schedule;
        $schedule['name'] = $request->name;
        $schedule['description'] = $request->description;
        $schedule['color'] = $request->color;

        Schedule::where('id', $request->id)->update($schedule);

        $array = [];
        foreach ($request->weekday as $key => $weekday) {

            $newArray = ScheduleWeek::where('schedule_id', $request->id)->where('week_day', $weekday)->first();
            if ($newArray == null) {
                $newArray = new ScheduleWeek();
                $newArray->schedule_id = $request->id;
                $newArray->week_day = $weekday;
                $newArray->save();
            }

            $newArray->day_type = $request->daytype[$key];
            $newArray->entry = $request->intime[$key];
            $newArray->break = $request->breaktime[$key];
            $newArray->user_resume = $request->resumetime[$key];
            $newArray->user_leave = $request->outtime[$key];
            $newArray->schedule_range = $request->range[$key];
            $newArray->flexi_lunch = $request->flexi_lunch[$key];
            $newArray->min_ot = $request->min_ot[$key];
            $newArray['min_flexi_hour'] = $request->min_flex_hour[$key];
            $newArray->save();
        }

        return redirect('e-attendance/schedule');
    }
    function mapAttendance(Request $request)
    {
        $emp_arr =$request->employee_id;
        $userpersonal['eattendance_type'] = $request->eattendance_type;
        $userpersonal['schedule_id'] = $request->schedule_id;
          $userpersonal['duty_roaster_id'] =NULL;
        //print_r($userpersonal['schedule_id']);
       for($i = 0 ; $i<count($emp_arr) ; $i++){
           $result =   UserPersonal::where('username', $emp_arr[$i])->update($userpersonal);
       }
        return true;
    }
    
    
    
    
    public function Empscheduledata(Request $request)
    {

        $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        $scheduleData = UserPersonal::select('user_personal.name as name','user_personal.username', 'schedule.name as sname')->leftjoin('schedule', 'schedule.id', '=', 'user_personal.schedule_id')->whereNull('user_personal.schedule_id')->get();;
        return DataTables::of($scheduleData)->make(true);
    }

   function employeescheduleData(Request $request)
   {
            $ActiveUserShownStatus1 = Setting::where('field', 'active_user_shown')->first();
            $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
            $user = User::where('id', Auth::id())->first();

            $scheduleData = UserPersonal::select('user_personal.name as name','user_personal.username', 'schedule.name as sname','user_personal.schedule_id')->join('schedule', 'schedule.id', '=', 'user_personal.schedule_id')->leftjoin('user_pay', 'user_personal.username', '=', 'user_pay.username');
    

            if ($request->schedule_id != 'not_assign_schedule' && $request->schedule_id)
                $scheduleData = $scheduleData->where('user_personal.schedule_id', $request->schedule_id);
            

            if ($request->schedule_id == 'not_assign_schedule')
                $scheduleData = $scheduleData->whereNull('user_personal.schedule_id');

            if ($ActiveUserShownStatus == '0') {
                $scheduleData = $scheduleData->where('user_pay.pay_status', '=', '1');
            }

        $scheduleData =  $scheduleData->get();
    
        $scheduleData->map(function ($item, $index) {
        $index++;
        $item->name = $item->name;
        if ($item->sname) {
            $item->schedule_name = $item->sname;
        } else {
            $item->schedule_name = "--";
        }

        return $item;
    });
    return DataTables::of($scheduleData)->make(true);
   }

// edit
     public function editattendancebyhr(Request $request)
    {
     
        $working_day = $request->working_day;
        $empid = $request->empid;
        $time_old_val = $request->time_old_val;
        $name = $request->empName;

        $devicename = $request->devicename;
        
        $update_data = [
            'time' => $request->time,
            'devicename' => $request->devicename,
        ];

        if($time_old_val!=''){
            $clockin_id =  DB::table('clockin')->where('employee_no',$empid)->where('working_day',$working_day)->where('time',$time_old_val)->first();
            $clockin_id = $clockin_id->id;
        }else{
            $clockin_id = 0;
        }
        //changed for audit by Ashutosh 
        $timeStore = new TimeChange();
        $timeStore->admin = Auth::id();
        $timeStore->employee_no = $empid;
        $timeStore->date = $working_day;
        $timeStore->time_from = $time_old_val;
        $timeStore->time_to = $request->time;
        $timeStore->clockin_id = $clockin_id;
        $timeStore->save();
        
        if($time_old_val!=''){
            $result=  DB::table('clockin')->where('employee_no',$empid)->where('working_day',$working_day)->where('time',$time_old_val)->update($update_data);
            return "updated";
        }else{

            Clockin::insert(array(

                'employee_no'     => $empid,
                'personname'      =>  $name,
                'datetime'        => $working_day." ".$request->time,
                'date'            => $working_day,
                'time'            => $request->time,
                'direction'       => "IN",
                'devicename'     =>  $devicename,
            // 'serialNumber'  =>  $serial_no,
            // 'serialNo'      =>  $serialNo,
                //'cardno'        =>  $cardReaderNo,
                'working_day'     =>  $working_day,
                'updated_at'     =>  date("Y-m-d H:i:s")

            ));

            return "inserted";
            }
    }
    
    public function dltattendancebyhr(Request $request)
    {
     
        $working_day = $request->working_day;
        $empid = $request->empid;
        $time_old_val = $request->time_old_val;
        $name = $request->empName;

        $devicename = $request->devicename;
        
        $update_data = [
            'time' => $request->time,
            'devicename' => $request->devicename,
        ];

        if($time_old_val!=''){
            $clockin_id =  DB::table('clockin')->where('employee_no',$empid)->where('working_day',$working_day)->where('time',$time_old_val)->first();
            DB::table('clockin')->where('id',$clockin_id->id)->delete();
        }
        //changed for audit by Ashutosh 
        $timeStore = new TimeChange();
        $timeStore->admin = Auth::id();
        $timeStore->employee_no = $empid;
        $timeStore->date = $working_day;
        $timeStore->time_from = $time_old_val;
        $timeStore->time_to = $request->time;
        $timeStore->clockin_id = 0;
        $timeStore->save();
        return 1;
    }
    
    
    public function updateAssignschedule(Request $request)
    {
        $schedule_id = $request->schedule_id;
        $empUsername = $request->empUsername;
        UserPersonal::where('username', $empUsername)->update(['schedule_id' => $schedule_id]);
        return true;
    }

    public function unassignschedule(Request $request)
    {
        $empUsername =($request->empUsernames);
        DB::table('user_personal')
        ->whereIn('username',[$empUsername])
        ->update(['schedule_id' =>NULL,'eattendance_type'=>NULL]);
        return true;
    }

}
