<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use File;
use SimpleXMLElement;
use App\Models\{Setting, Detail, Email_preference, Sms_preference, User,
    Email_content_preference,
    UserPay
};
use Hash;
use Response;
//use DB;
use Illuminate\Support\Facades\DB;
use Validator;
use ZipArchive;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;

class SettingsController extends Controller
{
    //

    protected $storageDriver;

    public function __construct()
    {
      $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }
    
    public function settings()
    {

        return view('settings.settings');
    }

    public function getPermissionList()
    {
        $result = $this->getPermissionList11();
        return DataTables::of($result)->make(true);
    }

    public function getPermissionList11()
    {
        $result = DB::table('permission_group')->get();
        for (
            $i = 0;
            $i < count($result);
            $i++
        ) {
            if ($this->isPermissionAlreadyAssign($result[$i]->id)) {
                $result[$i]->is_allow_to_delete = false;
            } else {
                $result[$i]->is_allow_to_delete = true;
            }
        }

        return $result;
    }

    public function getPermissiondata($id)
    {
        $result = DB::table('permission_group')->where('id', $id)->get();
        return $result;
    }

    public function editPermissionGroup(Request $request)
    {
        $id = $request->id;
        $groupName = $request->group_name;
        $eleave = $request->eleave;
        $eclaim = $request->eclaim;
        $epay = $request->epay;
        $e_payslip_download = $request->e_payslip_download;
        $approval = $request->approval;
        $hr = $request->hr;
        $hr_applysubordinate = $request->hr_applysubordinate;
        $settings = $request->settings;
        $viewLeave = $request->view_leave;
        $global_search = $request->global_search;
        $rl_allow = $request->rl_allow;
        $apply_rl = $request->apply_rl;
        $cancel_leave = $request->cancel_leave;
        $hr_leave_edit = $request->hr_leave_edit;
        $hr_menu = $request->hr_menu;
        $approver_menu = $request->approver_menu;
        $eleave_menu = $request->eleave_menu;
        $duty_rostere_viewe = $request->duty_rostere_viewe;
        $hr_leave_control = $request->hr_leave_control;
        $hr_leave_entitle = $request->hr_leave_entitle;
        $hr_add_employee = $request->hr_add_employee;
        $hr_edit_employee = $request->hr_edit_employee;
        $hr_setup_leave_edit = $request->hr_setup_leave_edit;

        $approval_view_all = $request->approval_view_all;
        $hr_view_all = $request->hr_view_all;
        $e_attendance_status = $request->e_attendance_status;
        $e_attendance_hr = $request->e_attendance_hr;
        $e_attendance_empl = $request->e_attendance_empl;
        $edit_attendance1 = $request->edit_attendance1;
        $attendance_audit = $request->attendance_audit;
        $eclaim_audit = $request->eclaim_audit;
        $leave_audit = $request->leave_audit;
        $approval_ot = $request->approval_ot;


        $groupsExist = $this->isPermissionGroupExist11($groupName, $id);
        if ($groupsExist) {
            $result = $this->editPermissionGroup11($id, $groupName, $eleave, $eclaim, $epay, $approval, $hr, $settings, $viewLeave, $global_search, $rl_allow, $apply_rl, $cancel_leave, $hr_leave_edit, $hr_menu, $approver_menu, $eleave_menu, $e_payslip_download, $duty_rostere_viewe, $hr_applysubordinate, $hr_leave_control, $hr_leave_entitle, $hr_add_employee, $hr_edit_employee, $hr_setup_leave_edit, $approval_view_all, $hr_view_all,$e_attendance_status,$e_attendance_hr,$e_attendance_empl,$edit_attendance1, $attendance_audit, $eclaim_audit,$leave_audit, $approval_ot);
        } else {
            $result = false;
        }
        return array('result' => $result);
    }

    public function editPermissionGroup11($id, $groupName, $eleave, $eclaim, $epay, $approval, $hr, $settings, $viewLeave, $global_search, $rl_allow, $apply_rl, $cancel_leave, $hr_leave_edit, $hr_menu, $approver_menu, $eleave_menu, $e_payslip_download, $duty_rostere_viewe, $hr_applysubordinate, $hr_leave_control, $hr_leave_entitle, $hr_add_employee, $hr_edit_employee, $hr_setup_leave_edit, $approval_view_all, $hr_view_all,$e_attendance_status,$e_attendance_hr,$e_attendance_empl,$edit_attendance1, $attendance_audit, $eclaim_audit, $leave_audit, $approval_ot)
    {

        $result = DB::table('permission_group')->where('id', $id)->update(array('group_name' => $groupName, 'eleave' => $eleave, 'eclaim' => $eclaim, 'epay' => $epay, 'approval' => $approval, 'hr' => $hr, 'settings' => $settings, 'view_leave' => $viewLeave, 'global_search' => $global_search, 'rl_allow' => $rl_allow, 'apply_rl' => $apply_rl, 'cancel_leave' => $cancel_leave, 'hr_leave_edit' => $hr_leave_edit, 'hr_menu' => $hr_menu, 'approver_menu' => $approver_menu, 'eleave_menu' => $eleave_menu, 'epay_download' => $e_payslip_download, 'hr_applysubordinate' => $hr_applysubordinate, 'duty_rostere_viewe' => $duty_rostere_viewe, 'hr_leave_control' => $hr_leave_control, 'hr_leave_entitle' => $hr_leave_entitle, 'hr_add_employee' => $hr_add_employee, 'hr_edit_employee' => $hr_edit_employee, 'hr_setup_leave_edit' => $hr_setup_leave_edit, 'approval_view_all' => $approval_view_all, 'hr_view_all' => $hr_view_all, 'e_attendance' => $e_attendance_status, 'admin_e_attndnc' => $e_attendance_hr, 'emp_e_attndnc' => $e_attendance_empl,'edit_attendance'=>$edit_attendance1, 'attendance_audit'=>$attendance_audit, 'eclaim_audit'=>$eclaim_audit, 'leave_audit'=>$leave_audit, 'approval_ot'=>$approval_ot));
        return true;
    }

    public function deletePermissionGroup(Request $request)
    {
        $id = $request->id;
        $result = $this->deletePermissionGroup11($id);
        return array('result' => $result);
    }

    public function deletePermissionGroup11($id)
    {
        DB::table('permission_group')->where('id', $id)->delete();
        return true;
    }

    public function isPermissionAlreadyAssign($permission_id)
    {
        $builder = DB::table('map_employee_permission')->where('permission_group_id', $permission_id)->first();
        $id = '';

        if (!empty($builder)) {
            $id = $builder->id;
        }
        if ($id != '') {
            return false;
        } else {
            return true;
        }
    }

    public function access_management()
    {
        $user = User::where('id', Auth::id())->first();
        $userPay = UserPay::where('username', $user->username)->first();
        $permissionss = DB::table('permission_group')->select('id', 'group_name')->get();
        //return view( 'settings.access_management', compact( 'userPay' ) );
        return view('settings.access_management', ['userPay' => $userPay, 'permissionss'=>$permissionss]);
    }

    public function isPermissionGroupExist(Request $request)
    {
        $groupName = $request->group_name;
        $id = $request->id;
        $result = $this->isPermissionGroupExist11($groupName, $id);
        return array('result' => $result);
    }

    public function isPermissionGroupExist11($groupName, $id)
    {
        if ($id == '') {
            $result = DB::table('permission_group')->where('group_name', $groupName)->first();
        } else {
            $result = DB::table('permission_group')->where('group_name', $groupName)->where('id', '!=', $id)->first();
        }
        $id = '';
        if (!empty($result)) {
            $id = $result->id;
        }

        if ($id != '')
            return FALSE;
        return TRUE;
    }

    public function addPermissionGroup(Request $request)
    {
        $groupName = $request->group_name;
        $eleave = $request->eleave;
        $eclaim = $request->eclaim;
        $epay = $request->epay;
        $epay_download = $request->e_payslip_download;
        $approval = $request->approval;
        $hr = $request->hr;
        $hr_applysubordinate = $request->hr_applysubordinate;
        $settings = $request->settings;
        $viewLeave = $request->view_leave;
        $duty_rostere_viewe = $request->duty_rostere_viewe;
        $global_search = $request->global_search;
        $rl_allow = $request->rl_allow;
        $apply_rl = $request->apply_rl;
        $cancel_leave = $request->cancel_leave;
        $hr_leave_edit = $request->hr_leave_edit;
        $hr_menu = $request->hr_menu;
        $approver_menu = $request->approver_menu;
        $eleave_menu = $request->eleave_menu;
        $hr_leave_control = $request->hr_leave_control;
        $hr_leave_entitle = $request->hr_leave_entitle;
        $hr_add_employee = $request->hr_add_employee;
        $hr_edit_employee = $request->hr_edit_employee;
        $hr_setup_leave_edit = $request->hr_setup_leave_edit;
        $approval_view_all = $request->approval_view_all;
        $hr_view_all = $request->hr_view_all;
        $e_attendance = $request->e_attendance;
        $e_attendance_admin = $request->e_attendance_admin;
        $e_attendance_emp = $request->e_attendance_emp;
        $edit_attendance = $request->edit_attendance;
        $attendance_audit = $request->attendance_audit;
        $eclaim_audit = $request->eclaim_audit;
        $leave_audit = $request->leave_audit;
        $approval_ot = $request->approval_ot;
        $groupsExist = $this->isPermissionGroupExist11($groupName, '');
        if ($groupsExist) {
            $result = $this->addPermissionGroup11($groupName, $eleave, $eclaim, $epay, $approval, $hr, $settings, $viewLeave, $global_search, $rl_allow, $apply_rl, $cancel_leave, $hr_leave_edit, $hr_menu, $approver_menu, $eleave_menu, $epay_download, $hr_applysubordinate, $duty_rostere_viewe, $hr_leave_control, $hr_leave_entitle, $hr_add_employee, $hr_edit_employee, $hr_setup_leave_edit, $approval_view_all, $hr_view_all,$e_attendance,$e_attendance_admin,$e_attendance_emp,$edit_attendance, $attendance_audit, $eclaim_audit, $leave_audit,$approval_ot);
        } else {
            $result = false;
        }
        return array('result' => $result);
    }

    public function addPermissionGroup11($groupName, $eleave, $eclaim, $epay, $approval, $hr, $settings, $viewLeave, $global_search, $rl_allow, $apply_rl, $cancel_leave, $hr_leave_edit, $hr_menu, $approver_menu, $eleave_menu, $epay_download, $hr_applysubordinate, $duty_rostere_viewe, $hr_leave_control, $hr_leave_entitle, $hr_add_employee, $hr_edit_employee, $hr_setup_leave_edit, $approval_view_all, $hr_view_all,$e_attendance,$e_attendance_admin,$e_attendance_emp,$edit_attendance, $attendance_audit, $eclaim_audit, $leave_audit, $approval_ot)
    {
        $result = DB::table('permission_group')->insert(array('group_name' => $groupName, 'eleave' => $eleave, 'eclaim' => $eclaim, 'epay' => $epay, 'approval' => $approval, 'hr' => $hr, 'settings' => $settings, 'view_leave' => $viewLeave, 'global_search' => $global_search, 'rl_allow' => $rl_allow, 'apply_rl' => $apply_rl, 'cancel_leave' => $cancel_leave, 'hr_leave_edit' => $hr_leave_edit, 'hr_menu' => $hr_menu, 'approver_menu' => $approver_menu, 'eleave_menu' => $eleave_menu, 'epay_download' => $epay_download, 'hr_applysubordinate' => $hr_applysubordinate, 'duty_rostere_viewe' => $duty_rostere_viewe, 'hr_leave_control' => $hr_leave_control, 'hr_leave_entitle' => $hr_leave_entitle, 'hr_add_employee' => $hr_add_employee, 'hr_edit_employee' => $hr_edit_employee, 'hr_setup_leave_edit' => $hr_setup_leave_edit, 'approval_view_all' => $approval_view_all, 'hr_view_all' => $hr_view_all, 'e_attendance'=>$e_attendance, 'admin_e_attndnc'=>$e_attendance_admin, 'emp_e_attndnc'=>$e_attendance_emp,'edit_attendance'=>$edit_attendance, 'attendance_audit'=>$attendance_audit, 'eclaim_audit'=>$eclaim_audit, 'leave_audit'=>$leave_audit, 'approval_ot'=>$approval_ot));
        return true;
    }




    public function email_server()
    {

        $company_id = Auth::user()->company_id;
        $email_server = Setting::where('field', 'email_smtp_server')->where('company_id', $company_id)->first();
        $email_id = Setting::where('field', 'email_email_id')->where('company_id', $company_id)->first();
        $email_password = Setting::where('field', 'email_password')->where('company_id', $company_id)->first();
        $email_port = Setting::where('field', 'email_port')->where('company_id', $company_id)->first();
        $email_sender = Setting::where('field', 'email_sender_name')->where('company_id', $company_id)->first();

        return view('settings.emailsettings', ['email_server' => $email_server, 'email_id' => $email_id, 'email_password' => $email_password, 'email_port' => $email_port, 'email_sender' => $email_sender]);
    }

    public function updatemailsetting(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email_smtp_server' => 'required',
            'email_email_id' => 'required|email',
            'email_password' => 'required',
            'email_port' => 'required',
            'email_sender_name' => 'required',

        ]);

        if ($validator->passes()) {

            $company_id = Auth::user()->company_id;

            $email_server = Setting::where('field', 'email_smtp_server')->where('company_id', $company_id)->update(['value' => $request->email_smtp_server]);
            $email_id = Setting::where('field', 'email_email_id')->where('company_id', $company_id)->update(['value' => $request->email_email_id]);
            $email_password = Setting::where('field', 'email_password')->where('company_id', $company_id)->update(['value' => $request->email_password]);
            $email_port = Setting::where('field', 'email_port')->where('company_id', $company_id)->update(['value' => $request->email_port]);
            $email_sender = Setting::where('field', 'email_sender_name')->where('company_id', $company_id)->update(['value' => $request->email_sender_name]);

            return json_encode(array('statusCode' => 200));
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function smssetting()
    {

        $company_id = Auth::user()->company_id;
        $sms_web_url = Setting::where('field', 'sms_web_url')->where('company_id', $company_id)->first();
        $sms_user_id = Setting::where('field', 'sms_user_id')->where('company_id', $company_id)->first();
        $sms_password = Setting::where('field', 'sms_password')->where('company_id', $company_id)->first();

        return view('settings.smssettings', ['sms_web_url' => $sms_web_url, 'sms_user_id' => $sms_user_id, 'sms_password' => $sms_password]);
    }

    public function updatesmssetings(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'sms_web_url' => 'required',
            'sms_user_id' => 'required',
            'sms_password' => 'required',

        ]);

        if ($validator->passes()) {

            $company_id = Auth::user()->company_id;

            $email_server = Setting::where('field', 'sms_web_url')->where('company_id', $company_id)->update(['value' => $request->sms_web_url]);
            $email_id = Setting::where('field', 'sms_user_id')->where('company_id', $company_id)->update(['value' => $request->sms_user_id]);
            $email_password = Setting::where('field', 'sms_password')->where('company_id', $company_id)->update(['value' => $request->sms_password]);

            return json_encode(array('statusCode' => 200));
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function companydetails()
    {

        $company_id = Auth::user()->company_id;
        $company_details = Detail::where('field', 'company_details')->where('company_id', $company_id)->first();
        $epayslip_logo = Setting::where('field', 'epayslip_branch_or_company_logo')->where('company_id', $company_id)->first();

        return view('settings.companydetails', ['company_details' => $company_details, 'epayslip_logo' => $epayslip_logo]);
    }

    public function updatecompany(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'company_details' => 'required',
            'epayslip_logo' => 'required',

        ]);

        if ($validator->passes()) {

            $company_id = Auth::user()->company_id;

            $email_server = Detail::where('field', 'company_details')->where('company_id', $company_id)->update(['v4_value' => $request->company_details]);
             $email_server11 = Detail::where('field', 'company_details')->where('company_id', $company_id)->update(['value' => $request->company_details]);
            $email_id = Setting::where('field', 'epayslip_branch_or_company_logo')->where('company_id', $company_id)->update(['value' => $request->epayslip_logo]);

            return json_encode(array('statusCode' => 200));
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function companylogo()
    {

        return view('settings.companylogo');
    }

    public function companylogoshow(Request $request)
    {

        $image = DB::table('details')->where('field', 'company_logo')->where('company_id', Auth::user()->company_id)->first();

        return response()->json($image->v4_value);
    }

    public function updatecompanylogo(Request $request)
    {

        $validator = \Validator::make($request->all(), [
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($validator->passes()) {
            if ($request->file('image')) {
                $imagePath = $request->file('image');
                $imageName = $imagePath->getClientOriginalName();
                $imageName = str_replace(' ','-',$imageName);
                // $path =  $request->file('image')->storeAs('public/settings/companylogo/', $imageName);
                
                // dd($path);
                $filePath = 'public/settings/companylogo/';
                $path = Storage::disk($this->storageDriver)->put($filePath . $imageName, file_get_contents($request->file('image')));
                $company_id = Auth::user()->company_id;
                $data = [

                    'filename' => $imageName,
                    'location' => 'storage/app/' . $filePath.$imageName,
                    'company_id' => $company_id
                ];
                if ($path) {
                    $upload = DB::table('files')->insert($data);
                    $update = DB::table('details')->where('field', 'company_logo')->where('company_id', $company_id)->update(['v4_value' => $imageName]);
                    $update11 = DB::table('details')->where('field', 'company_logo')->where('company_id', $company_id)->update(['value' => $imageName]);
                    return json_encode(array('statusCode' => 200));
                }
            }
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function softwaresettings()
    {
        $company_id = Auth::user()->company_id;
        $software_start_year = Setting::where('field', 'software_start_year')->where('company_id', $company_id)->first();
        $skip_eclaim_finance = Setting::where('field', 'skip_eclaim_finance')->where('company_id', $company_id)->first();
        $otp = Setting::where('field', 'otp')->where('company_id', $company_id)->first();
        return view('settings.softwaresettings', ['software_start_year' => $software_start_year, 'skip_eclaim_finance' => $skip_eclaim_finance,'otp' => $otp]);
    }

    public function updatesoftwaresettings(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'software_start_year' => 'required',

        ]);

        if ($validator->passes()) {
            $company_id = Auth::user()->company_id;
            $software_start_year = Setting::where('field', 'software_start_year')->where('company_id', $company_id)->update(['value' => $request->software_start_year]);
            $skip_eclaim_finance = Setting::where('field', 'skip_eclaim_finance')->where('company_id', $company_id)->update(['value' => $request->_val]);
            $otp = Setting::where('field', 'otp')->where('company_id', $company_id)->update(['value' => $request->_otp]);

            return json_encode(array('statusCode' => 200));
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function staticmessage()
    {
        $company_id = Auth::user()->company_id;
        $broadcast_msg = Detail::where('field', 'broadcast_msg')->where('company_id', $company_id)->first();
        return view('settings.staticmessage', ['broadcast_msg' => $broadcast_msg]);
    }

    public function updatestaticmessage(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'broadcast_msg' => 'required',

        ]);

        if ($validator->passes()) {
            $company_id = Auth::user()->company_id;
            $email_server = Detail::where('field', 'broadcast_msg')->where('company_id', $company_id)->update(['v4_value' => $request->broadcast_msg]);
            $email_server11 = Detail::where('field', 'broadcast_msg')->where('company_id', $company_id)->update(['value' => $request->broadcast_msg]);

            return json_encode(array('statusCode' => 200));
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function getAllUsersNameSort(Request $request)
    {
        $company_id = Auth::user()->company_id;
        $ActiveUserShownStatus = DB::table('settings')->where('field', 'active_user_shown')->first();

        if ($ActiveUserShownStatus->value == '1') {
            $users = DB::table('users')
                ->leftJoin('user_personal', 'users.username', '=', 'user_personal.username')
                ->select('users.username', 'user_personal.name', 'user_personal.employee_no')->orWhere('users.isDeleted', '=', 0)->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        }
        if ($ActiveUserShownStatus->value == '0') {

            $users = DB::table('users')
                ->leftJoin('user_personal', 'users.username', '=', 'user_personal.username')->leftJoin('user_pay', 'users.username', '=', 'user_pay.username')->Where('users.isDeleted', '=', 0)->where('user_pay.pay_status', '=', 1)->select('users.username', 'user_personal.name', 'user_personal.employee_no')->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        }

        return json_encode($users);
    }

    public function getPreferences()
    {
        $company_id = Auth::user()->company_id;
        $data = DB::table('email_preferences')
            ->leftJoin('user_personal', 'email_preferences.employee_id', '=', 'user_personal.username')->leftJoin('users', 'user_personal.username', '=', 'users.username')
            ->select('email_preferences.employee_id', 'user_personal.name')->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        return json_encode($data);
    }

    public function addPreferenceWD(Request $request)
    {
        $company_id = Auth::user()->company_id;
        if (DB::table('users')->where('company_id', $company_id)) {

            $array = explode(',', $request->str);

            for (
                $i = 0;
                $i < count($array);
                $i++
            ) {
                if ($array[$i] != '') {

                    $insert = new Email_preference;
                    $insert->employee_id = $array[$i];
                    $insert->save();
                }
            }
        }

        return json_encode(array('statusCode' => 200));
    }

    public function deletePreferenceWD(Request $request)
    {
        $company_id = Auth::user()->company_id;
        $array = explode(',', $request->str);

        for (
            $i = 0;
            $i < count($array);
            $i++
        ) {
            if ($array[$i] != '') {

                DB::table('email_preferences')
                    ->leftJoin('users', 'email_preferences.employee_id', '=', 'users.username')
                    ->where('email_preferences.employee_id', $array[$i])->where('users.company_id', $company_id)
                    ->delete();
            }
        }

        return json_encode(array('statusCode' => 200));
    }

    public function getEmailContentPrefernce()
    {
        $company_id = Auth::user()->company_id;
        $data = DB::table('email_content_preferences')
            ->leftJoin('user_personal', 'email_content_preferences.employee_id', '=', 'user_personal.username')->leftJoin('users', 'user_personal.username', '=', 'users.username')
            ->select('email_content_preferences.employee_id', 'user_personal.name')->orderBy('user_personal.name', 'ASC')->where('users.company_id', $company_id)->get();
        return json_encode($data);
    }

    public function getUserLi(Request $request)
    {

        $company_id = Auth::user()->company_id;
        $ActiveUserShownStatus = DB::table('settings')->where('field', 'active_user_shown')->first();

        if ($ActiveUserShownStatus->value == '1') {
            $data = DB::table('user_personal')->whereRaw('(name like ("'.$request->name.'%"))')->where('isDeleted', '=', 0)->orderBy('name', 'asc')->get();
        }
        if ($ActiveUserShownStatus->value == '0') {

            $data = DB::table('users')
                ->leftJoin('user_personal', 'users.username', '=', 'user_personal.username')->leftJoin('user_pay', 'users.username', '=', 'user_pay.username')->Where('users.isDeleted', '=', 0)->where('user_pay.pay_status', '=', 1)->select('users.username', 'user_personal.name', 'user_personal.employee_no')->whereRaw('(user_personal.name like ("'.$request->name.'%"))')->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        }

        return json_encode($data);
    }

    public function setEmailContentPrefernce(Request $request)
    {
        $company_id = Auth::user()->company_id;

        if (DB::table('users')->where('company_id', $company_id)) {
            $array = explode(',', $request->str);

            for (
                $i = 0;
                $i < count($array);
                $i++
            ) {
                if ($array[$i] != '') {

                    $insert = new Email_content_preference;
                    $insert->employee_id = $array[$i];
                    $insert->save();
                }
            }
        }

        return json_encode(array('statusCode' => 200));
    }

    public function deleteEmailContentPrefernceWD(Request $request)
    {
        $company_id = Auth::user()->company_id;
        $array = explode(',', $request->str);

        for (
            $i = 0;
            $i < count($array);
            $i++
        ) {
            if ($array[$i] != '') {

                DB::table('email_content_preferences')
                    ->leftJoin('users', 'email_content_preferences.employee_id', '=', 'users.username')
                    ->where('email_content_preferences.employee_id', $array[$i])->where('users.company_id', $company_id)
                    ->delete();
            }
        }

        return json_encode(array('statusCode' => 200));
    }

    public function getAllUser()
    {
        $company_id = Auth::user()->company_id;
        $ActiveUserShownStatus = DB::table('settings')->where('field', 'active_user_shown')->first();

        if ($ActiveUserShownStatus->value == '1') {
            $users = DB::table('users')
                ->leftJoin('user_personal', 'users.username', '=', 'user_personal.username')->leftJoin('sms_preference', 'user_personal.username', '=', 'sms_preference.employee_id')
                ->select('users.username', 'user_personal.name', 'user_personal.employee_no')->orWhere('users.isDeleted', '=', 0)->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        }
        if ($ActiveUserShownStatus->value == '0') {

            $users = DB::table('users')
                ->leftJoin('user_personal', 'users.username', '=', 'user_personal.username')->leftJoin('user_pay', 'users.username', '=', 'user_pay.username')->Where('users.isDeleted', '=', 0)->where('user_pay.pay_status', '=', 1)->select('users.username', 'user_personal.name', 'user_personal.employee_no')->where('users.company_id', $company_id)->orderBy('user_personal.name', 'asc')->get();
        }

        return json_encode($users);
    }

    public function addsmsPreference(Request $request)
    {
        $company_id = Auth::user()->company_id;
        if (DB::table('users')->where('company_id', $company_id)) {
            $array = explode(',', $request->str);

            for (
                $i = 0;
                $i < count($array);
                $i++
            ) {
                if ($array[$i] != '') {

                    DB::table('sms_preference')
                        ->leftJoin('users', 'sms_preference.employee_id', '=', 'users.username')
                        ->where('sms_preference.employee_id', $array[$i])->where('users.company_id', $company_id)
                        ->delete();

                    $insert = new Sms_preference;
                    $insert->employee_id = $array[$i];
                    $insert->save();
                }
            }
        }

        return json_encode(array('status' => 200));
    }

    public function deletePreference(Request $request)
    {
        $company_id = Auth::user()->company_id;
        $array = explode(',', $request->str);

        for (
            $i = 0;
            $i < count($array);
            $i++
        ) {
            if ($array[$i] != '') {

                DB::table('sms_preference')
                    ->leftJoin('users', 'sms_preference.employee_id', '=', 'users.username')
                    ->where('sms_preference.employee_id', $array[$i])->where('users.company_id', $company_id)
                    ->delete();
            }
        }
        return json_encode(array('status' => 200));
    }

    public function getsmsPreferences(Request $request)
    {
        $company_id = Auth::user()->company_id;
        $data = DB::table('sms_preference')
            ->leftJoin('user_personal', 'sms_preference.employee_id', '=', 'user_personal.username')->leftJoin('users', 'user_personal.username', '=', 'users.username')
            ->select('sms_preference.employee_id', 'user_personal.name')->where('users.company_id', $company_id)->orderBy('user_personal.name', 'ASC')->get();
        return json_encode($data);
    }

    public function ubspayrollpath()
    {

        $company_id = Auth::user()->company_id;
        $software_start_year = Setting::where('field', 'software_start_year')->where('company_id', $company_id)->first();
        return view('settings.ubspayrollpath', ['software_start_year' => $software_start_year]);
    }

    public function edituser()
    {

        $company_id = Auth::user()->company_id;
        $user = User::where('id', Auth::id())->first();
        $category = DB::table('category')->where('company_id', $company_id)->get();
        $department = DB::table('department')->where('company_id', $company_id)->get();
        $user_category = DB::table('user_category')->get();
        $user_pay = DB::table('user_pay')->distinct()->get();
        $branch = DB::table('branch')->where('company_id', $company_id)->get();
        $rest_day_category = DB::table('rest_day_category')->get();
        $permission_group = DB::table('permission_group')->get();
        $query = "select b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, ";
        $query .= "b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe from map_employee_permission a left join permission_group b on ";
        $query .= "a.permission_group_id=b.id where a.employee_id='$user->username'";
        $permission = DB::select($query);
        $entitle_category = DB::table('category_name')->where('company_id',$company_id)->where('is_deleted',0)->get();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->first();

        return view('settings.edit_user', ['categories' => $category, 'departments' => $department, 'user_categories' => $user_category, 'user_pay' => $user_pay, 'branches' => $branch, 'rest_day_category' => $rest_day_category, 'permission_group' => $permission_group, 'permission' => $permission, 'deleteBtnShowSetting' => $deleteBtnShowSetting, 'entitle_category'=> $entitle_category]);
    }

    public function getPermissionGroupOfuser()
    {

        $data = DB::table('map_employee_permission')->leftJoin('permission_group', 'map_employee_permission.permission_group_id', '=', 'permission_group.id')
            ->select('permission_group.id as permission_id', 'permission_group.type', 'permission_group.group_name', 'permission_group.eleave', 'permission_group.eclaim', 'permission_group.epay', 'permission_group.approval', 'permission_group.hr', 'permission_group.hr_applysubordinate', 'permission_group.settings', 'permission_group.view_leave', 'permission_group.approver_menu', 'permission_group.eleave_menu', 'permission_group.duty_rostere_viewe')->where('map_employee_permission.employee_id', Auth::user()->username)->get();

        return $data;
    }

    public function getPermissionGroupOfuse(Request $request)
    {
        $user = User::where('id', Auth::id())->first();
        $employeeId = ($request->employee_id ? $request->employee_id : $user->username);

        $result = $this->getPermissionGroupOfuse11($employeeId);
        return json_encode($result);
    }

    public function getPermissionGroupOfuse11($employeeId)
    {
        $query = 'select b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, ';
        $query .= 'b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe from map_employee_permission a left join permission_group b on ';
        $query .= "a.permission_group_id=b.id where a.employee_id='$employeeId'";
        $builder = DB::select($query);
        return $builder;
    }

    public function deleteuserli()
    {
        $company_id = Auth::user()->company_id;
        $user = User::where('id', Auth::id())->first();

        $branch = DB::table('branch')->where('company_id', $company_id)->get();
        $category = DB::table('category')->where('company_id', $company_id)->get();
        $department = DB::table('department')->where('company_id', $company_id)->get();

        $permission_group = DB::table('permission_group')->get();
        $query = "select b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, ";
        $query .= "b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe from map_employee_permission a left join permission_group b on ";
        $query .= "a.permission_group_id=b.id where a.employee_id='$user->username'";
        $permission = DB::select($query);

        $permission_group_hr = DB::table('permission_group')->where('group_name', Auth::user()->username)->first();
        $deleteBtnShowSetting = DB::table('settings')->where('field', 'admindeletebutton')->first();

        return view('settings.deleteuser', ['branches' => $branch, 'categories' => $category, 'departments' => $department, 'permission' => $permission, 'deleteBtnShowSetting' => $deleteBtnShowSetting]);
    }

    public function deleteuserlisted(Request $request)
    {

        $dtable = $request->dtable ?? '';
        $name = ($request->name ? $request->name : '');
        $empNo = ($request->employee_no ? $request->employee_no : '');
        $branchId = ($request->branch_id ? $request->branch_id : '');
        $categoryId = ($request->category_id ? $request->category_id : '');
        $departmentId = ($request->department_id ? $request->department_id : '');
        $leave_entitle_category = ($request->leave_entitle_category ? $request->leave_entitle_category : '');
        $pay_status = ($request->pay_status ? $request->pay_status : '');
        $rest_day_group = ($request->rest_day_group ? $request->rest_day_group : '');
        $role = ($request->role ? $request->role : '');

        $keyword = $request->keyword;

        $list = $this->getUserdeleteList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category, $pay_status, $rest_day_group, $role);
        if ($dtable != '') {
            return DataTables::of($list)->make(true);
        } else {
            return $list;
        }
    }

    public function getUserdeleteList11($name, $empNo, $branchId, $categoryId, $departmentId, $keyword, $leave_entitle_category, $pay_status, $rest_day_group, $role)
    {
        $ActiveUserShownStatus1 = DB::table('settings')->where('field', 'active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $user = User::where('id', Auth::id())->first();
        $permission_val1 = DB::table('map_employee_permission as a')->leftjoin('permission_group as b', 'a.permission_group_id', '=', 'b.id')->where('a.employee_id', $user->username)->selectRaw('b.hr, b.hr_leave_edit')->first();
        $permission_val = $permission_val1->hr;

        $approverId = $user->username;

        $approver_query = 'select distinct b.username from map_employee_approver a left join user_personal b on ';
        $approver_query .= "a.employee_id=b.username where a.approver_id='" . $approverId . "'";

        $approver_array = DB::select($approver_query);

        $approver_str = '';
        for (
            $i = 0;
            $i < count($approver_array);
            $i++
        ) {
            $approver_str .= "'" . $approver_array[$i]->username . "'";
            if ($i < (count($approver_array) - 1)) {
                $approver_str .= ', ';
            }
        }

        $query = "select a.username, a.employee_no, a.name, a.email_id, a.employee_code, DATE_FORMAT(b.date_commence, '%d/%m/%Y') as date_commence,b.date_commence as join_date, b.pay_status as active, c.name as branch, d.name as category, e.name as department, ";
        $query .= 'a.state, a.phone_no, g.group_name as role, ';
        $query .= "uc.category as category_mapping, rdc.category as rest_day_group, DATE_FORMAT(b.date_confirmed, '%d/%m/%Y') as date_confirmed ";
        $query .= 'from user_personal a left join user_pay b on a.username=b.username left join branch c ';
        $query .= 'on b.branch_id=c.id left join category d on b.category_id=d.id left join department e on b.department_id=e.id ';
        $query .= 'left join map_employee_permission f on a.username=f.employee_id left join permission_group g on g.id=f.permission_group_id ';
        $query .= 'left join user_category uc on uc.username=a.username left join rest_day_category_employee rdce on rdce.employee_id=a.username ';
        $query .= 'left join rest_day_category rdc on rdc.id=rdce.category_id ';
        $query .= "where a.username != '' and a.isDeleted='1' ";
        if ($keyword != '') {
            $query .= 'and (a.employee_no like "'.$keyword.'%" or a.name like "'.$keyword.'%") ';
        }

        if ($permission_val == 4) {
            $query .= ' and b.username in (' . $approver_str . ')';
        }

        if ($ActiveUserShownStatus == '1') {
            $query .= "and (b.pay_status = '1' or b.pay_status = '0')";
        } else {
            $query .= "and b.pay_status = '1'";
        }
        if ($name != '') {
            $query .= 'and (a.employee_no like "'.$name.'%" or a.name like "'.$name.'%") ';
        }
        if ($empNo != '') {
            $query .= "and a.employee_no = '$empNo'";
        }
        if ($branchId != '') {
            $query .= "and b.branch_id = '$branchId'";
        }
        if ($categoryId != '') {
            $query .= "and b.category_id = '$categoryId'";
        }
        if ($departmentId != '') {
            $query .= "and b.department_id = '$departmentId'";
        }
        if ($pay_status != '') {
            $query .= "and b.pay_status = '$pay_status'";
        }
        if ($leave_entitle_category != '') {
            $query .= "and uc.category = '$leave_entitle_category'";
        }
        if ($rest_day_group != '') {
            $query .= "and rdc.id = '$rest_day_group'";
        }
        if ($role != '') {
            $query .= "and g.id = '$role'";
        }
        $query .= 'order by a.name+0,a.name';

        $builder = DB::select($query);
        return $builder;
    }

    public function recoverselected(Request $request)
    {
        $username = $request->username;

        DB::table('users')->where('username', $username)->update(['isDeleted' => '0']);
        DB::table('user_personal')->where('username', $username)->update(['isDeleted' => '0']);

        return response()->json(['status' => 200]);
    }

    public function deleteUserper(Request $request)
    {

        $username = $request->username;

        DB::table('approver_approved_leaves')->whereRaw('approver_id = "'.$username.'"')->delete();
        DB::table('email_content_preferences')->whereRaw('employee_id = "'.$username.'"')->delete();
        DB::table('email_preferences')->whereRaw('employee_id = "'.$username.'"')->delete();
        DB::table('leave_adjustment')->whereRaw('employee_id = "'.$username.'"')->delete();
        DB::table('leave_bf_adj')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('leave_days')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('leave_entitle_history')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('leave_list')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('leave_past')->whereRaw('username = "'.$username.'"')->delete();
        
        DB::table('user_personal')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_pay')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_spouse')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_address')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_government')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_insurance')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_epf')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_tax')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('user_category')->whereRaw('username = "'.$username.'"')->delete();
        DB::table('map_employee_approver')->whereRaw('(employee_id = "'.$username.'" or approver_id = "'.$username.'")')->delete();
        DB::table('map_employee_manager')->whereRaw('(employee_id = "'.$username.'" or manager_id = "'.$username.'")')->delete();
        DB::table('map_employee_permission')->whereRaw('employee_id= "'.$username.'"')->delete();
        DB::table('messages')->whereRaw('(sender = "'.$username.'" or recipient = "'.$username.'")')->delete();
        DB::table('messages_sent')->whereRaw('(sender = "'.$username.'" or recipients = "'.$username.'")')->delete();
        DB::table('pending_emails')->whereRaw('email_to = "'.$username.'" or leave_username = "'.$username.'"')->delete();
        DB::table('user_epay')->whereRaw('employee_no = "'.$username.'"')->delete();
        DB::table('rest_day_category_employee')->whereRaw('employee_id = "'.$username.'"')->delete();
        
        
        DB::table('block_dates')->whereRaw('block_id = "'.$username.'"')->where('is_user', '1')->delete();
        
        DB::table('timeline_leaves_detail')->whereRaw('approver_id = "'.$username.'"')->delete();
        
       DB::table('rl_leaves')->whereRaw('employee_id = "'.$username.'"')->delete();
        DB::table('users')->whereRaw('username = "'.$username.'"')->delete();

        return response()->json(['status' => 200]);
    }

    public function viewrestore()
    {
        return view('settings.restore');
    }

    // public function restore(Request $request)
    // {
    //     $validator = \Validator::make($request->all(), [
    //         'file' => 'required',
    //     ]);

    //     if ($validator->passes()) {
    //         $filePath = $request->file('file');
    //         $filename = $filePath->getClientOriginalName();
    //         $filename = basename($filename);
    //         $extension = pathinfo($filename, PATHINFO_EXTENSION);
    //         if ($this->checkExtension($extension)) {

    //             $conn = mysqli_connect("localhost", "root", "", "ecoleave");

    //             if ($request->hasFile('file')) {
    //                 $path =  public_path('ecoleave_backup.sql');
    //                 if (File::exists($path)) {
    //                     File::delete($path);
    //                 }
    //                 $imagePath = $request->file('file');
    //                 $imageName = $imagePath->getClientOriginalName();
    //                 $request->file->move(public_path(), $imageName);
    //             }

    //             $path =  public_path($imageName);
    //             $filePath = $path;
    //             function restoreMysqlDB($filePath, $conn)
    //             {
    //                 $sql = '';
    //                 $error = '';

    //                 if (file_exists($filePath)) {
    //                     ini_set('max_execution_time', 120);
    //                     $lines = file($filePath);
    //                     foreach ($lines as $line) {

    //                         // Ignoring comments from the SQL script
    //                         if (substr($line, 0, 2) == '--' || $line == '') {
    //                             continue;
    //                         }

    //                         $sql .= $line;

    //                         if (substr(trim($line), -1, 1) == ';') {
    //                             $result = mysqli_query($conn, $sql);
    //                             if (!$result) {
    //                                 $error .= mysqli_error($conn) . "\n";
    //                             }
    //                             $sql = '';
    //                         }
    //                     } // end foreach



    //                 }
    //             }

    //             restoreMysqlDB($filePath, $conn);

    //             return redirect()->back()->with('message', 'File imported successfully');
    //         }
    //     }

    //     return response()->json(['error' => $validator->errors()]);
    // }
    
     public function restore(Request $request)
	{
        $validator = \Validator::make($request->all(), [
            'file' => 'required',
        ]);
        if ($validator->passes()) {
            $file=$request->file('file');
            if($request->file('file') != "")
            {
                $extension = $file->getClientOriginalExtension();
                //$endFileName = $file->getClientOriginalName();
                // Storage::delete('public/settings/backup.zip');
                $endFileName="backup.zip";
                $destinationPath = public_path();
                
                //dd($endFileName);
                $filePath = 'public/settings/';
                Storage::disk($this->storageDriver)->put($filePath . $endFileName, file_get_contents($file));
                $file->move($destinationPath,$endFileName);
                $source = $endFileName;
                $res=$this->MainRestoreFunction($source);
                File::deleteDirectory($res);
                return true;
            }
            else
            {
               // echo "No input file found!!";
                return redirect()->back()->with('message', 'No input file found!!');
            }
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function viewbackup()
    {
        return view('settings.backup');
    }



    //   public function backup()
    //   {
    //       $connection = mysqli_connect('localhost','root','','ecoleave');
    //       $tables = array();
    //       $result = mysqli_query($connection,"SHOW TABLES");
    //       while($row = mysqli_fetch_row($result)){
    //          $tables[] = $row[0];
    //       }
    //       $return = '';
    //       foreach($tables as $table){
    //          $result = mysqli_query($connection,"SELECT * FROM ".$table);
    //          $num_fields = mysqli_num_fields($result);

    //          $return .= 'DROP TABLE '.$table.';';
    //          $row2 = mysqli_fetch_row(mysqli_query($connection,"SHOW CREATE TABLE ".$table));
    //          $return .= "\n\n".$row2[1].";\n\n";

    //          for($i=0;$i<$num_fields;$i++){
    //           while($row = mysqli_fetch_row($result)){
    //              $return .= "INSERT INTO ".$table." VALUES(";
    //              for($j=0;$j<$num_fields;$j++){
    //               $row[$j] = addslashes($row[$j]);
    //               if(isset($row[$j])){ $return .= '"'.$row[$j].'"';}
    //               else{ $return .= '""';}
    //               if($j<$num_fields-1){ $return .= ',';}
    //              }
    //              $return .= ");\n";
    //           }
    //          }
    //          $return .= "\n\n\n";
    //       }
    //       //save file
    //       $handle = fopen("ecoleave_backup.sql","w+");
    //       fwrite($handle,$return);
    //       fclose($handle);
    //       $filepath = public_path('ecoleave_backup.sql');
    //       return Response::download($filepath); 
    //       return redirect()->back()->with('success', 'your message,here'); 


    //   }

    public function backup()
    {
        $this->createBakup("backup.zip");
    }

    public function createBakup($destination)
    {
        $this->MainBackupFunction($destination);
        $basepath=str_replace("/home/ecoleave/public_html/","",base_path());
        //dd($basepath);
        //exec("zip ~/public_html/v4.ecoleave.asia/storage/app/public/temp/zips/backup.zip ~/public_html/v4.ecoleave.asia/storage/app/public/temp/backup/");
        header("Content-type: application/zip");
        header("Content-Disposition: attachment; filename=$destination");
        header("Content-length: " . filesize($destination));
        header("Pragma: no-cache");
        header("Expires: 0");
        readfile("$destination");
        exit;
        header("Location: https://".$basepath."/backup.zip");
        return redirect()->to($destination);
        //return redirect()->to($destination)->send();
        // return response()->download($callback, $destination, $headers);
    }

    public function MainBackupFunction($destination)
    {
        $tables = $this->getTableNames();
        //dd($tables);
        $fileArray = array();
        // dd($tables);
        foreach ($tables as $table) {
            $aa = (array)$table;
            $keys = array_keys($aa);
            
            //dd($table->{$keys[0]});
            // dd($table->Tables_in_ecoleave);
            $data = $this->getTableData($table->{$keys[0]});
            $file = Storage::path("temp/backup/" . $table->{$keys[0]} . ".xml");
            $xmlContent = $this->arrayToXML(json_decode(json_encode($data), true));
            // dd($file,$xmlContent);
            $fh = fopen($file, 'w') or die("can't open file");
            fwrite($fh, $xmlContent);
            fclose($fh);
            array_push($fileArray, $file);
        }

        $this->create_zip($fileArray, $destination, TRUE);
    }

    public function getTableNames()
    {
        $query = "show tables";
        $builder = DB::select($query);
        return $builder;
    }

    public function arrayToXML($array, $head = "root")
    {

        $xml = new SimpleXMLElement('<' . $head . '/>');
        return $this->array2xml($array, $xml);
    }

    public function array2xml($array, $xml = false)
    {

        if ($xml === false) {
            $xml = new SimpleXMLElement('<root/>');
        }
        // var_dump($array);exit();
        foreach ($array as $key => $value) {
            //$value = (array)$value;
            // dd(is_array($value));
            if (is_array($value)) {
                if (is_int($key))
                    $this->array2xml($value, $xml->addChild("row"));
                else
                    $this->array2xml($value, $xml->addChild($key));
            } else {
                // dd($value);
                /*$value = str_replace('/','-',$value);
	        	$value = str_replace(' ','-',$value);
	        	$value = str_replace('.-','-',$value);*/
                $value = str_replace('&-', '-', $value);
                $value = str_replace('&', '', $value);
                $xml->addChild($key, $value);
            }
        }
        return $xml->asXML();
    }

    public function create_zip($files = array(), $destination = '', $overwrite = false)
    {
        //if the zip file already exists and overwrite is false, return false
        if (file_exists($destination) && !$overwrite) {
            return false;
        }
        //vars
        $valid_files = array();
        //if files were passed in...
        if (is_array($files)) {
            //cycle through each file
            foreach ($files as $file) {
                //make sure the file exists
                if (file_exists($file)) {
                    $valid_files[] = $file;
                }
            }
        }
        //if we have good files...
        if (count($valid_files)) {
            //create the archive
            $zip = new \ZipArchive();
           // if ($zip->open($destination, $overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
            if($zip->open($destination,ZipArchive::CREATE | ZIPARCHIVE::OVERWRITE ) !== true) {
                //$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE
                echo "Unable to open file!";
                return false;
            }
            //add the files
            foreach ($valid_files as $file) {
                //dd($file);
                $publicpath=str_replace("public","",public_path());
                //dd($publicpath);
                $fname = str_replace($publicpath."storage/app/public/", "", $file);
                //dd($fname);
                $zip->addFile($file, $fname);
            }

            $zip->close();

            //check to make sure the file exists
            return file_exists($destination);
        } else {
            return false;
        }
    }


    public function deleteFromTable($table)
    {
        $query = "delete from $table";

        $result = DB::select($query);
        return $result;
    }

    public function makeQuery($table, $valueArray, $keyArray)
    {
        
        $values = $this->arrayToCommaSeperated($valueArray);
        $keys = $this->arrayToCommaSeperated($keyArray);
        $query = "insert into $table ($keys) values ($values)";
        

        $result = DB::select($query);

        return $result;
    }

    public function arrayToCommaSeperated($array)
    {
        $commaseperated = '';
        if (count($array) > 0)
            $commaseperated .= $array[0];
        for (
            $i = 1;
            $i < count($array);
            $i++
        )
            $commaseperated .= ',' . $array[$i];
        return $commaseperated;
    }
    
     public function listFolderFiles($dir,$array){
        $ffs = scandir($dir);
    
        unset($ffs[array_search('.', $ffs, true)]);
        unset($ffs[array_search('..', $ffs, true)]);
   
        // prevent empty ordered elements
        if (count($ffs) < 1)
            return;
        foreach($ffs as $ff){
            
            $path=$dir;
            if(is_dir($dir.'/'.$ff)){
                $res = $this->listFolderFiles($dir.'/'.$ff, $array);
                $path = $res[0];
                
                $array = $res[1];
                
            }
            
        }
        array_push($array,$path);
        
        return [$path,$array];
    }

    public function MainRestoreFunction($source)
    {
        $val= rand(10,100);
        $path =  public_path('/storage/settings/files/'.$val);
        $destination = $path;
        //$zip = new Commons;
        $this->unzip_file("$source", $destination);
        //dd($this->unzip_file("$source", $destination));
        $str=storage_path();
        //dd($str);
        $files = array();
        foreach (glob($path . '/*.XML') as $file){
            $files[]=$file;
        }
       
        // foreach ($files as $key =>$value){
        //     $directories=$value;
        // }
        
        // if(!is_file($directories[0])){
        //  $directories = glob($directories[0] . '/*' , GLOB_ONLYDIR);   
        // }
        // if(!is_file($directories[0])){
        //     $directories = glob($directories[0] . '/*' , GLOB_ONLYDIR); 
        // }
       // dd($dirs,$path.'/home');
      // $dirval=explode("/",$dirs);
       //dd($dirval);
        // if($dirs[0]==$path.'/home'){
        //  $backupFolder = $path.$str.'/app/public/temp/backup/';
        // }
        // else{
        //     $backupFolder =$path.'/temp/backup/';
        // }
        $array = [];
        $backupFolder= $this->listFolderFiles($path,$array);
        array_unique($backupFolder[1]);
        $backupFolder=$backupFolder[1][0].'/';
        //dd($backupFolder);
        $filenameArray = array();
        $tablenamearray = array();
       // dd($destination,$source);
      // dd($source,$backupFolder);
        if ($handle = opendir($backupFolder)) {
            while (false !== ($entry = readdir($handle))) {
                $fileVal = explode('.', $entry);
                if ($entry != '.' && $entry != '..')
                    array_push($filenameArray, array('filename' => $backupFolder . $entry, 'table' => $fileVal[0]));
                    array_push($tablenamearray,$fileVal[0]);
            }
        }
        
        if (!in_array("race", $tablenamearray)) {
             $user = User::where('id' , Auth::id())->first();
             $this->deleteFromTable('race');
            DB::insert("INSERT INTO `race` (`race`, `company_id`, `is_deleted`) VALUES ('Chinese', $user->company_id, 0), ('Malay', $user->company_id, 0), ('India', $user->company_id, 0), ('Other', $user->company_id, 0)");
        }
         for (
            $i = 0;
            $i < count($filenameArray);
            $i++
        ) {
          
            if(is_file($filenameArray[$i]['filename'])){
          // dd($filenameArray[$i]['filename']);
       
                $xml = simplexml_load_file($filenameArray[$i]['filename']);
                $table = $filenameArray[$i]['table'];
                $this->deleteFromTable($table);
                if($table=='race'){
                        
                    if(empty($xml->row)){
                        $user = User::where('id' , Auth::id())->first();
                        //dd($user);
                        DB::insert("INSERT INTO `race` (`race`, `company_id`, `is_deleted`) VALUES ('Chinese', $user->company_id, 0), ('Malay', $user->company_id, 0), ('India', $user->company_id, 0), ('Other', $user->company_id, 0)");
                        // DB::table('race')->insert(array('race' => 'Chinese','company_id'=>$user->company_id,'is_deleted'=>0));
                        // DB::table('race')->insert(array('race' => 'Malay','company_id'=>$user->company_id,'is_deleted'=>0));
                        // DB::table('race')->insert(array('race' => 'India','company_id'=>$user->company_id,'is_deleted'=>0));
                        // DB::table('race')->insert(array('race' => 'Other','company_id'=>$user->company_id,'is_deleted'=>0));
                    }
                    else{
                      foreach ($xml->row as $element) {
                    $keyArray = array();
                    $valueArray = array();
                     $skip = 0;
                    foreach ($element->children() as $key => $val) {
                        if($table=='users' && $key=='slno'){
                            $key='id';
                        }
                        
                       
                        
                        if($table=='permission_group' ){
                            if($key=='approver_view_all' || $key == "approval_view_all"){
                            $skip++;
                                //key='approval_view_all';
                            }   
                        }
                        
                        array_push($keyArray, $key);
                        
                        array_push($valueArray, "'" . addslashes($val) . "'");
                        
                    }
                    
                    if($table=='permission_group'){
                        //dd($keyArray,$skip);
                        $keyArray2=$keyArray;
                        if($skip == 1){
                            $remove1= array_search('approver_view_all', $keyArray);
                            if($remove1!=''){
                                $a2 = array($remove1 => "approval_view_all");
                                $keyArray=array_replace($keyArray,$a2);
                            }
                        }elseif($skip ==2){
                           $remove= array_search('approver_view_all', $keyArray);
                           //unset($keyArray[$remove]);
                           //unset($valueArray[$remove]);
                          array_splice($keyArray,$remove,1);
                          array_splice($valueArray,$remove,1);
                            //find index of approver and unset it from key, values
                        }
                       // dd($remove,$keyArray,$valueArray,$keyArray2);
                    }
                   
                    $this->makeQuery($table, $valueArray, $keyArray);
                    
                    
                }
                    }
                }
                else{
                    foreach ($xml->row as $element) {
                        $keyArray = array();
                        $valueArray = array();
                         $skip = 0;
                        foreach ($element->children() as $key => $val) {
                            if($table=='users' && $key=='slno'){
                                $key='id';
                            }
                            
                           
                            
                            if($table=='permission_group' ){
                                if($key=='approver_view_all' || $key == "approval_view_all"){
                                $skip++;
                                    //key='approval_view_all';
                                }   
                            }
                            
                            array_push($keyArray, $key);
                            
                            array_push($valueArray, "'" . addslashes($val) . "'");
                            
                        }
                        
                        if($table=='permission_group'){
                            //dd($keyArray,$skip);
                            $keyArray2=$keyArray;
                            if($skip == 1){
                                $remove1= array_search('approver_view_all', $keyArray);
                                if($remove1!=''){
                                    $a2 = array($remove1 => "approval_view_all");
                                    $keyArray=array_replace($keyArray,$a2);
                                }
                            }elseif($skip ==2){
                               $remove= array_search('approver_view_all', $keyArray);
                               //unset($keyArray[$remove]);
                               //unset($valueArray[$remove]);
                              array_splice($keyArray,$remove,1);
                              array_splice($valueArray,$remove,1);
                                //find index of approver and unset it from key, values
                            }
                           // dd($remove,$keyArray,$valueArray,$keyArray2);
                        }
                       
                        $this->makeQuery($table, $valueArray, $keyArray);
                        
                        if($table=='category_name' && !in_array("replacement_duration", $tablenamearray)){
                            $this->deleteFromTable('replacement_duration');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','replacement_duration')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('replacement_duration')->insert(array('category_name' => $cat->id,'value' => $dtcd->value)); 
                            }
                           
                       }
                       if($table=='category_name' && !in_array("bf_duration", $tablenamearray)){
                           $this->deleteFromTable('bf_duration');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','bf_duration')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('bf_duration')->insert(array('category_name' => $cat->id,'value' => $dtcd->value)); 
                            }
                       }
                       if($table=='category_name' && !in_array("bf_adj_duration", $tablenamearray)){
                           $this->deleteFromTable('bf_adj_duration');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','bf_adj_duration')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('bf_adj_duration')->insert(array('category_name' => $cat->id,'value' => $dtcd->value)); 
                            }
                           
                       }
                       if($table=='category_name' && !in_array("claimable_pre_set", $tablenamearray)){
                           $this->deleteFromTable('claimable_pre_set');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','claimable_pre_set')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('claimable_pre_set')->insert(array('category_name' => $cat->id,'value' => $dtcd->value)); 
                            }
                           
                       }
                       if($table=='category_name' && !in_array("emergency_leave", $tablenamearray)){
                           $this->deleteFromTable('emergency_leave');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','emergency_leave')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('emergency_leave')->insert(array('category_name' => $cat->id,'value' => $dtcd->value)); 
                            }
                           
                       }
                       if($table=='category_name' && !in_array("max_past_leave", $tablenamearray)){
                           $this->deleteFromTable('max_past_leave');
                           $category=DB::table('category_name')->get();
                           $dtcd=DB::table('settings')->where('field','max_past_leave')->select('value')->first();
                            foreach($category as $cat){
                               DB::table('max_past_leave')->insert(array('category_name' => $cat->id,'value' => $dtcd->value ?? 0)); 
                            }
                           
                       }
                        
                        
                    }
                }
                
                if($table=='settings'){
                    if(getSettingsValue('otp')==0){
                        DB::table('settings')->insert(array('field' => 'otp','value' => '0'));
                    }
                    if(getSettingsValue('cut_of_month')==0){
                        DB::table('settings')->insert(array('field' => 'cut_of_month','value' => '12'));
                    }
                    if(getSettingsValue('cut_of_date')==0){
                        DB::table('settings')->insert(array('field' => 'cut_of_date','value' => '31'));
                    }
                    if(getSettingsValue('cut_of_startmonth')==0){
                        DB::table('settings')->insert(array('field' => 'cut_of_startmonth','value' => '1'));
                    }
                    if(getSettingsValue('cut_of_startdate')==0){
                        DB::table('settings')->insert(array('field' => 'cut_of_startdate','value' => '1'));
                    }
                    
                }
                
                if($table=='details'){
                    $dtcd=DB::table('details')->where('field','company_details')->select('value')->first();
                    $dtcl=DB::table('details')->where('field','company_logo')->select('value')->first();
                    $dtls=DB::table('details')->where('field','license_start')->select('value')->first();
                    $dtle=DB::table('details')->where('field','license_end')->select('value')->first();
                    $dtml=DB::table('details')->where('field','master_location')->select('value')->first();
                    $dtbm=DB::table('details')->where('field','broadcast_msg')->select('value')->first();
                    
                    
                       try {
                         DB::table('details')->where('field','company_details')->update(array('v4_value'=>$dtcd->value));
                    } catch (\Exception $th) {
                    }
                    
                    
                       try {
                         DB::table('details')->where('field','company_logo')->update(array('v4_value'=>$dtcl->value));
                    } catch (\Exception $th) {
                    }
                    
                    
                       try {
                       DB::table('details')->where('field','license_start')->update(array('v4_value'=>$dtls->value));
                    } catch (\Exception $th) {
                    }
                    
                        try {
                     DB::table('details')->where('field','license_end')->update(array('v4_value'=>$dtle->value));
                    } catch (\Exception $th) {
                    }
                          try {
                      DB::table('details')->where('field','master_location')->update(array('v4_value'=>$dtml->value));
                    } catch (\Exception $th) {
                    }
                    
                          try {
                       DB::table('details')->where('field','broadcast_msg')->update(array('v4_value'=>$dtbm->value));
                    } catch (\Exception $th) {
                    }
                    
                  
                  
                   
                  
                   
                }
                if($table='permission_group'){
                    try {
                        DB::statement("ALTER TABLE `permission_group` CHANGE `approver_view_all` `approval_view_all` INT(11) NOT NULL DEFAULT '0'");
                    } catch (\Exception $th) {
                    }
                }
               
            }
            }
            
            return $path;
       
    }
    
    public function dirpath($path){
       $result= glob($path . '/*' , GLOB_ONLYDIR);
       if(!is_file($result[0])){
           
           return $result;
       }
       return false;
    }

    public function getTableData($table)
    {
        $result = DB::table($table)->get();

        return $result;
    }

    public function uploadFile($filename, $tempname, $target)
    {
        $filename = basename($filename);
        $extension = pathinfo($filename, PATHINFO_EXTENSION);
        if ($this->checkExtension($extension)) {
            if ($filename != '') {

                if (!move_uploaded_file($tempname, $target)) {
                    echo 'There was an error uploading the file, please try again!<br>' . $filename . ',' . $tempname;
                    return;
                }
                // End of uploading
            }
        } else
            echo 'Invalid Extension';
    }

    public function checkExtension($extension)
    {
        $allow = array('sql');

        for (
            $i = 0;
            $i < count($allow);
            $i++
        )
            if ($allow[$i] == strtolower($extension))
                return true;
        return false;
    }
    
    

    public function xmlToArray($xml)
    {
        $xml = simplexml_load_file('branch.xml');
        $arr = (array) $xml;
        echo var_dump($arr);
    }
    /* creates a compressed zip file */


    public function unzip_file($source, $destination)
    {
       // dd($source, $destination);
        $zip = new ZipArchive;
        $res = $zip->open($source);
        //dd($res,$destination);
        if ($res === TRUE) {
            $zip->extractTo($destination);
            $zip->close();
        }
    }

}


  