<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Leavelist extends Model
{
    use HasFactory;
    protected $table = 'leave_list';
    public $timestamps = false;
    protected $fillable = ['username' , 'approver_id' , 'type' , 'is_half_day' , 'half_day_type' , 'start_date' , 'end_date' , 'no_days' ,  'reason', 'relieve','filename', 'status' ];
    

    public function getType()
    {
        return $this->belongsTo(Leavetype::class, 'type', 'type');
    }

}
