<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;
    protected $table = 'users';
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username',
        'password',
        'account_type',
        'company_id',
        'token',
        'status'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
    ];

    public function personal()
    {
        return $this->belongsTo(UserPersonal::class, 'username', 'username');
    }
    public function userPay()
    {
        return $this->belongsTo(UserPay::class, 'username', 'username');
    }
    public function spouse()
    {
        return $this->belongsTo(UserSpouse::class, 'username', 'username');
    }
    public function address()
    {
        return $this->belongsTo(UserAddress::class, 'username', 'username');
    }

}
