<?php

namespace App\Providers;

use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;

class MailConfigServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        if (\Schema::hasTable('settings')) {
            $mail = DB::table('settings')->whereIn('field', ['email_smtp_server', 'email_port','email_email_id','email_password','email_sender_name'])->get();

            foreach ($mail as $value) {
                if($value->field=="email_smtp_server"){
                    $server=$value->value;
                }
                if($value->field=="email_port"){
                    $port=$value->value;
                }
                if($value->field=="email_email_id"){
                    $emailid=$value->value;
                }
                if($value->field=="email_password"){
                    $password=$value->value;
                }
                if($value->field=="email_sender_name"){
                    $sendername=$value->value;
                }
            }
           
            if ($mail) //checking if table is not empty
            {
                $config = array(
                    'driver'     => "smtp",
                    'host'       => $server,
                    'port'       => $port,
                    'from'       => array('address' => $emailid, 'name' => $sendername),
                    'encryption' => "tls",
                    'username'   => $emailid,
                    'password'   => $password,
                    'options' => array(
                    'ssl' => array(
                            'verify_peer' => false,
                            'verify_peer_name' => false,
                            'allow_self_signed' => true
                        )
                    ),
                    //'sendmail'   => '/usr/sbin/sendmail -bs',
                    //'pretend'    => false,
                );
                Config::set('mail', $config);
            }
        }
    }
}
?>