<?php
use Illuminate\Support\Facades\DB;
use \App\Mail\MyDemoMail;
use Illuminate\Http\Request;
use App\Models\{User , Leavetype,Schedule, Relieve , Leavelist, LeaveDay, UserPay, LeaveAdjustment,LeavePast,Message, MapEmployeeApprover, UserPersonal, PublicHoliday, Category, Department, ApproverApprovedLeave,LeaveEntitleHistory,PendingEmail};

use Illuminate\Support\Facades\Auth;
// use DateTime;

use Illuminate\Support\Facades\Log;
use App\Jobs\SendEmailJob;



if (!function_exists('carbon')) {
    function carbon($time = null, $tz = null)
    {
        return new \Carbon\Carbon($time, $tz);
    }
}

function gethours(){
    return 8;
}

function notification(){
    $user = User::where('id' , Auth::id())->first();
    $notification = Message::leftJoin('user_personal', 'messages.sender', '=', 'user_personal.username')->select('messages.*', 'user_personal.name')->orderBy('messages.time' , 'DESC')->where('messages.recipient' , $user->username)->where('messages.expiry_date','>=',date('Y-m-d'))->get();
    return $notification;
}

 function getEClaimAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("eclaim", $user->username) > 0)
			return getPermissionValue("eclaim", $user->username);
		return 0;
    }

function isLeaveHourlyAllow($username, $startDate, $startHour, $endHour)
{
        $result = Leavelist::where('username',$username)->where('start_date',$startDate)->where('end_date',$startDate)->whereRaw("(status='1' OR status='0')")->where('is_hourly',0)->count('id');
        $allow = '1';
        if($result>0){
            $allow = '0';
        }
        if($allow=='1'){
            
            $result = Leavelist::where('username',$username)->where('start_date',$startDate)->where('end_date','<=',$startDate)->whereRaw("(status='1' OR status='0')")->whereRaw("(( start_time BETWEEN '".$startHour."' and '".$endHour."')  OR (end_time BETWEEN '".$startHour."' and '".$endHour."'))")->get();
            for($i=0;$i<count($result);$i++){
                $allow = '0';
            }
        }
        
        return $allow;
}

function day_count_anniv_cutt_off($username,$year){
    $joiningDate = getJoinDateStr($username);
    $joiningDateArr=explode('-',$joiningDate);
    $joining_month=$joiningDateArr[1];
    $joining_date=$joiningDateArr[2];

    $joining_curr_Date = $year.'-'.$joining_month.'-'.$joining_date;
    $curr_date = date('Y-m-d');

    $d = date('Y-m-d', strtotime($joining_curr_Date.'+1 years'));
    $d1 = date('Y-m-d', strtotime($d.'-1 day'));
    if($d1 <= date('Y-m-d')){
        $curr_date = $d1;
    }
    //echo $joining_curr_Date.'--'.$d1.'<br>';
    $date1 = new DateTime($joining_curr_Date);
    $date2 = new DateTime($curr_date);
    $diff = $date1->diff($date2);
    if($joining_curr_Date>date('Y-m-d')){
        return '0';
    }else{
        return $diff->days;
    }
}

function getJoinDateStr($username)
{
	$query = UserPay::where('username', $username)->first();
	return $query->date_commence;
}

function tilldateDays($joiningDate)
{
	$now = time(); // or your date as well
	$your_date = strtotime($joiningDate);
	$datediff = $now - $your_date;
	return floor($datediff / (60 * 60 * 24));
}

function tillYearEndDays($joiningDate)
{

	$currentY = date('Y');
	$yearE = mktime(0, 0, 0, 12, 31,  $currentY);

	$your_date = strtotime($joiningDate);
	$datediff = $yearE - $your_date;
	return floor($datediff / (60 * 60 * 24));
}

function getBroughtForwardLeaveCount($username, $year, $type){
	$query = DB::table('leave_bf_adj')->where('username', $username)->where('year', $year)->where('leave_type', $type)->sum('bf_adj');
	return $query;
}

function getBroughtForwardLeaveCount11($connection,$username, $year, $type){
	$query = $connection->table('leave_bf_adj')->where('username', $username)->where('year', $year)->where('leave_type', $type)->sum('bf_adj');
	return $query;
}

function getBroughtForwardLeaveNotAdjusted($username, $year, $type)
{
	$setting = DB::table('settings')->where('field', 'medical_leave_bf_allow')->first();

	$query = DB::table('leave_entitle_history')->where('username', $username)->where('year', $year)->where('leave_type', $type)->first();

//dd($query);
	if($type=="Medical" && $setting->value == 0){
		return 0;
	}

    $mcBf = (($query->entitle ?? 0) + ($query->bf_leaves ?? 0 )+ ($query->adjustment ?? 0)) - ($query->leave_taken ?? 0);
    if($mcBf == null){
        return 0;
    }
	$val = (floatval($mcBf)) + 0;


	if($val<0){
		return 0;
	}

	return $val;
}

function getBroughtForwardLeaveNotAdjusted11($connection,$username, $year, $type)
{
	$setting = $connection->table('settings')->where('field', 'medical_leave_bf_allow')->first();

	$query = $connection->table('leave_entitle_history')->where('username', $username)->where('year', $year)->where('leave_type', $type)->first();

//dd($query);
	if($type=="Medical" && $setting->value == 0){
		return 0;
	}

    $mcBf = (($query->entitle ?? 0) + ($query->bf_leaves ?? 0 )+ ($query->adjustment ?? 0)) - ($query->leave_taken ?? 0);
    if($mcBf == null){
        return 0;
    }
	$val = (floatval($mcBf)) + 0;


	if($val<0){
		return 0;
	}

	return $val;
}

function  getEntitleLeave($username, $year, $type)
{
    $query = DB::table('leave_entitle_history')->where('username', $username)->where('year', $year)->where('leave_type', $type)->first();

    if(!isset($query))
    {
        return 0;
    }

    return $query->entitle;
}

function getTotalReplaceLeave($username, $year)
{
    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = DB::table('leave_adjustment')->where('employee_id', $username)
        ->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('end_date', '<=', $endOfYear->format('Y-m-d'))->sum('no_granted');

    return $query;
}

function getAnnualClaimable($username, $year, $type)
{
    //$claimable_pre_set = DB::table('settings')->where('field', 'claimable_pre_set')->first();
    $user=DB::table('users')->where('username',$username)->first();
    $usercat =DB::table('user_category')->where('username',$username)->first();
    //dd($usercat);
    $claimable_pre_set = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();

    $current_month =  date('n');

    $entitle = getEntitleLeave($username, $year, $type);

    $val = round((($current_month - ($claimable_pre_set->value ?? 0))/12), 2);
    $claim = $val * $entitle;


    return $claim;
}


function getNPLSummary($username, $year)
{
    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = Leavelist::where('username', $username)->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('type', 'NPL')
    ->where('start_date', '<=', $endOfYear->format('Y-m-d'))->where('status', '1')->sum('no_days');

    return $query;
}

function getTakenLeves($username, $year, $type)
{

    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = Leavelist::where('username', $username)->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('type', $type)
    ->where('start_date', '<=', $endOfYear->format('Y-m-d'))->where('status', '1')->sum('no_days');

    return $query;
}

function getAdjustmentLeaveCount($username, $year, $stat = 0){
    if($stat==0){
        $data = LeaveAdjustment::selectRaw('sum(CASE taken_stat WHEN 0 then no_granted WHEN 0.5 THEN (no_granted - 0.5) END) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }else{
        $data = LeaveAdjustment::selectRaw('sum(no_granted) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }
    if($data!= ''){
        if($data->sumVal!=''){
            return $data->sumVal;
        }
        else{
            return 0;
        }
        
    }else{
        return 0;
    }
}

function getAdjustmentLeaveCount11($connection,$username, $year, $stat = 0){
    if($stat==0){
        $data = $connection->table('leave_adjustment')->selectRaw('sum(CASE taken_stat WHEN 0 then no_granted WHEN 0.5 THEN (no_granted - 0.5) END) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }else{
        $data = $connection->table('leave_adjustment')->selectRaw('sum(no_granted) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }
    if($data!= ''){
        if($data->sumVal!=''){
            return $data->sumVal;
        }
        else{
            return 0;
        }
        
    }else{
        return 0;
    }
}
// function getLeaveAdjustmentType(){
//     return DB::table('settings')->where("field",'leave_adjustment_type')->first()->value;
// }
function getSettingsValue($field = 'leave_adjustment_type'){
    return DB::table('settings')->where("field",$field)->first()->value ?? 0;
}
function getTakenLeaveCountDateBy($username, $year, $type, $startDate=null, $endDate=null){
    $cutOffDate = getCutOffDate();
    $cutOffMonth = getCutOffMonth();

    $cutOffStartDate = getCutOffStartDate();
    $cutOffStartMonth = getCutOffStartMonth();
    $hours = gethours();

    $query = LeaveDay::selectRaw("sum(CASE leave_list.is_hourly WHEN 1 THEN (((leave_list.end_time-leave_list.start_time)/3600 )/'$hours') WHEN 0 THEN leave_list.no_days END) as leave_taken")
             ->leftJoin('leave_list','leave_list.id','=','leave_days.leave_id')
             ->where('leave_days.status','1')
             ->where('leave_list.type',$type)
             ->where('leave_days.username',$username);
    //$year=date('Y',strtotime($year));
    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }

    if($startDate == null){
        $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    }
    $query =  $query->where('leave_days.date','>=',$startDate);

    if($endDate == null){
        $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
    }
    $query =  $query->where('leave_days.date','<=',$endDate);
    $value = $query->first()->leave_taken;
    if($value==''){
        $value = 0;
    }
    
    return $value;
}
function getPastLeaveCountDateBy($username, $year=null, $type=null, $startDate=null, $endDate=null){
    if($year==null){
        $year = date('Y');
    }
    $cutOffDate = getCutOffDate();
    $cutOffMonth = getCutOffMonth();

    $cutOffStartDate = getCutOffStartDate();
    $cutOffStartMonth = getCutOffStartMonth();

    $query = LeavePast::selectRaw("sum(total_leave_days) as leave_taken")
             ->where('username',"$username");

    if($type != null){
        $query = $query->where('type',$type);
    }
   // $year=date('Y',strtotime($year));
    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }

    if($startDate == null){
        $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    }
    $query =  $query->where('start_date','>=',$startDate);

    if($endDate == null){
        $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
    }
    $query =  $query->where('end_date','<=',$endDate);
    $value = $query->first()->leave_taken;
    if($value==''){
        $value = 0;
    }
    return $value;
}

function getCutOffDate(){
    return getSettingsValue("cut_of_date");
}
function getCutOffMonth(){
    return getSettingsValue("cut_of_month");
}
function getCutOffStartDate(){
    return getSettingsValue("cut_of_startdate");
}
function getCutOffStartMonth(){
    return getSettingsValue("cut_of_startmonth");
}
function myLeaveSummary($username,$year,$type="getYearlyEntitle"){
    $curl = curl_init();

    curl_setopt_array($curl, array(
      //   CURLOPT_URL => "http://localhost/co/v3ecoleaves/controller/leave.php",
      CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "action=".$type."&year=".$year."&username=".$username."",
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
function getLeavsCounts($username,$type,$sdate,$edate,$is_half_day,$action = "getLeaveDaysCount"){
    // dd("action=".$action."&start_date=".$sdate."&start_date=".$edate."&type=".$type."&username=".$username."");
    $curl = curl_init();

    curl_setopt_array($curl, array(
      //CURLOPT_URL => "http://localhost/v3/controller/leave.php",

      CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "action=".$action."&start_date=".$sdate."&end_date=".$edate."&type=".$type."&username=".$username."&is_half_day=".$is_half_day,
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}

function applysleave($username,$type,$approverid,$sdate,$edate,$is_half_day,$half_day_type=null,$no_days,$reason,$is_replacement,$filename=null,$Relieve=null,$action="addLeave"){
    // dd("action=".$action."&start_date=".$sdate."&start_date=".$edate."&type=".$type."&username=".$username."");
  
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
     
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => "action=".$action."&approver_id=".$approverid."&start_date=".$sdate."&end_date=".$edate."&type=".$type."&username=".$username."&is_half_day=".$is_half_day."&half_day_type=".$half_day_type."&no_days=".$no_days."&reason=".$reason."&is_replacement=".$is_replacement."&filename=".$filename."&Relieve=".$Relieve,
      
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));
// $curl = curl_init();

// curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://v3.ecoleave.asia/controller/leave.php',
//   CURLOPT_RETURNTRANSFER => true,
//   CURLOPT_ENCODING => '',
//   CURLOPT_MAXREDIRS => 10,
//   CURLOPT_TIMEOUT => 0,
//   CURLOPT_FOLLOWLOCATION => true,
//   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//   CURLOPT_CUSTOMREQUEST => 'POST',
//   CURLOPT_POSTFIELDS => array('action' => 'addLeave','approver_id' => '4000','start_date' => '2021-08-26','end_date' => '2021-08-26','type' => 'Annual','username' => '4003','is_half_day' => '1','half_day_type' => 'first','no_days' => '0.5','reason' => 'teset','is_replacement' => '0','filename' => '','Relieve' => '3001'),
//   CURLOPT_HTTPHEADER => array(
//     'Content-Type: application/x-www-form-urlencoded',
//     'Cache-Control: no-cache'
//   ),
// ));

    $response = curl_exec($curl);
    
    $err = curl_error($curl);
 
// \Log::info(json_encode($response));
//  \Log::info(json_encode($err));
 
    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
function selfleave($id,$status,$cancel_reason='',$reject_reason='',$action='multipleSetStatus'){
    if($action==null){
        $action='multipleSetStatus'; 
    }
   $data=[
        "action"=>$action,
        "status"=>$status,
        "cancel_reason"=>$cancel_reason,
        "reject_reason"=>$reject_reason
    ];

    foreach ($id as $key => $idd) {
        $data["ids[$key]"] = $idd;
    }

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://v3.ecoleave.asia/controller/leave.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        // CURLOPT_HTTPHEADER => array(
        //         "cache-control: no-cache",
        //         "Content-Type: application/json",
        //  ),
      ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    \Log::info(json_encode($data));
   //  \Log::info(json_encode($response));
    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}


function applyonbehalf($username,$approver_id,$type,$sdate,$edate,$is_half_day,$half_day_type=null,$no_days,$reason,$status,$filename=null,$Relieve,$action="addLeaveByApprover11"){
   $curl = curl_init();
//\Log::info(json_encode($is_half_day));
    curl_setopt_array($curl, array(
      CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "action=".$action."&approver_id=".$approver_id."&start_date=".$sdate."&end_date=".$edate."&type=".$type."&employee_id=".$username."&is_half_day=".$is_half_day."&half_day_type=".$half_day_type."&no_days=".$no_days."&reason=".$reason."&status=".$status."&filename=".$filename."&Relieve=".$Relieve,
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
   // \Log::info(json_encode($response). " : ". json_encode($err));
   // \Log::info(json_encode($no_days));
    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
    
    // by Ashutosh
    function getBranchNameById($id)
	{
		$res = DB::table('branch')->select("name")->where("id",$id)->first();
       
        if($res){
            return $res->name;
        }else{
            return '';
        }
	}
	
	function getDepartmentNameById($id)
	{
		$res = DB::table('department')->select("name")->where("id",$id)->first();
       
        if($res){
            return $res->name;
        }else{
            return '';
        }
	}



function approveleave($approver_id,$id,$status,$cancel_reason='',$reject_reason='',$action='multipleSetStatus'){
    if($action==null){
        $action='multipleSetStatus'; 
    }
   $data=[
        "action"=>$action,
        "approver_id"   =>$approver_id,
        "status"=>$status,
        "cancel_reason"=>$cancel_reason,
        "reject_reason"=>$reject_reason
    ];

    foreach ($id as $key => $idd) {
        $data["ids[$key]"] = $idd;
    }

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://v3.ecoleave.asia/controller/leave.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        // CURLOPT_HTTPHEADER => array(
        //         "cache-control: no-cache",
        //         "Content-Type: application/json",
        //  ),
      ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
   // \Log::info(json_encode($data));
   //  \Log::info(json_encode($response));
    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
function get_anniv_cutt_off_entitle($username,$year){
    $date_commence= UserPay::where('username',$username)->first();
    $joiningDate = $date_commence->date_commence;
    $joiningDateArr=explode('-',$joiningDate);
    $joining_month=$joiningDateArr[1];
    $joining_date=$joiningDateArr[2];
            
    $curr_date = $year.'-'.$joining_month.'-'.$joining_date;
    $curr_date = date('Y-m-d',(strtotime ( '+1 day' , strtotime ($curr_date) ) ));
        
    $date1 = new DateTime($joiningDate);
    $date2 = new DateTime($curr_date);
    $diff = $date1->diff($date2);
    $ExperienceInYear=$diff->y;
    if($diff->d>0){
        $ExperienceInYear = $ExperienceInYear + 1;
    }
    
    $annualEntitle11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
    $annualEntitle = $annualEntitle11->no_leaves;
            
    return $annualEntitle;
}
function YearStartToJoinDays($joiningDate)
	{

		$currentY = date('Y');
		$yearE = mktime(0, 0, 0, 1, 1,  $currentY);

		$your_date = strtotime($joiningDate);
		$datediff = $your_date - $yearE;
		return floor($datediff / (60 * 60 * 24));
    }
function tillTodayTotalDays($year, $leave_date = '')
	{
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;

		if ($leave_date != '') {
			$leave_date = strtotime(str_replace('/', '-', $leave_date));
			$leave_year = date('Y', $leave_date);
			$leave_month = date('m',$leave_date);
		} else {
			$leave_year = $year;
			$leave_month = date('m');
		}

		if($cutOffStartMonth!=1){
			if($cutOffStartMonth >= $leave_month){
				$cutOffStartYear = $leave_year;
				$cutOffYear = $leave_year;
			}else{
				$cutOffStartYear = $leave_year-1;
				$cutOffYear = $leave_year;
			}
		}else{
			$cutOffStartYear = $leave_year;
			$cutOffYear = $leave_year;
		}
		
		
		if ($leave_date != '') {
			$Check_now = $leave_date;
		} else { 
			$Check_now = time(); 
		}
		
		
		$check_your_date = strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
		
		$check_datediff = $Check_now - $check_your_date;
		return floor($check_datediff / (60 * 60 * 24));
	}
// function getYearWiseFixLeaveEntitle($username, $type="Annual", $currentDate){
//     $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
//     $cutOffMonth = $cutOffMonth11->value;
//     $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
//     $cutOffDate=$cutOffDate11->value;
//     $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
//     $cutOffStartDate=$cutOffStartDate11->value;
//     $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
//     $cutOffStartMonth=$cutOffStartMonth11->value;
//     $date_commence= UserPay::where('username',$username)->first();
//     $commence_year=$date_commence->date_commence;
//     $date_resigned=$date_commence->date_resigned;
//     $resign_year = date('Y',strtotime($date_resigned));
//     $experience_check = 0;
//     $SettingLeaveAdjustmentType= DB::table('settings')->where('field', "leave_adjustment_type")->first();
//     $medicalLeaveProRated = DB::table('settings')->where('field', "medical_leave_prorated")->first();
//     $actual_experience = 0;
//     $_check_year = date('Y',strtotime($currentDate));
//     $cutOffStartYear = $_check_year;
//     $cutOffYear = $_check_year;
//         if($cutOffStartMonth!=1){
//             if($cutOffStartMonth > date('m')){
//                 $cutOffStartYear = $_check_year;
//                 $cutOffYear = $_check_year;
//             }else{
//                 $cutOffStartYear = $_check_year-1;
//                 $cutOffYear = $_check_year;
//             }
//         }else{
//             $cutOffStartYear = $_check_year;
//             $cutOffYear = $_check_year;
//         }
//         if($SettingLeaveAdjustmentType->value == 6){
//             $date_for_query = "CURDATE()";
            
//             $year_for_check = date('Y');
//             $year_for_check = date("Y",  strtotime($currentDate));
//             //$_d = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
//             $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
//             $date_for_query = "'".$_d."'";
            
//             $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".date("Y")."-".$cutOffMonth."-".$cutOffDate."') as 'days' ")->first();
//             $actual_experience = intval($resultArrayVal->experience);
//             $date_commence = $resultArrayVal->date_commence;
//             $ExperienceInYear = $actual_experience + 1;
            
//             if(date("Y",  strtotime($date_commence))==  $year_for_check){
            
//                 $resultArrayVal1 = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".$year_for_check."-".$cutOffMonth."-".$cutOffDate."') as 'days'")->first();

//                 $actual_experience = intval($resultArrayVal1->experience);
//                 $date_commence = $resultArrayVal1->date_commence;
//                 $ExperienceInYear = $actual_experience + 1;
//                 $days_difference =  $resultArrayVal1->days;
//                 $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//                 $entitle_year_base =  $entitle_year_base11->no_leaves;
//                 if($entitle_year_base==""){
//                     $entitle_year_base = 0;
//                 }
//                 $currentYearTotalDays = date("z", mktime(0,0,0,12,31,$year_for_check)) + 1;
//                 $entitle = ($days_difference/$currentYearTotalDays) * $entitle_year_base;
//                 $value = round($entitle * 2) / 2;
//                 return $value;
//                 exit;
                
//             }

//             $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//             $entitle_year_base =  $entitle_year_base11->no_leaves;
//                 if($entitle_year_base==""){
//                     $entitle_year_base = 0;
//                 } 
//             return $entitle_year_base;
//             exit;
//         }
//         elseif($SettingLeaveAdjustmentType->value == 7){
//             if($type=="Medical"){
//                 $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
//                 $date_for_query = "'".$_d."'";
//                 $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
//                 $ExperienceInYear = intval($resultArrayVal->experience) + 1;
//                 $date_commence = $resultArrayVal->date_commence;
//                 $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//                 $entitle_year_base =  $entitle_year_base11->no_leaves;
//                 if($entitle_year_base==""){
//                     $entitle_year_base = 0;
//                 } 
//                 if($resign_year!='-1' && $resign_year== $_check_year){
//                     if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
//                         $first_date = strtotime($commence_year);
//             			$second_date = strtotime($date_resigned);
//             			$datediff = $second_date - $first_date;
//             			$year_total_days = floor($datediff/(60*60*24))+1;
//                         return $entitle_year_base * ($year_total_days/365);
//                         exit;
//                     }
//                     else{
//                         $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
//             			return $entitle_year_base * ($days_before_resign/365);
//             			exit;

//                     }

//                 }
//                 return $entitle_year_base;
//             		exit;
//             }
//             $date_commence = $date_commence->date_commence;
//             $date_for_query = "CURDATE()";
//             $date_for_query1 = "CURDATE()";
//             $year_first_date = "";
//             $year_last_date = "";
//             $_d = $cutOffStartYear."-".$cutOffStartMonth."-".$cutOffStartDate;
//             $_d1 = $cutOffYear."-".$cutOffMonth."-".$cutOffDate;
//             $date_for_query = "'".$_d."'";
//             $date_for_query1 = "'".$_d1."'";
//             $year_first_date= $_d;
//             $year_last_date = $_d1;
//             $resultArrayVal= UserPay::where('username',$username)->selectRaw(" TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience1, TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query1.") as experience2,date_commence")->first();
//             $first_experience = $resultArrayVal->experience1+1;
//             $second_experience = $resultArrayVal->experience2+1;
//             $entitle_before11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$first_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//             $entitle_before = $entitle_before11->no_leaves;
//             if($entitle_before==""){
//                 $entitle_before = 0;
//             } 
//             $entitle_after11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$first_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//             $entitle_after = $entitle_after11->no_leaves;
//             if($entitle_after==""){
//                 $entitle_after = 0;
//             } 

//             $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  $cutOffStartYear;
//             $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  $cutOffYear;
//             if(date('m',strtotime($date_commence)) >= $cutOffStartMonth){
//                 $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".$cutOffStartYear;
//             }else{
//                 $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',strtotime($currentDate));
//             }

//             $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year)+1;
//             $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year);
//             $entitle_before_new = ($entitle_before/365)*$ExperienceInDaysBefore;
//             $entitle_after_new = ($entitle_after/365)*$ExperienceInDaysAfter;
//             if(strtotime($join_date_in_current_year) == strtotime($date_commence)){
//                 if($resign_year!='-1' && $resign_year==  $_check_year){
//                     if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
//                         $first_date = strtotime($commence_year);
//             			$second_date = strtotime($date_resigned);
//             			$datediff = $second_date - $first_date;
// 						$year_work_days = floor($datediff/(60*60*24))+1;
// 						$year_start_date_s = date("Y")."-01-01";
							
// 						$year_end_date_s = date("Y")."-12-31";
							
// 						$year_total_days = floor((strtotime($year_end_date_s) - strtotime($year_start_date_s))/(60*60*24)) + 1;
//                         return $entitle_after_new* ($year_work_days/$year_total_days);
//             			exit;
//                     }
//                     else{
//                         $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
//                         return $entitle_after_new* ($days_before_resign/365);
//             			exit;
//                     }
//                 }
//                 return $entitle_after_new;
//             }
//             $entitle = $entitle_before_new+ $entitle_after_new;
//             $value = round($entitle * 2) / 2;
//             if($resign_year!='-1' && $resign_year==  $_check_year){
//                 $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
//                 return $value * ($days_before_resign/365);
//                 exit;
//             }
//             return $value;
//             exit;
//         }
//         elseif($SettingLeaveAdjustmentType->value == 5){
//             if($type=="Medical"){
//                 $date_for_query = "CURDATE()";
//                 $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
//                 $date_for_query = "'".$_d."'";
//                 $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
//                 $ExperienceInYear = intval($resultArrayVal->experience) + 1;
//                 $date_commence = $resultArrayVal->date_commence;
//                 $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//                 $entitle_year_base =  $entitle_year_base11->no_leaves;
//                 if($entitle_year_base==""){
//                     $entitle_year_base = 0;
//                 }
//                 if($resign_year!='-1' && $resign_year==  $_check_year){
//                     $days_before_resign = FromYearStartDays($date_resigned, $_check_year);
//                     return $entitle_year_base * ($days_before_resign/365);
//                     exit;
//                 }
//                 return $entitle_year_base;
//                 exit;
//             }
//             $date_for_query = "CURDATE()";
//             $date_for_calculation = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
//             $_d = date("Y",  strtotime($currentDate))."-".$cutOffStartDate."-".$cutOffStartMonth;
//             $date_for_query = "'".$_d."'";
//             $date_for_calculation = $_d;
//             $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
//             $ExperienceInYear_forfirst = intval($resultArrayVal->experience) + 1;
//             $date_commence = $resultArrayVal->date_commence;
//             if($ExperienceInYear_forfirst==0){
//                 $ExperienceInYear_forfirst = 1;
//             }
//             $experience_at_current_year_end = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,'".(date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate)."') as experience")->first();
//             if($experience_at_current_year_end->experience==0){
//                 $experience_at_current_year_end = 1;
//             }
//             else{
                
//                     $experience_at_current_year_end = $experience_at_current_year_end->experience;
                
//             }
            
//             $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear_forfirst)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//             $entitle_year_base =  $entitle_year_base11->no_leaves;
//             if($entitle_year_base==""){
//                 $entitle_year_base = 0;
//             }

//             $entitle_current_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$experience_at_current_year_end)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
//             $entitle_current_year_base =  $entitle_current_year_base11->no_leaves;
//             $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  date("Y",strtotime($date_for_calculation));
//             $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  date("Y",strtotime($date_for_calculation));
//             $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',  strtotime($date_for_calculation));
//             $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year)+1;
//             $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year);
//             $currentYearTotalDays = date("z", mktime(0,0,0,12,31,date('Y',strtotime($date_for_calculation)))) + 1;
//             $entitleBefore = ($ExperienceInDaysBefore/$currentYearTotalDays) * $entitle_year_base;
//             $entitleAfter = ($ExperienceInDaysAfter/$currentYearTotalDays) * $entitle_current_year_base;
//             if (strtotime($join_date_in_current_year) == strtotime($date_commence)){
//                 if($resign_year!='-1' && $resign_year==  $_check_year){
//                     $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
//                     //return $entitleAfter * ($days_before_resign/365);
//                     return $entitle_current_year_base * ($days_before_resign/365);
//                     exit;
//                 }
//                 return $entitleAfter;
//             }
            
//             $entitle = $entitleBefore + $entitleAfter;
                    
//             $value = round($entitle * 2) / 2;
//             if($resign_year!='-1' && $resign_year==  $_check_year){
//                 $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
//                 //return $value * ($days_before_resign/365);
//                 return $entitle_current_year_base * ($days_before_resign/365);
//                 exit;
//             }
//             return $value;
                
                
//         }
//         elseif($SettingLeaveAdjustmentType->value == 0){
//             $resultArrayVal = UserPay::where('username',$username)->selectRaw("(year('".$currentDate."') * 365.24 + month('".$currentDate."') * 30.5 + day('".$currentDate."'))/365.24 - (year(date_commence) * 365.24 + month(date_commence) * 30.5 + day(date_commence)) / 365.24 as experience")->first();
//             $experience = intval($resultArrayVal->experience);
//             $actual_experience = $experience;
//             $experience_check = 1;

//         }
//         elseif($SettingLeaveAdjustmentType->value == 2){
//             $resultArrayVal = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence)as experience,month(date_commence) as join_month")->first();
//             $actual_experience = $resultArrayVal->experience; 
//             if($resultArrayVal->join_month<=6 && $resultArrayVal->experience>=1){ 
//                 $experience = $resultArrayVal->experience;
//                 $experience_check = 0;
//             }elseif($resultArrayVal->join_month>6 && $resultArrayVal->experience>=1){ 
//                     $experience = $resultArrayVal->experience-1;
//                     $experience_check = 0;
//             }else{
//                     $experience = 0;
//                     $experience_check = 0;
//             }

//         }
//         else{
//             $resultArrayVal = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience")->first();
//             $experience = ((intval($resultArrayVal->experience) > 0)? intval($resultArrayVal->experience): 0);
//             $experience_check = 1;
//             $actual_experience = $experience;

//         }
//         if($SettingLeaveAdjustmentType->value != 2){
//             $experience = intval($resultArrayVal->experience);
//             $actual_experience = $experience;
//         }
//     $entitle11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',($experience + 1))->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();  
//     $entitle =  $entitle11->no_leaves;
//     $actual_entitle = $entitle;
//     if($type=='Medical' && !$medicalLeaveProRated->value){
//         if($resign_year!='-1' && $resign_year==  date('Y')){
//             $days_before_resign = FromYearStartDays($date_resigned);
//             return $entitle * ($days_before_resign/365);
//             exit;
//         }
//         return $entitle;
//         exit;
//     }
//     if($SettingLeaveAdjustmentType->value==3 && strtolower($type)=='annual'){
//         $entitle_value = 0;
//         $date_commence = UserPay::where('username',$username)->selectRaw("date_commence")->first();
//         $joining_timestamp = strtotime($date_commence->date_commence);
// 		$joining_year = date('Y',$joining_timestamp);
//         $current_year = date('Y',strtotime($currentDate));
//         if($current_year==$joining_year){
//             $month_join = date('m',$joining_timestamp);
//             if($month_join<12){
//                 $entitle_value = ((12-$month_join)/12)*$entitle;
//             }else{
//                 $entitle_value = $entitle;
//             }
//         }else{
//             $entitle_value = $entitle;
//         }
//         return $entitle_value;
//     }
//     if($experience == 0 && $experience_check && $SettingLeaveAdjustmentType->value!=3)
// 	{
//         $expValues = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience, 12 - month(date_commence) as months")->first();
//         $exp = $expValues->experience;
//         $months = $expValues->months;
//         if($SettingLeaveAdjustmentType->value==0){
//             $months = $months + 1;
//         }
//         if($exp=="0"){
//             $entitle = intval($entitle) * $months / 12;
//         }
        
//     }
//     if($SettingLeaveAdjustmentType->value==4)
// 	{
//         $commence_year = UserPay::where('username',$username)->selectRaw("date_commence")->first();
//         $year_value = date('Y',strtotime($commence_year->date_commence));
                    
//         $year_first_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffStartMonth."-".$cutOffStartDate);
//         $year_end_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate);
//         $today_date = strtotime(date('Y-m-d',strtotime($currentDate)));
                    
//         $year_total_days = floor(($year_end_date-$year_first_date)/(60*60*24))+1;
                    
//         $entitle_1_first_days =  floor(($today_date-$year_first_date)/(60*60*24))+1;
//         $entitle_1 = ($entitle_1_first_days/$year_total_days)* $actual_entitle;
                    
//         $entitle_2_first_days =  floor(($year_end_date-$today_date)/(60*60*24))+1;
//         $entitle_2 = ($entitle_2_first_days/$year_total_days)* $actual_entitle;
                    
//                     $entitle = $entitle_1 + $entitle_2;
//     }
//     if($SettingLeaveAdjustmentType->value == 2 && $experience == 0 ){
//         $new_e = 0;
//         $year_value = date('Y',strtotime($commence_year));
// 		if($year_value==date('Y',strtotime($currentDate))){
// 			$first_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffStartMonth."-".$cutOffStartDate);
// 			$second_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffMonth."-".$cutOffDate);
// 			$datediff = $second_date - $first_date;
// 			$year_total_days = floor($datediff/(60*60*24))+1;
				
// 			$today_date_val = strtotime(date('Y-m-d',strtotime($commence_year)));
// 			$reamining_days_datediff = $second_date - $today_date_val;
// 			$reamining_days = floor($reamining_days_datediff/(60*60*24));
// 			$new_e = ($reamining_days/$year_total_days)*$entitle;
				
// 		}
// 		if($year_value<date('Y',strtotime($currentDate)) && $actual_experience>0){
// 			$new_e = $entitle;
// 		}
// 		$entitle = $new_e;

//     }
//     if($resign_year!='-1' && $resign_year==  date('Y',strtotime($currentDate))){
//         $days_before_resign = FromYearStartDays($date_resigned);
        
//         return $entitle * ($days_before_resign/365);
//     }
//     return $entitle; 

// }

function getYearWiseFixLeaveEntitle($username, $type="Annual", $currentDate){
    $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $date_commence= UserPay::where('username',$username)->first();
    $commence_year=$date_commence->date_commence;
    $date_resigned=$date_commence->date_resigned;
    $resign_year = date('Y',strtotime($date_resigned));
    $experience_check = 0;
    $SettingLeaveAdjustmentType= DB::table('settings')->where('field', "leave_adjustment_type")->first();
    $medicalLeaveProRated = DB::table('settings')->where('field', "medical_leave_prorated")->first();
    $actual_experience = 0;
    $_check_year = date('Y',strtotime($currentDate));
    $cutOffStartYear = $_check_year;
    $cutOffYear = $_check_year;
        if($cutOffStartMonth!=1){
            if($cutOffStartMonth > date('m')){
                $cutOffStartYear = $_check_year;
                $cutOffYear = $_check_year;
            }else{
                $cutOffStartYear = $_check_year-1;
                $cutOffYear = $_check_year;
            }
        }else{
            $cutOffStartYear = $_check_year;
            $cutOffYear = $_check_year;
        }
        if($SettingLeaveAdjustmentType->value == 6){
            $date_for_query = "CURDATE()";
            
            $year_for_check = date('Y');
            $year_for_check = date("Y",  strtotime($currentDate));
            //$_d = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
            $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
            $date_for_query = "'".$_d."'";
            
            $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".date("Y")."-".$cutOffMonth."-".$cutOffDate."') as 'days' ")->first();
            $actual_experience = intval($resultArrayVal->experience);
            $date_commence = $resultArrayVal->date_commence;
            $ExperienceInYear = $actual_experience + 1;
            
            if(date("Y",  strtotime($date_commence))==  $year_for_check){
            
                $resultArrayVal1 = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".$year_for_check."-".$cutOffMonth."-".$cutOffDate."') as 'days'")->first();

                $actual_experience = intval($resultArrayVal1->experience);
                $date_commence = $resultArrayVal1->date_commence;
                $ExperienceInYear = $actual_experience + 1;
                $days_difference =  $resultArrayVal1->days;
                $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                }
                $currentYearTotalDays = date("z", mktime(0,0,0,12,31,$year_for_check)) + 1;
                $entitle = ($days_difference/$currentYearTotalDays) * $entitle_year_base;
                $value = round($entitle * 2) / 2;
                return $value;
                exit;
                
            }

            $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                } 
            return $entitle_year_base;
            exit;
        }
        elseif($SettingLeaveAdjustmentType->value == 7){
            
            if($type=="Medical"){
                $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
                $ExperienceInYear = intval($resultArrayVal->experience) + 1;
                $date_commence = $resultArrayVal->date_commence;
                $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                } 
                if($resign_year!='-1' && $resign_year== $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
            			$year_total_days = floor($datediff/(60*60*24))+1;
                        return $entitle_year_base * ($year_total_days/365);
                        exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
            			return $entitle_year_base * ($days_before_resign/365);
            			exit;

                    }

                }
                return $entitle_year_base;
            		exit;
            }
            $date_commence = $date_commence->date_commence;
            $date_for_query = "CURDATE()";
            $date_for_query1 = "CURDATE()";
            $year_first_date = "";
            $year_last_date = "";
            $_d = $cutOffStartYear."-".$cutOffStartMonth."-".$cutOffStartDate;
            $_d1 = $cutOffYear."-".$cutOffMonth."-".$cutOffDate;
            $date_for_query = "'".$_d."'";
            $date_for_query1 = "'".$_d1."'";
            $year_first_date= $_d;
            $year_last_date = $_d1;
            $resultArrayVal= UserPay::where('username',$username)->selectRaw(" TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience1, TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query1.") as experience2,date_commence")->first();
            $first_experience = $resultArrayVal->experience1+1;
            $second_experience = $resultArrayVal->experience2+1;
           
            $entitle_before11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$first_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_before = $entitle_before11->no_leaves;
            if($entitle_before==""){
                $entitle_before = 0;
            } 
            $entitle_after11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$second_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_after = $entitle_after11->no_leaves;
            if($entitle_after==""){
                $entitle_after = 0;
            } 

            $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  $cutOffStartYear;
            $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  $cutOffYear;
            if(date('m',strtotime($date_commence)) >= $cutOffStartMonth){
                $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".$cutOffStartYear;
            }else{
                $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',strtotime($currentDate));
            }

            $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year);
            $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year)+1;
            $entitle_before_new = ($ExperienceInDaysBefore/365)*$entitle_before;
            $entitle_after_new = ($ExperienceInDaysAfter/365)*$entitle_after;
            
            if(strtotime($join_date_in_current_year) == strtotime($date_commence)){
                
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                       
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
						$year_work_days = floor($datediff/(60*60*24))+1;
						$year_start_date_s = date("Y")."-01-01";
						$year_end_date_s = date("Y")."-12-31";
							
						$year_total_days = floor((strtotime($year_end_date_s) - strtotime($year_start_date_s))/(60*60*24)) + 1;
						 //  dd($entitle_before,$year_work_days,$year_total_days);
                        return $entitle_before* ($year_work_days/$year_total_days);
            			exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                        return $entitle_before* ($days_before_resign/365);
            			exit;
                    }
                }
                return $entitle_after_new;
            }
            
          
            $entitle = $entitle_before_new+ $entitle_after_new;
            $value = round($entitle * 2) / 2;
             
            if($resign_year!='-1' && $resign_year==  $_check_year){
                $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                 $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $date_resigned);
                $entitle_after_new = ($ExperienceInDaysAfter/365)*$entitle_after;
                $entitle = $entitle_before_new+ $entitle_after_new;
                //dd($entitle);
                return $entitle;
                //return $value * ($days_before_resign/365);
                exit;
            }
            
            //dd($value);
            return $value;
            exit;
        }
        elseif($SettingLeaveAdjustmentType->value == 5){
            if($type=="Medical"){
                $date_for_query = "CURDATE()";
                $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
                $ExperienceInYear = intval($resultArrayVal->experience) + 1;
                $date_commence = $resultArrayVal->date_commence;
                $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                }
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    $days_before_resign = FromYearStartDays($date_resigned, $_check_year);
                    return $entitle_year_base * ($days_before_resign/365);
                    exit;
                }
                return $entitle_year_base;
                exit;
            }
            $date_for_query = "CURDATE()";
            $date_for_calculation = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
            $_d = date("Y",  strtotime($currentDate))."-".$cutOffStartDate."-".$cutOffStartMonth;
            $date_for_query = "'".$_d."'";
            $date_for_calculation = $_d;
            $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
            $ExperienceInYear_forfirst = intval($resultArrayVal->experience);
            $date_commence = $resultArrayVal->date_commence;
            if($ExperienceInYear_forfirst==0){
                $ExperienceInYear_forfirst = 1;
            }
            $experience_at_current_year_end = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,'".(date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate)."') as experience")->first();
            if($experience_at_current_year_end->experience==0){
                $experience_at_current_year_end = 1;
            }
            else{
                
                    $experience_at_current_year_end = $experience_at_current_year_end->experience;
                
            }
           
            $entitle_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear_forfirst)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_year_base =  $entitle_year_base11->no_leaves;
            if($entitle_year_base==""){
                $entitle_year_base = 0;
            }

            $entitle_current_year_base11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$experience_at_current_year_end)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_current_year_base =  $entitle_current_year_base11->no_leaves;
            $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  date("Y",strtotime($date_for_calculation));
            $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  date("Y",strtotime($date_for_calculation));
            $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',  strtotime($date_for_calculation));
            $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year);
            $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year)+1;
            $currentYearTotalDays = date("z", mktime(0,0,0,12,31,date('Y',strtotime($date_for_calculation)))) + 1;
            $entitleBefore = ($ExperienceInDaysBefore/$currentYearTotalDays) * $entitle_year_base;
            $entitleAfter = ($ExperienceInDaysAfter/$currentYearTotalDays) * $entitle_current_year_base;
             //dd($ExperienceInDaysBefore,$ExperienceInDaysAfter,$entitle_year_base,$entitle_current_year_base);
            if (strtotime($join_date_in_current_year) == strtotime($date_commence)){
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
            			$year_total_days = floor($datediff/(60*60*24))+1;
                        return $entitle_year_base * ($year_total_days/365);
                        exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
            			return $entitle_year_base * ($days_before_resign/365);
            			exit;

                    }
                    // $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                    // dd($entitle_year_base,$days_before_resign,$date_resigned,$_check_year);
                    // return $entitle_year_base * ($days_before_resign/365);
                    // exit;
                }
                return $entitleAfter;
            }
            
            $entitle = $entitleBefore + $entitleAfter;
                 
            $value = round($entitle * 2) / 2;
            if($resign_year!='-1' && $resign_year==  $_check_year){
                $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                return $value * ($days_before_resign/365);
                exit;
            }
            return $value;
                
                
        }
        elseif($SettingLeaveAdjustmentType->value == 0){
            $resultArrayVal = UserPay::where('username',$username)->selectRaw("(year('".$currentDate."') * 365.24 + month('".$currentDate."') * 30.5 + day('".$currentDate."'))/365.24 - (year(date_commence) * 365.24 + month(date_commence) * 30.5 + day(date_commence)) / 365.24 as experience")->first();
            $experience = intval($resultArrayVal->experience);
            $actual_experience = $experience;
            $experience_check = 1;

        }
        elseif($SettingLeaveAdjustmentType->value == 2){
            $resultArrayVal = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence)as experience,month(date_commence) as join_month")->first();
            $actual_experience = $resultArrayVal->experience; 
            if($resultArrayVal->join_month<=6 && $resultArrayVal->experience>=1){ 
                $experience = $resultArrayVal->experience;
                $experience_check = 0;
            }elseif($resultArrayVal->join_month>6 && $resultArrayVal->experience>=1){ 
                    $experience = $resultArrayVal->experience-1;
                    $experience_check = 0;
            }else{
                    $experience = 0;
                    $experience_check = 0;
            }

        }
        else{
            $resultArrayVal = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience")->first();
            $experience = ((intval($resultArrayVal->experience) > 0)? intval($resultArrayVal->experience): 0);
            $experience_check = 1;
            $actual_experience = $experience;

        }
        if($SettingLeaveAdjustmentType->value != 2){
            $experience = intval($resultArrayVal->experience);
            $actual_experience = $experience;
        }
    $entitle11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',($experience + 1))->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();  
    $entitle =  $entitle11->no_leaves;
    $actual_entitle = $entitle;
    if($type=='Medical' && !$medicalLeaveProRated->value){
        if($resign_year!='-1' && $resign_year==  date('Y')){
            $days_before_resign = FromYearStartDays($date_resigned);
            return $entitle * ($days_before_resign/365);
            exit;
        }
        return $entitle;
        exit;
    }
    if($SettingLeaveAdjustmentType->value==3 && strtolower($type)=='annual'){
        $entitle_value = 0;
        $date_commence = UserPay::where('username',$username)->selectRaw("date_commence")->first();
        $joining_timestamp = strtotime($date_commence->date_commence);
		$joining_year = date('Y',$joining_timestamp);
        $current_year = date('Y',strtotime($currentDate));
        if($current_year==$joining_year){
            $month_join = date('m',$joining_timestamp);
            if($month_join<12){
                $entitle_value = ((12-$month_join)/12)*$entitle;
            }else{
                $entitle_value = $entitle;
            }
        }else{
            $entitle_value = $entitle;
        }
        return $entitle_value;
    }
    if($experience == 0 && $experience_check && $SettingLeaveAdjustmentType->value!=3)
	{
        $expValues = UserPay::where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience, 12 - month(date_commence) as months")->first();
        $exp = $expValues->experience;
        $months = $expValues->months;
        if($SettingLeaveAdjustmentType->value==0){
            $months = $months + 1;
        }
        if($exp=="0"){
            $entitle = intval($entitle) * $months / 12;
        }
        
    }
    if($SettingLeaveAdjustmentType->value==4)
	{
        $commence_year = UserPay::where('username',$username)->selectRaw("date_commence")->first();
        $year_value = date('Y',strtotime($commence_year->date_commence));
                    
        $year_first_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffStartMonth."-".$cutOffStartDate);
        $year_end_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate);
        $today_date = strtotime(date('Y-m-d',strtotime($currentDate)));
                    
        $year_total_days = floor(($year_end_date-$year_first_date)/(60*60*24))+1;
                    
        $entitle_1_first_days =  floor(($today_date-$year_first_date)/(60*60*24))+1;
        $entitle_1 = ($entitle_1_first_days/$year_total_days)* $actual_entitle;
                    
        $entitle_2_first_days =  floor(($year_end_date-$today_date)/(60*60*24))+1;
        $entitle_2 = ($entitle_2_first_days/$year_total_days)* $actual_entitle;
                    
                    $entitle = $entitle_1 + $entitle_2;
    }
    if($SettingLeaveAdjustmentType->value == 2 && $experience == 0 ){
        $new_e = 0;
        $year_value = date('Y',strtotime($commence_year));
		if($year_value==date('Y',strtotime($currentDate))){
			$first_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffStartMonth."-".$cutOffStartDate);
			$second_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffMonth."-".$cutOffDate);
			$datediff = $second_date - $first_date;
			$year_total_days = floor($datediff/(60*60*24))+1;
				
			$today_date_val = strtotime(date('Y-m-d',strtotime($commence_year)));
			$reamining_days_datediff = $second_date - $today_date_val;
			$reamining_days = floor($reamining_days_datediff/(60*60*24));
			$new_e = ($reamining_days/$year_total_days)*$entitle;
				
		}
		if($year_value<date('Y',strtotime($currentDate)) && $actual_experience>0){
			$new_e = $entitle;
		}
		$entitle = $new_e;

    }
    if($resign_year!='-1' && $resign_year==  date('Y',strtotime($currentDate))){
        $days_before_resign = FromYearStartDays($date_resigned);
        
        return $entitle * ($days_before_resign/365);
    }
    return $entitle; 

}

function getYearWiseFixLeaveEntitle11($connection,$username, $type="Annual", $currentDate){
    $cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $date_commence= $connection->table('user_pay')->where('username',$username)->first();
    $commence_year=$date_commence->date_commence;
    $date_resigned=$date_commence->date_resigned;
    $resign_year = date('Y',strtotime($date_resigned));
    $experience_check = 0;
    $SettingLeaveAdjustmentType= $connection->table('settings')->where('field', "leave_adjustment_type")->first();
    $medicalLeaveProRated = $connection->table('settings')->where('field', "medical_leave_prorated")->first();
    $actual_experience = 0;
    $_check_year = date('Y',strtotime($currentDate));
    $cutOffStartYear = $_check_year;
    $cutOffYear = $_check_year;
        if($cutOffStartMonth!=1){
            if($cutOffStartMonth > date('m')){
                $cutOffStartYear = $_check_year;
                $cutOffYear = $_check_year;
            }else{
                $cutOffStartYear = $_check_year-1;
                $cutOffYear = $_check_year;
            }
        }else{
            $cutOffStartYear = $_check_year;
            $cutOffYear = $_check_year;
        }
        if($SettingLeaveAdjustmentType->value == 6){
            $date_for_query = "CURDATE()";
            
            $year_for_check = date('Y');
            $year_for_check = date("Y",  strtotime($currentDate));
            //$_d = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
            $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
            $date_for_query = "'".$_d."'";
            
            $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".date("Y")."-".$cutOffMonth."-".$cutOffDate."') as 'days' ")->first();
            $actual_experience = intval($resultArrayVal->experience);
            $date_commence = $resultArrayVal->date_commence;
            $ExperienceInYear = $actual_experience + 1;
            
            if(date("Y",  strtotime($date_commence))==  $year_for_check){
            
                $resultArrayVal1 = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence,TIMESTAMPDIFF(DAY, date_commence,'".$year_for_check."-".$cutOffMonth."-".$cutOffDate."') as 'days'")->first();

                $actual_experience = intval($resultArrayVal1->experience);
                $date_commence = $resultArrayVal1->date_commence;
                $ExperienceInYear = $actual_experience + 1;
                $days_difference =  $resultArrayVal1->days;
                $entitle_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                }
                $currentYearTotalDays = date("z", mktime(0,0,0,12,31,$year_for_check)) + 1;
                $entitle = ($days_difference/$currentYearTotalDays) * $entitle_year_base;
                $value = round($entitle * 2) / 2;
                return $value;
                exit;
                
            }

            $entitle_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                } 
            return $entitle_year_base;
            exit;
        }
        elseif($SettingLeaveAdjustmentType->value == 7){
            
            if($type=="Medical"){
                $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
                $ExperienceInYear = intval($resultArrayVal->experience) + 1;
                $date_commence = $resultArrayVal->date_commence;
                $entitle_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                } 
                if($resign_year!='-1' && $resign_year== $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
            			$year_total_days = floor($datediff/(60*60*24))+1;
                        return $entitle_year_base * ($year_total_days/365);
                        exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
            			return $entitle_year_base * ($days_before_resign/365);
            			exit;

                    }

                }
                return $entitle_year_base;
            		exit;
            }
            $date_commence = $date_commence->date_commence;
            $date_for_query = "CURDATE()";
            $date_for_query1 = "CURDATE()";
            $year_first_date = "";
            $year_last_date = "";
            $_d = $cutOffStartYear."-".$cutOffStartMonth."-".$cutOffStartDate;
            $_d1 = $cutOffYear."-".$cutOffMonth."-".$cutOffDate;
            $date_for_query = "'".$_d."'";
            $date_for_query1 = "'".$_d1."'";
            $year_first_date= $_d;
            $year_last_date = $_d1;
            $resultArrayVal= $connection->table('user_pay')->where('username',$username)->selectRaw(" TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience1, TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query1.") as experience2,date_commence")->first();
            $first_experience = $resultArrayVal->experience1+1;
            $second_experience = $resultArrayVal->experience2+1;
           
            $entitle_before11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$first_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_before = $entitle_before11->no_leaves;
            if($entitle_before==""){
                $entitle_before = 0;
            } 
            $entitle_after11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$second_experience)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_after = $entitle_after11->no_leaves;
            if($entitle_after==""){
                $entitle_after = 0;
            } 

            $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  $cutOffStartYear;
            $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  $cutOffYear;
            if(date('m',strtotime($date_commence)) >= $cutOffStartMonth){
                $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".$cutOffStartYear;
            }else{
                $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',strtotime($currentDate));
            }

            $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year);
            $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year)+1;
            $entitle_before_new = ($ExperienceInDaysBefore/365)*$entitle_before;
            $entitle_after_new = ($ExperienceInDaysAfter/365)*$entitle_after;
            
            if(strtotime($join_date_in_current_year) == strtotime($date_commence)){
                
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                       
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
						$year_work_days = floor($datediff/(60*60*24))+1;
						$year_start_date_s = date("Y")."-01-01";
						$year_end_date_s = date("Y")."-12-31";
							
						$year_total_days = floor((strtotime($year_end_date_s) - strtotime($year_start_date_s))/(60*60*24)) + 1;
						 //  dd($entitle_before,$year_work_days,$year_total_days);
                        return $entitle_before* ($year_work_days/$year_total_days);
            			exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                        return $entitle_before* ($days_before_resign/365);
            			exit;
                    }
                }
                return $entitle_after_new;
            }
            
          
            $entitle = $entitle_before_new+ $entitle_after_new;
            $value = round($entitle * 2) / 2;
             
            if($resign_year!='-1' && $resign_year==  $_check_year){
                $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                 $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $date_resigned);
                $entitle_after_new = ($ExperienceInDaysAfter/365)*$entitle_after;
                $entitle = $entitle_before_new+ $entitle_after_new;
                //dd($entitle);
                return $entitle;
                //return $value * ($days_before_resign/365);
                exit;
            }
            
            //dd($value);
            return $value;
            exit;
        }
        elseif($SettingLeaveAdjustmentType->value == 5){
            if($type=="Medical"){
                $date_for_query = "CURDATE()";
                $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
                $ExperienceInYear = intval($resultArrayVal->experience) + 1;
                $date_commence = $resultArrayVal->date_commence;
                $entitle_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
                $entitle_year_base =  $entitle_year_base11->no_leaves;
                if($entitle_year_base==""){
                    $entitle_year_base = 0;
                }
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    $days_before_resign = FromYearStartDays($date_resigned, $_check_year);
                    return $entitle_year_base * ($days_before_resign/365);
                    exit;
                }
                return $entitle_year_base;
                exit;
            }
            $date_for_query = "CURDATE()";
            $date_for_calculation = date("Y",  strtotime($currentDate))."-".date("m")."-".date("d");
            $_d = date("Y",  strtotime($currentDate))."-".$cutOffStartDate."-".$cutOffStartMonth;
            $date_for_query = "'".$_d."'";
            $date_for_calculation = $_d;
            $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
            $ExperienceInYear_forfirst = intval($resultArrayVal->experience);
            $date_commence = $resultArrayVal->date_commence;
            if($ExperienceInYear_forfirst==0){
                $ExperienceInYear_forfirst = 1;
            }
            $experience_at_current_year_end = $connection->table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,'".(date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate)."') as experience")->first();
            if($experience_at_current_year_end->experience==0){
                $experience_at_current_year_end = 1;
            }
            else{
                
                    $experience_at_current_year_end = $experience_at_current_year_end->experience;
                
            }
           
            $entitle_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$ExperienceInYear_forfirst)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_year_base =  $entitle_year_base11->no_leaves;
            if($entitle_year_base==""){
                $entitle_year_base = 0;
            }

            $entitle_current_year_base11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',$experience_at_current_year_end)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $entitle_current_year_base =  $entitle_current_year_base11->no_leaves;
            $start_date_of_year = $cutOffStartDate."-".$cutOffStartMonth."-".  date("Y",strtotime($date_for_calculation));
            $end_date_of_year = $cutOffDate."-".$cutOffMonth."-".  date("Y",strtotime($date_for_calculation));
            $join_date_in_current_year = (date('d',strtotime($date_commence)))."-".date('m',strtotime($date_commence))."-".date('Y',  strtotime($date_for_calculation));
            $ExperienceInDaysBefore = getDaysDifference($start_date_of_year, $join_date_in_current_year);
            $ExperienceInDaysAfter = getDaysDifference($join_date_in_current_year, $end_date_of_year)+1;
            $currentYearTotalDays = date("z", mktime(0,0,0,12,31,date('Y',strtotime($date_for_calculation)))) + 1;
            $entitleBefore = ($ExperienceInDaysBefore/$currentYearTotalDays) * $entitle_year_base;
            $entitleAfter = ($ExperienceInDaysAfter/$currentYearTotalDays) * $entitle_current_year_base;
             //dd($ExperienceInDaysBefore,$ExperienceInDaysAfter,$entitle_year_base,$entitle_current_year_base);
            if (strtotime($join_date_in_current_year) == strtotime($date_commence)){
                if($resign_year!='-1' && $resign_year==  $_check_year){
                    if(date('Y',strtotime($commence_year))==date("Y") && $resign_year==date("Y")){
                        $first_date = strtotime($commence_year);
            			$second_date = strtotime($date_resigned);
            			$datediff = $second_date - $first_date;
            			$year_total_days = floor($datediff/(60*60*24))+1;
                        return $entitle_year_base * ($year_total_days/365);
                        exit;
                    }
                    else{
                        $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
            			return $entitle_year_base * ($days_before_resign/365);
            			exit;

                    }
                    // $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                    // dd($entitle_year_base,$days_before_resign,$date_resigned,$_check_year);
                    // return $entitle_year_base * ($days_before_resign/365);
                    // exit;
                }
                return $entitleAfter;
            }
            
            $entitle = $entitleBefore + $entitleAfter;
                 
            $value = round($entitle * 2) / 2;
            if($resign_year!='-1' && $resign_year==  $_check_year){
                $days_before_resign = FromYearStartDays($date_resigned,$_check_year);
                return $value * ($days_before_resign/365);
                exit;
            }
            return $value;
                
                
        }
        elseif($SettingLeaveAdjustmentType->value == 0){
            $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("(year('".$currentDate."') * 365.24 + month('".$currentDate."') * 30.5 + day('".$currentDate."'))/365.24 - (year(date_commence) * 365.24 + month(date_commence) * 30.5 + day(date_commence)) / 365.24 as experience")->first();
            $experience = intval($resultArrayVal->experience);
            $actual_experience = $experience;
            $experience_check = 1;

        }
        elseif($SettingLeaveAdjustmentType->value == 2){
            $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence)as experience,month(date_commence) as join_month")->first();
            $actual_experience = $resultArrayVal->experience; 
            if($resultArrayVal->join_month<=6 && $resultArrayVal->experience>=1){ 
                $experience = $resultArrayVal->experience;
                $experience_check = 0;
            }elseif($resultArrayVal->join_month>6 && $resultArrayVal->experience>=1){ 
                    $experience = $resultArrayVal->experience-1;
                    $experience_check = 0;
            }else{
                    $experience = 0;
                    $experience_check = 0;
            }

        }
        else{
            $resultArrayVal = $connection->table('user_pay')->where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience")->first();
            $experience = ((intval($resultArrayVal->experience) > 0)? intval($resultArrayVal->experience): 0);
            $experience_check = 1;
            $actual_experience = $experience;

        }
        if($SettingLeaveAdjustmentType->value != 2){
            $experience = intval($resultArrayVal->experience);
            $actual_experience = $experience;
        }
    $entitle11 = $connection->table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',$type)->where('a.experience','<=',($experience + 1))->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();  
    $entitle =  $entitle11->no_leaves;
    $actual_entitle = $entitle;
    if($type=='Medical' && !$medicalLeaveProRated->value){
        if($resign_year!='-1' && $resign_year==  date('Y')){
            $days_before_resign = FromYearStartDays($date_resigned);
            return $entitle * ($days_before_resign/365);
            exit;
        }
        return $entitle;
        exit;
    }
    if($SettingLeaveAdjustmentType->value==3 && strtolower($type)=='annual'){
        $entitle_value = 0;
        $date_commence = $connection->table('user_pay')->where('username',$username)->selectRaw("date_commence")->first();
        $joining_timestamp = strtotime($date_commence->date_commence);
		$joining_year = date('Y',$joining_timestamp);
        $current_year = date('Y',strtotime($currentDate));
        if($current_year==$joining_year){
            $month_join = date('m',$joining_timestamp);
            if($month_join<12){
                $entitle_value = ((12-$month_join)/12)*$entitle;
            }else{
                $entitle_value = $entitle;
            }
        }else{
            $entitle_value = $entitle;
        }
        return $entitle_value;
    }
    if($experience == 0 && $experience_check && $SettingLeaveAdjustmentType->value!=3)
	{
        $expValues = $connection->table('user_pay')->where('username',$username)->selectRaw("year('".$currentDate."') - year(date_commence) as experience, 12 - month(date_commence) as months")->first();
        $exp = $expValues->experience;
        $months = $expValues->months;
        if($SettingLeaveAdjustmentType->value==0){
            $months = $months + 1;
        }
        if($exp=="0"){
            $entitle = intval($entitle) * $months / 12;
        }
        
    }
    if($SettingLeaveAdjustmentType->value==4)
	{
        $commence_year = $connection->table('user_pay')->where('username',$username)->selectRaw("date_commence")->first();
        $year_value = date('Y',strtotime($commence_year->date_commence));
                    
        $year_first_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffStartMonth."-".$cutOffStartDate);
        $year_end_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate);
        $today_date = strtotime(date('Y-m-d',strtotime($currentDate)));
                    
        $year_total_days = floor(($year_end_date-$year_first_date)/(60*60*24))+1;
                    
        $entitle_1_first_days =  floor(($today_date-$year_first_date)/(60*60*24))+1;
        $entitle_1 = ($entitle_1_first_days/$year_total_days)* $actual_entitle;
                    
        $entitle_2_first_days =  floor(($year_end_date-$today_date)/(60*60*24))+1;
        $entitle_2 = ($entitle_2_first_days/$year_total_days)* $actual_entitle;
                    
                    $entitle = $entitle_1 + $entitle_2;
    }
    if($SettingLeaveAdjustmentType->value == 2 && $experience == 0 ){
        $new_e = 0;
        $year_value = date('Y',strtotime($commence_year));
		if($year_value==date('Y',strtotime($currentDate))){
			$first_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffStartMonth."-".$cutOffStartDate);
			$second_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffMonth."-".$cutOffDate);
			$datediff = $second_date - $first_date;
			$year_total_days = floor($datediff/(60*60*24))+1;
				
			$today_date_val = strtotime(date('Y-m-d',strtotime($commence_year)));
			$reamining_days_datediff = $second_date - $today_date_val;
			$reamining_days = floor($reamining_days_datediff/(60*60*24));
			$new_e = ($reamining_days/$year_total_days)*$entitle;
				
		}
		if($year_value<date('Y',strtotime($currentDate)) && $actual_experience>0){
			$new_e = $entitle;
		}
		$entitle = $new_e;

    }
    if($resign_year!='-1' && $resign_year==  date('Y',strtotime($currentDate))){
        $days_before_resign = FromYearStartDays($date_resigned);
        
        return $entitle * ($days_before_resign/365);
    }
    return $entitle; 

}

//////////////


function FromYearStartDays($resignDate, $currentY_y = ""){
    if($currentY_y!=""){
        $currentY = $currentY_y;
    }else{
        $currentY = date('Y');
    }
    
    $yearStart = mktime(0, 0, 0, 1, 1,  $currentY );
    
    $your_date = strtotime($resignDate);
    $datediff = $your_date - $yearStart;
    return floor($datediff/(60*60*24));
}
function getDaysDifference($first,$second){
            
    $first_date = strtotime($first);
    $second_date = strtotime($second);
    
    $check_datediff = $second_date - $first_date;
    return floor($check_datediff/(60*60*24));
}
function get_curr_joining_date($username,$year){
    $date_commence= UserPay::where('username',$username)->first();
    $joiningDate = $date_commence->date_commence;
    $joiningDateArr=explode('-',$joiningDate);
    $joining_month=$joiningDateArr[1];
    $joining_date=$joiningDateArr[2];
            
    $joining_curr_Date = $year.'-'.$joining_month.'-'.$joining_date;
    return $joining_curr_Date;
}
function getEmergencyLeaveCountByUser($username,$year)
	{
		$yearArr = explode('-',$year);
		if(count($yearArr)>0){
			$year= $yearArr[0];
		}
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $date_commence= UserPay::where('username',$username)->first();
		
		$joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];


		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		
		if($cutOffStartMonth!=1){
			$startYear = $year-1;
		}else{
			$startYear = $year;
		}

		$prev_date = $year.'-'.$joining_month.'-'.$joining_date;
		$curr_date = ($year+1).'-'.$joining_month.'-'.$joining_date;
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		$hours = gethours();
		
		if($SettingLeaveAdjustmentType==8){
			$days_query = DB::table('leave_days')->where('username', $username)->whereBetween('date',[$prev_date,$curr_date])->selectRaw("leave_id,status ")->get();
		}else{
			
            $days_query = DB::table('leave_days')->where('username', $username)->whereYear('date',$year)->selectRaw("leave_id,status ")->get();
		}
		
		
        $days_result = $days_query;
		for($i=0;$i<count($days_result);$i++){
            $update_query = Leavelist::where('id', $days_result[$i]->leave_id)->first();
            if(!empty($update_query)){
                $update_query->status = $days_result[$i]->status;
                $update_query->save();
            }
			
		}
		
		if($SettingLeaveAdjustmentType==8){
			
            $query1 = DB::table("leave_past")->whereBetween('start_date',[$prev_date,$curr_date])->where('username',$username)->where('type','Emergency')->selectRaw("sum(total_leave_days) as no_days")->first();
		}else{
			
            $query1 = DB::table("leave_past")->whereYear('start_date',$year)->where('username',$username)->where('type','Emergency')->selectRaw("sum(total_leave_days) as no_days")->first();
		}
		$past_val = $query1->no_days;
		
		if($SettingLeaveAdjustmentType==8){
			$query = DB::table("leave_list")->whereBetween('start_date',[$prev_date,$curr_date])->where('username',$username)->where('type','Emergency')->where('type','!=','NPL')->where('status',1)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
		}else{
			$startDate_1 = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
            $endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            $query = DB::table("leave_list")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Emergency')->where('type','!=','NPL')->where('status',1)->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
			
		}
		$all_val = $past_val + $query->no_days;
		return floatval($all_val);
	}
function getReplacementLeaveCount($username, $year)
	{
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
        $year=date('Y',strtotime($year));
        $hours = gethours();
		if($cutOffStartMonth==1){
			$startDate = $year.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}else{
			$startDate = ($year-1).'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}
		$endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

        $rleave1 = DB::table("leave_list")->where('start_date','>=',$startDate)->where('end_date','<=',$endDate)->where('username',$username)->where('status',1)->where('type','Other_pay')->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
		$rlLeave = floatval($rleave1->no_days);
		
		
        $pastLeave1 = DB::table("leave_past")->where('start_date','>=',$startDate)->where('end_date','<=',$endDate)->where('username',$username)->where('type','Other_pay')->selectRaw("sum(total_leave_days) as no_days")->first();
		$pastLeave = floatval($rleave1->no_days);
		$totalRL = $pastLeave + $rlLeave;
		
		return $totalRL;
    }

function getReplacementLeaveCount11($connection,$username, $year)
	{
		$cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $hours = gethours();
        $cutOffStartMonth=$cutOffStartMonth11->value;
        $year=date('Y',strtotime($year));
		if($cutOffStartMonth==1){
			$startDate = $year.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}else{
			$startDate = ($year-1).'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}
		$endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

        $rleave1 = $connection->table("leave_list")->where('start_date','>=',$startDate)->where('end_date','<=',$endDate)->where('username',$username)->where('status',1)->where('type','Other_pay')->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
		$rlLeave = floatval($rleave1->no_days);
		
		
        $pastLeave1 = $connection->table("leave_past")->where('start_date','>=',$startDate)->where('end_date','<=',$endDate)->where('username',$username)->where('type','Other_pay')->selectRaw("sum(total_leave_days) as no_days")->first();
		$pastLeave = floatval($rleave1->no_days);
		$totalRL = $pastLeave + $rlLeave;
		
		return $totalRL;
    }
    
function getTakenLeaveCount($username, $year, $type)
	{
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $date_commence= UserPay::where('username',$username)->first();
        $joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$hours = gethours();
		
// 		if($cutOffStartMonth!=1){
// 			if($year==date("Y") && $cutOffStartMonth <= date('m') && 0){
// 				$cutOffStartYear = $year+1;
// 				$cutOffYear = $year;
// 			}else if($cutOffStartMonth > date('m')){
// 				$cutOffStartYear = $year;
// 				$cutOffYear = $year-1;
// 			}else{
// 				$cutOffStartYear = $year-1;
// 				$cutOffYear = $year;
// 			}
// 		}else{
// 			$cutOffStartYear = $year;
// 			$cutOffYear = $year;
// 		}
// 		$prev_date = date('Y',strtotime($year)).'-'.$joining_month.'-'.$joining_date;
// 		//dd($prev_date,$year,$joining_month,$joining_date);
// 		$curr_date = (date('Y',strtotime($year))+1).'-'.$joining_month.'-'.$joining_date;
// 		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
// 		$value11 = DB::table("leave_days as a")->leftjoin('leave_list as b','a.leave_id','=','b.id');
// 		if($SettingLeaveAdjustmentType==8){
// 			$select = "sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken ";
// 			if($type!="Emergency"){
//                 $value11->where('b.leave_category','!=','Emergency');
//             }
            
// 			$startDate_1 = $cutOffStartYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
//             $endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            
			

// 		}else{
// 			$select = "sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as leave_taken ";
// 			if($type!="Emergency"){
// 				$value11->where('b.leave_category','!=','Emergency');
//             }
// 			$startDate_1 = $cutOffStartYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
// 			$endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
			
// 		}
// 		$val12=$value11->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('a.username',$username)->where('a.status',1)->where('b.type',$type)->selectRaw("$select")->first();
	
// 		$value = $val12->leave_taken ?? '';
// 		if($value==''){
// 			$value = 0;
// 		}
		
// 		return $value;

$date_commence= getUserDetails($username);
        $joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		if($cutOffStartMonth!=1){
		    $syear = $year-1;
			if($year==date("Y") && $cutOffStartMonth <= date('m') && 0){
				$cutOffStartYear = $year+1;
				$cutOffYear = $year;
			}else if($cutOffStartMonth > date('m')){
				$cutOffStartYear = $year;
				$cutOffYear = $year-1;
			}else{
				$cutOffStartYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
		    $syear = $year;
			$cutOffStartYear = $year;
			$cutOffYear = $year;
		}
		$prev_date = date('Y',strtotime($year)).'-'.$joining_month.'-'.$joining_date;
		//dd($prev_date,$year,$joining_month,$joining_date);
		$curr_date = (date('Y',strtotime($year))+1).'-'.$joining_month.'-'.$joining_date;
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		if($SettingLeaveAdjustmentType==8){
		
			$startDate_1 = $syear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
            $endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            
            $query = "select sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN CASE b.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as leave_taken from leave_days a left join leave_list b on a.leave_id=b.id where a.status = 1 and b.type='".$type."' and a.username='".$username."' and start_date>='".$startDate_1."' and end_date<='".$endDate_1."'";
            if($type!="Emergency"){
				$query .= "and b.leave_category!='Emergency'";
            }
            $val12=DB::select($query);
			

		}else{
			
			$startDate_1 = $syear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
			$endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
		
			$query = "select sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN CASE b.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as leave_taken from leave_days a left join leave_list b on a.leave_id=b.id where a.status = 1 and b.type='".$type."' and a.username='".$username."' and start_date>='".$startDate_1."' and end_date<='".$endDate_1."'";
            if($type!="Emergency"){
				$query .= "and b.leave_category!='Emergency'";
            }
            $val12=DB::select($query);
			
		}
		$value = $val12[0]->leave_taken ?? '';
		if($value==''){
			$value = 0;
		}
			return $value;
    }
    
     function getUserDetails($username) {
        $result = DB::table('user_pay')->where('username',$username)->first();
        return $result;
    }

function getTakenLeaveCount11($connection,$username, $year, $type)
	{
		$cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = $connection->table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $date_commence= $connection->table('user_pay')->where('username',$username)->first();
        $joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$hours = gethours();
		
		if($cutOffStartMonth!=1){
			if($year==date("Y") && $cutOffStartMonth <= date('m') && 0){
				$cutOffStartYear = $year+1;
				$cutOffYear = $year;
			}else if($cutOffStartMonth > date('m')){
				$cutOffStartYear = $year;
				$cutOffYear = $year-1;
			}else{
				$cutOffStartYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$cutOffStartYear = $year;
			$cutOffYear = $year;
		}
		$prev_date = date('Y',strtotime($year)).'-'.$joining_month.'-'.$joining_date;
		//dd($prev_date,$year,$joining_month,$joining_date);
		$curr_date = (date('Y',strtotime($year))+1).'-'.$joining_month.'-'.$joining_date;
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		$value11 = $connection->table("leave_days as a")->leftjoin('leave_list as b','a.leave_id','=','b.id');
		if($SettingLeaveAdjustmentType==8){
			$select = "sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken ";
			if($type!="Emergency"){
                $value11->where('b.leave_category','!=','Emergency');
            }
            
			$startDate_1 = $cutOffStartYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
            $endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            
			

		}else{
			$select = "sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as leave_taken ";
			if($type!="Emergency"){
				$value11->where('b.leave_category','!=','Emergency');
            }
			$startDate_1 = $cutOffStartYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
			$endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
			
		}
		$val12=$value11->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('a.username',$username)->where('a.status',1)->where('b.type',$type)->selectRaw("$select")->first();
	
		$value = $val12->leave_taken ?? '';
		if($value==''){
			$value = 0;
		}
		
		return $value;
    }
    
function getTakenPastLeaves($username, $year)
	{
	  //  $year=date('Y',strtotime($year));
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $prev_date = get_curr_joining_date($username,$year);
        $date_commence= UserPay::where('username',$username)->first();
		$joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = ($year+1).'-'.$joining_month.'-'.$joining_date;
		
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));

        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;

		if($cutOffStartMonth!=1){
			if($year==date("Y") && $cutOffStartMonth <= date('m') && 0){
				$startYear = $year+1;
				$cutOffYear = $year;
			}else if($cutOffStartMonth > date('m')){
				$startYear = $year;
				$cutOffYear = $year-1;
			}else{
				$startYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$startYear = $year;
			$cutOffYear = $year;
		}

		
		$startDate_1 = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		$endDate_1 = $cutOffYear.'-'.$cutOffMonth.'-'.$cutOffDate;
		
		if($SettingLeaveAdjustmentType==8){
			$query = DB::table("leave_past")->whereBetween('start_date', [$prev_date, $curr_date])->where('username',$username)->where('type','Annual')->selectRaw("sum(total_leave_days) as no_days")->first();
		}else{
			
            $query = DB::table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Annual')->selectRaw("sum(total_leave_days) as no_days")->first();
		}
		$annualLeaves = floatval($query->no_days);
		
        $query = DB::table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Medical')->selectRaw("sum(total_leave_days) as no_days")->first();
		$medicalLeaves = floatval($query->no_days);
		
		
        $query = DB::table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Other_pay')->selectRaw("sum(total_leave_days) as no_days")->first();
		$replacementLeaves = floatval($query->no_days);
		
		
        $query = DB::table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->selectRaw("sum(total_leave_days) as no_days")->first();
		$totalLeaves = floatval($query->no_days);
		
		$takenLeaves = array("annual" => $annualLeaves, "medical" =>$medicalLeaves, "replacement"=>$replacementLeaves, "other_pay"=>$replacementLeaves,"total" => $totalLeaves);
		return $takenLeaves;
    }

function getTakenPastLeaves11($connection,$username, $year)
	{
	  //  $year=date('Y',strtotime($year));
		$SettingLeaveAdjustmentType11 = $connection->table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $prev_date = get_curr_joining_date($username,$year);
        $date_commence= $connection->table('user_pay')->where('username',$username)->first();
		$joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = ($year+1).'-'.$joining_month.'-'.$joining_date;
		
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));

        $cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;

		if($cutOffStartMonth!=1){
			if($year==date("Y") && $cutOffStartMonth <= date('m') && 0){
				$startYear = $year+1;
				$cutOffYear = $year;
			}else if($cutOffStartMonth > date('m')){
				$startYear = $year;
				$cutOffYear = $year-1;
			}else{
				$startYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$startYear = $year;
			$cutOffYear = $year;
		}

		
		$startDate_1 = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		$endDate_1 = $cutOffYear.'-'.$cutOffMonth.'-'.$cutOffDate;
		
		if($SettingLeaveAdjustmentType==8){
			$query = $connection->table("leave_past")->whereBetween('start_date', [$prev_date, $curr_date])->where('username',$username)->where('type','Annual')->selectRaw("sum(total_leave_days) as no_days")->first();
		}else{
			
            $query = $connection->table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Annual')->selectRaw("sum(total_leave_days) as no_days")->first();
		}
		$annualLeaves = floatval($query->no_days);
		
        $query = $connection->table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Medical')->selectRaw("sum(total_leave_days) as no_days")->first();
		$medicalLeaves = floatval($query->no_days);
		
		
        $query = $connection->table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->where('type','Other_pay')->selectRaw("sum(total_leave_days) as no_days")->first();
		$replacementLeaves = floatval($query->no_days);
		
		
        $query = $connection->table("leave_past")->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->where('username',$username)->selectRaw("sum(total_leave_days) as no_days")->first();
		$totalLeaves = floatval($query->no_days);
		
		$takenLeaves = array("annual" => $annualLeaves, "medical" =>$medicalLeaves, "replacement"=>$replacementLeaves, "other_pay"=>$replacementLeaves,"total" => $totalLeaves);
		return $takenLeaves;
    }
function getCountOfBFLeaveTaken($username="",$year="YEAR(CURDATE())",$start_month="01",$start_date="01")
{
        // $BFAdj11 = DB::table('settings')->where('field', "bf_duration")->first();
        // $BFAdj = $BFAdj11->value;
        $hours = gethours();
        $BFAdj=0;
        if($username!=''){
            $users11=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $BFAdj11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
            $BFAdj = $BFAdj11->value ?? 0;
        }
        
        $query = DB::table("leave_list")->where('username',$username)->where('status',1)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();

        $BFLeaveTaken =  $query->no_days;
                
        
        $query1 = DB::table("leave_past")->where('username',$username)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(total_leave_days) as no_days")->first();
        $past_val = $query1->no_days;
        $total = $BFLeaveTaken + $past_val;
        
        return $total;
}

function getCountOfBFLeaveTaken11($connection,$username="",$year="YEAR(CURDATE())",$start_month="01",$start_date="01")
{
        // $BFAdj11 = DB::table('settings')->where('field', "bf_duration")->first();
        // $BFAdj = $BFAdj11->value;
        $hours = gethours();
        $BFAdj=0;
        if($username!=''){
            $users11=$connection->table('users')->where('username',$username)->first();
            $usercat =$connection->table('user_category')->where('username',$username)->first();
            $BFAdj11 = $connection->table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
            $BFAdj = $BFAdj11->value ?? 0;
        }
        
        $query = $connection->table("leave_list")->where('username',$username)->where('status',1)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();

        $BFLeaveTaken =  $query->no_days;
                
        
        $query1 = $connection->table("leave_past")->where('username',$username)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(total_leave_days) as no_days")->first();
        $past_val = $query1->no_days;
        $total = $BFLeaveTaken + $past_val;
        
        return $total;
}

function getCountOfBFAdjLeaveTaken($username="",$year="YEAR(CURDATE())",$bfCount = 0,$bfAdjCount=0)
{
    $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $hours = gethours();

    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }
    $year_startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    $year_endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

    $BFLeaveTaken = getCountOfBFLeaveTaken($username,$year);
    
    
    if($BFLeaveTaken>$bfCount){
        $BFLeaveTaken = $bfCount;
    }
    // $BFAdj11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
    
    
    // $BFAdj = $BFAdj11->value;
    $BFAdj=0;
    if($username!=''){
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $BFAdj11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $BFAdj = $BFAdj11->value ?? 0;
    }
    
    $query = DB::table("leave_list")->where('username',$username)->where('status',1)->whereRaw(" (start_date between '".$year_startDate."' AND DATE_ADD('".$year_startDate."',INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();

    
    $BFAdjLeaveTaken =  $query->no_days;
            
            
    $query1 = DB::table("leave_past")->where('username',$username)->whereRaw(" (type='Emergency' OR type='Annual') and (start_date between '".$year_startDate."' AND DATE_ADD('".$year_startDate."',INTERVAL ".$BFAdj." DAY))")->selectRaw("sum(total_leave_days) as no_days")->first();
    $past_val = $query1->no_days;
    $total = $BFAdjLeaveTaken + $past_val  - $BFLeaveTaken;
    
    if($total<0){
        $total = 0;
    }
    
    if($total>$bfAdjCount){
        $total = $bfAdjCount;
    }
    return $total;
}

function getCountOfBFAdjLeaveTaken11($connection,$username="",$year="YEAR(CURDATE())",$bfCount = 0,$bfAdjCount=0)
{
    $cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
    $cutOffMonth = $cutOffMonth11->value;
    $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
    $cutOffDate=$cutOffDate11->value;
    $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartDate=$cutOffStartDate11->value;
    $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
    $cutOffStartMonth=$cutOffStartMonth11->value;
    $hours = gethours();
    
    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }
    $year_startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    $year_endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

    $BFLeaveTaken = getCountOfBFLeaveTaken11($connection,$username,$year);
    
    
    if($BFLeaveTaken>$bfCount){
        $BFLeaveTaken = $bfCount;
    }
    // $BFAdj11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
    
    
    // $BFAdj = $BFAdj11->value;
    $BFAdj=0;
    if($username!=''){
        $users11=$connection->table('users')->where('username',$username)->first();
        $usercat =$connection->table('user_category')->where('username',$username)->first();
        $BFAdj11 = $connection->table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $BFAdj = $BFAdj11->value ?? 0;
    }
    
    $query = $connection->table("leave_list")->where('username',$username)->where('status',1)->whereRaw(" (start_date between '".$year_startDate."' AND DATE_ADD('".$year_startDate."',INTERVAL ".$BFAdj." DAY)) AND (type='Emergency' OR type='Annual')")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();

    
    $BFAdjLeaveTaken =  $query->no_days;
            
            
    $query1 = $connection->table("leave_past")->where('username',$username)->whereRaw(" (type='Emergency' OR type='Annual') and (start_date between '".$year_startDate."' AND DATE_ADD('".$year_startDate."',INTERVAL ".$BFAdj." DAY))")->selectRaw("sum(total_leave_days) as no_days")->first();
    $past_val = $query1->no_days;
    $total = $BFAdjLeaveTaken + $past_val  - $BFLeaveTaken;
    
    if($total<0){
        $total = 0;
    }
    
    if($total>$bfAdjCount){
        $total = $bfAdjCount;
    }
    return $total;
}


function getCountOfAdjLeaveTaken($username="",$year="YEAR(CURDATE())",$start_month="01",$start_date="01"){
    
    $rlDays=0;
    $hours = gethours();
    if($username!=''){
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $rlDays1 = DB::table('replacement_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $rlDays = $rlDays1->value ?? 0;
        if($rlDays == '' || $rlDays == NULL){
            $rlDays =0;
        }
    }
    
    $query = DB::table("leave_list")->where('username',$username)->where('type','Other_pay')->where('status',1)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$rlDays." DAY))")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
    $RLTaken = $query->no_days;
    
    
    $query1 = DB::table("leave_past")->where('username',$username)->where('type','Other_pay')->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$rlDays." DAY))")->selectRaw("sum(total_leave_days) as no_days")->first();
    $past_val = $query1->no_days;
        
    $total = $RLTaken + $past_val;
    
    return $total;
}

function getCountOfAdjLeaveTaken11($connection,$username="",$year="YEAR(CURDATE())",$start_month="01",$start_date="01"){
    
    $rlDays=0;
    $hours = gethours();
    if($username!=''){
        $users11=$connection->table('users')->where('username',$username)->first();
        $usercat =$connection->table('user_category')->where('username',$username)->first();
        $rlDays1 = $connection->table('replacement_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $rlDays = $rlDays1->value ?? 0;
    }
    
    $query = $connection->table("leave_list")->where('username',$username)->where('type','Other_pay')->where('status',1)->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$rlDays." DAY))")->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days")->first();
    $RLTaken = $query->no_days;
    
    
    $query1 = $connection->table("leave_past")->where('username',$username)->where('type','Other_pay')->whereRaw(" (start_date between CONCAT('".$year."','-".$start_month."-".$start_date."')AND DATE_ADD(CONCAT('".$year."','-".$start_month."-".$start_date."'),INTERVAL ".$rlDays." DAY))")->selectRaw("sum(total_leave_days) as no_days")->first();
    $past_val = $query1->no_days;
        
    $total = $RLTaken + $past_val;
    
    return $total;
}

function getForfeitAdjLeaveCount($username,$year,$currentDate='CURDATE()'){ 
    $duration=0;
    if($username!=''){
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $duration_query = DB::table('replacement_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $duration = $duration_query->value ?? 0;
        if($duration == '' || $duration == NULL){
            $duration =0;
        }
    }
    
    if($duration<365){
        
        $result = DB::table('leave_adjustment')->where('employee_id',$username)->whereYear('start_date',$year)->where('taken_stat',0)->having('isforfeit',1)->selectRaw("case when DATEDIFF(DATE_ADD(start_date, INTERVAL (".$duration.") DAY),CURDATE()) >0 then 0 ELSE 1 END isforfeit ,no_granted")->get();
        $rl_count = 0;
        for($i=0;$i<count($result);$i++){
            $rl_count += $result[$i]->no_granted;
        }
        return $rl_count;
    }else{
        return 0;
    }
}

function getForfeitAdjLeaveCount11($connection,$username,$year,$currentDate='CURDATE()'){ 
    $duration=0;
    if($username!=''){
        $users11=$connection->table('users')->where('username',$username)->first();
        $usercat =$connection->table('user_category')->where('username',$username)->first();
        $duration_query = $connection->table('replacement_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $duration = $duration_query->value ?? 0;
    }
    
    if($duration<365){
        
        $result = $connection->table('leave_adjustment')->where('employee_id',$username)->whereYear('start_date',$year)->where('taken_stat',0)->having('isforfeit',1)->selectRaw("case when DATEDIFF(DATE_ADD(start_date, INTERVAL (".$duration.") DAY),CURDATE()) >0 then 0 ELSE 1 END isforfeit ,no_granted")->get();
        $rl_count = 0;
        for($i=0;$i<count($result);$i++){
            $rl_count += $result[$i]->no_granted;
        }
        return $rl_count;
    }else{
        return 0;
    }
}
function getBroughtForwardPercentage($username,$bf=0,$entitle=0)
	{
        
        $resultArrayVal = DB::table('user_category as a')->leftjoin("leave_brought_forward_category as b",'a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
                
            if ($resultArrayVal->type=="perc"){
                $bf_value = ($bf * $resultArrayVal->percentage)/100;
            }elseif($resultArrayVal->type=="entitle"){
                $bf_max_value = ($entitle * $resultArrayVal->percentage)/100;
                if($bf_max_value<=$bf){
                    $bf_value = $bf_max_value;
                }  else {
                            $bf_value = $bf;
                        }
            }else{
                if($resultArrayVal->percentage<=$bf){
                    $bf_value = $resultArrayVal->percentage;
                }  else {
                    $bf_value = $bf;
                }
            }
                
		return floatval($bf_value);
	}
    
function getBFValue($year, $username, $dateValue = "")
	{
	   $hourlyLeave = getSettingsValue('hourlyLeave');
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		$exported_date = explode('-', $dateValue);
		$previous_year = $year - 1;


		$_p_year = 0;
		if (count($exported_date) > 0) {
			$last_date_previous_year = ($exported_date[0] - 1) . "-".$cutOffMonth."-".$cutOffDate;
			$_p_year = ($exported_date[0] - 1);
		} else {
			$last_date_previous_year = $previous_year . "-".$cutOffMonth."-".$cutOffDate;
			$_p_year = $previous_year;
        }
        $date_commence= UserPay::where('username',$username)->first();
		
        $user_join_date = $date_commence->date_commence;
        $SoftwareStartDate1 = DB::table('settings')->where('field', "software_start_year")->first();
		$SoftwareStartDate = $SoftwareStartDate1->value;

		if ($user_join_date == $exported_date[0]) {
			return 0;
		}

		if ($SoftwareStartDate <= ($year - 1)) {
		   $previous_bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
		} else {
			$previous_bfAnnual = 0;
		}
		  //if($year=="2021")
		  //dd($previous_bfAnnual);
		$balance = 0;
		$actual_annualEntitleForBF = getYearWiseFixLeaveEntitle($username, "Annual", $last_date_previous_year);
		$pastLeaves = getTakenPastLeaves($username, $_p_year);
		$bfAnnual = $previous_bfAnnual;
		$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", $last_date_previous_year);
	//	dd($annualEntitle);
	    

		if ($SettingLeaveAdjustmentType == 8) {
			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$joiningDate = $date_commence->date_commence;
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			$curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
			
			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($curr_date);
			$diff = $date1->diff($date2);
			$ExperienceInYear = $diff->y;
			if ($diff->d > 0 || $joiningDate == $curr_date) {
				$ExperienceInYear = $ExperienceInYear + 1;
			}

            $annualEntitle11 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $annualEntitle =  $annualEntitle11->no_leaves;
			
		}

		$adjustmentLeaves = getAdjustmentLeaveCount($username, $last_date_previous_year, 1);
		$bfAnnualAdj = getBroughtForwardLeaveCount($username, $last_date_previous_year, "Annual");
		$annaualTaken = getTakenLeaveCount($username, $_p_year, "Annual");
		$EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $last_date_previous_year);
		 
		$rlLeave = getReplacementLeaveCount($username, date('Y',strtotime($last_date_previous_year)));



        $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
        
		if ($BFLeaveTaken > $bfAnnual) {
			$BFLeaveTaken = $bfAnnual;
        }
        
		$bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);
        
		$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);


		/*BF, BF Adj, ADJ Start*/

        // $BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
        // $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
        // $BFClearDuration = $BFClearDuration11->value;
        // $BFAdjClearDuration = $BFAdjClearDuration11->value;
        $BFClearDuration=0;
        $BFAdjClearDuration=0;
        if($username!=''){
            $users11=DB::table('users')->where('username',$username)->first();
            $usercat =DB::table('user_category')->where('username',$username)->first();
            $BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
            $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
            $BFClearDuration = $BFClearDuration11->value ?? 0;
            $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
        }
		
		$bf_forfeit_value = 0;
		$bfadj_forfeit_value = 0;
		if ($BFClearDuration < 365) {
			$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
		}

		if ($BFAdjClearDuration < 365) {
			$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
		}


		$RL_forfeit = getForfeitAdjLeaveCount($username, $year);
        if($hourlyLeave == 1){
            $total_forfeit = round($bf_forfeit_value + $bfadj_forfeit_value,3);
        } else {
           $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value); 
        }
		
		/*BF, BF Adj, ADJ End*/
		
		$user_commence=DB::table('user_pay')->where('username',$username)->selectRaw("date_commence")->first();
		if(date('Y',strtotime($last_date_previous_year)) < date('Y',strtotime($user_commence->date_commence))){
            $annualEntitle=0;
        }
       
    	$balance = ($bfAnnual + $annualEntitle + $bfAnnualAdj) - ($annaualTaken + $pastLeaves['annual'] + $EmergencyLeaveValue) - $total_forfeit;
        $balance = roundaway($balance);
        
		$balance = getBroughtForwardPercentage($username, $balance, $actual_annualEntitleForBF);
    	 if($hourlyLeave == 1){
    	     $balance = round($balance,3);
    	 } else {
    	    $balance = roundaway($balance); 
    	 }
		
		return $balance;
    }

function getAdjustmentGrantedLeaveCount($username, $year)
	{
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
        //$year=date('Y',strtotime($year));
		if($cutOffStartMonth==1){
			$startDate = $year.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}else{
			$startDate = ($year-1).'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}
		$endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

        $query = DB::table('leave_adjustment')->where('employee_id', $username)->where('granted',"0")
        ->whereBetween('start_date', [$startDate, $endDate])->selectRaw("sum(no_granted) as no_granted")->first();
        
		return floatval($query->no_granted);
}


function getAdjustmentGrantedLeaveCount11($connection,$username, $year)
	{
		$cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
        //$year=date('Y',strtotime($year));
		if($cutOffStartMonth==1){
			$startDate = $year.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}else{
			$startDate = ($year-1).'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
		}
		$endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;

        $query = $connection->table('leave_adjustment')->where('employee_id', $username)->where('granted',"0")
        ->whereBetween('start_date', [$startDate, $endDate])->selectRaw("sum(no_granted) as no_granted")->first();
        
		return floatval($query->no_granted);
}
function roundaway($input) 
{
		$value = round($input * 2) / 2;
		return $value;
}
function getNPLCount($username, $year)
{
    $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		$date_commence= UserPay::where('username',$username)->first();
		$hours = gethours();
		
		$joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];

		if($cutOffStartMonth!=1){
			$startYear = $year-1;
		}else{
			$startYear = $year;
		}

		$prev_date = $year.'-'.$joining_month.'-'.$joining_date;
		$curr_date = ($year+1).'-'.$joining_month.'-'.$joining_date;
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		
		if($SettingLeaveAdjustmentType==8){
			
            $query = DB::table("leave_list as a")->leftjoin('leave_days as b','a.id','=','b.leave_id')->where('a.username',$username)->where('a.type','npl')->where('b.status',1)->whereBetween('a.start_date',[$prev_date, $curr_date])->selectRaw("sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.no_days END) as count")->first();
            
		}else{
			$startDate_1 = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
			$endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            
            $query = DB::table("leave_list as a")->leftjoin('leave_days as b','a.id','=','b.leave_id')->where('a.username',$username)->where('a.type','npl')->where('b.status',1)->where('a.start_date','>=',$startDate_1)->where('a.end_date','<=',$endDate_1)->selectRaw("sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.no_days END) as count")->first();
		}
		$leaveCount = floatval($query->count);
		
		
        $query = DB::table("leave_past")->where('username',$username)->where('type','npl')->whereYear('start_date',$year)->selectRaw("sum(total_leave_days) as count")->first();
		$nplCount = floatval($query->count);
		
		return $leaveCount + $nplCount;
}

function getNPLCount11($connection,$username, $year)
{
    $cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = $connection->table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		$date_commence= $connection->table('user_pay')->where('username',$username)->first();
		
		$joiningDate = $date_commence->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$hours=gethours();

		if($cutOffStartMonth!=1){
			$startYear = $year-1;
		}else{
			$startYear = $year;
		}

		$prev_date = $year.'-'.$joining_month.'-'.$joining_date;
		$curr_date = ($year+1).'-'.$joining_month.'-'.$joining_date;
		$curr_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		
		if($SettingLeaveAdjustmentType==8){
			
            $query = $connection->table("leave_list as a")->leftjoin('leave_days as b','a.id','=','b.leave_id')->where('a.username',$username)->where('a.type','npl')->where('b.status',1)->whereBetween('a.start_date',[$prev_date, $curr_date])->selectRaw("sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.no_days END) as count")->first();
            
		}else{
			$startDate_1 = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
			$endDate_1 = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
            
            $query = $connection->table("leave_list as a")->leftjoin('leave_days as b','a.id','=','b.leave_id')->where('a.username',$username)->where('a.type','npl')->where('b.status',1)->where('start_date','>=',$startDate_1)->where('end_date','<=',$endDate_1)->selectRaw("sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.no_days END) as count")->first();
		}
		$leaveCount = floatval($query->count);
		
		
        $query = $connection->table("leave_past")->where('username',$username)->where('type','npl')->whereYear('start_date',$year)->selectRaw("sum(total_leave_days) as count")->first();
		$nplCount = floatval($query->count);
		
		return $leaveCount + $nplCount;
}

function getYearlyEntitle($username, $year = null){
    if($year == null){
        $year = carbon()->year;
    }
    //dd($year);
    // $year=date('Y',strtotime($year));
    $hours = gethours();
    $hourlyLeave =  getSettingsValue('hourlyLeave');
    $user = User::where('id' , Auth::id())->first();
   // $year = request()->post('year') ?? carbon()->year;
    $type ="Annual";
    //$username = $user->username;
    $cutOffMonth = DB::table('settings')->where('field', "cut_of_month")->first();
    $cutOffDate = DB::table('settings')->where('field', "cut_of_date")->first();
    $cutOffStartDate = DB::table('settings')->where('field', "cut_of_startdate")->first();
    $cutOffStartMonth = DB::table('settings')->where('field', "cut_of_startmonth")->first();
    $SettingLeaveAdjustmentType = DB::table('settings')->where('field', "leave_adjustment_type")->first();
   // dd($SettingLeaveAdjustmentType->value);
    if ($SettingLeaveAdjustmentType->value == 8) {
        $joiningDate = UserPay::where('username',$username)->first();
        $joiningDateArr = explode('-', $joiningDate->date_commence);
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];
        $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
        if ((isset($_POST["pdf"]))) {
        } else {
            if (date('Y-m-d') < $curr_date) {
                $year = $year - 1;
            }
        }
    
    }
    
    $SoftwareStartDate = DB::table('settings')->where('field', "software_start_year")->first();
    $companyName = DB::table('settings')->where('field', "company")->first();
    $isShowClaimable ='';
    $date_commence= UserPay::where('username',$username)->first();
    $joiningDate = strtotime($date_commence->date_commence);
    $cutOffStartYear = $year;
    $cutOffYear = $year;
    if(($cutOffStartMonth->value ?? 0)!=1){
        if(($cutOffStartMonth->value ?? 0) > date('m')){
            $cutOffStartYear = $year;
            $cutOffYear = $year;
        }else{
            $cutOffStartYear = $year-1;
            $cutOffYear = $year;
        }
    }else{
        $cutOffStartYear = $year;
        $cutOffYear = $year;
    }
    $duration=0;
    if($username!=''){
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $duration_query = DB::table('replacement_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $duration = $duration_query->value ?? 0;
    }

    if($duration<365){
        $result = DB::table('leave_adjustment')->where('employee_id',$username)->whereYear('start_date',$year)->where('taken_stat',0)->having('isforfeit',1)->selectRaw("case when DATEDIFF(DATE_ADD(start_date, INTERVAL (90) DAY),CURDATE()) >0 then 0 ELSE 1 END isforfeit ,no_granted")->get();
        $rl_count = 0;
        for($i=0;$i<count($result);$i++){
            $rl_count += $result[$i]->no_granted;
        }
        $RL_forfeit = $rl_count;
    }
    else{
        $RL_forfeit= 0;
    }
    //$dt = $year."-".$cutOffMonth."-".$cutOffDate;
    
    $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year)."-".$cutOffMonth->value."-".$cutOffDate->value);
   
    //dd($annualEntitle);
    $medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth->value."-".$cutOffDate->value);
    $medical_pro_rated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
    $medical_pro_rated = $medical_pro_rated11->value;
    $joiningDate = $date_commence->date_commence;
    $joiningDateArr = explode('-', $joiningDate);
    $date_for_query = "CURDATE()";
    
    if ($medical_pro_rated == 1)
    {
        $joining_year = $joiningDateArr[0];
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];
        $resultArrayVal = UserPay::where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence,".$date_for_query.") as experience,date_commence")->first();
        $ExperienceInYear = $resultArrayVal->experience;
        $joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

        //section one
        $prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
        $start = $year . "-".$cutOffStartMonth->value ?? 0 ."-".$cutOffStartDate->value;
        $datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
        $days1 = round($datediff / (60 * 60 * 24));

        $date1 = new DateTime($joiningDate);
        $date2 = new DateTime($prev_date_of_joining_date);
        $diff = $date1->diff($date2);
        $experiance1 = $diff->y;
        if ($experiance1 == 0) {
            $experiance1 = 1;
        }
        $medicalEntitlenew11= DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Medical")->where('a.experience','<=',$experiance1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        $medicalEntitlenew1 =$medicalEntitlenew11->no_leaves;
        $d1 = ($days1 / 365) * $medicalEntitlenew1;

        $a1 = array(
            'username' => $username,
            'joining date' => $joiningDate,
            'entitle' => $medicalEntitlenew1,
            'start date' => $start,
            'end date' => $prev_date_of_joining_date,
            'days' => $days1,
            'experiance' => $experiance1,
        );
        //section one

        //section two
        $end_date = $year . "-".$cutOffMonth->value."-".$cutOffDate->value;
        $datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
        $days2 = round($datediff2 / (60 * 60 * 24));

        $date1 = new DateTime($joiningDate);
        $date2 = new DateTime($end_date);
        $diff = $date1->diff($date2);
        $experiance2 = $diff->y;
        //$experiance2=$experiance2+1;
        if ($joiningdatecurrent <= date('Y-m-d')) {
            $experiance2 = $experiance2 + 1;
        }
        $medicalEntitlenew21= DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Medical")->where('a.experience','<=',$experiance2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        $medicalEntitlenew =$medicalEntitlenew21->no_leaves;
        $d2 = ($days2 / 365) * $medicalEntitlenew;

        $a2 = array(
            'username' => $username,
            'joining date' => $joiningDate,
            'entitle' => $medicalEntitlenew,
            'start date' => $end_date,
            'end date' => $joiningdatecurrent,
            'days2' => $days2,
            'experiance' => $experiance2,
        );
        //section two
        if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
            if ($medicalEntitlenew1 != $medicalEntitlenew) {
                $medicalEntitle = round($d1 + $d2);
            } else {
                if ($medicalEntitlenew1 != '') {
                    $medicalEntitle = $medicalEntitlenew1;
                } else if ($medicalEntitlenew != '') {
                    $medicalEntitle = $medicalEntitlenew;
                }
            }
        }

    }
    $resiged_date_str = $date_commence->date_resigned;
    $joiningDate = $date_commence->date_commence;
    $joiningDateArr = explode('-', $joiningDate);
    $resignDateArr = explode('-', $resiged_date_str);
    $resign_year = $resignDateArr[0];
    $joining_year = $joiningDateArr[0];
    
    if($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
        $joining_year = $joiningDateArr[0];
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];
        $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
        $date1 = new DateTime($joiningDate);
        $date2 = new DateTime($joiningdatecurrent);
        $diff = $date1->diff($date2);
        $experiance1 = $diff->y;
        $experiance1 = $experiance1 + 1;
       
        if($joining_year < $year && $resign_year == $year){
            $joining_year = $joiningDateArr[0];
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($joiningdatecurrent);
            $diff = $date1->diff($date2);
            $experiance_1 = $diff->y;
            if ($experiance_1 == 0) {
                $experiance_1 = 1;
            }
            $annualEntitle_11=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $annualEntitle_1 =$annualEntitle_11->no_leaves;

            $experiance_2 = $experiance_1 + 1;
            $annualEntitle_21=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $annualEntitle_2 =$annualEntitle_21->no_leaves;
            $pro = 0;
            if(($annualEntitle_1 != $annualEntitle_2)  && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
                $pro = 1;
                $datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-".$cutOffStartMonth->value ?? 0 ."-".$cutOffStartDate->value);
                $days1 = round($datediff11 / (60 * 60 * 24));
                $datediff22 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
                $days2 = round($datediff22 / (60 * 60 * 24));
                $first_dif = ($days1 / 365) * $annualEntitle_1;
                //$second_dif = ($days2 / 365) * $annualEntitle_2;
                $second_dif = ($days2 / 365) * $annualEntitle_1;
                $annualEntitle = ($first_dif + $second_dif);
                $datediff2 = $datediff11+$datediff22;
            } else {
                $datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-".$cutOffStartMonth->value ?? 0 ."-".$cutOffStartDate->value);
            }
            
        }
        elseif ($joining_year < $year && $resign_year > $year){
            
            $datediff2=0;
            $joining_year = $joiningDateArr[0];
            $joining_month = $joiningDateArr[1];
            $joining_date = $joiningDateArr[2];
            $joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
            $date1 = new DateTime($joiningDate);
            $date2 = new DateTime($joiningdatecurrent);
            $diff = $date1->diff($date2);
            $experiance_1 = $diff->y;
            if ($experiance_1 == 0) {
                $experiance_1 = 1;
            }
            $annualEntitle_11=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $annualEntitle_1 =$annualEntitle_11->no_leaves;

            $experiance_2 = $experiance_1 + 1;
            $annualEntitle_21=DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
            $annualEntitle_2 =$annualEntitle_21->no_leaves;
            $pro = 0;
            if ($annualEntitle_1 != $annualEntitle_2) {
                $pro = 1;
                $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-".$cutOffMonth->value."-".$cutOffDate->value);
            }
        }
        elseif($joining_year == $year && $resign_year == $year) {
            $pro = 0;
            $datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);
        }
        elseif ($joining_year == $year && $resign_year > $year) {
            
            $pro = 0;
            
            $datediff2 = strtotime($cutOffYear . "-".$cutOffMonth->value."-".$cutOffDate->value) - strtotime($joiningDate);
           
            
        }
        else{

            
            $datediff2 =0;
            $pro=0;
        }
       
        $days = round($datediff2 / (60 * 60 * 24));
        //dd($days);
        $annualEntitle1 = ($days+1) / 365;
        //dd($pro);
        if ($joining_year < $year && $resign_year > $year) {
            if($pro == 0) {
                $annualEntitle = $annualEntitle;
            }
        } else {
            if($pro == 0) {
                $annualEntitle = $annualEntitle;
            }
        }
       
    }
   
    if($SettingLeaveAdjustmentType->value == 8 || $SettingLeaveAdjustmentType->value == 1) {
        $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth->value."-".$cutOffDate->value);
        $joiningDate=$date_commence->date_commence;
        $joiningDateArr = explode('-', $joiningDate);
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];

        $curr_date = $year . '-' . $joining_month . '-' . $joining_date;
        $curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
        $date1 = new DateTime($joiningDate);
        $date2 = new DateTime($curr_date);
        $diff = $date1->diff($date2);
        $ExperienceInYear = $diff->y;
        if ($diff->d > 0) {
            $ExperienceInYear = $ExperienceInYear + 1;
        }
        $annualEntitle1 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        $annualEntitle =$annualEntitle1->no_leaves;

    }
    elseif($SettingLeaveAdjustmentType->value == 6  && $joining_year != Date('Y')) {
        $annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth->value."-".$cutOffDate->value);
        $joiningDate = $date_commence->date_commence;
        $joiningDateArr = explode('-', $joiningDate);
        $joining_month = $joiningDateArr[1];
        $joining_date = $joiningDateArr[2];

        if($year!=""){
            if($year == date('Y')){
                $curr_date = date($year.'-m-d');
            }else {
                $curr_date = ($year) . "-".$cutOffMonth->value."-".$cutOffDate->value;
            }
            
        }else{
            $curr_date = date('Y-m-d');
        }
        $date1 = new DateTime($joiningDate);
        $date2 = new DateTime($curr_date);
        $diff = $date1->diff($date2);
        $ExperienceInYear = $diff->y;
        $actual_ExperienceInYear = $ExperienceInYear;

        if ($diff->d > 0 || $joiningDate == $curr_date) {
            $ExperienceInYear = $ExperienceInYear + 1;
        }
        if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
            $ExperienceInYear = 1;
        }
        $annualEntitle1 = DB::table("leave_entitle as a")->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type',"Annual")->where('a.experience','<=',$ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->first();
        if($actual_ExperienceInYear>0){
        $annualEntitle =$annualEntitle1->no_leaves;
        }
    
    }
   // dd($annualEntitle);
  
    $rlLeave=getReplacementLeaveCount($username, $year);
    
    $annaualTaken = getTakenLeaveCount($username, $year, "Annual");
   
    $medicalTaken = getTakenLeaveCount($username, $year, "Medical");
    $pastLeaves = getTakenPastLeaves($username, $year);
   // dd($pastLeaves);
    $adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
    if ($SoftwareStartDate->value <= ($year - 1)) {
       // dd($SoftwareStartDate->value,$year);
        $bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth->value."-".$cutOffDate->value);
        // dd($bfAnnual);
    } else {
        $bfAnnual = 0;
    }
     
    $EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);
    $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
    $bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
    $bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
    $nplCount = getNPLCount($username, $year);
    if(($cutOffStartMonth->value ?? 0)!='1'){
        $BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth->value ?? 0, $cutOffStartDate->value);
    }else{
        $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
    }
    if($BFLeaveTaken > $bfAnnual) {
        $BFLeaveTaken = $bfAnnual;
    }
    $tilldateDaysVal = tilldateDays($date_commence->date_commence);
    $tillYearEndDaysVal = tillYearEndDays($date_commence->date_commence);
    $YearStartToJoinDaysVal = YearStartToJoinDays($date_commence->date_commence);
   
    $resiged_date_str = $date_commence->date_resigned;
    $resiged_date = strtotime($resiged_date_str);
    $resiged_year = date('Y', $resiged_date);
    
    $leave_month = date("n");
    $leave_year = date("Y");
    if($SettingLeaveAdjustmentType->value == 8) {
        $annual_ent = get_anniv_cutt_off_entitle($username, $year);
        $cut_off_days = day_count_anniv_cutt_off($username, $year);
        $earn = ($cut_off_days / 365) * $annual_ent;
        if($hourlyLeave == 1){
            $earn = round($earn,3);
        } else {
            $earn = roundaway($earn); 
        }
    }
    else{
        if($year < $leave_year) {
            if($hourlyLeave == 1){
                $earn = round($annualEntitle,3);
            } else {
                $earn = roundaway($annualEntitle);
            }
           
        }
        else {
            if(($cutOffStartMonth->value ?? 0 !=1) && $cutOffMonth->value <= $leave_month && $year<=$leave_year){
                if($hourlyLeave == 1){
                    $earn = round($annualEntitle,3);
                } else {
                   $earn = roundaway($annualEntitle); 
                }
                
            }
            elseif($year == $resiged_year) {
                if ($leave_month < date('n', $resiged_date)) {
                    if($hourlyLeave == 1){
                        $earn = round(($leave_month /  date('n', $resiged_date)) * round($annualEntitle,3),3);
                    } else {
                        $earn = roundaway(($leave_month /  date('n', $resiged_date)) * roundaway($annualEntitle));
                    }
                    
                } else {
                    if($hourlyLeave == 1){
                        $earn = round(round($annualEntitle,3),3);
                    } else {
                        $earn = roundaway(roundaway($annualEntitle));  
                    }
                    
                }
            }
            else {
                if ($SettingLeaveAdjustmentType->value == 4 && $tillYearEndDaysVal < 365) {
                    if($hourlyLeave == 1){
                         $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                    } else {
                         $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                    }
                   
                }
                else {
                    
                    if ((date("m", strtotime($joiningDate)) == $leave_month) && date("Y", strtotime($joiningDate)) == $leave_year) {
                        if($hourlyLeave == 1){
                            $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                        } else {
                            $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                        }
                        
                    }
                    else {
                        if(($cutOffStartMonth->value ?? 0) >$leave_month){
                            if(date("Y", strtotime($joiningDate)) == $leave_year){
                                $month_cal = $leave_month - $joiningDateArr[1];
                            }else{
                                if($joining_year==($leave_year-1) && $cutOffStartMonth>$joiningDateArr[1]){
                                    $month_cal_1 = 12 - $cutOffStartMonth->value?? 0 ;
                                }else if($joining_year==($leave_year-1)){
                                    $month_cal_1 = 12 - $joiningDateArr[1];
                                }else{
                                    $month_cal_1 = 12 - $cutOffStartMonth->value?? 0 ;
                                }
                                $month_cal = $month_cal_1 + $leave_month;
                            }
                            $month_cal = $month_cal +1;
                        }
                        else{
                            $month_cal = $leave_month - $cutOffStartMonth->value?? 0 ;
                            $month_cal = $month_cal +1;
                        }
                        if(date("Y", strtotime($joiningDate)) == $leave_year) {
                            if ($companyName == "earn_prorated") {
                                 if($hourlyLeave == 1){
                                   $earn = round((round($annualEntitle,3) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal,3);  
                                 } else {
                                   $earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);  
                                 }
                                
                            } else {
                                if($hourlyLeave == 1){
                                    $earn = round(($month_cal / 12) * round($annualEntitle,3),3);
                                } else {
                                    $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
                                }
                                
                            }

                            if ($month_cal == 12) {
                                if($hourlyLeave == 1){
                                    $earn = round($annualEntitle,3);
                                } else {
                                    $earn = roundaway($annualEntitle);
                                }
                                
                            }
                        } else{
                            if($hourlyLeave == 1){
                                $earn = round(($month_cal / 12) * round($annualEntitle,3),3);
                            } else {
                                $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
                            }
                            
                        }
                    }
                }
            }
        }
    }
    
    

    $rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);
    $bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);
      if($hourlyLeave == 1){
          $aentitle = round($annualEntitle,3);
      } else {
          $aentitle = getValue($annualEntitle);
      }
    //dd($annualEntitle);
    $yearlyEntitle = array(
        "annual" => array(
            "entitle" => $aentitle,
            "taken" => floatval($annaualTaken),
            "rlLeave" => floatval($rlLeave),
            "rlLeaveTaken" => $rlLeaveTaken,
            "rlForfeit" => $RL_forfeit,
            "isShowClaimable" => $isShowClaimable
        ),
        "medical" => array(
            "entitle" => floatval($medicalEntitle),
            "taken" => floatval($medicalTaken)
        ),
        "past_leaves" => $pastLeaves,
        "adjust_leaves" => $adjustmentLeaves,
        "npl" => $nplCount,
        "earn" => $earn,
        "EmergencyLeaveValue" => $EmergencyLeaveValue,
        "brought_forward" => array(
            "annual" => ($bfAnnual),
            "annual_taken" => floatval($BFLeaveTaken),
            "annual_adj" => ($bfAnnualAdj),
            "bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
            "medical" => $bfMedical,
            "medical_adj" => $bfMedicalAdj
        ),
        "date_commence" => $date_commence->date_commence
    );
    $totalDaysTillToday =  tillTodayTotalDays($year, '');
    // $BFClearDuration1 = DB::table('settings')->where('field', "bf_duration")->first();
    // $BFClearDuration = $BFClearDuration1->value;
    // $BFAdjClearDuration1 = DB::table('settings')->where('field', "bf_adj_duration")->first();
    // $BFAdjClearDuration = $BFAdjClearDuration1->value;
    $BFClearDuration=0;
    $BFAdjClearDuration=0;
    if($username!=''){
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
        $BFClearDuration = $BFClearDuration1->value ?? 0;
        $BFAdjClearDuration = $BFAdjClearDuration1->value ?? 0;
    }
    $yearlyEntitle['bf_forfeit'] = 0;
    $yearlyEntitle['bfadj_forfeit'] = 0;
    $yearlyEntitle['adj_forfeit'] = 0;
    $bf_forfeit_value = 0;
    $bfadj_forfeit_value = 0;

    $checking_leave_year = $leave_year;
    if(($cutOffStartMonth->value ?? 0 )!=1){
        if(($cutOffStartMonth->value ?? 0) >= $leave_month){
            $checking_leave_year = $leave_year+1;
        }
    }
    if(($BFClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFClearDuration < 365) {
        $yearlyEntitle['bf_forfeit'] = 1;
        $bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
    }
    if(($BFAdjClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFAdjClearDuration < 365) {
        $yearlyEntitle['bfadj_forfeit'] = 1;
        $bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
    }
    if($hourlyLeave == 1){
        $total_forfeit = round($bf_forfeit_value + $bfadj_forfeit_value,3);
    } else {
       $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value); 
    }
    
    $user=DB::table('users')->where('username',$username)->first();
    $usercat =DB::table('user_category')->where('username',$username)->first();
    $preset = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
    //$preset = DB::table('settings')->where('field', "claimable_pre_set")->first();
    $earn1 = ($earn - ($preset->value ?? 0));
    $ear1 = (($preset->value ?? 0) / 12) * $annualEntitle;
    $earn1 = $earn - $ear1;
    if ($SettingLeaveAdjustmentType->value == 8) {
       $_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
    }else {
       if ($year < date('Y')) {
            if ($earn1 > $annualEntitle) {
                $earn2 = $annualEntitle;
            } else {
                $earn2 = $earn1;
            }
            
            $_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
        }else{
            if ($earn1 > $annualEntitle) {
                $earn2 = $annualEntitle;
            } else {
                $earn2 = $earn1;
            }
          //  dd($bfAnnual, $bfAnnualAdj, $earn2,$total_forfeit);
            $_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
        }
        if($hourlyLeave == 1){
            $_claim = round($_claim,3);
        } else {
            $_claim = roundaway($_claim); 
        }
        
        if ($_claim < 0) {
            $_claim = 0;
        }
    }
    $confirm_disp1 = DB::table('settings')->where('field', "confirm_display")->first();
    $confirm_disp = $confirm_disp1->value;
    
    $user_pay = DB::table('user_pay as a')->where('a.username', $username)->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, a.pay_status, a.contract")->leftjoin('branch as b','a.branch_id','=','b.id')->leftjoin('department as c','a.department_id','=','c.id')->leftjoin('category as d','a.category_id','=','d.id')->first();
    if ($confirm_disp == '1') {
        $user_pay->date_confirmed." -- ";
        if ($user_pay->date_confirmed == '' || $user_pay->date_confirmed == '00-00-0000') {
            $_claim = 0;
        }
    }
    $claimable_el_al= getSettingsValue('claimable_al_el');
    $claimableelal = $claimable_el_al ?? 0;
    if($claimableelal== '1'){
        $_claim = $_claim-($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']);
    }

    if (date("Y", strtotime($joiningDate)) == $leave_year) {


        if ($yearlyEntitle['annual']['isShowClaimable'] == 0) {
            $yearlyEntitle["claimable"] = 0;
        } else {
            //echo " <br /> Earn = <br />";
             if($claimableelal== '1'){
                $_claim11 = $yearlyEntitle['earn']-($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']);
            }
            $yearlyEntitle["claimable"] = $_claim11;
        }
    } else {
        $yearlyEntitle["claimable"] = $_claim;
    }
   if($hourlyLeave == 1){
        $yearlyEntitle["balance"] = round($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit, 3);
   } else {
        $yearlyEntitle["balance"] = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit);
   }
    return $yearlyEntitle;
    //dd($yearlyEntitle);
    

}

function getUserRequiredListByUsername($nameORNo = "",$year=""){
   $user = User::where('id' , !empty(Auth::check()) ? Auth::id() : request()->auth_id)->first();
       
    $ActiveUserShownStatus11 = DB::table('settings')->where('field',"active_user_shown")->first();
    $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
    $permission_val = getPermissionValue("hr", $user->username);
    $approverId = $user->username;
    $approver_query = DB::table('map_employee_approver as a')->leftjoin('user_personal as b','a.employee_id','=','b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
    $approver_str = "";
		for($i=0;$i<count($approver_query);$i++){
			$approver_str .= "'".$approver_query[$i]->username."'";
			if($i<(count($approver_query)-1)){
				$approver_str .= ", ";
			}
        }
        $query = DB::table('user_personal as a')->leftjoin('user_pay as b','a.username','=','b.username')->whereRaw("1 and (DATE_FORMAT(b.date_resigned,'%Y') >=  '".$year."' OR DATE_FORMAT(b.date_resigned,'%Y') = '0000')")->selectRaw("a.username, a.employee_no, a.employee_no as 'No.', a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(b.date_commence,'%d/%m/%Y') as date_commence, DATE_FORMAT(b.date_commence,'%Y') as join_year");
        if($nameORNo != ""){
            $query->whereRaw("(a.name like ('".$nameORNo."%') OR a.employee_no like ('".$nameORNo."%'))");
        }
        if($permission_val==4){
            $query->whereRaw("a.username in (".$approver_str.")");
        }
        if($ActiveUserShownStatus=='0'){
            $query->whereRaw("b.pay_status like '%1%'");
        }
            $query->where('a.isDeleted',0);
        if($year!=""){
            $query->having('join_year','<=',$year);
        }
        $result= $query->get();
        return $result;
}

function getPermissionValue($group, $username){
   $query = DB::table('map_employee_permission as a')->leftjoin('permission_group as b','a.permission_group_id','=','b.id')->where('a.employee_id', "$username")->selectRaw("b.".$group)->first();
   $result = intval($query->$group ?? null);
   
   return $result;
        

}

function getCountryState($username){

		$result1=UserPersonal::where('username',$username)->selectRaw("nationality, state")->first();
		$result = $result1;
		return $result;

    }

function getUserRequiredList($usernames = "",$year="")
	{
		$user = User::where('id' , Auth::id())->first();
        $ActiveUserShownStatus11 = DB::table('settings')->where('field',"active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
        $permission_val = getPermissionValue("hr", $user->username);
        $approverId = $user->username;
        $approver_query = DB::table('map_employee_approver as a')->leftjoin('user_personal as b','a.employee_id','=','b.username')->where('a.approver_id', $approverId)->selectRaw("distinct b.username")->get();
		$approver_str = "";
		for($i=0;$i<count($approver_query);$i++){
			$approver_str .= "'".$approver_query[$i]->username."'";
			if($i<(count($approver_query)-1)){
				$approver_str .= ", ";
			}
		}
		
		$yearwisedt=date('Y-m-d');
        $yearwisedt=str_replace(date('Y'),$year,$yearwisedt);
        $query = DB::table('user_personal as a')->leftjoin('user_pay as bb','a.username','=','bb.username')->whereRaw("1 and (DATE_FORMAT(bb.date_resigned,'%Y') >=  '".$year."'  OR DATE_FORMAT(bb.date_resigned,'%Y') = '0000' )")->selectRaw("a.username, a.employee_no, a.employee_no as 'No.', a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(bb.date_commence, '%d/%m/%Y') as date_commence, DATE_FORMAT(bb.date_commence,'%Y') as join_year");
        if($usernames != ""){
            $query->wherein('a.username ',$approver_str);
        }
        if($permission_val==4){
            $query->whereRaw("a.username in (".$approver_str.")");
        }
        if($ActiveUserShownStatus=='0'){
            $query->whereRaw("bb.pay_status like '%1%'");
        }
            $query->where('a.isDeleted',0);
        if($year!=""){
            $query->where("DATE_FORMAT(bb.date_commence,'%Y')",'<=',$year);
        }
        
        $result= $query->get();
		
		return $result;
    }
    
    function getConfirmDisplay($username)
	{
		$ConfirmDisplayUser11 = DB::table('settings')->where('field', "confirm_display")->first();
		$ConfirmDisplayUser = $ConfirmDisplayUser11->value;
		$userpay = DB::table('user_pay')->where('username', $username)->first();
		$userConfirmDate = $userpay->date_confirmed;
		$userJoinDate = $userpay->date_commence;
		$isShowClaimable = 1;
		if ($ConfirmDisplayUser == 1) {
			if ($userConfirmDate != 0) {
				$month = date('n', strtotime($userConfirmDate));
				if ($month != 0) {
					$isShowClaimable = 1;
				} else {
					$isShowClaimable = 0;
				}
			} else {
				$isShowClaimable = 0;
			}
		}
		return $isShowClaimable;
	}


    
function getConfirmDisplay11($connection,$username)
	{
        $ConfirmDisplayUser11 = $connection->table('settings')->where('field', "confirm_display")->first();
        $ConfirmDisplayUser = $ConfirmDisplayUser11->value;
        
        $userConfirmDate11 = $connection->table('user_pay')->where('username',$username)->first();
		$userConfirmDate = $userConfirmDate11->date_confirmed;
		$userJoinDate = $userConfirmDate11->date_commence;
		$isShowClaimable = 1;
		if ($ConfirmDisplayUser == 1) {
			if ($userConfirmDate != 0) {
			    
				$month = date('m', strtotime($userConfirmDate));
				if ($month != 0) {
					$isShowClaimable = 1;
				} else {
					$isShowClaimable = 0;
				}
			} else {
				$isShowClaimable = 0;
			}
		}
		return $isShowClaimable;
    }
function getforfeitLeaveCountByUser($username,$start_date,$end_date)
    {
        $hours = gethours();
        $query=DB::table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->where('a.status',1)->where('b.type','Other_pay')->where('a.date','>=',$start_date)->where('a.date','<=',$end_date)->where('a.username',$username)->selectRaw("sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken")->first();
        $value = $query->leave_taken;
        if($value==''){
            $value = 0;
        }
        
        return $value;
    }

function getforfeitLeaveCountByUser11($conection,$username,$start_date,$end_date)
    {
        $hours = gethours();
        $query=$conection->table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->where('a.status',1)->where('b.type','Other_pay')->where('a.date','>=',$start_date)->where('a.date','<=',$end_date)->where('a.username',$username)->selectRaw("sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken")->first();
        $value = $query->leave_taken;
        if($value==''){
            $value = 0;
        }
        
        return $value;
    }

function getTakenPastLeavesforfeit($username, $forfeit_leave_date_start, $forfeit_leave_date_end)
	{
		$query = DB::table('leave_past')->where('type','Other_pay')->where('username',$username)->where('start_date','>=',$forfeit_leave_date_start)->where('start_date','<=',$forfeit_leave_date_end)->selectRaw("sum(total_leave_days) as no_days")->first();
        $replacementLeaves = floatval($query->no_days);
		return $replacementLeaves;
    }

function getTakenPastLeavesforfeit11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end)
	{
		$query = $connection->table('leave_past')->where('type','Other_pay')->where('username',$username)->where('start_date','>=',$forfeit_leave_date_start)->where('start_date','<=',$forfeit_leave_date_end)->selectRaw("sum(total_leave_days) as no_days")->first();
        $replacementLeaves = floatval($query->no_days);
		return $replacementLeaves;
    }
    
function getpreviousyearbf_new($year, $username, $dateValue = "")
	{
	    $hourlyLeave =  getSettingsValue('hourlyLeave');
		$cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;

        $SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
        $SoftwareStartDate=$SoftwareStartDate11->value;

        $date_commence11= UserPay::where('username',$username)->first();
        $user_join_date = $date_commence11->date_commence;
		$pre_year = $year - 1;

		$startdate = $SoftwareStartDate;
		$enddate = $pre_year;

		$years = range($startdate, $enddate);

		if ($pre_year == $SoftwareStartDate) {
			$exported_date = explode('-', $dateValue);
			$previous_year = $year - 1;


			$_p_year = 0;
			if (count($exported_date) > 0) {
				$last_date_previous_year = ($exported_date[0] - 1) . "-".$cutOffMonth."-".$cutOffDate;
				$_p_year = ($exported_date[0] - 1);
			} else {
				$last_date_previous_year = $previous_year . "-".$cutOffMonth."-".$cutOffDate;
				$_p_year = $previous_year;
			}

			$year1 = $pre_year;
			$bfAnnual = 0;
			$adjustmentLeaves = getAdjustmentLeaveCount($username, $year1, 1);

			$annaualTaken = getTakenLeaveCount($username, $year1, "Other_pay");

			$granted_rlen = getAdjustmentGrantedLeaveCount($username, $year1);

			$pastLeaves = getTakenPastLeaves($username, $year1);

			$totalDaysTillToday =  tillTodayTotalDays($year1);

            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "replacement_duration")->first();
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;
            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=DB::table('users')->where('username',$username)->first();
                $usercat =DB::table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }

			$forfeit_leave_date_start = date('Y-m-d', strtotime($year1 . "-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));


			$bf_forfeit_value = 0;
			$annaualTakenforfeit = getforfeitLeaveCountByUser($username, $forfeit_leave_date_start, $forfeit_leave_date_end);

			$pastLeavesforfeit = getTakenPastLeavesforfeit($username, $forfeit_leave_date_start, $forfeit_leave_date_end);

			$annaualTakentotal = getforfeitLeaveCountByUser($username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));
			//print_r($annaualTakentotal);exit();
			$pastLeavestotal = getTakenPastLeavesforfeit($username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));

			$curr_bfadj_date = $year1 . "-".$cutOffStartMonth."-".$cutOffStartDate;


			$date1 = new DateTime($curr_bfadj_date);
			$date2 = new DateTime(date('Y-m-d'));
			$diff = $date1->diff($date2);
			$bfadj_days = $diff->days;

			if ($BFAdjClearDuration < 365) {
				if ($bfadj_days > $BFAdjClearDuration) {
					$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
					$total_leave_total = ($annaualTakentotal + $pastLeavestotal);
					if ($total_leave_in > 0) {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves ) - $total_leave_in;
						
					} else {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
					}
					$bf_forfeit_value = $tot_forfeit;
				}
			}
			if ($bf_forfeit_value <= 0) {
				$bf_forfeit_value = 0;
			}
			$total_forfeit = $bf_forfeit_value;
			$balance = ($bfAnnual + $adjustmentLeaves + $granted_rlen) - ($annaualTaken + $pastLeaves['replacement'] + $total_forfeit);
			if($hourlyLeave == 1){
			    $balance = round($balance,3);
			} else {
			   $balance = roundaway($balance); 
			}
			

			$master_Arr[$year1] = array(
				'rlbf' => $bfAnnual, 'rladj' => $adjustmentLeaves, 'granted' => $granted_rlen, 'taken' => $annaualTaken,
				'total_forfeit' => $total_forfeit, 'balance' => $balance
			);
			return $balance;
		} else {
			$master_Arr = array();
			
			foreach ($years as $year1) {
				$balance = 0;
				
				if ($SoftwareStartDate <= ($year1 - 1)) {
					$bfAnnual = getpreviousyearbf_new($year1, $username, ($year1) . "-".$cutOffMonth."-".$cutOffDate);
				} else {
					$bfAnnual = 0;
				}
				$adjustmentLeaves = getAdjustmentLeaveCount($username, $year1, 1);
				$annaualTaken = getTakenLeaveCount($username, $year1, "Other_pay");
				$granted_rlen = getAdjustmentGrantedLeaveCount($username, $year1);
				$pastLeaves = getTakenPastLeaves($username, $year1);
				$totalDaysTillToday =  tillTodayTotalDays($year1);
                
                $BFAdjClearDuration=0;
                if($username!=''){
                    $users11=DB::table('users')->where('username',$username)->first();
                    $usercat =DB::table('user_category')->where('username',$username)->first();
                    $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                    $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
                }

				$forfeit_leave_date_start = date('Y-m-d', strtotime($year1 . "-".$cutOffStartMonth."-".$cutOffStartDate));
				$forfeit_leave_date_end = date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate));
				$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));


				$bf_forfeit_value = 0;
				$annaualTakenforfeit = getforfeitLeaveCountByUser($username, $forfeit_leave_date_start, $forfeit_leave_date_end);

				$pastLeavesforfeit = getTakenPastLeavesforfeit($username, $forfeit_leave_date_start, $forfeit_leave_date_end);

				$annaualTakentotal = getforfeitLeaveCountByUser($username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));

				$pastLeavestotal = getTakenPastLeavesforfeit($username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));
				$adjustmentLeaves = getAdjustmentLeaveCount($username, $year1, 1);

				$curr_bfadj_date = $year1 . "-".$cutOffStartMonth."-".$cutOffStartDate;


				$date1 = new DateTime($curr_bfadj_date);
				if($year1==date('Y')){
					$date2 = new DateTime(date('Y-m-d'));
				}else{
					$date2 = new DateTime($year1."-".$cutOffMonth."-".$cutOffDate);
				}
				
				$diff = $date1->diff($date2);
				$bfadj_days = $diff->days;


				if ($BFAdjClearDuration < 365) {
					if ($bfadj_days > $BFAdjClearDuration) {
						$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
						if ($total_leave_in > 0) {
							$tot_forfeit = ($bfAnnual + $adjustmentLeaves ) - $total_leave_in;
						} else {
							$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
						}
						$bf_forfeit_value = $tot_forfeit;
					}
				}
				if ($bf_forfeit_value <= 0) {
					$bf_forfeit_value = 0;
				}
				$total_forfeit = $bf_forfeit_value;


				$balance = ($bfAnnual + $adjustmentLeaves + $granted_rlen) - ($annaualTaken + $pastLeaves['replacement'] + $total_forfeit);
				if($hourlyLeave == 1){
    			    $balance = round($balance,3);
    			} else {
    			   $balance = roundaway($balance); 
    			}

				$master_Arr[$year1] = array(
					'rlbf' => $bfAnnual, 'rladj' => $adjustmentLeaves, 'granted' => $granted_rlen, 'taken' => $annaualTaken,
					'total_forfeit' => $total_forfeit, 'balance' => $balance
				);
				if ($pre_year == $year1) {
					return $balance;
				}
			}
		}
    }  
    
function getpreviousyearbf_new11($connection,$year, $username, $dateValue = "")
	{
	    $hourlyLeave =  getSettingsValue('hourlyLeave');
		$cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;

        $SoftwareStartDate11 = $connection->table('settings')->where('field', "software_start_year")->first();
        $SoftwareStartDate=$SoftwareStartDate11->value;

        $date_commence11= $connection->table('user_pay')->where('username',$username)->first();
        $user_join_date = $date_commence11->date_commence;
		$pre_year = $year - 1;

		$startdate = $SoftwareStartDate;
		$enddate = $pre_year;

		$years = range($startdate, $enddate);

		if ($pre_year == $SoftwareStartDate) {
			$exported_date = explode('-', $dateValue);
			$previous_year = $year - 1;


			$_p_year = 0;
			if (count($exported_date) > 0) {
				$last_date_previous_year = ($exported_date[0] - 1) . "-".$cutOffMonth."-".$cutOffDate;
				$_p_year = ($exported_date[0] - 1);
			} else {
				$last_date_previous_year = $previous_year . "-".$cutOffMonth."-".$cutOffDate;
				$_p_year = $previous_year;
			}

			$year1 = $pre_year;
			$bfAnnual = 0;
			$adjustmentLeaves = getAdjustmentLeaveCount11($connection,$username, $year1, 1);

			$annaualTaken = getTakenLeaveCount11($connection,$username, $year1, "Other_pay");

			$granted_rlen = getAdjustmentGrantedLeaveCount11($connection,$username, $year1);

			$pastLeaves = getTakenPastLeaves11($connection,$username, $year1);

			$totalDaysTillToday =  tillTodayTotalDays($year1);

            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "replacement_duration")->first();
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;
            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=$connection->table('users')->where('username',$username)->first();
                $usercat =$connection->table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = $connection->table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }

			$forfeit_leave_date_start = date('Y-m-d', strtotime($year1 . "-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));


			$bf_forfeit_value = 0;
			$annaualTakenforfeit = getforfeitLeaveCountByUser11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);

			$pastLeavesforfeit = getTakenPastLeavesforfeit11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);

			$annaualTakentotal = getforfeitLeaveCountByUser11($connection,$username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));
			//print_r($annaualTakentotal);exit();
			$pastLeavestotal = getTakenPastLeavesforfeit11($connection,$username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));

			$curr_bfadj_date = $year1 . "-".$cutOffStartMonth."-".$cutOffStartDate;


			$date1 = new DateTime($curr_bfadj_date);
			$date2 = new DateTime(date('Y-m-d'));
			$diff = $date1->diff($date2);
			$bfadj_days = $diff->days;

			if ($BFAdjClearDuration < 365) {
				if ($bfadj_days > $BFAdjClearDuration) {
					$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
					$total_leave_total = ($annaualTakentotal + $pastLeavestotal);
					if ($total_leave_in > 0) {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves ) - $total_leave_in;
						
					} else {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
					}
					$bf_forfeit_value = $tot_forfeit;
				}
			}
			if ($bf_forfeit_value <= 0) {
				$bf_forfeit_value = 0;
			}
			$total_forfeit = $bf_forfeit_value;
			$balance = ($bfAnnual + $adjustmentLeaves + $granted_rlen) - ($annaualTaken + $pastLeaves['replacement'] + $total_forfeit);
			if($hourlyLeave == 1){
			    $balance = round($balance,3);
			} else {
			    $balance = roundway($balance);
			}

			$master_Arr[$year1] = array(
				'rlbf' => $bfAnnual, 'rladj' => $adjustmentLeaves, 'granted' => $granted_rlen, 'taken' => $annaualTaken,
				'total_forfeit' => $total_forfeit, 'balance' => $balance
			);
			return $balance;
		} else {
			$master_Arr = array();
			
			foreach ($years as $year1) {
				$balance = 0;
				
				if ($SoftwareStartDate <= ($year1 - 1)) {
					$bfAnnual = getpreviousyearbf_new11($connection,$year1, $username, ($year1) . "-".$cutOffMonth."-".$cutOffDate);
				} else {
					$bfAnnual = 0;
				}
				$adjustmentLeaves = getAdjustmentLeaveCount11($connection,$username, $year1, 1);
				$annaualTaken = getTakenLeaveCount11($connection,$username, $year1, "Other_pay");
				$granted_rlen = getAdjustmentGrantedLeaveCount11($connection,$username, $year1);
				$pastLeaves = getTakenPastLeaves11($connection,$username, $year1);
				$totalDaysTillToday =  tillTodayTotalDays($year1);
                
                $BFAdjClearDuration=0;
                if($username!=''){
                    $users11=$connection->table('users')->where('username',$username)->first();
                    $usercat =$connection->table('user_category')->where('username',$username)->first();
                    $BFAdjClearDuration11 = $connection->table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                    $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
                }

				$forfeit_leave_date_start = date('Y-m-d', strtotime($year1 . "-".$cutOffStartMonth."-".$cutOffStartDate));
				$forfeit_leave_date_end = date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate));
				$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));


				$bf_forfeit_value = 0;
				$annaualTakenforfeit = getforfeitLeaveCountByUser11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);

				$pastLeavesforfeit = getTakenPastLeavesforfeit11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);

				$annaualTakentotal = getforfeitLeaveCountByUser11($connection,$username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));

				$pastLeavestotal = getTakenPastLeavesforfeit11($connection,$username, date('Y-m-d', strtotime($year1."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year1."-".$cutOffMonth."-".$cutOffDate)));
				$adjustmentLeaves = getAdjustmentLeaveCount11($connection,$username, $year1, 1);

				$curr_bfadj_date = $year1 . "-".$cutOffStartMonth."-".$cutOffStartDate;


				$date1 = new DateTime($curr_bfadj_date);
				if($year1==date('Y')){
					$date2 = new DateTime(date('Y-m-d'));
				}else{
					$date2 = new DateTime($year1."-".$cutOffMonth."-".$cutOffDate);
				}
				
				$diff = $date1->diff($date2);
				$bfadj_days = $diff->days;


				if ($BFAdjClearDuration < 365) {
					if ($bfadj_days > $BFAdjClearDuration) {
						$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
						if ($total_leave_in > 0) {
							$tot_forfeit = ($bfAnnual + $adjustmentLeaves ) - $total_leave_in;
						} else {
							$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
						}
						$bf_forfeit_value = $tot_forfeit;
					}
				}
				if ($bf_forfeit_value <= 0) {
					$bf_forfeit_value = 0;
				}
				$total_forfeit = $bf_forfeit_value;


				$balance = ($bfAnnual + $adjustmentLeaves + $granted_rlen) - ($annaualTaken + $pastLeaves['replacement'] + $total_forfeit);
				if($hourlyLeave == 1){
				    $balance = round($balance,3);
				} else {
				    $balance = roundway($balance);
				}

				$master_Arr[$year1] = array(
					'rlbf' => $bfAnnual, 'rladj' => $adjustmentLeaves, 'granted' => $granted_rlen, 'taken' => $annaualTaken,
					'total_forfeit' => $total_forfeit, 'balance' => $balance
				);
				if ($pre_year == $year1) {
					return $balance;
				}
			}
		}
    }  
    
function getYearlyrlEntitleList($username, $year = null)
	{
	    //$year=date('Y',strtotime($year));
	    $hourlyLeave =  getSettingsValue('hourlyLeave');
        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $companyName11 = DB::table('settings')->where('field', "company")->first();
        if($companyName11!=''){
            $companyName = $companyName11->value;
        }
        else{
            $companyName ='';
        }
        $cutOffStartYear = $year;
		$cutOffYear = $year;
		if($cutOffStartMonth!=1){
			if($cutOffStartMonth > date('m')){
				$cutOffStartYear = $year;
				$cutOffYear = $year;
			}else{
				$cutOffStartYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$cutOffStartYear = $year;
			$cutOffYear = $year;
		}
        $ActiveUserShownStatus11 = DB::table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
        if ($username != '') {
            //$users = getUserRequiredListByUsername($username, $year);
            
            $query = DB::table('user_personal as a')->leftjoin('user_pay as b','a.username','=','b.username')->where('a.username',$username)->selectRaw("a.username, a.employee_no, a.employee_no as 'No.', a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(b.date_commence,'%d/%m/%Y') as date_commence, DATE_FORMAT(b.date_commence,'%Y') as join_year");
            
            if($ActiveUserShownStatus=='0'){
                $query->whereRaw("b.pay_status like '%1%'");
            }
                $query->where('a.isDeleted',0);
            if($year!=""){
                $query->having('join_year','<=',$year);
            }
            $users = $query->get();
            
        }
        else {
			$users = getUserRequiredList("", $year);
			
        }
        
        $SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
        $SoftwareStartDate = $SoftwareStartDate11->value;
        
        for($i = 0; $i < count($users); $i++) {
            
            $username = $users[$i]->username;
            $date_commence11= UserPay::where('username',$username)->first();
            $date_commence = $date_commence11->date_commence;
			$joiningDate = strtotime($date_commence);
			$RL_forfeit = getForfeitAdjLeaveCount($username, $year);

            $isShowClaimable = getConfirmDisplay($username);
            $annualEntitle = getYearWiseFixLeaveEntitle($username, "Other_pay", ($year) . "-".$cutOffMonth."-".$cutOffDate);
            
            $medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$annaualTaken = getTakenLeaveCount($username, $year, "Other_pay");

			$rlLeave = getReplacementLeaveCount($username, $year);
			$medicalTaken = getTakenLeaveCount($username, $year, "Medical");
			$pastLeaves = getTakenPastLeaves($username, $year);
			$adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
		//	dd($username);
            $granted_rlen = getAdjustmentGrantedLeaveCount($username, $year);
            
            if($SoftwareStartDate <= ($year - 1)) {
                $bfAnnual = getpreviousyearbf_new($year, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
            } else {
				$bfAnnual = 0;
            }
            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
            
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;
            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=DB::table('users')->where('username',$username)->first();
                $usercat =DB::table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }
            $forfeit_leave_date_start = date('Y-m-d', strtotime($year . "-".$cutOffStartMonth."-".$cutOffStartDate));
            
            $dt = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
            $forfeit_leave_date_end = date('Y-m-d', strtotime("$dt + $BFAdjClearDuration days"));
            
            $EmergencyLeaveValue = getforfeitLeaveCountByUser($username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            $pastLeavesforfeit = getTakenPastLeavesforfeit($username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            $bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Other_pay");
			$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
			$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
            $nplCount = getNPLCount($username, $year);
            $BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
            if ($BFLeaveTaken > $bfAnnual) {
				$BFLeaveTaken = $bfAnnual;
            }
            $bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

			$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);

			$tilldateDaysVal = tilldateDays($date_commence);
			$tillYearEndDaysVal = tillYearEndDays($date_commence);
            $YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);
            $resiged_date_str = $date_commence11->date_resigned;
            $resiged_date = strtotime($resiged_date_str);
            $resiged_year = date('Y', $resiged_date);
            if($year < date('Y')) {
                if($hourlyLeave ==1){
                    $earn = round($annualEntitle,3);
                } else {
                   $earn = roundaway($annualEntitle); 
                }
                
                
			} else {
				if ($year == $resiged_year) {
                    if(date("m") < date('m', $resiged_date)) {
                        if($hourlyLeave ==1){ 
                            $earn = round((date("m") /  date('m', $resiged_date)) * round($annualEntitle,3),3);
                        } else {
                           $earn = roundaway((date("m") /  date('m', $resiged_date)) * roundaway($annualEntitle)); 
                        }
                        
                    }
                    else{
                        if($hourlyLeave ==1){ 
                             $earn = round(round($annualEntitle,3),3);
                        } else {
                             $earn = roundaway(roundaway($annualEntitle));
                        }
                       
                        
                    }
                }
                else{
                    if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
                        if($hourlyLeave ==1){ 
                            $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                        } else {
                            $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal); 
                        }
                        
					} else {
                        if ((date("m", $joiningDate) == date("m")) && date("Y", $joiningDate) == date("Y")) {
                            if($hourlyLeave ==1){
                                $earn = round((1 / 12) * round($annualEntitle,3),3);
                                $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                            } else {
                                $earn = roundaway((1 / 12) * roundaway($annualEntitle));
                                $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                            }
                        }
                        else {
                            if (date("Y", $joiningDate) == date("Y")) {
                                if ($companyName == "earn_prorated") {
                                    if($hourlyLeave ==1){
                                        $earn = round((round($annualEntitle,3) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal,3);
                                    } else {
                                        $earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
                                    }
                                    
								} else {
								    if($hourlyLeave ==1){
								        $earn = round((date("m") / 12) * round($annualEntitle,3),3);
								    } else {
								       $earn = roundaway((date("m") / 12) * roundaway($annualEntitle)); 
								    }
                                }
                                if (date("m") == 12) {
                                    if($hourlyLeave ==1){
                                        $earn = round($annualEntitle,3);
                                    } else {
                                        $earn = roundaway($annualEntitle); 
                                    }
								}
                            }
                            else {
                                if($hourlyLeave ==1){
                                    $earn = round((date("m") / 12) * round($annualEntitle,3),3);
                                } else {
                                    $earn = roundaway((date("m") / 12) * roundaway($annualEntitle));
                                }
                                
							}
                        }
                    }
                }
            } 
            $SoftwareStartDate11 = DB::table('settings')->where('field', "software_start_year")->first();
             if($hourlyLeave ==1){
                 $rgranted = round($granted_rlen,3);
                 $aentitle = round($annualEntitle,3);
                 $mentitle = round($medicalEntitle,3);
             } else {
                 $rgranted = roundaway($granted_rlen);
                 $aentitle = getValue($annualEntitle);
                 $mentitle = roundaway($medicalEntitle);
             }
        
            $yearlyEntitle = array(
				"Other_pay" => array(
					"granted" => $rgranted,
					"entitle" => $aentitle,
					"taken" => floatval($annaualTaken),
					"rlLeave" => floatval($rlLeave),
					"rlLeaveTaken" => $rlLeaveTaken,
					"rlForfeit" => $RL_forfeit,
					"isShowClaimable" => $isShowClaimable
				),
				"medical" => array(
					"entitle" => $mentitle,
					"taken" => floatval($medicalTaken)
				),
				"past_leaves" => $pastLeaves,
				"adjust_leaves" => $adjustmentLeaves,
				"npl" => $nplCount,
				"earn" => $earn,
				"past_leave_forfeit" => $pastLeavesforfeit,
				"EmergencyLeaveValue" => $EmergencyLeaveValue,
				"brought_forward" => array(
					"Other_pay" => ($bfAnnual),
                    "annual_taken" => floatval($BFLeaveTaken),
                    "annual" => floatval($BFLeaveTaken),
					"annual_adj" => ($bfAnnualAdj),
					"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
					"medical" => $bfMedical,
					"medical_adj" => $bfMedicalAdj
				)
            );
            
            $totalDaysTillToday =  tillTodayTotalDays($year);
            //$BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
            //$BFClearDuration = $BFClearDuration11->value;

            $BFClearDuration=0;
            if($username!=''){
                $users11=DB::table('users')->where('username',$username)->first();
                $usercat =DB::table('user_category')->where('username',$username)->first();
                $BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFClearDuration = $BFClearDuration11->value ?? 0;
            }

            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "replacement_duration")->first();
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;

            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=DB::table('users')->where('username',$username)->first();
                $usercat =DB::table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }

            $users[$i]->bf_forfeit = 0;
			$users[$i]->bfadj_forfeit = 0;
			$users[$i]->adj_forfeit = 0;

			$bf_forfeit_value = 0;
            $bfadj_forfeit_value = 0;
            
            $forfeit_leave_date_start = date('Y-m-d', strtotime($year . "-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));

			$annaualTakenforfeit = getforfeitLeaveCountByUser($username, $forfeit_leave_date_start, $forfeit_leave_date_end);

            $pastLeavesforfeit = getTakenPastLeavesforfeit($username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            
            $annaualTakentotal = getforfeitLeaveCountByUser($username, date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year."-".$cutOffMonth."-".$cutOffDate)));

			$pastLeavestotal = getTakenPastLeavesforfeit($username, date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year."-".$cutOffMonth."-".$cutOffDate)));

			$curr_bfadj_date = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;


			$date1 = new DateTime($curr_bfadj_date);
			$date2 = new DateTime(date('Y-m-d'));
			$diff = $date1->diff($date2);
            $bfadj_days = $diff->days;
            
            if ($BFAdjClearDuration < 365) {
				if ($bfadj_days > $BFAdjClearDuration) {
					$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
					$total_leave_total = ($annaualTakentotal + $pastLeavestotal);
					if ($total_leave_in > 0) {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves) - $total_leave_in;
						
					} else {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
					}
					$bf_forfeit_value = $tot_forfeit;
				}
			}
			if (($BFClearDuration < $totalDaysTillToday || $year != $cutOffYear) && $BFClearDuration < 365) {
				$users[$i]->bf_forfeit = 1;
				$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
			}
			if ($bf_forfeit_value <= 0) {
				$bf_forfeit_value = 0;
            }
            if (($BFAdjClearDuration < $totalDaysTillToday || $year != $cutOffYear) && $BFAdjClearDuration < 365) {
				$users[$i]->bfadj_forfeit = 1;
				$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
			}
            //$users[$i]->bf_forfeit = $bf_forfeit_value;
            if($hourlyLeave == 1){
                 $total_forfeit = round($bf_forfeit_value + $bfadj_forfeit_value + $RL_forfeit,3);
            } else {
                 $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value + $RL_forfeit);
            }
           
            $users[$i]->entitle = $yearlyEntitle;

			if ($year < date('Y')) {
			    if($hourlyLeave == 1){
			        $_claim = round($annualEntitle,3) + $bfAnnual + $bfAnnualAdj + $adjustmentLeaves;
			    } else {
			       	$_claim = roundaway($annualEntitle) + $bfAnnual + $bfAnnualAdj + $adjustmentLeaves; 
			    }
			
			} else {
                //return $yearlyEntitle;
				$_claim = claimable($yearlyEntitle, $users[$i]->date_commence, $resiged_date, $year) - $total_forfeit;
			}

			if ($_claim < 0) {
				$_claim = 0;
			}


            $users[$i]->claimable = $_claim;
            if($hourlyLeave == 1){
                $users[$i]->balance = round($yearlyEntitle['brought_forward']['Other_pay'] + $yearlyEntitle['adjust_leaves'] + $yearlyEntitle['Other_pay']['granted'] - ($yearlyEntitle['Other_pay']['taken'] + $yearlyEntitle['past_leaves']['replacement'] + $bf_forfeit_value),3);
            } else {
                $users[$i]->balance = roundaway($yearlyEntitle['brought_forward']['Other_pay'] + $yearlyEntitle['adjust_leaves'] + $yearlyEntitle['Other_pay']['granted'] - ($yearlyEntitle['Other_pay']['taken'] + $yearlyEntitle['past_leaves']['replacement'] + $bf_forfeit_value));
            }
            // return $users;
		}
        //return $yearlyEntitle;
		return $users;
		
    }
    
    function getYearlyrrlEntitleList($username, $year = null, $connection)
	{
        //$year=date('Y',strtotime($year));
       $hourlyLeave = getSettingsValue('hourlyLeave');
        $cutOffMonth11 = $connection->table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = $connection->table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = $connection->table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = $connection->table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = $connection->table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $companyName11 = $connection->table('settings')->where('field', "company")->first();
        if($companyName11!=''){
            $companyName = $companyName11->value;
        }
        else{
            $companyName ='';
        }
        $ActiveUserShownStatus11 = $connection->table('settings')->where('field', "active_user_shown")->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
        if ($username != '') {
            //$users = getUserRequiredListByUsername($username, $year);
            
            $query = $connection->table('user_personal as a')->leftjoin('user_pay as b','a.username','=','b.username')->whereRaw("(a.name like ('" . $username . "%') OR a.employee_no like ('" . $username . "%') OR a.username like ('" . $username . "%'))")->selectRaw("a.username, a.employee_no, a.employee_no as 'No.', a.employee_code, a.name, a.name as 'Name&nbsp;', DATE_FORMAT(b.date_commence,'%d/%m/%Y') as date_commence, DATE_FORMAT(b.date_commence,'%Y') as join_year");
            
            if($ActiveUserShownStatus=='0'){
                $query->whereRaw("b.pay_status like '%1%'");
            }
                $query->where('a.isDeleted',0);
            if($year!=""){
                $query->having('join_year','<=',$year);
            }
            $users = $query->get();
            
        }
        else {
			$users = getUserRequiredList("", $year);
			
        }
        
        $SoftwareStartDate11 = $connection->table('settings')->where('field', "software_start_year")->first();
        $SoftwareStartDate = $SoftwareStartDate11->value;
        
        for($i = 0; $i < count($users); $i++) {
            
            $username = $users[$i]->username;
            $date_commence11= $connection->table('user_pay')->where('username',$username)->first();
            $date_commence = $date_commence11->date_commence;
			$joiningDate = strtotime($date_commence);
			$RL_forfeit = getForfeitAdjLeaveCount11($connection,$username, $year);

            $isShowClaimable = getConfirmDisplay11($connection,$username);
            $annualEntitle = getYearWiseFixLeaveEntitle11($connection,$username, "Other_pay", ($year) . "-".$cutOffMonth."-".$cutOffDate);
            
            $medicalEntitle = getYearWiseFixLeaveEntitle11($connection,$username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$annaualTaken = getTakenLeaveCount11($connection,$username, $year, "Other_pay");

			$rlLeave = getReplacementLeaveCount11($connection,$username, $year);
			$medicalTaken = getTakenLeaveCount11($connection,$username, $year, "Medical");
			$pastLeaves = getTakenPastLeaves11($connection,$username, $year);
			$adjustmentLeaves = getAdjustmentLeaveCount11($connection,$username, $year, 1);
            $granted_rlen = getAdjustmentGrantedLeaveCount11($connection,$username, $year);
            
            if($SoftwareStartDate <= ($year - 1)) {
                $bfAnnual = getpreviousyearbf_new11($connection,$year, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
            } else {
				$bfAnnual = 0;
            }
            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
            
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;
            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=$connection->table('users')->where('username',$username)->first();
                $usercat =$connection->table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = $connection->table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }
            $forfeit_leave_date_start = date('Y-m-d', strtotime($year . "-".$cutOffStartMonth."-".$cutOffStartDate));
            
            $dt = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
            $forfeit_leave_date_end = date('Y-m-d', strtotime("$dt + $BFAdjClearDuration days"));
            
            $EmergencyLeaveValue = getforfeitLeaveCountByUser11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            $pastLeavesforfeit = getTakenPastLeavesforfeit11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            $bfAnnualAdj = getBroughtForwardLeaveCount11($connection,$username, $year, "Other_pay");
			$bfMedical = getBroughtForwardLeaveNotAdjusted11($connection,$username, $year, "Medical");
			$bfMedicalAdj = getBroughtForwardLeaveCount11($connection,$username, $year, "Medical");
            $nplCount = getNPLCount11($connection,$username, $year);
            $BFLeaveTaken = getCountOfBFLeaveTaken11($connection,$username, $year);
            if ($BFLeaveTaken > $bfAnnual) {
				$BFLeaveTaken = $bfAnnual;
            }
            $bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken11($connection,$username, $year, $bfAnnual, $bfAnnualAdj);

			$rlLeaveTaken = getCountOfAdjLeaveTaken11($connection,$username, $year);

			$tilldateDaysVal = tilldateDays($date_commence);
			$tillYearEndDaysVal = tillYearEndDays($date_commence);
            $YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);
            $resiged_date_str = $date_commence11->date_resigned;
            $resiged_date = strtotime($resiged_date_str);
            $resiged_year = date('Y', $resiged_date);
            if($year < date('Y')) {
                if($hourlyLeave == 1){
                   $earn = round($annualEntitle,3); 
                } else {
                    $earn = roundaway($annualEntitle); 
                }
                
                
			} else {
				if ($year == $resiged_year) {
                    if(date("m") < date('m', $resiged_date)) {
                        if($hourlyLeave == 1){
                            $earn = round((date("m") /  date('m', $resiged_date)) * round($annualEntitle,3),3);
                        } else {
                            $earn = roundaway((date("m") /  date('m', $resiged_date)) * roundaway($annualEntitle)); 
                        }
                    }
                    else{
                        if($hourlyLeave == 1){
                            $earn = round(round($annualEntitle,3),3);
                        } else {
                            $earn = roundaway(roundaway($annualEntitle));
                        }
                        
                    }
                }
                else{
                    if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
                        if($hourlyLeave == 1){
                            $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                        } else {
                           $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal); 
                        }
                        
                        
					} else {
                        if ((date("m", $joiningDate) == date("m")) && date("Y", $joiningDate) == date("Y")) {
                            if($hourlyLeave == 1){
                                $earn = round((1 / 12) * round($annualEntitle,3),3);
                                $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
                            } else {
                                $earn = roundaway((1 / 12) * roundaway($annualEntitle));
                                $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
                            }
                        }
                        else {
                            if (date("Y", $joiningDate) == date("Y")) {
                                if ($companyName == "earn_prorated") {
                                    if($hourlyLeave == 1){
                                       $earn = round((round($annualEntitle,3) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal,3); 
                                    } else {
                                       $earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal); 
                                    }
                                    
                                    
								} else {
								    if($hourlyLeave == 1){
                                        $earn = round((date("m") / 12) * round($annualEntitle,3),3);
								    } else {
								       $earn = roundaway((date("m") / 12) * roundaway($annualEntitle)); 
								    }
                                    
                                }
                                if (date("m") == 12) {
                                    if($hourlyLeave == 1){
                                         $earn = round($annualEntitle,3);
                                    } else {
                                        $earn = roundaway($annualEntitle); 
                                    }
                                   
                                    
								}
                            }
                            else {
                                if($hourlyLeave == 1){
                                    $earn = round((date("m") / 12) * round($annualEntitle,3),3);
                                } else {
                                    $earn = roundaway((date("m") / 12) * roundaway($annualEntitle));
                                }
                                
                                
							}
                        }
                    }
                }
            } 
            $SoftwareStartDate11 = $connection->table('settings')->where('field', "software_start_year")->first();
         if($hourlyLeave == 1){
             $rgranted = round($granted_rlen,3);
             $rentitle = round($annualEntitle,3);
             $mentitle = round($medicalEntitle,3);
         } else {
              $rgranted = roundaway($granted_rlen);
             $rentitle = getValue($annualEntitle);
              $mentitle = roundaway($medicalEntitle);
         }
            $yearlyEntitle = array(
				"Other_pay" => array(
					"granted" => $rgranted,
					"entitle" => $rentitle,
					"taken" => floatval($annaualTaken),
					"rlLeave" => floatval($rlLeave),
					"rlLeaveTaken" => $rlLeaveTaken,
					"rlForfeit" => $RL_forfeit,
					"isShowClaimable" => $isShowClaimable
				),
				"medical" => array(
					"entitle" => $mentitle,
					"taken" => floatval($medicalTaken)
				),
				"past_leaves" => $pastLeaves,
				"adjust_leaves" => $adjustmentLeaves,
				"npl" => $nplCount,
				"earn" => $earn,
				"past_leave_forfeit" => $pastLeavesforfeit,
				"EmergencyLeaveValue" => $EmergencyLeaveValue,
				"brought_forward" => array(
					"Other_pay" => ($bfAnnual),
                    "annual_taken" => floatval($BFLeaveTaken),
                    "annual" => floatval($BFLeaveTaken),
					"annual_adj" => ($bfAnnualAdj),
					"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
					"medical" => $bfMedical,
					"medical_adj" => $bfMedicalAdj
				)
            );
            
            $totalDaysTillToday =  tillTodayTotalDays($year);
            //$BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
            //$BFClearDuration = $BFClearDuration11->value;

            $BFClearDuration=0;
            if($username!=''){
                $users11=$connection->table('users')->where('username',$username)->first();
                $usercat =$connection->table('user_category')->where('username',$username)->first();
                $BFClearDuration11 = $connection->table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFClearDuration = $BFClearDuration11->value ?? 0;
            }

            // $BFAdjClearDuration11 = DB::table('settings')->where('field', "replacement_duration")->first();
            // $BFAdjClearDuration = $BFAdjClearDuration11->value;

            $BFAdjClearDuration=0;
            if($username!=''){
                $users11=$connection->table('users')->where('username',$username)->first();
                $usercat =$connection->table('user_category')->where('username',$username)->first();
                $BFAdjClearDuration11 = $connection->table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users11->company_id)->first();
                $BFAdjClearDuration = $BFAdjClearDuration11->value ?? 0;
            }

            $users[$i]->bf_forfeit = 0;
			$users[$i]->bfadj_forfeit = 0;
			$users[$i]->adj_forfeit = 0;

			$bf_forfeit_value = 0;
            $bfadj_forfeit_value = 0;
            
            $forfeit_leave_date_start = date('Y-m-d', strtotime($year . "-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate));
			$forfeit_leave_date_end = date('Y-m-d', strtotime($forfeit_leave_date_end . " + $BFAdjClearDuration days"));

			$annaualTakenforfeit = getforfeitLeaveCountByUser11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);

            $pastLeavesforfeit = getTakenPastLeavesforfeit11($connection,$username, $forfeit_leave_date_start, $forfeit_leave_date_end);
            
            $annaualTakentotal = getforfeitLeaveCountByUser11($connection,$username, date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year."-".$cutOffMonth."-".$cutOffDate)));

			$pastLeavestotal = getTakenPastLeavesforfeit11($connection,$username, date('Y-m-d', strtotime($year."-".$cutOffStartMonth."-".$cutOffStartDate)), date('Y-m-d', strtotime($year."-".$cutOffMonth."-".$cutOffDate)));

			$curr_bfadj_date = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;


			$date1 = new DateTime($curr_bfadj_date);
			$date2 = new DateTime(date('Y-m-d'));
			$diff = $date1->diff($date2);
            $bfadj_days = $diff->days;
            
            if ($BFAdjClearDuration < 365) {
				if ($bfadj_days > $BFAdjClearDuration) {
					$total_leave_in = ($annaualTakenforfeit + $pastLeavesforfeit);
					$total_leave_total = ($annaualTakentotal + $pastLeavestotal);
					if ($total_leave_in > 0) {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves) - $total_leave_in;
						
					} else {
						$tot_forfeit = ($bfAnnual + $adjustmentLeaves);
					}
					$bf_forfeit_value = $tot_forfeit;
				}
			}
			if ($bf_forfeit_value <= 0) {
				$bf_forfeit_value = 0;
            }
            $users[$i]->bf_forfeit = $bf_forfeit_value;
            if($hourlyLeave == 1){
                $total_forfeit = round($bf_forfeit_value + $bfadj_forfeit_value + $RL_forfeit,3);
            } else {
                $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value + $RL_forfeit);
            }
            
            $users[$i]->entitle = $yearlyEntitle;

			if ($year < date('Y')) {
			    if($hourlyLeave == 1){
			       $_claim = round($annualEntitle,3) + $bfAnnual + $bfAnnualAdj + $adjustmentLeaves; 
			    } else {
			      $_claim = roundaway($annualEntitle) + $bfAnnual + $bfAnnualAdj + $adjustmentLeaves;  
			    }
				
			} else {
                //return $yearlyEntitle;
				$_claim = claimable11($connection,$yearlyEntitle, $users[$i]->date_commence, $resiged_date, $year) - $total_forfeit;
			}

			if ($_claim < 0) {
				$_claim = 0;
			}

            $users[$i]->claimable = $_claim;
            if($hourlyLeave == 1){
             $users[$i]->balance = round($yearlyEntitle['brought_forward']['Other_pay'] + $yearlyEntitle['adjust_leaves'] + $yearlyEntitle['Other_pay']['granted'] - ($yearlyEntitle['Other_pay']['taken'] + $yearlyEntitle['past_leaves']['replacement'] + $bf_forfeit_value),3);
            } else {
             $users[$i]->balance = roundaway($yearlyEntitle['brought_forward']['Other_pay'] + $yearlyEntitle['adjust_leaves'] + $yearlyEntitle['Other_pay']['granted'] - ($yearlyEntitle['Other_pay']['taken'] + $yearlyEntitle['past_leaves']['replacement'] + $bf_forfeit_value));
            }
            // return $users;
		}
        //return $yearlyEntitle;
		return $users;
		
    }
    
function claimable($obj, $date_commence, $resiged_date = '', $year = '', $leave_date = '')
	{
		if ($leave_date != '') {
			$leave_date = strtotime(str_replace('/', '-', $leave_date));
		}
        $hourlyLeave = getSettingsValue('hourlyLeave');
        $SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		$claimable = 0;

		
		if ($obj['Other_pay']['isShowClaimable'] == 0) {
			$claimable = 0;
		} else if ($date_commence != "") {
			$timestamp = strtotime(str_replace('/', '-', $date_commence));

			$joining_year = date('Y', $timestamp);

			$leave_date_time = "";

			if ($leave_date != '') {
				$current_year = date('Y', $leave_date);
				$current_month = date('m', $leave_date);

				$leave_date_time = $leave_date;
			} else {
				$current_year = date('Y');
				$current_month = date('m');
				$leave_date_time = time();
				
			}


			$tillYearEndDaysVal = tillYearEndDays($date_commence);

			
			$date_difference = floor(($leave_date_time - $timestamp) / 3600 / 24);
			if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
				if($hourlyLeave == 1){
				    $claimable = $obj['earn'] + round($obj['brought_forward']['annual'],3) + round($obj['brought_forward']['annual_adj'],3); 
				} else {
				    $claimable = $obj['earn'] + roundaway($obj['brought_forward']['annual']) + roundaway($obj['brought_forward']['annual_adj']); 
				}
				
			} else if ($SettingLeaveAdjustmentType == 3) {
				$earn = $obj['earn'];
				if($hourlyLeave == 1){
				    $claimable = $earn + round($obj['brought_forward']['annual'],3) + round($obj['brought_forward']['annual_adj'],3); 
				} else {
				    $claimable = $earn + roundaway($obj['brought_forward']['annual']) + roundaway($obj['brought_forward']['annual_adj']);  
				}
				
			} else {
				$resiged_year = date('Y', $resiged_date);

				if ($year != '' && $year == $resiged_year) {
					if ($joining_year == $current_year) {
						$currentY = $current_year;
						$yearStartDAte = mktime(0, 0, 0, 1, 1,  $currentY);

						$your_date = strtotime($date_commence);
						$datediff_day = $resiged_date - $yearStartDAte;
						$this_year_working_days = floor($datediff_day / (60 * 60 * 24));

						if ($date_difference < $this_year_working_days) {
						    if($hourlyLeave == 1){
						       $val = (round($obj['Other_pay']['entitle'],3) / $this_year_working_days) * $date_difference; 
						    } else {
						       $val = (roundaway($obj['Other_pay']['entitle']) / $this_year_working_days) * $date_difference; 
						    }
							
						} else {
						    if($hourlyLeave == 1){
						        $val = round($obj['Other_pay']['entitle'],3);
						    } else {
						     $val = roundaway($obj['Other_pay']['entitle']);   
						    }
							
                        }
                        if(request()->auth_id!=''){
					        $user = User::where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = User::where('id' , Auth::id())->first();
						}
                        $usercat =DB::table('user_category')->where('username',$user->username)->first();
                        $preset11 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
                        //$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $claimable = (round($val,3) + round($obj['brought_forward']['annual_taken'],3)) - $preset;
						} else {
						   $claimable = (roundaway($val) + roundaway($obj['brought_forward']['annual_taken'])) - $preset; 
						}
						
					} else {
					    if(request()->auth_id!=''){
					        $user = User::where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = User::where('id' , Auth::id())->first();
						}
                        $usercat =DB::table('user_category')->where('username',$user->username)->first();
                        $preset11 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
	                    if($hourlyLeave == 1){
						    $claimable = round(((date('m', $resiged_date) - $preset) / date('n', $resiged_date)) * $obj['Other_pay']['entitle'],3); 
	                    } else {
	                        $claimable = roundaway(((date('m', $resiged_date) - $preset) / date('n', $resiged_date)) * $obj['Other_pay']['entitle']); 
	                    }
						if ($obj['Other_pay']['entitle'] < $claimable) {
							$claimable = $obj['Other_pay']['entitle'];
						}
						if($hourlyLeave == 1){
						    $claimable = $claimable + round($obj['brought_forward']['annual_taken'],3) + round($obj['brought_forward']['annual_adj'],3);
						} else {
						    $claimable = $claimable + roundaway($obj['brought_forward']['annual_taken']) + roundaway($obj['brought_forward']['annual_adj']);
						}
						
					}
				} else {
					if ($joining_year == $current_year) {
					    if(request()->auth_id!=''){
					        $user = User::where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = User::where('id' , Auth::id())->first();
						}
                        $usercat =DB::table('user_category')->where('username',$user->username)->first();
                        $preset11 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $_tmp_claimble = (round($obj['earn'],3) + round($obj['brought_forward']['annual'],3) + $obj['brought_forward']['annual_adj']) - $preset; 
   
						} else {
						    $_tmp_claimble = (roundaway($obj['earn']) + roundaway($obj['brought_forward']['annual']) + $obj['brought_forward']['annual_adj']) - $preset; 
   
						}
						
						if ($obj['Other_pay']['entitle'] < $_tmp_claimble) {
							$_tmp_claimble = $obj['Other_pay']['entitle'];
						} 
						$claimable = $_tmp_claimble;
					} else {
					    if(request()->auth_id!=''){
					        $user = User::where('id' , request()->auth_id)->first();
					    }
						else{
						    $user = User::where('id' , Auth::id())->first();
						}
                        $usercat =DB::table('user_category')->where('username',$user->username)->first();
                        $preset11 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $_tmp_claimble = round((($current_month - $preset) / 12) * $obj['Other_pay']['entitle'],3); 
						} else {
						   $_tmp_claimble = roundaway((($current_month - $preset) / 12) * $obj['Other_pay']['entitle']);  
						}
						

						if ($obj['Other_pay']['entitle'] < $_tmp_claimble) {
							$_tmp_claimble = $obj['Other_pay']['entitle'];
						} 
						$claimable = $_tmp_claimble;
						
					}
				}
			}
		}
		return $claimable; 
    }
    
function claimable11($connection,$obj, $date_commence, $resiged_date = '', $year = '', $leave_date = '')
	{
		if ($leave_date != '') {
			$leave_date = strtotime(str_replace('/', '-', $leave_date));
		}
        $hourlyLeave = getSettingsValue('hourlyLeave');
        $SettingLeaveAdjustmentType11 = $connection->table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
		$claimable = 0;

		
		if ($obj['Other_pay']['isShowClaimable'] == 0) {
			$claimable = 0;
		} else if ($date_commence != "") {
			$timestamp = strtotime(str_replace('/', '-', $date_commence));

			$joining_year = date('Y', $timestamp);

			$leave_date_time = "";

			if ($leave_date != '') {
				$current_year = date('Y', $leave_date);
				$current_month = date('m', $leave_date);

				$leave_date_time = $leave_date;
			} else {
				$current_year = date('Y');
				$current_month = date('m');
				$leave_date_time = time();
				
			}


			$tillYearEndDaysVal = tillYearEndDays($date_commence);

			
			$date_difference = floor(($leave_date_time - $timestamp) / 3600 / 24);
			if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
				if($hourlyLeave == 1){
				    $claimable = $obj['earn'] + round($obj['brought_forward']['annual'],3) + round($obj['brought_forward']['annual_adj'],3); 
				} else {
				    $claimable = $obj['earn'] + roundaway($obj['brought_forward']['annual']) + roundaway($obj['brought_forward']['annual_adj']); 
				}
				
			} else if ($SettingLeaveAdjustmentType == 3) {
				$earn = $obj['earn'];
				if($hourlyLeave == 1){
				    $claimable = $earn + round($obj['brought_forward']['annual'],3) + round($obj['brought_forward']['annual_adj'],3);
				} else {
				    $claimable = $earn + roundaway($obj['brought_forward']['annual']) + roundaway($obj['brought_forward']['annual_adj']);
				}
				
			} else {
				$resiged_year = date('Y', $resiged_date);

				if ($year != '' && $year == $resiged_year) {
					if ($joining_year == $current_year) {
						$currentY = $current_year;
						$yearStartDAte = mktime(0, 0, 0, 1, 1,  $currentY);

						$your_date = strtotime($date_commence);
						$datediff_day = $resiged_date - $yearStartDAte;
						$this_year_working_days = floor($datediff_day / (60 * 60 * 24));

						if ($date_difference < $this_year_working_days) {
						    if($hourlyLeave == 1){
						        $val = (round($obj['Other_pay']['entitle'],3) / $this_year_working_days) * $date_difference;
						    } else {
						        $val = (roundaway($obj['Other_pay']['entitle']) / $this_year_working_days) * $date_difference;
						    }
							
						} else {
						    if($hourlyLeave == 1){
						        $val = round($obj['Other_pay']['entitle'],3);
						    } else {
						       $val = roundaway($obj['Other_pay']['entitle']); 
						    }
							
                        }
                        if(request()->auth_id!=''){
					        $user = $connection->table('users')->where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = $connection->table('users')->where('id' , Auth::id())->first();
						}
                        $usercat =$connection->table('user_category')->where('username',$user->username)->first();
                        $preset11 = $connection->table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
                        //$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $claimable = (round($val,3) + round($obj['brought_forward']['annual_taken'],3)) - $preset;
						} else {
						    $claimable = (roundaway($val) + roundaway($obj['brought_forward']['annual_taken'])) - $preset;
						}
						
					} else {
					    if(request()->auth_id!=''){
					        $user = $connection->table('users')->where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = $connection->table('users')->where('id' , Auth::id())->first();
						}
                        $usercat =$connection->table('user_category')->where('username',$user->username)->first();
                        $preset11 = $connection->table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
                        if($hourlyLeave == 1){
						    $claimable = round(((date('m', $resiged_date) - $preset) / date('n', $resiged_date)) * $obj['Other_pay']['entitle'],3); 
                        } else {
                           $claimable = roundaway(((date('m', $resiged_date) - $preset) / date('n', $resiged_date)) * $obj['Other_pay']['entitle']);  
                        }
						if ($obj['Other_pay']['entitle'] < $claimable) {
							$claimable = $obj['Other_pay']['entitle'];
						}
						if($hourlyLeave == 1){
						    $claimable = $claimable + round($obj['brought_forward']['annual_taken'],3) + round($obj['brought_forward']['annual_adj'],3);
						} else {
						    $claimable = $claimable + roundaway($obj['brought_forward']['annual_taken']) + roundaway($obj['brought_forward']['annual_adj']);
						}
						
					}
				} else {
					if ($joining_year == $current_year) {
					    if(request()->auth_id!=''){
					        $user = $connection->table('users')->where('id' , request()->auth_id)->first();
					    }
						else{
                            $user = $connection->table('users')->where('id' , Auth::id())->first();
						}
                        $usercat =$connection->table('user_category')->where('username',$user->username)->first();
                        $preset11 = $connection->table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $_tmp_claimble = (round($obj['earn'],3) + round($obj['brought_forward']['annual'],3) + $obj['brought_forward']['annual_adj']) - $preset; 
                        } else {
						    $_tmp_claimble = (roundaway($obj['earn']) + roundaway($obj['brought_forward']['annual']) + $obj['brought_forward']['annual_adj']) - $preset; 
    
						}
						
						if ($obj['Other_pay']['entitle'] < $_tmp_claimble) {
							$_tmp_claimble = $obj['Other_pay']['entitle'];
						} 
						$claimable = $_tmp_claimble;
					} else {
					    if(request()->auth_id!=''){
					        $user = $connection->table('users')->where('id' , request()->auth_id)->first();
					    }
						else{
						    $user = $connection->table('users')->where('id' , Auth::id())->first();
						}
                        $usercat =$connection->table('user_category')->where('username',$user->username)->first();
                        $preset11 = $connection->table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
						//$preset11 = DB::table('settings')->where('field', "claimable_pre_set")->first();
						$preset = $preset11->value ?? 0;
						if($hourlyLeave == 1){
						    $_tmp_claimble = round((($current_month - $preset) / 12) * $obj['Other_pay']['entitle'],3); 
						} else {
						    $_tmp_claimble = roundaway((($current_month - $preset) / 12) * $obj['Other_pay']['entitle']); 
						}
						

						if ($obj['Other_pay']['entitle'] < $_tmp_claimble) {
							$_tmp_claimble = $obj['Other_pay']['entitle'];
						} 
						$claimable = $_tmp_claimble;
						
					}
				}
			}
		}
		return $claimable; 
	}
	
	

    function getMaxLeaveValueForUser($username)
    {
        
        $resultArray = DB::table('category_max_leave as ml')->leftjoin('user_category as uc','uc.category','=','ml.category')->where('uc.username', $username)->selectRaw('ml.leave_type, ml.max_value')->get();
        $finalResult = array();
        
        $finalResult['username'] = $username;
        for($i=0;$i<count($resultArray);$i++){
            $finalResult[$resultArray[$i]->leave_type] = $resultArray[$i]->max_value;
        }
        
        return $finalResult;
    }
    
    function getleavecolorarry(){
        $masterArr=array();
        $leaveclolor =  DB::table('leave_name')->get();
        foreach($leaveclolor as $row){
            $masterArr[$row->type]=$row->leave_color;
        }
        return $masterArr;
    }

    function getUserGroups($username)
	{
        $result =  DB::table('user_pay')->selectRaw("branch_id, department_id, category_id")->where("username",$username)->first();
        
		return $result;
    }
    
    function getAllBranchIdsOfStateByBranch($id)
	{
		$statequery = DB::table('branch')->select("state")->where("id",$id)->get();
		if(count($statequery)>0){
			$state = $statequery[0]->state;
            $branch_ids = DB::table('branch')->select("id")->where("state",$state)->get();
		    return $branch_ids;
		}else{
			return '';
		}
	}

    function getHRApproverPendingLeaveListAll($categoryId, $branchId, $departmentId, $leaveType, $date, $employeeNo, $employeeName, $approverId, $Status='',$approvername='')
    {
        $user = User::where('id' , Auth::id())->first();
        $hours = gethours();
        $approval_viewStatus1 = DB::table('map_employee_permission as a')->leftjoin('permission_group as b','a.permission_group_id','=','b.id')->where('a.employee_id',$user->username)->selectRaw('b.hr_view_all')->first();
        $approval_viewStatus = $approval_viewStatus1->hr_view_all;
        $logged_username = $user->username;
        $ActiveUserShownStatus1= DB::table('settings')->where('field','active_user_shown')->first();
        $ActiveUserShownStatus = $ActiveUserShownStatus1->value;
        $currentOnly1= DB::table('settings')->where('field','only_current_year_leave_display')->first();
		$currentOnly = $currentOnly1->value;
		$LeaveMultipleApprover1= DB::table('settings')->where('field','leave_multiple_approver')->first();
        $LeaveMultipleApprover = $LeaveMultipleApprover1->value;
        if($LeaveMultipleApprover=='3' || $LeaveMultipleApprover=='4'){
            $query = "select (select GROUP_CONCAT(distinct(user_personal.name)) from user_personal left join approver_approved_leaves on approver_approved_leaves.approver_id=user_personal.username where approver_approved_leaves.leave_days_id=b.id) as approvername,a.id, a.username, c.name, c.employee_no, b.type,b.approver_id,c.name,DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, b.date_applied as date_applied1, a.date as start_date1, ";
        }
        else{
            $query = "select IF(b.approver_id='', '-',(select name from user_personal where username=b.approver_id)) as approvername,a.id, a.username, c.name, c.employee_no, b.type,b.approver_id,c.name,DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date, b.date_applied as date_applied1, a.date as start_date1,";
        }
        
        $query .= "DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, ";
		$query .= "CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END as 'no_days', a.status, b.reason,e.name as Department, ";
		$query .= " CASE b.is_half_day WHEN 1 THEN ( CASE b.half_day_type WHEN 'first' THEN 'AM' WHEN 'second' THEN 'PM' END ) WHEN 0 THEN '' END as 'half_day_type',  ";
		$query .= "a.cancellation_reason, b.filename,a.leave_id, c_r.name as r_name from leave_days a left join leave_list b on a.leave_id=b.id ";
        $query .= "left join user_pay d on a.username=d.username left join department e on d.department_id=e.id ";
        $query .= " left join user_personal c_r on b.relieve=c_r.username ";
        if($approvername!=''){
             $query .= " left join user_personal c_a on b.approver_id=c_a.username ";
        }
        $query .= " left join user_personal c on a.username=c.username where (a.status='0' OR a.status='3' OR a.status='5') ";
        if($currentOnly=='1'){
			$query .= " and DATE_FORMAT(a.date, '%Y') >= YEAR(CURDATE()) ";
        }
        if($approval_viewStatus==1){
			$query .= " and c.username= '".$logged_username."' ";
		}else if($approval_viewStatus==2){
			$logged_userGroups = getUserGroups($logged_username);
			$query .= " and d.branch_id= '".$logged_userGroups->branch_id."' ";
			$query .= " and d.category_id= '".$logged_userGroups->category_id."' ";
			$query .= " and  d.department_id= '".$logged_userGroups->department_id."' ";
		}else if($approval_viewStatus==3){
			$logged_userGroups = getUserGroups($logged_username);
			$query .= " and d.branch_id= '".$logged_userGroups->branch_id."' ";
		}else if($approval_viewStatus==4){
			$logged_userGroups = getUserGroups($logged_username);
			$all_other_branch_ids = getAllBranchIdsOfStateByBranch($logged_userGroups->branch_id);
			if(is_array($all_other_branch_ids) && count($all_other_branch_ids)>0){
				$array_i = array();
				for($b_id_i = 0; $b_id_i<count($all_other_branch_ids); $b_id_i++){
					$array_i[] = $all_other_branch_ids[$b_id_i]['id'];
				}
				$str_branch_ids = implode(", ",$array_i);
				$query .= " and  d.branch_id IN (".$str_branch_ids.") ";
			}
        }
        if($leaveType!=''){
            $query .= " and  b.type= '".$leaveType."' ";
        }
        if($Status!=''){
            $query .= " and  b.status= '".$Status."' ";
        }
        if($approvername!=''){
            
            $query .= " and (c_a.name like ('".$approvername."%') OR c_a.employee_no like ('".$approvername."%') OR c_a.username like ('".$approvername."%')) ";
           
        }
        if($date!=''){
            $query .= " and  a.date= '".$date."' ";
        }
        if($employeeNo!=''){
            $query .= " and  c.employee_no= '".$employeeNo."' ";
        }
         if($employeeName!=''){
            $query .= " and  c.name= '".$employeeName."' ";
        }
        if($ActiveUserShownStatus=='1'){
			$query .= "and (d.pay_status = '1' or d.pay_status = '0')";
        }
        else{
            $query .= "and d.pay_status = '1'";
        }
        if($branchId!=''){
            $query .= " and  d.branch_id= '".$branchId."' ";
        }
        if($departmentId!=''){
            $query .= " and  d.department_id= '".$departmentId."' ";
        }
         if($categoryId!=''){
            $query .= " and  d.category_id= '".$categoryId."' ";
        }
        
        $query .="and  b.type!= '' order by a.id asc";
        
        $builder = DB::select($query);
		
        $leave_color=getleavecolorarry();
        
		$masterArr=$builder;
		foreach($masterArr as $key=>$val)
		{
            
                $masterArr[$key]->textColor='#ffffff';
                $masterArr[$key]->color=$leave_color[$val->type];
            

			
		}
		
		return $masterArr;

    }

    function getLeaveEntitle($username, $type)
	{
        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
		$SettingLeaveAdjustmentType11 = DB::table('settings')->where('field', "leave_adjustment_type")->first();
        $SettingLeaveAdjustmentType = $SettingLeaveAdjustmentType11->value;
        $experience_check = 0;
        $medicalLeaveProRated11 = DB::table('settings')->where('field', "medical_leave_prorated")->first();
		$medicalLeaveProRated = $medicalLeaveProRated11->value;
		$actual_experience = 0;
		if($SettingLeaveAdjustmentType == 0)
		{
			$query = "select (year(CURDATE()) * 365.24 + month(CURDATE()) * 30.5 + day(CURDATE()))/365.24 - ";
			$query .= "(year(date_commence) * 365.24 + month(date_commence) * 30.5 + day(date_commence)) / 365.24 ";
			$query .= "as experience from user_pay where username='$username'";
			$builder = DB::select($query);
			$experience = intval($builder[0]->experience);
			$actual_experience = $experience;
			$experience_check = 1;
		}elseif($SettingLeaveAdjustmentType == 2)
		{
			$query = "select year(CURDATE()) - year(date_commence)as experience,month(date_commence) as join_month  from user_pay where username='$username'";
			
			$resultArrayVal = DB::select($query);
			
			$actual_experience = $resultArrayVal[0]->experience;
			
			if($resultArrayVal[0]->join_month<=6 && $resultArrayVal[0]->experience>=1){ 
				$experience = $resultArrayVal[0]->experience;
				$experience_check = 0;
			}elseif($resultArrayVal[0]->join_month>6 && $resultArrayVal[0]->experience>=1){ 
				$experience = $resultArrayVal[0]->experience-1;
				$experience_check = 0;
			}else{
				$experience = 0;
				$experience_check = 0;
			}
		}
		else
		{
            $query = "select year(CURDATE()) - year(date_commence) as experience from user_pay where username='$username'";
            $builder = DB::select($query);
            
			$experience = ((intval($builder[0]->experience) > 0)? intval($builder[0]->experience): 0);
			$experience_check = 1;
			$actual_experience = $experience;
		}
		if($SettingLeaveAdjustmentType != 2){
			$builder = DB::select($query);
			$experience = intval($builder[0]->experience);
			$actual_experience = $experience;
		}
		$query = "select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c ";
		$query .= "on b.username=c.username where a.type='".$type."' and a.experience <= $experience + 1 ";
		$query .= " and b.username='".$username."'";
        $builder = DB::select($query);
		$entitle = $builder[0]->no_leaves;
                $actual_entitle = $entitle;
		
		if($type=='Medical' && !$medicalLeaveProRated){
			return $entitle;
			exit;
		}
		
		if($SettingLeaveAdjustmentType==3 && strtolower($type)=='annual'){
			$entitle_value = 0;
			$y_query = "select date_commence from user_pay where username='$username'";
			$y_builder = DB::select($y_query);
			$date_commence = $y_builder[0]->date_commence;
			$joining_timestamp = strtotime($date_commence);
			$joining_year = date('Y',$joining_timestamp);
			$current_year = date('Y');
			
			if($current_year==$joining_year){
				$month_join = date('m',$joining_timestamp);
				if($month_join<12){
					$entitle_value = ((12-$month_join)/12)*$entitle;
				}else{
					$entitle_value = $entitle;
				}
			}else{
				$entitle_value = $entitle;
			}
			return $entitle_value;
		}
		
		if($experience == 0 && $experience_check && $SettingLeaveAdjustmentType!=3)
		{
			$query = "select year(CURDATE()) - year(date_commence) as experience, 12 - month(date_commence) as months from user_pay where username='$username'";
			$expValues = DB::select($query);
			$exp = $expValues[0]->experience;
			$months = intval($expValues[0]->months);
			if($SettingLeaveAdjustmentType==0){
				$months = $months + 1;
			}
			
			if($exp == "0"){
				$entitle = intval($entitle) * $months / 12;
			}
		}
                
                if($SettingLeaveAdjustmentType==4)
		{
                    $new_e = 0;
                    $y_query = "select date_commence from user_pay where username='$username'";
                    $y_builder = DB::select($y_query);
                    $commence_year = $y_builder[0]->date_commence;

                    $year_value = date('Y',strtotime($commence_year));
                    
                    $year_first_date = strtotime(date('Y')."-".$cutOffStartDate."-".$cutOffStartMonth);
                    $year_end_date = strtotime(date('Y')."-".$cutOffMonth."-".$cutOffDate);
                    $today_date = strtotime(date('Y-m-d'));
                    
                    $year_total_days = floor(($year_end_date-$year_first_date)/(60*60*24))+1;
                    
                    $entitle_1_first_days =  floor(($today_date-$year_first_date)/(60*60*24))+1;
                    $entitle_1 = ($entitle_1_first_days/$year_total_days)* $actual_entitle;
                    
                    $entitle_2_first_days =  floor(($year_end_date-$today_date)/(60*60*24))+1;
                    $entitle_2 = ($entitle_2_first_days/$year_total_days)* $actual_entitle;
                    
                    $entitle = $entitle_1 + $entitle_2;
                    
		}
		
		if($SettingLeaveAdjustmentType == 2 && $experience == 0 ){
			$new_e = 0;
			$y_query = "select date_commence from user_pay where username='$username'";
			$y_builder = DB::select($y_query);
			$commence_year = $y_builder[0]->date_commence;
			
			$year_value = date('Y',strtotime($commence_year));
			if($year_value==date('Y')){
				$first_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffStartDate."-".$cutOffStartMonth);
				$second_date = strtotime(date('Y',strtotime($commence_year))."-".$cutOffMonth."-".$cutOffDate);
				$datediff = $second_date - $first_date;
				$year_total_days = floor($datediff/(60*60*24))+1;
				
				$today_date_val = strtotime(date('Y-m-d',strtotime($commence_year)));
				$reamining_days_datediff = $second_date - $today_date_val;
				$reamining_days = floor($reamining_days_datediff/(60*60*24));
				$new_e = ($reamining_days/$year_total_days)*$entitle;
				
			}
			if($year_value<date('Y') && $actual_experience>0){
				$new_e = $entitle;
			}
			$entitle = $new_e;
			
		}
		
		return $entitle;
    }

    function get_local_time(){
        ini_set('allow_url_fopen',1);
        //$ip = file_get_contents("http://ipecho.net/plain");
        $ip = $_SERVER['REMOTE_ADDR'];
        $url = 'http://ip-api.com/json/'.$ip;
        
        $tz = file_get_contents($url);
        $tz = json_decode($tz,true)['timezone'];
    
        return $tz;
    }
    
    function sendSMSToUserFromServer($username, $message)
	{
		$to = getPhoneNo($username);
		if($to!=''){
		    sendSMS($to, $message);
		}
    }
    
    function getPhoneNo($username)
	{
        $phone = DB::table('user_personal')->where('username',$username)->selectRaw("phone_no")->first();
		$emailId = $phone->phone_no;
		return $emailId;
    }
    
    function sendSMS($to, $message)
	{
		$emailSendingStatus1=DB::table('settings')->where('field','email_by_cronjob')->first();
        $smsSettings = getSMSSettings();
        //dd($smsSettings);
		$webUrl = $smsSettings->web_url ?? '';
		$username = $smsSettings->user_id ?? '';
		$password = $smsSettings->password ?? '';
		gw_send_sms($username, $password, $webUrl, $to, $message);
    }
    
    function getSMSSettings()
    {
            $query = DB::table('settings')->selectRaw("(select value from settings where field='sms_web_url') as web_url, (select value from settings where field='sms_user_id') as user_id, (select value from settings where field='sms_password') as password")->first();
            $result = $query;
            return $result;
    }

    function gw_send_sms($user, $pass, $sms_from, $sms_to, $sms_msg)  
    {           
	    $query_string = "api2.aspx?apiusername=".$user."&apipassword=".$pass;
	    $query_string .= "&senderid=".rawurlencode($sms_from)."&mobileno=".rawurlencode($sms_to);
	    $query_string .= "&message=".rawurlencode(stripslashes($sms_msg)) . "&languagetype=1";        
	    $url = "http://gateway80.onewaysms.com.my/".$query_string;
                     $fd = @implode ('', file ($url));      
	    if ($fd)  
	    {                       
		    if ($fd > 0)
		    {
				$ok = "success";
		    }        
		    else
		    {
				$ok = "fail";
		    }
        }           
        else      
        {                       
            $ok = "fail";       
        }           
        return $ok;  
    } 

    function diff($start,$end = false) {
		if(!$end) { $end = time(); }
		if(!is_numeric($start) || !is_numeric($end)) { return false; }
		$start  = date('Y-m-d H:i:s',$start);
		$end    = date('Y-m-d H:i:s',$end);
		$d_start    = new DateTime($start);
		$d_end      = new DateTime($end);
		$diff = $d_start->diff($d_end);
		$val['year']    = $diff->format('%y');
		$val['month']    = $diff->format('%m');
		$val['day']      = $diff->format('%d');
		$val['hour']     = $diff->format('%h');
		$val['min']      = $diff->format('%i');
		$val['sec']      = $diff->format('%s');
		$val['invert']      = $diff->invert;
		return $val;
	} 
   

    function hasContentPreference($username)
    {
            $query = "select employee_id from email_content_preferences where employee_id='$username'";
			$user1 = DB::select($query);
			$user = $user1;
            if(empty($user))
                    return FALSE;
            else
                    return TRUE;
	}
    
    function getUserCategory($username)
	{
		$builder = DB::table('user_category')->where('username',$username)->first();
		$result = $builder->category;
		return $result;
    }
    
    function getLeaveNameByType($type="Annual"){
		$result = DB::table('leave_name')->where('type',$type)->first();
		return $result->name;
    }
    
      function sendEmailNow(){
            
		$all_pending_email_users = DB::table('pending_emails')->where('sent_status',0)->selectRaw("distinct(email_to),`emp_name`,leave_status,leave_username")->get();
		    
		        $branchEmailInfo = [];
                $topMgtEmailInfo = [];
                  $deptEmailInfo= [];
		if(count($all_pending_email_users) > 0) {
        		for($i=0;$i<count($all_pending_email_users);$i++){
        			
        			$all_pending_email = DB::table("pending_emails")->where('sent_status',0)->where('email_to',$all_pending_email_users[$i]->email_to)->get();
        			
        			$subject = "Leave Status";
        			
        			
        			
        			if(($all_pending_email_users[$i]->leave_status=='recommended' || $all_pending_email_users[$i]->leave_status=='Cancellation Pending') || ($all_pending_email_users[$i]->email_to!=$all_pending_email_users[$i]->leave_username && $all_pending_email_users[$i]->leave_status=="")){
						$uname = UserPersonal::where('username',$all_pending_email_users[$i]->email_to)->first();
        				$_name_val = $uname->name ?? '';
        				$body = "Dear ".$_name_val.", <br /><br />";
        				$body .= "Following leave pending for your action : <br/><br />";
        			}else{
        				$body = "Dear ".$all_pending_email_users[$i]->emp_name.", <br /><br />";
        				$body .= "Your Leave Status : <br/><br />";
        			}
        			$body .= "<table>";
        			$body .= "<tr>";
        			if($all_pending_email_users[$i]->leave_status=='recommended' || $all_pending_email_users[$i]->leave_status=='Cancellation Pending'){
        				$body .= "<td width='100'><strong>Employee</strong></td>";
        			}
        			$body .= "<td width='100'><strong>From Date</strong></td>";
        			$body .= "<td width='100'><strong>To Date</strong></td>";
        			$body .= "<td width='200'><strong>Leave Type</strong></td>";
        			$body .= "<td width='100'><strong>Reason</strong></td>";
        			$body .= "<td width='100'><strong>Status</strong></td>";
        			if($all_pending_email_users[$i]->leave_status!='approved'){
        				$body .= "<td width='100'><strong>Link</strong></td>";
        			}
        			$body .= "</tr>";
        			$inner_body = "";
        			for($j=0;$j<count($all_pending_email);$j++){
        				pendingEmailStatusUpdate($all_pending_email[$j]->id,'1');
        				$body .= $all_pending_email[$j]->email_body;
                                        
                                        $re = "/>.*?(?=<td>)<td>\\K.*?(?=<\\/td>)/s";
                                        preg_match_all($re, $all_pending_email[$j]->email_body, $matches);
                                        $new_inner_body = "<tr>";
                                        for($_m_i=0;$_m_i<count($matches[0]);$_m_i++){
                                            if($_m_i!=3){
                                                $new_inner_body .= "<td>".$matches[0][$_m_i]."</td>";
                                            }
                                        }
                                        $new_inner_body .= "</tr>";
                                        
        				$inner_body .= $new_inner_body;
        			}
        			$body .= "</table><br /><br />";
        			
        			$body .= "Kind regards,<br />";
        			$body .= "Note, this is an automatic email. Please do not reply. <br />";
        			$body .= "If you did not request this information, please ignore this message. <br />";
        			$body .= "If you have any questions, please contact us<br />";
        			
        			if(count($all_pending_email)>0){
                        $uname = UserPersonal::where('username',$all_pending_email_users[$i]->email_to)->first();
                        if(isset($uname->email_id)){
                            sendemail($uname->email_id,$subject,$body);
						
                        }
						//Mail::to($uname->email_id)->send(new MyDemoMail($body,$subject));
				// 		$details['email_id'] = $uname->email_id;
				//         $details['subject'] = $subject;
				//         $details['body'] = $body;
				    
    //                     SendEmailJob::dispatch($details);
						
						
        				$AllowEmailSentToAll1 = DB::table('settings')->where('field' , "email_status_sent_to_all")->first();
           				$AllowEmailSentToAll = $AllowEmailSentToAll1->value;
        				
        				if($all_pending_email_users[$i]->leave_status=='approved' && $AllowEmailSentToAll){ 
                                            $branch_info = getBranchByUsername($all_pending_email_users[$i]->email_to);
                                            if(!$branch_info->isEmpty()){
                                               
                                                $branch_id = $branch_info[0]->email;
                                            }else{
                                                
                                                $branch_id = '';
                                            }
                                          
                                            
                                        
                                            $re = "/>.*?(?=<td>)<td>\\K.*?(?=<\\/td>)/s";
                                            preg_match_all($re, $inner_body, $b_matches);
                                            
                                            $branch_new_inner_body = "<tr>";
                                            $_t_j=0;
                                            for($_m_i=0;$_m_i<count($b_matches[0]);$_m_i++){
                                                
                                                $_t_j++;
                                                if($_t_j==1){
                                                    $branch_new_inner_body .= "<td>".$all_pending_email_users[$i]->emp_name."</td>";
                                                }
                                                $branch_new_inner_body .= "<td>".$b_matches[0][$_m_i]."</td>";
                                                if($_t_j==4){
                                                    $_t_j = 0;
                                                    $branch_new_inner_body .= "</tr><tr>";
                                                }
                                            }
                                            $branch_new_inner_body .= "</tr>"; 
                                            //$branch_new_inner_body = substr($branch_new_inner_body, 0, -4);
                                            
                                            if(array_key_exists($branch_id, $branchEmailInfo)){
                                                $exist_ar = $branchEmailInfo[$branch_id];
                                                
                                                $_updated_inner_body = $exist_ar['inner_body'].$branch_new_inner_body;
                                                $exist_ar['inner_body'] = $_updated_inner_body;
                                                
                                                $branchEmailInfo[$branch_id] = $exist_ar;
                                            }else{
                                                //$all_pending_email_users[$i]['emp_name']
                                                
                                                $ar = array("subject"=>$subject, "inner_body"=>$branch_new_inner_body);
                                                //echo $all_pending_email_users[$i]['email_to']." Branch id = ".$branch_id." <br />";
                                                $branchEmailInfo[$branch_id] = $ar;
                                            }
                                            
                                            //$topMgtEmailInfo
                                            $leave_username = $all_pending_email_users[$i]->leave_username;
                                            
                                            $in_mgt_email1=DB::table('user_pay as up')->leftjoin('category as c','c.id','=','up.category_id')->where('up.username',$leave_username)->select('c.in_mgt_email as memail','c.email')->first();
                                            $in_mgt_email = $in_mgt_email1->memail;
                                            
                                            if($in_mgt_email=="1"){
                                                $topMgtEmailInfo[] = $branch_new_inner_body;
                                            }
                                            
                                            $in_mgt_email11=DB::table('user_pay as up')->leftjoin('department as d','d.id','=','up.department_id')->where('up.username',$leave_username)->select('d.email')->first();
                                            $deptEmailInfo[] = $branch_new_inner_body;
        				}else{
                                        
                                        }
        				
        			}
        		}
        		
        		SendEmailToDept($deptEmailInfo,isset($in_mgt_email11->email) ? $in_mgt_email11->email: '');
                SendEmailToTopMgt($topMgtEmailInfo,isset($in_mgt_email1->email) ? $in_mgt_email1->email : '');
                SendEmailToBranchHeads($branchEmailInfo);
		}
    }
    
    function pendingEmailStatusUpdate($id,$status){

		$query = "update pending_emails set sent_status='$status' where id='$id'";
		$result1 = DB::select($query);
		$result = $result1;
		return $result;

    }
    
    function SendEmailToDept($deptEmailInfo,$in_mgt_email){
        $subject = "Leave Status";
		if(count($deptEmailInfo)>0 && $in_mgt_email!='' && $in_mgt_email!=null){
			$body = "";
			$body .= "Leave Status : <br/><br />";
			$body .= "<table>";
			$body .= "<tr>";
			$body .= "<td width='100'><strong>User</strong></td>";
			$body .= "<td width='100'><strong>From Date</strong></td>";
			$body .= "<td width='100'><strong>To Date</strong></td>";
			$body .= "<td width='200'><strong>Leave Type</strong></td>";
			$body .= "<td width='100'><strong>Status</strong></td>";
			$body .= "</tr>";
			for($i=0;$i<count($deptEmailInfo);$i++){
				$body .= $deptEmailInfo[$i];
			}
			
			$body .= "</table><br /><br />";

			$body .= "Kind regards,<br />";
			$body .= "Note, this is an automatic email. Please do not reply. <br />";
			$body .= "If you did not request this information, please ignore this message. <br />";
			$body .= "If you have any questions, please contact us<br />";
			if(ValidateEmail($in_mgt_email)){
			    sendemail($in_mgt_email,$subject,$body);
			}
		}
    }
    
    function SendEmailToTopMgt($topMgtEmailInfo,$in_mgt_email){
        $top_mgt_email1 = DB::table('settings')->where('field' , "top_mgt_email")->first();
        $top_mgt_email = $top_mgt_email1->value;
        $top_mgt_email = $in_mgt_email;
		$subject = "Leave Status";
		
		if(count($topMgtEmailInfo)>0 && $top_mgt_email!='' && $top_mgt_email!=null){
			$body = "";
			$body .= "Leave Status : <br/><br />";
			$body .= "<table>";
			$body .= "<tr>";
			$body .= "<td width='100'><strong>User</strong></td>";
			$body .= "<td width='100'><strong>From Date</strong></td>";
			$body .= "<td width='100'><strong>To Date</strong></td>";
			$body .= "<td width='200'><strong>Leave Type</strong></td>";
			$body .= "<td width='100'><strong>Status</strong></td>";
			$body .= "</tr>";
			for($i=0;$i<count($topMgtEmailInfo);$i++){
				$body .= $topMgtEmailInfo[$i];
			}
			
			$body .= "</table><br /><br />";

			$body .= "Kind regards,<br />";
			$body .= "Note, this is an automatic email. Please do not reply. <br />";
			$body .= "If you did not request this information, please ignore this message. <br />";
			$body .= "If you have any questions, please contact us<br />";
			//Mail::to($top_mgt_email)->send(new MyDemoMail($body,$subject));
			if(ValidateEmail($top_mgt_email)){
			    sendemail($top_mgt_email,$subject,$body);
			 //   $details['email_id'] = $top_mgt_email;
				// $details['subject'] = $subject;
				// $details['body'] = $body;
				    
    //             SendEmailJob::dispatch($details);
			}
			//Email::sendEmail($top_mgt_email, $subject, $body);
		}
		
		
    }
    
    function SendEmailToBranchHeads($branchEmailInfo){
		
		$branch_permission1 = DB::table('settings')->where('field' , "approve_email_to_branch")->first();
		$branch_permission = $branch_permission1->value;
		if($branch_permission==1){
			
			if(count($branchEmailInfo)>0){
                $subject = "Leave Status";
                
				foreach($branchEmailInfo as $key=>$value){
				    $body = "";
					$body .= "Leave Status : <br/><br />";
					$body .= "<table>";
					$body .= "<tr>";
					$body .= "<td width='100'><strong>User</strong></td>";
					$body .= "<td width='100'><strong>From Date</strong></td>";
					$body .= "<td width='100'><strong>To Date</strong></td>";
					$body .= "<td width='200'><strong>Leave Type</strong></td>";
					$body .= "<td width='100'><strong>Status</strong></td>";
					$body .= "</tr>";

					$body .= $branchEmailInfo[$key]['inner_body'];
					$body .= "</table><br /><br />";

					$body .= "Kind regards,<br />";
					$body .= "Note, this is an automatic email. Please do not reply. <br />";
					$body .= "If you did not request this information, please ignore this message. <br />";
					$body .= "If you have any questions, please contact us<br />";
                    
                   if(ValidateEmail($key)){
                       
                        if($key!=''){
                            //Mail::to($key)->send(new MyDemoMail($body,$subject));
                            sendemail($key,$subject,$body);
                            // dd($key,$body,$subject);
                   
                //             $details['email_id'] = $key;
				            // $details['subject'] = $subject;
				            // $details['body'] = $body;
				    
                //             SendEmailJob::dispatch($details);
                        }
                    } 
					//Email::sendEmail($key, $subject, $body);
				}
			}
		}
	
	}

    function ValidateEmail($key)
    {
        $email = test_input($key);
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
          return false;
        }
        return true;
    }

    function test_input($data) {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }
    function getBranchByUsername($username){
		
		$result1 = DB::table('branch as b')->leftjoin('user_pay as up','up.branch_id','=','b.id')->selectRaw("b.*")->where('up.username',$username)->get();
		$result = $result1;
		return $result;
		
    }
    
    function getApproversOfEmployee($employeeId)
	{
		$result1 = DB::table('map_employee_approver as a')->leftjoin('user_personal as b','a.approver_id','=','b.username')->where('a.employee_id',$employeeId)->selectRaw("distinct a.approver_id as username, b.name")->orderBy('a.approver_index','asc')->get();
		$result = $result1;
		return $result;
    }
    
    function unMarkReplacementLeaveAsTaken($username,$year="")
	{
		if($year!=""){
			$query = "select min(id) as mid from leave_adjustment where employee_id='".$username."' and taken_stat=1 and year(start_date)='".$year."'";
		}else{
			$query = "select min(id) as mid from leave_adjustment where employee_id='".$username."' and taken_stat=1";
		}
        $minId=DB::select($query);
        $mid=0;
        if(!empty($minId)){
            $mid=$minId[0]->mid;
        }
        
        if($mid!=0){
            $leaves = LeaveAdjustment::where('id', $mid)->first();
            $leaves->taken_stat = "0";
            $leaves->save();
        }

    }
    
    function markReplacementLeaveAsTaken($username , $year='', $startDate='CURDATE()')
	{
        $users11=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
            if($year==''){
                $year = date('Y');
            }
            
            
            if($startDate=="CURDATE()"){
                $f_query = "select case when DATEDIFF(DATE_ADD(start_date, INTERVAL (SELECT `value` FROM `replacement_duration` where `category_name`='".$usercat->category."' and `company_id`='".$users11->company_id."') DAY), CURDATE()) >0 then 0 ELSE 1 END isforfeit ,";
            }else{
                $f_query = "select case when DATEDIFF(DATE_ADD(start_date, INTERVAL (SELECT `value` FROM `replacement_duration` where `category_name`='".$usercat->category."' and `company_id`='".$users11->company_id."') DAY),'".$startDate."') >0 then 0 ELSE 1 END isforfeit ,";
            }
            $f_query .= "no_granted,id from leave_adjustment where employee_id='".$username."' and year(start_date)='".$year."' and taken_stat=0 having isforfeit=1";
            
            $result = DB::select($f_query);
            
            $ids = array();
            for($i=0;$i<count($result);$i++){
                //dd($result[$i]->id);
                array_push($ids, $result[$i]->id);
            }
            
            $id_str = implode(",",$ids);
            
            $query = "select min(id) as mid from leave_adjustment where employee_id='".$username."' and taken_stat=0  and year(start_date)='".$year."' ";
            if($id_str!=''){
                $query .= " and id NOT IN (".$id_str.")";
            }
            
            $minId = DB::select($query);
            //dd($minId);
           // dd($query);
            if($minId[0]->mid!=''){
            $leaves = LeaveAdjustment::where('id', $minId[0]->mid)->first();
            $leaves->taken_stat = "1";
            $leaves->save();
             return $minId[0]->mid;
            }
            else{
                return '';
            }
           
    }
    
    function add_date($givendate,$day=0,$mth=0,$yr=0)
	{
		$cd = strtotime($givendate);
		$newdate = date('Y-m-d', mktime(date('h',$cd), 
			date('i',$cd), date('s',$cd), date('m',$cd)+$mth, 
			date('d',$cd)+$day, date('Y',$cd)+$yr));
		return $newdate;
    }
    
    function dateDifference($startDate, $endDate)
    {
        $startDate = strtotime($startDate);
        $endDate = strtotime($endDate);
        return $startDate - $endDate;
    }
    
    function hasHRAccess()
	{
        $user = User::where('id' , Auth::id())->first();
		if(getPermissionValue("hr", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    function hasApprovalAccess()
	{
        $user = User::where('id' , Auth::id())->first();
		if(getPermissionValue("approval", $user->username) > 0)
			return TRUE;
		return FALSE;
	}
	
	function getHRAccess()
	{
        $user = User::where('id' , Auth::id())->first();
		return getPermissionValue("hr", $user->username);
	}
	
	function getPermissionValueString($group, $username)
	{
		$query = DB::table('map_employee_permission as a')->leftjoin('permission_group as b','a.permission_group_id','=','b.id')->where('a.employee_id', "$username")->select("b.".$group)->first();
        //dd($query);
        $result = $query->$group ?? null;
        //dd($result);
        return $result;
	}


    function hasRLMenuAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("rl_allow", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    function hasSettingsAccess()
	{
        $user = User::where('id' , Auth::id())->first();
		return getPermissionValue("settings", $user->username);
	}
	
	function getSelfRepleasementLeave($username,$year){
        $user = User::where('id' , Auth::id())->first();
        
        $ActiveUserShownStatus11=DB::table('settings')->where('field','active_user_shown')->where('company_id',$user->company_id)->first();
        $ActiveUserShownStatus='';
        if(!empty($ActiveUserShownStatus11)){
            $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
        }
        $currentOnly11 =DB::table('settings')->where('company_id',$user->company_id)->where('field','only_current_year_leave_display')->first();
        $currentOnly='';
        if(!empty($currentOnly11)){
            $currentOnly = $currentOnly11->value;
        }
        $currentUser = $user->username;
        //echo $currentUser;
       
        $query1=DB::table('rl_leaves as a')->leftjoin('user_personal as b','a.employee_id','=','b.username')->leftjoin('user_pay as c','a.employee_id','=','c.username')->leftjoin('branch as d','c.branch_id','=','d.id')->leftjoin('department as e','c.department_id','=','e.id')->leftjoin('category as f','c.category_id','=','f.id')->leftjoin('map_employee_approver as map','a.employee_id','=','map.employee_id')->selectRaw("a.id, a.approver_id, a.employee_id, b.employee_no, b.name, d.name as branch, e.name as department, f.name as category, DATE_FORMAT(a.start_date, '%d/%m/%Y') as start_date, a.end_date, a.no_days, sum(a.no_granted) as no_granted,  DATE_FORMAT(a.date_applied, '%d/%m/%Y') as date_applied, a.reason,a.leave_status as `status`, 0 as is_hourly, 0 as no_hours");
        if($currentOnly=='1'){
            $query1->whereRaw("DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE())");
        }
        if($year!='' && $year!=0){
            $query1->whereRaw("DATE_FORMAT(a.start_date, '%Y') = '".$year."' ");
        }
        if($ActiveUserShownStatus=='1'){
            $query1->whereRaw("(c.pay_status = '1' or c.pay_status = '0')");
        }
        else{
            $query1->where('c.pay_status',1);
        }
        if($username!=""){
            $query1->where('a.employee_id',$username);
        }
        if($username==''){
            $query1->where('map.approver_id',$currentUser);
        }
        $_q1=$query1->groupBy('a.id');


        $query2 = DB::table('leave_adjustment as 1adj')->leftjoin('user_personal as lb','1adj.employee_id','=','lb.username')->leftjoin('user_pay as lc','1adj.employee_id','=','lc.username')->leftjoin('branch as ld','lc.branch_id','=','ld.id')->leftjoin('department as le','lc.department_id','=','le.id')->leftjoin('category as lf','lc.category_id','=','lf.id')->leftjoin('map_employee_approver as 1map','lb.employee_no','=','1map.employee_id')->selectRaw("1adj.id as id, 1adj.employee_id, '-' as approver_id, lb.employee_no, lb.name, ld.name as branch, le.name as department, lf.name as category,  DATE_FORMAT(1adj.start_date, '%d/%m/%Y') as start_date, 1adj.end_date, 1adj.no_days, sum(1adj.no_granted) as no_granted, DATE_FORMAT(1adj.date_applied, '%d/%m/%Y') as date_applied, 1adj.reason,'approved' as `status`, 1adj.is_hourly, 1adj.no_hours ")->whereRaw("1");
        
        if($currentOnly=='1'){
            $query2->whereRaw("DATE_FORMAT(1adj.start_date, '%Y') = YEAR(CURDATE())");
        }
        
        if($year!='' && $year!=0){
            $query2->whereRaw("DATE_FORMAT(1adj.start_date, '%Y') = '".$year."'");
                
        }
        
        if($username==""){
            $query2->where('1map.approver_id',$currentUser);
        }
        if($ActiveUserShownStatus=='1'){
            $query2->whereRaw("(lc.pay_status = '1' or lc.pay_status = '0')");
        }
        else{
            $query2->where('lc.pay_status',1);
        }
       
        if($username!=""){
            $query2->where('1adj.employee_id',$username);
        }
        $_q2 = $query2->groupByRaw("1adj.employee_id,1adj.start_date")->union($_q1)->get();
        return $_q2;
    }
    
   
 function getRLeaveList($username){
        $user = User::where('id' , Auth::id())->first();
        
        $ActiveUserShownStatus11=DB::table('settings')->where('field','active_user_shown')->where('company_id',$user->company_id)->first();
        $ActiveUserShownStatus='';
        if(!empty($ActiveUserShownStatus11)){
            $ActiveUserShownStatus = $ActiveUserShownStatus11->value;
        }
        $currentOnly11 =DB::table('settings')->where('company_id',$user->company_id)->where('field','only_current_year_leave_display')->first();
        $currentOnly='';
        if(!empty($currentOnly11)){
            $currentOnly = $currentOnly11->value;
        }
        $currentUser = $user->username;
        
        $result=DB::table('rl_leaves as a')->leftjoin('user_personal as b','a.employee_id','=','b.username')->leftjoin('user_pay as c','a.employee_id','=','c.username')->leftjoin('branch as d','c.branch_id','=','d.id')->leftjoin('department as e','c.department_id','=','e.id')->leftjoin('category as f','c.category_id','=','f.id')->selectRaw(" a.id, a.approver_id, a.employee_id, b.employee_no, b.name, d.name as branch, e.name as department, f.name as category, DATE_FORMAT(a.start_date, '%d/%m/%Y') as start_date, a.end_date, a.no_days, sum(a.no_granted) as no_granted,  DATE_FORMAT(a.date_applied, '%d/%m/%Y') as date_applied, a.reason, b.username");
        if($currentOnly=='1'){
            $result->whereRaw(" DATE_FORMAT(a.start_date, '%Y') = YEAR(CURDATE())");
        }
        if($ActiveUserShownStatus=='1'){
            $result->whereRaw(" (c.pay_status = '1' or c.pay_status = '0')");
        }
        else{
            $result->where('c.pay_status',1);
        }
        $results=$result->where('a.approver_id',$username)->groupBy('a.id')->get();
		
		
		return $results;
    }
    
    function getstatebybranch($id)
	{
		$ids = DB::table('branch')->where('id',$id)->get();
		if(count($ids)>0){
			return $ids[0]->state;
		}else{
			return '';
		}
    }

    function getbranchbystate($state)
	{
		
		$ids = DB::table('branch')->where('state',$state)->get();
		if(count($ids)>0){
			$d = '';
			foreach($ids as $id){
				$d.=$id->id.',';
			}
			$d = rtrim($d,',');
			return $d;
		}else{
			return '';
		}
	}
	
	function getPermissionGroupOfEmployee(){
        $user = User::where('id' , Auth::id())->first();
        $employeeId=$user->username;
        $result=DB::table('map_employee_permission as a')->leftjoin('permission_group as b','a.permission_group_id','=','b.id')->where('a.employee_id',$employeeId)->selectRaw("b.id as permission_id, b.type, b.group_name, b.eleave, b.eclaim, b.epay, b.approval, b.hr, b.hr_applysubordinate, b.settings, b.view_leave, b.approver_menu, b.eleave_menu, b.duty_rostere_viewe ")->first();
       
		return json_encode($result);

    }

	
	function getValue($val){
        $near_int = floor($val);
        if($near_int > 0){
            $rem = fmod($val, $near_int);
        }else{
            $rem = $val;
        }
        
        // dd($rem);
        //$rem = 13.76%13;
        //return $rem;
        if($rem == 0){
            return $val;
        }
        //var_dump(floor($val));exit;
        //dd($rem);
        if($rem <= 0.24){
            //dd(floor($val));
            return floor($val);
        }elseif($rem > 0.24 && $rem <= 0.74){
            return (double)(floor($val).".5");
        }elseif($rem > 0.74 && $rem < 1){
            return round($val);
        }
    }


    function sendemail($to,$subject,$body,$auth=''){
        
        if($auth==''){
            $user = User::where('id' , Auth::id())->first();
            
        }
        else{
            $user = User::where('username', $auth)->first();
           
        }
        
       $email_email_id=DB::table('settings')->where('field','email_email_id')->first();
       $email_sender_name=DB::table('settings')->where('field','email_sender_name')->first();
       $uname=$email_sender_name->value;
       $uemail=$email_email_id->value;
       $sender = "$uname <$uemail>";
       //$emailSettings = DB_Settings::getEmailSettings();
       $headers = 'From: '.$sender."\r\n";
       $headers .= 'Reply-To: '.$sender.' '. "\r\n";
       $headers .= "Return-Path: ".($uemail) . "\r\n";
       $headers .= "MIME-Version: 1.0\r\n";
       $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
       $headers .= "X-Priority: 3\r\n";
       $headers .= 'X-Mailer: PHP/' . phpversion();
       mail($to , $subject , $body, $headers);
       
       //var_dump($val);

               
        }

    function getcompanylogo(){
        
        $result = DB::table('details')->where('field','company_logo')->first();
       // dd($result);
		return $result->v4_value;
	
    }
    
    function getemail(){
        $result = DB::table('user_personal')->where('username',session()->get('otpusername'))->first();
        return $result->email_id;
    }

    function getpermissiongroup(){
        $user = User::where('id' , Auth::id())->first();
        $result = DB::table('map_employee_permission')->leftjoin('permission_group','permission_group.id','=','map_employee_permission.permission_group_id')->where('employee_id',$user->username)->first();
        return $result->group_name ?? '';
    }


    function hasEClaimAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("eclaim", $user->username) > 0)
			return TRUE;
		return FALSE;
    }

function hasEattendanceAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("e_attendance", $user->username) > 0)
			return TRUE;
		return FALSE;
    }


    function EattendanceDashboardRoute(){
        if(hasEattendanceHRAccess()){
            return 'dashboardHr';
        }else{
            return 'dashboardEmp';
        }
    }


    function hasEattendanceEmployeeAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("emp_e_attndnc", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    function hasEattendanceAuditAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("attendance_audit", $user->username) > 0)
			return TRUE;
		return FALSE;
    }

    function hasEclaimAuditAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("eclaim_audit", $user->username) > 0)
			return TRUE;
		return FALSE;
    }

    function hasEleaveAuditAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("leave_audit", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    
    function getUserName($id){
       $user = UserPersonal::select('username')->where('employee_no' ,$id)->first();
        return $user->username;
    }
    
    function getNameByUserName($id){
        $user = UserPersonal::select('name')->where('username' ,$id)->first();
        if(isset($user)){
            return $user->name;
        }else{
            return NULL;
        }
    }
    
    function getUserNameById($id){
        $users = DB::table('users')->select('username')->where('id' ,$id)->first();
        $user = UserPersonal::select('name')->where('username' ,$users->username)->first();
        return $user->name;
    }
    
    
       function getEmpNo(){
       $user = User::select('user_personal.employee_no')->join('user_personal','user_personal.username', '=', 'users.username')->where('users.id' , Auth::id())->first();
        return $user->employee_no;
    }
 function getScheduleName($id){
        $scheduleName = Schedule::select('name')->find($id);
       return $scheduleName->name;
    }
    
    // approval e-att
    function hasEattendanceApprovalAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("approval_ot", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    function hasEattendanceHRAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("admin_e_attndnc", $user->username) > 0)
			return TRUE;
		return FALSE;
    }


        function hasEattendanceEditAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("edit_attendance", $user->username) > 0)
			return TRUE;
		return FALSE;
    }


    function hasEPayAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("epay", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    function hasGlobalSearchAccess(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("global_search", $user->username) > 0)
			return TRUE;
		return FALSE;
    }
    
    function hasGlobalSearchAccess11(){
        $user = User::where('id' , Auth::id())->first();
        if(getPermissionValue("global_search", $user->username) > 0)
			return getPermissionValue("global_search", $user->username);
		return FALSE;
    }

    function filterData(&$str){ 
        $str = preg_replace("/\t/", "\\t", $str); 
        $str = preg_replace("/\r?\n/", "\\n", $str); 
        if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"'; 
    } 
    
    function getUserBranchId($username)
	{
		$builder = DB::table('user_pay')->where('username',$username)->selectRaw("branch_id")->first();
		$result = $builder->branch_id;
		return $result;
    } 
    
    function getstaticmsg()
	{
	    $result=DB::table('details')->where('field','broadcast_msg')->first();
	    //dd($result);
	    return $result->v4_value;
	}

    function getapprovername($username){
	    $result=DB::table('user_personal')->whereRaw("username='".$username."'")->pluck("user_personal.name")->first();
	    return $result;
	}


 function getYearWiseFixLeaveEntitleQueryReturn($username, $type="Annual", $currentDate, $als=''){
        $cutOffMonth11 = DB::table('settings')->where('field', "cut_of_month")->first();
        $cutOffMonth = $cutOffMonth11->value;
        $cutOffDate11 = DB::table('settings')->where('field', "cut_of_date")->first();
        $cutOffDate=$cutOffDate11->value;
        $cutOffStartDate11 = DB::table('settings')->where('field', "cut_of_startdate")->first();
        $cutOffStartDate=$cutOffStartDate11->value;
        $cutOffStartMonth11 = DB::table('settings')->where('field', "cut_of_startmonth")->first();
        $cutOffStartMonth=$cutOffStartMonth11->value;
        $SettingLeaveAdjustmentType= DB::table('settings')->where('field', "leave_adjustment_type")->first();
        
        $_check_year = date('Y',strtotime($currentDate));
        $cutOffStartYear = $_check_year;
        $cutOffYear = $_check_year;
            if($cutOffStartMonth!=1){
                if($cutOffStartMonth > date('m')){
                    $cutOffStartYear = $_check_year;
                    $cutOffYear = $_check_year;
                }else{
                    $cutOffStartYear = $_check_year-1;
                    $cutOffYear = $_check_year;
                }
            }else{
                $cutOffStartYear = $_check_year;
                $cutOffYear = $_check_year;
            }
           
            if($SettingLeaveAdjustmentType->value == 6){
                $date_for_query = "CURDATE()";
                
                $year_for_check = date('Y');
                $year_for_check = date("Y",  strtotime($currentDate));
                if($year_for_check!=""){
					
                    if($year_for_check == date('Y')){
                        $curr_date = date($year_for_check.'-m-d');
                    }else {
                        $curr_date = ($year_for_check) . "-".$cutOffMonth."-".$cutOffDate;
                    }
                    
                }else{
                    $curr_date = date('Y-m-d');
                }
                $_d = date("Y",  strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                
                $query ="(SELECT TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as experience from user_pay where username=user_personal.username) as ".$als."ExperienceInYear6, (SELECT TIMESTAMPDIFF(DAY, date_commence," . $date_for_query . ") as experience from user_pay where username=user_personal.username) as ".$als."days_difference6,(select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= ".$als."ExperienceInYear6+1  and b.username=user_personal.username ) as ".$als."entitle_year_base6, (SELECT DAYOFYEAR('" . $year_for_check . "-12-31')) as ".$als."currentYearTotalDays, (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%Y') = ".$year_for_check." THEN (SELECT round(((".$als."days_difference6/".$als."currentYearTotalDays)*".$als."entitle_year_base6)*2)/2 ) ELSE (SELECT entitle_year_base6) END) as ".$als."annualentitle , (SELECT TIMESTAMPDIFF(YEAR, date_commence," . $curr_date . ") as ".$als."experience from user_pay where username=user_personal.username) as ".$als."actual_ExperienceInYear, (SELECT FLOOR( TIMESTAMPDIFF( DAY, date_commence, " . $curr_date . " ) % 30.4375 ) as ".$als."days from user_pay where username=user_personal.username) as ".$als."dayss, (SELECT TIMESTAMPDIFF( MONTH, date_commence, " . $curr_date . " ) % 12 as ".$als."month from user_pay where username=user_personal.username) as ".$als."months, (CASE WHEN (SELECT dayss) > 0 AND  unix_timestamp(user_pay.date_commence) =  unix_timestamp( " . $curr_date . ")   THEN (SELECT ".$als."actual_ExperienceInYear)+1 ELSE (CASE WHEN (SELECT ".$als."actual_ExperienceInYear)=0 AND (SELECT ".$als."months) > 0 THEN 1 WHEN (SELECT ".$als."actual_ExperienceInYear)=0 AND (SELECT ".$als."dayss) > 0 THEN 1 ELSE (SELECT ".$als."actual_ExperienceInYear) END) END) as ".$als."ExperienceInYear61,(select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= ".$als."ExperienceInYear61  and b.username=user_personal.username ) as ".$als."annualEntitle13, (CASE WHEN (SELECT ".$als."actual_ExperienceInYear) > 0 THEN (SELECT ".$als."annualEntitle13) ELSE (select ".$als."annualentitle) END)as ".$als."entitle";
                return $query;
            }
            elseif($SettingLeaveAdjustmentType->value == 7){
                
                $_d = $cutOffStartYear."-".$cutOffStartMonth."-".$cutOffStartDate;
                $_d1 = $cutOffYear."-".$cutOffMonth."-".$cutOffDate;
                $date_for_query = "'".$_d."'";
                $date_for_query1 = "'".$_d1."'";
                $year_for_check = date("Y",  strtotime($currentDate));
                $yearStart = mktime(0, 0, 0, 1, 1,  $year_for_check);
                $yrr = date('Y');

                $query = "(SELECT TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as ".$als."experience from user_pay where username=user_personal.username) as ".$als."first_experience, (SELECT TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query1 . ") as ".$als."experience from user_pay where username=user_personal.username) as ".$als."second_experience, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= ".$als."first_experience+1  and b.username=user_personal.username ) as ".$als."entitle_before, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= ".$als."second_experience+1  and b.username=user_personal.username ) as ".$als."entitle_after, (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%m') >= " . $cutOffStartMonth . " THEN (SELECT DATEDIFF(CONCAT('" . $cutOffStartYear . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))," . $date_for_query . ")) ELSE (SELECT DATEDIFF(CONCAT('" . $year_for_check . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))," . $date_for_query . "))  END) as ".$als."ExperienceInDaysBefore, (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%m') >= " . $cutOffStartMonth . " THEN (SELECT DATEDIFF(" . $date_for_query1 . ",CONCAT('" . $cutOffStartYear . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')))) ELSE (SELECT DATEDIFF(" . $date_for_query1 . ",CONCAT('" . $year_for_check . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))))  END) as ".$als."ExperienceInDaysAfter, (SELECT (".$als."ExperienceInDaysBefore/365)*".$als."entitle_before) as ".$als."entitle_before_new, (SELECT (".$als."ExperienceInDaysAfter/365)*".$als."entitle_after) as ".$als."entitle_after_new, 
                (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%m') >= " . $cutOffStartMonth . " THEN (SELECT DATEDIFF(" . $date_for_query1 . ",CONCAT('" . $cutOffStartYear . "', DATE_FORMAT(user_pay.date_resigned, '-%m-%d')))) ELSE (SELECT DATEDIFF(" . $date_for_query1 . ", CONCAT('" . $year_for_check . "', DATE_FORMAT(user_pay.date_resigned, '-%m-%d'))))  END) as ".$als."rExperienceInDaysAfter, (SELECT (".$als."rExperienceInDaysAfter/365)*".$als."entitle_after) as ".$als."rentitle_after_new,  (SELECT DAYOFYEAR('" . $yrr . "-12-31')) as ".$als."year_total_days, (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%m') >= " . $cutOffStartMonth . " THEN  (CASE 
                            WHEN unix_timestamp(CONCAT('" . $cutOffStartYear . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))) = unix_timestamp('user_pay.date_commence')  
                                THEN 
                                    (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1  AND DATE_FORMAT(user_pay.date_resigned, '%Y') = " . $year_for_check . " 
                                    THEN  (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%Y') = YEAR(CURDATE()) AND DATE_FORMAT(user_pay.date_resigned, '%Y') = YEAR(CURDATE()) THEN (SELECT  (".$als."entitle_before* (floor((unix_timestamp(user_pay.date_resigned)-unix_timestamp(user_pay.date_commence))/(60*60*24))/".$als."year_total_days))) ELSE (SELECT  (".$als."entitle_before* (floor((unix_timestamp(user_pay.date_resigned)-$yearStart)/(60*60*24))/365))) END)
                                    ELSE 
                                        (SELECT ".$als."entitle_after_new) 
                                    END) 
                                    
                        ELSE (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1 AND  DATE_FORMAT(user_pay.date_commence, '%Y') = " . $year_for_check . "  THEN 
                            (SELECT (".$als."entitle_before_new+".$als."rentitle_after_new))
                        ELSE (SELECT round(".$als."entitle_before_new+".$als."entitle_after_new) 
                    )
                    END) END)
                ELSE 
                        (CASE 
                            WHEN unix_timestamp(CONCAT('" . $year_for_check . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))) = unix_timestamp('user_pay.date_commence')  
                                THEN 
                                    (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1  AND DATE_FORMAT(user_pay.date_commence, '%Y') = " . $year_for_check . " 
                                    THEN  (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%Y') = YEAR(CURDATE()) AND DATE_FORMAT(user_pay.date_resigned, '%Y') = YEAR(CURDATE()) THEN (SELECT  (".$als."entitle_before* (floor((unix_timestamp(user_pay.date_resigned)-unix_timestamp(user_pay.date_commence))/(60*60*24))/".$als."year_total_days))) ELSE (SELECT  (".$als."entitle_before* (floor((unix_timestamp(user_pay.date_resigned)-$yearStart)/(60*60*24))/365))) END)
                                    ELSE 
                                        (SELECT ".$als."entitle_after_new) 
                                    END) 
                                    
                        ELSE (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1 AND DATE_FORMAT(user_pay.date_commence, '%Y') = " . $year_for_check . " THEN 
                            (SELECT (".$als."entitle_before_new+".$als."rentitle_after_new))
                    ELSE (SELECT round(".$als."entitle_before_new+".$als."entitle_after_new) 
                    )
                    END) END) END) as ".$als."annualentitle, (Select ".$als."annualentitle) as ".$als."entitle";
                    return $query;
            }
            elseif($SettingLeaveAdjustmentType->value == 5){
                $year = date("Y",  strtotime($currentDate));
                $_d = $year . "-" . $cutOffStartMonth . "-" . $cutOffStartDate;
                $_d1 = $year . "-" . $cutOffMonth . "-" . $cutOffDate;
                $date_for_query = "'" . $_d . "'";
                $date_for_query1 = "'" . $_d1 . "'";
                $yearStart = mktime(0, 0, 0, 1, 1,  $year);

                $query ="(SELECT TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as ".$als."experience from user_pay where username=user_personal.username) as ".$als."ExperienceInYear_forfirst, (SELECT TIMESTAMPDIFF(YEAR, date_commence,'" . $year . "-" . $cutOffMonth . "-" . $cutOffDate . "') as ".$als."experience from user_pay where username=user_personal.username) as ".$als."experience_at_current_year_end, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= CASE WHEN ".$als."ExperienceInYear_forfirst = 0 THEN 1 ELSE ".$als."ExperienceInYear_forfirst END  and b.username=user_personal.username ) as ".$als."entitle_year_base, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= CASE WHEN ".$als."experience_at_current_year_end = 0 THEN 1 ELSE ".$als."experience_at_current_year_end END  and b.username=user_personal.username ) as ".$als."entitle_current_year_base, (SELECT DAYOFYEAR('" . $year . "-12-31')) as ".$als."currentYearTotalDays, (SELECT  DATEDIFF(CONCAT('" . $year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))," . $date_for_query . "))  as ".$als."ExperienceInDaysBefore, (SELECT (".$als."ExperienceInDaysBefore/".$als."currentYearTotalDays)*".$als."entitle_year_base) as ".$als."entitleBefore, (SELECT DATEDIFF(" . $date_for_query1 . ",CONCAT('" . $year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')))+1)  as ".$als."ExperienceInDaysAfter, (SELECT (".$als."ExperienceInDaysAfter/".$als."currentYearTotalDays)*".$als."entitle_current_year_base) as ".$als."entitleAfter,
                (CASE 
                WHEN unix_timestamp(CONCAT('" . $year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))) = unix_timestamp(user_pay.date_commence)  
                    THEN 
                        (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1 AND DATE_FORMAT(user_pay.date_resigned, '%Y') = " . $year . "  
                        THEN  (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%Y') = YEAR(CURDATE() )  AND DATE_FORMAT(user_pay.date_resigned, '%Y') = YEAR(CURDATE()) THEN (SELECT  (".$als."entitle_year_base* (floor((unix_timestamp(user_pay.date_resigned)-unix_timestamp(user_pay.date_commence))/(60*60*24))/365))) ELSE (CASE WHEN unix_timestamp('user_pay.date_commence') > unix_timestamp(" . $date_for_query . ") THEN (SELECT  (".$als."entitle_year_base* (((floor((unix_timestamp(user_pay.date_resigned)-$yearStart)/(60*60*24))+1)-".$als."ExperienceInDaysBefore)/365)))  ELSE (SELECT  (".$als."entitle_year_base* (floor((unix_timestamp(user_pay.date_resigned)-$yearStart)/(60*60*24))/365))) END) END)
                        ELSE 
                           (SELECT ".$als."entitleAfter) 
                        END) 
                        
                    ELSE (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1 AND DATE_FORMAT(user_pay.date_commence, '%Y') = " . $year . "  THEN 
                    (SELECT  (round(".$als."entitleBefore+".$als."entitleAfter) * (floor((unix_timestamp(user_pay.date_resigned)-$yearStart)/(60*60*24))/365)))
                ELSE (SELECT round(".$als."entitleBefore+".$als."entitleAfter) 
                )
                END) END) as ".$als."annualentitle, (Select ".$als."annualentitle) as ".$als."entitle";

                return $query;
                    
            }
            elseif($SettingLeaveAdjustmentType->value == 0){
                $query = "(select (year('".$currentDate."') * 365.24 + month('".$currentDate."') * 30.5 + day('".$currentDate."'))/365.24 - (year(date_commence) * 365.24 + month(date_commence) * 30.5 + day(date_commence)) / 365.24 as ".$als."experience from user_pay where username=user_personal.username) as ".$als."actual_experience,(SELECT ".$als."actual_experience) as ".$als."experience, '1' as ".$als."experience_check, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= ".$als."experience + 1  and b.username=user_personal.username) as ".$als."entitle"; 
                
            }
            elseif($SettingLeaveAdjustmentType->value == 2){
                $query = "(select year('".$currentDate."') - year(date_commence) as ".$als."experience  from user_pay where username=user_personal.username) as ".$als."actual_experience, (select month(date_commence) as join_month  from user_pay where username=user_personal.username) as ".$als."join_month, (CASE WHEN (SELECT ".$als."join_month)<=6 AND (SELECT ".$als."actual_experience)>=1 THEN (SELECT ".$als."actual_experience) WHEN (SELECT ".$als."join_month)>6 AND (SELECT ".$als."actual_experience)>=1 THEN (SELECT ".$als."actual_experience)-1 ELSE 0 END) as ".$als."experience, '0' as  ".$als."experience_check, (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <=  ".$als."experience + 1  and b.username=user_personal.username)as  ".$als."entitle";
                
    
            }
            else{
                $query = "(select year('".$currentDate."') - year(date_commence) as  ".$als."experience from user_pay where username=user_personal.username) as  ".$als."experience, (CASE WHEN (SELECT  ".$als."experience) > 0 THEN (SELECT  ".$als."experience) ELSE 0 END) as  ".$als."actual_experience,(SELECT  ".$als."actual_experience) as  ".$als."experience, '1' as  ".$als."experience_check , (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <=  ".$als."experience + 1  and b.username=user_personal.username)as  ".$als."entitle";
           
    
            }

        $query .=", (SELECT  ".$als."entitle) as  ".$als."actual_entitle";
       
        if($SettingLeaveAdjustmentType->value==3 && strtolower($type)=='annual'){
            $current_year = date('Y',strtotime($currentDate));

            $query .=", (CASE WHEN ".$current_year." =  DATE_FORMAT(user_pay.date_commence, '%Y') THEN (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%m') < 12 THEN (((12-DATE_FORMAT(user_pay.date_commence, '%m'))/12)*(SELECT  ".$als."entitle ))  ELSE  (SELECT ".$als."entitle ) END) ELSE (SELECT ".$als."entitle ) END) as entitle";
            return $query;
        }
        if($SettingLeaveAdjustmentType->value!=3)
        {
            $query .=", (SELECT year('".$currentDate."') - year(date_commence) as ".$als."experience  from user_pay where username=user_personal.username) as ".$als."exp,(SELECT month(date_commence) as ".$als."months  from user_pay where username=user_personal.username) as ".$als."months ";
            if($SettingLeaveAdjustmentType->value==0){
                $query .=", (SELECT ".$als."months)+1 as ".$als."months";
            }
            $query.=", (CASE WHEN (SELECT ".$als."experience) = 0 AND (SELECT ".$als."experience_check)=1 THEN (CASE WHEN (SELECT ".$als."exp) = 0 THEN (SELECT ".$als."entitle)*(SELECT ".$als."months) /12 ELSE (SELECT ".$als."entitle ) END) ELSE (SELECT ".$als."entitle ) END) as ".$als."entitle";
            
        }
        if($SettingLeaveAdjustmentType->value==4)
        {
                      
            $year_first_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffStartMonth."-".$cutOffStartDate);
            $year_end_date = strtotime(date('Y',strtotime($currentDate))."-".$cutOffMonth."-".$cutOffDate);
            $today_date = strtotime(date('Y-m-d',strtotime($currentDate)));
                        
            $year_total_days = floor(($year_end_date-$year_first_date)/(60*60*24))+1;
                        
            $entitle_1_first_days =  floor(($today_date-$year_first_date)/(60*60*24))+1;
                        
            $entitle_2_first_days =  floor(($year_end_date-$today_date)/(60*60*24))+1;
            
            $query .=", (SELECT ((".$entitle_1_first_days."/".$year_total_days.")* (SELECT ".$als."actual_entitle))+((".$entitle_2_first_days."/".$year_total_days.")* (SELECT ".$als."actual_entitle))) as ".$als."entitle";

        }
            $cyear = date('Y',strtotime($currentDate));
        if($SettingLeaveAdjustmentType->value == 2){
            $new_e = 0;
           
            $first_date = "-".$cutOffStartMonth."-".$cutOffStartDate;
            $second_date = "-".$cutOffMonth."-".$cutOffDate;
               
            $query .=", (SELECT  unix_timestamp(CONCAT(DATE_FORMAT(user_pay.date_commence, '%Y'),'".$second_date."')) -  unix_timestamp(CONCAT(DATE_FORMAT(user_pay.date_commence, '%Y'),'".$first_date."')) as ".$als."datediff, (SELECT floor(datediff/(60*60*24))+1) as ".$als."year_total_days, (SELECT unix_timestamp(CONCAT(DATE_FORMAT(user_pay.date_commence, '%Y'),'".$second_date."'))-unix_timestamp(DATE_FORMAT(user_pay.date_commence, '%Y-%m-%d'))) as ".$als."reamining_days_datediff, (SELECT floor(".$als."reamining_days_datediff/(60*60*24))) as ".$als."reamining_days";

            $query .= ", (CASE WHEN (SELECT ".$als."experience) = 0 THEN (CASE WHEN DATE_FORMAT(user_pay.date_commence, '%Y') = '".$cyear."' THEN (SELECT ((".$als."reamining_days/".$als."year_total_days)*(SELECT ".$als."entitle))) ELSE (SELECT ".$als."entitle ) END) ELSE (SELECT ".$als."entitle ) END) as ".$als."entitle";
           
    
        }

        $yearStart = mktime(0, 0, 0, 1, 1,  date('Y',strtotime($currentDate)));
        $query .=", (SELECT floor(('".strtotime('user_pay.date_resigned')."'-'".$yearStart."')/(60*60*24))) as ".$als."days_before_resign";
        $query .= ", (CASE WHEN DATE_FORMAT(user_pay.date_resigned, '%Y') !=-1 AND DATE_FORMAT(user_pay.date_resigned, '%Y') = '".$cyear."' THEN (SELECT (".$als."entitle)*(".$als."days_before_resign/365)) ELSE (SELECT ".$als."entitle) END) as ".$als."entitle";

        return $query; 
    
    }

   

    function getBFValueQueryReturn($year, $username, $dateValue = "" , $cutOffMonth,$cutOffDate,$SoftwareStartDate,$SettingLeaveAdjustmentType,$cutOffStartMonth,$cutOffStartDate,$cutOffStartYear){
        $als='bf';
        $exported_date = explode('-', $dateValue);
		$previous_year = $year - 1;
        $_p_year = 0;
        $hours = gethours();
		if (count($exported_date) > 0) {
			$last_date_previous_year = ($exported_date[0] - 1) . "-".$cutOffMonth."-".$cutOffDate;
			$_p_year = ($exported_date[0] - 1);
		} else {
			$last_date_previous_year = $previous_year . "-".$cutOffMonth."-".$cutOffDate;
			$_p_year = $previous_year;
        }
        $startDate_1 = $year-1 . '-' . $cutOffStartMonth . '-' . $cutOffStartDate;
        $endDate_1 = $year . '-' . $cutOffMonth . '-' . $cutOffDate;
        $annualtakenstartdate = $cutOffStartYear . '-' . $cutOffStartMonth . '-' . $cutOffStartDate;

        $leave_year = $year;
		$leave_month = date('m');
        $Check_now = time(); 
        if($cutOffStartMonth!=1){
			if($cutOffStartMonth >= $leave_month){
				$tcutOffStartYear = $leave_year;
			}else{
				$tcutOffStartYear = $leave_year-1;
			}
		}else{
			$tcutOffStartYear = $leave_year;
		}
        $check_your_date = strtotime($tcutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
		
		$check_datediff = $Check_now - $check_your_date;
        $totalDaysTillToday= floor($check_datediff / (60 * 60 * 24));
        

        if ($SoftwareStartDate <= ($year - 1)) {
            $query = getBFValueQueryReturn($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate, $cutOffMonth,$cutOffDate,$SoftwareStartDate,$SettingLeaveAdjustmentType,$cutOffStartMonth,$cutOffStartDate,$cutOffStartYear);
            $query .=", (SELECT ".$als."balance) as ".$als."previous_bfAnnual, ";
			
		} else {
			$query ="(SELECT '0' )as ".$als."previous_bfAnnual, ";
		}
        
        $balance = 0;
		 $query .= getYearWiseFixLeaveEntitleQueryReturn($username, "Annual", $last_date_previous_year ,$als);
         $query .=", (SELECT ".$als."entitle) as ".$als."bannualEntitle, (SELECT ".$als."previous_bfAnnual) as ".$als."bfAnnual,  (SELECT ".$als."previous_bfAnnual) as ".$als."bf, (CASE WHEN (SELECT ".$als."bf) IS NULL THEN 0 ELSE (SELECT ".$als."bf) END) as ".$als."bf, (SELECT bf_duration.value FROM users left join user_category on user_category.username=users.username left join bf_duration on bf_duration.category_name=user_category.category where users.username=user_personal.username) as ".$als."BFClearDuration, (CASE WHEN (SELECT ".$als."BFClearDuration) IS NULL THEN 0 ELSE (SELECT ".$als."BFClearDuration) END) as ".$als."BFClearDuration,(SELECT bf_adj_duration.value FROM users left join user_category on user_category.username=users.username left join bf_adj_duration on bf_adj_duration.category_name=user_category.category where users.username=user_personal.username) as ".$als."BFAdjClearDuration, (CASE WHEN (SELECT ".$als."BFAdjClearDuration) IS NULL THEN 0 ELSE (SELECT ".$als."BFAdjClearDuration) END) as ".$als."BFAdjClearDuration ";
        if($SettingLeaveAdjustmentType == 8) {
            $query .=", (SELECT FLOOR( TIMESTAMPDIFF( DAY, user_pay.date_commence, DATE_ADD(CONCAT('".$year."', DATE_FORMAT(user_pay.date_commence, '-%m-%d')), INTERVAL 1 DAY) ) % 30.4375 ) AS ".$als."DateDiff) as ".$als."bExperienceInDay, (SELECT TIMESTAMPDIFF(YEAR,user_pay.date_commence,DATE_ADD(CONCAT('".$year."', DATE_FORMAT(user_pay.date_commence, '-%m-%d')), INTERVAL 1 DAY)) AS ".$als."DateDiff) as ".$als."bExperienceInYear,  (select max(a.no_leaves) as no_leaves from leave_entitle a left join user_category b on a.category_name=b.category left join user_pay c on b.username=c.username where a.type='Annual' and a.experience <= (CASE WHEN ".$als."bExperienceInDay > 0 THEN ".$als."bExperienceInYear+1 WHEN user_pay.date_commence = DATE_ADD(CONCAT('".$year."', DATE_FORMAT(user_pay.date_commence, '-%m-%d')), INTERVAL 1 DAY) THEN ".$als."bExperienceInYear+1 ELSE ".$als."bExperienceInYear END)  and b.username=user_personal.username ) as ".$als."bannualEntitle , (select sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days from leave_list where type='Emergency' and status='1' and username=user_personal.username and start_date >= CONCAT('" . $year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')) and end_date <= CONCAT('" . ($year + 1) . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))) as ".$als."EmergencyLeaveValue, (select sum(total_leave_days) as no_days from leave_past where type='Emergency' and username=user_personal.username and start_date >= CONCAT('" . $year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')) and start_date <= CONCAT('" . ($year + 1) . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')))  as ".$als."EmergencyPastLeaveValue";

        }else{
            
            $query .=", (select sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days from leave_list where type='Emergency' and status='1' and username=user_personal.username and start_date >= '" . $startDate_1 . "' and   end_date <= '" . $endDate_1 . "') as ".$als."EmergencyLeaveValue, (select sum(total_leave_days) as no_days from leave_past where type='Emergency' and username=user_personal.username and (start_date between '" . $startDate_1 . "' and '" . $endDate_1 . "')) as ".$als."EmergencyPastLeaveValue";
        }
        if($cutOffStartMonth!='1'){
            $query .=", (SELECT sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days FROM leave_list where username=user_personal.username and status=1 and (start_date between CONCAT('".$cutOffStartYear."','-".$cutOffStartMonth."-".$cutOffStartDate."')AND DATE_ADD(CONCAT('".$cutOffStartYear."','-".$cutOffStartMonth."-".$cutOffStartDate."'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFCLeaveTaken,(CASE WHEN (SELECT ".$als."BFCLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFCLeaveTaken) END) as ".$als."BFCLeaveTaken, (SELECT sum(total_leave_days) as no_days FROM leave_past where username=user_personal.username and (start_date between CONCAT('".$cutOffStartYear."','-".$cutOffStartMonth."-".$cutOffStartDate."')AND DATE_ADD(CONCAT('".$cutOffStartYear."','-".$cutOffStartMonth."-".$cutOffStartDate."'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFPastLeave,(CASE WHEN (SELECT ".$als."BFPastLeave) IS NULL THEN 0 ELSE (SELECT ".$als."BFPastLeave) END) as ".$als."BFPastLeave";

        }else{
            $query .=", (SELECT sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days FROM leave_list where username=user_personal.username and status=1 and (start_date between CONCAT('".$year."','-01-01')AND DATE_ADD(CONCAT('".$year."','-01-01'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFCLeaveTaken,(CASE WHEN (SELECT ".$als."BFCLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFCLeaveTaken) END) as ".$als."BFCLeaveTaken, (SELECT sum(total_leave_days) as no_days FROM leave_past where username=user_personal.username and (start_date between CONCAT('".$year."','-01-01')AND DATE_ADD(CONCAT('".$year."','-01-01'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFPastLeave,(CASE WHEN (SELECT ".$als."BFPastLeave) IS NULL THEN 0 ELSE (SELECT ".$als."BFPastLeave) END) as ".$als."BFPastLeave";
        }
        
        $lyear=date('Y',strtotime($last_date_previous_year));
        $edt = $_p_year . '-' . $cutOffMonth . '-' . $cutOffDate;
        $query .=",(SELECT ".$als."entitle) as ".$als."actual_annualEntitleForBF, (CASE WHEN (SELECT (".$als."BFCLeaveTaken+".$als."BFPastLeave)) > (SELECT ".$als."bfAnnual) THEN (SELECT ".$als."bfAnnual) ELSE (SELECT (".$als."BFCLeaveTaken+".$als."BFPastLeave)) END) as ".$als."BFLeaveTaken,(CASE WHEN (SELECT ".$als."BFLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFLeaveTaken) END) as ".$als."BFLeaveTaken, (SELECT sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days FROM leave_list where username=user_personal.username and status=1 and (start_date between CONCAT('".$year."','-01-01')AND DATE_ADD(CONCAT('".$year."','-01-01'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFacLeaveTaken,(CASE WHEN (SELECT ".$als."BFacLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFacLeaveTaken) END) as ".$als."BFacLeaveTaken, (SELECT sum(total_leave_days) as no_days FROM leave_past where username=user_personal.username and (start_date between CONCAT('".$year."','-01-01')AND DATE_ADD(CONCAT('".$year."','-01-01'),INTERVAL ".$als."BFClearDuration DAY)) AND (type='Emergency' OR type='Annual')) as ".$als."BFacPastLeave,(CASE WHEN (SELECT ".$als."BFacPastLeave) IS NULL THEN 0 ELSE (SELECT ".$als."BFacPastLeave) END) as ".$als."BFacPastLeave, (CASE WHEN (SELECT (".$als."BFacLeaveTaken+".$als."BFacPastLeave)) > (SELECT ".$als."bfAnnual) THEN (SELECT ".$als."bfAnnual) ELSE (SELECT (".$als."BFacLeaveTaken+".$als."BFacPastLeave)) END) as ".$als."BFALeaveTaken,(CASE WHEN (SELECT ".$als."BFALeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFALeaveTaken) END) as ".$als."BFALeaveTaken, (SELECT sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_days FROM leave_list where username=user_personal.username and status=1 and (start_date between '".$startDate_1."' AND DATE_ADD('".$startDate_1."',INTERVAL ".$als."BFAdjClearDuration DAY)) and  (type='Emergency' OR type='Annual')) as ".$als."BFADLeaveTaken,(CASE WHEN (SELECT ".$als."BFADLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFADLeaveTaken) END) as ".$als."BFADLeaveTaken, (SELECT sum(total_leave_days) as no_days FROM leave_past where username=user_personal.username and (type='Emergency' OR type='Annual') and (start_date between '".$startDate_1."' AND DATE_ADD('".$startDate_1."',INTERVAL ".$als."BFAdjClearDuration DAY))) as ".$als."BFADPastLeaveTaken,(CASE WHEN (SELECT ".$als."BFADPastLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."BFADPastLeaveTaken) END) as ".$als."BFADPastLeaveTaken,(CASE WHEN (SELECT ((".$als."BFADLeaveTaken+".$als."BFADPastLeaveTaken)-".$als."BFALeaveTaken)) < 0 THEN 0 ELSE (SELECT ((".$als."BFADLeaveTaken+".$als."BFADPastLeaveTaken)-".$als."BFALeaveTaken)) END) as ".$als."bfAdjLeaveTaken, (CASE WHEN (SELECT ".$als."bfAdjLeaveTaken) > (SELECT bf_adj) THEN (SELECT bf_adj) ELSE (SELECT ".$als."bfAdjLeaveTaken) END) as ".$als."bfAdjLeaveTaken, (CASE WHEN (SELECT ".$als."bfAdjLeaveTaken) IS NULL THEN 0 ELSE (SELECT ".$als."bfAdjLeaveTaken) END) as ".$als."bfAdjLeaveTaken, (CASE WHEN (SELECT ".$als."BFClearDuration) < '".$totalDaysTillToday."' AND (SELECT ".$als."BFClearDuration) < 365  THEN 1 WHEN '".$year."' != '".$year."' AND (SELECT ".$als."BFClearDuration) < 365 THEN 1 ELSE 0 END) as ".$als."bf_forfeit, (CASE WHEN (SELECT ".$als."BFClearDuration) < '".$totalDaysTillToday."' AND (SELECT ".$als."BFClearDuration) < 365  THEN (SELECT ".$als."bfAnnual-".$als."BFLeaveTaken) WHEN '".$year."' != '".$year."' AND (SELECT ".$als."BFClearDuration) < 365 THEN (SELECT ".$als."bfAnnual-".$als."BFLeaveTaken) ELSE 0 END) as ".$als."bf_forfeit_value, (CASE WHEN (SELECT ".$als."BFAdjClearDuration) < '".$totalDaysTillToday."' AND (SELECT ".$als."BFAdjClearDuration) < 365  THEN 1 WHEN '".$year."' != '".$year."' AND (SELECT ".$als."BFAdjClearDuration) < 365 THEN 1 ELSE 0 END) as ".$als."bfadj_forfeit, (CASE WHEN (SELECT ".$als."BFAdjClearDuration) < '".$totalDaysTillToday."' AND (SELECT ".$als."BFAdjClearDuration) < 365  THEN (SELECT bf_adj-".$als."bfAdjLeaveTaken) WHEN '".$year."' != '".$year."' AND (SELECT ".$als."BFAdjClearDuration) < 365 THEN (SELECT bf_adj-".$als."bfAdjLeaveTaken) ELSE 0 END) as ".$als."bfadj_forfeit_value, (select sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken from leave_days a left join leave_list b on a.leave_id=b.id where a.status = 1 and b.type='Annual' and a.username=user_personal.username and start_date>='" . $annualtakenstartdate . "' and end_date<='" . $edt . "') as ".$als."annualTaken, (SELECT sum(bf_adj) as bf_adj FROM leave_bf_adj where username=user_personal.username and year='".$lyear."' and leave_type='Annual') as ".$als."bf_adj, (select sum(total_leave_days) as no_days from leave_past where type='Annual' and username=user_personal.username and start_date >= CONCAT('" . $_p_year . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d')) and start_date <= CONCAT('" . ($_p_year + 1) . "', DATE_FORMAT(user_pay.date_commence, '-%m-%d'))) as ".$als."bpastLeaves, ";
        $query .="(CASE WHEN '".$lyear."' < DATE_FORMAT(user_pay.date_commence, '%Y') THEN 0 ELSE (SELECT ".$als."bannualEntitle) END) as ".$als."bannualEntitle , (CASE WHEN (SELECT ".$als."bfAnnual) IS NULL THEN 0 ELSE (SELECT ".$als."bfAnnual) END) as ".$als."bfAnnual, (CASE WHEN (SELECT ".$als."bf_adj) IS NULL THEN 0 ELSE (SELECT ".$als."bf_adj) END) as ".$als."bf_adj, (CASE WHEN (SELECT ".$als."annualTaken) IS NULL THEN 0 ELSE (SELECT ".$als."annualTaken) END) as ".$als."annualTaken,(CASE WHEN (SELECT ".$als."EmergencyLeaveValue) IS NULL THEN 0 ELSE (SELECT ".$als."EmergencyLeaveValue) END) as ".$als."EmergencyLeaveValue,(CASE WHEN (SELECT ".$als."EmergencyPastLeaveValue)IS NULL THEN 0 ELSE (SELECT ".$als."EmergencyPastLeaveValue) END) as ".$als."EmergencyPastLeaveValue,(CASE WHEN (SELECT ".$als."bpastLeaves) IS NULL THEN 0 ELSE (SELECT ".$als."bpastLeaves) END) as ".$als."bpastLeaves, (CASE WHEN (SELECT ".$als."bannualEntitle) IS NULL THEN 0 ELSE (SELECT ".$als."bannualEntitle) END) as ".$als."bannualEntitle,(CASE WHEN (SELECT ".$als."bf_forfeit_value) IS NULL THEN 0 ELSE (SELECT ".$als."bf_forfeit_value) END) as ".$als."bf_forfeit_value,(CASE WHEN (SELECT ".$als."bfadj_forfeit_value) IS NULL THEN 0 ELSE (SELECT ".$als."bfadj_forfeit_value) END) as ".$als."bfadj_forfeit_value, (SELECT  ((CASE WHEN (SELECT ".$als."bf) IS NULL THEN 0 ELSE (SELECT ".$als."bf) END)+(CASE WHEN (SELECT ".$als."bf_adj) IS NULL THEN 0 ELSE (SELECT ".$als."bf_adj) END)+(CASE WHEN (SELECT ".$als."bannualEntitle) IS NULL THEN 0 ELSE (SELECT ".$als."bannualEntitle) END))-((CASE WHEN (SELECT ".$als."annualTaken) IS NULL THEN 0 ELSE (SELECT ".$als."annualTaken) END)+(CASE WHEN (SELECT ".$als."EmergencyLeaveValue) IS NULL THEN 0 ELSE (SELECT ".$als."EmergencyLeaveValue) END)+(CASE WHEN (SELECT ".$als."EmergencyPastLeaveValue)IS NULL THEN 0 ELSE (SELECT ".$als."EmergencyPastLeaveValue) END)+(CASE WHEN (SELECT ".$als."bpastLeaves) IS NULL THEN 0 ELSE (SELECT ".$als."bpastLeaves) END)) -(round(((CASE WHEN (SELECT ".$als."bf_forfeit_value) IS NULL THEN 0 ELSE (SELECT ".$als."bf_forfeit_value) END)+(CASE WHEN (SELECT ".$als."bfadj_forfeit_value) IS NULL THEN 0 ELSE (SELECT ".$als."bfadj_forfeit_value) END))*2)/2)) as ".$als."balance, (select b.percentage from user_category a left join leave_brought_forward_category b on a.category=b.category_name where a.username=user_personal.username) as ".$als."percentage , (select b.type from user_category a left join leave_brought_forward_category b on a.category=b.category_name where a.username=user_personal.username) as ".$als."type,(((SELECT ".$als."actual_annualEntitleForBF)*(SELECT ".$als."percentage))/100) as ".$als."bf_max_value, ";
       
        $query .=" (CASE WHEN (SELECT ".$als."type) = 'perc' THEN (((SELECT ".$als."balance)*(SELECT ".$als."percentage))/100) WHEN (SELECT ".$als."type)= 'entitle' THEN (CASE WHEN (SELECT ".$als."bf_max_value) <= (SELECT ".$als."balance) THEN (SELECT ".$als."bf_max_value) ELSE (SELECT ".$als."balance) END) ELSE (CASE WHEN (SELECT ".$als."percentage) <= (SELECT ".$als."balance) THEN (SELECT ".$als."percentage) ELSE (SELECT ".$als."balance) END) END) as bfAnnual";
        return $query;
    }


    function  setStatus($_id = '', $_approver_id = '', $_status = '',Request $request,$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$user,$LeaveMultipleApprover,$npl_to_hr1,$emailSendingStatus,$uname,$Cancel_leave_to_hr,$SoftwareStartDate,$SettingLeaveAdjustmentType,$workForEarnSetting,$sendbypreference,$companyName11,$medical_pro_rated)
	{
	    

		if ($_id == '') {
			$id = $request->id;
		} else {
			$id = $_id;
		}
		$cancel_reason = $request->cancel_reason;
		$reject_reason = $request->reject_reason;

		$login_username = ($request->username ? $request->username : $user->username);

		if ($_approver_id == '') {
			$approverId = ($request->approver_id ? $request->approver_id : $user->username);
		} else {
			$approverId = $_approver_id;
		}

		if ($_status == '') {
			$status = $request->status;
		} else {
			$status = $_status;
		}
		$apply_subord = $request->apply_subord ? $request->apply_subord : '0';
		if ($status != "2" && $apply_subord != '1') {
            
		    if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
				update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
				if (!UpdateApproverOfLeave($id, $approverId, $status,request(),$user,$uname,$emailSendingStatus,$sendbypreference)) {
					return;
				}
			} else if ($LeaveMultipleApprover == '3') {
				update_leave_approver($id, $approverId, $status,$cancel_reason,$reject_reason);
				$cnt = get_approver_by_leaveid($id);
				if ($cnt > 0) {
					return;
				}
			} else if ($LeaveMultipleApprover == '4') {
				update_leave_approver($id,'',$status,$cancel_reason,$reject_reason);
			}
		}

		if($status == "2" && $apply_subord != '1')
		{
			
		    if ($LeaveMultipleApprover == '1' || $LeaveMultipleApprover == '2') {
				update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
				
			} else if ($LeaveMultipleApprover == '3') {
				update_leave_approver11($id, $approverId, $status,$cancel_reason,$reject_reason);
				
			} else if ($LeaveMultipleApprover == '4') {
			    update_leave_approver11($id,'',$status,$cancel_reason,$reject_reason);
			}
		}


		$result = setStatus11($id, $status);

		$sStatus = "";
		if ($status == "1")
			$sStatus = "approved";
		else if ($status == "2")
			$sStatus = "rejected";
		else if ($status == "3")
			$sStatus = "recommended";
		else if ($status == "4")
			$sStatus = "cancelled";
		else if ($status == "5")
			$sStatus = "Cancellation Pending";
        
		
		$npl_to_hr='';
		if($npl_to_hr1!='')
		$npl_to_hr = $npl_to_hr1->value;
		$nplHRUsers = getNPL_HR_User();

		$hr_id_array = array();
		for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
			$hr_id_array[$npl_hr_i] = strtolower($nplHRUsers[$npl_hr_i]->employee_id);
		}
		
		$leaveDetails = getLeaveDetails($id);
	
		$isShowClaimable = getConfirmDisplay($leaveDetails->username);

		if ($status == '4' || $status == '2') {
			if ($leaveDetails->type == 'Other_pay') {
				for ($_rl_i = 0; $_rl_i < ($leaveDetails->no_days * 2); $_rl_i++) {
					unMarkReplacementLeaveAsTaken($leaveDetails->username);
				}
			}
		}

		if ($cancel_reason != '') {
			updateLeaveDays($cancel_reason, $id);
		}
		if ($reject_reason != '') {
			updateLeaveDays($reject_reason, $id, 'reject');
		}


		$email_send_allow = true;
        $sendbypreference1 = DB::table('settings')->where('field','email_send_by_preferneces')->first();
        $sendbypreference = $sendbypreference1->value;
		if ($sendbypreference == "1") {
			if (!hasContentPreference($leaveDetails->username)) {
				$email_send_allow = true;
			} else {
				$email_send_allow = false;
			}
		}
		if ($status == "3") {
            $getLeaveMultipleApprover=DB::table('settings')->where('field','leave_multiple_approver')->first();
		    $LeaveMultipleApprover = $getLeaveMultipleApprover->value;
			
			if ($LeaveMultipleApprover == '1') {
				$masterApprover = getApproversOfEmployee($leaveDetails->username);
				if (count($masterApprover) > 1) {
					$masterApprover = $masterApprover[1]->username;
				} else {
					$masterApprover = getApproversOfEmployee($approverId);
					$masterApprover = $masterApprover[0]->username;
				}
			} else {
				$masterApprover = getApproversOfEmployee($approverId);
				$masterApprover = $masterApprover[0]->username;
			}

			setAssignee($id, $masterApprover);
           

            $name = $uname->name;

			if ($email_send_allow) {
				if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = str_replace('self-leaves', 'dashboard', url()->current());

					$body = "Leave has been recommended by $name. ";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "Employee Name: $emp_name<br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display<br>";
					$body .= "Reason: $reason<br>";
					$body .= "Link: <a href='$referer'>$referer</a><br><br>";
					$body .= "Kind regards,";
					$body .= "Note, this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";

                    $semail = UserPersonal::where('username',$masterApprover)->first();
				    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
				     sendemail($semail->email_id,$subject,$body);
				    
				    // $details['email_id'] = $semail->email_id;
				    // $details['subject'] = $subject;
				    // $details['body'] = $body;
				    
        //             SendEmailJob::dispatch($details);
                    
					//Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
				} else {

					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;

					$referer = str_replace('self-leaves', 'dashboard', url()->current());
                    $referer = str_replace('approve-leaves', 'approve-leave', $referer);

					$body = "<tr>";
					$body .= "<td>$emp_name</td>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					$body .= "<td>$type_display Leave</td>";
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords($sStatus) . "</td>";
					$body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
					$body .= "</tr>";

					pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
				}
			}
		} else if ($status == "5") {

			
			$approver_done = false;
			if ($Cancel_leave_to_hr == 1) {

				$masterApprover = getCancelLeave_Approver();
				
				if (count($masterApprover) > 0) {
					$approver_done = true;
					$masterApprover = $masterApprover[0]->username;
					setAssignee($id, $masterApprover);
				} else {
					$approver_done = false;
				}
			}

			if (!$approver_done) {
				$masterApprover = getApproversOfEmployee($approverId);
				$masterApprover = $masterApprover[0]->username;
				setAssignee($id, $masterApprover);
			}

          
        
			if ($email_send_allow) {
				if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;

					$body = "Self Leave has been Cancelled by $name. ";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display<br>";
					$body .= "Reason: $reason<br><br>";
					$body .= "Name : $emp_name<br><br>";
					$referer = str_replace('self-leaves', 'dashboard', url()->current());
					$body .= "Link: <a href='$referer'>$referer</a><br><br>";

					$body .= "Kind regards,";
					$body .= "Note, this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
                    $body .= "If you have any questions, please contact us";
                    
                    $semail = UserPersonal::where('username',$masterApprover)->first();
				    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
					sendemail($semail->email_id,$subject,$body);
					
				// 	$details['email_id'] = $semail->email_id;
				//     $details['subject'] = $subject;
				//     $details['body'] = $body;
    //                 SendEmailJob::dispatch($details);
					//Email::sendEmailToUserFromServer($masterApprover, $subject, $body);
				} else {

					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;

					$referer = str_replace('self-leaves', 'dashboard', url()->current());
					 $referer = str_replace('approve-leaves', 'approve-leave', $referer);

					$body = "<tr>";
					$body .= "<td>$emp_name</td>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					$body .= "<td>$type_display Leave</td>";
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords($sStatus) . "</td>";
					$body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
					$body .= "</tr>";


					pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
				}
			}
		} else if ($status == "4") {
			if ($email_send_allow) {
                if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = url()->current();
					$referer = str_replace('approve-leaves', 'approve-leave', url()->current());
					

					$body = "Dear $emp_name<br><br>";
					$body .= "Your leave has been $sStatus<br><br>";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display<br>";
					$body .= "Reason: $reason<br><br>";
					$body .= "Kind regards,<br><br>";
					$body .= "Note: this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";

					$semail = UserPersonal::where('username',$username)->first();
					sendemail($semail->email_id,$subject,$body);
					
				// 	$details['email_id'] = $semail->email_id;
				//     $details['subject'] = $subject;
				//     $details['body'] = $body;
				    
    //                 SendEmailJob::dispatch($details);
                    
				    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
					
					$message = "Dear $emp_name  ";
					$message .= "Your leave has been $sStatus, ";
					$message .= "Details of the leave are as follows: ";
					$message .= "From: $from_date  ";
					$message .= "To: $to_date  ";
					$message .= "Reason: $reason";

					sendSMSToUserFromServer($username, $message);
				} else {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = url()->current();
                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
					
					$body = "<tr>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					$body .= "<td>$type_display Leave</td>";
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords($sStatus) . "</td>";
					$body .= "<td>  </td>";
					$body .= "</tr>";

					pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
				}
			}
		} else if ($sStatus != "") {
			$username = $leaveDetails->username;
			$type = $leaveDetails->type;
			$year = date("Y", strtotime(str_replace('/', '-', $leaveDetails->start_date)));
			$leave_month = date("m", strtotime(str_replace('/', '-', $leaveDetails->start_date)));

			if($cutOffStartMonth!=1){
				if($cutOffStartMonth > $leave_month){
					$cutOffStartYear = $year;
					$year = $year;
				}else{
					$cutOffStartYear = $year;
					$year = $year+1;
				}
			}else{
				$cutOffStartYear = $year;
				$year = $year;
			}
			
			$new_type = $type;

			$categoryId = getUserCategory($username);
			$leaveAllowMaxvalue = getMaxValue($new_type, $categoryId);
			$totalLeaveValue = getLeaveAccordingToTypeCount($year, $username, $new_type);
			$this_taken = 0;

			$TakenPastLeaves = getTakenPastLeaves($username, $cutOffStartYear);


			if ($type == "Medical" && $status == "1") {
				$medicalEntitle = getLeaveEntitle($username, "Medical");
				$medicalTaken = getTakenLeaveCount($username, $year, "Medical");


				$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
				$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");


				if (($medicalTaken + $TakenPastLeaves['medical']) > ($medicalEntitle + $bfMedical + $bfMedicalAdj)) {
					$new_type = "NPL";
					changeType($id, "NPL");
				}
			}
            
            if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
				if ($leaveAllowMaxvalue < $totalLeaveValue) {
					$type = "Annual";
					$new_type = "Annual";
					changeType($id, $new_type);
				}
			}

			if ($type == "Annual" && $status == "1") {

				$checking_year = date('Y');
				if($cutOffStartMonth!=1){
					if($cutOffStartMonth <= $leave_month){
						$checking_year = date('Y') + 1;
					}
				}

				$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
			
                $_start_leave_date_array = explode("/", $leaveDetails->start_date);
                $_start_leave_date = $_start_leave_date_array[2] . "-" . $_start_leave_date_array[1] . "-" . $_start_leave_date_array[0];
                
				if ($SoftwareStartDate <= ($year - 1)) {
					
					$bfAnnual = getBFValue($year - 1, $username, $_start_leave_date);
                
                } else {
                    
                    $bfAnnual = 0;

				}
				$users=DB::table('users')->where('username',$username)->first();
				$usercat =DB::table('user_category')->where('username',$username)->first();
				$BFClearDuration1 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
				
				$BFAdjClearDuration1 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
				
				//$BFClearDuration1=DB::table('settings')->where('field','bf_duration')->first();
                $BFClearDuration = $BFClearDuration1->value;
				//$BFAdjClearDuration1=DB::table('settings')->where('field','bf_adj_duration')->first();
                $BFAdjClearDuration = $BFAdjClearDuration1->value;
				$totalDaysTillToday =  tillTodayTotalDays($year,$leaveDetails->start_date);

				if (($BFClearDuration < $totalDaysTillToday || $year != date('Y'))  && $cutOffStartMonth==1) {
					
					$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
					
					if ($BFLeaveTaken > $bfAnnual) {
						$BFLeaveTaken = $bfAnnual;
					}

					$bfAnnual = $BFLeaveTaken;
				}else if($cutOffStartMonth!=1){
					
					$BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
					
					if ($BFLeaveTaken > $bfAnnual) {
						$BFLeaveTaken = $bfAnnual;
					}

					$bfAnnual = $BFLeaveTaken;
				}
                
                if (($BFAdjClearDuration < $totalDaysTillToday || $year != date('Y')) && $cutOffStartMonth==1 ) {

					$BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);

					if ($BFADJLeaveTaken > $bfAnnualAdj) {
						$BFADJLeaveTaken = $bfAnnualAdj;
					}

					$bfAnnualAdj = $BFADJLeaveTaken;
				}else if($cutOffStartMonth!=1){
					$BFADJLeaveTaken = getCountOfBFAdjLeaveTaken($username, $checking_year, $bfAnnual, $bfAnnualAdj);

					if ($BFADJLeaveTaken > $bfAnnualAdj) {
						$BFADJLeaveTaken = $bfAnnualAdj;
					}

					$bfAnnualAdj = $BFADJLeaveTaken;
				}
				
				$taken = getTakenLeaveCount($username, $year, $type);
				if ($type == "Annual") {

					$el_taken = getTakenLeaveCount($username, $year, "Emergency");
                
                }
                
                $leave_end_month = date('m', strtotime(str_replace("/", "-", $leaveDetails->end_date)));

				if ($year > date('Y')) {
					$yearlyEntitle = getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt',$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$SettingLeaveAdjustmentType,$SoftwareStartDate,$companyName11,$medical_pro_rated);
				} else {
					$yearlyEntitle = getYearlyEntitleMain($username, $year, FALSE, $leaveDetails->start_date, 'updt',$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$SettingLeaveAdjustmentType,$SoftwareStartDate,$companyName11,$medical_pro_rated);
				}
				$claimable = $yearlyEntitle['claimable'];
				$entitle1 = $yearlyEntitle['annual']['entitle'];
				
                //$elSetting1=DB::table('settings')->where('field','emergency_leave')->first();
				$users=DB::table('users')->where('username',$username)->first();
				$usercat =DB::table('user_category')->where('username',$username)->first();
        		$elSetting1 = DB::table('emergency_leave')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
				$elSetting = $elSetting1->value;
				$em_leave = getEmergencyLeaveCountByUser($username, $year);


				$resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
				$max_day = $resultArrayVal->percentage;
				$balance1 = $yearlyEntitle['balance'];

				if ($year > $checking_year) {
					if ($balance1 <= $max_day) {
						$claimable = $balance1 + 1;
					} else {
						$claimable = $max_day + 1;
					}
				} else {
					if ($balance1 < 0) {
						$new_type = "NPL";
						changeType($id, "NPL");
					}
				}

				if ($isShowClaimable == 0) {
					$claimable = 0;
				}

			
				if ($SettingLeaveAdjustmentType != 8) {
					
					if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable) || (($claimable) == 0)) {

						$new_type = "NPL";
						changeType($id, "NPL");

						if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
							//$result = setStatus11($id, '0');
							$result = setStatus11($id, $status);
						}
					}
					
				} else {
					
					$TakenPastLeaves2 = getTakenPastLeaves2($username, $leaveDetails->start_date, $year);
					$cut_off_taken = getTakenLeaveCount2($username, $type, $leaveDetails->start_date, $year);
					$cut_off_em_leave = getEmergencyLeaveCountByUser2($username, $leaveDetails->start_date, $year);
					
					if (($cut_off_taken + $cut_off_em_leave + $TakenPastLeaves2['annual']) > $yearlyEntitle['annual']['entitle']) {

						$new_type = "NPL";
						changeType($id, "NPL");

						if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
							//$result = setStatus11($id, '0');
							$result = setStatus11($id, $status);
						}
					}
					$leavedate = str_replace('/', '-', $leaveDetails->start_date);
					$leavedate = date('Y-m-d', strtotime($leavedate));

					$joindate1 = DB::table('user_pay')->where('username',$username)->first();
					$joiningDate = $joindate1->date_commence;
					$joiningDateArr = explode('-', $joiningDate);
					$joining_month = $joiningDateArr[1];
					$joining_date = $joiningDateArr[2];

					$curr_j_date = $year . '-' . $joining_month . '-' . $joining_date;
					if ($leavedate > $curr_j_date) {
						$resultArrayVal = DB::table('user_category as a')->leftjoin('leave_brought_forward_category as b','a.category','=','b.category_name')->where('a.username',$username)->selectRaw("b.percentage,b.type")->first();
						$max_day = $resultArrayVal->percentage;
						if (isset($_SESSION['maxday'])) {
							if ($_SESSION['maxday'] > 0) {
								$_SESSION['maxday'] = ($_SESSION['maxday'] - 1);
							} else {
								$new_type = "NPL";
								changeType($id, "NPL");

								if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
								//	$result = setStatus11($id, '0');
									$result = setStatus11($id, $status);
								}
							}
						} else {
							$_SESSION['maxday'] = $max_day;
							if ($_SESSION['maxday'] > 0) {
								$_SESSION['maxday'] = ($_SESSION['maxday'] - 1);
							} else {
								$new_type = "NPL";
								changeType($id, "NPL");

								if ($npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
									// $result = setStatus11($id, '0');
									$result = setStatus11($id, $status);
								}
							}
						}
					}
				}

				$is_emergency_check = true;

				if ($npl_to_hr == '1') {
					if ($new_type != "NPL") {
						$is_emergency_check = true;
					} else {
						$is_emergency_check = false;
					}
				}

				$dateDiff = diff(strtotime($leaveDetails->start_date_cal), strtotime($leaveDetails->date_applied_cal));
				if ($is_emergency_check && $elSetting != 0 && $new_type != "NPL") {
					if ($dateDiff['invert'] == 0 || (($dateDiff['month'] == 0 && $dateDiff['year'] == 0 && $dateDiff['day'] < $elSetting) && ($this->total_Emergency < $elSetting))) {
						if ($this->total_Emergency < $elSetting) {
							$this->total_Emergency++;
							changeCategory($leaveDetails->leave_id, "Emergency");
							changeTypeOfLeaveList($leaveDetails->leave_id, "Emergency");
							$new_type = "Emergency";
						} else {
							if ($leaveDetails->leave_category == 'Emergency') {
								changeCategory($leaveDetails->leave_id, "Normal");
							}
						}
					}
				} else {
					if ($leaveDetails->leave_category == 'Emergency') {
						changeCategory($leaveDetails->leave_id, "Normal");
					}
				}

				if ($new_type != 'Annual' && $new_type != 'Medical' && $new_type != 'Absent' && $new_type != 'NPL' && $new_type != 'Other_pay' && $new_type != 'Emergency') {
					if ($leaveAllowMaxvalue < $totalLeaveValue) {
						changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
						changeCategory($leaveDetails->leave_id, "Normal");
						$new_type = "NPL";
					}
				} else if ($new_type == 'Emergency') {
					if (($taken + $em_leave + $TakenPastLeaves['annual']) > ($claimable)) {
						changeTypeOfLeaveList($leaveDetails->leave_id, "NPL");
						changeCategory($leaveDetails->leave_id, "Normal");
						$new_type = "NPL";
					}
				}
				
			}
			
			$uname = UserPersonal::where('username',$approverId)->first();
			$name = $uname->name;
			
			if ($email_send_allow) {
				
				if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($new_type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = url()->current();
					$referer = str_replace('approve-leaves', 'approve-leave', url()->current());
					$half_day_type = '';
					if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
						$half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
					}

					$body = "Dear $emp_name<br><br>";
					$body .= "Your leave has been $sStatus<br><br>";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display $half_day_type<br>";
					$body .= "Reason: $reason<br><br>";
					$body .= "Kind regards,<br><br>";
					$body .= "Note: this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";

					$semail = UserPersonal::where('username',$username)->first();
					
					sendemail($semail->email_id,$subject,$body);
				
				    // $details['email_id'] = $semail->email_id;
				    // $details['subject'] = $subject;
				    // $details['body'] = $body;
				    
        //             SendEmailJob::dispatch($details);
                    
				    //Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));

					$message = "Dear $emp_name  ";
					$message .= "Your leave has been $sStatus, ";
					$message .= "Details of the leave are as follows: ";
					$message .= "From: $from_date  ";
					$message .= "To: $to_date  $half_day_type";
					$message .= "Reason: $reason";

					sendSMSToUserFromServer($username, $message);

				} else {
					if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
						$subject = "Leave $new_type";
					} else {
						$subject = "Leave $sStatus";
					}
					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->sdate;
					$to_date = $leaveDetails->edate;
					$type_display = getLeaveNameByType($new_type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = url()->current();
					$referer = str_replace('approve-leaves', 'approve-leave', url()->current());
					
					$half_day_type = '';
					if ($leaveDetails->half_day_type != '' && $leaveDetails->is_half_day != '0') {
						$half_day_type = ($leaveDetails->half_day_type != "first") ? "(PM)" : "(AM)";
					}


					$body = "<tr>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
					$body .= "<td>$type_display Leave $half_day_type<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					$body .= "<td>$reason</td>";
					if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {
						$body .= "<td>" . ucwords($new_type) . "</td>";
					} else {
						$body .= "<td>" . ucwords($sStatus) . "</td>";
					}
					$body .= "</tr>";

					if ($new_type == "NPL" && $npl_to_hr == '1' && !in_array($login_username, $hr_id_array)) {

						for ($npl_hr_i = 0; $npl_hr_i < count($nplHRUsers); $npl_hr_i++) {
							pendingEmailInsert($nplHRUsers[$npl_hr_i]->name, $nplHRUsers[$npl_hr_i]->employee_id, $body, $subject, $sStatus, $leaveDetails->username);
						}
					} else {
						pendingEmailInsert($emp_name, $username, $body, $subject, $sStatus, $leaveDetails->username);
					}
				}
			}
		}
		if ($_id == '') {
			return array(
				'result' => $result,
			);
		}
    }
    
    function update_leave_approver($leave_id,$approver_id='',$status='',$cancel_reason='',$reject_reason=''){
        $query = "insert into approver_approved_leaves (leave_days_id, approver_id) values ('$leave_id', '$approver_id')";
		DB::select($query);
		
		$query = "insert into timeline_leaves_detail (leave_days_id, approver_id,status,reject_reason,cancellation_reason) values ('$leave_id', '$approver_id','$status','$reject_reason','$cancel_reason')";
        DB::select($query);
        
        //if($approver_id!=''){
            // $query1 = "update leave_approver set status = '1' where leave_id='$leave_id' AND approver_id='$approver_id'";
        //}else{
            // $query1 = "update leave_approver set status = '1' where leave_id='$leave_id'";
        //}
        // DB::select($query1);
	}
	
	function update_leave_approver11($leave_id,$approver_id='',$status='',$cancel_reason,$reject_reason){
        
		$query = "insert into timeline_leaves_detail (leave_days_id, approver_id,status,reject_reason,cancellation_reason) values ('$leave_id', '$approver_id','$status','$reject_reason','$cancel_reason')";
        DB::select($query);
        
    }
    
    function UpdateApproverOfLeave($_id = '', $_approver_id = '', $_status,Request $request,$user,$uname,$emailSendingStatus,$sendbypreference)
	{
		
		$approverId = $_approver_id;
		$id = $_id;
		$leaveDetails = getLeaveDetails($id);
		$masterApprover = NextApproverOfLeave($approverId, $leaveDetails->username);
		
		if ($masterApprover != $approverId && $masterApprover != '') {

			setAssignee($id, $masterApprover);

			
			$name = $uname->name;
			

			$email_send_allow = true;
			if ($sendbypreference) {
				if (!hasContentPreference($leaveDetails->username)) {
					$email_send_allow = true;
				} else {
					$email_send_allow = false;
				}
			}
			$sStatus='';
			if ($email_send_allow) {
				if ($emailSendingStatus == '0') {
					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->start_date;
					$to_date = $leaveDetails->end_date;
					$type_display = getLeaveNameByType($leaveDetails->type);

					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;
					$referer = str_replace('self-leaves', 'dashboard', url()->current());

					$body = "Leave has been Approved by $name and need your approval on this same. ";
					$body .= "Details of the leave are as follows:<br><br>";
					$body .= "Employee Name: $emp_name<br>";
					$body .= "From: ".date('d-m-Y',strtotime($from_date))."<br>";
					$body .= "To: ".date('d-m-Y',strtotime($to_date))."<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")<br><br>"; 
					}
					$body .= "Type: $type_display<br>";
					$body .= "Reason: $reason<br>";
					$body .= "Link: <a href='$referer'>$referer</a><br><br>";
					$body .= "Kind regards,";
					$body .= "Note, this is an automatic email. Please do not reply. ";
					$body .= "If you did not request this information, please ignore this message. ";
					$body .= "If you have any questions, please contact us";
					
					$semail = UserPersonal::where('username',$masterApprover)->first();
					//Mail::to($semail->email_id)->send(new MyDemoMail($body,$subject));
					sendemail($semail->email_id,$subject,$body);
				// 	$details['email_id'] = $semail->email_id;
				//     $details['subject'] = $subject;
				//     $details['body'] = $body;
				    
    //                 SendEmailJob::dispatch($details);
                    
				} else {

					$subject = "Leave $sStatus";

					$emp_name = $leaveDetails->name;
					$from_date = $leaveDetails->start_date;
					$to_date = $leaveDetails->end_date;
					$type_display = getLeaveNameByType($leaveDetails->type);
					$reason = $leaveDetails->reason;
					$username = $leaveDetails->username;


                    $referer = str_replace('approve-leaves', 'approve-leave', url()->current());
                    
					$body = "<tr>";
					$body .= "<td>$emp_name</td>";
					$body .= "<td>".date('d-m-Y',strtotime($from_date))."</td>";
					$body .= "<td>".date('d-m-Y',strtotime($to_date))."</td>";
					$body .= "<td>$type_display Leave<br>";
					if($leaveDetails->is_hourly == 1){
					    $startTime =  date("h:i A", $leaveDetails->start_time);
                        $endTime = date("h:i A", $leaveDetails->end_time);
                        $body .= "Time: (".$startTime." to ".$endTime.")</td>"; 
					}
					$body .= "<td>$reason</td>";
					$body .= "<td>" . ucwords($sStatus) . "</td>";
					$body .= '<td>Link: <a href="'.$referer.'">'.$referer.'</a></td>';
					$body .= "</tr>";

					pendingEmailInsert($emp_name, $masterApprover, $body, $subject, $sStatus, $leaveDetails->username);
				}
			}

			return false;
		}
		return true;
    }
    
    function get_approver_by_leaveid($id){
        // $builder = DB::table('leave_approver')->where('status','0')->where('leave_id',$id)->selectRaw("count(id) as value")->first();
		// $result = $builder->value;
		$result=0;
         return $result;
    }

    function setStatus11($id, $status)
	{
		$query = "update leave_days set status='$status' where id='$id'";
		$builder = DB::select($query);
		$resultVal = $builder;
		
		$builder = DB::table('leave_days')->where('id',$id)->selectRaw("leave_id")->first();;
		$leaveId = $builder->leave_id;
		$approved = '';
		if($status=='1'){
			$approved = ", date_approved='".date('Y-m-d')."'";
		}
		$query = "update leave_list set status='$status'".$approved." where id='$leaveId'";
		$builder = DB::select($query);
        return $resultVal;
        
    }
    
    function getNPL_HR_User(){
		
		$builder = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg','mep.permission_group_id','=','pg.id')->leftjoin('user_personal as up','mep.employee_id','=','up.username')->where('pg.hr',3)->selectRaw("mep.employee_id,up.name")->get();
		$result = $builder;
        return $result;
        
    }
    
    function getLeaveDetails($id)
	{
		$hours = gethours();
		$builder = DB::table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->leftjoin('user_personal as c','a.username','=','c.username')->where('a.id',$id)->selectRaw("a.id, a.leave_id, a.username, c.name, c.employee_no, b.type, DATE_FORMAT(b.date_applied, '%m/%d/%Y') as date_applied_cal, DATE_FORMAT(b.date_applied, '%d/%m/%Y') as date_applied, DATE_FORMAT(a.date, '%d/%m/%Y') as start_date,a.date as sdate, a.date as edate, DATE_FORMAT(a.date, '%m/%d/%Y') as start_date_cal, DATE_FORMAT(a.date, '%d/%m/%Y') as end_date, CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END as 'no_days', a.status, b.reason, b.leave_category as leave_category, b.approver_id, a.cancellation_reason, b.half_day_type,b.is_half_day,  b.start_time,b.end_time, b.is_hourly  ")->get();
		//dd($builder);
		$result = $builder[0];
		
		return $result;
	}

    function updateLeaveDays($reason,$leaveId,$which='cancel'){
		if($which=='cancel'){
			$query = "update leave_days set cancellation_reason='$reason' where id='$leaveId'";
			$result2 = DB::select($query);
		}
		if($which=='reject'){
			$query = "update leave_days set reject_reason='$reason' where id='$leaveId'";
			$result2 = DB::select($query);
		}
		
    }

    function setAssignee($id, $assignee)
	{
		$query = DB::table('leave_days')->where('id',$id)->selectRaw("leave_id")->first();
		$leaveId = $query->leave_id;
		
		$query = "update leave_list set approver_id='$assignee' where id='$leaveId'";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    function pendingEmailInsert($emp_name, $to,$body,$subject,$leave_type,$username){
    
		$query = "insert into pending_emails (`emp_name`, `email_to`, `email_body`, `email_subject`, `leave_status`, `sent_status`, `leave_username`) values ('$emp_name', '$to', '$body', '$subject', '$leave_type','0','$username')";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    function getCancelLeave_Approver(){
        
        $query = DB::table('map_employee_permission as mep')->leftjoin('permission_group as pg','mep.permission_group_id','=','pg.id')->leftjoin('user_personal as up','mep.employee_id','=','up.username')->where('pg.cancel_leave','1')->selectRaw("mep.employee_id, up.username")->get();
		$result = $query;
		return $result;
    }
    
    function getMaxValue($leave_type,$category){
		$builder = DB::table('category_max_leave')->where('leave_type',$leave_type)->where('category',$category)->first();
		if($builder!='')
		$result = $builder->max_value;
		else
		$result=0;
		
		return $result;
    }
    
    function getLeaveAccordingToTypeCount($year,$username,$type,$status='1')
	{
		$builder = DB::table('leave_list')->where('type',$type)->where('username',$username)->where('status',$status)->whereYear('start_date',$year)->count();
		$result = $builder;
		return $result;
    }

    function changeType($id, $type)
	{
		$listId = getLeaveListId($id);
		$query = "update leave_list set type='$type' where id='$listId'";
		$builder = DB::select($query);
		$result = $builder;
		return $result;
    }
    
    function getYearlyEntitleMain($username = '', $year = '' , $in_json = true, $date = '', $updt = '',$cutOffMonth,$cutOffDate,$cutOffStartMonth,$cutOffStartDate,$SettingLeaveAdjustmentType,$SoftwareStartDate,$companyName11,$medical_pro_rated)
	{
	    $date_for_query = "CURDATE()";
		$hourlyLeave = getSettingsValue('hourlyLeave');
		$userPay = DB::table('user_pay')->where('username' , $username)->first();
		
		
		if ($SettingLeaveAdjustmentType == 8) {
			$joiningDate = $userPay->date_commence;
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
				if (date('Y-m-d') < $curr_date) {
					$year = $year - 1;
				}
			
		}
		

		$companyName='';
		if($companyName11!='')
		$companyName = $companyName11->value;

		$isShowClaimable = getConfirmDisplay($username);

		$date_commence = $userPay->date_commence;
		$joiningDate = strtotime($date_commence);

		$cutOffStartYear = $year;
		$cutOffYear = $year;
		if($cutOffStartMonth!=1){
			if($cutOffStartMonth > date('m')){
				$cutOffStartYear = $year;
				$cutOffYear = $year;
			}else{
				$cutOffStartYear = $year-1;
				$cutOffYear = $year;
			}
		}else{
			$cutOffStartYear = $year;
			$cutOffYear = $year;
		}
		
		$RL_forfeit = getForfeitAdjLeaveCount($username, $year);

		$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
		$medicalEntitle = getYearWiseFixLeaveEntitle($username, "Medical", ($year) . "-".$cutOffMonth."-".$cutOffDate);
		
		
		$joiningDate = $userPay->date_commence;
		$joiningDateArr = explode('-', $joiningDate);
		if ($medical_pro_rated == 1) {


			$joining_year = $joiningDateArr[0];
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			$resultArrayVal = DB::table('user_pay')->where('username',$username)->selectRaw("TIMESTAMPDIFF(YEAR, date_commence," . $date_for_query . ") as experience, date_commence")->first();

			$ExperienceInYear = intval($resultArrayVal->experience) + 1;
			$joiningdatecurrent = $year . '-' . $joining_month . '-' . $joining_date;

			//section one	
			$prev_date_of_joining_date = date('Y-m-d', strtotime('-1 day', strtotime($joiningdatecurrent)));
			$start = $year . "-".$cutOffStartMonth."-".$cutOffStartDate;
			$datediff = strtotime($prev_date_of_joining_date) - strtotime($start);
			$days1 = round($datediff / (60 * 60 * 24));

			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($prev_date_of_joining_date);
			$diff = $date1->diff($date2);
			$experiance1 = $diff->y;
			if ($experiance1 == 0) {
				$experiance1 = 1;
			}
			

			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance1)->where('b.username', $username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$medicalEntitlenew1 = $builder1[0]->no_leaves;
			$d1 = ($days1 / 365) * $medicalEntitlenew1;

			$a1 = array(
				'username' => $username,
				'joining date' => $joiningDate,
				'entitle' => $medicalEntitlenew1,
				'start date' => $start,
				'end date' => $prev_date_of_joining_date,
				'days' => $days1,
				'experiance' => $experiance1,
			);
			//section one

			//section two
			$end_date = $year . "-".$cutOffMonth."-".$cutOffDate;
			$datediff2 = strtotime($end_date) - strtotime($joiningdatecurrent);
			$days2 = round($datediff2 / (60 * 60 * 24));

			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($end_date);
			$diff = $date1->diff($date2);
			$experiance2 = $diff->y;
			if ($joiningdatecurrent <= date('Y-m-d')) {
				$experiance2 = $experiance2 + 1;
			}
			$builder1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Medical')->where('a.experience','<=', $experiance2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$medicalEntitlenew = $builder1[0]->no_leaves;
			$d2 = ($days2 / 365) * $medicalEntitlenew;

			$a2 = array(
				'username' => $username,
				'joining date' => $joiningDate,
				'entitle' => $medicalEntitlenew,
				'start date' => $end_date,
				'end date' => $joiningdatecurrent,
				'days2' => $days2,
				'experiance' => $experiance2,
			);
			
			if ($medicalEntitlenew1 != '' && $medicalEntitlenew != '') {
				if ($medicalEntitlenew1 != $medicalEntitlenew) {
					$medicalEntitle = round($d1 + $d2);
				} else {
					if ($medicalEntitlenew1 != '') {
						$medicalEntitle = $medicalEntitlenew1;
					} else if ($medicalEntitlenew != '') {
						$medicalEntitle = $medicalEntitlenew;
					}
				}
			}
		}
		
		$resiged_date_str = $userPay->date_resigned;
		$joiningDate = $userPay->date_commence;
		$joiningDateArr = explode('-', $joiningDate);
		$resignDateArr = explode('-', $resiged_date_str);
		$resign_year = $resignDateArr[0];
		$joining_year = $joiningDateArr[0];
		if ($resiged_date_str != '' && $resiged_date_str != '0000-00-00') {
			$joining_year = $joiningDateArr[0];
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($joiningdatecurrent);
			$diff = $date1->diff($date2);
			$experiance1 = $diff->y;
			$experiance1 = $experiance1 + 1;
			

			
			if ($joining_year < $year && $resign_year == $year) {
				$joining_year = $joiningDateArr[0];
				$joining_month = $joiningDateArr[1];
				$joining_date = $joiningDateArr[2];
				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
				$date1 = new DateTime($joiningDate);
				$date2 = new DateTime($joiningdatecurrent);
				$diff = $date1->diff($date2);
				$experiance_1 = $diff->y;
				if ($experiance_1 == 0) {
					$experiance_1 = 1;
				}
				
				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$annualEntitle_1 = $builder_1[0]->no_leaves;

				$experiance_2 = $experiance_1 + 1;
				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$pro = 0;
				$annualEntitle_2 = $builder_2[0]->no_leaves;
				
				if (($annualEntitle_1 != $annualEntitle_2)  && strtotime($joiningdatecurrent) < strtotime($resiged_date_str)) {
					$pro = 1;
					$datediff11 = strtotime($joiningdatecurrent) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
					$days1 = round($datediff11 / (60 * 60 * 24));
					$datediff22 = strtotime($resiged_date_str) - strtotime($joiningdatecurrent);
					$days2 = round($datediff22 / (60 * 60 * 24));
					$first_dif = ($days1 / 365) * $annualEntitle_1;
					$second_dif = ($days2 / 365) * $annualEntitle_2;
					$annualEntitle = ($first_dif + $second_dif);
					
				} else {
					$datediff2 = strtotime($resiged_date_str) - strtotime($cutOffStartYear . "-".$cutOffStartMonth."-".$cutOffStartDate);
				}
				//echo $annualEntitle;exit;
			} else if ($joining_year < $year && $resign_year > $year) {
				$joining_year = $joiningDateArr[0];
				$joining_month = $joiningDateArr[1];
				$joining_date = $joiningDateArr[2];
				$joiningdatecurrent = $cutOffYear . '-' . $joining_month . '-' . $joining_date;
				$date1 = new DateTime($joiningDate);
				$date2 = new DateTime($joiningdatecurrent);
				$diff = $date1->diff($date2);
				$experiance_1 = $diff->y;
				if ($experiance_1 == 0) {
					$experiance_1 = 1;
				}
				
				$builder_1 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_1)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$annualEntitle_1 = $builder_1[0]->no_leaves;

				$experiance_2 = $experiance_1 + 1;
				$builder_2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $experiance_2)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
				$pro = 0;
				$annualEntitle_2 = $builder_2[0]->no_leaves;
				if ($annualEntitle_1 != $annualEntitle_2) {
					$pro = 1;
					$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($cutOffYear) . "-".$cutOffMonth."-".$cutOffDate);
				}
			} else if ($joining_year == $year && $resign_year == $year) {
			    	$pro = 0;
				$datediff2 = strtotime($resiged_date_str) - strtotime($joiningDate);
			} else if ($joining_year == $year && $resign_year > $year) {
			    	$pro = 0;
				$datediff2 = strtotime($cutOffYear . "-".$cutOffMonth."-".$cutOffDate) - strtotime($joiningDate);
			}

			
			$days = round($datediff2 / (60 * 60 * 24));
			$annualEntitle1 = $days / 365;
			if ($joining_year < $year && $resign_year > $year) {
				if ($pro == 0) {
					$annualEntitle = $annualEntitle;
				}
			} else {
				if ($pro == 0) {
					$annualEntitle = $annualEntitle;
				}
			}
		}
		

		if ($SettingLeaveAdjustmentType == 8 || $SettingLeaveAdjustmentType == 1) {
			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$joiningDate = $userPay->date_commence;

			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			$curr_date = date('Y-m-d', (strtotime('+1 day', strtotime($curr_date))));
			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($curr_date);
			$diff = $date1->diff($date2);
			$ExperienceInYear = $diff->y;
			if ($diff->d > 0) {
				$ExperienceInYear = $ExperienceInYear + 1;
			}

			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			$annualEntitle = $builder2[0]->no_leaves;
			
		} else if ($SettingLeaveAdjustmentType == 6  && $joining_year != Date('Y')) {
			$annualEntitle = getYearWiseFixLeaveEntitle($username, "Annual", ($year) . "-".$cutOffMonth."-".$cutOffDate);
			$joiningDate = $userPay->date_commence;
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];

			if($year!=""){
				
				if($year == date('Y')){
					$curr_date = date($year.'-m-d');
				}else {
					$curr_date = ($year) . "-".$cutOffMonth."-".$cutOffDate;
				}
				
			}else{
				$curr_date = date('Y-m-d');
			}


			$date1 = new DateTime($joiningDate);
			$date2 = new DateTime($curr_date);
			$diff = $date1->diff($date2);
			$ExperienceInYear = $diff->y;
			$actual_ExperienceInYear = $ExperienceInYear;

			if ($diff->d > 0 || $joiningDate == $curr_date) {
				$ExperienceInYear = $ExperienceInYear + 1;
			}
			if ($ExperienceInYear == 0 && ($diff->m > 0 || $diff->d > 0)) {
				$ExperienceInYear = 1;
			}
			
			$builder2 = DB::table('leave_entitle as a')->leftjoin('user_category as b','a.category_name','=','b.category')->leftjoin('user_pay as c','b.username','=','c.username')->where('a.type','Annual')->where('a.experience','<=', $ExperienceInYear)->where('b.username',$username)->selectRaw("max(a.no_leaves) as no_leaves")->get();
			if($actual_ExperienceInYear>0){
				$annualEntitle = $builder2[0]->no_leaves;
			}
		}
		$rlLeave = getReplacementLeaveCount($username, $year);
		$annaualTaken = getTakenLeaveCount($username, $year, "Annual");
		$medicalTaken = getTakenLeaveCount($username, $year, "Medical");
		$pastLeaves = getTakenPastLeaves($username, $year);
		$adjustmentLeaves = getAdjustmentLeaveCount($username, $year, 1);
		if ($SoftwareStartDate <= ($year - 1)) {
			$bfAnnual = getBFValue($year - 1, $username, ($year) . "-".$cutOffMonth."-".$cutOffDate);
		} else {
			$bfAnnual = 0;
		}
		
		$EmergencyLeaveValue = getEmergencyLeaveCountByUser($username, $year);
		$bfAnnualAdj = getBroughtForwardLeaveCount($username, $year, "Annual");
		$bfMedical = getBroughtForwardLeaveNotAdjusted($username, $year, "Medical");
		$bfMedicalAdj = getBroughtForwardLeaveCount($username, $year, "Medical");
		$nplCount = getNPLCount($username, $year);

		if($cutOffStartMonth!='1'){
			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $cutOffStartYear, $cutOffStartMonth, $cutOffStartDate);
		}else{
			$BFLeaveTaken = getCountOfBFLeaveTaken($username, $year);
		}
		

		

		if ($BFLeaveTaken > $bfAnnual) {
			$BFLeaveTaken = $bfAnnual;
		}


		$tilldateDaysVal = tilldateDays($date_commence);
		$tillYearEndDaysVal = tillYearEndDays($date_commence);
		$YearStartToJoinDaysVal = YearStartToJoinDays($date_commence);

		$resiged_date_str = $userPay->date_resigned;
		$resiged_date = strtotime($resiged_date_str);
		$resiged_year = date('Y', $resiged_date);

		if ($date != '') {
			$leave_month = date("n", strtotime(str_replace('/', '-', $date)));
			$leave_year = date("Y", strtotime(str_replace('/', '-', $date)));
		} else {
			$leave_month = date("n");
			$leave_year = date("Y");
		}

		if ($SettingLeaveAdjustmentType == 8) {
			$annual_ent = get_anniv_cutt_off_entitle($username, $year);
			$cut_off_days = day_count_anniv_cutt_off($username, $year);
			$earn = ($cut_off_days / 365) * $annual_ent;
			if($hourlyLeave == 1){
			  $earn = round($earn,3);  
			} else {
			   $earn = roundaway($earn); 
			}
			
		} else {
			if ($year < $leave_year) {
			    if($hourlyLeave == 1){
			        $earn = round($annualEntitle,3);
			    } else {
			       $earn = roundaway($annualEntitle); 
			    }
				
			} else {
				if($cutOffStartMonth!=1 && $cutOffMonth <= $leave_month && $year<=$leave_year){
				    if($hourlyLeave == 1){
				        $earn = round($annualEntitle,3);
				    } else {
				      $earn = roundaway($annualEntitle);  
				    }
					
				}else if ($year == $resiged_year) {
					if ($leave_month < date('n', $resiged_date)) {
					    if($hourlyLeave == 1){
					        $earn = round(($leave_month /  date('n', $resiged_date)) * round($annualEntitle,3),3);
					    } else {
					       $earn = roundaway(($leave_month /  date('n', $resiged_date)) * roundaway($annualEntitle));
					    }
					
					} else {
					   if($hourlyLeave == 1){
					       $earn = round(round($annualEntitle,3),3);
					   } else {
					       $earn = roundaway(roundaway($annualEntitle));
					   }
						
					}
				} else {
					if ($SettingLeaveAdjustmentType == 4 && $tillYearEndDaysVal < 365) {
					    if($hourlyLeave == 1){
					        $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
					    } else {
					        $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
					    }
					
					} else {
						if ((date("n", strtotime($joiningDate)) == $leave_month) && date("Y", strtotime($joiningDate)) == $leave_year) {
						    if($hourlyLeave == 1){
						        $earn = round((round($annualEntitle,3) / $tillYearEndDaysVal) * $tilldateDaysVal,3);
						    } else {
						        $earn = roundaway((roundaway($annualEntitle) / $tillYearEndDaysVal) * $tilldateDaysVal);
						    }
						
						} else {
							if($cutOffStartMonth>$leave_month){
								if(date("Y", strtotime($joiningDate)) == $leave_year){
									$month_cal = $leave_month - $joiningDateArr[1];
								}else{
									if($joining_year==($leave_year-1) && $cutOffStartMonth>$joiningDateArr[1]){
										$month_cal_1 = 12 - $cutOffStartMonth;
									}else if($joining_year==($leave_year-1)){
										$month_cal_1 = 12 - $joiningDateArr[1];
									}else{
										$month_cal_1 = 12 - $cutOffStartMonth;
									}
									$month_cal = $month_cal_1 + $leave_month;
								}
								$month_cal = $month_cal +1;
								
							}else{
								$month_cal = $leave_month - $cutOffStartMonth;
								$month_cal = $month_cal +1;
							}
							if (date("Y", strtotime($joiningDate)) == $leave_year) {
								if ($companyName == "earn_prorated") {
								    if($hourlyLeave == 1){
								        $earn = round((round($annualEntitle,3) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal,3);
								    } else {
								        $earn = roundaway((roundaway($annualEntitle) / (365 - $YearStartToJoinDaysVal)) * $tilldateDaysVal);
								    }
									
								} else {
								    if($hourlyLeave == 1){
								        $earn = round(($month_cal / 12) * round($annualEntitle,3),3);
								    } else {
								        $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));
								    }
									
								}

								
								if ($month_cal == 12) {
								    if($hourlyLeave == 1){
								        $earn = round($annualEntitle,3);
								    } else {
								      $earn = roundaway($annualEntitle);  
								    }
									
								}
							} else {
								 if($hourlyLeave == 1){
								     $earn = round(($month_cal / 12) * round($annualEntitle,3),3);
								 } else {
								   $earn = roundaway(($month_cal / 12) * roundaway($annualEntitle));  
								 }
								
							}
						}
					}
				}
			}
		}
		$annualEntitle_arr = explode('.', number_format($annualEntitle, 2));
		if (isset($annualEntitle_arr[1])) {
			
			if ($annualEntitle_arr[1] > 1 && $annualEntitle_arr[1] <= 25) {
				$annualEntitle = floor($annualEntitle);
			} else if ($annualEntitle_arr[1] >= 26 && $annualEntitle_arr[1] <= 75) {
				$annualEntitle = $annualEntitle;
			} else if ($annualEntitle_arr[1] > 75) {
				$annualEntitle = ceil($annualEntitle);
			} else {
				$annualEntitle = $annualEntitle;
			}

		} else {
			$annualEntitle = $annualEntitle;
		}


		$rlLeaveTaken = getCountOfAdjLeaveTaken($username, $year);
		$bfAdjLeaveTaken = getCountOfBFAdjLeaveTaken($username, $year, $bfAnnual, $bfAnnualAdj);
        if($hourlyLeave == 1){
             $aentitle = round($annualEntitle,3);
        } else {
            $aentitle = getValue($annualEntitle);
        }
		$yearlyEntitle = array(
			"annual" => array(
				"entitle" => $aentitle,
				"taken" => floatval($annaualTaken),
				"rlLeave" => floatval($rlLeave),
				"rlLeaveTaken" => $rlLeaveTaken,
				"rlForfeit" => $RL_forfeit,
				"isShowClaimable" => $isShowClaimable
			),
			"medical" => array(
				"entitle" => floatval($medicalEntitle),
				"taken" => floatval($medicalTaken)
			),
			"past_leaves" => $pastLeaves,
			"adjust_leaves" => $adjustmentLeaves,
			"npl" => $nplCount,
			"earn" => $earn,
			"EmergencyLeaveValue" => $EmergencyLeaveValue,
			"brought_forward" => array(
				"annual" => ($bfAnnual),
				"annual_taken" => floatval($BFLeaveTaken),
				"annual_adj" => ($bfAnnualAdj),
				"bfAdjLeaveTaken" => ($bfAdjLeaveTaken),
				"medical" => $bfMedical,
				"medical_adj" => $bfMedicalAdj
			),
			"date_commence" => $date_commence
		);

		$totalDaysTillToday =  tillTodayTotalDays($year, $date);

		// $BFClearDuration11 = DB::table('settings')->where('field', "bf_duration")->first();
		// $BFAdjClearDuration11 = DB::table('settings')->where('field', "bf_adj_duration")->first();
		
		$users=DB::table('users')->where('username',$username)->first();
		$usercat =DB::table('user_category')->where('username',$username)->first();
		$BFClearDuration11 = DB::table('bf_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();
				
		$BFAdjClearDuration11 = DB::table('bf_adj_duration')->where('category_name', $usercat->category)->where('company_id',$users->company_id)->first();

        $BFClearDuration = $BFClearDuration11->value;
		$BFAdjClearDuration = $BFAdjClearDuration11->value;
		
		$yearlyEntitle['bf_forfeit'] = 0;
		$yearlyEntitle['bfadj_forfeit'] = 0;
		$yearlyEntitle['adj_forfeit'] = 0;

		$bf_forfeit_value = 0;
		$bfadj_forfeit_value = 0;

		$checking_leave_year = $leave_year;
		if($cutOffStartMonth!=1){
			if($cutOffStartMonth>=$leave_month){
				$checking_leave_year = $leave_year+1;
			}
		}

		if (($BFClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFClearDuration < 365) {
			$yearlyEntitle['bf_forfeit'] = 1;
			$bf_forfeit_value = $bfAnnual - $BFLeaveTaken;
		}

		if (($BFAdjClearDuration < $totalDaysTillToday || $year != $checking_leave_year) && $BFAdjClearDuration < 365) {
			$yearlyEntitle['bfadj_forfeit'] = 1;
			$bfadj_forfeit_value = $bfAnnualAdj - $bfAdjLeaveTaken;
		}
        if($hourlyLeave == 1){ 
            $total_forfeit = round($bf_forfeit_value + $bfadj_forfeit_value,3);
        } else {
            $total_forfeit = roundaway($bf_forfeit_value + $bfadj_forfeit_value);
        }
	
		
		//$preset1 = DB::table('settings')->where('field', "claimable_pre_set")->first();
		$user=DB::table('users')->where('username',$username)->first();
        $usercat =DB::table('user_category')->where('username',$username)->first();
        $preset1 = DB::table('claimable_pre_set')->where('category_name', $usercat->category)->where('company_id',$user->company_id)->first();
		$preset = $preset1->value;
		$earn1 = ($earn - $preset);
		$ear1 = ($preset / 12) * $annualEntitle;
		$earn1 = $earn - $ear1;
		if ($SettingLeaveAdjustmentType == 8) {
			$_claim = ($bfAnnual + $bfAnnualAdj + $earn) - $total_forfeit;
		} else {
			if ($year < date('Y')) {
				if ($earn1 > $annualEntitle) {
					$earn2 = $annualEntitle;
				} else {
					$earn2 = $earn1;
				}
				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
				
			} else {
				if ($earn1 > $annualEntitle) {
					$earn2 = $annualEntitle;
				} else {
					$earn2 = $earn1;
				}
				$_claim = ($bfAnnual + $bfAnnualAdj + $earn2) - $total_forfeit;
				
			}
			if($hourlyLeave == 1){ 
			    $_claim = round($_claim,3);
			 } else {
			    $_claim = roundaway($_claim); 
			 }
			
			if ($_claim < 0) {
				$_claim = 0;
			}
		}
		
		$confirm_disp1 = DB::table('settings')->where('field', "confirm_display")->first();
    	$confirm_disp = $confirm_disp1->value;
		$user_pay = DB::table('user_pay as a')->where('a.username', $username)->selectRaw("a.job_title, a.branch_id, b.name as branch, a.department_id, c.name as department, a.category_id, d.name as category, DATE_FORMAT(a.date_commence, '%d-%m-%Y') as date_commence, DATE_FORMAT(a.date_prompted, '%d-%m-%Y') as date_prompted, DATE_FORMAT(a.date_resigned, '%d-%m-%Y') as date_resigned, DATE_FORMAT(a.date_confirmed, '%d-%m-%Y') as date_confirmed, a.pay_rate_type, a.pay_method, a.pay_status, a.contract")->leftjoin('branch as b','a.branch_id','=','b.id')->leftjoin('department as c','a.department_id','=','c.id')->leftjoin('category as d','a.category_id','=','d.id')->first();
		if ($confirm_disp == '1') {
			$user_pay->date_confirmed." -- ";
			if ($user_pay->date_confirmed == '' || $user_pay->date_confirmed == '00-00-0000') {
				$_claim = 0;
			}
		}
		
		if (date("Y", strtotime($joiningDate)) == $leave_year) {


			if ($yearlyEntitle['annual']['isShowClaimable'] == 0) {
				$yearlyEntitle["claimable"] = 0;
			} else {
				
				$yearlyEntitle["claimable"] = $yearlyEntitle['earn'];
			}
		} else {
			$yearlyEntitle["claimable"] = $_claim;
		}
		if($hourlyLeave == 1){ 
		    $yearlyEntitle["balance"] = round($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit,3);
		
		} else {
		 $yearlyEntitle["balance"] = roundaway($yearlyEntitle['brought_forward']['annual'] + $yearlyEntitle['brought_forward']['annual_adj'] + $yearlyEntitle['annual']['entitle'] - ($yearlyEntitle['EmergencyLeaveValue'] + $yearlyEntitle['annual']['taken'] + $yearlyEntitle['past_leaves']['annual']) - $total_forfeit);
		}
		if ($in_json) {
			return json_encode($yearlyEntitle);
		} else {
			return $yearlyEntitle;
		}
	}
	
	function getTakenPastLeaves2($username, $leavedate, $year)
	{
		$leavedate = str_replace('/','-',$leavedate);
		$leavedate = date('Y-m-d',strtotime($leavedate));
		
		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
		$builder = DB::table('leave_past')->where('type','Annual')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw('sum(total_leave_days) as no_leave')->first();
		$noleave ="";
		if(!empty($builder)){
			$noleave=$builder->no_leave ?? 0;
		}
		
		$annualLeaves = floatval($noleave);
			
		$builder1 = DB::table('leave_past')->where('type','Medical')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw('sum(total_leave_days) as no_leave')->first();
		$mnoleave ="";
		if(!empty($builder1)){
			$mnoleave=$builder1->no_leave ?? 0;
		}
		$medicalLeaves = floatval($mnoleave);
		
		$builder2 = DB::table('leave_past')->where('type','Other_pay')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw('sum(total_leave_days) as no_leave')->first();
		$onoleave ="";
		if(!empty($builder2)){
			$onoleave=$builder2->no_leave ?? 0;
		}
		$replacementLeaves = floatval($onoleave);
		
		$builder3 = DB::table('leave_past')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw('sum(total_leave_days) as no_leave')->first();
		$tnoleave ="";
		if(!empty($builder3)){
			$tnoleave=$builder3->no_leave ?? 0;
		}
		$totalLeaves = floatval($tnoleave);
		
		$takenLeaves = array("annual" => $annualLeaves, "medical" =>$medicalLeaves, "replacement"=>$replacementLeaves, "total" => $totalLeaves);
		return $takenLeaves;
	}

	function getTakenLeaveCount2($username, $type, $leavedate, $year)
	{
		$leavedate = str_replace('/','-',$leavedate);
		$hours = gethours();
		$leavedate = date('Y-m-d',strtotime($leavedate));
		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
	
		$builder = DB::table('leave_days as a')->leftjoin('leave_list as b','a.leave_id','=','b.id')->where('a.status','1')->where('b.type',$type)->whereRaw("(date between '$start_date' and '$end_date')")->where("a.username",$username);
		if($type!="Emergency"){
			$builder->where('b.leave_category','!=','Emergency');
		}
		$val = $builder->selectRaw("sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END) as leave_taken")->first();

		$value = $val->leave_taken;
		if($value==''){
			$value = 0;
		}
		
		return $value;
	}

	function getEmergencyLeaveCountByUser2($username,$leavedate,$year)
	{
		$leavedate = str_replace('/','-',$leavedate);
		$leavedate = date('Y-m-d',strtotime($leavedate));

		$userPay = DB::table('user_pay')->where('username',$username)->first();
		$joiningDate = $userPay->date_commence;
		$joiningDateArr=explode('-',$joiningDate);
		$joining_month=$joiningDateArr[1];
		$joining_date=$joiningDateArr[2];
		$curr_date = $year.'-'.$joining_month.'-'.$joining_date;
		if( $leavedate > $curr_date){
			$start_date = $curr_date;
			$end_date = date('Y-m-d',(strtotime ( '+1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($end_date) ) ));
		}else{
			$start_date = date('Y-m-d',(strtotime ( '-1 year' , strtotime ($curr_date) ) ));
			$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ($curr_date) ) ));
		}
		
		
		$builder1 = DB::table('leave_past')->where('type','Emergency')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(total_leave_days) as no_leave")->first();
		
		$result1 = $builder1;
		$past_val = $result1->no_leave;
		
		
		$builder = DB::table('leave_list')->where('type','Emergency')->where('type','!=','NPL')->where('username',$username)->wherebetween('start_date',[$start_date,$end_date])->selectRaw("sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN no_days END) as no_leave")->first();
		
		$result = $builder;
		$all_val = $past_val + $result->no_leave;
		return floatval($all_val);
	}
	
	function changeCategory($id, $category)
	{
		
		$leave = Leavelist::find($id);
       	$leave->leave_category = $category;
		$leave->save();
		return $leave;
	}
	
	
	function getUserNameByRowId($id){
        $user = DB::table('users')->select('username')->where('id' ,$id)->first();
        return $user->username;
    }
    

    function changeTypeOfLeaveList($listid, $type)
	{
		$leave = Leavelist::find($listid);
       	$leave->type = $type;
		$leave->save();
		return $leave;
	}
	
	function NextApproverOfLeave($currentApprover, $user_id)
	{

		$approverArray = getApproversOfEmployee($user_id);
		

		for ($i = 0; $i < count($approverArray); $i++) {
			if ($currentApprover == $approverArray[$i]->username) {
				if (count($approverArray) == ($i + 1)) {
					return $currentApprover;
				} else {
					return $approverArray[$i + 1]->username;
				}
			}
		}
    }
    
    function getLeaveListId($leaveDaysId)
	{
		$builder = DB::table('leave_days')->where('id',$leaveDaysId)->first();
		$result = $builder->leave_id;
		return $result;
	}
    
    
        // for time calculation
    function explode_time($time) { //explode time and convert into seconds
        if(isset($time) && $time != NULL){
            $time = explode(':', $time);
            $time = $time[0] * 3600 + $time[1] * 60;
            return $time;
        }
    }

    function second_to_hhmm($time) { //convert seconds to hh:mm
        $hour = floor($time / 3600);
            
        if ($hour == 0) {
            $hour = "00";
        }elseif($hour <=9){
            $hour = "0".$hour;
        }else{
            $hour = $hour;
        }
        
        $minute = strval(floor(($time % 3600) / 60));
        if ($minute == 0) {
            $minute = "00";
        } else if($minute <= 9) {
            $minute = "0".$minute;
        } else{
            $minute = $minute;
        }
        $time = $hour . ":" . $minute;
        //dd($time);
        return $time;
    }

