<?php 
    require_once realpath(__DIR__ . '/../vendor/autoload.php');

    use Carbon\Carbon;

    include('connection.php');
    
    $cutOffMonth = getSettingsValuels('cut_of_month');
    $cutOffDate=getSettingsValuels('cut_of_date');
    $cutOffStartDate=getSettingsValuels('cut_of_startdate');
    $cutOffStartMonth=getSettingsValuels('cut_of_startmonth');
    $hours = gethoursls();
    
    function gethoursls(){
        return 8;
    }
    
    function checkCountls($functionType, $leaveno, $currentCount)
	{
		$return = false;
		switch ($functionType) {
			case '>':
				if ($currentCount > $leaveno) {
					$return = true;
				}
				break;
			case '=':
				if ($currentCount == $leaveno) {
					$return = true;
				}
				break;
			case '<':
				if ($currentCount < $leaveno) {
					$return = true;
				}
				break;
			case '<=':
				if ($currentCount <= $leaveno) {
					$return = true;
				}
				break;
			case '>=':
				if ($currentCount >= $leaveno) {
					$return = true;
				}
				break;
		}
		return $return;
    }
    
    function getUserBranchIdls($username)
	{
        global $conn;
	    $resultsql="Select branch_id FROM user_pay where username='".$username."'";
		$result = mysqli_fetch_assoc(mysqli_query($conn, $resultsql));
        return $result['branch_id'];
    } 
    
    function getstatebybranchls($id)
	{
        global $conn;
	    $idssql="SELECT * FROM branch where id=$id";
	    $idssql1="SELECT * FROM branch where id=$id";
	    $total = mysqli_num_rows(mysqli_query($conn, $idssql1));
		$ids = mysqli_fetch_assoc(mysqli_query($conn, $idssql));
		if($total>0){
			return $ids['state'];
		}else{
			return '';
		}
    }
    
    function getUserGroupsls($username) {
        global $conn;
        $resultsql="Select branch_id, department_id, category_id FROM user_pay where username='".$username."'";
		$result = mysqli_fetch_assoc(mysqli_query($conn, $resultsql));
        return $result;
    }
    
    function getSettingsValuels($field = 'leave_adjustment_type'){
        //var_dump($conn);
        global $conn;
        $sql="SELECT value FROM settings where field='".$field."'";
        $result = mysqli_fetch_assoc(mysqli_query($conn, $sql));
       
        return $result['value'] ?? 0;
    }
    
    function getTakenLeaveCountDateByls($username, $year, $type, $startDate=null, $endDate=null){
        global $conn;
        global $cutOffDate;
        global $cutOffMonth;

        global$cutOffStartDate;
        global $cutOffStartMonth;
        global $hours;

        $query = "select sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours')  WHEN 0 THEN CASE b.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END END) as leave_taken from leave_days a left join leave_list b on a.leave_id=b.id where a.status = 1 and b.type='".$type."'and a.username='".$username."' ";
      
        if($cutOffStartMonth!=1){
            $startYear = $year-1;
        }else{
            $startYear = $year;
        }
    
        if($startDate == null){
            $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
        }
        $query .=  " and a.date >='".$startDate."'";

        if($endDate == null){
            $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
        }
        
        $query .=  " and a.date <='".$endDate."'";
        $value = mysqli_fetch_assoc(mysqli_query($conn, $query));
        
        return $value['leave_taken'] ?? 0;
    }

    function getPastLeaveCountDateByls($username, $year=null, $type=null, $startDate=null, $endDate=null){
        if($year==null){
            $year = date('Y');
        }
        global $conn;
        global $cutOffDate;
        global $cutOffMonth;
    
        global $cutOffStartDate;
        global $cutOffStartMonth;
        global $hours;
    
        $query = "select sum(CASE a.is_hourly WHEN 1 THEN (((a.end_time-a.start_time)/3600 )/'$hours') WHEN 0 THEN a.total_leave_days END) as leave_taken from leave_past a where a.username='".$username."' ";
    
        if($type != null){
            $query .=" and a.type='".$type."'";
        }
        if($cutOffStartMonth!=1){
            $startYear = $year-1;
        }else{
            $startYear = $year;
        }
    
        if($startDate == null){
            $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
        }
        $query .=  " and a.start_date >='".$startDate."'";
        
        if($endDate == null){
            $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
        }
        $query .=  " and a.start_date <='".$endDate."'";
        $value = mysqli_fetch_assoc(mysqli_query($conn, $query));
        //echo $query;
        return $value['leave_taken'] ?? 0;
    }
    
    function getPermissionValuels($group, $username)
	{
	    global $conn;
		$query = "select b.$group as val from map_employee_permission a left join permission_group b on a.permission_group_id=b.id where a.employee_id='".$username."'";
		$builder = mysqli_fetch_assoc(mysqli_query($conn, $query));
        $result = intval($builder['val'] ?? 0);
		return $result;
    }
    
    
    if(isset($_GET['action'])=='pdf'){
        $need_to_check=false;
	    if (isset($_GET['leave_no']) && $_GET['leave_no'] != '') {
			$need_to_check = true;
		}
		if(isset($_GET['year']) && $_GET['year'] != '')
        {
            $year11=$_GET['year'];
            $year=$_GET['year'];
        } else {
            $year11 = date('Y');
            $year= date('Y');
        }
        $days=0; 
        for($month=1;$month<=12;$month++){ 
        $days = $days + cal_days_in_month(CAL_GREGORIAN,$month,$year11);
        }
        $query="Select * FROM users where id='".$_GET['auth_id']."'";
        $user = mysqli_fetch_assoc(mysqli_query($conn, $query));
        
 		$ActiveUserShownStatus = getSettingsValuels('active_user_shown');
		$hr_viewStatus = getPermissionValuels("hr_view_all",$user['username']);
		$permission_val = getPermissionValuels("hr", $user['username']);
		$approverId = $user['username'];
		
        if(isset($_GET['datefrom']) && $_GET['datefrom'] != ''){
            $startDate = $_GET['datefrom'];
        }
        else{
            $startDate ='';
        }
        if(isset($_GET['dateto']) && $_GET['dateto'] != ''){
            $endDate = $_GET['dateto'];
        }
        else{
            $endDate ='';
        }
        
        
        if($cutOffStartMonth!=1){
            $startYear = $year-1;
        }else{
            $startYear = $year;
        }
        if($startDate == null){
        $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
        }
       
        if($endDate == null){
            $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
        }
        
        $query = "SELECT user_personal.username, user_personal.employee_no, user_personal.employee_no as No, user_personal.employee_code, user_personal.name, user_personal.name as Name, b.date_commence, b.date_commence as join_year,b.date_resigned, user_personal.sex, rdce.id as rempcatid ,rdc.id as restdayid, c.state as estate FROM user_personal left join user_pay b on user_personal.username=b.username left join branch c on b.branch_id=c.id left join user_category uc on user_personal.username=uc.username left join rest_day_category_employee rdce on user_personal.username=rdce.employee_id left join rest_day_category rdc on rdce.category_id=rdc.id where user_personal.username IS not NULL and year(b.date_commence)<='".$year11."' and (year(b.date_resigned) >= '".$year11."' or year(b.date_resigned) = 0000)";
        if(isset($_GET['pagetype']) && $_GET['pagetype']=='report'){
            $query .= " and user_personal.isDeleted=0";
        }
            if(isset($_GET['name']) && $_GET['name'] != '')
            {
                $query .= " and (user_personal.name like '".$_GET['name']."%' or user_personal.employee_no like '".$_GET['name']."%')";
            }
            
            if(isset($_GET['branch']) && $_GET['branch'] != '')
            {
                $query .= " and b.branch_id='".$_GET['branch']."'";
            }
                        
            if(isset($_GET['department']) && $_GET['department'] != '')
            {
                $query .= " and b.department_id='".$_GET['department']."'";
            }

            if(isset($_GET['category']) && $_GET['category'] != '')
            {
               $query .= " and b.category_id='".$_GET['category']."'";
            }

            if($ActiveUserShownStatus==1){
                $query .= " and (b.pay_status ='1' or b.pay_status ='0')";
            }
            else{
                $query .= " and b.pay_status ='1'";
            }
            
            if($hr_viewStatus==1){
    		    $query .= " and user_personal.username= '".$approverId."' ";
    		}else if($hr_viewStatus==2){
    			$logged_userGroups = getUserGroupsls($approverId);
    			$query .=" and b.branch_id='".$logged_userGroups['branch_id']."' and  b.category_id='".$logged_userGroups['category_id']."' and b.department_id='".$logged_userGroups['department_id']."'";
    		}else if($hr_viewStatus==3){
    			$logged_userGroups = getUserGroupsls($approverId);
    			$query .=" and b.branch_id='".$logged_userGroups['branch_id']."'";
    			
    		}else if($hr_viewStatus==4){
    			$userbranchId = getUserBranchIdls($approverId);
    			$state_nm = getstatebybranchls($userbranchId);
    			//echo $state_nm;
    			 $query .=" and c.state='".$state_nm."'";
    		}
    		if(!isset($_GET['function_type'])){
    		    if(!isset($_GET['leave_no'])){
            		if(isset($_GET['add_limit']) && $_GET['add_limit']=='yes'){
            		    if($_GET['offset']){
                            $offset = $_GET['offset'];
                        }
                        
                        $leavesdataCount = $_GET['totalemp'];
                        // echo $leavesdataCount;
                        // exit;
                        $length = $leavesdataCount;
                        if(isset($_GET['rlimit'])  && $_GET['rlimit'] > 0){
                            $length = $_GET['rlimit'];
                        }
                        if($length!=null && $length!=''){
                            $query .=" LIMIT $length";
                        }
                        if($offset!=null && $offset!=''){
                            $query .=" OFFSET $offset";
                        }
                      
            		}
    		    }
    		}
         
            $entitle=mysqli_query($conn,$query);
            
            $leavesdata = [];
            while($item = mysqli_fetch_array($entitle)){
                $username=$item['username'];
                $AnnualLeave = getTakenLeaveCountDateByls($username, $year, "Annual", $startDate, $endDate);
    			$AnnualPastLeave = getPastLeaveCountDateByls($username, $year, "Annual", $startDate, $endDate);
    
    			$MedicalLeave = getTakenLeaveCountDateByls($username, $year, "Medical", $startDate, $endDate);
    			$MedicalPastLeave = getPastLeaveCountDateByls($username, $year, "Medical", $startDate, $endDate);
    
    			$MaternityLeave = getTakenLeaveCountDateByls($username, $year, "Maternity", $startDate, $endDate);
    			$MaternityPastLeave = getPastLeaveCountDateByls($username, $year, "Maternity", $startDate, $endDate);
    
    			$MarriageLeave = getTakenLeaveCountDateByls($username, $year, "Marriage", $startDate, $endDate);
    			$MarriagePastLeave = getPastLeaveCountDateByls($username, $year, "Marriage", $startDate, $endDate);
    
    			$CompassionateLeave = getTakenLeaveCountDateByls($username, $year, "Compassionate", $startDate, $endDate);
    			$CompassionatePastLeave = getPastLeaveCountDateByls($username, $year, "Compassionate", $startDate, $endDate);
    
    			$HospitalLeave = getTakenLeaveCountDateByls($username, $year, "Hospital", $startDate, $endDate);
    			$HospitalPastLeave = getPastLeaveCountDateByls($username, $year, "Hospital", $startDate, $endDate);
    
    			$ExaminationLeave = getTakenLeaveCountDateByls($username, $year, "Examination", $startDate, $endDate);
    			$ExaminationPastLeave = getPastLeaveCountDateByls($username, $year, "Examination", $startDate, $endDate);
    
    			$PaternityLeave = getTakenLeaveCountDateByls($username, $year, "Paternity", $startDate, $endDate);
    			$PaternityPastLeave = getPastLeaveCountDateByls($username, $year, "Paternity", $startDate, $endDate);
    
    			$AdvanceLeave = getTakenLeaveCountDateByls($username, $year, "Advance", $startDate, $endDate);
    			$AdvancePastLeave = getPastLeaveCountDateByls($username, $year, "Advance", $startDate, $endDate);
              
    			$ReplacementLeave = getTakenLeaveCountDateByls($username, $year, "Other_pay", $startDate, $endDate);
    			$ReplacementPastLeave = getPastLeaveCountDateByls($username, $year, "Other_pay", $startDate, $endDate);
    
    			$Line_ShutLeave = getTakenLeaveCountDateByls($username, $year, "Line_Shut", $startDate, $endDate);
    			$Line_ShutPastLeave = getPastLeaveCountDateByls($username, $year, "Line_Shut", $startDate, $endDate);
    
    			$AbsentLeave = getTakenLeaveCountDateByls($username, $year, "Absent", $startDate, $endDate);
    			$AbsentPastLeave = getPastLeaveCountDateByls($username, $year, "Absent", $startDate, $endDate);
    
    			$NPLeave = getTakenLeaveCountDateByls($username, $year, "NPL", $startDate, $endDate);
    			$NPLPastLeave = getPastLeaveCountDateByls($username, $year, "NPL", $startDate, $endDate);
    			
    		//	dd($NPLLeave, (float)$NPLLeave, $NPLPastLeave);
    
    			$ELeave = getTakenLeaveCountDateByls($username, $year, "Emergency", $startDate, $endDate);
                $ELPastLeave = getPastLeaveCountDateByls($username, $year, "Emergency", $startDate, $endDate);
                $item["AnnualLeave"] = (float)($AnnualLeave ?? 0) + $AnnualPastLeave ?? 0;
    			$item["MedicalLeave"] = (float)($MedicalLeave ?? 0) + $MedicalPastLeave ?? 0;
    			$item["MaternityLeave"] = (float)($MaternityLeave ?? 0) + $MaternityPastLeave ?? 0;
    			$item["MarriageLeave"] = (float)($MarriageLeave ?? 0) + $MarriagePastLeave ?? 0;
    			$item["CompassionateLeave"] = (float)($CompassionateLeave ?? 0) + $CompassionatePastLeave ?? 0;
    			$item["HospitalLeave"] = (float)($HospitalLeave ?? 0) + $HospitalPastLeave ?? 0;
    			$item["ExaminationLeave"] = (float)($ExaminationLeave ?? 0) + $ExaminationPastLeave ?? 0;
    			$item["PaternityLeave"] = (float)($PaternityLeave ?? 0) + $PaternityPastLeave ?? 0;
    			$item["Advance"] = (float)($AdvanceLeave ?? 0) + $AdvancePastLeave ?? 0;
    			$item["ReplacementLeave"] = (float)($ReplacementLeave ?? 0) + $ReplacementPastLeave ?? 0;
    			$item["Line_ShutLeave"] = (float)($Line_ShutLeave ?? 0 ) + $Line_ShutPastLeave ?? 0;
    			$item["AbsentLeave"] = (float)($AbsentLeave ?? 0) + $AbsentPastLeave ?? 0;
    			$item["NPLeave"] = (float)($NPLeave ?? 0) + $NPLPastLeave ?? 0;
                $item["ELeave"] = (float)($ELeave ?? 0 )+ $ELPastLeave ?? 0;
               array_push($leavesdata, $item);  
            }

            $userLeaveNoArray = array();
    		$no = 0;
    		$usernameArray = array();
            $i=0;
            for($i=0; $i < count($leavesdata); $i++){
                $username=$leavesdata[$i]['username'];
                
                
                 $startdate=Carbon::parse($startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate);
                 
                if($leavesdata[$i]['join_year'] > $startdate){
                    $startdate=Carbon::parse($leavesdata[$i]['join_year']);
                 
                }
                
                $enddate=Carbon::parse($year11.'-'.$cutOffMonth.'-'.$cutOffDate);
            
                $resigned = false;
    
                if($leavesdata[$i]['date_resigned']!='0000-00-00' && $leavesdata[$i]['date_resigned'] < $enddate && $leavesdata[$i]['date_resigned'] > $startdate){
                    $enddate=Carbon::parse($leavesdata[$i]['date_resigned']);
                    $resigned = true;
                }
                
                $query2="Select * FROM rest_days left join rest_dates on rest_days.id=rest_dates.rest_day_id where rest_days.category_id='".$leavesdata[$i]['restdayid']."'";
                
                $query3="Select * FROM public_holiday where (state='".$leavesdata[$i]['estate']."' or state='National') and company_id='".$user['company_id']."' ";
    
                if($enddate=='0000-00-00'){
                    $enddate = Carbon::parse($year11.'-'.$cutOffMonth.'-'.$cutOffDate);
                }
                
                $query2 .=" and (rest_dates.date between '".$startdate."' and '".$enddate."')";
                    
                $query3 .=" and (date between '".$startdate."' and '".$enddate."')"; 
                
                $publicholiday=mysqli_num_rows(mysqli_query($conn, $query3));
                $restdays=mysqli_num_rows(mysqli_query($conn, $query2));
                //   echo $query3;
                $days11=date_diff($startdate, $enddate);
                // print_r($days11->days);
                // $query4="Select sum(total_leave_days) as total FROM leave_past where username='".$username."' and year(start_date)='".$year11."' and status=1";
                
                $query4 = "Select sum(CASE is_hourly WHEN 1 THEN (((end_time-start_time)/3600 )/'$hours') WHEN 0 THEN total_leave_days END) as total FROM leave_past where username='".$username."' and (start_date between '".$startdate."' and '".$enddate."') and status=1";
                
                // $query5="Select sum(b.no_days) as total FROM leave_days left join leave_list b on leave_days.leave_id=b.id where b.username='".$username."' and year(b.start_date)='".$year11."' and b.status=1";
                
                $query5 = "Select sum(CASE b.is_hourly WHEN 1 THEN (((b.end_time-b.start_time)/3600 )/'$hours') WHEN 0 THEN b.no_days END)  as total FROM leave_days left join leave_list b on leave_days.leave_id=b.id where b.username='".$username."' and (b.start_date between '".$startdate."' and '".$enddate."') and b.status=1";
                
                
                
                $leaves11=mysqli_fetch_assoc(mysqli_query($conn, $query4));
                
                $allLeaves = mysqli_fetch_assoc(mysqli_query($conn, $query5));
                            
                $leave = ($allLeaves['total'] ?? 0)+($leaves11['total'] ?? 0);
                
                $attendworkday=($days11->days+1)-$publicholiday-$restdays;
                
                $leavesdata[$i]['attendance']=sprintf("%0.1f", (($attendworkday-$leave)*100)/$attendworkday);
                
                 if (!$need_to_check) {
    				$usersResult[$i] = $leavesdata[$i];
    				$usernameArray[$no] = $leavesdata[$i]['username'];
    				$userLeaveNoArray[$no] = $leavesdata[$i];
    				$no++;
    			} else {
    
    				switch ($_GET['leave_type']) {
    					case 'Annual':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'], $leavesdata[$i]["AnnualLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Medical':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'], $leavesdata[$i]["MedicalLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Maternity':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["MaternityLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Marriage':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["MarriageLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Compassionate':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["CompassionateLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Hospital':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["HospitalLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    						}
    						break;
    					case 'Examination':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["ExaminationLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Paternity':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["PaternityLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Advance':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["Advance"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Other_pay':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["ReplacementLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Line_Shut':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["Line_ShutLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Absent':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["AbsentLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'NPL':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'], $leavesdata[$i]["NPLeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    					case 'Emergency':
    						if (checkCountls($_GET['function_type'], $_GET['leave_no'],  $leavesdata[$i]["ELeave"])) {
    							$usernameArray[$no] = $leavesdata[$i]['username'];
    							$userLeaveNoArray[$no] = $leavesdata[$i];
    							$no++;
    						}
    						break;
    				}
    			}
                
            }
          
        
        
        $finalData = null;
       
		if (count($usernameArray) > 0) {
            $finalData =  $usernameArray;
            
			for ($i = 0; $i < count($finalData); $i++) {
                
                    
				for ($j = 0; $j < count($userLeaveNoArray); $j++) {
                   // echo'<pre>';
                    //print_r($usernameArray[$i]);
                    if ("1" .$userLeaveNoArray[$j]['username'] == "1" .$usernameArray[$i]) {
						$finalData[$i] = $userLeaveNoArray[$j];
					}
				}
			}

		} else {
			$finalData = array();
        }
        
        if(isset($_GET['order'][0]['column'])){
            if($_GET['order'][0]['column']==0){
                $ocolumn="No";
            }
            elseif($_GET['order'][0]['column']==1){
                    $ocolumn="name";
                }
            elseif($_GET['order'][0]['column']==2){
                $ocolumn="join_year";
            }
            elseif($_GET['order'][0]['column']==3){
                $ocolumn="attendance";
            }
            elseif($_GET['order'][0]['column']==4){
                $ocolumn="AnnualLeave";
            }
            elseif($_GET['order'][0]['column']==5){
                $ocolumn="MedicalLeave";
            }
            elseif($_GET['order'][0]['column']==6){
                $ocolumn="MaternityLeave";
            }
            elseif($_GET['order'][0]['column']==7){
                $ocolumn="MarriageLeave";
            }
            elseif($_GET['order'][0]['column']==8){
                $ocolumn="CompassionateLeave";
            }
            elseif($_GET['order'][0]['column']==9){
                $ocolumn="HospitalLeave";
            }
            elseif($_GET['order'][0]['column']==10){
                $ocolumn="ExaminationLeave";
            }
            elseif($_GET['order'][0]['column']==11){
                $ocolumn="PaternityLeave";
            }
            elseif($_GET['order'][0]['column']==12){
                $ocolumn="Advance";
            }
            elseif($_GET['order'][0]['column']==13){
                $ocolumn="ReplacementLeave";
            }
            elseif($_GET['order'][0]['column']==14){
                $ocolumn="Line_ShutLeave";
            }
            elseif($_GET['order'][0]['column']==15){
                $ocolumn="AbsentLeave";
            }
            elseif($_GET['order'][0]['column']==16){
                $ocolumn="NPLeave";
            }
            elseif($_GET['order'][0]['column']==17){
                $ocolumn="ELeave";
            }
           $results = array_column($finalData, $ocolumn);
            if($_GET['order'][0]['dir']=='asc'){
                array_multisort($results, SORT_ASC, $finalData);
            }
            else{
                array_multisort($results, SORT_DESC, $finalData);
            }
    
        }
         
         echo json_encode($finalData); 
        
    }

?>