{{ View::make('layout.header') }}
@php
    $user_join_year = date('Y', strtotime(App\Models\UserPay::where('username', Auth::user()->username)->first()->date_commence));
    $cutOffStartMonth = getSettingsValue('cut_of_startmonth');
    
    if ($cutOffStartMonth != 1) {
        if ($cutOffStartMonth > date('m')) {
            $currentYear = date('Y') + 1;
        } else {
            $currentYear = date('Y') + 1;
        }
    } else {
        $currentYear = date('Y') + 1;
    }
@endphp
<style>
    .timeline .timeline-item .timeline-event h6 {
        word-break: break-all
    }

    .table tbody td,
    .table thead th {
        padding-left: 6px !important;
        padding-right: 6px !important
    }

    table.dataTable thead .sorting:after,
    table.dataTable thead .sorting:before,
    table.dataTable thead .sorting_asc:after,
    table.dataTable thead .sorting_asc:before,
    table.dataTable thead .sorting_desc:after,
    table.dataTable thead .sorting_desc:before {
        display: none
    }

    #start_year {
        -webkit-appearance: none !important;
        padding-right: 3.5rem
    }
</style>
<!-- BEGIN: Content-->

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">E-Attendance</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">HR
                                </li>
                                <li class="breadcrumb-item active"><a href="{{ route('dashboardHr') }}">Dashboard</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <style>
            @media screen and (min-width: 1000px) {
                .col-lgg-3 {
                    width: 20% !important;
                    padding-left: 10px;
                }
            }

            @media screen and (max-width: 480px) {
                .col-lgg-3 {
                    width: 100% !important;
                    padding-left: 20px;
                    padding-right: 20px;
                }

            }
        </style>
        <div class="content-body">
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <!-- Statistics Card -->
                    <div class="col-lgg-3">
                        <div class="card earnings-card" style="background:#ff9e4326;">
                            <div class="card-body" style="padding:0px;">
                                <div class="row" style="margin:0px;">
                                    <div class="col-8" style="padding:0px;">
                                        <div style="padding: 1rem;">
                                            <h5 class="card-title " style="margin-bottom:10px;">Total</h5>
                                        </div>
                                    </div>
                                    <div class="col-4"
                                        style="padding:0px;
                                        align-items: center; display: flex;
                                        justify-content: flex-end;">
                                        <h2 class="text-warning" style="padding-right:15px;" id="total_emp"></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lgg-3">
                        <div class="card earnings-card" style="background:#28c76f26">
                            <div class="card-body" style="padding:0px;">
                                <div class="row" style="margin:0px;">
                                    <div class="col-6" style="padding:0px;">
                                        <div style="padding: 1rem;">
                                            <h5 class="card-title " style="margin-bottom:10px;">Present</h5>
                                        </div>
                                    </div>
                                    <div class="col-6"
                                        style="padding:0px;
                                        align-items: center; display: flex;
                                        justify-content: flex-end;">
                                        <h2 class="text-success" style="padding-right:15px;" id="present_emp"></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lgg-3">
                        <div class="card earnings-card" style="background:#ea545526;">
                            <div class="card-body" style="padding:0px;">
                                <div class="row" style="margin:0px;">
                                    <div class="col-6" style="padding:0px;">
                                        <div style="padding: 1rem;">
                                            <h5 class="card-title" style="margin-bottom:10px;">Absent</h5>
                                        </div>
                                    </div>
                                    <div class="col-6"
                                        style="padding:0px;
                                        align-items: center; display: flex;
                                        justify-content: flex-end;">
                                        <h2 class="text-danger" style="padding-right:15px;" id="absent_emp"></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lgg-3">
                        <div class="card earnings-card" style="background:#bed7db;">
                            <div class="card-body" style="padding:0px;">
                                <div class="row" style="margin:0px;">
                                    <div class="col-6" style="padding:0px;">
                                        <div style="padding: 1rem;">
                                            <h5 class="card-title" style="margin-bottom:10px;">Late
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-6"
                                        style="padding:0px;
                                        align-items: center; display: flex;
                                        justify-content: flex-end;">
                                        <h2 class="text-danger" style="padding-right:15px;" id="late_emp"></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lgg-3">
                        <div class="card earnings-card" style="background:#a6afda;">
                            <div class="card-body" style="padding:0px;">
                                <div class="row" style="margin:0px;">
                                    <div class="col-8" style="padding:0px;">
                                        <div style="padding: 1rem;">
                                            <h5 class="card-title" style="margin-bottom:10px;">UnAssigned
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-4"
                                        style="padding:0px;
                                        align-items: center; display: flex;
                                        justify-content: flex-end;">
                                        <h2 class="text-info" style="padding-right:15px;" id="unAssignedEmp"></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- line chart --}}
                    <div class="col-xl-12 col-md-12 col-12">

                        <div class="card card-user-timeline">
                            <div class="card-header" style="">
                                <div class="">
                                    <button onclick="more_filter_graph()"
                                        class="btn btn-primary waves-effect waves-float waves-light"
                                        style="">Filter</button>
                                </div>

                            </div>
                            <div class="card activity filter-container"
                                style="margin: 0px 15px; background-color:#e6e5e5; padding:10px 20px 20px 20px; display:none !important;"
                                id="empleavetoday">
                                <div class="row">
                                    <div class="col-md-12" style="padding:0px;">
                                        <button id="spanclose" onclick="more_filter_graph()"
                                            style="float:right;border:0px;background-color:transparent;color:white;padding: 3px 8px 5px;">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-x cursor-pointer font-large-1"
                                                data-repeater-delete="">
                                                <line x1="18" y1="6" x2="6" y2="18">
                                                </line>
                                                <line x1="6" y1="6" x2="18" y2="18">
                                                </line>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Department &nbsp;:&nbsp;
                                        <select name="department" id="department" class="form-control">
                                            <option value="">Department</option>
                                            @foreach ($departments as $department)
                                                <option value="{{ $department->id }}">{{ $department->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Branch &nbsp;:&nbsp;
                                        <select name="branch" id="branch" class="form-control">
                                            <option value="">Branch</option>
                                            @foreach ($branches as $branch)
                                                <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Category &nbsp;:&nbsp;
                                        <select name="category" id="category" class="form-control">
                                            <option value="">Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-sm-6 filter-form-group" style="margin-top:19px;">
                                        <input type="button" value="Apply"
                                            onclick="year_filter({{ date('Y') }}, {{ date('Y') - 1 }})"
                                            class="filter-apply btn btn-info" />
                                    </div>
                                </div>
                            </div>

                            <div id="line-charts" class="p-2">

                            </div>
                        </div>
                    </div>

                    {{-- overview branch wise --}}
                    <div class="col-xl-6 col-md-6 col-12">
                        <div class="card card-user-timeline">
                            <div class="card-header d-flex">
                                <h4 class="card-title">Monthly Attendance Overview (%)</h4>
                                <form id="filter-form">
                                    <div class="d-sm-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">

                                            @csrf
                                            <select onchange="dataYear(this.value)" class="form-control"
                                                id="data_year" name="data_year" style="border-width: 0px;">
                                                <?php
                                                $start_year = getSettingsValue("software_start_year");
                                                $SoftwareStartDate = $start_year;
                                                if($user_join_year>$SoftwareStartDate){
                                                    
                                                    $start_year = $user_join_year;
                                                }
                                                for($i= $start_year; $i<=$currentYear; $i++){
                                                ?>
                                                <option @if ($i == date('Y')) selected @endif
                                                    value="{{ $i }}">
                                                    <?php echo $i; ?>
                                                </option>
                                                <?php }
                                            
                                            ?>
                                            </select>

                                            <select onchange="dataMonth(this.value)" class="form-control"
                                                id="data_month" name="month" style="border-width: 0px;">

                                                <?php
                                                for ($i = 1; $i <= 12; $i++) {
                                                    $monthNum = $i;
                                                    $dateObj = DateTime::createFromFormat('!m', $monthNum);
                                                    $label = $dateObj->format('F');
                                                
                                                    $value = $i;
                                                    if (date('n') == $i) {
                                                        echo "<option selected value='$value'>$label</option>";
                                                    } else {
                                                        echo "<option value='$value'>$label</option>";
                                                    }
                                                }
                                                
                                                ?>
                                            </select>

                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div id="pie-chart">

                            </div>
                        </div>
                    </div>

                    {{-- present abs branch wise --}}
                    <div class="col-xl-6 col-md-6 col-12">
                        <div class="card card-user-timeline">
                            <div class="card-header d-flex">
                                <h4 class="card-title">Attendance Overview</h4>
                                <form id="filter-form">
                                    <div class="d-sm-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                            @php
                                                $branches = DB::table('branch')->get();
                                            @endphp
                                            @csrf
                                            <select onchange="filterBranch(this.value)" class="form-control"
                                                id="data_filter_branch" name="branch_id" style="border-width: 0px;">
                                                <option value="All">All</option>
                                                @foreach ($branches as $branch)
                                                    <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                                @endforeach
                                            </select>

                                            <input onchange="filterDateFrom(this.value)"
                                                style="border: none; font-size: 0.9em;" value="{{ date('Y-m-d') }}"
                                                id="date_from" type="date" class="form-control">
                                            -
                                            <input onchange="filterDateTo(this.value)"
                                                style="border: none; font-size: 0.9em;" value="{{ date('Y-m-d') }}"
                                                id="date_to" type="date" class="form-control">

                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div id="pie-chart-data">

                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-md-12 col-12">
                        <div class="content-body">
                            <section id="dashboard-ecommerce">
                                <div class="row match-height">
                                    <div class="col-md-12">
                                        <div class="card">

                                            <div class="card-header" style="">
                                                <div class="">
                                                    <button onclick="more_filter()"
                                                        class="btn btn-primary waves-effect waves-float waves-light"
                                                        style="">Filter</button>
                                                </div>
                                                <div class="d-flex align-items-right">
                                                    <div class="btn-group btn-align-right MiniRightnav">

                                                        {{-- hide and show --}}
                                                        <div class="dropdown">
                                                            <button class="dropbtn fa fa-gear"></button>
                                                            <div id="myDropdown" class="dropdown-content">

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card activity filter-container"
                                                style="margin: 0px 15px; background-color:#e6e5e5; padding:10px 20px 20px 20px; display:none !important;"
                                                id="lateEmpFilter">
                                                <div class="row">
                                                    <div class="col-md-12" style="padding:0px;">
                                                        <button id="spanclose" onclick="more_filter()"
                                                            style="float:right;border:0px;background-color:transparent;color:white;padding: 3px 8px 5px;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 24 24" fill="none"
                                                                stroke="currentColor" stroke-width="2"
                                                                stroke-linecap="round" stroke-linejoin="round"
                                                                class="feather feather-x cursor-pointer font-large-1"
                                                                data-repeater-delete="">
                                                                <line x1="18" y1="6" x2="6"
                                                                    y2="18">
                                                                </line>
                                                                <line x1="6" y1="6" x2="18"
                                                                    y2="18">
                                                                </line>
                                                            </svg>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="row">

                                                    <div class="col-sm-3 filter-form-group mb-1">
                                                        Date From &nbsp;:
                                                        <input type="date" name="sdatefrom" id="sdatefrom"
                                                            class="tcal form-control flatpickr-basic"
                                                            placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy">
                                                    </div>
                                                    <div class="col-sm-3 filter-form-group mb-1">
                                                        Date To &nbsp;:<span class="red">*</span>&nbsp;
                                                        <input type="date" name="sdateto" id="sdateto"
                                                            class="tcal form-control flatpickr-basic"
                                                            placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy">
                                                    </div>

                                                    <div class="col-sm-6 filter-form-group" style="margin-top:19px;">
                                                        <input type="button" value="Apply"
                                                            onclick="getfilterdata();"
                                                            class="filter-apply btn btn-info" />
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="p-2">
                                                <h1>Late In Listings</h1>
                                            </div>

                                            <div class="card-body" style="padding-top:0px !important; ">
                                                <div class="table-responsive " style="overflow-x: scroll !important;">
                                                    <table class="table" id="reporttable" style=" font-size:12px;">
                                                        <thead>
                                                            <tr>
                                                                <th style="text-transform: capitalize;">Staff Name</th>
                                                                <th style="text-transform: capitalize;">Branch</th>
                                                                <th style="text-transform: capitalize;">Department</th>
                                                                <th style="text-transform: capitalize;">Late In Time
                                                                </th>
                                                                <th style="text-transform: capitalize;">Check In</th>
                                                                <th style="text-transform: capitalize;">Late In Hours
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>


                    <!-- pie chart Card -->
                    <input type="hidden" id="userdata">
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
{{ View::make('layout.footer') }}
@include('inc.timline-model')
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('app-assets/vendors/js/charts/apexcharts.min.js') }}"></script>
<script src="{{ asset('app-assets/js/scripts/charts/chart-apex.min.js') }}"></script>
<script type="text/javascript">
    var userdata = '';

    var month = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
        "Oct", "Nov", "Dec"
    ];

    var current_year = new Date().getFullYear();
    var current_month = new Date().getMonth() + 1;
    var branch = $("#data_filter_branch").val();
    var date_from = $("#date_from").val();
    var date_to = $("#date_to").val();
    var total_employee = {{ $total_emp }};
    var total_employee_avg = Math.round(total_employee / 10);

    $(document).ready(function() {
        $('#start_year option[value="' + current_year + '"]').attr("selected", true);
        var data = getdata(current_month, current_year, 'counter_data', 'today');
        $('#total_emp').text(data.total_emp);
        $('#present_emp').text(data.present_emp);
        $('#absent_emp').text(data.absent_emp);
        $('#late_emp').text(data.late_emp);
        $('#unAssignedEmp').text(data.unAssignedEmp);

        pie_filter(current_year, current_month);

        pie_filter_branch(branch, date_from, date_to);

        getfilterdata();

    });

    document.addEventListener('readystatechange', event => {
        if (event.target.readyState === "complete") {
            year_filter(current_year, current_year - 1);
        }
    });


    function getdata(month = "", year = "", data_type, chartype = 'yearwise', branch = "All", branchs = "", department =
        "", category = "", date_from = "", date_to = "") {

        $.ajax({

            type: 'GET',
            async: false,
            url: '{{ route('hrdashboarddata') }}',
            data: {
                'month': month,
                'year': year,
                'chartype': chartype,
                'data_type': data_type,
                'branch_id': branch,
                'date_from': date_from,
                'date_to': date_to,

                'category': category,
                'branch': branchs,
                'department': department,
            },
            success: function(data) {
                userdata = data;
            }
        });
        return userdata;
    }

    // ************ start_year ************

    //     // charts 
    var Present = [];
    var prev_Present = [];

    var pie_present = [];
    var pie_branch = [];


    function year_filter(start_year, prev_year) {

        var branchs = $("#branch").val();
        var department = $("#department").val();
        var category = $("#category").val();

        // for (var i = 1; i <= month.length; i++) {
        //     if ((start_year >= current_year) && ((i > current_month) || (start_year > current_year))) {
        //         break;
        //     }
        // }

        // for (var i = 1; i <= month.length; i++) {
        //     if ((prev_year >= current_year) && ((i > current_month) || (prev_year > current_year))) {
        //         break;
        //     }
        // }

        var yearData = getdata(1, start_year, 'line_chart', 'yearwise', 'All', branchs, department, category);
        var yearData2 = getdata(1, prev_year, 'line_chart', 'yearwise', 'All', branchs, department, category);

        $.each(yearData, function(key, val) {
            Present.push(val.present_emp);
        });
        $.each(yearData2, function(key, val) {
            prev_Present.push(val.present_emp);
        });


        lineChart(Present, prev_Present);
        Present = [];
        prev_Present = [];
    }

    function pie_filter(year, month) {
        var year = year;
        var month = month;

        var month_data = getdata(month, year, 'pie_chart');

        var chartData = JSON.parse(month_data.data);

        for (const key in chartData) {
            pie_branch.push(key)
            pie_present.push(chartData[key])
        }

        pieChart(pie_present, pie_branch);
        pie_present = [];
        pie_branch = [];
    }



    var pie_data = [];
    var pie_lable = [];

    function pie_filter_branch(branch, date_from, date_to) {
        var branch = branch;
        var date_from = date_from;
        var date_to = date_to;

        var month_data = getdata('', '', 'pie_chart_branch', '', branch, '', '', '', date_from, date_to);
        pie_data = [month_data["present"], month_data["absent"], Number(month_data["late"])];
        pie_lable = ["Present", "Absent", "Late"];

        pieChartBranch(pie_data, pie_lable);
        pie_data = [];
        pie_lable = [];
    }


    // ------------------------- Line Chart -----------------------------
    var linechart = "";
    var linecount = 1;

    function lineChart(Present, prev_Present) {
        if (linecount > 1) {
            linechart.destroy();
        }
        linecount++;
        var options = {
            series: [{
                    name: "Current Year",
                    data: Present
                },
                {
                    name: "Previous Year",
                    data: prev_Present
                }
            ],
            chart: {
                height: 400,
                type: 'line',
                dropShadow: {
                    enabled: true,
                    color: '#000',
                    top: 18,
                    left: 7,
                    blur: 10,
                    opacity: 0.2
                },
                toolbar: {
                    show: false
                }
            },
            colors: ['#77B6EA', '#545454'],
            dataLabels: {
                enabled: false,
            },
            stroke: {
                curve: 'smooth'
            },
            title: {
                text: 'Attendance Overview',
                align: 'left'
            },

            markers: {
                size: 0
            },
            xaxis: {
                categories: month,
                title: {
                    text: 'Month'
                }
            },
            yaxis: {
                title: {
                    text: '% Present'
                },
                ticks: {
                    beginAtZero: true,
                    steps: 10,
                    stepValue: 5,
                    max: 35
                }
            },
            legend: {
                position: 'top',
                horizontalAlign: 'right',
                floating: true,
                offsetY: -25,
                offsetX: -5
            }
        };

        linechart = new ApexCharts(document.querySelector("#line-charts"), options);
        linechart.render();
    }

    // ====================== pie chart ============================

    var chart = "";
    var count = 1;

    function pieChart(pie_present, pie_branch) {

        if (count > 1) {
            chart.destroy();
        }
        count++;

        var options = {
            series: [{
                data: pie_present
            }],
            chart: {
                type: 'bar',
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: pie_branch
            }
        };

        chart = new ApexCharts(document.querySelector("#pie-chart"), options);
        chart.render();
    }

    // pie chart branch filter
    var chart1 = "";
    var count1 = 1;

    function pieChartBranch(pie_data, pie_lable) {

        if (count1 > 1) {
            chart1.destroy();
        }
        count1++;

        var options = {
            series: pie_data,
            chart: {
                type: 'donut',
            },
            legend: {
                position: 'bottom'
            },
            labels: pie_lable,
            dataLabels: {
                enabled: false
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 200
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }],
        };


        chart1 = new ApexCharts(document.querySelector("#pie-chart-data"), options);
        chart1.render();
    }


    // =============================== filter of pie chart ==================

    function dataYear(current_year) {
        var dataMonth = $("#data_month").val();
        pie_filter(current_year, dataMonth);
        pie_present = [];
        pie_branch = [];
    }

    function dataMonth(current_month) {
        var dataYear = $("#data_year").val();
        pie_filter(dataYear, current_month);
        pie_present = [];
        pie_branch = [];
    }

    // ==================================== filter of pie chart branch =================
    function filterDateFrom(date_from) {
        var date_to = $("#date_to").val();
        var filter_branch = $("#data_filter_branch").val();
        if (!filter_branch) {
            filter_branch = "All";
        }
        pie_filter_branch(filter_branch, date_from, date_to);
        pie_present = [];
        pie_branch = [];
    }

    function filterDateTo(date_to) {
        var date_from = $("#date_from").val();
        var filter_branch = $("#data_filter_branch").val();
        if (!filter_branch) {
            filter_branch = "All";
        }
        pie_filter_branch(filter_branch, date_from, date_to);
        pie_present = [];
        pie_branch = [];
    }

    function filterBranch(filter_branch) {
        var date_from = $("#date_from").val();
        var date_to = $("#date_to").val();
        pie_filter_branch(filter_branch, date_from, date_to);
        pie_present = [];
        pie_branch = [];
    }


    // late in data 
    function getfilterdata() {

        var sdatefrom = $("#sdatefrom").val();
        var sdateto = $("#sdateto").val();
        var apploginmodel = "{{ hasEattendanceEditAccess() ? '#inlineForm' : '' }}";
        var table = $('#reporttable').DataTable({
            "lengthMenu": [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            "order": [],
            "processing": true,
            "destroy": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('hrdashboarddata') }}",
                "type": 'GET',
                "data": {
                    "user_type": "hr",
                    "sdatefrom": sdatefrom,
                    "sdateto": sdateto,
                    'data_type': "late_data",
                }
            },
            "deferRender": true,
            "columns": [{
                    data: 'name',
                    name: 'name'
                }, {
                    data: 'branch_id',
                    name: 'branch'
                }, {
                    data: 'department_id',
                    name: 'department'
                }, {
                    data: 'intime',
                    name: 'intime'
                }, {
                    data: 'entry',
                    name: 'entry'
                }, {
                    data: 'lateness',
                    name: 'lateness'
                },

            ],
            'rowCallback': function(row, data, index) {
                $('td:eq(2)', row).css('width', '120');
            },

            "language": {
                "paginate": {
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },
        });

        var columns = table.settings().init().columns;
        for (let i = 0; i < columns.length; i++) {
            //
            var dCol =
                `<div class="toggle-vis custom-control mt-1 ml-1 custom-control-success custom-checkbox"><input class='inp custom-control-input' data-column="${i}" key="{!! $c_key !!}" id="{!! $c_key !!}_${i}"  type="checkbox" checked><label for="{!! $c_key !!}_${i}" class="custom-control-label" style="cursor: pointer">${columns[i].name}</label></div>`;
            $("#myDropdown").append(dCol);
        }

        // show hide and show data
        var daraArr = {!! json_encode($columnHideShowData) !!}
        hidefun(table, '{!! $c_key !!}', daraArr);

    }
</script>

{{-- filter --}}
<script>
    var x = document.getElementById("empleavetoday");
    x.style.display = "none";

    function more_filter_graph() {
        var x = document.getElementById("empleavetoday");
        if (x.style.display === "none") {
            x.style.display = "block";
        } else {
            x.style.display = "none";
        }
    }


    var x = document.getElementById("lateEmpFilter");
    x.style.display = "none";

    function more_filter() {
        var x = document.getElementById("lateEmpFilter");
        if (x.style.display === "none") {
            x.style.display = "block";
        } else {
            x.style.display = "none";
        }
    }
</script>
