{{ View::make('layout.header') }}
<style>
    .table thead th {
        padding: 8px 10px !important;
    }

    a.disable {
        pointer-events: none;
        color: gray !important;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">HR </li>
                                <li class="breadcrumb-item active"><a href="{{ route('setupHr') }}">Setup</a></li>
                                <li class="breadcrumb-item active">
                                    <a href="{{ route('viewdutyroaster') }}">Duty Roster</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header" style="">
                                <div class="d-flex align-items-center">
                                    <h4 class="card-title" style="margin-bottom:0px;">Duty Roster</h4>
                                </div>
                                <div class="btn-group btn-align-right "><a class="dt-button create-new btn btn-primary"
                                        href="<?php echo e(route('duty_Roaster')); ?>"><span><svg xmlns="http://www.w3.org/2000/svg"
                                                width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" class="feather feather-plus mr-50 font-small-4">
                                                <line x1="12" y1="5" x2="12" y2="19">
                                                </line>
                                                <line x1="5" y1="12" x2="19" y2="12">
                                                </line>
                                            </svg>Add New Duty Roster</span></a></div>
                            </div>
                            <div class="card-body" style="padding-top:0px !important; ">
                                <div class="table-responsive " style="overflow-x: unset !important;">
                                    <table class="table table-striped" id="reporttable" style=" font-size:12px;">
                                        <thead>
                                            <tr>
                                                <th style="text-transform: capitalize;" width="5%">Serial No.</th>
                                                <th width="15%" style="text-transform: capitalize;">Group ID</th>
                                                <th style="text-transform: capitalize;" width="35%">Name</th>
                                                <th width="50%" style="text-transform: capitalize;">Edit</th>
                                                <th width="50%" style="text-transform: capitalize;">Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
{{ View::make('layout.footer') }}
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript"></script>
<script type="text/javascript">
    var url = $
    var base_url = $('body').attr('data-baseurl') + '/e-attendance';
    $(document).ready(function() {
        getfilterdata();
    });

    function getfilterdata() {

        var string_url = "dutyRoasterdata";
        $('#reporttable').DataTable({
            "lengthMenu": [
                [10, 20, 50, -1],
                [10, 20, 50, "All"]
            ],
            "order": [],
            "processing": true,
            "destroy": true,
            "serverSide": true,
            "ajax": string_url,
            "columns": [

                {
                   data: 'index',
                    name: 'index'
                },
                {
                    data: 'group_id',
                    name: 'group_id'
                }, {
                    data: 'name',
                    name: 'name'
                },

                {
                    "render": function(data, type, row, meta) {
                        var edit = '<a href="' + base_url + '/update-duty_roaster?id=' + row.id +
                            '" style="color:#28c76f;"><svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><circle cx="12" cy="12" r="3"></circle><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></a>&nbsp;';
                        return edit;
                    }
                },

                {
                    "render": function(data, type, row, meta) {
                        if (row.duty_roaster_id == null)
                            var deletee = '<a href="javascript:deleteduty(\'' + row.id +
                                '\');"  class="' + row.map_schedule +
                                ' text-danger "><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 font-small-4 mr-50"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></a>&nbsp;';
                        else
                            var deletee = '<a href="javascript:deleteduty(\'' + row.id +
                                '\');"  class="' + row.map_schedule +
                                ' text-danger disable "><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 font-small-4 mr-50"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></a>&nbsp;';
                        return deletee;

                    }

                },

            ],
            "language": {
                "paginate": {
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },
        });
    }

    function deleteduty(id) {
        var result = confirm("Are you sure want to delete this Duty Roster?");
        if (result) {

            $.ajax({
                type: 'get',
                url: '{{ route('removeDutyRoaster') }}',
                data: {
                    id: id,
                },
                success: function(data) {
                    toastr.success(data.success);
                    var table = $('#reporttable').DataTable();
                    table.row($(this).parents('tr')).remove().draw();

                },

            });
        }
    }
</script>
