{{ View::make('layout.header') }}
<style>
    .table thead th {
        padding: 8px 10px !important;
    }

    a.disable {
        pointer-events: none;
    }
</style>


<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb mt-3">
                                <li class="breadcrumb-item">HR
                                </li>
                                <li class="breadcrumb-item active"><a
                                        href="{{ route('all-attendance') }}">Attendance</a></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header" style="">
                                <div class="">
                                    <button onclick="more_filter()"
                                        class="btn btn-primary waves-effect waves-float waves-light"
                                        style="">Filter</button>

                                    <div class="btn-group">
                                        <select name="in_out_filter" id="in_out_filter" class=" form-control"
                                            style="padding-left: 10px; border-width: 0 1px 0 0px; border-radius:0px;"
                                            onchange="getfilterdata()">
                                            <option value="">All</option>
                                            <option value="no_in_out">No In or Out</option>
                                            <option value="no_lunch">No Lunch</option>
                                            <option value="over_lunch">Over Lunch</option>
                                            <option value="late_in">Late In</option>
                                            <option value="early_out">Early Out</option>
                                            <option value="overtime">Overtime</option>
                                            <option value="on_leave">On leave</option>
                                            <option value="at_least_one">At Least One</option>
                                        </select>
                                    </div>

                                    <div class="btn-group">
                                        <select name="att_filter" id="att_filter" class=" form-control"
                                            style="padding-left: 10px; border-width: 0 1px 0 0px; border-radius:0px;"
                                            onchange="getfilterdata()">
                                            <option value="daily">Daily</option>
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly">Monthly</option>
                                        </select>
                                    </div>

                                </div>
                                <div class="d-flex align-items-right">
                                    <div class="btn-group btn-align-right MiniRightnav">

                                        <a onclick="exportpdf()" class="text-danger"><i
                                                class="fa fa-file-pdf-o report-download-btn"
                                                style="font-size:25px;"></i><span>Download PDF</a>
                                        &nbsp;&nbsp;
                                        <a onclick="exportexcel()" class="text-success"><i
                                                class="fa fa-file-excel-o report-download-btn"
                                                style="font-size:25px;"></i><span>Download Excel</span></a>
                                        &nbsp;&nbsp;
                                        {{-- hide and show --}}
                                        <div class="dropdown">
                                            <button class="dropbtn fa fa-gear"></button>
                                            <div id="myDropdown" class="dropdown-content">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card activity filter-container"
                                style="margin: 0px 15px; background-color:#e6e5e5; padding:10px 20px 20px 20px; display:none !important;"
                                id="empleavetoday">
                                <div class="row">
                                    <div class="col-md-12" style="padding:0px;">
                                        <button id="spanclose" onclick="more_filter()"
                                            style="float:right;border:0px;background-color:transparent;color:white;padding: 3px 8px 5px;">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-x cursor-pointer font-large-1"
                                                data-repeater-delete="">
                                                <line x1="18" y1="6" x2="6" y2="18">
                                                </line>
                                                <line x1="6" y1="6" x2="18" y2="18">
                                                </line>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Department &nbsp;:&nbsp;
                                        <select name="department" id="department" class="form-control">
                                            <option value="">Department</option>
                                            @foreach ($departments as $department)
                                                <option value="{{ $department->id }}">{{ $department->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Branch &nbsp;:&nbsp;
                                        <select name="branch" id="branch" class="form-control">
                                            <option value="">Branch</option>
                                            @foreach ($branches as $branch)
                                                <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Category &nbsp;:&nbsp;
                                        <select name="category" id="category" class="form-control">
                                            <option value="">Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Date From &nbsp;:
                                        <input type="date" name="sdatefrom" id="sdatefrom"
                                            class="tcal form-control flatpickr-basic" placeholder="DD-MM-YYYY"
                                            data-dateformat="dd-mm-yy">
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Date To &nbsp;:<span class="red">*</span>&nbsp;
                                        <input type="date" name="sdateto" id="sdateto"
                                            class="tcal form-control flatpickr-basic" placeholder="DD-MM-YYYY"
                                            data-dateformat="dd-mm-yy">
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Schedule &nbsp;:&nbsp;
                                        <select name="schedule" id="schedule" class="form-control">
                                            <option value="">Schedule</option>
                                            <option value="Flexi">Flexi</option>
                                            @foreach ($schedules as $schedule)
                                                <option value="{{ $schedule->id }}">{{ $schedule->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-3 filter-form-group mb-1">
                                        Day Type &nbsp;:&nbsp;
                                        <select name="day_type" id="day_type" class="form-control">
                                            <option value="">Day Type</option>
                                            <option value="Work">Work</option>
                                            <option value="Rest">Rest</option>
                                            <option value="PH">PH</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 filter-form-group" style="margin-top:19px;">
                                        <input type="button" value="Apply" onclick="getfilterdata();"
                                            class="filter-apply btn btn-info" />
                                    </div>
                                </div>
                            </div>
                            <div class="card-body" style="padding-top:0px !important; ">
                                <div class="table-responsive " style="overflow-x: unset !important;">
                                    <table class="table table-striped " id="reporttable" style=" font-size:12px;">
                                        <thead>
                                            <tr>
                                                <th style="text-transform: capitalize;">Date</th>
                                                <th style="text-transform: capitalize;">Day</th>
                                                <th style="text-transform: capitalize;">Emp No.</th>
                                                <th style="text-transform: capitalize;">Employees Name</th>
                                                <th style="text-transform: capitalize;">Schedule</th>
                                                <th style="text-transform: capitalize;">Day Type</th>
                                                <th style="text-transform: capitalize; width:8% !important">Intime</th>
                                                <th style="text-transform: capitalize; width:8% !important">Break</th>
                                                <th style="text-transform: capitalize; width:8% !important">Resume</th>
                                                <th style="text-transform: capitalize; width:8% !important">Outtime
                                                </th>
                                                <th style="text-transform: capitalize;">Work Hour</th>
                                                <th style="text-transform: capitalize;">Late In</th>
                                                <th style="text-transform: capitalize;">Early Out</th>
                                                <th style="text-transform: capitalize;">Overtime</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
{{ View::make('layout.footer') }}
@include('E-Attendance.edit_attendance')
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript"></script>
<script type="text/javascript">
    var base_url = $('body').attr('data-baseurl') + '/e-attendance';
    $(document).ready(function() {
        getfilterdata();
    });




    function getfilterdata() {
        var sdatefrom = $("#sdatefrom").val();
        var sdateto = $("#sdateto").val();
        var schedule = $("#schedule").val();
        var day_type = $("#day_type").val();
        var category = $("#category").val();
        var branch = $("#branch").val();
        var department = $("#department").val();
        var in_out_filter = $("#in_out_filter").val();
        var att_filter = $("#att_filter").val();
        var apploginmodel = "{{ hasEattendanceEditAccess() ? '#inlineForm' : '' }}";
        var table = $('#reporttable').DataTable({
            "lengthMenu": [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            "order": [],
            "processing": true,
            "destroy": true,
            "ajax": {
                "url": "{!! route('all-attendance') !!}",
                "type": 'GET',
                "data": {
                    "user_type": "hr",
                    "sdatefrom": sdatefrom,
                    "sdateto": sdateto,
                    "schedule": schedule,
                    "day_type": day_type,
                    "category": category,
                    "branch": branch,
                    "department": department,
                    "in_out_filter": in_out_filter,
                    "att_filter": att_filter
                }
            },
            "serverSide": true,
            "deferRender": true,
            "columns": [{
                    data: 'date',
                    name: 'date'
                }, {
                    data: 'day_name',
                    name: 'Day Name'
                }, {
                    data: 'employee_no',
                    name: 'employee_no'
                }, {
                    data: 'personname',
                    name: 'personname'
                }, {
                    data: 'schedule_id',
                    name: 'Schedule'
                },
                {
                    data: 'day_type',
                    name: 'Day Type'
                },
                {
                    data: 'intime',
                    name: 'Intime',
                    "render": function(data, type, row, meta) {
                        var textColor = "";
                        if (row.schedule_id != "Flexi") {
                            var textColor = row.in_text_color;
                        }
                        var text =
                            `<a  style="color:${textColor};${row.in_textbold}" class="appDialog-modelbox status-fd" data-toggle="modal" data-target="${apploginmodel}" data-id='{"working_day": "${row.working_day}","empid": "${row.employee_no}","time": "${row.intime_id}", "devicename": "${row.devicename}", "empName": "${row.personname}"}'><span> &#x1F552;</span> ${row.intime}</a>`;
                        return text;

                    }
                },
                {
                    name: 'Break',
                    "render": function(data, type, row, meta) {
                        var textColor = "";
                        if (row.schedule_id != "Flexi") {
                            var textColor = row.lunch_text_color;
                        }
                        var text =
                            `<a   style="color:${textColor};${row.break_textbold}" class="appDialog-modelbox status-fd" data-toggle="modal" data-target="${apploginmodel}" data-id='{"working_day": "${row.working_day}","empid": "${row.employee_no}","time": "${row.break_id}", "devicename": "${row.devicename}", "empName": "${row.personname}"}'><span> &#x1F552; ${row.break_time}</span></a>`;
                        return text;

                    }
                },
                {
                    name: 'Resume',
                    "render": function(data, type, row, meta) {
                        var textColor = "";
                        if (row.schedule_id != "Flexi") {
                            var textColor = row.lunch_text_color;
                        }
                        var text =
                            `<a  style="color:${textColor};${row.resume_textbold}" class="appDialog-modelbox status-fd" data-toggle="modal" data-target="${apploginmodel}" data-id='{"working_day": "${row.working_day}","empid": "${row.employee_no}","time": "${row.resume_id}", "devicename": "${row.devicename}", "empName": "${row.personname}"}'><span> &#x1F552; ${row.resume_time}</span></a>`;
                        return text;

                    }
                },

                {
                    name: 'Outtime',
                    "render": function(data, type, row, meta) {
                        var textColor = "";
                        if (row.schedule_id != "Flexi") {
                            var textColor = row.leave_text_color;
                        }
                        var text =
                            `<a style="color:${textColor};${row.out_textbold}"  class="appDialog-modelbox status-fd" data-toggle="modal" data-target="${apploginmodel}" data-id='{"working_day": "${row.working_day}","empid": "${row.employee_no}","time": "${row.leave_id}", "devicename": "${row.devicename}", "empName": "${row.personname}"}'><span>&#x1F552;</span> ${row.leave_time}</a>`;
                        return text;
                    }
                },
                
                {
                    name: 'work_hour',
                    "render": function(data, type, row, meta) {
                        var text = `<span style=""><strong>${row.work_hour}</strong></span>`;

                        return text;
                    }
                },
                
                {
                    name: 'Late',
                    "render": function(data, type, row, meta) {
                        var text = `<span style="color:red"><strong>${row.lateness}</strong></span>`;

                        return text;
                    }
                },
               
                {
                    name: 'Early Out',
                    "render": function(data, type, row, meta) {
                        var text = `<span style="color:red"><strong>${row.earlyOut}</strong></span>`;

                        return text;
                    }
                },
                {
                    data: 'overtime',
                    name: 'Overtime'
                },
            ],
            'rowCallback': function(row, data, index) {
                // $('td:eq(2)', row).css('width', '120');
            },
            'columnDefs': [{
                "targets": [],
                "orderable": false
            }],
            "language": {
                "paginate": {
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },
        });
        var columns = table.settings().init().columns;
        for (let i = 0; i < columns.length; i++) {
            //
            var dCol =
                `<div class="toggle-vis custom-control mt-1 ml-1 custom-control-success custom-checkbox"><input class='inp custom-control-input' data-column="${i}" key="{!! $c_key !!}" id="{!! $c_key !!}_${i}"  type="checkbox" checked><label for="{!! $c_key !!}_${i}" class="custom-control-label" style="cursor: pointer">${columns[i].name}</label></div>`;
            $("#myDropdown").append(dCol);
        }

        // show hide and show data
        var daraArr = {!! json_encode($columnHideShowData) !!}
        hidefun(table, '{!! $c_key !!}', daraArr);
    }

    // excel download option

    function exportexcel() {
        var exportdata = [];
        $('.singleSelectBox').each(function() {
            if ($(this).is(":checked")) {
                exportdata.push($(this).val());
            }
        });
        exportdata = exportdata.toString();

        var branch = $("#branch").val();
        var department = $("#department").val();
        var category = $("#category").val();
        let url = "emp-attendanceexport?branch=" + branch + "&department=" + department + "&category=" + category +
            "&exportdata=" + exportdata;

        window.location.href = url;

    }

    // excel download option

    function exportpdf() {
        var exportdata = [];
        $('.singleSelectBox').each(function() {
            if ($(this).is(":checked")) {
                exportdata.push($(this).val());
            }
        });
        exportdata = exportdata.toString();
        var branch = $("#branch").val();
        var department = $("#department").val();
        var category = $("#category").val();
        let url = "empattendancepdf?branch=" + branch + "&department=" + department + "&category=" + category +
            "&exportdata=" + exportdata;
        window.location.href = url;

    }

    // pdf download option



    var x = document.getElementById("empleavetoday");
    x.style.display = "none";

    function more_filter() {
        var x = document.getElementById("empleavetoday");
        if (x.style.display === "none") {
            x.style.display = "block";
        } else {
            x.style.display = "none";
        }
    }
</script>
