<link rel="stylesheet" type="text/css"
    href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" type="text/css"
    href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
<link rel="stylesheet" type="text/css"
    href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
<link rel="stylesheet" type="text/css"
    href="{{ asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css') }}">
<!-- END: Vendor CSS-->


<!-- BEGIN: Theme CSS-->
<link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap-extended.css') }}">

<!-- BEGIN: Page CSS-->

<!-- END: Page CSS-->

<!-- BEGIN: Custom CSS-->
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/style.css') }}">
<style>
    .table thead th {
        /* padding: 8px 10px !important; */
    }

    a.disable {
        pointer-events: none;
    }
</style>
<!-- BEGIN: Content-->
<div class="container" style="background-color: white;">
    <div class="container text-center">
        <h1>Attendance and Access Control</h1>
        <br>
        <div class="row d-flex justify-content-center">
            <div class="col-md-3">
                <label for="">Select Device</label>
                <select name="" class="form-control" id="device">
                    <option value="">All</option>
                    @foreach ($devices as $device)
                        <option value="{{ $device->devicename }}">{{ $device->devicename }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-5 row">
                <div class="col-md-5">
                    <label for="">Date From</label>
                    <input class="form-control" id="from_date" type="date">
                </div>
                <div class="mt-2">
                    --
                </div>
                <div class="col-md-5">
                    <label for="">Date To</label>
                    <input class="form-control" id="to_date" type="date">
                </div>

            </div>
            <div class="col-md-3">
                <label for="">Select Employee</label>
                <select name="" class="form-control" id="emp">
                    <option value="">All</option>
                    @foreach ($emps as $emp)
                        <option value="{{ $emp->employee_no }}">{{ $emp->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="mt-1 mb-2">
            <button onclick="resetFilter()" class="btn btn-danger">Reset</button>
            <button onclick="getFilterData()" class="btn btn-success">Apply</button>
        </div>

        <table class="table table-striped" id="reporttable">
            <thead>
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Employee NO</th>
                    <th scope="col">Name</th>
                    <th scope="col" style="width: 15% !important;">Date</th>
                    <th scope="col">Time</th>
                    <th scope="col">Device</th>
                    <th scope="col">Serial</th>
                    <th scope="col">CardNumber</th>

                </tr>
            </thead>
            <tbody>
            <tbody></tbody>

            </tbody>
        </table>

    </div>
</div>
<!-- END: Content-->
<link rel="stylesheet" crossorigin="anonymous" type="text/css"
    href="{{ asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css') }}">
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<!-- BEGIN: Vendor JS-->
<script src="{{ asset('app-assets/vendors/js/vendors.min.js') }}"></script>
<!-- BEGIN Vendor JS-->

<!-- BEGIN: Page Vendor JS-->
<!-- <script src="{{ asset('app-assets/vendors/js/charts/apexcharts.min.js') }}"></script> -->
<script src="{{ asset('app-assets/vendors/js/extensions/toastr.min.js') }}"></script>
<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->
<script src="{{ asset('app-assets/js/core/app-menu.js') }}"></script>
<script src="{{ asset('app-assets/js/core/app.js') }}"></script>
<!-- END: Theme JS-->

<!-- BEGIN: Page JS-->
<!-- <script src="{{ asset('app-assets/js/scripts/pages/dashboard-ecommerce.js') }}"></script> -->
<!-- END: Page JS-->
<script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/responsive.bootstrap4.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/jszip.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
<script src="{{ asset('app-assets/js/scripts/customizer.min.js') }}"></script>

<script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.rowGroup.min.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js') }}"></script>

<script src="{{ asset('app-assets/js/scripts/tables/table-datatables-basic.min.js') }}"></script>





<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript"></script>

<script>
    function resetFilter() {
         window.location.href = window.location.href;
    }
</script>

<script>
    function getFilterData() {
        var from_date = $("#from_date").val();
        var to_date = $("#to_date").val();
        var device = $("#device").val();
        var emp = $("#emp").val();

        $('#reporttable').DataTable({
            "lengthMenu": [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            "order": [],
            "processing": true,
            "destroy": true,
            "serverSide": false,
            "ajax": {
                "url": "{!! route('all-clockindata') !!}",
                "type": 'GET',
                "data": {
                    "from_date": from_date,
                    "to_date": to_date,
                    "device": device,
                    "emp": emp,
                }
            },
            "columns": [{
                    data: 'serialNo',
                    name: 'serialNo'
                },
                {
                    data: 'employee_no',
                    name: 'employee_no'
                }, {
                    data: 'personname',
                    name: 'personname'
                },

                {
                    name: 'Date',
                    "render": function(data, type, row, meta) {
                        var text =
                            `<span  style="width:15% !important;">${row.date}</span>`;
                        return text;
                    }
                }, {
                    data: 'time',
                    name: 'time'
                },
                {
                    data: 'devicename',
                    name: 'devicename'
                },
                {
                    data: 'serialNumber',
                    name: 'serialNumber'
                },
                {
                    data: 'cardno',
                    name: 'cardno'
                },


            ],
            'columnDefs': [{
                "targets": [6],
                "orderable": false
            }],
            "language": {
                "paginate": {
                    // remove previous & next text from pagination
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },



        });

    }
</script>

<script type="text/javascript">
    var base_url = $('body').attr('data-baseurl') + '/e-attendance';
    $(document).ready(function() {
        getFilterData()
    });
</script>
