{{ View::make('layout.header') }}
<!-- END: Custom CSS-->

<style>
    .timeline .timeline-item .timeline-event h6 {
        word-break: break-all;
    }
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">E-claim
                                </li>
                                <li class="breadcrumb-item active"><a href="#">Dashboard</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body mb-5">
            <!-- Dashboard Ecommerce Starts -->
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header" style="">
                                <h4 class="card-title">Staff Eclaim Details</h4>
                                <div class="d-sm-flex justify-content-between align-items-center"
                                    style="margin: 0px 0;">
                                    <div class="d-flex align-items-right">
                                        <div class="btn-group btn-align-right">
                                            <button type="button"
                                                class="btn btn-success waves-effect waves-float waves-light approved-btn"
                                                disabled data-toggle="modal"
                                                data-target="#exampleModal">Approve</button>
                                            &nbsp;&nbsp;
                                            <button type="button"
                                                class="btn btn-danger waves-effect waves-float waves-light  reject-visible-btn"
                                                disabled data-toggle="modal" data-target="#rejectModal">Reject</button>
                                            &nbsp;&nbsp;
                                            {{-- hide and show --}}
                                            <div class="dropdown" style="margin-top:4px;">
                                                <button class="dropbtn fa fa-gear"></button>
                                                <div id="myDropdown" class="dropdown-content">

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="card-body" style="padding-top:0px;">
                                <div class="table-responsive" style="overflow: unset;">
                                    <table class="table table-striped  my-leave-summary-entitle" id="leavetable"
                                        style="font-size:12px;">
                                        <thead>
                                            <tr>
                                                <th style="text-transform: capitalize;" width="11%">Apply Date</th>
                                                <th style="text-transform: capitalize;" width="12%">User Name</th>
                                                <th style="text-transform: capitalize;" width="10%">Claim Type</th>
                                                <th style="text-transform: capitalize;" width="10%">Amount</th>
                                                <th style="text-transform: capitalize;" width="11%">Billing Date</th>
                                                <th style="text-transform: capitalize;" width="10%">Status</th>
                                                <th style="text-transform: capitalize;" width="15%">Desc1</th>
                                                <th style="text-transform: capitalize;" width="15%">Desc2</th>
                                                <th style="text-transform: capitalize;" width="4%">Action</th>
                                                <th style="text-transform: capitalize;" style="text-align:center;"
                                                    width="2%"><input type="checkbox" id="checkAll"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="listbd">


                                        </tbody>
                                    </table>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>

                    </div>
            </section>
            <!-- Dashboard Ecommerce ends -->
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <h5 class="modal-title" id="exampleModalLabel">Approve the eclaim(s)?</h5>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary yes-btn">Yes</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <h5 class="modal-title" id="exampleModalLabel">Reject the eclaim(s)?</h5>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger reject-btn">OK</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog"
                aria-labelledby="rejectModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Are you sure want cancel the leave(s)?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="leave_id" id="leaveID">
                            <div id="cmsg"></div>
                            <lable>Please enter cancellation Reason</lable>
                            <input type="text" name="reason" id="cancelReason" class="form-control">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger cancel-btn">OK</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- END: Content-->
{{ View::make('layout.footer') }}
@include('inc-eclaim.dashboard-model')
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    <?php if($eclaimFinanceSkipSetting==1){ ?>
    var approve = "3";
    <?php }else{ ?>
    var approve = "2";
    <?php } ?>
    $('.yes-btn').attr('disabled', false);
    $('.reject-btn').attr('disabled', false);
    $(document).on('click', 'input[name="inlineRadioOptions"]', function() {
        $('.approved-btn').attr('disabled', false);
        $('.reject-visible-btn').attr('disabled', false);
    });

    $(document).on('click', '.yes-btn', function() {
        var arrId = [];
        $('.yes-btn').attr('disabled', true);
        $.each($('input[name="inlineRadioOptions"]:checked'), function() {
            var str = $(this).val();
            arrId.push(str);
        });
        var url = '{{ route('updateEClaimStatus') }}';
        $.ajax({
            url: url,
            type: 'POST',
            data: {
                '_token': "{{ csrf_token() }}",
                'status': approve,
                'ids': arrId

            },
            success: function(e) {
                window.location.reload();

            },
            error: function(w) {}
        });
    });

    $(document).on('click', '.reject-btn', function() {
        var arrId = [];
        var arrId = [];
        $.each($('input[name="inlineRadioOptions"]:checked'), function() {
            var str = $(this).val();
            arrId.push(str);
        });

        var url = '{{ route('updateEClaimStatus') }}';
        $.ajax({
            url: url,
            type: 'POST',
            data: {
                '_token': "{{ csrf_token() }}",
                'ids': arrId,
                'status': 5
            },
            success: function(e) {
                window.location.reload();
                // console.log(e);
            },
            error: function(w) {}
        });

    });
</script>


<script type="text/javascript">
    var base_url = $('body').attr('data-baseurl') + '/e-claim';
    $(document).ready(function() {
        var table = $('#leavetable').DataTable({
            "lengthMenu": [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            "processing": true,
            "destroy": true,
            "serverSide": true,
            "order": [],
            "ajax": "{!! route('e-claim.getEClaimListForApproval') !!}",

            "columns": [


                {
                    data: 'created',
                    name: 'Apply Date',
                    "render": function(data, type, row, meta) {
                        var created = row.created.split("-").reverse().join("-");
                        return created;
                    }
                },
                {
                    data: 'name',
                    name: 'User Name'
                },

                {
                    data: 'type_name',
                    name: 'Claim Type',
                    "render": function(data, type, row, meta) {
                        var ltype = '';

                        if (row.filename != null && row.filename != '') {
                            ltype += '<a href="' + base_url + '/view-file/' + row.id +
                                '" style="color:blue;">';
                            ltype += row.type_name;
                            ltype += '</a>';
                        } else {
                            ltype += row.type_name;
                        }
                        return ltype;
                    }
                },
                {
                    data: 'total_amount',
                    name: 'Amount',
                    "render": function(data, type, row, meta) {
                        var amount = parseFloat(row.total_amount).toFixed(2);


                        return amount;
                    }
                },
                {
                    data: 'billing_date',
                    name: 'Billing Date',
                    "render": function(data, type, row, meta) {
                        var billing_date = row.billing_date.split("-").reverse().join("-");
                        return billing_date;
                    }
                },
                {
                    data: 'status_text',
                    name: 'Status'
                },
                {
                    name: 'Desc1',
                    "render": function(data, type, row, meta) {
                        var des1 = ''
                        if (row.fields.length > 0) {
                            des1 += row.fields[0].field_name + " :- " + row.fields[0].value;
                        } else {
                            des1 += "-";
                        }
                        return des1;
                    }

                },
                {
                    name: 'Desc2',
                    "render": function(data, type, row, meta) {
                        var des2 = ''
                        if (row.fields.length > 1) {
                            des2 += row.fields[1].field_name + " :- " + row.fields[1].value;
                        } else {
                            des2 += "-";
                        }
                        return des2;
                    }

                },
                {
                    name: 'Action',
                    "render": function(data, type, row, meta) {
                        if (row.status < 2) {
                            var edit =
                                '<a class="appDialog-model text-success" data-toggle="modal" data-target="#inlineForm11" data-id="' +
                                row.id +
                                '" ><svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><circle cx="12" cy="12" r="3"></circle><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></a>';
                        } else {
                            var edit = '';
                        }
                        return edit;

                    }
                },
                {
                    name: 'Checkbox',
                    "render": function(data, type, row, meta) {
                        if (row.status < 2) {
                            var action =
                                '<input type="checkbox" class="approve" name="inlineRadioOptions"id="inlineRadio' +
                                row.id + '" value="' + row.id + '"' + row.dradio;
                            action += '/>';
                        } else {
                            var action = '';
                        }
                        return action;

                    }
                },


            ],

            'columnDefs': [{
                "targets": [8, 9],
                "orderable": false
            }],
            "language": {
                "paginate": {
                    // remove previous & next text from pagination
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },
            'rowCallback': function(row, data, index) {
                $(row).find('td:eq(6)').css('text-align', 'center');
                $(row).find('td:eq(7)').css('text-align', 'center');

            }


        });

        var columns = table.settings().init().columns;
        for (let i = 0; i < columns.length; i++) {
            //
            var dCol =
                `<div class="toggle-vis custom-control mt-1 ml-1 custom-control-success custom-checkbox"><input class='inp custom-control-input' data-column="${i}" key="{!! $c_key !!}" id="{!! $c_key !!}_${i}"  type="checkbox" checked><label for="{!! $c_key !!}_${i}" class="custom-control-label" style="cursor: pointer">${columns[i].name}</label></div>`;
            $("#myDropdown").append(dCol);
        }

        // show hide and show data
        var daraArr = {!! json_encode($columnHideShowData) !!}
        hidefun(table, '{!! $c_key !!}', daraArr);
    });
</script>
<style>
    #example {

        max-width: 100% !important;
        overflow: scroll;
        < !-- Available options: visible, hidden, scroll, auto -->
    }
</style>

<script>
    function update() {
        $.ajax({
            url: '{{ route('updateEClaimAmount') }}',
            method: 'POST',
            data: {
                '_token': "{{ csrf_token() }}",
                'id': $("#id").val(),
                'username': $("#employeeid").val(),
                'eclaimtype_id': $("#eclaimtype_id").val(),
                'billing_date': $("#billing_date").val(),
                'total_amount': $("#total_amount").val(),

            },
            success: function(e) {
                $("#msg").empty();
                if (e == true) {
                    $("#msg").append('<p style="color:green;">Eclaim Amount Update Sucessfully</p>');
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                } else {
                    $("#msg").append('<p style="color:red;">' + e + '</p>');
                }
            }
        });
    }

    $("#checkAll").click(function() {
        $('.approved-btn').attr('disabled', false);
        $('.reject-visible-btn').attr('disabled', false);
        $('.cancel-visible-btn').attr('disabled', false);
        $('input:checkbox').not(this).filter('.approve').not(":disabled").prop('checked', this.checked);
    });

    $("#checkAll11").click(function() {
        $('.approved-btn1').attr('disabled', false);
        $('.reject-visible-btn1').attr('disabled', false);
        $('.delete-visible-btn1').attr('disabled', false);
        $('input:checkbox').not(this).filter('.replacement').not(":disabled").prop('checked', this.checked);
    });
</script>
