{{View::make('layout.header')}}
@php
$user_join_year = date('Y',strtotime(App\Models\UserPay::where('username' , Auth::user()->username)->first()->date_commence));
$cutOffStartMonth = getSettingsValue("cut_of_startmonth");

if($cutOffStartMonth!=1){
    if($cutOffStartMonth > date('m')){
        $currentYear = date('Y')+1;
    }else{
        $currentYear = date('Y')+1;
    }
}else{
    $currentYear = date('Y')+1;
}
@endphp
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Dashboard</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                @if(session()->has('message'))
                <div class="alert alert-success">
                {{ session()->get('message') }}
                </div>
                @endif
                @if(session()->has('danger'))
                <div class="alert alert-danger">
                {{ session()->get('danger') }}
                </div>
                @endif

            </div>
            <div class="content-body">
                <section id="dashboard-ecommerce">
                    <div class="row match-height">

                        <!-- Statistics Card -->
                        <div class="col-xl-8 col-md-6 col-12">
                            <div class="card card-statistics" style="flex: 0;">
                                <div class="card-header">
                                    <h4 class="card-title">My Annual Leaves</h4>
                                </div>
                                <div class="card-body statistics-body">
                                    <div class="row">
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-primary mr-2" style="cursor:unset;">
                                                    <div class="avatar-content">
                                                        <i data-feather="thumbs-up" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                    <h4 class="font-weight-bolder mb-0">{{ isset($myLeaveSumm->claimable) ? $myLeaveSumm->claimable : 0 }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Claimable</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-info mr-2" style="cursor:unset;">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ isset($myLeaveSumm->balance) ? $myLeaveSumm->balance : 0 }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Balance</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                            <div class="media">
                                                <div class="avatar bg-light-danger mr-2" style="cursor:unset;">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                {{-- atakenel validation --}}
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">
    
                                                        @if (isset($myLeaveSumm) && $myLeaveSumm != '')
                                                            {{ $myLeaveSumm->atakenel + $myLeaveSumm->atakenal }}
                                                        @endif
                                                    </h4>
                                                    <p class="card-text font-small-3 mb-0">Taken
                                                        <br>
                                                        @if (isset($myLeaveSumm) && $myLeaveSumm != '')
                                                            (EL-{{ $myLeaveSumm->atakenel }} |
                                                        @endif
                                                        
                                                        @if (isset($myLeaveSumm) && $myLeaveSumm != '')
                                                           AL- {{ $myLeaveSumm->atakenal }})
                                                        @endif
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                            <div class="media">
                                                <div class="avatar bg-light-warning mr-2" style="cursor:unset;">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ $pendingLeave }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Pending</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card card-statistics" style="flex: 0;">
                                <div class="card-header">
                                    <h4 class="card-title">My Leaves</h4>
                                    <form id="filter-form">
                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                            <div class="d-flex align-items-center">
                                                
                                                @csrf
                                                <select class="form-control" id="start_year"  name="year" style="border-width: 0px;">
                                                <?php
                                                    $start_year = getSettingsValue("software_start_year");
                                                    $SoftwareStartDate = $start_year;
                                                    if($user_join_year>$SoftwareStartDate){
                                                        
                                                        $start_year = $user_join_year;
                                                    }
                                                    for($i= $start_year; $i<=$currentYear; $i++){
                                                    ?>
                                                        <option value="{{$i}}" <?php if ($i==$year){ echo 'selected="selected"'; } ?>><?php echo $i; ?></option>
                                                <?php }
                                                
                                                ?>
                                                </select>
                                                &nbsp;
                                                <select class="form-control" id="leave-type-select" name="leave_type" style="border-width: 0 0px 0 1px; border-radius:0px;">
                                                    @foreach($leavetypes as $leaveType)
                                                    <?php $selected='';
                                                if(request()->get('type')){
                                                 if(request()->get('type') == $leaveType->type){ 
                                                    $selected='selected';
                                                 }
                                                 else{
                                                     $selected='';
                                                 }
                                                }else
                                                {
                                                   
                                                    if($leaveType->type=='Annual'){
                                                      $selected='selected';  
                                                    }
                                                }
                                                ?>
                                                        <option value="{{ $leaveType->type }}" {{ $selected }}>{{ $leaveType->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body statistics-body">
                                    <div class="row">
                                        <canvas id="canvas" height="280" width="600"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">

                                        <h4 class="card-title"> Upcoming Holidays</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="timeline ml-50" style="height:530px; overflow-y:auto;">
                                        @foreach($recentHoliday as $recent)
                                            <li class="timeline-item" style="margin-left: 10px;">
                                                <span class="timeline-point timeline-point-indicator"></span>
                                                <div class="timeline-event">
                                                    <h6>{{ date('d-m-Y', strtotime($recent->date)) }}</h6>
                                                    <p>{{ $recent->description }}</p>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                    <center ><a style="margin-top: 10px" href="{{ url('/e-leave/view-all-holidays') }}" class="btn btn-primary btn-block"> View All Holidays</a></center>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row match-height">
                        <div class="col-xl-8 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <h4 class="card-title mb-50 mb-sm-0"> Employees On Leave Today</h4>
                                </div>
                                <div class="card-body" style="height:270px; overflow:scroll;">
                                    <div class="table-responsive ">
                                        <table class="table" style="font-size:11px">
                                            <thead>
                                                <tr>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Name</th>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Branch</th>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Department</th>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Days</th>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Category</th>
                                                    <th style="width:16%; padding: 0.72rem 1rem; text-transform: capitalize;">Type</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($leaves as $leave)
                                                <?php
                                                if($leave->type=="Other_pay"){
                                                    $type="Replacement";
                                                }elseif($leave->type=="Line_Shut"){
                                                     $type="Out Of office";
                                                }else{ 
                                                    $type=$leave->type;
                                                }
                                                ?>
                                                <tr>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->name}}</td>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->branch}}</td>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->department}}</td>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->leave_type}}</td>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->category}}</td>
                                                    <td style="width:16%; padding: 0.72rem 1rem;">{{$leave->typename }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <!-- <center> <a href="{{ url('/e-leave/self-leaves') }}" class="btn btn-primary">View All</a> </center> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">

                                        <h4 class="card-title"> Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">AL</p>
                                                </div>
                                                <?php
                                                $bal = isset($myLeaveSumm->balance) ? $myLeaveSumm->balance : 0;
                                                $en = isset($myLeaveSumm->aentitle) ? $myLeaveSumm->aentitle : 0;
                                           if($en == 0){
                                               $percentage = 0;
                                           } else {
                                           $percentage = (isset($myLeaveSumm->balance) ? $myLeaveSumm->balance : 0) / isset($myLeaveSumm->aentitle) ? $myLeaveSumm->aentitle : 0 *100 ;
                                               
                                           }
                                                ?>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ $bal }}/ {{ $en }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-info" style="height: 6px" style="background-color:#6a7e80;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="{{ $percentage }}" aria-valuemin="{{ $percentage }}" aria-valuemax="{{ $percentage }}" style="width: {{ $percentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <?php
                                               
                                                
                                                // if(($myLeaveSummSm->bf_forfeit ?? 0) == 1){
                                                //         $actual_bf = $myLeaveSummSm->entitle['brought_forward']['Other_pay'];
                                                //         $taken_bf = $myLeaveSummSm->entitle['EmergencyLeaveValue'];
                                                //         $past_leave = $myLeaveSummSm->entitle['past_leave_forfeit'];
                                                //         if($actual_bf>0){
                                                //             $bf_forfeit = $actual_bf - $taken_bf - $past_leave;
                                                //         }else{
                                                //             $bf_forfeit = $actual_bf - $taken_bf - $past_leave;
                                                //         }
                                                //     }else{
                                                //         $bf_forfeit =  $myLeaveSummSm->bf_forfeit ?? 0;
                                                //     }
                                                    
                                                //      $ml=(($myLeaveSumm['brought_forward']['medical'] ?? 0 ) + ($myLeaveSumm['brought_forward']['medical_adj'] ?? 0 ) + ($myLeaveSumm['medical']['entitle'] ?? 0))-($bf_forfeit);
                                                    
                                                //     $medleavetaken = $myLeaveSumm['medical']['taken']+$myLeaveSumm['past_leaves']['medical'];
                                                //     $meentitle = $myLeaveSumm['medical']['entitle'];
                                                //     $mebalance = ($meentitle + $myLeaveSumm['brought_forward']['medical_adj'])-($myLeaveSumm['medical']['taken']+$myLeaveSumm['past_leaves']['medical']);
                                                //     if($medleavetaken > $meentitle){
                                                //         $meBal = 0;
                                                //     }else{
                                                //         $meBal = (round($mebalance*2))/2;
                                                //     }
                                                    $meBal = isset($medicalSumm->mbalance) ? $medicalSumm->mbalance : 0;
                                                      $ml = isset($medicalSumm->mentitle) ? $medicalSumm->mentitle : 0;
                                                   // dd($medHistory);
                                                if(($ml ?? 0.0) !='0.0'){
                                                    
                                                   $medHistory11 = $ml;
                                                   $dt= $ml;
                                                     $mePercentage = $meBal  / $dt *100 ;
                                                   
                                                }
                                                else{
                                                    $medHistory11=0;
                                                      $mePercentage = 0 ;
                                                      $dt= 0;
                                                }
                                                //dd($medHistory11);
                                                 if(is_float($dt)){
                                                    $dt= round($dt,2);
                                                 }else{
                                                     $dt=$dt;
                                                 }
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">MC</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{isset($medicalSumm->mbalance) ? $medicalSumm->mbalance : 0 }}/{{ $ml }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-danger" style="height: 6px"  style="background-color:#ea5455;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: {{ $mePercentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <?php
                                                $totalReplacement=0;
                                                    $rPercentage = $totalReplacement != 0 ? isset($myLeaveSummSm->balance) ? $myLeaveSummSm->balance : 0   / $totalReplacement *100 : 0 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">RL</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{isset($myLeaveSummSm->balance) ? $myLeaveSummSm->balance : 0}}/{{$totalReplacement}} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px"   style="background-color:#4298a1;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="0" style="width: {{$rPercentage}}%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="card card-revenue-budget">
                                <div class="row mx-0">
                                    <div class="col-md-12 col-12 revenue-report-wrapper">

                                           <div class="row">
                                                <div class = "col-md-10">
                                                    <h4 class="card-title">My Summary</h4>
                                                    
                                                </div>
                                                <div class = "col-md-2">
                                                   <form id="filter-form">
                                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                                            <div class="d-flex align-items-center">
                                                                @csrf
                                                                <select class="form-control" id="start_year2"  name="year" style="border-width: 0 1px 0 0px; border-radius:0px;">
                                                                <?php
                                                                    $start_year = getSettingsValue("software_start_year");
                                                                    $SoftwareStartDate = $start_year;
                                                                    if($user_join_year>$SoftwareStartDate){
                                                                        $start_year = $user_join_year;
                                                                    }
                                                                    for($i= $start_year; $i<=$currentYear; $i++){
                                                                    ?>
                                                                        <option value="{{$i}}" <?php if ($i==$year){ echo 'selected="selected"'; } ?>><?php echo $i; ?></option>
                                                                <?php } ?>
                                                                </select>

                                                            </div>
                                                        </div>
                                                    </form>

                                    </div> </div>
                                    <div class="row">
                                    <div class="col-md-9">
                                    <div class="row">
                                    <div class="col-md-12">
                                 
                                                    </div>
                                                    </div>
                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                            <table class="table-responsive"  id="attendance-table">
                                                <thead>
                                                <tr>
                                                    <th style="text-align: center;font-size: 18px; color: white;"></th>
                                                    @for ($i=1; $i < 32 ; $i++)
                                                   <th style="min-width:25px;">{{ sprintf("%02d",$i) }}</th>
                                                    @endfor
                                                </tr>
                                                </thead>
                                                <tbody>
                                              
                                                </tbody>
                                            </table>

                                        </div>
                                        <div class="row">
                                        
                                                    <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color:#e0e0e0;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;Rest Day</span>
                                                    </div>
                                                    <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color:#28c76f;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;</p>
                                                    <span>&nbsp;Approved</span>
                                                    </div>
                                                    <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color:#00cfe8;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;RL</span>
                                                    </div>
                                                    <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color: #7367f0;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;</p>
                                                    <span>&nbsp;Other</span>
                                                    </div>
                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                    <p style="background-color:#6a7e80;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;<p>
                                                     <span >&nbsp;PH</span>
                                                      </div>
                                                    <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color:#ea5455;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;</p>
                                                    <span>&nbsp;MC<td>
                                                    </div>
                                                    
                                                    
                                                      <div class="col-md-3 col-sm-12 col-xs-12">
                                                    <p style="background-color:#4298a1;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;<p>
                                                     <span >&nbsp;NPL</span>
                                                      </div>
                                                      <div class="col-md-3 col-sm-6 col-xs-6">
                                                    <p style="background-color:#ff9f43;border-radius: 10px;width:50px; float:left;">&nbsp;&nbsp;</p>
                                                    <span>&nbsp;Pending</span>
                                                     </div>
                                                      
                                        </div>
                                        </div>
                                        <div class="col-lg-3 col-12">
                                          
                                        <canvas id="myChart" style="width:100%;max-width:100%"></canvas>
                                        <br>
                                        <div class="row">
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#28c76f;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;Approved</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_a"> 
                                        
                                        </div>
                                       
                                        </div>
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#ea5455;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;MC</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_m"> 
                                        
                                        </div>
                                       
                                        </div>
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#00cfe8;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;RL</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_od"> 
                                       
                                        </div>
                                       
                                        </div>
                                        
                                        <div class="col-md-12">
                                       
                                       <div style="width:70%; float:left;">
                                       <p style="background-color:#4298a1;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                  <span>&nbsp;NPL</span>
                                       </div>
                                       <div style="width:30%; float:right; text-align:right;" id="summary_n"> 
                                  
                                       </div>
                                      
                                       </div>
                                        
                                        
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#7367f0;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;Other</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_o"> 
                                        
                                        </div>
                                       
                                        </div>
                                        
                                       
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#ff9f43;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;Pending</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_p"> 
                                        
                                        </div>
                                       
                                        </div>
                                        <div class="col-md-12">
                                       
                                        <div style="width:70%; float:left;">
                                        <p style="background-color:#ffffff;border-radius: 10px; float:left;width:50px;">&nbsp;&nbsp;</p>
                                                   <span>&nbsp;Total</span>
                                        </div>
                                        <div style="width:30%; float:right; text-align:right;" id="summary_total"> 
                                     
                                        </div>
                                       
                                        </div>
                                             </div>
                                        </div>
                                    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <!-- END: Content-->
    {{View::make('layout.footer')}}
    @include('inc.timline-model')
 

<script>

</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.min.js"></script>
<script type="text/javascript">
    function showenddate() {
        document.getElementById('end_date').style.display='block';
    }
    function hideenddate() {
        document.getElementById('end_date').style.display='none';
    }

    $('#leave-type-select').change(function() {
        // window.location.href = "{{ route('employee-dashboard', ['type' => 'TYPE']) }}".replace('TYPE', $(this).val());
        updateGraph();

    });

    $('#start_year').change(function() {
        updateGraph();
    });

    $('#start_year2').change(function() {
        updateGraph2();
    });

    function updateGraph(){
        window.location.href = "{{ route('employee-dashboard')}}?type="+$('#leave-type-select').val()+"&year="+$('#start_year').val()+"";
    }

    var month = <?php echo $months; ?>;
    var pending = <?php echo $pendingLeaves; ?>;
    var approved = <?php echo $approvedLeaves; ?>;
    var barChartData = {
        labels: month,
        datasets: [
            {
                label: 'Approved',
                backgroundColor: "#28c76f",
                data: approved
            },
            {
                label: 'Pending',
                backgroundColor: "#ff9f43",
                data: pending
            },
        ]
    };

    window.onload = function() {
        var ctx = document.getElementById("canvas").getContext("2d");
        window.myBar = new Chart(ctx, {
            type: 'bar',
            data: barChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: '#c1c1c1',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
            }
        });
    };
    
     $(document).ready(function() {
         updateGraph2();
     });

    function updateGraph2(){
        var year = $('#start_year2').val();
        var string_url = "employee-summary?year="+year;
        $.ajax({
            url:string_url,
            type:'GET',
            success:function(data){
                var htmlString ='<tr style="line-height:20px;"><td>Jan</td>';
                
                for (var i=1; i < 32; i++){
                    htmlString +='<td style="background-color:'+data['Jan'][i]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Feb</td>';
                
                for (var j=1; j < data['Febdays']+1; j++){
                    htmlString +='<td style="background-color:'+data['Feb'][j]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Mar</td>';
                
                for (var k=1; k < 32; k++){
                    htmlString +='<td style="background-color:'+data['Mar'][k]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Apr</td>';
                
                for (var l=1; l < 31; l++){
                    htmlString +='<td style="background-color:'+data['Apr'][l]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                 htmlString +='<tr style="line-height:20px;"><td>May</td>';
                
                for (var m=1; m < 32; m++){
                    htmlString +='<td style="background-color:'+data['May'][m]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Jun</td>';
                
                for (var n=1; n < 31; n++){
                    htmlString +='<td style="background-color:'+data['Jun'][n]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Jul</td>';
                
                for (var o=1; o < 32; o++){
                    htmlString +='<td style="background-color:'+data['Jul'][o]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Aug</td>';
                
                for (var p=1; p < 32; p++){
                    htmlString +='<td style="background-color:'+data['Aug'][p]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Sep</td>';
                
                for (var q=1; q < 31; q++){
                    htmlString +='<td style="background-color:'+data['Sep'][q]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Oct</td>';
                
                for (var r=1; r < 32; r++){
                    htmlString +='<td style="background-color:'+data['Oct'][r]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Nov</td>';
                
                for (var s=1; s < 31; s++){
                    htmlString +='<td style="background-color:'+data['Nov'][s]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                htmlString +='<tr style="line-height:20px;"><td>Dec</td>';
                
                for (var t=1; t < 32; t++){
                    htmlString +='<td style="background-color:'+data['Dec'][t]+'; width: 40px;  border: 1px solid #d6d6d6;"></td>';
                 }
                
                htmlString +='</tr>';
                $("#attendance-table tbody").html(htmlString);
                
                $("#summary_a").html(data['a']+' Days');
                $("#summary_m").html(data['m']+' Days');
                $("#summary_od").html(data['od']+' Days');
                $("#summary_n").html(data['n']+' Days');
                $("#summary_o").html(data['o']+' Days');
                $("#summary_p").html(data['p']+' Days');
                var total =data['a']+data['m']+data['od']+data['n']+data['o']+data['p'];
                $("#summary_total").html(total+' Days');
                
                var xValues = ["Approved", "MC", "RL", "NPL", "Other", "Pending"];
                var yValues = [data['a'],  data['m'],data['od'],data['n'], data['o'], data['p']];
                var barColors = [
                  "#28c76f",
                  "#ea5455",
                  "#00cfe8",
                  "#4298a1",
                  "#7367f0",
                  "#ff9f43"
                ];
                
                new Chart("myChart", {
                  type: "doughnut",
                  data: {
                    labels: xValues,
                    datasets: [{
                      backgroundColor: barColors,
                      data: yValues
                    }]
                  },
                  options: {
                        responsive: true,
                        title: {
                            display: false,
                            position: "top",
                            fontStyle: "bold",
                            fontSize: 0,
                            fullWidth: false,
                            padding: 0
                        },
                        legend: {
                            display: false,
                            position: "top",
                            fullWidth: false,
                            labels: { display: false, usePointStyle: true, fontSize: 15, fontStyle: "bold" }
                
                        }
                    }
                });
            },
            error:function(w){
            }
        });
        
    }
    function updateGraph21(){
        window.location.href = "{{ route('employee-dashboard')}}?type="+$('#leave-type-select').val()+"&year="+$('#start_year2').val()+"";
    }

    var month = <?php echo $months; ?>;
    var pending = <?php echo $pendingLeaves; ?>;
    var approved = <?php echo $approvedLeaves; ?>;
    var barChartData = {
        labels: months,
        datasets: [
            {
                label: 'Approved',
                backgroundColor: "#28c76f",
                data: approved
            },
            {
                label: 'Pending',
                backgroundColor: "#ff9f43",
                data: pending
            },
        ]
    };

    window.onload = function() {
        var ctx = document.getElementById("canvas").getContext("2d");
        window.myBar = new Chart(ctx, {
            type: 'bar',
            data: barChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: '#c1c1c1',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
            }
        });
    };

</script>
