<table class="table">
    <thead>
        <tr>
            <th width="10%" style="text-transform: capitalize;" width="10%">Type</th>
            <th width="10%" style="text-transform: capitalize;" width="5%">Date</th>
            <th style="text-transform: capitalize;" width="5%">Days</th>
            <th style="text-transform: capitalize;" width="10%">Reason</th>
            <th style="text-transform: capitalize;white-space: nowrap;" width="10%">Cancellation Reason</th>
            <th style="text-transform: capitalize;white-space: nowrap;" width="10%">Reject Reason</th>
            <th style="text-transform: capitalize;" width="10%">Status</th>
            <th style="text-transform: capitalize;" width="5%">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($leaves as $leave)
        <tr>
            @php
                $r_name = '';
                if($leave->relieve != '')
                {
                    $employee = Illuminate\Support\Facades\DB::table('user_personal')
                    ->where('username', $leave->relieve)->first();
                    $r_name = $employee->name;
                }

                $status = '';
                $class= '';

                if($leave->status == 0)
                {
                    $status = 'Pending';
                    $class= 'grey';
                }
                elseif($leave->status == 1)
                {
                    $status = 'Approved';
                    $class= 'green';
                }
                elseif($leave->status == 2)
                {
                    $status = 'Rejected';
                    $class= 'red';
                }
                elseif($leave->status == 3)
                {
                    $status = 'Recommended';
                    $class= 'blue';
                }
                elseif($leave->status == 4)
                {
                    $status = 'Cancelled';
                    $class= 'yellow';
                }
                elseif($leave->status == 5)
                {
                    $status = 'Cancellation Pending';
                    $class= 'orange';
                }
                $leaveDays = Illuminate\Support\Facades\DB::table('leave_days')->where('leave_id', $leave->id)->first();
            @endphp
            <td>{{ $leave->type }}</td>
            <td style="white-space: nowrap;"><a class="appDialog-model" data-toggle="modal" data-target="#inlineForm" 
            data-id="{{$leave->id}}" style="color:#3192F4;">{{ date('d-m-Y', strtotime($leave->start_date)) }}</a></td>
            <td>{{ $leave->no_days }}</td>
            <td>{{ $leave->reason }}</td>
            <td>{{ isset($leaveDays) ? $leaveDays->cancellation_reason :''}}</td>
            <td>{{ isset($leaveDays) ? $leaveDays->reject_reason :''}}</td>
            <td style="background-color:{{$class}};color:black;">{{ $status }}</td>
            <td><button type="button" data-toggle="modal" data-target="#exampleModal" 
            data-id="{{$leave->id}}"
            class="btn btn-outline-dark btn-sm waves-effect app-dialog-model" {{ $leave->status == '4' || $leave->status == '5' ? 'disabled' : ''}}>Cancel</button></td>
        </tr>
        @endforeach
    </tbody>
</table><br>
