    {{View::make('layout.header')}}
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">My Leaves</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                    <div class="form-group breadcrumb-right">
                        <a href="#" class="btn btn-primary btn-block waves-effect waves-float waves-light" data-toggle="modal" data-target="#add-payment-sidebar">Apply For Leave</a>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-lg-12 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        
                                        <h4 class="card-title"> My Leaves Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        @foreach($history as $leaveType)
                                        <?php
                                        $percentage = $leaveType->entitle != 0 ? (($leaveType->entitle - $leaveType->leave_taken) / $leaveType->entitle) * 100 : 0;
                                        ?>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">{{ $leaveType->leave_type}}</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ $leaveType->entitle - $leaveType->leave_taken}}/{{ $leaveType->entitle}} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="{{ $leaveType->entitle }}" style="width: {{  $percentage }}%"></div>
                                            </div>
                                        </div>
                                        @endforeach
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/ Medal Card -->
                    </div>

                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">My Leaves</h4>
                                            <form method="get" action="{{ route('employee-myleaves') }}">
                                                <div class="d-flex align-items-center">
                                                    <select name="type" class="select2 form-control" style="padding-left: 10px;">
                                                        <option value="">All Leave Types</option>
                                                        @foreach($leaveTypes as $type)
                                                            <option value="{{ $type->name }}" {{request()->get('type') && request()->get('type') == $type->name ? 'selected' : '' }}>{{ $type->name }}</option>
                                                        @endforeach    
                                                    </select>
                                                    
                                                    <lable  style="padding-left: 10px;">From</lable>
                                                    <input type="text" id="datepicker1" name="from" class="form-control"  style="padding-left: 10px;" value="{{request()->get('from') ? request()->get('from') : '' }}">
                                                    
                                                    <lable  style="padding-left: 10px;">To</lable>
                                                    <input type="text" id="datepicker2" name="to" class="form-control"  style="padding-left: 0px;" value="{{request()->get('to') ? request()->get('to') : '' }}">
                                                    &nbsp;&nbsp;
                                                    <button type="submit" class="btn btn-secondary btn-block waves-effect waves-float waves-light" style="padding-left: 10px;">Filter</button>
                                                </div>
                                            </form>    
                                        </div>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>TYPE</th>
                                                <th>RELIEVE</th>
                                                <th>LEAVE DATE</th>
                                                <th>LEAVE REASON</th>
                                                <th width="20%">STATUS</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($leaves as $leave)
                                            <tr>
                                                @php
                                                    $r_name = '';
                                                    if($leave->relieve != '')
                                                    {
                                                        $employee = Illuminate\Support\Facades\DB::table('user_personal')
                                                        ->where('username', $leave->relieve)->first();
                                                        $r_name = $employee->name;
                                                    }

                                                    $status = '';
                                                    $class= '';

                                                    if($leave->status == 0)
                                                    {
                                                        $status = 'Pending';
                                                        $class= 'grey';
                                                    }
                                                    elseif($leave->status == 1)
                                                    {
                                                        $status = 'Approved';
                                                        $class= 'green';
                                                    }
                                                    elseif($leave->status == 2)
                                                    {
                                                        $status = 'Rejected';
                                                        $class= 'red';
                                                    }
                                                    elseif($leave->status == 3)
                                                    {
                                                        $status = 'Recommended';
                                                        $class= 'blue';
                                                    }
                                                    elseif($leave->status == 4)
                                                    {
                                                        $status = 'Cancelled';
                                                        $class= 'yellow';
                                                    }
                                                    elseif($leave->status == 5)
                                                    {
                                                        $status = 'Cancellation Pending';
                                                        $class= 'orange';
                                                    }
                                                    
                                                @endphp
                                                <td>{{ $leave->type }}</td>
                                                <td>{{ $r_name }}</td>
                                                 <td>{{ date('d-m-Y', strtotime($leave->start_date)) }}</td>
                                                <td>{{ $leave->reason }}</td>
                                                <td style="background-color:{{$class}};color:black;">{{ $status }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <br>
                                    <div style="float: right;">
                                        {{ $leaves->links('pagination::bootstrap-4') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Ecommerce ends -->
                <div class="modal modal-slide-in fade" id="add-payment-sidebar" aria-hidden="true">
                    <div class="modal-dialog sidebar-lg">
                        <div class="modal-content p-0">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">×</button>
                            <div class="modal-header mb-1">
                                <h5 class="modal-title">
                                    <span class="align-middle">Apply Leave</span>
                                </h5>
                            </div>
                            <div class="modal-body flex-grow-1">
                            <form id="leave-form">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                <input type="hidden" name="user_id" value="{{Auth::id()}}">
                                    <div class="form-group">
                                        <label class="form-label" for="payment-date">Leave Type  :</label>
                                        <select class="form-control" id="basicSelect" name="leave_type">
                                            <option value="">select</option>
                                            @foreach($leaveTypes as $type)
                                                <option value="{{ $type->name }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="type-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="payment-note">Half Day / Full Day  : </label>
                                        <div class="demo-inline-spacing">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="hideenddate()" name="hof" id="inlineRadio1" value="1" />
                                                <label class="form-check-label" for="inlineRadio1">Half Day</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="showenddate()" name="hof" id="inlineRadio2" value="0" checked/>
                                                <label class="form-check-label" for="inlineRadio2">Full Day</label>
                                            </div>
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="day-error"></span>
                                    </div>
                                    <div class="form-group" id="half_day_type" style="display:none;">
                                        <label>Half Day Type</label>
                                        <select name="half_day_type" class="form-control">
                                            <option value="first">First Half</option>
                                            <option value="second">Second Half</option>
                                        </select>
                                    </div>    
                                    <div class="form-group">
                                        <label>Leave start Date</label>
                                        <input type="date" name="leave_start_date" class="form-control" placeholder="Leave Start Date" autocomplete="off">
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="start-date-error"></span>
                                    </div>
                                    <div id="end_date">
                                        <label>Leave End Date</label>
                                        <div class="form-group">
                                            <input type="date" name="leave_end_date" class="form-control" id="datepicker2" placeholder="Leave End Date"  autocomplete="off" >
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="end-date-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label>Reason</label>
                                        <textarea class="form-control" name="reason" placeholder="Type here"></textarea>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="reason-error"></span>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Relieve</label>
                                        <select class="form-control" name="relieve">
                                            <option value="">Select Relieve</option>
                                            @foreach($relieves as $relieve)
                                            <option value="{{$relieve->username}}">{{$relieve->name}}</option>
                                            @endforeach
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="relive-error"></span>
                                    </div>
                                    <div class="form-group d-flex flex-wrap mb-0">
                                        <button type="button" onclick="saveDetails()" class="btn btn-primary mr-1">Send</button>
                                        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    {{View::make('layout.footer')}}
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">
        function showenddate() {
            document.getElementById('end_date').style.display='block';
            document.getElementById('half_day_type').style.display='none';
        }
        function hideenddate() {
            document.getElementById('end_date').style.display='none';
            document.getElementById('half_day_type').style.display='block';
        }

        function saveDetails(e){
            var leaveForm = $("#leave-form");
            var data = leaveForm.serialize();
            $( '#type-error' ).html('');
            $( '#day-error' ).html('');
            $( '#start-date-error' ).html('');
            $( '#end-date-error' ).html('');
            $( '#relive-error' ).html('');
            $( '#reason-error' ).html('');
            $.ajax({
                url:'{{route('myleave-apply')}}',
                type:'POST',
                data:data,
                success:function(e){
                   window.location.reload();
                   Swal.fire(
                    'Good job!',
                    'Leave Successfully added!',
                    'success'
                    )
                },
                error:function(w){
                    if(w.responseJSON.errors)
                    {
                        if(w.responseJSON.errors.leave_type){
                            $( '#type-error' ).html( w.responseJSON.errors.leave_type[0] );
                        }
                        if(w.responseJSON.errors.hof){
                            $( '#day-error' ).html( w.responseJSON.errors.hof[0] );
                        }
                        if(w.responseJSON.errors.leave_start_date){
                            $( '#start-date-error' ).html( w.responseJSON.errors.leave_start_date[0] );
                        }
                        if(w.responseJSON.errors.leave_end_date){
                            $( '#end-date-error' ).html( w.responseJSON.errors.leave_end_date[0] );
                        }
                        if(w.responseJSON.errors.reason){
                            $( '#reason-error' ).html( w.responseJSON.errors.reason[0] );
                        }
                        if(w.responseJSON.errors.relieve){
                            $( '#relive-error' ).html( w.responseJSON.errors.relieve[0] );
                        }

                    }
                }
            });
            

        };
    </script>