<style>
    .inr-sign::before {
        content: "\20B9";
    }

    .inr-sign::after {
        content: "\20B9";
    }

    @page {

        th,
        td,
        p,
        div,
        b ... {
            margin: 0;
            padding: 0
        }

        html {
            margin: 40px 50px
        }
    }
</style>
<table style="width:100%;border: 1px Solid black;font-size: 14px; table-layout:fixed;">
    <thead>
        <tr style="border: 1px Solid black;">
            @foreach ($arrColumns as $key => $arrColumn)
                @if (!in_array($key, json_decode($columnHideShowData)))
                    <th>
                        {{ $arrColumn }}</th>
                @endif
            @endforeach

        </tr>
    </thead>
    <tbody>
        @foreach ($leaves as $request)
            @php
                $userPersonal = DB::table('user_personal')
                    ->where('username', $request->username)
                    ->first();
                $emp_no = isset($userPersonal) ? $userPersonal->employee_no : '';
                $emp_name = isset($userPersonal) ? $userPersonal->name : '';
                $status = '';
                $class = '';
                $htype = '';
                if ($request->half_day_type == 'first') {
                    $htype = 'AM';
                }
                if ($request->half_day_type == 'second') {
                    $htype = 'PM';
                }
                if ($request->status == 0) {
                    $status = 'Pending';
                    $class = 'grey';
                } elseif ($request->status == 1) {
                    $status = 'Approved';
                    $class = 'green';
                } elseif ($request->status == 2) {
                    $status = 'Rejected';
                    $class = 'red';
                } elseif ($request->status == 3) {
                    $status = 'Recommended';
                    $class = 'blue';
                } elseif ($request->status == 4) {
                    $status = 'Cancelled';
                    $class = 'yellow';
                } elseif ($request->status == 5) {
                    $status = 'Cancellation Pending';
                    $class = 'orange';
                }
                $r_name = '';
                if ($request->relieve != '') {
                    $employee = Illuminate\Support\Facades\DB::table('user_personal')
                        ->where('username', $request->relieve)
                        ->first();
                    $r_name = '';
                    if (!empty($employee)) {
                        $r_name = $employee->name;
                    }
                }
                if ($request->type == 'Line_Shut') {
                    $iname = 'Out Of Office';
                } elseif ($request->type == 'Other_pay') {
                    $iname = 'Replacement';
                } else {
                    $iname = $request->type;
                }
                if ($request->is_hourly == 1) {
                    $ndays = $request->no_of_hours . ' Hour(s)';
                } else {
                    $ndays = $request->no_days . ' ' . $htype . ' Day(s)';
                }
                
            @endphp
            <tr>
                @php
                    $arrRows = [$emp_no, $emp_name, $r_name, $iname, date('d-m-Y', strtotime($request->start_date)), $ndays, $status, $request->reason];
                @endphp
                @for ($k = 0; $k < count($arrRows); $k++)
                    @if (!in_array($k, json_decode($columnHideShowData)))
                        <td>{{ $arrRows[$k] }}</td>
                    @endif
                @endfor
            </tr>
        @endforeach
    </tbody>
</table>
