{{ View::make('layout.header') }}

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">HR
                                </li>
                                <li class="breadcrumb-item">Reports
                                </li>
                                <li class="breadcrumb-item active"><a href="#">Category Report</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-right col-md-3 col-12">
                <!-- <a onclick="exportpdf()" class="text-danger" ><i class="fa fa-file-pdf-o report-download-btn" style="font-size:25px;"></i></a>
                 &nbsp;&nbsp;
                 <a onclick="exportexcel()" class="text-success"><i class="fa fa-file-excel-o report-download-btn" style="font-size:25px;"></i></a> -->
            </div>
        </div>
        <div class="content-body">
            <div class="content-body">
                <section id="dashboard-ecommerce">


                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="btn-group">
                                        <h4>Category Report</h4>
                                    </div>
                                    <div class="d-sm-flex justify-content-between align-items-center"
                                        style="margin: 0px 0;">
                                        <div class="d-flex align-items-right">
                                            <div class="btn-group btn-align-right MiniRightnav">
                                                <a onclick="exportpdf()" class="text-danger"><i
                                                        class="fa fa-file-pdf-o report-download-btn"
                                                        style="font-size:25px;"></i><span>Download PDF</span></a>
                                                &nbsp;&nbsp;
                                                <a onclick="exportexcel()" class="text-success"><i
                                                        class="fa fa-file-excel-o report-download-btn"
                                                        style="font-size:25px;"></i><span>Download Excel</span></a>
                                                &nbsp;&nbsp;
                                                {{-- hide and show --}}
                                                <div class="dropdown">
                                                    <button class="dropbtn fa fa-gear"></button>
                                                    <div id="myDropdown" class="dropdown-content">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="card-body">
                                    <div class="table-responsive" style="padding: 0 15px 15px 15px;">

                                        <!--<table  id="example11" class="table table-bordered" style="font-size:11px;text-align: center;" width="100%" border="1">-->
                                        <table class="table table-striped  my-leave-summary-entitle" id="example11"
                                            style="font-size:12px;">
                                            <thead>
                                                <tr>
                                                    <th width="30%" style="text-transform: capitalize;">Category</th>
                                                    <th width="25%" style="text-transform: capitalize;">Description
                                                    </th>
                                                    <th width="10%" style="text-transform: capitalize;">Email</th>
                                                    <th width="10%" style="text-transform: capitalize;">Forecast</th>


                                                    <th width="15%"
                                                        style="text-transform: capitalize;white-space: nowrap;">Actual
                                                    </th>
                                                    <th width="10%" style="text-transform: capitalize;">Percent</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td width="75%"
                                                        style="text-align: right;;text-transform: capitalize;"
                                                        colspan="4">Total</td>
                                                    <td width="25%" colspan="2"
                                                        style="text-transform: capitalize;">{{ $total }}</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </section>
            </div>
        </div>
    </div>
</div>
<!-- END: Content-->
{{ View::make('layout.footer') }}
@include('inc.timline-model')

<script type="text/javascript">
    $(document).ready(function() {
        var table = $('#example11').DataTable({
            "lengthMenu": [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            "order": [],
            "processing": true,
            "destroy": true,
            "serverSide": true,
            "searching": false,
            "ajax": "{!! route('getrcategorydata') !!}",

            "columns": [

                {
                    data: 'name',
                    name: 'Category'
                },
                {
                    data: 'description',
                    name: 'Description'
                },
                {
                    data: 'email',
                    name: 'Email'
                },
                {
                    data: 'forecast',
                    name: 'Forecast'
                },
                {
                    data: 'employee',
                    name: 'Employee'
                },
                {
                    data: 'percent',
                    name: 'Percent',
                    "render": function(data, type, row, meta) {
                        var percent = row.percent + '%';
                        return percent;
                    }
                },

            ],
            'rowCallback': function(row, data, index) {
                $(row).find('td:eq(0)').css('word-break', 'all');
                $(row).find('td:eq(1)').css('word-break', 'all');

            },
            "language": {
                "paginate": {
                    // remove previous & next text from pagination
                    "previous": '&nbsp;',
                    "next": '&nbsp;'
                }
            },
        });

        var columns = table.settings().init().columns;
        for (let i = 0; i < columns.length; i++) {
            //
            var dCol =
                `<div class="toggle-vis custom-control mt-1 ml-1 custom-control-success custom-checkbox"><input class='inp custom-control-input' data-column="${i}" key="{!! $c_key !!}" id="{!! $c_key !!}_${i}"  type="checkbox" checked><label for="{!! $c_key !!}_${i}" class="custom-control-label" style="cursor: pointer">${columns[i].name}</label></div>`;
            $("#myDropdown").append(dCol);
        }

        // show hide and show data
        var daraArr = {!! json_encode($columnHideShowData) !!}
        hidefun(table, '{!! $c_key !!}', daraArr);

    });


    function exportpdf() {
        let url = "catpdf";
        window.location.href = url;
    }

    function exportexcel() {
        let url = "catexport";
        window.location.href = url;
    }
</script>
