<style>
    table {
        border-collapse: collapse;
        width: 100%;
    }

    th,
    td {
        text-align: left;
        padding: 6px;
    }

    thead {
        display: table-header-group
    }

    tfoot {
        display: table-row-group
    }

    tr {
        page-break-inside: avoid
    }

    tr:nth-child(even) {
        background-color: #f5f5dc;
    }

    @page {

        th,
        td,
        p,
        div,
        b ... {
            margin: 0;
            padding: 0
        }

        html {
            margin: 40px 50px
        }
    }
</style>

<table class="table table-bordered  my-leave-summary-entitle" id="example11" style="font-size:12px; table-layout:fixed;">
    <thead>

        <tr style="height:80px; border-top:1px solid black !important; border-bottom:0px !important;">
            <th width="30%" style="border-top:1px solid black !important; text-align:left; font-weight:300;">
                {{ $companyname->v4_value }}</th>
            <th width="40%" style="border-top:1px solid black !important; text-align:center; font-size:22px;">Approver
                Leave List</th>
            <th width="30%" style="border-top:1px solid black !important; text-align:right; font-weight:300;">
                {{ $timedate }}</th>
        </tr>
    </thead>
</table>
<table class="table table-bordered  my-leave-summary-entitle" id="example11"
    style="font-size:11px; table-layout:fixed;">
    <thead>

        <tr style="height:50px; border-top:1px solid black !important; border-bottom:1px solid black !important;">
            @foreach ($arrColumns as $key => $arrColumn)
                @if (!in_array($key, json_decode($columnHideShowData)))
                    <th
                        style="border-top:1px solid black !important; border-bottom:1px solid black !important;  text-align: left;color:black;text-transform: capitalize;">
                        {{ $arrColumn }}</th>
                @endif
            @endforeach
        </tr>
    </thead>
    <tbody>
        @foreach ($leaves as $leave)
            <?php if ($leave->date_approved == '-') {
                $leave->date_approved = '';
            }
            if ($leave->date_applied == '-') {
                $leave->date_applied = '';
            } ?>
            <tr style="height:25px;">

                <?php if ($leave->date_approved != '' && $leave->date_approved != '0000-00-00') {
                    $aDate = date('d-m-Y', strtotime($leave->date_approved));
                } else {
                    $aDate = '';
                } ?>

                <?php if ($leave->date_applied != '' && $leave->date_applied != '0000-00-00') {
                    $appDate = date('d-m-Y', strtotime($leave->date_applied));
                } else {
                    $appDate = '';
                } ?>

                <?php if ($leave->is_hourly != 0) {
                    $lCalc = number_format((float) $leave->no_of_hours, 2) . 'Hour(s)';
                } else {
                    $lCalc = $leave->no_days . ' ' . $leave->half_day . 'Day(s)';
                } ?>

                @php
                    $arrRows = [$leave->emp_no, $leave->emp_name, $leave->r_name ,$leave->leave_type, date('d-m-Y', strtotime($leave->date)), $aDate, $appDate, $lCalc, $leave->leave_status, $leave->reason];
                @endphp
                @for ($k = 0; $k < count($arrRows); $k++)
                    @if (!in_array($k, json_decode($columnHideShowData)))
                        <td style="word-break: break-all; word-wrap: break-word;  ">{{ $arrRows[$k] }}</td>
                    @endif
                @endfor
            </tr>
        @endforeach
    </tbody>
</table>
