<style>
    table {
        border-collapse: collapse;
        width: 100%;
        border: 1px solid black;
    }

    th,
    td {
        text-align: left;
        padding: 6px;
    }



    @page {

        th,
        td,
        p,
        div,
        b ... {
            margin: 0;
            padding: 0
        }

        html {
            margin: 40px 50px
        }
    }
</style>


<table width="100%" style="text-align: center">
    <tr>
        <td>
            <div>
                <h1>Electronic Time Card</h1>
            </div>
        </td>
        <td>
            <div style="padding-left: 60% !important;">
                <img src="{{ asset('') }}/storage/settings/companylogo/<?php echo getcompanylogo(); ?>" width="125px">
            </div>
        </td>
    <tr>
</table>
<br>

@foreach ($employees as $employee)
    <br>
    <table width="100%" style="text-align: center">
        <tr>
            <td>User ID = {{ $employee['employee_no'] }}</td>
            <td>Name = {{ $employee['personname'] }}</td>
            <td><span style="font-family: DejaVu Sans, sans-serif;">✔</span> = Excused</td>
            <td>Date : {{ date('d-m-Y', strtotime($employee['start_date'])) }} -
                {{ date('d-m-Y', strtotime($employee['end_date'])) }}</td>
        </tr>
    </table>
    <table width="100%">
        <thead>
            <tr>
                <th style="text-transform: capitalize;">Date</th>
                <th style="text-transform: capitalize;">Day Type</th>
                <th style="text-transform: capitalize;">Sche</th>

                <th style="text-transform: capitalize;">In</th>
                <th style="text-transform: capitalize;">Break</th>
                <th style="text-transform: capitalize;">Resume</th>
                <th style="text-transform: capitalize;">Out</th>

                <th style="text-transform: capitalize;">Work</th>
                <th style="text-transform: capitalize;">Overtime</th>
                <th style="text-transform: capitalize;">Short</th>

                <th style="text-transform: capitalize;">Leave Taken</th>
                <th style="text-transform: capitalize;">Remark</th>

            </tr>
        </thead>
        <tbody>
            @foreach ($employee['att'] as $attData)
                @if ($attData)
                    <tr style="border-bottom: 1px solid black;">
                        <th>{{ date('d-m-Y', strtotime($attData['date'])) ?? null }}</th>
                        <td>{{ $attData['day_type'] ?? null }}</td>
                        <td>{{ $attData['sche'] ?? null }}</td>
                        <td>{{ $attData['in_time'] ?? null }}</td>
                        <td>{{ $attData['break_time'] ?? null }}</td>
                        <td>{{ $attData['resume_time'] ?? null }}</td>
                        <td>{{ $attData['out_time'] ?? null }}</td>
                        <td>{{ $attData['work'] ?? null }}</td>
                        <td>{{ $attData['overtime'] ?? null }}</td>
                        <td>{{ $attData['short'] ?? null }}</td>
                        <td>{{ $attData['leave_taken'] ?? null }}</td>
                        <td>{{ $attData['remark'] ?? null }}</td>
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>

    @php
        $workDays = 0;
        $flexiDays = 0;
        $holidays = 0;
        $workDayPresent = 0;
        $flexiDayPresent = 0;
        $holidayPresent = 0;
        $workDayHours = 0;
        $flexiDayHours = 0;
        $holidayHours = 0;
        $workDayOvertimeHours = 0;
        $flexiOvertimeHours = 0;
        $holiOvertimeHours = 0;
        $workDayShortHours = 0;
        $flexiShortHours = 0;
        $holiShortHours = 0;
    @endphp
    @foreach ($employee['att'] as $attData)
        @php
            if (isset($attData['day_type']) && $attData['day_type'] == 'Work') {
                $workDays += 1;
                if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                    $workDayPresent += 1;
                }
            
                if (isset($attData['work'])) {
                    $workDayHours = second_to_hhmm(explode_time($workDayHours) + explode_time($attData['work']));
                }
            
                if (isset($attData['overtime'])) {
                    $workDayOvertimeHours = second_to_hhmm(explode_time($workDayOvertimeHours) + explode_time($attData['overtime']));
                }
            
                if (isset($attData['short'])) {
                    $workDayShortHours = second_to_hhmm(explode_time($workDayShortHours) + explode_time($attData['short']));
                }
            }
            
            if (isset($attData['day_type']) && $attData['day_type'] == 'Flexi') {
                $flexiDays += 1;
                if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                    $flexiDayPresent += 1;
                }
            
                if (isset($attData['work'])) {
                    $flexiDayHours = second_to_hhmm(explode_time($flexiDayHours) + explode_time($attData['work']));
                }
            
                if (isset($attData['overtime'])) {
                    $flexiOvertimeHours = second_to_hhmm(explode_time($flexiOvertimeHours) + explode_time($attData['overtime']));
                }
            
                if (isset($attData['short'])) {
                    $flexiShortHours = second_to_hhmm(explode_time($flexiShortHours) + explode_time($attData['short']));
                }
            }
            
            if ((isset($attData['day_type']) && $attData['day_type'] == 'HOLIDAY') || (isset($attData['day_type']) && $attData['day_type'] == 'Rest')) {
                $holidays += 1;
                if ((isset($attData['in_time']) && $attData['in_time'] != '00:00' && $attData['in_time'] != null) || $attData['break_time'] || $attData['resume_time'] || $attData['out_time']) {
                    $holidayPresent += 1;
                }
            
                if (isset($attData['work'])) {
                    $holidayHours = second_to_hhmm(explode_time($holidayHours) + explode_time($attData['work']));
                }
            
                if (isset($attData['overtime'])) {
                    $holiOvertimeHours = second_to_hhmm(explode_time($holiOvertimeHours) + explode_time($attData['overtime']));
                }
            
                if (isset($attData['short'])) {
                    $holiShortHours = second_to_hhmm(explode_time($holiShortHours) + explode_time($attData['short']));
                }
            }
        @endphp
    @endforeach

    <table>
        <tr>
            <td>
                <table class="table" id="reporttable" style=" font-size:12px;">
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th>Day Type</th>
                            <th>Total Days</th>
                            <th>Present</th>
                            <th>Work</th>
                            <th>Overtime</th>
                            <th>Short</th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr style="border-bottom: 1px solid black;">
                            <td>Workday</td>
                            <td>{{ $workDays }}</td>
                            <td>{{ $workDayPresent }}</td>
                            <td>{{ $workDayHours }}</td>
                            <td>{{ $workDayOvertimeHours }}</td>
                            <td>{{ $workDayShortHours }}</td>
                        </tr>
                        <tr style="border-bottom: 1px solid black;">
                            <td>FlexiDay</td>
                            <td>{{ $flexiDays }}</td>
                            <td>{{ $flexiDayPresent }}</td>
                            <td>{{ $flexiDayHours }}</td>
                            <td>{{ $flexiOvertimeHours }}</td>
                            <td>{{ $flexiShortHours }}</td>
                        </tr>
                        <tr style="border-bottom: 1px solid black;">
                            <td>RestDay</td>
                            <td>{{ $holidays }}</td>
                            <td>{{ $holidayPresent }}</td>
                            <td>{{ $holidayHours }}</td>
                            <td>{{ $holiOvertimeHours }}</td>
                            <td>{{ $holiShortHours }}</td>
                        </tr>
                    </tbody>

                    <tbody>
                        <tr style="border-bottom: 1px solid black;">
                            <td>Total</td>
                            <td>{{ $workDays + $flexiDays + $holidays }}</td>
                            <td>{{ $workDayPresent + $flexiDayPresent + $holidayPresent }}
                            </td>
                            <td>
                                {{ second_to_hhmm(explode_time($workDayHours) + explode_time($flexiDayHours) + explode_time($holidayHours)) }}
                            </td>
                            <td>
                                {{ second_to_hhmm(explode_time($workDayOvertimeHours) + explode_time($flexiOvertimeHours) + explode_time($holiOvertimeHours)) }}
                            </td>
                            <td>
                                {{ second_to_hhmm(explode_time($workDayShortHours) + explode_time($flexiShortHours) + explode_time($holiShortHours)) }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            <td>
                <table class="table" id="reporttable" style=" font-size:12px;">
                    <thead>
                        <tr>
                            <th>Leave Type</th>
                            <th>Total</th>

                        </tr>
                    </thead>

                    <tbody>
                        @php
                            $leaveCount = 0;
                        @endphp
                        @foreach ($leaveNames as $lv)
                            <tr style="border-bottom: 1px solid black;">
                                @php
                                    $leaveType = $lv->type;
                                @endphp
                                <td>{{ $leaveType }}</td>
                                <td>
                                    @php
                                        $leaveList = array_filter($employee['att'], function ($value) use ($leaveType) {
                                            if (isset($value['leave_taken'])) {
                                                return $leaveType == $value['leave_taken'];
                                            }
                                        });
                                        
                                        $leaveCount += count($leaveList);
                                    @endphp
                                    {{ count($leaveList) }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tbody>
                        <tr>
                            <td>Total</td>
                            <td>{{ $leaveCount }}</td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </table>

    <div style="page-break-after: always;"> </div>
@endforeach
