<style>
    table {
        border-collapse: collapse;
        width: 100%;
    }

    th,
    td {
        text-align: left;
        padding: 6px;
    }


    @page {

        th,
        td,
        p,
        div,
        b ... {
            margin: 0;
            padding: 0
        }

        html {
            margin: 40px 50px
        }
    }
</style>


<table width="100%" style="text-align: center">
    <tr>
        <td>
            <div>
                <h1>User Movement Analysis</h1>
            </div>
        </td>
        <td>
            <div style="padding-left: 60% !important;">
                <img src="{{ asset('') }}/storage/settings/companylogo/<?php echo getcompanylogo(); ?>" width="125px">
            </div>
        </td>
    <tr>
</table>

<br>

<table width="100%">
    <thead>
        <tr>
            @foreach ($arrColumns as $key => $arrColumn)
                @if (!in_array($key, json_decode($columnHideShowData)))
                    <th
                        style="border-top:1px solid black !important; border-bottom:1px solid black !important;  text-align: left;color:black;text-transform: capitalize;">
                        {{ $arrColumn }}</th>
                @endif
            @endforeach
        </tr>
    </thead>
    <tbody>

        @foreach ($employees as $employee)
            <tr>
                @php
                    
                    $html = '<tr>';
                    $count = 1;
                    foreach ($employee->movement as $key => $movement) {
                        $index = explode('_', $key);
                        if ($index[0] == '0000') {
                            $dvc = 'Manual';
                        } else {
                            $dvc = $index[0];
                        }
                        $html .= '<td>' . $movement . '<br>' . $dvc . '</td>';
                        if ($count % 4 == 0) {
                            $html = $html . '</tr><tr>';
                        }
                    
                        $count++;
                    }
                    
                    $movement = '<table>' . $html . '</table>';
                    
                    $arrRows = [$employee->date, $employee->dayname, $employee->employee_no, $employee->personname, $movement];
                @endphp
                @for ($k = 0; $k < count($arrRows); $k++)
                    @if (!in_array($k, json_decode($columnHideShowData)))
                        <td>{{ $arrRows[$k] }}</td>
                    @endif
                @endfor
            </tr>
        @endforeach
    </tbody>
</table>
