{{View::make('layout.header')}}

<style>
    .table thead th,
    .table tbody td {
        padding: 5px 2px !important;
        text-align: center !important;
    }

    table.dataTable thead .sorting:before,
    table.dataTable thead .sorting_asc:before,
    table.dataTable thead .sorting_desc:before,
    table.dataTable thead .sorting:after,
    table.dataTable thead .sorting_asc:after,
    table.dataTable thead .sorting_desc:after {
        display: none;
    }

    .anyClass {
        height: 200px;
        overflow-y: scroll;
        border: 1px solid lightgray;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active"><a href="{{route('settings')}}">Settings</a>
                                </li>
                                <li class="breadcrumb-item active"><a href="{{route('softwaresettings')}}">Software
                                        Settings</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            @if(session()->has('message'))
            <div class="alert alert-success">
                {{ session()->get('message') }}
            </div>
            @endif
            @if(session()->has('danger'))
            <div class="alert alert-danger">
                {{ session()->get('danger') }}
            </div>
            @endif

        </div>

        <div class="content-body">
            <section id="dashboard-ecommerce">

                <div class="row match-height">
                    <div class="col-md-12 ">

                        <div class="card">


                        <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">    Software Settings
                                                </div>
                                            </div>

                            <div class="card-body">

                                <form>
                                    @csrf

                                    <label for="">Software Start Date :* </label><br />
                                    <textarea name="software_start_year" id="software_start_year" class="form-control"
                                        style="height:80px; width:100%;">{{$software_start_year->value}}</textarea>
                                    <span class="text-danger error-text software_start_year_err"></span>
                                    <br />
                                    <label for="">Skip EClaim Finance :&nbsp;</label>
                                    <input id="skip_eclaim_finance" type="checkbox" name="skip_eclaim_finance"
                                        value="{{$skip_eclaim_finance->value}}" {{ $skip_eclaim_finance->value==1 ?
                                    'checked' : '' }} >
                                    <br />
                                    <div class="custom-control custom-control-success custom-switch">
                                        <label for="">OTP :&nbsp;</label>
                                        <input type="checkbox" class="custom-control-input" id="otp" {{ ($otp->value?? 0)==1 ?
                                    'checked' : '' }} />
                                        <label class="custom-control-label" for="otp"></label>
                                    </div>

                                    <div id="message3"></div><br />
                                    <button type="submit" class="btn btn-info software-submit">Apply</button>
                                </form>

                            </div>
                        </div>

                    </div>


                </div>


        </div>
    </div>
    </section>
    </section>
</div>
</div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $(".software-submit").click(function (e) {
            e.preventDefault();


            var _token = $("input[name='_token']").val();
            var software_start_year = $("#software_start_year").val();
            if ($("#skip_eclaim_finance").prop('checked')) {
                _val = 1;
            } else {
                _val = 0;
            }

            if ($("#otp").prop('checked')) {
                _otp = 1;
            } else {
                _otp = 0;
            }

            $.ajax({
                url: "{{ route('updatesoftwaresettings')}} ",

                type: 'POST',
                data: { _token: _token, software_start_year: software_start_year, _val: _val, _otp: _otp },
                success: function (data) {

                    if ($.isEmptyObject(data.error)) {
                        showMessage3("Details Added Successfully ");
                    }
                    else {
                        printErrorMsg(data.error);
                    }

                }
            });
        });
        function showMessage3(message) {
            $("#message3").html("<span style='color:green;'>" + message + "</span>");
        }
        function printErrorMsg(msg) {
            $.each(msg, function (key, value) {
                console.log(key);
                $('.' + key + '_err').text(value);
            });
        }

    });
</script>
<!-- END: Content-->
{{View::make('layout.footer')}}