{{View::make('layout.header')}}

<style>
    .table thead th,
    .table tbody td {
        padding: 5px 2px !important;
        text-align: center !important;
    }

    table.dataTable thead .sorting:before,
    table.dataTable thead .sorting_asc:before,
    table.dataTable thead .sorting_desc:before,
    table.dataTable thead .sorting:after,
    table.dataTable thead .sorting_asc:after,
    table.dataTable thead .sorting_desc:after {
        display: none;
    }

    .anyClass {
        height: 200px;
        overflow-y: scroll;
        border: 1px solid lightgray;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active"><a href="{{route('settings')}}">Settings</a>
                                </li>
                                <li class="breadcrumb-item active"><a href="{{route('companylogo')}}">UBS Payroll Path</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            @if(session()->has('message'))
            <div class="alert alert-success">
                {{ session()->get('message') }}
            </div>
            @endif
            @if(session()->has('danger'))
            <div class="alert alert-danger">
                {{ session()->get('danger') }}
            </div>
            @endif

        </div>

        <div class="content-body">
            <section id="dashboard-ecommerce">

                <div class="row match-height">
                    <div class="col-md-12 ">
                        <div class="card">


                            <div class="card-header">
                                <div class="d-flex align-items-center">
                                    <h4 class="card-title"> UBS Payroll Path
                                </div>
                                @if (\Session::has('statusMsg'))
                                <div class="alert alert-success alert-dismissible" style="padding:15px;">
                                    
                                    <strong>Success!</strong> {{ Session::get('statusMsg') }}
                                </div>
                                
                                @endif
                            </div>

                            <div class="card-body">
                            
                                <form id="upload-image-form" action="{{ route('importDBFFile') }}" class="submit" enctype="multipart/form-data" method="POST">

                                    
                                    @csrf
                                    <div class="row">

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="">Year </label>
                                                <select name="epay_year" id="epay_year" class="form-control"
                                                    value="">
                                                    {{ $now = date('Y') }}
                                                    {{ $start = $software_start_year->value }}

                                                    @for ($i =$start; $i <= $now ; $i++) <option {{ ($i == $now) ?
                                                        'selected' : '' }} value="{{ $i }}">{{ $i
                                                        }}</option>
                                                        @endfor


                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="">Month
                                                </label>
                                                <select name="epay_month" id="epay_month" class="form-control"
                                                    value="">
                                                    {{ $now = date('m') }}


                                                    
                                                    @for($i=1; $i<=12;$i++) 
                                                    <option value="{{$i}}" {{ ($i == $now) ?
                                                        'selected' : '' }}>{{$i}}</option>

                                                        @endfor
                                                </select>
                                                <span class="text-danger error-text epayslip_logo_err"></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="">Browse Path
                                                </label>
                                                <input id="ubs" type="file" name="fileupload[]" class="form-control" multiple>
                                                <span class="text-danger error-text epayslip_logo_err"></span>
                                            </div>
                                        </div>



                                    </div>
                                    <div id="message3" class="my-1"></div>

                                    <div id="img" class="mb-1"></div>
                                    <button type="submit" class="btn btn-info ">Apply</button>
                                </form>



                            </div>
                        </div>

                    </div>


                </div>
        </div>
    </div>
    </section>
</div>
</div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script type="text/javascript">



</script>
<!-- END: Content-->
{{View::make('layout.footer')}}
@include('inc.updateleave-modal')
