<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, UserPay, Branch, Department, Category};
use Auth , DateTime;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Carbon\CarbonInterval;
use Carbon\CarbonPeriod;

class Eleavecontroller extends Controller
{
    public function dashboard(){
        $user = User::where('id' , Auth::id())->first();
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $months = [];
		$pendingLeaves = [];
		$approvedLeave = [];
		$type = request()->get('type') ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			$pending = LeaveList::where('username', $user->username)->whereIn('status', ['0', '5'])->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			$approved = LeaveList::where('username', $user->username)->where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			array_push($pendingLeaves, $pending);
			array_push($approvedLeave, $approved);
		}
		$pendingLeave = Leavelist::where('status', '0')->where('type', 'Annual')->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('start_date', '<=', $endOfYear->format('Y-m-d'))->count();
		$start = Carbon::now()->startOfMonth();
        $end = $start->copy()->endOfMonth();
        $now = Carbon::now();
        $interval = CarbonPeriod::create($start, $end);

    	$user = User::where('id' , Auth::id())->first();
    	$leavetypes = Leavetype::orderBy('name')->get();
    	$relieves = Relieve::orderBy('name')->get();
		$today = \Carbon\Carbon::now();
    	$leaves = Leavelist::where('start_date', date('Y-m-d'))->get();
		$leaves->transform(function($item) {
            $pay = UserPay::where('username', $item->username)->first();
			$branch = Branch::find($pay->branch_id);
			$department = Department::find($pay->department_id);
			$category = Category::find($pay->category_id);
			$item->branch = $branch->name;
			$item->department = $department->name;
			$item->category = $category->name;
			if($item->is_half_day == 0)
			{
				$item->leave_type = "Full Day";
			}
			else
			{
				$item->leave_type = "Half Day";
			}
			return $item;
		});
		$history = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Annual')->first();
		$medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Medical')->first();
		$repHistory = DB::table('leave_list')->where('username', $user->username)
					->where('type', 'Other_pay')->where('status', 1)->count();
		$totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');
		$recentHoliday = DB::table('public_holiday')->orderBy('date')->where('company_id', $user->company_id)
					->where('date', '>' , date('Y-m-d'))->get()->take(6);
		$leavesArray = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username)->whereBetween('start_date', [$startOfYear,$endOfYear])->get();
		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
		$restDay->transform( function($item) {
			$item->month = date("F", strtotime($item->date));
			$item->day = date("j", strtotime($item->date));
			return [

				'status' => '#FFC0CB',
				'date' => $item->date,
				'month' => $item->month,
				'day' => $item->day,
			];
		})->toArray();
        $leavesArray = $leavesArray->transform(function($item) {
			$item->month = date("F", strtotime($item->start_date));
			$item->day = date("j", strtotime($item->start_date));
			if($item->status == '1' && $item->type != 'Medical')
			{
				$color = "#28c76f";
			}
			if($item->status == '0' && $item->type != 'Medical')
			{
				$color = "#ff9f43";
			}

			if($item->status != '0' && $item->status != '1' && $item->type != 'Medical')
			{
				$color = "#1589FF";
			}

			if($item->type == 'Medical')
			{
				$color = "#ec1818";
			}
			return [
				'status' => $color,
				'date' => $item->start_date,
				'month' => $item->month,
				'day' => $item->day,
			];
		});
		$arrayOne = [];
		$arrayTwo = [];
		$arrayThree = [];
		$arrayFour = [];
		$arrayFive = [];
		$arraySix = [];
		$arraySeven = [];
		$arrayEight = [];
		$arrayNine = [];
		$arrayTen = [];
		$arrayEleven = [];
		$arrayTweal = [];
		$allLeaves = $leavesArray->union($restDay);

		foreach($allLeaves as $leaveVal)
		{
			if($leaveVal['month'] == "January")
			{
				$arrayOne[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "February")
			{
				$arrayTwo[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "March")
			{
				$arrayThree[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "April")
			{
				$arrayFour[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "May")
			{
				$arrayFive[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "June")
			{
				$arraySix[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "July")
			{
				$arraySeven[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "August")
			{
				$arrayEight[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "September")
			{
				$arrayNine[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "October")
			{
				$arrayTweal[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "November")
			{
				$arrayTen[$leaveVal['day']] = $leaveVal['status'];
			}

			if($leaveVal['month'] == "December")
			{
				$arrayTweal[$leaveVal['day']] = $leaveVal['status'];
			}


		}
		for($i=1; $i <=31 ; $i++)
		{
			if(!isset($arrayOne[$i]))
			{
				$arrayOne[$i] = '#F8F9F9';
			}
			if(!isset($arrayTwo[$i]))
			{
				$arrayTwo[$i] = '#F8F9F9';
			}
			if(!isset($arrayThree[$i]))
			{
				$arrayThree[$i] = '#F8F9F9';
			}
			if(!isset($arrayFour[$i]))
			{
				$arrayFour[$i] = '#F8F9F9';
			}
			if(!isset($arrayFive[$i]))
			{
				$arrayFive[$i] = '#F8F9F9';
			}
			if(!isset($arraySix[$i]))
			{
				$arraySix[$i] = '#F8F9F9';
			}
			if(!isset($arraySeven[$i]))
			{
				$arraySeven[$i] = '#F8F9F9';
			}
			if(!isset($arrayEight[$i]))
			{
				$arrayEight[$i] = '#F8F9F9';
			}
			if(!isset($arrayNine[$i]))
			{
				$arrayNine[$i] = '#F8F9F9';
			}
			if(!isset($arrayTen[$i]))
			{
				$arrayTen[$i] = '#F8F9F9';
			}
			if(!isset($arrayEleven[$i]))
			{
				$arrayEleven[$i] = '#F8F9F9';
			}
			if(!isset($arrayTweal[$i]))
			{
				$arrayTweal[$i] = '#F8F9F9';
			}
		}
		ksort($arrayOne);
		ksort($arrayTwo);
		ksort($arrayThree);
		ksort($arrayFour);
		ksort($arrayFive);
		ksort($arraySix);
		ksort($arraySeven);
		ksort($arrayEight);
		ksort($arrayNine);
		ksort($arrayTen);
		ksort($arrayEleven);
		ksort($arrayTweal);

    	return view('E-Leave/dashboard' , ['leavetypes'=>$leavetypes , 'relieves'=>$relieves ,
		'leaves'=>$leaves, 'history' => $history, 'recentHoliday' => $recentHoliday,
		'months' => json_encode($months,JSON_NUMERIC_CHECK),
		'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
		'approvedLeave' => json_encode($approvedLeave,JSON_NUMERIC_CHECK),
		'start' => $start, 'interval' =>  $interval, 'monthArray' => $months,
		'arrayOne' => $arrayOne, 'arrayTwo' => $arrayTwo, 'arrayThree' => $arrayThree, 'arrayFour' => $arrayFour,
		'arrayFive' => $arrayFive, 'arraySix' => $arraySix, 'arraySeven' => $arraySeven, 'arrayEight' => $arrayEight,
		'arrayNine' => $arrayNine, 'arrayTen' => $arrayTen, 'arrayEleven' => $arrayEleven, 'arrayTweal' => $arrayTweal,
		'pendingLeave' => $pendingLeave, 'medHistory' => $medHistory, 'repHistory' => $repHistory, 'totalReplacement' =>$totalReplacement
		]);
    }
    
    function filteruser(Request $request){
		$branch=$request->get('branch');
		$department=$request->get('department');
		$category=$request->get('category');
		$user = UserPay::leftJoin('user_personal', 'user_pay.username', '=', 'user_personal.username')->orderBy('user_personal.name' , 'asc');
        
		if($branch && $branch != '')
		{
			$user->where('user_pay.branch_id', $branch);
		}

		if($department && $department != '')
		{
			$user->where('user_pay.department_id', $department);
		}

		if($category && $category != '')
		{
			$user->where('user_pay.category_id', $category);
		}
		$users = $user->get();
		
		return $users;
	}

	function filtercountry(Request $request){
		$user = User::where('id' , Auth::id())->first();
		$country=$request->get('country');
		$states=DB::table('states')->where('company_id',$user->company_id)->where('is_deleted',0);
        if($country && $country != '')
		{
			$states->where('country', $country);
		}
		$states = $states->get();
		return $states;
	}
	

    function ApplyForLeave(Request $request){
    	$request->validate([
    		"leave_type"=>"required",
    		"hof"=>"required",
    		"leave_start_date"=>"required|date",
    		"leave_end_date"=>"nullable|date",
    		"reason"=>"nullable",
    		"relieve"=>"required"
    	]);
    	$ishalfday = 0;
    	if($request->hof=='h'){
    		$ishalfday = 1;
    	}
    	$user = User::where('id' , $request->user_id)->first();
    	$leave_start_date = new DateTime($request->leave_start_date);
    	$leave_end_date = new DateTime($request->leave_end_date);


    if(!empty($request->leave_end_date)){
    		$no_days = $leave_start_date->diff($leave_end_date);
    		$no_days = $no_days->format('%a');
    	}


    	$leave = Leavelist::create([
    		"username"=>$user->username,
    		"type"=>$request->leave_type,
    		"is_half_day"=>$ishalfday,
    		"start_date"=>$request->leave_start_date,
    		"end_date"=>$request->leave_end_date ?? $request->leave_start_date,
    		"no_days"=> $no_days ?? 0.5,
    		"half_day_type"=>'',
    		"reason"=>$request->reason,
    		"date_applied"=>now(),
    		"relieve"=>$request->relieve,

    	]);
    	if($leave){
    		return redirect()->route('employee-dashboard')->with('message','Applied successfully.');
    	}else{
    		return redirect()->route('employee-dashboard')->with('danger','Something went wrong');
    	}

    }


	private function  carbon()
	{
		return new \Carbon\Carbon();
	}


	public function getChartData(Request $request)
	{
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $months = [];
		$pendingLeaves = [];
		$approvedLeave = [];
		$type = $request->type ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			$pending = LeaveList::where('status', '0')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			$approved = LeaveList::where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			array_push($pendingLeaves, $pending);
			array_push($approvedLeave, $approved);
		}

		return [
            'months' => json_encode($months,JSON_NUMERIC_CHECK),
			'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
			'approvedLeave' => json_encode($approvedLeave,JSON_NUMERIC_CHECK),
		];
	}

	public function getTimeline($id)
	{
		$leave = LeaveList::find($id);
		$leaveDay = LeaveDay::where('leave_id', $id)->first();
		$status = '';
        if($leave->status == 0)
		{
			$status = 'Pending';
			$reason = $leave->reason;
		}
		if($leave->status == 1)
		{
			$status = 'Approved';
			$reason = $leave->reason;
            $approver_id = $leave->approver_id;
		}
		if($leave->status == 2)
		{
			$status = 'Rejected';
			$reason = isset($leaveDay) && isset($leaveDay->reject_reason) ? '( Reason : '.$leaveDay->reject_reason. ')' : '';
		}
		if($leave->status == 3)
		{
			$status = 'Recommended';
			$reason = '';
		}
		if($leave->status == 4)
		{
			$status = 'Cancelled';
			$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? '( Reason : '.$leaveDay->cancellation_reason. ')' : '';
		}
		if($leave->status == 5)
		{
			$status = 'Cancellation Pending';
			$reason = isset($leaveDay) && isset($leaveDay->cancellation_reason) ? '( Reason : '.$leaveDay->cancellation_reason. ')' : '';
		}
		return [
			'Created' => date('d-m-Y h:i', strtotime($leave->date_applied)),
			'Pending' => '',
            $status    => $status != '' ? (isset($leave->date_approved) ? date('d-m-Y h:i', strtotime($leave->date_approved)). ''.$reason.''.$approver_id : $reason ) : ''.$reason,

		];
	}

	public function filterGraph(Request $request)
	{
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
        $Dateinterval = \DateInterval::createFromDateString('1 month');
        $monthRange   = new \DatePeriod($startOfYear, $Dateinterval, $endOfYear);
        $months = [];
		$pendingLeaves = [];
		$approvedLeave = [];
		$type = $request->leave_type ?? 'Annual';
		foreach ($monthRange as $month) {
            $m = $month->copy()->format('M');
			array_push($months, $m);
			$startDate = $month->copy()->startOfMonth();
            $endDate = $month->copy()->endOfMonth();

			$pending = LeaveList::where('status', '0')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			$approved = LeaveList::where('status', '1')->where('type', $type)->where('start_date', '>=', $startDate->format('Y-m-d'))->where('start_date', '<=', $endDate->format('Y-m-d'))->count();
			array_push($pendingLeaves, $pending);
			array_push($approvedLeave, $approved);
		}
		return ['months' => $months,
		'pendingLeaves' => json_encode($pendingLeaves,JSON_NUMERIC_CHECK),
		'approvedLeave' => json_encode($approvedLeave,JSON_NUMERIC_CHECK),
	];
	}
}
