<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Response;
use App\Models\{User , Leavetype, Relieve , Leavelist, LeaveDay, Branch, Department, Category, LeaveEntitleHistory, UserPay};
use Auth , DateTime;
use Illuminate\Support\Facades\Storage;

class MyLeaveController extends Controller
{
	protected $storageDriver;

    public function __construct()
    {
      $this->storageDriver = env('DOCUMENT_STORAGE', 'local');
    }
    public function index(Request $request)
    {
        $user = User::where('id' , Auth::id())->first();
        $leaveTypes  = Leavetype::all();
        $relieves = Relieve::orderBy('name')->get();
		$leaveArray = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username);
		$type = $request->get('type');
		$from = $request->get('from');
		$to = $request->get('to');
        if($type && $type != '')
		{
			$leaveArray->where('type', $type);
		}

		if($from && $from != '')
		{
			$leaveArray->where('start_date', '>=', $from);
		}

		if($to && $to != '')
		{
			$leaveArray->where('end_date', '<=', $to);
		}

    	$leaves = $leaveArray->paginate(10);


        $history = LeaveEntitleHistory::where('username' , $user->username)->where('year', carbon()->year)->get();
		$history->transform(function($item) {
			if($item->leave_type == 'Annual')
			{
				$item->class = 'progress-bar-info';
			}
			if($item->leave_type == 'Medical')
			{
				$item->class = 'progress-bar-danger';
			}
			if($item->leave_type == 'Marriage')
			{
				$item->class = 'progress-bar-warning';
			}
			if($item->leave_type == 'Compassionate')
			{
				$item->class = 'progress-bar-success';
			}
			if($item->leave_type == 'Hospital')
			{
				$item->class = 'progress-bar-primary';
			}
			if($item->leave_type == 'Maternity')
			{
				$item->class = 'progress-bar-secondary';
			}
			if($item->leave_type == 'Examination')
			{
				$item->class = 'progress-bar-dark';
			}

			if($item->leave_type == 'Paternity')
			{
				$item->class = 'progress-bar-info';
			}
			if($item->leave_type == 'Advance')
			{
				$item->class = 'progress-bar-danger';
			}
			if($item->leave_type == 'Other_pay')
			{
				$item->class = 'progress-bar-warning';
			}
			if($item->leave_type == 'Line_Shut')
			{
				$item->class = 'progress-bar-success';
			}
			if($item->leave_type == 'Absent')
			{
				$item->class = 'progress-bar-primary';
			}
			if($item->leave_type == 'Emergency')
			{
				$item->class = 'progress-bar-secondary';
			}
			if($item->leave_type == 'NPL')
			{
				$item->class = 'progress-bar-dark';
			}
			return $item;
		});
		// dd($history);
        return view('E-Leave/my-leaves', compact('leaveTypes', 'relieves', 'leaves', 'history'));
    }

    function apply(Request $request)
    {
    	$this->validate($request,[
    		"leave_type"=>"required",
    		"hof"=>"required",
    		"leave_start_date
			"=>"required|date",
    		"leave_end_date"=>"nullable|date",
    		"reason"=>"nullable",
    		"relieve"=>"required"
    	]);

    	$user = User::where('id' , $request->user_id)->first();
    	$leave_start_date = new DateTime($request->leave_start_date);
    	$leave_end_date = new DateTime($request->leave_end_date);



    	if(!empty($request->leave_end_date)){

    		$no_days = $leave_start_date->diff($leave_end_date);
    		$no_days = $no_days->format('%a');
    	}

		$history = LeaveEntitleHistory::where('username', $user->username)
					->where('year', carbon()->year)->where('leave_type', $request->leave_type)->first();

		if(isset($history))
		{
			if($history->entitle > $no_days + 1)
			{
				$history->leave_taken = (string)$history->leave_taken + (string)$no_days + 1;
				$history->save();
			}

		}

    	$leave = Leavelist::create([
    		"username" => $user->username,
    		"type" => $request->leave_type,
    		"is_half_day" => $request->hof,
    		"start_date" => $request->leave_start_date,
    		"end_date" => $request->leave_end_date ?? $request->leave_start_date,
    		"no_days" => $no_days + 1 ?? 0.5,
    		"half_day_type" => $request->half_day_type ?? '',
    		"reason" => $request->reason,
    		"date_applied" => now(),
    		"relieve" => $request->relieve,

    	]);


		$leaveDay = LeaveDay::create([
    		'leave_id' => $leave->id,
			'username' => $user->username,
			'date' => $request->leave_start_date,
			'cancellation_reason' => '',
			'reject_reason' => ''

    	]);
    	return 1;

    }

	public function getMyLeaves(Request $request)
	{
		$user = User::where('id' , Auth::id())->first();
		$leaveTypes  = Leavetype::all();
    	$leaveArray = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username);
		$relieves = Relieve::orderBy('name')->get();
		$type = $request->get('type');
		$from = $request->get('from');
		$to = $request->get('to');
		$status = $request->get('status');
        if($type && $type != '')
		{
			$leaveArray->where('type', $type);
		}
		if($from && $from != '')
		{
			$leaveArray->where('start_date', '>=', $from);
		}

		if($to && $to != '')
		{
			$leaveArray->where('end_date', '<=', $to);
		}

		if(isset($status) && $status != '')
		{

			$leaveArray->where('status', $status);
		}

    	$leaves = $leaveArray->get();
		if($request->get('get') && $request->get('get') == 'all')
		{
			$leaves = $leaves;
		}
		else
		{
			$leaves =  $this->arrayPaginator($leaves, $request);
		}


		$replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->get();
		$history = LeaveEntitleHistory::where('username' , $user->username)->where('year', carbon()->year)->get();
		$history->transform(function($item) {
			if($item->leave_type == 'Annual')
			{
				$item->class = 'progress-bar-info';
			}
			if($item->leave_type == 'Medical')
			{
				$item->class = 'progress-bar-danger';
			}
			if($item->leave_type == 'Marriage')
			{
				$item->class = 'progress-bar-warning';
			}
			if($item->leave_type == 'Compassionate')
			{
				$item->class = 'progress-bar-success';
			}
			if($item->leave_type == 'Hospital')
			{
				$item->class = 'progress-bar-primary';
			}
			if($item->leave_type == 'Maternity')
			{
				$item->class = 'progress-bar-secondary';
			}
			if($item->leave_type == 'Examination')
			{
				$item->class = 'progress-bar-dark';
			}

			if($item->leave_type == 'Paternity')
			{
				$item->class = 'progress-bar-info';
			}
			if($item->leave_type == 'Advance')
			{
				$item->class = 'progress-bar-danger';
			}
			if($item->leave_type == 'Other_pay')
			{
				$item->class = 'progress-bar-warning';
			}
			if($item->leave_type == 'Line_Shut')
			{
				$item->class = 'progress-bar-success';
			}
			if($item->leave_type == 'Absent')
			{
				$item->class = 'progress-bar-primary';
			}
			if($item->leave_type == 'Emergency')
			{
				$item->class = 'progress-bar-secondary';
			}
			if($item->leave_type == 'NPL')
			{
				$item->class = 'progress-bar-dark';
			}
			return $item;
		});
		$today = \Carbon\Carbon::now();

		$alHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Annual')->first();
		$medHistory = DB::table('leave_entitle_history')->where('username', $user->username)
					->where('year', $today->year)->where('leave_type', 'Medical')->first();
		$repHistory = DB::table('leave_list')->where('username', $user->username)
					->where('type', 'Other_pay')->where('status', 1)->count();
		$totalReplacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->sum('no_granted');

		$cut_off_days = day_count_anniv_cutt_off($user->username, carbon()->year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Other_pay');//rithik
		$mBFAdj = getBroughtForwardLeaveCount($user->username, carbon()->year, 'Medical');
		$rBFAdj = getAdjustmentLeaveCount($user->username, carbon()->year, 1);
		$mbf = getBroughtForwardLeaveNotAdjusted($user->username, carbon()->year, 'Medical');
		$rbf = 0;
		$albf = 0;
		$aEntitle = getEntitleLeave($user->username, carbon()->year, 'Annual');
		$mEntitle = getEntitleLeave($user->username, carbon()->year, 'Medical');
		$rEntitle = '-';
		$aEarn = (date('n') / 12) * $aEntitle;
		$mEarn = '-';
		$rEarn = getTotalReplaceLeave( $user->username , carbon()->year);
		$aClaim = getAnnualClaimable($user->username, carbon()->year, 'Annual');
		$mClaim = (($mEntitle + $mBFAdj) * 2)/2;
		$rlClaim ="-";
		$anunpl = getNPLSummary($user->username, carbon()->year);
		$mcnpl = 0;
		$rpnpl = '-';
		$elTaken = getTakenLeves($user->username, carbon()->year, 'Emergency');
		$alTaken = getTakenLeves($user->username, carbon()->year, 'Annual');
		$mcTaken = getTakenLeves($user->username, carbon()->year, 'Medical');
		$rlTaken = getTakenLeves($user->username, carbon()->year, 'Other_pay');
		$forAlBf = $albf;
		$forAlBfAdj =  $aBFAdj;
		$forMC = $mbf;
		$forRL = $rbf;
		$alBalance = $aEntitle - $alTaken;
		$mcBalance = $mEntitle - $mcTaken;
		$rlBalance = $rEarn - $rlTaken;

		$dataArray = [
			'albf' => $albf, 'forAlBf' => $forAlBf,
			'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
			'rbf' => $rbf, 'forMC' => $forMC,
			'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
			'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
			'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
			'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
			'mEntitle' => $mEntitle,
			'rEntitle' => $rEntitle,
			'aEarn' => $aEarn,
			'mEarn' => $mEarn,
			'rEarn' => $rEarn,
			'aClaim' => $aClaim,
			'mClaim' => $mClaim,
			'rlClaim' => $rlClaim,
			'anunpl' => $anunpl,
			'mcnpl' => $mcnpl,
			'rpnpl' => $rpnpl,
			'elTaken' => $elTaken,
			'alTaken' => $alTaken,
			'mcTaken' => $mcTaken,
			'rlTaken' => $rlTaken,
		];

        return view('E-Leave.self-leave', compact('leaves', 'leaveTypes', 'replacement', 'relieves', 'history',
		'alHistory', 'medHistory', 'repHistory', 'totalReplacement', 'dataArray'
		));
	}

	public function getAllLeaves()
	{
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
		$user = User::where('id' , Auth::id())->first();
        $branches = Branch::where('company_id', $user->company_id)->get();
        $departments = Department::where('company_id', $user->company_id)->get();
        $categories = Category::where('company_id', $user->company_id)->get();
		$leaveTypes  = Leavetype::all();
    	$leavesArray = Leavelist::orderBy('date_applied' , 'DESC')->get();
		$leavesArray->transform(function ($item) {
            $item->background_color = $item->getType->leave_color;
            return [
                'title' => $item->username.'( '.$item->type.')',
				'type' => $item->type,
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'color' =>  $item->background_color,
            ];

        })->toArray();
		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
		$restDay->transform( function($item) {

			return [

				'title' => 'Rest Day',
				'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'color' =>  '#FFC0CB',
			];
		})->toArray();
		$leaves = $restDay->union($leavesArray);
        return view('E-Leave.all-holidays', compact('leaves', 'branches', 'departments', 'categories', 'leaveTypes'));
	}

	public function cancelLeave(Request $request, $id)
	{
		$leave = Leavelist::find($id);
        $day = LeaveDay::where('leave_id', $id)->first();
		$leave->status = "4";
		$leave->date_approved = date('Y-m-d');
		$leave->save();

		$day->status = "4";
		$day->cancellation_reason = $request->reason;
		$day->save();


		return 1;
	}

	public function getEntitle($year=null,$isjson="no"){
        $user = User::where('id' , Auth::id())->first();
        $userPay = UserPay::where('username' , $user->username)->first();
        if($year == null){
			$year = carbon()->year;
        }
		if(getSettingsValue('leave_adjustment_type') == 8){
			$year =
			$joiningDate = getJoinDateStr($user->username);
			$joiningDateArr = explode('-', $joiningDate);
			$joining_month = $joiningDateArr[1];
			$joining_date = $joiningDateArr[2];
			$curr_date = $year . '-' . $joining_month . '-' . $joining_date;
			// if ((isset($_POST["pdf"]))) {
			// } else {
				if (date('Y-m-d') < $curr_date) {
					$year = $year - 1;
				}
			// }
		}

		$replacement = DB::table('leave_adjustment')->where('employee_id', $user->username)->groupBy('start_date');
		$replacement = $replacement->whereRaw("DATE_FORMAT(`start_date`, '%Y') = '".$year."'");
		$replacement = $replacement->get();


		$cut_off_days = day_count_anniv_cutt_off($user->username, $year);
        $aBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
		$mBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Medical');
		$rBFAdj = getBroughtForwardLeaveCount($user->username, $year, 'Other_pay');
		$mbf = getBroughtForwardLeaveNotAdjusted($user->username, $year, 'Medical');
		$rbf = 0;
		$albf = 0;
		$aEntitle = getEntitleLeave($user->username, $year, 'Annual');
		$mEntitle = getEntitleLeave($user->username, $year, 'Medical');
		$rEntitle = '-';
		$aEarn = (date('n') / 12) * $aEntitle;
		$mEarn = '-';
		$rEarn = getTotalReplaceLeave( $user->username , $year);
		$aClaim = getAnnualClaimable($user->username, $year, 'Annual');
		$mClaim = (($mEntitle + $mBFAdj) * 2)/2;
		$rlClaim ="-";
		$anunpl = getNPLSummary($user->username, $year);
		$mcnpl = 0;
		$rpnpl = '-';
		$elTaken = getTakenLeves($user->username, $year, 'Emergency');
		$alTaken = getTakenLeves($user->username, $year, 'Annual');
		$mcTaken = getTakenLeves($user->username, $year, 'Medical');
		$rlTaken = getTakenLeves($user->username, $year, 'Other_pay');
		$forAlBf = $albf;
		$forAlBfAdj =  $aBFAdj;
		$forMC = $mbf;
		$forRL = $rbf;
		$alBalance = $aEntitle - $alTaken;
		$mcBalance = $mEntitle - $mcTaken;
		$rlBalance = $rEarn - $rlTaken;

		$dataArray = [
			'albf' => $albf, 'forAlBf' => $forAlBf,
			'mbf' => $mbf, 'forAlBfAdj' => $forAlBfAdj,
			'rbf' => $rbf, 'forMC' => $forMC,
			'aBFAdj' => $aBFAdj, 'forRL' => $forRL,
			'mBFAdj' => $mBFAdj, 'alBalance' => $alBalance,
			'rBFAdj' => $rBFAdj, 'mcBalance' => $mcBalance,
			'aEntitle' => $aEntitle, 'rlBalance' => $rlBalance,
			'mEntitle' => $mEntitle,
			'rEntitle' => $rEntitle,
			'aEarn' => $aEarn,
			'mEarn' => $mEarn,
			'rEarn' => $rEarn,
			'aClaim' => $aClaim,
			'mClaim' => $mClaim,
			'rlClaim' => $rlClaim,
			'anunpl' => $anunpl,
			'mcnpl' => $mcnpl,
			'rpnpl' => $rpnpl,
			'elTaken' => $elTaken,
			'alTaken' => $alTaken,
			'mcTaken' => $mcTaken,
			'rlTaken' => $rlTaken,
		];

		$alsStartDate = ((isset($_POST["datefrom"]) && $_POST["datefrom"] != "") ? date('Y-m-d', strtotime($_POST["datefrom"])) : "");
		$alsEndDate = ((isset($_POST["dateto"]) && $_POST["dateto"] != "") ? date('Y-m-d', strtotime($_POST["dateto"])) : "");
		$username = $user->username;

		// $dataArrayAls["alsAnnualLeave"] = getTakenLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Annual", $alsStartDate, $alsEndDate);

		// $dataArrayAls["alsMedicalLeave"] = getTakenLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Medical", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsMaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Maternity", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsMarriageLeave"] = getTakenLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Marriage", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsCompassionateLeave"] = getTakenLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Compassionate", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsHospitalLeave"] = getTakenLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Hospital", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsExaminationLeave"] = getTakenLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Examination", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsPaternityLeave"] = getTakenLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Paternity", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsAdvance"] = getTakenLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Advance", $alsStartDate, $alsEndDate);

		// $dataArrayAls["alsReplacementLeave"] = getTakenLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Other_pay", $alsStartDate, $alsEndDate);

		$dataArrayAls["alsLine_ShutLeave"] = getTakenLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Line_Shut", $alsStartDate, $alsEndDate);
		$dataArrayAls["alsAbsentLeave"] = getTakenLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "Absent", $alsStartDate, $alsEndDate);

		// $dataArrayAls["alsNPLeave"] = getTakenLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate) + getPastLeaveCountDateBy($username, $year, "NPL", $alsStartDate, $alsEndDate);
		$myLeaveSumm = json_decode(myLeaveSummary($username,$year),true);
		$myLeaveSummSm = json_decode(myLeaveSummary($username,$year,"getYearlyrlEntitleList"),true);
		$myLeaveSummSm = $myLeaveSummSm['users'][0];
		if($isjson == "no"){
			return view('E-Leave.entitle', compact('user','username','userPay','replacement', 'dataArray','dataArrayAls','myLeaveSumm','myLeaveSummSm'));
		}else{
			$dataa['data'] = html_entity_decode(view('E-Leave.partials.entilted', compact('user','username','userPay','replacement', 'dataArray','dataArrayAls','myLeaveSumm','myLeaveSummSm')));
			return Response::json($dataa, 200);
		}

	}


	public function leaveFilter(Request $request)
	{
		$user = User::where('id' , Auth::id())->first();
    	$leaveArray = Leavelist::orderBy('date_applied' , 'DESC')->where('username' , $user->username);
		$type = $request->get('type');
		$from = $request->get('from');
		$to = $request->get('to');
        if($type && $type != '')
		{
			$leaveArray->where('type', $type);
		}

		if($from && $from != '')
		{
			$leaveArray->where('start_date', '>=', $from);
		}

		if($to && $to != '')
		{
			$leaveArray->where('end_date', '<=', $to);
		}

    	$leaves = $leaveArray->paginate(10);
		return view('E-Leave.inc.self-filter', compact('leaves'))->render();
	}

	public function holidayFilter(Request $request)
	{
    	$leaveArray = Leavelist::orderBy('date_applied' , 'DESC');
		$startOfYear = carbon()->setDate(carbon()->year, 1, 1)->startOfMonth();
        $endOfYear =  carbon()->setDate(carbon()->year, 1, 1)->addMonth(11)->endOfMonth();
		$type = $request->type;
        if($type && $type != '')
		{
			$leaveArray->where('type', $type);
		}

		if($request->name && $request->name != '')
		{
			$leaveArray->where('username', 'like', '%'. $request->name .'%');
		}

		if($request->branch && $request->branch != '')
		{
			$branchId = UserPay::where('branch_id', $request->branch)->pluck('username')->toArray();
			$leaveArray->whereIn('username',$branchId);
		}

		if($request->department && $request->department != '')
		{
			$branchId = UserPay::where('department_id', $request->department)->pluck('username')->toArray();
			$leaveArray->whereIn('username',$branchId);
		}

		if($request->category && $request->category != '')
		{
			$branchId = UserPay::where('category_id', $request->category)->pluck('username')->toArray();
			$leaveArray->whereIn('username',$branchId);
		}

		$Array = $leaveArray->get();
		$Array->transform(function ($item) {
            $item->background_color = $item->getType->leave_color;
            return [
                'title' => $item->username.'(  '.$item->type.')',
				'type' => $item->type,
                'start' => date('Y-m-d', strtotime($item->start_date)),
                'color' =>  $item->background_color,
            ];

        })->toArray();

		$restDay = DB::table('rest_days')->join('rest_dates', 'rest_days.id', '=', 'rest_dates.rest_day_id')->where('rest_dates.date', '>=', $startOfYear->format('Y-m-d'))->where('rest_dates.date', '<=', $endOfYear->format('Y-m-d'))->get();
		$restDay->transform( function($item) {

			return [

				'title' => 'Rest Day',
				'type' => '',
                'start' => date('Y-m-d', strtotime($item->date)),
                'color' =>  '#FFC0CB',
			];
		})->toArray();
		$leaves = $Array->union($restDay);
		return $leaves;
	}

	public function arrayPaginator($array, $request)
	 {
	    $page = $request->get('page') ??  1;
	    $perPage = 9;
	    $offset = ($page * $perPage) - $perPage;
        $department = array_slice($array->toArray(), $offset, $perPage);
        $departments = new LengthAwarePaginator($department, count($array), $perPage, $page, [
            'path' => $request->url(),
            'query' => $request->query()
        ]);
	    return $departments;
	}

	public function viewDocs($id)
    {
		$leave = Leavelist::find($id);

        $file_path = 'public/upload/'.$leave->filename;
        $fileContent = Storage::disk($this->storageDriver)->get($file_path);
        $fileName = basename($file_path);
        return response($fileContent)->header('Content-Type',  '');
    }
    public function remainingDays(Request $request)
    {
        $data = getLeavsCounts(Auth::user()->username,$request->type,$request->start_date,$request->end_date,$request->is_half_day,$request->action);
            // dd($data);
        return Response::json(json_decode($data), 200);

    }

}
