    {{View::make('layout.header')}}
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Dashboard</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                @if(session()->has('message'))
                <div class="alert alert-success">
                {{ session()->get('message') }}
                </div>
                @endif
                @if(session()->has('danger'))
                <div class="alert alert-danger">
                {{ session()->get('danger') }}
                </div>
                @endif

            </div>
            <div class="content-body">
                <section id="dashboard-ecommerce">
                    <div class="row match-height">

                        <!-- Statistics Card -->
                        <div class="col-xl-8 col-md-6 col-12">
                            <div class="card card-statistics" style="flex: 0;">
                                <div class="card-header">
                                    <h4 class="card-title">My Annual Leaves</h4>
                                </div>
                                <div class="card-body statistics-body">
                                    <div class="row">
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-primary mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="thumbs-up" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ isset($history) ? $history->entitle : 0 }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Claimable</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-info mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ isset($history) ? $history->entitle - $history->leave_taken: 0 }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Balance</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                            <div class="media">
                                                <div class="avatar bg-light-danger mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ isset($history) ? $history->leave_taken: 0 }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Taken</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                            <div class="media">
                                                <div class="avatar bg-light-warning mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">{{ $pendingLeave }}</h4>
                                                    <p class="card-text font-small-3 mb-0">Pending</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card card-statistics" style="flex: 0;">
                                <div class="card-header">
                                    <h4 class="card-title">My Leaves</h4>
                                    <form id="filter-form">
                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                            <div class="d-flex align-items-center">
                                                @csrf
                                                <select class="form-control" id="start_year"  name="year">
                                                    <?php for($x=2021;$x<=date('Y',time());$x++){
                                                    ?>
                                                    <option value="<?php echo $x; ?>"><?php echo $x; ?></option>
                                                    <?php } ?>
                                                </select>
                                                &nbsp;&nbsp;
                                                <select class="form-control select2" id="leave-type-select" name="leave_type">
                                                    <option value="Annual"  {{request()->get('type') && request()->get('type') == 'Annual' ? 'selected' : '' }}>Annual</option>
                                                    <option value="Absent" {{request()->get('type') && request()->get('type') == 'Absent' ? 'selected' : '' }}>Absent</option>
                                                    <option value="Advance" {{request()->get('type') && request()->get('type') == 'Advance' ? 'selected' : '' }}>Advance</option>                                         
                                                    <option value="Compassionate" {{request()->get('type') && request()->get('type') == 'Compassionate' ? 'selected' : '' }}>Compassionate</option>
                                                    <option value="Emergency" {{request()->get('type') && request()->get('type') == 'Emergency' ? 'selected' : '' }}>Emergency</option>
                                                    <option value="Examination" {{request()->get('type') && request()->get('type') == 'Examination' ? 'selected' : '' }}>Examination</option>
                                                    <option value="Hospital" {{request()->get('type') && request()->get('type') == 'Hospital' ? 'selected' : '' }}>Hospital</option>
                                                    <option value="Marriage" {{request()->get('type') && request()->get('type') == 'Marriage' ? 'selected' : '' }}>Marriage</option>
                                                    <option value="Maternity"{{request()->get('type') && request()->get('type') == 'Maternity' ? 'selected' : '' }}>Maternity</option>
                                                    <option value="Medical" {{request()->get('type') && request()->get('type') == 'Medical' ? 'selected' : '' }}>Medical</option>
                                                    <option value="NPL" {{request()->get('type') && request()->get('type') == 'NPL' ? 'selected' : '' }}>NPL</option>
                                                    <option value="Line_Shut" {{request()->get('type') && request()->get('type') == 'Line_Shut' ? 'selected' : '' }}>Out Of Office</option>
                                                    <option value="Paternity" {{request()->get('type') && request()->get('type') == 'Paternity' ? 'selected' : '' }}>Paternity</option>
                                                    <option value="Other_pay" {{request()->get('type') && request()->get('type') == 'Other_pay' ? 'selected' : '' }}>Replacement</option>
                                                </select>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body statistics-body">
                                    <div class="row">
                                        <canvas id="canvas" height="280" width="600"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">

                                        <h4 class="card-title"> Upcoming Holidays</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="timeline ml-50">
                                        @foreach($recentHoliday as $recent)
                                            <li class="timeline-item">
                                                <span class="timeline-point timeline-point-indicator"></span>
                                                <div class="timeline-event">
                                                    <h6>{{ date('d-m-Y', strtotime($recent->date)) }}</h6>
                                                    <p>{{ $recent->description }}</p>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                    <center><a href="{{ url('/e-leave/all-holidays') }}" class="btn btn-primary btn-block"> View All Holidays</a></center>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row match-height">
                        <div class="col-xl-8 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <h4 class="card-title mb-50 mb-sm-0"> Employees On Leave Today</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table" style="font-size:11px">
                                            <thead>
                                                <tr>
                                                    <th style="text-transform: capitalize;">Name</th>
                                                    <th style="text-transform: capitalize;">Branch</th>
                                                    <th style="text-transform: capitalize;">Department</th>
                                                    <th style="text-transform: capitalize;">Leave Type</th>
                                                    <th style="text-transform: capitalize;">Category</th>
                                                    <th style="text-transform: capitalize;">Type</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($leaves as $leave)
                                                <tr>
                                                    <td>{{$leave->username}}</td>
                                                    <td>{{$leave->branch}}</td>
                                                    <td>{{$leave->department}}</td>
                                                    <td>{{$leave->leave_type}}</td>
                                                    <td>{{$leave->category}}</td>
                                                    <td>{{$leave->type}}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <!-- <center> <a href="{{ url('/e-leave/self-leaves') }}" class="btn btn-primary">View All</a> </center> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">

                                        <h4 class="card-title"> Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">AL</p>
                                                </div>
                                                <?php
                                                    $percentage = (isset($history) ? ($history->entitle - $history->leave_taken) : 0 )  / (isset($history) ? $history->entitle : 0) *100 ;
                                                ?>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ isset($history) ? ($history->entitle - $history->leave_taken) : 0 }}/{{ isset($history) ? $history->entitle : 0 }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-info" style="height: 6px" style="background-color:#6a7e80;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="{{ $percentage }}" aria-valuemin="{{ $percentage }}" aria-valuemax="{{ $percentage }}" style="width: {{ $percentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <?php
                                                    $mePercentage = (isset($medHistory) ? ($medHistory->entitle - $medHistory->leave_taken) : 0 )  / (isset($medHistory) ? $medHistory->entitle : 1) *100 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">MC</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ isset($medHistory) ? ($medHistory->entitle - $medHistory->leave_taken) : 0 }}/{{ isset($medHistory) ? $medHistory->entitle : 1 }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-danger" style="height: 6px"  style="background-color:#ec1818;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: {{ $mePercentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <?php
                                                    $rPercentage = $totalReplacement != 0 ? ($totalReplacement - $repHistory) / $totalReplacement *100 : 0 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">RL</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{$totalReplacement - $repHistory}}/{{$totalReplacement}} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px"   style="background-color:#4298a1;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="0" style="width: {{$rPercentage}}%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="card card-revenue-budget">
                                <div class="row mx-0">
                                    <div class="col-md-12 col-12 revenue-report-wrapper">
                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                            <table class="table-responsive"  id="attendance-table">
                                                <thead>
                                                <tr>
                                                    <th style="text-align: center;font-size: 18px; color: white;"></th>
                                                    @for ($i=1; $i < 32 ; $i++)
                                                        <th style="width:40px;">{{ $i }}</th>
                                                    @endfor
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr style="line-height:30px;">
                                                    <td>Jan</td>
                                                    @foreach($arrayOne as $janKey => $january)
                                                        <td style="background-color:{{$january}};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Feb</td>
                                                    @foreach($arrayTwo as  $febKey => $february)
                                                        <td style="background-color:{{ $february }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Mar</td>
                                                    @foreach($arrayThree as  $marKey => $march)
                                                        <td style="background-color:{{ $march }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Apr</td>
                                                    @foreach($arrayFour as $aprKey => $april)
                                                        <td style="background-color:{{ $april }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>May</td>
                                                    @foreach($arrayFive as $mayKey => $may)
                                                        <td style="background-color:{{ $may }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Jun</td>
                                                    @foreach($arraySix as $junKey => $june)
                                                        <td style="background-color:{{ $june }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Jul</td>
                                                    @foreach($arraySeven as $julKey => $july)
                                                        <td style="background-color:{{ $july }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Aug</td>
                                                    @foreach($arrayEight as $augKey => $august)
                                                        <td style="background-color:{{ $august }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Sep</td>
                                                    @foreach($arrayNine as $sepKey => $september)
                                                        <td style="background-color:{{ $september }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Oct</td>
                                                    @foreach($arrayTen as $octKey => $october)
                                                        <td style="background-color:{{ $october }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Nov</td>
                                                    @foreach($arrayEleven as $novKey => $november)
                                                        <td style="background-color:{{ $november }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                <tr style="line-height:30px;">
                                                    <td>Dec</td>
                                                    @foreach($arrayTweal as $decKey => $december)
                                                        <td style="background-color:{{ $december }};border-radius: 10px;width:40px;"></td>
                                                    @endforeach
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                        <table>
                                            <tfoot>
                                                <tr>
                                                    <td style="background-color:#28c76f;border-radius: 10px;width:30px;"><td>
                                                    <td colspan="4">Approved<td>
                                                    <td style="background-color:#ff9f43;border-radius: 10px;width:30px;"><td>
                                                    <td colspan="4">Pending<td>
                                                    <td style="background-color:#1589FF;border-radius: 10px;width:30px;"><td>
                                                    <td colspan="4">Other<td>
                                                    <td style="background-color:#ec1818;border-radius: 10px;width:30px;"><td>
                                                    <td colspan="4">MC<td>
                                                    <td style="background-color:#FFC0CB;border-radius: 10px;width:30px;"><td>
                                                    <td colspan="4">Rest Day<td>
                                                <tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <!-- END: Content-->
    {{View::make('layout.footer')}}
    @include('inc.timline-model')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.min.js"></script>
<script type="text/javascript">
    function showenddate() {
        document.getElementById('end_date').style.display='block';
    }
    function hideenddate() {
        document.getElementById('end_date').style.display='none';
    }

    $('#leave-type-select').change(function() {

        window.location.href = "{{ route('employee-dashboard', ['type' => 'TYPE']) }}".replace('TYPE', $(this).val());

    })

    var month = <?php echo $months; ?>;
    var pending = <?php echo $pendingLeaves; ?>;
    var approved = <?php echo $approvedLeave; ?>;
    var barChartData = {
        labels: month,
        datasets: [{
            label: 'Approved',
            backgroundColor: "#28c76f",
            data: approved
        },
            {
                label: 'Pending',
                backgroundColor: "#ff9f43",
                data: pending
            },
        ]
    };

    window.onload = function() {
        var ctx = document.getElementById("canvas").getContext("2d");
        window.myBar = new Chart(ctx, {
            type: 'bar',
            data: barChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: '#c1c1c1',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
            }
        });
    };

</script>
