<?php
use Illuminate\Support\Facades\DB;
use \App\Models\Leavelist;
use \App\Models\UserPay;
use \App\Models\LeaveAdjustment;
use \App\Models\LeaveDay;
use \App\Models\LeavePast;


if (!function_exists('carbon')) {
    function carbon($time = null, $tz = null)
    {
        return new \Carbon\Carbon($time, $tz);
    }
}

function day_count_anniv_cutt_off($username,$year){
    $joiningDate = getJoinDateStr($username);
    $joiningDateArr=explode('-',$joiningDate);
    $joining_month=$joiningDateArr[1];
    $joining_date=$joiningDateArr[2];

    $joining_curr_Date = $year.'-'.$joining_month.'-'.$joining_date;
    $curr_date = date('Y-m-d');

    $d = date('Y-m-d', strtotime($joining_curr_Date.'+1 years'));
    $d1 = date('Y-m-d', strtotime($d.'-1 day'));
    if($d1 <= date('Y-m-d')){
        $curr_date = $d1;
    }
    //echo $joining_curr_Date.'--'.$d1.'<br>';
    $date1 = new DateTime($joining_curr_Date);
    $date2 = new DateTime($curr_date);
    $diff = $date1->diff($date2);
    if($joining_curr_Date>date('Y-m-d')){
        return '0';
    }else{
        return $diff->days;
    }
}

function getJoinDateStr($username)
{
	$query = UserPay::where('username', $username)->first();
	return $query->date_commence;
}

function tilldateDays($joiningDate)
{
	$now = time(); // or your date as well
	$your_date = strtotime($joiningDate);
	$datediff = $now - $your_date;
	return floor($datediff / (60 * 60 * 24));
}

function tillYearEndDays($joiningDate)
{

	$currentY = date('Y');
	$yearE = mktime(0, 0, 0, 12, 31,  $currentY);

	$your_date = strtotime($joiningDate);
	$datediff = $yearE - $your_date;
	return floor($datediff / (60 * 60 * 24));
}

function getBroughtForwardLeaveCount($username, $year, $type){
	$query = DB::table('leave_bf_adj')->where('username', $username)->where('year', $year)->where('leave_type', $type)->sum('bf_adj');
	return $query;
}

function getBroughtForwardLeaveNotAdjusted($username, $year, $type)
{
	$setting = DB::table('settings')->where('field', 'medical_leave_bf_allow')->first();

	$query = DB::table('leave_entitle_history')->where('username', $username)->where('year', $year)->where('leave_type', $type)->first();


	if($type=="Medical" && $setting->value == 0){
		return 0;
	}

    $mcBf = ($query->entitle + $query->bf_leaves + $query->adjustment) - $query->leave_taken;
    if($mcBf == null){
        return 0;
    }
	$val = (floatval($mcBf)) + 0;


	if($val<0){
		return 0;
	}

	return $val;
}

function  getEntitleLeave($username, $year, $type)
{
    $query = DB::table('leave_entitle_history')->where('username', $username)->where('year', $year)->where('leave_type', $type)->first();

    if(!isset($query))
    {
        return 0;
    }

    return $query->entitle;
}

function getTotalReplaceLeave($username, $year)
{
    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = DB::table('leave_adjustment')->where('employee_id', $username)
        ->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('end_date', '<=', $endOfYear->format('Y-m-d'))->sum('no_granted');

    return $query;
}

function getAnnualClaimable($username, $year, $type)
{
    $claimable_pre_set = DB::table('settings')->where('field', 'claimable_pre_set')->first();
    $current_month =  date('n');

    $entitle = getEntitleLeave($username, $year, $type);

    $val = round((($current_month - $claimable_pre_set->value)/12), 2);
    $claim = $val * $entitle;


    return $claim;
}


function getNPLSummary($username, $year)
{
    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = Leavelist::where('username', $username)->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('type', 'NPL')
    ->where('start_date', '<=', $endOfYear->format('Y-m-d'))->where('status', '1')->sum('no_days');

    return $query;
}

function getTakenLeves($username, $year, $type)
{

    $startOfYear = carbon()->setDate($year, 1, 1)->startOfMonth();
    $endOfYear =  carbon()->setDate($year, 1, 1)->addMonth(11)->endOfMonth();
    $query = Leavelist::where('username', $username)->where('start_date', '>=', $startOfYear->format('Y-m-d'))->where('type', $type)
    ->where('start_date', '<=', $endOfYear->format('Y-m-d'))->where('status', '1')->sum('no_days');

    return $query;
}

function getAdjustmentLeaveCount($username, $year, $stat){
    if($stat==0){
        $data = LeaveAdjustment::selectRaw('sum(CASE taken_stat WHEN 0 then no_granted WHEN 0.5 THEN (no_granted - 0.5) END) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }else{
        $data = LeaveAdjustment::selectRaw('sum(no_granted) as sumVal')->whereRaw("employee_id='".$username."' and year(start_date)='".$year."' and (taken_stat=0 OR taken_stat=0.5) and granted='1'")->first();
    }
    if($data != null){
        return $data->sumVal;
    }else{
        return 0;
    }
}
// function getLeaveAdjustmentType(){
//     return DB::table('settings')->where("field",'leave_adjustment_type')->first()->value;
// }
function getSettingsValue($field = 'leave_adjustment_type'){
    return DB::table('settings')->where("field",$field)->first()->value ?? 0;
}
function getTakenLeaveCountDateBy($username, $year, $type, $startDate=null, $endDate=null){
    $cutOffDate = getCutOffDate();
    $cutOffMonth = getCutOffMonth();

    $cutOffStartDate = getCutOffStartDate();
    $cutOffStartMonth = getCutOffStartMonth();

    $query = LeaveDay::selectRaw("sum(CASE leave_list.is_half_day WHEN 1 then 0.5 WHEN 0 THEN 1 END) as leave_taken")
             ->leftJoin('leave_list','leave_list.id','=','leave_days.leave_id')
             ->where('leave_days.status','1')
             ->where('leave_list.type',$type)
             ->where('leave_days.username',$username);

    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }

    if($startDate == null){
        $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    }
    $query =  $query->where('leave_days.date','>=',$startDate);

    if($endDate == null){
        $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
    }
    $query =  $query->where('leave_days.date','<=',$endDate);
    $value = $query->first()->leave_taken;
    if($value==''){
        $value = 0;
    }
    return $value;
}
function getPastLeaveCountDateBy($username, $year=null, $type=null, $startDate=null, $endDate=null){
    if($year==null){
        $year = date('Y');
    }
    $cutOffDate = getCutOffDate();
    $cutOffMonth = getCutOffMonth();

    $cutOffStartDate = getCutOffStartDate();
    $cutOffStartMonth = getCutOffStartMonth();

    $query = LeavePast::selectRaw("sum(leave_past.total_leave_days) as leave_taken")
             ->where('leave_past.username',$username);

    if($type != null){
        $query = $query->where('leave_past.type',$type);
    }

    if($cutOffStartMonth!=1){
        $startYear = $year-1;
    }else{
        $startYear = $year;
    }

    if($startDate == null){
        $startDate = $startYear.'-'.$cutOffStartMonth.'-'.$cutOffStartDate;
    }
    $query =  $query->where('leave_past.start_date','>=',$startDate);

    if($endDate == null){
        $endDate = $year.'-'.$cutOffMonth.'-'.$cutOffDate;
    }
    $query =  $query->where('leave_past.end_date','<=',$endDate);
    $value = $query->first()->leave_taken;
    if($value==''){
        $value = 0;
    }
    return $value;
}

function getCutOffDate(){
    return getSettingsValue("cut_of_date");
}
function getCutOffMonth(){
    return getSettingsValue("cut_of_month");
}
function getCutOffStartDate(){
    return getSettingsValue("cut_of_startdate");
}
function getCutOffStartMonth(){
    return getSettingsValue("cut_of_startmonth");
}
function myLeaveSummary($username,$year,$type="getYearlyEntitle"){
    $curl = curl_init();

    curl_setopt_array($curl, array(
      //   CURLOPT_URL => "http://localhost/co/v3ecoleaves/controller/leave.php",
      CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "action=".$type."&year=".$year."&username=".$username."",
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
function getLeavsCounts($username,$type,$sdate,$edate,$is_half_day,$action = "getLeaveDaysCount"){
    // dd("action=".$action."&start_date=".$sdate."&start_date=".$edate."&type=".$type."&username=".$username."");
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => "http://localhost/v3/controller/leave.php",
      //CURLOPT_URL => "https://v3.ecoleave.asia/controller/leave.php",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "action=".$action."&start_date=".$sdate."&end_date=".$edate."&type=".$type."&username=".$username."&is_half_day=".$is_half_day,
      CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      return $response;
    }
}
