{{View::make('layout.header')}}
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Approval
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Approve / Reject / Cancel</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <form method="get" action="{{ route('approve-leave') }}"   style="padding-left: 20px;">
                                        <div class="btn-group">
                                            <input type="text" name="name" class="form-control" placeholder="Staff name" style="padding-left: 10px;" value="{{request()->get('name') ? request()->get('name') : '' }}">
                                            &nbsp;&nbsp;
                                            <select name="type" class="select2 form-control" style="padding-left: 10px;">
                                                <option value="">All Leave Types</option>
                                                @foreach($leaveTypes as $type)
                                                    <option value="{{ $type->type }}" {{request()->get('type') && request()->get('type') == $type->name ? 'selected' : '' }}>{{ $type->name }}</option>
                                                @endforeach
                                            </select>
                                            &nbsp;&nbsp;
                                            <select name="status" class="select2 form-control">
                                                <option value="">All</option>
                                                <option value="0">Pending</option>
                                                <option value="1">Approved</option>
                                                <option value="2">Rejected</option>
                                                <option value="3">Recommended</option>
                                                <option value="4">Cancelled</option>
                                                <option value="5">Cancellation Pending</option>
                                            </select>
                                            &nbsp;&nbsp;
                                            <div class="btn-group">
                                                <button type="submit" class="btn btn-secondary waves-effect waves-float waves-light" style="padding-left: 10px;">Filter</button>
                                            </div>
                                        </div>
                                    </form>
                                    <div class="d-sm-flex justify-content-between align-items-center table-responsive" style="margin-left: 20px;margin-top:15px;">
                                        <div class="d-flex align-items-right">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-success waves-effect waves-float waves-light approved-btn" disabled  data-toggle="modal" data-target="#exampleModal" >Approve</button>
                                                &nbsp;&nbsp;
                                                <button type="button" class="btn btn-danger waves-effect waves-float waves-light  reject-visible-btn" disabled data-toggle="modal" data-target="#rejectModal">Reject</button>
                                                &nbsp;&nbsp;
                                                <button type="button" class="btn  btn-primary waves-effect waves-float waves-light cancel-visible-btn" disabled data-toggle="modal" data-target="#cancelModal">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered  my-leave-summary-entitle" style="font-size:12px;" >
                                            <thead>
                                                <tr>
                                                    <th style="text-transform: capitalize;" width="5%">Emp No.</th>
                                                    <th style="text-transform: capitalize;"  width="5%">Name</th>
                                                    <th style="text-transform: capitalize;" width="5%">Type</th>
                                                    <th style="text-transform: capitalize;" width="10%">Date</th>
                                                    <th style="text-transform: capitalize;white-space: nowrap;" width="5%">Days</th>
                                                    <th style="text-transform: capitalize;" width="5%">Status</th>
                                                    <th style="text-transform: capitalize;" width="10%">Reason</th>
                                                    <th width="5%">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($requests as $request)
                                                    <tr>
                                                        <td>{{  $request->emp_no }}</td>
                                                        <td>{{  $request->emp_name }}</td>

                                                        <td>
                                                        @if($request->filename != '')
                                                            <a href="{{route('myleave-view-docs', $request->id )}}" style="color:blue;">{{ $request->type == 'Other_pay' ? 'Replacement' : $request->type }}</a>
                                                        @else
                                                            {{ $request->type == 'Other_pay' ? 'Replacement' : $request->type }}
                                                        @endif
                                                        </td>
                                                        <td style="white-space: nowrap;"><a class="appDialog-model" data-toggle="modal" data-target="#inlineForm"
                                                    data-id="{{$request->id}}" style="color:#3192F4;">{{  date('d-m-Y', strtotime($request->start_date)) }}</a></td>
                                                        <td>{{  $request->no_days }}</td>
                                                        <td style="background-color:{{ $request->back_color }};text-align:center; font-weight:bold;color:black;">
                                                            {{  $request->leave_status }}
                                                        </td>
                                                        <td>{{  substr($request->reason, 0, 30) }}</td>
                                                        <td style="text-align:center;"> <input type="checkbox" name="inlineRadioOptions"id="inlineRadio{{ $request->id }}" value="{{ $request->id }}" {{ in_array($request->status, ['1', '2']) ? 'disabled' : ''}}/></td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Ecommerce ends -->
                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                        <div class="modal-header">

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <h5 class="modal-title" id="exampleModalLabel">Are you sure want approve the leave(s)?</h5>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary yes-btn">Yes</button>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Are you sure want reject the leave(s)?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="leave_id" id="leaveID">
                            <lable>Please enter reject Reason</lable>
                            <input type="text" name="reason" id="rejectReason"  class="form-control">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-danger reject-btn">OK</button>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Are you sure want cancel the leave(s)?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="leave_id" id="leaveID">
                            <lable>Please enter cancellation Reason</lable>
                            <input type="text" name="reason" id="cancelReason"  class="form-control">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-danger cancel-btn">OK</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    {{View::make('layout.footer')}}
    @include('inc.timline-model')
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">
        $(document).on('click', 'input[name="inlineRadioOptions"]', function() {
            $('.approved-btn').attr('disabled', false);
            $('.reject-visible-btn').attr('disabled', false);
            $('.cancel-visible-btn').attr('disabled', false);
        });
        $(document).on('click', '.yes-btn', function() {
            var arrId = [];
              $.each($('input[name="inlineRadioOptions"]:checked'), function(){
                arrId.push($(this).val());
              });
            var url = '{{route('leave-approve')}}';
            $.ajax({
                url:url,
                type:'POST',
                data:{
                    '_token' : "{{ csrf_token() }}",
                    'id' : arrId
                },
                success:function(e){
                    window.location.reload();
                },
                error:function(w){
                }
            });
        });

        $(document).on('click', '.reject-btn', function() {
            var arrId = [];
              $.each($('input[name="inlineRadioOptions"]:checked'), function(){
                arrId.push($(this).val());
              });
            var url = '{{route('reject-leave')}}';
            $.ajax({
                url:url,
                type:'POST',
                data:{
                    '_token' : "{{ csrf_token() }}",
                    'id' : arrId,
                    'reason' :  $('#rejectReason').val()
                },
                success:function(e){
                    window.location.reload();
                },
                error:function(w){
                }
            });
        });

        $(document).on('click', '.cancel-btn', function() {
            var arrId = [];
              $.each($('input[name="inlineRadioOptions"]:checked'), function(){
                arrId.push($(this).val());
              });
            var url = '{{route('leave-cancellation')}}';
            $.ajax({
                url:url,
                type:'POST',
                data:{
                    '_token' : "{{ csrf_token() }}",
                    'id' : arrId,
                    'reason' :  $('#cancelReason').val()
                },
                success:function(e){
                    window.location.reload();
                },
                error:function(w){
                }
            });
        });
    </script>
