{{View::make('layout.header')}}
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Self Leave</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-3 col-12">
                    <div class="form-group breadcrumb-right">
                        <a href="#" class="btn btn-primary btn-block waves-effect waves-float waves-light" data-toggle="modal" data-target="#add-payment-sidebar">Apply For Leave</a>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-lg-12 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">

                                        <h4 class="card-title"> My Leaves Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <?php
                                                    $percentage = (isset($alHistory) ? ($alHistory->entitle - $alHistory->leave_taken) : 0 )  / (isset($alHistory) ? $alHistory->entitle : 0) *100 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">AL</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ isset($alHistory) ? ($alHistory->entitle - $alHistory->leave_taken) : 0 }}/{{ isset($alHistory) ? $alHistory->entitle : 0 }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-info" style="height: 6px" style="background-color:#6a7e80;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="0" style="width: {{ $percentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <?php
                                                    $mePercentage = (isset($medHistory) ? ($medHistory->entitle - $medHistory->leave_taken) : 0 )  / (isset($medHistory) ? $medHistory->entitle : 0) *100 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">MC</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{ isset($medHistory) ? ($medHistory->entitle - $medHistory->leave_taken) : 0 }}/{{ isset($medHistory) ? $medHistory->entitle : 0 }} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress  progress-bar-danger" style="height: 6px"  style="background-color:#ec1818;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="0" style="width: {{ $mePercentage }}%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <?php
                                                    $rPercentage = $totalReplacement != 0 ? ($totalReplacement - $repHistory) / $totalReplacement *100 : 0 ;
                                                ?>
                                                <div class="col-md-6">
                                                     <p class="mb-50">RL</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">{{$totalReplacement - $repHistory}}/{{$totalReplacement}} Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px"   style="background-color:#4298a1;">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="0" style="width: {{$rPercentage}}%"></div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/ Medal Card -->
                    </div>
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card" style="font-size:12px;">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">My Leaves</h4>
                                            <form method="get" action="{{ route('self-leaves') }}">
                                                <div class="d-flex align-items-center">
                                                    <select name="type" class="select2 form-control" style="padding-left: 10px;">
                                                        <option value="">All Leave Types</option>
                                                        @foreach($leaveTypes as $type)
                                                            <option value="{{ $type->type }}" {{request()->get('type') && request()->get('type') == $type->type ? 'selected' : '' }}>{{ $type->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    &nbsp;&nbsp;
                                                    <select name="status" class="select2 form-control">
                                                        <option value="">Status</option>
                                                        <option value="0" {{request()->get('status') && request()->get('status') == "0" ? 'selected' : '' }}>Pending</option>
                                                        <option value="1" {{request()->get('status') && request()->get('status') == "1" ? 'selected' : '' }}>Approved</option>
                                                        <option value="2" {{request()->get('status') && request()->get('status') == "2" ? 'selected' : '' }}>Rejected</option>
                                                        <option value="3" {{request()->get('status') && request()->get('status') == "3" ? 'selected' : '' }}>Recommended</option>
                                                        <option value="4" {{request()->get('status') && request()->get('status') == "4" ? 'selected' : '' }}>Cancelled</option>
                                                        <option value="5" {{request()->get('status') && request()->get('status') == "5" ? 'selected' : '' }}>Cancellation Pending</option>
                                                    </select>
                                                    &nbsp;&nbsp;
                                                    <lable  style="padding-left: 10px;">From</lable>
                                                    <input type="text" id="datepicker1" name="from" class="form-control"  style="padding-left: 10px;" value="{{request()->get('from') ? request()->get('from') : '' }}">

                                                    <lable  style="padding-left: 10px;">To</lable>
                                                    <input type="text" id="datepicker2" name="to" class="form-control"  style="padding-left: 0px;" value="{{request()->get('to') ? request()->get('to') : '' }}">
                                                    &nbsp;&nbsp;
                                                    <button type="submit" class="btn btn-secondary btn-block waves-effect waves-float waves-light" style="padding-left: 10px;">Filter</button>

                                                </div>
                                            </form>
                                            &nbsp;&nbsp;
                                            <a href="{{ route('self-leaves', ['type' => request()->get('type'),'from' => request()->get('from'),'to' => request()->get('to') , 'get' => 'all' ]) }}" class="btn btn-secondary btn-block waves-effect waves-float waves-light" style="padding-left: 10px;width:100px;">View All</a>
                                        </div>
                                    <div class="self-table">
                                    <table class="table table-bordered my-leave-summary-entitle" style="font-size:11px;text-align: center;" width="100%">
                                        <thead>
                                            <tr>
                                                <th width="10%" style="text-transform: capitalize;" width="10%">Type</th>
                                                <th width="10%" style="text-transform: capitalize;" width="5%">Date</th>
                                                <th style="text-transform: capitalize;" width="5%">Days</th>
                                                <th style="text-transform: capitalize;" width="10%">Reason</th>
                                                <!-- <th style="text-transform: capitalize;white-space: nowrap;" width="10%">Cancellation Reason</th>
                                                <th style="text-transform: capitalize;white-space: nowrap;" width="10%">Reject Reason</th> -->
                                                <th style="text-transform: capitalize;" width="10%">Status</th>
                                                <th style="text-transform: capitalize;" width="5%">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($leaves as $leave)
                                            <tr>
                                                @php

                                                    $status = '';
                                                    $class= '';

                                                    if($leave['status'] == 0)
                                                    {
                                                        $status = 'Pending';
                                                        $class= 'grey';
                                                    }
                                                    elseif($leave['status'] == 1)
                                                    {
                                                        $status = 'Approved';
                                                        $class= 'green';
                                                    }
                                                    elseif($leave['status'] == 2)
                                                    {
                                                        $status = 'Rejected';
                                                        $class= 'red';
                                                    }
                                                    elseif($leave['status'] == 3)
                                                    {
                                                        $status = 'Recommended';
                                                        $class= 'blue';
                                                    }
                                                    elseif($leave['status'] == 4)
                                                    {
                                                        $status = 'Cancelled';
                                                        $class= 'yellow';
                                                    }
                                                    elseif($leave['status'] == 5)
                                                    {
                                                        $status = 'Cancellation Pending';
                                                        $class= 'orange';
                                                    }
                                                    $leaveDays = Illuminate\Support\Facades\DB::table('leave_days')->where('leave_id', $leave['id'])->first();
                                                @endphp
                                                <td>
                                                @if($leave['filename'] != '')
                                                <a href="{{route('myleave-view-docs', $leave['id'])}}" style="color:blue;">{{ $leave['type'] == 'Other_pay' ? 'Replacement' : $leave['type'] }}</a>
                                                @else
                                                {{ $leave['type'] == 'Other_pay' ? 'Replacement' : $leave['type'] }}
                                                @endif
                                                </td>
                                                <td style="white-space: nowrap;"><a class="appDialog-model" data-toggle="modal" data-target="#inlineForm"
                                                data-id="{{$leave['id']}}" style="color:#3192F4;">{{ date('d-m-Y', strtotime($leave['start_date'])) }}</a></td>
                                                <td>{{ $leave['no_days'] }}</td>
                                                <td>{{ $leave['reason'] }}</td>
                                                <!-- <td>{{ isset($leaveDays) ? $leaveDays->cancellation_reason :''}}</td>
                                                <td>{{ isset($leaveDays) ? $leaveDays->reject_reason :''}}</td> -->
                                                <td style="background-color:{{$class}};color:black;">{{ $status }}</td>
                                                <td><button type="button" data-toggle="modal" data-target="#exampleModal"
                                                data-id="{{$leave['id']}}"
                                                class="btn btn-outline-dark btn-sm waves-effect app-dialog-model" {{ $leave['status'] == '4' || $leave['status'] == '5' ? 'disabled' : ''}}>Cancel</button></td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                        </table><br>
                                        <div style="float: right;">
                                        @if(request()->get('get') && request()->get('get') == 'all')
                                        @else
                                            {{ $leaves->links('pagination::bootstrap-4') }}
                                        @endif
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>My Leave Summary</h4>
                                    <div class="d-sm-flex justify-content-between align-items-center table-responsive" style="margin-left: 20px;">
                                        <div class="d-flex align-items-right">
                                            <select class="form-control" id="start_year"  name="year">
                                                <?php for($x=2021;$x<=date('Y',time());$x++){
                                                ?>
                                                <option value="<?php echo $x; ?>"><?php echo $x; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <table  class="table table-bordered my-leave-summary-entitle" style="font-size:11px;text-align: center;" width="100%" border="1">
                                            <thead>
                                                <tr style="height:50px;background: #F7F7F7;">
                                                    <th style="width:5%;background: #F7F7F7;text-align: center;color:black;text-transform: capitalize;">Type</th>
                                                    <th style="width:8%;text-align:center;color:black;background: #F7F7F7;text-transform: capitalize;">BF</th>
                                                    <th style="width:8%;text-align:center;color:black;background: #F7F7F7;text-transform: capitalize;white-space: nowrap;">BF Adj</th>
                                                    <th style="width:8%;text-align:center;color:black;background: #F7F7F7;text-transform: capitalize;">Entitle</th>
                                                    <th style="width:5%;text-align:center;color:black;background: #F7F7F7;text-transform: capitalize;">Earn</th>
                                                    <th style="width:8%;text-align:center;color:black;text-transform: capitalize;">Claimable
                                                    </th><th style="width:4%;text-align:center;color:black;text-transform: capitalize;">NPL
                                                    </th><th style="width:11%;text-align:center;color:black;text-transform: capitalize;">Taken
                                                    <table class="tableheading">
                                                    <tbody><tr>
                                                        <td style="border-top:none;border-bottom:none;padding:0;width:70px">EL</td>
                                                        <td style="border-top:none;border-bottom:none;border-right:none;padding:0;width:33%">AL</td>
                                                    </tr></tbody></table>
                                                    </th>
                                                    <th style="width:15%;text-align:center;color:black;text-transform: capitalize;">Forfeit
                                                    <table class="tableheading">
                                                    <tbody><tr>
                                                            <td style="border-top:none;border-bottom:none;padding:0;width:70PX">BF</td>
                                                            <td style="border-top:none;border-bottom:none;padding:0;width:33%">Adj</td>
                                                    </tr></tbody></table></th>
                                                    <th style="width:8%;text-align:center;color:black;text-transform: capitalize;">Balance</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr style="height:30px;">
                                                    <th style="background: #F7F7F7;"><b>AL</b></th>
                                                    <td style="text-align:center;">{{ $dataArray['albf'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['aBFAdj'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['aEntitle'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['aEarn'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['aClaim'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['anunpl'] }}</td>
                                                    <td style="width:11%">
                                                        <table >
                                                        <tbody><tr>
                                                            <td style="border-left:none;border-top:none;border-bottom:none;padding:0;width:70px;border-right:1px solid black;text-align:center;">{{ $dataArray['elTaken'] }}</td>
                                                            <td style="border-top:none;border-bottom:none;border-right:none;padding:10px;text-align:center;border-right:none;">{{ $dataArray['alTaken'] }}</td>
                                                        </tr></tbody></table>
                                                    </td>
                                                    <td style="width:11%">
                                                        <table class="tableheading">
                                                        <tbody><tr>
                                                                <td style="border-left:none;border-top:none;border-bottom:none;padding:0;width:90px;border-right:1px solid black;text-align:center;">{{ $dataArray['forAlBf'] }}</td>
                                                                <td style="border-top:none;border-bottom:none;padding:10px;border-right:none;">{{ $dataArray['forAlBfAdj'] }}</td>
                                                        </tr></tbody></table>
                                                    </td>
                                                    <td  style="text-align:center;">{{ $dataArray['alBalance'] }}</td>
                                                </tr>
                                                <tr  style="height:30px;">
                                                    <th class="type" style="background: #F7F7F7;"><b>MC</b></th>
                                                    <td  style="text-align:center;">{{ $dataArray['mbf'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mBFAdj'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mEntitle'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mEarn'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mClaim'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mcnpl'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mcTaken'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['forMC'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['mcBalance'] }}</td>
                                                </tr>
                                                <tr  style="height:30px;">
                                                    <th class="type"  style="background: #F7F7F7;"><b>RL</b></th>
                                                    <td style="text-align:center;">{{ $dataArray['rbf'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rBFAdj'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rEntitle'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rEarn'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rlClaim'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rpnpl'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rlTaken'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['forRL'] }}</td>
                                                    <td style="text-align:center;">{{ $dataArray['rlBalance'] }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                     <h4>Replacement Leaves </h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <table  class="table">
                                            <thead>
                                                <tr>
                                                    <th style="width:12%;text-transform: capitalize;">Name</th>
                                                    <th style="width:13%;text-transform: capitalize;">Date</th>
                                                    <th style="width:7%;text-transform: capitalize;">Days</th>
                                                    <th style="width:13%;text-transform: capitalize;">Reason</th>
                                                    <th style="width:11%;text-transform: capitalize;">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($replacement as $value)
                                                    <tr>
                                                        <td class="type">{{ $value->employee_id }}</td>
                                                        <td class="dateapply">{{ date('d/m/Y', strtotime($value->start_date)) }}</td>
                                                        <td class="noday">{{ $value->no_granted }}</td>
                                                        <td class="status">{{ $value->reason }}</td>
                                                        <td class="status">Approved</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <div class="modal modal-slide-in fade" id="add-payment-sidebar" aria-hidden="true">
                    <div class="modal-dialog sidebar-lg">
                        <div class="modal-content p-0">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">×</button>
                            <div class="modal-header mb-1">
                                <h5 class="modal-title">
                                    <span class="align-middle">Apply Leave</span>
                                </h5>
                            </div>
                            <div class="modal-body flex-grow-1">
                            <form id="leave-form">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                <input type="hidden" name="user_id" value="{{Auth::id()}}">
                                    <div class="form-group">
                                        <label class="form-label" for="payment-date">Leave Type  :</label>
                                        <select class="form-control" id="basicSelect" onChange="leave_type_change('hidden_div', this)" name="leave_type" >

                                            @foreach($leaveTypes as $type)
                                                <option value="{{ $type->name }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="type-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="payment-note">Half Day / Full Day  : </label>
                                        <div class="demo-inline-spacing">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="hideenddate()" name="hof" id="inlineRadio1" value="1" />
                                                <label class="form-check-label" for="inlineRadio1">Half Day</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="showenddate()" name="hof" id="inlineRadio2" value="0" checked/>
                                                <label class="form-check-label" for="inlineRadio2">Full Day</label>
                                            </div>
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="day-error"></span>
                                    </div>
                                    <div class="form-group" id="half_day_type" style="display:none;">
                                        <label>Half Day Type</label>
                                        <select name="half_day_type" class="form-control">
                                            <option value="first">First Half</option>
                                            <option value="second">Second Half</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Leave start Date</label>
                                        <input type="date" name="leave_start_date"  onchange="calculatedays();" class="form-control" id="start-date" onChange="daysBetween()"  placeholder="Leave Start Date" autocomplete="off">
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="start-date-error"></span>
                                    </div>
                                    <div id="end_date">
                                        <label>Leave End Date</label>
                                        <div class="form-group">
                                            <input type="date" name="leave_end_date" onchange="calculatedays();" class="form-control" id="end-date" onChange="daysBetween()" placeholder="Leave End Date"  autocomplete="off" >
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="end-date-error"></span>
                                    </div>

                                    <div class="form-group" id="hidden_div" style="display: none;">
                                        <span id="filespan">
                                            <label>Add Slip File</label>
                                            {{-- <li class="applyleaveleft">Add Slip File &nbsp;:<span class="red">*</span>&nbsp;</li> --}}
                                            {{-- <li class="applyleaveright"> --}}
                                              <div>
                                                <input type="file" name="slip_file" id="slip_file" value="" />
                                              </div>
                                            </li>
                                            </span>

                                    </div>
                                    <div class="form-group">
                                        <label>Total Leave Days</label>
                                        <input type="text" name="no_of_day" id="no-of-day"  class="form-control"  autocomplete="off" readonly>
                                    </div>

                                    <div class="form-group">
                                        <label>Reason</label>
                                        <textarea class="form-control" name="reason" placeholder="Type here" onChange="daysBetween()"></textarea>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="reason-error"></span>
                                    </div>

                                    <div class="form-group">
                                        <label>Relieve</label>
                                        <select class="form-control" name="relieve">
                                            <option value="">Select Relieve</option>
                                            @foreach($relieves as $relieve)
                                            <option value="{{$relieve->username}}">{{$relieve->name}}</option>
                                            @endforeach
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="relive-error"></span>
                                    </div>
                                    <div class="form-group d-flex flex-wrap mb-0">
                                        <button type="button" onclick="saveDetails()" class="btn btn-primary mr-1">Send</button>
                                        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Are you sure want cancel the leave(s)?</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="leave_id" id="leaveID">
                <lable>Please enter Cancellation Reason</lable>
                <input type="text" name="reason" id="cancelReason"  class="form-control">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary ok-btn">OK</button>
            </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    {{View::make('layout.footer')}}
    @include('inc.timline-model')
    <script type="text/javascript">
''
    function calculatedays()
    {
        var endDate = $("#end-date").val();
        if($('input[name="hof"]:checked').val() == 0 && $("#basicSelect").val() == "" && $("#end-date").val() == "" && $("#start-date").val() == "" ){
            return;
        }
        if($('input[name="hof"]:checked').val() == 1){
            endDate = $("#start-date").val();
        }
        var data = {
            'type':  $("#basicSelect").val(),
            'start_date':  $("#start-date").val(),
            'end_date': endDate,
            "is_half_day": $('input[name="hof"]:checked').val(),
            '_token' : "{{ csrf_token() }}",
            'action': "getLeaveDaysCount"
        }
        $.ajax({
            type: "POST",
            url: "{{ route('remainingDays') }}",
            data: data,
            before: function (response) {
                console.log(response);
                // console.log(response);
            },
            success: function (response) {
                // console.log(response);
                $("#no-of-day").val(response.no_leave_days);
                // console.log(response);
            },
            error: function (response) {
                console.log(response);
                // console.log(response);
            }
        });

    }

    function leave_type_change(divId, element){
        document.getElementById(divId).style.display = element.value == "Medical"? 'block' : 'none';
	}

    function showenddate() {
        document.getElementById('end_date').style.display='block';
        document.getElementById('half_day_type').style.display='none';
        daysBetween();
    }

    function hideenddate() {
        document.getElementById('end_date').style.display='none';
        document.getElementById('half_day_type').style.display='block';
        daysBetween();
    }

    function daysBetween() {

        var statDate = $('#start-date').val();
        var endDate = $('#end-date').val();
        const date1 = new Date(statDate);
        const date2 = new Date(endDate);

        const oneDay = 1000 * 60 * 60 * 24;


        const diffInTime = date2.getTime() - date1.getTime();
        const diffInDaysb=0;
        if(statDate == "" && endDate == "" && $("input[name='hof']:checked").val() == 0)
        {
            diffInDays = 0;
        }
        if(statDate !== "" && endDate == "" && $("input[name='hof']:checked").val() == 0)
        {
            diffInDays = 0;
        }
        if(statDate == endDate && $("input[name='hof']:checked").val() == 0)
        {
            diffInDays = 1;
        }
        if(statDate != endDate && $("input[name='hof']:checked").val() == 0)
        {
            diffInDays = Math.round(diffInTime / oneDay) + 1;
        }
        console.log(statDate != endDate , $("input[name='hof']").val() == 0, $("input[name='hof']:checked").val());
        if($("input[name='hof']:checked").val() == 1)
        {
            diffInDays = 0.5;
        }

        $('#no-of-days').val(diffInDays);
    }

    function saveDetails(e){
        var leaveForm = $("#leave-form");
        var data = leaveForm.serialize();
        $( '#type-error' ).html('');
        $( '#day-error' ).html('');
        $( '#start-date-error' ).html('');
        $( '#end-date-error' ).html('');
        $( '#relive-error' ).html('');
        $( '#reason-error' ).html('');
        $.ajax({
            url:'{{route('myleave-apply')}}',
            type:'POST',
            data:data,
            success:function(e){

            },
            error:function(w){
                if(w.responseJSON.errors)
                {
                    if(w.responseJSON.errors.leave_type){
                        $( '#type-error' ).html( w.responseJSON.errors.leave_type[0] );
                    }
                    if(w.responseJSON.errors.hof){
                        $( '#day-error' ).html( w.responseJSON.errors.hof[0] );
                    }
                    if(w.responseJSON.errors.leave_start_date){
                        $( '#start-date-error' ).html( w.responseJSON.errors.leave_start_date[0] );
                    }
                    if(w.responseJSON.errors.leave_end_date){
                        $( '#end-date-error' ).html( w.responseJSON.errors.leave_end_date[0] );
                    }
                    if(w.responseJSON.errors.reason){
                        $( '#reason-error' ).html( w.responseJSON.errors.reason[0] );
                    }
                    if(w.responseJSON.errors.relieve){
                        $( '#relive-error' ).html( w.responseJSON.errors.relieve[0] );
                    }

                }
            }
        });


    };
        $('.app-dialog-model').on('click', function() {
            var id = $(this).data('id');
            console.log(id);
            $('#exampleModal #leaveID').val(id);
        });

        $('.ok-btn').on('click', function() {
            var id = $('#leaveID').val();
            var url = '{{route('cancel-leaves', ['ID'])}}'.replace('ID', id);
            $.ajax({
                url:url,
                type:'POST',
                data:{
                    '_token' : "{{ csrf_token() }}",
                    'reason' :  $('#cancelReason').val()
                },
                success:function(e){
                    window.location.reload();
                },
                error:function(w){
                }
            });
        });

    $(document).on('change', '#type-selection', function(){
        ajaxsearch();
    });

    $(document).on('change', '.from-date', function(){
        ajaxsearch();
    });

    $(document).on('change', '.to-date', function(){
        ajaxsearch();
    });

    function ajaxsearch(){
        $("#overlay").show();
        $.ajax({
            type:'POST',
            url:'{{ route('self.filter')}}',
            data:$("#filter-form").serialize(),
            success:function(data) {
                //alert(data);
                setTimeout(function(){
                    $(".self-table").html(data);
                    $("#overlay").hide();
                },200);

            }
        });
    }

    </script>
