<?php

use Illuminate\Support\Facades\Route;

use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Models\EAttandanceHook;
use App\Http\Controllers\{
    Logincontroller,
    Eleavecontroller,
    LeaveApprovalsController,
    RegisterController,
    MyLeaveController,
    PersonalInfoController,
    ReportController,
    ApprovalDashboardController,
    HrController,
    SettingsController,
    NewEntitleApiController,
    EpayslipController,
    EattendanceController,
    EclaimController,
    ScheduleController,
    DutyroasterController,
   DeviceController
};
/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */

Route::get('webhook', function(Request $request) {
    \Log::info("Data".json_encode($request->all()));
    //dd($fff);
    print_r("<pre>");
    $newRequest = EAttandanceHook::where('id','!=', "0")->orderBy('id','DESC')->get();
    //dd($newRequest);
    foreach($newRequest as $rr){
        //dd(json_decode($rr->data));
        print_r(json_decode($rr->data));
    }
    exit;
    
    // $newRequest = new EAttandanceHook();
    // $newRequest->data = json_encode($request->all());
    // $newRequest->time = time();
    // $newRequest->save();
    // print_r($request->all());
    
    return true;
});
Route::post('webhook', function(Request $request) {
    \Log::info("Data".json_encode($request->all()));
    //dd($request);
    //$requestt = file_get_contents('php://input');
    //var_dump( file_get_contents('php://input'));
    $newRequest = new EAttandanceHook();
    $newRequest->data = json_encode($request->all());
    $newRequest->time = time();
    $newRequest->server = json_encode($_SERVER);
    $newRequest->save();
    
    EAttandanceHook::where(DB::raw('date_format(FROM_UNIXTIME(time), "%Y-%m-%d")'), '!=', date("Y-m-d"))->delete();
    
    //print_r($request->all());
    $saveData = Helper::saveWebHookData($newRequest);
    if($saveData){
        $newRequest->used = 'y';
        $newRequest->save();   
    }
    return true;
});
//E-Leave Routes
Route::get('clear-cache', function() {
    \Artisan::call('config:cache');
    \Artisan::call('route:clear');
    \Artisan::call('cache:clear');
});

/****** E-Attendance Route *****/
Route::group(['prefix' => 'e-attendance'], function () {
    Route::middleware(['auth', 'sessiondestroy'])->group(function() {
        //Route::get('/eattendance', [EattendanceController::class, 'EAttendanceMain'])->name('eattendance');
        Route::get('/empattendancedata', [EattendanceController::class, 'empattendancedata'])->name('empattendancedata');
        Route::get('/emp-attendance', [EattendanceController::class, 'attendanceEmp'])->name('attendanceEmp');
        
        Route::get('/ot-request', [EattendanceController::class, 'otRequest'])->name('ot-request');
        Route::post('/addOtReq', [EattendanceController::class, 'addOtRequest'])->name('addOtReq');
        Route::get('/empOtData', [EattendanceController::class, 'empOtData'])->name('empOtData');
        Route::get('/allEmpOtData', [EattendanceController::class, 'allEmpOtData'])->name('allEmpOtData');
        Route::post('/updatedOTList', [EattendanceController::class, 'updatedOTList'])->name('updatedOTList');
        Route::post('/deleteRequestOT', [EattendanceController::class, 'deleteRequestOT'])->name('deleteRequestOT');
        Route::get('/approval-list', [EattendanceController::class, 'approvalList'])->name('approval-list');
        Route::post('/approveOTUsers', [EattendanceController::class, 'approveOTUsers'])->name('approveOTUsers');
        
        
        Route::get('/all-attendance', [EattendanceController::class, 'allAttendance'])->name('all-attendance');
        Route::get('/hr-attendance', [EattendanceController::class, 'HrAttendance'])->name('HrAttendance');
         Route::get('/allattendance', [EattendanceController::class, 'allAttendanceeee'])->name('allattendance');
        Route::get('/emp-dashboard', [EattendanceController::class, 'dashboardEmp'])->name('dashboardEmp');
        Route::get('/hr-dashboard', [EattendanceController::class, 'dashboardHr'])->name('dashboardHr');
        Route::get('/hr-setup', [EattendanceController::class, 'setupHr'])->name('setupHr');
        Route::get('/schedule', [ScheduleController::class, 'schedule'])->name('schedule');
        Route::get('/scheduledata', [ScheduleController::class, 'scheduledata'])->name('scheduledata');

        Route::get('/create-schedule', [ScheduleController::class, 'createSchedule'])->name('create-schedule');

        Route::get('/getschedule-type', [ScheduleController::class, 'getScheduleType'])->name('getScheduleType');

        Route::get('/schedule-to-emp', [ScheduleController::class, 'empSchedule'])->name('empSchedule');
        Route::post('/schedule-data', [ScheduleController::class, 'insterscheduleData'])->name('insterscheduleData');
        Route::get('/update-schedule/{id}', [ScheduleController::class, 'updateschedule'])->name('update-schedule');  
        Route::post('/edit-schedule', [ScheduleController::class, 'editschedule'])->name('editschedule');  
        Route::get('/removeSchedule', [ScheduleController::class, 'removeSchedule'])->name('removeSchedule');
        Route::get('/schedulemapAttendance', [ScheduleController::class, 'mapAttendance'])->name('schedulemapAttendance');

    
        Route::get('/employeescheduleData', [ScheduleController::class, 'employeescheduleData'])->name('employeescheduleData');

        Route::get('/empscheduledata', [ScheduleController::class, 'Empscheduledata'])->name('empscheduledata');

        Route::get('emp-attendanceexport', [EattendanceController::class, 'empAttendanceexport'])->name('emp-attendanceexport');
        Route::get('empattendancepdf', [EattendanceController::class, 'empAttendancePdf'])->name('empattendancepdf');
        Route::post('editattendancebyhr', [ScheduleController::class, 'editattendancebyhr'])->name('editattendancebyhr');
         Route::post('dltattendancebyhr', [ScheduleController::class, 'dltattendancebyhr'])->name('dltattendancebyhr');
        Route::get('hrdashboarddata', [EattendanceController::class, 'hrDashboardData'])->name('hrdashboarddata');
        Route::get('empdashboarddata', [EattendanceController::class, 'empDashboardData'])->name('empdashboarddata');

        Route::get('getshcedule', [EattendanceController::class, 'getShcedule'])->name('getshcedule');
        
        
        //  ======================= reports Ashutosh ==================

        // attendance summary
        Route::get('reports/attendance-summary', [EattendanceController::class, 'attendanceSummary'])->name('reports.attendance-summary');
        Route::get('reports/attendance-summary-data', [EattendanceController::class, 'attendanceSummaryData'])->name('reports.attendance-summary-data');
        Route::get('reports/attendance-summary-excel', [EattendanceController::class, 'attendanceSummaryExcel'])->name('reports.attendance-summary-excel');
        Route::get('reports/attendance-summary-pdf', [EattendanceController::class, 'attendanceSummaryPdf'])->name('reports.attendance-summary-pdf');

        // user movement
        Route::get('reports/user-movement', [EattendanceController::class, 'userMovement'])->name('reports.user-movement');
        Route::get('reports/user-movement-data', [EattendanceController::class, 'userMovementData'])->name('reports.user-movement-data');
        Route::get('reports/user-movement-excel', [EattendanceController::class, 'userMovementExcel'])->name('reports.user-movement-excel');
        Route::get('reports/user-movement-pdf', [EattendanceController::class, 'userMovementPdf'])->name('reports.user-movement-pdf');

                // audit trial
        Route::get('reports/audit-trial', [EattendanceController::class, 'auditTrial'])->name('reports.audit-trial');
        Route::get('reports/audit-trial-data', [EattendanceController::class, 'auditTrialData'])->name('reports.audit-trial-data');
        Route::get('reports/audit-trial-excel', [EattendanceController::class, 'auditTrialExcel'])->name('reports.audit-trial-excel');
        Route::get('reports/audit-trial-pdf', [EattendanceController::class, 'auditTrialPdf'])->name('reports.audit-trial-pdf');

        // attendance sheet
        Route::get('reports/attendance-sheet', [EattendanceController::class, 'attendanceSheet'])->name('reports.attendance-sheet');
        Route::get('reports/attendance-sheet-data', [EattendanceController::class, 'attendanceSheetData'])->name('reports.attendance-sheet-data');
        Route::get('reports/attendance-sheet-excel', [EattendanceController::class, 'attendanceSheetExcel'])->name('reports.attendance-sheet-excel');
        Route::get('reports/attendance-sheet-pdf', [EattendanceController::class, 'attendanceSheetPdf'])->name('reports.attendance-sheet-pdf');

        // time card
        Route::get('reports/time-card', [EattendanceController::class, 'timeCard'])->name('reports.time-card');
        Route::get('reports/time-card-data', [EattendanceController::class, 'timeCardData'])->name('reports.time-card-data');
        Route::get('reports/time-card-excel', [EattendanceController::class, 'timeCardExcel'])->name('reports.time-card-excel');
        Route::get('reports/time-card-pdf', [EattendanceController::class, 'timeCardPdf'])->name('reports.time-card-pdf');
        Route::get('reports/view-time-card', [EattendanceController::class, 'viewTimeCard'])->name('reports.view-time-card');


        Route::post('unassignschedule', [ScheduleController::class, 'unassignschedule'])->name('unassignschedule');

       Route::post('updateAssignschedule', [ScheduleController::class, 'updateAssignschedule'])->name('updateAssignschedule');
       
       
       
       // assign Attendance to emp
        Route::get('assign-attendance-to-emp', [EattendanceController::class, 'assignAttToEmp'])->name('assign-attendance-to-emp');
        Route::get('empAttData', [EattendanceController::class, 'empAttdata'])->name('empAttData');
        Route::get('mapAttendanceStartDate', [EattendanceController::class, 'mapAttendanceStartDate'])->name('mapAttendanceStartDate');
        Route::get('employeeAttListDate', [EattendanceController::class, 'employeeAttListDate'])->name('employeeAttListDate');
        Route::post('updatedAttList', [EattendanceController::class, 'updatedAttList'])->name('updatedAttList');
        Route::post('unassignAttendanceStart', [EattendanceController::class, 'unassignAttendanceStart'])->name('unassignAttendanceStart');
        
        // Duty Roaster Route

        Route::get('/duty_Roaster' ,'DutyroasterController@dutyRoaster')->name('duty_Roaster');
        Route::post('/createDutyroaster' , 'DutyroasterController@createDutyroaster')->name('createDutyroaster');

        Route::get('/viewdutyroaster' ,'DutyroasterController@viewdutyroaster')->name('viewdutyroaster');

        Route::get('/dutyRoasterdata' , 'DutyroasterController@dutyRoasterdata')->name('dutyRoasterdata');

        Route::get('/update-duty_roaster' , 'DutyroasterController@updateDutyRoaster')->name('update-duty_roaster');

        Route::get('/removedutyRoaster' , 'DutyroasterController@removeDutyRoaster')->name('removeDutyRoaster');

        Route::POST('/editdutyRoaster' , 'DutyroasterController@editdutyRoaster')->name('editdutyRoaster');
       
        Route::get('/getYearlyDutyRoaster' , 'DutyroasterController@getYearlyDutyRoaster')->name('getYearlyDutyRoaster');

        Route::get('/dutyroasterdataLoad' , 'DutyroasterController@dutyroasterdataLoad')->name('dutyroasterdataLoad'); 
        Route::get('/getHoliday' , 'DutyroasterController@getHoliday')->name('getHoliday'); 

        Route::get('/dutyroaster-to-emp','DutyroasterController@empDutyroaster')->name('dutyroaster-to-emp');
        Route::POST('deleteRoaster' , 'DutyroasterController@deleteRoaster')->name('deleteRoaster');
        Route::get('/getdutyRoaster-type', 'DutyroasterController@getDutyRoasterType')->name('getdutyRoasterType');

         Route::get('/map-attendance', 'DutyroasterController@mapAttendance')->name('mapAttendance');

        Route::get('/empdutyroasterdata', 'DutyroasterController@Empdutyroasterdata')->name('empdutyroasterdata');

        Route::get('/employeedutyroasterData', 'DutyroasterController@employeedutyroasterData')->name('employeedutyroasterData');  
        
        Route::post('/updateAssigndutyroaster', 'DutyroasterController@updateAssigndutyroaster')->name('updateAssigndutyroaster');  

        Route::post('/unassigndutyroaster', 'DutyroasterController@unassigndutyroaster')->name('unassigndutyroaster'); 
        
                // duty roaster data update
        Route::post('/updateDutyRoasterData' , 'DutyroasterController@updateDutyRoasterData')->name('updateDutyRoasterData');

        
     
        
          // Device Route

        Route::get('/devices', 'DeviceController@devices')->name('devices');  

        Route::post('/add-devices', 'DeviceController@addDevices')->name('add-devices');  

    
        Route::get('/viewdevices', 'DeviceController@viewDevice')->name('viewdevices'); 
        
        Route::get('/getdevicesdata', 'DeviceController@getDevicedata')->name('getdevicesdata'); 
 
        Route::get('/editdevice', 'DeviceController@editdevice')->name('edit-device'); 

        Route::post('/update-device', 'DeviceController@updateDevice')->name('update-device'); 
    
       Route::get('/deletedevice', 'DeviceController@deletedevice')->name('deletedevice'); 
       
       Route::get('/list', [EattendanceController::class, 'list']);
        
    });
    
    // reports route without auth
    Route::get('reports/attendance-summary-data', [EattendanceController::class, 'attendanceSummaryData'])->name('reports.attendance-summary-data');
    Route::get('reports/user-movement-data', [EattendanceController::class, 'userMovementData'])->name('reports.user-movement-data');
    Route::get('reports/audit-trial-data', [EattendanceController::class, 'auditTrialData'])->name('reports.audit-trial-data');
    Route::get('reports/attendance-sheet-data', [EattendanceController::class, 'attendanceSheetData'])->name('reports.attendance-sheet-data');
    Route::get('reports/time-card-data', [EattendanceController::class, 'timeCardData'])->name('reports.time-card-data');
    
    Route::get('/all-attendance', [EattendanceController::class, 'allAttendance'])->name('all-attendance');
    Route::get('/clockin', [EattendanceController::class, 'EAttendanceClockIn']);
    
    Route::get('/all-clockindata', [EattendanceController::class, 'allClockindata'])->name('all-clockindata');

    
});
/****** E-Attendance Route *****/


Route::get('delete-webhook', function() {
    \Artisan::call('delete-attendance-hook');
});

Route::get('config-clear', function() {
    \Artisan::call('config:clear');
});
Route::get('route-clear', function() {
    \Artisan::call('route:clear');
});
Route::get('view-clear', function() {
    \Artisan::call('view:clear');
});
Route::get('/storage-link', function () {
    \Artisan::call('storage:link');
});


Route::get('/login', function() {
    return view('E-Leave/login');
})->name('login');
Route::get('/register', function() {
    return view('auth.register');
})->name('register');
Route::get('/', function() {
    return redirect()->route('employee-dashboard');
});

Route::group(['prefix' => 'e-payslip'], function () {
    Route::middleware(['auth', 'sessiondestroy'])->group(function() {

        /******** Neeraj Masih ************ */

        //Epayslip
        Route::post('/epayslip/base64Img', [EpayslipController::class, 'base64Img'])->name('admin.epayslip.base64Img');
        Route::get('/epayslip', [EpayslipController::class, 'index'])->name('admin.epayslip');
        Route::get('/epayslip-view/{id}', [EpayslipController::class, 'epayslipView'])->name('admin.epayslipView');
        Route::post('/epayslip/data-table', [EpayslipController::class, 'getEpayslipGridData'])->name('admin.getEpayslipGridData');
        Route::post('/epayslip/getAllowanceDeduction', [EpayslipController::class, 'getAllowanceDeduction'])->name('admin.getAllowanceDeduction');
        Route::post('/epayslip/getUserEPayDetail', [EpayslipController::class, 'getUserEPayDetail'])->name('admin.getUserEPayDetail');
        Route::get('/epayslip-report-download', [EpayslipController::class, 'epayslipReportDownload'])->name('admin.epayslipReportDownload');

        /********************* */
    });
});


/****** E-Claim Route *****/
Route::group(['prefix' => 'e-claim'], function () {
    Route::middleware(['auth', 'sessiondestroy'])->group(function() {
        
        Route::get('/dashboard', [EclaimController::class, 'dashboard'])->name('e-claim.dashboard');
        Route::get('/getEClaimListForApproval', [EclaimController::class, 'getEClaimListForApproval'])->name('e-claim.getEClaimListForApproval');
        Route::post('/updateEClaimAmount', [EclaimController::class, 'updateEClaimAmount'])->name('updateEClaimAmount');
        Route::post('updateEClaimStatus', [EclaimController::class, 'EClaimStatus'])->name('updateEClaimStatus');
        
        Route::get('/financer', [EclaimController::class, 'financer'])->name('e-claim.financer');
        Route::get('/getEClaimListForFinancer', [EclaimController::class, 'getEClaimListForFinancer'])->name('e-claim.getEClaimListForFinancer');
        Route::get('/getEClaimListForApprovalByFinancer', [EclaimController::class, 'getEClaimListForApprovalByFinancer'])->name('e-claim.getEClaimListForApprovalByFinancer');
        
         
        Route::get('/claim', [EclaimController::class, 'eclaim'])->name('e-claim.claim');
        Route::get('/edit-eclaim', [EclaimController::class, 'editeclaim'])->name('e-claim.edit-eclaim');
        Route::get('/getEClaim', [EclaimController::class, 'getEClaim'])->name('e-claim.getEClaim');
        Route::get('/getEClaimFieldType', [EclaimController::class, 'getEClaimFieldType'])->name('e-claim.getEClaimFieldType');
        Route::post('/addClaim', [EclaimController::class, 'addClaim'])->name('addClaim');
        Route::get('/get-eclaim-data/{id}', [EclaimController::class, 'geteclaimdata'])->name('get-eclaim-data');
        Route::get('/getEClaimByIdForEdit', [EclaimController::class, 'getEClaimByIdForEdit'])->name('e-claim.getEClaimByIdForEdit');
        Route::get('/view-file/{id}', [EclaimController::class, 'viewDocs'])->name('eclaim-view-docs');
        Route::post('/deleteEclaim', [EclaimController::class, 'deleteEclaim'])->name('e-claim.deleteEclaim');
        Route::post('/deleteEclaimFile', [EclaimController::class, 'deleteEclaimFile'])->name('e-claim.deleteEclaimFile');
        Route::post('/updateClaim', [EclaimController::class, 'updateClaim'])->name('updateClaim');
        
        
        Route::get('/claim-rate', [EclaimController::class, 'claimrate'])->name('e-claim.claim-rate');
        Route::get('/getClaimRateList', [EclaimController::class, 'getClaimRateList'])->name('getClaimRateList');
        Route::post('/setclaimrate', [EclaimController::class, 'setclaimrate'])->name('e-claim.setclaimrate');
        
         
        Route::get('/report', [EclaimController::class, 'report'])->name('e-claim.report');
        Route::get('/geteclaimreportdata', [EclaimController::class, 'geteclaimreportdata'])->name('geteclaimreportdata');
        Route::get('/get-eclaim-report-data/{id}', [EclaimController::class, 'getreportdata'])->name('get-eclaim-report-data');
        Route::get('/eclaimreportpdf', [EclaimController::class, 'eclaimreportpdf'])->name('eclaimreportpdf');
        Route::get('/editreport', [EclaimController::class, 'editreport'])->name('e-claim.editreport');
        Route::get('/eclaimreportexport', [EclaimController::class, 'eclaimreportexport'])->name('eclaimreportexport');
        Route::post('/deleteEclaimEmployee', [EclaimController::class, 'deleteEclaimEmployee'])->name('deleteEclaimEmployee');
        
        Route::get('/type', [EclaimController::class, 'type'])->name('e-claim.type');
        Route::get('/gettype', [EclaimController::class, 'gettype'])->name('e-claim.gettype');
        Route::post('/addtype', [EclaimController::class, 'addtype'])->name('e-claim.addtype');
        Route::get('/get-eclaim-type-data/{id}', [EclaimController::class, 'geteclaimtypedata'])->name('get-eclaim-type-data');
        Route::get('/edittype', [EclaimController::class, 'edittype'])->name('e-claim.edittype');
        Route::get('/deletetype', [EclaimController::class, 'deletetype'])->name('e-claim.deletetype');
        
        Route::get('/type-field/{typeid}', [EclaimController::class, 'typefield'])->name('e-claim.type-field');
        Route::get('/gettypefield', [EclaimController::class, 'gettypefield'])->name('e-claim.gettypefield');
        Route::post('/addtypefield', [EclaimController::class, 'addtypefield'])->name('e-claim.addtypefield');
        Route::get('/get-eclaim-type-field-data/{id}', [EclaimController::class, 'geteclaimtypefielddata'])->name('get-eclaim-type-field-data');
        Route::get('/edittypefield', [EclaimController::class, 'edittypefield'])->name('e-claim.edittypefield'); 
        Route::get('/deletetypefield', [EclaimController::class, 'deletetypefield'])->name('e-claim.deletetypefield');
        
        
        // audit
        Route::get('/audit', [EclaimController::class, 'audit'])->name('e-claim.audit');

    });
    Route::get('/geteclaimauditdata', [EclaimController::class, 'geteclaimauditdata'])->name('geteclaimauditdata');
    Route::get('/eclaimauditpdf', [EclaimController::class, 'eclaimauditpdf'])->name('eclaimauditpdf');
    Route::get('/eclaimauditexport', [EclaimController::class, 'eclaimauditexport'])->name('eclaimauditexport');
});
/****** End E-Claim Route *****/

Route::group(['prefix' => 'e-leave'], function () {
    Route::post('/register', [RegisterController::class, 'create'])->name('register.store');
    Route::post('/post-login', [Logincontroller::class, 'postLogin'])->name('postlogin');
    Route::get('/otp', function() {
        return view('E-Leave/otp');
    })->name('otp');
    Route::post('/otpverify', [Logincontroller::class, 'otpverify'])->name('otpverify');
    Route::get('/forgot-password', function() {
        return view('E-Leave/forgot-password');
    })->name('forgot-password');
    Route::post('/sendforgotpasswordmail', [Logincontroller::class, 'sendforgotpasswordmail'])->name('sendforgotpasswordmail');
    Route::get('/changepassword', [Logincontroller::class, 'change_password'])->name('changepassword');
    Route::post('/updatePassword', [Logincontroller::class, 'updatePassword'])->name('updatePassword');
    Route::middleware(['auth', 'sessiondestroy'])->group(function() {
        Route::get('/dashboard', [Eleavecontroller::class, 'dashboard'])->name('employee-dashboard');
        Route::get('/filteruser', [Eleavecontroller::class, 'filteruser'])->name('filteruser');
        Route::get('/filtercountry', [Eleavecontroller::class, 'filtercountry'])->name('filtercountry');
        Route::get('/employee-summary', [Eleavecontroller::class, 'edashmysummary'])->name('employee-summary');
        Route::get('/filteremployee', [LeaveApprovalsController::class, 'filteremployee'])->name('filteremployee');

        Route::post('/apply-for-leave', [Eleavecontroller::class, 'ApplyForLeave'])->name('applyforleave');
        Route::post('/change-password', [Logincontroller::class, 'changePassword'])->name('change-password');
        Route::post('/upload-profile', [Logincontroller::class, 'uploadProfile'])->name('upload-profile');
        Route::post('/update-personal', [Logincontroller::class, 'savePersonalInfo'])->name('update-personal-info');

        Route::post('/get-chart-data', [Eleavecontroller::class, 'getChartData'])->name('get-chart-data');
        Route::post('/filter-chart', [Eleavecontroller::class, 'filterGraph'])->name('filter-chart');
        Route::get('/get-timeline-data/{id}', [Eleavecontroller::class, 'getTimeline'])->name('get-timeline-data');
         Route::get('/get-time-line-data/{id}', [Eleavecontroller::class, 'getTimelines'])->name('get-time-line-data');
         Route::get('/approver-staff-leave', [ApprovalDashboardController::class, 'getapproverstaffLeave'])->name('getApproverstaffLeave');

        Route::get('/getuser', [MyLeaveController::class, 'getuser'])->name('getuser');
        Route::get('/getglobaluser', [MyLeaveController::class, 'getglobaluser'])->name('getglobaluser');
        Route::get('/view-all-holidays', [MyLeaveController::class, 'viewallholidays'])->name('view-all-holidays');
        Route::get('/search', [MyLeaveController::class, 'globalSearch'])->name('global-search');
        Route::get('/get-leave-data/{id}', [MyLeaveController::class, 'getLeave'])->name('get-leave-data');
        Route::get('/get-requestrl-leave-data/{id}', [MyLeaveController::class, 'getRlLeave'])->name('get-requestrl-leave-data');
        Route::get('/view-file/{id}', [MyLeaveController::class, 'viewDocs'])->name('myleave-view-docs');
        Route::get('/my-leaves', [MyLeaveController::class, 'index'])->name('employee-myleaves');
        Route::post('/my-leaves', [MyLeaveController::class, 'apply'])->name('myleave-apply');
        Route::get('/self-leaves', [MyLeaveController::class, 'getMyLeaves'])->name('self-leaves'); 
        Route::get('/self-leaves/getdata', [MyLeaveController::class, 'getSelfLeave'])->name('getSelfLeave');
        Route::get('/self-leaves/search', [MyLeaveController::class, 'getMyLeaves_search']);
        Route::post('/cancel-leaves/{id}', [MyLeaveController::class, 'cancelLeave'])->name('cancel-leaves');
        Route::get('/all-holidays', [MyLeaveController::class, 'getAllLeaves'])->name('all-holidays');
        Route::get('/all-leaves', [MyLeaveController::class, 'getAllLeaves'])->name('all-leaves');
        Route::get('/entitle/{year?}/{isjson?}', [MyLeaveController::class, 'getEntitle'])->name('all-entitle');
        Route::get('/en/{year?}/{isjson?}', [MyLeaveController::class, 'getEntitle11']);
        Route::post('/leaves-filter', [MyLeaveController::class, 'leaveFilter'])->name('self.filter');
        Route::post('/calender-filter11', [MyLeaveController::class, 'holidayFilter11'])->name('calender.filter11');
        Route::post('/calender-filter13', [MyLeaveController::class, 'holidayFilter13'])->name('calender.filter13');

        Route::get('/request-for-rl', [MyLeaveController::class, 'erequestforrl'])->name('request-for-rl');
        Route::get('/getRL_Approvers', [MyLeaveController::class, 'getRL_Approvers'])->name('getRL_Approvers');
        Route::post('/addRLeave', [MyLeaveController::class, 'addRLeave'])->name('addRLeave');


        Route::post('/calender-filter', [MyLeaveController::class, 'holidayFilter'])->name('calender.filter');
        Route::post('/acalender-filter', [MyLeaveController::class, 'aholidayFilter'])->name('acalender.filter');

        Route::get('/personal-information', [PersonalInfoController::class, 'index'])->name('personal-information');
        Route::get('/update-personal-information', [PersonalInfoController::class, 'updatepersonalinfo']);

        Route::get('/logout', [Logincontroller::class, 'logout'])->name('logout');

        Route::post('/approve-leaves', [LeaveApprovalsController::class, 'approver'])->name('approveleave');
         Route::post('/approve-leavess', [LeaveApprovalsController::class, 'approverr'])->name('approveleaves');
        Route::post('/selfapprove-leaves', [LeaveApprovalsController::class, 'selfapprover'])->name('selfapproveleave');
        Route::get('/approve-leave', [LeaveApprovalsController::class, 'index'])->name('approve-leave');
        Route::get('/approve-leave/leave-data', [LeaveApprovalsController::class, 'getLeave'])->name('getLeave');
        Route::get('/approve-leave/search', [LeaveApprovalsController::class, 'approve_search']);
        Route::get('/approve-leave/ssearch', [LeaveApprovalsController::class, 'approve_search1']);

        Route::get('/apply-behalf', [LeaveApprovalsController::class, 'applyBehalf'])->name('applyBehalf-view');
        Route::post('/approve-leave', [LeaveApprovalsController::class, 'approveLeave'])->name('leave-approve');
        Route::post('/reject-leave', [LeaveApprovalsController::class, 'rejectLeave'])->name('reject-leave');
        Route::post('/approval-cancellation-leave', [LeaveApprovalsController::class, 'leaveCancellation'])->name('leave-cancellation');
        Route::post('/store-behalf-leave', [LeaveApprovalsController::class, 'storeBehalf'])->name('apply-behalf-leave');


        Route::get('/report', [ReportController::class, 'index'])->name('report-index');
        Route::get('/getreportdata', [ReportController::class, 'getreportdata'])->name('get-report-data');

        Route::get('/pdf', [ReportController::class, 'downloadPDF'])->name('report-pdf-doenload');
        Route::get('/export', [ReportController::class, 'export'])->name('export');

        Route::get('/user-info-pdf', [ReportController::class, 'downloaduserinfoPDF'])->name('user-info-pdf');
        Route::get('/user-info-export', [ReportController::class, 'userinfoexport'])->name('user-info-export');

        Route::get('/approval-dashboard', [ApprovalDashboardController::class, 'index'])->name('approval-dashboard');
        Route::get('/message', [ApprovalDashboardController::class, 'getMessage'])->name('get-message');
        Route::post('/message', [ApprovalDashboardController::class, 'storeMessage'])->name('stote-message');

        Route::get('/hr-dashboard', [HrController::class, 'dashboard'])->name('hr-dashboard');
        Route::get('/getemployeegendercomposition', [HrController::class, 'getemployeegendercomposition'])->name('getemployeegendercomposition');
        Route::get('/getemployeetypecomposition', [HrController::class, 'getemployeetypecomposition'])->name('getemployeetypecomposition');
        Route::get('/getemployeeracecomposition', [HrController::class, 'getemployeeracecomposition'])->name('getemployeeracecomposition');
        Route::get('/getRestDaygroup', [HrController::class, 'getRestDaygroup'])->name('getRestDaygroup');
        Route::get('/getleavecategory', [HrController::class, 'getleavecategory'])->name('getleavecategory');
        Route::get('/getmaritalstatus', [HrController::class, 'getmaritalstatus'])->name('getmaritalstatus');
        Route::get('/getagedistribution', [HrController::class, 'getagedistribution'])->name('getagedistribution');
        Route::get('/getlengthofservice', [HrController::class, 'getlengthofservice'])->name('getlengthofservice');
        Route::get('/getrbranchforecastdata', [HrController::class, 'getrbranchforecastdata'])->name('getrbranchforecastdata');
        Route::get('/getrcategoryforecastdata', [HrController::class, 'getrcategoryforecastdata'])->name('getrcategoryforecastdata');
        Route::get('/getrdeptforecastdata', [HrController::class, 'getrdeptforecastdata'])->name('getrdeptforecastdata');
        Route::get('/getweeklyattendance', [HrController::class, 'getweeklyattendance'])->name('getweeklyattendance');
        Route::get('/getmonthlyattrition', [HrController::class, 'getmonthlyattrition'])->name('getmonthlyattrition');
        Route::get('/getbirthdayanniversary', [HrController::class, 'getbirthdayanniversary'])->name('getbirthdayanniversary');

        Route::get('/editleave', [HrController::class, 'editleave'])->name('editleave');

        Route::get('/editRlleave', [HrController::class, 'editRlleave'])->name('editRlleave');


        Route::get('/getYearlyLeaveGraphByLeaveType', [HrController::class, 'getYearlyLeaveGraphByLeaveType'])->name('getYearlyLeaveGraphByLeaveType');
        Route::get('/getHRApproverPendingLeaveListAll', [HrController::class, 'getHRApproverPendingLeaveListAll'])->name('getHRApproverPendingLeaveListAll');
        Route::get('/getBranchEmployeeCount', [HrController::class, 'getBranchEmployeeCount'])->name('getBranchEmployeeCount');
        Route::get('/getCategoryEmployeeCount', [HrController::class, 'getCategoryEmployeeCount'])->name('getCategoryEmployeeCount');
        Route::get('/getDepartmentEmployeeCount', [HrController::class, 'getDepartmentEmployeeCount'])->name('getDepartmentEmployeeCount');
        Route::post('/branchgetTypewiseYearlyLeaveCount', [HrController::class, 'branchgetTypewiseYearlyLeaveCount'])->name('branchgetTypewiseYearlyLeaveCount');
        Route::post('/categorygetTypewiseYearlyLeaveCount', [HrController::class, 'categorygetTypewiseYearlyLeaveCount'])->name('categorygetTypewiseYearlyLeaveCount');
        Route::post('/deptgetTypewiseYearlyLeaveCount', [HrController::class, 'deptgetTypewiseYearlyLeaveCount'])->name('deptgetTypewiseYearlyLeaveCount');

        Route::get('/setup', [HrController::class, 'setup'])->name('setup');

        Route::get('/employee-type', [HrController::class, 'employee_type'])->name('employee-type');
        Route::get('/getemployeetype', [HrController::class, 'getemployeetype'])->name('getemployeetype');
        Route::post('/addemployeetype', [HrController::class, 'addemployeetype'])->name('addemployeetype');
        Route::get('/get-emptype-data/{id}', [HrController::class, 'getemptypedata'])->name('get-emptype-data');
        Route::get('/editemptype', [HrController::class, 'editemptype'])->name('editemptype');
        Route::get('/deleteemptype', [HrController::class, 'deleteemptype'])->name('deleteemptype');


        Route::get('/employee-designation', [HrController::class, 'employee_designation'])->name('employee-designation');
        Route::get('/getemployeedesignation', [HrController::class, 'getemployeedesignation'])->name('getemployeedesignation');
        Route::post('/addemployeedesignation', [HrController::class, 'addemployeedesignation'])->name('addemployeedesignation');
        Route::get('/get-empdesignation-data/{id}', [HrController::class, 'getempdesignationdata'])->name('get-empdesignation-data');
        Route::get('/editempdesignation', [HrController::class, 'editempdesignation'])->name('editempdesignation');
        Route::get('/deleteempdesignation', [HrController::class, 'deleteempdesignation'])->name('deleteempdesignation');

        Route::get('/create-employee', [HrController::class, 'createemployee'])->name('create-employee');
        Route::get('/getGroupPermissions', [HrController::class, 'getGroupPermissions'])->name('getGroupPermissions');
        Route::get('/getStateByCountry', [HrController::class, 'getStateByCountry'])->name('getStateByCountry');
        Route::get('/registerUser_1', [HrController::class, 'registerUser_1'])->name('registerUser_1');
        Route::get('/mapEmployeePermission', [HrController::class, 'mapEmployeePermission'])->name('mapEmployeePermission');
        Route::get('/employeeNoAvailable', [HrController::class, 'isEmployeeNoAvailable'])->name('employeeNoAvailable');
        Route::get('/usernameAvailable', [HrController::class, 'usernameAvailable'])->name('usernameAvailable');
        Route::get('/registerUser_2', [HrController::class, 'registerUser_2'])->name('registerUser_2');
        Route::get('/registerUser_3', [HrController::class, 'registerUser_3'])->name('registerUser_3');
        Route::get('/registerUser_4', [HrController::class, 'registerUser_4'])->name('registerUser_4');
        Route::get('/getCategoryNames', [HrController::class, 'getcategoryNames'])->name('getCategoryNames');

        Route::get('/edit-employee', [HrController::class, 'editemployee'])->name('edit-employee');
        Route::get('/getemployeelist', [HrController::class, 'getemployeelist'])->name('getemployeelist');
        Route::post('/resetPassword', [HrController::class, 'resetPassword'])->name('resetPassword');
        Route::post('/deleteUser', [HrController::class, 'deleteUser'])->name('deleteUser');
        Route::get('/update-employee/{id}', [HrController::class, 'updateemployee'])->name('update-employee');
        Route::get('getAllDetails', [HrController::class, 'getAllDetails'])->name('getAllDetails');
        Route::get('getLeaveMultipleApprover', [HrController::class, 'getLeaveMultipleApprover'])->name('getLeaveMultipleApprover');
        Route::get('getApproversOfEmployee', [HrController::class, 'getApproversOfEmployee'])->name('getApproversOfEmployee');
        Route::get('getPermissionGroupOfEmployee', [HrController::class, 'getPermissionGroupOfEmployee'])->name('getPermissionGroupOfEmployee');
        Route::get('getRestDayCategoriesOfEmployee', [HrController::class, 'getRestDayCategoriesOfEmployee'])->name('getRestDayCategoriesOfEmployee');
        Route::get('updateUserAll', [HrController::class, 'updateUserAll'])->name('updateUserAll');
        Route::get('mapEmployeeToCategory', [HrController::class, 'mapEmployeeToCategory'])->name('mapEmployeeToCategory');
        Route::get('removeEmployeeMapping', [HrController::class, 'removeEmployeeMapping11'])->name('removeEmployeeMapping');
        Route::get('mapEmplyoyeeS', [HrController::class, 'mapEmplyoyeeS'])->name('mapEmplyoyeeS');

        Route::get('/approver-create', [HrController::class, 'approvercreate'])->name('approver-create');
        Route::get('/getApprovers', [HrController::class, 'getApprovers'])->name('getApprovers');
        Route::get('/getManagers', [HrController::class, 'getManagers'])->name('getManagers');
        Route::get('/getGroupedUsers', [HrController::class, 'getGroupedUsers'])->name('getGroupedUsers');
        Route::get('/getUnMappedEmployees', [HrController::class, 'getUnMappedEmployees'])->name('getUnMappedEmployees');
        Route::get('/getAllUsers', [HrController::class, 'getAllUsers'])->name('getAllUsers');
        Route::get('/getEmployeesUnderApprover', [HrController::class, 'getEmployeesUnderApprover'])->name('getEmployeesUnderApprover');
        Route::get('/getMapBackupUserListForEmp', [HrController::class, 'getMapBackupUserListForEmp'])->name('getMapBackupUserListForEmp');
        Route::get('/removeBackupUserMappingByEmployee', [HrController::class, 'removeBackupUserMappingByEmployee'])->name('removeBackupUserMappingByEmployee');
        Route::get('/map_backup_users', [HrController::class, 'map_backup_users'])->name('map_backup_users');
        Route::get('/mapMultipleEmployeemanager', [HrController::class, 'mapMultipleEmployeemanager'])->name('mapMultipleEmployeemanager');
        Route::get('/mapEmplyoyee', [HrController::class, 'mapEmplyoyee'])->name('mapEmplyoyee');
        Route::get('/mapEmplyoyeemanager', [HrController::class, 'mapEmplyoyeemanager'])->name('mapEmplyoyeemanager');
        Route::get('/getEmployeesUnderManager', [HrController::class, 'getEmployeesUnderManager'])->name('getEmployeesUnderManager');
        Route::get('/getUserList', [HrController::class, 'getUserList'])->name('getUserList');

        Route::get('/approver-edit', [HrController::class, 'approveredit'])->name('approver-edit');
        Route::get('/getApproverEmployeeList', [HrController::class, 'getApproverEmployeeList'])->name('getApproverEmployeeList');
        Route::get('/getAllManagerNConnectedUsers', [HrController::class, 'getAllManagerNConnectedUsers'])->name('getAllManagerNConnectedUsers');
        Route::get('/eremoveManagerMapping', [HrController::class, 'eremoveManagerMapping'])->name('eremoveManagerMapping');
        Route::get('/updateManagerMapping', [HrController::class, 'updateManagerMapping'])->name('updateManagerMapping');
        Route::get('/editApproverMapping', [HrController::class, 'editApproverMapping'])->name('editApproverMapping');
        Route::get('/eremoveApproverMapping', [HrController::class, 'eremoveApproverMapping'])->name('eremoveApproverMapping');
        Route::get('/get-eclaimmapping-data/{id}', [HrController::class, 'geteclaimmappingdata'])->name('get-eclaimmapping-data');
        Route::get('/get-employeeapprovermapping-data/{id}', [HrController::class, 'employeeapprovermapping'])->name('get-employeeapprovermapping-data');

        Route::get('/gethdata', [MyLeaveController::class, 'getholidaysdata'])->name('gethdata');

        Route::get('/claim-rate', [HrController::class, 'claimrate'])->name('claim-rate');
        Route::get('/getclaimrate', [HrController::class, 'getclaimrate'])->name('getclaimrate');
        Route::get('/setclaimrate', [HrController::class, 'setclaimrate'])->name('setclaimrate');

        Route::get('/block-days', [HrController::class, 'blockdates'])->name('block-days');
        Route::get('/getRestDayCategories', [HrController::class, 'getRestDayCategories'])->name('getRestDayCategories');
        Route::get('/getCategoryMappingForApprover', [HrController::class, 'getCategoryMappingForApprover'])->name('getCategoryMappingForApprover');
        Route::get('/deleteMappingByCategoryUser', [HrController::class, 'deleteMappingByCategoryUser'])->name('deleteMappingByCategoryUser');
        Route::get('/deleteRestDayCategory', [HrController::class, 'deleteRestDayCategory'])->name('deleteRestDayCategory');
        Route::get('/getEmployeesUnderApprover', [HrController::class, 'getEmployeesUnderApprover'])->name('getEmployeesUnderApprover');
        Route::get('/getcategoryList', [HrController::class, 'getcategoryList'])->name('getcategoryList');
        Route::get('/getbranchList', [HrController::class, 'getbranchList'])->name('getbranchList');
        Route::get('/get-employeeslist', [HrController::class, 'getEmployeesList'])->name('getEmployeesList');
        Route::get('/getdepartmentList', [HrController::class, 'getdepartmentList'])->name('getdepartmentList');
        Route::get('/EmployeAddedList', [HrController::class, 'EmployeAddedList'])->name('EmployeAddedList');
        Route::get('/CategoryAddedList', [HrController::class, 'CategoryAddedList'])->name('CategoryAddedList');
        Route::get('/DepartmentAddedList', [HrController::class, 'DepartmentAddedList'])->name('DepartmentAddedList');
        Route::get('/BranchAddedList', [HrController::class, 'BranchAddedList'])->name('BranchAddedList');
        Route::get('/getBlockdaysList', [HrController::class, 'getBlockdaysList'])->name('getBlockdaysList');
        Route::get('/getCategoryRestDays', [HrController::class, 'getCategoryRestDays'])->name('getCategoryRestDays');
        Route::get('/getEmployeeRestDays', [HrController::class, 'getEmployeeRestDays'])->name('getEmployeeRestDays');
        Route::get('/addBlockdays', [HrController::class, 'addBlockdays'])->name('addBlockdays');
        Route::get('/updateBlockdays', [HrController::class, 'updateBlockdays'])->name('updateBlockdays');
        Route::get('/updateRestDays', [HrController::class, 'updateRestDays'])->name('updateRestDays');
        Route::get('/addRestDayCategory', [HrController::class, 'addRestDayCategory'])->name('addRestDayCategory');
        Route::get('/isRestDayExist', [HrController::class, 'isRestDayExist'])->name('isRestDayExist');
        Route::get('/mapCategoryEmployee', [HrController::class, 'mapCategoryEmployee'])->name('mapCategoryEmployee');





        Route::get('/reports/employees', [HrController::class, 'remployee'])->name('employees');
        Route::get('/reports/getremployeedata', [HrController::class, 'getremployeedata'])->name('getremployeedata');
        Route::get('/reports/employeepdf', [HrController::class, 'employeePDF'])->name('report-employeepdf');
        Route::get('/reports/employeeexport', [HrController::class, 'employeeexport'])->name('report-employeeexport');

        Route::get('/reports/departments', [HrController::class, 'rdepartments'])->name('departments');
        //Route::get('/reports/getrdeptdata' , [HrController::class, 'getrdeptdata'])->name('getrdeptdata');
        Route::get('/reports/deptpdf', [HrController::class, 'departmentPDF'])->name('report-deptpdf');
        Route::get('/reports/deptexport', [HrController::class, 'deparmentexport'])->name('report-deptexport');

        Route::get('/reports/category', [HrController::class, 'rcategory'])->name('category');
        Route::get('/reports/catpdf', [HrController::class, 'categoryPDF'])->name('report-catpdf');
        Route::get('/reports/catexport', [HrController::class, 'categoryexport'])->name('report-catexport');

        Route::get('/reports/branch', [HrController::class, 'rbranch'])->name('branch');
        Route::get('/reports/branchpdf', [HrController::class, 'branchPDF'])->name('report-branchpdf');
        Route::get('/reports/branchexport', [HrController::class, 'branchexport'])->name('report-branchexport');

        Route::get('/reports/leave', [HrController::class, 'rleave'])->name('leave');
        Route::get('/reports/getrleavedata', [HrController::class, 'getrleavedata'])->name('getrleavedata');
        Route::get('/reports/leavepdf', [HrController::class, 'leavePDF'])->name('report-leavepdf');
        Route::get('/reports/leaveexport', [HrController::class, 'leaveexport'])->name('report-leaveexport');

        Route::get('/reports/holiday', [HrController::class, 'rholiday'])->name('holiday');
        Route::get('/reports/getrholidaydata', [HrController::class, 'getrholidaydata'])->name('getrholidaydata');
        Route::get('/reports/getsearchholidaydata', [HrController::class, 'getsearchholidaydata'])->name('getsearchholidaydata');
        Route::get('/reports/holidaypdf', [HrController::class, 'holidayPDF'])->name('report-holidaypdf');
        Route::get('/reports/holidayexport', [HrController::class, 'holidayexport'])->name('report-holidayexport');

        Route::get('/reports/annualentitle', [HrController::class, 'rannualentitle'])->name('annualentitle');
        Route::get('/reports/leave-audit', [HrController::class, 'leaveAudit'])->name('leave-audit');


        Route::get('/reports/getrannualentitledata', [HrController::class, 'getrannualentitledata'])->name('getrannualentitledata');
        Route::get('/reports/annualentitlepdf', [HrController::class, 'annualentitlePDF'])->name('report-annualentitlepdf');
        Route::get('/reports/annualentitleexport', [HrController::class, 'annualentitleexport'])->name('report-annualentitleexport');

        Route::get('/reports/medicalentitle', [HrController::class, 'rmedicalentitle'])->name('medicalentitle');
        Route::get('/reports/getrmedicalentitledata', [HrController::class, 'getrmedicalentitledata'])->name('getrmedicalentitledata');
        Route::get('/reports/medicalentitlepdf', [HrController::class, 'medicalentitlePDF'])->name('report-medicalentitlepdf');
        Route::get('/reports/medicalentitleexport', [HrController::class, 'medicalentitleexport'])->name('report-medicalentitleexport');

        Route::get('/reports/rlentitle', [HrController::class, 'rrlentitle'])->name('rlentitle');
        Route::get('/reports/getrrlentitledata', [HrController::class, 'getrrlentitledata'])->name('getrrlentitledata');
        Route::get('/reports/rlentitlepdf', [HrController::class, 'rlentitlePDF'])->name('report-rlentitlepdf');
        Route::get('/reports/rlentitleexport', [HrController::class, 'rlentitleexport'])->name('report-rlentitleexport');

        

        Route::get('/leave-summary', [HrController::class, 'leavesummary'])->name('leave-summary');
        Route::get('/leavesummarypdf', [HrController::class, 'leavesummaryPDF'])->name('leavesummarypdf');
        Route::get('/leavesummaryexport', [HrController::class, 'leavesummaryexport'])->name('leavesummaryexport');

        Route::get('/other-leave-reports', [HrController::class, 'other_leave_reports'])->name('other-leave-reports');
        Route::get('/otherleavereportpdf', [HrController::class, 'otherleavereportPDF'])->name('otherleavereportpdf');
        Route::get('/otherleavereportexport', [HrController::class, 'otherleavereportexport'])->name('otherleavereportexport');

        Route::get('/countries', [HrController::class, 'countries'])->name('countries');
        Route::get('/getcountry', [HrController::class, 'getcountry'])->name('getcountry');
        Route::post('/addcountry', [HrController::class, 'addcountry'])->name('addcountry');
        Route::get('/get-country-data/{id}', [HrController::class, 'getcountrydata'])->name('get-country-data');
        Route::get('/editcountry', [HrController::class, 'editcountry'])->name('editcountry');
        Route::get('/deletecountry', [HrController::class, 'deletecountry'])->name('deletecountry');

        Route::get('/states', [HrController::class, 'states'])->name('states');
        Route::get('/getstate', [HrController::class, 'getstate'])->name('getstate');
        Route::post('/addstate', [HrController::class, 'addstate'])->name('addstate');
        Route::get('/get-state-data/{id}', [HrController::class, 'getstatedata'])->name('get-state-data');
        Route::get('/editstate', [HrController::class, 'editstate'])->name('editstate');
        Route::get('/deletestate', [HrController::class, 'deletestate'])->name('deletestate');


        Route::get('/create-department', [HrController::class, 'createdepartment'])->name('create-department');
        Route::get('/create-category', [HrController::class, 'createcategory'])->name('create-category');
        Route::get('/create-branch', [HrController::class, 'createbranch'])->name('create-branch');
        Route::post('/addDepartment', [HrController::class, 'addDepartment'])->name('addDepartment');
        Route::post('/addCategory', [HrController::class, 'addCategory'])->name('addCategory');
        Route::post('/addBranch', [HrController::class, 'addBranch'])->name('addBranch');
        Route::get('/isDepartmentAvailable', [HrController::class, 'isDepartmentAvailable'])->name('isDepartmentAvailable');
        Route::get('/isCategoryAvailable', [HrController::class, 'isCategoryAvailable'])->name('isCategoryAvailable');
        Route::get('/isBranchAvailable', [HrController::class, 'isBranchAvailable'])->name('isBranchAvailable');

        Route::get('/edit-department-category-branch', [HrController::class, 'editdepartment'])->name('edit-department-category-branch');
        Route::get('/getdeptdata', [HrController::class, 'getdeptdata'])->name('getdeptdata');
        Route::get('/get-dept-data/{id}', [HrController::class, 'getdept_data'])->name('get-dept-data');
        Route::get('/editdept', [HrController::class, 'editdept'])->name('editdept');
        Route::get('/deletedepartment', [HrController::class, 'deletedepartment'])->name('deletedepartment');

        Route::get('/getcategorydata', [HrController::class, 'getcategorydata'])->name('getcategorydata');
        Route::get('/get-cat-data/{id}', [HrController::class, 'getcat_data'])->name('get-cat-data');
        Route::post('/editcat', [HrController::class, 'editcat'])->name('editcat');
        Route::get('/deletecategory', [HrController::class, 'deletecategory'])->name('deletecategory');

        Route::get('/getbranchdata', [HrController::class, 'getbranchdata'])->name('getbranchdata');
        Route::get('/get-branch-data/{id}', [HrController::class, 'getbranch_data'])->name('get-branch-data');
        Route::post('/editbranch', [HrController::class, 'editbranch'])->name('editbranch');
        Route::get('/deletebranch', [HrController::class, 'deletebranch'])->name('deletebranch');

        Route::get('/leave-entitle', [HrController::class, 'leaveentitle'])->name('leave-entitle');
        Route::get('/getLeaveEntitleList', [HrController::class, 'getLeaveEntitleList'])->name('getLeaveEntitleList');
        Route::post('/setannualentitle', [HrController::class, 'setannualentitle'])->name('setannualentitle');
        Route::post('/setmedicalentitle', [HrController::class, 'setmedicalentitle'])->name('setmedicalentitle');
        Route::post('/setmaxleaveallowentitle', [HrController::class, 'setmaxleaveallowentitle'])->name('setmaxleaveallowentitle');
        Route::post('/setholidayrestdaysetting', [HrController::class, 'setholidayrestdaysetting'])->name('setholidayrestdaysetting');

        Route::get('/edit-leave', [HrController::class, 'edit_Leave'])->name('edit-leave');
        Route::get('/getLeaveListForAdminFromTo', [HrController::class, 'getLeaveListForAdminFromTo'])->name('getLeaveListForAdminFromTo');
        Route::post('/cancelLeave', [LeaveApprovalsController::class, 'cancelLeave'])->name('cancelLeave');
        Route::post('/deletePastLeave', [LeaveApprovalsController::class, 'deletePastLeave'])->name('deletePastLeave');

        Route::get('/leave-replacement', [HrController::class, 'leaveReplacement'])->name('leave-replacement');
        Route::get('/get-replacement-data/{id}', [HrController::class, 'getreplacement_data'])->name('get-replacement-data');
        Route::post('/addLeaveAdjustment', [HrController::class, 'addLeaveAdjustment'])->name('addLeaveAdjustment');
        Route::post('/editreplacementleave', [HrController::class, 'editreplacementleave'])->name('editreplacementleave');
        Route::post('/deleteLeaveAdjustment', [HrController::class, 'deleteLeaveAdjustment'])->name('deleteLeaveAdjustment');
        Route::get('/leavereplacementexport', [HrController::class, 'leavereplacementexport'])->name('leavereplacementexport');
        Route::get('/leavereplacementpdf', [HrController::class, 'leavereplacementpdf'])->name('leavereplacementpdf');

        Route::get('/past-leave', [HrController::class, 'pastLeave'])->name('past-leave');
        Route::get('/getAllPastLeavesFromTo', [HrController::class, 'getAllPastLeavesFromTo'])->name('getAllPastLeavesFromTo');
        Route::get('/get-pastleave-data/{id}', [HrController::class, 'getpastleave_data'])->name('get-pastleave-data');
        Route::post('/addPastLeave', [HrController::class, 'addPastLeave'])->name('addPastLeave');
        Route::post('/editpastleave', [HrController::class, 'editpastleave'])->name('editpastleave');
        Route::post('/deletePastLeave', [HrController::class, 'deletePastLeave'])->name('deletePastLeave');
        Route::get('/getLeaveDaysCount', [HrController::class, 'getLeaveDaysCount'])->name('getLeaveDaysCount');
        Route::get('/getYearlyrlEntitleList', [HrController::class, 'getYearlyrlEntitleList'])->name('getYearlyrlEntitleList');

        Route::get('/compulsory-leave', [HrController::class, 'compulsoryLeave'])->name('compulsory-leave');
        Route::get('/getCompulsoryLeaveList', [HrController::class, 'getCompulsoryLeaveList'])->name('getCompulsoryLeaveList');
        Route::get('/addCompulsoryLeave', [HrController::class, 'addCompulsoryLeave'])->name('addCompulsoryLeave');
        Route::get('/get-compulsoryleave-data/{id}', [HrController::class, 'getcompulsoryleave_data'])->name('get-compulsoryleave-data');
        Route::get('/editCompulsoryLeave', [HrController::class, 'editCompulsoryLeave'])->name('editCompulsoryLeave');
        Route::post('/deleteCompulsoryLeave', [HrController::class, 'deleteCompulsoryLeave'])->name('deleteCompulsoryLeave');


        Route::get('/leave-control', [HrController::class, 'leaveControl'])->name('leave-control');

        Route::get('/getEscalateDuration', [HrController::class, 'getEscalateDuration'])->name('getEscalateDuration');
        Route::post('/setEscalateDuration', [HrController::class, 'setEscalateDuration'])->name('setEscalateDuration');

        Route::get('/getmaxpastleave', [HrController::class, 'getmaxpastleave'])->name('getmaxpastleave');
        Route::post('/setmaxpastleave', [HrController::class, 'setmaxpastleave'])->name('setmaxpastleave');

        Route::get('/getLeaveAdjustmentType', [HrController::class, 'getLeaveAdjustmentType'])->name('getLeaveAdjustmentType');
        Route::post('/setLeaveAdjustmentType', [HrController::class, 'setLeaveAdjustmentType'])->name('setLeaveAdjustmentType');

        Route::get('/getLeaveMultipleApprover', [HrController::class, 'getLeaveMultiple_Approver'])->name('getLeaveMultipleApprover');
        Route::post('/setLeaveMultipleApprover', [HrController::class, 'setLeaveMultipleApprover'])->name('setLeaveMultipleApprover');

        Route::get('/getActiveUserShown', [HrController::class, 'getActiveUserShown'])->name('getActiveUserShown');
        Route::post('/setActiveUserShown', [HrController::class, 'setActiveUserShown'])->name('setActiveUserShown');

        Route::get('/getConfirmDisplay', [HrController::class, 'getConfirmDisplay'])->name('getConfirmDisplay');
        Route::post('/setConfirmDisplay', [HrController::class, 'setConfirmDisplay'])->name('setConfirmDisplay');

        Route::get('/getClaimable_al_el', [HrController::class, 'getClaimable_al_el'])->name('getClaimable_al_el');
        Route::post('/setClaimable_al_el', [HrController::class, 'setClaimable_al_el'])->name('setClaimable_al_el');

        Route::get('/getCurrentYearLeaveDisplay', [HrController::class, 'getCurrentYearLeaveDisplay'])->name('getCurrentYearLeaveDisplay');
        Route::post('/setCurrentYearLeaveDisplay', [HrController::class, 'setCurrentYearLeaveDisplay'])->name('setCurrentYearLeaveDisplay');

        Route::get('/getSingleEmailSetting', [HrController::class, 'getSingleEmailSetting'])->name('getSingleEmailSetting');
        Route::post('/setSingleEmailSetting', [HrController::class, 'setSingleEmailSetting'])->name('setSingleEmailSetting');

        Route::get('/getNPL_TO_HR', [HrController::class, 'getNPL_TO_HR'])->name('getNPL_TO_HR');
        Route::post('/setNPL_TO_HR', [HrController::class, 'setNPL_TO_HR'])->name('setNPL_TO_HR');

        Route::get('/getApply_rl_to_hr', [HrController::class, 'getApply_rl_to_hr'])->name('getApply_rl_to_hr');
        Route::post('/setApply_rl_to_hr', [HrController::class, 'setApply_rl_to_hr'])->name('setApply_rl_to_hr');

        Route::get('/getCancel_leave_to_hr', [HrController::class, 'getCancel_leave_to_hr'])->name('getCancel_leave_to_hr');
        Route::post('/setCancel_leave_to_hr', [HrController::class, 'setCancel_leave_to_hr'])->name('setCancel_leave_to_hr');

        Route::get('/getIsMedicalLeavProrated', [HrController::class, 'getIsMedicalLeavProrated'])->name('getIsMedicalLeavProrated');
        Route::post('/setIsMedicalLeavProrated', [HrController::class, 'setIsMedicalLeavProrated'])->name('setIsMedicalLeavProrated');

        Route::get('/getIsMedicalClaimableProrated', [HrController::class, 'getIsMedicalClaimableProrated'])->name('getIsMedicalClaimableProrated');
        Route::post('/setIsMedicalClaimableProrated', [HrController::class, 'setIsMedicalClaimableProrated'])->name('setIsMedicalClaimableProrated');

        Route::get('/getIsMedicalLeaveBFAllow', [HrController::class, 'getIsMedicalLeaveBFAllow'])->name('getIsMedicalLeaveBFAllow');
        Route::post('/setIsMedicalLeaveBFAllow', [HrController::class, 'setIsMedicalLeaveBFAllow'])->name('setIsMedicalLeaveBFAllow');

        Route::get('/getIsRelieveAllow', [HrController::class, 'getIsRelieveAllow'])->name('getIsRelieveAllow');
        Route::post('/setIsRelieveAllow', [HrController::class, 'setIsRelieveAllow'])->name('setIsRelieveAllow');

        Route::get('/getWorkForEarn', [HrController::class, 'getWorkForEarn'])->name('getWorkForEarn');
        Route::post('/setWorkForEarn', [HrController::class, 'setWorkForEarn'])->name('setWorkForEarn');

        Route::get('/getpastLeaveCancel', [HrController::class, 'getpastLeaveCancel'])->name('getpastLeaveCancel');
        Route::post('/setpastLeaveCancel', [HrController::class, 'setpastLeaveCancel'])->name('setpastLeaveCancel');

        Route::get('/gethalfdayleave', [HrController::class, 'gethalfdayleave'])->name('gethalfdayleave');
        Route::get('/getApproveLeavePage', [HrController::class, 'getApproveLeavePage'])->name('getApproveLeavePage');

        Route::post('/sethalfdayleave', [HrController::class, 'sethalfdayleave'])->name('sethalfdayleave');
        Route::post('/setBFAdj', [HrController::class, 'setBFAdj'])->name('setBFAdj');

        Route::post('/setHourlyLeave', [HrController::class, 'setHourlyLeave'])->name('setHourlyLeave');
        Route::get('/getHourlyLeave', [HrController::class, 'getHourlyLeave'])->name('getHourlyLeave');

        Route::get('/getClaimablePreSet', [HrController::class, 'getClaimablePreSet'])->name('getClaimablePreSet');
        Route::post('/setClaimablePreSet', [HrController::class, 'setClaimablePreSet'])->name('setClaimablePreSet');

        Route::get('/getEmergencyLeaveSettings', [HrController::class, 'getEmergencyLeaveSettings'])->name('getEmergencyLeaveSettings');
        Route::post('/setEmergencyLeaveSettings', [HrController::class, 'setEmergencyLeaveSettings'])->name('setEmergencyLeaveSettings');

        Route::get('/getReplacementDuration', [HrController::class, 'getReplacementDuration'])->name('getReplacementDuration');
        Route::post('/setReplacementDuration', [HrController::class, 'setReplacementDuration'])->name('setReplacementDuration');

        Route::get('/getBFDuration', [HrController::class, 'getBFDuration'])->name('getBFDuration');
        Route::post('/setBFDuration', [HrController::class, 'setBFDuration'])->name('setBFDuration');

        Route::get('/getBFAdjDuration', [HrController::class, 'getBFAdjDuration'])->name('getBFAdjDuration');
        Route::post('/setBFAdjDuration', [HrController::class, 'setBFAdjDuration'])->name('setBFAdjDuration');
        Route::post('/updateBroughtForwardCategory', [HrController::class, 'updateBroughtForwardCategory'])->name('updateBroughtForwardCategory');
        Route::post('/approveleaveDisplayUpdate', [HrController::class, 'approveleaveDisplayUpdate'])->name('approveleaveDisplayUpdate');
        Route::post('/leaveNameUpdate', [HrController::class, 'leaveNameUpdate'])->name('leaveNameUpdate');

        Route::get('/getNames', [HrController::class, 'getNames'])->name('getNames');
        Route::get('/getBroughtForwardList', [HrController::class, 'getBroughtForwardList'])->name('getBroughtForwardList');
        Route::get('/getLeaveName', [HrController::class, 'getLeaveName'])->name('getLeaveName');
        Route::get('/getcalendarcolor', [HrController::class, 'getcalendarcolor'])->name('getcalendarcolor');

        Route::get('/rest-day', [HrController::class, 'restday'])->name('rest-day');
        Route::get('/apr-rest-day', [HrController::class, 'aprrestday'])->name('apr-rest-day');

        Route::post('/addRestDay', [HrController::class, 'addRestDay'])->name('addRestDay');
        Route::get('/editMapCategoryEmployee', [HrController::class, 'editMapCategoryEmployee'])->name('editMapCategoryEmployee');
        Route::get('/removeMapping', [HrController::class, 'removeMapping'])->name('removeMapping');
        Route::get('/getRestDayUserList', [HrController::class, 'getRestDayUserList'])->name('getRestDayUserList');
        Route::get('/getRestDayCategoriesdatatable', [HrController::class, 'getRestDayCategoriesdatatable'])->name('getRestDayCategoriesdatatable');
        Route::get('/getCategoryMapping', [HrController::class, 'getCategoryMapping'])->name('getCategoryMapping');
        Route::get('/get-categorymapping-data/{id}', [HrController::class, 'getcategorymapping_data'])->name('get-categorymapping-data');
        Route::get('/add-edit-holiday', [HrController::class, 'add_edit_holiday'])->name('add-edit-holiday');
        Route::get('/holidays-list', [HrController::class, 'holidays'])->name('holidays-list');
        Route::get('/get-holiday-data/{id}', [HrController::class, 'getholidaydata'])->name('get-holiday-data');
        Route::get('/deleteholiday', [HrController::class, 'deleteholiday'])->name('deleteholiday');
        Route::get('/create-holiday', [HrController::class, 'createholiday'])->name('create-holiday');
        Route::post('/addHoliday', [HrController::class, 'addHoliday'])->name('addHoliday');
        Route::post('/updateWithDateAndDescription', [HrController::class, 'updateWithDateAndDescription'])->name('updateWithDateAndDescription');

        Route::get('/hr-apply-on-behalf', [HrController::class, 'hrapplyonbehalf'])->name('hr-apply-on-behalf');
        Route::get('/getAllUsersForHR', [HrController::class, 'getAllUsersForHR'])->name('getAllUsersForHR');
        Route::post('/addLeaveByApprover', [LeaveApprovalsController::class, 'addLeaveByApprover'])->name('addLeaveByApprover');
        Route::post('/calender-filter12', [MyLeaveController::class, 'holidayFilter12'])->name('calender.filter12');

        Route::get('/getPublicHolidaysWithStates', [HrController::class, 'getPublicHolidaysWithStates'])->name('getPublicHolidaysWithStates');
        Route::post('addNextYearPHoliday', [HrController::class, 'addNextYearPHoliday'])->name('addNextYearPHoliday');
        Route::post('holidaySubscribe', [HrController::class, 'holidaySubscribe'])->name('holidaySubscribe');
        Route::post('holidayUnsubscribe', [HrController::class, 'holidayUnsubscribe'])->name('holidayUnsubscribe');

        Route::get('/race-category', [HrController::class, 'racecategory'])->name('race-category');
        Route::get('/getrace', [HrController::class, 'getrace'])->name('getrace');
        Route::post('/addrace', [HrController::class, 'addrace'])->name('addrace');
        Route::get('/get-race-data/{id}', [HrController::class, 'getracedata'])->name('get-race-data');
        Route::get('/editrace', [HrController::class, 'editrace'])->name('editrace');
        Route::get('/deleterace', [HrController::class, 'deleterace'])->name('deleterace');
        Route::get('/getcategory', [HrController::class, 'getcategory'])->name('getcategory');
        Route::post('/add-category', [HrController::class, 'add_category'])->name('add-category');
        Route::get('/get-category-data/{id}', [HrController::class, 'get_categorydata'])->name('get-category-data');
        Route::get('/edit-category', [HrController::class, 'edit_category'])->name('edit-category');
        Route::get('/delete-category', [HrController::class, 'delete_category'])->name('delete-category');

        Route::get('/send-edit-message', [HrController::class, 'sendEditMessage'])->name('send-edit-message');
        Route::post('/sendMessage', [HrController::class, 'sendMessage'])->name('sendMessage');
        Route::get('/getSentMessages', [HrController::class, 'getSentMessages'])->name('getSentMessages');
        Route::post('/deleteSentMessage', [HrController::class, 'deleteSentMessage'])->name('deleteSentMessage');
        Route::get('/get-message-data/{id}', [HrController::class, 'getSingleSentMessage'])->name('get-message-data');
        Route::get('/ubspayrollpath', [SettingsController::class, 'ubspayrollpath'])->name('ubspayrollpath');


        Route::post('/importDBFFile', [HrController::class, 'importDBFFile'])->name('importDBFFile');
        Route::get('/settings', [SettingsController::class, 'settings'])->name('settings');
        Route::get('/email-server', [SettingsController::class, 'email_server'])->name('email-server');
        Route::post('/updatemailsetting', [SettingsController::class, 'updatemailsetting'])->name('updatemailsetting');
        Route::get('/smssettings', [SettingsController::class, 'smssetting'])->name('smssettings');
        Route::post('/updatesmssetings', [SettingsController::class, 'updatesmssetings'])->name('updatesmssetings');
        Route::get('/companydetails', [SettingsController::class, 'companydetails'])->name('companydetails');
        Route::post('/updatecompany', [SettingsController::class, 'updatecompany'])->name('updatecompany');
        Route::get('/companylogo', [SettingsController::class, 'companylogo'])->name('companylogo');
        Route::post('/companylogoshow', [SettingsController::class, 'companylogoshow'])->name('companylogoshow');
        Route::post('/updatecompanylogo', [SettingsController::class, 'updatecompanylogo'])->name('updatecompanylogo');
        Route::get('/softwaresettings', [SettingsController::class, 'softwaresettings'])->name('softwaresettings');
        Route::post('/updatesoftwaresettings', [SettingsController::class, 'updatesoftwaresettings'])->name('updatesoftwaresettings');
        Route::get('/staticmessage', [SettingsController::class, 'staticmessage'])->name('staticmessage');
        Route::post('/updatestaticmessage', [SettingsController::class, 'updatestaticmessage'])->name('updatestaticmessage');
        Route::post('/getAllUsersNameSort', [SettingsController::class, 'getAllUsersNameSort'])->name('getAllUsersNameSort');
        Route::post('/getPreferences', [SettingsController::class, 'getPreferences'])->name('getPreferences');
        Route::post('/addPreferenceWD', [SettingsController::class, 'addPreferenceWD'])->name('addPreferenceWD');
        Route::post('/deletePreferenceWD', [SettingsController::class, 'deletePreferenceWD'])->name('deletePreferenceWD');
        Route::post('/getEmailContentPrefernce', [SettingsController::class, 'getEmailContentPrefernce'])->name('getEmailContentPrefernce');
        Route::post('/getUserLi', [SettingsController::class, 'getUserLi'])->name('getUserLi');
        Route::post('/setEmailContentPrefernce', [SettingsController::class, 'setEmailContentPrefernce'])->name('setEmailContentPrefernce');
        Route::post('/deleteEmailContentPrefernceWD', [SettingsController::class, 'deleteEmailContentPrefernceWD'])->name('deleteEmailContentPrefernceWD');
        Route::post('/getAllUser', [SettingsController::class, 'getAllUser'])->name('getAllUser');
        Route::post('/addsmsPreference', [SettingsController::class, 'addsmsPreference'])->name('addsmsPreference');
        Route::post('/getsmsPreferences', [SettingsController::class, 'getsmsPreferences'])->name('getsmsPreferences');
        Route::post('/deletePreference', [SettingsController::class, 'deletePreference'])->name('deletePreference');

        Route::get('/permission', [SettingsController::class, 'access_management'])->name('permission');
        Route::get('/isPermissionGroupExist', [SettingsController::class, 'isPermissionGroupExist'])->name('isPermissionGroupExist');
        Route::post('/addPermissionGroup', [SettingsController::class, 'addPermissionGroup'])->name('addPermissionGroup');
        Route::get('/getPermissionList', [SettingsController::class, 'getPermissionList'])->name('getPermissionList');
        Route::get('/get-permission-data/{id}', [SettingsController::class, 'getPermissiondata'])->name('get-permission-data');
        Route::post('/editPermissionGroup', [SettingsController::class, 'editPermissionGroup'])->name('editPermissionGroup');
        Route::post('/deletePermissionGroup', [SettingsController::class, 'deletePermissionGroup'])->name('deletePermissionGroup');

        Route::get('/userlist', [SettingsController::class, 'edituser'])->name('userlist');
        Route::get('/edituserdetails', [SettingsController::class, 'edituserdetails'])->name('edituserdetails');
        Route::get('/getPermissionGroupOfuser', [SettingsController::class, 'getPermissionGroupOfuser'])->name('getPermissionGroupOfuser');
        Route::get('/update-user/{id}', [SettingsController::class, 'updateuser'])->name('updateuser');
        Route::get('/getPermissionGroupOfuse', [SettingsController::class, 'getPermissionGroupOfuse'])->name('getPermissionGroupOfuse');
        Route::get('/deleteuserlist', [SettingsController::class, 'deleteuserli'])->name('deleteuserlist');
        Route::get('/deleteuserlisted', [SettingsController::class, 'deleteuserlisted'])->name('deleteuserlisted');
        Route::post('/deleteUserper', [SettingsController::class, 'deleteUserper'])->name('deleteUserper');
        Route::post('/recoverselected', [SettingsController::class, 'recoverselected'])->name('recoverselected');
        Route::post('/restore', [SettingsController::class, 'restore'])->name('restore');
        Route::get('/restore', [SettingsController::class, 'viewrestore'])->name('viewrestore');
        Route::get('/backup', [SettingsController::class, 'viewbackup'])->name('viewbackup');
        Route::post('/backup', [SettingsController::class, 'backup'])->name('backup');
        Route::get('/user-pdf', [HrController::class, 'downloaduserPDF'])->name('user-pdf');
        Route::get('/user-export', [HrController::class, 'userexport'])->name('user-export');



        Route::post('/deleteRLeave', [LeaveApprovalsController::class, 'deleteRLeave'])->name('deleteRLeave');
        Route::post('/RLeaveStatus', [LeaveApprovalsController::class, 'RLeaveStatus'])->name('RLeaveStatus');
        Route::post('/rejectRLeave', [LeaveApprovalsController::class, 'rejectRLeave'])->name('rejectRLeave');

        Route::get('/duty-roster', [MyLeaveController::class, 'getDutyRoster'])->name('duty-roster');
        Route::get('/calender.filter14', [MyLeaveController::class, 'holidayFilter14'])->name('calender.filter14');

        Route::get('/getjoinresign', [HrController::class, 'getjoinresign'])->name('getjoinresign');
        Route::post('/setmdbf', [HrController::class, 'setmdbf'])->name('setmdbf');
        Route::get('/getRLList', [HrController::class, 'getRLList'])->name('getRLList');
        Route::get('/getBFList', [HrController::class, 'getBFList'])->name('getBFList');
        Route::get('/getBFAdjList', [HrController::class, 'getBFAdjList'])->name('getBFAdjList');
        Route::get('/getclaimablepresetList', [HrController::class, 'getclaimablepresetList'])->name('getclaimablepresetList');
        Route::get('/getemergencyleaveList', [HrController::class, 'getemergencyleaveList'])->name('getemergencyleaveList');
        Route::get('/getmaxpastleaveList', [HrController::class, 'getmaxpastleaveList'])->name('getmaxpastleaveList');

        Route::get('/aduty-roster', [MyLeaveController::class, 'getDutyRoster'])->name('aduty-roster');
        Route::get('/get-categorymapping-data11/{id}', [HrController::class, 'getcategorymapping_data11'])->name('get-categorymapping-data11');

        Route::get('/sendemail', [HrController::class, 'sendemail'])->name('sendemail');
        Route::get('empPermissionData', [HrController::class, 'empPermissionData'])->name('empPermissionData');
        Route::get('unassigedPermission', [HrController::class, 'unassigedPermission'])->name('unassigedPermission');
        Route::post('updateUserPermission', [HrController::class, 'updateUserPermission'])->name('updateUserPermission');
        
        
    });
   
    Route::get('/getLeaveAdjustmentList', [HrController::class, 'getLeaveAdjustmentList'])->name('getLeaveAdjustmentList');
    Route::get('/getreportdata', [ReportController::class, 'getreportdata'])->name('get-report-data');
    Route::get('/reports/getremployeedata', [HrController::class, 'getremployeedata'])->name('getremployeedata');
    Route::get('/reports/getrdeptdata', [HrController::class, 'getrdeptdata'])->name('getrdeptdata');
    Route::get('/reports/getrcategorydata', [HrController::class, 'getrcategorydata'])->name('getrcategorydata');
    Route::get('/reports/getrbranchdata', [HrController::class, 'getrbranchdata'])->name('getrbranchdata');
    Route::get('/reports/getrleavedata', [HrController::class, 'getrleavedata'])->name('getrleavedata');
    Route::get('/reports/getrholidaydata', [HrController::class, 'getrholidaydata'])->name('getrholidaydata');
    Route::get('/reports/getrannualentitledata', [HrController::class, 'getrannualentitledata'])->name('getrannualentitledata');
    Route::get('/reports/getrmedicalentitledata', [HrController::class, 'getrmedicalentitledata'])->name('getrmedicalentitledata');
    Route::get('/reports/getrrlentitledata', [HrController::class, 'getrrlentitledata'])->name('getrrlentitledata');
    Route::get('/reports/getYearlyEntitleListHR', [HrController::class, 'getYearlyEntitleListHR'])->name('getYearlyEntitleListHR');
    Route::get('/getleavesummarydata', [HrController::class, 'getleavesummarydata'])->name('getleavesummarydata');

    Route::get('/getotherleavereportdata', [HrController::class, 'getotherleavereportdata'])->name('getotherleavereportdata');

    Route::get('/annualentitleapi', [NewEntitleApiController::class, 'annualentitleapi'])->name('annualentitleapi');

    Route::get('/newannualentitle', [NewEntitleApiController::class, 'rannualentitle'])->name('newannualentitle');

    Route::get('/leaveType', [LeaveApprovalsController::class, 'leaveType'])->name('leaveType');
    
    Route::get('/send_dailyemail_t', [HrController::class, 'sendDailyEmailT'])->name('send_dailyemail_t');
    Route::get('/send_email_today_leave_suers', [HrController::class, 'sendEmailTodayLeaveSuser'])->name('send_email_today_leave_suers');
    Route::get('/Send2DaysBeforeEmail', [HrController::class, 'Send2DaysBeforeEmail'])->name('Send2DaysBeforeEmail');
    
    // audit for leave
    Route::get('/reports/leaveAuditData', [HrController::class, 'leaveAuditData'])->name('leaveAuditData');
    Route::get('/reports/leaveAuditExport', [HrController::class, 'leaveAuditExport'])->name('leaveAuditExport');
    Route::get('/reports/leaveAuditPdf', [HrController::class, 'leaveAuditPdf'])->name('leaveAuditPdf');
    
});

Route::post('/apply-on-behalf', [LeaveApprovalsController::class, 'applyonbehalf'])->name('applyonbehalf');
Route::post('/apply-self-leave', [MyLeaveController::class, 'applySelfLeave'])->name('applySelfLeave');
Route::post('/remaining-days', [MyLeaveController::class, 'remainingDays'])->name('remainingDays');
Route::post('/remaining-days11', [MyLeaveController::class, 'remainingDays11'])->name('remainingDays11');


// hide and show columns setting
Route::get('hide-show-columns', [EattendanceController::class, 'hideShowSetting'])->name('hide-show-columns');
Route::get('hide-show-data', [EattendanceController::class, 'hideShowData'])->name('hide-show-data');

