    <?php echo e(View::make('layout.header')); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Dashboard</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                    <div class="form-group breadcrumb-right">
                        <button class="btn btn-primary btn-block waves-effect waves-float waves-light" data-toggle="modal" data-target="#inlineForm">Apply For Leave</button>
                    </div>
                </div>
                <?php if(session()->has('message')): ?>
                <div class="alert alert-success">
                <?php echo e(session()->get('message')); ?>

                </div>
                <?php endif; ?> 
                <?php if(session()->has('danger')): ?>
                <div class="alert alert-danger">
                <?php echo e(session()->get('danger')); ?>

                </div>
                <?php endif; ?> 

            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">

                        <!-- Statistics Card -->
                        <div class="col-xl-8 col-md-6 col-12">
                            <div class="card card-statistics" style="flex: 0;">
                                <div class="card-header">
                                    <h4 class="card-title">My Annual Leaves</h4>
                                </div>
                                <div class="card-body statistics-body">
                                    <div class="row">
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-primary mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="thumbs-up" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">20</h4>
                                                    <p class="card-text font-small-3 mb-0">Claimable</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                            <div class="media">
                                                <div class="avatar bg-light-info mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">10</h4>
                                                    <p class="card-text font-small-3 mb-0">Balance</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                            <div class="media">
                                                <div class="avatar bg-light-danger mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">5</h4>
                                                    <p class="card-text font-small-3 mb-0">Taken</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-sm-6 col-12">
                                            <div class="media">
                                                <div class="avatar bg-light-success mr-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="calendar" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="media-body my-auto">
                                                    <h4 class="font-weight-bolder mb-0">5</h4>
                                                    <p class="card-text font-small-3 mb-0">Pending</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <!-- Revenue Report Card -->
                        <div class="">
                            <div class="card card-revenue-budget">
                                <div class="row mx-0">
                                    <div class="col-md-12 col-12 revenue-report-wrapper">
                                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                            <h4 class="card-title mb-50 mb-sm-0">My Leaves</h4>
                                            <div class="d-flex align-items-center">
                                                <div class="d-flex align-items-center mr-2">
                                                    <span class="bullet bullet-primary font-small-3 mr-50 cursor-pointer"></span>
                                                    <span>Approved</span>
                                                </div>
                                                <div class="d-flex align-items-center ml-75">
                                                    <span class="bullet bullet-warning font-small-3 mr-50 cursor-pointer"></span>
                                                    <span>Pending</span>
                                                </div>

                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Last 12 Months
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Last 3</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Last 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Last Month</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="revenue-report-chart"></div>
                                        <style type="text/css">
                                            .table th, .table td {padding: 8px;}
                                        </style>
                                <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>REASON</th>
                                            <th>TYPE</th>
                                            <th>LEAVE DATE</th>
                                            <th>APPLIED ON</th>
                                            <th>STATUS</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($leave->reason); ?></td>
                                            <td><?php echo e($leave->type); ?></td>
                                            <td><?php echo e($leave->start_date); ?></td>
                                            <td><?php echo e($leave->date_applied); ?></td>
                                            <td><span class="text-success"><?php echo e($leave->status); ?></span></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <center> <a href="#" class="btn btn-primary">View All</a> </center>
                            </div>
                                    </div>                                    
                                </div>
                            </div>
                        </div>
                        <!--/ Revenue Report Card -->
                        </div>
                        <!--/ Statistics Card -->
                        <!-- Medal Card -->
                        <div class="col-lg-4 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        
                                        <h4 class="card-title"> Upcoming Holidays</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="timeline ml-50">
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <h6>15-08-1947</h6>
                                                <p>Independance Day</p>
                                            </div>
                                        </li>
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <h6>15-08-1947</h6>
                                                <p>Independance Day</p>
                                            </div>
                                        </li>
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <h6>15-08-1947</h6>
                                                <p>Independance Day</p>
                                            </div>
                                        </li>
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <h6>15-08-1947</h6>
                                                <p>Independance Day</p>
                                            </div>
                                        </li>
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <h6>15-08-1947</h6>
                                                <p>Independance Day</p>
                                            </div>
                                        </li>
                                    </ul>
                                    <center><a href="#" class="btn btn-primary btn-block"> View All Holidays</a></center>
                                </div>
                            </div>

                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        
                                        <h4 class="card-title"> My Leaves Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Annual</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Medical</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-danger" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Marriage</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-warning" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Compassionate</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-success" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>                                     
                                    </div>
                                    <center><a href="#" class="btn btn-primary btn-block"> View All</a></center>
                                </div>
                            </div>
                        </div>
                        <!--/ Medal Card -->
                    </div>
                    <div class="row match-height">
                        <div class="col-md-5">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Last Pay Slip</h4>
                                </div>
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>S NO.</th>
                                                <th>DATE</th>
                                                <th>AMOUNT</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>01</td>
                                                <td>07-05-2021</td>
                                                <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                            </tr>
                                            <tr>
                                                <td>02</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                            </tr>
                                            <tr>
                                                <td>03</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                            </tr>
                                            <tr>
                                                <td>04</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                            </tr>
                                            <tr>
                                                <td>05</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <center> <a href="#" class="btn btn-primary">View All</a> </center>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">My Claims</h4>
                                </div>
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>CLAIM TYPE</th>
                                                <th>DATE</th>
                                                <th>AMOUNT</th>
                                                <th>STATUS</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Petrol</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                                <td><p class="text-success">Approved</p></td>
                                            </tr>
                                            <tr>
                                                <td>Petrol</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                                <td><p class="text-warning">Pending</p></td>
                                            </tr>
                                            <tr>
                                                <td>Petrol</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                                <td><p class="text-danger">Rejected</p></td>
                                            </tr>
                                            <tr>
                                                <td>Petrol</td>
                                                <td>07-05-2021</td>
                                                 <td> <i class="fa fa-rupee"></i> 1000.00</td>
                                                <td><p class="text-success">Approved</p></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <center> <a href="#" class="btn btn-primary">View All</a> </center>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Ecommerce ends -->

            </div>
        </div>
    </div>
    <!-- END: Content-->
    <?php echo e(View::make('layout.footer')); ?>



                                            <!-- Modal -->
                                            <div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="myModalLabel33">Apply For Leave</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="<?php echo e(route('applyforleave')); ?>" method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="user_id" value="<?php echo e(Auth::guard('user')->id()); ?>">
                                                            <div class="modal-body">
                                                                <label>Leave Type </label>
                                                                <div class="form-group">
                                                                   <select class="form-control" name="leave_type" required="">
                                                                       <option value="">Select Leave Type</option>
                                                                       <?php $__currentLoopData = $leavetypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leavetype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                       <option value="<?php echo e($leavetype->name); ?>"><?php echo e($leavetype->name); ?></option>
                                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                   </select>
                                                                </div>

                                                                <label>Half Or Full Day</label>
                                                                <div class="form-group">
                                                                   <input type="radio" name="hof" value="f" required="" checked onclick="showenddate()"> Full Day 
                                                                   <input type="radio" name="hof" value="h" onclick="hideenddate()"> Half Day 
                                                                </div>
                                                                <label>Leave Start Date</label>
                                                                <div class="form-group">
                                                                    <input type="text" name="leave_start_date" class="form-control" id="datepicker1" placeholder="Leave Start Date" required="" autocomplete="off">
                                                                </div>
                                                                <div id="end_date">
                                                                <label>Leave End Date</label>
                                                                <div class="form-group">
                                                                    <input type="text" name="leave_end_date" class="form-control" id="datepicker2" placeholder="Leave End Date"  autocomplete="off" >
                                                                </div>
                                                                </div>
                                                                <label>Reason</label>
                                                                <div class="form-group">
                                                                    <textarea class="form-control" name="reason" placeholder="Type here" required></textarea>
                                                                </div>
                                                                <label>Relieve</label>
                                                                <div class="form-group">
                                                                    <select class="form-control" name="relieve" required >
                                                                        <option value="">Select Relieve</option>
                                                                        <?php $__currentLoopData = $relieves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relieve): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($relieve->name); ?>"><?php echo e($relieve->name); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary">Apply Leave Request</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <script type="text/javascript">
                                            function showenddate() {
                                                document.getElementById('end_date').style.display='block';
                                            }
                                            function hideenddate() {
                                                document.getElementById('end_date').style.display='none';
                                            }
                                        </script>
<?php /**PATH C:\xampp\htdocs\ECL\resources\views/E-Leave/dashboard.blade.php ENDPATH**/ ?>