<?php echo e(View::make('layout.header')); ?>


<style>
    .bootstrapWizard {
        display: block;
        list-style: none;
        padding: 0;
        position: relative;
        width: 100%
    }

    .bootstrapWizard a:active,
    .bootstrapWizard a:focus,
    .bootstrapWizard a:hover {
        text-decoration: none
    }

    .bootstrapWizard li {
        display: block;
        float: left;
        width: 25%;
        text-align: center;
        padding-left: 0
    }

    .bootstrapWizard li:before {
        border-top: 2px solid #55606E;
        content: "";
        display: block;
        font-size: 0;
        overflow: hidden;
        position: relative;
        top: 23px;
        right: 1px;
        width: 100%;
        z-index: 1
    }

    .bootstrapWizard li:first-child:before {
        left: 50%;
        max-width: 50%
    }

    .bootstrapWizard li:last-child:before {
        max-width: 50%;
        width: 50%
    }

    .bootstrapWizard li.complete .step {
        background: #0aa66e !important;
        padding: 7px 7px !important;
        border: 2px solid #55606E !important;
    }

    .bootstrapWizard li .step i {
        font-size: 19px;
        font-weight: 400;
        position: relative;
        top: 1.5px
    }

    .bootstrapWizard li .step {
        background: #B2B5B9;
        color: #fff;
        display: inline;
        font-size: 15px;
        font-weight: 700;
        border: 2px solid transparent;
        border-radius: 50%;
        line-height: normal;
        position: relative;
        text-align: center;
        z-index: 2;
        transition: all .1s linear 0s;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        width: 40px;
        height: 40px;
        padding: 0px;
    }

    .bootstrapWizard li.active .step,
    .bootstrapWizard li.active.complete .step {
        background: #7367F0;
        color: #fff;
        font-weight: 700;
        padding: 7px 13px;
        font-size: 15px;
        border-radius: 50%;
        border: 2px solid #55606E
    }

    .bootstrapWizard li.active .title,
    .bootstrapWizard li.complete .title {
        color: #2B3D53
    }

    .bootstrapWizard li .title {
        color: #bfbfbf;
        display: block;
        font-size: 13px;
        line-height: 15px;
        max-width: 100%;
        position: relative;
        table-layout: fixed;
        text-align: center;
        top: 20px;
        word-wrap: break-word;
        z-index: 1
    }

    .wizard-actions {
        display: block;
        list-style: none;
        padding: 0;
        position: relative;
        width: 100%
    }

    .wizard-actions li {
        display: inline
    }

    .help-block {
        display: block;
        color: red;
    }

    .alert-danger {
        margin-top: 15px;
        border-color: #ea5455;
        color: #fff !important;
        background-color: #ea5455 !important;
        text-shadow: none;
        opacity: 1 !important;
        padding: 15px;

    }

    .alert-danger .close {
        color: #fff !important;
        opacity: 1 !important;
        margin-top: -4px !important;
    }

    .alert-success {
        margin-top: 15px;
        border-color: #28c76f;
        color: #fff !important;
        background-color: #28c76f !important;
        text-shadow: none;
        opacity: 1 !important;
        padding: 15px;

    }

    .alert-success .close {
        color: #fff !important;
        opacity: 1 !important;
        margin-top: -4px !important;
    }

    .disabled a,
    .completed a {
        opacity: 0.7 !important;
        cursor: not-allowed !important;

        box-shadow: 0 8px 25px -8px transparent !important;
    }

    .disabled .btn-primary:focus,
    .btn-primary:active,
    .btn-primary.active {
        background: transparent !important;
    }

    #employeeno,
    #icno_new,
    #branch,
    #department,
    #category,
    .emp-required,
    #approver1 {
        background-color: #FFFFE0 !important;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-5">
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb mt-2">
                                <li class="breadcrumb-item">HR
                                </li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('setup')); ?>">Setup</a>
                                </li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('edit-employee')); ?>">Employees</a></li>
                                <li class="breadcrumb-item active"><a href="#">Edit Employee</a>
                                </li>

                            </ol>
                        </div>
                    </div>
                    <div class="col-7">
                        <div class="form-bootstrapWizard">
                            <ul class="bootstrapWizard form-wizard">
                                <li class="active" data-target="#step1">
                                    <a href="#tab1" data-toggle="tab"> <span class="step">1</span> <span
                                            class="title">Personal Details</span> </a>
                                </li>
                                <li data-target="#step2">
                                    <a href="#tab2" data-toggle="tab"> <span class="step">2</span> <span
                                            class="title">Pay</span> </a>
                                </li>
                                <li data-target="#step3">
                                    <a href="#tab3" data-toggle="tab"> <span class="step">3</span> <span
                                            class="title">Third</span> </a>
                                </li>
                                <li data-target="#step4">
                                    <a href="#tab4" data-toggle="tab"> <span class="step">4</span> <span
                                            class="title">Mapping</span> </a>
                                </li>
                            </ul>
                            <div class="clearfix"></div>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- Horizontal Wizard -->
            <section class="horizontal-wizard">
                <article class="col-sm-12 col-md-12 col-lg-12">
                    <!-- Widget ID (each widget will need unique ID)-->
                    <div class="jarviswidget jarviswidget-color-darken" id="wid-id-0" data-widget-editbutton="false"
                        data-widget-deletebutton="false">

                        <!-- widget div-->
                        <div>
                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->
                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body">
                                <div class="row">
                                    <form id="wizard-1" novalidate="novalidate" method="post"
                                        onsubmit="return false;">
                                        <div id="bootstrap-wizard-1" class="col-sm-12">

                                            <div class="tab-content">
                                                <div class="tab-pane active" id="tab1">
                                                    <br>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Personal Details</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Employee No &nbsp;:</label>
                                                                        <input type="text" name="employeeno"
                                                                            id="employeeno" value=""
                                                                            onblur="checkempno(this.value);"
                                                                            class="form-control emp-required" />
                                                                        <div id="message1"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Employee Code &nbsp;:</label>
                                                                        <input type="text" name="employeecode"
                                                                            id="employeecode" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Employee Name &nbsp;:</label>
                                                                        <input type="text" name="employeename"
                                                                            id="employeename" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Address &nbsp;:</label>
                                                                        <input type="text" name="address"
                                                                            id="address" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Postcode &nbsp;:</label>
                                                                        <input type="text" name="postcode"
                                                                            id="postcode" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Town &nbsp;:</label>
                                                                        <input type="text" name="town"
                                                                            id="town" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Nationality &nbsp;:</label>
                                                                        <select class="form-control" id="nationality"
                                                                            onchange="getState()">
                                                                            <?php for ($i = 0; $i < count($countries); $i++) {
                                                                                echo '<option value="' . $countries[$i]->country . '">' . $countries[$i]->country . '</option>';
                                                                            } ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>State &nbsp;:</label>
                                                                        <select class="form-control" name="state"
                                                                            id="state">
                                                                            <option vlaue="">Select State
                                                                            </option>

                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Phone No &nbsp;:</label>
                                                                        <input type="text" name="phoneno"
                                                                            id="phoneno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date of Birth &nbsp;:</label>
                                                                        <input type="date" name="dob"
                                                                            id="dob" value=""
                                                                            class="form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Highest Education &nbsp;:</label>
                                                                        <input type="text" name="education"
                                                                            id="education" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Working Experience &nbsp;:</label>
                                                                        <input type="text" name="experience"
                                                                            id="experience" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>I/C No. (Old) &nbsp;:</label>
                                                                        <input type="text" name="icno_old"
                                                                            id="icno_old" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>I/C No. (New) &nbsp;:</label>
                                                                        <input type="text" name="icno_new"
                                                                            id="icno_new" value=""
                                                                            onblur="checkicnew(this.value);"
                                                                            class="form-control emp-required" />
                                                                        <span id="message2"></span>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>I/C Color &nbsp;:</label>
                                                                        <input type="text" name="ic_color"
                                                                            id="ic_color" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Passport No. &nbsp;:</label>
                                                                        <input type="text" name="passportno"
                                                                            id="passportno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Gender &nbsp;:</label>
                                                                        <select class="form-control" name="sex"
                                                                            id="sex">
                                                                            <option value="1">Male</option>
                                                                            <option value="0">Female</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Race &nbsp;:</label>
                                                                        <select class="form-control" id="race"
                                                                            name="race">

                                                                            <?php $__currentLoopData = $race; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($rc->race); ?>">
                                                                                    <?php echo e($rc->race); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Bumiputra &nbsp;:</label>
                                                                        <select class="form-control" name="bumiputra"
                                                                            id="bumiputra">
                                                                            <option value="1">Yes</option>
                                                                            <option value="0">No</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Marital Status &nbsp;:</label>
                                                                        <select class="form-control"
                                                                            name="maritalstatus" id="maritalstatus">
                                                                            <option value="Single">Single</option>
                                                                            <option value="Married">Married</option>
                                                                            <option value="Other">Other</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Email ID &nbsp;:</label>
                                                                        <input type="text" name="email"
                                                                            id="email_id" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>User Role &nbsp;:</label>
                                                                        <div id="list_permission"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Blood Group &nbsp;:</label>
                                                                        <input type="text" name="blood_group"
                                                                            id="blood_group" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Spouse Particular</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Spouse Name &nbsp;:</label>
                                                                        <input type="text" name="spousename"
                                                                            id="spousename" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Sp. I/C No &nbsp;:</label>
                                                                        <input type="text" name="spic_no"
                                                                            id="spic_no" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>No. of children &nbsp;:</label>
                                                                        <input type="text" name="childern"
                                                                            id="childern" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Spouse Working &nbsp;:</label>
                                                                        <select class="form-control"
                                                                            name="spouseworking" id="spouseworking">
                                                                            <option value="No">No</option>
                                                                            <option value="Yes">Yes</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Permanent Address/Contact</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Name &nbsp;:</label>
                                                                        <input type="text" name="adname"
                                                                            id="adname" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Address &nbsp;:</label>
                                                                        <input type="text" name="paddress"
                                                                            id="paddress" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Phone No &nbsp;:</label>
                                                                        <input type="text" name="pphno"
                                                                            id="pphno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="tab-pane" id="tab2">
                                                    <br>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Personal Details</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Branch &nbsp;:</label>
                                                                        <select class="form-control emp-required"
                                                                            name="pbranch" id="pbranch"></select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Department &nbsp;:</label>
                                                                        <select class="form-control emp-required"
                                                                            name="pdepartment"
                                                                            id="pdepartment"></select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Category &nbsp;:</label>
                                                                        <select class="form-control emp-required"
                                                                            name="pcategory" id="pcategory"></select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Employee Type &nbsp;:</label>
                                                                        <select class="form-control"
                                                                            name="employee_type"
                                                                            id="employee_type"></select>
                                                                        <!--<input type="text" name="employee_type" id="employee_type" value="" class="form-control" />-->
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date Commence &nbsp;:</label>
                                                                        <input type="date" name="commence"
                                                                            id="commence" value=""
                                                                            class="emp-required form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date Confirmed &nbsp;:</label>
                                                                        <input type="date" name="confirmed"
                                                                            id="confirmed" value=""
                                                                            class="form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date Promoted &nbsp;:</label>
                                                                        <input type="date" name="promoted"
                                                                            id="promoted" value=""
                                                                            class="form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date Attendance Start &nbsp;:</label>
                                                                        <input type="date" name="att_start"
                                                                            id="att_start" value=""
                                                                            class="form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Date Resigned &nbsp;:</label>
                                                                        <input type="date" name="resigned"
                                                                            id="resigned" value=""
                                                                            class="form-control flatpickr-basic"
                                                                            placeholder="DD-MM-YYYY"
                                                                            data-dateformat="dd-mm-yy" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Job Title &nbsp;:</label>
                                                                        <input type="text" name="jobtitle"
                                                                            id="jobtitle" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Designation &nbsp;:</label>
                                                                        <select class="form-control"
                                                                            name="designation"
                                                                            id="designation"></select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Pay Rate Type &nbsp;:</label>
                                                                        <select class="form-control" name="paytype"
                                                                            id="paytype">
                                                                            <option value="Monthly"> Monthly </option>
                                                                            <option value="Daily"> Daily </option>
                                                                            <option value="Hourly"> Hourly </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Pay Method &nbsp;:</label>
                                                                        <select class="form-control" name="paymethod"
                                                                            id="paymethod">
                                                                            <option value="Bank"> Bank </option>
                                                                            <option value="Cash"> Cash </option>
                                                                            <option value="Check"> Check </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Pay Status &nbsp;:</label>
                                                                        <select class="form-control" name="paystatus"
                                                                            id="paystatus">
                                                                            <option value="1"> Active </option>
                                                                            <option value="0"> Not Active
                                                                            </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Contract &nbsp;:</label>
                                                                        <select class="form-control" name="contract"
                                                                            id="contract">
                                                                            <option value="1"> Yes </option>
                                                                            <option value="0"> No </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="tab-pane" id="tab3">
                                                    <br>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Goverment</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Bank Code &nbsp;:</label>
                                                                        <input type="text" name="bankcode"
                                                                            id="bankcode" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Branch Code &nbsp;:</label>
                                                                        <input type="text" name="branchcode"
                                                                            id="branchcode" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Bank A/C No &nbsp;:</label>
                                                                        <input type="text" name="acno"
                                                                            id="acno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Category &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="govcategory" id="govcategory">
                                                                            <option value="1"> 1 </option>
                                                                            <option value="2"> 2 </option>
                                                                            <option value="3"> 3 </option>
                                                                            <option value="4"> 4 </option>
                                                                            <option value="5"> 5 </option>
                                                                            <option value="6"> 6 </option>
                                                                            <option value="7"> 7 </option>
                                                                            <option value="8"> 8 </option>
                                                                            <option value="9"> 9 </option>
                                                                            <option value="10"> 10 </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Payment Mode &nbsp;:</label>
                                                                        <input type="text" name="paymentmode"
                                                                            id="paymentmode" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Insurance</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Socso No &nbsp;:</label>
                                                                        <input type="text" name="socso_no"
                                                                            id="socso_no" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Socso IC &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="socsoic" id="socsoic">
                                                                            <option value="new_IC_number"> Use the new
                                                                                IC number </option>
                                                                            <option value="old_IC_number"> Use the old
                                                                                IC number </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Table &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="table" id="table">
                                                                            <option value="normal_contribution"> Normal
                                                                                Contribution </option>
                                                                            <option
                                                                                value="employee&employer_contribution">
                                                                                Employee & Employer Contribution to the
                                                                                same account </option>
                                                                            <option value="employer_contribution"> Only
                                                                                employer pay the Contribution </option>
                                                                            <option
                                                                                value="employer_total_contribution">
                                                                                Employer pay the total of Contribution
                                                                            </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Category &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="inscategory" id="inscategory">
                                                                            <option value="1"> 1 </option>
                                                                            <option value="2"> 2 </option>
                                                                            <option value="3"> 3 </option>
                                                                            <option value="4"> 4 </option>
                                                                            <option value="5"> 5 </option>
                                                                            <option value="6"> X </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Socso Initial &nbsp;:</label>
                                                                        <input type="text" name="socso_initial"
                                                                            id="socso_initial" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">EPF</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>EPF No &nbsp;:</label>
                                                                        <input type="text" name="epfno"
                                                                            id="epfno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>EPF IC &nbsp;:</label>
                                                                        <input type="text" name="epfic"
                                                                            id="epfic" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Table &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="epftable" id="epftable">
                                                                            <option value="1"> 1 </option>
                                                                            <option value="2"> 2 </option>
                                                                            <option value="3"> 3 </option>
                                                                            <option value="4"> 4 </option>
                                                                            <option value="5"> 5 </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Category &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="epfcategory" id="epfcategory">
                                                                            <option value="1"> 1 </option>
                                                                            <option value="2"> 2 </option>
                                                                            <option value="3"> 3 </option>
                                                                            <option value="4"> 4 </option>
                                                                            <option value="5"> 5 </option>
                                                                            <option value="6"> 6 </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>EPF (Yee) Formula &nbsp;:</label>
                                                                        <input type="text" name="epfyee"
                                                                            id="epfyee" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>EPF (Yer) Formula &nbsp;:</label>
                                                                        <input type="text" name="epfyer"
                                                                            id="epfyer" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">TAX</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Branch &nbsp;:</label>
                                                                        <input type="text" name="taxbranch"
                                                                            id="taxbranch" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Tax No &nbsp;:</label>
                                                                        <input type="text" name="taxno"
                                                                            id="taxno" value=""
                                                                            class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Category &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            name="taxcategory" id="taxcategory">
                                                                            <option value="1"> 1 </option>
                                                                            <option value="2"> 2 </option>
                                                                            <option value="3"> 3 </option>
                                                                            <option value="4"> 4 </option>
                                                                            <option value="5"> 5 </option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="tab-pane" id="tab4">
                                                    <br>
                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Employee Mapping</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Leave Entitle Category &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            id="leavecategory" name="leavecategory">
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Approver Mapping 1 &nbsp;:</label>
                                                                        <div id="list_approver1"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Approver Mapping 2 &nbsp;:</label>
                                                                        <div id="list_approver2"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Approver Mapping 3 &nbsp;:</label>
                                                                        <div id="list_approver3"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Approver Mapping 4 &nbsp;:</label>
                                                                        <div id="list_approver4"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Approver Mapping 5 &nbsp;:</label>
                                                                        <div id="list_approver5"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Eclaim Role &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            id="users_status" name="users_status">
                                                                            <option value="">Select one</option>
                                                                            <option value="5">Staff</option>
                                                                            <option value="2">Manager</option>
                                                                        </select>
                                                                    </div>
                                                                </div>



                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Roster Type &nbsp;:</label>

                                                                        <select class="form-control"
                                                                            name="schedule_id" id="schedule_id">
                                                                            <option vlaue="">Select Roster Type
                                                                            </option>
                                                                            <?php $__currentLoopData = $duty_roasters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $duty_roaster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option
                                                                                    value="<?php echo e($duty_roaster->id); ?>">
                                                                                    <?php echo e($duty_roaster->name); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                        </select>
                                                                    </div>
                                                                </div>


                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="card">
                                                        <div class="card-header">
                                                            <div class="d-flex align-items-center">
                                                                <h4 class="card-title">Restday Add</h4>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <div class="form-group">
                                                                        <label>Select Restday Group &nbsp;:</label>
                                                                        <select class="select form-control"
                                                                            id="groupselname"
                                                                            name="groupselname"></select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" name="profile_photo_file"
                                                                id="profile_photo_file" value="wewrwerwerwer" />
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <a href="" class="btn btn-info"
                                                                        onclick="redirect();">Back</a>
                                                                    <button class="btn btn-primary"
                                                                        onclick="add_user();">Submit</button>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="6">
                                                                    <div id="message"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>


                                                <div class="form-actions" style="border-top: none">
                                                    <div class="row">
                                                        <div class="col-sm-12">

                                                            <ul class="pager wizard no-margin"
                                                                style="list-style:none;">

                                                                <li class="previous disabled"
                                                                    style="float:left; margin-left:-3%">
                                                                    <a class="btn btn-primary waves-effect waves-float waves-light"
                                                                        id="prev-btn"><svg
                                                                            xmlns="http://www.w3.org/2000/svg"
                                                                            width="14" height="14"
                                                                            viewBox="0 0 24 24" fill="none"
                                                                            stroke="currentColor" stroke-width="2"
                                                                            stroke-linecap="round"
                                                                            stroke-linejoin="round"
                                                                            class="feather feather-arrow-left align-middle mr-sm-25 mr-0">
                                                                            <line x1="19" y1="12"
                                                                                x2="5" y2="12"></line>
                                                                            <polyline points="12 19 5 12 12 5">
                                                                            </polyline>
                                                                        </svg> Previous </a>
                                                                </li>

                                                                <li class="next" style="float:right;">
                                                                    <a class="btn btn-primary txt-color-darken btn-primary btn-next waves-effect waves-float waves-light"
                                                                        id="nex-btn"> Next <svg
                                                                            xmlns="http://www.w3.org/2000/svg"
                                                                            width="14" height="14"
                                                                            viewBox="0 0 24 24" fill="none"
                                                                            stroke="currentColor" stroke-width="2"
                                                                            stroke-linecap="round"
                                                                            stroke-linejoin="round"
                                                                            class="feather feather-arrow-right align-middle ml-sm-25 ml-0">
                                                                            <line x1="5" y1="12"
                                                                                x2="19" y2="12"></line>
                                                                            <polyline points="12 5 19 12 12 19">
                                                                            </polyline>
                                                                        </svg></a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </form>
                                </div>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>

            </section>
            <!-- /Horizontal Wizard -->
        </div>
    </div>
</div>
<!-- END: Content-->
<?php echo e(View::make('layout.footer')); ?>

<script src="<?php echo e(asset('app-assets/bw/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('app-assets/bw/jquery.bootstrap.wizard.min.js')); ?>"></script>
<script src="<?php echo e(asset('app-assets/bw/wizard.min.js')); ?>"></script>
<script src="<?php echo e(asset('app-assets/js/scripts/form.js')); ?>"></script>
<script>
    $(document).ready(function() {

        if ($('#tab1').hasClass('active')) {
            setTimeout(() => {
                $('#prev-btn').attr('data-disabled', true);
                $('#nex-btn').attr('data-dis', false);
                $('.previous').addClass('disabled');
                $('.next').removeClass('disabled');
            }, 10);
        }
    });
    var fieldCheck = false;

    $('.bootstrapWizard.form-wizard li').click(function() {

        $('.bootstrapWizard.form-wizard').find('li').removeClass('active');
        $('.bootstrapWizard.form-wizard').find('li a').removeClass('active');

        $(this).addClass('active');
        $(this).find('a').addClass('active');

        $('.tab-content').find('.tab-pane').removeClass('active');

        let findId = $(this).find('a').attr('href').split('#').pop();

        $(`.tab-content`).find(`#${findId}.tab-pane`).addClass('active');
        if ($('#tab1').hasClass('active')) {
            $('#prev-btn').attr('data-disabled', true);
            $('#nex-btn').attr('data-dis', false);
            $('.previous').addClass('disabled');
            $('.next').removeClass('disabled');
        }
        if ($('#tab2').hasClass('active')) {
            $('#prev-btn').attr('data-disabled', false);
            $('#nex-btn').attr('data-dis', false);
            $('.previous').removeClass('disabled');
            $('.next').removeClass('disabled');
        }
        if ($('#tab3').hasClass('active')) {
            $('#prev-btn').attr('data-disabled', false);
            $('#nex-btn').attr('data-dis', false);
            $('.previous').removeClass('disabled');
            $('.next').removeClass('disabled');
        }
        if ($('#tab4').hasClass('active')) {
            $('#prev-btn').attr('data-disabled', false);
            $('#nex-btn').attr('data-dis', true);
            $('.previous').removeClass('disabled');
            $('.next').addClass('disabled');
        }

    });

    $('.next').click(function() {
        let allTabs = $('.tab-pane');
        if ($('#nex-btn').attr('data-dis') == 'true') {
            return;
        }
        setTimeout(() => {
            for (let i = 0; i < allTabs.length; i++) {
                if ($(allTabs[i]).hasClass('active')) {
                    let tabname = $(allTabs[i]).attr('id');
                    if (tabname == 'tab2') {
                        if ($('#tab2').hasClass('active')) {
                            $('#prev-btn').attr('data-disabled', false);
                            $('#nex-btn').attr('data-dis', false);
                            $('.previous').removeClass('disabled');
                            $('.next').removeClass('disabled');
                        }
                    }
                    if (tabname == 'tab3') {
                        if ($('#tab3').hasClass('active')) {
                            $('#prev-btn').attr('data-disabled', false);
                            $('#nex-btn').attr('data-dis', false);
                            $('.previous').removeClass('disabled');
                            $('.next').removeClass('disabled');
                        }
                    }
                    if (tabname == 'tab4') {
                        if ($('#tab4').hasClass('active')) {
                            $('#prev-btn').attr('data-disabled', false);
                            $('#nex-btn').attr('data-dis', true);
                            $('.previous').removeClass('disabled');
                            $('.next').addClass('disabled');
                        }
                    }
                }
            }
        }, 300);
        var data;
        var reqfield = $('.tab-pane.active .emp-required').each(function(i, el) {
            data = $(el).val();
            var allCheck = false;
        })

        if (data || $('#tab3').hasClass('active')) {
            fieldCheck = true;
            $('.bootstrapWizard.form-wizard').find('li.active .step').addClass('bg-success');
            $('.bootstrapWizard.form-wizard').find('li.active .step').html(
                '<span class="bg-success"><i class="fa fa-check"></i></span>');
        }
        if (fieldCheck) {
            var nextLI = $('.bootstrapWizard.form-wizard').find('li.active').next();
            $('.bootstrapWizard.form-wizard').find('li.active').removeClass('active');
            $(nextLI).addClass('active');
            var nextForm = $('.tab-content').find('.tab-pane.active').next();
            $('.tab-content').find('.tab-pane.active').removeClass('active');
            $(nextForm).addClass('active');
            if ($('#step3reqsub').hasClass('active')) {
                // $('.step').addClass('bg-success');
                // $('.step').html('<span class="bg-success"><i class="fa fa-check"></i></span>');
            }
        }
    })
    $('.previous').click(function() {
        let allTabs = $('.tab-pane');
        if ($('#prev-btn').attr('data-disabled') == 'true') {
            return;
        }
        setTimeout(() => {
            for (let i = 0; i < allTabs.length; i++) {
                if ($(allTabs[i]).hasClass('active')) {
                    let tabname = $(allTabs[i]).attr('id');
                    if (tabname == 'tab2') {
                        if ($('#tab2').hasClass('active')) {
                            $('#nex-btn').attr('data-dis', false);
                            $('#prev-btn').attr('data-disabled', false);
                            $('.previous').removeClass('disabled');
                            $('.next').removeClass('disabled');
                        }
                    }
                    if (tabname == 'tab3') {
                        if ($('#tab3').hasClass('active')) {
                            $('#nex-btn').attr('data-dis', false);
                            $('#prev-btn').attr('data-disabled', false);
                            $('.previous').removeClass('disabled');
                            $('.next').removeClass('disabled');
                        }
                    }
                    if (tabname == 'tab1') {
                        if ($('#tab1').hasClass('active')) {
                            $('#nex-btn').attr('data-dis', false);
                            $('#prev-btn').attr('data-disabled', true);
                            $('.previous').addClass('disabled');
                            $('.next').removeClass('disabled');
                        }
                    }
                }
            }
        }, 300);
        var prevLI = $('.bootstrapWizard.form-wizard').find('li.active').prev();
        $('.bootstrapWizard.form-wizard').find('li.active').removeClass('active');
        $(prevLI).addClass('active');
        var prevForm = $('.tab-content').find('.tab-pane.active').prev();
        $('.tab-content').find('.tab-pane.active').removeClass('active');
        $(prevForm).addClass('active');
    })
</script>

<script>
    var username;
    var lResObj;
    $(function() {
        $("#tabs").tabs();
    });

    $(document).ready(function() {
        username = '<?php echo $username; ?>';
        getCategoryNames();

    });

    function getCategoryNames() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getCategoryNames')); ?>',
            data: {
                dtable: 'no',
            },
            success: function(data) {
                var lResObj = data;
                var html = "";
                for (var i = 0; i < lResObj.length; i++) {
                    html += "<option value='" + lResObj[i].id + "'>" + lResObj[i].name + "</option>";
                }
                $("#leavecategory").html(html);

                getEmployeeType();
            }
        });
    }

    function getEmployeeType() {
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getemployeetype')); ?>',
            data: {
                dtable: 'no',
            },
            success: function(data) {
                var resObj = data;
                var html = "<option value=''>Select Type</option>";
                for (var i = 0; i < resObj.length; i++) {
                    html += "<option value='" + resObj[i].employee_type + "'>" + resObj[i].employee_type +
                        "</option>";
                }
                $("#employee_type").html(html);
                getDesignation();
            }
        });
    }

    function getDesignation() {
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getemployeedesignation')); ?>',
            data: {
                dtable: 'no',
            },
            success: function(data) {
                var resObj = data;
                var html = "<option value=''></option>";
                for (var i = 0; i < resObj.length; i++) {
                    html += "<option value='" + resObj[i].designation + "'>" + resObj[i].designation +
                        "</option>";
                }
                $("#designation").html(html);
                getDepartment();
            }
        });
    }

    /// list department starts ///
    function getDepartment() {
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getdepartmentList')); ?>',
            success: function(data) {
                var resObj = data;
                var html1 = "";
                html1 += '<option value="1" selected>Default</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html1 += '<option value=' + resObj[i].id + '>' + resObj[i].name + '</option>';
                }
                $("#pdepartment").html(html1);

                getCategory();
            }
        });
    }
    /// list department ends ///



    /// list category starts ///
    function getCategory() {
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getcategoryList')); ?>',
            success: function(data) {
                var resObj = data;
                var html2 = "";
                html2 += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html2 += '<option value=' + resObj[i].id + '>' + resObj[i].name + '</option>';
                }
                $("#pcategory").html(html2);

                getBranch();
            }
        });
    }
    /// list category ends ///

    /// list branch starts ///
    function getBranch() {
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getbranchList')); ?>',
            success: function(data) {
                var resObj = data;
                var html3 = "";
                html3 += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html3 += '<option value=' + resObj[i].id + '>' + resObj[i].name + '</option>';
                }
                $("#pbranch").html(html3);
                getEmpdetails();
            }
        });
    }
    /// list branch ends ///

  
    function getEmpdetails() {
     
        getState();
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getAllDetails')); ?>',
            data: {
                username: username,
            },
            success: function(data) {
                var resObj = data;
                
                var html;

                $("#employeeno").val(resObj.personal.employee_no);
                $("#employeecode").val(resObj.personal.employee_code);
                $("#employeename").val(resObj.personal.name);
                $("#address").val(resObj.personal.address);
                $("#postcode").val(resObj.personal.postal_code);
                $("#town").val(resObj.personal.town);
                $("#nationality").val(resObj.personal.nationality);
                $("#state").val(resObj.personal.state);
                $("#phoneno").val(resObj.personal.phone_no);
                $("#profile_photo_file").val(resObj.personal.profile_photo_file);
                $("#permissionlist").val(resObj.permission_group_id.permission_group_id)
                $("#permissionlist > [value='" + resObj.permission_group_id.permission_group_id + "']")
                    .attr("selected", "true");
                $("#eattendance_type > [value='" + resObj.personal.eattendance_type + "']").attr("selected",
                    "true");
                //var sdat = formatDate(resObj.personal.dob);
                //$("#dob").val(sdat);
                if (resObj.personal.eattendance_type) {
                    ScheduleType(resObj.personal.eattendance_type, resObj.personal.schedule_id, resObj
                        .personal.duty_roaster_id);

                }

                if (resObj.personal.dob == "00-00-0000" || resObj.personal.dob == "01-01-1970" || resObj
                    .personal.dob == "0000-00-00" || resObj.personal.dob == null)
                    $("#dob").val("");
                else {
                    $("#dob").val(resObj.personal.dob.split("-").reverse().join("-"));

                    $("#dob").flatpickr({
                        defaultDate: resObj.personal.dob,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }
                $("#education").val(resObj.personal.highest_education);
                $("#experience").val(resObj.personal.working_experience);
                $("#icno_old").val(resObj.personal.ic_no_old);
                $("#icno_new").val(resObj.personal.ic_no_new);
                $("#ic_color").val(resObj.personal.ic_color);
                $("#passportno").val(resObj.personal.passport_no);
                $("#sex").val(resObj.personal.sex);
                $("#employee_type").val(resObj.personal.employee_type);
                $("#designation").val(resObj.personal.designation);
                $("#race").val(resObj.personal.race);
                $("#bumiputra").val(resObj.personal.bumiputra);
                $("#maritalstatus").val(resObj.personal.marital_status);
                $("#email_id").val(resObj.personal.email_id);
                $("#blood_group").val(resObj.personal.blood_group);

                $("#spousename").val(resObj.spouse.spouse_name);
                $("#spic_no").val(resObj.spouse.spouse_ic_no);
                $("#childern").val(resObj.spouse.no_children);
                $("#spouse_working").val(resObj.spouse.spouse_working);

                $("#adname").val(resObj.address.name);
                $("#paddress").val(resObj.address.address);
                $("#pphno").val(resObj.address.phone_no);

                $("#jobtitle").val(resObj.pay.job_title);
                $("#pbranch").val(resObj.pay.branch_id);
                $("#pdepartment").val(resObj.pay.department_id);
                $("#pcategory").val(resObj.pay.category_id);
                //$("#commence").val(resObj.pay.date_commence);

                if (resObj.pay.date_commence == "00-00-0000" || resObj.pay.date_commence == "01-01-1970")
                    $("#commence").val("");
                else {
                    var dcdate = resObj.pay.date_commence.split("-").reverse().join("-");
                    $("#commence").flatpickr({
                        defaultDate: dcdate,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }
                //$("#promoted").val(resObj.pay.date_prompted);
                if (resObj.pay.date_prompted == "00-00-0000" || resObj.pay.date_prompted == "01-01-1970")
                    $("#promoted").val("");
                else {
                    var dpdate = resObj.pay.date_prompted.split("-").reverse().join("-");
                    $("#promoted").flatpickr({
                        defaultDate: dpdate,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }
                //$("#resigned").val(resObj.pay.date_resigned);
                if (resObj.pay.date_resigned == "00-00-0000" || resObj.pay.date_resigned == "01-01-1970")
                    $("#resigned").val("");
                else {
                    var drdate = resObj.pay.date_resigned.split("-").reverse().join("-");
                    $("#resigned").flatpickr({
                        defaultDate: drdate,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }

                if (resObj.pay.date_attendance_start == "00-00-0000" || resObj.pay.date_attendance_start=="01-01-1970" || resObj.pay.date_attendance_start==null)
                    $("#att_start").val("");
                else {
                    var drdate = resObj.pay.date_attendance_start.split("-").reverse().join("-");
                    $("#att_start").flatpickr({
                        defaultDate: drdate,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }
                if (resObj.pay.date_confirmed == "00-00-0000" || resObj.pay.date_confirmed == "01-01-1970")
                    $("#confirmed").val("");
                else {
                    var dcdate = resObj.pay.date_confirmed.split("-").reverse().join("-");
                    $("#confirmed").flatpickr({
                        defaultDate: dcdate,
                        altInput: true,
                        altFormat: 'd-m-Y',
                        dateFormat: 'Y-m-d'
                    });
                }

                $("#paytype").val(resObj.pay.pay_rate_type);
                $("#paymethod").val(resObj.pay.pay_method);
                $("#paystatus").val(resObj.pay.pay_status);
                $("#contract").val(resObj.pay.contract);


                $("#bankcode").val(resObj.government.bank_code);
                $("#branchcode").val(resObj.government.branch_code);
                $("#acno").val(resObj.government.bank_ac_no);
                $("#govcategory").val(resObj.government.category);
                $("#paymentmode").val(resObj.government.payment_mode);

                $("#socso_no").val(resObj.insurance.socso_no);
                $("#itable").val(resObj.insurance.tables);
                $("#socso_ic").val(resObj.insurance.socso_ic);
                $("#icategory").val(resObj.insurance.category);
                $("#socso_initial").val(resObj.insurance.socso_initial);

                $("#epfno").val(resObj.epf.epf_no);
                $("#epfic").val(resObj.epf.epf_ic);
                $("#etable").val(resObj.epf.tables);
                $("#ecategory").val(resObj.epf.category);
                $("#epfyee").val(resObj.epf.epf_yee_formula);
                $("#epfyer").val(resObj.epf.epf_yer_formula);

                $("#taxno").val(resObj.tax.tax_no);
                $("#taxbranch").val(resObj.tax.branch);
                $("#taxcategory").val(resObj.tax.category);
                $("#leavecategory > [value='" + resObj.category.category + "']").attr("selected", "true");
                //$("#leavecategory").val(resObj.category);
                $("#users_status").val(resObj.user_status.status);

                //appSelect();
                getApprover();
            }
        });
    }
    /// list employee full details ends ///-->
    function getApprover() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getLeaveMultipleApprover')); ?>',
            success: function(data) {
                var resObj = data;
                if (resObj == 1)
                    getApprover2();
                else
                    getApprover1();

            }
        });
    }
    /// list approver starts ///


    function getApprover1() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getApprovers')); ?>',
            success: function(data) {
                var resObj = data;
                var html = "";
                //html += '<select class="select" name="approver" id="approver" >';
                html += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html += '<option value="' + resObj[i].username + '">' + resObj[i].name + '</option>';
                }
                html += '</select>';
                //$("#list_approver").html(html);

                $("#list_approver1").html(
                    '<select class="select form-control compulsory" name="approver1" id="approver1" >' +
                    html);
                $("#list_approver2").html(
                    '<select class="select form-control" name="approver2" id="approver2" >' + html);
                $("#list_approver3").html(
                    '<select class="select form-control" name="approver3" id="approver3" >' + html);
                $("#list_approver4").html(
                    '<select class="select form-control" name="approver4" id="approver4" >' + html);
                $("#list_approver5").html(
                    '<select class="select form-control" name="approver5" id="approver5" >' + html);

                getmyApprover1();
            }
        });
    }

    function getApprover2() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getApprovers')); ?>',
            success: function(data) {
                var resObj = data;
                var html = "";
                //html += '<select class="select" name="approver" id="approver" multiple>';

                html += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html += '<option value="' + resObj[i].username + '">' + resObj[i].name + '</option>';
                }
                html += '</select>';
                //$("#list_approver").html('<select class="select" name="approver" id="approver" >'+html);

                $("#list_approver1").html(
                    '<select class="select form-control compulsory emp-required" name="approver1" id="approver1" >' +
                    html);
                $("#list_approver2").html(
                    '<select class="select form-control" name="approver2" id="approver2" >' + html);
                $("#list_approver3").html(
                    '<select class="select form-control" name="approver3" id="approver3" >' + html);
                $("#list_approver4").html(
                    '<select class="select form-control" name="approver4" id="approver4" >' + html);
                $("#list_approver5").html(
                    '<select class="select form-control" name="approver5" id="approver5" >' + html);

                getmyApprover2();
            }
        });
    }

    function getmyApprover1() {
    
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getApproversOfEmployee')); ?>',
            data: {
                employee_id: username,
            },
            success: function(data) {
                var resObj = data;
                var html = "";

                var selectedValues = new Array();
                for (var i = 0; i < resObj.length; i++) {
                    selectedValues[i] = resObj[i].username;
                    var _vl = new Array();
                    _vl[0] = resObj[i].username;
                    $("#approver" + (i + 1)).val(_vl);
                }
                $("#approver").val(selectedValues);


                getpermissionList();
            }
        });
    }

    function getmyApprover2() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getApproversOfEmployee')); ?>',
            data: {
                employee_id: username,
            },
            success: function(data) {
                var resObj = data;
                var html = "";

                var selectedValues = new Array();
                for (var i = 0; i < resObj.length; i++) {
                    selectedValues[i] = resObj[i].username;
                    var _vl = new Array();
                    _vl[0] = resObj[i].username;
                    $("#approver" + (i + 1)).val(_vl);
                }
                $("#approver").val(selectedValues);

                getpermissionList();
            }
        });
    }

    function getpermissionList() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getGroupPermissions')); ?>',
            success: function(data) {
                var resObj = data;
                var html = "";
                html += '<select class="select form-control" name="permissionlist" id="permissionlist" >';
                html += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html += '<option value="' + resObj[i].id + '">' + resObj[i].permission + '</option>';
                }
                html += '</select>';
                $("#list_permission").html(html);

                getrestdaygroup();
            }
        });
    }
    


    /// list restdaygroup starts ///
    function getrestdaygroup() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getRestDayCategories')); ?>',
            success: function(data) {
                var resObj = data;
                var html01 = "";
                html01 += '<option value="">Click to Choose one</option>';
                for (var i = 0; i < resObj.length; i++) {
                    html01 += '<option value="' + resObj[i].id + '">' + resObj[i].category + '</option>';
                }
                $("#groupselname").html(html01);
                getemppermission();
            }
        });
    }

    function getemppermission() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getPermissionGroupOfEmployee')); ?>',
            data: {
                employee_id: username,
            },
            success: function(data) {
                var resObj = data[0];
                var html;
                $("#permissionlist").val(resObj.permission_id);

                getmyRestday();
            }
        });
    }

    function getmyRestday() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getRestDayCategoriesOfEmployee')); ?>',
            data: {
                employee_id: username,
            },
            success: function(data) {
                var resObj = data;
                var html = "";

                $("#groupselname").val(resObj[0].category_id);

            }
        });
    }

    function formatDate(input) {
        var datePart = input.match(/\d+/g),
            year = datePart[0].substring(0), // get only two digits
            month = datePart[1],
            day = datePart[2];

        return day + '-' + month + '-' + year;
    }
    
    
    var sURL = window.document.URL.toString();
    var sURL = sURL.split("/");


    
    function checkempno(employeeno) {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('employeeNoAvailable')); ?>',
            data: {
                employee_no: employeeno,
                username: sURL[5]
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == false)
                    showError1("Employee no already taken.");
                else
                    showMessage1("Employee no valid.");

            }
        });
    }

    function showMessage1(message) {
        $("#message1").html("<span style='color:green;'>" + message + "</span>");
    }

    function showError1(message) {
        $("#message1").html("<span style='color:red;'>" + message + "</span>");
    }
 
 
    function checkicnew(icno_new) {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('usernameAvailable')); ?>',
            data: {
                username: icno_new,
                gusername: sURL[5]
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == false)
                    showError2("IC No: already taken.");
                else
                    showMessage2("IC No: valid.");

            }
        });
    }

    function showMessage2(message) {
        $("#message2").html("<span style='color:green;'>" + message + "</span>");
    }

    function showError2(message) {
        $("#message2").html("<span style='color:red;'>" + message + "</span>");
    }
    

    function getState() {
        var country = $("#nationality").val();

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getStateByCountry')); ?>',
            data: {
                country: country,
            },
            success: function(data) {
                var result_data = data;
                var html = "";
                for (var i = 0; i < result_data.length; i++) {
                    html += "<option value='" + result_data[i].state + "'>" + result_data[i].state +
                        "</option>";
                }
                $("#state").html(html);
            }
        });
    }

    var $validator = $("#wizard-1").validate({

        rules: {
            employeeno: {
                required: true
            },
            employeecode: {
                required: false
            },
            employeename: {
                required: false
            },
            icno_new: {
                required: true
            },
            email_id: {
                required: false,
                email: "Your email address must be in the format of name@domain.com"
            },
            pbranch: {
                required: true
            },
            pdepartment: {
                required: true
            },
            pcategory: {
                required: true
            },
            commence: {
                required: true
            },
            icno_new: {
                required: true
            },
        },

        messages: {
            employeeno: "Employee number required",
            employeecode: "Employee code required",
            employeename: "Employee Name required",
            icno_new: "I/C No. (New) required",
            pbranch: "Branch required",
            pdepartment: "Department required",
            pcategory: "Category required",
            commence: "Date Commence required",
            email: {
                required: "Email address required",
                email: "Your email address must be in the format of name@domain.com"
            }
        },

        highlight: function(element) {
            $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
        },
        unhighlight: function(element) {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
        },
        errorElement: 'span',
        errorClass: 'help-block',
        errorPlacement: function(error, element) {
            if (element.parent('.input-group').length) {
                error.insertAfter(element.parent());
            } else {
                error.insertAfter(element);
            }
        }
    });



    function add_user() {
        if (validate()) {


            $.ajax({
                type: 'get',
                url: '<?php echo e(route('updateUserAll')); ?>',
                data: {
                    username: username,

                    employee_no: $("#employeeno").val(),
                    employee_code: $("#employeecode").val(),
                    name: $("#employeename").val(),
                    address: $("#address").val(),
                    postal_code: $("#postcode").val(),
                    town: $("#town").val(),
                    nationality: $("#nationality").val(),
                    state: $("#state").val(),
                    phone_no: $("#phoneno").val(),
                    dob: $("#dob").val(),
                    highest_education: $("#education").val(),
                    working_experience: $("#experience").val(),
                    ic_no_old: $("#icno_old").val(),
                    ic_no_new: $("#icno_new").val(),
                    ic_color: $("#ic_color").val(),
                    passport_no: $("#passportno").val(),
                    sex: $("#sex").val(),
                    employee_type: $("#employee_type").val(),
                    designation: $("#designation").val(),
                    race: $("#race").val(),
                    bumiputra: $("#bumiputra").val(),
                    marital_status: $("#maritalstatus").val(),
                    email_id: $("#email_id").val(),
                    blood_group: $("#blood_group").val(),

                    spouse_name: $("#spousename").val(),
                    spouse_ic_no: $("#spic_no").val(),
                    no_children: $("#childern").val(),
                    spouse_working: $("#spouse_working").val(),

                    address_name: $("#adname").val(),
                    address_address: $("#paddress").val(),
                    address_phone_no: $("#pphno").val(),

                    job_title: $("#jobtitle").val(),
                    branch_id: $("#pbranch").val(),
                    department_id: $("#pdepartment").val(),
                    category_id: $("#pcategory").val(),
                    date_commence: $("#commence").val(),
                    date_prompted: $("#promoted").val(),
                    date_resigned: $("#resigned").val(),
                    date_confirmed: $("#confirmed").val(),
                    pay_rate_type: $("#paytype").val(),
                    pay_method: $("#paymethod").val(),
                    pay_status: $("#paystatus").val(),
                    contract: $("#contract").val(),
                    att_start: $("#att_start").val(),

                    bank_code: $("#bankcode").val(),
                    branch_code: $("#branchcode").val(),
                    bank_ac_no: $("#acno").val(),
                    gov_category: $("#govcategory").val(),
                    payment_mode: $("#paymentmode").val(),

                    socso_no: $("#socso_no").val(),
                    socso_ic: $("#socso_ic").val(),
                    ins_table: $("#itable").val(),
                    ins_category: $("#icategory").val(),
                    socso_initial: $("#socso_initial").val(),

                    epf_no: $("#epfno").val(),
                    epf_ic: $("#epfic").val(),
                    epf_table: $("#etable").val(),
                    epf_category: $("#ecategory").val(),
                    epf_yee_formula: $("#epfyee").val(),
                    epf_yer_formula: $("#epfyer").val(),

                    tax_no: $("#taxno").val(),
                    branch: $("#taxbranch").val(),
                    tax_category: $("#taxcategory").val(),

                    category: $("#leavecategory").val(),

                    users_status: $("#users_status").val(),
                    profile_photo_file: $("#profile_photo_file").val(),
                    eattendance_type: $("#eattendance_type").val(),
                    schedule_id: $("#schedule_id").val(),

                },
                success: function(data) {
                    var resObj = data;
                    var messege = resObj;
                    if (messege == true) {
                        updateRestday();
                    } else if (messege == 'dup_ic_no') {
                        showError("IC NO. Already Taken");
                    } else if (messege == 'dup_emp_no') {
                        showError("Employee no Already Taken");
                    } else {
                        showError("Error Occured");
                    }
                }
            });
        }
    }



    function redirect() {
        window.location.reload();
    }

    function validate() {
        var employeeno = $("#employeeno").val();
        var employeename = $("#employeename").val();
        var phoneno = $("#phoneno").val();
        var email_id = $("#email_id").val();
        var icno_new = $("#icno_new").val();
        var pbranch = $("#pbranch").val();
        var department = $("#pdepartment").val();
        var category = $("#pcategory").val();
        var approver1 = $("#approver1").val();
        //approver1
        var commence = $("#commence").val();

        if (employeeno == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (icno_new == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (pbranch == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (department == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (category == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (commence == "") {
            var htm =
                '<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>Some mandatory fields are empty.</div>';
            showError(htm);
            displayred();
            return false;
        } else if (approver1 == "") {
            showError("Some mandatory fields are empty");
            displayred();
            return false;
        } else
            return true;
    }

    function displayred() {
        $(".red").css("display", "inline");
    }

    function updateRestday() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('mapEmployeeToCategory')); ?>',
            data: {
                employee_id: $("#icno_new").val(),
                category_id: $("#groupselname").val(),
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == true)
                    updatePermission();
                else
                    showError("Error Occured");
            }
        });
    }


    function deleteApprover() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('removeEmployeeMapping')); ?>',
            data: {
                employee_id: $("#icno_new").val(),
                category_id: $("#groupselname").val(),
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == true)
                    updateApprover();
                else
                    showError("Error Occured");
            }
        });
    }

    function updateApprover() {
        var _arr = new Array();
        var _index_arr = new Array();
        if ($("#approver1").val() != '') {
            _arr[0] = $("#approver1").val();
            _index_arr[0] = '1';
        }
        if ($("#approver2").val() != '') {
            _arr[1] = $("#approver2").val();
            _index_arr[1] = '2';
        }
        if ($("#approver3").val() != '') {
            _arr[2] = $("#approver3").val();
            _index_arr[2] = '3';
        }
        if ($("#approver4").val() != '') {
            _arr[3] = $("#approver4").val();
            _index_arr[3] = '4';
        }
        if ($("#approver5").val() != '') {
            _arr[4] = $("#approver5").val();
            _index_arr[4] = '5';
        }

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('mapEmplyoyeeS')); ?>',
            data: {
                employee_id: $("#icno_new").val(),
                approver_id: _arr,
                approver_index: _index_arr,
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == true) {
                    var msg =
                        '<div class="alert alert-success fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i><strong>Success</strong> Employee updated successfully.</div>';
                    showMessage(msg);
                } else {
                    showError("Error Occured");
                }
            }
        });

    }

    function showMessage(message) {
        $("#message").html("<span style='color:green;'>" + message + "</span>");
    }

    function showError(message) {
        $("#message").html("<span style='color:red;margin-top:20px;'></br>" + message + "</span>");
    }


    function updatePermission() {

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('mapEmployeePermission')); ?>',
            data: {
                permission_group_id: $("#permissionlist").val(),
                employee_ids: $("#icno_new").val(),
            },
            success: function(data) {
                var resObj = data;
                var messege = resObj;
                if (messege == true)
                    deleteApprover();
                else
                    showError("Error Occured");
            }
        });
    }

    $(document).ready(function() {
        $('#bootstrap-wizard-1').bootstrapWizard({
            'tabClass': 'form-wizard',
            'onNext': function(tab, navigation, index) {
                var $valid = $("#wizard-1").valid();
                if (!$valid) {
                    $validator.focusInvalid();
                    return false;
                } else {
                    $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1)
                        .addClass(
                            'complete');
                    $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1).find(
                            '.step')
                        .html('<i class="fa fa-check"></i>');
                }
            }
        });


        var wizard = $('.wizard').wizard();

        wizard.on('finished', function(e, data) {
            $.smallBox({
                title: "Congratulations! Your form was submitted",
                content: "<i class='fa fa-clock-o'></i> <i>1 seconds ago...</i>",
                color: "#5F895F",
                iconSmall: "fa fa-check bounce animated",
                timeout: 4000
            });

        });


    });




    function ScheduleType(schedule, schedule_id = '', duty_roaster_id = '') {

        $(".schedule_id").removeClass("d-none");
        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getScheduleType')); ?>',
            data: {
                eattendance_type: schedule
            },
            success: function(data) {
                if (data) {
                    var result_data = data;
                    var html = "";
                    for (var i = 0; i < result_data.length; i++) {
                        html += "<option value='" + result_data[i].id + "'>" + result_data[i].name +
                            "</option>";
                    }
                    $("#schedule_id").html(html);

                    if (schedule_id) {
                        $("#schedule_id  > [value='" + schedule_id + "']").attr("selected",
                            "true");
                    } else {
                        $("#schedule_id  > [value='" + duty_roaster_id + "']").attr("selected",
                            "true");
                    }

                } else {
                    $(".schedule_id").addClass("d-none");
                }

            }
        });
    }
</script>
<?php /**PATH /home/ecoleave/public_html/v4/armada/resources/views/hr/setup/update_employee.blade.php ENDPATH**/ ?>