<?php echo e(View::make('layout.header')); ?>


<style>


    .bootstrapWizard {
        display: block;
        list-style: none;
        padding: 0;
        position: relative;
        width: 100%
    }

    .bootstrapWizard a:active,
    .bootstrapWizard a:focus,
    .bootstrapWizard a:hover {
        text-decoration: none
    }

    .bootstrapWizard li {
        display: block;
        float: left;
        width: 25%;
        text-align: center;
        padding-left: 0
    }

    .bootstrapWizard li:before {
        border-top: 2px solid #55606E;
        content: "";
        display: block;
        font-size: 0;
        overflow: hidden;
        position: relative;
        top: 23px;
        right: 1px;
        width: 100%;
        z-index: 1
    }

    .bootstrapWizard li:first-child:before {
        left: 50%;
        max-width: 50%
    }

    .bootstrapWizard li:last-child:before {
        max-width: 50%;
        width: 50%
    }

    .bootstrapWizard li.complete .step {
        background: #0aa66e !important;
        padding: 7px 7px !important;
        border: 2px solid #55606E !important;
    }

    .bootstrapWizard li .step i {
        font-size: 19px;
        font-weight: 400;
        position: relative;
        top: 1.5px
    }

    .bootstrapWizard li .step {
        background: #B2B5B9;
        color: #fff;
        display: inline;
        font-size: 15px;
        font-weight: 700;
        border: 2px solid transparent;
        border-radius: 50%;
        line-height: normal;
        position: relative;
        text-align: center;
        z-index: 2;
        transition: all .1s linear 0s;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        width: 40px;
        height: 40px;
        padding: 0px;
    }

    .bootstrapWizard li.active .step,
    .bootstrapWizard li.active.complete .step {
        background: #7367F0;
        color: #fff;
        font-weight: 700;
        padding: 7px 13px;
        font-size: 15px;
        border-radius: 50%;
        border: 2px solid #55606E
    }

    .bootstrapWizard li.active .title,
    .bootstrapWizard li.complete .title {
        color: #2B3D53
    }

    .bootstrapWizard li .title {
        color: #bfbfbf;
        display: block;
        font-size: 13px;
        line-height: 15px;
        max-width: 100%;
        position: relative;
        table-layout: fixed;
        text-align: center;
        top: 20px;
        word-wrap: break-word;
        z-index: 1
    }

    .wizard-actions {
        display: block;
        list-style: none;
        padding: 0;
        position: relative;
        width: 100%
    }

    .wizard-actions li {
        display: inline
    }

    .help-block{
        display: block;
        color:red;
    }
    .alert-danger {
    margin-top:15px;
    border-color: #ea5455;
    color: #fff !important;
    background-color: #ea5455 !important;
    text-shadow: none;
    opacity:1 !important;
    padding:15px;

    }
    .alert-danger .close{
        color:#fff !important;
        opacity:1 !important;
        margin-top:-4px !important;
    }

    .alert-success {
    margin-top:15px;
    border-color: #28c76f;
    color: #fff !important;
    background-color: #28c76f !important;
    text-shadow: none;
    opacity:1 !important;
    padding:15px;

    }
    .alert-success .close{
        color:#fff !important;
        opacity:1 !important;
        margin-top:-4px !important;
    }

    .disabled a, .completed a {
        opacity:0.7 !important;
        cursor: not-allowed !important;
        
        box-shadow: 0 8px 25px -8px transparent !important;
    }
    .disabled .btn-primary:focus, .btn-primary:active, .btn-primary.active {
        background:transparent !important;
    }
    
    #employeeno, #icno_new, #branch, #department, #category, .emp-required{
        background-color: #FFFFE0 !important;
    }
</style>
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-5">
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb mt-3">
                                    <li class="breadcrumb-item">HR
                                    </li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('setup')); ?>">Setup</a></li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('edit-employee')); ?>">Employees</a></li>
                                    <li class="breadcrumb-item active"><a href="#">Employee Create</a>
                                    </li>
                                </ol>
                            </div>
                        </div>


                        <div class="col-7">
                            <div class="form-bootstrapWizard">
                                    
									<ul class="bootstrapWizard form-wizard">
										<li class="active" data-target="#step1">
											<a href="#tab1" data-toggle="tab"> <span class="step">1</span> <span class="title">Personal Details</span> </a>
										</li>
										<li data-target="#step2">
											<a href="#tab2" data-toggle="tab"> <span class="step">2</span> <span class="title">Pay</span> </a>
										</li>
										<li data-target="#step3" id="step3req">
											<a href="#tab3" class="active" data-toggle="tab" id="step3reqsub"> <span class="step">3</span> <span class="title">Third</span> </a>
										</li>
										<li data-target="#step4">
											<a href="#tab4" data-toggle="tab"> <span class="step">4</span> <span class="title">Mapping</span> </a>
										</li>
									</ul>
                                    <div class="clearfix"></div>
                                    <br>
								</div>

                        </div>

                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Horizontal Wizard -->
                <section class="horizontal-wizard">


                    <article class="col-sm-12 col-md-12 col-lg-12">
	<!-- Widget ID (each widget will need unique ID)-->
		<div class="jarviswidget jarviswidget-color-darken" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">

			<!-- widget div-->
			<div>
				<!-- widget edit box -->
				<div class="jarviswidget-editbox">
				<!-- This area used as dropdown edit box -->
				</div>
				<!-- end widget edit box -->

				<!-- widget content -->
				<div class="widget-body">
					<div class="row">
						<form id="wizard-1" novalidate="novalidate" method="post" onsubmit="return false;">
							<div id="bootstrap-wizard-1" class="col-sm-12">
								<div class="tab-content">
									<div class="tab-pane active" id="tab1">
										<br>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Personal Details</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Employee No &nbsp;:</label>
                                                            <input type="text" name="employeeno" id="employeeno" value="" onblur="checkempno(this.value);" class="form-control emp-required" />
                                                            <span id="message1"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Employee Code &nbsp;:</label>
                                                            <input type="text" name="employeecode" id="employeecode" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Employee Name &nbsp;:</label>
                                                            <input type="text" name="employeename" id="employeename" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Address &nbsp;:</label>
                                                            <input type="text" name="address" id="address" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Postcode &nbsp;:</label>
                                                            <input type="text" name="postcode" id="postcode" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Town &nbsp;:</label>
                                                            <input type="text" name="town" id="town" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Nationality &nbsp;:</label>
                                                            <select class="form-control" id="nationality" onchange="getState()">
                                                            <?php  for($i=0;$i<count($countries);$i++){

                                                                    echo '<option value="'.$countries[$i]->country.'">'.$countries[$i]->country.'</option>';
                                                                } ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>State &nbsp;:</label>
                                                          
                                                            <select class="form-control" name="state" id="state">
                                                                <option vlaue="">Select State</option>
                                                                
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Phone No &nbsp;:</label>
                                                            <input type="text" name="phoneno" id="phoneno" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Date of Birth &nbsp;:</label>
                                                            <input type="date" name="dob" id="dob"  value="" class="form-control flatpickr-basic"  placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy"/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Highest Education &nbsp;:</label>
                                                            <input type="text" name="education" id="education" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Working Experience &nbsp;:</label>
                                                            <input type="text" name="experience" id="experience" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>I/C No. (Old) &nbsp;:</label>
                                                            <input type="text" name="icno_old" id="icno_old" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>I/C No. (New) &nbsp;:</label>
                                                            <input type="text" name="icno_new" id="icno_new" value="" class="form-control emp-required" onblur="checkicnew(this.value);"/>
                                                            <span id="message2"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>I/C Color &nbsp;:</label>
                                                            <input type="text" name="ic_color" id="ic_color" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Passport No. &nbsp;:</label>
                                                            <input type="text" name="passportno" id="passportno" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Gender &nbsp;:</label>
                                                            <select class="form-control" name="sex" id="sex">
                                                                <option value="1">Male</option>
                                                                <option value="0">Female</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Race &nbsp;:</label>
                                                            <select class="form-control" id="race" name="race">
                                                               
                                                                <?php $__currentLoopData = $race; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($rc->race); ?>"><?php echo e($rc->race); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Bumiputra &nbsp;:</label>
                                                            <select class="form-control" name="bumiputra" id="bumiputra">
                                                                <option value="1">Yes</option>
                                                                <option value="0">No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Marital Status &nbsp;:</label>
                                                            <select class="form-control" name="maritalstatus" id="maritalstatus">
                                                                <option value="Single">Single</option>
                                                                <option value="Married">Married</option>
                                                                <option value="Other">Other</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Email ID &nbsp;:</label>
                                                            <input type="text" name="email" id="email" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>User Role &nbsp;:</label>
                                                            <div id="list_permission"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Blood Group &nbsp;:</label>
                                                            <input type="text" name="blood_group" id="blood_group" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
										<div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Spouse Particular</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
										        <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Spouse Name &nbsp;:</label>
                                                            <input type="text" name="spousename" id="spousename" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Sp. I/C No &nbsp;:</label>
                                                            <input type="text" name="spic_no" id="spic_no" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>No. of children &nbsp;:</label>
                                                            <input type="text" name="childern" id="childern" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Spouse Working &nbsp;:</label>
                                                            <select class="form-control" name="spouseworking" id="spouseworking">
                                                                    <option value="No">No</option>
                                                                    <option value="Yes">Yes</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Permanent Address/Contact</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
										        <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Name &nbsp;:</label>
                                                            <input type="text" name="name" id="name" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Address &nbsp;:</label>
                                                            <input type="text" name="paddress" id="paddress" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Phone No &nbsp;:</label>
                                                            <input type="text" name="phno" id="phno" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									</div>

									<div class="tab-pane" id="tab2">
										<br>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Personal Details</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
												<div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Branch &nbsp;:</label>
                                                            <select class="form-control emp-required" name="branch" id="branch"></select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Department &nbsp;:</label>
                                                            <select class="form-control emp-required" name="department" id="department"></select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Category &nbsp;:</label>
                                                            <select class="form-control emp-required" name="category" id="category"></select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Employee Type &nbsp;:</label>
                                                            <select class="select form-control" name="employee_type" id="employee_type"></select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Date Commence &nbsp;:</label>
                                                            <input type="date" name="commence" id="commence" value="" class="emp-required form-control flatpickr-basic"  placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Date Confirmed &nbsp;:</label>
                                                            <input type="date" name="confirmed" id="confirmed" value="" class="form-control flatpickr-basic"  placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Date Promoted &nbsp;:</label>
                                                            <input type="date" name="promoted" id="promoted" value="" class="form-control flatpickr-basic"  placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Date Resigned &nbsp;:</label>
                                                            <input type="date" name="resigned" id="resigned" value="" class="form-control flatpickr-basic"  placeholder="DD-MM-YYYY" data-dateformat="dd-mm-yy" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Job Title &nbsp;:</label>
                                                            <input type="text" name="jobtitle" id="jobtitle" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Designation &nbsp;:</label>
                                                            <select class="form-control" name="designation" id="designation"></select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Pay Rate Type &nbsp;:</label>
                                                            <select class="form-control" name="paytype" id="paytype" >
                                                                <option value="Monthly"> Monthly </option>
                                                                <option value="Daily"> Daily </option>
                                                                <option value="Hourly"> Hourly </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Pay Method &nbsp;:</label>
                                                            <select class="form-control" name="paymethod" id="paymethod" >
                                                                <option value="Bank"> Bank </option>
                                                                <option value="Cash"> Cash </option>
                                                                <option value="Check"> Check </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Pay Status &nbsp;:</label>
                                                            <select class="form-control" name="paystatus" id="paystatus" >
                                                                <option value="1"> Active </option>
                                                                <option value="0"> Not Active </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Contract &nbsp;:</label>
                                                            <select class="form-control" name="contract" id="contract" >
                                                                <option value="1"> Yes </option>
                                                                <option value="0"> No </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									</div>

									<div class="tab-pane" id="tab3">
										<br>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Goverment</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Bank Code &nbsp;:</label>
                                                            <input type="text" name="bankcode" id="bankcode" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Branch Code &nbsp;:</label>
                                                            <input type="text" name="branchcode" id="branchcode" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Bank A/C No &nbsp;:</label>
                                                            <input type="text" name="acno" id="acno" value="" class="form-control" />
                                                        </div>
                                                    </div><div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Category &nbsp;:</label>
                                                            <select class="select form-control" name="govcategory" id="govcategory" >
                                                                <option value="1"> 1 </option><option value="2"> 2 </option>
                                                                <option value="3"> 3 </option><option value="4"> 4 </option>
                                                                <option value="5"> 5 </option><option value="6"> 6 </option>
                                                                <option value="7"> 7 </option><option value="8"> 8 </option>
                                                                <option value="9"> 9 </option><option value="10"> 10 </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Payment Mode &nbsp;:</label>
                                                            <input type="text" name="paymentmode" id="paymentmode" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Insurance</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Socso No &nbsp;:</label>
                                                            <input type="text" name="socso_no" id="socso_no" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Socso IC &nbsp;:</label>
                                                            <select class="select form-control" name="socsoic" id="socsoic" >
                                                                <option value="new_IC_number"> Use the new IC number </option>
                                                                <option value="old_IC_number"> Use the old IC number </option>
                                                            </select>
                                                        </div>
                                                    </div><div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Table &nbsp;:</label>
                                                            <select class="select form-control" name="table" id="table" >
                                                                <option value="normal_contribution"> Normal Contribution </option>
                                                                <option value="employee&employer_contribution"> Employee & Employer Contribution to the same account </option>
                                                                <option value="employer_contribution"> Only employer pay the Contribution </option>
                                                                <option value="employer_total_contribution"> Employer pay the total of Contribution </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Category &nbsp;:</label>
                                                            <select class="select form-control" name="inscategory" id="inscategory" >
                                                                <option value="1"> 1 </option><option value="2"> 2 </option>
                                                                <option value="3"> 3 </option><option value="4"> 4 </option>
                                                                <option value="5"> 5 </option><option value="6"> X </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Socso Initial &nbsp;:</label>
                                                            <input type="text" name="socso_initial" id="socso_initial" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">EPF</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>EPF No &nbsp;:</label>
                                                            <input type="text" name="epfno" id="epfno" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>EPF IC &nbsp;:</label>
                                                            <input type="text" name="epfic" id="epfic" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Table &nbsp;:</label>
                                                            <select class="select form-control" name="epftable" id="epftable" >
                                                                <option value="1"> 1 </option><option value="2"> 2 </option>
                                                                <option value="3"> 3 </option><option value="4"> 4 </option>
                                                                <option value="5"> 5 </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Category &nbsp;:</label>
                                                            <select class="select form-control" name="epfcategory" id="epfcategory" >
                                                                <option value="1"> 1 </option><option value="2"> 2 </option>
                                                                <option value="3"> 3 </option><option value="4"> 4 </option>
                                                                <option value="5"> 5 </option><option value="6"> 6 </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>EPF (Yee) Formula &nbsp;:</label>
                                                            <input type="text" name="epfyee" id="epfyee" value="" class="form-control" />
                                                        </div>
                                                    </div><div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>EPF (Yer) Formula &nbsp;:</label>
                                                            <input type="text" name="epfyer" id="epfyer" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">TAX</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Branch &nbsp;:</label>
                                                            <input type="text" name="taxbranch" id="taxbranch" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Tax No &nbsp;:</label>
                                                            <input type="text" name="taxno" id="taxno" value="" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Category &nbsp;:</label>
                                                            <select class="select form-control" name="taxcategory" id="taxcategory" >
                                                                <option value="1"> 1 </option><option value="2"> 2 </option>
                                                                <option value="3"> 3 </option><option value="4"> 4 </option>
                                                                <option value="5"> 5 </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									</div>

									<div class="tab-pane" id="tab4">
										<br>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Employee Mapping</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Leave Entitle Category &nbsp;:</label>
                                                            <select class="select form-control" id="leavecategory" name="leavecategory">
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Approver Mapping 1 &nbsp;:</label>
                                                            <div id="list_approver1"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Approver Mapping 2 &nbsp;:</label>
                                                            <div id="list_approver2"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Approver Mapping 3 &nbsp;:</label>
                                                            <div id="list_approver3"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Approver Mapping 4 &nbsp;:</label>
                                                            <div id="list_approver4"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Approver Mapping 5 &nbsp;:</label>
                                                            <div id="list_approver5"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-header">
                                                <div class="d-flex align-items-center">
                                                    <h4 class="card-title">Restday Add</h4>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>Select Restday Group &nbsp;:</label>
                                                            <select class="select form-control" id="groupselname" name="groupselname"></select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <a href="" class="btn btn-info" onclick="link();">Back</a>
                                                        <button class="btn btn-primary" onclick="add_user();">Submit</button>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="6">
                                                        <div style="margin-left:12px;" id="message"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


									</div>


														<div class="form-actions" style="border-top: none">
															<div class="row">
																<div class="col-sm-12">

																	<ul class="pager wizard no-margin" style="list-style:none;">
																		<!--<li class="previous first disabled">
																		<a href="javascript:void(0);" class="btn btn-default"> First </a>
																		</li>-->
																		<li class="previous disabled" style="float:left; margin-left:-3%">
																			<a class="btn btn-primary waves-effect waves-float waves-light" id="prev-btn"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left align-middle mr-sm-25 mr-0"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg> Previous </a>
																		</li>
																		<!--<li class="next last">
																		<a href="javascript:void(0);" class="btn btn-primary"> Last </a>
																		</li>-->
																		<li class="next" style="float:right;">
																			<a class="btn btn-primary txt-color-darken btn-primary btn-next waves-effect waves-float waves-light" id="nex-btn"> Next <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right align-middle ml-sm-25 ml-0"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg></a>
																		</li>
																	</ul>
																</div>
															</div>
														</div>

													</div>
												</div>
											</form>
										</div>

									</div>
									<!-- end widget content -->

								</div>
								<!-- end widget div -->

							</div>
							<!-- end widget -->

                        </article>

                </section>
                <!-- /Horizontal Wizard -->
            </div>
        </div>
    </div>
    <!-- END: Content-->
    <?php echo e(View::make('layout.footer')); ?>

    <script src="<?php echo e(asset('app-assets/bw/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/bw/jquery.bootstrap.wizard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/bw/wizard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/js/scripts/form.js')); ?>"></script>
    <script>
    $(document).ready(function() {
        
        if($('#tab1').hasClass('active')){
            setTimeout(() => { 
                $('#prev-btn').attr('data-disabled',true);
                $('#nex-btn').attr('data-dis',false);
                $('.previous').addClass('disabled');
                $('.next').removeClass('disabled');
            }, 10);
        }
    });
        var fieldCheck = false;

         $('.bootstrapWizard.form-wizard li').click(function(){
            
            $('.bootstrapWizard.form-wizard').find('li').removeClass('active');
            $('.bootstrapWizard.form-wizard').find('li a').removeClass('active');

            $(this).addClass('active');
            $(this).find('a').addClass('active');

            $('.tab-content').find('.tab-pane').removeClass('active');

            let findId = $(this).find('a').attr('href').split('#').pop();

            $(`.tab-content`).find(`#${findId}.tab-pane`).addClass('active');
            if($('#tab1').hasClass('active')){
                $('#prev-btn').attr('data-disabled',true);
                $('#nex-btn').attr('data-dis',false);
                $('.previous').addClass('disabled');
                $('.next').removeClass('disabled');
                return;
            }
            if($('#tab2').hasClass('active')){
                $('#prev-btn').attr('data-disabled',false);
                $('#nex-btn').attr('data-dis',false);
                $('.previous').removeClass('disabled');
                $('.next').removeClass('disabled');
            }
            if($('#tab3').hasClass('active')){
                //console.log("tab3.1");
                $('#prev-btn').attr('data-disabled',false);
                $('#nex-btn').attr('data-dis',false);
                $('.previous').removeClass('disabled');
                $('.next').removeClass('disabled');

            }
            if($('#tab4').hasClass('active')){
                //console.log("tab4.1");
                $('#prev-btn').attr('data-disabled',false);
                $('#nex-btn').attr('data-dis',true);
                $('.previous').removeClass('disabled');
                $('.next').addClass('disabled');
                return;
            }
            
        });



        $('.next').click(function(){
            let allTabs = $('.tab-pane');
            if($('#nex-btn').attr('data-dis') == 'true') {
                return;
            }
            setTimeout(() => {
                for(let i=0; i < allTabs.length;i++) {
                    if($(allTabs[i]).hasClass('active')) {
                    //console.log($(allTabs[i]).attr('id'));
                    let tabname =$(allTabs[i]).attr('id');
                        if(tabname=='tab2')
                        {
                            if($('#tab2').hasClass('active')){
                                $('#prev-btn').attr('data-disabled',false);
                                $('#nex-btn').attr('data-dis',false);
                                $('.previous').removeClass('disabled');
                                $('.next').removeClass('disabled');
                            }
                        }
                        if(tabname=='tab3')
                        {
                            //console.log("tab3.2");
                            if($('#tab3').hasClass('active')){
                                $('#prev-btn').attr('data-disabled',false);
                                $('#nex-btn').attr('data-dis',false);
                                $('.previous').removeClass('disabled');
                                $('.next').removeClass('disabled');
                            }
                        }
                        if(tabname=='tab4')
                        {
                           // console.log("tab4.2");
                            if($('#tab4').hasClass('active')){
                                $('#prev-btn').attr('data-disabled',false);
                                $('#nex-btn').attr('data-dis',true);
                                $('.previous').removeClass('disabled');
                                $('.next').addClass('disabled');
                                return;
                            }
                        }
                    }
                    }

                    var data;
          
            var reqfield = $('.tab-pane.active .emp-required').each(function(i,el){
                data =  $(el).val();
                console.log(data);
                var allCheck = false;
            })
            //console.log($('#tab3').hasClass('active'));
            //console.log($('#tab4').hasClass('active'));
            if(data || $('#tab3').hasClass('active')){
                    fieldCheck = true;
                    $('.bootstrapWizard.form-wizard').find('li.active .step').addClass('bg-success');
                    $('.bootstrapWizard.form-wizard').find('li.active .step').html('<span class="bg-success"><i class="fa fa-check"></i></span>');
                }

            if(fieldCheck){

                var nextLI =  $('.bootstrapWizard.form-wizard').find('li.active').next();

                //console.log(nextLI);
                $('.bootstrapWizard.form-wizard').find('li.active').removeClass('active');

                $(nextLI).addClass('active');


                var nextForm = $('.tab-content').find('.tab-pane.active').next();
            $('.tab-content').find('.tab-pane.active').removeClass('active');
            $(nextForm).addClass('active');

            if($('#step3reqsub').hasClass('active')){
                    // $('.step').addClass('bg-success');
                    // $('.step').html('<span class="bg-success"><i class="fa fa-check"></i></span>');
                }


            }
                }, 300);
    
        })




        $('.previous').click(function(){
            let allTabs = $('.tab-pane');
            if($('#prev-btn').attr('data-disabled') == 'true') {
                return;
            }

            //console.log(allTabs);
            
            setTimeout(() => {
                for(let i=0; i < allTabs.length;i++) {
                    if($(allTabs[i]).hasClass('active')) {
                    console.log($(allTabs[i]).attr('id'));
                    let tabname =$(allTabs[i]).attr('id');
                        if(tabname=='tab2')
                        {
                            if($('#tab2').hasClass('active')){
                                $('#nex-btn').attr('data-dis',false);
                                $('#prev-btn').attr('data-disabled',false);
                                $('.previous').removeClass('disabled');
                                $('.next').removeClass('disabled');
                            }
                        }
                        if(tabname=='tab3')
                        {
                            if($('#tab3').hasClass('active')){
                                $('#nex-btn').attr('data-dis',false);
                                $('#prev-btn').attr('data-disabled',false);
                                $('.previous').removeClass('disabled');
                                $('.next').removeClass('disabled');
                            }
                        }
                        if(tabname=='tab1')
                        {
                            if($('#tab1').hasClass('active')){
                                $('#nex-btn').attr('data-dis',false);
                                $('#prev-btn').attr('data-disabled',true);
                                $('.previous').addClass('disabled');
                                $('.next').removeClass('disabled');
                                return;
                            }
                        }
                    }
                    
                    }
            var prevLI =  $('.bootstrapWizard.form-wizard').find('li.active').prev();

            $('.bootstrapWizard.form-wizard').find('li.active').removeClass('active');

            $(prevLI).addClass('active');


            var prevForm = $('.tab-content').find('.tab-pane.active').prev();
            $('.tab-content').find('.tab-pane.active').removeClass('active');
            $(prevForm).addClass('active');
                }, 300);

            



        })




    </script>
 
<script>
var lResObj;
$(function() {
	$( "#tabs" ).tabs();});

$(document).ready(function(){
	getCategoryNames();
});
function getCategoryNames(){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('getCategoryNames')); ?>',
        data:{
            dtable:'no',
        },
        success:function(data) {
            var lResObj = data;
            var html = "";
			for(var i=0;i<lResObj.length;i++){
				html += "<option value='"+lResObj[i].id+"'>"+lResObj[i].name+"</option>";
			}
			$("#leavecategory").html(html);

			getEmployeeType();
        }
    });
}

function getEmployeeType(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getemployeetype')); ?>',
        data:{
            dtable:'no',
        },
        success:function(data) {
            var resObj = data;
            var html = "<option value=''></option>";
			for(var i=0;i<resObj.length;i++){
				html += "<option value='"+resObj[i].employee_type+"'>"+resObj[i].employee_type+"</option>";
			}
			$("#employee_type").html(html);
			getDesignation();
        }
    });
}
function getDesignation(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getemployeedesignation')); ?>',
        data:{
            dtable:'no',
        },
        success:function(data) {
            var resObj = data;
            var html = "<option value=''></option>";
			for(var i=0;i<resObj.length;i++){
				html += "<option value='"+resObj[i].designation+"'>"+resObj[i].designation+"</option>";
			}
			$("#designation").html(html);
			getPermission();
        }
    });
}

/// permission list starts ///
function getPermission(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getGroupPermissions')); ?>',
        data:{
            dtable:'no',
        },
        success:function(data) {
            var resObj = data;
            var html = "";
			html += '<select class="select form-control" name="permissionlist" id="permissionlist" >';
			html += '<option value="1" selected>Default</option>';
			for(var i = 0; i < resObj.length; i++){
				html += '<option value="'+resObj[i].id+'">'+resObj[i].permission+'</option>';
			}
			html += '</select>';
			$("#list_permission").html(html);
			getDepartment();
        }
    });
}
/// permission list ends ///

/// list department starts ///
function getDepartment(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getdepartmentList')); ?>',
        success:function(data) {
            var resObj = data;
            var html1 = "";
			html1 += '<option value="">Click to Choose one</option>';
			for(var i = 0; i < resObj.length; i++){
				html1 += '<option value="'+resObj[i].id+'">'+resObj[i].name+'</option>';
			}
			$("#department").html(html1);
			getCategory();
        }
    });
}
/// list department ends ///

/// list category starts ///
function getCategory(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getcategoryList')); ?>',
        success:function(data) {
            var resObj = data;
            var html2 = "";
			html2 += '<option value="">Click to Choose one</option>';
			for(var i = 0; i < resObj.length; i++){
				html2 += '<option value="'+resObj[i].id+'">'+resObj[i].name+'</option>';
			}
			$("#category").html(html2);
			getBranch();
        }
    });
}
/// list category ends ///

/// list branch starts ///
function getBranch(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('getbranchList')); ?>',
        success:function(data) {
            var resObj = data;
            var html3 = "";
			html3 += '<option value="">Click to Choose one</option>';
			for(var i = 0; i < resObj.length; i++){
				html3 += '<option value="'+resObj[i].id+'">'+resObj[i].name+'</option>';
			}
			$("#branch").html(html3);
			getApprover();
        }
    });
}
/// list branch ends ///

/// list approver starts ///
function getApprover(){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('getApprovers')); ?>',
        success:function(data) {
            var resObj = data;
            var html = "";
			html += '<option value="">Click to Choose one</option>';
			for(var i = 0; i < resObj.length; i++){
				html += '<option value="'+resObj[i].username+'">'+resObj[i].name+'</option>';
			}
			//$("#approver").html(html);
			html += '</select>';

			$("#list_approver1").html('<select class="select compulsory emp-required form-control" name="approver1" id="approver1" >'+html);
			$("#list_approver2").html('<select class="select form-control" name="approver2" id="approver2" >'+html);
			$("#list_approver3").html('<select class="select form-control" name="approver3" id="approver3" >'+html);
			$("#list_approver4").html('<select class="select form-control" name="approver4" id="approver4" >'+html);
			$("#list_approver5").html('<select class="select form-control" name="approver5" id="approver5" >'+html);

			getrestdaygroup();
        }
    });
}
/// list approver ends ///

/// list restdaygroup starts ///
function getrestdaygroup(){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('getRestDayCategories')); ?>',
        success:function(data) {
            var resObj = data;
            var html01 = "";
			html01 += '<option value="">Click to Choose one</option>';
			for(var i = 0; i < resObj.length; i++){
				html01 += '<option value="'+resObj[i].id+'">'+resObj[i].category +'</option>';
			}
			$("#groupselname").html(html01);
			getState();
        }
    });
}
/// list restdaygroup ends ///

function getState(){
	var country = $("#nationality").val();

    $.ajax({
        type:'get',
        url:'<?php echo e(route('getStateByCountry')); ?>',
        data:{ country: country, },
        success:function(data) {
                var result_data = data;
				var html = "";
				for(var i=0;i<result_data.length;i++){
					html += "<option value='"+result_data[i].state+"'>"+result_data[i].state+"</option>";
				}
				$("#state").html(html);
        }
    });
}


var $validator = $("#wizard-1").validate({

			    rules: {
			      employeeno: {
			        required: true
			      },
			      employeecode: {
			        required: false
			      },
				  employeename: {
					required:false
				  },
			      icno_new: {
			        required: true
			      },
			      email: {
			        required: false,
					email: "Your email address must be in the format of name@domain.com"
			      },
			      branch: {
			        required: true
			      },
			      department: {
			        required: true
			      },
			      category: {
			        required: true
			      },
			      commence: {
			        required: true
			      },
				  icno_new:{
					required: true
				  },
			    },

			    messages: {
				  employeeno:"Employee number required",
			      employeecode: "Employee code required",
				  employeename:"Employee Name required",
			      icno_new: "I/C No. (New) required",
				  branch:"Branch required",
				  department:"Department required",
				  category:"Category required",
				  commence:"Date Commence required",
			      email: {
			        required: "Email address required",
			        email: "Your email address must be in the format of name@domain.com"
			      }
			    },

			    highlight: function (element) {
			      $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
			    },
			    unhighlight: function (element) {
			      $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			    },
			    errorElement: 'span',
			    errorClass: 'help-block',
			    errorPlacement: function (error, element) {
			      if (element.parent('.input-group').length) {
			        error.insertAfter(element.parent());
			      } else {
			        error.insertAfter(element);
			      }
			    }
			  });

function add_user(){
	if(validate()){

        $.ajax({
            type:'get',
            url:'<?php echo e(route('registerUser_1')); ?>',
            data:{
                _token: '<?=csrf_token()?>',
                employee_no: $("#employeeno").val(),
                employee_code: $("#employeecode").val(),
                username: $("#icno_new").val(),
                name: $("#employeename").val(),
                address: $("#address").val(),
                postal_code: $("#postcode").val(),
                town: $("#town").val(),
                nationality: $("#nationality").val(),
                state: $("#state").val(),
                phone_no: $("#phoneno").val(),
                dob: $("#dob").val(),
                highest_education: $("#education").val(),
                working_experience: $("#experience").val(),
                ic_no_old: $("#icno_old").val(),
                ic_no_new: $("#icno_new").val(),
                ic_color: $("#ic_color").val(),
                passport_no: $("#passportno").val(),
                sex: $("#sex").val(),
                employee_type: $("#employee_type").val(),
                designation: $("#designation").val(),
                race: $("#race").val(),
                bumiputra: $("#bumiputra").val(),
                marital_status: $("#maritalstatus").val(),
                email_id: $("#email").val(),
                blood_group: $("#blood_group").val(),
                spouse_name: $("#spousename").val(),
                spouse_ic_no: $("#spic_no").val(),
                no_children: $("#childern").val(),
                spouse_working: $("#spouseworking").val(),
                address_name: $("#name").val(),
                address_address: $("#paddress").val(),
                address_phone_no: $("#phno").val(),
            },
            success:function(data) {
                console.log(data);
                    var user = "";
                    var resObj = data;
                    var messege = resObj;
                    if(messege ==  true){
                        mapPermission();
                    }else if(messege == 'dup_ic_no'){
                        showError("I/C No.(New) Already Exist.");
                    }else if(messege == 'dup_emp_no'){
                        showError("Employee No Already Exist.");
                    }else if(messege == 'duplicate'){
                        showError("Employee Already Exist.");
                    }
                    else{
                        showError("Error Occured");
                    }
            }
        });
    }
}

<!--/// map permission starts ///-->
function mapPermission(){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('mapEmployeePermission')); ?>',
        data:{
            employee_ids: $("#icno_new").val() ,
		    permission_group_id: $("#permissionlist").val(),
         },
        success:function(data) {
            var resObj = data;
			var messege = resObj;
			if(messege ==  true)
				add_user2();
			else
				showError("Error Occured");
        }
    });
}
/// map permission ends ///

function validate(){
	var employeeno = $("#employeeno").val();
	var employeename = $("#employeename").val();
	var phoneno = $("#phoneno").val();
	var icno_new = $("#icno_new").val();
        var branch = $("#branch").val();
        var department = $("#department").val();
        var category = $("#category").val();
        var approver1 = $("#approver1").val();
        var commence = $("#commence").val();


	if(employeeno == ""){
			var htm='<div class="alert alert-danger fade in" ><button class="close"   data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
			return false;
	}
	else if(icno_new == ""){
            var htm='<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
			return false;
	}
	else if(branch == ""){
            var htm='<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
			return false;
	}else if(department == ""){
            var htm='<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
			return false;
	}else if(category == ""){
            var htm='<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
			return false;
	}
	else if(commence == ""){
			var htm='<div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button>Some mandatory fields are empty.</div>';
			showError(htm);
			displayred();
		return false;
	}
	else if(approver1 == ""){
		$('#list_approver1').after( "<p style='color:red;margin:-10px 0 0 0;'>Approver Mapping 1 is required</p>" );
		showError("Some mandatory fields are empty");
		//alert('Approve 1');
		displayred();
		return false;
	}
	else
		return true;
}
function displayred(){
	$(".red").css("display", "inline");
}


/// check username starts ///
function checkempno(employeeno){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('employeeNoAvailable')); ?>',
        data:{
            employee_no: employeeno,
         },
        success:function(data) {
            var resObj = data;
			var messege = resObj;
			if(messege ==  false)
				showError1("Employee number is taken.");
			else
				showMessage1("Employee number is valid.");
        }
    });
}

function showMessage1(message){
	$("#message1").html("<span style='color:green;'>" + message + "</span>");
}

function showError1(message){
	$("#message1").html("<span style='color:red;'>" + message + "</span>");
}
/// check username ends /// -->

/// check ic no: starts /// -->
function checkicnew(icno_new){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('usernameAvailable')); ?>',
        data:{
            username: icno_new,
         },
        success:function(data) {
            var resObj = data;
            var messege = resObj;
            console.log(messege);
			if(messege ==  false)
				showError2("IC No: already taken.");
			else
				showMessage2("IC No: valid.");
        }
    });
}

function showMessage2(message){
	$("#message2").html("<span style='color:green;'>" + message + "</span>");
}

function showError2(message){
	$("#message2").html("<span style='color:red;'>" + message + "</span>");
}
 /// check ic no: ends /// -->



function add_user2(){
	if(validate2()){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('registerUser_2')); ?>',
        data:{
            _token: '<?=csrf_token()?>',
            username: $("#icno_new").val(),
            job_title: $("#jobtitle").val(),
            branch_id: $("#branch").val(),
            department_id: $("#department").val(),
            category_id: $("#category").val(),
            date_commence: $("#commence").val(),
            date_prompted: $("#promoted").val(),
            date_resigned: $("#resigned").val(),
            date_confirmed: $("#confirmed").val(),
            pay_rate_type: $("#paytype").val(),
            pay_method: $("#paymethod").val(),
            pay_status: $("#paystatus").val(),
            contract: $("#contract").val(),
         },
        success:function(data) {
            var resObj = data;
			var messege = resObj;
			if(messege ==  true)
			add_user3();
		    else
			showError("Error Occured");
        }
    });
}}
function validate2(){
	var branch = $("#branch").val();
	if(branch == ""){
		displayred();
		return false;
	}
	else if(commence == ""){
		displayred();
		return false;
	}
	else
		return true;
}

function add_user3(){

    $.ajax({
        type:'get',
        url:'<?php echo e(route('registerUser_3')); ?>',
        data:{

        _token: '<?=csrf_token()?>',
        username: $("#icno_new").val(),

		bank_code: $("#bankcode").val(),
		branch_code: $("#branchcode").val(),
		bank_ac_no: $("#acno").val(),
		gov_category: $("#govcategory").val(),
		payment_mode: $("#paymentmode").val(),

		socso_no: $("#socso_no").val(),
		socso_ic: $("#socsoic").val(),
		ins_table: $("#table").val(),
		ins_category: $("#inscategory").val(),
		socso_initial: $("#socso_initial").val(),

		epf_no: $("#epfno").val(),
		epf_ic: $("#epfic").val(),
		epf_table: $("#epftable").val(),
		epf_category: $("#epfcategory").val(),
		epf_yee_formula: $("#epfyee").val(),
		epf_yer_formula: $("#epfyer").val(),

		tax_no: $("#taxno").val(),
		branch: $("#taxbranch").val(),
		tax_category: $("#taxcategory").val(),
         },
        success:function(data) {
            var resObj = data;
			var messege = resObj;
			if(messege ==  true)
			addRestday();
		else
			showError("Error Occured");
        }
    });
}

/// add rest day starts ///-->
function addRestday(){
    $.ajax({
        type:'get',
        url:'<?php echo e(route('mapCategoryEmployee')); ?>',
        data:{
            employee_ids: $("#icno_new").val(),
		    category_id: $("#groupselname").val(),
         },
        success:function(data) {
            var resObj = data;
			var messege = resObj;
			if(messege ==  true)
				mapApprover();
			else
				showError("Error Occured");
        }
    });
}
/// add rest day ends ///-->
/// map approver starts ///-->
function mapApprover(){

	var _arr = new Array();
	var _index_arr = new Array();
	if($("#approver1").val()!=''){
		//_arr.push($("#approver1").val());
		_arr[0] = $("#approver1").val();
		_index_arr[0] = '1';
	}
	if($("#approver2").val()!=''){
		//_arr.push($("#approver2").val());
		_arr[1] = $("#approver2").val();
		_index_arr[1] = '2';
	}
	if($("#approver3").val()!=''){
		//_arr.push($("#approver3").val());
		_arr[2] = $("#approver3").val();
		_index_arr[2] = '3';
	}
	if($("#approver4").val()!=''){
		//_arr.push($("#approver4").val());
		_arr[3] = $("#approver4").val();
		_index_arr[3] = '4';
	}
	if($("#approver5").val()!=''){
		//_arr.push($("#approver5").val());
		_arr[4] = $("#approver5").val();
		_index_arr[4] = '5';
	}

        if(_arr.length>0){
            for(var i = 0; i < _arr.length; i++){

                $.ajax({
                    type:'get',
                    url:'<?php echo e(route('mapEmplyoyee')); ?>',
                    data:{
                        employee_id: $("#icno_new").val(),
						approver_id: _arr[i],
						approver_index: _index_arr[i],
                    },
                    success:function(data) {
                        var resObj = data;
                        var messege = resObj;
                        if(messege ==  true)
							mapCategory();
						else
							showError("Error Occured");
                    }
                });
            }
        }else{
            mapCategory();
        }

}
/// map approver ends ///-->

/// map category starts ///-->
function mapCategory(){

    $.ajax({
                    type:'get',
                    url:'<?php echo e(route('registerUser_4')); ?>',
                    data:{
                        _token: '<?=csrf_token()?>',
                        username: $("#icno_new").val(),

		                category: $("#leavecategory").val(),
                    },
                    success:function(data) {
                        var resObj = data;
                        var messege = resObj;
                        if(messege ==  true){
                            var msg='<div class="alert alert-success fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i><strong>Success</strong> Employee is added successfully.</div>';
                            showMessage(msg);
                            setInterval(redirect,2000);
                        }
                        else
                            showError("Error Occured");
                    }
                });
}
function link(){
	window.location.reload();
}
/// map category ends ///-->
function redirect(){
	window.location.reload();
}
function showMessage(message){
	$("#message").html("<span style='color:green;'>" + message + "</span>");
}

function showError(message){
	$("#message").html("<span style='color:red;'></br>" + message + "</span>");
}


$(document).ready(function() {

			$('#bootstrap-wizard-1').bootstrapWizard({
			    'tabClass': 'form-wizard',
			    'onNext': function (tab, navigation, index) {
			      var $valid = $("#wizard-1").valid();
			      if (!$valid) {
			        $validator.focusInvalid();
			        return false;
			      } else {
			        $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1).addClass(
			          'complete');
			        $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1).find('.step')
			        .html('<i class="fa fa-check"></i>');
			      }
			    }
			  });
			  var wizard = $('.wizard').wizard();

			  wizard.on('finished', function (e, data) {
			    $.smallBox({
			      title: "Congratulations! Your form was submitted",
			      content: "<i class='fa fa-clock-o'></i> <i>1 seconds ago...</i>",
			      color: "#5F895F",
			      iconSmall: "fa fa-check bounce animated",
			      timeout: 4000
			    });

			  });


        })

        $(document).ready(function () {
    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });

    $(".next-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);

    });
});

function nextTab(elem) {
    $(elem).next().find('a[data-toggle="tab"]').click();
}
function prevTab(elem) {
    $(elem).prev().find('a[data-toggle="tab"]').click();
}

</script>

<?php /**PATH /home/ecoleave/public_html/v4/agbb/resources/views/hr/setup/add_employee.blade.php ENDPATH**/ ?>