    <?php echo e(View::make('layout.header')); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">My Leaves</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                    <div class="form-group breadcrumb-right">
                        <a href="#" class="btn btn-primary btn-block waves-effect waves-float waves-light" data-toggle="modal" data-target="#add-payment-sidebar">Apply For Leave</a>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-lg-12 col-12">
                            <div class="card card-user-timeline">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        
                                        <h4 class="card-title"> My Leaves Annual Quota</h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row avg-sessions pt-50">
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Annual</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Medical</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-danger" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Marriage</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-warning" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Compassionate</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-success" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div> 
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Annual</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-info" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Medical</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-danger" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Marriage</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-warning" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div>
                                        <div class="col-4 mb-2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                     <p class="mb-50">Compassionate</p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p class="mb-50">05/10 Remaining</p>
                                                </div>
                                            </div>
                                            <div class="progress progress-bar-success" style="height: 6px">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="50" aria-valuemin="50" aria-valuemax="100" style="width: 50%"></div>
                                            </div>
                                        </div> 

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/ Medal Card -->
                    </div>

                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">My Leaves</h4>
                                            <div class="d-flex align-items-center">
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        All Leave Types  
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> |
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Jan 2021 
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> To
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Dec 2021
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>TYPE</th>
                                                <th>RELIEVE</th>
                                                <th>LEAVE DATE</th>
                                                <th>LEAVE REASON</th>
                                                <th width="20%">STATUS</th>
                                                <th>ACTION</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <?php
                                                    $r_name = '';
                                                    if($leave->relieve != '')
                                                    {
                                                        $employee = Illuminate\Support\Facades\DB::table('user_personal')
                                                        ->where('username', $leave->relieve)->first();
                                                        $r_name = $employee->name;
                                                    }

                                                    $status = '';
                                                    $class= '';

                                                    if($leave->status == 0)
                                                    {
                                                        $status = 'Pending';
                                                        $class= 'grey';
                                                    }
                                                    elseif($leave->status == 1)
                                                    {
                                                        $status = 'Approved';
                                                        $class= 'green';
                                                    }
                                                    elseif($leave->status == 2)
                                                    {
                                                        $status = 'Rejected';
                                                        $class= 'red';
                                                    }
                                                    elseif($leave->status == 3)
                                                    {
                                                        $status = 'Recommended';
                                                        $class= 'blue';
                                                    }
                                                    elseif($leave->status == 4)
                                                    {
                                                        $status = 'Cancelled';
                                                        $class= 'yellow';
                                                    }
                                                    elseif($leave->status == 5)
                                                    {
                                                        $status = 'Cancellation Pending';
                                                        $class= 'orange';
                                                    }
                                                    
                                                ?>
                                                <td><?php echo e($leave->type); ?></td>
                                                <td><?php echo e($r_name); ?></td>
                                                 <td><?php echo e($leave->start_date); ?></td>
                                                <td><?php echo e($leave->reason); ?></td>
                                                <td style="background-color:<?php echo e($class); ?>;color:black;"><?php echo e($status); ?></td>
                                                <td><button type="button" class="btn btn-outline-dark waves-effect">Cancel</button></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div style="float: right;">
                                        <?php echo e($leaves->links('pagination::bootstrap-4')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">Leave Summary</h4>
                                            <div class="d-flex align-items-center">
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        All Leave Types  
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> |
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Jan 2021 
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> To
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Dec 2021
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>TYPE</th>
                                                <th>BF</th>
                                                <th>BF ADJ</th>
                                                <th>ENTITLE</th>
                                                <th>EARN</th>
                                                <th>CLAIMABLE</th>
                                                <th>NPL</th>
                                                <th>TAKEN</th>
                                                <th>FORFEIT</th>
                                                <th>BALANCE</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                          <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div style="float: right;">
                                        <nav aria-label="Page navigation example">
                                            <ul class="pagination mt-2">
                                              <li class="page-item prev-item"><a class="page-link" href="javascript:void(0);"></a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">3</a></li>
                                              <li class="page-item active" aria-current="page">
                                                <a class="page-link" href="javascript:void(0);">4</a>
                                              </li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">5</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">6</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">7</a></li>
                                              <li class="page-item next-item"><a class="page-link" href="javascript:void(0);"></a></li>
                                            </ul>
                                          </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Ecommerce ends -->
                <div class="modal modal-slide-in fade" id="add-payment-sidebar" aria-hidden="true">
                    <div class="modal-dialog sidebar-lg">
                        <div class="modal-content p-0">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">×</button>
                            <div class="modal-header mb-1">
                                <h5 class="modal-title">
                                    <span class="align-middle">Apply Leave</span>
                                </h5>
                            </div>
                            <div class="modal-body flex-grow-1">
                            <form id="leave-form">
                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                <input type="hidden" name="user_id" value="<?php echo e(Auth::guard('user')->id()); ?>">
                                    <div class="form-group">
                                        <label class="form-label" for="payment-date">Leave Type  :</label>
                                        <select class="form-control" id="basicSelect" name="leave_type">
                                            <option value="">select</option>
                                            <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($type->name); ?>"><?php echo e($type->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="type-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="payment-note">Half Day / Full Day  : </label>
                                        <div class="demo-inline-spacing">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="hideenddate()" name="hof" id="inlineRadio1" value="1" />
                                                <label class="form-check-label" for="inlineRadio1">Half Day</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" onclick="showenddate()" name="hof" id="inlineRadio2" value="0" />
                                                <label class="form-check-label" for="inlineRadio2">Full Day</label>
                                            </div>
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="day-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label>Leave start Date</label>
                                        <input type="text" name="leave_start_date" class="form-control" id="datepicker1" placeholder="Leave Start Date" autocomplete="off">
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="start-date-error"></span>
                                    </div>
                                    <div id="end_date">
                                        <label>Leave End Date</label>
                                        <div class="form-group">
                                            <input type="text" name="leave_end_date" class="form-control" id="datepicker2" placeholder="Leave End Date"  autocomplete="off" >
                                        </div>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="end-date-error"></span>
                                    </div>
                                    <div class="form-group">
                                        <label>Reason</label>
                                        <textarea class="form-control" name="reason" placeholder="Type here"></textarea>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="reason-error"></span>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Relieve</label>
                                        <select class="form-control" name="relieve">
                                            <option value="">Select Relieve</option>
                                            <?php $__currentLoopData = $relieves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relieve): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($relieve->name); ?>"><?php echo e($relieve->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <span style="font-size: 14px; font-style: italic;color: #dc3545!important;" id="relive-error"></span>
                                    </div>
                                    <div class="form-group d-flex flex-wrap mb-0">
                                        <button type="button" onclick="saveDetails()" class="btn btn-primary mr-1">Send</button>
                                        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    <?php echo e(View::make('layout.footer')); ?>

    <script type="text/javascript">
        function showenddate() {
            document.getElementById('end_date').style.display='block';
        }
        function hideenddate() {
            document.getElementById('end_date').style.display='none';
        }

        function saveDetails(e){
            var leaveForm = $("#leave-form");
            var data = leaveForm.serialize();
            $( '#type-error' ).html('');
            $( '#day-error' ).html('');
            $( '#start-date-error' ).html('');
            $( '#end-date-error' ).html('');
            $( '#relive-error' ).html('');
            $( '#reason-error' ).html('');
            $.ajax({
                url:'<?php echo e(route('myleave-apply')); ?>',
                type:'POST',
                data:data,
                success:function(e){
                    
                },
                error:function(w){
                    if(w.responseJSON.errors)
                    {
                        if(w.responseJSON.errors.leave_type){
                            $( '#type-error' ).html( w.responseJSON.errors.leave_type[0] );
                        }
                        if(w.responseJSON.errors.hof){
                            $( '#day-error' ).html( w.responseJSON.errors.hof[0] );
                        }
                        if(w.responseJSON.errors.leave_start_date){
                            $( '#start-date-error' ).html( w.responseJSON.errors.leave_start_date[0] );
                        }
                        if(w.responseJSON.errors.leave_end_date){
                            $( '#end-date-error' ).html( w.responseJSON.errors.leave_end_date[0] );
                        }
                        if(w.responseJSON.errors.reason){
                            $( '#reason-error' ).html( w.responseJSON.errors.reason[0] );
                        }
                        if(w.responseJSON.errors.relieve){
                            $( '#relive-error' ).html( w.responseJSON.errors.relieve[0] );
                        }

                    }
                }
            });
            

        };
    </script><?php /**PATH C:\xampp\htdocs\ECL\resources\views/E-Leave/my-leaves.blade.php ENDPATH**/ ?>