<?php echo e(View::make('layout.header')); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">HR
                                    </li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('setup')); ?>">Setup</a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('holidays-list')); ?>">Holidays</a>
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Add Holiday</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title" >Add New Holiday</h4>
                                </div>
                               
                                <div class="card-body">
                                    <form  id="all-filter11"  enctype="multipart/form-data">
                                        <div class="row" id="leave">
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="payment-date">Date :</label>
                                                    <input type="date" name="holiday_date"  id="holiday_date" required class="form-control flatpickr-basic" placeholder="DD-MM-YYYY" >
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="payment-date">Holiday Description :</label>
                                                    <input type="text" name="description"  id="description" required class="form-control" placeholder="" >
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="payment-date">Select Country :</label>
                                                    <select class="form-control" id="country" name="country" onchange="statefilter()">
                                                        <option value="">Select Country</option>
                                                        
                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($countries->country_code); ?>"><?php echo e($countries->country); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <div class="form-group">
                                                    <label class="form-label" for="payment-date">Select State :</label>
                                                    <select class="form-control" id="state" name="state[]" required multiple style="height:300px;">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <div class="form-group d-flex flex-wrap mb-0">
                                                    <button type="button"  onclick="saveDetails()" class="btn btn-info">Apply</button>
                                                </div>
                                                <div id="msg" style="margin-top:15px;"></div>
                                            </div>      
                                        </div> 
                                    </form>     
                                </div>
                            </div>    
                        </div>
                    </div>
                </section>    
            </div>
        </div>
    </div>
    <!-- END: Content-->
    <?php echo e(View::make('layout.footer')); ?>

    <script>
    function statefilter() { 
        var country = $('#country').val();
        $.ajax({
            url: "filtercountry",
            method: "get",
            data: { country: country},
            success: function (data) {
                if(data){
                    $("#state").empty();
                    $("#state").append('<option value="National">All</option>');
                    $.each(data,function(key,value){
                        $("#state").append('<option value="'+value.state+'">'+value.state+'</option>');
                    });
            
                }else{
                    $("#state").empty();
                     $("#state").append('<option value="">Select State</option>');
                     $("#state").append('<option value="National">All</option>');
                   
                }
            }
            

        });
           
                
    }

    function saveDetails(){
        var opstates = $("#state").val();
        if(opstates=="National"){
            //opstates = "";
        if(validate()){
            
            $.ajax({
                        url:'<?php echo e(route('addHoliday')); ?>',
                        method:'POST',
                        data:{
                            _token : '<?=csrf_token()?>',
                            country: $("#country").val(),
                            date: $("#holiday_date").val(),
                            description: $("#description").val(),
                            state: opstates,
                        },
                        success:function(resObj){
                            var messege = resObj.result;
                            if(messege ==  0){
                                showError("Holiday already taken");
                            }	
                            else if(messege ==  1){
                                showMessage("Holiday added successfully");
                                setInterval(window.location.href = "<?php echo e(route('holidays-list')); ?>" ,1200);
                                clear_form('#leave');
                            }	
                            else
                                showError("No Branch for selected State");
                            
                        }
                    });
        }	}
        else{	
            var options = document.getElementById("state").options;
            for(var i = 0; i < options.length; i++){
                if(options[i].selected){
                if(validate()){
                    
                    $.ajax({
                        url:'<?php echo e(route('addHoliday')); ?>',
                        method:'POST',
                        data:{
                            _token : '<?=csrf_token()?>',
                            country: $("#country").val(),
                            date: $("#holiday_date").val(),
                            description: $("#description").val(),
                            state: options[i].value,
                        },
                        success:function(resObj){
                            var messege = resObj.result;
                            if(messege ==  0){
                                showError("Holiday already taken");
                            }	
                            else if(messege ==  1){
                                showMessage("Holiday added successfully");
                                setInterval(window.location.href = "<?php echo e(route('holidays-list')); ?>" ,1200);
                                clear_form('#leave');
                            }
                            else
                                showError("No Branch for selected State");
                            
                        }
                    });
                }
            }
        }}
    }

    function validate(){
        var vstate = $("#state").val();
        var vdate = $("#holiday_date").val();
        var vdescription = $("#description").val();
        if(vstate == ""){
            displayred();
            return false;
        }
        else if(vdate == ""){
            displayred();
            return false;
        }
        else if(vdescription == ""){
            displayred();
            return false;
        }
        else
            return true;
    }
    function displayred(){
        $(".red").css("display", "inline");
    }
    function showMessage(message){
        $("#msg").html("<span style='color:green;'>" + message + "</span>");
    }

    function showError(message){
        $("#msg").html("<span style='color:red;'>" + message + "</span>");
    }

    function clear_form(ele) {
        $(ele).find(':input').each(function(){
            switch(this.type) {
                case 'password':
                case 'select-multiple':
                case 'select-one':
                case 'text':
                case 'textarea':
                    $(this).val('');
                    break;
                case 'checkbox':
                case 'radio':
                    this.checked = false;
               
            }
        });
       
    }
    
    </script><?php /**PATH /home/ecoleave/public_html/v4/agbb/resources/views/hr/add_holiday.blade.php ENDPATH**/ ?>